/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : ctapi.h
            Author : David Corcoran
            Date   : 02/22/03
            License: See file LICENSE
            Purpose: This is the header file for the CT-API.
 
********************************************************************/
 
#ifndef __ctapi_h__
#define __ctapi_h__
 
#ifdef __cplusplus
extern "C"
{
#endif


#define         OK                   0x00
#define         ERR_INVALID          -1
#define         ERR_CT               -8
#define         ERR_TRANS            -10
#define         ERR_MEMORY           -11
#define         ERR_HOST             -127
#define         ERR_HTSI             -128

  /********* CT-BCS Part IV status words **********/

  /* Reset of CT */
#define         CTBCS_CT_OK_RESET    0x9000
#define         CTBCS_CT_ERR_RESET   0x6400

  /* Reset of ICC 1 */
#define         CTBCS_ICCS_OK_RESET   0x9000
#define         CTBCS_ICCA_OK_RESET   0x9001
#define         CTBCS_ICC_ERR_RESET   0x6400


  /* Card terminal (CT) general error codes */
#define         CTBCS_CT_ERR_REMOVED    0x64A1
#define         CTBCS_CT_ERR_INACTIVE   0x64A2
#define         CTBCS_CT_ERR_LENGTH     0x6700
#define         CTBCS_CT_ERR_UNALLOWED  0x6900
#define         CTBCS_CT_ERR_PARAMS     0x6A00 
#define         CTBCS_CT_ERR_LE         0x6C00
#define         CTBCS_CT_ERR_INS        0x6D00
#define         CTBCS_CT_ERR_CLA        0x6E00
#define         CTBCS_CT_ERR_COMM       0x6F00

  /************ CT-BCS Part VII status words **********/
#define         CTBCS_ICC_SUCCESS       0x9000
#define         CTBCS_ICC_ERR_NOFILE    0x6A82
#define         CTBCS_ICC_ERR_CORRUPT   0x6281
#define         CTBCS_ICC_ERR_EOF       0x6282
#define         CTBCS_ICC_ERR_MEM       0x6501

#define         CTBCS_ICC_ERR_VERIFY    0X6300
#define         CTBCS_ICC_ERR_BLOCKED   0X6983



extern char 
      		CT_init (
                	unsigned short Ctn, 
                  	unsigned short Pn
                 	);			        

extern char CT_close (
			unsigned short Ctn
		     );

extern char 
   CT_data (
			unsigned short  Ctn,
           		unsigned char   *Dad,
            		unsigned char   *Sad,
            		unsigned short   Lc,
            		unsigned char   *Cmd,
            		unsigned short  *Lr,
            		unsigned char   *Rsp
           );
            
#ifdef __cplusplus
}
#endif

#endif


