# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function


__metaclass__ = type

from ansible_collections.junipernetworks.junos.plugins.modules import junos_ospf_interfaces
from ansible_collections.junipernetworks.junos.tests.unit.compat.mock import MagicMock, patch
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import set_module_args

from .junos_module import TestJunosModule, load_fixture


class TestJunosOspfv3Module(TestJunosModule):
    module = junos_ospf_interfaces

    def setUp(self):
        super(TestJunosOspfv3Module, self).setUp()
        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration",
        )
        self.lock_configuration = self.mock_lock_configuration.start()
        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration",
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()
        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.ospf_interfaces.ospf_interfaces.load_config",
        )
        self.load_config = self.mock_load_config.start()

        self.mock_validate_config = patch(
            "ansible_collections.ansible.netcommon.plugins.module_utils.network.common.utils.validate_config",
        )
        self.validate_config = self.mock_validate_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.ospf_interfaces.ospf_interfaces.commit_configuration",
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_get_connection = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.ospf_interfaces.ospf_interfaces."
            "Ospf_interfacesFacts.get_connection",
        )
        self.get_connection = self.mock_get_connection.start()

        self.conn = self.get_connection()
        self.conn.get = MagicMock()

        self.mock_get_xml_dict = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts."
            "ospf_interfaces.ospf_interfaces.Ospf_interfacesFacts._get_xml_dict",
        )
        self._get_xml_dict = self.mock_get_xml_dict.start()

    def tearDown(self):
        super(TestJunosOspfv3Module, self).tearDown()
        self.mock_get_connection.stop()
        self.mock_load_config.stop()
        self.mock_validate_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()

    def load_fixtures(self, commands=None, format="text", changed=False):
        self.get_connection.return_value = load_fixture(
            "junos_ospf_interfaces_config.cfg",
        )
        if changed:
            self.load_config.return_value = load_fixture(
                "get_configuration_rpc_reply_diff.txt",
            )
        else:
            self.load_config.return_value = None

    def test_junos_ospf_interfaces_merged(self):
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.75",
                        name="ge-0/0/2.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.2"),
                                    priority=3,
                                    metric=5,
                                ),
                            ),
                        ],
                    ),
                ],
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:ospf>'
            "<nc:area><nc:name>0.0.0.2</nc:name><nc:interface><nc:name>ge-0/0/2.0</nc:name>"
            "<nc:priority>3</nc:priority><nc:metric>5</nc:metric></nc:interface></nc:area></nc:ospf></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:router-id>10.200.16.75</nc:router-id></nc:routing-options>",
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_ospf_interfaces_merged_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_ospf_interfaces_config.cfg",
        )
        src = load_fixture("junos_ospf_interfaces.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.77",
                        name="so-0/0/0.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.10"),
                                    priority=3,
                                    metric=5,
                                ),
                            ),
                        ],
                    ),
                ],
                state="merged",
            ),
        )
        self.execute_module(changed=False, commands=[])

    def test_junos_ospf_interfaces_replaced(self):
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.75",
                        name="ge-0/0/2.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.1"),
                                    priority=6,
                                    metric=7,
                                ),
                            ),
                        ],
                    ),
                ],
                state="replaced",
            ),
        )
        result = self.execute_module(changed=True)
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:ospf/><nc:ospf>'
            "<nc:area><nc:name>0.0.0.1</nc:name><nc:interface><nc:name>ge-0/0/2.0</nc:name>"
            "<nc:priority>6</nc:priority><nc:metric>7</nc:metric></nc:interface></nc:area></nc:ospf></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:router-id>10.200.16.75</nc:router-id></nc:routing-options>",
        ]
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_ospf_interfaces_replaced_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_ospf_interfaces_config.cfg",
        )
        src = load_fixture("junos_ospf_interfaces.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.75",
                        name="ge-0/0/2.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.1"),
                                    priority=6,
                                    metric=7,
                                ),
                            ),
                        ],
                    ),
                ],
                state="replaced",
            ),
        )

        self.execute_module(changed=False, commands=[])

    def test_junos_ospf_interfaces_overridden(self):
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.75",
                        name="ge-0/0/2.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.1"),
                                    priority=6,
                                    metric=7,
                                ),
                            ),
                        ],
                    ),
                ],
                state="overridden",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:ospf/><nc:ospf>'
            "<nc:area><nc:name>0.0.0.1</nc:name><nc:interface><nc:name>ge-0/0/2.0</nc:name>"
            "<nc:priority>6</nc:priority><nc:metric>7</nc:metric></nc:interface></nc:area></nc:ospf></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:router-id>10.200.16.75</nc:router-id></nc:routing-options>",
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_ospf_interfaces_overridden_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_ospf_interfaces_config.cfg",
        )
        src = load_fixture("junos_ospf_interfaces.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.75",
                        name="ge-0/0/2.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.1"),
                                    priority=6,
                                    metric=7,
                                ),
                            ),
                        ],
                    ),
                ],
                state="overridden",
            ),
        )

        self.execute_module(changed=False, commands=[])

    def test_junos_ospf_interfaces_delete(self):
        self.get_connection.return_value = load_fixture(
            "junos_ospf_interfaces_config.cfg",
        )
        src = load_fixture("junos_ospf_interfaces.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=[dict(router_id="10.200.16.75", name="ge-0/0/2.0")],
                state="deleted",
            ),
        )

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:ospf/></nc:protocols>',
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]

        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_ospf_interfaces_delete_idempotent(self):
        set_module_args(
            dict(
                config=[dict(router_id="10.200.16.75", name="ge-0/0/2.0")],
                state="deleted",
            ),
        )
        self.execute_module(changed=False, commands=[])

    def test_junos_ospf_interfaces_rendered(self):
        set_module_args(
            dict(
                config=[
                    dict(
                        router_id="10.200.16.75",
                        name="ge-0/0/2.0",
                        address_family=[
                            dict(
                                afi="ipv4",
                                processes=dict(
                                    area=dict(area_id="0.0.0.1"),
                                    priority=6,
                                    metric=7,
                                ),
                            ),
                        ],
                    ),
                ],
                state="rendered",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:ospf/><nc:ospf>'
            "<nc:area><nc:name>0.0.0.1</nc:name><nc:interface><nc:name>ge-0/0/2.0</nc:name>"
            "<nc:priority>6</nc:priority><nc:metric>7</nc:metric></nc:interface></nc:area></nc:ospf></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:router-id>10.200.16.75</nc:router-id></nc:routing-options>",
        ]
        self.execute_module(changed=False, commands=commands)
