/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:15:39 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JProgressBar;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.alignment.BamUtils;
import uk.ac.sanger.artemis.components.alignment.BamView;
import uk.ac.sanger.artemis.components.alignment.CRAMReferenceSequenceFile;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BamUtils_ESTest extends BamUtils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      String string0 = BamUtils.constructIndexFilename((String) null);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/ j)vDl3?");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "Failed to find an index file for remote alignment file: ");
      try { 
        BamUtils.getIndexFile(" j)vDl3?");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // 
         // An index file could not be created.
         // The BAM/CRAM file needs to be accessible, sorted and indexed.
         // Indexing and sorting can be done using samtools (http://www.htslib.org). For example: 
         // 
         // samtools sort <in.bam> -o <sorted.bam>
         // samtools index <sorted.bam>
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      boolean boolean0 = BamUtils.isCramFile((String) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      boolean boolean0 = BamUtils.isBamFile("Stop Codons In Translation ...");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/64|[O79K;aP4?837b.crai");
      FileSystemHandling.createFolder(evoSuiteFile0);
      File file0 = BamUtils.getIndexFile("64|[O79K;aP4?837b");
      assertTrue(file0.exists());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.validateSAMFile((SamReader) null, (CRAMReferenceSequenceFile) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("htsjdk.samtools.SamFileValidator", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/_");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "ile.");
      // Undeclared exception!
      try { 
        BamUtils.getIndexFile("_");
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class htsjdk.samtools.SAMFileHeader
         //
         verifyException("htsjdk.samtools.SAMTextHeaderCodec", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.getFeatureLength((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.getCount((BamView) null, 0, 0, (String) null, false, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.createTempIndexFile((URL) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL("Show paired reads with SNPs", "Show paired reads with SNPs.bai", 331, "k", uRLStreamHandler0);
      // Undeclared exception!
      try { 
        BamUtils.createTempIndexFile(uRL0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Prefix string too short
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.createIndexFileFromScratch("Filled", (File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.countOverRange((BamView) null, "LYfuf?$", 10485760, 2450, 120000, (int[][]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.count((BamView) null, "", 1, 1, true, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      int[] intArray0 = new int[9];
      // Undeclared exception!
      try { 
        BamUtils.calculateMappedReads((BamView) null, (FeatureVector) null, true, false, false, intArray0, (JProgressBar) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.calc((BamView) null, "lowrite", (-69), false, (JProgressBar) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockFile mockFile0 = new MockFile("_tD`_&");
      try { 
        BamUtils.createIndexFileFromScratch("_tD`_&", mockFile0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockRandomAccessFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      MockFile mockFile0 = new MockFile("H>l)`S&HQ6?tY-<c\"1");
      // Undeclared exception!
      try { 
        BamUtils.createIndexFileFromScratch("H>l)`S&HQ6?tY-<c\"1", mockFile0);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // java.io.FileNotFoundException: File does not exist, and RandomAccessFile is not open in write mode
         //
         verifyException("htsjdk.samtools.FileInputResource$1", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      String string0 = BamUtils.constructIndexFilename("caiEuVY:HNCtH!{LiE");
      assertEquals("caiEuVY:HNCtH!{LiE.crai", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      boolean boolean0 = BamUtils.isCramFile("^[t]B1%URA");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      boolean boolean0 = BamUtils.isBamFile("Y;");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      int int0 = BamUtils.getFtpBufferSize();
      assertEquals(10485760, int0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      int int0 = BamUtils.getFtpSocketTimeout();
      assertEquals(10000, int0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/;VP2umd4Qy,.bai");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "l?n2m");
      File file0 = BamUtils.getIndexFile(";VP2umd4Qy,");
      assertEquals(1392409281320L, file0.lastModified());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      try { 
        BamUtils.getIndexFile("ftp");
        fail("Expecting exception: MalformedURLException");
      
      } catch(MalformedURLException e) {
         //
         // no protocol: ftp.bai
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      try { 
        BamUtils.getIndexFile("http|3J!(JnYR2.bam");
        fail("Expecting exception: MalformedURLException");
      
      } catch(MalformedURLException e) {
         //
         // no protocol: http|3J!(JnYR2.bam.bai
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      try { 
        BamUtils.getIndexFile("");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Alignment file is not a known file type. The file suffix may be incorrect.
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      BamUtils.createIndexFileFromScratch("", mockFile0);
      assertEquals(1392409281320L, mockFile0.lastModified());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      File file0 = BamUtils.createTempIndexFile(uRL0);
      //  // Unstable assertion: assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/_fooExample0.bai", file0.toString());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      String string0 = BamUtils.constructIndexFilename("Failed to find an index file for remote alignment file: ");
      //  // Unstable assertion: assertEquals("Failed to find an index file for remote alignment file: .bai", string0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      boolean boolean0 = BamUtils.samRecordEqualityCheck((SAMRecord) null, (SAMRecord) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      SAMRecord sAMRecord0 = new SAMRecord((SAMFileHeader) null);
      // Undeclared exception!
      try { 
        BamUtils.samRecordEqualityCheck(sAMRecord0, sAMRecord0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("5vg3_j FY]JUh~#$");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry();
      Range range0 = new Range(2, 1006);
      FeatureVector featureVector0 = entry0.getFeaturesInRange(range0);
      int[] intArray0 = new int[9];
      Locale locale0 = Locale.GERMAN;
      NumberFormat numberFormat0 = NumberFormat.getIntegerInstance(locale0);
      JFormattedTextField jFormattedTextField0 = new JFormattedTextField((Format) numberFormat0);
      BoundedRangeModel boundedRangeModel0 = jFormattedTextField0.getHorizontalVisibility();
      JProgressBar jProgressBar0 = new JProgressBar(boundedRangeModel0);
      BamUtils.calculateMappedReads((BamView) null, featureVector0, false, false, false, intArray0, jProgressBar0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      BamUtils bamUtils0 = new BamUtils();
  }
}
