//
// BAGEL - Parallel electron correlation program.
// Filename: _complex_eriroot_12.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot12(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[12] = {5.036188911729393e-02,4.545066815637803e-01,1.269589940103960e+00,2.509848097232131e+00,4.198415644878412e+00,
    6.369975388030638e+00,9.075434230961196e+00,1.239044796380947e+01,1.643219508767532e+01,2.139675593616611e+01,2.766110877984608e+01,3.619136036061554e+01
    };
  static constexpr double aw[12] = {4.269311638686991e-01,2.861795353464431e-01,1.277396217845591e-01,3.744547050323081e-02,7.048355810072695e-03,
    8.236924826884174e-04,5.688691636404396e-05,2.158245704902338e-06,4.018971174941392e-08,3.046254269987585e-10,6.584620243078148e-13,1.664368496489123e-16
    };
  static constexpr double xr[54960] = {   8.553341492608533e-03,  -1.773433929383325e-04,   2.745158512879098e-06,  -3.754753855019241e-08,   4.777863611524048e-10,
  -5.782319544284248e-12,   6.726494758019945e-14,  -7.560981090652973e-16,   8.227906685214016e-18,  -8.664102759536624e-20,   8.801789882703582e-22,  -8.573818443999875e-24,
   7.915879488106303e-26,  -6.773942807794654e-28,   8.553599391311426e-03,  -1.773539723040864e-04,   2.745427802702337e-06,  -3.755297202355763e-08,   4.778812087498545e-10,
  -5.783812781746427e-12,   6.728662285702015e-14,  -7.563916801984858e-16,   8.231635756492586e-18,  -8.668542969614717e-20,   8.806708023587994e-22,  -8.578787470643777e-24,
   7.920238743056617e-26,  -6.776772945760071e-28,   8.554054478225747e-03,  -1.773726410062626e-04,   2.745903012274682e-06,  -3.756256061250633e-08,   4.780485936415962e-10,
  -5.786448093240821e-12,   6.732487719248183e-14,  -7.569098130658765e-16,   8.238217450157241e-18,  -8.676379874904359e-20,   8.815388353655278e-22,  -8.587557074604393e-24,
   7.927930782134785e-26,  -6.781763513962994e-28,   8.554604809304967e-03,  -1.773952175231924e-04,   2.746477714848490e-06,  -3.757415718027409e-08,   4.782510395572029e-10,
  -5.789635542434884e-12,   6.737114833312193e-14,  -7.575365528981443e-16,   8.246178984398522e-18,  -8.685859899677056e-20,   8.825888440967450e-22,  -8.598164233682148e-24,
   7.937232184751014e-26,  -6.787792602868234e-28,   8.555139097970767e-03,  -1.774171366382263e-04,   2.747035703746502e-06,  -3.758541696312018e-08,   4.784476148687207e-10,
  -5.792730703351338e-12,   6.741608178942102e-14,  -7.581451989786927e-16,   8.253910920529040e-18,  -8.695066667174034e-20,   8.836085659914615e-22,  -8.608464473649635e-24,
   7.946261931736467e-26,  -6.793639703589337e-28,   8.555569540326942e-03,  -1.774347959853310e-04,   2.747485267944678e-06,  -3.759448915647343e-08,   4.786060051448255e-10,
  -5.795224727009399e-12,   6.745228979826845e-14,  -7.586356725062741e-16,   8.260141829505809e-18,  -8.702486187684010e-20,   8.844303212666645e-22,  -8.616764356683130e-24,
   7.953536250799913e-26,  -6.798345862668013e-28,   8.555853981872931e-03,  -1.774464657473901e-04,   2.747782359183442e-06,  -3.760048461454499e-08,   4.787106821712291e-10,
  -5.796873028352005e-12,   6.747622040097394e-14,  -7.589598451503529e-16,   8.264260161811150e-18,  -8.707390181330917e-20,   8.849734598926118e-22,  -8.622249820645422e-24,
   7.958343025096472e-26,  -6.801453554007736e-28,   8.556000060208022e-03,  -1.774524589698468e-04,   2.747934938170127e-06,  -3.760356379006580e-08,   4.787644436434717e-10,
  -5.797719601182703e-12,   6.748851145559117e-14,  -7.591263469676748e-16,   8.266375449943152e-18,  -8.709909020852522e-20,   8.852524300511789e-22,  -8.625067193203523e-24,
   7.960811543827407e-26,  -6.803048865995080e-28,   8.556050904745715e-03,  -1.774545450042175e-04,   2.747988046024294e-06,  -3.760463556047793e-08,   4.787831565821112e-10,
  -5.798014273132848e-12,   6.749278971570634e-14,  -7.591843032159103e-16,   8.267111747480882e-18,  -8.710785790357232e-20,   8.853495349334268e-22,  -8.626047857149804e-24,
   7.961670735961353e-26,  -6.803604027587566e-28,   8.556058973103770e-03,  -1.774548760309663e-04,   2.747996473572979e-06,  -3.760480563735152e-08,   4.787861261041146e-10,
  -5.798061034202553e-12,   6.749346862834409e-14,  -7.591935002531052e-16,   8.267228590234615e-18,  -8.710924924657166e-20,   8.853649444619898e-22,  -8.626203477462849e-24,
   7.961807077994596e-26,  -6.803692119273488e-28,   7.603132195023099e-02,  -1.520931457212813e-03,   2.189084952864737e-05,  -2.636891759199271e-07,   2.720952232924536e-09,
  -2.318472550876212e-11,   1.372253016461633e-13,   5.866338242393186e-17,  -1.762144319988068e-17,   3.362820762095967e-19,  -4.363139780578765e-21,   4.241625699192701e-23,
  -2.613247398442219e-25,  -5.788965433094429e-28,   7.603337728801297e-02,  -1.521005696203888e-03,   2.189238114712358e-05,  -2.637109104157467e-07,   2.721144653499649e-09,
  -2.318459185924105e-11,   1.371786640782288e-13,   5.980402783313926e-17,  -1.763990141389286e-17,   3.365005969432033e-19,  -4.364736934890835e-21,   4.241151370598919e-23,
  -2.608990648945269e-25,  -5.881236675147653e-28,   7.603700408078609e-02,  -1.521136697043072e-03,   2.189508379992708e-05,  -2.637492611686540e-07,   2.721484129166431e-09,
  -2.318435420403051e-11,   1.370963319313231e-13,   6.181731408884448e-17,  -1.767247668395768e-17,   3.368861598135333e-19,  -4.367552986949016e-21,   4.240308908639418e-23,
  -2.601470007949204e-25,  -6.044169920695775e-28,   7.604138983672623e-02,  -1.521295113134363e-03,   2.189835202644645e-05,  -2.637956351256278e-07,   2.721894535576541e-09,
  -2.318406371036096e-11,   1.369967077894070e-13,   6.425282347661421e-17,  -1.771187635507073e-17,   3.373523516109412e-19,  -4.370954514811667e-21,   4.239280808940613e-23,
  -2.592359698872536e-25,  -6.241393727430143e-28,   7.604564766145830e-02,  -1.521448909610491e-03,   2.190152492110267e-05,  -2.638406539672622e-07,   2.722292855479209e-09,
  -2.318377843768607e-11,   1.368999239839462e-13,   6.661824415323221e-17,  -1.775013461298429e-17,   3.378048857421283e-19,  -4.374252809307682e-21,   4.238272912750512e-23,
  -2.583498526132319e-25,  -6.433067908796949e-28,   7.604907785928895e-02,  -1.521572812411894e-03,   2.190408107619718e-05,  -2.638769204214578e-07,   2.722613668333833e-09,
  -2.318354628473805e-11,   1.368219057510412e-13,   6.852456313637067e-17,  -1.778096194157994e-17,   3.381694148467098e-19,  -4.376907111080805e-21,   4.237453913723932e-23,
  -2.576347866280009e-25,  -6.587630517162082e-28,   7.605134454615771e-02,  -1.521654688289988e-03,   2.190577019298612e-05,  -2.639008845798395e-07,   2.722825622212767e-09,
  -2.318339173575545e-11,   1.367703279841733e-13,   6.978460021537079e-17,  -1.780133550374220e-17,   3.384102761493899e-19,  -4.378659673167681e-21,   4.236909279656916e-23,
  -2.571616855756818e-25,  -6.689837330557066e-28,   7.605250862097514e-02,  -1.521696736434093e-03,   2.190663765229849e-05,  -2.639131913005575e-07,   2.722934460296175e-09,
  -2.318331201285676e-11,   1.367438326910602e-13,   7.043180565583597e-17,  -1.781179935773525e-17,   3.385339659094100e-19,  -4.379559278899506e-21,   4.236628515415976e-23,
  -2.569185405230133e-25,  -6.742348485850250e-28,   7.605291379148209e-02,  -1.521711371829039e-03,   2.190693958216560e-05,  -2.639174747640147e-07,   2.722972340735880e-09,
  -2.318328420811427e-11,   1.367346095449966e-13,   7.065708992088977e-17,  -1.781544156586239e-17,   3.385770166182476e-19,  -4.379872328223475e-21,   4.236530622696737e-23,
  -2.568338822018243e-25,  -6.760629146229376e-28,   7.605297808663265e-02,  -1.521713694271933e-03,   2.190698749440589e-05,  -2.639181544905114e-07,   2.722978351761536e-09,
  -2.318327979320426e-11,   1.367331459009798e-13,   7.069284030860418e-17,  -1.781601954210182e-17,   3.385838481422003e-19,  -4.379922001673381e-21,   4.236515080391950e-23,
  -2.568204466936185e-25,  -6.763530209577469e-28,   2.060318179015365e-01,  -3.832896573217186e-03,   4.718548586764418e-05,  -4.128922511045824e-07,   1.852495231770828e-09,
   1.575357318337376e-11,  -4.752560315908108e-13,   5.772925139066810e-15,  -3.162748010257558e-17,  -2.901013434988148e-19,   9.758358127149623e-21,  -1.271037426458984e-22,
   7.250535420253043e-25,   7.368205249972505e-27,   2.060362436162956e-01,  -3.833012646557040e-03,   4.718652411568610e-05,  -4.128773867503050e-07,   1.851825933900697e-09,
   1.576492272490390e-11,  -4.753381999988330e-13,   5.771929030066264e-15,  -3.158617158072481e-17,  -2.907545432063394e-19,   9.762744338097469e-21,  -1.270480563640121e-22,
   7.228964730517549e-25,   7.400975223130782e-27,   2.060440529384132e-01,  -3.833217456378909e-03,   4.718835581440933e-05,  -4.128511497173362e-07,   1.850644853655849e-09,
   1.578494756702876e-11,  -4.754830992067020e-13,   5.770169589339273e-15,  -3.151326708692220e-17,  -2.919068890944978e-19,   9.770473009689237e-21,  -1.269496025371932e-22,
   7.190888687795164e-25,   7.458775021129683e-27,   2.060534961885045e-01,  -3.833465108784171e-03,   4.719057020181423e-05,  -4.128194088754188e-07,   1.849216519237079e-09,
   1.580915908580820e-11,  -4.756581623974837e-13,   5.768039001922160e-15,  -3.142508471642722e-17,  -2.932999163391224e-19,   9.779800068577782e-21,  -1.268302195639189e-22,
   7.144822527285444e-25,   7.528627278566162e-27,   2.060626636728989e-01,  -3.833705519356366e-03,   4.719271934383103e-05,  -4.127885799796208e-07,   1.847829749898473e-09,
   1.583266034333178e-11,  -4.758279531042696e-13,   5.765967468147383e-15,  -3.133945215025301e-17,  -2.946518216904620e-19,   9.788835201713342e-21,  -1.267139775621628e-22,
   7.100077009504359e-25,   7.596396771732369e-27,   2.060700489798846e-01,  -3.833899186618008e-03,   4.719445027278143e-05,  -4.127637335630602e-07,   1.846712466953781e-09,
   1.585159059567167e-11,  -4.759646213441489e-13,   5.764296377674559e-15,  -3.127044859879910e-17,  -2.957405966387096e-19,   9.796099872905170e-21,  -1.266200859234538e-22,
   7.064012525712214e-25,   7.650960916346557e-27,   2.060749291085143e-01,  -3.834027156354852e-03,   4.719559384789664e-05,  -4.127473100791312e-07,   1.845974127753336e-09,
   1.586409836224694e-11,  -4.760548739734264e-13,   5.763191029872549e-15,  -3.122484295346744e-17,  -2.964598914525098e-19,   9.800893423510882e-21,  -1.265579223179898e-22,
   7.040172923148725e-25,   7.687001172478674e-27,   2.060774353033283e-01,  -3.834092874276057e-03,   4.719618106908731e-05,  -4.127388741598828e-07,   1.845594937148752e-09,
   1.587052138730068e-11,  -4.761012059104969e-13,   5.762623034246172e-15,  -3.120141938971418e-17,  -2.968292378574660e-19,   9.803353033224995e-21,  -1.265259607079512e-22,
   7.027927418055212e-25,   7.705504997469400e-27,   2.060783076098132e-01,  -3.834115747894992e-03,   4.719638544735168e-05,  -4.127359376943712e-07,   1.845462953505726e-09,
   1.587275693037705e-11,  -4.761173294419628e-13,   5.762425282984206e-15,  -3.119326614508571e-17,  -2.969577849450714e-19,   9.804208787298908e-21,  -1.265148301877195e-22,
   7.023664823802149e-25,   7.711944694899808e-27,   2.060784460329540e-01,  -3.834119377618294e-03,   4.719641787891893e-05,  -4.127354717050816e-07,   1.845442009382546e-09,
   1.587311167791925e-11,  -4.761198878950516e-13,   5.762393899962770e-15,  -3.119197231567639e-17,  -2.969781832503387e-19,   9.804344567751542e-21,  -1.265130636431391e-22,
   7.022988388199554e-25,   7.712966551605554e-27,   3.891258781190768e-01,  -6.476186065762061e-03,   6.088363075379516e-05,  -2.156734161645495e-07,  -3.456936800559469e-09,
   6.634103473000713e-11,  -3.655554944719799e-13,  -4.788051486969629e-15,   1.173195129496972e-16,  -7.981222218962065e-19,  -8.434421707596103e-21,   2.487344799318492e-22,
  -1.966298831745890e-24,  -1.639961631307674e-26,   3.891315820389029e-01,  -6.476246505019828e-03,   6.088168335143897e-05,  -2.156113012187550e-07,  -3.457447229977619e-09,
   6.633156603015858e-11,  -3.652482753030133e-13,  -4.790711855063387e-15,   1.172835475875065e-16,  -7.968444763469550e-19,  -8.446360085887905e-21,   2.486118219445391e-22,
  -1.961372853179528e-24,  -1.644941079842099e-26,   3.891416465465485e-01,  -6.476353136853420e-03,   6.087824689672221e-05,  -2.155017056480157e-07,  -3.458347539783237e-09,
   6.631485411827186e-11,  -3.647062592245710e-13,  -4.795402614029749e-15,   1.172200453926419e-16,  -7.945903911721731e-19,  -8.467400792732827e-21,   2.483950959206705e-22,
  -1.952683607848029e-24,  -1.653712858264463e-26,   3.891538164033086e-01,  -6.476482053016107e-03,   6.087409110242899e-05,  -2.153691938399252e-07,  -3.459435605710776e-09,
   6.629463866665298e-11,  -3.640509789049824e-13,  -4.801068759004044e-15,   1.171431884403508e-16,  -7.918656095752034e-19,  -8.492801249794620e-21,   2.481325276648699e-22,
  -1.942181128189045e-24,  -1.664295006605600e-26,   3.891656304241985e-01,  -6.476607177265436e-03,   6.087005631416030e-05,  -2.152405665819521e-07,  -3.460491254812867e-09,
   6.627500629068895e-11,  -3.634149816996484e-13,  -4.806563103055122e-15,   1.170685044198667e-16,  -7.892213637544538e-19,  -8.517415404429568e-21,   2.478771072351784e-22,
  -1.931990381602444e-24,  -1.674542032383070e-26,   3.891751474556314e-01,  -6.476707957585807e-03,   6.086680564387737e-05,  -2.151369553886887e-07,  -3.461341223195242e-09,
   6.625918528673904e-11,  -3.629027292549477e-13,  -4.810984796937580e-15,   1.170082879632924e-16,  -7.870918572136190e-19,  -8.537212608593547e-21,   2.476709691524975e-22,
  -1.923784352016068e-24,  -1.682778322755303e-26,   3.891814360473518e-01,  -6.476774542540996e-03,   6.086465751332462e-05,  -2.150684954892602e-07,  -3.461902647435354e-09,
   6.624872839816346e-11,  -3.625642902797656e-13,  -4.813904381178294e-15,   1.169684725713499e-16,  -7.856850424014348e-19,  -8.550278760713505e-21,   2.475345735281846e-22,
  -1.918363672260696e-24,  -1.688211621732112e-26,   3.891846655113021e-01,  -6.476808734353725e-03,   6.086355430050087e-05,  -2.150333394567377e-07,  -3.462190897698414e-09,
   6.624335746598447e-11,  -3.623905006186856e-13,  -4.815403049467273e-15,   1.169480176024728e-16,  -7.849626763097684e-19,  -8.556984066033190e-21,   2.474644712223252e-22,
  -1.915580425927135e-24,  -1.690999068547839e-26,   3.891857895512201e-01,  -6.476820634689829e-03,   6.086317031001124e-05,  -2.150211033008081e-07,  -3.462291215025286e-09,
   6.624148793340674e-11,  -3.623300139155221e-13,  -4.815924566771290e-15,   1.169408968123085e-16,  -7.847112662022244e-19,  -8.559317146607222e-21,   2.474400624618510e-22,
  -1.914611776320536e-24,  -1.691968817282031e-26,   3.891859679206569e-01,  -6.476822523088508e-03,   6.086310937566889e-05,  -2.150191616019747e-07,  -3.462307133489962e-09,
   6.624119125814206e-11,  -3.623204156217565e-13,  -4.816007319261880e-15,   1.169397667816012e-16,  -7.846713716415538e-19,  -8.559687338172765e-21,   2.474361887000302e-22,
  -1.914458068993831e-24,  -1.692122681799756e-26,   6.122912273499601e-01,  -8.738885402075606e-03,   5.149045177734778e-05,   2.589687328342952e-07,  -7.062854349807709e-09,
   2.075243821381396e-11,   8.152848882869545e-13,  -9.595072669905556e-15,  -5.132708751795578e-17,   2.017672969460229e-18,  -8.138177162660193e-21,  -2.879571779784962e-22,
   3.952792980423732e-24,   1.896599940573278e-26,   6.122960466082147e-01,  -8.738812499324605e-03,   5.148648539119543e-05,   2.589880303936942e-07,  -7.061709460267741e-09,
   2.073365556811231e-11,   8.151494641941563e-13,  -9.588301576840060e-15,  -5.136064716509138e-17,   2.016193691443409e-18,  -8.114073974983397e-21,  -2.878162201225989e-22,
   3.945123334119930e-24,   1.900742244546927e-26,   6.123045499638048e-01,  -8.738683856886515e-03,   5.147948716352235e-05,   2.590220669585220e-07,  -7.059689439732216e-09,
   2.070052411262433e-11,   8.149104350956426e-13,  -9.576357931345266e-15,  -5.141978133216661e-17,   2.013584075285253e-18,  -8.071581984856713e-21,  -2.875672542741146e-22,
   3.931600749505604e-24,   1.908030818633629e-26,   6.123148317983295e-01,  -8.738528293597794e-03,   5.147102572371091e-05,   2.590631999894816e-07,  -7.057247073778026e-09,
   2.066047964437136e-11,   8.146212773483750e-13,  -9.561922460151108e-15,  -5.149114666133504e-17,   2.010429511649813e-18,  -8.020265763639101e-21,  -2.872657877669724e-22,
   3.915267209959391e-24,   1.916809182352652e-26,   6.123248126871822e-01,  -8.738377267621736e-03,   5.146281243829749e-05,   2.591031057352878e-07,  -7.054876344197771e-09,
   2.062162447407781e-11,   8.143404412385123e-13,  -9.547915991921522e-15,  -5.156028004255438e-17,   2.007368176630058e-18,  -7.970517458136319e-21,  -2.869726964686921e-22,
   3.899429854448212e-24,   1.925294409229417e-26,   6.123328527759078e-01,  -8.738255597452548e-03,   5.145619659145984e-05,   2.591352350277117e-07,  -7.052966713804485e-09,
   2.059033708308805e-11,   8.141141125951296e-13,  -9.536637747773950e-15,  -5.161586786254798e-17,   2.004902765596798e-18,  -7.930489984476809e-21,  -2.867362765576013e-22,
   3.886685067945645e-24,   1.932103772490081e-26,   6.123381653345501e-01,  -8.738175197227731e-03,   5.145182528530817e-05,   2.591564565545029e-07,  -7.051704961283055e-09,
   2.056966970187099e-11,   8.139645142814068e-13,  -9.529187823022528e-15,  -5.165254786060098e-17,   2.003274038589778e-18,  -7.904064577336167e-21,  -2.865799033172226e-22,
   3.878270187719509e-24,   1.936590453706879e-26,   6.123408935292364e-01,  -8.738133907016690e-03,   5.144958051174377e-05,   2.591673520604227e-07,  -7.051057021062219e-09,
   2.055905810586901e-11,   8.138876746742364e-13,  -9.525362715030702e-15,  -5.167136889237756e-17,   2.002437724649375e-18,  -7.890501296388643e-21,  -2.864995514882896e-22,
   3.873950799501365e-24,   1.938890616396910e-26,   6.123418430930881e-01,  -8.738119535445532e-03,   5.144879921387503e-05,   2.591711439011219e-07,  -7.050831504322514e-09,
   2.055536497590436e-11,   8.138609277626545e-13,  -9.524031476103770e-15,  -5.167791719379803e-17,   2.002146656285860e-18,  -7.885781654864986e-21,  -2.864715768713551e-22,
   3.872447724062579e-24,   1.939690578502903e-26,   6.123419937753526e-01,  -8.738117254868704e-03,   5.144867523342909e-05,   2.591717455931353e-07,  -7.050795718149093e-09,
   2.055477894285918e-11,   8.138566832925512e-13,  -9.523820232751301e-15,  -5.167895619890416e-17,   2.002100468617039e-18,  -7.885032768892886e-21,  -2.864671373324506e-22,
   3.872209222222972e-24,   1.939817491542101e-26,   8.600498473856124e-01,  -1.003271663361520e-02,   2.051294164013045e-05,   6.518775960054499e-07,  -3.675132505481060e-09,
  -7.253650157817308e-11,   7.047283774076097e-13,   9.201624287282518e-15,  -1.389877346985979e-16,  -1.175490152683061e-18,   2.766509064916124e-20,   1.341199099697561e-22,
  -5.501980179975857e-24,  -9.485142716754410e-27,   8.600517663315297e-01,  -1.003253353236127e-02,   2.051087994962219e-05,   6.518097448905789e-07,  -3.674145765824122e-09,
  -7.251844869477730e-11,   7.043659201866314e-13,   9.197674961216982e-15,  -1.388721017916690e-16,  -1.174801326978800e-18,   2.763146815901568e-20,   1.340498827969540e-22,
  -5.492872377583920e-24,  -9.497359113381505e-27,   8.600551521853633e-01,  -1.003221046280160e-02,   2.050724251447400e-05,   6.516900342695770e-07,  -3.672405061605328e-09,
  -7.248660040999824e-11,   7.037266048312757e-13,   9.190708201190443e-15,  -1.386681806561813e-16,  -1.173586177404017e-18,   2.757218638455900e-20,   1.339262472809102e-22,
  -5.476817553809167e-24,  -9.518828870431031e-27,   8.600592461293002e-01,  -1.003181983003650e-02,   2.050284485650615e-05,   6.515453023297625e-07,  -3.670300888203671e-09,
  -7.244809988413072e-11,   7.029539573484595e-13,   9.182287139079791e-15,  -1.384217929290981e-16,  -1.172117307422188e-18,   2.750057999155171e-20,   1.337766243843433e-22,
  -5.457431209379246e-24,  -9.544643497031040e-27,   8.600632201799577e-01,  -1.003144063815125e-02,   2.049857648980441e-05,   6.514048235911400e-07,  -3.668258930838242e-09,
  -7.241073550557706e-11,   7.022043236036135e-13,   9.174115487478134e-15,  -1.381828089849828e-16,  -1.170691879679366e-18,   2.743114710612124e-20,   1.336312462678575e-22,
  -5.438639860299039e-24,  -9.569550458132761e-27,   8.600664214234269e-01,  -1.003113518590254e-02,   2.049513852470682e-05,   6.512916733139858e-07,  -3.666614484961063e-09,
  -7.238064331795330e-11,   7.016007428393332e-13,   9.167534925113497e-15,  -1.379904334105056e-16,  -1.169543950549160e-18,   2.737527112219786e-20,   1.335140410104664e-22,
  -5.423522248604914e-24,  -9.589505481602477e-27,   8.600685366501376e-01,  -1.003093335819320e-02,   2.049286706040179e-05,   6.512169142270056e-07,  -3.665528123079551e-09,
  -7.236076288689514e-11,   7.012020613160731e-13,   9.163187788437679e-15,  -1.378633868880176e-16,  -1.168785604053994e-18,   2.733837776605253e-20,   1.334365496611575e-22,
  -5.413542806564195e-24,  -9.602637787149608e-27,   8.600696228899747e-01,  -1.003082971300551e-02,   2.049170064193059e-05,   6.511785245182678e-07,  -3.664970304250816e-09,
  -7.235055455585626e-11,   7.009973668576592e-13,   9.160955691162426e-15,  -1.377981646256214e-16,  -1.168396213955601e-18,   2.731944007160187e-20,   1.333967405021241e-22,
  -5.408420978306397e-24,  -9.609365292367792e-27,   8.600700009608756e-01,  -1.003079363882608e-02,   2.049129467317107e-05,   6.511651630519555e-07,  -3.664776163030397e-09,
  -7.234700164721180e-11,   7.009261286505196e-13,   9.160178847434897e-15,  -1.377754669543742e-16,  -1.168260692259691e-18,   2.731285003568219e-20,   1.333828823901158e-22,
  -5.406638771278127e-24,  -9.611704227245045e-27,   8.600700609552918e-01,  -1.003078791437328e-02,   2.049123025217852e-05,   6.511630427913675e-07,  -3.664745356096843e-09,
  -7.234643785877271e-11,   7.009148244876782e-13,   9.160055575795657e-15,  -1.377718653143227e-16,  -1.168239187264726e-18,   2.731180435429397e-20,   1.333806831956454e-22,
  -5.406355982930765e-24,  -9.612075258945205e-27,   1.115705761226605e+00,  -1.004359875355070e-02,  -1.880144085344404e-05,   6.512670993339534e-07,   3.494193577404169e-09,
  -7.193454019012585e-11,  -6.804856432058141e-13,   8.993429115496238e-15,   1.345848190497681e-16,  -1.119370312016995e-18,  -2.668418638073512e-20,   1.207310767327734e-22,
   5.253873432595254e-24,  -6.596406197231630e-27,   1.115704002529648e+00,  -1.004341582202363e-02,  -1.879948074928871e-05,   6.511998091385871e-07,   3.493240793473959e-09,
  -7.191689420966778e-11,  -6.801346592980733e-13,   8.989667418169470e-15,   1.344732758880290e-16,  -1.118749713898516e-18,  -2.665207418455504e-20,   1.206818739999821e-22,
   5.245304046137574e-24,  -6.614062096920863e-27,   1.115700899429909e+00,  -1.004309305182202e-02,  -1.879602254936455e-05,   6.510810879596698e-07,   3.491559991585901e-09,
  -7.188576361208906e-11,  -6.795155800859755e-13,   8.983031545393835e-15,   1.342765660140872e-16,  -1.117654865983068e-18,  -2.659545465303027e-20,   1.205949513243301e-22,
   5.230198006459803e-24,  -6.645120583241868e-27,   1.115697147382090e+00,  -1.004270278082625e-02,  -1.879184159813046e-05,   6.509375519367300e-07,   3.489528230421353e-09,
  -7.184813041089568e-11,  -6.787673875397475e-13,   8.975010277659266e-15,   1.340388894326982e-16,  -1.116331317821684e-18,  -2.652706288254748e-20,   1.204896671011817e-22,
   5.211956797208908e-24,  -6.682514055129900e-27,   1.115693505224491e+00,  -1.004232393991258e-02,  -1.878778357891921e-05,   6.507982336217691e-07,   3.487556546257274e-09,
  -7.181160748194215e-11,  -6.780414787100118e-13,   8.967226406694852e-15,   1.338083529225170e-16,  -1.115046810877872e-18,  -2.646074589585120e-20,   1.203872747743620e-22,
   5.194274882834283e-24,  -6.718644870416943e-27,   1.115690571339885e+00,  -1.004201877023881e-02,  -1.878451504721319e-05,   6.506860177716472e-07,   3.485968694836760e-09,
  -7.178219277261899e-11,  -6.774569993198358e-13,   8.960957997049083e-15,   1.336227759080763e-16,  -1.114012294658804e-18,  -2.640737660329046e-20,   1.203046571980684e-22,
   5.180049412670042e-24,  -6.747629736727324e-27,   1.115688632774316e+00,  -1.004181712917007e-02,  -1.878235553177633e-05,   6.506118759439704e-07,   3.484919721379699e-09,
  -7.176275981991820e-11,  -6.770709342077815e-13,   8.956817008700660e-15,   1.335002185320795e-16,  -1.113328835054430e-18,  -2.637213794328462e-20,   1.202500006565146e-22,
   5.170658697090946e-24,  -6.766722955091477e-27,   1.115687637256934e+00,  -1.004171357980655e-02,  -1.878124660140641e-05,   6.505738031676106e-07,   3.484381100765339e-09,
  -7.175278123253856e-11,  -6.768727171994804e-13,   8.954690742399540e-15,   1.334373006656078e-16,  -1.112977886159487e-18,  -2.635404949498858e-20,   1.202219120458234e-22,
   5.165838965536898e-24,  -6.776509866963158e-27,   1.115687290762577e+00,  -1.004167753897566e-02,  -1.878086064142958e-05,   6.505605520029942e-07,   3.484193641256424e-09,
  -7.174930827906414e-11,  -6.768037332606509e-13,   8.953950728372715e-15,   1.334154049020081e-16,  -1.112855741602813e-18,  -2.634775496429676e-20,   1.202121323883394e-22,
   5.164161867443124e-24,  -6.779913368688430e-27,   1.115687235778912e+00,  -1.004167181981464e-02,  -1.878079939553261e-05,   6.505584492453143e-07,   3.484163894599342e-09,
  -7.174875717797195e-11,  -6.767927868064451e-13,   8.953833300827321e-15,   1.334119305061346e-16,  -1.112836359248697e-18,  -2.634675617159426e-20,   1.202105803414555e-22,
   5.163895756604446e-24,  -6.780453318831387e-27,   1.362546030564537e+00,  -8.797310580184568e-03,  -4.927958325021944e-05,   2.721299922699750e-07,   6.764294527852698e-09,
   1.700066227077954e-11,  -7.806472059775609e-13,  -8.625273165138513e-15,   5.106272888272369e-17,   1.812446338901323e-18,   6.562480108320265e-21,  -2.568679527167486e-22,
  -3.351763615795508e-24,   1.735508945979961e-26,   1.362541418238230e+00,  -8.797233988165948e-03,  -4.927578452875358e-05,   2.721457884963247e-07,   6.763198337451958e-09,
   1.698377797237560e-11,  -7.805126103306939e-13,  -8.619190546240175e-15,   5.108975854027795e-17,   1.811126884384756e-18,   6.542039154601803e-21,  -2.567392565393561e-22,
  -3.345318734086621e-24,   1.738771906502919e-26,   1.362533280004576e+00,  -8.797098836754844e-03,  -4.926908212579356e-05,   2.721736483473462e-07,   6.761264246315087e-09,
   1.695399508068811e-11,  -7.802750569028502e-13,  -8.608461286079614e-15,   5.113738294906904e-17,   1.808799227418793e-18,   6.506003093172348e-21,  -2.565119783378936e-22,
  -3.333955430116334e-24,   1.744512990649061e-26,   1.362523439657674e+00,  -8.796935404106388e-03,  -4.926097836242444e-05,   2.722073148905894e-07,   6.758925785394321e-09,
   1.691799785667010e-11,  -7.799877071747133e-13,  -8.595493515597903e-15,   5.119485187354649e-17,   1.805985523229712e-18,   6.462482985768145e-21,  -2.562368247889919e-22,
  -3.320229786662536e-24,   1.751427137780977e-26,   1.362513887334617e+00,  -8.796776740115989e-03,  -4.925311226335745e-05,   2.722399748753644e-07,   6.756655923213735e-09,
   1.688306971826786e-11,  -7.797086509724039e-13,  -8.582911083679119e-15,   5.125051717128048e-17,   1.803254995668598e-18,   6.420292062715072e-21,  -2.559693696194496e-22,
  -3.306920855984162e-24,   1.758109959779189e-26,   1.362506192476626e+00,  -8.796648917881773e-03,  -4.924677607684342e-05,   2.722662689221065e-07,   6.754827548980648e-09,
   1.685494448722660e-11,  -7.794837738904217e-13,  -8.572779464356430e-15,   5.129527124733928e-17,   1.801056012061534e-18,   6.386344878201789e-21,  -2.557536675822698e-22,
  -3.296210589605855e-24,   1.763472582854248e-26,   1.362501108032324e+00,  -8.796564452981315e-03,  -4.924258955130622e-05,   2.722836355257414e-07,   6.753619488439363e-09,
   1.683636591679300e-11,  -7.793351433979976e-13,  -8.566086934557007e-15,   5.132480031400984e-17,   1.799603302810455e-18,   6.363933381494740e-21,  -2.556110164723664e-22,
  -3.289138935706739e-24,   1.767005852901919e-26,   1.362498496982799e+00,  -8.796521075519250e-03,  -4.924043966711605e-05,   2.722925516234599e-07,   6.752999121419714e-09,
   1.682682681228580e-11,  -7.792588034887215e-13,  -8.562650700289051e-15,   5.133995141568196e-17,   1.798857372273033e-18,   6.352430249685326e-21,  -2.555377215371423e-22,
  -3.285509003423646e-24,   1.768817187091834e-26,   1.362497588192001e+00,  -8.796505977485838e-03,  -4.923969139567640e-05,   2.722956545574672e-07,   6.752783201753326e-09,
   1.682350693893458e-11,  -7.792322309273617e-13,  -8.561454798919493e-15,   5.134522274874461e-17,   1.798597761065823e-18,   6.348427473177583e-21,  -2.555122047153167e-22,
  -3.284245842918445e-24,   1.769447134264123e-26,   1.362497443979840e+00,  -8.796503581630625e-03,  -4.923957265603732e-05,   2.722961469315870e-07,   6.752748938501752e-09,
   1.682298013496538e-11,  -7.792280141444488e-13,  -8.561265031132439e-15,   5.134605913480689e-17,   1.798556565137792e-18,   6.347792334850601e-21,  -2.555081552695661e-22,
  -3.284045409591656e-24,   1.769547074269510e-26,   1.584909262310597e+00,  -6.633124177181750e-03,  -5.915262410519083e-05,  -1.779314152748447e-07,   3.568976248097783e-09,
   6.098826881954167e-11,   2.779642719777591e-13,  -4.912240644744756e-15,  -1.020769324374981e-16,  -5.656792926712010e-19,   8.629489860920955e-21,   2.048472044018422e-22,
   1.302389192698697e-24,  -1.700409689807631e-26,   1.584903720797433e+00,  -6.633174019205597e-03,  -5.915061437311863e-05,  -1.778743204766545e-07,   3.569363975961352e-09,
   6.097856799401495e-11,   2.776970784150629e-13,  -4.914122422220523e-15,  -1.020402743514081e-16,  -5.646279654832984e-19,   8.637370484142043e-21,   2.047211701887680e-22,
   1.298545898917403e-24,  -1.703491621737881e-26,   1.584893942863570e+00,  -6.633261953201167e-03,  -5.914706799263741e-05,  -1.777735832085890e-07,   3.570047822706373e-09,
   6.096144773601512e-11,   2.772256895491319e-13,  -4.917439967126762e-15,  -1.019755637077048e-16,  -5.627734121611725e-19,   8.651256666099703e-21,   2.044985990609784e-22,
   1.291767203680193e-24,  -1.708918978354422e-26,   1.584882119542853e+00,  -6.633368261695702e-03,  -5.914277937040558e-05,  -1.776517832494990e-07,   3.570874217218569e-09,
   6.094074062715823e-11,   2.766558147774082e-13,  -4.921446666436530e-15,  -1.018972691286352e-16,  -5.605317707508408e-19,   8.668015084572796e-21,   2.042291541693609e-22,
   1.283575209505225e-24,  -1.715463455357548e-26,   1.584870641941492e+00,  -6.633471440861891e-03,  -5.913861573503060e-05,  -1.775335551769588e-07,   3.571675921954088e-09,
   6.092063317724165e-11,   2.761027302533885e-13,  -4.925331158835612e-15,  -1.018212142267901e-16,  -5.583565716898466e-19,   8.684249426016613e-21,   2.039672581794085e-22,
   1.275627676314169e-24,  -1.721797523675504e-26,   1.584861395931227e+00,  -6.633554543977334e-03,  -5.913526133880056e-05,  -1.774383216522345e-07,   3.572321374605779e-09,
   6.090443104874503e-11,   2.756572729265021e-13,  -4.928456772117095e-15,  -1.017599111219414e-16,  -5.566049390442142e-19,   8.697302932316346e-21,   2.037560467442755e-22,
   1.269228914768718e-24,  -1.726886419050990e-26,   1.584855286428389e+00,  -6.633609448869518e-03,  -5.913304470304479e-05,  -1.773753976744132e-07,   3.572747687161669e-09,
   6.089372309755497e-11,   2.753629718198738e-13,  -4.930520318624438e-15,  -1.017193863617157e-16,  -5.554478242513054e-19,   8.705916382201697e-21,   2.036163688342716e-22,
   1.265002524785905e-24,  -1.730242341916687e-26,   1.584852148936052e+00,  -6.633637642633415e-03,  -5.913190632036143e-05,  -1.773430846357093e-07,   3.572966559975730e-09,
   6.088822347316766e-11,   2.752118493258574e-13,  -4.931579490954883e-15,  -1.016985697784276e-16,  -5.548536934178028e-19,   8.710336067460170e-21,   2.035446025833492e-22,
   1.262832627626442e-24,  -1.731963688593234e-26,   1.584851056907841e+00,  -6.633647455329100e-03,  -5.913151009040573e-05,  -1.773318380150929e-07,   3.573042731257577e-09,
   6.088630918636471e-11,   2.751592521789662e-13,  -4.931948056830156e-15,  -1.016913235516505e-16,  -5.546469171382080e-19,   8.711873785095136e-21,   2.035196181197053e-22,
   1.262077463649814e-24,  -1.732562487933765e-26,   1.584850883618228e+00,  -6.633649012449677e-03,  -5.913144721391060e-05,  -1.773300533421361e-07,   3.573054818144458e-09,
   6.088600541103787e-11,   2.751509058510772e-13,  -4.932006538945287e-15,  -1.016901736361302e-16,  -5.546141053689410e-19,   8.712117771494321e-21,   2.035156531653936e-22,
   1.261957633733881e-24,  -1.732657493423329e-26,   1.769070930030394e+00,  -4.103485623362845e-03,  -4.773471270453562e-05,  -3.832964597275711e-07,  -1.303901524857887e-09,
   2.004324556240305e-11,   4.561897357493477e-13,   4.691283086705018e-15,   1.553026960464651e-17,  -3.899343003786792e-19,  -8.692653089090219e-21,  -8.929038697360928e-23,
  -2.173918958525545e-25,   9.893933270552511e-27,   1.769066453444869e+00,  -4.103593358804637e-03,  -4.773544252365160e-05,  -3.832775917669528e-07,  -1.303259537343942e-09,
   2.005246035854910e-11,   4.562297442928581e-13,   4.689955145295587e-15,   1.549355730622278e-17,  -3.903918398244221e-19,  -8.693917209646943e-21,  -8.921696711128132e-23,
  -2.156442677467768e-25,   9.913378152045589e-27,   1.769058554383974e+00,  -4.103783455361654e-03,  -4.773673000728151e-05,  -3.832442919362071e-07,  -1.302126694816148e-09,
   2.006871788018830e-11,   4.563002616251691e-13,   4.687610718425150e-15,   1.542877361259711e-17,  -3.911988665117077e-19,  -8.696138977492857e-21,  -8.908730140266660e-23,
  -2.125604196054569e-25,   9.947659547042728e-27,   1.769049002660842e+00,  -4.104013314774130e-03,  -4.773828634547752e-05,  -3.832040134609197e-07,  -1.300756772075979e-09,
   2.008837301394315e-11,   4.563853982997075e-13,   4.684773675897878e-15,   1.535042922567794e-17,  -3.921742048382090e-19,  -8.698810570086383e-21,  -8.893031192570524e-23,
  -2.088311777008680e-25,   9.989062796276737e-27,   1.769039729914636e+00,  -4.104236450588111e-03,  -4.773979668724344e-05,  -3.831648992870019e-07,  -1.299426793764750e-09,
   2.010745006915553e-11,   4.564679075582772e-13,   4.682017287535210e-15,   1.527436628270548e-17,  -3.931204941472593e-19,  -8.701388405046901e-21,  -8.877770383130398e-23,
  -2.052106683175228e-25,   1.002920375110330e-26,   1.769032259840151e+00,  -4.104416200362372e-03,  -4.774101302317523e-05,  -3.831333804423588e-07,  -1.298355322531214e-09,
   2.012281556680740e-11,   4.565342756638117e-13,   4.679795174932222e-15,   1.521308556091689e-17,  -3.938824165231079e-19,  -8.703453825359183e-21,  -8.865461765492869e-23,
  -2.022938741893454e-25,   1.006150305384121e-26,   1.769027323713380e+00,  -4.104534973100274e-03,  -4.774181657230680e-05,  -3.831125489574085e-07,  -1.297647285050617e-09,
   2.013296747678230e-11,   4.565780814235830e-13,   4.678326058347133e-15,   1.517258971314247e-17,  -3.943856872512410e-19,  -8.704813109852947e-21,  -8.857321253160333e-23,
  -2.003664320236925e-25,   1.008282736923403e-26,   1.769024788765390e+00,  -4.104595967745829e-03,  -4.774222917633446e-05,  -3.831018496343689e-07,  -1.297283665154856e-09,
   2.013818055467440e-11,   4.566005625915143e-13,   4.677571354221598e-15,   1.515179234327514e-17,  -3.946440808275129e-19,  -8.705509463907446e-21,  -8.853138485739890e-23,
  -1.993765748262697e-25,   1.009377270446522e-26,   1.769023906451824e+00,  -4.104617197357300e-03,  -4.774237277788618e-05,  -3.830981254206936e-07,  -1.297157102524255e-09,
   2.013999494831458e-11,   4.566083849502566e-13,   4.677308633942681e-15,   1.514455349872820e-17,  -3.947340075199788e-19,  -8.705751565099265e-21,  -8.851682281121803e-23,
  -1.990320422582624e-25,   1.009758141753136e-26,   1.769023766440731e+00,  -4.104620566197924e-03,  -4.774239556504469e-05,  -3.830975344290053e-07,  -1.297137018711567e-09,
   2.014028286447025e-11,   4.566096261360839e-13,   4.677266942020433e-15,   1.514340478764836e-17,  -3.947482771937839e-19,  -8.705789970348665e-21,  -8.851451184694884e-23,
  -1.989773695092499e-25,   1.009818576458181e-26,   1.903932500657640e+00,  -1.832118928068416e-03,  -2.492196989212482e-05,  -2.795302599711283e-07,  -2.611930878874583e-09,
  -1.878548535977676e-11,  -6.474608281785647e-14,   8.794444721357169e-16,   2.351744889969937e-17,   3.321908030349567e-19,   3.352206945389608e-21,   2.164541612031466e-23,
  -2.012824551415734e-26,  -3.274223547986380e-27,   1.903930161277158e+00,  -1.832197607777748e-03,  -2.492343960976010e-05,  -2.795478566037725e-07,  -2.612021193915527e-09,
  -1.878373607138227e-11,  -6.468405767811058e-14,   8.805684947600861e-16,   2.353158607743624e-17,   3.323014616436516e-19,   3.352057830950201e-21,   2.162105652913183e-23,
  -2.065776166798354e-26,  -3.281774925430648e-27,   1.903926033291350e+00,  -1.832336443385759e-03,  -2.492603299081718e-05,  -2.795789048005614e-07,  -2.612180485201107e-09,
  -1.878064762391464e-11,  -6.457458317402006e-14,   8.825521533279449e-16,   2.355653081725989e-17,   3.324966179585095e-19,   3.351792046786997e-21,   2.157802872111297e-23,
  -2.159261458405401e-26,  -3.295101821771706e-27,   1.903921041495589e+00,  -1.832504331745940e-03,  -2.492916900507422e-05,  -2.796164463289422e-07,  -2.612372980798488e-09,
  -1.877690996977371e-11,  -6.444215399369446e-14,   8.849513308492228e-16,   2.358669334861351e-17,   3.327324280895866e-19,   3.351466104439627e-21,   2.152592242350405e-23,
  -2.272392369962034e-26,  -3.311220880135677e-27,   1.903916195346429e+00,  -1.832667322042889e-03,  -2.493221346688767e-05,  -2.796528886030102e-07,  -2.612559725319075e-09,
  -1.877327830404845e-11,  -6.431354017101692e-14,   8.872809513656499e-16,   2.361597364620353e-17,   3.329611650914017e-19,   3.351144914827539e-21,   2.147525829176526e-23,
  -2.382309490225805e-26,  -3.326873191367988e-27,   1.903912291208210e+00,  -1.832798630052974e-03,  -2.493466609834540e-05,  -2.796822443105033e-07,  -2.612710073350878e-09,
  -1.877035037697061e-11,  -6.420989195336310e-14,   8.891580504572472e-16,   2.363956077557590e-17,   3.331453011299550e-19,   3.350882749071738e-21,   2.143438642583554e-23,
  -2.470922890051922e-26,  -3.339485494579773e-27,   1.903909711352973e+00,  -1.832885398566663e-03,  -2.493628677927336e-05,  -2.797016411992189e-07,  -2.612809376123853e-09,
  -1.876841452650152e-11,  -6.414138416086807e-14,   8.903985935616868e-16,   2.365514638663781e-17,   3.332669105036224e-19,   3.350707839651301e-21,   2.140735086781545e-23,
  -2.529509153469448e-26,  -3.347820946880662e-27,   1.903908386452141e+00,  -1.832929959129416e-03,  -2.493711908443918e-05,  -2.797116021698798e-07,  -2.612860359076688e-09,
  -1.876742002566007e-11,  -6.410619628752809e-14,   8.910357303821617e-16,   2.366315023684084e-17,   3.333293427970313e-19,   3.350617497161464e-21,   2.139345810658278e-23,
  -2.559605930207653e-26,  -3.352102053261085e-27,   1.903907925304815e+00,  -1.832945468965413e-03,  -2.493740877714166e-05,  -2.797150691355708e-07,  -2.612878101967538e-09,
  -1.876707382497151e-11,  -6.409394789561754e-14,   8.912575010116986e-16,   2.366593603315162e-17,   3.333510697533221e-19,   3.350585970130851e-21,   2.138862121732572e-23,
  -2.570082969192869e-26,  -3.353592203545989e-27,   1.903907852126921e+00,  -1.832947930168670e-03,  -2.493745474744400e-05,  -2.797156192933141e-07,  -2.612880917415856e-09,
  -1.876701888505238e-11,  -6.409200420034220e-14,   8.912926933989646e-16,   2.366637809984924e-17,   3.333545173713032e-19,   3.350580963308515e-21,   2.138785360379313e-23,
  -2.571745606001868e-26,  -3.353828673290150e-27,   1.981543383864962e+00,  -3.657533153732088e-04,  -5.387415147758852e-06,  -6.967828099934197e-08,  -8.315728169260230e-10,
  -9.337566923837922e-12,  -9.936202103286422e-14,  -1.001962114679473e-15,  -9.511218565619755e-18,  -8.361116039385240e-20,  -6.557747144883488e-22,  -4.138670835623201e-24,
  -1.199359932372531e-26,   2.100548335656642e-28,   1.981542877855177e+00,  -3.657729432478348e-04,  -5.387883697097744e-06,  -6.968705157868003e-08,  -8.317128405162859e-10,
  -9.339544031496380e-12,  -9.938704512416936e-14,  -1.002244856219549e-15,  -9.513987412758515e-18,  -8.363243841084438e-20,  -6.558466889167974e-22,  -4.137085987543985e-24,
  -1.194548386711746e-26,   2.109375987533603e-28,   1.981541984957131e+00,  -3.658075789502669e-04,  -5.388710523894424e-06,  -6.970252891245267e-08,  -8.319599429800636e-10,
  -9.343033121945245e-12,  -9.943120643810027e-14,  -1.002743816461302e-15,  -9.518873332059224e-18,  -8.366997711323982e-20,  -6.559734458629523e-22,  -4.134284230901248e-24,
  -1.186049084246498e-26,   2.124966680914638e-28,   1.981540905194193e+00,  -3.658494642372543e-04,  -5.389710441025361e-06,  -6.972124684226846e-08,  -8.322587907507819e-10,
  -9.347252939661678e-12,  -9.948461685011648e-14,  -1.003347263989492e-15,  -9.524781854996593e-18,  -8.371535788543412e-20,  -6.561263069509486e-22,  -4.130887329915214e-24,
  -1.175755848104171e-26,   2.143843275403330e-28,   1.981539856915057e+00,  -3.658901293363261e-04,  -5.390681257772715e-06,  -6.973942057867465e-08,  -8.325489581351895e-10,
  -9.351350274447608e-12,  -9.953647730904350e-14,  -1.003933184554953e-15,  -9.530518182856271e-18,  -8.375940076708771e-20,  -6.562742671028290e-22,  -4.127580258849790e-24,
  -1.165746807048810e-26,   2.162193664541255e-28,   1.981539012389181e+00,  -3.659228911819633e-04,  -5.391463417170322e-06,  -6.975406303494893e-08,  -8.327827498536470e-10,
  -9.354651613622579e-12,  -9.957826298363189e-14,  -1.004405269155317e-15,  -9.535139605909469e-18,  -8.379487253790400e-20,  -6.563931500951711e-22,  -4.124909371960385e-24,
  -1.157671790616836e-26,   2.176994651127043e-28,   1.981538454319084e+00,  -3.659445408846807e-04,  -5.391980294344290e-06,  -6.976373945455360e-08,  -8.329372532014481e-10,
  -9.356833363527543e-12,  -9.960587791634140e-14,  -1.004717250777055e-15,  -9.538193512455773e-18,  -8.381830743493251e-20,  -6.564715530858380e-22,  -4.123141188716071e-24,
  -1.152330151772423e-26,   2.186783771608741e-28,   1.981538167716445e+00,  -3.659556594322256e-04,  -5.392245747930816e-06,  -6.976870905139532e-08,  -8.330166036133053e-10,
  -9.357953884266119e-12,  -9.962006065092970e-14,  -1.004877479563143e-15,  -9.539761886715355e-18,  -8.383034107048603e-20,  -6.565117695018063e-22,  -4.122232118300641e-24,
  -1.149585166561805e-26,   2.191813704358042e-28,   1.981538067960667e+00,  -3.659595294064978e-04,  -5.392338143460860e-06,  -6.977043881163442e-08,  -8.330442231344282e-10,
  -9.358343905744059e-12,  -9.962499726392299e-14,  -1.004933250457652e-15,  -9.540307781237389e-18,  -8.383452927961675e-20,  -6.565257596658330e-22,  -4.121915545000842e-24,
  -1.148629463001969e-26,   2.193564856563552e-28,   1.981538052130747e+00,  -3.659601435210590e-04,  -5.392352805452903e-06,  -6.977071330297152e-08,  -8.330486060139963e-10,
  -9.358405797444517e-12,  -9.962578064507310e-14,  -1.004942100615884e-15,  -9.540394407535736e-18,  -8.383519388085184e-20,  -6.565279793547723e-22,  -4.121865301438343e-24,
  -1.148477792415391e-26,   2.193842761098711e-28,   7.885209403049700e-03,  -1.570627017361006e-04,   2.336904882122042e-06,  -3.074711184745316e-08,   3.767110896962025e-10,
  -4.394913852971905e-12,   4.935588078980077e-14,  -5.365911303706627e-16,   5.660964519436013e-18,  -5.797586156918234e-20,   5.753207829793252e-22,  -5.510348279724214e-24,
   5.054722066325708e-26,  -4.380981234921554e-28,   7.885428913627304e-03,  -1.570713638904835e-04,   2.337117174562785e-06,  -3.075124098255302e-08,   3.767806726749332e-10,
  -4.395973390555578e-12,   4.937079115919780e-14,  -5.367875429410702e-16,   5.663401756864352e-18,  -5.800439948059319e-20,   5.756349271502888e-22,  -5.513564857011483e-24,
   5.057707301683560e-26,  -4.383336046083023e-28,   7.885816259728284e-03,  -1.570866493441019e-04,   2.337491799782775e-06,  -3.075852771503921e-08,   3.769034700040755e-10,
  -4.397843276063797e-12,   4.939710594849010e-14,  -5.371341944136577e-16,   5.667703379401197e-18,  -5.805476857235251e-20,   5.761893897556037e-22,  -5.519241957787325e-24,
   5.062975648708634e-26,  -4.387490784821456e-28,   7.886284670453436e-03,  -1.571051342909695e-04,   2.337944854945465e-06,  -3.076734028878800e-08,   3.770519869538425e-10,
  -4.400104898400510e-12,   4.942893495439237e-14,  -5.375535027858302e-16,   5.672906787050417e-18,  -5.811569843572983e-20,   5.768601081205453e-22,  -5.526109154903136e-24,
   5.069347642221214e-26,  -4.392514117829102e-28,   7.886739424466924e-03,  -1.571230808467319e-04,   2.338384729970394e-06,  -3.077589682709380e-08,   3.771961951239941e-10,
  -4.402301004459487e-12,   4.945984330503061e-14,  -5.379607001451686e-16,   5.677960092110216e-18,  -5.817487220328076e-20,   5.775114982878631e-22,  -5.532778209606572e-24,
   5.075534982214715e-26,  -4.397390027676167e-28,   7.887105789158983e-03,  -1.571375395691775e-04,   2.338739128354727e-06,  -3.078279089803437e-08,   3.773123891974454e-10,
  -4.404070561864678e-12,   4.948474933711600e-14,  -5.382888334106583e-16,   5.682032349948010e-18,  -5.822255909988889e-20,   5.780364420617922e-22,  -5.538152503462583e-24,
   5.080520510123292e-26,  -4.401317525133876e-28,   7.887347886592445e-03,  -1.571470942281425e-04,   2.338973328464943e-06,  -3.078734688410078e-08,   3.773891788696001e-10,
  -4.405240051188026e-12,   4.950121006423296e-14,  -5.385057071792298e-16,   5.684723901684558e-18,  -5.825407821337822e-20,   5.783834097347691e-22,  -5.541704617536542e-24,
   5.083815390073325e-26,  -4.403912513166689e-28,   7.887472218354228e-03,  -1.571520011860169e-04,   2.339093607604308e-06,  -3.078968675768792e-08,   3.774286173493810e-10,
  -4.405840700941293e-12,   4.950966444501652e-14,  -5.386170974391689e-16,   5.686106351467347e-18,  -5.827026740346664e-20,   5.785616233645400e-22,  -5.543529069109391e-24,
   5.085507632990613e-26,  -4.405245091590922e-28,   7.887515493663335e-03,  -1.571537091268276e-04,   2.339135472843624e-06,  -3.079050119707318e-08,   3.774423448002415e-10,
  -4.406049772304791e-12,   4.951260723044227e-14,  -5.386558702596951e-16,   5.686587559078521e-18,  -5.827590261601892e-20,   5.786236568878161e-22,  -5.544164129334987e-24,
   5.086096659800865e-26,  -4.405708896214894e-28,   7.887522360882668e-03,  -1.571539801548977e-04,   2.339142116327211e-06,  -3.079063043857171e-08,   3.774445231826451e-10,
  -4.406082949512075e-12,   4.951307421759316e-14,  -5.386620230872356e-16,   5.686663921680220e-18,  -5.827679686642351e-20,   5.786335009737767e-22,  -5.544264906694941e-24,
   5.086190131485446e-26,  -4.405782495074704e-28,   7.027880918278682e-02,  -1.357755722050261e-03,   1.897306760918773e-05,  -2.236850102644703e-07,   2.290038895803683e-09,
  -1.992525840758440e-11,   1.325733301521943e-13,  -3.417799491068477e-16,  -8.240831683942102e-18,   1.953686919147421e-19,  -2.773310221249271e-21,   3.001342433524796e-23,
  -2.423480861888242e-25,   9.712202609954046e-28,   7.028059049239835e-02,  -1.357818699153551e-03,   1.897435680427501e-05,  -2.237036957157059e-07,   2.290225067613968e-09,
  -1.992592072407283e-11,   1.325514552376198e-13,  -3.411165388665583e-16,  -8.252579592719391e-18,   1.955237154673164e-19,  -2.774804767158634e-21,   3.002032195667334e-23,
  -2.422412909488906e-25,   9.675260936668805e-28,   7.028373373966505e-02,  -1.357929827518252e-03,   1.897663169440006e-05,  -2.237366669904171e-07,   2.290553545602090e-09,
  -1.992708832810621e-11,   1.325128315053990e-13,  -3.399455154804160e-16,  -8.273314084566766e-18,   1.957972856739700e-19,  -2.777441374628528e-21,   3.003247086091959e-23,
  -2.420523873049962e-25,   9.610006137595406e-28,   7.028753475568737e-02,  -1.358064212413881e-03,   1.897938266096136e-05,  -2.237765370635690e-07,   2.290950701877875e-09,
  -1.992849839299370e-11,   1.324660844683852e-13,  -3.385287757858594e-16,  -8.298395185797275e-18,   1.961281385792250e-19,  -2.780628662294518e-21,   3.004712380747995e-23,
  -2.418231752798831e-25,   9.530978872153687e-28,   7.029122489201615e-02,  -1.358194678578149e-03,   1.898205340363408e-05,  -2.238152431355870e-07,   2.291336209452919e-09,
  -1.992986535897636e-11,   1.324206584170631e-13,  -3.371526693951274e-16,  -8.322752627306716e-18,   1.964493759670186e-19,  -2.783721853987244e-21,   3.006130918320393e-23,
  -2.415998348401016e-25,   9.454134387804881e-28,   7.029419774379772e-02,  -1.358299785893127e-03,   1.898420502806782e-05,  -2.238464248847348e-07,   2.291646737180450e-09,
  -1.993096520680080e-11,   1.323840316485727e-13,  -3.360435513826768e-16,  -8.342381214915046e-18,   1.967081971953176e-19,  -2.786212991120060e-21,   3.007270844489493e-23,
  -2.414193229704814e-25,   9.392139037556838e-28,   7.029616221296286e-02,  -1.358369241612595e-03,   1.898562683646607e-05,  -2.238670295426849e-07,   2.291851912616676e-09,
  -1.993169129951401e-11,   1.323598135968900e-13,  -3.353103992881627e-16,  -8.355354642273928e-18,   1.968792395329840e-19,  -2.787858747885059e-21,   3.008022701072272e-23,
  -2.412997540863354e-25,   9.351129326743365e-28,   7.029717108094713e-02,  -1.358404911276127e-03,   1.898635701959324e-05,  -2.238776111173786e-07,   2.291957275146786e-09,
  -1.993206397651036e-11,   1.323473716016167e-13,  -3.349338081332332e-16,  -8.362018109468693e-18,   1.969670834823137e-19,  -2.788703816755467e-21,   3.008408386446482e-23,
  -2.412382600732788e-25,   9.330055179597057e-28,   7.029752222972424e-02,  -1.358417326561031e-03,   1.898661116914162e-05,  -2.238812941467830e-07,   2.291993946764240e-09,
  -1.993219365729673e-11,   1.323430402763460e-13,  -3.348027190026442e-16,  -8.364337548085741e-18,   1.969976592524556e-19,  -2.788997933832362e-21,   3.008542559462742e-23,
  -2.412168422407310e-25,   9.322717948710085e-28,   7.029757795234320e-02,  -1.358419296702018e-03,   1.898665149929932e-05,  -2.238818785935583e-07,   2.291999766008037e-09,
  -1.993221423429173e-11,   1.323423529178906e-13,  -3.347819163396593e-16,  -8.364705618543313e-18,   1.970025112478066e-19,  -2.789044605360134e-21,   3.008563847629249e-23,
  -2.412134428477937e-25,   9.321553527676452e-28,   1.914245577501883e-01,  -3.474707452423201e-03,   4.241715326541215e-05,  -3.812986880695938e-07,   2.065975209364305e-09,
   6.165550855937289e-12,  -3.288763275380093e-13,   4.658797537534862e-15,  -3.629251523095431e-17,  -4.705220087829462e-22,   5.011526724340452e-21,  -8.788452239687467e-23,
   8.303106970703294e-25,  -1.842126641412669e-27,   1.914285366780592e-01,  -3.474814671820657e-03,   4.241831275670449e-05,  -3.812928307634290e-07,   2.065511607204705e-09,
   6.174722605687647e-12,  -3.289711546731057e-13,   4.658784122465954e-15,  -3.627120908610671e-17,  -9.241520294536810e-22,   5.016627140584647e-21,  -8.789693067684901e-23,
   8.295119963229602e-25,  -1.822888051112540e-27,   1.914355576470516e-01,  -3.475003860784343e-03,   4.242035848508567e-05,  -3.812824884638593e-07,   2.064693465647462e-09,
   6.190906275352946e-12,  -3.291384330778562e-13,   4.658759206309340e-15,  -3.623359659678122e-17,  -1.724640276451177e-21,   5.025622869408285e-21,  -8.791871079798049e-23,
   8.281010316150232e-25,  -1.788933126939344e-27,   1.914440476280982e-01,  -3.475232627797923e-03,   4.242283183977302e-05,  -3.812699705250127e-07,   2.063703975589588e-09,
   6.210475694130903e-12,  -3.293406301913156e-13,   4.658726954407136e-15,  -3.618808540890362e-17,  -2.692685744326291e-21,   5.036493713651865e-21,  -8.794485231548560e-23,
   8.263920748764536e-25,  -1.747860652329662e-27,   1.914522897121425e-01,  -3.475454708442006e-03,   4.242523255063842e-05,  -3.812578058444879e-07,   2.062743202560853e-09,
   6.229473295655988e-12,  -3.295368382279996e-13,   4.658693421493218e-15,  -3.614387277916322e-17,  -3.632537718019700e-21,   5.047039721677429e-21,  -8.797002555543127e-23,
   8.247301153306753e-25,  -1.707973790281318e-27,   1.914589295406372e-01,  -3.475633611991179e-03,   4.242716626047274e-05,  -3.812479971926267e-07,   2.061969077901876e-09,
   6.244777478283086e-12,  -3.296948425099978e-13,   4.658664814724096e-15,  -3.610823334474132e-17,  -4.389734571092446e-21,   5.055530270841518e-21,  -8.799015824246450e-23,
   8.233891612393334e-25,  -1.675831163575164e-27,   1.914633170762357e-01,  -3.475751827422166e-03,   4.242844388847965e-05,  -3.812415114312772e-07,   2.061457482365620e-09,
   6.254890190377008e-12,  -3.297992203405837e-13,   4.658645131827488e-15,  -3.608467251886969e-17,  -4.890108138671287e-21,   5.061138137256135e-21,  -8.800338979793077e-23,
   8.225020543382970e-25,  -1.654586866138490e-27,   1.914655703027759e-01,  -3.475812536440274e-03,   4.242909997045820e-05,  -3.812381793282671e-07,   2.061194732628590e-09,
   6.260083545884317e-12,  -3.298528145089826e-13,   4.658634782472383e-15,  -3.607256953029360e-17,  -5.147083585490081e-21,   5.064017259890531e-21,  -8.801016263811727e-23,
   8.220461645697705e-25,  -1.643675353039511e-27,   1.914663545616258e-01,  -3.475833666728248e-03,   4.242932831925003e-05,  -3.812370193437057e-07,   2.061103276841372e-09,
   6.261891139858804e-12,  -3.298714670422759e-13,   4.658631141877243e-15,  -3.606835643670317e-17,  -5.236527781528392e-21,   5.065019239862337e-21,  -8.801251645320722e-23,
   8.218874373543977e-25,  -1.639877254537231e-27,   1.914664790128334e-01,  -3.475837019811957e-03,   4.242936455474751e-05,  -3.812368352598964e-07,   2.061088763909169e-09,
   6.262177980081753e-12,  -3.298744268755853e-13,   4.658630562341599e-15,  -3.606768785125469e-17,  -5.250721416583454e-21,   5.065178234348118e-21,  -8.801288980347150e-23,
   8.218622471290524e-25,  -1.639274536919730e-27,   3.641776821104630e-01,  -6.000312085675288e-03,   5.800581784929079e-05,  -2.608848325607521e-07,  -2.226635781915682e-09,
   5.635476617921631e-11,  -4.517300484910401e-13,  -1.539005115864457e-15,   8.488356450715750e-17,  -9.463254041370633e-19,   2.655824444672825e-22,   1.455165065817241e-22,
  -2.133324734080477e-24,   6.938021371909543e-27,   3.641831176236921e-01,  -6.000385273394426e-03,   5.800456179969748e-05,  -2.608320260199183e-07,  -2.227268390838056e-09,
   5.635168582267259e-11,  -4.515072163975077e-13,  -1.542179342974581e-15,   8.488426431749595e-17,  -9.455732318653009e-19,   2.524849070554688e-22,   1.455645776969059e-22,
  -2.131118351543709e-24,   6.889694505742843e-27,   3.641927085762794e-01,  -6.000514402208098e-03,   5.800234519171649e-05,  -2.607388504098206e-07,  -2.228384384484932e-09,
   5.634624541400796e-11,  -4.511140244183795e-13,  -1.547778251501163e-15,   8.488545431128737e-17,  -9.442458132480349e-19,   2.293852187727362e-22,   1.456491132406486e-22,
  -2.127223002205908e-24,   6.804466234654630e-27,   3.642043058948953e-01,  -6.000670525572524e-03,   5.799966435346089e-05,  -2.606261854964864e-07,  -2.229733421558265e-09,
   5.633965816936601e-11,  -4.506385704194406e-13,  -1.554544989899119e-15,   8.488681684740577e-17,  -9.426403463061558e-19,   2.014718010972946e-22,   1.457508458689559e-22,
  -2.122509040862269e-24,   6.701484528101523e-27,   3.642155641995863e-01,  -6.000822065884937e-03,   5.799706132676050e-05,  -2.605168165723186e-07,  -2.231042588530038e-09,
   5.633325433689634e-11,  -4.501770058370581e-13,  -1.561110334132327e-15,   8.488805958404336e-17,  -9.410814337131070e-19,   1.743938153033672e-22,   1.458490946654453e-22,
  -2.117928981707345e-24,   6.601592650731179e-27,   3.642246336205672e-01,  -6.000944129351734e-03,   5.799496399314266e-05,  -2.604287134177455e-07,  -2.232096910506268e-09,
   5.632808901091153e-11,  -4.498051739872518e-13,  -1.566396647103330e-15,   8.488900342761533e-17,  -9.398253417617209e-19,   1.525943904257784e-22,   1.459278763124962e-22,
  -2.114236609932364e-24,   6.521179150939223e-27,   3.642306264722212e-01,  -6.001024779157323e-03,   5.799357793172918e-05,  -2.603704979064596e-07,  -2.232793428111190e-09,
   5.632467268266505e-11,  -4.495594734509870e-13,  -1.569888454343629e-15,   8.488959906197044e-17,  -9.389952153717669e-19,   1.381966978401948e-22,   1.459797545356912e-22,
  -2.111795419564999e-24,   6.468071819201711e-27,   3.642337040696855e-01,  -6.001066194353850e-03,   5.799286606698913e-05,  -2.603406019149727e-07,  -2.233151073878398e-09,
   5.632291725358640e-11,  -4.494332942659356e-13,  -1.571681264167021e-15,   8.488989627890414e-17,  -9.385688677117208e-19,   1.308049526904975e-22,   1.460063410541636e-22,
  -2.110541338614784e-24,   6.440807476306399e-27,   3.642347752527043e-01,  -6.001080608920124e-03,   5.799261828705109e-05,  -2.603301964144590e-07,  -2.233275547906293e-09,
   5.632230610424956e-11,  -4.493893764131427e-13,  -1.572305204317834e-15,   8.488999834791503e-17,  -9.384204674541100e-19,   1.282325318494620e-22,   1.460155859119103e-22,
  -2.110104778571967e-24,   6.431319275704880e-27,   3.642349452345562e-01,  -6.001082896295604e-03,   5.799257896736509e-05,  -2.603285452083053e-07,  -2.233295299847256e-09,
   5.632220911585310e-11,  -4.493824072532451e-13,  -1.572404212001373e-15,   8.489001447934879e-17,  -9.383969180899235e-19,   1.278243404099200e-22,   1.460170525246587e-22,
  -2.110035499388356e-24,   6.429813695589277e-27,   5.781765521806417e-01,  -8.316414398420341e-03,   5.393692712397295e-05,   1.502527336505644e-07,  -6.474583204882542e-09,
   3.697405153862845e-11,   5.339733324560947e-13,  -1.015953801900030e-14,   1.291922213214853e-17,   1.496303329070972e-18,  -1.650382865419387e-20,  -9.374216159279915e-23,
   3.792784299557722e-24,  -2.100619484077526e-26,   5.781816014552655e-01,  -8.316372018453510e-03,   5.393328941898533e-05,   1.502872293405821e-07,  -6.473831924309226e-09,
   3.695413008247038e-11,   5.340058251000218e-13,  -1.015450077847770e-14,   1.285034432843574e-17,   1.495814201942801e-18,  -1.648054858427852e-20,  -9.389117234703999e-23,
   3.788732448743057e-24,  -2.092265242570452e-26,   5.781905107031513e-01,  -8.316297230475599e-03,   5.392687097487103e-05,   1.503480823699343e-07,  -6.472506241308181e-09,
   3.691898641545644e-11,   5.340630123407465e-13,  -1.014561383453308e-14,   1.272888804066491e-17,   1.494950509455815e-18,  -1.643949091427731e-20,  -9.415360971856734e-23,
   3.781583109729263e-24,  -2.077540478331395e-26,   5.782012833892421e-01,  -8.316206782654491e-03,   5.391911030948499e-05,   1.504216406611574e-07,  -6.470903148949293e-09,
   3.687650405209327e-11,   5.341319140155355e-13,  -1.013486994350676e-14,   1.258215761370083e-17,   1.493905067580100e-18,  -1.638987828913798e-20,  -9.447010938417527e-23,
   3.772938429867686e-24,  -2.059763131102078e-26,   5.782117408325472e-01,  -8.316118963446971e-03,   5.391157700333870e-05,   1.504930227208006e-07,  -6.469346829532507e-09,
   3.683527728962652e-11,   5.341985411837194e-13,  -1.012444236647122e-14,   1.243985641702179e-17,   1.492889066998962e-18,  -1.634175159828435e-20,  -9.477648047136233e-23,
   3.764546731892733e-24,  -2.042534489341951e-26,   5.782201648590377e-01,  -8.316048207386215e-03,   5.390550870943393e-05,   1.505505077978949e-07,  -6.468093032304965e-09,
   3.680207584816637e-11,   5.342520279870527e-13,  -1.011604377122973e-14,   1.232532223896837e-17,   1.492069800614745e-18,  -1.630300743228246e-20,  -9.502265818010165e-23,
   3.757786789994919e-24,  -2.028676300442359e-26,   5.782257311324311e-01,  -8.316001448122222e-03,   5.390149910414777e-05,   1.505884834244350e-07,  -6.467264522684482e-09,
   3.678014197082505e-11,   5.342872795092712e-13,  -1.011049497423845e-14,   1.224968992861318e-17,   1.491528057921714e-18,  -1.627741874198436e-20,  -9.518501938348221e-23,
   3.753320091678311e-24,  -2.019529324057927e-26,   5.782285896265796e-01,  -8.315977433481588e-03,   5.389944004654138e-05,   1.506079827916976e-07,  -6.466839036325402e-09,
   3.676887943501285e-11,   5.343053545320780e-13,  -1.010764566293644e-14,   1.221086452633912e-17,   1.491249727843802e-18,  -1.626428167258256e-20,  -9.526830423163505e-23,
   3.751026275782904e-24,  -2.014835088454078e-26,   5.782295845431161e-01,  -8.315969074723831e-03,   5.389872338328181e-05,   1.506147692579701e-07,  -6.466690940783839e-09,
   3.676495965458040e-11,   5.343116412014180e-13,  -1.010665397567623e-14,   1.219735344216485e-17,   1.491152833530933e-18,  -1.625970982370351e-20,  -9.529727710276002e-23,
   3.750227899770093e-24,  -2.013201722046786e-26,   5.782297424222633e-01,  -8.315967748292599e-03,   5.389860965919563e-05,   1.506158461545298e-07,  -6.466667440007950e-09,
   3.676433765119712e-11,   5.343126385952734e-13,  -1.010649661054233e-14,   1.219520953561235e-17,   1.491137456837068e-18,  -1.625898436408457e-20,  -9.530187397769378e-23,
   3.750101208855185e-24,  -2.012942553278648e-26,   8.202951820063363e-01,  -9.838426500274850e-03,   2.793797940105614e-05,   5.824667348471568e-07,  -4.938593294108434e-09,
  -5.306512045424397e-11,   8.953122263148698e-13,   4.297394728765707e-15,  -1.606711674214908e-16,  -2.813241858226636e-20,   2.785207064852228e-20,  -1.178433042809320e-22,
  -4.544732875851488e-24,   4.234929824316361e-26,   8.202977956245641e-01,  -9.838262856791033e-03,   2.793520852389536e-05,   5.824170575110292e-07,  -4.937339219280178e-09,
  -5.305666176614911e-11,   8.948928708555409e-13,   4.297284296185422e-15,  -1.605545612081237e-16,  -2.872826391326794e-20,   2.782421076272939e-20,  -1.175395495867504e-22,
  -4.539100167748345e-24,   4.224157419746842e-26,   8.203024071847625e-01,  -9.837974116631792e-03,   2.793031983982089e-05,   5.823294075151674e-07,  -4.935126862981441e-09,
  -5.304173646207817e-11,   8.941531598506445e-13,   4.297087809868317e-15,  -1.603489030337182e-16,  -2.977837508739399e-20,   2.777507982327534e-20,  -1.170042066525644e-22,
  -4.529167230497392e-24,   4.205174716087060e-26,   8.203079831741108e-01,  -9.837624988284785e-03,   2.792440936641632e-05,   5.822234311932377e-07,  -4.932452473734390e-09,
  -5.302368894067645e-11,   8.932591166334961e-13,   4.296847445925216e-15,  -1.601003814400331e-16,  -3.104602173430850e-20,   2.771571834357943e-20,  -1.163579493688942e-22,
  -4.517166555209740e-24,   4.182263845553658e-26,   8.203133958726537e-01,  -9.837286080778791e-03,   2.791867260260519e-05,   5.821205627223867e-07,  -4.929857076816290e-09,
  -5.300616905221602e-11,   8.923916379826015e-13,   4.296611206463728e-15,  -1.598592910292739e-16,  -3.227437259273797e-20,   2.765814167072268e-20,  -1.157317089906491e-22,
  -4.505527330698946e-24,   4.160067566525687e-26,   8.203177560032685e-01,  -9.837013075807255e-03,   2.791405187201929e-05,   5.820377014653688e-07,  -4.927766870430222e-09,
  -5.299205549803206e-11,   8.916931257656735e-13,   4.296418820532079e-15,  -1.596651935105550e-16,  -3.326229945542831e-20,   2.761179476172022e-20,  -1.152280301889651e-22,
  -4.496158675467854e-24,   4.142218874736654e-26,   8.203206369682360e-01,  -9.836832686088554e-03,   2.791099893378627e-05,   5.819829522599436e-07,  -4.926385998680377e-09,
  -5.298272963106297e-11,   8.912317166457603e-13,   4.296290680468812e-15,  -1.595369969310117e-16,  -3.391431305025281e-20,   2.758118722267285e-20,  -1.148956055616872e-22,
  -4.489971830010936e-24,   4.130440595739483e-26,   8.203221164408782e-01,  -9.836740049533284e-03,   2.790943121469800e-05,   5.819548371718041e-07,  -4.925676947540006e-09,
  -5.297794038884303e-11,   8.909948090052064e-13,   4.296224560741384e-15,  -1.594711802811194e-16,  -3.424890878369796e-20,   2.756547425071080e-20,  -1.147250124150286e-22,
  -4.486795762295085e-24,   4.124396774345217e-26,   8.203226313783978e-01,  -9.836707806881577e-03,   2.790888557334663e-05,   5.819450516566690e-07,  -4.925430170534109e-09,
  -5.297627345508392e-11,   8.909123587752915e-13,   4.296201497243783e-15,  -1.594482751266501e-16,  -3.436532898937296e-20,   2.756000607663390e-20,  -1.146656554518049e-22,
  -4.485690489639891e-24,   4.122293944887476e-26,   8.203227130915826e-01,  -9.836702690433406e-03,   2.790879898841599e-05,   5.819434988396213e-07,  -4.925391011121521e-09,
  -5.297600893593191e-11,   8.908992754221900e-13,   4.296197835014768e-15,  -1.594446405333329e-16,  -3.438380142602469e-20,   2.755913839400191e-20,  -1.146562372468805e-22,
  -4.485515106959195e-24,   4.121960291737420e-26,   1.075281230368069e+00,  -1.016191368577890e-02,  -1.070089041353549e-05,   6.948711432733420e-07,   1.914914672718280e-09,
  -8.480200671412455e-11,  -3.758208069735253e-13,   1.246410254812592e-14,   7.700858398140177e-17,  -2.009642432864757e-18,  -1.620830142356336e-20,   3.411095410615569e-22,
   3.464698843471594e-24,  -5.968576553074859e-26,   1.075280229317821e+00,  -1.016171853291584e-02,  -1.069981624464714e-05,   6.947918468567412e-07,   1.914388547638697e-09,
  -8.477757512238217e-11,  -3.756200559739604e-13,   1.245736536531348e-14,   7.694088386410766e-17,  -2.007900318239414e-18,  -1.618715361056364e-20,   3.406787386905384e-22,
   3.458422994788637e-24,  -5.958312032121622e-26,   1.075278463030401e+00,  -1.016137420070973e-02,  -1.069792109676299e-05,   6.946519456686475e-07,   1.913460420612240e-09,
  -8.473447595497661e-11,  -3.752659717420559e-13,   1.244548226795919e-14,   7.682149821989553e-17,  -2.004828129699585e-18,  -1.614986939507822e-20,   3.399191888165478e-22,
   3.447361525515605e-24,  -5.940218946316905e-26,   1.075276327355718e+00,  -1.016095786137047e-02,  -1.069562987287139e-05,   6.944828073430743e-07,   1.912338509767051e-09,
  -8.468237832370891e-11,  -3.748380548429765e-13,   1.243112122563082e-14,   7.667725898933241e-17,  -2.001116274110943e-18,  -1.610483847717191e-20,   3.390017683860180e-22,
   3.434006939727197e-24,  -5.918372658704390e-26,   1.075274254225183e+00,  -1.016055371864193e-02,  -1.069340602077503e-05,   6.943186439583378e-07,   1.911249786684015e-09,
  -8.463182204646457e-11,  -3.744228975144763e-13,   1.241718827944482e-14,   7.653736292538748e-17,  -1.997516079117727e-18,  -1.606117926843541e-20,   3.381122357909887e-22,
   3.421064566664441e-24,  -5.897198201394426e-26,   1.075272584242407e+00,  -1.016022816965217e-02,  -1.069161482132610e-05,   6.941864198343956e-07,   1.910373018146446e-09,
  -8.459110831999788e-11,  -3.740886362071161e-13,   1.240597017003813e-14,   7.642475675451875e-17,  -1.994618107353708e-18,  -1.602604808255647e-20,   3.373964153789345e-22,
   3.410654122768019e-24,  -5.880164339097939e-26,   1.075271480798564e+00,  -1.016001306400642e-02,  -1.069043137886965e-05,   6.940990601221862e-07,   1.909793808349396e-09,
  -8.456421214678522e-11,  -3.738678523612909e-13,   1.239856042420190e-14,   7.635039375834457e-17,  -1.992704304014739e-18,  -1.600285364180806e-20,   3.369237934204561e-22,
   3.403782797397253e-24,  -5.868920409196000e-26,   1.075270914143131e+00,  -1.015990260046772e-02,  -1.068982367099719e-05,   6.940542003272612e-07,   1.909496400692022e-09,
  -8.455040175641942e-11,  -3.737544971396180e-13,   1.239475608681762e-14,   7.631221876074812e-17,  -1.991721822141344e-18,  -1.599094825138110e-20,   3.366811967101553e-22,
   3.400256425932864e-24,  -5.863149742496532e-26,   1.075270716916031e+00,  -1.015986415317911e-02,  -1.068961216010210e-05,   6.940385870374809e-07,   1.909392892283165e-09,
  -8.454559525492478e-11,  -3.737150472492389e-13,   1.239343209905603e-14,   7.629893382503678e-17,  -1.991379915672479e-18,  -1.598680543643529e-20,   3.365967773693099e-22,
   3.399029419264447e-24,  -5.861141786693507e-26,   1.075270685618926e+00,  -1.015985805215039e-02,  -1.068957859658709e-05,   6.940361094506078e-07,   1.909376467258886e-09,
  -8.454483254506309e-11,  -3.737087873053642e-13,   1.239322200739658e-14,   7.629682579416842e-17,  -1.991325662451827e-18,  -1.598614807457539e-20,   3.365833820685816e-22,
   3.398834728204323e-24,  -5.860823179177491e-26,   1.326591619540743e+00,  -9.176626282529958e-03,  -4.535694273667132e-05,   3.819828412724626e-07,   6.898605109489287e-09,
  -4.386816335455825e-12,  -9.892498092551742e-13,  -5.921394423634273e-15,   1.179147498885128e-16,   1.806427100987147e-18,  -7.756008067767924e-21,  -3.776075905921527e-22,
  -1.297606621537152e-24,   6.102382119955639e-26,   1.326587375109587e+00,  -9.176518864915859e-03,  -4.535307010875168e-05,   3.819786315277307e-07,   6.897217630973077e-09,
  -4.398377993942572e-12,  -9.889409652954700e-13,  -5.915347982798306e-15,   1.178817810480936e-16,   1.804497265544381e-18,  -7.763770195271489e-21,  -3.771649750744773e-22,
  -1.291828376498329e-24,   6.095821575092856e-26,   1.326579886038161e+00,  -9.176329325822500e-03,  -4.534623742941517e-05,   3.819711945841832e-07,   6.894769756095339e-09,
  -4.418769069321005e-12,  -9.883960757715156e-13,  -5.904684225276924e-15,   1.178235806206045e-16,   1.801093892250991e-18,  -7.777437679486914e-21,  -3.763843630758472e-22,
  -1.281646614366066e-24,   6.084245175155429e-26,   1.326570830674443e+00,  -9.176100134792156e-03,  -4.533797636070288e-05,   3.819621867823032e-07,   6.891810361122042e-09,
  -4.443409722311778e-12,  -9.877373097865894e-13,  -5.891798499293039e-15,   1.177531591125215e-16,   1.796981653092060e-18,  -7.793915298521661e-21,  -3.754411037733740e-22,
  -1.269358639711114e-24,   6.070246525919136e-26,   1.326562040409184e+00,  -9.175877641854046e-03,  -4.532995778917224e-05,   3.819534264938396e-07,   6.888938061505665e-09,
  -4.467313219423027e-12,  -9.870979171443981e-13,  -5.879298683553374e-15,   1.176847481682394e-16,   1.792992866202457e-18,  -7.809859974401968e-21,  -3.745261004300411e-22,
  -1.257454708152658e-24,   6.056656551717606e-26,   1.326554959461997e+00,  -9.175698405689298e-03,  -4.532349894246397e-05,   3.819463580961586e-07,   6.886624625484161e-09,
  -4.486557231338100e-12,  -9.865829210401187e-13,  -5.869235743679222e-15,   1.176296036129674e-16,   1.789781917439994e-18,  -7.822667933503785e-21,  -3.737894846520493e-22,
  -1.247882963664447e-24,   6.045708432202098e-26,   1.326550280682419e+00,  -9.175579970238474e-03,  -4.531923144829306e-05,   3.819416819315262e-07,   6.885096169070978e-09,
  -4.499267294389791e-12,  -9.862426650125326e-13,  -5.862589635567443e-15,   1.175931486520464e-16,   1.787661337789149e-18,  -7.831113172389329e-21,  -3.733029864018601e-22,
  -1.241566885623394e-24,   6.038474014366674e-26,   1.326547877962192e+00,  -9.175519148157497e-03,  -4.531704000851062e-05,   3.819392787987560e-07,   6.884311301879131e-09,
  -4.505792653307423e-12,  -9.860679409412821e-13,  -5.859177562352368e-15,   1.175744222121353e-16,   1.786572676735901e-18,  -7.835444633708449e-21,  -3.730532218351225e-22,
  -1.238325984802080e-24,   6.034758766997681e-26,   1.326547041682480e+00,  -9.175497978505469e-03,  -4.531627727735364e-05,   3.819384420960215e-07,   6.884038132540119e-09,
  -4.508063567108476e-12,  -9.860071288062776e-13,  -5.857990121592259e-15,   1.175679034960417e-16,   1.786193815283139e-18,  -7.836951351598891e-21,  -3.729663010201336e-22,
  -1.237198390472284e-24,   6.033465636891606e-26,   1.326546908976838e+00,  -9.175494619174683e-03,  -4.531615624335057e-05,   3.819383093099863e-07,   6.883994784844421e-09,
  -4.508423915748330e-12,  -9.859974788613766e-13,  -5.857801698814551e-15,   1.175668690272643e-16,   1.786133697894007e-18,  -7.837190404880456e-21,  -3.729525084549803e-22,
  -1.237019477233866e-24,   6.033260434755330e-26,   1.557418296186375e+00,  -7.113820319234266e-03,  -6.090389722538247e-05,  -1.107608261447043e-07,   4.842334759310065e-09,
   6.562380799345991e-11,   9.221143322611600e-14,  -8.419341957096309e-15,  -1.139178787732527e-16,  -2.600302326201658e-20,   1.857989960594232e-20,   2.346299533902176e-22,
  -3.124196041366749e-25,  -4.583840019794569e-26,   1.557412591926534e+00,  -7.113851254475802e-03,  -6.090117270721964e-05,  -1.106994433162042e-07,   4.842460916677604e-09,
   6.560723161570899e-11,   9.191401657246276e-14,  -8.419398570284510e-15,  -1.138395647032393e-16,  -2.480621272638592e-20,   1.857776263154916e-20,   2.342957450421468e-22,
  -3.168331559620531e-25,  -4.582073932804902e-26,   1.557402526877898e+00,  -7.113905826185592e-03,  -6.089636519512105e-05,  -1.105911449826152e-07,   4.842683183944555e-09,
   6.557798226065969e-11,   9.138938729021917e-14,  -8.419495190788605e-15,  -1.137013858009800e-16,  -2.269582167755105e-20,   1.857396980721165e-20,   2.337061357826074e-22,
  -3.246116352090487e-25,  -4.578945454727589e-26,   1.557390356467510e+00,  -7.113971790992956e-03,  -6.089055180314506e-05,  -1.104602110207802e-07,   4.842951373336506e-09,
   6.554261350246417e-11,   9.075528483420662e-14,  -8.419606444912431e-15,  -1.135343112465885e-16,  -2.014630102775669e-20,   1.856934583419663e-20,   2.329933562704423e-22,
  -3.340015986097909e-25,  -4.575141710377478e-26,   1.557378542014445e+00,  -7.114035803474191e-03,  -6.088490816142242e-05,  -1.103331251538736e-07,   4.843211121258190e-09,
   6.550827799732733e-11,   9.014000745284438e-14,  -8.419708608081505e-15,  -1.133721316842694e-16,  -1.767376950486886e-20,   1.856481757610656e-20,   2.323015937952756e-22,
  -3.431006132159333e-25,  -4.571427404022974e-26,   1.557369024710279e+00,  -7.114087353177476e-03,  -6.088036164446868e-05,  -1.102307625940307e-07,   4.843419936943389e-09,
   6.548061767318279e-11,   8.964456172123758e-14,  -8.419786727134090e-15,  -1.132414916735983e-16,  -1.568372050372612e-20,   1.856114147975991e-20,   2.317444566203435e-22,
  -3.504187717787270e-25,  -4.568419687590560e-26,   1.557362735975267e+00,  -7.114121407530115e-03,  -6.087735735156224e-05,  -1.101631311512770e-07,   4.843557706245079e-09,
   6.546234018208291e-11,   8.931728464935113e-14,  -8.419836300017344e-15,  -1.131551718674008e-16,  -1.436960801114069e-20,   1.855869858957441e-20,   2.313763778902981e-22,
  -3.552486609338968e-25,  -4.566424654036070e-26,   1.557359506449148e+00,  -7.114138893356668e-03,  -6.087581449243512e-05,  -1.101284016166296e-07,   4.843628391702176e-09,
   6.545295380325132e-11,   8.914924457378385e-14,  -8.419861125278000e-15,  -1.131108440006499e-16,  -1.369501939005306e-20,   1.855743978599420e-20,   2.311873727914527e-22,
  -3.577272406868713e-25,  -4.565397764423458e-26,   1.557358382389409e+00,  -7.114144979026835e-03,  -6.087527748444122e-05,  -1.101163140736583e-07,   4.843652983968771e-09,
   6.544968678615888e-11,   8.909076183837279e-14,  -8.419869665214891e-15,  -1.130954155172926e-16,  -1.346026578768651e-20,   1.855700096949190e-20,   2.311215911731602e-22,
  -3.585896466277223e-25,  -4.565039973056569e-26,   1.557358204016914e+00,  -7.114145944718375e-03,  -6.087519226858553e-05,  -1.101143959655571e-07,   4.843656885926519e-09,
   6.544916835544683e-11,   8.908148167826998e-14,  -8.419871015604006e-15,  -1.130929672407082e-16,  -1.342301567225839e-20,   1.855693130315561e-20,   2.311111526947940e-22,
  -3.587264849756546e-25,  -4.564983178789206e-26,   1.751863646214136e+00,  -4.504081660529696e-03,  -5.244416523126119e-05,  -4.003116132584076e-07,  -7.826854163175287e-10,
   3.260866535543421e-11,   5.918694181637163e-13,   4.888762768558154e-15,  -5.724467678120248e-18,  -8.169783663443629e-19,  -1.261006530294190e-20,  -8.189611288345750e-23,
   6.525072173567306e-25,   2.458120798793954e-26,   1.751858728709031e+00,  -4.504194139969407e-03,  -5.244460079400831e-05,  -4.002809621863035e-07,  -7.818532939466571e-10,
   3.261824603401431e-11,   5.918532959494327e-13,   4.885994675015332e-15,  -5.777531933455550e-18,  -8.173936208171660e-19,  -1.260590574112426e-20,  -8.171574906364698e-23,
   6.551478475915531e-25,   2.459245279866320e-26,   1.751850051661144e+00,  -4.504392604690695e-03,  -5.244536897084368e-05,  -4.002268705978443e-07,  -7.803850197735942e-10,
   3.263514685642424e-11,   5.918247348838257e-13,   4.881109196092537e-15,  -5.871150274168429e-18,  -8.181255871602371e-19,  -1.259855287427573e-20,  -8.139742848707639e-23,
   6.598046520717052e-25,   2.461221458904856e-26,   1.751839559226273e+00,  -4.504632578382107e-03,  -5.244629720972973e-05,  -4.001614500441770e-07,  -7.786095991695886e-10,
   3.265557594704476e-11,   5.917900056037082e-13,   4.875199690092558e-15,  -5.984330034437938e-18,  -8.190093982477517e-19,  -1.258963911803545e-20,  -8.101240001102903e-23,
   6.654312221227547e-25,   2.463597459992592e-26,   1.751829373293658e+00,  -4.504865528151414e-03,  -5.244719764861471e-05,  -4.000979278926674e-07,  -7.768860854266450e-10,
   3.267540023163087e-11,   5.917560890076403e-13,   4.869460821885012e-15,  -6.094177251382383e-18,  -8.198660351832003e-19,  -1.258096215221319e-20,  -8.063850433497578e-23,
   6.708886933165505e-25,   2.465889782775091e-26,   1.751821167596930e+00,  -4.505053180472941e-03,  -5.244792254371881e-05,  -4.000467459536189e-07,  -7.754976694991684e-10,
   3.269136473960517e-11,   5.917286215169533e-13,   4.864836216756085e-15,  -6.182650273742853e-18,  -8.205551621958224e-19,  -1.257395516760752e-20,  -8.033721552053741e-23,
   6.752817852437893e-25,   2.467726232655069e-26,   1.751815745398214e+00,  -4.505177173385285e-03,  -5.244840130316570e-05,  -4.000129212776488e-07,  -7.745802409327913e-10,
   3.270191102158722e-11,   5.917104006363804e-13,   4.861779651837212e-15,  -6.241102617574434e-18,  -8.210100507480221e-19,  -1.256931678908297e-20,  -8.013808856149441e-23,
   6.781830074520039e-25,   2.468934724314023e-26,   1.751812960833393e+00,  -4.505240848318157e-03,  -5.244864709534595e-05,  -3.999955492772952e-07,  -7.741091011674781e-10,
   3.270732618201823e-11,   5.917010214323583e-13,   4.860209740582299e-15,  -6.271117890767954e-18,  -8.212435110887378e-19,  -1.256693219736114e-20,  -8.003581478534905e-23,
   6.796724117773782e-25,   2.469553795801969e-26,   1.751811991639098e+00,  -4.505263010745065e-03,  -5.244873263383151e-05,  -3.999895025689001e-07,  -7.739451172473864e-10,
   3.270921084127702e-11,   5.916977534265487e-13,   4.859663283751008e-15,  -6.281564535145553e-18,  -8.213247457427361e-19,  -1.256610181049840e-20,  -8.000021546446519e-23,
   6.801907310326874e-25,   2.469769023051373e-26,   1.751811837841264e+00,  -4.505266527606707e-03,  -5.244874620705408e-05,  -3.999885430288931e-07,  -7.739190952857042e-10,
   3.270950990424523e-11,   5.916972346734527e-13,   4.859576566923937e-15,  -6.283222252541640e-18,  -8.213376354547527e-19,  -1.256597002017760e-20,  -7.999456624778786e-23,
   6.802729772875159e-25,   2.469803164961379e-26,   1.896182987867475e+00,  -2.045651639048980e-03,  -2.853972339695666e-05,  -3.244012073619265e-07,  -3.000695164833389e-09,
  -1.994683827676318e-11,  -2.759291545416595e-14,   1.851040507273818e-15,   3.811147815991345e-17,   4.842880522450833e-19,   4.204659940556748e-21,   1.485446558222404e-23,
  -3.055531010633000e-25,  -8.252149246508605e-27,   1.896180308884885e+00,  -2.045742942462035e-03,  -2.854141149634983e-05,  -3.244198766016317e-07,  -3.000732779317462e-09,
  -1.994316801465160e-11,  -2.749250815603681e-14,   1.852676901459126e-15,   3.812915396351330e-17,   4.843622682054517e-19,   4.202721381490863e-21,   1.479347061156872e-23,
  -3.065872907026446e-25,  -8.263960668965198e-27,   1.896175581649198e+00,  -2.045904053036639e-03,  -2.854439019125227e-05,  -3.244528159638232e-07,  -3.000799035729549e-09,
  -1.993668915915988e-11,  -2.731530021176857e-14,   1.855564546675737e-15,   3.816033650633312e-17,   4.844929670761501e-19,   4.199295555905225e-21,   1.468577389086545e-23,
  -3.084125980210071e-25,  -8.284795742534181e-27,   1.896169865205745e+00,  -2.046098876938159e-03,  -2.854799208984798e-05,  -3.244926418084608e-07,  -3.000878957684677e-09,
  -1.992885038989960e-11,  -2.710095422225636e-14,   1.859056661955875e-15,   3.819803134984127e-17,   4.846505722325543e-19,   4.195144129994000e-21,   1.455542630490515e-23,
  -3.106205679473063e-25,  -8.309978847290084e-27,   1.896164315551480e+00,  -2.046288016225355e-03,  -2.855148878086739e-05,  -3.245312990374795e-07,  -3.000956339241760e-09,
  -1.992123596928826e-11,  -2.689280357659650e-14,   1.862447106462184e-15,   3.823461287642721e-17,   4.848031143819855e-19,   4.191104695448074e-21,   1.442876195552281e-23,
  -3.127648512172880e-25,  -8.334414725615195e-27,   1.896159844657439e+00,  -2.046440389831950e-03,  -2.855430569129484e-05,  -3.245624372064644e-07,  -3.001018529699226e-09,
  -1.991509853830480e-11,  -2.672507193386747e-14,   1.865178661569994e-15,   3.826407388747091e-17,   4.849256718682049e-19,   4.187843913135624e-21,   1.432663314313655e-23,
  -3.144928472953434e-25,  -8.354091722892352e-27,   1.896156890289645e+00,  -2.046541078268255e-03,  -2.855616706609441e-05,  -3.245830109945946e-07,  -3.001059552001749e-09,
  -1.991104139156381e-11,  -2.661421426108091e-14,   1.866983750234537e-15,   3.828353698788982e-17,   4.850064947634712e-19,   4.185685981663339e-21,   1.425910435303075e-23,
  -3.156349643878989e-25,  -8.367089891527452e-27,   1.896155373055476e+00,  -2.046592787424218e-03,  -2.855712297438378e-05,  -3.245935760750556e-07,  -3.001080596634418e-09,
  -1.990895734486272e-11,  -2.655727624669201e-14,   1.867910788473769e-15,   3.829353091803805e-17,   4.850479514094611e-19,   4.184576770866135e-21,   1.422441151675566e-23,
  -3.162215851441299e-25,  -8.373763820957420e-27,   1.896154844964258e+00,  -2.046610785401011e-03,  -2.855745568753759e-05,  -3.245972532614212e-07,  -3.001087917863929e-09,
  -1.990823189249171e-11,  -2.653745728804454e-14,   1.868233458802491e-15,   3.829700918939345e-17,   4.850623728486413e-19,   4.184190539128580e-21,   1.421233419697595e-23,
  -3.164257780268364e-25,  -8.376086543654278e-27,   1.896154761163266e+00,  -2.046613641438300e-03,  -2.855750848455756e-05,  -3.245978367761410e-07,  -3.001089079473802e-09,
  -1.990811676935415e-11,  -2.653431223712835e-14,   1.868284662433085e-15,   3.829756113329900e-17,   4.850646609561176e-19,   4.184129241838997e-21,   1.421041759010066e-23,
  -3.164581812969884e-25,  -8.376455118278960e-27,   1.979988537254030e+00,  -4.124384667454934e-04,  -6.309995643547757e-06,  -8.461721976091725e-08,  -1.044633726466922e-09,
  -1.209627848523242e-11,  -1.321686881060091e-13,  -1.359908056643154e-15,  -1.303843677849967e-17,  -1.136008171938509e-19,  -8.449255908108768e-22,  -4.285407455955024e-24,
   1.022983457920935e-26,   7.204974700347359e-28,   1.979987944511377e+00,  -4.124623053203901e-04,  -6.310584300504600e-06,  -8.462858256739662e-08,  -1.044819994056808e-09,
  -1.209896190781187e-11,  -1.322029874997330e-13,  -1.360292028351754e-15,  -1.304199905949660e-17,  -1.136227037691749e-19,  -8.448567336686133e-22,  -4.280027382100129e-24,
   1.034953149175078e-26,   7.225127988936724e-28,   1.979986898562634e+00,  -4.125043714635694e-04,  -6.311623080259774e-06,  -8.464863446565253e-08,  -1.045148705397417e-09,
  -1.210369746410557e-11,  -1.322635169214747e-13,  -1.360969612381806e-15,  -1.304828451938245e-17,  -1.136613003082808e-19,  -8.447346297864833e-22,  -4.270522135413412e-24,
   1.056094090607116e-26,   7.260718630220266e-28,   1.979985633713491e+00,  -4.125552427315958e-04,  -6.312879329284857e-06,  -8.467288492669413e-08,  -1.045546253589627e-09,
  -1.210942479795890e-11,  -1.323367227065451e-13,  -1.361789056339001e-15,  -1.305588455233099e-17,  -1.137079329714337e-19,  -8.445859492659158e-22,  -4.259007779335693e-24,
   1.081692460033644e-26,   7.303806127916231e-28,   1.979984405739462e+00,  -4.126046323261080e-04,  -6.314099026418476e-06,  -8.469643051109706e-08,  -1.045932256586027e-09,
  -1.211498589267666e-11,  -1.324078031882823e-13,  -1.362584665220492e-15,  -1.306326209918546e-17,  -1.137531625996213e-19,  -8.444405320344186e-22,  -4.247808348122166e-24,
   1.106579083454247e-26,   7.345688071051717e-28,   1.979983416441960e+00,  -4.126444232718055e-04,  -6.315081707720034e-06,  -8.471540114792965e-08,  -1.046243265806977e-09,
  -1.211946662514542e-11,  -1.324650744245523e-13,  -1.363225673924357e-15,  -1.306920504305510e-17,  -1.137895699119738e-19,  -8.443226108171796e-22,  -4.238770820893509e-24,
   1.126653355500586e-26,   7.379465863037439e-28,   1.979982762703594e+00,  -4.126707180507675e-04,  -6.315731099466740e-06,  -8.472793788985582e-08,  -1.046448799754352e-09,
  -1.212242779864292e-11,  -1.325029229985052e-13,  -1.363649278515042e-15,  -1.307313188124602e-17,  -1.138136129606085e-19,  -8.442443108695122e-22,  -4.232791433794106e-24,
   1.139930780465088e-26,   7.401804359589057e-28,   1.979982426968941e+00,  -4.126842221823183e-04,  -6.316064609731328e-06,  -8.473437650351830e-08,  -1.046554358877339e-09,
  -1.212394862208464e-11,  -1.325223615246591e-13,  -1.363866831322119e-15,  -1.307514845304556e-17,  -1.138259558053916e-19,  -8.442039826175172e-22,  -4.229718396532173e-24,
   1.146753303617191e-26,   7.413282041678898e-28,   1.979982310112032e+00,  -4.126889224992742e-04,  -6.316180693664859e-06,  -8.473661758514342e-08,  -1.046591100907793e-09,
  -1.212447797758230e-11,  -1.325291275161119e-13,  -1.363942554412330e-15,  -1.307585033175510e-17,  -1.138302511430574e-19,  -8.441899272919259e-22,  -4.228648425811364e-24,
   1.149128571088004e-26,   7.417277876811536e-28,   1.979982291568384e+00,  -4.126896683786535e-04,  -6.316199114711315e-06,  -8.473697321693190e-08,  -1.046596931419498e-09,
  -1.212456197991002e-11,  -1.325302011969009e-13,  -1.363954570711378e-15,  -1.307596170988018e-17,  -1.138309327206341e-19,  -8.441876960170922e-22,  -4.228478618534011e-24,
   1.149505523034648e-26,   7.417912004625745e-28,   7.292148640857860e-03,  -1.397471447044199e-04,   2.001398518483720e-06,  -2.536332385488253e-08,   2.995393864642134e-10,
  -3.371978001160411e-12,   3.658279136644902e-14,  -3.848274962946323e-16,   3.935580673461275e-18,  -3.917233489580699e-20,   3.790333150640501e-22,  -3.557285870642544e-24,
   3.220064224117780e-26,  -2.788378781590389e-28,   7.292336610427792e-03,  -1.397542892840470e-04,   2.001567300203514e-06,  -2.536649146786240e-08,   2.995909535299969e-10,
  -3.372737740443899e-12,   3.659315542287211e-14,  -3.849601832047446e-16,   3.937186156826360e-18,  -3.919075686332866e-20,   3.792334572668251e-22,  -3.559334030323372e-24,
   3.222007740132812e-26,  -2.790038572185002e-28,   7.292668298595198e-03,  -1.397668967327961e-04,   2.001865141819103e-06,  -2.537208135059947e-08,   2.996819562923351e-10,
  -3.374078524997629e-12,   3.661144639397786e-14,  -3.851943619550533e-16,   3.940019744776255e-18,  -3.922327131070022e-20,   3.795867091943458e-22,  -3.562949027601484e-24,
   3.225437909680014e-26,  -2.792967659167509e-28,   7.293069401475147e-03,  -1.397821430318306e-04,   2.002225335353624e-06,  -2.537884168525325e-08,   2.997920180358772e-10,
  -3.375700178623504e-12,   3.663356988197068e-14,  -3.854776197125218e-16,   3.943447321726826e-18,  -3.926260278737893e-20,   3.800140320903155e-22,  -3.567322004510450e-24,
   3.229587079648259e-26,  -2.796510155976154e-28,   7.293458808251893e-03,  -1.397969451708287e-04,   2.002575047177809e-06,  -2.538540553663727e-08,   2.998988852604904e-10,
  -3.377274831693623e-12,   3.665505310882094e-14,  -3.857526918444678e-16,   3.946775981832014e-18,  -3.930080045903617e-20,   3.804290445626936e-22,  -3.571568978008268e-24,
   3.233616458800361e-26,  -2.799949791865168e-28,   7.293772525799349e-03,  -1.398088705100395e-04,   2.002856800697817e-06,  -2.539069403200345e-08,   2.999849912912872e-10,
  -3.378543623905819e-12,   3.667236410835426e-14,  -3.859743511657050e-16,   3.949458386999582e-18,  -3.933158301089548e-20,   3.807634984834496e-22,  -3.574991548095175e-24,
   3.236863503479640e-26,  -2.802721176470265e-28,   7.293979832851317e-03,  -1.398167510164148e-04,   2.003042993203606e-06,  -2.539418893889929e-08,   3.000418960581923e-10,
  -3.379382152482146e-12,   3.668380505895701e-14,  -3.861208514247472e-16,   3.951231303442907e-18,  -3.935192896183263e-20,   3.809845610218659e-22,  -3.577253740118112e-24,
   3.239009596617093e-26,  -2.804552682284945e-28,   7.294086297442329e-03,  -1.398207981741241e-04,   2.003138616541339e-06,  -2.539598385319936e-08,   3.000711216785528e-10,
  -3.379812818252215e-12,   3.668968119965962e-14,  -3.861960961310668e-16,   3.952141914143273e-18,  -3.936237924798729e-20,   3.810981061866598e-22,  -3.578415675307743e-24,
   3.240111873934703e-26,  -2.805493317431110e-28,   7.294123353816303e-03,  -1.398222068468147e-04,   2.003171899848423e-06,  -2.539660860745126e-08,   3.000812942895031e-10,
  -3.379962721980706e-12,   3.669172655014115e-14,  -3.862222873026088e-16,   3.952458881755927e-18,  -3.936601683116546e-20,   3.811376296419372e-22,  -3.578820127954392e-24,
   3.240495556452184e-26,  -2.805820725130251e-28,   7.294129234171404e-03,  -1.398224303848329e-04,   2.003177181485466e-06,  -2.539670774819621e-08,   3.000829085601438e-10,
  -3.379986509949498e-12,   3.669205112412099e-14,  -3.862264435549979e-16,   3.952509181158084e-18,  -3.936659407811710e-20,   3.811439016133773e-22,  -3.578884310465409e-24,
   3.240556442760978e-26,  -2.805872680746112e-28,   6.513519615311932e-02,  -1.216114352385091e-03,   1.649609052563177e-05,  -1.900632673206551e-07,   1.922447150372382e-09,
  -1.688234181641508e-11,   1.202302791195059e-13,  -5.119780517233188e-16,  -2.915811830997580e-18,   1.076226001246304e-19,  -1.688687673897513e-21,   1.976646561211110e-23,
  -1.827756622833135e-25,   1.197198140655547e-27,   6.513674483130882e-02,  -1.216167863354187e-03,   1.649717285382249e-05,  -1.900791029049439e-07,   1.922616131374332e-09,
  -1.688334394524824e-11,   1.202224771326624e-13,  -5.116121591591241e-16,  -2.922972348556139e-18,   1.077248584610077e-19,  -1.689819075477286e-21,   1.977515492695904e-23,
  -1.827862929766709e-25,   1.196022033383807e-27,   6.513947758098675e-02,  -1.216262287924786e-03,   1.649908271622636e-05,  -1.901070458049804e-07,   1.922914292036947e-09,
  -1.688511163040340e-11,   1.202086951003521e-13,  -5.109662551302651e-16,  -2.935611075587239e-18,   1.079053312659807e-19,  -1.691815502716209e-21,   1.979048032059634e-23,
  -1.828048563029869e-25,   1.193943270235377e-27,   6.514278219202362e-02,  -1.216376473303470e-03,   1.650139227402501e-05,  -1.901408359579791e-07,   1.923274815783058e-09,
  -1.688724813309710e-11,   1.201920036197221e-13,  -5.101847421479562e-16,  -2.950900577158715e-18,   1.081236228895554e-19,  -1.694229690752940e-21,   1.980899993377723e-23,
  -1.828269710695007e-25,   1.191423631393789e-27,   6.514599039879951e-02,  -1.216487328963336e-03,   1.650363449074646e-05,  -1.901736402142659e-07,   1.923624789944388e-09,
  -1.688932116421205e-11,   1.201757724804453e-13,  -5.094255612552931e-16,  -2.965750290876751e-18,   1.083356014975741e-19,  -1.696573432840259e-21,   1.982696585182947e-23,
  -1.828480915288509e-25,   1.188971347921193e-27,   6.514857499420501e-02,  -1.216576637477734e-03,   1.650544089024501e-05,  -1.902000678711702e-07,   1.923906713066515e-09,
  -1.689099041944043e-11,   1.201626772924466e-13,  -5.088136155321528e-16,  -2.977717992746768e-18,   1.085064151745027e-19,  -1.698461584960286e-21,   1.984142991973519e-23,
  -1.828648562266718e-25,   1.186991331328627e-27,   6.515028290058492e-02,  -1.216635653223252e-03,   1.650663457526078e-05,  -1.902175312731641e-07,   1.924092997202925e-09,
  -1.689209306540483e-11,   1.201540146300472e-13,  -5.084090766693669e-16,  -2.985628468285147e-18,   1.086193085533930e-19,  -1.699709273323975e-21,   1.985098308572438e-23,
  -1.828758117128379e-25,   1.185680772762247e-27,   6.515116000824477e-02,  -1.216665961334459e-03,   1.650724760460223e-05,  -1.902264997132061e-07,   1.924188661275065e-09,
  -1.689265921298840e-11,   1.201495629704900e-13,  -5.082012721625486e-16,  -2.989691627899785e-18,   1.086772917374565e-19,  -1.700350030557777e-21,   1.985588772168956e-23,
  -1.828814000306577e-25,   1.185007057999083e-27,   6.515146529614747e-02,  -1.216676510461891e-03,   1.650746097746171e-05,  -1.902296212843773e-07,   1.924221957753505e-09,
  -1.689285624770770e-11,   1.201480130570778e-13,  -5.081289352328574e-16,  -2.991105967520956e-18,   1.086974744350678e-19,  -1.700573053498099e-21,   1.985759460665000e-23,
  -1.828833390687463e-25,   1.184772457093706e-27,   6.515151374125416e-02,  -1.216678184468436e-03,   1.650749483690903e-05,  -1.902301166358460e-07,   1.924227241432870e-09,
  -1.689288751354323e-11,   1.201477670847314e-13,  -5.081174559468448e-16,  -2.991330409423169e-18,   1.087006772043568e-19,  -1.700608444239138e-21,   1.985786545541058e-23,
  -1.828836464812279e-25,   1.184735224018682e-27,   1.781762261300356e-01,  -3.153103822032108e-03,   3.804269824388854e-05,  -3.476434486269505e-07,   2.120248231033170e-09,
  -2.921657795095074e-13,  -2.144561921311423e-13,   3.528974569911334e-15,  -3.352977643155327e-17,   1.338858885623810e-19,   1.969286074734212e-21,  -5.187694216836158e-23,
   6.483335360528482e-25,  -4.415656472012905e-27,   1.781797950166827e-01,  -3.153201597306267e-03,   3.804388917244595e-05,  -3.476436640512888e-07,   2.119945614078074e-09,
  -2.852110642068345e-13,  -2.145440329875690e-13,   3.529419423882439e-15,  -3.352133972342392e-17,   1.336171627369545e-19,   1.973292656252078e-21,  -5.190877615900599e-23,
   6.482277129428707e-25,  -4.407420958770133e-27,   1.781860924639789e-01,  -3.153374123357384e-03,   3.804599044601682e-05,  -3.476440388679376e-07,   2.119411541333683e-09,
  -2.729386508831636e-13,  -2.146990114797768e-13,   3.530203637464051e-15,  -3.350643928139224e-17,   1.331428588011778e-19,   1.980361788587718e-21,  -5.196489860909376e-23,
   6.480399420902579e-25,  -4.392876863320466e-27,   1.781937075591155e-01,  -3.153582743772038e-03,   3.804853109210738e-05,  -3.476444830578349e-07,   2.118765563745832e-09,
  -2.580975098761808e-13,  -2.148863822790311e-13,   3.531150657881124e-15,  -3.348839808485848e-17,   1.325690987977301e-19,   1.988908928145329e-21,  -5.203267865900100e-23,
   6.478111067667628e-25,  -4.375268851904720e-27,   1.782011003235239e-01,  -3.153785268931924e-03,   3.805099725979720e-05,  -3.476449048001156e-07,   2.118138280709319e-09,
  -2.436887234368483e-13,  -2.150682462767696e-13,   3.532068690152553e-15,  -3.347085947705511e-17,   1.320118653878275e-19,   1.997205363967090e-21,  -5.209839052217489e-23,
   6.475870923457232e-25,  -4.358153181295366e-27,   1.782070559543646e-01,  -3.153948420618282e-03,   3.805298379501595e-05,  -3.476452377649573e-07,   2.117632821286167e-09,
  -2.320802877847876e-13,  -2.152147303653815e-13,   3.532807299903324e-15,  -3.345671303069985e-17,   1.315627956233693e-19,   2.003888159865647e-21,  -5.215126416509801e-23,
   6.474052927909611e-25,  -4.344349183002900e-27,   1.782109913859098e-01,  -3.154056228371021e-03,   3.805429637522832e-05,  -3.476454544598179e-07,   2.117298759857247e-09,
  -2.244091976420539e-13,  -2.153115130833746e-13,   3.533294897228127e-15,  -3.344735670771572e-17,   1.312659752473864e-19,   2.008303685897369e-21,  -5.218617127171376e-23,
   6.472845084625571e-25,  -4.335219997163536e-27,   1.782130124358715e-01,  -3.154111592818083e-03,   3.805497042110386e-05,  -3.476455647154936e-07,   2.117127183894467e-09,
  -2.204695889712762e-13,  -2.153612121257533e-13,   3.533545158628067e-15,  -3.344254912764840e-17,   1.311135181010647e-19,   2.010571162368868e-21,  -5.220408819520186e-23,
   6.472222775321211e-25,  -4.330529327690304e-27,   1.782137158836144e-01,  -3.154130862922102e-03,   3.805520502466591e-05,  -3.476456029274086e-07,   2.117067462215432e-09,
  -2.190983503169464e-13,  -2.153785097729805e-13,   3.533632241607634e-15,  -3.344087538182830e-17,   1.310604499076651e-19,   2.011360361193328e-21,  -5.221032282441678e-23,
   6.472005852636528e-25,  -4.328896315903802e-27,   1.782138275112158e-01,  -3.154133920822275e-03,   3.805524225281711e-05,  -3.476456089833474e-07,   2.117057985060592e-09,
  -2.188807525937323e-13,  -2.153812546447992e-13,   3.533646059395094e-15,  -3.344060976131068e-17,   1.310520285222146e-19,   2.011485595364194e-21,  -5.221131210203809e-23,
   6.471971414696326e-25,  -4.328637161322645e-27,   3.410839526283930e-01,  -5.549311879292867e-03,   5.469670124821345e-05,  -2.880928277830193e-07,  -1.209992237575333e-09,
   4.527195072289228e-11,  -4.618372996848059e-13,   6.450220188436370e-16,   5.228796012684994e-17,  -8.360620652552931e-19,   4.594669558691473e-21,   5.615912957393351e-23,
  -1.528456491241619e-24,   1.418906740764782e-26,   3.410890790603508e-01,  -5.549392755707561e-03,   5.469601697303220e-05,  -2.880503751561106e-07,  -1.210640066570395e-09,
   4.527317586386350e-11,  -4.616996509256218e-13,   6.422079826538536e-16,   5.230704020280479e-17,  -8.357685233987112e-19,   4.585223894463686e-21,   5.626143728630107e-23,
  -1.528209337061807e-24,   1.416281327825193e-26,   3.410981246777339e-01,  -5.549535453706901e-03,   5.469480926281417e-05,  -2.879754659069366e-07,  -1.211783013514649e-09,
   4.527533314405027e-11,  -4.614567269856304e-13,   6.372433798137082e-16,   5.234067491056482e-17,  -8.352501367742619e-19,   4.568558145269078e-21,   5.644180461843668e-23,
  -1.527770435448024e-24,   1.411647588560795e-26,   3.411090626454694e-01,  -5.549707989101494e-03,   5.469334838223672e-05,  -2.878848832741785e-07,  -1.213164808574102e-09,
   4.527793407775209e-11,  -4.611629116868469e-13,   6.312415080110550e-16,   5.238129114004977e-17,  -8.346225698243532e-19,   4.548407925045311e-21,   5.665964028200942e-23,
  -1.527234949228318e-24,   1.406042456577472e-26,   3.411196809415187e-01,  -5.549875466143904e-03,   5.469192965643844e-05,  -2.877969455829737e-07,  -1.214505949986161e-09,
   4.528045098568253e-11,  -4.608776086064053e-13,   6.254164398504687e-16,   5.242066285216940e-17,  -8.340125765914728e-19,   4.528848737037364e-21,   5.687083229921566e-23,
  -1.526710125394370e-24,   1.400599043406343e-26,   3.411282348355891e-01,  -5.550010371052859e-03,   5.469078637096027e-05,  -2.877261029500546e-07,  -1.215586154479096e-09,
   4.528247281881564e-11,  -4.606477204132148e-13,   6.207248768155280e-16,   5.245233876608289e-17,  -8.335206283365724e-19,   4.513093763952259e-21,   5.704076584449637e-23,
  -1.526283766122635e-24,   1.396212439887605e-26,   3.411338870635303e-01,  -5.550099507733013e-03,   5.469003072301405e-05,  -2.876792908270069e-07,  -1.216299835650841e-09,
   4.528380599257381e-11,  -4.604957890734471e-13,   6.176252831426490e-16,   5.247324936386907e-17,  -8.331952906969981e-19,   4.502683971932622e-21,   5.715295696321131e-23,
  -1.526000289462495e-24,   1.393313137984771e-26,   3.411367897428582e-01,  -5.550145281802865e-03,   5.468964260434486e-05,  -2.876552503848479e-07,  -1.216666314550260e-09,
   4.528448976980148e-11,  -4.604177572349666e-13,   6.160336505244536e-16,   5.248398168425843e-17,  -8.330281317158596e-19,   4.497338297974689e-21,   5.721054217817436e-23,
  -1.525854170853880e-24,   1.391823987984585e-26,   3.411378000453612e-01,  -5.550161213587694e-03,   5.468950750696707e-05,  -2.876468828606210e-07,  -1.216793866026574e-09,
   4.528472762602343e-11,  -4.603905962934277e-13,   6.154796932229207e-16,   5.248771616814644e-17,  -8.329699373648682e-19,   4.495477727437512e-21,   5.723058041664475e-23,
  -1.525803227018346e-24,   1.391305640757710e-26,   3.411379603663774e-01,  -5.550163741728318e-03,   5.468948606844083e-05,  -2.876455550484283e-07,  -1.216814106458437e-09,
   4.528476536394544e-11,  -4.603862861669479e-13,   6.153917890156698e-16,   5.248830873190532e-17,  -8.329607020992472e-19,   4.495182482429043e-21,   5.723375998015124e-23,
  -1.525795138854921e-24,   1.391223384534311e-26,   5.457828976043252e-01,  -7.879407687156717e-03,   5.514479736937393e-05,   5.317626501362065e-08,  -5.629554827654861e-09,
   4.646759732053573e-11,   2.624519517720373e-13,  -9.016707352166498e-15,   5.436338726466852e-17,   8.025319008135647e-19,  -1.710504969101970e-20,   5.398238637223462e-23,
   2.252278564807424e-24,  -3.392065875933821e-26,   5.457880610663929e-01,  -7.879392578474344e-03,   5.514163284459844e-05,   5.321967945568112e-08,  -5.629184087522031e-09,
   4.644988892197756e-11,   2.625931756507682e-13,  -9.013991841768656e-15,   5.429167328324259e-17,   8.028007431243282e-19,  -1.709112119485364e-20,   5.373761943190054e-23,
   2.252125078411888e-24,  -3.386121124593789e-26,   5.457971718356323e-01,  -7.879365909065053e-03,   5.513604916070132e-05,   5.329627143897995e-08,  -5.628529749837778e-09,
   4.641864652353174e-11,   2.628422146345764e-13,  -9.009199550183602e-15,   5.416518059892148e-17,   8.032740968988110e-19,  -1.706654497113391e-20,   5.330607723283732e-23,
   2.251849256642411e-24,  -3.375635191619669e-26,   5.458081882645514e-01,  -7.879333643249513e-03,   5.512929760013602e-05,   5.338886429669113e-08,  -5.627738243511437e-09,
   4.638087529838925e-11,   2.631430948156799e-13,  -9.003403415891536e-15,   5.401230573323423e-17,   8.038447385434659e-19,  -1.703682856587215e-20,   5.278485339866386e-23,
   2.251507226896027e-24,  -3.362961764492022e-26,   5.458188823930988e-01,  -7.879302302479504e-03,   5.512274360540347e-05,   5.347872777148377e-08,  -5.626969575875930e-09,
   4.634421541472389e-11,   2.634349114681299e-13,  -8.997775328684012e-15,   5.386398274014783e-17,   8.043968838259806e-19,  -1.700798191027930e-20,   5.227948812431401e-23,
   2.251166298332081e-24,  -3.350665204863225e-26,   5.458274971359359e-01,  -7.879277042100707e-03,   5.511746400990310e-05,   5.355110337507794e-08,  -5.626350141701253e-09,
   4.631468825555318e-11,   2.636697999005931e-13,  -8.993240484833272e-15,   5.374455676691452e-17,   8.048403790862965e-19,  -1.698474452144221e-20,   5.187282354623417e-23,
   2.250885288340477e-24,  -3.340763982837257e-26,   5.458331894537121e-01,  -7.879260344293478e-03,   5.511397545372341e-05,   5.359891944277798e-08,  -5.625940730046849e-09,
   4.629517996050541e-11,   2.638249144094343e-13,  -8.990243486150597e-15,   5.366567212726915e-17,   8.051327938673381e-19,  -1.696939021452080e-20,   5.160432766052069e-23,
   2.250696490274148e-24,  -3.334223749574080e-26,   5.458361126846144e-01,  -7.879251767253596e-03,   5.511218394613585e-05,   5.362347267091925e-08,  -5.625730446474578e-09,
   4.628516236057739e-11,   2.639045435771749e-13,  -8.988704243468908e-15,   5.362517034194794e-17,   8.052827653147897e-19,  -1.696150521331372e-20,   5.146651045601719e-23,
   2.250598571870242e-24,  -3.330865744453358e-26,   5.458371301344745e-01,  -7.879248781631159e-03,   5.511156040075704e-05,   5.363201823123999e-08,  -5.625657250401491e-09,
   4.628167577739889e-11,   2.639322545335922e-13,  -8.988168473609827e-15,   5.361107479752011e-17,   8.053349328097365e-19,  -1.695876079362857e-20,   5.141855278510443e-23,
   2.250564337457584e-24,  -3.329697074331150e-26,   5.458372915894023e-01,  -7.879248307839511e-03,   5.511146145294196e-05,   5.363337427424256e-08,  -5.625645634957788e-09,
   4.628112251103823e-11,   2.639366516573990e-13,  -8.988083453251285e-15,   5.360883809866760e-17,   8.053432095802679e-19,  -1.695832529331468e-20,   5.141094307919055e-23,
   2.250558897664983e-24,  -3.329511627906100e-26,   7.814307581372986e-01,  -9.588380472225436e-03,   3.442232082537197e-05,   4.961568296430275e-07,  -5.778253876713415e-09,
  -3.070825471710970e-11,   9.449632129591231e-13,  -6.588966770706244e-16,  -1.433995816214506e-16,   9.270402943764161e-19,   1.878052227177521e-20,  -2.717458681055941e-22,
  -1.718836125274850e-24,   5.964935444363319e-26,   7.814339787140189e-01,  -9.588241029833766e-03,   3.441907803743107e-05,   4.961280302656622e-07,  -5.776929454560979e-09,
  -3.070950280416568e-11,   9.445884180054028e-13,  -6.558039465254496e-16,  -1.433206939678233e-16,   9.256558170691505e-19,   1.876987181604812e-20,  -2.713155109034950e-22,
  -1.719171958513323e-24,   5.954350307742414e-26,   7.814396612261215e-01,  -9.587994988123263e-03,   3.441335669164282e-05,   4.960772123742935e-07,  -5.774592918659928e-09,
  -3.071170014093723e-11,   9.439272545524614e-13,  -6.503505613251075e-16,  -1.431815320025078e-16,   9.232146831616239e-19,   1.875107729228160e-20,  -2.705567659338592e-22,
  -1.719758872508954e-24,   5.935688991202653e-26,   7.814465321607359e-01,  -9.587697483083203e-03,   3.440643940985598e-05,   4.960157612420746e-07,  -5.771768283824461e-09,
  -3.071434877790187e-11,   9.431280552785312e-13,  -6.437627226003628e-16,  -1.430133181755564e-16,   9.202659020395103e-19,   1.872834799845445e-20,  -2.696403519760969e-22,
  -1.720458923867666e-24,   5.913151345967740e-26,   7.814532019056222e-01,  -9.587408682095115e-03,   3.439972531157203e-05,   4.959561038796225e-07,  -5.769026940811247e-09,
  -3.071691123127598e-11,   9.423525065533951e-13,  -6.373741159423131e-16,  -1.428500843575966e-16,   9.174064827534473e-19,   1.870627993335111e-20,  -2.687518313148585e-22,
  -1.721128433794582e-24,   5.891301301942311e-26,   7.814585746504942e-01,  -9.587176036197291e-03,   3.439431729438373e-05,   4.959080434921269e-07,  -5.766819097520748e-09,
  -3.071896921070311e-11,   9.417279495554630e-13,  -6.322323730694749e-16,  -1.427186320737895e-16,   9.151052675094748e-19,   1.868850015528008e-20,  -2.680368511759981e-22,
  -1.721660567744267e-24,   5.873720035750103e-26,   7.814621247104363e-01,  -9.587022312056324e-03,   3.439074415143518e-05,   4.958762854614654e-07,  -5.765360461779073e-09,
  -3.072032600385424e-11,   9.413153586525689e-13,  -6.288371673763858e-16,  -1.426317936412562e-16,   9.135857888781289e-19,   1.867675060687192e-20,  -2.675647967675043e-22,
  -1.722008665328289e-24,   5.862112849163502e-26,   7.814639477884087e-01,  -9.586943368629867e-03,   3.438890928859718e-05,   4.958599760131257e-07,  -5.764611465333767e-09,
  -3.072102182893347e-11,   9.411035060230198e-13,  -6.270942983690268e-16,  -1.425872050318158e-16,   9.128058111817770e-19,   1.867071634758265e-20,  -2.673224953367230e-22,
  -1.722186340466522e-24,   5.856155157041266e-26,   7.814645823198029e-01,  -9.586915891850385e-03,   3.438827066641441e-05,   4.958542993316305e-07,  -5.764350783443036e-09,
  -3.072126386551429e-11,   9.410297739553948e-13,  -6.264877932941664e-16,  -1.425716866852572e-16,   9.125343880776688e-19,   1.866861602011516e-20,  -2.672381793787286e-22,
  -1.722248008557322e-24,   5.854082029689735e-26,   7.814646830108360e-01,  -9.586911531673537e-03,   3.438816932675372e-05,   4.958533985190982e-07,  -5.764309417442883e-09,
  -3.072130226618468e-11,   9.410180739376306e-13,  -6.263915548192180e-16,  -1.425692241908972e-16,   9.124913195930286e-19,   1.866828272478382e-20,  -2.672248005123176e-22,
  -1.722257786205731e-24,   5.853753076757798e-26,   1.034515733697360e+00,  -1.021377761406580e-02,  -2.235827346321243e-06,   7.115741608075014e-07,   1.580877806849158e-10,
  -8.942585302011955e-11,  -3.912052213710928e-15,   1.367748816461146e-14,  -3.035501912488337e-18,  -2.321229536105448e-18,   1.208154342707032e-21,   4.198165954941722e-22,
  -3.576201613532796e-25,  -7.940035614640369e-26,   1.034515524267404e+00,  -1.021357777868246e-02,  -2.235738453746473e-06,   7.114905494729224e-07,   1.580821865275804e-10,
  -8.939904911829612e-11,  -3.919916778775591e-15,   1.366970979168326e-14,  -3.030474813278370e-18,  -2.319087081909665e-18,   1.205978066627096e-21,   4.192442189589632e-22,
  -3.568299242541185e-25,  -7.925062834625500e-26,   1.034515154731716e+00,  -1.021322518507868e-02,  -2.235581603977598e-06,   7.113430363471260e-07,   1.580723065980410e-10,
  -8.935176563377693e-11,  -3.933783241498057e-15,   1.365599059241895e-14,  -3.021611849815301e-18,  -2.315309078730802e-18,   1.202141948348223e-21,   4.182351375461063e-22,
  -3.554373578636483e-25,  -7.898673869243438e-26,   1.034514707896750e+00,  -1.021279885764500e-02,  -2.235391943959227e-06,   7.111646966584671e-07,   1.580603444279599e-10,
  -8.929461111308243e-11,  -3.950532506593348e-15,   1.363941118102825e-14,  -3.010907322918409e-18,  -2.310744751158904e-18,   1.197510010666736e-21,   4.170164549557751e-22,
  -3.537565504063988e-25,  -7.866816410143986e-26,   1.034514274129181e+00,  -1.021238502040192e-02,  -2.235207829905509e-06,   7.109916039669647e-07,   1.580487157973982e-10,
  -8.923914865874628e-11,  -3.966773347922419e-15,   1.362332663213874e-14,  -3.000528802490544e-18,  -2.306318044227163e-18,   1.193020453252798e-21,   4.158349580679867e-22,
  -3.521280920484586e-25,  -7.835944500443575e-26,   1.034513924700324e+00,  -1.021205166289426e-02,  -2.235059513323009e-06,   7.108521888139767e-07,   1.580393364939612e-10,
  -8.919448470217048e-11,  -3.979843115174251e-15,   1.361037661688143e-14,  -2.992177485934020e-18,  -2.302754999025520e-18,   1.189408768089211e-21,   4.148842898214806e-22,
  -3.508185457564675e-25,  -7.811113677247077e-26,   1.034513693808197e+00,  -1.021183139813430e-02,  -2.234961509986596e-06,   7.107600785258406e-07,   1.580331332239848e-10,
  -8.916497932599899e-11,  -3.988472708340842e-15,   1.360182314226897e-14,  -2.986663725249134e-18,  -2.300402095814233e-18,   1.187024698239720e-21,   4.142566581435903e-22,
  -3.499543548571720e-25,  -7.794725077996032e-26,   1.034513575235353e+00,  -1.021171828533387e-02,  -2.234911181085008e-06,   7.107127794316365e-07,   1.580299458188847e-10,
  -8.914982930621135e-11,  -3.992902353501505e-15,   1.359743165680538e-14,  -2.983833579723157e-18,  -2.299194229141879e-18,   1.185801126872484e-21,   4.139345101588400e-22,
  -3.495109018962520e-25,  -7.786314671227351e-26,   1.034513533965197e+00,  -1.021167891597575e-02,  -2.234893663729683e-06,   7.106963171769218e-07,   1.580288361381243e-10,
  -8.914455658554670e-11,  -3.994443803573234e-15,   1.359590334042106e-14,  -2.982848749951479e-18,  -2.298773893572516e-18,   1.185375373012935e-21,   4.138224108036103e-22,
  -3.493566097946496e-25,  -7.783388294719436e-26,   1.034513527416202e+00,  -1.021167266862873e-02,  -2.234890883970433e-06,   7.106937048736413e-07,   1.580286600340057e-10,
  -8.914371989555020e-11,  -3.994688394877327e-15,   1.359566082622025e-14,  -2.982692481866708e-18,  -2.298707195594946e-18,   1.185307817499493e-21,   4.138046234709414e-22,
  -3.493321284098093e-25,  -7.782923963810442e-26,   1.289191063437539e+00,  -9.519285522458376e-03,  -4.011809037701010e-05,   4.903206920967061e-07,   6.562467256244020e-09,
  -2.963489003118704e-11,  -1.093065030595341e-12,  -1.200590065911798e-15,   1.732820429693190e-16,   1.158146867997251e-18,  -2.446892558137537e-20,  -3.507495887088881e-22,
   2.604904056598288e-24,   8.229544924730360e-26,   1.289187309766615e+00,  -9.519147717965850e-03,  -4.011440763980715e-05,   4.902928901450573e-07,   6.560935487382626e-09,
  -2.963719235760089e-11,  -1.092612285809842e-12,  -1.196727781874237e-15,   1.731793325153853e-16,   1.156361337715734e-18,  -2.445282424161896e-20,  -3.501566165671309e-22,
   2.604558339006930e-24,   8.213534132030683e-26,   1.289180686634782e+00,  -9.518904566127665e-03,  -4.010791009121901e-05,   4.902438314273076e-07,   6.558233173871972e-09,
  -2.964124868971225e-11,  -1.091813629385292e-12,  -1.189917603225039e-15,   1.729981535114058e-16,   1.153213218155342e-18,  -2.442441498691081e-20,  -3.491112559192639e-22,
   2.603941619245648e-24,   8.185311142927005e-26,   1.289172678349648e+00,  -9.518610555166030e-03,  -4.010005437797624e-05,   4.901845061436242e-07,   6.554966388419570e-09,
  -2.964614315346008e-11,  -1.090848258617504e-12,  -1.181690982514970e-15,   1.727791640534839e-16,   1.149410698628752e-18,  -2.439006532613994e-20,  -3.478488099656686e-22,
   2.603184479460989e-24,   8.151231833860770e-26,   1.289164904544154e+00,  -9.518325145764674e-03,  -4.009242943551668e-05,   4.901269110916242e-07,   6.551795971920146e-09,
  -2.965088362924399e-11,  -1.089911484005076e-12,  -1.173713428312078e-15,   1.725666714443261e-16,   1.145723694468165e-18,  -2.435672255978424e-20,  -3.466249393579587e-22,
   2.602437554545531e-24,   8.118198694071295e-26,   1.289158642425103e+00,  -9.518095231795577e-03,  -4.008628777505192e-05,   4.900805110530951e-07,   6.549242586266311e-09,
  -2.965469462904369e-11,  -1.089157110363534e-12,  -1.167293048593545e-15,   1.723955607798514e-16,   1.142756653453284e-18,  -2.432986443846661e-20,  -3.456402150087083e-22,
   2.601827329225455e-24,   8.091623752600870e-26,   1.289154504703448e+00,  -9.517943312722776e-03,  -4.008222991290404e-05,   4.900498496515234e-07,   6.547555677921745e-09,
  -2.965720902043043e-11,  -1.088658770669943e-12,  -1.163053626797741e-15,   1.722825284758614e-16,   1.140797632619820e-18,  -2.431211824281494e-20,  -3.449901186814075e-22,
   2.601419942926147e-24,   8.074081180777299e-26,   1.289152379839530e+00,  -9.517865296241386e-03,  -4.008014614187280e-05,   4.900341032201346e-07,   6.546689469775039e-09,
  -2.965849909066963e-11,  -1.088402891745614e-12,  -1.160877423969767e-15,   1.722244916716173e-16,   1.139792059904503e-18,  -2.430300508658221e-20,  -3.446564460979686e-22,
   2.601209445578307e-24,   8.065077694627402e-26,   1.289151640269803e+00,  -9.517838142086650e-03,  -4.007942088782851e-05,   4.900286224772435e-07,   6.546387994016652e-09,
  -2.965894792201008e-11,  -1.088313837484834e-12,  -1.160120126759389e-15,   1.722042931326054e-16,   1.139442137226531e-18,  -2.429983322726316e-20,  -3.445403374234324e-22,
   2.601135975620083e-24,   8.061944818441843e-26,   1.289151522910682e+00,  -9.517833833105576e-03,  -4.007930580102286e-05,   4.900277527563015e-07,   6.546340154721520e-09,
  -2.965901913637073e-11,  -1.088299706120182e-12,  -1.159999961247484e-15,   1.722010879834512e-16,   1.139386612929773e-18,  -2.429932989963721e-20,  -3.445219139583021e-22,
   2.601124307247563e-24,   8.061447715416890e-26,   1.527982126160927e+00,  -7.604950800139101e-03,  -6.172469854740434e-05,  -2.275093701523164e-08,   6.155734286493753e-09,
   6.460080937780386e-11,  -1.935694004030578e-13,  -1.191670558012997e-14,  -9.909772171836592e-17,   9.097094318118691e-19,   2.760560346967151e-20,   1.513182132027817e-22,
  -3.350963524838994e-24,  -6.757444282515299e-26,   1.527976346429580e+00,  -7.604956986240815e-03,  -6.172123750900799e-05,  -2.269057066679917e-08,   6.155459035745616e-09,
   6.457739760481460e-11,  -1.938271420118423e-13,  -1.191361554676727e-14,  -9.898192946059620e-17,   9.104707147513032e-19,   2.758481577255946e-20,   1.508302224709884e-22,
  -3.352139600422456e-24,  -6.746300336027225e-26,   1.527966148266149e+00,  -7.604967887945780e-03,  -6.171513057880944e-05,  -2.258407112277665e-08,   6.154973057729966e-09,
   6.453609211806075e-11,  -1.942816844316129e-13,  -1.190816105924339e-14,  -9.877768354254533e-17,   9.118119711088710e-19,   2.754812977514750e-20,   1.499698171696637e-22,
  -3.354202319111367e-24,  -6.726640224675846e-26,   1.527953816987174e+00,  -7.604981046929694e-03,  -6.170774622934719e-05,  -2.245532113093051e-08,   6.154384907261965e-09,
   6.448615353308049e-11,  -1.948309014362951e-13,  -1.190156190035197e-14,  -9.853082885423617e-17,   9.134303572394102e-19,   2.750375886458810e-20,   1.489305345412411e-22,
  -3.356675314920120e-24,  -6.702873106977929e-26,   1.527941846465395e+00,  -7.604993796865089e-03,  -6.170057785679489e-05,  -2.233036469320684e-08,   6.153813416929284e-09,
   6.443768287183393e-11,  -1.953636315391140e-13,  -1.189515185492641e-14,  -9.829131401202598e-17,   9.149978215127816e-19,   2.746067413387435e-20,   1.479227986832665e-22,
  -3.359053816075559e-24,  -6.679806829535082e-26,   1.527932203505748e+00,  -7.605004050439399e-03,  -6.169480327115582e-05,  -2.222972421261461e-08,   6.153352656450193e-09,
   6.439864188235997e-11,  -1.957924766324063e-13,  -1.188998536080879e-14,  -9.809845527504522e-17,   9.162579461813454e-19,   2.742595835187117e-20,   1.471118263512281e-22,
  -3.360953990846151e-24,  -6.661229572445528e-26,   1.527925831774811e+00,  -7.605010817198390e-03,  -6.169098760722122e-05,  -2.216323393873000e-08,   6.153048010447302e-09,
   6.437284739944675e-11,  -1.960756954648218e-13,  -1.188657013991535e-14,  -9.797106236750895e-17,   9.170893397349432e-19,   2.740301523102590e-20,   1.465763647301317e-22,
  -3.362201808359618e-24,  -6.648956333804276e-26,   1.527922559637130e+00,  -7.605014289587233e-03,  -6.168902810577563e-05,  -2.212909145365904e-08,   6.152891503356217e-09,
   6.435960165942930e-11,  -1.962210941558700e-13,  -1.188481586080635e-14,  -9.790565384202818e-17,   9.175159061389169e-19,   2.739123174595594e-20,   1.463015077273949e-22,
  -3.362840216793153e-24,  -6.642654146756300e-26,   1.527921420747769e+00,  -7.605015497759608e-03,  -6.168834608726316e-05,  -2.211720839860976e-08,   6.152837020589908e-09,
   6.435499151135197e-11,  -1.962716939037017e-13,  -1.188420520427996e-14,  -9.788289000727922e-17,   9.176643137752745e-19,   2.738713022207968e-20,   1.462058616328364e-22,
  -3.363062037880986e-24,  -6.640460725821126e-26,   1.527921240022098e+00,  -7.605015689459780e-03,  -6.168823786050379e-05,  -2.211532274751808e-08,   6.152828374496112e-09,
   6.435425995160960e-11,  -1.962797230261185e-13,  -1.188410829847974e-14,  -9.787927780472943e-17,   9.176878610466215e-19,   2.738647935847383e-20,   1.461906848834337e-22,
  -3.363097219662370e-24,  -6.640112665495154e-26,   1.732977560637099e+00,  -4.943008022528549e-03,  -5.729889517574702e-05,  -4.067996106329533e-07,   2.238876447152336e-11,
   4.840463816703293e-11,   7.210374365250767e-13,   4.131360653899285e-15,  -4.496170849259157e-17,  -1.378998302775139e-18,  -1.498992323972323e-20,  -1.236989671425244e-23,
   2.399985642422811e-24,   4.239399753047370e-26,   1.732972188913098e+00,  -4.943122274600871e-03,  -5.729887686740465e-05,  -4.067541636844104e-07,   2.340130830797872e-11,
   4.841269771422075e-11,   7.209181176269183e-13,   4.126705241041436e-15,  -4.502446564040417e-17,  -1.379050098647498e-18,  -1.497496571625395e-20,  -1.206157557284020e-23,
   2.402320448007145e-24,   4.236364939469689e-26,   1.732962710423527e+00,  -4.943323863779389e-03,  -5.729884409932873e-05,  -4.066739657074454e-07,   2.518782093893315e-11,
   4.842691146016111e-11,   7.207074439109836e-13,   4.118490558378259e-15,  -4.513515022018411e-17,  -1.379140202517233e-18,  -1.494856127452052e-20,  -1.151772011938385e-23,
   2.406432176964108e-24,   4.230997816283847e-26,   1.732951248935984e+00,  -4.943567609833346e-03,  -5.729880368689194e-05,  -4.065769790233678e-07,   2.734785757449399e-11,
   4.844408616743555e-11,   7.204524672053851e-13,   4.108557051231366e-15,  -4.526890353699547e-17,  -1.379246956747972e-18,  -1.491661289436450e-20,  -1.086039519936344e-23,
   2.411390359199508e-24,   4.224487141376078e-26,   1.732940122325781e+00,  -4.943804215710594e-03,  -5.729876362909371e-05,  -4.064828151084481e-07,   2.944453907101379e-11,
   4.846074576999640e-11,   7.202047017820493e-13,   4.098913541810364e-15,  -4.539865711059577e-17,  -1.379348288412762e-18,  -1.488557721174514e-20,  -1.022260175099700e-23,
   2.416189262126346e-24,   4.218145046772336e-26,   1.732931158875829e+00,  -4.943994809020301e-03,  -5.729873076719033e-05,  -4.064069500618623e-07,   3.113342301320951e-11,
   4.847415699537018e-11,   7.200049343972362e-13,   4.091144691527041e-15,  -4.550311908100693e-17,  -1.379428269911816e-18,  -1.486056042843896e-20,  -9.709037811329357e-24,
   2.420044867473982e-24,   4.213020447242885e-26,   1.732925235989026e+00,  -4.944120743167756e-03,  -5.729870876285420e-05,  -4.063568159624592e-07,   3.224932151516196e-11,
   4.848301422613538e-11,   7.198728480760462e-13,   4.086011093990487e-15,  -4.557211345251682e-17,  -1.379480312582628e-18,  -1.484402252724192e-20,  -9.369798742411070e-24,
   2.422587525540685e-24,   4.209626625560070e-26,   1.732922194303639e+00,  -4.944185414362905e-03,  -5.729869737296222e-05,  -4.063310685200102e-07,   3.282236220987440e-11,
   4.848756139428841e-11,   7.198049895842310e-13,   4.083374721571657e-15,  -4.560753539166546e-17,  -1.379506789242887e-18,  -1.483552728169747e-20,  -9.195618799948387e-24,
   2.423891738076508e-24,   4.207881393785995e-26,   1.732921135617248e+00,  -4.944207923443773e-03,  -5.729869339433988e-05,  -4.063221066984777e-07,   3.302181003915395e-11,
   4.848914384797416e-11,   7.197813667005599e-13,   4.082457104132297e-15,  -4.561986273424649e-17,  -1.379515964931430e-18,  -1.483257007695556e-20,  -9.134999539104411e-24,
   2.424345432192066e-24,   4.207273577175742e-26,   1.732920967618301e+00,  -4.944211495309675e-03,  -5.729869276231005e-05,  -4.063206845718813e-07,   3.305345946188482e-11,
   4.848939495066929e-11,   7.197776178789587e-13,   4.082311490698651e-15,  -4.562181883836083e-17,  -1.379517419099581e-18,  -1.483210079235892e-20,  -9.125380366191180e-24,
   2.424417415378856e-24,   4.207177107359661e-26,   1.887517898829820e+00,  -2.290387327914047e-03,  -3.273383149538790e-05,  -3.756194860853533e-07,  -3.401271170796785e-09,
  -1.983201177427837e-11,   4.416838659454220e-14,   3.382966901700438e-15,   5.867843187835460e-17,   6.594181290135697e-19,   4.348848300076303e-21,  -1.338057340969385e-23,
  -9.480385407015002e-25,  -1.720300947165390e-26,   1.887514826199208e+00,  -2.290493035965339e-03,  -3.273574434476428e-05,  -3.756380222301413e-07,  -3.401207232561635e-09,
  -1.982531620666831e-11,   4.432279154636504e-14,   3.385190487039075e-15,   5.869658700324577e-17,   6.593442094325647e-19,   4.342903367115836e-21,  -1.350707001073975e-23,
  -9.497432145899909e-25,  -1.721574394622378e-26,   1.887509404348321e+00,  -2.290679563716246e-03,  -3.273911956796176e-05,  -3.756707244355213e-07,  -3.401094235861988e-09,
  -1.981349821400448e-11,   4.459528014611110e-14,   3.389113831957082e-15,   5.872860154751998e-17,   6.592132461722386e-19,   4.332404869486261e-21,  -1.373035048447302e-23,
  -9.527506386295973e-25,  -1.723817859825298e-26,   1.887502847939641e+00,  -2.290905122279774e-03,  -3.274320087335621e-05,  -3.757102595705320e-07,  -3.400957297764791e-09,
  -1.979920170406407e-11,   4.492484211523029e-14,   3.393857629635994e-15,   5.876727897174674e-17,   6.590539783896228e-19,   4.319695363336473e-21,  -1.400047174929042e-23,
  -9.563863917571701e-25,  -1.726524617593421e-26,   1.887496482831194e+00,  -2.291124098182433e-03,  -3.274716288097094e-05,  -3.757486304601850e-07,  -3.400824045093725e-09,
  -1.978531654673570e-11,   4.524484408193810e-14,   3.398462455463993e-15,   5.880478976806757e-17,   6.588984153637913e-19,   4.307341896875300e-21,  -1.426283478888070e-23,
  -9.599150164728578e-25,  -1.729145932525700e-26,   1.887491354996035e+00,  -2.291300507733408e-03,  -3.275035458474768e-05,  -3.757795350029929e-07,  -3.400716472366641e-09,
  -1.977412629289713e-11,   4.550268285301959e-14,   3.402171776661688e-15,   5.883498175194586e-17,   6.587724159372405e-19,   4.297379145633959e-21,  -1.447428691541087e-23,
  -9.627569812686971e-25,  -1.731253068046354e-26,   1.887487966522561e+00,  -2.291417078671401e-03,  -3.275246358710320e-05,  -3.757999529681282e-07,  -3.400645279505382e-09,
  -1.976672974397376e-11,   4.567308227103344e-14,   3.404622699130226e-15,   5.885491922887532e-17,   6.586888247974053e-19,   4.290790571761973e-21,  -1.461405760326453e-23,
  -9.646345816173890e-25,  -1.732643189812913e-26,   1.887486226351049e+00,  -2.291476944245044e-03,  -3.275354665495534e-05,  -3.758104375784961e-07,  -3.400608684321293e-09,
  -1.976293057301271e-11,   4.576059799219296e-14,   3.405881324530874e-15,   5.886515410228037e-17,   6.586457937587950e-19,   4.287405364685199e-21,  -1.468585102901256e-23,
  -9.655987201718429e-25,  -1.733356391904050e-26,   1.887485620663921e+00,  -2.291497781136607e-03,  -3.275392362572083e-05,  -3.758140866852582e-07,  -3.400595941580543e-09,
  -1.976160812705163e-11,   4.579105982888860e-14,   3.406319394163732e-15,   5.886871581073766e-17,   6.586308000143350e-19,   4.286226848235904e-21,  -1.471084169409343e-23,
  -9.659342816271933e-25,  -1.733604518219683e-26,   1.887485524549502e+00,  -2.291501087670518e-03,  -3.275398344574595e-05,  -3.758146657407491e-07,  -3.400593919224262e-09,
  -1.976139826788208e-11,   4.579589375926257e-14,   3.406388909474265e-15,   5.886928097476569e-17,   6.586284199351181e-19,   4.286039821367551e-21,  -1.471480747790739e-23,
  -9.659875298582130e-25,  -1.733643887216110e-26,   1.978230965674580e+00,  -4.672837727876055e-04,  -7.434266468979921e-06,  -1.034529572188823e-07,  -1.321624628567675e-09,
  -1.577642399981808e-11,  -1.767507121161924e-13,  -1.849448646593220e-15,  -1.777934914846065e-17,  -1.508568261117534e-19,  -1.005139591652636e-21,  -2.487759627795377e-24,
   7.512607804948948e-26,   1.945610184055825e-27,   1.978230267218249e+00,  -4.673129210861601e-04,  -7.435011287808215e-06,  -1.034677782770128e-07,  -1.321873736860560e-09,
  -1.578007319899984e-11,  -1.767974700271263e-13,  -1.849958104805232e-15,  -1.778357414342311e-17,  -1.508690889587976e-19,  -1.004661746885424e-21,  -2.473286454857917e-24,
   7.540606940941552e-26,   1.950058258943466e-27,   1.978229034724111e+00,  -4.673643571125742e-04,  -7.436325646419127e-06,  -1.034939330515246e-07,  -1.322313345860886e-09,
  -1.578651308405622e-11,  -1.768799841051126e-13,  -1.850857085080316e-15,  -1.779102756321906e-17,  -1.508906660209569e-19,  -1.003817169046004e-21,  -2.447721788340885e-24,
   7.590054624146441e-26,   1.957912929924351e-27,   1.978227544281909e+00,  -4.674265598945919e-04,  -7.437915177412464e-06,  -1.035255644321747e-07,  -1.322845016987830e-09,
  -1.579430165273348e-11,  -1.769797763677744e-13,  -1.851944198205549e-15,  -1.780003750087960e-17,  -1.509166532776663e-19,  -1.002793485347704e-21,  -2.416763468452727e-24,
   7.649920245928724e-26,   1.967421069428193e-27,   1.978226097284707e+00,  -4.674869513417155e-04,  -7.439458470304647e-06,  -1.035562766014293e-07,  -1.323361249655439e-09,
  -1.580186411692708e-11,  -1.770766690485590e-13,  -1.852999607904161e-15,  -1.780878123801478e-17,  -1.509417722960737e-19,  -1.001797184115734e-21,  -2.386662248871010e-24,
   7.708113195297282e-26,   1.976662078927043e-27,   1.978224931529696e+00,  -4.675356062507360e-04,  -7.440701872968042e-06,  -1.035810214887254e-07,  -1.323777188440252e-09,
  -1.580795738337704e-11,  -1.771547360509756e-13,  -1.853849874470210e-15,  -1.781582295914336e-17,  -1.509619297120764e-19,  -1.000992765014628e-21,  -2.362379100693826e-24,
   7.755047477402937e-26,   1.984114165512004e-27,   1.978224161183865e+00,  -4.675677586752482e-04,  -7.441523562779179e-06,  -1.035973742142036e-07,  -1.324052066902590e-09,
  -1.581198421630827e-11,  -1.772063269745079e-13,  -1.854411736109276e-15,  -1.782047496390217e-17,  -1.509752110870181e-19,  -1.000460331568043e-21,  -2.346316574213083e-24,
   7.786087657948874e-26,   1.989042118134833e-27,   1.978223765563384e+00,  -4.675842711416207e-04,  -7.441945561921266e-06,  -1.036057726608044e-07,  -1.324193240513306e-09,
  -1.581405234573236e-11,  -1.772328231260174e-13,  -1.854700285318988e-15,  -1.782286366932093e-17,  -1.509820198621837e-19,  -1.000186626893557e-21,  -2.338062545778065e-24,
   7.802036579902008e-26,   1.991574016506158e-27,   1.978223627862296e+00,  -4.675900185615076e-04,  -7.442092446106905e-06,  -1.036086959029655e-07,  -1.324242378931969e-09,
  -1.581477220227773e-11,  -1.772420456317838e-13,  -1.854800718527832e-15,  -1.782369502889249e-17,  -1.509843878322501e-19,  -1.000091317744448e-21,  -2.335188835136492e-24,
   7.807589070484117e-26,   1.992455451442020e-27,   1.978223606010946e+00,  -4.675909306028617e-04,  -7.442115754771336e-06,  -1.036091597853154e-07,  -1.324250176600626e-09,
  -1.581488643479188e-11,  -1.772435091296122e-13,  -1.854816655943005e-15,  -1.782382695177456e-17,  -1.509847635069193e-19,  -1.000076191418862e-21,  -2.334732777881925e-24,
   7.808470237045013e-26,   1.992595331787288e-27,   6.763363460811109e-03,  -1.248767540692367e-04,   1.723714005312556e-06,  -2.106592943353900e-08,   2.400752842970926e-10,
  -2.610267506651691e-12,   2.737797497018359e-14,  -2.788069454496135e-16,   2.764349011795714e-18,  -2.673371892521364e-20,   2.519360456835967e-22,  -2.312148619191842e-24,
   2.055964687313341e-26,  -1.765482760822861e-28,   6.763525330214133e-03,  -1.248826874871587e-04,   1.723849265248639e-06,  -2.106838118309326e-08,   2.401138706076961e-10,
  -2.610817847581079e-12,   2.738525342048889e-14,  -2.788974838727504e-16,   2.765415976456852e-18,  -2.674569142272137e-20,   2.520638307693501e-22,  -2.313445679709985e-24,
   2.057199381133587e-26,  -1.766579204482048e-28,   6.763810961661977e-03,  -1.248931576579994e-04,   1.724087951203723e-06,  -2.107270775372658e-08,   2.401819650908493e-10,
  -2.611789077893347e-12,   2.739809864029110e-14,  -2.790572732354625e-16,   2.767299091203657e-18,  -2.676682252679047e-20,   2.522893717421739e-22,  -2.315735015876058e-24,
   2.059378601403640e-26,  -1.768514339106698e-28,   6.764156367891613e-03,  -1.249058192580474e-04,   1.724376602942322e-06,  -2.107794020533190e-08,   2.402643198743920e-10,
  -2.612963747381576e-12,   2.741363510510471e-14,  -2.792505483318801e-16,   2.769576922041742e-18,  -2.679238376773392e-20,   2.525622043363746e-22,  -2.318504418336226e-24,
   2.062014732956801e-26,  -1.770855078873698e-28,   6.764491700744659e-03,  -1.249181119230749e-04,   1.724656852610332e-06,  -2.108302052883825e-08,   2.403442833523697e-10,
  -2.614104355326603e-12,   2.742872170827984e-14,  -2.794382352017171e-16,   2.771788984658567e-18,  -2.681720790261968e-20,   2.528271765659107e-22,  -2.321194071752832e-24,
   2.064574885955685e-26,  -1.773128218083071e-28,   6.764761853760764e-03,  -1.249280154527789e-04,   1.724882640711096e-06,  -2.108711370887410e-08,   2.404087115532101e-10,
  -2.615023399959351e-12,   2.744087819781030e-14,  -2.795894754080336e-16,   2.773571555307150e-18,  -2.683721287222541e-20,   2.530407143475076e-22,  -2.323361656768808e-24,
   2.066638058621041e-26,  -1.774959994949661e-28,   6.764940372539597e-03,  -1.249345598806622e-04,   1.725031848538585e-06,  -2.108981867252012e-08,   2.404512897820607e-10,
  -2.615630779219980e-12,   2.744891241859861e-14,  -2.796894328614706e-16,   2.774749721347923e-18,  -2.685043521283707e-20,   2.531818552908297e-22,  -2.324794367335615e-24,
   2.068001731981427e-26,  -1.776170677249294e-28,   6.765032052477917e-03,  -1.249379208663469e-04,   1.725108477321896e-06,  -2.109120788218175e-08,   2.404731573547998e-10,
  -2.615942725659031e-12,   2.745303881739871e-14,  -2.797407721741187e-16,   2.775354851075168e-18,  -2.685722657307641e-20,   2.532543499754532e-22,  -2.325530259266075e-24,
   2.068702156574288e-26,  -1.776792506114781e-28,   6.765063962839006e-03,  -1.249390907055194e-04,   1.725135149216885e-06,  -2.109169142228624e-08,   2.404807688208603e-10,
  -2.616051305951917e-12,   2.745447511866123e-14,  -2.797586423074175e-16,   2.775565485566137e-18,  -2.685959053627805e-20,   2.532795843339333e-22,  -2.325786413332051e-24,
   2.068945963769705e-26,  -1.777008952967866e-28,   6.765069026588978e-03,  -1.249392763437072e-04,   1.725139381705172e-06,  -2.109176815405666e-08,   2.404819766679035e-10,
  -2.616068536361598e-12,   2.745470304323139e-14,  -2.797614780996653e-16,   2.775598911002125e-18,  -2.685996567266052e-20,   2.532835887702236e-22,  -2.325827062410668e-24,
   2.068984653468446e-26,  -1.777043300749134e-28,   6.052093702401293e-02,  -1.092770426777539e-03,   1.438923806852814e-05,  -1.618535294566403e-07,   1.612453545969287e-09,
  -1.417623005261706e-11,   1.050872500911927e-13,  -5.547745255875931e-16,  -6.955998977978637e-20,   5.510404559859581e-20,  -9.906700283820603e-22,   1.242181782101744e-23,
  -1.250810979846999e-25,   9.903073648761615e-28,   6.052228783488887e-02,  -1.092815994840112e-03,   1.439014590600833e-05,  -1.618668288011982e-07,   1.612601321302281e-09,
  -1.417731927417831e-11,   1.050869805890629e-13,  -5.545868717023134e-16,  -7.376432680622949e-20,   5.516837677607926e-20,  -9.914458921915165e-22,   1.242904919139766e-23,
  -1.251227646373918e-25,   9.901240833277339e-28,   6.052467143126016e-02,  -1.092896403447185e-03,   1.439174786712714e-05,  -1.618902965335193e-07,   1.612862072863700e-09,
  -1.417924092160105e-11,   1.050864960605430e-13,  -5.542555767402776e-16,  -8.118560853715679e-20,   5.528192045617316e-20,  -9.928151249472472e-22,   1.244180794783775e-23,
  -1.251962170182120e-25,   9.897991298468966e-28,   6.052755381967748e-02,  -1.092993639584058e-03,   1.439368509089743e-05,  -1.619186753806128e-07,   1.613177375853755e-09,
  -1.418156408450448e-11,   1.050858948346862e-13,  -5.538546699372166e-16,  -9.016404266686972e-20,   5.541927035730557e-20,  -9.944711717073840e-22,   1.245723407287208e-23,
  -1.252849185153428e-25,   9.894035476113772e-28,   6.053035211625990e-02,  -1.093088040177746e-03,   1.439556583490911e-05,  -1.619462265551115e-07,   1.613483465918057e-09,
  -1.418381883265657e-11,   1.050852951178972e-13,  -5.534651608616237e-16,  -9.888490698613755e-20,   5.555266136801735e-20,  -9.960792056077924e-22,   1.247220749074005e-23,
  -1.253709047775402e-25,   9.890167513303148e-28,   6.053260647630318e-02,  -1.093164091962810e-03,   1.439708102431464e-05,  -1.619684224839794e-07,   1.613730047642426e-09,
  -1.418563484266746e-11,   1.050848004854636e-13,  -5.531511511729152e-16,  -1.059137298876118e-19,   5.566015819417668e-20,  -9.973748833948001e-22,   1.248426844471000e-23,
  -1.254400855194718e-25,   9.887031657706318e-28,   6.053409616069469e-02,  -1.093214347534437e-03,   1.439808227682862e-05,  -1.619830896777997e-07,   1.613892984229903e-09,
  -1.418683464077396e-11,   1.050844680049353e-13,  -5.529435483692789e-16,  -1.105599196811303e-19,   5.573120915996152e-20,  -9.982311746369384e-22,   1.249223740246928e-23,
  -1.254857554634742e-25,   9.884949802969538e-28,   6.053486119834145e-02,  -1.093240156764836e-03,   1.439859648099891e-05,  -1.619906221442526e-07,   1.613976659894204e-09,
  -1.418745073605797e-11,   1.050842955169181e-13,  -5.528369001273234e-16,  -1.129464765924597e-19,   5.576770309944186e-20,  -9.986709614837373e-22,   1.249632962482432e-23,
  -1.255091957163848e-25,   9.883877658373379e-28,   6.053512747883898e-02,  -1.093249139997717e-03,   1.439877545655425e-05,  -1.619932439137527e-07,   1.614005783964314e-09,
  -1.418766516435664e-11,   1.050842352033125e-13,  -5.527997747740146e-16,  -1.137772217544849e-19,   5.578040608359157e-20,  -9.988240397408679e-22,   1.249775392542067e-23,
  -1.255173521692554e-25,   9.883504008910900e-28,   6.053516973398818e-02,  -1.093250565517513e-03,   1.439880385760897e-05,  -1.619936599536786e-07,   1.614010405552608e-09,
  -1.418769919073263e-11,   1.050842256191962e-13,  -5.527938832327194e-16,  -1.139090534716013e-19,   5.578242191658209e-20,  -9.988483314566788e-22,   1.249797994065325e-23,
  -1.255186463842986e-25,   9.883444693111189e-28,   1.661468846059324e-01,  -2.864874516914669e-03,   3.407350867653018e-05,  -3.140143982447945e-07,   2.070333089529413e-09,
  -4.369726406418373e-12,  -1.298565743614104e-13,   2.544392571190583e-15,  -2.776478416577127e-17,   1.753385995846129e-19,   2.895620226087728e-22,  -2.629395521887644e-23,
   4.209047904973514e-25,  -4.068125903844794e-27,   1.661500813267904e-01,  -2.864962847562680e-03,   3.407467220050400e-05,  -3.140184526507385e-07,   2.070149617542783e-09,
  -4.364707795336724e-12,  -1.299294295572215e-13,   2.544980768970854e-15,  -2.776347859096354e-17,   1.752018696226903e-19,   2.921730907377109e-22,  -2.632358208236319e-23,
   4.210506392685573e-25,  -4.065940780479427e-27,   1.661557220796783e-01,  -2.865118709302770e-03,   3.407672517278364e-05,  -3.140256028858998e-07,   2.069825795047615e-09,
  -4.355851437288788e-12,  -1.300579808610735e-13,   2.546018277204836e-15,  -2.776116592215433e-17,   1.749604833777651e-19,   2.967810898353640e-22,  -2.637584604599756e-23,
   4.213074993373706e-25,  -4.062076710995328e-27,   1.661625430894813e-01,  -2.865307180555844e-03,   3.407920750541623e-05,  -3.140342424992604e-07,   2.069434083415060e-09,
  -4.345140632412066e-12,  -1.302134216237058e-13,   2.547272201897951e-15,  -2.775835413647562e-17,   1.746683850289498e-19,   3.023543717056101e-22,  -2.643902181328089e-23,
   4.216172573181311e-25,  -4.057389939404867e-27,   1.661691649659959e-01,  -2.865490146830958e-03,   3.408161716078443e-05,  -3.140426228503122e-07,   2.069053667832472e-09,
  -4.334741091265074e-12,  -1.303643157324290e-13,   2.548488818373218e-15,  -2.775560849843916e-17,   1.743845995522428e-19,   3.077661137525913e-22,  -2.650032827912960e-23,
   4.219170848894948e-25,  -4.052825129880117e-27,   1.661744995769993e-01,  -2.865637543260997e-03,   3.408355824018469e-05,  -3.140493690536941e-07,   2.068747103437808e-09,
  -4.326362154835416e-12,  -1.304858704032711e-13,   2.549468427152676e-15,  -2.775338517896110e-17,   1.741558270242999e-19,   3.121266701646615e-22,  -2.654969911996525e-23,
   4.221579911181931e-25,  -4.049137050312313e-27,   1.661780246484392e-01,  -2.865734940772872e-03,   3.408484081816658e-05,  -3.140538244261246e-07,   2.068544478978881e-09,
  -4.320824914857404e-12,  -1.305661897671564e-13,   2.550115499278960e-15,  -2.775191043282319e-17,   1.740045805534270e-19,   3.150085016220267e-22,  -2.658231422908838e-23,
   4.223168685787973e-25,  -4.046694779966803e-27,   1.661798349584623e-01,  -2.865784959233818e-03,   3.408549946702734e-05,  -3.140561117312269e-07,   2.068440405490677e-09,
  -4.317981095353280e-12,  -1.306074370468413e-13,   2.550447728803529e-15,  -2.775115134311366e-17,   1.739268842396658e-19,   3.164886000712629e-22,  -2.659906109014929e-23,
   4.223983641384739e-25,  -4.045438932690668e-27,   1.661804650561776e-01,  -2.865802368645586e-03,   3.408572871319957e-05,  -3.140569077306117e-07,   2.068404179191601e-09,
  -4.316991248987508e-12,  -1.306217934515314e-13,   2.550563352712929e-15,  -2.775088685844368e-17,   1.738998375033257e-19,   3.170037841840832e-22,  -2.660488958102441e-23,
   4.224267141889723e-25,  -4.045001564904582e-27,   1.661805650441370e-01,  -2.865805131280815e-03,   3.408576509128665e-05,  -3.140570340391446e-07,   2.068398430454923e-09,
  -4.316834172627624e-12,  -1.306240716110216e-13,   2.550581700083322e-15,  -2.775084487524037e-17,   1.738955453772863e-19,   3.170855378656481e-22,  -2.660581446290577e-23,
   4.224312122286888e-25,  -4.044932148381866e-27,   3.197395784877343e-01,  -5.125830899145237e-03,   5.115138096312570e-05,  -3.008022279651233e-07,  -4.130671840723593e-10,
   3.456721097011907e-11,  -4.246014481606488e-13,   1.875784627908945e-15,   2.591618957827211e-17,  -6.218155900068483e-19,   5.711580091052407e-21,   3.255796270153701e-25,
  -8.144430953320406e-25,   1.237998997474628e-26,   3.197443734470322e-01,  -5.125915385344002e-03,   5.115114524791915e-05,  -3.007697905327581e-07,  -4.136634675643638e-10,
   3.457087053528777e-11,  -4.245329245167235e-13,   1.873686153387718e-15,   2.594012221231928e-17,  -6.218104076097428e-19,   5.706513368439554e-21,   4.156910406725008e-25,
  -8.150362153614217e-25,   1.237246597463914e-26,   3.197528342099066e-01,  -5.126064455150700e-03,   5.115072905222501e-05,  -3.007125513931873e-07,  -4.147155406462167e-10,
   3.457732453695634e-11,  -4.244119624907087e-13,   1.869983378821337e-15,   2.598233432010473e-17,  -6.218008858658671e-19,   5.697570092091636e-21,   5.746489984423489e-25,
  -8.160810479122902e-25,   1.235916595740025e-26,   3.197630650236610e-01,  -5.126244699301343e-03,   5.115022531932741e-05,  -3.006433324758861e-07,  -4.159875847342792e-10,
   3.458512305798770e-11,  -4.242656070195962e-13,   1.865505973502468e-15,   2.603334797393245e-17,  -6.217887288347212e-19,   5.686750737889029e-21,   7.667857500143573e-25,
  -8.173415086290023e-25,   1.234304288236171e-26,   3.197729968879603e-01,  -5.126419663952800e-03,   5.114973581763867e-05,  -3.005761309896260e-07,  -4.172223228218548e-10,
   3.459268773024868e-11,  -4.241234366966111e-13,   1.861159417455948e-15,   2.608284005874876e-17,  -6.217762535739108e-19,   5.676242216602966e-21,   9.532281205214989e-25,
  -8.185620401852735e-25,   1.232734845283730e-26,   3.197809978453143e-01,  -5.126560603706790e-03,   5.114934113288224e-05,  -3.005219907942947e-07,  -4.182169112123277e-10,
   3.459877743506377e-11,  -4.240088409799961e-13,   1.857657911659224e-15,   2.612268795851324e-17,  -6.217657212760262e-19,   5.667772911144863e-21,   1.103365788699696e-24,
  -8.195430619407302e-25,   1.231467485252155e-26,   3.197862847239569e-01,  -5.126653729536875e-03,   5.114908016157006e-05,  -3.004862141792056e-07,  -4.188740682537199e-10,
   3.460279929971038e-11,  -4.239330862803617e-13,   1.855344190636331e-15,   2.614900782935443e-17,  -6.217585255774990e-19,   5.662174697645995e-21,   1.202545710157568e-24,
  -8.201902153591268e-25,   1.230628550320665e-26,   3.197889997855674e-01,  -5.126701552668875e-03,   5.114894608753913e-05,  -3.004678406380011e-07,  -4.192115346044787e-10,
   3.460486406902427e-11,  -4.238941727565853e-13,   1.854155987835211e-15,   2.616252096738661e-17,  -6.217547572224596e-19,   5.659299176309805e-21,   1.253470562691894e-24,
  -8.205222230350455e-25,   1.230197257765803e-26,   3.197899447870609e-01,  -5.126718197719040e-03,   5.114889941344315e-05,  -3.004614454731652e-07,  -4.193289904327665e-10,
   3.460558262731290e-11,  -4.238806269786008e-13,   1.853742423555271e-15,   2.616722380147539e-17,  -6.217534339880659e-19,   5.658298233938280e-21,   1.271194025086758e-24,
  -8.206377277639958e-25,   1.230047069337871e-26,   3.197900947457564e-01,  -5.126720839048395e-03,   5.114889200650807e-05,  -3.004604306445198e-07,  -4.193476289399340e-10,
   3.460569664769989e-11,  -4.238784773756762e-13,   1.853676796627677e-15,   2.616797005096589e-17,  -6.217532234571845e-19,   5.658139393857622e-21,   1.274006428054074e-24,
  -8.206560542299423e-25,   1.230023233032696e-26,   5.151495586813500e-01,  -7.437155642905818e-03,   5.527402712318645e-05,  -2.920156505075243e-08,  -4.656551810819043e-09,
   4.995552928091744e-11,   3.777595508730636e-14,  -6.940576178472055e-15,   7.175528869028134e-17,   1.914599244936373e-19,  -1.296043644387317e-20,   1.213004495656048e-22,
   6.154182614512264e-25,  -2.687796091903329e-26,   5.151547353537667e-01,  -7.437163691297531e-03,   5.527140813147825e-05,  -2.915484662000840e-08,  -4.656496476061467e-09,
   4.994187561831198e-11,   3.796318609913032e-14,  -6.939913926510891e-15,   7.170073755103014e-17,   1.920777761519828e-19,  -1.295654348964883e-20,   1.211049017987363e-22,
   6.172606287339687e-25,  -2.685995248193284e-26,   5.151638694742426e-01,  -7.437177882148992e-03,   5.526678690516415e-05,  -2.907242161617990e-08,  -4.656398623394110e-09,
   4.991778458339384e-11,   3.829344182688703e-14,  -6.938743682761162e-15,   7.160449463305966e-17,   1.931671664178101e-19,  -1.294966509306813e-20,   1.207599622863925e-22,
   6.205069511866789e-25,  -2.682813605094131e-26,   5.151749142102552e-01,  -7.437195023699665e-03,   5.526119891291206e-05,  -2.897277015688755e-08,  -4.656279934759302e-09,
   4.988865526866589e-11,   3.869259223516566e-14,  -6.937325731895033e-15,   7.148813958136497e-17,   1.944830731162661e-19,  -1.294133196134119e-20,   1.203430413700965e-22,
   6.244246608780374e-25,  -2.678959475509606e-26,   5.151856358926862e-01,  -7.437211645386034e-03,   5.525577423290458e-05,  -2.887604881742429e-08,  -4.656164332675289e-09,
   4.986037894459237e-11,   3.907987286104116e-14,  -6.935946196189593e-15,   7.137520813309267e-17,   1.957590714446736e-19,  -1.293322587931195e-20,   1.199384942621965e-22,
   6.282197645828414e-25,  -2.675210792370143e-26,   5.151942728854780e-01,  -7.437225021963866e-03,   5.525140421435553e-05,  -2.879814467059058e-08,  -4.656070932084611e-09,
   4.983760127611285e-11,   3.939171231182542e-14,  -6.934832702349663e-15,   7.128424925788175e-17,   1.967859524989212e-19,  -1.292668397285702e-20,   1.196127344453117e-22,
   6.312712206385399e-25,  -2.672185782023061e-26,   5.151999799315288e-01,  -7.437233854291979e-03,   5.524851660018725e-05,  -2.874667351313968e-08,  -4.656009080976130e-09,
   4.982255087023883e-11,   3.959769742378404e-14,  -6.934095869490148e-15,   7.122415369802992e-17,   1.974639848733350e-19,  -1.292235544912390e-20,   1.193975458243171e-22,
   6.332847150214682e-25,  -2.670184406549936e-26,   5.152029107341144e-01,  -7.437238388050518e-03,   5.524703367717202e-05,  -2.872024262575298e-08,  -4.655977276143279e-09,
   4.981482197455527e-11,   3.970345810929973e-14,  -6.933717144112180e-15,   7.119329436578783e-17,   1.978120285205738e-19,  -1.292013076851567e-20,   1.192870571089396e-22,
   6.343178585325981e-25,  -2.669155831478923e-26,   5.152039308206432e-01,  -7.437239965738028e-03,   5.524651753303721e-05,  -2.871104343410135e-08,  -4.655966199600911e-09,
   4.981213189473913e-11,   3.974026549846621e-14,  -6.933585273315661e-15,   7.118255390877436e-17,   1.979331430807939e-19,  -1.291935616533439e-20,   1.192486038341865e-22,
   6.346773131681958e-25,  -2.668797703525244e-26,   5.152040926940346e-01,  -7.437240216079704e-03,   5.524643562810950e-05,  -2.870958366430662e-08,  -4.655964441593870e-09,
   4.981170501769261e-11,   3.974610615397277e-14,  -6.933564344769890e-15,   7.118084956592656e-17,   1.979523610963220e-19,  -1.291923323305796e-20,   1.192425019873909e-22,
   6.347343470024015e-25,  -2.668740867714580e-26,   7.436634309151876e-01,  -9.290796801188916e-03,   3.980517584431203e-05,   4.000085182715515e-07,  -6.169654219985382e-09,
  -8.733638589833372e-12,   8.681812273068753e-13,  -4.593119375881733e-15,  -9.952731042622416e-17,   1.425580432038305e-18,   6.060302873734099e-21,  -2.843086580074096e-22,
   1.042096777625412e-24,   4.226656257489327e-26,   7.436671556903927e-01,  -9.290684328135516e-03,   3.980171229296878e-05,   4.000002551855083e-07,  -6.168436425020796e-09,
  -8.742605432498776e-12,   8.679205013960424e-13,  -4.588345907725950e-15,  -9.950154348123877e-17,   1.424126398646327e-18,   6.066556193395228e-21,  -2.840017092899639e-22,
   1.037882629840171e-24,   4.222808157911373e-26,   7.436737278517689e-01,  -9.290485869562885e-03,   3.979560135823289e-05,   3.999856680288668e-07,  -6.166287904489778e-09,
  -8.758419945899706e-12,   8.674605015287501e-13,  -4.579927028881251e-15,  -9.945605602349552e-17,   1.421562018378599e-18,   6.077569178324435e-21,  -2.834603224689386e-22,
   1.030456016321734e-24,   4.216016224244048e-26,   7.436816745309991e-01,  -9.290245894576235e-03,   3.978821289875516e-05,   3.999680174732873e-07,  -6.163690398309586e-09,
  -8.777530033462834e-12,   8.669043587621659e-13,  -4.569753615832337e-15,  -9.940101587228786e-17,   1.418463331926640e-18,   6.090850258972924e-21,  -2.828060623142323e-22,
   1.021491548296265e-24,   4.207800121147166e-26,   7.436893885599838e-01,  -9.290012934407189e-03,   3.978104130290714e-05,   3.999508704667362e-07,  -6.161169315982443e-09,
  -8.796068177171334e-12,   8.663645634537157e-13,  -4.559884544866563e-15,  -9.934754596818633e-17,   1.415457472810670e-18,   6.103705708668569e-21,  -2.821713269829804e-22,
   1.012805602626016e-24,   4.199820716608371e-26,   7.436956025449386e-01,  -9.289825267157241e-03,   3.977526466974899e-05,   3.999370483574237e-07,  -6.159138745773820e-09,
  -8.810992525304175e-12,   8.659297819486887e-13,  -4.551939236256814e-15,  -9.930444421366709e-17,   1.413037633452224e-18,   6.114034984919327e-21,  -2.816602856422377e-22,
   1.005820203204256e-24,   4.193390224963923e-26,   7.436997084707613e-01,  -9.289701261173119e-03,   3.977144792164993e-05,   3.999279106936362e-07,  -6.157797167650102e-09,
  -8.820849501615804e-12,   8.656425206423917e-13,  -4.546691607535491e-15,  -9.927595009351582e-17,   1.411439450271012e-18,   6.120847223955917e-21,  -2.813227422078615e-22,
   1.001210190393550e-24,   4.189139908263227e-26,   7.437018170091884e-01,  -9.289637578535358e-03,   3.976948794654849e-05,   3.999232167488650e-07,  -6.157108260763922e-09,
  -8.825910056668224e-12,   8.654950089091649e-13,  -4.543997468863444e-15,  -9.926131290598784e-17,   1.410618955194279e-18,   6.124341566440432e-21,  -2.811494419125962e-22,
   9.988445254685872e-25,   4.186956809158049e-26,   7.437025508971871e-01,  -9.289615413268780e-03,   3.976880577640643e-05,   3.999215827687296e-07,  -6.156868489594612e-09,
  -8.827671194576871e-12,   8.654436678020173e-13,  -4.543059871757690e-15,  -9.925621764748412e-17,   1.410333413919125e-18,   6.125557156897114e-21,  -2.810891302283044e-22,
   9.980214201595128e-25,   4.186196904632373e-26,   7.437026673547202e-01,  -9.289611895949025e-03,   3.976869752621362e-05,   3.999213234686324e-07,  -6.156830441648085e-09,
  -8.827950651770573e-12,   8.654355207562209e-13,  -4.542911093826435e-15,  -9.925540906921822e-17,   1.410288104328784e-18,   6.125750023629294e-21,  -2.810795599303046e-22,
   9.978908182600249e-25,   4.186076315551437e-26,   9.936788118776002e-01,  -1.019760099143736e-02,   6.259554588082002e-06,   6.999193611421314e-07,  -1.600727954631976e-09,
  -8.501108207547721e-11,   3.654069594813000e-13,   1.228789132544194e-14,  -8.142942395039538e-17,  -1.922705674018057e-18,   1.791668280407382e-20,   3.109817888568372e-22,
  -3.926221107283717e-24,  -5.071673486326073e-26,   9.936793969080364e-01,  -1.019740441946696e-02,   6.258657065376192e-06,   6.998398658441633e-07,  -1.600216609269725e-09,
  -8.498699280393243e-11,   3.651947505097518e-13,   1.228144357889546e-14,  -8.135460691204717e-17,  -1.921116412936490e-18,   1.789272023935630e-20,   3.106152484155163e-22,
  -3.919059834257843e-24,  -5.063817707443706e-26,   9.936804291353956e-01,  -1.019705758326956e-02,   6.257073605674025e-06,   6.996996134672627e-07,  -1.599314574329529e-09,
  -8.494449720459206e-11,   3.648204636395239e-13,   1.227007077880863e-14,  -8.122267296678838e-17,  -1.918313668846405e-18,   1.785047378518712e-20,   3.099689473981866e-22,
  -3.906437740582686e-24,  -5.049968419190577e-26,   9.936816771997299e-01,  -1.019663821615564e-02,   6.255159266887503e-06,   6.995300500381919e-07,  -1.598224236540603e-09,
  -8.489312862816397e-11,   3.643681432841730e-13,   1.225632608188666e-14,  -8.106327658582124e-17,  -1.914927171754151e-18,   1.779945003138109e-20,   3.091882262741087e-22,
  -3.891198962613478e-24,  -5.033242767034901e-26,   9.936828886775051e-01,  -1.019623113419800e-02,   6.253301276201092e-06,   6.993654735075352e-07,  -1.597166187294656e-09,
  -8.484327928210935e-11,   3.639293224917370e-13,   1.224299072871490e-14,  -8.090868337209094e-17,  -1.911642351517853e-18,   1.774998098645949e-20,   3.084311454728031e-22,
  -3.876430515001727e-24,  -5.017027823299270e-26,   9.936838645412197e-01,  -1.019590321746236e-02,   6.251804801254259e-06,   6.992329162272309e-07,  -1.596314145856877e-09,
  -8.480313446121533e-11,   3.635760175304735e-13,   1.223225349953339e-14,  -8.078424964667206e-17,  -1.908998099695523e-18,   1.771017513081770e-20,   3.078218450876618e-22,
  -3.864551204114263e-24,  -5.003981046477809e-26,   9.936845093319721e-01,  -1.019568654728114e-02,   6.250816103241234e-06,   6.991453362090662e-07,  -1.595751283437582e-09,
  -8.477661392244556e-11,   3.633426594343038e-13,   1.222516125002591e-14,  -8.070207722111092e-17,  -1.907251782737384e-18,   1.768389452007944e-20,   3.074195209343801e-22,
  -3.856710351368051e-24,  -4.995367685288156e-26,   9.936848404497002e-01,  -1.019557528028755e-02,   6.250308404641760e-06,   6.991003632263588e-07,  -1.595462273460649e-09,
  -8.476299634923868e-11,   3.632228496569750e-13,   1.222151988159518e-14,  -8.065989356507134e-17,  -1.906355261446377e-18,   1.767040508942664e-20,   3.072129980900048e-22,
  -3.852686413080997e-24,  -4.990946697440449e-26,   9.936849556961602e-01,  -1.019553655335053e-02,   6.250131702680309e-06,   6.990847105325547e-07,  -1.595361688342442e-09,
  -8.475825694534011e-11,   3.631811536647279e-13,   1.222025260384165e-14,  -8.064521367467837e-17,  -1.906043266119395e-18,   1.766571107096706e-20,   3.071411302249398e-22,
  -3.851286276540762e-24,  -4.989408311768120e-26,   9.936849739840867e-01,  -1.019553040794552e-02,   6.250103662853715e-06,   6.990822266924270e-07,  -1.595345727223168e-09,
  -8.475750488226963e-11,   3.631745373175097e-13,   1.222005151067051e-14,  -8.064288429774532e-17,  -1.905993758994557e-18,   1.766496624716553e-20,   3.071297264634374e-22,
  -3.851064114661424e-24,  -4.989164209169346e-26,   1.250511745195226e+00,  -9.814964176103655e-03,  -3.362842450948226e-05,   5.891534938737194e-07,   5.708085822400341e-09,
  -5.561418802834765e-11,  -1.044291447569070e-12,   4.795256706331833e-15,   1.940832274302253e-16,  -7.765921900579352e-20,  -3.570352468288929e-20,  -1.298800156088828e-22,
   6.330965774185527e-24,   5.142227935186153e-26,   1.250508598965325e+00,  -9.814798660359272e-03,  -3.362522196982403e-05,   5.891014350071450e-07,   5.706623274119991e-09,
  -5.560475186316328e-11,  -1.043785061425804e-12,   4.794977578147005e-15,   1.939338477598913e-16,  -7.831463312332442e-20,  -3.566476233614333e-20,  -1.295118298862868e-22,
   6.322091081066717e-24,   5.127968571863701e-26,   1.250503047636196e+00,  -9.814506617109888e-03,  -3.361957170556653e-05,   5.890095835074753e-07,   5.704043162365331e-09,
  -5.558810205613451e-11,  -1.042891853138813e-12,   4.794483264155397e-15,   1.936703975666235e-16,  -7.946958621641042e-20,  -3.559641007731907e-20,  -1.288630031582643e-22,
   6.306443392082108e-24,   5.102844447765361e-26,   1.250496335324047e+00,  -9.814153495556859e-03,  -3.361274048336349e-05,   5.888985279509134e-07,   5.700924248432493e-09,
  -5.556796970914710e-11,  -1.041812318207266e-12,   4.793882488721103e-15,   1.933520567422005e-16,  -8.086355221584347e-20,  -3.551383365121398e-20,  -1.280798704516089e-22,
   6.287542228404815e-24,   5.072526669434704e-26,   1.250489819561457e+00,  -9.813810712484997e-03,  -3.360611004226267e-05,   5.887907299753538e-07,   5.697897491697259e-09,
  -5.554842639192977e-11,  -1.040764891788790e-12,   4.793296080595677e-15,   1.930432534745973e-16,  -8.221405430128138e-20,  -3.543374926938136e-20,  -1.273211201226580e-22,
   6.269214434280354e-24,   5.043160133093559e-26,   1.250484570858672e+00,  -9.813534586102480e-03,  -3.360076949843952e-05,   5.887038985250783e-07,   5.695459914261018e-09,
  -5.553268313667497e-11,  -1.039921505057898e-12,   4.792821397851838e-15,   1.927946549315002e-16,  -8.330004306678165e-20,  -3.536929117400058e-20,  -1.267109550959800e-22,
   6.254464930677041e-24,   5.019549651774085e-26,   1.250481102761548e+00,  -9.813352134150998e-03,  -3.359724097995269e-05,   5.886465263525664e-07,   5.693849567978618e-09,
  -5.552228056214693e-11,  -1.039364409030085e-12,   4.792506620652044e-15,   1.926304683249138e-16,  -8.401668720741560e-20,  -3.532672622901039e-20,  -1.263082944168833e-22,
   6.244726125205728e-24,   5.003971162592074e-26,   1.250479321774791e+00,  -9.813258438645658e-03,  -3.359542904605014e-05,   5.886170643893936e-07,   5.693022689877091e-09,
  -5.551693843162632e-11,  -1.039078375060312e-12,   4.792344622803904e-15,   1.925461762703702e-16,  -8.438442221374799e-20,  -3.530487569235437e-20,  -1.261016712925832e-22,
   6.239727071481353e-24,   4.995977938064178e-26,   1.250478701893532e+00,  -9.813225827433420e-03,  -3.359479840642558e-05,   5.886068101050041e-07,   5.692734905173239e-09,
  -5.551507906839811e-11,  -1.038978828106721e-12,   4.792288183113244e-15,   1.925168417275175e-16,  -8.451236863530615e-20,  -3.529727178170281e-20,  -1.260297800662083e-22,
   6.237987469371710e-24,   4.993196948911278e-26,   1.250478603527269e+00,  -9.813220652500563e-03,  -3.359469833357866e-05,   5.886051829018205e-07,   5.692689238548772e-09,
  -5.551478401373678e-11,  -1.038963031840859e-12,   4.792279224307838e-15,   1.925121869331816e-16,  -8.453266973393038e-20,  -3.529606521077778e-20,  -1.260183731453891e-22,
   6.237711435769075e-24,   4.992755697670183e-26,   1.496575489192568e+00,  -8.098070108291422e-03,  -6.136526489901611e-05,   8.570509713947460e-08,   7.372571818031217e-09,
   5.563093593884203e-11,  -5.651308903340742e-13,  -1.434105082312196e-14,  -4.539127339491664e-17,   2.087188634063929e-18,   2.948682621895516e-20,  -9.266106765687531e-23,
  -6.680893771767321e-24,  -5.161073311861257e-26,   1.496569744526123e+00,  -8.098045820961351e-03,  -6.136112232989080e-05,   8.575701470698960e-08,   7.371775729154763e-09,
   5.560281386429949e-11,  -5.652475042506545e-13,  -1.433401945723559e-14,  -4.526819343180149e-17,   2.086696621998566e-18,   2.944580587193154e-20,  -9.302834965995519e-23,
  -6.674043144316347e-24,  -5.142679371235722e-26,   1.496559608286859e+00,  -8.098002953754450e-03,  -6.135381306577457e-05,   8.584860267306470e-08,   7.370370885461124e-09,
   5.555320326864739e-11,  -5.654530094731553e-13,  -1.432161386177912e-14,  -4.505115731196103e-17,   2.085826929637280e-18,   2.937345931149869e-20,  -9.367533590431844e-23,
  -6.661952690864660e-24,  -5.110259303219335e-26,   1.496547351975211e+00,  -8.097951098100496e-03,  -6.134497524666852e-05,   8.595931533977616e-08,   7.368671907997798e-09,
   5.549323278237188e-11,  -5.657010622824159e-13,  -1.430661520543047e-14,  -4.478895424886223e-17,   2.084772683821228e-18,   2.928603588933995e-20,  -9.445582385964893e-23,
  -6.647328697847313e-24,  -5.071118530443121e-26,   1.496535454322514e+00,  -8.097900736412360e-03,  -6.133639629538656e-05,   8.606675508571671e-08,   7.367022334248065e-09,
   5.543503455144036e-11,  -5.659414005547202e-13,  -1.429205720493269e-14,  -4.453466257656789e-17,   2.083746516779574e-18,   2.920122834179642e-20,  -9.521156769214106e-23,
  -6.633127733548231e-24,  -5.033186155556475e-26,   1.496525870131231e+00,  -8.097860150564134e-03,  -6.132948566993140e-05,   8.615327978694420e-08,   7.365693290293718e-09,
   5.538816519865030e-11,  -5.661346794493551e-13,  -1.428033121661502e-14,  -4.432998793792988e-17,   2.082917901412225e-18,   2.913295262592970e-20,  -9.581899615947287e-23,
  -6.621684604759745e-24,  -5.002674740983209e-26,   1.496519537265680e+00,  -8.097833324753166e-03,  -6.132491947998381e-05,   8.621044037364997e-08,   7.364814999152977e-09,
   5.535720180810277e-11,  -5.662622309979668e-13,  -1.427258374911402e-14,  -4.419483040495843e-17,   2.082369414210028e-18,   2.908785886495681e-20,  -9.621969454575210e-23,
  -6.614121722133423e-24,  -4.982536057824180e-26,   1.496516285097223e+00,  -8.097819546125715e-03,  -6.132257459355147e-05,   8.623979092804386e-08,   7.364363929107226e-09,
   5.534130280345585e-11,  -5.663276842108401e-13,  -1.426860531900897e-14,  -4.412544769824522e-17,   2.082087445326281e-18,   2.906470774653905e-20,  -9.642526230495616e-23,
  -6.610237368497825e-24,  -4.972200903616534e-26,   1.496515153159923e+00,  -8.097814749983709e-03,  -6.132175844559317e-05,   8.625000599792708e-08,   7.364206925985570e-09,
   5.533576935601095e-11,  -5.663504577451398e-13,  -1.426722063221092e-14,  -4.410130273410453e-17,   2.081989256616888e-18,   2.905665085215766e-20,  -9.649677861840802e-23,
  -6.608885311948221e-24,  -4.968604776476322e-26,   1.496514973537524e+00,  -8.097813988884721e-03,  -6.132162893468590e-05,   8.625162695753217e-08,   7.364182011559665e-09,
   5.533489129056915e-11,  -5.663540712089821e-13,  -1.426700090349165e-14,  -4.409747146600878e-17,   2.081973673196953e-18,   2.905537238451221e-20,  -9.650812568569795e-23,
  -6.608670755794889e-24,  -4.968034173694066e-26,   1.712257942970277e+00,  -5.420839610603422e-03,  -6.214324939897397e-05,  -3.977206379583121e-07,   1.171850509553542e-09,
   6.688509990955536e-11,   8.082897567521965e-13,   1.783862961919910e-15,  -1.051597806739586e-16,  -1.947209553497584e-18,  -1.216190763041419e-20,   1.607421017677963e-22,
   4.872322673159676e-24,   4.877517480040961e-26,   1.712252118388296e+00,  -5.420951248340462e-03,  -6.214258383862365e-05,  -3.976579047510468e-07,   1.172983886451907e-09,
   6.688850774927620e-11,   8.080126761290829e-13,   1.777313156090991e-15,  -1.052101216708233e-16,  -1.946367146356692e-18,  -1.213182422248797e-20,   1.610922032275070e-22,
   4.870960060430161e-24,   4.865623300737782e-26,   1.712241840873095e+00,  -5.421148220537369e-03,  -6.214140892936074e-05,  -3.975472084529017e-07,   1.174983430660013e-09,
   6.689451046341313e-11,   8.075236561551725e-13,   1.765758241926118e-15,  -1.052988460281357e-16,  -1.944879244770097e-18,  -1.207874857485839e-20,   1.617092551389281e-22,
   4.868542573267430e-24,   4.844632009538252e-26,   1.712229413279460e+00,  -5.421386376960336e-03,  -6.213998733415270e-05,  -3.974133489348995e-07,   1.177400760015145e-09,
   6.690175115527706e-11,   8.069321459308760e-13,   1.751789876935961e-15,  -1.054059566513011e-16,  -1.943077569292028e-18,  -1.201458091353944e-20,   1.624541941968383e-22,
   4.865596942143680e-24,   4.819242643949390e-26,   1.712217348878402e+00,  -5.421617549476324e-03,  -6.213860635024594e-05,  -3.972833958610445e-07,   1.179746895014043e-09,
   6.690876160010996e-11,   8.063577275986310e-13,   1.738233781068114e-15,  -1.055097536969320e-16,  -1.941325930080780e-18,  -1.195230066042552e-20,   1.631761042953626e-22,
   4.862713960748482e-24,   4.794588373001204e-26,   1.712207630019540e+00,  -5.421803760694175e-03,  -6.213749318569715e-05,  -3.971787040845755e-07,   1.181636504892778e-09,
   6.691439573177639e-11,   8.058948473419924e-13,   1.727316143212606e-15,  -1.055932393599561e-16,  -1.939912968494209e-18,  -1.190213756811037e-20,   1.637567600077198e-22,
   4.860374708284812e-24,   4.774722446592115e-26,   1.712201208002935e+00,  -5.421926796762610e-03,  -6.213675730235918e-05,  -3.971095240245180e-07,   1.182884926636750e-09,
   6.691811210969576e-11,   8.055889176239331e-13,   1.720103421063480e-15,  -1.056483406295080e-16,  -1.938978396812382e-18,  -1.186899514744479e-20,   1.641400034617217e-22,
   4.858820772051823e-24,   4.761593080518465e-26,   1.712197910000085e+00,  -5.421989978891444e-03,  -6.213637929085147e-05,  -3.970739962593933e-07,   1.183525989449385e-09,
   6.692001862029935e-11,   8.054317874625448e-13,   1.716399794375844e-15,  -1.056766178005613e-16,  -1.938498167699653e-18,  -1.185197631051655e-20,   1.643366801459107e-22,
   4.858020216905970e-24,   4.754849810460218e-26,   1.712196762101577e+00,  -5.422011969567506e-03,  -6.213624770453271e-05,  -3.970616304167579e-07,   1.183749107442503e-09,
   6.692068187604609e-11,   8.053770935903447e-13,   1.715110785049171e-15,  -1.056864567501861e-16,  -1.938330974704416e-18,  -1.184605296877897e-20,   1.644051134287645e-22,
   4.857741172974714e-24,   4.752502640494394e-26,   1.712196579945968e+00,  -5.422015459163930e-03,  -6.213622682283889e-05,  -3.970596681241048e-07,   1.183784512730427e-09,
   6.692078711027798e-11,   8.053684142703646e-13,   1.714906240433315e-15,  -1.056880179050855e-16,  -1.938304441349575e-18,  -1.184511302648792e-20,   1.644159718115234e-22,
   4.857696873398474e-24,   4.752130171585702e-26,   1.877802715987760e+00,  -2.571242455022630e-03,  -3.758059209784789e-05,  -4.331190355361324e-07,  -3.778444530172963e-09,
  -1.740002256907096e-11,   1.689763073466732e-13,   5.671977643602676e-15,   8.525858144388355e-17,   8.045654565027259e-19,   2.387446127341734e-21,  -8.545618765057208e-23,
  -2.167700301694797e-24,  -3.017970678657751e-26,   1.877799188550357e+00,  -2.571364326617575e-03,  -3.758271611103247e-05,  -4.331352537345708e-07,  -3.778204258382223e-09,
  -1.738881290622182e-11,   1.692003083933264e-13,   5.674681302623484e-15,   8.526821862481691e-17,   8.041162437784353e-19,   2.373937115848728e-21,  -8.567672776662648e-23,
  -2.169786241541097e-24,  -3.017716365209476e-26,   1.877792964169746e+00,  -2.571579374659346e-03,  -3.758646385526346e-05,  -4.331638624441494e-07,  -3.777780038846569e-09,
  -1.736902895780225e-11,   1.695955820730545e-13,   5.679450712672766e-15,   8.528517716384690e-17,   8.033226764916634e-19,   2.350089802133020e-21,  -8.606585777452494e-23,
  -2.173463015672726e-24,  -3.017257375496641e-26,   1.877785437306291e+00,  -2.571839419348528e-03,  -3.759099547922845e-05,  -4.331984418092973e-07,  -3.777266631225727e-09,
  -1.734509862802385e-11,   1.700735857905443e-13,   5.685215820225455e-15,   8.530560443882358e-17,   8.023615103748112e-19,   2.321235570235420e-21,  -8.653636939237777e-23,
  -2.177902353689824e-24,  -3.016684877566290e-26,   1.877778130068611e+00,  -2.572091872826379e-03,  -3.759539450393648e-05,  -4.332319955747893e-07,  -3.776767766534718e-09,
  -1.732185976418344e-11,   1.705376596301491e-13,   5.690810270827643e-15,   8.532535194479834e-17,   8.014267765598861e-19,   2.293205752994140e-21,  -8.699310350072547e-23,
  -2.182205005947264e-24,  -3.016110790926526e-26,   1.877772243245950e+00,  -2.572295250789229e-03,  -3.759893815953038e-05,  -4.332590150992356e-07,  -3.776365559844491e-09,
  -1.730313331190375e-11,   1.709115372883043e-13,   5.695315498150528e-15,   8.534120083130680e-17,   8.006725847032826e-19,   2.270611961706850e-21,  -8.736102038291639e-23,
  -2.185666158584646e-24,  -3.015635185615840e-26,   1.877768353237048e+00,  -2.572429641636633e-03,  -3.760127967470622e-05,  -4.332768637561144e-07,  -3.776099628331784e-09,
  -1.729075650076135e-11,   1.711586015960820e-13,   5.698291693299720e-15,   8.535164437721942e-17,   8.001736492188211e-19,   2.255675862636411e-21,  -8.760412229474949e-23,
  -2.187950771783895e-24,  -3.015314483764211e-26,   1.877766355500001e+00,  -2.572498658482233e-03,  -3.760248213334464e-05,  -4.332860282365500e-07,  -3.775963010139298e-09,
  -1.728439957956692e-11,   1.712854848347319e-13,   5.699819870926539e-15,   8.535699863148092e-17,   7.999172429354609e-19,   2.248003444449695e-21,  -8.772896332124791e-23,
  -2.189123270225012e-24,  -3.015147798902649e-26,   1.877765660164337e+00,  -2.572522680541214e-03,  -3.760290065667143e-05,  -4.332892177537770e-07,  -3.775915451024009e-09,
  -1.728218686177346e-11,   1.713296483275284e-13,   5.700351728766596e-15,   8.535886079473066e-17,   7.998279698775599e-19,   2.245332668078049e-21,  -8.777241483368698e-23,
  -2.189531248039767e-24,  -3.015089465997960e-26,   1.877765549823907e+00,  -2.572526492516541e-03,  -3.760296707039729e-05,  -4.332897238736955e-07,  -3.775907903672258e-09,
  -1.728183572761250e-11,   1.713366564950113e-13,   5.700436125458792e-15,   8.535915622631318e-17,   7.998138021196425e-19,   2.244908837415290e-21,  -8.777930996411374e-23,
  -2.189595982754652e-24,  -3.015080194333142e-26,   1.976234478776642e+00,  -5.321086983233182e-04,  -8.813787992855102e-06,  -1.273724924705886e-07,  -1.684122407216015e-09,
  -2.070944537828776e-11,  -2.373730383835824e-13,  -2.513174554989406e-15,  -2.394747602320003e-17,  -1.917504750626078e-19,  -9.895522733178571e-22,   4.488190664405899e-24,
   2.394287446504616e-25,   4.742494981759778e-27,   1.976233650580116e+00,  -5.321445903088696e-04,  -8.814737198675918e-06,  -1.273919492341463e-07,  -1.684456956936204e-09,
  -2.071440346314232e-11,  -2.374359854486388e-13,  -2.513821067060844e-15,  -2.395160197385736e-17,  -1.917259600168172e-19,  -9.880417190148411e-22,   4.523392482702885e-24,
   2.400553192812771e-25,   4.751946334437979e-27,   1.976232189141721e+00,  -5.322079267391626e-04,  -8.816412240474668e-06,  -1.274262847822267e-07,  -1.685047347189378e-09,
  -2.072315311648731e-11,  -2.375470653125815e-13,  -2.514961779520877e-15,  -2.395887707220017e-17,  -1.916825547283516e-19,  -9.853731607172374e-22,   4.585562979771649e-24,
   2.411617758152746e-25,   4.768634131816645e-27,   1.976230421831010e+00,  -5.322845214277994e-04,  -8.818437980148301e-06,  -1.274678101441795e-07,  -1.685761376179608e-09,
  -2.073373505483688e-11,  -2.376813992294522e-13,  -2.516341024546459e-15,  -2.396766531389203e-17,  -1.916298158972884e-19,  -9.821409179968712e-22,   4.660836308508515e-24,
   2.425011744366134e-25,   4.788831501889165e-27,   1.976228706026722e+00,  -5.323588861855112e-04,  -8.820404806748161e-06,  -1.275081290022014e-07,  -1.686454671754751e-09,
  -2.074400966460202e-11,  -2.378118239253464e-13,  -2.517679849211779e-15,  -2.397618747306482e-17,  -1.915783531290934e-19,  -9.789974609105809e-22,   4.734011043244458e-24,
   2.438029684413302e-25,   4.808457930079098e-27,   1.976227323704206e+00,  -5.324187991709967e-04,  -8.821989452726719e-06,  -1.275406141906449e-07,  -1.687013273795678e-09,
  -2.075228808005150e-11,  -2.379169035739568e-13,  -2.518758300907611e-15,  -2.398304613370899e-17,  -1.915367055009950e-19,  -9.764610806056007e-22,   4.793031841473814e-24,
   2.448527726951373e-25,   4.824282461187967e-27,   1.976226410244625e+00,  -5.324583913974264e-04,  -8.823036654558319e-06,  -1.275620821948257e-07,  -1.687382433190714e-09,
  -2.075775895747038e-11,  -2.379863438196396e-13,  -2.519470879366386e-15,  -2.398757494108948e-17,  -1.915090924555433e-19,  -9.747831005679099e-22,   4.832067092390413e-24,
   2.455470014051810e-25,   4.834745754796101e-27,   1.976225941125355e+00,  -5.324787247639033e-04,  -8.823574472495778e-06,  -1.275731077752767e-07,  -1.687572028157243e-09,
  -2.076056871518007e-11,  -2.380220064043369e-13,  -2.519836809115906e-15,  -2.398989968747166e-17,  -1.914948830510599e-19,  -9.739207633859215e-22,   4.852124499945476e-24,
   2.459036870983006e-25,   4.840121236579950e-27,   1.976225777841857e+00,  -5.324858021158329e-04,  -8.823761669680969e-06,  -1.275769454462358e-07,  -1.687638020643073e-09,
  -2.076154670898267e-11,  -2.380344193634729e-13,  -2.519964172183522e-15,  -2.399070867543245e-17,  -1.914899327540690e-19,  -9.736205212397334e-22,   4.859107406041138e-24,
   2.460278612559645e-25,   4.841992553358287e-27,   1.976225751930909e+00,  -5.324869252006419e-04,  -8.823791375520538e-06,  -1.275775544373046e-07,  -1.687648492847172e-09,
  -2.076170190464440e-11,  -2.380363891419477e-13,  -2.519984382846989e-15,  -2.399083704302145e-17,  -1.914891469924904e-19,  -9.735728723031747e-22,   4.860215579759363e-24,
   2.460475672396841e-25,   4.842289521277950e-27,   6.289922092851075e-03,  -1.120366543073376e-04,   1.492356104460568e-06,  -1.760915195400809e-08,   1.938564387918471e-10,
  -2.037703713688092e-12,   2.067792000175689e-14,  -2.039843124961416e-16,   1.961232721289705e-18,  -1.843040840180480e-20,   1.690121712653749e-22,  -1.515574976571253e-24,
   1.318517459248212e-26,  -1.120775164902344e-28,   6.290062220195455e-03,  -1.120416136131424e-04,   1.492465313008518e-06,  -1.761106568333024e-08,   1.938855781403136e-10,
  -2.038106300142300e-12,   2.068308301589941e-14,  -2.040467196779161e-16,   1.961948376432026e-18,  -1.843825513579656e-20,   1.690941121095233e-22,  -1.516398478383441e-24,
   1.319288931739741e-26,  -1.121488109367730e-28,   6.290309485446219e-03,  -1.120503648245629e-04,   1.492658026552576e-06,  -1.761444279603046e-08,   1.939370008884987e-10,
  -2.038816770274781e-12,   2.069219476461932e-14,  -2.041568596877433e-16,   1.963211442568543e-18,  -1.845210427777400e-20,   1.692387368707109e-22,  -1.517851984583060e-24,
   1.320650585055933e-26,  -1.122746425116945e-28,   6.290608495462699e-03,  -1.120609476303195e-04,   1.492891080582194e-06,  -1.761852696065340e-08,   1.939991919022648e-10,
  -2.039676048883224e-12,   2.070321539608381e-14,  -2.042900789253967e-16,   1.964739235502935e-18,  -1.846885670290645e-20,   1.694136849371929e-22,  -1.519610303398940e-24,
   1.322297755475767e-26,  -1.124268528860445e-28,   6.290898784116777e-03,  -1.120712220176967e-04,   1.493117349229187e-06,  -1.762249234562379e-08,   1.940595764162187e-10,
  -2.040510400293183e-12,   2.071391676547795e-14,  -2.044194443593343e-16,   1.966222893066189e-18,  -1.848512584165164e-20,   1.695835908952767e-22,  -1.521318006767291e-24,
   1.323897475383831e-26,  -1.125746720271888e-28,   6.291132647562205e-03,  -1.120794994914289e-04,   1.493299645383963e-06,  -1.762568720134297e-08,   1.941082289586158e-10,
  -2.041182670934401e-12,   2.072253960671858e-14,  -2.045236870644872e-16,   1.967418468519236e-18,  -1.849823647329873e-20,   1.697205146647159e-22,  -1.522694253539600e-24,
   1.325186673036519e-26,  -1.126937932402780e-28,   6.291287185590690e-03,  -1.120849693732511e-04,   1.493420111796759e-06,  -1.762779849760647e-08,   1.941403813955177e-10,
  -2.041626958076837e-12,   2.072823838505922e-14,  -2.045925823001246e-16,   1.968208659884092e-18,  -1.850690191219891e-20,   1.698110158107233e-22,  -1.523603918875222e-24,
   1.326038788984598e-26,  -1.127725259985027e-28,   6.291366549880133e-03,  -1.120877785042292e-04,   1.493481979649762e-06,  -1.762888280880183e-08,   1.941568943557704e-10,
  -2.041855140168673e-12,   2.073116527685804e-14,  -2.046279674796931e-16,   1.968614515520839e-18,  -1.851135269997974e-20,   1.698575000135825e-22,  -1.524071157819265e-24,
   1.326476464639835e-26,  -1.128129650890088e-28,   6.291394173605374e-03,  -1.120887562615139e-04,   1.493503513734264e-06,  -1.762926022272276e-08,   1.941626420251754e-10,
  -2.041934564121779e-12,   2.073218405554946e-14,  -2.046402842809249e-16,   1.968755785978837e-18,  -1.851290194414375e-20,   1.698736804656002e-22,  -1.524233797710686e-24,
   1.326628813337640e-26,  -1.128270412478923e-28,   6.291398557122354e-03,  -1.120889114187711e-04,   1.493506930916447e-06,  -1.762932011356422e-08,   1.941635541098095e-10,
  -2.041947167755817e-12,   2.073234572393760e-14,  -2.046422388192418e-16,   1.968778204067320e-18,  -1.851314779292245e-20,   1.698762481374415e-22,  -1.524259607043368e-24,
   1.326652989532216e-26,  -1.128292749861611e-28,   5.636837412034225e-02,  -9.850075880145704e-04,   1.259286443666992e-05,  -1.381907007469980e-07,   1.352897218698254e-09,
  -1.183920764850081e-11,   8.977180030221323e-14,  -5.319379996861136e-16,   1.317818035289775e-18,   2.481414944710302e-20,  -5.593309331811676e-22,   7.535205863330207e-24,
  -8.098570082771682e-26,   7.069265390537267e-28,   5.636955622818705e-02,  -9.850464932010027e-04,   1.259362615270137e-05,  -1.382018087747406e-07,   1.353023500296421e-09,
  -1.184025354877674e-11,   8.977521045030003e-14,  -5.318532332196647e-16,   1.315442179542053e-18,   2.485320422401289e-20,  -5.598339461504404e-22,   7.540382157448303e-24,
  -8.102705059923216e-26,   7.070524947747868e-28,   5.637164213424968e-02,  -9.851151445570059e-04,   1.259497027040217e-05,  -1.382214098614957e-07,   1.353246330045808e-09,
  -1.184209892011558e-11,   8.978122263011984e-14,  -5.317035541437560e-16,   1.311248217688673e-18,   2.492213869963015e-20,  -5.607217282885780e-22,   7.549516551011877e-24,
  -8.109999657888742e-26,   7.072741679018935e-28,   5.637416453334226e-02,  -9.851981628454987e-04,   1.259659569040869e-05,  -1.382451130640050e-07,   1.353515784776137e-09,
  -1.184433013058772e-11,   8.978848395763098e-14,  -5.315223775886186e-16,   1.306173889020147e-18,   2.500553201906422e-20,  -5.617955982645478e-22,   7.560563218692127e-24,
  -8.118817570861516e-26,   7.075412319906916e-28,   5.637661333859845e-02,  -9.852787601029793e-04,   1.259817372318741e-05,  -1.382681251457172e-07,   1.353777373687795e-09,
  -1.184649590771321e-11,   8.979552405201391e-14,  -5.313463028190214e-16,   1.301244733793043e-18,   2.508652757447144e-20,  -5.628384636260858e-22,   7.571288450364913e-24,
  -8.127374915518164e-26,   7.077994608012721e-28,   5.637858613870025e-02,  -9.853436914585478e-04,   1.259944503979660e-05,  -1.382866643990135e-07,   1.353988111270493e-09,
  -1.184824045511528e-11,   8.980118895481980e-14,  -5.312043218809057e-16,   1.297271659759714e-18,   2.515180431711032e-20,  -5.636788481526715e-22,   7.579929499682697e-24,
  -8.134266494236267e-26,   7.080067465510173e-28,   5.637988976630907e-02,  -9.853865985344416e-04,   1.260028513936015e-05,  -1.382989153064925e-07,   1.354127365336795e-09,
  -1.184939313548534e-11,   8.980492903540801e-14,  -5.311104361199402e-16,   1.294645240628906e-18,   2.519495162667689e-20,  -5.642342893762469e-22,   7.585639811588302e-24,
  -8.138819292833881e-26,   7.081433548170427e-28,   5.638055925273392e-02,  -9.854086338635533e-04,   1.260071658187733e-05,  -1.383052068880337e-07,   1.354198879712800e-09,
  -1.184998506556598e-11,   8.980684876016743e-14,  -5.310622004773253e-16,   1.293296113897723e-18,   2.521711404102842e-20,  -5.645195752514523e-22,   7.588572472196610e-24,
  -8.141157052543297e-26,   7.082133975747228e-28,   5.638079227540951e-02,  -9.854163035400696e-04,   1.260086675117858e-05,  -1.383073967551805e-07,   1.354223771065635e-09,
  -1.185019108804069e-11,   8.980751678102734e-14,  -5.310454083065902e-16,   1.292826484673985e-18,   2.522482854197443e-20,  -5.646188780171660e-22,   7.589593234202622e-24,
  -8.141970680196942e-26,   7.082377587452919e-28,   5.638082925298407e-02,  -9.854175206158273e-04,   1.260089058106312e-05,  -1.383077442581039e-07,   1.354227720986186e-09,
  -1.185022378077013e-11,   8.980762277928768e-14,  -5.310427434630474e-16,   1.292751958453151e-18,   2.522605275882056e-20,  -5.646346363024882e-22,   7.589755216148549e-24,
  -8.142099789277060e-26,   7.082416236799785e-28,   1.552094825861814e-01,  -2.606803636963923e-03,   3.050071734097063e-05,  -2.817350665828237e-07,   1.957049676240860e-09,
  -6.725903256723493e-12,  -7.009882127506693e-14,   1.757213256000626e-15,  -2.147408303931039e-17,   1.690157117671246e-19,  -4.925164236296965e-22,  -1.070467317824694e-23,
   2.388407561531320e-25,  -2.899873595900785e-27,   1.552123442315566e-01,  -2.606882896896986e-03,   3.050181761869628e-05,  -2.817413429330332e-07,   1.956950432788160e-09,
  -6.722434703104374e-12,  -7.015523241132197e-14,   1.757782219261894e-15,  -2.147611300811174e-17,   1.689596899942959e-19,  -4.910301428430898e-22,  -1.072589687674226e-23,
   2.390235058617952e-25,  -2.900213491116271e-27,   1.552173937337114e-01,  -2.607022753727941e-03,   3.050375903053907e-05,  -2.817524150053960e-07,   1.956775251641489e-09,
  -6.716313475624266e-12,  -7.025477505338268e-14,   1.758786009577481e-15,  -2.147968981488830e-17,   1.688607497039423e-19,  -4.884066595559670e-22,  -1.076334839053046e-23,
   2.393457992124621e-25,  -2.900808991439718e-27,   1.552234997886746e-01,  -2.607191872543811e-03,   3.050610652885843e-05,  -2.817657989609289e-07,   1.956563310723598e-09,
  -6.708910070405620e-12,  -7.037515041213861e-14,   1.759999540274157e-15,  -2.148400622107241e-17,   1.687409583052926e-19,  -4.852327517847764e-22,  -1.080863849245144e-23,
   2.397352272873777e-25,  -2.901521825684048e-27,   1.552294275908892e-01,  -2.607356052719092e-03,   3.050838535827900e-05,  -2.817787871470571e-07,   1.956357446950197e-09,
  -6.701721348222917e-12,  -7.049201639562779e-14,   1.761177338952800e-15,  -2.148818739307045e-17,   1.686245079788097e-19,  -4.821499402729872e-22,  -1.085260880579556e-23,
   2.401129706960991e-25,  -2.902206234077037e-27,   1.552342030585616e-01,  -2.607488315964451e-03,   3.051022109534730e-05,  -2.817892468741475e-07,   1.956191523228732e-09,
  -6.695929043285020e-12,  -7.058616760019590e-14,   1.762125960408927e-15,  -2.149154915418150e-17,   1.685305832465213e-19,  -4.796652951890826e-22,  -1.088803318645548e-23,
   2.404170559420196e-25,  -2.902752136250685e-27,   1.552373586550626e-01,  -2.607575714057290e-03,   3.051143408915809e-05,  -2.817961568170619e-07,   1.956081843373034e-09,
  -6.692101021585325e-12,  -7.064838372332793e-14,   1.762752695638382e-15,  -2.149376734472449e-17,   1.684684637039513e-19,  -4.780229122447265e-22,  -1.091144218825203e-23,
   2.406178822758616e-25,  -2.903110189484035e-27,   1.552389792211024e-01,  -2.607620597437025e-03,   3.051205701069130e-05,  -2.817997048904606e-07,   1.956025505019745e-09,
  -6.690134973080864e-12,  -7.068033550908532e-14,   1.763074524177549e-15,  -2.149490550150315e-17,   1.684365451040728e-19,  -4.771792926306326e-22,  -1.092346420117663e-23,
   2.407209828553668e-25,  -2.903293241146719e-27,   1.552395432765397e-01,  -2.607636219552502e-03,   3.051227382282986e-05,  -2.818009397482391e-07,   1.956005893950007e-09,
  -6.689450643844639e-12,  -7.069145675274523e-14,   1.763186534772326e-15,  -2.149530148973661e-17,   1.684254327980230e-19,  -4.768856348621472e-22,  -1.092764863172138e-23,
   2.407568626447240e-25,  -2.903356822455577e-27,   1.552396327844921e-01,  -2.607638698569172e-03,   3.051230822786354e-05,  -2.818011356992850e-07,   1.956002781848859e-09,
  -6.689342048888003e-12,  -7.069322154721616e-14,   1.763204309084350e-15,  -2.149536432013086e-17,   1.684236692977764e-19,  -4.768390340782310e-22,  -1.092831264601136e-23,
   2.407625560209591e-25,  -2.903366905690369e-27,   3.000317222560082e-01,  -4.731121673088004e-03,   4.752317292519414e-05,  -3.024149354578111e-07,   1.810292260386091e-10,
   2.508163444194969e-11,  -3.635227638280423e-13,   2.390458651939996e-15,   7.557728902099681e-18,  -4.024405922333603e-19,   5.072947386443606e-21,  -2.515776221524028e-23,
  -2.873705500612710e-25,   7.792073125073839e-27,   3.000361777432912e-01,  -4.731206644150596e-03,   4.752327186986002e-05,  -3.023913821066410e-07,   1.805182636657306e-10,
   2.508631898358358e-11,  -3.635024842119248e-13,   2.389097102810186e-15,   7.579071977060439e-18,  -4.025680901617989e-19,   5.071136757965361e-21,  -2.510068265651315e-23,
  -2.880734584355041e-25,   7.793911745832073e-27,   3.000440395280109e-01,  -4.731356571537060e-03,   4.752344622566857e-05,  -3.023498182835030e-07,   1.796166858655708e-10,
   2.509458275019121e-11,  -3.634666549962152e-13,   2.386694279708889e-15,   7.616725930387250e-18,  -4.027928228838432e-19,   5.067938346744359e-21,  -2.499995416691857e-23,
  -2.893130996304656e-25,   7.797139558263603e-27,   3.000535460945572e-01,  -4.731537856143374e-03,   4.752365666025644e-05,  -3.022995527878995e-07,   1.785265281974906e-10,
   2.510457166624078e-11,  -3.634232523296773e-13,   2.383788167009308e-15,   7.662246848133738e-18,  -4.030641639019510e-19,   5.064064779096905e-21,  -2.487813400615564e-23,
  -2.908109749218437e-25,   7.801014597591423e-27,   3.000627749178390e-01,  -4.731713834475411e-03,   4.752386052940564e-05,  -3.022507495529818e-07,   1.774682637701968e-10,
   2.511426483822985e-11,  -3.633810365261094e-13,   2.380966342347342e-15,   7.706426609288031e-18,  -4.033271495735566e-19,   5.060298091092051e-21,  -2.475985413473984e-23,
  -2.922639206096177e-25,   7.804747034097528e-27,   3.000702095471912e-01,  -4.731855593433927e-03,   4.752402446489260e-05,  -3.022114297443395e-07,   1.766157696669125e-10,
   2.512207074057619e-11,  -3.633469698193532e-13,   2.378692672729189e-15,   7.742009248359747e-18,  -4.035387010869929e-19,   5.057259187480680e-21,  -2.466455587818160e-23,
  -2.934335587182273e-25,   7.807732786544468e-27,   3.000751222223902e-01,  -4.731949261851104e-03,   4.752413264422053e-05,  -3.021854456843007e-07,   1.760524714307175e-10,
   2.512722737512769e-11,  -3.633244306513039e-13,   2.377190054938717e-15,   7.765517701395704e-18,  -4.036783405632997e-19,   5.055248927330318e-21,  -2.460157788743062e-23,
  -2.942060250683678e-25,   7.809695413658413e-27,   3.000776451175790e-01,  -4.731997364020702e-03,   4.752418815423093e-05,  -3.021721009363266e-07,   1.757631953764655e-10,
   2.512987513102365e-11,  -3.633128468983860e-13,   2.376418321604211e-15,   7.777589203628396e-18,  -4.037500057261807e-19,   5.054215880263087e-21,  -2.456923363971238e-23,
  -2.946025967346460e-25,   7.810700130054280e-27,   3.000785232345781e-01,  -4.732014106255049e-03,   4.752420746779447e-05,  -3.021674560647691e-07,   1.756625109201487e-10,
   2.513079663941647e-11,  -3.633088136643362e-13,   2.376149702054350e-15,   7.781790607321610e-18,  -4.037749420568998e-19,   5.053856210164614e-21,  -2.455797560440883e-23,
  -2.947406069473182e-25,   7.811049323527614e-27,   3.000786625796628e-01,  -4.732016763009167e-03,   4.752421053224902e-05,  -3.021667189824098e-07,   1.756465337179318e-10,
   2.513094286691246e-11,  -3.633081735790466e-13,   2.376107075323592e-15,   7.782457303051724e-18,  -4.037788987585374e-19,   5.053799130317862e-21,  -2.455618909389735e-23,
  -2.947625063088698e-25,   7.811104711641570e-27,   4.862814132456839e-01,  -6.997555739591332e-03,   5.450954039397054e-05,  -9.572560712871479e-08,  -3.662760408742738e-09,
   4.879264258787459e-11,  -1.240287663101992e-13,  -4.623409637132434e-15,   7.064816390012261e-17,  -2.160061554154910e-19,  -7.405717946737437e-21,   1.228418008290560e-22,
  -4.331167751530311e-25,  -1.333639358482286e-26,   4.862865193671739e-01,  -6.997582501530501e-03,   5.450747912428763e-05,  -9.567994075221560e-08,  -3.662932639386620e-09,
   4.878352896955816e-11,  -1.238439624556980e-13,  -4.624122259639089e-15,   7.061683834064250e-17,  -2.153765700639774e-19,  -7.408305817824823e-21,   1.227437909111401e-22,
  -4.311276295410166e-25,  -1.334530286911175e-26,   4.862955290417839e-01,  -6.997629712965276e-03,   5.450384190320069e-05,  -9.559936866103939e-08,  -3.663236332042891e-09,
   4.876744671387155e-11,  -1.235179400451335e-13,  -4.625377968578856e-15,   7.056155510210421e-17,  -2.142660681489149e-19,  -7.412862173339115e-21,   1.225707985538400e-22,
  -4.276197860725244e-25,  -1.336097494259208e-26,   4.863064233687370e-01,  -6.997686783757295e-03,   5.449944360315066e-05,  -9.550195187597405e-08,  -3.663603200686046e-09,
   4.874799794884073e-11,  -1.231238243422403e-13,  -4.626893445289381e-15,   7.049469104483318e-17,  -2.129239388896266e-19,  -7.418354751035524e-21,   1.223615253422702e-22,
  -4.233815356647918e-25,  -1.337984312955162e-26,   4.863169991122690e-01,  -6.997742168477331e-03,   5.449517366993323e-05,  -9.540739375564897e-08,  -3.663958973742365e-09,
   4.872911540613153e-11,  -1.227413431190602e-13,  -4.628361566141001e-15,   7.042976492411395e-17,  -2.116217578535163e-19,  -7.423669040278063e-21,   1.221582735775344e-22,
  -4.192707521590523e-25,  -1.339807354133849e-26,   4.863255185927527e-01,  -6.997786772349544e-03,   5.449173376725149e-05,  -9.533122785462767e-08,  -3.664245310052939e-09,
   4.871390243088876e-11,  -1.224333068373476e-13,  -4.629542060737386e-15,   7.037745009250344e-17,  -2.105732643720410e-19,  -7.427937408017894e-21,   1.219944701753831e-22,
  -4.159617650502165e-25,  -1.341269778733987e-26,   4.863311480152851e-01,  -6.997816239263478e-03,   5.448946069189488e-05,  -9.528090313756680e-08,  -3.664434383885793e-09,
   4.870384926132691e-11,  -1.222298038751469e-13,  -4.630321031451176e-15,   7.034287591178443e-17,  -2.098806964620722e-19,  -7.430751626959097e-21,   1.218861993539869e-22,
  -4.137765219893392e-25,  -1.342233091829467e-26,   4.863340389626815e-01,  -6.997831369914271e-03,   5.448829334380522e-05,  -9.525506033380763e-08,  -3.664531441496640e-09,
   4.869868625937508e-11,  -1.221253083335624e-13,  -4.630720736527747e-15,   7.032511872523156e-17,  -2.095251094729183e-19,  -7.432194933057481e-21,   1.218305870860002e-22,
  -4.126546900257468e-25,  -1.342726862154950e-26,   4.863350451785524e-01,  -6.997836635954351e-03,   5.448788703520389e-05,  -9.524606572365090e-08,  -3.664565216784039e-09,
   4.869688919451495e-11,  -1.220889397677868e-13,  -4.630859804426667e-15,   7.031893790487726e-17,  -2.094013568656122e-19,  -7.432696981754848e-21,   1.218112291329036e-22,
  -4.122642890148933e-25,  -1.342898574289728e-26,   4.863352048509233e-01,  -6.997837471587124e-03,   5.448782255951031e-05,  -9.524463841307100e-08,  -3.664570576148282e-09,
   4.869660402342183e-11,  -1.220831686752809e-13,  -4.630881870065592e-15,   7.031795708104561e-17,  -2.093817196341438e-19,  -7.432776635385618e-21,   1.218081572167071e-22,
  -4.122023407363183e-25,  -1.342925815560672e-26,   7.071651494936539e-01,  -8.954839292643069e-03,   4.401076054114395e-05,   3.009791946036101e-07,  -6.148035230361551e-09,
   1.024803985806108e-11,   7.028983087880060e-13,  -6.933374039023958e-15,  -4.667305159640702e-17,   1.439233370155204e-18,  -4.711746353457674e-21,  -1.941483987093599e-22,
   2.446939789914408e-24,   1.159035791324429e-26,   7.071692685634186e-01,  -8.954754608996453e-03,   4.400730784855651e-05,   3.009886880775517e-07,  -6.147048235763276e-09,
   1.023446659618835e-11,   7.027753930908692e-13,  -6.928542631018614e-15,  -4.669245005820569e-17,   1.438235652109084e-18,  -4.696811381628515e-21,  -1.940623109084287e-22,
   2.442498328574320e-24,   1.161468102476733e-26,   7.071765364644313e-01,  -8.954605181216576e-03,   4.400121596910119e-05,   3.010054291401497e-07,  -6.145306808925493e-09,
   1.021052408207399e-11,   7.025584652975167e-13,  -6.920020270609968e-15,  -4.672662790529460e-17,   1.436475525137619e-18,  -4.670480671185011e-21,  -1.939102644851125e-22,
   2.434666716751621e-24,   1.165749108733499e-26,   7.071853244406232e-01,  -8.954424487878778e-03,   4.399385037220647e-05,   3.010256550168867e-07,  -6.143201296852228e-09,
   1.018158569841989e-11,   7.022960838668891e-13,  -6.909719604104983e-15,  -4.676786914128296e-17,   1.434347778815664e-18,  -4.638679269311784e-21,  -1.937261646925771e-22,
   2.425205881963367e-24,   1.170907276490159e-26,   7.071938551873430e-01,  -8.954249070073299e-03,   4.398670078329546e-05,   3.010452715277062e-07,  -6.141157553403143e-09,
   1.015350659392907e-11,   7.020412952811234e-13,  -6.899724777289987e-15,  -4.680781439937148e-17,   1.432282847220761e-18,  -4.607846761611446e-21,  -1.935471892317540e-22,
   2.416031134645477e-24,   1.175895420777583e-26,   7.072007271103448e-01,  -8.954107753019802e-03,   4.398094174422394e-05,   3.010610611393259e-07,  -6.139511320288676e-09,
   1.013089630129163e-11,   7.018359885042144e-13,  -6.891676572050370e-15,  -4.683992861133590e-17,   1.430619829624553e-18,  -4.583036953138968e-21,  -1.934028269252826e-22,
   2.408647002480424e-24,   1.179899984141834e-26,   7.072052677903276e-01,  -8.954014371882110e-03,   4.397713655618823e-05,   3.010714881745383e-07,  -6.138423606932178e-09,
   1.011596065363403e-11,   7.017002998112164e-13,  -6.886360173506317e-15,  -4.686111722124278e-17,   1.429521164773903e-18,  -4.566657001069106e-21,  -1.933073459308649e-22,
   2.403771089468793e-24,   1.182539368830940e-26,   7.072075995959474e-01,  -8.953966415783575e-03,   4.397518249738833e-05,   3.010768409588829e-07,  -6.137865041344870e-09,
   1.010829197769500e-11,   7.016306092536420e-13,  -6.883630477904860e-15,  -4.687198872825635e-17,   1.428957018207720e-18,  -4.558249417663115e-21,  -1.932582843957232e-22,
   2.401268123074003e-24,   1.183892730355396e-26,   7.072084111941577e-01,  -8.953949724158063e-03,   4.397450238323072e-05,   3.010787037265717e-07,  -6.137670631818091e-09,
   1.010562306259761e-11,   7.016063515563086e-13,  -6.882680466634441e-15,  -4.687577108678127e-17,   1.428760673040244e-18,  -4.555323766614618e-21,  -1.932412037079431e-22,
   2.400397109567501e-24,   1.184363447831248e-26,   7.072085399832321e-01,  -8.953947075423829e-03,   4.397439445914059e-05,   3.010789993070572e-07,  -6.137639781909733e-09,
   1.010519955381687e-11,   7.016025021339918e-13,  -6.882529716930624e-15,  -4.687637122050700e-17,   1.428729516298565e-18,  -4.554859538619194e-21,  -1.932384930305783e-22,
   2.400258899641367e-24,   1.184438128434796e-26,   9.530409741939784e-01,  -1.011448938794357e-02,   1.445065840270580e-05,   6.612933489579658e-07,  -3.187156189765669e-09,
  -7.246544758387997e-11,   6.637052534774254e-13,   8.736105452512006e-15,  -1.350114442553127e-16,  -9.953040790309470e-19,   2.676308553683652e-20,   8.115647207845323e-23,
  -5.174651815859594e-24,   3.687588587733022e-27,   9.530423253523115e-01,  -1.011430363830816e-02,   1.444887087346201e-05,   6.612255568401778e-07,  -3.186227016359133e-09,
  -7.244830164301615e-11,   6.633531569087422e-13,   8.732757244657122e-15,  -1.348995533021427e-16,  -9.948846700801031e-19,   2.673144131743645e-20,   8.118115762010503e-23,
  -5.166564054089554e-24,   3.646058466627293e-27,   9.530447093568630e-01,  -1.011397589562550e-02,   1.444571717388825e-05,   6.611059496321308e-07,  -3.184587876881389e-09,
  -7.241805271392315e-11,   6.627321151401134e-13,   8.726850430633705e-15,  -1.347022281590982e-16,  -9.941445152202446e-19,   2.667564513366719e-20,   8.122447072454845e-23,
  -5.152306205343924e-24,   3.572924730799235e-27,   9.530475918894803e-01,  -1.011357961204938e-02,   1.444190440932298e-05,   6.609613415672116e-07,  -3.182606496513158e-09,
  -7.238148451221682e-11,   6.619815507327251e-13,   8.719709811440638e-15,  -1.344638048896905e-16,  -9.932493402554282e-19,   2.660824486962179e-20,   8.127642837577089e-23,
  -5.135087839658344e-24,   3.484740625178655e-27,   9.530503899602100e-01,  -1.011319493443300e-02,   1.443820380007905e-05,   6.608209818563134e-07,  -3.180683723420071e-09,
  -7.234599429061413e-11,   6.612533406878788e-13,   8.712779878260489e-15,  -1.342325406895064e-16,  -9.923801408800428e-19,   2.654288613971314e-20,   8.132643202636951e-23,
  -5.118395959418018e-24,   3.399394368737304e-27,   9.530526438762028e-01,  -1.011288506293523e-02,   1.443522317938226e-05,   6.607079265870222e-07,  -3.179135275745354e-09,
  -7.231741067504687e-11,   6.606670084356635e-13,   8.707198687728926e-15,  -1.340463754432794e-16,  -9.916797975312576e-19,   2.649028574445569e-20,   8.136640250338080e-23,
  -5.104965956086240e-24,   3.330827479202887e-27,   9.530541331388462e-01,  -1.011268031505735e-02,   1.443325390364826e-05,   6.606332298491860e-07,  -3.178112340376051e-09,
  -7.229852648231749e-11,   6.602797194596450e-13,   8.703511457991242e-15,  -1.339234283900347e-16,  -9.912169608821093e-19,   2.645555366094132e-20,   8.139266182575418e-23,
  -5.096099848130853e-24,   3.285611108485726e-27,   9.530548979202201e-01,  -1.011257517022108e-02,   1.443224266837684e-05,   6.605948720266628e-07,  -3.177587091811289e-09,
  -7.228882958207908e-11,   6.600808740854858e-13,   8.701618112250755e-15,  -1.338603101017230e-16,  -9.909792529223748e-19,   2.643772490133966e-20,   8.140610014146957e-23,
  -5.091549211738336e-24,   3.262418580939492e-27,   9.530551641052017e-01,  -1.011253857407486e-02,   1.443189071174072e-05,   6.605815216374604e-07,  -3.177404286605799e-09,
  -7.228545465212182e-11,   6.600116714615591e-13,   8.700959151455258e-15,  -1.338383445311192e-16,  -9.908965134391394e-19,   2.643152068407250e-20,   8.141076997557322e-23,
  -5.089965724407953e-24,   3.254350703193148e-27,   9.530552063448939e-01,  -1.011253276679310e-02,   1.443183486168981e-05,   6.605794031336520e-07,  -3.177375278524426e-09,
  -7.228491910504952e-11,   6.600006903061510e-13,   8.700854585139040e-15,  -1.338348590555412e-16,  -9.908833836779140e-19,   2.643053621937326e-20,   8.141151065821382e-23,
  -5.089714465922203e-24,   3.253070655397855e-27,   1.210760679010513e+00,  -1.005425270842461e-02,  -2.605156793639783e-05,   6.702809866811229e-07,   4.359627341946846e-09,
  -7.837678242475374e-11,  -8.254974240194423e-13,   1.068004880793420e-14,   1.650728955986241e-16,  -1.523626751470310e-18,  -3.410196413446318e-20,   2.092351255918141e-22,
   7.132884235559102e-24,  -2.489050985766521e-26,   1.210758241590382e+00,  -1.005406445042191e-02,  -2.604912217197143e-05,   6.702076846117261e-07,   4.358471573508795e-09,
  -7.835583740717672e-11,  -8.250670466803692e-13,   1.067493448994904e-14,   1.649304255852490e-16,  -1.522554930751705e-18,  -3.405841367945391e-20,   2.090539175856382e-22,
   7.120242024981920e-24,  -2.487600932917012e-26,   1.210753940909788e+00,  -1.005373228293997e-02,  -2.604480710945285e-05,   6.700783578942285e-07,   4.356432692776930e-09,
  -7.831888776584329e-11,  -8.243079422876110e-13,   1.066591313104778e-14,   1.646791838608721e-16,  -1.520664445010362e-18,  -3.398163154598064e-20,   2.087342599727576e-22,
   7.097958673045883e-24,  -2.485038107899922e-26,   1.210748740797250e+00,  -1.005333065098749e-02,  -2.603959018866679e-05,   6.699220018154738e-07,   4.353968093130316e-09,
  -7.827422179493277e-11,  -8.233905418967067e-13,   1.065500941156076e-14,   1.643756333460003e-16,  -1.518379742982753e-18,  -3.388889366934599e-20,   2.083478746817362e-22,
   7.071054334911720e-24,  -2.481931999056431e-26,   1.210743692949296e+00,  -1.005294078349845e-02,  -2.603452663341247e-05,   6.697702424872866e-07,   4.351576378357108e-09,
  -7.823087542698535e-11,  -8.225004863376278e-13,   1.064442950783675e-14,   1.640812172044096e-16,  -1.516163148054898e-18,  -3.379897823008667e-20,   2.079729338437102e-22,
   7.044978879001911e-24,  -2.478909219382185e-26,   1.210739626705965e+00,  -1.005262673271027e-02,  -2.603044817333305e-05,   6.696480075240385e-07,   4.349650271405832e-09,
  -7.819596660275298e-11,  -8.217838564831746e-13,   1.063591022700249e-14,   1.638442294456554e-16,  -1.514378458098138e-18,  -3.372662432985512e-20,   2.076709978136989e-22,
   7.024003468188269e-24,  -2.476468807253246e-26,   1.210736939921006e+00,  -1.005241922401669e-02,  -2.602775352961017e-05,   6.695672468139026e-07,   4.348377841334161e-09,
  -7.817290458709014e-11,  -8.213105098095323e-13,   1.063028267456292e-14,   1.636877251591963e-16,  -1.513199641659127e-18,  -3.367885369751165e-20,   2.074715384853759e-22,
   7.010158276845904e-24,  -2.474853638721650e-26,   1.210735560164305e+00,  -1.005231266161217e-02,  -2.602636980318129e-05,   6.695257754098422e-07,   4.347724482560721e-09,
  -7.816106271972230e-11,  -8.210674822526548e-13,   1.062739322498274e-14,   1.636073814701417e-16,  -1.512594409858508e-18,  -3.365433341256216e-20,   2.073691234816677e-22,
   7.003052740255960e-24,  -2.474023373714622e-26,   1.210735079933069e+00,  -1.005227557210697e-02,  -2.602588820077246e-05,   6.695113413989587e-07,   4.347497090171190e-09,
  -7.815694130103982e-11,  -8.209829036150200e-13,   1.062638761599081e-14,   1.635794216894997e-16,  -1.512383776763969e-18,  -3.364580084778885e-20,   2.073334796942160e-22,
   7.000580330264463e-24,  -2.473734265364495e-26,   1.210735003727258e+00,  -1.005226968653778e-02,  -2.602581177787418e-05,   6.695090509435329e-07,   4.347461006848191e-09,
  -7.815628730060460e-11,  -8.209694825929175e-13,   1.062622804398444e-14,   1.635749850746022e-16,  -1.512350353302464e-18,  -3.364444693959364e-20,   2.073278236438859e-22,
   7.000188027835937e-24,  -2.473688381824200e-26,   1.463210813792464e+00,  -8.582793958532162e-03,  -5.959508558456227e-05,   2.116917522779936e-07,   8.316508653664983e-09,
   3.716232675347266e-11,  -9.741721911570393e-13,  -1.437766762890356e-14,   4.907836909193233e-17,   3.083270269473837e-18,   1.767474766577803e-20,  -4.523806600024172e-22,
  -7.652668210599475e-24,   2.390996323412385e-26,   1.463205236139323e+00,  -8.582734298511762e-03,  -5.959041528082211e-05,   2.117263554465744e-07,   8.315140270373966e-09,
   3.713418519729559e-11,  -9.740418561528031e-13,  -1.436732220521911e-14,   4.915143818461664e-17,   3.080944758389436e-18,   1.762810678686238e-20,  -4.521998301830747e-22,
  -7.637314928792829e-24,   2.401923879007639e-26,   1.463195394637506e+00,  -8.582629019594423e-03,  -5.958217508169311e-05,   2.117873918842058e-07,   8.312725886093842e-09,
   3.708454550700504e-11,  -9.738117229503396e-13,  -1.434907391781892e-14,   4.928021040170849e-17,   3.076842121583390e-18,   1.754588520750722e-20,  -4.518801104153590e-22,
  -7.610246214904279e-24,   2.421154117657109e-26,   1.463183494793451e+00,  -8.582501701782272e-03,  -5.957221201099091e-05,   2.118611613205016e-07,   8.309806641965046e-09,
   3.702454883826316e-11,  -9.735331793041196e-13,  -1.432701876293422e-14,   4.943565162401355e-17,   3.071882473987731e-18,   1.744659318438613e-20,  -4.514924080800412e-22,
  -7.577552609126420e-24,   2.444319653828350e-26,   1.463171943264435e+00,  -8.582378089804589e-03,  -5.956254115079101e-05,   2.119327372257444e-07,   8.306972957630079e-09,
   3.696633460660085e-11,  -9.732624976674041e-13,  -1.430561938063679e-14,   4.958626717066297e-17,   3.067069102522883e-18,   1.735033948870932e-20,  -4.511148906398751e-22,
  -7.545854182990638e-24,   2.466716484057948e-26,   1.463162637956825e+00,  -8.582278499539416e-03,  -5.955475123141426e-05,   2.119903704914166e-07,   8.304690370031582e-09,
   3.691945910597271e-11,  -9.730442423112315e-13,  -1.428838846917912e-14,   4.970739770101507e-17,   3.063192495285799e-18,   1.727289705567765e-20,  -4.508099506199397e-22,
  -7.520346965289513e-24,   2.484693358983453e-26,   1.463156489397574e+00,  -8.582212687140182e-03,  -5.954960418306506e-05,   2.120284401371563e-07,   8.303182170690251e-09,
   3.688849495218645e-11,  -9.728999263206136e-13,  -1.427700658106342e-14,   4.978733907530206e-17,   3.060631383866253e-18,   1.722177257414156e-20,  -4.506080524785944e-22,
  -7.503506260625520e-24,   2.496540021747246e-26,   1.463153331886931e+00,  -8.582178887800969e-03,  -5.954696104856351e-05,   2.120479865816438e-07,   8.302407667206639e-09,
   3.687259657544661e-11,  -9.728257832545696e-13,  -1.427116267112144e-14,   4.982836203180475e-17,   3.059316279682932e-18,   1.719553257563819e-20,  -4.505042448249550e-22,
  -7.494862085021447e-24,   2.502613920621725e-26,   1.463152232897378e+00,  -8.582167123388959e-03,  -5.954604110067458e-05,   2.120547892415879e-07,   8.302138098800970e-09,
   3.686706350887697e-11,  -9.727999723229920e-13,  -1.426912884122696e-14,   4.984263555102326e-17,   3.058858569374116e-18,   1.718640187049201e-20,  -4.504680940056732e-22,
  -7.491854090136157e-24,   2.504726416794863e-26,   1.463152058503391e+00,  -8.582165256527285e-03,  -5.954589511852960e-05,   2.120558686987466e-07,   8.302095322227105e-09,
   3.686618551158022e-11,  -9.727958762577573e-13,  -1.426880610976033e-14,   4.984490032951867e-17,   3.058785938179332e-18,   1.718495306567653e-20,  -4.504623564376425e-22,
  -7.491376795510530e-24,   2.505061565854455e-26,   1.689550658489669e+00,  -5.936648886344484e-03,  -6.675581296143780e-05,  -3.672061220945524e-07,   2.705336878180973e-09,
   8.643546929261129e-11,   8.000205536251837e-13,  -2.778424717022811e-15,  -1.816215960179258e-16,  -2.214962403584002e-18,   8.693922835651601e-22,   4.470299256864651e-22,
   6.763351014083890e-24,   1.424617301258629e-26,   1.689544403212127e+00,  -5.936751877615125e-03,  -6.675428489693122e-05,  -3.671251360987515e-07,   2.706456268245751e-09,
   8.642988146494664e-11,   7.995439050826606e-13,  -2.785840008492386e-15,  -1.816166003340581e-16,  -2.212653885897451e-18,   9.107666838447435e-22,   4.471223328012622e-22,
   6.753137165401043e-24,   1.403243196712569e-26,   1.689533365793550e+00,  -5.936933588825347e-03,  -6.675158809244441e-05,  -3.669822393282003e-07,   2.708430904752925e-09,
   8.642000981572230e-11,   7.987028626839056e-13,  -2.798918070282009e-15,  -1.816076438796997e-16,  -2.208580094721782e-18,   9.837210081469071e-22,   4.472841203604751e-22,
   6.735107711856689e-24,   1.365561281001049e-26,   1.689520019428687e+00,  -5.937153284406891e-03,  -6.674832621715541e-05,  -3.668094543526790e-07,   2.710817727273058e-09,
   8.640805273178305e-11,   7.976858849637932e-13,  -2.814721397102818e-15,  -1.815965725054342e-16,  -2.203653386443584e-18,   1.071850396320082e-21,   4.474775978941942e-22,
   6.713294486423415e-24,   1.320052261980509e-26,   1.689507063217765e+00,  -5.937366528030954e-03,  -6.674515873373720e-05,  -3.666417253691395e-07,   2.713133840387938e-09,
   8.639642387800391e-11,   7.966986415260619e-13,  -2.830051677218120e-15,  -1.815855722482135e-16,  -2.198869961459335e-18,   1.157312948991692e-21,   4.476631647211823e-22,
   6.692106266224443e-24,   1.275931961249272e-26,   1.689496626012549e+00,  -5.937538290646433e-03,  -6.674260639745999e-05,  -3.665066105892749e-07,   2.714998973943304e-09,
   8.638704069583834e-11,   7.959033462321213e-13,  -2.842393443023391e-15,  -1.815765298787512e-16,  -2.195016025531031e-18,   1.226094579988361e-21,   4.478110384418873e-22,
   6.675028525339049e-24,   1.240431578472016e-26,   1.689489729366634e+00,  -5.937651776731294e-03,  -6.674091953953631e-05,  -3.664173318488250e-07,   2.716231079680042e-09,
   8.638083305128313e-11,   7.953778367772758e-13,  -2.850544691626941e-15,  -1.815704664079287e-16,  -2.192469184042243e-18,   1.271511986409620e-21,   4.479079597701775e-22,
   6.663739572535813e-24,   1.216994312037425e-26,   1.689486187631654e+00,  -5.937710053681223e-03,  -6.674005315845945e-05,  -3.663714837789707e-07,   2.716863719383481e-09,
   8.637764283927205e-11,   7.951079648652832e-13,  -2.854729519878535e-15,  -1.815673251858216e-16,  -2.191161188448352e-18,   1.294826016126948e-21,   4.479574889926885e-22,
   6.657940833109113e-24,   1.204964575795119e-26,   1.689484954901972e+00,  -5.937730336936636e-03,  -6.673975159086048e-05,  -3.663555260714009e-07,   2.717083898622728e-09,
   8.637653209232175e-11,   7.950140338484987e-13,  -2.856185892182319e-15,  -1.815662275030153e-16,  -2.190705917384590e-18,   1.302939088424219e-21,   4.479746891740141e-22,
   6.655922318588951e-24,   1.200778538519630e-26,   1.689484759284920e+00,  -5.937733555582832e-03,  -6.673970373548900e-05,  -3.663529938092980e-07,   2.717118837237941e-09,
   8.637635581477778e-11,   7.949991283075393e-13,  -2.856416989128660e-15,  -1.815660531092997e-16,  -2.190633671604769e-18,   1.304226445812551e-21,   4.479774167585220e-22,
   6.655601998163273e-24,   1.200114320606306e-26,   1.866882056013449e+00,  -2.893729367076188e-03,  -4.315135980860183e-05,  -4.960779151891239e-07,  -4.071318035636018e-09,
  -1.110330910656905e-11,   3.704205894981393e-13,   8.872681030103594e-15,   1.147125323523653e-16,   7.881344122855343e-19,  -4.277521455303229e-21,  -2.326379094916671e-22,
  -4.064115880979781e-24,  -4.136971627449869e-26,   1.866878005990149e+00,  -2.893868924830239e-03,  -4.315364695817997e-05,  -4.960881772616074e-07,  -4.070793576934137e-09,
  -1.108579931409790e-11,   3.707213174203513e-13,   8.875309360292334e-15,   1.146936769141881e-16,   7.869232594523850e-19,  -4.302698809848565e-21,  -2.329369877500868e-22,
  -4.064795287805794e-24,  -4.130771377598861e-26,   1.866870859486245e+00,  -2.894115179007335e-03,  -4.315768242897206e-05,  -4.961062714915780e-07,  -4.069867817627151e-09,
  -1.105489881805105e-11,   3.712519158468039e-13,   8.879943758531986e-15,   1.146603198151629e-16,   7.847849109773599e-19,  -4.347127936733087e-21,  -2.334643447709588e-22,
  -4.065982389582879e-24,  -4.119811145720467e-26,   1.866862217560562e+00,  -2.894412956150949e-03,  -4.316256175298806e-05,  -4.961281284484826e-07,  -4.068747793616209e-09,
  -1.101752646440721e-11,   3.718934515705261e-13,   8.885542039184159e-15,   1.146198367590231e-16,   7.821970664478951e-19,  -4.400857678765688e-21,  -2.341013966621930e-22,
  -4.067397851372727e-24,  -4.106524180573648e-26,   1.866853827817903e+00,  -2.894702037193310e-03,  -4.316729808639587e-05,  -4.961493229468558e-07,  -4.067659880117520e-09,
  -1.098123855429441e-11,   3.725161703395985e-13,   8.890970798735403e-15,   1.145803822527906e-16,   7.796826018860899e-19,  -4.453023360481012e-21,  -2.347191708193314e-22,
  -4.068751010434817e-24,  -4.093590114904144e-26,   1.866847068927645e+00,  -2.894934920090367e-03,  -4.317111330688822e-05,  -4.961663798636735e-07,  -4.066783031554040e-09,
  -1.095200013249050e-11,   3.730177720594123e-13,   8.895339868417237e-15,   1.145484876849665e-16,   7.776553851911191e-19,  -4.495051458972946e-21,  -2.352163646020656e-22,
  -4.069826083291449e-24,  -4.083145312921237e-26,   1.866842602664344e+00,  -2.895088806412904e-03,  -4.317363418572780e-05,  -4.961776423992734e-07,  -4.066203410417142e-09,
  -1.093267728442249e-11,   3.733491958269507e-13,   8.898224781051315e-15,   1.145273582012630e-16,   7.763150550940727e-19,  -4.522824872340870e-21,  -2.355446675308844e-22,
  -4.070529118286764e-24,  -4.076231197785472e-26,   1.866840308990720e+00,  -2.895167834851854e-03,  -4.317492873095726e-05,  -4.961834236611647e-07,  -4.065905680671156e-09,
  -1.092275326745996e-11,   3.735193898278087e-13,   8.899705674952740e-15,   1.145164904622359e-16,   7.756264898789877e-19,  -4.537088462726978e-21,  -2.357131944062138e-22,
  -4.070887885571427e-24,  -4.072676642510584e-26,   1.866839510651243e+00,  -2.895195341495241e-03,  -4.317537930184810e-05,  -4.961854354701168e-07,  -4.065802042510584e-09,
  -1.091929899356039e-11,   3.735786261399943e-13,   8.900221010653286e-15,   1.145127051813590e-16,   7.753867899980756e-19,  -4.542053133407895e-21,  -2.357718401987937e-22,
  -4.071012395607828e-24,  -4.071438837936149e-26,   1.866839383965508e+00,  -2.895199706424112e-03,  -4.317545080089030e-05,  -4.961857546969220e-07,  -4.065785596058810e-09,
  -1.091875084174612e-11,   3.735880260666890e-13,   8.900302782442351e-15,   1.145121043829085e-16,   7.753487511028793e-19,  -4.542840962889805e-21,  -2.357811459309280e-22,
  -4.071032136439927e-24,  -4.071242386485431e-26,   1.973954652175360e+00,  -6.092245779829018e-04,  -1.051867385780996e-05,  -1.579670643006785e-07,  -2.161456272499231e-09,
  -2.734405665194870e-11,  -3.195592073604093e-13,  -3.396951585665114e-15,  -3.147703737312821e-17,  -2.229452798432633e-19,  -4.299779557789711e-22,   2.398499664090035e-23,
   6.252660676346739e-25,   1.086128082612437e-26,   1.973953663605771e+00,  -6.092690966383672e-04,  -1.051989221722194e-05,  -1.579927556443189e-07,  -2.161906629355214e-09,
  -2.735075629552835e-11,  -3.196418688812604e-13,  -3.397700706374068e-15,  -3.147872463069819e-17,  -2.228184700541282e-19,  -4.260468745842267e-22,   2.406546642934275e-23,
   6.266073394657611e-25,   1.088023068419703e-26,   1.973951919165986e+00,  -6.093476563917957e-04,  -1.052204223778890e-05,  -1.580380935351015e-07,  -2.162701385643687e-09,
  -2.736257911960260e-11,  -3.197877299612224e-13,  -3.399022191407171e-15,  -3.148168828539820e-17,  -2.225943737757532e-19,  -4.191036556889430e-22,   2.420756949370292e-23,
   6.289755686885576e-25,   1.091368255039688e-26,   1.973949809611849e+00,  -6.094426617211058e-04,  -1.052464241727865e-05,  -1.580929253119526e-07,  -2.163662574625716e-09,
  -2.737687744638597e-11,  -3.199641127298958e-13,  -3.400619547398474e-15,  -3.148524886929359e-17,  -2.223228168191231e-19,  -4.106963022613994e-22,   2.437959452662003e-23,
   6.318418723298463e-25,   1.095415768008105e-26,   1.973947761526784e+00,  -6.095349017609866e-04,  -1.052716699479885e-05,  -1.581461641787457e-07,  -2.164595849047681e-09,
  -2.739076015196662e-11,  -3.201353483183249e-13,  -3.402169606089169e-15,  -3.148868121310546e-17,  -2.220585890248141e-19,  -4.025224988583507e-22,   2.454679509896526e-23,
   6.346271692832255e-25,   1.099347615173646e-26,   1.973946111496837e+00,  -6.096092166692256e-04,  -1.052920102551741e-05,  -1.581890592575037e-07,  -2.165347803729962e-09,
  -2.740194541017157e-11,  -3.202732979416527e-13,  -3.403417863499377e-15,  -3.149142890436279e-17,  -2.218452967763350e-19,  -3.959291217689354e-22,   2.468163423900165e-23,
   6.368729307688770e-25,   1.102516915010174e-26,   1.973945021128049e+00,  -6.096583263247148e-04,  -1.053054520600440e-05,  -1.582174067637970e-07,  -2.165844741207266e-09,
  -2.740933717907688e-11,  -3.203644547718608e-13,  -3.404242469335965e-15,  -3.149323602395516e-17,  -2.217041445532131e-19,  -3.915680899521248e-22,   2.477080432944900e-23,
   6.383578508349807e-25,   1.104612039275424e-26,   1.973944461153444e+00,  -6.096835476232293e-04,  -1.053123554696690e-05,  -1.582319655550771e-07,  -2.166099960693639e-09,
  -2.741313343786577e-11,  -3.204112688374618e-13,  -3.404665875671685e-15,  -3.149416143458927e-17,  -2.216315903884842e-19,  -3.893271780174085e-22,   2.481661933417400e-23,
   6.391207255016299e-25,   1.105688266279747e-26,   1.973944266246280e+00,  -6.096923263087391e-04,  -1.053147583282366e-05,  -1.582370330333880e-07,  -2.166188795088763e-09,
  -2.741445479739822e-11,  -3.204275630084864e-13,  -3.404813235259583e-15,  -3.149448311314807e-17,  -2.216063267782051e-19,  -3.885469989607683e-22,   2.483256915251151e-23,
   6.393862983241090e-25,   1.106062901576343e-26,   1.973944235317061e+00,  -6.096937193738483e-04,  -1.053151396318192e-05,  -1.582378371798912e-07,  -2.166202892022238e-09,
  -2.741466448070946e-11,  -3.204301486740874e-13,  -3.404836618680840e-15,  -3.149453413920746e-17,  -2.216023172941560e-19,  -3.884231853601745e-22,   2.483510033453522e-23,
   6.394284433193975e-25,   1.106122353156861e-26,   5.864385444564631e-03,  -1.008932470892607e-04,   1.298393943067765e-06,  -1.480833927820431e-08,   1.576366389062678e-10,
  -1.603450001056144e-12,   1.575384444487863e-14,  -1.506560896080838e-16,   1.404909906527002e-18,  -1.283636753284731e-20,   1.144049312352697e-22,  -1.003884245223742e-24,
   8.477848476631711e-27,  -7.221889208330842e-29,   5.864507347013573e-03,  -1.008974172307484e-04,   1.298482738824683e-06,  -1.480984500990575e-08,   1.576588364531498e-10,
  -1.603747296214340e-12,   1.575754233430416e-14,  -1.506995478187093e-16,   1.405394246150987e-18,  -1.284156446060189e-20,   1.144576064667578e-22,  -1.004414829313669e-24,
   8.482562477084285e-27,  -7.226393543767811e-29,   5.864722452588615e-03,  -1.009047758558498e-04,   1.298639430498619e-06,  -1.481250212402978e-08,   1.576980086061080e-10,
  -1.604271947831962e-12,   1.576406835314289e-14,  -1.507762447911758e-16,   1.406249051910968e-18,  -1.285073674830024e-20,   1.145505764910558e-22,  -1.005351320913707e-24,
   8.490883536470452e-27,  -7.234340222736033e-29,   5.864982572119776e-03,  -1.009136745719685e-04,   1.298828921076645e-06,  -1.481571552165196e-08,   1.577453832092072e-10,
  -1.604906480921199e-12,   1.577196144949026e-14,  -1.508690119359708e-16,   1.407283000630279e-18,  -1.286183177443822e-20,   1.146630373437693e-22,  -1.006484192834979e-24,
   8.500950794990719e-27,  -7.243947225761895e-29,   5.865235103776242e-03,  -1.009223139073577e-04,   1.299012893401036e-06,  -1.481883543757461e-08,   1.577913812126696e-10,
  -1.605522599031804e-12,   1.577962577904735e-14,  -1.509590941748166e-16,   1.408287063238242e-18,  -1.287260661181274e-20,   1.147722548241983e-22,  -1.007584443022902e-24,
   8.510729518818391e-27,  -7.253271223355613e-29,   5.865438548677898e-03,  -1.009292740848627e-04,   1.299161112119705e-06,  -1.482134909158032e-08,   1.578284420226946e-10,
  -1.606019024895304e-12,   1.578580138777462e-14,  -1.510316815297558e-16,   1.409096154560523e-18,  -1.288128953163685e-20,   1.148602694177843e-22,  -1.008471132515495e-24,
   8.518611151192339e-27,  -7.260780853013865e-29,   5.865572985696448e-03,  -1.009338734622364e-04,   1.299259058777465e-06,  -1.482301021152594e-08,   1.578529337981645e-10,
  -1.606347097906580e-12,   1.578988276861799e-14,  -1.510796549101640e-16,   1.409630901082705e-18,  -1.288702844656048e-20,   1.149184427876190e-22,  -1.009057208691693e-24,
   8.523821163479206e-27,  -7.265742267726306e-29,   5.865642026852994e-03,  -1.009362355294142e-04,   1.299309361042542e-06,  -1.482386332006615e-08,   1.578655123171055e-10,
  -1.606515592594174e-12,   1.579197895357745e-14,  -1.511042943044438e-16,   1.409905554079727e-18,  -1.288997608581329e-20,   1.149483222035690e-22,  -1.009358238664815e-24,
   8.526497363730950e-27,  -7.268289939331194e-29,   5.865666057469134e-03,  -1.009370576791653e-04,   1.299326869520150e-06,  -1.482416025930587e-08,   1.578698905164197e-10,
  -1.606574240862319e-12,   1.579270858188800e-14,  -1.511128707119615e-16,   1.410001155154305e-18,  -1.289100210740411e-20,   1.149587227414406e-22,  -1.009463023152190e-24,
   8.527428936830042e-27,  -7.269176639582930e-29,   5.865669870806898e-03,  -1.009371881435130e-04,   1.299329647889304e-06,  -1.482420737980600e-08,   1.578705852825537e-10,
  -1.606583547636784e-12,   1.579282436536856e-14,  -1.511142316906403e-16,   1.410016325993287e-18,  -1.289116492616410e-20,   1.149603731983865e-22,  -1.009479651398796e-24,
   8.527576769261103e-27,  -7.269317344793030e-29,   5.261982382061609e-02,  -8.905470979234122e-04,   1.105700586958446e-05,  -1.183265251873470e-07,   1.136479478476468e-09,
  -9.857964473687556e-12,   7.557486881501025e-14,  -4.792078220356629e-16,   1.878796540946408e-18,   8.048802311564239e-21,  -3.015386773885885e-22,   4.421913804019894e-24,
  -5.085494181307054e-26,   4.613638164188497e-28,   5.262086169739830e-02,  -8.905804097757749e-04,   1.105764573829329e-05,  -1.183357749389595e-07,   1.136585813395897e-09,
  -9.858907469288120e-12,   7.557977413237266e-14,  -4.791800590640858e-16,   1.877514253142814e-18,   8.071734488573500e-21,  -3.018548642512606e-22,   4.425297735686108e-24,
  -5.088780631998238e-26,   4.615487463063628e-28,   5.262269309617762e-02,  -8.906391911806120e-04,   1.105877484535549e-05,  -1.183520969900464e-07,   1.136773448634631e-09,
  -9.860571355152880e-12,   7.558842689940805e-14,  -4.791310078430183e-16,   1.875250550291503e-18,   8.112212872369417e-21,  -3.024129462233357e-22,   4.431269837685160e-24,
  -5.094579148026604e-26,   4.618751932429489e-28,   5.262490772647869e-02,  -8.907102738936709e-04,   1.106014025664902e-05,  -1.183718350142965e-07,   1.137000348717423e-09,
  -9.862583267419692e-12,   7.559888523977611e-14,  -4.790715870997291e-16,   1.872511404765117e-18,   8.161183976276071e-21,  -3.030880667040682e-22,   4.438493245657615e-24,
  -5.101589954501894e-26,   4.622701669445592e-28,   5.262705773850499e-02,  -8.907792835418662e-04,   1.106146586118521e-05,  -1.183909976300679e-07,   1.137220629385294e-09,
  -9.864536317034769e-12,   7.560903311480761e-14,  -4.790137898818154e-16,   1.869850349965594e-18,   8.208749632496846e-21,  -3.037437570542557e-22,   4.445507572852930e-24,
  -5.108395056392500e-26,   4.626538420089117e-28,   5.262878982276166e-02,  -8.908348795260651e-04,   1.106253381321740e-05,  -1.184064357037364e-07,   1.137398091786291e-09,
  -9.866109611033818e-12,   7.561720459815691e-14,  -4.789671485010814e-16,   1.867705248659735e-18,   8.247086077101549e-21,  -3.042721840776999e-22,   4.451159634023322e-24,
  -5.113876530745006e-26,   4.629630986148860e-28,   5.262993438379911e-02,  -8.908716176884887e-04,   1.106323952737870e-05,  -1.184166373580531e-07,   1.137515359284268e-09,
  -9.867149187565200e-12,   7.562260244824399e-14,  -4.789362891881342e-16,   1.866287123127288e-18,   8.272427014684438e-21,  -3.046214627442223e-22,   4.454895106126865e-24,
  -5.117498282000956e-26,   4.631675345489824e-28,   5.263052218012577e-02,  -8.908904849029827e-04,   1.106360195479511e-05,  -1.184218765349202e-07,   1.137575582839242e-09,
  -9.867683051155511e-12,   7.562537397032531e-14,  -4.789204292305497e-16,   1.865558637236813e-18,   8.285443550664701e-21,  -3.048008660597944e-22,   4.456813663457493e-24,
  -5.119358128420127e-26,   4.632725483683400e-28,   5.263072676952758e-02,  -8.908970518750784e-04,   1.106372810247727e-05,  -1.184237001005755e-07,   1.137596544371576e-09,
  -9.867868865881489e-12,   7.562633853922608e-14,  -4.789149070808382e-16,   1.865305047524901e-18,   8.289974513360366e-21,  -3.048633141222944e-22,   4.457481468926329e-24,
  -5.120005449649409e-26,   4.633091035583873e-28,   5.263075923511956e-02,  -8.908980939662086e-04,   1.106374812044834e-05,  -1.184239894763827e-07,   1.137599870686260e-09,
  -9.867898352053630e-12,   7.562649159900324e-14,  -4.789140306993336e-16,   1.865264804738452e-18,   8.290693535539359e-21,  -3.048732240116658e-22,   4.457587442072193e-24,
  -5.120108169883920e-26,   4.633149045614909e-28,   1.452496050257926e-01,  -2.375799603545693e-03,   2.730308061708303e-05,  -2.515744229864197e-07,   1.809315245060594e-09,
  -7.890034783255813e-12,  -2.963406710922549e-14,   1.162853462151709e-15,  -1.583059515065098e-17,   1.427762197954189e-19,  -7.591243119471343e-22,  -2.376273488158802e-24,
   1.176103485273637e-25,  -1.809452294191950e-27,   1.452521667271482e-01,  -2.375870384695410e-03,   2.730409811663682e-05,  -2.515818005591239e-07,   1.809273079928855e-09,
  -7.887737761329184e-12,  -2.967568792132517e-14,   1.163334996010313e-15,  -1.583377405666783e-17,   1.427634498651291e-19,  -7.583900006378504e-22,  -2.389559828245098e-24,
   1.177527642513152e-25,  -1.810448106135123e-27,   1.452566869670827e-01,  -2.375995280833056e-03,   2.730589349123485e-05,  -2.515948166492899e-07,   1.809198631279161e-09,
  -7.883683859364733e-12,  -2.974913527000582e-14,   1.164184634672159e-15,  -1.583938076204216e-17,   1.427408613689698e-19,  -7.570935804200075e-22,  -2.413009670712074e-24,
   1.180040522293330e-25,  -1.812202700330777e-27,   1.452621530218098e-01,  -2.376146309450748e-03,   2.730806444433662e-05,  -2.516105528552933e-07,   1.809108525989777e-09,
  -7.878780523830396e-12,  -2.983796013015469e-14,   1.165211966343440e-15,  -1.584615614425889e-17,   1.427134520372485e-19,  -7.555247138098672e-22,  -2.441375497192205e-24,
   1.183079006934887e-25,  -1.814320054353540e-27,   1.452674595116656e-01,  -2.376292928427361e-03,   2.731017193340548e-05,  -2.516258261608140e-07,   1.809020968309850e-09,
  -7.874019074648597e-12,  -2.992420184813516e-14,   1.166209218682570e-15,  -1.585272905686600e-17,   1.426867439432708e-19,  -7.540004062211234e-22,  -2.468923036903516e-24,
   1.186028592825929e-25,  -1.816371016816018e-27,   1.452717344501522e-01,  -2.376411044923845e-03,   2.731186967437226e-05,  -2.516381278935012e-07,   1.808950372056839e-09,
  -7.870182327298714e-12,  -2.999368570752057e-14,   1.167012546632193e-15,  -1.585802087603657e-17,   1.426651568796217e-19,  -7.527715274431107e-22,  -2.491122480806067e-24,
   1.188404652827803e-25,  -1.818019998072237e-27,   1.452745593019527e-01,  -2.376489095255923e-03,   2.731299149920111e-05,  -2.516462555606338e-07,   1.808903693478186e-09,
  -7.867646590334299e-12,  -3.003960363935481e-14,   1.167543349082225e-15,  -1.586151603193449e-17,   1.426508575815331e-19,  -7.519590575492868e-22,  -2.505795148345092e-24,
   1.189974667710294e-25,  -1.819108024268149e-27,   1.452760100135477e-01,  -2.376529178162380e-03,   2.731356760616702e-05,  -2.516504291667931e-07,   1.808879712568237e-09,
  -7.866344218806952e-12,  -3.006318600398355e-14,   1.167815934618749e-15,  -1.586331047174692e-17,   1.426435033975506e-19,  -7.515416766241545e-22,  -2.513331399515350e-24,
   1.190780932074002e-25,  -1.819666285415064e-27,   1.452765149493966e-01,  -2.376543129436997e-03,   2.731376812487346e-05,  -2.516518817745369e-07,   1.808871364324039e-09,
  -7.865890892707092e-12,  -3.007139427040833e-14,   1.167910809408677e-15,  -1.586393496493983e-17,   1.426409419853509e-19,  -7.513963812803831e-22,  -2.515954641265180e-24,
   1.191061557633313e-25,  -1.819860514911529e-27,   1.452765950758753e-01,  -2.376545343314604e-03,   2.731379994440216e-05,  -2.516521122808118e-07,   1.808870039502925e-09,
  -7.865818954970253e-12,  -3.007269681913931e-14,   1.167925864678855e-15,  -1.586403405970493e-17,   1.426405354428017e-19,  -7.513733238616618e-22,  -2.516370922171184e-24,
   1.191106088943278e-25,  -1.819891332734890e-27,   2.818447388341526e-01,  -4.365367807894788e-03,   4.392665388093265e-05,  -2.959563493155970e-07,   6.009273593949959e-10,
   1.717556705281488e-11,  -2.951163532331933e-13,   2.437309098375406e-15,  -3.571781737314729e-18,  -2.244468696158609e-19,   3.784927319846339e-21,  -3.106634409640785e-23,
   5.645679455718906e-27,   3.685070414864461e-27,   2.818488576236773e-01,  -4.365450988587563e-03,   4.392698955868250e-05,  -2.959402070228928e-07,   6.005122463720859e-10,
   1.718035337137381e-11,  -2.951253993600735e-13,   2.436547447793429e-15,  -3.555813880368279e-18,  -2.246059957669460e-19,   3.784938108956483e-21,  -3.103915514091358e-23,
   5.124520673269225e-27,   3.689462687117865e-27,   2.818561253180046e-01,  -4.365597758532713e-03,   4.392758167749971e-05,  -2.959117200486913e-07,   5.997797626891124e-10,
   1.718879768475698e-11,  -2.951413273158759e-13,   2.435203067494826e-15,  -3.527638329380634e-18,  -2.248866621431020e-19,   3.784954525764424e-21,  -3.099115376150057e-23,
   4.205010550009146e-27,   3.697207477154258e-27,   2.818649135349635e-01,  -4.365775228016316e-03,   4.392829735018145e-05,  -2.958772670810989e-07,   5.988940181878783e-10,
   1.719900655632207e-11,  -2.951605294654292e-13,   2.433576685502905e-15,  -3.493568130605135e-18,  -2.252258520934297e-19,   3.784969908843072e-21,  -3.093306560294598e-23,
   3.093271069371189e-27,   3.706563274386645e-27,   2.818734450292223e-01,  -4.365947505718647e-03,   4.392899177383372e-05,  -2.958438142300931e-07,   5.980341345653722e-10,
   1.720891497084353e-11,  -2.951791097330606e-13,   2.431997044260231e-15,  -3.460493356747771e-18,  -2.255549277060128e-19,   3.784980163680336e-21,  -3.087662818056040e-23,
   2.014163451960801e-27,   3.715635991342107e-27,   2.818803179225424e-01,  -4.366086285665659e-03,   4.392955094960315e-05,  -2.958168603870783e-07,   5.973414104900403e-10,
   1.721689549742281e-11,  -2.951940341585431e-13,   2.430723948749964e-15,  -3.433848744087261e-18,  -2.258198804218581e-19,   3.784985072770879e-21,  -3.083112967033416e-23,
   1.144956542396238e-27,   3.722937879613411e-27,   2.818848594239189e-01,  -4.366177986666444e-03,   4.392992032406170e-05,  -2.957990474857195e-07,   5.968836644003565e-10,
   1.722216812161054e-11,  -2.952038746070332e-13,   2.429882437238953e-15,  -3.416242458499433e-18,  -2.259948847882029e-19,   3.784986675453187e-21,  -3.080104879000248e-23,
   5.706533802228769e-28,   3.727759420900553e-27,   2.818871917070973e-01,  -4.366225078801815e-03,   4.393010997874010e-05,  -2.957898990028567e-07,   5.966485879157749e-10,
   1.722487562960858e-11,  -2.952089215467339e-13,   2.429450196501892e-15,  -3.407200788834964e-18,  -2.260847357341119e-19,   3.784986990987023e-21,  -3.078559578706698e-23,
   2.757377732959687e-28,   3.730234456180499e-27,   2.818880034803988e-01,  -4.366241469536754e-03,   4.393017598393228e-05,  -2.957867146772732e-07,   5.965667670798749e-10,
   1.722581796485844e-11,  -2.952106771293559e-13,   2.429299737734024e-15,  -3.404053753015563e-18,  -2.261160056486801e-19,   3.784987020015597e-21,  -3.078021642700164e-23,
   1.730923358871503e-28,   3.731095746591312e-27,   2.818881322976791e-01,  -4.366244070515238e-03,   4.393018645776926e-05,  -2.957862093633251e-07,   5.965537832252332e-10,
   1.722596749869456e-11,  -2.952109556662473e-13,   2.429275861362608e-15,  -3.403554361778738e-18,  -2.261209675858752e-19,   3.784987020786429e-21,  -3.077936275862779e-23,
   1.568040440970390e-28,   3.731232413528046e-27,   4.591547574996380e-01,  -6.566997602597580e-03,   5.304077791823447e-05,  -1.467242132032161e-07,  -2.725877195691644e-09,
   4.450897477276851e-11,  -2.233514402305945e-13,  -2.534140821316476e-15,   5.877148439752914e-17,  -4.122535137632227e-19,  -2.645650898959913e-21,   9.047411338405586e-23,
  -8.209239296408839e-25,  -2.405575867570308e-27,   4.591597269812231e-01,  -6.567038721882969e-03,   5.303924285367697e-05,  -1.466825282740700e-07,  -2.726189461733779e-09,
   4.450396378185386e-11,  -2.231973997174472e-13,  -2.535520035138831e-15,   5.876016193085542e-17,  -4.117877324437829e-19,  -2.650671916533183e-21,   9.045562273841572e-23,
  -8.196627718876386e-25,  -2.421926686500049e-27,   4.591684955925802e-01,  -6.567111267985791e-03,   5.303653406570036e-05,  -1.466089783857783e-07,  -2.726740284065931e-09,
   4.449511960782935e-11,  -2.229256170658354e-13,  -2.537952402147421e-15,   5.874016608999230e-17,  -4.109659323995310e-19,  -2.659525236865560e-21,   9.042289888917551e-23,
  -8.174374295107756e-25,  -2.450748802016077e-27,   4.591790984914872e-01,  -6.567198975271334e-03,   5.303325832756097e-05,  -1.465200475980235e-07,  -2.727406044219827e-09,
   4.448442138537855e-11,  -2.225970159651121e-13,  -2.540891468264777e-15,   5.871595764368946e-17,  -4.099723369977539e-19,  -2.670219949053529e-21,   9.038316390370696e-23,
  -8.147465069063173e-25,  -2.485551077984846e-27,   4.591893913931462e-01,  -6.567284102983358e-03,   5.303007804351564e-05,  -1.464337219609534e-07,  -2.728052038420293e-09,
   4.447403180817811e-11,  -2.222780590750016e-13,  -2.543742382124923e-15,   5.869242587931994e-17,  -4.090079124499046e-19,  -2.680590862668655e-21,   9.034441727756014e-23,
  -8.121341924416485e-25,  -2.519284430173277e-27,   4.591976830710713e-01,  -6.567352668579400e-03,   5.302751586598879e-05,  -1.463641840466732e-07,  -2.728572217818059e-09,
   4.446565928673201e-11,  -2.220211426493733e-13,  -2.546037407311624e-15,   5.867344706755213e-17,  -4.082310856139109e-19,  -2.688937419427148e-21,   9.031307994613632e-23,
  -8.100297378049743e-25,  -2.546422244479982e-27,   4.592031619907871e-01,  -6.567397969539546e-03,   5.302582273560180e-05,  -1.463182370294652e-07,  -2.728915832875145e-09,
   4.446012549681822e-11,  -2.218513920871689e-13,  -2.547553119102437e-15,   5.866089547550669e-17,  -4.077178218506410e-19,  -2.694448701443648e-21,   9.029231234397671e-23,
  -8.086391483260983e-25,  -2.564336144359917e-27,   4.592059756555343e-01,  -6.567421231905695e-03,   5.302495320457757e-05,  -1.462946417792671e-07,  -2.729092261562551e-09,
   4.445728320520661e-11,  -2.217642217647243e-13,  -2.548331262245182e-15,   5.865444631481151e-17,  -4.074542517012262e-19,  -2.697277779466685e-21,   9.028162850049505e-23,
  -8.079250131870631e-25,  -2.573530133657024e-27,   4.592069549737051e-01,  -6.567429328291627e-03,   5.302465055195490e-05,  -1.462864293544319e-07,  -2.729153663756517e-09,
   4.445629385181850e-11,  -2.217338820862858e-13,  -2.548602062708877e-15,   5.865220109730686e-17,  -4.073625161429528e-19,  -2.698262270322340e-21,   9.027790691690151e-23,
  -8.076764517796583e-25,  -2.576729285400572e-27,   4.592071103778399e-01,  -6.567430613062629e-03,   5.302460252494364e-05,  -1.462851261613196e-07,  -2.729163407181448e-09,
   4.445613685184464e-11,  -2.217290676327982e-13,  -2.548645033143312e-15,   5.865184478714362e-17,  -4.073479590894133e-19,  -2.698418486173959e-21,   9.027731621166934e-23,
  -8.076370085014964e-25,  -2.577236903975092e-27,   6.720705056916079e-01,  -8.589957278528350e-03,   4.704184588928163e-05,   2.050984519328390e-07,  -5.790778756402367e-09,
   2.466541538031328e-11,   4.952977507927821e-13,  -7.648871940072292e-15,   1.219355345433460e-20,   1.115589239566539e-18,  -1.058370521808777e-20,  -7.335316395690958e-23,
   2.383996568494091e-24,  -1.173855310045738e-26,   6.720749093251456e-01,  -8.589899513723976e-03,   4.703859251410688e-05,   2.051214496658563e-07,  -5.790082257117698e-09,
   2.465041640134481e-11,   4.952968717924123e-13,  -7.645116790204739e-15,  -3.198626747306782e-20,   1.115207786403008e-18,  -1.056906705462490e-20,  -7.343648375384923e-23,
   2.381562270483680e-24,  -1.169280364876129e-26,   6.720826793584170e-01,  -8.589797581579683e-03,   4.703285220085903e-05,   2.051620181144792e-07,  -5.788853274517043e-09,
   2.462395647217945e-11,   4.952952267815858e-13,  -7.638491818116550e-15,  -1.098921500341112e-19,   1.114534359579181e-18,  -1.054325002812095e-20,  -7.358323191904181e-23,
   2.377267094080562e-24,  -1.161215628099770e-26,   6.720920745438776e-01,  -8.589674315211841e-03,   4.702591149569397e-05,   2.052110544588952e-07,  -5.787367177990537e-09,
   2.459197108130405e-11,   4.952930774107789e-13,  -7.630482620239859e-15,  -2.040113686441398e-19,   1.113719454265178e-18,  -1.051205267886177e-20,  -7.376021973293320e-23,
   2.372073634678439e-24,  -1.151476999530786e-26,   6.721011947856197e-01,  -8.589554641006674e-03,   4.701917414783058e-05,   2.052586377219354e-07,  -5.785924503777373e-09,
   2.456093093736246e-11,   4.952908231657942e-13,  -7.622709303994283e-15,  -2.952912762196847e-19,   1.112927741017580e-18,  -1.048178869150777e-20,  -7.393155342476520e-23,
   2.367032249976273e-24,  -1.142036865791861e-26,   6.721085416173233e-01,  -8.589458226326336e-03,   4.701374703538196e-05,   2.052969555867053e-07,  -5.784762306099844e-09,
   2.453593308075885e-11,   4.952888871039609e-13,  -7.616448565106422e-15,  -3.687611533415442e-19,   1.112289505543184e-18,  -1.045742407835081e-20,  -7.406923182677012e-23,
   2.362971221667046e-24,  -1.134442011967012e-26,   6.721133961179037e-01,  -8.589394513944755e-03,   4.701016109561671e-05,   2.053222682050903e-07,  -5.783994347538682e-09,
   2.451941870219653e-11,   4.952875490251791e-13,  -7.612312238472409e-15,  -4.172773992922180e-19,   1.111867554984460e-18,  -1.044133204404667e-20,  -7.416003806860584e-23,
   2.360287888818523e-24,  -1.129428359357506e-26,   6.721158890883189e-01,  -8.589361793574557e-03,   4.700831960565118e-05,   2.053352652366753e-07,  -5.783599964374717e-09,
   2.451093894127208e-11,   4.952868436901637e-13,  -7.610188240400883e-15,  -4.421831230358522e-19,   1.111650796465490e-18,  -1.043307038581169e-20,  -7.420661911862513e-23,
   2.358909907268903e-24,  -1.126855121080298e-26,   6.721167567818742e-01,  -8.589350404788691e-03,   4.700767866802512e-05,   2.053397886208684e-07,  -5.783462695751536e-09,
   2.450798766791476e-11,   4.952865953000592e-13,  -7.609448995834332e-15,  -4.508502458063450e-19,   1.111575341061771e-18,  -1.043019521752333e-20,  -7.422282375560474e-23,
   2.358430294301198e-24,  -1.125959722636991e-26,   6.721168944725292e-01,  -8.589348597537561e-03,   4.700757696051722e-05,   2.053405064029481e-07,  -5.783440913113854e-09,
   2.450751935026513e-11,   4.952865557466978e-13,  -7.609331689441520e-15,  -4.522255256028542e-19,   1.111563366824514e-18,  -1.042973898583538e-20,  -7.422539481319340e-23,
   2.358354186620347e-24,  -1.125817646661768e-26,   9.128631239250363e-01,  -9.968113095043590e-03,   2.203539321394115e-05,   5.996438837411521e-07,  -4.459998753520693e-09,
  -5.411501916084004e-11,   8.439368275531704e-13,   4.051750131446345e-15,  -1.513610970477443e-16,   7.611535657028182e-20,   2.516725046013692e-20,  -1.423915628366741e-22,
  -3.778597280600013e-24,   4.520491826776593e-26,   9.128651847164903e-01,  -9.967944623978084e-03,   2.203289113964454e-05,   5.995932181128614e-07,  -4.458816639275592e-09,
  -5.410703854763256e-11,   8.435416805932659e-13,   4.051988259305612e-15,  -1.512556680427562e-16,   7.539374958994600e-20,   2.514404849174587e-20,  -1.420668691628919e-22,
  -3.774751439103185e-24,   4.509826243895856e-26,   9.128688208255745e-01,  -9.967647365701557e-03,   2.202847672961841e-05,   5.995038238972233e-07,  -4.456731230973036e-09,
  -5.409295625794029e-11,   8.428446621038038e-13,   4.052406468900624e-15,  -1.510697163250733e-16,   7.412181783831835e-20,   2.510312757483302e-20,  -1.414945729955258e-22,
  -3.767967596889445e-24,   4.491029968148754e-26,   9.128732173238374e-01,  -9.967287937542452e-03,   2.202313969748414e-05,   5.993957378279471e-07,  -4.454210301583434e-09,
  -5.407592717040419e-11,   8.420022026383628e-13,   4.052908814642610e-15,  -1.508449968939178e-16,   7.258609315551287e-20,   2.505367850171965e-20,  -1.408036211933279e-22,
  -3.759768265901457e-24,   4.468341026767245e-26,   9.128774850293168e-01,  -9.966939031561801e-03,   2.201795956192504e-05,   5.992908206039334e-07,  -4.451763831627612e-09,
  -5.405939496752189e-11,   8.411847582252332e-13,   4.053392970209131e-15,  -1.506269848631128e-16,   7.109765364628697e-20,   2.500570867891509e-20,  -1.401339814968257e-22,
  -3.751812441910270e-24,   4.446356541407908e-26,   9.128809227945348e-01,  -9.966657972239079e-03,   2.201378720183654e-05,   5.992063084347267e-07,  -4.449793563622868e-09,
  -5.404607636929092e-11,   8.405265225985238e-13,   4.053780484877724e-15,  -1.504514586951659e-16,   6.990031515784870e-20,   2.496708951243135e-20,  -1.395953332099186e-22,
  -3.745406162317166e-24,   4.428675862525351e-26,   9.128831942896705e-01,  -9.966472260490595e-03,   2.201103051828759e-05,   5.991504681092059e-07,  -4.448491927769722e-09,
  -5.403727544721110e-11,   8.400917126845423e-13,   4.054035317294672e-15,  -1.503355238054708e-16,   6.910998113573765e-20,   2.494158274567968e-20,  -1.392397976986588e-22,
  -3.741174392907886e-24,   4.417007332195250e-26,   9.128843607743475e-01,  -9.966376890862298e-03,   2.200961493379926e-05,   5.991217926085926e-07,  -4.447823562720609e-09,
  -5.403275568176504e-11,   8.398684604190589e-13,   4.054165805625998e-15,  -1.502760010513372e-16,   6.870436826878807e-20,   2.492848753900223e-20,  -1.390573348782966e-22,
  -3.739001605684178e-24,   4.411019479770259e-26,   9.128847667741694e-01,  -9.966343696946489e-03,   2.200912224327685e-05,   5.991118120256066e-07,  -4.447590946032474e-09,
  -5.403118252474625e-11,   8.397907623369300e-13,   4.054211162756580e-15,  -1.502552860565306e-16,   6.856323260984685e-20,   2.492393022751813e-20,  -1.389938463872739e-22,
  -3.738245415485510e-24,   4.408936068465070e-26,   9.128848312004717e-01,  -9.966338429546138e-03,   2.200904406086549e-05,   5.991102282534479e-07,  -4.447554033626999e-09,
  -5.403093288585878e-11,   8.397784330495557e-13,   4.054218357435420e-15,  -1.502519989882058e-16,   6.854083829982286e-20,   2.492320707320130e-20,  -1.389837725572939e-22,
  -3.738125421757848e-24,   4.408605493749640e-26,   1.170179293329356e+00,  -1.022943152637137e-02,  -1.764458538278293e-05,   7.265299661474419e-07,   2.621031947058203e-09,
  -9.406286155772421e-11,  -4.624934697049603e-13,   1.484526221600872e-14,   8.875201855875834e-17,  -2.610502210910344e-18,  -1.819523155249165e-20,   4.872829767695854e-22,
   3.831545017636298e-24,  -9.589352277537231e-26,   1.170177642104924e+00,  -1.022922749991645e-02,  -1.764311470945290e-05,   7.264420268113225e-07,   2.620384301042914e-09,
  -9.403377397242189e-11,  -4.622620636737883e-13,   1.483651647978608e-14,   8.867600766346751e-17,  -2.608016488623494e-18,  -1.817185200286362e-20,   4.865919499669018e-22,
   3.824443734258085e-24,  -9.570823873387156e-26,   1.170174728605050e+00,  -1.022886751208712e-02,  -1.764051997872119e-05,   7.262868785944802e-07,   2.619241783390542e-09,
  -9.398246243638768e-11,  -4.618539058485462e-13,   1.482109129125446e-14,   8.854196514162408e-17,  -2.603633278877691e-18,  -1.813063398422463e-20,   4.853737186236424e-22,
   3.811927674604636e-24,  -9.538168741475263e-26,   1.170171205760169e+00,  -1.022843224515818e-02,  -1.763738290635822e-05,   7.260993094309608e-07,   2.617860688734457e-09,
  -9.392043978423152e-11,  -4.613606327381958e-13,   1.480245057867873e-14,   8.838001564259770e-17,  -2.598337973120471e-18,  -1.808085330707610e-20,   4.839024880227608e-22,
   3.796817423520202e-24,  -9.498747424989538e-26,   1.170167786042595e+00,  -1.022800973136808e-02,  -1.763433801823949e-05,   7.259172600224364e-07,   2.616520416914944e-09,
  -9.386025418647855e-11,  -4.608820602955337e-13,   1.478436662782995e-14,   8.822294034157084e-17,  -2.593202528344881e-18,  -1.803259047561114e-20,   4.824761967249454e-22,
   3.782174071862282e-24,  -9.460546510004332e-26,   1.170165031305340e+00,  -1.022766938540794e-02,  -1.763188547379417e-05,   7.257706316732524e-07,   2.615441048698240e-09,
  -9.381178729953948e-11,  -4.604967352026955e-13,   1.476980711861357e-14,   8.809650452561193e-17,  -2.589069165368057e-18,  -1.799375593961731e-20,   4.813285935642476e-22,
   3.770395769182271e-24,  -9.429821444437121e-26,   1.170163211093924e+00,  -1.022744450342039e-02,  -1.763026506107855e-05,   7.256737561195416e-07,   2.614727986529398e-09,
  -9.377976998017167e-11,  -4.602422203814681e-13,   1.476019070542726e-14,   8.801300790438861e-17,  -2.586339715661762e-18,  -1.796811696830611e-20,   4.805709620457386e-22,
   3.762621774792145e-24,  -9.409542878795105e-26,   1.170162276349881e+00,  -1.022732901964355e-02,  -1.762943295881040e-05,   7.256240101692404e-07,   2.614361846042193e-09,
  -9.376333025585290e-11,  -4.601115461108599e-13,   1.475525353141246e-14,   8.797014382402877e-17,  -2.584938569964105e-18,  -1.795495699099277e-20,   4.801820934861886e-22,
   3.758632206721129e-24,  -9.399136284551421e-26,   1.170161951007097e+00,  -1.022728882507577e-02,  -1.762914334710080e-05,   7.256066963173055e-07,   2.614234415619808e-09,
  -9.375760868922875e-11,  -4.600660687114318e-13,   1.475353531198207e-14,   8.795522704419565e-17,  -2.584450977078205e-18,  -1.795037763235477e-20,   4.800467778795131e-22,
   3.757244038662853e-24,  -9.395515354793960e-26,   1.170161899379841e+00,  -1.022728244678078e-02,  -1.762909739014332e-05,   7.256039488798118e-07,   2.614214194552583e-09,
  -9.375670077581556e-11,  -4.600588523107327e-13,   1.475326266415278e-14,   8.795286007325028e-17,  -2.584373607013159e-18,  -1.794965100304004e-20,   4.800253067539051e-22,
   3.757023776283291e-24,  -9.394940819149369e-26,   1.427945461970760e+00,  -9.047083777085102e-03,  -5.623635085265175e-05,   3.492992128839824e-07,   8.794712034754392e-09,
   9.235126046319401e-12,  -1.337356363313001e-12,  -1.093985041724683e-14,   1.670779567627868e-16,   3.292509930250443e-18,  -9.375084095499421e-21,  -7.447711124999989e-22,
  -3.583117528340810e-24,   1.321968859267989e-25,   1.427940199732552e+00,  -9.046985507049458e-03,  -5.623141442043658e-05,   3.493076913574259e-07,   8.792836556498739e-09,
   9.213763215695297e-12,  -1.336918617664350e-12,  -1.092883720693339e-14,   1.670377180226272e-16,   3.288706930295438e-18,  -9.396576926739602e-21,  -7.438131967305139e-22,
  -3.568435376834962e-24,   1.320379315532149e-25,   1.427930914805299e+00,  -9.046812106115468e-03,  -5.622270486446708e-05,   3.493226355287014e-07,   8.789527745702046e-09,
   9.176085743460030e-12,  -1.336146294859390e-12,  -1.090941463145059e-14,   1.669666430082471e-16,   3.282000483586839e-18,  -9.434427943364720e-21,  -7.421238844075541e-22,
  -3.542567884419302e-24,   1.317574424093164e-25,   1.427919688011160e+00,  -9.046602424598931e-03,  -5.621217463629198e-05,   3.493406785184930e-07,   8.785527548960160e-09,
   9.130555702839659e-12,  -1.335212541090033e-12,  -1.088594638357067e-14,   1.668805738301892e-16,   3.273897805340852e-18,  -9.480072741385630e-21,  -7.400827614493081e-22,
  -3.511355734829717e-24,   1.314182529678608e-25,   1.427908789902950e+00,  -9.046398866007440e-03,  -5.620195360171388e-05,   3.493581653851788e-07,   8.781645119981835e-09,
   9.086387288260242e-12,  -1.334306223395003e-12,  -1.086318238014337e-14,   1.667968891941135e-16,   3.266039013114210e-18,  -9.524253136588838e-21,  -7.381029622649649e-22,
  -3.481125692286482e-24,   1.310889550015866e-25,   1.427900011008140e+00,  -9.046234879415983e-03,  -5.619372076431077e-05,   3.493722318393001e-07,   8.778518125294365e-09,
   9.050828247473447e-12,  -1.333576216297408e-12,  -1.084485729028338e-14,   1.667293808290428e-16,   3.259713191053392e-18,  -9.559750703210036e-21,  -7.365092710183103e-22,
  -3.456822975601171e-24,   1.308236642251821e-25,   1.427894210305568e+00,  -9.046126518805177e-03,  -5.618828118816604e-05,   3.493815165509098e-07,   8.776452176054477e-09,
   9.027342459470508e-12,  -1.333093894828122e-12,  -1.083275490433981e-14,   1.666847269768711e-16,   3.255535705819505e-18,  -9.583161090069067e-21,  -7.354567803170867e-22,
  -3.440788732273688e-24,   1.306483589512826e-25,   1.427891231439833e+00,  -9.046070870078068e-03,  -5.618548787133826e-05,   3.493862815560915e-07,   8.775391309105202e-09,
   9.015284782287217e-12,  -1.332846216450457e-12,  -1.082654176184420e-14,   1.666617810207384e-16,   3.253391141841660e-18,  -9.595169298644580e-21,  -7.349164590922961e-22,
  -3.432561970557277e-24,   1.305583295631373e-25,   1.427890194629890e+00,  -9.046051500970320e-03,  -5.618451565822992e-05,   3.493879395601931e-07,   8.775022080064566e-09,
   9.011088538323622e-12,  -1.332760012394279e-12,  -1.082437954092427e-14,   1.666537922323580e-16,   3.252644830004559e-18,  -9.599346614597211e-21,  -7.347284244935087e-22,
  -3.429699778552064e-24,   1.305269937389187e-25,   1.427890030102980e+00,  -9.046048427356890e-03,  -5.618436138265217e-05,   3.493882026388938e-07,   8.774963489232774e-09,
   9.010422677879749e-12,  -1.332746333124618e-12,  -1.082403644144391e-14,   1.666525244154339e-16,   3.252526406447218e-18,  -9.600009390263885e-21,  -7.346985873762646e-22,
  -3.429245645425266e-24,   1.305220211624277e-25,   1.664709282654485e+00,  -6.487447455135993e-03,  -7.084225014443198e-05,  -3.090870292966561e-07,   4.616047182259863e-09,
   1.039732884043649e-10,   6.291697370401907e-13,  -9.815209014400129e-15,  -2.551227489942674e-16,  -1.691609858868913e-18,   2.756243740517877e-20,   7.536383832507830e-22,
   5.108664865619579e-24,  -9.026607685307790e-26,   1.664702646428968e+00,  -6.487534042965743e-03,  -7.083964867759016e-05,  -3.089897178346110e-07,   4.616924063155793e-09,
   1.039538757617760e-10,   6.285024658354701e-13,  -9.820817671627935e-15,  -2.550054900967545e-16,  -1.687750001055595e-18,   2.759307114127213e-20,   7.529694216424367e-22,
   5.087564150557143e-24,  -9.042850253018616e-26,   1.664690936903335e+00,  -6.487686806333287e-03,  -7.083505794919974e-05,  -3.088180250498384e-07,   4.618470571388217e-09,
   1.039196129202766e-10,   6.273253061178437e-13,  -9.830703663887264e-15,  -2.547984807120609e-16,  -1.680942034490766e-18,   2.764701897995714e-20,   7.517880745669546e-22,
   5.050356440740754e-24,  -9.071422537976176e-26,   1.664676777958635e+00,  -6.487871491544544e-03,  -7.082950611091016e-05,  -3.086104375754800e-07,   4.620339326755053e-09,
   1.038781667143981e-10,   6.259022998308642e-13,  -9.842639891104737e-15,  -2.545479853046981e-16,  -1.672714568157017e-18,   2.771207285053695e-20,   7.503579543382164e-22,
   5.005406860637098e-24,  -9.105822533011784e-26,   1.664663033055031e+00,  -6.488050741080936e-03,  -7.082411577012271e-05,  -3.084089417228047e-07,   4.622152122160814e-09,
   1.038379155402190e-10,   6.245213181626279e-13,  -9.854208510004913e-15,  -2.543046231946354e-16,  -1.664732515791789e-18,   2.777503718452458e-20,   7.489679236356920e-22,
   4.961815012727423e-24,  -9.139060586322243e-26,   1.664651960593675e+00,  -6.488195113755268e-03,  -7.081977287155094e-05,  -3.082466382569542e-07,   4.623611512338732e-09,
   1.038054783251376e-10,   6.234091385611753e-13,  -9.863514527822974e-15,  -2.541084411532546e-16,  -1.658305884289574e-18,   2.782562520902627e-20,   7.478469219156174e-22,
   4.926729850838973e-24,  -9.165724424105753e-26,   1.664644644232950e+00,  -6.488290498731683e-03,  -7.081690291185227e-05,  -3.081394003092535e-07,   4.624575374434706e-09,
   1.037840388173301e-10,   6.226743874510492e-13,  -9.869657165138064e-15,  -2.539787426764992e-16,  -1.654061047294042e-18,   2.785898669630310e-20,   7.471055922765091e-22,
   4.903561815403889e-24,  -9.183288461013732e-26,   1.664640886970143e+00,  -6.488339479177952e-03,  -7.081542897302440e-05,  -3.080843313657083e-07,   4.625070216258635e-09,
   1.037730268813334e-10,   6.222971062754564e-13,  -9.872809658445130e-15,  -2.539121162577030e-16,  -1.651881666939947e-18,   2.787609895676775e-20,   7.467247013315169e-22,
   4.891668752383283e-24,  -9.192291447557184e-26,   1.664639579226544e+00,  -6.488356526585778e-03,  -7.081491594282872e-05,  -3.080651645731374e-07,   4.625242427009187e-09,
   1.037691938019580e-10,   6.221657978575802e-13,  -9.873906587101009e-15,  -2.538889231329894e-16,  -1.651123200679825e-18,   2.788205177913771e-20,   7.465920996878720e-22,
   4.887530032350857e-24,  -9.195422315825403e-26,   1.664639371705937e+00,  -6.488359231742098e-03,  -7.081483453141888e-05,  -3.080621230888474e-07,   4.625269753369028e-09,
   1.037685855320353e-10,   6.221449613880277e-13,  -9.874080639119286e-15,  -2.538852425521367e-16,  -1.651002846662105e-18,   2.788299625547496e-20,   7.465710562540678e-22,
   4.886873311015174e-24,  -9.195919013163373e-26,   1.854577433731308e+00,  -3.263872672018862e-03,  -4.950065538755698e-05,  -5.624202543278798e-07,  -4.182111132012898e-09,
   1.207278474322487e-12,   6.741426094212620e-13,   1.294065087248248e-14,   1.369591159309651e-16,   3.472003914958449e-19,  -1.956334734741796e-20,  -4.785437729480590e-22,
  -6.087383684763701e-24,  -2.963722369554320e-26,   1.854572788342516e+00,  -3.264030847616372e-03,  -4.950300244308986e-05,  -5.624189081393349e-07,  -4.181158892410078e-09,
   1.232772797937214e-12,   6.745003934022567e-13,   1.294175811127524e-14,   1.368753821667786e-16,   3.447249733128644e-19,  -1.960074369898323e-20,  -4.787493637462520e-22,
  -6.081606062676765e-24,  -2.943577040827954e-26,   1.854564591302540e+00,  -3.264309950605661e-03,  -4.950714342309495e-05,  -5.624165133315643e-07,  -4.179478242259095e-09,
   1.277759674123609e-12,   6.751315294478470e-13,   1.294370505351230e-14,   1.367275045939617e-16,   3.403562084924943e-19,  -1.966670083505306e-20,  -4.791109318217448e-22,
  -6.071388609744866e-24,  -2.908011928520102e-26,   1.854554679050104e+00,  -3.264647444338144e-03,  -4.951214999612617e-05,  -5.624135843619857e-07,  -4.177445285938846e-09,
   1.332161246740695e-12,   6.758943997891244e-13,   1.294604772407356e-14,   1.365484712226195e-16,   3.350720046791798e-19,  -1.974640684664941e-20,  -4.795460967520027e-22,
  -6.058994784945287e-24,  -2.864974986748123e-26,   1.854545056088580e+00,  -3.264975076795947e-03,  -4.951700951104264e-05,  -5.624107062614457e-07,  -4.175470998258754e-09,
   1.384976443246162e-12,   6.766346603189782e-13,   1.294830980622294e-14,   1.363744402845638e-16,   3.299406805043849e-19,  -1.982373153862864e-20,  -4.799664027383906e-22,
  -6.046922492961991e-24,  -2.823162871991528e-26,   1.854537303727775e+00,  -3.265239012799471e-03,  -4.952092371442787e-05,  -5.624083628324184e-07,  -4.173880015668344e-09,
   1.427525887068248e-12,   6.772307745607229e-13,   1.295012340914942e-14,   1.362340796097814e-16,   3.258058732561817e-19,  -1.988598560102079e-20,  -4.803034585156028e-22,
  -6.037168149074314e-24,  -2.789456294733598e-26,   1.854532180994161e+00,  -3.265413416790394e-03,  -4.952350987672702e-05,  -5.624068021595825e-07,  -4.172828467127023e-09,
   1.455642880120315e-12,   6.776245635433660e-13,   1.295131754482413e-14,   1.361412516916245e-16,   3.230731391222668e-19,  -1.992710348720624e-20,  -4.805254260179123e-22,
  -6.030708428302822e-24,  -2.767172219670950e-26,   1.854529550190795e+00,  -3.265502981516896e-03,  -4.952483791019744e-05,  -5.624059969135856e-07,  -4.172288367604290e-09,
   1.470082634380607e-12,   6.778267581635268e-13,   1.295192947280714e-14,   1.360935553524448e-16,   3.216695866251180e-19,  -1.994821376516435e-20,  -4.806391840371228e-22,
  -6.027386654874415e-24,  -2.755724771195802e-26,   1.854528634510092e+00,  -3.265534155329355e-03,  -4.952530013093711e-05,  -5.624057160408125e-07,  -4.172100368438290e-09,
   1.475108576045529e-12,   6.778971283009480e-13,   1.295214225013542e-14,   1.360769502632099e-16,   3.211810414368676e-19,  -1.995556047891985e-20,  -4.806787414721862e-22,
  -6.026229781196488e-24,  -2.751739823743838e-26,   1.854528489203914e+00,  -3.265539102183546e-03,  -4.952537347836314e-05,  -5.624056714417098e-07,  -4.172070534962571e-09,
   1.475906126282430e-12,   6.779082948090162e-13,   1.295217600500640e-14,   1.360743150771268e-16,   3.211035148153302e-19,  -1.995672625791471e-20,  -4.806850169316742e-22,
  -6.026046168046646e-24,  -2.751107440977793e-26,   1.971336561171739e+00,  -7.015887435125229e-04,  -1.264126882684842e-05,  -1.973766013431209e-07,  -2.793355850039169e-09,
  -3.627614686233676e-11,  -4.299908603507003e-13,  -4.533266450912910e-15,  -3.946078621954812e-17,  -2.078168587129036e-19,   1.532080236382907e-21,   7.195952503375158e-23,
   1.482617335401154e-24,   2.357685131131569e-26,   1.971335372893947e+00,  -7.016443756442379e-04,  -1.264284350717741e-05,  -1.974106853052642e-07,  -2.793961746598033e-09,
  -3.628508269020725e-11,  -4.300943041204385e-13,  -4.533957955120436e-15,  -3.945402315408485e-17,  -2.074390253770796e-19,   1.541379110704297e-21,   7.213381065750530e-23,
   1.485316131469133e-24,   2.361092270613523e-26,   1.971333276038628e+00,  -7.017425472239428e-04,  -1.264562233280582e-05,  -1.974708338077559e-07,  -2.795030978834248e-09,
  -3.630085120124173e-11,  -4.302768176668770e-13,  -4.535177083457350e-15,  -3.944205761447854e-17,  -2.067715999609969e-19,   1.557800720411188e-21,   7.244154297156834e-23,
   1.490080303224686e-24,   2.367104428315609e-26,   1.971330740293361e+00,  -7.018612706615917e-04,  -1.264898299150006e-05,  -1.975435776405066e-07,  -2.796324107452824e-09,
  -3.631992053143073e-11,  -4.304974900347211e-13,  -4.536649488877208e-15,  -3.942753415433071e-17,  -2.059632923744146e-19,   1.577681102145576e-21,   7.281400161278140e-23,
   1.495844774693493e-24,   2.374374735812263e-26,   1.971328278420627e+00,  -7.019765392640043e-04,  -1.265224595621249e-05,  -1.976142082641553e-07,  -2.797579665403688e-09,
  -3.633843467242470e-11,  -4.307116887491659e-13,  -4.538077011335093e-15,  -3.941337781131003e-17,  -2.051772920053696e-19,   1.597004932266540e-21,   7.317593976446625e-23,
   1.501444573449212e-24,   2.381432970135274e-26,   1.971326295013819e+00,  -7.020694081430935e-04,  -1.265487491315613e-05,  -1.976711160963552e-07,  -2.798591277783272e-09,
  -3.635335083077169e-11,  -4.308842256332907e-13,  -4.539225668619090e-15,  -3.940193261923424e-17,  -2.045431616569962e-19,   1.612589375644845e-21,   7.346777163199840e-23,
   1.505958382581728e-24,   2.387119230645410e-26,   1.971324984338453e+00,  -7.021307791367456e-04,  -1.265661225490481e-05,  -1.977087240480060e-07,  -2.799259807260863e-09,
  -3.636320785103884e-11,  -4.309982257034875e-13,  -4.539984026127951e-15,  -3.939434974103669e-17,  -2.041236798089225e-19,   1.622895828716888e-21,   7.366073584480715e-23,
   1.508942340420954e-24,   2.390876723572499e-26,   1.971324311220594e+00,  -7.021622975916921e-04,  -1.265750451678402e-05,  -1.977280388512071e-07,  -2.799603152031735e-09,
  -3.636827011543981e-11,  -4.310567673363870e-13,  -4.540373276396782e-15,  -3.939044935192453e-17,  -2.039081135627713e-19,   1.628191324214375e-21,   7.375987145081491e-23,
   1.510475151442148e-24,   2.392806410242786e-26,   1.971324076932043e+00,  -7.021732681194861e-04,  -1.265781508526149e-05,  -1.977347617555788e-07,  -2.799722659968514e-09,
  -3.637003211680191e-11,  -4.310771428325284e-13,  -4.540508726254094e-15,  -3.938909079558813e-17,  -2.038330611069857e-19,   1.630034890051174e-21,   7.379438275500051e-23,
   1.511008724954529e-24,   2.393478060746043e-26,   1.971324039753500e+00,  -7.021750090025954e-04,  -1.265786436860799e-05,  -1.977358285978940e-07,  -2.799741624405229e-09,
  -3.637031172375955e-11,  -4.310803761215290e-13,  -4.540530218749161e-15,  -3.938887516439601e-17,  -2.038211502405552e-19,   1.630327458505609e-21,   7.379985952032227e-23,
   1.511093398788797e-24,   2.393584642685094e-26,   5.480518804530602e-03,  -9.117632920921896e-05,   1.134831546117576e-06,  -1.252351006526648e-08,   1.290314250396886e-10,
  -1.271295452998267e-12,   1.210123259453335e-14,  -1.122892583615592e-16,   1.015525832192882e-18,  -9.036130764505160e-21,   7.799007289569198e-23,  -6.756848830171667e-25,
   5.407838001862396e-27,  -4.761714374459520e-29,   5.480625340675276e-03,  -9.117985564453364e-05,   1.134904222404514e-06,  -1.252470376568793e-08,   1.290484739809168e-10,
  -1.271517008790447e-12,   1.210390516543851e-14,  -1.123198464714631e-16,   1.015855933445297e-18,  -9.039628337692259e-21,   7.802367924977074e-23,  -6.760337862570093e-25,
   5.410968530761127e-27,  -4.762998542494812e-29,   5.480813330932207e-03,  -9.118607836848990e-05,   1.135032468662262e-06,  -1.252681023791028e-08,   1.290785601645775e-10,
  -1.271907996481450e-12,   1.210862166405288e-14,  -1.123738292803437e-16,   1.016438517700235e-18,  -9.045801324033509e-21,   7.808299399811539e-23,  -6.766495070168764e-25,
   5.416497731712209e-27,  -4.765258159466043e-29,   5.481040660229361e-03,  -9.119360341892510e-05,   1.135187558718450e-06,  -1.252935769489804e-08,   1.291149459151345e-10,
  -1.272380866552090e-12,   1.211432610717905e-14,  -1.124391222543996e-16,   1.017143181613266e-18,  -9.053268260558900e-21,   7.815474499771491e-23,  -6.773941716244070e-25,
   5.423192795105521e-27,  -4.767979766974655e-29,   5.481261357493284e-03,  -9.120090909580129e-05,   1.135338131400849e-06,  -1.253183102395161e-08,   1.291502740346007e-10,
  -1.272840008165980e-12,   1.211986514139760e-14,  -1.125025247048887e-16,   1.017827463284617e-18,  -9.060519646809251e-21,   7.822442789455412e-23,  -6.781172133595172e-25,
   5.429701771113732e-27,  -4.770610638057143e-29,   5.481439155445191e-03,  -9.120679480388561e-05,   1.135459440784862e-06,  -1.253382372201130e-08,   1.291787378227041e-10,
  -1.273209949407141e-12,   1.212432821796673e-14,  -1.125536131931325e-16,   1.018378859434292e-18,  -9.066363142048298e-21,   7.828058380085187e-23,  -6.786997823212233e-25,
   5.434952142159088e-27,  -4.772722019763693e-29,   5.481556644643990e-03,  -9.121068414621932e-05,   1.135539604756112e-06,  -1.253514056732522e-08,   1.291975481036604e-10,
  -1.273454430706180e-12,   1.212727778147293e-14,  -1.125873775788076e-16,   1.018743284535342e-18,  -9.070225336644144e-21,   7.831770055515758e-23,  -6.790847803970620e-25,
   5.438424835504678e-27,  -4.774113269133006e-29,   5.481616982045336e-03,  -9.121268156257845e-05,   1.135580774303823e-06,  -1.253581686316596e-08,   1.292072086758145e-10,
  -1.273579993051619e-12,   1.212879266017552e-14,  -1.126047190692238e-16,   1.018930456639049e-18,  -9.072209041988100e-21,   7.833676485739145e-23,  -6.792825098102031e-25,
   5.440209263185082e-27,  -4.774826533871578e-29,   5.481637983201748e-03,  -9.121337679006751e-05,   1.135595103982764e-06,  -1.253605225934279e-08,   1.292105712208070e-10,
  -1.273623697688361e-12,   1.212931994934649e-14,  -1.126107552303519e-16,   1.018995607166555e-18,  -9.072899533953416e-21,   7.834340085171028e-23,  -6.793513336466446e-25,
   5.440830514115957e-27,  -4.775074600004430e-29,   5.481641315804172e-03,  -9.121348711349556e-05,   1.135597377916894e-06,  -1.253608961372175e-08,   1.292111048148684e-10,
  -1.273630633084108e-12,   1.212940362390929e-14,  -1.126117131000715e-16,   1.019005945827142e-18,  -9.073009107662340e-21,   7.834445391584938e-23,  -6.793622551509470e-25,
   5.440929105893774e-27,  -4.775113955563073e-29,   4.922597213920158e-02,  -8.074759677365467e-04,   9.739990404010276e-06,  -1.016260153686990e-07,   9.564072863323789e-10,
  -8.198194536651414e-12,   6.302772107234398e-14,  -4.164372746370640e-16,   1.992374495159003e-18,  -7.621511605090749e-22,  -1.531457524206101e-22,   2.473532645698394e-24,
  -3.189555299169607e-26,   2.801355278121932e-28,   4.922688634248898e-02,  -8.075045770950086e-04,   9.740528882736041e-06,  -1.016337080545137e-07,   9.564959805599653e-10,
  -8.199014430764627e-12,   6.303293755045201e-14,  -4.164395120019231e-16,   1.991722030934150e-18,  -7.493165840146452e-22,  -1.533440836884735e-22,   2.475597654266791e-24,
  -3.191669915380738e-26,   2.804339509511919e-28,   4.922849950969810e-02,  -8.075550605190398e-04,   9.741479077508894e-06,  -1.016472825447843e-07,   9.566524888808295e-10,
  -8.200461150263552e-12,   6.304214071195657e-14,  -4.164434245916203e-16,   1.990570066420633e-18,  -7.266610979411013e-22,  -1.536941483950148e-22,   2.479243177730548e-24,
  -3.195398333075791e-26,   2.809612033310261e-28,   4.923045023884980e-02,  -8.076161086174437e-04,   9.742628132392045e-06,  -1.016636980293618e-07,   9.568417505775252e-10,
  -8.202210544762447e-12,   6.305326689157916e-14,  -4.164480955723994e-16,   1.989175937000018e-18,  -6.992510471910418e-22,  -1.541176311285382e-22,   2.483654427179141e-24,
  -3.199901905314564e-26,   2.815999195346179e-28,   4.923234404638183e-02,  -8.076753761991335e-04,   9.743743687462501e-06,  -1.016796350138468e-07,   9.570254931976558e-10,
  -8.203908832708784e-12,   6.306406549890318e-14,  -4.164525670551820e-16,   1.987821323533441e-18,  -6.726263447268568e-22,  -1.545289299899144e-22,   2.487939982439514e-24,
  -3.204268794220578e-26,   2.822211824918177e-28,   4.923386972572259e-02,  -8.077231236453256e-04,   9.744642416053688e-06,  -1.016924744410613e-07,   9.571735214863237e-10,
  -8.205276955692514e-12,   6.307276292779384e-14,  -4.164561240520252e-16,   1.986729192514303e-18,  -6.511667205722156e-22,  -1.548604024437463e-22,   2.491394658585400e-24,
  -3.207783047573463e-26,   2.827225273055810e-28,   4.923487789321758e-02,  -8.077546754104137e-04,   9.745236305325389e-06,  -1.017009588974276e-07,   9.572713396746762e-10,
  -8.206180989079236e-12,   6.307850915769056e-14,  -4.164584523290531e-16,   1.986007104734666e-18,  -6.369811415519346e-22,  -1.550794998155127e-22,   2.493678568573565e-24,
  -3.210103413462432e-26,   2.830542288672237e-28,   4.923539564343375e-02,  -8.077708790926764e-04,   9.745541303747247e-06,  -1.017053161928409e-07,   9.573215751489670e-10,
  -8.206645254123496e-12,   6.308145985064717e-14,  -4.164596411676661e-16,   1.985636146018373e-18,  -6.296944846848678e-22,  -1.551920372891897e-22,   2.494851812689804e-24,
  -3.211294478704704e-26,   2.832247037499568e-28,   4.923557585240650e-02,  -8.077765189869959e-04,   9.745647462493083e-06,  -1.017068328086922e-07,   9.573390602495700e-10,
  -8.206806845925984e-12,   6.308248682319515e-14,  -4.164600538642977e-16,   1.985507009409282e-18,  -6.271580290163344e-22,  -1.552312102488235e-22,   2.495260226319337e-24,
  -3.211708951720292e-26,   2.832840598138818e-28,   4.923560444914882e-02,  -8.077774139631293e-04,   9.745664308483442e-06,  -1.017070734756559e-07,   9.573418349029491e-10,
  -8.206832488324406e-12,   6.308264978754586e-14,  -4.164601193018434e-16,   1.985486516209485e-18,  -6.267555157100441e-22,  -1.552374266128308e-22,   2.495325038561834e-24,
  -3.211774718694807e-26,   2.832934797870422e-28,   1.361648149567816e-01,  -2.168970590095124e-03,   2.445257710499341e-05,  -2.239163282279386e-07,   1.646763261959138e-09,
  -8.263240693525939e-12,  -3.436104902435021e-15,   7.325353112138888e-16,  -1.124955033653213e-17,   1.116793822199954e-19,  -7.686958660429863e-22,   1.365121166862952e-24,
   4.492877230729250e-26,  -1.036129022193158e-27,   1.361671092408300e-01,  -2.169033593680049e-03,   2.445350337806983e-05,  -2.239240628190463e-07,   1.646758079832970e-09,
  -8.261792518939059e-12,  -3.465701673932078e-15,   7.329124029855992e-16,  -1.125278415776166e-17,   1.116861250137589e-19,  -7.684133047574031e-22,   1.357515678156401e-24,
   4.502710983081911e-26,  -1.036654672141730e-27,   1.361711576117837e-01,  -2.169144766264934e-03,   2.445513779905732e-05,  -2.239377095213063e-07,   1.646748902025837e-09,
  -8.259236588400665e-12,  -3.517932539508876e-15,   7.335778056427576e-16,  -1.125848931311551e-17,   1.116979908676658e-19,  -7.679142248708626e-22,   1.344092581339424e-24,
   4.520075116547603e-26,  -1.037579747798596e-27,   1.361760530656729e-01,  -2.169279200357056e-03,   2.445711415422863e-05,  -2.239542093743276e-07,   1.646737746377079e-09,
  -8.256144900509802e-12,  -3.581102418192106e-15,   7.343824487776504e-16,  -1.126538638757895e-17,   1.117122847639504e-19,  -7.673098859037595e-22,   1.327855966438641e-24,
   4.541093017626602e-26,  -1.038694201026733e-27,   1.361808056137310e-01,  -2.169409709803340e-03,   2.445903276125925e-05,  -2.239702251715064e-07,   1.646726856188100e-09,
  -8.253142465445377e-12,  -3.642438953959916e-15,   7.351636149296111e-16,  -1.127208020789056e-17,   1.117261040306016e-19,  -7.667223173842912e-22,   1.312088243206064e-24,
   4.561518821161376e-26,  -1.039771745691585e-27,   1.361846342950383e-01,  -2.169514848777703e-03,   2.446057836300033e-05,  -2.239831258744183e-07,   1.646718039856147e-09,
  -8.250722970417064e-12,  -3.691859689053942e-15,   7.357929354731937e-16,  -1.127747141459484e-17,   1.117371958035682e-19,  -7.662483441187250e-22,   1.299382039618695e-24,
   4.577989332478194e-26,  -1.040636691904889e-27,   1.361871642637016e-01,  -2.169584323846294e-03,   2.446159966755967e-05,  -2.239916497361418e-07,   1.646712192959974e-09,
  -8.249123833015995e-12,  -3.724520348171050e-15,   7.362087906396805e-16,  -1.128103321652083e-17,   1.117445050458306e-19,  -7.659348396150947e-22,   1.290984085597997e-24,
   4.588880462172691e-26,  -1.041206712364147e-27,   1.361884635373529e-01,  -2.169620002960711e-03,   2.446212415584231e-05,  -2.239960269326653e-07,   1.646709183735795e-09,
  -8.248302482484898e-12,  -3.741294494581769e-15,   7.364223556748445e-16,  -1.128286218305703e-17,   1.117482525044511e-19,  -7.657737437115847e-22,   1.286670741043929e-24,
   4.594475962069544e-26,  -1.041498975320474e-27,   1.361889157636248e-01,  -2.169632421457738e-03,   2.446230670871630e-05,  -2.239975504218777e-07,   1.646708135302849e-09,
  -8.248016585290563e-12,  -3.747133102408640e-15,   7.364966894993638e-16,  -1.128349874148355e-17,   1.117495558567004e-19,  -7.657176574666764e-22,   1.285169347579311e-24,
   4.596423906493088e-26,  -1.041600625360777e-27,   1.361889875258094e-01,  -2.169634392104774e-03,   2.446233567733964e-05,  -2.239977921770139e-07,   1.646707968881373e-09,
  -8.247971216459295e-12,  -3.748059619150613e-15,   7.365084852800664e-16,  -1.128359975310869e-17,   1.117497626339879e-19,  -7.657087566237233e-22,   1.284931092634283e-24,
   4.596733036458078e-26,  -1.041616752273991e-27,   2.650638635475620e-01,  -4.027973308785606e-03,   4.044301866938307e-05,  -2.839553676245693e-07,   8.790437537877866e-10,
   1.089230778611661e-11,  -2.294935971439176e-13,   2.220305693847033e-15,  -9.251144518484150e-18,  -9.974455101562038e-20,   2.477217863381806e-21,  -2.746335046472754e-23,
   1.215651019334961e-25,   1.028498844330852e-27,   2.650676560620266e-01,  -4.028053134970525e-03,   4.044351130709611e-05,  -2.839451194048710e-07,   8.787207447629013e-10,
   1.089667358290352e-11,  -2.295176649519823e-13,   2.219965374365739e-15,  -9.240670084738612e-18,  -9.988585464645510e-20,   2.477956760811827e-21,  -2.745557708322419e-23,
   1.212783416153627e-25,   1.033070886140576e-27,   2.650743480508940e-01,  -4.028193987182032e-03,   4.044438042632034e-05,  -2.839270329338211e-07,   8.781507628171801e-10,
   1.090437655360226e-11,  -2.295601106103945e-13,   2.219364487781327e-15,  -9.222185258701060e-18,  -1.001351542844474e-19,   2.479259114850304e-21,  -2.744183361238016e-23,
   1.207723858907153e-25,   1.041140969101214e-27,   2.650824401391512e-01,  -4.028364303177804e-03,   4.044543112260304e-05,  -2.839051569086683e-07,   8.774614877886703e-10,
   1.091369013597034e-11,  -2.296113982118604e-13,   2.218637228635433e-15,  -9.199828911162311e-18,  -1.004365539946010e-19,   2.480831476497442e-21,  -2.742516844290433e-23,
   1.201606428775117e-25,   1.050903887166444e-27,   2.650902958651774e-01,  -4.028529638805440e-03,   4.044645085649603e-05,  -2.838839141037518e-07,   8.767923025678073e-10,
   1.092273062388451e-11,  -2.296611473807509e-13,   2.217930526279660e-15,  -9.178121259045019e-18,  -1.007290887942182e-19,   2.482355323333111e-21,  -2.740894156318938e-23,
   1.195668408595888e-25,   1.060386233484245e-27,   2.650966243837760e-01,  -4.028662828032342e-03,   4.044727215178918e-05,  -2.838667969217914e-07,   8.762531805961347e-10,
   1.093001282324889e-11,  -2.297011960391898e-13,   2.217360720460029e-15,  -9.160630637813270e-18,  -1.009647088086147e-19,   2.483581069929543e-21,  -2.739583455316476e-23,
   1.190885303506325e-25,   1.068028420086643e-27,   2.651008061795648e-01,  -4.028750835629489e-03,   4.044781475651139e-05,  -2.838554841098335e-07,   8.758969212412601e-10,
   1.093482442790466e-11,  -2.297276454623280e-13,   2.216983960292544e-15,  -9.149071572014868e-18,  -1.011203816182958e-19,   2.484390118328721e-21,  -2.738715660871813e-23,
   1.187724952418511e-25,   1.073079865083242e-27,   2.651029537390416e-01,  -4.028796031286577e-03,   4.044809338136808e-05,  -2.838496737954143e-07,   8.757139597105773e-10,
   1.093729531102696e-11,  -2.297412241715228e-13,   2.216790400887663e-15,  -9.143134951864386e-18,  -1.012003206475065e-19,   2.484805324106580e-21,  -2.738269479047824e-23,
   1.186102035260374e-25,   1.075674524592928e-27,   2.651037012179380e-01,  -4.028811761976467e-03,   4.044819035474290e-05,  -2.838476513597191e-07,   8.756502774297790e-10,
   1.093815530763191e-11,  -2.297459496754219e-13,   2.216723018819533e-15,  -9.141068579382063e-18,  -1.012281431381037e-19,   2.484949795818002e-21,  -2.738114097335656e-23,
   1.185537175939876e-25,   1.076577699190511e-27,   2.651038198325992e-01,  -4.028814258216867e-03,   4.044820574286555e-05,  -2.838473304221592e-07,   8.756401718887732e-10,
   1.093829177644700e-11,  -2.297466995150440e-13,   2.216712325646277e-15,  -9.140740670850253e-18,  -1.012325581357226e-19,   2.484972719378174e-21,  -2.738089436407978e-23,
   1.185447541108522e-25,   1.076721024336295e-27,   4.337233084429769e-01,  -6.150389923547600e-03,   5.104677852688700e-05,  -1.835285455790605e-07,  -1.894011423876457e-09,
   3.849532297996084e-11,  -2.703128487409162e-13,  -9.042531053980047e-16,   4.287773145322784e-17,  -4.502305824942507e-19,   4.571923086869148e-22,   5.093803681313014e-23,
  -7.782705504328054e-25,   3.205160026247109e-27,   4.337280919260517e-01,  -6.150441413788421e-03,   5.104571101010823e-05,  -1.834924714783905e-07,  -1.894390219038598e-09,
   3.849351868989342e-11,  -2.702002587302052e-13,  -9.057657573972062e-16,   4.287950626518610e-17,  -4.499670499843280e-19,   4.524001796512773e-22,   5.096084811139333e-23,
  -7.777669030750630e-25,   3.193789702394406e-27,   4.337365323756971e-01,  -6.150532260883797e-03,   5.104382718701501e-05,  -1.834288195419067e-07,  -1.895058480334725e-09,
   3.849033257387310e-11,  -2.700015881877139e-13,  -9.084341319355839e-16,   4.288262153316228e-17,  -4.495019477326083e-19,   4.439469379183946e-22,   5.100103158256656e-23,
  -7.768771336435761e-25,   3.173739452604158e-27,   4.337467385186319e-01,  -6.150642100104723e-03,   5.104154895316037e-05,  -1.833518532973077e-07,  -1.895866329541811e-09,
   3.848647576656209e-11,  -2.697613473646690e-13,  -9.116595247731792e-16,   4.288636056443857e-17,  -4.489393793441347e-19,   4.337295314083997e-22,   5.104950695497162e-23,
  -7.757993819270113e-25,   3.149516409057527e-27,   4.337566463199978e-01,  -6.150748715398530e-03,   5.103933697446547e-05,  -1.832771382692576e-07,  -1.896650345714496e-09,
   3.848272732951363e-11,  -2.695281191860553e-13,  -9.147893876768856e-16,   4.288996105431415e-17,  -4.483930785266377e-19,   4.238152034425202e-22,   5.109644574126775e-23,
  -7.747512012649837e-25,   3.126024060213491e-27,   4.337646278116573e-01,  -6.150834592745741e-03,   5.103755481204413e-05,  -1.832169505850966e-07,  -1.897281774255741e-09,
   3.847970454620922e-11,  -2.693402289295716e-13,  -9.173098382048643e-16,   4.289284057636070e-17,  -4.479528646606171e-19,   4.158316155895072e-22,   5.113417289391463e-23,
  -7.739054274516958e-25,   3.107115378367038e-27,   4.337699017881028e-01,  -6.150891333802927e-03,   5.103637708259742e-05,  -1.831771805030896e-07,  -1.897698930348915e-09,
   3.847770563162194e-11,  -2.692160721179324e-13,  -9.189748533961684e-16,   4.289473304022009e-17,  -4.476619199897394e-19,   4.105578033339951e-22,   5.115906017510659e-23,
  -7.733458833207020e-25,   3.094628910554561e-27,   4.337726102115673e-01,  -6.150920471453756e-03,   5.103577222869486e-05,  -1.831567569314241e-07,  -1.897913135024567e-09,
   3.847667862541827e-11,  -2.691523109520472e-13,  -9.198297780658908e-16,   4.289570173440405e-17,  -4.475124876898299e-19,   4.078499436147156e-22,   5.117182795383364e-23,
  -7.730583229517738e-25,   3.088219001806260e-27,   4.337735529006431e-01,  -6.150930612825718e-03,   5.103556169842530e-05,  -1.831496483630066e-07,  -1.897987686953312e-09,
   3.847632109201625e-11,  -2.691301181826921e-13,  -9.201273200893289e-16,   4.289603839161472e-17,  -4.474604734988884e-19,   4.069075271061747e-22,   5.117626982195444e-23,
  -7.729582018767942e-25,   3.085988370737675e-27,   4.337737024922972e-01,  -6.150932222109710e-03,   5.103552828991798e-05,  -1.831485203331285e-07,  -1.897999517129177e-09,
   3.847626435285332e-11,  -2.691265964905418e-13,  -9.201745348501942e-16,   4.289609179047252e-17,  -4.474522194249935e-19,   4.067579823299226e-22,   5.117697458678952e-23,
  -7.729423124720195e-25,   3.085634419124331e-27,   6.384767642113758e-01,  -8.205311549901291e-03,   4.896528588053148e-05,   1.169659556520439e-07,  -5.195799968042075e-09,
   3.401665171414399e-11,   2.865627402956309e-13,  -7.092010375489803e-15,   3.206278465911413e-17,   6.586954146129189e-19,  -1.156839731666128e-20,   2.140062975041730e-23,
   1.492107523918593e-24,  -2.014606765591618e-26,   6.384813488355463e-01,  -8.205278541399857e-03,   4.896236552952764e-05,   1.169977291411656e-07,  -5.195396008048905e-09,
   3.400272475632461e-11,   2.866459040226065e-13,  -7.089784575766415e-15,   3.201427700702227e-17,   6.588001178354757e-19,  -1.155917625310794e-20,   2.125527889033128e-23,
   1.491865883892966e-24,  -2.011041018750771e-26,   6.384894382548274e-01,  -8.205220290134027e-03,   4.895721270912894e-05,   1.170537833593338e-07,  -5.194683119588743e-09,
   3.397815398372664e-11,   2.867925443873043e-13,  -7.085856833928650e-15,   3.192871610739514e-17,   6.589842610186210e-19,  -1.154290677902514e-20,   2.099901688884734e-23,
   1.491437486265712e-24,  -2.004749976896436e-26,   6.384992196882092e-01,  -8.205149839727999e-03,   4.895098217892841e-05,   1.171215466413209e-07,  -5.193820925859851e-09,
   3.394844881945947e-11,   2.869696873262346e-13,  -7.081106884773508e-15,   3.182530885766259e-17,   6.592058940338572e-19,  -1.152323567430515e-20,   2.068950337563221e-23,
   1.490916023984485e-24,  -1.997144110976643e-26,   6.385087149377107e-01,  -8.205081434759495e-03,   4.894493401825651e-05,   1.171873111342533e-07,  -5.192983754213574e-09,
   3.391961792381036e-11,   2.871414702142311e-13,  -7.076495213314324e-15,   3.172497933386718e-17,   6.594199685785648e-19,  -1.150414153226468e-20,   2.038941125732389e-23,
   1.490406202178616e-24,  -1.989761870604285e-26,   6.385163639029985e-01,  -8.205026319340867e-03,   4.894006193528205e-05,   1.172402765941968e-07,  -5.192309218679321e-09,
   3.389639668899072e-11,   2.872797241867528e-13,  -7.072779751354530e-15,   3.164419561367718e-17,   6.595916488648919e-19,  -1.148876114082272e-20,   2.014793192964971e-23,
   1.489992924845560e-24,  -1.983815846315153e-26,   6.385214180638374e-01,  -8.204989895518006e-03,   4.893684266550586e-05,   1.172752685877673e-07,  -5.191863438427007e-09,
   3.388105474339245e-11,   2.873710152918336e-13,  -7.070324464718391e-15,   3.159083496962795e-17,   6.597047127124067e-19,  -1.147859883858516e-20,   1.998849935900290e-23,
   1.489718581265262e-24,  -1.979887318224236e-26,   6.385240135742248e-01,  -8.204971188739453e-03,   4.893518945227249e-05,   1.172932365978009e-07,  -5.191634490639540e-09,
   3.387317661074886e-11,   2.874178776501946e-13,  -7.069063503343469e-15,   3.156343784853340e-17,   6.597626591136612e-19,  -1.147338025388432e-20,   1.990666413145598e-23,
   1.489577304267952e-24,  -1.977869985998093e-26,   6.385249169585328e-01,  -8.204964677450568e-03,   4.893461404197183e-05,   1.172994902014163e-07,  -5.191554800352945e-09,
   3.387043466446815e-11,   2.874341853407047e-13,  -7.068624605567536e-15,   3.155390300438486e-17,   6.597828092200431e-19,  -1.147156391654113e-20,   1.987818716226057e-23,
   1.489528069708917e-24,  -1.977167859764420e-26,   6.385250603128556e-01,  -8.204963644188096e-03,   4.893452273255263e-05,   1.173004825466689e-07,  -5.191542154463720e-09,
   3.386999956057498e-11,   2.874367729955195e-13,  -7.068554958125948e-15,   3.155239000220844e-17,   6.597860058782091e-19,  -1.147127569066519e-20,   1.987366856949247e-23,
   1.489520253929008e-24,  -1.977056443175781e-26,   8.733869988781980e-01,  -9.764335115746680e-03,   2.877089070797078e-05,   5.207548178128605e-07,  -5.333358658143378e-09,
  -3.303734789392937e-11,   8.912880825698050e-13,  -5.687556278480275e-16,  -1.324302557228975e-16,   9.132080727978400e-19,   1.582376913984413e-20,  -2.606830057519905e-22,
  -1.089691806582246e-24,   5.237630713077747e-26,   8.733896901358911e-01,  -9.764188762869917e-03,   2.876789774912459e-05,   5.207238364002725e-07,  -5.332109379382630e-09,
  -3.303841923283251e-11,   8.909418273446595e-13,  -5.657081542274541e-16,  -1.323637184587527e-16,   9.118786309994911e-19,   1.581696364194568e-20,  -2.603044518809029e-22,
  -1.091063385671600e-24,   5.229553868204974e-26,   8.733944386752197e-01,  -9.763930527998248e-03,   2.876261719642600e-05,   5.206691684078642e-07,  -5.329905402651337e-09,
  -3.304030476644205e-11,   8.903309964098556e-13,  -5.603344760436029e-16,  -1.322463358046411e-16,   9.095343923645299e-19,   1.580494841757555e-20,  -2.596369661509484e-22,
  -1.093475991827055e-24,   5.215314271984726e-26,   8.734001802723326e-01,  -9.763618279707382e-03,   2.875623286791586e-05,   5.206030619215218e-07,  -5.327241004339563e-09,
  -3.304257648984180e-11,   8.895926149609663e-13,  -5.538427653222108e-16,  -1.321044353517776e-16,   9.067024105973508e-19,   1.579040788357317e-20,  -2.588306507164147e-22,
  -1.096380452867412e-24,   5.198116263702501e-26,   8.734057537098011e-01,  -9.763315167116654e-03,   2.875003609026585e-05,   5.205388854618291e-07,  -5.324655158139081e-09,
  -3.304477316975847e-11,   8.888760602445856e-13,  -5.475472119946342e-16,  -1.319667226585431e-16,   9.039559938624124e-19,   1.577628007444542e-20,  -2.580487469436904e-22,
  -1.099186574671203e-24,   5.181442363244492e-26,   8.734102433079477e-01,  -9.763070992615541e-03,   2.874504477602556e-05,   5.204871847202599e-07,  -5.322572539498404e-09,
  -3.304653657820052e-11,   8.882989944786273e-13,  -5.424802413981630e-16,  -1.318558130747729e-16,   9.017455370793321e-19,   1.576489024140249e-20,  -2.574194663713236e-22,
  -1.101437504859611e-24,   5.168025575080042e-26,   8.734132098121502e-01,  -9.762909650891117e-03,   2.874174696150655e-05,   5.204530212926274e-07,  -5.321196629632941e-09,
  -3.304769876876349e-11,   8.879177685038880e-13,  -5.391343508750442e-16,  -1.317825406779329e-16,   9.002858955659972e-19,   1.575735981494384e-20,  -2.570039479322061e-22,
  -1.102920161960070e-24,   5.159167581414560e-26,   8.734147332100033e-01,  -9.762826795567617e-03,   2.874005348635666e-05,   5.204354765838704e-07,  -5.320490110594121e-09,
  -3.304829466990475e-11,   8.877220181854653e-13,  -5.374167788315043e-16,  -1.317449163374499e-16,   8.995366055439175e-19,   1.575349127519361e-20,  -2.567906517477138e-22,
  -1.103680119468134e-24,   5.154620921667146e-26,   8.734152634355727e-01,  -9.762797957231919e-03,   2.873946407439739e-05,   5.204293699628171e-07,  -5.320244212352599e-09,
  -3.304850192924014e-11,   8.876538898660398e-13,  -5.368190740245871e-16,  -1.317318215642733e-16,   8.992758569541488e-19,   1.575214458685616e-20,  -2.567164267667264e-22,
  -1.103944397640513e-24,   5.153038788190635e-26,   8.734153475747357e-01,  -9.762793380995581e-03,   2.873937054367130e-05,   5.204284009249949e-07,  -5.320205192266448e-09,
  -3.304853481134488e-11,   8.876430790475520e-13,  -5.367242318139712e-16,  -1.317297436384437e-16,   8.992344820541015e-19,   1.575193087610967e-20,  -2.567046489827190e-22,
  -1.103986323934991e-24,   5.152787743107872e-26,   1.129035284052481e+00,  -1.033514802305908e-02,  -8.738244239209125e-06,   7.529592758978624e-07,   6.637206477958496e-10,
  -9.994454005662189e-11,  -2.193919911483531e-14,   1.608561754803460e-14,  -1.280604512479551e-17,  -2.874481490196880e-18,   5.377370506002562e-21,   5.391468604040214e-22,
  -1.767862881337997e-24,  -1.070433317626043e-25,   1.129034465592794e+00,  -1.033493658272137e-02,  -8.737871073647005e-06,   7.528658428982270e-07,   6.636894044791077e-10,
  -9.991302457311780e-11,  -2.197235456358820e-14,   1.607598776117854e-14,  -1.278370429298829e-17,  -2.871731458288790e-18,   5.366615091700064e-21,   5.383756209802595e-22,
  -1.763896589416986e-24,  -1.068341041048687e-25,   1.129033021436199e+00,  -1.033456351423166e-02,  -8.737212631512145e-06,   7.527010028717382e-07,   6.636342374289156e-10,
  -9.985743038407573e-11,  -2.203081040578258e-14,   1.605900337432442e-14,  -1.274432027203815e-17,  -2.866882204954576e-18,   5.347656852665066e-21,   5.370159953779828e-22,
  -1.756906452783353e-24,  -1.064653166171495e-25,   1.129031275195037e+00,  -1.033411243216360e-02,  -8.736416460761273e-06,   7.525017174153787e-07,   6.635674645529398e-10,
  -9.979023150818758e-11,  -2.210141495013878e-14,   1.603847849450205e-14,  -1.269675927128257e-17,  -2.861023924928928e-18,   5.324766179224711e-21,   5.353740316925397e-22,
  -1.748468288089543e-24,  -1.060200527682919e-25,   1.129029580025050e+00,  -1.033367456754582e-02,  -8.735643577663499e-06,   7.523082973270768e-07,   6.635025753247134e-10,
  -9.972502344061223e-11,  -2.216987198633385e-14,   1.601856671606818e-14,  -1.265065334696440e-17,  -2.855342551503894e-18,   5.302579701034633e-21,   5.337822494062799e-22,
  -1.740291698949248e-24,  -1.055885073373926e-25,   1.129028214454483e+00,  -1.033332185676005e-02,  -8.735020971504796e-06,   7.521525112659706e-07,   6.634502532364896e-10,
  -9.967251232113844e-11,  -2.222495949307654e-14,   1.600253565597899e-14,  -1.261355788253652e-17,  -2.850769822906208e-18,   5.284731894493951e-21,   5.325015106102578e-22,
  -1.733715498733217e-24,  -1.052413673122095e-25,   1.129027312127567e+00,  -1.033308880510004e-02,  -8.734609573466558e-06,   7.520495856145311e-07,   6.634156561608685e-10,
  -9.963782352787759e-11,  -2.226133068844713e-14,   1.599194732001545e-14,  -1.258906879173405e-17,  -2.847750257342763e-18,   5.272950774495109e-21,   5.316559944075947e-22,
  -1.729375320433599e-24,  -1.050122315281112e-25,   1.129026848745021e+00,  -1.033296912604794e-02,  -8.734398303679702e-06,   7.519967330067500e-07,   6.633978816201880e-10,
  -9.962001214687963e-11,  -2.227999987286471e-14,   1.598651115683223e-14,  -1.257649955995965e-17,  -2.846200187911078e-18,   5.266904435967411e-21,   5.312220203689295e-22,
  -1.727148055560730e-24,  -1.048946360303452e-25,   1.129026687461359e+00,  -1.033292747131478e-02,  -8.734324769739960e-06,   7.519783379110893e-07,   6.633916938686936e-10,
  -9.961381320604202e-11,  -2.228649639480309e-14,   1.598461928188551e-14,  -1.257212585185265e-17,  -2.845660771043738e-18,   5.264800562062057e-21,   5.310710097666622e-22,
  -1.726373094079982e-24,  -1.048537180448954e-25,   1.129026661867904e+00,  -1.033292086131349e-02,  -8.734313100937546e-06,   7.519754188978068e-07,   6.633907119026945e-10,
  -9.961282954197849e-11,  -2.228752723412291e-14,   1.598431907837280e-14,  -1.257143185816077e-17,  -2.845575177714917e-18,   5.264466735183531e-21,   5.310470482693098e-22,
  -1.726250130632721e-24,  -1.048472255034234e-25,   1.390887272820946e+00,  -9.477813820859684e-03,  -5.120027716898919e-05,   4.896563993027723e-07,   8.637209900136480e-09,
  -2.582775536283794e-11,  -1.551899631171735e-12,  -3.835269851996570e-15,   2.707007238815872e-16,   2.239248147938275e-18,  -4.311426911240990e-20,  -7.186324895856597e-22,
   5.150869072349506e-24,   1.861805430247067e-25,   1.390882482532452e+00,  -9.477676190788466e-03,  -5.119543101488195e-05,   4.896321234588001e-07,   8.635035898969410e-09,
  -2.583518754887191e-11,  -1.551192775427493e-12,  -3.827807437867020e-15,   2.705198587488482e-16,   2.235594652280014e-18,  -4.308244961228843e-20,  -7.172938855639740e-22,
   5.149781182231404e-24,   1.857653053551817e-25,   1.390874030360825e+00,  -9.477433345920624e-03,  -5.118688089182818e-05,   4.895892827212511e-07,   8.631200646322514e-09,
  -2.584828986063481e-11,  -1.549945902698101e-12,  -3.814649877203276e-15,   2.702008284624642e-16,   2.229153589773883e-18,  -4.302630924357826e-20,  -7.149343537691092e-22,
   5.147846342677814e-24,   1.850335416898530e-25,   1.390863810531630e+00,  -9.477139704789401e-03,  -5.117654368304880e-05,   4.895374696520085e-07,   8.626564392884737e-09,
  -2.586411304084390e-11,  -1.548438827768081e-12,  -3.798756631545367e-15,   2.698152396180661e-16,   2.221374509244712e-18,  -4.295843337838438e-20,  -7.120853667235547e-22,
   5.145480793933233e-24,   1.841502691340521e-25,   1.390853889954918e+00,  -9.476854652988129e-03,  -5.116651027056793e-05,   4.894871603848581e-07,   8.622065037845341e-09,
  -2.587945269225804e-11,  -1.546976473205716e-12,  -3.783345550743592e-15,   2.694411113885033e-16,   2.213832673930213e-18,  -4.289255085450193e-20,  -7.093239960569294e-22,
   5.143157300926218e-24,   1.832944602856925e-25,   1.390845898537711e+00,  -9.476625026076628e-03,  -5.115842875254253e-05,   4.894466247079792e-07,   8.618441447094132e-09,
  -2.589179492311725e-11,  -1.545798911972893e-12,  -3.770943333683041e-15,   2.691398580746703e-16,   2.207764200474604e-18,  -4.283948409861339e-20,  -7.071026042144694e-22,
   5.141266196463680e-24,   1.826062176922810e-25,   1.390840618181872e+00,  -9.476473296186987e-03,  -5.115308925044103e-05,   4.894198359388354e-07,   8.616047547649552e-09,
  -2.589994301454328e-11,  -1.545021041612640e-12,  -3.762754408146039e-15,   2.689408635604796e-16,   2.203757750297511e-18,  -4.280442214854019e-20,  -7.056362804231439e-22,
   5.140007148307226e-24,   1.821520193843330e-25,   1.390837906537708e+00,  -9.476395376705809e-03,  -5.115034735266972e-05,   4.894060775372129e-07,   8.614818321822917e-09,
  -2.590412515090753e-11,  -1.544621642520684e-12,  -3.758550931580268e-15,   2.688386914800194e-16,   2.201701324885348e-18,  -4.278641728207823e-20,  -7.048837266020160e-22,
   5.139357652497458e-24,   1.819189461260402e-25,   1.390836962736462e+00,  -9.476368256288312e-03,  -5.114939304061275e-05,   4.894012886265437e-07,   8.614390503363446e-09,
  -2.590558041592586e-11,  -1.544482639877742e-12,  -3.757088180018818e-15,   2.688031329146448e-16,   2.200985738831736e-18,  -4.278015070249062e-20,  -7.046218687257958e-22,
   5.139131126017662e-24,   1.818378513801851e-25,   1.390836812968741e+00,  -9.476363952659706e-03,  -5.114924160588362e-05,   4.894005286841631e-07,   8.614322615645442e-09,
  -2.590581132907582e-11,  -1.544460582636102e-12,  -3.756856076061911e-15,   2.687974904196864e-16,   2.200872193327736e-18,  -4.277915629112300e-20,  -7.045803190648815e-22,
   5.139095157389625e-24,   1.818249841153832e-25,   1.637604513208039e+00,  -7.067603232694243e-03,  -7.403717064768330e-05,  -2.178847817013329e-07,   6.819279359097267e-09,
   1.148059396340802e-10,   2.328042623021356e-13,  -1.867239138640539e-14,  -2.876844781911583e-16,   1.239660911878634e-19,   6.377204214401844e-20,   8.236131664428828e-22,
  -3.524448473173979e-24,  -2.424249649324262e-25,   1.637597579940762e+00,  -7.067664134715987e-03,  -7.403333301742675e-05,  -2.177774603417000e-07,   6.819597882995058e-09,
   1.147691870618106e-10,   2.320546309403910e-13,  -1.867186435127883e-14,  -2.874161773481663e-16,   1.281444555688397e-19,   6.374927182654967e-20,   8.218536124412578e-22,
  -3.545334729962402e-24,  -2.421873230907450e-25,   1.637585346374106e+00,  -7.067771572807007e-03,  -7.402656131478244e-05,  -2.175881181211409e-07,   6.820159068567522e-09,
   1.147043374658659e-10,   2.307324667301716e-13,  -1.867092297477069e-14,  -2.869428352250250e-16,   1.355098827791458e-19,   6.370898898734701e-20,   8.187502748907540e-22,
  -3.582115366974525e-24,  -2.417672264734575e-25,   1.637570553913386e+00,  -7.067901446350985e-03,  -7.401837265486490e-05,  -2.173592112385151e-07,   6.820836203004610e-09,
   1.146259221817874e-10,   2.291346670372557e-13,  -1.866976520298153e-14,  -2.863705997069434e-16,   1.444036865320272e-19,   6.366010103567233e-20,   8.150001157102607e-22,
  -3.626465671658712e-24,  -2.412579248839427e-25,   1.637556194170910e+00,  -7.068027481631472e-03,  -7.401042298962598e-05,  -2.171370424055918e-07,   6.821492028049571e-09,
   1.145497996101803e-10,   2.275845720306882e-13,  -1.866862090872657e-14,  -2.858152248795979e-16,   1.530245007625445e-19,   6.361245589187983e-20,   8.113620744796592e-22,
  -3.669389130889431e-24,  -2.407621294186111e-25,   1.637544626523366e+00,  -7.068128982701823e-03,  -7.400401865955111e-05,  -2.169581019118590e-07,   6.822019259675105e-09,
   1.144884774346527e-10,   2.263365672881947e-13,  -1.866768451227395e-14,  -2.853679237498690e-16,   1.599599080386774e-19,   6.357394085299324e-20,   8.084331444871410e-22,
  -3.703873882831947e-24,  -2.403617412390376e-25,   1.637536983011186e+00,  -7.068196037471066e-03,  -7.399978670275242e-05,  -2.168398787638728e-07,   6.822367110185481e-09,
   1.144479574148813e-10,   2.255122661729556e-13,  -1.866705863037106e-14,  -2.850724049702649e-16,   1.645380964312821e-19,   6.354842590461497e-20,   8.064986562399199e-22,
  -3.726614878850474e-24,  -2.400966923086938e-25,   1.637533057758623e+00,  -7.068230468562962e-03,  -7.399761336276350e-05,  -2.167791709457709e-07,   6.822545582723149e-09,
   1.144271486266836e-10,   2.250890588722657e-13,  -1.866673500679445e-14,  -2.849206573686975e-16,   1.668877913516200e-19,   6.353530270736970e-20,   8.055054814589203e-22,
  -3.738279274983149e-24,  -2.399604289417914e-25,   1.637531691547544e+00,  -7.068242451865133e-03,  -7.399685690747247e-05,  -2.167580418974243e-07,   6.822607675404468e-09,
   1.144199059662543e-10,   2.249417753285154e-13,  -1.866662201597614e-14,  -2.848678426847467e-16,   1.677053975316385e-19,   6.353073186807563e-20,   8.051598420802555e-22,
  -3.742336915778870e-24,  -2.399129776798946e-25,   1.637531474749090e+00,  -7.068244353414324e-03,  -7.399673686822678e-05,  -2.167546890494480e-07,   6.822617527408413e-09,
   1.144187566571638e-10,   2.249184042956193e-13,  -1.866660406924394e-14,  -2.848594618385236e-16,   1.678351296126704e-19,   6.353000638741079e-20,   8.051049959697942e-22,
  -3.742980700254079e-24,  -2.399054467006295e-25,   1.840685593090049e+00,  -3.688003427013359e-03,  -5.664717846554147e-05,  -6.281295947463954e-07,  -3.964236673263156e-09,
   2.223503611948487e-11,   1.098376191849099e-12,   1.732579625458535e-14,   1.294859873401066e-16,  -9.460646314567135e-19,  -4.734752344783453e-20,  -7.838677748834966e-22,
  -5.936388822032591e-24,   5.244884755558971e-26,   1.840680277968890e+00,  -3.688180013620168e-03,  -5.664939960109988e-05,  -6.281084631471842e-07,  -3.962688120725596e-09,
   2.226909352239013e-11,   1.098711939461692e-12,   1.732249840963732e-14,   1.292850963190301e-16,  -9.500905248668572e-19,  -4.738325977015004e-20,  -7.834621452043665e-22,
  -5.914947414884168e-24,   5.284984175460207e-26,   1.840670899185600e+00,  -3.688491598588931e-03,  -5.665331812068682e-05,  -6.280711501654622e-07,  -3.959955293150247e-09,
   2.232918301631787e-11,   1.099303941995119e-12,   1.731666827544488e-14,   1.289304992520436e-16,  -9.571925541906603e-19,  -4.744620897339896e-20,  -7.827440261420031e-22,
  -5.877091915827265e-24,   5.355704433268068e-26,   1.840659557973553e+00,  -3.688868362142661e-03,  -5.665805522733433e-05,  -6.280259866780107e-07,  -3.956650077395823e-09,
   2.240183477546035e-11,   1.100019065425612e-12,   1.730959960272624e-14,   1.285015094356197e-16,  -9.657774593658221e-19,  -4.752214342902936e-20,  -7.818716137857831e-22,
  -5.831279559128975e-24,   5.441158896430400e-26,   1.840648547820629e+00,  -3.689234108961459e-03,  -5.666265266215438e-05,  -6.279820964311870e-07,  -3.953440749390619e-09,
   2.247235430189309e-11,   1.100712527729133e-12,   1.730271776187027e-14,   1.280848368374832e-16,  -9.741084444812132e-19,  -4.759566609400034e-20,  -7.810204463786122e-22,
  -5.786766993408122e-24,   5.524052253746778e-26,   1.840639677969277e+00,  -3.689528743592794e-03,  -5.666635538844243e-05,  -6.279467058371055e-07,  -3.950854868305861e-09,
   2.252915706640438e-11,   1.101270622127849e-12,   1.729715973138679e-14,   1.277490157677410e-16,  -9.808175560489994e-19,  -4.765475650985135e-20,  -7.803317170776541e-22,
  -5.750880582011736e-24,   5.590783785152337e-26,   1.840633816824092e+00,  -3.689723429847085e-03,  -5.666880163967436e-05,  -6.279233041172183e-07,  -3.949145925247153e-09,
   2.256668796349948e-11,   1.101639131696404e-12,   1.729348017691254e-14,   1.275270353663448e-16,  -9.852497271757000e-19,  -4.769373457016597e-20,  -7.798751291436439e-22,
  -5.727153965285316e-24,   5.634856064913872e-26,   1.840630806812993e+00,  -3.689823409606991e-03,  -5.667005776930611e-05,  -6.279112811903854e-07,  -3.948268227359450e-09,
   2.258596083558330e-11,   1.101828295705114e-12,   1.729158841384788e-14,   1.274130143802275e-16,  -9.875255214145291e-19,  -4.771373068519707e-20,  -7.796401893664618e-22,
  -5.714965039237014e-24,   5.657482246232778e-26,   1.840629759145876e+00,  -3.689858208327211e-03,  -5.667049495484872e-05,  -6.279070957007999e-07,  -3.947962724816087e-09,
   2.259266876965662e-11,   1.101894122709995e-12,   1.729092962839227e-14,   1.273733246037216e-16,  -9.883175786301860e-19,  -4.772068717496561e-20,  -7.795583431989534e-22,
  -5.710721908136585e-24,   5.665356373284392e-26,   1.840629592895287e+00,  -3.689863730397694e-03,  -5.667056432913463e-05,  -6.279064314832776e-07,  -3.947914245211867e-09,
   2.259373321854990e-11,   1.101904567919532e-12,   1.729082507207311e-14,   1.273670262058566e-16,  -9.884432646464162e-19,  -4.772179091545809e-20,  -7.795453518632773e-22,
  -5.710048550169172e-24,   5.666605835485536e-26,   1.968311795065862e+00,  -8.130117713867388e-04,  -1.530383302431916e-05,  -2.484809933744703e-07,  -3.633122710776151e-09,
  -4.826810585520259e-11,  -5.755982493116738e-13,  -5.896239083567649e-15,  -4.484861389719745e-17,  -5.714992432970533e-20,   6.789952724449751e-21,   1.812323288572227e-22,
   3.279777025580591e-24,   4.793492821958349e-26,   1.968310356222564e+00,  -8.130818162842172e-04,  -1.530588122937642e-05,  -2.485263422584318e-07,  -3.633933528329994e-09,
  -4.827971667139268e-11,  -5.757153694246780e-13,  -5.896407191045216e-15,  -4.481930793707480e-17,  -5.620168956013721e-20,   6.810472418831224e-21,   1.815854933357551e-22,
   3.284655851777266e-24,   4.798290213842523e-26,   1.968307817204231e+00,  -8.132054219959474e-04,  -1.530949569060086e-05,  -2.486063699292516e-07,  -3.635364362342936e-09,
  -4.830020439636742e-11,  -5.759219667653281e-13,  -5.896701207362494e-15,  -4.476752653009416e-17,  -5.452703118239870e-20,   6.846704292520802e-21,   1.822089417868992e-22,
   3.293265245236948e-24,   4.806747553561349e-26,   1.968304746728933e+00,  -8.133549050573979e-04,  -1.531386696866595e-05,  -2.487031553368122e-07,  -3.637094770011577e-09,
  -4.832497880790106e-11,  -5.761716790536446e-13,  -5.897052278615380e-15,  -4.470479149822423e-17,  -5.249948656896130e-20,   6.890558123441058e-21,   1.829633065366955e-22,
   3.303676873918354e-24,   4.816961042206483e-26,   1.968301765684828e+00,  -8.135000391777806e-04,  -1.531811119260048e-05,  -2.487971287404768e-07,  -3.638774858406539e-09,
  -4.834902983025679e-11,  -5.764139827959492e-13,  -5.897388422229194e-15,  -4.464376325854437e-17,  -5.052853112354294e-20,   6.933174503657064e-21,   1.836961374443774e-22,
   3.313785394941759e-24,   4.826862240944269e-26,   1.968299363993944e+00,  -8.136169706314075e-04,  -1.532153075918071e-05,  -2.488728438170172e-07,  -3.640128486668938e-09,
  -4.836840534271810e-11,  -5.766090987515041e-13,  -5.897655866400170e-15,  -4.459450925954407e-17,  -4.893885543371185e-20,   6.967537118614610e-21,   1.842868592322770e-22,
   3.321929459285034e-24,   4.834828546207728e-26,   1.968297776901204e+00,  -8.136942433623484e-04,  -1.532379058043446e-05,  -2.489228805356750e-07,  -3.641023023770134e-09,
  -4.838120849262377e-11,  -5.767379883054567e-13,  -5.897830948091087e-15,  -4.456191879029125e-17,  -4.788749565964808e-20,   6.990258703942341e-21,   1.846773751572488e-22,
   3.327311285011126e-24,   4.840087645405355e-26,   1.968296961822777e+00,  -8.137339286202651e-04,  -1.532495117870595e-05,  -2.489485784996956e-07,  -3.641482437242245e-09,
  -4.838778357086458e-11,  -5.768041670058476e-13,  -5.897920353313378e-15,  -4.454516831900054e-17,  -4.734728431304229e-20,   7.001932082227494e-21,   1.848779786362071e-22,
   3.330075224444845e-24,   4.842786928803834e-26,   1.968296678122431e+00,  -8.137477417582256e-04,  -1.532535514701430e-05,  -2.489575231844104e-07,  -3.641642344426371e-09,
  -4.839007209470571e-11,  -5.768271991572046e-13,  -5.897951390789352e-15,  -4.453933598167099e-17,  -4.715921298349315e-20,   7.005995865780903e-21,   1.849478092466673e-22,
   3.331037257004478e-24,   4.843726197602963e-26,   1.968296633102864e+00,  -8.137499337281983e-04,  -1.532541925176493e-05,  -2.489589425956468e-07,  -3.641667719689699e-09,
  -4.839043525228383e-11,  -5.768308539497690e-13,  -5.897956312171661e-15,  -4.453841036644735e-17,  -4.712936647816253e-20,   7.006640768217132e-21,   1.849588908173416e-22,
   3.331189919181223e-24,   4.843875235156202e-26,   5.133066129035467e-03,  -8.266554367492024e-05,   9.961457329219453e-07,  -1.064764110643157e-08,   1.062729163964347e-10,
  -1.015203332531091e-12,   9.367162164071840e-15,  -8.444907736662208e-17,   7.398483843517049e-19,  -6.442806012544463e-21,   5.318834573373416e-23,  -4.672353388208283e-25,
   3.454045999933434e-27,  -2.685071560977174e-29,   5.133159637667894e-03,  -8.266854167573381e-05,   9.962055858172611e-07,  -1.064859425881587e-08,   1.062861119717580e-10,
  -1.015369938343434e-12,   9.369108912961751e-15,  -8.447088482294558e-17,   7.400734659520041e-19,  -6.445222729628407e-21,   5.320989342417526e-23,  -4.674294590046370e-25,
   3.457830456333653e-27,  -2.681031061379108e-29,   5.133324639694186e-03,  -8.267383191360211e-05,   9.963112032341898e-07,  -1.065027623831054e-08,   1.063093979998795e-10,
  -1.015663951860862e-12,   9.372544462831340e-15,  -8.450937106001473e-17,   7.404707000431253e-19,  -6.449487876491512e-21,   5.324793377631096e-23,  -4.677717476352513e-25,
   3.464515006808012e-27,  -2.673906828178952e-29,   5.133524169705588e-03,  -8.268022929794385e-05,   9.964389272452819e-07,  -1.065231032265174e-08,   1.063375595129764e-10,
  -1.016019535731412e-12,   9.376699586401009e-15,  -8.455592034779387e-17,   7.409511660849419e-19,  -6.454646720723032e-21,   5.329396518980190e-23,  -4.681852385780311e-25,
   3.472609638252098e-27,  -2.665301208575019e-29,   5.133717878153457e-03,  -8.268644015770151e-05,   9.965629302934795e-07,  -1.065428520353795e-08,   1.063649022012714e-10,
  -1.016364792802776e-12,   9.380734167230378e-15,  -8.460112144538965e-17,   7.414177265553275e-19,  -6.459656284869534e-21,   5.333868587125080e-23,  -4.685862213232091e-25,
   3.480479886033512e-27,  -2.656956601357423e-29,   5.133873933011700e-03,  -8.269144382484689e-05,   9.966628332675467e-07,  -1.065587630457197e-08,   1.063869319665671e-10,
  -1.016642972129180e-12,   9.383984988499843e-15,  -8.463754335709121e-17,   7.417936764746382e-19,  -6.463692961087978e-21,   5.337473678292451e-23,  -4.689089419887914e-25,
   3.486828718309183e-27,  -2.650241208237316e-29,   5.133977054147307e-03,  -8.269475029571709e-05,   9.967288511586936e-07,  -1.065692775544740e-08,   1.064014902391839e-10,
  -1.016826809971079e-12,   9.386133374649845e-15,  -8.466161446759170e-17,   7.420421439521800e-19,  -6.466360832066545e-21,   5.339857059344124e-23,  -4.691220403992017e-25,
   3.491028146859224e-27,  -2.645807201649089e-29,   5.134030012670753e-03,  -8.269644836901293e-05,   9.967627556754218e-07,  -1.065746775041799e-08,   1.064089670405638e-10,
  -1.016921226272123e-12,   9.387236766943171e-15,  -8.467397742125573e-17,   7.421697582648368e-19,  -6.467731068283947e-21,   5.341081411164364e-23,  -4.692314303640296e-25,
   3.493186061755250e-27,  -2.643531184629739e-29,   5.134048445510895e-03,  -8.269703940570763e-05,   9.967745566393523e-07,  -1.065765570453483e-08,   1.064115694785008e-10,
  -1.016954089808647e-12,   9.387620827575140e-15,  -8.467828066534377e-17,   7.422141778837177e-19,  -6.468208016508412e-21,   5.341507617204411e-23,  -4.692694971790957e-25,
   3.493937351777734e-27,  -2.642739164806703e-29,   5.134051370555462e-03,  -8.269713319541085e-05,   9.967764292986514e-07,  -1.065768553045083e-08,   1.064119824528237e-10,
  -1.016959304850481e-12,   9.387681773412566e-15,  -8.467896354064031e-17,   7.422212267741353e-19,  -6.468283702807866e-21,   5.341575253042794e-23,  -4.692755375088218e-25,
   3.494056581027710e-27,  -2.642613490187255e-29,   4.614453601802471e-02,  -7.341858969034748e-04,   8.607138217956153e-06,  -8.755685733294515e-08,   8.066625564976991e-10,
  -6.818310548420668e-12,   5.224861626714967e-14,  -3.541146830386249e-16,   1.877151489933065e-18,  -5.114534363280378e-21,  -7.339060911477547e-23,   1.246097154096246e-24,
  -1.989841964957594e-26,   2.066869619724409e-28,   4.614534384736462e-02,  -7.342105447585256e-04,   8.607592379852808e-06,  -8.756325535067257e-08,   8.067360891557993e-10,
  -6.819007981829427e-12,   5.225353729199706e-14,  -3.541317752521738e-16,   1.876837919803748e-18,  -5.108048780593648e-21,  -7.351360627057685e-23,   1.247644108316926e-24,
  -1.989581179678760e-26,   2.073319181530768e-28,   4.614676930963035e-02,  -7.342540377511467e-04,   8.608393789317580e-06,  -8.757454528543597e-08,   8.068658443133558e-10,
  -6.820238641343881e-12,   5.226221984628860e-14,  -3.541619168920662e-16,   1.876284198617566e-18,  -5.096598346418518e-21,  -7.373062304375937e-23,   1.250377562663492e-24,
  -1.989116234540429e-26,   2.084695804714157e-28,   4.614849305297852e-02,  -7.343066324399341e-04,   8.609362919588765e-06,  -8.758819810201271e-08,   8.070227552277601e-10,
  -6.821726814494999e-12,   5.227271773818337e-14,  -3.541983340544271e-16,   1.875613913939756e-18,  -5.082741228391935e-21,  -7.399301861827171e-23,   1.253689412563150e-24,
  -1.988545879520668e-26,   2.098446127086178e-28,   4.615016649512250e-02,  -7.343576930687678e-04,   8.610303794574384e-06,  -8.760145296966152e-08,   8.071750916708185e-10,
  -6.823171555917345e-12,   5.228290770954959e-14,  -3.542336553228821e-16,   1.874962460181227e-18,  -5.069277308119672e-21,  -7.424772295973908e-23,   1.256911332861017e-24,
  -1.987983693265923e-26,   2.111787921459517e-28,   4.615151464273293e-02,  -7.343988287213320e-04,   8.611061794286160e-06,  -8.761213159910111e-08,   8.072978191239729e-10,
  -6.824335455686219e-12,   5.229111575735610e-14,  -3.542620868227181e-16,   1.874437118015775e-18,  -5.058422577669846e-21,  -7.445289159212515e-23,   1.259511764889934e-24,
  -1.987524735362639e-26,   2.122530992758940e-28,   4.615240549638872e-02,  -7.344260113453351e-04,   8.611562688075998e-06,  -8.761918818036752e-08,   8.073789187617325e-10,
  -6.825104556984310e-12,   5.229653906752504e-14,  -3.542808626565794e-16,   1.874089717135108e-18,  -5.051245862323523e-21,  -7.458845455943403e-23,   1.261232480165217e-24,
  -1.987218500791558e-26,   2.129627402658745e-28,   4.615286299908748e-02,  -7.344399712071827e-04,   8.611819927524401e-06,  -8.762281217552861e-08,   8.074205683956861e-10,
  -6.825499532577013e-12,   5.229932406636117e-14,  -3.542905014826256e-16,   1.873911228476328e-18,  -5.047559005910244e-21,  -7.465806989244948e-23,   1.262116890689915e-24,
  -1.987060319874066e-26,   2.133270996223084e-28,   4.615302223816143e-02,  -7.344448301101182e-04,   8.611909463108219e-06,  -8.762407355663550e-08,   8.074350651056440e-10,
  -6.825637008288939e-12,   5.230029338994122e-14,  -3.542938558128962e-16,   1.873849090860110e-18,  -5.046275559560429e-21,  -7.468229970974833e-23,   1.262424835813124e-24,
  -1.987005118063333e-26,   2.134539062181022e-28,   4.615304750726019e-02,  -7.344456011532409e-04,   8.611923671221548e-06,  -8.762427372122387e-08,   8.074373655420961e-10,
  -6.825658823830940e-12,   5.230044720725756e-14,  -3.542943880727348e-16,   1.873839229858854e-18,  -5.046071884699442e-21,  -7.468614462729250e-23,   1.262473708061903e-24,
  -1.986996351392097e-26,   2.134740281073401e-28,   1.278637719888876e-01,  -1.983662594830217e-03,   2.191821957905577e-05,  -1.988884278234274e-07,   1.482139944054097e-09,
  -8.136747478950575e-12,   1.259802119720033e-14,   4.310910190147276e-16,  -7.763566813449879e-18,   8.259877467954074e-20,  -6.773678373937838e-22,   2.483524651246908e-24,
   6.910336885104360e-27,  -4.207659455804806e-28,   1.278658284917537e-01,  -1.983718558932981e-03,   2.191905337964330e-05,  -1.988960488317562e-07,   1.482157418192950e-09,
  -8.135894329975470e-12,   1.257758289283712e-14,   4.313701196185560e-16,  -7.766422898298277e-18,   8.261146272901450e-20,  -6.773202282053062e-22,   2.480494913165244e-24,
   7.014765040981958e-27,  -4.199106066394343e-28,   1.278694572870313e-01,  -1.983817310215560e-03,   2.192052464185351e-05,  -1.989094955694160e-07,   1.482188228196274e-09,
  -8.134388488273402e-12,   1.254151308840008e-14,   4.318626317604568e-16,  -7.771462337452899e-18,   8.263383833963328e-20,  -6.772356936577370e-22,   2.475153962336111e-24,
   7.199217060614862e-27,  -4.184024734413602e-28,   1.278738453735279e-01,  -1.983936724293168e-03,   2.192230372139708e-05,  -1.989257543972963e-07,   1.482225444095539e-09,
  -8.132566846334219e-12,   1.249788670348787e-14,   4.324582419083503e-16,  -7.777555794294819e-18,   8.266087360840461e-20,  -6.771325737031894e-22,   2.468704267062392e-24,
   7.422576458463006e-27,  -4.165807565329125e-28,   1.278781053655362e-01,  -1.984052652524369e-03,   2.192403083521200e-05,  -1.989415370222689e-07,   1.482261530872075e-09,
  -8.130797629797734e-12,   1.245552408210265e-14,   4.330365118972051e-16,  -7.783470914770807e-18,   8.268709642186354e-20,  -6.770315234786743e-22,   2.462452055753268e-24,
   7.639742147769760e-27,  -4.148143085828291e-28,   1.278815372410909e-01,  -1.984146045029306e-03,   2.192542218580192e-05,  -1.989542504657133e-07,   1.482290571974558e-09,
  -8.129371800111346e-12,   1.242138950845661e-14,   4.335024030583036e-16,  -7.788235841441062e-18,   8.270820503007788e-20,  -6.769494423884393e-22,   2.457421829362687e-24,
   7.814925495670025e-27,  -4.133927578799275e-28,   1.278838050031730e-01,  -1.984207758224426e-03,   2.192634157045828e-05,  -1.989626508742337e-07,   1.482309747158830e-09,
  -8.128429357246656e-12,   1.239883017286027e-14,   4.338102773582188e-16,  -7.791384313174414e-18,   8.272214532049859e-20,  -6.768948732790142e-22,   2.454101113353327e-24,
   7.930799585929718e-27,  -4.124541507295056e-28,   1.278849696198354e-01,  -1.984239451240564e-03,   2.192681372000753e-05,  -1.989669647596264e-07,   1.482319589999683e-09,
  -8.127945281143326e-12,   1.238724369405469e-14,   4.339683922578194e-16,  -7.793001170894121e-18,   8.272930188405050e-20,  -6.768667468964509e-22,   2.452396746148247e-24,
   7.990342318052414e-27,  -4.119723573558818e-28,   1.278853749772921e-01,  -1.984250482338808e-03,   2.192697805622664e-05,  -1.989684662268296e-07,   1.482323015168764e-09,
  -8.127776780235735e-12,   1.238321072605686e-14,   4.340234266655276e-16,  -7.793563927741836e-18,   8.273179240276764e-20,  -6.768569409235179e-22,   2.451803681416142e-24,
   8.011072413076750e-27,  -4.118047008862955e-28,   1.278854393020310e-01,  -1.984252232824728e-03,   2.192700413413295e-05,  -1.989687044880413e-07,   1.482323558661658e-09,
  -8.127750040807825e-12,   1.238257074065630e-14,   4.340321599188265e-16,  -7.793653229251922e-18,   8.273218759533413e-20,  -6.768553840754357e-22,   2.451709577610529e-24,
   8.014362264254662e-27,  -4.117780978305782e-28,   2.495778350599142e-01,  -3.717805202769591e-03,   3.712621822618523e-05,  -2.684266587301729e-07,   1.046662441903191e-09,
   6.094341321858825e-12,  -1.718861803590963e-13,   1.883685422321250e-15,  -1.133291763131838e-17,  -2.297627607324312e-20,   1.408857238079392e-21,  -2.096345312761809e-23,
   1.399590618839661e-25,  -4.504170739591730e-29,   2.495813168151474e-01,  -3.717880677378125e-03,   3.712680560609258e-05,  -2.684209141283138e-07,   1.046420377280314e-09,
   6.098048535673294e-12,  -1.719158057986516e-13,   1.883605059820615e-15,  -1.132694623398604e-17,  -2.308436792408796e-20,   1.409721834978985e-21,  -2.096348109428807e-23,
   1.399286735686374e-25,  -3.957768822324284e-29,   2.495874604717297e-01,  -3.718013852195275e-03,   3.712784193641313e-05,  -2.684107748626015e-07,   1.045993216616938e-09,
   6.104589842851824e-12,  -1.719680675929749e-13,   1.883462962331636e-15,  -1.131640664507054e-17,  -2.327509750673084e-20,   1.411247278601318e-21,  -2.096349797580298e-23,
   1.398752015215572e-25,  -2.993765114181994e-29,   2.495948895231222e-01,  -3.718174886361148e-03,   3.712909488923300e-05,  -2.683985095367621e-07,   1.045476631708778e-09,
   6.112499439537924e-12,  -1.720312413521654e-13,   1.883290630815732e-15,  -1.130365700737587e-17,  -2.350572934111794e-20,   1.413091604010270e-21,  -2.096346303726967e-23,
   1.398107948015364e-25,  -1.828308395324499e-29,   2.496021015974181e-01,  -3.718331213189405e-03,   3.713031103633896e-05,  -2.683865975260948e-07,   1.044975079643276e-09,
   6.120177706357602e-12,  -1.720925465507262e-13,   1.883122804785365e-15,  -1.129127458757118e-17,  -2.372962218044300e-20,   1.414881774373925e-21,  -2.096337116284168e-23,
   1.397485325626722e-25,  -6.971450638070603e-30,   2.496079116078551e-01,  -3.718457146363400e-03,   3.713129060689776e-05,  -2.683769977507910e-07,   1.044570992569446e-09,
   6.126363051216075e-12,  -1.721419168862221e-13,   1.882987226877840e-15,  -1.128129567965407e-17,  -2.390998686001491e-20,   1.416323720183009e-21,  -2.096325562935437e-23,
   1.396985620970308e-25,   2.139290702672428e-30,   2.496117507872429e-01,  -3.718540359935756e-03,   3.713193782027198e-05,  -2.683706526205914e-07,   1.044303957855709e-09,
   6.130450135006484e-12,  -1.721745319246916e-13,   1.882897453628198e-15,  -1.127469993875262e-17,  -2.402916835828186e-20,   1.417276438383517e-21,  -2.096315895936883e-23,
   1.396656337373018e-25,   8.158630671141094e-30,   2.496137223982130e-01,  -3.718583093831427e-03,   3.713227017384408e-05,  -2.683673935453419e-07,   1.044166816205608e-09,
   6.132549022737924e-12,  -1.721912788331940e-13,   1.882851293313797e-15,  -1.127131213614872e-17,  -2.409037366989424e-20,   1.417765675763651e-21,  -2.096310302868404e-23,
   1.396487515751128e-25,   1.124957636755182e-29,   2.496144086368447e-01,  -3.718597967714503e-03,   3.713238584913134e-05,  -2.683662591072270e-07,   1.044119081756090e-09,
   6.133279555795138e-12,  -1.721971073541163e-13,   1.882835217646705e-15,  -1.127013288903972e-17,  -2.411167672407290e-20,   1.417935954700421e-21,  -2.096308256079412e-23,
   1.396428800537707e-25,   1.232536456729463e-29,   2.496145175335300e-01,  -3.718600327992971e-03,   3.713240420504410e-05,  -2.683660790833856e-07,   1.044111506906882e-09,
   6.133395481138470e-12,  -1.721980322414124e-13,   1.882832666225500e-15,  -1.126994575442595e-17,  -2.411505722465397e-20,   1.417962975403608e-21,  -2.096307926531606e-23,
   1.396419485362345e-25,   1.249607525667344e-29,   4.099238959558122e-01,  -5.751284045897040e-03,   4.868685877391223e-05,  -2.080319734525183e-07,  -1.190292372791457e-09,
   3.184427795176783e-11,  -2.788119224679726e-13,   2.157842541896580e-16,   2.744364493668136e-17,  -3.974190826191683e-19,   1.947257155203037e-21,   1.858970927601970e-23,
  -5.541745830545806e-25,   5.049437666204911e-27,   4.099284589913291e-01,  -5.751342449606875e-03,   4.868618702790515e-05,  -2.080021161287542e-07,  -1.190683597120803e-09,
   3.184468148743327e-11,  -2.787397159843323e-13,   2.144455091706358e-16,   2.745174995959359e-17,  -3.973217956642352e-19,   1.943836248695072e-21,   1.862657256833720e-23,
  -5.540029130094183e-25,   5.048349297976639e-27,   4.099365104879416e-01,  -5.751445497045553e-03,   4.868500154277884e-05,  -2.079494321094567e-07,  -1.191373835996706e-09,
   3.184539139093260e-11,  -2.786122892755568e-13,   2.120835404868405e-16,   2.746603967414732e-17,  -3.971499768290590e-19,   1.937800883072648e-21,   1.869161185870064e-23,
  -5.536987093680383e-25,   5.046421513200514e-27,   4.099462463561225e-01,  -5.751570091470292e-03,   4.868356773677543e-05,  -2.078857255169176e-07,  -1.192208339353711e-09,
   3.184624616263562e-11,  -2.784581741721414e-13,   2.092278799069751e-16,   2.748329895814550e-17,  -3.969419482879201e-19,   1.930504355500725e-21,   1.877024683288363e-23,
  -5.533286675400391e-25,   5.044077854393539e-27,   4.099556976767327e-01,  -5.751691033392676e-03,   4.868217550365715e-05,  -2.078238797233285e-07,  -1.193018313236208e-09,
   3.184707213709066e-11,  -2.783085311678788e-13,   2.064561331816071e-16,   2.750003304003191e-17,  -3.967397220071044e-19,   1.923422590337256e-21,   1.884657250539214e-23,
  -5.529671414725497e-25,   5.041789463521523e-27,   4.099633114720039e-01,  -5.751788453899584e-03,   4.868105371017319e-05,  -2.077740571730094e-07,  -1.193670711945127e-09,
   3.184773479238441e-11,  -2.781879587073942e-13,   2.042235936231666e-16,   2.751349880277255e-17,  -3.965766135710748e-19,   1.917718746663162e-21,   1.890805099315715e-23,
  -5.526742581035498e-25,   5.039936464589344e-27,   4.099683425001120e-01,  -5.751852823359166e-03,   4.868031233710891e-05,  -2.077411351320507e-07,  -1.194101753623022e-09,
   3.184817132222453e-11,  -2.781082758067251e-13,   2.027485395745772e-16,   2.752238939722551e-17,  -3.964687376916213e-19,   1.913950305333327e-21,   1.894867071889014e-23,
  -5.524799226282202e-25,   5.038707368689781e-27,   4.099709261638213e-01,  -5.751885878834262e-03,   4.867993157195852e-05,  -2.077242280309292e-07,  -1.194323098138784e-09,
   3.184839508649907e-11,  -2.780673514961669e-13,   2.019910808189543e-16,   2.752695287255587e-17,  -3.964133083524987e-19,   1.912015202983496e-21,   1.896952960158762e-23,
  -5.523798738144961e-25,   5.038074722505757e-27,   4.099718254300516e-01,  -5.751897383884560e-03,   4.867979903765145e-05,  -2.077183433503549e-07,  -1.194400136575532e-09,
   3.184847290368753e-11,  -2.780531068853393e-13,   2.017274486552026e-16,   2.752854087051200e-17,  -3.963940109012963e-19,   1.911341700395863e-21,   1.897678952114235e-23,
  -5.523450114048524e-25,   5.037854293613420e-27,   4.099719681311423e-01,  -5.751899209567598e-03,   4.867977800602065e-05,  -2.077174095321564e-07,  -1.194412361393443e-09,
   3.184848524906964e-11,  -2.780508464366338e-13,   2.016856142553426e-16,   2.752879284675969e-17,  -3.963909484354890e-19,   1.911234826117271e-21,   1.897794156062620e-23,
  -5.523394773455579e-25,   5.037819303631094e-27,   6.064459276412790e-01,  -7.809334347351498e-03,   4.989356307654900e-05,   3.958431794832099e-08,  -4.462095807201575e-09,
   3.864596558112442e-11,   1.052949244786547e-13,  -5.772949797628876e-15,   4.783803634161376e-17,   2.321573430951560e-19,  -9.417102222542523e-21,   6.843040286327167e-23,
   5.000201491226733e-25,  -1.645675222643503e-26,   6.064506001168363e-01,  -7.809323087025304e-03,   4.989105399750932e-05,   3.962045303061427e-08,  -4.461946262417993e-09,
   3.863461273590723e-11,   1.054196809826815e-13,  -5.772157209294263e-15,   4.779840955947815e-17,   2.325055556233808e-19,  -9.413952833275650e-21,   6.831120323090761e-23,
   5.012205086956313e-25,  -1.643611184765453e-26,   6.064588445824490e-01,  -7.809303209756337e-03,   4.988662675674066e-05,   3.968420530361506e-08,  -4.461682245980170e-09,
   3.861458173469203e-11,   1.056397312928507e-13,  -5.770757722633391e-15,   4.772849832866255e-17,   2.331194835952216e-19,  -9.408389664369924e-21,   6.810099650975092e-23,
   5.033370761734582e-25,  -1.639967667820865e-26,   6.064688135526667e-01,  -7.809279159891123e-03,   4.988127340703030e-05,   3.976128048811304e-08,  -4.461362751890505e-09,
   3.859036220521769e-11,   1.059056744089319e-13,  -5.769063825977022e-15,   4.764397943507626e-17,   2.338610022067551e-19,  -9.401652358207871e-21,   6.784702191994454e-23,
   5.058939168929483e-25,  -1.635559363386022e-26,   6.064784909153377e-01,  -7.809255797977344e-03,   4.987607659051164e-05,   3.983608830290336e-08,  -4.461052338602885e-09,
   3.856685258024679e-11,   1.061636965340601e-13,  -5.767417722621206e-15,   4.756194936156386e-17,   2.345799663431396e-19,  -9.395101157367365e-21,   6.760068737562918e-23,
   5.083733964373795e-25,  -1.631277233088184e-26,   6.064862866284982e-01,  -7.809236967377124e-03,   4.987189019066880e-05,   3.989634144346450e-08,  -4.460802091796057e-09,
   3.854791516306260e-11,   1.063714477345715e-13,  -5.766090427534798e-15,   4.749588091765205e-17,   2.351585176420984e-19,  -9.389815904150283e-21,   6.740240085950272e-23,
   5.103689274867491e-25,  -1.627825737638755e-26,   6.064914377772375e-01,  -7.809224519288700e-03,   4.986912393531501e-05,   3.993615022928181e-08,  -4.460636644125421e-09,
   3.853540245408208e-11,   1.065086731197394e-13,  -5.765212779721091e-15,   4.745223088590879e-17,   2.355405023389629e-19,  -9.386319739117104e-21,   6.727145374527941e-23,
   5.116866052712335e-25,  -1.625544142295305e-26,   6.064940831015885e-01,  -7.809218125002995e-03,   4.986770334415801e-05,   3.995659227065432e-08,  -4.460551651299248e-09,
   3.852897682646832e-11,   1.065791285602184e-13,  -5.764761881679474e-15,   4.742981661596946e-17,   2.357365733909083e-19,  -9.384523127476217e-21,   6.720422997978116e-23,
   5.123630070071381e-25,  -1.624372154079123e-26,   6.064950038250636e-01,  -7.809215899159113e-03,   4.986720889651851e-05,   3.996370704371081e-08,  -4.460522064385253e-09,
   3.852674036728842e-11,   1.066036486169369e-13,  -5.764604913216933e-15,   4.742201546005558e-17,   2.358048023767495e-19,  -9.383897615128702e-21,   6.718083592886182e-23,
   5.125983888274468e-25,  -1.623964188401153e-26,   6.064951499309191e-01,  -7.809215545936278e-03,   4.986713043458852e-05,   3.996483604755011e-08,  -4.460517369141438e-09,
   3.852638547388607e-11,   1.066075394885979e-13,  -5.764580003094323e-15,   4.742077754000447e-17,   2.358156286489770e-19,  -9.383798346141900e-21,   6.717712379539914e-23,
   5.126357384966688e-25,  -1.623899447758732e-26,   8.348274652552565e-01,  -9.510665158560711e-03,   3.448987163474981e-05,   4.312837407657702e-07,  -5.783818283989599e-09,
  -1.228222610474419e-11,   8.217145717102776e-13,  -4.181330827429980e-15,  -9.099777198173249e-17,   1.310554251330172e-18,   4.098110546715070e-21,  -2.540017021088464e-22,
   1.197730049568288e-24,   3.305605979414294e-26,   8.348306921566028e-01,  -9.510543901061000e-03,   3.448662474847758e-05,   4.312721576443336e-07,  -5.782665570126947e-09,
  -1.229038834279202e-11,   8.214760655858826e-13,  -4.176941574471007e-15,  -9.098025114721335e-17,   1.309253948352875e-18,   4.105351320005578e-21,  -2.537603021787880e-22,
   1.194043926096397e-24,   3.305029713587767e-26,   8.348363858281795e-01,  -9.510329942952398e-03,   3.448089609297301e-05,   4.312517128443072e-07,  -5.780631860889225e-09,
  -1.230478373167606e-11,   8.210552553029966e-13,  -4.169200229437713e-15,  -9.094931067297901e-17,   1.306960554885883e-18,   4.118109339838221e-21,  -2.533343831381905e-22,
   1.187549129882627e-24,   3.304007836374859e-26,   8.348432702562169e-01,  -9.510071227053165e-03,   3.447396983900179e-05,   4.312269802057523e-07,  -5.778173142567237e-09,
  -1.232217884344838e-11,   8.205464710331102e-13,  -4.159845381977569e-15,  -9.091185507226362e-17,   1.304189083749409e-18,   4.133505066865382e-21,  -2.528194170535069e-22,
   1.179711611735560e-24,   3.302763568704748e-26,   8.348499530995120e-01,  -9.509820074883348e-03,   3.446724689125541e-05,   4.312029591263955e-07,  -5.775786747885742e-09,
  -1.233905321179923e-11,   8.200526191582097e-13,  -4.150770211665734e-15,  -9.087544984550479e-17,   1.301500393553381e-18,   4.148418124505798e-21,  -2.523195597449398e-22,
   1.172119883086008e-24,   3.301546650086089e-26,   8.348553363957351e-01,  -9.509617753363312e-03,   3.446183164520400e-05,   4.311836001346592e-07,  -5.773864647916310e-09,
  -1.235263802718382e-11,   8.196548266100240e-13,  -4.143463923151860e-15,  -9.084609079697263e-17,   1.299335713603640e-18,   4.160408383671846e-21,  -2.519169264155409e-22,
   1.166016108202503e-24,   3.300559866750146e-26,   8.348588934275477e-01,  -9.509484064573063e-03,   3.445825367667926e-05,   4.311708041799989e-07,  -5.772594729146884e-09,
  -1.236161024735065e-11,   8.193919959445717e-13,  -4.138638285297423e-15,  -9.082667546716814e-17,   1.297905965149207e-18,   4.168319835842281e-21,  -2.516508956984985e-22,
   1.161988724049159e-24,   3.299904661093953e-26,   8.348607200858240e-01,  -9.509415409497783e-03,   3.445641632056653e-05,   4.311642316460567e-07,  -5.771942617868005e-09,
  -1.236621655627138e-11,   8.192570271120215e-13,  -4.136160778069775e-15,  -9.081670000905777e-17,   1.297171916812842e-18,   4.172379191877117e-21,  -2.515142830820659e-22,
   1.159922287395865e-24,   3.299567205591412e-26,   8.348613558633623e-01,  -9.509391513552148e-03,   3.445577682817139e-05,   4.311619438245777e-07,  -5.771715652966804e-09,
  -1.236781960851348e-11,   8.192100511346930e-13,  -4.135298568621170e-15,  -9.081322720244306e-17,   1.296916455754944e-18,   4.173791522467126e-21,  -2.514667349075089e-22,
   1.159203334494069e-24,   3.299449595745262e-26,   8.348614567521406e-01,  -9.509387721598572e-03,   3.445567535030580e-05,   4.311615807697576e-07,  -5.771679637161628e-09,
  -1.236807398058435e-11,   8.192025967491693e-13,  -4.135161753060470e-15,  -9.081267607992715e-17,   1.296875919083897e-18,   4.174015613041436e-21,  -2.514591897191890e-22,
   1.159089260302122e-24,   3.299430925306995e-26,   1.087612160221189e+00,  -1.036888274858292e-02,   2.953419734924773e-07,   7.477101720056629e-07,  -1.304589454147513e-09,
  -9.520564253393248e-11,   4.077183300177798e-13,   1.410577133650412e-14,  -1.070633365922907e-16,  -2.228310833691738e-18,   2.545419663374482e-20,   3.387133312973771e-22,
  -6.087502744402935e-24,  -5.028388522014641e-26,   1.087612186442855e+00,  -1.036867276902553e-02,   2.946113593539805e-07,   7.476211492633309e-07,  -1.304019395636654e-09,
  -9.517799065640423e-11,   4.074394788993816e-13,   1.409829590583867e-14,  -1.069571425806061e-16,  -2.226578455429597e-18,   2.541707999976894e-20,   3.383500338271911e-22,
  -6.075609971873751e-24,  -5.020405044024849e-26,   1.087612232656096e+00,  -1.036830227710289e-02,   2.933224391143149e-07,   7.474640882710670e-07,  -1.303013836357609e-09,
  -9.512921042573835e-11,   4.069476676182328e-13,   1.408511013372018e-14,  -1.067698883958920e-16,  -2.223523165138404e-18,   2.535164671774716e-20,   3.377094639036932e-22,
  -6.054645133348007e-24,  -5.006321289365728e-26,   1.087612288443358e+00,  -1.036785430893794e-02,   2.917643060433233e-07,   7.472742043047935e-07,  -1.301798445256367e-09,
  -9.507024520694630e-11,   4.063533491626103e-13,   1.406917384136680e-14,  -1.065436747331388e-16,  -2.219831263120922e-18,   2.527262565206125e-20,   3.369356882869654e-22,
  -6.029328545759669e-24,  -4.989296587280427e-26,   1.087612342501950e+00,  -1.036741946545396e-02,   2.902521612647357e-07,   7.470899057853842e-07,  -1.300619131884984e-09,
  -9.501302410459482e-11,   4.057767980262836e-13,   1.405371162664383e-14,  -1.063242965427671e-16,  -2.216249936571464e-18,   2.519601963167688e-20,   3.361853666671940e-22,
  -6.004787540022620e-24,  -4.972775134623268e-26,   1.087612385980133e+00,  -1.036706918717259e-02,   2.890343293427271e-07,   7.469414641923450e-07,  -1.299669498658477e-09,
  -9.496694279351153e-11,   4.053126244622778e-13,   1.404126152799822e-14,  -1.061477302124668e-16,  -2.213366805540737e-18,   2.513438289227222e-20,   3.355815236164329e-22,
  -5.985043318886533e-24,  -4.959469880762968e-26,   1.087612414675121e+00,  -1.036683774224076e-02,   2.882297703443204e-07,   7.468433897995025e-07,  -1.299042196805346e-09,
  -9.493650055623842e-11,   4.050060480467979e-13,   1.403303769093002e-14,  -1.060311375403123e-16,  -2.211462632839841e-18,   2.509369165584670e-20,   3.351828116911456e-22,
  -5.972009258536939e-24,  -4.950680082768778e-26,   1.087612429400665e+00,  -1.036671888812647e-02,   2.878166410923815e-07,   7.467930279777623e-07,  -1.298720108775931e-09,
  -9.492086932123075e-11,   4.048486500434871e-13,   1.402881527424301e-14,  -1.059712861111201e-16,  -2.210485042404568e-18,   2.507280626513676e-20,   3.349781458191523e-22,
  -5.965319529663785e-24,  -4.946166746080572e-26,   1.087612434524321e+00,  -1.036667752048959e-02,   2.876728556785507e-07,   7.467754997326790e-07,  -1.298608012875374e-09,
  -9.491542909452923e-11,   4.047938731757209e-13,   1.402734576943831e-14,  -1.059504581704448e-16,  -2.210144829794686e-18,   2.506553874496456e-20,   3.349069245985798e-22,
  -5.962991726516070e-24,  -4.944595940883182e-26,   1.087612435337294e+00,  -1.036667095604506e-02,   2.876500392936616e-07,   7.467727182723573e-07,  -1.298590225264395e-09,
  -9.491456582293521e-11,   4.047851811710576e-13,   1.402711258619444e-14,  -1.059471532481079e-16,  -2.210090844955494e-18,   2.506438557653269e-20,   3.348956234653369e-22,
  -5.962622365561609e-24,  -4.944346680625347e-26,   1.352197275224559e+00,  -9.861615722653724e-03,  -4.451888531443740e-05,   6.216775642678915e-07,   7.744827443909075e-09,
  -6.332198773136986e-11,  -1.528598315019878e-12,   5.728007253508958e-15,   3.135608522374232e-16,  -1.163963478832785e-20,  -6.604604306697970e-20,  -2.572692956096528e-22,
   1.338168123144601e-23,   1.066424632174046e-25,   1.352193110308052e+00,  -9.861441084927085e-03,  -4.451454093144710e-05,   6.216182948232525e-07,   7.742687514435489e-09,
  -6.331071197525060e-11,  -1.527780911738860e-12,   5.727934277621031e-15,   3.132848455339595e-16,  -1.293659755217868e-20,  -6.596426035464939e-20,  -2.565064434878775e-22,
   1.335968651747647e-23,   1.063334134009604e-25,   1.352185761576930e+00,  -9.861132947442322e-03,  -4.450687617554857e-05,   6.215137215480651e-07,   7.738912507446876e-09,
  -6.329081585924359e-11,  -1.526339178214673e-12,   5.727801973487778e-15,   3.127981069677457e-16,  -1.522192818911937e-20,  -6.582006364052001e-20,  -2.551622020685289e-22,
   1.332091930323818e-23,   1.057891415855199e-25,   1.352176875974641e+00,  -9.860760367373945e-03,  -4.449760953508709e-05,   6.213872850768644e-07,   7.734349317736305e-09,
  -6.326675749390859e-11,  -1.524596819832403e-12,   5.727635964939596e-15,   3.122100139830187e-16,  -1.797995649981196e-20,  -6.564588713221589e-20,  -2.535398353458423e-22,
   1.327411449904076e-23,   1.051327921454876e-25,   1.352168250574102e+00,  -9.860398697250377e-03,  -4.448861538336295e-05,   6.212645580809575e-07,   7.729921115631406e-09,
  -6.324340229581981e-11,  -1.522906416401138e-12,   5.727468505012665e-15,   3.116396021399182e-16,  -2.065173570085465e-20,  -6.547699596198110e-20,  -2.519681152459279e-22,
   1.322875349573853e-23,   1.044974900270600e-25,   1.352161302485101e+00,  -9.860107357809600e-03,  -4.448137105987987e-05,   6.211657018012456e-07,   7.726355005064481e-09,
  -6.322458783205938e-11,  -1.521545399848278e-12,   5.727329091675150e-15,   3.111804428235736e-16,  -2.280003061503696e-20,  -6.534107999711136e-20,  -2.507042794912594e-22,
   1.319226586933211e-23,   1.039870365011566e-25,   1.352156711518026e+00,  -9.859914854370808e-03,  -4.447658475101143e-05,   6.211003847146971e-07,   7.723999165934461e-09,
  -6.321215565915002e-11,  -1.520646431657064e-12,   5.727234763866136e-15,   3.108772132528247e-16,  -2.421760174927708e-20,  -6.525133792006190e-20,  -2.498702944752144e-22,
   1.316818221157258e-23,   1.036503917608262e-25,   1.352154353900579e+00,  -9.859815997264484e-03,  -4.447412694133702e-05,   6.210668429298799e-07,   7.722789510144358e-09,
  -6.320577117150330e-11,  -1.520184882036624e-12,   5.727185640269210e-15,   3.107215443748975e-16,  -2.494497922524761e-20,  -6.520527232629055e-20,  -2.494423539880439e-22,
   1.315582235841754e-23,   1.034777105625086e-25,   1.352153533320395e+00,  -9.859781589560490e-03,  -4.447327150825037e-05,   6.210551686694874e-07,   7.722368507073894e-09,
  -6.320354899659460e-11,  -1.520024253540556e-12,   5.727168433856247e-15,   3.106673709939547e-16,  -2.519805204153507e-20,  -6.518924215762228e-20,  -2.492934611889646e-22,
   1.315152171252622e-23,   1.034176394259222e-25,   1.352153403106103e+00,  -9.859776129551542e-03,  -4.447313576422862e-05,   6.210533161377232e-07,   7.722301701047421e-09,
  -6.320319636825432e-11,  -1.519998764868517e-12,   5.727165698285685e-15,   3.106587748326074e-16,  -2.523820658060341e-20,  -6.518669855121223e-20,  -2.492698366010616e-22,
   1.315083932163321e-23,   1.034081084890452e-25,   1.608135796296729e+00,  -7.668328703859665e-03,  -7.592091219479160e-05,  -9.030002262301590e-08,   9.123632964231630e-09,
   1.131024482559742e-10,  -4.143369814191284e-13,  -2.724864919845013e-14,  -2.293855426491512e-16,   3.300294539787905e-18,   9.129433678215953e-20,   3.058919450178240e-22,
  -1.863525733261734e-23,  -3.067595260573785e-25,   1.608128689020655e+00,  -7.668353728888670e-03,  -7.591578349363825e-05,  -9.019443865333043e-08,   9.123043288452435e-09,
   1.130489804538413e-10,  -4.149312504048640e-13,  -2.723747216387480e-14,  -2.290040878032417e-16,   3.301786739475726e-18,   9.117943565351276e-20,   3.036983065286159e-22,
  -1.862663848784287e-23,  -3.058601685966255e-25,   1.608116148510528e+00,  -7.668397861882256e-03,  -7.590673409094914e-05,  -9.000817477281119e-08,   9.122002119919106e-09,
   1.129546535832286e-10,  -4.159790355576394e-13,  -2.721774607817292e-14,  -2.283313984523640e-16,   3.304410604180001e-18,   9.097673496196574e-20,   2.998329283321922e-22,
  -1.861135756611893e-23,  -3.042743692996319e-25,   1.608100985057198e+00,  -7.668451186945257e-03,  -7.589579191912114e-05,  -8.978301187733614e-08,   9.120741975214754e-09,
   1.128406230613918e-10,  -4.172446449115724e-13,  -2.719388622618941e-14,  -2.275186465319941e-16,   3.307567831506663e-18,   9.073170266174915e-20,   2.951679576243533e-22,
  -1.859275576193607e-23,  -3.023587344772895e-25,   1.608086265336075e+00,  -7.668502911041139e-03,  -7.588516993280928e-05,  -8.956450027702224e-08,   9.119517442377235e-09,
   1.127299561892563e-10,  -4.184718283559438e-13,  -2.717071633469423e-14,  -2.267303438078381e-16,   3.310616519604527e-18,   9.049390897075224e-20,   2.906487935842164e-22,
  -1.857456795705451e-23,  -3.005010936686510e-25,   1.608074407819463e+00,  -7.668544548530744e-03,  -7.587661334623525e-05,  -8.938852221203203e-08,   9.118530110999662e-09,
   1.126408273169730e-10,  -4.194593942607049e-13,  -2.715204585653301e-14,  -2.260958008230579e-16,   3.313060842562166e-18,   9.030240259683235e-20,   2.870150226416054e-22,
  -1.855982352926610e-23,  -2.990060546192455e-25,   1.608066572828185e+00,  -7.668572046778930e-03,  -7.587095947646055e-05,  -8.927226451767685e-08,   9.117877277378842e-09,
   1.125819437701116e-10,  -4.201114526254957e-13,  -2.713970623898444e-14,  -2.256767525810328e-16,   3.314670303867625e-18,   9.017588665962832e-20,   2.846172236421834e-22,
  -1.855003543638791e-23,  -2.980188712273819e-25,   1.608062549260876e+00,  -7.668586163787174e-03,  -7.586805599645666e-05,  -8.921256850687852e-08,   9.117541885422774e-09,
   1.125517077228374e-10,  -4.204461588625695e-13,  -2.713336848367975e-14,  -2.254616274693554e-16,   3.315495076498179e-18,   9.011092337029185e-20,   2.833868692514412e-22,
  -1.854499481060078e-23,  -2.975121255999391e-25,   1.608061148833462e+00,  -7.668591076599666e-03,  -7.586704542203593e-05,  -8.919179201776120e-08,   9.117425128384974e-09,
   1.125411843423898e-10,  -4.205626314535279e-13,  -2.713116244723780e-14,  -2.253867633363963e-16,   3.315781865636654e-18,   9.008831368896139e-20,   2.829587971040068e-22,
  -1.854323815195145e-23,  -2.973357832262139e-25,   1.608060926605490e+00,  -7.668591856160147e-03,  -7.586688505819127e-05,  -8.918849513461283e-08,   9.117406599663910e-09,
   1.125395144530822e-10,  -4.205811128638229e-13,  -2.713081237381539e-14,  -2.253748840054832e-16,   3.315827361807715e-18,   9.008472590977336e-20,   2.828908757330518e-22,
  -1.854295928893196e-23,  -2.973078017858935e-25,   1.824978021728373e+00,  -4.172365393695570e-03,  -6.454551586568747e-05,  -6.863946728997881e-07,  -3.214397692175930e-09,
   5.483946015517579e-11,   1.633369081811237e-12,   2.048698655208530e-14,   5.237087394593439e-17,  -3.597719294827921e-18,  -8.636033934787713e-20,  -9.295856351530647e-22,
   1.722769569307433e-24,   2.680994107057319e-25,   1.824971966994837e+00,  -4.172558259467270e-03,  -6.454731098609348e-05,  -6.863429237278074e-07,  -3.212099246234989e-09,
   5.487959846744144e-11,   1.633499040566003e-12,   2.047472164742701e-14,   5.200696121605730e-17,  -3.602435163281053e-18,  -8.634762068139280e-20,  -9.276025264583675e-22,
   1.767255075394086e-24,   2.685124813210773e-25,   1.824961283186828e+00,  -4.172898562269271e-03,  -6.455047745287023e-05,  -6.862515809656205e-07,  -3.208043456528912e-09,
   5.495040346044748e-11,   1.633727578457722e-12,   2.045306714699577e-14,   5.136487690186308e-17,  -3.610748051130759e-18,  -8.632495498471774e-20,  -9.241008707155162e-22,
   1.845716811020362e-24,   2.692393839613584e-25,   1.824948363981155e+00,  -4.173310039781631e-03,  -6.455430458552632e-05,  -6.861410762687019e-07,  -3.203138904484481e-09,
   5.503598802662001e-11,   1.634002605201513e-12,   2.042686034244327e-14,   5.058853966230014e-17,  -3.620785863049834e-18,  -8.629716656715032e-20,  -9.198624971144185e-22,
   1.940536040816916e-24,   2.701150074809821e-25,   1.824935821998219e+00,  -4.173709473793483e-03,  -6.455801802219944e-05,  -6.860337457255985e-07,  -3.198377391541322e-09,
   5.511903685113516e-11,   1.634268210307877e-12,   2.040139626310581e-14,   4.983496723047262e-17,  -3.630515496296729e-18,  -8.626979141625630e-20,  -9.157436384706581e-22,
   2.032524422696861e-24,   2.709615330119262e-25,   1.824925718166736e+00,  -4.174031237420383e-03,  -6.456100817325799e-05,  -6.859472425987847e-07,  -3.194541393811609e-09,
   5.518591467739760e-11,   1.634481185256590e-12,   2.038086629019984e-14,   4.922795853386823e-17,  -3.638342879715813e-18,  -8.624745283498752e-20,  -9.124224522359292e-22,
   2.106585567130652e-24,   2.716409637828664e-25,   1.824919041650133e+00,  -4.174243845639907e-03,  -6.456298335313186e-05,  -6.858900637637296e-07,  -3.192006544573114e-09,
   5.523009399681970e-11,   1.634621429099897e-12,   2.036729240522117e-14,   4.882688730137359e-17,  -3.643509842250761e-18,  -8.623255214512218e-20,  -9.102263628380005e-22,
   2.155502487883681e-24,   2.720886856809930e-25,   1.824915612913192e+00,  -4.174353027828251e-03,  -6.456399749880031e-05,  -6.858606937869206e-07,  -3.190704750329824e-09,
   5.525277836870840e-11,   1.634693300664666e-12,   2.036031907914399e-14,   4.862092713500196e-17,  -3.646161705858822e-18,  -8.622485671703490e-20,  -9.090980998951767e-22,
   2.180617046266609e-24,   2.723182306354967e-25,   1.824914419505729e+00,  -4.174391029321723e-03,  -6.456435044905697e-05,  -6.858504703568643e-07,  -3.190251644489024e-09,
   5.526067326343155e-11,   1.634718292284056e-12,   2.035789155337262e-14,   4.854924226564028e-17,  -3.647084453496690e-18,  -8.622217137440146e-20,  -9.087053235197589e-22,
   2.189357342988033e-24,   2.723980650904158e-25,   1.824914230128202e+00,  -4.174397059617947e-03,  -6.456440645586220e-05,  -6.858488479946587e-07,  -3.190179742622005e-09,
   5.526192604559722e-11,   1.634722256973509e-12,   2.035750631967883e-14,   4.853786693316922e-17,  -3.647230868600097e-18,  -8.622174492098429e-20,  -9.086429918005088e-22,
   2.190744257579923e-24,   2.724107308338796e-25,   1.964794503751329e+00,  -9.484362671785133e-04,  -1.866883340807876e-05,  -3.151434861817875e-07,  -4.750839042021239e-09,
  -6.422535657634002e-11,  -7.606150185968971e-13,  -7.293121476954179e-15,  -3.960011345458742e-17,   4.304660619469052e-19,   1.927113399813299e-20,   4.135705396451932e-22,
   6.747139217119973e-24,   8.796056838057543e-26,   1.964792748174774e+00,  -9.485251136445464e-04,  -1.867151179485999e-05,  -3.152038178296306e-07,  -4.751909861187899e-09,
  -6.423969074927010e-11,  -7.607172575130427e-13,  -7.291612314430176e-15,  -3.951745906642711e-17,   4.326236136863316e-19,   1.931320833487356e-20,   4.142149970360071e-22,
   6.754198894377602e-24,   8.798368302662971e-26,   1.964789650227412e+00,  -9.486818984501598e-04,  -1.867623834052703e-05,  -3.153102848908699e-07,  -4.753799454695083e-09,
  -6.426498117991039e-11,  -7.608974824736309e-13,  -7.288943434845640e-15,  -3.937146950028320e-17,   4.364333505810319e-19,   1.938748457543990e-20,   4.153522848882353e-22,
   6.766646512052129e-24,   8.802411468591462e-26,   1.964785903806943e+00,  -9.488715078758600e-04,  -1.868195456567162e-05,  -3.154390446162541e-07,  -4.756084569416306e-09,
  -6.429555846682418e-11,  -7.611151100430683e-13,  -7.285706066300035e-15,  -3.919469072248696e-17,   4.410447341972917e-19,   1.947736054643710e-20,   4.167277302372007e-22,
   6.781682418911390e-24,   8.807239988145809e-26,   1.964782266480860e+00,  -9.490556021019421e-04,  -1.868750465319718e-05,  -3.155640618231342e-07,  -4.758303126464236e-09,
  -6.432523799042693e-11,  -7.613260622023367e-13,  -7.282552669556119e-15,  -3.902281856574780e-17,   4.455262126242462e-19,   1.956467373721296e-20,   4.180632222538376e-22,
   6.796262332729356e-24,   8.811863959580254e-26,   1.964779336036049e+00,  -9.492039236995304e-04,  -1.869197635857396e-05,  -3.156647880256853e-07,  -4.760090515526870e-09,
  -6.434914428652779e-11,  -7.614957752573618e-13,  -7.280004723677194e-15,  -3.888417538880217e-17,   4.491398922537621e-19,   1.963505732868163e-20,   4.191392432373863e-22,
   6.807995732738658e-24,   8.815543425876336e-26,   1.964777399521923e+00,  -9.493019406277270e-04,  -1.869493148885678e-05,  -3.157313529438615e-07,  -4.761271662966927e-09,
  -6.436493960026823e-11,  -7.616078072707748e-13,  -7.278317358295246e-15,  -3.879247173705307e-17,   4.515294410753896e-19,   1.968158768145165e-20,   4.198503394764479e-22,
   6.815743070304553e-24,   8.817952424314721e-26,   1.964776404989549e+00,  -9.493522796882306e-04,  -1.869644918460962e-05,  -3.157655393289450e-07,  -4.761878261131153e-09,
  -6.437305077262488e-11,  -7.616653066177743e-13,  -7.277449662080346e-15,  -3.874534946461258e-17,   4.527571125511365e-19,   1.970549008519287e-20,   4.202155462774843e-22,
   6.819719876126425e-24,   8.819182649517627e-26,   1.964776058827127e+00,  -9.493698010855730e-04,  -1.869697744763223e-05,  -3.157774385499788e-07,  -4.762089396748456e-09,
  -6.437587386445509e-11,  -7.616853143057280e-13,  -7.277147468816116e-15,  -3.872894365848978e-17,   4.531844982463390e-19,   1.971381062461068e-20,   4.203426637963824e-22,
   6.821103749366264e-24,   8.819609739944462e-26,   1.964776003895617e+00,  -9.493725815102627e-04,  -1.869706127641622e-05,  -3.157793268084590e-07,  -4.762122901232630e-09,
  -6.437632184663994e-11,  -7.616884889897720e-13,  -7.277099506187759e-15,  -3.872634007089632e-17,   4.532523224292158e-19,   1.971513103131319e-20,   4.203628357831296e-22,
   6.821323337196644e-24,   8.819677461047894e-26,   4.817571934992523e-03,  -7.518002590689459e-05,   8.779436857757882e-07,  -9.098250629524596e-09,   8.803840541078931e-11,
  -8.162916162791956e-13,   7.301879783555428e-15,  -6.411183607810115e-17,   5.416624114635663e-19,  -4.681588595321488e-21,   3.591360200246850e-23,  -3.229190636732780e-25,
   2.851481269823352e-27,   7.199785465227618e-30,   4.817654341581249e-03,  -7.518258748438621e-05,   8.779932653468143e-07,  -9.099016965011206e-09,   8.804869051599191e-11,
  -8.164180883202338e-13,   7.303304787440660e-15,  -6.412767974692565e-17,   5.418145007198300e-19,  -4.683251446275490e-21,   3.593156182248501e-23,  -3.228631053737110e-25,
   2.858315839867499e-27,   7.260437676051310e-30,   4.817799753091493e-03,  -7.518710760364981e-05,   8.780807539886867e-07,  -9.100369272527119e-09,   8.806684037662371e-11,
  -8.166412756103852e-13,   7.305819554182953e-15,  -6.415564071128527e-17,   5.420829264867425e-19,  -4.686185335047671e-21,   3.596328652674913e-23,  -3.227640116860347e-25,
   2.870369946929816e-27,   7.366999959088567e-30,   4.817975592702530e-03,  -7.519257367938534e-05,   8.781865542186780e-07,  -9.102004661767950e-09,   8.808879016275835e-11,
  -8.169111993533564e-13,   7.308860991187255e-15,  -6.418945918537946e-17,   5.424076153859625e-19,  -4.689732618059145e-21,   3.600170687586584e-23,  -3.226435841489283e-25,
   2.884936315350953e-27,   7.495072912169954e-30,   4.818146301517479e-03,  -7.519788036445868e-05,   8.782892716595916e-07,  -9.103592441660140e-09,   8.811010154747408e-11,
  -8.171732819868584e-13,   7.311814146042759e-15,  -6.422229771831022e-17,   5.427229284286095e-19,  -4.693175831892146e-21,   3.603906591902808e-23,  -3.225260467477124e-25,
   2.899067004484965e-27,   7.618583890385968e-30,   4.818283827165711e-03,  -7.520215558548443e-05,   8.783720255197380e-07,  -9.104871659976191e-09,   8.812727180873577e-11,
  -8.173844448359580e-13,   7.314193585169470e-15,  -6.424875784790951e-17,   5.429770198893681e-19,  -4.695949333253887e-21,   3.606920573414595e-23,  -3.224309115571667e-25,
   2.910443239719380e-27,   7.717495347545634e-30,   4.818374704037409e-03,  -7.520498068532553e-05,   8.784267107467766e-07,  -9.105717005116653e-09,   8.813861863338677e-11,
  -8.175239933936541e-13,   7.315766079864198e-15,  -6.426624508675366e-17,   5.431449578930924e-19,  -4.697781862904131e-21,   3.608914305285989e-23,  -3.223678289556708e-25,
   2.917956882341541e-27,   7.782566746710682e-30,   4.818421374393304e-03,  -7.520643154327353e-05,   8.784547951399508e-07,  -9.106151148995167e-09,   8.814444608681846e-11,
  -8.175956631754992e-13,   7.316573694136694e-15,  -6.427522650402125e-17,   5.432312141277728e-19,  -4.698722907898334e-21,   3.609938845695544e-23,  -3.223353654498905e-25,
   2.921814389960319e-27,   7.815895116974612e-30,   4.818437618554919e-03,  -7.520693653308239e-05,   8.784645703154585e-07,  -9.106302259725106e-09,   8.814647443566855e-11,
  -8.176206092827577e-13,   7.316854801711354e-15,  -6.427835270918392e-17,   5.432612383165840e-19,  -4.699050439790470e-21,   3.610295552015383e-23,  -3.223240554848046e-25,
   2.923156854246775e-27,   7.827481208670338e-30,   4.818440196285196e-03,  -7.520701666826723e-05,   8.784661215080823e-07,  -9.106326239058159e-09,   8.814679630908491e-11,
  -8.176245679236052e-13,   7.316899410088201e-15,  -6.427884880156467e-17,   5.432660028328382e-19,  -4.699102414237760e-21,   3.610352161410872e-23,  -3.223222602392875e-25,
   2.923369876452682e-27,   7.829319090003094e-30,   4.333914895303911e-02,  -6.693220455272137e-04,   7.629607226203574e-06,  -7.567630533148485e-08,   6.820671735321501e-10,
  -5.676726529925578e-12,   4.314319510533128e-14,  -2.974663459755409e-16,   1.651134447093408e-18,  -7.194318727815021e-21,  -3.548627668120156e-23,   5.807900872343562e-25,
  -6.596710757128884e-27,   3.497297307418458e-28,   4.333986499819015e-02,  -6.693433482103490e-04,   7.629991231014733e-06,  -7.568163217967277e-08,   6.821278947456828e-10,
  -5.677312550390075e-12,   4.314752620352016e-14,  -2.974905456444033e-16,   1.650983499706033e-18,  -7.191222719766456e-21,  -3.552514359142814e-23,   5.833877253398169e-25,
  -6.554535888900979e-27,   3.504650330719193e-28,   4.334112850045230e-02,  -6.693809383493172e-04,   7.630668841336087e-06,  -7.569103193402087e-08,   6.822350432342858e-10,
  -5.678346631428275e-12,   4.315516817163653e-14,  -2.975332377717106e-16,   1.650717019066414e-18,  -7.185748834392381e-21,  -3.559351337867938e-23,   5.879756146734148e-25,
  -6.480178079520883e-27,   3.517583718349845e-28,   4.334265639089682e-02,  -6.694263948263270e-04,   7.631488262364249e-06,  -7.570239897946818e-08,   6.823646167750005e-10,
  -5.679597119261941e-12,   4.316440837058852e-14,  -2.975848469165795e-16,   1.650394563936677e-18,  -7.179111104051520e-21,  -3.567582646276242e-23,   5.935306819314472e-25,
  -6.390367187346246e-27,   3.533152782087473e-28,   4.334413969286376e-02,  -6.694705253649114e-04,   7.632283791740146e-06,  -7.571343470847111e-08,   6.824904133670125e-10,
  -5.680811140300827e-12,   4.317337801901579e-14,  -2.976349328326912e-16,   1.650081296252192e-18,  -7.172647764916112e-21,  -3.575535744878429e-23,   5.989311126608284e-25,
  -6.303289033552665e-27,   3.548193544589754e-28,   4.334533465916417e-02,  -6.695060779131845e-04,   7.632924695418320e-06,  -7.572232552006019e-08,   6.825917598003997e-10,
  -5.681789189360787e-12,   4.318060343772242e-14,  -2.976752703797789e-16,   1.649828764789330e-18,  -7.167426967702325e-21,  -3.581915655389389e-23,   6.032871081799967e-25,
  -6.233218218025880e-27,   3.560257600514838e-28,   4.334612428998210e-02,  -6.695295711677255e-04,   7.633348210562575e-06,  -7.572820068996033e-08,   6.826587308197623e-10,
  -5.682435490988907e-12,   4.318537766319804e-14,  -2.977019193112972e-16,   1.649661814865362e-18,  -7.163970291219127e-21,  -3.586118173257173e-23,   6.061681488887198e-25,
  -6.186955097645088e-27,   3.568203571935285e-28,   4.334652980887206e-02,  -6.695416363143193e-04,   7.633565711238247e-06,  -7.573121795741062e-08,   6.826931246018312e-10,
  -5.682767405292782e-12,   4.318782939378173e-14,  -2.977156031408274e-16,   1.649576052884005e-18,  -7.162192997915659e-21,  -3.588272282560731e-23,   6.076485275735207e-25,
  -6.163208683329541e-27,   3.572276248859051e-28,   4.334667095434001e-02,  -6.695458357366965e-04,   7.633641415197478e-06,  -7.573226815876335e-08,   6.827050958253502e-10,
  -5.682882932298724e-12,   4.318868273109055e-14,  -2.977203656566958e-16,   1.649546198631408e-18,  -7.161574056392681e-21,  -3.589021389886580e-23,   6.081639183849187e-25,
  -6.154945425192886e-27,   3.573692514295060e-28,   4.334669335222484e-02,  -6.695465021289782e-04,   7.633653428413894e-06,  -7.573243481190887e-08,   6.827069955009014e-10,
  -5.682901264900131e-12,   4.318881814349562e-14,  -2.977211213897280e-16,   1.649541460982400e-18,  -7.161475822834678e-21,  -3.589140232040811e-23,   6.082457100467926e-25,
  -6.153634250123951e-27,   3.573917195965292e-28,   1.202652505949984e-01,  -1.817472583353699e-03,   1.966853691138018e-05,  -1.764560081816684e-07,   1.323272144144107e-09,
  -7.715055475121956e-12,   2.160149014788628e-14,   2.252217089588669e-16,  -5.250894988537016e-18,   5.773700611620165e-20,  -5.650427420926342e-22,   2.612799784813670e-24,
   6.167174729703806e-27,   4.756087392802443e-28,   1.202670960112830e-01,  -1.817522236971107e-03,   1.966928142095668e-05,  -1.764632372747617e-07,   1.323302357518169e-09,
  -7.714608964768499e-12,   2.158765738035902e-14,   2.254169263411762e-16,  -5.253277227913577e-18,   5.775061731275187e-20,  -5.649964250020564e-22,   2.616358969364333e-24,
   6.343419220884641e-27,   4.770995678680888e-28,   1.202703523341643e-01,  -1.817609853213815e-03,   1.967059513361510e-05,  -1.764759927821599e-07,   1.323355653658643e-09,
  -7.713820777573027e-12,   2.156324416100516e-14,   2.257614279386548e-16,  -5.257480560805023e-18,   5.777464948631763e-20,  -5.649138126305819e-22,   2.622647907890540e-24,
   6.654274453960946e-27,   4.797181595797275e-28,   1.202742900114607e-01,  -1.817715802530215e-03,   1.967218371252053e-05,  -1.764914162962429e-07,   1.323420072919968e-09,
  -7.712867160055160e-12,   2.153371476787805e-14,   2.261780668438987e-16,  -5.262562990787133e-18,   5.780373505367348e-20,  -5.648124080941815e-22,   2.630267347336243e-24,
   7.029939603701679e-27,   4.828641344544105e-28,   1.202781127418679e-01,  -1.817818659245170e-03,   1.967372590204991e-05,  -1.765063885673242e-07,   1.323482581743318e-09,
  -7.711940846324581e-12,   2.150503906804168e-14,   2.265825996251200e-16,  -5.267496624674265e-18,   5.783199766514758e-20,  -5.647123869375646e-22,   2.637679590592686e-24,
   7.394392586783487e-27,   4.858967790313343e-28,   1.202811923564608e-01,  -1.817901521392628e-03,   1.967496828751997e-05,  -1.765184495974174e-07,   1.323532917772101e-09,
  -7.711194219935309e-12,   2.148193179436098e-14,   2.269085339636972e-16,  -5.271470878325684e-18,   5.785478491472660e-20,  -5.646306799827768e-22,   2.643661804231239e-24,
   7.687820963574093e-27,   4.883244997589485e-28,   1.202832273465139e-01,  -1.817956276259325e-03,   1.967578924234196e-05,  -1.765264190973253e-07,   1.323566168998804e-09,
  -7.710700666606112e-12,   2.146665973569587e-14,   2.271239290762266e-16,  -5.274096887019965e-18,   5.786985176111692e-20,  -5.645761357790894e-22,   2.647620115968261e-24,
   7.881629490763504e-27,   4.899211860727472e-28,   1.202842724222839e-01,  -1.817984395823623e-03,   1.967621084459459e-05,  -1.765305117506859e-07,   1.323583242025205e-09,
  -7.710447142765161e-12,   2.145881581821201e-14,   2.272345520450266e-16,  -5.275445434784137e-18,   5.787759222828586e-20,  -5.645479535185877e-22,   2.649654555863757e-24,
   7.981133471900380e-27,   4.907388392580626e-28,   1.202846361722286e-01,  -1.817994183146484e-03,   1.967635758754462e-05,  -1.765319362256322e-07,   1.323589183959694e-09,
  -7.710358891824204e-12,   2.145608551414855e-14,   2.272730565403177e-16,  -5.275914803859382e-18,   5.788028683390507e-20,  -5.645381171723323e-22,   2.650362924827686e-24,
   8.015762601970366e-27,   4.910230613629357e-28,   1.202846938944183e-01,  -1.817995736262250e-03,   1.967638087364999e-05,  -1.765321622696878e-07,   1.323590126839663e-09,
  -7.710344887157333e-12,   2.145565224505462e-14,   2.272791667284030e-16,  -5.275989286014341e-18,   5.788071445279105e-20,  -5.645365549859540e-22,   2.650475345730157e-24,
   8.021257571222382e-27,   4.910681459523887e-28,   2.352806457164227e-01,  -3.433387351203038e-03,   3.400892134319158e-05,  -2.509119155261867e-07,   1.131355029399031e-09,
   2.560593544920503e-12,  -1.242768092087710e-13,   1.516987967974930e-15,  -1.135002114062028e-17,   1.690382935611621e-20,   6.342979118646972e-22,  -1.418357640110529e-23,
   1.492380942532845e-25,   7.326659136626904e-28,   2.352838353220474e-01,  -3.433457911491397e-03,   3.400955674048971e-05,  -2.509094898559367e-07,   1.131179913889623e-09,
   2.563580982107961e-12,  -1.243065469755228e-13,   1.517043118485889e-15,  -1.134731505572826e-17,   1.683091659187201e-20,   6.352335795451782e-22,  -1.417793630713566e-23,
   1.495032798375211e-25,   7.378187677338653e-28,   2.352894634797466e-01,  -3.433582415673105e-03,   3.401067782886941e-05,  -2.509052074452909e-07,   1.130870885837018e-09,
   2.568852449440619e-12,  -1.243590139401072e-13,   1.517140232530799e-15,  -1.134253690632406e-17,   1.670228480180516e-20,   6.368859091544672e-22,  -1.416795394972842e-23,
   1.499707747000535e-25,   7.468879649582121e-28,   2.352962691906872e-01,  -3.433732966509597e-03,   3.401203332424570e-05,  -2.509000252255000e-07,   1.130497147877393e-09,
   2.575226912899023e-12,  -1.244224476725647e-13,   1.517257323071918e-15,  -1.133675362345810e-17,   1.654678275519323e-20,   6.388861887924881e-22,  -1.415583156744906e-23,
   1.505353403555382e-25,   7.578151641200392e-28,   2.353028761434674e-01,  -3.433879117660045e-03,   3.401334907255965e-05,  -2.508949903498466e-07,   1.130134268870719e-09,
   2.581415287263905e-12,  -1.244840176879560e-13,   1.517370635718285e-15,  -1.133113355578900e-17,   1.639586698822799e-20,   6.408303956394100e-22,  -1.414400944398990e-23,
   1.510826393700742e-25,   7.683818807568059e-28,   2.353081986806144e-01,  -3.433996854412607e-03,   3.401440891972666e-05,  -2.508909314059034e-07,   1.129841894799825e-09,
   2.586400672453703e-12,  -1.245336102688003e-13,   1.517461663290273e-15,  -1.132660197485184e-17,   1.627432204443475e-20,   6.423983201402979e-22,  -1.413444714281106e-23,
   1.515229815681893e-25,   7.768647638381477e-28,   2.353117157486545e-01,  -3.434074652411778e-03,   3.401510919763231e-05,  -2.508882479014636e-07,   1.129648677943604e-09,
   2.589694980581672e-12,  -1.245663765266200e-13,   1.517521687545282e-15,  -1.132360556482686e-17,   1.619402243998490e-20,   6.434352069468208e-22,  -1.412810970243768e-23,
   1.518136794290375e-25,   7.824556477683540e-28,   2.353135219407522e-01,  -3.434114605298732e-03,   3.401546880831156e-05,  -2.508868693523432e-07,   1.129549445262584e-09,
   2.591386782240902e-12,  -1.245832024429424e-13,   1.517552474174193e-15,  -1.132206613932176e-17,   1.615278943640270e-20,   6.439679545743884e-22,  -1.412484930374660e-23,
   1.519628822738489e-25,   7.853223647252770e-28,   2.353141506039446e-01,  -3.434128511249699e-03,   3.401559397162884e-05,  -2.508863894654592e-07,   1.129514905371654e-09,
   2.591975631975901e-12,  -1.245890586780911e-13,   1.517563183581847e-15,  -1.132153022856178e-17,   1.613843865843593e-20,   6.441534231118498e-22,  -1.412371356624751e-23,
   1.520148002362463e-25,   7.863194403255949e-28,   2.353142503642060e-01,  -3.434130717931784e-03,   3.401561383320611e-05,  -2.508863133106854e-07,   1.129509424316924e-09,
   2.592069074446004e-12,  -1.245899879734520e-13,   1.517564882724897e-15,  -1.132144518217536e-17,   1.613616142306708e-20,   6.441828563533567e-22,  -1.412353329640672e-23,
   1.520230382628406e-25,   7.864776287157869e-28,   3.876815428712005e-01,  -5.372052411870383e-03,   4.609605609912148e-05,  -2.223414618160613e-07,  -6.193734463815187e-10,
   2.531188078455450e-11,  -2.625117329419165e-13,   8.812710895186113e-16,   1.467155432775507e-17,  -3.100228658442330e-19,   2.277755768250117e-21,  -1.236152967592602e-24,
  -2.601298329448495e-25,   6.454004913492057e-27,   3.876858636643732e-01,  -5.372114861645659e-03,   4.609570562131650e-05,  -2.223177175433632e-07,  -6.197421446936706e-10,
   2.531359913846962e-11,  -2.624730229416157e-13,   8.802246537919825e-16,   1.468111240443119e-17,  -3.100273904351369e-19,   2.276161434915178e-21,  -1.188668873426674e-24,
  -2.598013115246075e-25,   6.459317489088540e-27,   3.876934877450539e-01,  -5.372225049826436e-03,   4.609508702920361e-05,  -2.222758190954322e-07,  -6.203926743413808e-10,
   2.531662952605422e-11,  -2.624046981688650e-13,   8.783781904082275e-16,   1.469797232638432e-17,  -3.100351747982980e-19,   2.273349860268078e-21,  -1.104851508869761e-24,
  -2.592217153246776e-25,   6.468643293574492e-27,   3.877027068190903e-01,  -5.372358281292916e-03,   4.609433873369751e-05,  -2.222251528198923e-07,  -6.211792261494822e-10,
   2.532029104719193e-11,  -2.623220444020297e-13,   8.761454086351218e-16,   1.471835022730160e-17,  -3.100442477395441e-19,   2.269952889970670e-21,  -1.003446108663953e-24,
  -2.585210102144663e-25,   6.479837786834482e-27,   3.877116564886295e-01,  -5.372487610398131e-03,   4.609361200051857e-05,  -2.221759645481246e-07,  -6.219427178495791e-10,
   2.532384259783892e-11,  -2.622417692059372e-13,   8.739778438227741e-16,   1.473812301015125e-17,  -3.100526994438652e-19,   2.266658118281768e-21,  -9.049487251518199e-25,
  -2.578409385604844e-25,   6.490618974406548e-27,   3.877188661916605e-01,  -5.372591789295982e-03,   4.609302633817144e-05,  -2.221363374484642e-07,  -6.225577200880163e-10,
   2.532670153802409e-11,  -2.621770745143962e-13,   8.722316685814036e-16,   1.475404473841703e-17,  -3.100592527681793e-19,   2.264006005188686e-21,  -8.255614436450289e-25,
  -2.572932003029270e-25,   6.499242390132625e-27,   3.877236302181596e-01,  -5.372660625454087e-03,   4.609263923739210e-05,  -2.221101517507535e-07,  -6.229640748210985e-10,
   2.532858962557828e-11,  -2.621343126689407e-13,   8.710778207536855e-16,   1.476456212228508e-17,  -3.100634580750456e-19,   2.262254570137204e-21,  -7.730846837714580e-25,
  -2.569313240935606e-25,   6.504910352753319e-27,   3.877260767685125e-01,  -5.372695975062938e-03,   4.609244040998367e-05,  -2.220967038896935e-07,  -6.231727488242911e-10,
   2.532955892440652e-11,  -2.621123484740842e-13,   8.704852627543686e-16,   1.476996224770047e-17,  -3.100655790331591e-19,   2.261355444193771e-21,  -7.461294778494514e-25,
  -2.567455020342116e-25,   6.507811773177865e-27,   3.877269283119389e-01,  -5.372708278650534e-03,   4.609237120108773e-05,  -2.220920231983320e-07,  -6.232453783535393e-10,
   2.532989624608372e-11,  -2.621047030075429e-13,   8.702790172115211e-16,   1.477184164296270e-17,  -3.100663110954296e-19,   2.261042546078863e-21,  -7.367465370195888e-25,
  -2.566808279664861e-25,   6.508820150790016e-27,   3.877270634401138e-01,  -5.372710231052486e-03,   4.609236021834245e-05,  -2.220912804351697e-07,  -6.232569035945888e-10,
   2.532994977193592e-11,  -2.621034897475154e-13,   8.702462888699197e-16,   1.477213986913991e-17,  -3.100664269713427e-19,   2.260992895873848e-21,  -7.352575491946515e-25,
  -2.566705652256797e-25,   6.508980095775839e-27,   5.760082604773645e-01,  -7.409440111554872e-03,   4.996602228993161e-05,  -2.554032764495566e-08,  -3.676080974300922e-09,
   3.941159020192945e-11,  -3.414242039605699e-14,  -4.174912552677225e-15,   5.018499492986660e-17,  -7.995166391373384e-20,  -6.137374902923823e-21,   7.587424817879873e-23,
  -9.570869795896485e-26,  -5.598627242896617e-27,   5.760129406312675e-01,  -7.409447164872725e-03,   4.996395423702062e-05,  -2.550344849640110e-08,  -3.676127436255704e-09,
   3.940336675108484e-11,  -3.401122015479935e-14,  -4.175172237738674e-15,   5.015908729867021e-17,  -7.956200905724666e-20,  -6.137875327731346e-21,   7.583379723697592e-23,
  -9.372529159457225e-26,  -5.589701740031448e-27,   5.760211986789250e-01,  -7.409459602142569e-03,   4.996030510418741e-05,  -2.543838092671754e-08,  -3.676209269318228e-09,
   3.938885593182847e-11,  -3.377977056120869e-14,  -4.175629388106264e-15,   5.011337123938534e-17,  -7.887462599707554e-20,  -6.138748379626913e-21,   7.576247337460096e-23,
  -9.022751399623021e-26,  -5.573997099864254e-27,   5.760311841297825e-01,  -7.409474627065533e-03,   4.995589249812184e-05,  -2.535971121409648e-08,  -3.676307967374734e-09,
   3.937130859473873e-11,  -3.349999352646080e-14,  -4.176180358488687e-15,   5.005808812507659e-17,  -7.804372317485161e-20,  -6.139787115108590e-21,   7.567631706678903e-23,
  -8.600133707323034e-26,  -5.555082851015543e-27,   5.760408775513476e-01,  -7.409489197967810e-03,   4.995160877925801e-05,  -2.528335121133926e-08,  -3.676403514387369e-09,
   3.935427321271864e-11,  -3.322848956314513e-14,  -4.176713324756024e-15,   5.000441736690528e-17,  -7.723739862208875e-20,  -6.140777741347197e-21,   7.559277126418742e-23,
  -8.190217896591539e-26,  -5.536800790869650e-27,   5.760486862441683e-01,  -7.409500925327093e-03,   4.994815784438069e-05,  -2.522184460568871e-08,  -3.676480294300265e-09,
   3.934054920784758e-11,  -3.300984024927083e-14,  -4.177141309918751e-15,   4.996117886833429e-17,  -7.658804995483904e-20,  -6.141563058025529e-21,   7.552553450185021e-23,
  -7.860249415781657e-26,  -5.522130016303613e-27,   5.760538459906017e-01,  -7.409508669284220e-03,   4.994587751504895e-05,  -2.518120606302694e-08,  -3.676530935342371e-09,
   3.933148037443124e-11,  -3.286539531875331e-14,  -4.177423446404580e-15,   4.993260665143409e-17,  -7.615907758268889e-20,  -6.142075756263795e-21,   7.548113821465306e-23,
  -7.642336921139589e-26,  -5.512463748857162e-27,   5.760564957367637e-01,  -7.409512644546101e-03,   4.994470645279789e-05,  -2.516033744125630e-08,  -3.676556912948848e-09,
   3.932682301562444e-11,  -3.279122664871687e-14,  -4.177568130278988e-15,   4.991793314739576e-17,  -7.593881240865423e-20,  -6.142337126724699e-21,   7.545834865466664e-23,
  -7.530467078076408e-26,  -5.507508292818189e-27,   5.760574180003227e-01,  -7.409514027912809e-03,   4.994429885321597e-05,  -2.515307411967064e-08,  -3.676565950077454e-09,
   3.932520196668485e-11,  -3.276541326946933e-14,  -4.177618455919991e-15,   4.991282585177768e-17,  -7.586215229693494e-20,  -6.142427792753134e-21,   7.545041813957353e-23,
  -7.491535912636610e-26,  -5.505784875688155e-27,   5.760575643506173e-01,  -7.409514247421731e-03,   4.994423417274545e-05,  -2.515192153974522e-08,  -3.676567383926208e-09,
   3.932494472794769e-11,  -3.276131712266013e-14,  -4.177626440343987e-15,   4.991201539201881e-17,  -7.584998763978980e-20,  -6.142442165660504e-21,   7.544915975197925e-23,
  -7.485358365284243e-26,  -5.505511458388658e-27,   7.973671830337262e-01,  -9.215629691624275e-03,   3.910527283901035e-05,   3.378038468812601e-07,  -5.843247702002740e-09,
   5.749154625454114e-12,   6.710679200512648e-13,  -6.327367718803892e-15,  -4.336719562182206e-17,   1.273084556341378e-18,  -5.318585424485665e-21,  -1.652464704400368e-22,
   2.310212914825083e-24,   1.132014955840898e-26,   7.973708425585696e-01,  -9.215534665883396e-03,   3.910199133703960e-05,   3.378091326064634e-07,  -5.842305366892522e-09,
   5.736765587212271e-12,   6.709536287784914e-13,  -6.323093177643087e-15,  -4.338917776096406e-17,   1.272235846677513e-18,  -5.304398965173948e-21,  -1.651610240766032e-22,
   2.307879314102619e-24,   1.136879503042121e-26,   7.973772995983451e-01,  -9.215366990275626e-03,   3.909620150572565e-05,   3.378184499299861e-07,  -5.840642732586046e-09,
   5.714911764948542e-12,   6.707519133898739e-13,  -6.315553008702325e-15,  -4.342791702913667e-17,   1.270738646016578e-18,  -5.279378444226569e-21,  -1.650099661697385e-22,
   2.303764269659462e-24,   1.145442679073690e-26,   7.973851070946398e-01,  -9.215164233106327e-03,   3.908920111389887e-05,   3.378297004758300e-07,  -5.838632480513340e-09,
   5.688497533785352e-12,   6.705079175328095e-13,  -6.306439321509684e-15,  -4.347467819106400e-17,   1.268928831150265e-18,  -5.249143319948990e-21,  -1.648268177353626e-22,
   2.298792789029116e-24,   1.155762605307319e-26,   7.973926860316671e-01,  -9.214967397829179e-03,   3.908240602333732e-05,   3.378406054962821e-07,  -5.836681196267849e-09,
   5.662867245859148e-12,   6.702709674653816e-13,  -6.297596063663759e-15,  -4.351998647142940e-17,   1.267172540495465e-18,  -5.219812471962576e-21,  -1.646485108540003e-22,
   2.293971234486150e-24,   1.165744633318202e-26,   7.973987912057939e-01,  -9.214808828366991e-03,   3.907693253744212e-05,   3.378493783944673e-07,  -5.835109434510524e-09,
   5.642228551338164e-12,   6.700800240860007e-13,  -6.290475024367355e-15,  -4.355642417587247e-17,   1.265758159381494e-18,  -5.196198879857925e-21,  -1.645045048026029e-22,
   2.290090391410788e-24,   1.173759975017807e-26,   7.974028252399240e-01,  -9.214704047746164e-03,   3.907331602508815e-05,   3.378551694733013e-07,  -5.834070924344753e-09,
   5.628595144216035e-12,   6.699538230019692e-13,  -6.285771024466124e-15,  -4.358047118705885e-17,   1.264823788921175e-18,  -5.180602759241580e-21,  -1.644091700762328e-22,
   2.287527630267149e-24,   1.179043620897567e-26,   7.974048968611751e-01,  -9.214650237653508e-03,   3.907145885632955e-05,   3.378581416462574e-07,  -5.833537625046888e-09,
   5.621595059071819e-12,   6.698890037127084e-13,  -6.283355745669993e-15,  -4.359281108634681e-17,   1.264344015365266e-18,  -5.172595668263045e-21,  -1.643601561198362e-22,
   2.286212033330083e-24,   1.181753084315838e-26,   7.974056179002342e-01,  -9.214631508521327e-03,   3.907081246500944e-05,   3.378591758480547e-07,  -5.833352009380556e-09,
   5.619158825739006e-12,   6.698664413340974e-13,  -6.282515157439264e-15,  -4.359710460633859e-17,   1.264177036996244e-18,  -5.169809087165030e-21,  -1.643430876110468e-22,
   2.285754207859106e-24,   1.182695510479997e-26,   7.974057323188375e-01,  -9.214628536464252e-03,   3.907070989223933e-05,   3.378593399478595e-07,  -5.833322554922359e-09,
   5.618772239049792e-12,   6.698628609274033e-13,  -6.282381771066267e-15,  -4.359778585786307e-17,   1.264150540361070e-18,  -5.169366912222927e-21,  -1.643403786583832e-22,
   2.285681561062851e-24,   1.182845030750846e-26,   1.046197494043855e+00,  -1.033112539592411e-02,   9.081858157659156e-06,   7.122619492449416e-07,  -3.081145732230696e-09,
  -8.113447910858105e-11,   7.441991924967818e-13,   9.616458985558998e-15,  -1.661962221731581e-16,  -1.004289084641884e-18,   3.338949854494980e-20,   1.849908441040504e-23,
  -6.525577055417938e-24,   3.341475576149701e-26,   1.046198341999144e+00,  -1.033092533997013e-02,   9.080130892179968e-06,   7.121860444923387e-07,  -3.080104324870143e-09,
  -8.111560060564177e-11,   7.437658071903951e-13,   9.613072283286082e-15,  -1.660566381976855e-16,  -1.004184365466430e-18,   3.334967473898708e-20,   1.873956350734048e-23,
  -6.513617656575121e-24,   3.334449078884605e-26,   1.046199838098661e+00,  -1.033057235541538e-02,   9.077083580068713e-06,   7.120521237326609e-07,  -3.078267239523795e-09,
  -8.108229460908886e-11,   7.430013891052292e-13,   9.607096687943820e-15,  -1.658104761777018e-16,  -1.003998582682286e-18,   3.327946499678065e-20,   1.916347685540946e-23,
  -6.492530504943829e-24,   3.322065017654915e-26,   1.046201646974964e+00,  -1.033014555225559e-02,   9.073399547463768e-06,   7.118902098190611e-07,  -3.076046658926602e-09,
  -8.104202988149747e-11,   7.420775529808689e-13,   9.599871437550514e-15,  -1.655130463552197e-16,  -1.003772221183195e-18,   3.319466886106600e-20,   1.967536900605171e-23,
  -6.467057951181127e-24,   3.307114397459638e-26,   1.046203402767046e+00,  -1.032973125006220e-02,   9.069824000156059e-06,   7.117330522468846e-07,  -3.073891839820847e-09,
  -8.100295125581532e-11,   7.411812388981979e-13,   9.592857819031690e-15,  -1.652245493192762e-16,  -1.003550683164039e-18,   3.311245723180582e-20,   2.017156395132657e-23,
  -6.442357136581389e-24,   3.292625971465349e-26,   1.046204817042877e+00,  -1.032939751575938e-02,   9.066944193031090e-06,   7.116064665277813e-07,  -3.072156577383873e-09,
  -8.097147695487688e-11,   7.404595595192208e-13,   9.587208120231915e-15,  -1.649923136169254e-16,  -1.003370933418536e-18,   3.304630522364917e-20,   2.057076167233441e-23,
  -6.422478188739246e-24,   3.280972403831290e-26,   1.046205751489179e+00,  -1.032917700092482e-02,   9.065041565072719e-06,   7.115228299366046e-07,  -3.071010256145758e-09,
  -8.095068269133784e-11,   7.399828724271108e-13,   9.583475087174636e-15,  -1.648389414274497e-16,  -1.003251530915780e-18,   3.300263064673650e-20,   2.083428488891195e-23,
  -6.409352184805283e-24,   3.273280780632480e-26,   1.046206231346718e+00,  -1.032906375936053e-02,   9.064064566505761e-06,   7.114798813273456e-07,  -3.070421660966452e-09,
  -8.094000489158793e-11,   7.397381282371474e-13,   9.581558054139080e-15,  -1.647602037536156e-16,  -1.003190018181213e-18,   3.298021325226123e-20,   2.096953645322627e-23,
  -6.402614338608963e-24,   3.269333494625021e-26,   1.046206398361493e+00,  -1.032902434513107e-02,   9.063724527841300e-06,   7.114649331134880e-07,  -3.070216810246284e-09,
  -8.093628855268756e-11,   7.396529519237685e-13,   9.580890822491317e-15,  -1.647328025686692e-16,  -1.003168577259825e-18,   3.297241251768277e-20,   2.101659923214134e-23,
  -6.400269644762486e-24,   3.267960039808076e-26,   1.046206424864246e+00,  -1.032901809066103e-02,   9.063670569083037e-06,   7.114625610588449e-07,  -3.070184303980860e-09,
  -8.093569882881847e-11,   7.396394360499352e-13,   9.580784942457757e-15,  -1.647284545765781e-16,  -1.003165173416467e-18,   3.297117473611290e-20,   2.102406684100094e-23,
  -6.399897596701805e-24,   3.267742112048625e-26,   1.312088588895078e+00,  -1.018592853572192e-02,  -3.636330269438114e-05,   7.335447359437481e-07,   6.130305875240861e-09,
  -9.696884694962585e-11,  -1.231506862090794e-12,   1.523517672044897e-14,   2.646898957783375e-16,  -2.677165488850801e-18,  -6.203673439134607e-20,   4.484779710458566e-22,
   1.448333133716131e-23,  -6.918596283263883e-26,   1.312085186744622e+00,  -1.018572254593892e-02,  -3.635986412910711e-05,   7.334540786713093e-07,   6.128582217447650e-09,
  -9.693899539082544e-11,  -1.230817390468516e-12,   1.522620100815596e-14,   2.644310154121901e-16,  -2.674872265291153e-18,  -6.194832569110659e-20,   4.479820263574955e-22,
   1.445719388137029e-23,  -6.900457585507544e-26,   1.312079183857456e+00,  -1.018535909440661e-02,  -3.635379751283224e-05,   7.332941351941598e-07,   6.125541582276016e-09,
  -9.688633618205863e-11,  -1.229601357694106e-12,   1.521036950060944e-14,   2.639745190977931e-16,  -2.670827905012152e-18,  -6.179245791114684e-20,   4.471079970614420e-22,
   1.441113900986476e-23,  -6.868491883239301e-26,   1.312071925546862e+00,  -1.018491964018859e-02,  -3.634646303598180e-05,   7.331007685412464e-07,   6.121866153709240e-09,
  -9.682268454197612e-11,  -1.228131856503858e-12,   1.519123657316358e-14,   2.634230337860806e-16,  -2.665940945700740e-18,  -6.160420366381261e-20,   4.460529392534361e-22,
   1.435555977258915e-23,  -6.829907377192823e-26,   1.312064879770215e+00,  -1.018449306255812e-02,  -3.633934425612192e-05,   7.329130920674752e-07,   6.118299513933451e-09,
  -9.676091821384765e-11,  -1.226706272551021e-12,   1.517267385904397e-14,   2.628882002090777e-16,  -2.661200456941903e-18,  -6.142168266319254e-20,   4.450306193067368e-22,
   1.430172023881682e-23,  -6.792522241788730e-26,   1.312059204117763e+00,  -1.018414944361438e-02,  -3.633361046488510e-05,   7.327619313706093e-07,   6.115427279922630e-09,
  -9.671117838655373e-11,  -1.225558544122920e-12,   1.515772799969267e-14,   2.624577310204278e-16,  -2.657384219626821e-18,  -6.127481283618354e-20,   4.442084200504727e-22,
   1.425843065519220e-23,  -6.762456895084939e-26,   1.312055453911050e+00,  -1.018392239928597e-02,  -3.632982216988305e-05,   7.326620612859650e-07,   6.113529850582756e-09,
  -9.667832016388861e-11,  -1.224800489899078e-12,   1.514785596833742e-14,   2.621734734290950e-16,  -2.654863808896703e-18,  -6.117784541939158e-20,   4.436657948357277e-22,
   1.422986617376228e-23,  -6.742615537783680e-26,   1.312053528050967e+00,  -1.018380580516376e-02,  -3.632787685130475e-05,   7.326107776132007e-07,   6.112555581866076e-09,
  -9.666144866759597e-11,  -1.224411299219876e-12,   1.514278742180799e-14,   2.620275519130508e-16,  -2.653569856376365e-18,  -6.112807321357020e-20,   4.433873377172503e-22,
   1.421520945960743e-23,  -6.732433873679258e-26,   1.312052857745769e+00,  -1.018376522414922e-02,  -3.632719978958264e-05,   7.325929285607819e-07,   6.112216502918851e-09,
  -9.665557683026539e-11,  -1.224275854781655e-12,   1.514102346100489e-14,   2.619767718817065e-16,  -2.653119547850146e-18,  -6.111075355226318e-20,   4.432904510934395e-22,
   1.421011004712927e-23,  -6.728891297703382e-26,   1.312052751377947e+00,  -1.018375878453137e-02,  -3.632709235036194e-05,   7.325900961951922e-07,   6.112162696908675e-09,
  -9.665464507150586e-11,  -1.224254362418902e-12,   1.514074355389198e-14,   2.619687142310055e-16,  -2.653048093102827e-18,  -6.110800535091568e-20,   4.432750780834765e-22,
   1.420930093510112e-23,  -6.728329198814009e-26,   1.576244608159205e+00,  -8.277381711713893e-03,  -7.605648738719226e-05,   7.296152741686955e-08,   1.122071315113731e-08,
   9.330866381445182e-11,  -1.257112406508096e-12,  -3.197487248531011e-14,  -4.439095481912332e-17,   6.905277186860313e-18,   8.000672624169182e-20,  -9.132833987275933e-22,
  -3.016884010255875e-23,  -7.434120213352505e-26,   1.576237490527453e+00,  -8.277360885170428e-03,  -7.605018573505176e-05,   7.304847830905419e-08,   1.121894405364984e-08,
   9.324608186973829e-11,  -1.257222101218428e-12,  -3.195169053338854e-14,  -4.405931908428997e-17,   6.900549516763249e-18,   7.982301826690882e-20,  -9.137694030748415e-22,
  -3.010484118381857e-23,  -7.329145264058240e-26,   1.576224931833179e+00,  -8.277324116615657e-03,  -7.603906717987926e-05,   7.320185694257579e-08,   1.121582233052334e-08,
   9.313569208635551e-11,  -1.257414955074366e-12,  -3.191079859954867e-14,  -4.347477009533278e-17,   6.892205489793090e-18,   7.949918391225927e-20,  -9.146207768712042e-22,
  -2.999197567116891e-23,  -7.144303595897451e-26,   1.576209746542440e+00,  -8.277279621948158e-03,  -7.602562388389784e-05,   7.338724291029244e-08,   1.121204730076477e-08,
   9.300227072725745e-11,  -1.257646956236005e-12,  -3.186137378041561e-14,  -4.276899636820867e-17,   6.882112447047159e-18,   7.910814750723896e-20,  -9.156397309823638e-22,
  -2.985560264957491e-23,  -6.921452497350924e-26,   1.576195005780088e+00,  -8.277236391974283e-03,  -7.601257480974841e-05,   7.356712748082254e-08,   1.120838234926753e-08,
   9.287281368950657e-11,  -1.257870923714634e-12,  -3.181341621534410e-14,  -4.208496209905330e-17,   6.872310803841502e-18,   7.872910925783899e-20,  -9.166179007110428e-22,
  -2.972332439979903e-23,  -6.705804338228723e-26,   1.576183131426225e+00,  -8.277201541168891e-03,  -7.600206368059639e-05,   7.371197932554926e-08,   1.120542975633172e-08,
   9.276857213682575e-11,  -1.258050450454364e-12,  -3.177479884610769e-14,  -4.153471381722752e-17,   6.864412241391396e-18,   7.842417142233619e-20,  -9.173980247025692e-22,
  -2.961684194160689e-23,  -6.532576112285386e-26,   1.576175285364651e+00,  -8.277178499992360e-03,  -7.599511862061734e-05,   7.380766506910805e-08,   1.120347865949644e-08,
   9.269971435610971e-11,  -1.258168638904149e-12,  -3.174928931610188e-14,  -4.117151138902398e-17,   6.859191801146378e-18,   7.822287482198728e-20,  -9.179096657491021e-22,
  -2.954651905353471e-23,  -6.418352184840582e-26,   1.576171256129363e+00,  -8.277166663416075e-03,  -7.599155215678028e-05,   7.385679507012200e-08,   1.120247665444687e-08,
   9.266435975860631e-11,  -1.258229198441789e-12,  -3.173619146939497e-14,  -4.098511068359556e-17,   6.856510482176858e-18,   7.811956149626255e-20,  -9.181712281701098e-22,
  -2.951041690386250e-23,  -6.359767585978096e-26,   1.576169853731888e+00,  -8.277162542977667e-03,  -7.599031084133953e-05,   7.387389375130783e-08,   1.120212789368091e-08,
   9.265205540817403e-11,  -1.258250255116433e-12,  -3.173163304472223e-14,  -4.092025148835672e-17,   6.855577165275594e-18,   7.808361223368949e-20,  -9.182620780664821e-22,
  -2.949785313440521e-23,  -6.339388592247897e-26,   1.576169631191424e+00,  -8.277161889091899e-03,  -7.599011386285965e-05,   7.387660700695153e-08,   1.120207254997345e-08,
   9.265010293138365e-11,  -1.258253595494123e-12,  -3.173090970453508e-14,  -4.090996014237958e-17,   6.855429057925497e-18,   7.807790805013831e-20,  -9.182764857093477e-22,
  -2.949585952812494e-23,  -6.336155292040302e-26,   1.807202560095474e+00,  -4.722452611163278e-03,  -7.304720346120049e-05,  -7.267241478931143e-07,  -1.678757580586540e-09,
   1.009678875693749e-10,   2.205796597089083e-12,   1.934770501012602e-14,  -1.485232227635724e-16,  -7.784234821077899e-18,  -1.190445179123145e-19,  -3.771952641772574e-22,
   2.425509529596940e-23,   6.071143435846789e-25,   1.807195710073461e+00,  -4.722656667332044e-03,  -7.304813028076957e-05,  -7.266291743626567e-07,  -1.675660433045031e-09,
   1.010055595781268e-10,   2.205396468581511e-12,   1.932138772518683e-14,  -1.490205300932379e-16,  -7.786008046258800e-18,  -1.188921434210110e-19,  -3.727791514801942e-22,
   2.430493205697410e-23,   6.066958602025974e-25,   1.807183623033116e+00,  -4.723016705886179e-03,  -7.304976425325854e-05,  -7.264615634873507e-07,  -1.670195928893054e-09,
   1.010719902856242e-10,   2.204689377188644e-12,   1.927494572183068e-14,  -1.498975120795015e-16,  -7.789118441716794e-18,  -1.186230276357152e-19,  -3.649893911151080e-22,
   2.439267928385796e-23,   6.059535684442434e-25,   1.807169007137652e+00,  -4.723452031235783e-03,  -7.305173765732689e-05,  -7.262588379053378e-07,  -1.663588979652447e-09,
   1.011522471417941e-10,   2.203832550921126e-12,   1.921877950766122e-14,  -1.509570729651240e-16,  -7.792848048472987e-18,  -1.182971867287299e-19,  -3.555742762064173e-22,
   2.449845924247713e-23,   6.050493875795596e-25,   1.807154818156768e+00,  -4.723874598675617e-03,  -7.305365087723348e-05,  -7.260619844276740e-07,  -1.657175893481059e-09,
   1.012300838455949e-10,   2.202998870871585e-12,   1.916424593620608e-14,  -1.519847382489946e-16,  -7.796435691642982e-18,  -1.179804236587311e-19,  -3.464388173301569e-22,
   2.460080824765194e-23,   6.041647285661739e-25,   1.807143387610530e+00,  -4.724214985652838e-03,  -7.305519033213907e-05,  -7.259033653103317e-07,  -1.652010187074239e-09,
   1.012927341517886e-10,   2.202325917054271e-12,   1.912030842505509e-14,  -1.528119393830381e-16,  -7.799302216543031e-18,  -1.177249270920403e-19,  -3.390827001778439e-22,
   2.468301535537296e-23,   6.034471242588309e-25,   1.807135834466260e+00,  -4.724439893662505e-03,  -7.305620669026191e-05,  -7.257985347521931e-07,  -1.648597070665139e-09,
   1.013341059505819e-10,   2.201880579458966e-12,   1.909127238739731e-14,  -1.533582095967582e-16,  -7.801184796103377e-18,  -1.175559448541588e-19,  -3.342235254309192e-22,
   2.473721689321535e-23,   6.029705306203643e-25,   1.807131955551997e+00,  -4.724555390467945e-03,  -7.305672836471792e-05,  -7.257446937195311e-07,  -1.646844361938065e-09,
   1.013553441816886e-10,   2.201651672717587e-12,   1.907636009454684e-14,  -1.536386435254565e-16,  -7.802148013533375e-18,  -1.174691166109179e-19,  -3.317286078012995e-22,
   2.476501502868256e-23,   6.027250311355525e-25,   1.807130605458253e+00,  -4.724595589517068e-03,  -7.305690989465822e-05,  -7.257259529756002e-07,  -1.646234329926407e-09,
   1.013627350422645e-10,   2.201571967066266e-12,   1.907116959170355e-14,  -1.537362348856678e-16,  -7.802482700728730e-18,  -1.174388876438216e-19,  -3.308603087571408e-22,
   2.477468454171472e-23,   6.026394641006040e-25,   1.807130391216870e+00,  -4.724601968520644e-03,  -7.305693869888835e-05,  -7.257229790358928e-07,  -1.646137526927194e-09,
   1.013639078083212e-10,   2.201559317331327e-12,   1.907034592361495e-14,  -1.537517205195875e-16,  -7.802535783944530e-18,  -1.174340903622688e-19,  -3.307225254518124e-22,
   2.477621868098717e-23,   6.026258801569422e-25,   1.960676144864261e+00,  -1.114310470818232e-03,  -2.295243275367078e-05,  -4.024965732904280e-07,  -6.235091316578358e-09,
  -8.505316487155853e-11,  -9.789356363948822e-13,  -8.121583707612020e-15,  -4.843573353730439e-18,   1.678673342603158e-18,   4.642794284619637e-20,   8.669852490028673e-22,
   1.253905136112204e-23,   1.326687599042535e-25,   1.960673986021554e+00,  -1.114423954117791e-03,  -2.295594775681887e-05,  -4.025764440430085e-07,  -6.236468037523932e-09,
  -8.506906195509621e-11,  -9.789442462269387e-13,  -8.115800541554371e-15,  -4.645203562805812e-18,   1.683181057349879e-18,   4.650573527942159e-20,   8.679461371842069e-22,
   1.254358810141021e-23,   1.325027341923341e-25,   1.960670176440740e+00,  -1.114624215474404e-03,  -2.296215066487908e-05,  -4.027173893326506e-07,  -6.238897291552349e-09,
  -8.509710329492207e-11,  -9.789590135449956e-13,  -8.105583657832076e-15,  -4.294909943463664e-18,   1.691139009590358e-18,   4.664302358382696e-20,   8.696406375482990e-22,
   1.255154884462423e-23,   1.322086727950349e-25,   1.960665569396394e+00,  -1.114866404833136e-03,  -2.296965236128880e-05,  -4.028878424927637e-07,  -6.241834785232652e-09,
  -8.513099528761426e-11,  -9.789761455213416e-13,  -8.093208148718630e-15,  -3.870875842825971e-18,   1.700768699710467e-18,   4.680907199305832e-20,   8.716879325730900e-22,
   1.256109924858291e-23,   1.318512026529515e-25,   1.960661096477288e+00,  -1.115101550731050e-03,  -2.297693600268894e-05,  -4.030533370463592e-07,  -6.244686467226456e-09,
  -8.516388038495088e-11,  -9.789920174220655e-13,  -8.081172067116894e-15,  -3.458754012277392e-18,   1.710124204943432e-18,   4.697030843266760e-20,   8.736736116250092e-22,
   1.257029110454007e-23,   1.315021979560080e-25,   1.960657492807730e+00,  -1.115291004611531e-03,  -2.298280441509877e-05,  -4.031866727615439e-07,  -6.246983754870664e-09,
  -8.519036024084124e-11,  -9.790042590701639e-13,  -8.071460077990173e-15,  -3.126412305996350e-18,   1.717666012066037e-18,   4.710022658790526e-20,   8.752719554297853e-22,
   1.257763888919422e-23,   1.312196251747607e-25,   1.960655111398593e+00,  -1.115416203820236e-03,  -2.298668255193074e-05,  -4.032747861922582e-07,  -6.248501766256816e-09,
  -8.520785180148368e-11,  -9.790120813657454e-13,  -8.065034791406307e-15,  -2.906639493532045e-18,   1.722652016432364e-18,   4.718608793042418e-20,   8.763274776085694e-22,
   1.258246620416816e-23,   1.310322107507927e-25,   1.960653888378945e+00,  -1.115480503148567e-03,  -2.298867428274461e-05,  -4.033200389942977e-07,  -6.249281339145525e-09,
  -8.521683274261093e-11,  -9.790160159582825e-13,  -8.061732693558184e-15,  -2.793723885219633e-18,   1.725213345056088e-18,   4.723018607539850e-20,   8.768693420427408e-22,
   1.258493660395788e-23,   1.309357493186980e-25,   1.960653462687461e+00,  -1.115502883682867e-03,  -2.298936754231486e-05,  -4.033357900188454e-07,  -6.249552676850363e-09,
  -8.521995835281614e-11,  -9.790173722875834e-13,  -8.060582985112109e-15,  -2.754414334138087e-18,   1.726104962588575e-18,   4.724553551211316e-20,   8.770579115736850e-22,
   1.258579507029707e-23,   1.309021407706495e-25,   1.960653395135691e+00,  -1.115506435192217e-03,  -2.298947755398289e-05,  -4.033382895071919e-07,  -6.249595734417679e-09,
  -8.522045433040643e-11,  -9.790175868944315e-13,  -8.060400524030064e-15,  -2.748176058595786e-18,   1.726246455881035e-18,   4.724797128827638e-20,   8.770878334724178e-22,
   1.258593123160647e-23,   1.308968059301525e-25,   4.530239708582334e-03,  -6.857042780007384e-05,   7.767068688001281e-07,  -7.811298158796407e-09,   7.332911435859873e-11,
  -6.607758852354184e-13,   5.725904385900649e-15,  -4.922325263729481e-17,   3.959466554824872e-19,  -3.485769698053428e-21,   2.507438456700806e-23,  -1.564518007403333e-25,
   4.529345394762625e-27,   5.786098029020063e-29,   4.530312607603102e-03,  -6.857262690842782e-05,   7.767481618733320e-07,  -7.811918451516704e-09,   7.333717871675857e-11,
  -6.608729808255049e-13,   5.726945950172688e-15,  -4.923503762982631e-17,   3.960533504980073e-19,  -3.486560207844570e-21,   2.510272135850857e-23,  -1.560346796336174e-25,
   4.536124340312760e-27,   5.775348826174379e-29,   4.530441242226776e-03,  -6.857650741174938e-05,   7.768210278425657e-07,  -7.813013041859661e-09,   7.335140959548861e-11,
  -6.610443263974461e-13,   5.728784035000049e-15,  -4.925583459204424e-17,   3.962417129976282e-19,  -3.487953332417709e-21,   2.515275575125477e-23,  -1.552993111723826e-25,
   4.548047582644681e-27,   5.756312945028365e-29,   4.530596793967365e-03,  -6.858120000002128e-05,   7.769091444465770e-07,  -7.814336758519688e-09,   7.336861975855369e-11,
  -6.612515514808984e-13,   5.731007056198200e-15,  -4.928098617641428e-17,   3.964696492113230e-19,  -3.489634944493372e-21,   2.521331516608183e-23,  -1.544112039498482e-25,
   4.562399984671025e-27,   5.733177549272636e-29,   4.530747806537879e-03,  -6.858575573712552e-05,   7.769946931134993e-07,  -7.815621932035740e-09,   7.338532921554638e-11,
  -6.614527557139061e-13,   5.733165534640388e-15,  -4.930540674387833e-17,   3.966910999547985e-19,  -3.491264317633149e-21,   2.527216502561307e-23,  -1.535502088518235e-25,
   4.576264679326785e-27,   5.710595847398654e-29,   4.530869464337332e-03,  -6.858942596143444e-05,   7.770636147313081e-07,  -7.816657345906095e-09,   7.339879166209973e-11,
  -6.616148673820518e-13,   5.734904669222717e-15,  -4.932508238725756e-17,   3.968696226871991e-19,  -3.492574695160900e-21,   2.531961645503466e-23,  -1.528574389113831e-25,
   4.587384927456379e-27,   5.692316910630151e-29,   4.530949855620417e-03,  -6.859185126926598e-05,   7.771091592218284e-07,  -7.817341575366180e-09,   7.340768815385111e-11,
  -6.617219997120584e-13,   5.736054001601561e-15,  -4.933808504807012e-17,   3.969876485079790e-19,  -3.493439480904217e-21,   2.535099239692635e-23,  -1.524000794619652e-25,
   4.594709019165030e-27,   5.680195791573692e-29,   4.530991141002118e-03,  -6.859309680840640e-05,   7.771325492123632e-07,  -7.817692974289634e-09,   7.341225715904478e-11,
  -6.617770209475925e-13,   5.736644283077427e-15,  -4.934476295261722e-17,   3.970482793406358e-19,  -3.493883253315491e-21,   2.536711189232274e-23,  -1.521653306926887e-25,
   4.598462879132293e-27,   5.673957820522961e-29,   4.531005510854612e-03,  -6.859353033409218e-05,   7.771406904266677e-07,  -7.817815284188601e-09,   7.341384747992054e-11,
  -6.617961721748613e-13,   5.736849743005264e-15,  -4.934708732466496e-17,   3.970693854708210e-19,  -3.494037658817486e-21,   2.537272345592808e-23,  -1.520836445019569e-25,
   4.599768264665514e-27,   5.671784538116688e-29,   4.531007791156919e-03,  -6.859359912885590e-05,   7.771419823306624e-07,  -7.817834693193597e-09,   7.341409984368717e-11,
  -6.617992112385212e-13,   5.736882347001091e-15,  -4.934745617364016e-17,   3.970727348660810e-19,  -3.494062158302229e-21,   2.537361398245943e-23,  -1.520706829910711e-25,
   4.599975355364913e-27,   5.671439568490693e-29,   4.077843406876709e-02,  -6.117404048515733e-04,   6.783398122252615e-06,  -6.561797568832798e-08,   5.782421650953115e-10,
  -4.735515966535872e-12,   3.551323167072573e-14,  -2.490005134506611e-16,   1.372449654338506e-18,  -8.119011121072426e-21,  -8.972457611727693e-24,   8.396571161563979e-25,
   2.053883278905511e-26,   7.071212001972325e-28,   4.077907066460946e-02,  -6.117588755239996e-04,   6.783723664992708e-06,  -6.562241935156030e-08,   5.782921480752624e-10,
  -4.736006619034752e-12,   3.551683366110822e-14,  -2.490277962224582e-16,   1.372415972076407e-18,  -8.114482616636990e-21,  -8.843108107634001e-24,   8.447799314604044e-25,
   2.058824982944347e-26,   7.062604086551207e-28,   4.078019397285128e-02,  -6.117914683333575e-04,   6.784298113155613e-06,  -6.563026063946313e-08,   5.783803479488805e-10,
  -4.736872426710818e-12,   3.552318936055282e-14,  -2.490759245313328e-16,   1.372356984820846e-18,  -8.106470573717166e-21,  -8.614624215413978e-24,   8.538140182963577e-25,
   2.067509093800842e-26,   7.047352881206977e-28,   4.078155233157458e-02,  -6.118308816412940e-04,   6.784992781019909e-06,  -6.563974304668104e-08,   5.784870072019341e-10,
  -4.737919444970526e-12,   3.553087462280482e-14,  -2.491341003215735e-16,   1.372286417199301e-18,  -8.096745808440796e-21,  -8.337923116116866e-24,   8.647292386094625e-25,
   2.077949322411774e-26,   7.028804749117231e-28,   4.078287104710753e-02,  -6.118691452149524e-04,   6.785667193408382e-06,  -6.564894907171538e-08,   5.785905575134124e-10,
  -4.738935950031964e-12,   3.553833522023683e-14,  -2.491905538319367e-16,   1.372218708379988e-18,  -8.087266953272945e-21,  -8.068872478727396e-24,   8.753161996220924e-25,
   2.088020981311030e-26,   7.010687563342654e-28,   4.078393341900376e-02,  -6.118999711539132e-04,   6.786210520528730e-06,  -6.565636580458330e-08,   5.786739815674498e-10,
  -4.739754889063604e-12,   3.554434529359112e-14,  -2.492360158599271e-16,   1.372164734597464e-18,  -8.079603538943989e-21,  -7.851818926830901e-24,   8.838381987476651e-25,
   2.096089071300601e-26,   6.996013248766184e-28,   4.078463543100397e-02,  -6.119203410225680e-04,   6.786569555743044e-06,  -6.566126688399050e-08,   5.787291092764060e-10,
  -4.740296056689975e-12,   3.554831660068044e-14,  -2.492660484185630e-16,   1.372129349740592e-18,  -8.074526294782153e-21,  -7.708242536852876e-24,   8.894660850240711e-25,
   2.101398045730858e-26,   6.986277942770526e-28,   4.078499595257344e-02,  -6.119308021218909e-04,   6.786753941937273e-06,  -6.566378389528254e-08,   5.787574207906648e-10,
  -4.740573980602711e-12,   3.555035604385450e-14,  -2.492814691159301e-16,   1.372111264577409e-18,  -8.071914745154253e-21,  -7.634462504009518e-24,   8.923552517408281e-25,
   2.104117570428693e-26,   6.981266418899525e-28,   4.078512143617419e-02,  -6.119344432346901e-04,   6.786818119946397e-06,  -6.566465997565643e-08,   5.787672749995053e-10,
  -4.740670715909678e-12,   3.555106588865700e-14,  -2.492868360391945e-16,   1.372104983670049e-18,  -8.071005112112820e-21,  -7.608775263770401e-24,   8.933606897707826e-25,
   2.105063029487049e-26,   6.979520206453370e-28,   4.078514134872985e-02,  -6.119350210306348e-04,   6.786828304146070e-06,  -6.566479899809420e-08,   5.787688387327645e-10,
  -4.740686066534435e-12,   3.555117853115279e-14,  -2.492876876774024e-16,   1.372103987631729e-18,  -8.070860734580876e-21,  -7.604698700236897e-24,   8.935202312019268e-25,
   2.105213008770299e-26,   6.979243016145611e-28,   1.132971391130300e-01,  -1.668245780970290e-03,   1.767310333392705e-05,  -1.564880687898288e-07,   1.174575666730593e-09,
  -7.138162113339066e-12,   2.583801864363403e-14,   8.632253625458231e-17,  -3.549756499170110e-18,   3.765670144847896e-20,  -4.290328558071150e-22,   4.031671137752567e-24,
   6.434785260810409e-26,   1.773996444356896e-27,   1.132987972899469e-01,  -1.668289816719395e-03,   1.767376423585554e-05,  -1.564947593557157e-07,   1.174611890681946e-09,
  -7.137990134518866e-12,   2.582866348040134e-14,   8.645018422527978e-17,  -3.551553381192828e-18,   3.767798744864151e-20,  -4.286267574941983e-22,   4.044487860172396e-24,
   6.452080073162811e-26,   1.771202966382874e-27,   1.133017232196445e-01,  -1.668367520022216e-03,   1.767493042426273e-05,  -1.565065648329486e-07,   1.174675797704738e-09,
  -7.137686470591713e-12,   2.581215232063223e-14,   8.667547985294518e-17,  -3.554722608035114e-18,   3.771560049899662e-20,  -4.279093315766130e-22,   4.067086316514763e-24,
   6.482497881669593e-26,   1.766255643091997e-27,   1.133052613711061e-01,  -1.668461482296290e-03,   1.767634061997323e-05,  -1.565208399177817e-07,   1.174753056496393e-09,
  -7.137318928012944e-12,   2.579218032639870e-14,   8.694801005029166e-17,  -3.558552482294269e-18,   3.776117389085108e-20,  -4.270403511433289e-22,   4.094383803681133e-24,
   6.519110390474682e-26,   1.760242330647930e-27,   1.133086962373689e-01,  -1.668552701978706e-03,   1.767770964311478e-05,  -1.565346976879399e-07,   1.174828038865209e-09,
  -7.136961758578023e-12,   2.577278503146223e-14,   8.721268282776811e-17,  -3.562267953955847e-18,   3.780551128590400e-20,  -4.261952340262119e-22,   4.120853470705839e-24,
   6.554476232053471e-26,   1.754372363915590e-27,   1.133114633854974e-01,  -1.668626189326951e-03,   1.767881253152845e-05,  -1.565458611588278e-07,   1.174888429978047e-09,
  -7.136673765615608e-12,   2.575715554322723e-14,   8.742597522643038e-17,  -3.565259293725787e-18,   3.784129732132207e-20,  -4.255133283952807e-22,   4.142155342269134e-24,
   6.582839752832129e-26,   1.749620467778974e-27,   1.133132918992851e-01,  -1.668674749416408e-03,   1.767954131091141e-05,  -1.565532376989623e-07,   1.174928328636521e-09,
  -7.136483336734504e-12,   2.574682546188002e-14,   8.756695202312611e-17,  -3.567235037722181e-18,   3.786497757187838e-20,  -4.250622047148473e-22,   4.156220564502943e-24,
   6.601519823000792e-26,   1.746469195632885e-27,   1.133142309383787e-01,  -1.668699687642397e-03,   1.767991557720104e-05,  -1.565570258797359e-07,   1.174948816430420e-09,
  -7.136385502721145e-12,   2.574151973063964e-14,   8.763936179768830e-17,  -3.568249404487403e-18,   3.787714886251376e-20,  -4.248303666759544e-22,   4.163440422097706e-24,
   6.611093750275450e-26,   1.744847375028060e-27,   1.133145577810904e-01,  -1.668708367667539e-03,   1.768004584452090e-05,  -1.565583443866785e-07,   1.174955947064137e-09,
  -7.136351444380697e-12,   2.573967290446756e-14,   8.766456650541942e-17,  -3.568602420763071e-18,   3.788138683890344e-20,  -4.247496471672755e-22,   4.165952832664760e-24,
   6.614422989768907e-26,   1.744282330028132e-27,   1.133146096466013e-01,  -1.668709745070226e-03,   1.768006651617472e-05,  -1.565585536153785e-07,   1.174957078581810e-09,
  -7.136346039491269e-12,   2.573937983299570e-14,   8.766856623194936e-17,  -3.568658437525183e-18,   3.788205942558230e-20,  -4.247368368516936e-22,   4.166351492592291e-24,
   6.614951149268985e-26,   1.744192638805449e-27,   2.220726080768878e-01,  -3.173049115876055e-03,   3.110779118734375e-05,  -2.325488850129477e-07,   1.155971818967463e-09,
   4.732597637946566e-14,  -8.676597779343359e-14,   1.167333986212385e-15,  -1.041452409292219e-17,   3.211531365810625e-20,   1.908948561432409e-22,  -5.213577223904517e-24,
   2.450661515245596e-25,   3.063444778830361e-27,   2.220755257304957e-01,  -3.173114519893087e-03,   3.110844072948814e-05,  -2.325488213062658e-07,   1.155849481491061e-09,
   4.962587248464012e-14,  -8.679329806375729e-14,   1.167441700234545e-15,  -1.041366942455659e-17,   3.208929112393681e-20,   1.924267489949944e-22,  -5.191435611382218e-24,
   2.454048322996349e-25,   3.058789870478774e-27,   2.220806740256895e-01,  -3.173229926293870e-03,   3.110958680081481e-05,  -2.325487071413347e-07,   1.155633583858284e-09,
   5.368424748104544e-14,  -8.684150325732356e-14,   1.167631692552557e-15,  -1.041215608100481e-17,   3.204346650233631e-20,   1.951314782086794e-22,  -5.152394552777040e-24,
   2.460003069331363e-25,   3.050539683502818e-27,   2.220868994836493e-01,  -3.173369476918903e-03,   3.111097254700460e-05,  -2.325485661019464e-07,   1.155372464883796e-09,
   5.859197132092350e-14,  -8.689979032484314e-14,   1.167861312800707e-15,  -1.041031714390394e-17,   3.198821260294118e-20,   1.984049231725642e-22,  -5.105233859151741e-24,
   2.467167252801109e-25,   3.040501299161482e-27,   2.220929431388583e-01,  -3.173504950220556e-03,   3.111231770539554e-05,  -2.325484260522052e-07,   1.155118919342126e-09,
   6.335661185380360e-14,  -8.695637107413067e-14,   1.168084098205490e-15,  -1.040852252065764e-17,   3.193473813506709e-20,   2.015857098571576e-22,  -5.059501707406991e-24,
   2.474084053987802e-25,   3.030691249765493e-27,   2.220978118922258e-01,  -3.173614085729250e-03,   3.111340127582768e-05,  -2.325483109864199e-07,   1.154914626399536e-09,
   6.719516433213341e-14,  -8.700194939930157e-14,   1.168263481138425e-15,  -1.040707004622851e-17,   3.189177799114685e-20,   2.041502409354298e-22,  -5.022696891913675e-24,
   2.479628874143428e-25,   3.022741959842782e-27,   2.221010291087231e-01,  -3.173686200518676e-03,   3.111411724476900e-05,  -2.325482338544715e-07,   1.154779613701630e-09,
   6.973171913213995e-14,  -8.703206557130216e-14,   1.168381970136494e-15,  -1.040610697096053e-17,   3.186344853343222e-20,   2.058458779638744e-22,  -4.998394806872485e-24,
   2.483279446082769e-25,   3.017466512595089e-27,   2.221026813129212e-01,  -3.173723234910333e-03,   3.111448491822336e-05,  -2.325481939037888e-07,   1.154710272171892e-09,
   7.103439469409457e-14,  -8.704753130317177e-14,   1.168442806297528e-15,  -1.040561136300480e-17,   3.184891788258568e-20,   2.067169899514349e-22,  -4.985920064761213e-24,
   2.485150062619195e-25,   3.014750307160646e-27,   2.221032563792493e-01,  -3.173736125068975e-03,   3.111461288860803e-05,  -2.325481799445006e-07,   1.154686136254418e-09,
   7.148780815424323e-14,  -8.705291423486354e-14,   1.168463978715125e-15,  -1.040543869927135e-17,   3.184386320263486e-20,   2.070202395474313e-22,  -4.981578999735481e-24,
   2.485800490899589e-25,   3.013803791625423e-27,   2.221033476344280e-01,  -3.173738170559601e-03,   3.111463319566359e-05,  -2.325481777267861e-07,   1.154682306171002e-09,
   7.155975887751112e-14,  -8.705376842923748e-14,   1.168467338383433e-15,  -1.040541129218346e-17,   3.184306122964518e-20,   2.070683635063425e-22,  -4.980890174451218e-24,
   2.485903673724182e-25,   3.013653539711565e-27,   3.669137823091714e-01,  -5.014088527673830e-03,   4.338412064368796e-05,  -2.285346331000837e-07,  -1.739072320833021e-10,
   1.935106874475399e-11,  -2.328172387516723e-13,   1.189497231390814e-15,   5.113515112093265e-18,  -2.223863456597185e-19,   2.078788150038786e-21,  -4.589812980861715e-24,
   1.450502664513261e-25,   9.241585376867027e-27,   3.669178493623821e-01,  -5.014152738939499e-03,   4.338402097400767e-05,  -2.285164719315798e-07,  -1.742344695108634e-10,
   1.935339861458295e-11,  -2.328036339789098e-13,   1.188746140366531e-15,   5.122314476603177e-18,  -2.224074028162307e-19,   2.079702814987712e-21,  -4.522687511404725e-24,
   1.454258401025463e-25,   9.233470102217354e-27,   3.669250257340453e-01,  -5.014266036573553e-03,   4.338384495567380e-05,  -2.284844244914411e-07,  -1.748118694827884e-10,
   1.935750850415355e-11,  -2.327796093460162e-13,   1.187420772556693e-15,   5.137844246055143e-18,  -2.224442775770097e-19,   2.081318606689082e-21,  -4.404292765290279e-24,
   1.460850795734284e-25,   9.219079535028236e-27,   3.669337034661863e-01,  -5.014403030199376e-03,   4.338363185732264e-05,  -2.284456693625931e-07,  -1.755100410551406e-10,
   1.936247617629121e-11,  -2.327505264475936e-13,   1.185818028884533e-15,   5.156628388511201e-18,  -2.224883880771248e-19,   2.083275583473088e-21,  -4.261212752367972e-24,
   1.468763305979759e-25,   9.201557384746306e-27,   3.669421276445569e-01,  -5.014536013821530e-03,   4.338342471799886e-05,  -2.284080433907350e-07,  -1.761877860132601e-10,
   1.936729655934169e-11,  -2.327222596989723e-13,   1.184262014516653e-15,   5.174869347476466e-18,  -2.225307085178311e-19,   2.085178660006505e-21,  -4.122401670774173e-24,
   1.476382783410947e-25,   9.184420813183764e-27,   3.669489140432217e-01,  -5.014643138382653e-03,   4.338325765785768e-05,  -2.283777301309424e-07,  -1.767337485208548e-10,
   1.937117825881980e-11,  -2.326994643138628e-13,   1.183008439436971e-15,   5.189568070702061e-18,  -2.225644422859090e-19,   2.086714091191778e-21,  -4.010640949781814e-24,
   1.482476634863116e-25,   9.170525450881122e-27,   3.669533983697256e-01,  -5.014713921781593e-03,   4.338314717378180e-05,  -2.283576985595287e-07,  -1.770945010138076e-10,
   1.937374246341238e-11,  -2.326843897473577e-13,   1.182180065204687e-15,   5.199282706708649e-18,  -2.225865572212064e-19,   2.087729816927797e-21,  -3.936822740367701e-24,
   1.486481658823520e-25,   9.161299472082136e-27,   3.669557012844555e-01,  -5.014750271638883e-03,   4.338309040594185e-05,  -2.283474110461026e-07,  -1.772797616465512e-10,
   1.937505907220232e-11,  -2.326766445920801e-13,   1.181754644879335e-15,   5.204272250266945e-18,  -2.225978599612898e-19,   2.088251792376625e-21,  -3.898923254813959e-24,
   1.488531725441184e-25,   9.156547845862082e-27,   3.669565028347784e-01,  -5.014762923411447e-03,   4.338307064276159e-05,  -2.283438303282379e-07,  -1.773442428232627e-10,
   1.937551729286068e-11,  -2.326739482396824e-13,   1.181606571767915e-15,   5.206009004237295e-18,  -2.226017853338973e-19,   2.088433526617930e-21,  -3.885733537549350e-24,
   1.489244202602730e-25,   9.154891827982609e-27,   3.669566300297642e-01,  -5.014764931067426e-03,   4.338306750639804e-05,  -2.283432621150350e-07,  -1.773544750750216e-10,
   1.937559000440774e-11,  -2.326735203381482e-13,   1.181583074525161e-15,   5.206284607809387e-18,  -2.226024078258649e-19,   2.088462367991530e-21,  -3.883640584493221e-24,
   1.489357212250084e-25,   9.154628937722464e-27,   5.471666820992395e-01,  -7.011878330853749e-03,   4.933240117266345e-05,  -7.813282027183255e-08,  -2.904591135228670e-09,
   3.736667671870175e-11,  -1.292902938197230e-13,  -2.656003485421668e-15,   4.367560444621880e-17,  -2.605574570529147e-19,  -2.940001771139175e-21,   6.996820404130367e-23,
  -3.249452341973843e-26,   7.907612775350064e-27,   5.471713037208963e-01,  -7.011900182440076e-03,   4.933076632544606e-05,  -7.809783317505982e-08,  -2.904771596956377e-09,
   3.736143390632982e-11,  -1.291759018209159e-13,  -2.656873394584310e-15,   4.366319795958942e-17,  -2.601944881244875e-19,  -2.940119723525261e-21,   7.002483288380401e-23,
  -3.069209755386886e-26,   7.886089768772780e-27,   5.471794585204113e-01,  -7.011938731916115e-03,   4.932788152955919e-05,  -7.803610189173780e-08,  -2.905089893836723e-09,
   3.735218149357477e-11,  -1.289740818153304e-13,  -2.658407365453701e-15,   4.364130618666849e-17,  -2.595537875713104e-19,  -2.940318852642086e-21,   7.012462609836093e-23,
  -2.751777500843479e-26,   7.848014443872474e-27,   5.471893191786512e-01,  -7.011985332728381e-03,   4.932439306334261e-05,  -7.796146258429586e-08,  -2.905474559030621e-09,
   3.734099101191348e-11,  -1.287300840522052e-13,  -2.660260558099393e-15,   4.361483387575123e-17,  -2.587786433023650e-19,  -2.940544317379462e-21,   7.024507631036205e-23,
  -2.368972663842299e-26,   7.801807203542301e-27,   5.471988915124879e-01,  -7.012030557722011e-03,   4.932100637395280e-05,  -7.788901117930662e-08,  -2.905847752060372e-09,
   3.733012501050082e-11,  -1.284932625221890e-13,  -2.662057823272009e-15,   4.358913447044792e-17,  -2.580257258408517e-19,  -2.940747173914001e-21,   7.036177555844155e-23,
  -1.998438803563960e-26,   7.756776451380983e-27,   5.472066027007253e-01,  -7.012066980166168e-03,   4.931827799589677e-05,  -7.783065038797067e-08,  -2.906148224384973e-09,
   3.732136972834833e-11,  -1.283025160498915e-13,  -2.663504399407457e-15,   4.356843099278255e-17,  -2.574188841434484e-19,  -2.940899132556234e-21,   7.045562056508515e-23,
  -1.700719871575657e-26,   7.720376207391879e-27,   5.472116980384871e-01,  -7.012091042463409e-03,   4.931647508082370e-05,  -7.779208912303948e-08,  -2.906346689322100e-09,
   3.731558352629664e-11,  -1.281764907640265e-13,  -2.664459645580359e-15,   4.355475032954317e-17,  -2.570177466297198e-19,  -2.940993940636782e-21,   7.051755006192760e-23,
  -1.504373549921061e-26,   7.696262955393134e-27,   5.472143147140910e-01,  -7.012103398056583e-03,   4.931554918175664e-05,  -7.777228684356755e-08,  -2.906448585260832e-09,
   3.731261176646260e-11,  -1.281117758787381e-13,  -2.664950016700291e-15,   4.354772460217981e-17,  -2.568116977883812e-19,  -2.941040897815456e-21,   7.054932855218229e-23,
  -1.403658150980010e-26,   7.683860925596566e-27,   5.472152254681546e-01,  -7.012107698287529e-03,   4.931522691157450e-05,  -7.776539460226491e-08,  -2.906484047047364e-09,
   3.731157737554422e-11,  -1.280892520868333e-13,  -2.665120664051289e-15,   4.354527922526626e-17,  -2.567399733556770e-19,  -2.941056966209432e-21,   7.056038532107701e-23,
  -1.368621992218106e-26,   7.679541307431893e-27,   5.472153699920990e-01,  -7.012108380663258e-03,   4.931517577161474e-05,  -7.776430090435057e-08,  -2.906489674153276e-09,
   3.731141322992469e-11,  -1.280856779100258e-13,  -2.665147741973080e-15,   4.354489117724367e-17,  -2.567285913320479e-19,  -2.941059502967140e-21,   7.056213968685846e-23,
  -1.363063126842725e-26,   7.678855702185503e-27,   7.611537962247160e-01,  -8.888148172316151e-03,   4.260442602565935e-05,   2.460442884969565e-07,  -5.582195894095046e-09,
   1.961253827576962e-11,   4.809978595913078e-13,  -7.035077988249309e-15,  -2.808178915178378e-18,   9.491931198635356e-19,  -9.996879748346810e-21,  -4.481928888438191e-23,
   2.648981587425305e-24,   4.377487464223629e-27,   7.611577840862539e-01,  -8.888078908165604e-03,   4.260128986406772e-05,   2.460625592436713e-07,  -5.581519590843005e-09,
   1.959873884064767e-11,   4.809896296035277e-13,  -7.031880453065685e-15,  -2.849826332752987e-18,   9.489633171182989e-19,  -9.980493714965350e-21,  -4.478614775956753e-23,
   2.648898805983771e-24,   4.398334463979267e-27,   7.611648204921998e-01,  -8.887956686322886e-03,   4.259575636677801e-05,   2.460947877620279e-07,  -5.580326252843740e-09,
   1.957439463494909e-11,   4.809750190987684e-13,  -7.026238981441746e-15,  -2.923257659989864e-18,   9.485579666241706e-19,  -9.951580826940382e-21,  -4.472754907162500e-23,
   2.648742816352895e-24,   4.434875337813344e-27,   7.611733285828505e-01,  -8.887808887274230e-03,   4.258906572989913e-05,   2.461337409272535e-07,  -5.578883272441391e-09,
   1.954496608154510e-11,   4.809572009971044e-13,  -7.019418326779595e-15,  -3.011955787565427e-18,   9.480680516393778e-19,  -9.916619984237273e-21,  -4.465648617982718e-23,
   2.648537284257698e-24,   4.478645500189779e-27,   7.611815876642128e-01,  -8.887665399093109e-03,   4.258257112747114e-05,   2.461715372407932e-07,  -5.577482469575473e-09,
   1.951640648217031e-11,   4.809397455519341e-13,  -7.012798076702462e-15,  -3.097962056704285e-18,   9.475927015362628e-19,  -9.882681621180556e-21,  -4.458728642209452e-23,
   2.648320061160142e-24,   4.520702475595127e-27,   7.611882407677099e-01,  -8.887549801563210e-03,   4.257733955574385e-05,   2.462019720311514e-07,  -5.576354013625895e-09,
   1.949340578192196e-11,   4.809255705823464e-13,  -7.007465694007851e-15,  -3.167175698334881e-18,   9.472099457366958e-19,  -9.855342077231837e-21,  -4.453138817654117e-23,
   2.648132396613158e-24,   4.554272330092615e-27,   7.611926368706293e-01,  -8.887473414171895e-03,   4.257388282000345e-05,   2.462220762245603e-07,  -5.575608356242333e-09,
   1.947821053163095e-11,   4.809161486729295e-13,  -7.003942544409095e-15,  -3.212875640867462e-18,   9.469571158083988e-19,  -9.837276978112541e-21,  -4.449437763436527e-23,
   2.648002189187695e-24,   4.576302769943755e-27,   7.611948944336376e-01,  -8.887434184786620e-03,   4.257210768069285e-05,   2.462323986569984e-07,  -5.575225427421826e-09,
   1.947040803394864e-11,   4.809112929629431e-13,  -7.002133360308018e-15,  -3.236333862565137e-18,   9.468273028718928e-19,  -9.827999806875818e-21,  -4.447534814817096e-23,
   2.647933403990363e-24,   4.587569515118428e-27,   7.611956801917639e-01,  -8.887420530511706e-03,   4.257148983673423e-05,   2.462359911505279e-07,  -5.575092145845926e-09,
   1.946769246084678e-11,   4.809096001654559e-13,  -7.001503676601635e-15,  -3.244496978482334e-18,   9.467821246437006e-19,  -9.824770822053965e-21,  -4.446872113792614e-23,
   2.647909157463142e-24,   4.591483539941598e-27,   7.611958048804078e-01,  -8.887418363760244e-03,   4.257139179385973e-05,   2.462365612144119e-07,  -5.575070995909992e-09,
   1.946726154428002e-11,   4.809093314125424e-13,  -7.001403755389957e-15,  -3.245792270284585e-18,   9.467749556877964e-19,  -9.824258427567571e-21,  -4.446766935079584e-23,
   2.647905295384962e-24,   4.592104287275882e-27,   1.005071096787974e+00,  -1.022523663890172e-02,   1.728302966348943e-05,   6.510329355607816e-07,  -4.506631609887268e-09,
  -6.066778247181570e-11,   9.353902025876908e-13,   3.973889113909046e-15,  -1.788903777527169e-16,   2.643649595101354e-19,   2.826377072274812e-20,  -2.233046355087244e-22,
  -3.019190044785778e-24,   9.436116619592266e-26,   1.005072711995025e+00,  -1.022505373633657e-02,   1.728050207893249e-05,   6.509761255332924e-07,  -4.505321740515809e-09,
  -6.065994523098030e-11,   9.349230648524021e-13,   3.974752122164655e-15,  -1.787717314382540e-16,   2.632399644328155e-19,   2.824534323952515e-20,  -2.226241975657569e-22,
  -3.013697249591726e-24,   9.418764936120426e-26,   1.005075561861551e+00,  -1.022473101485666e-02,   1.727604271387392e-05,   6.508758893222123e-07,  -4.503010988477849e-09,
  -6.064611492904284e-11,   9.340990458063836e-13,   3.976271846363372e-15,  -1.785624411278142e-16,   2.612577355054155e-19,   2.821285515529288e-20,  -2.214245860004833e-22,
  -3.004016961135458e-24,   9.388145103337547e-26,   1.005079007623725e+00,  -1.022434079871524e-02,   1.727065142088383e-05,   6.507546928153103e-07,  -4.500217711162534e-09,
  -6.062938885234069e-11,   9.331030641874944e-13,   3.978104288182903e-15,  -1.783094723664545e-16,   2.588656469874699e-19,   2.817361706533163e-20,  -2.199757624343385e-22,
  -2.992331645671032e-24,   9.351115040268576e-26,   1.005082352367733e+00,  -1.022396200680264e-02,   1.726541871372577e-05,   6.506370480166167e-07,  -4.497506997265838e-09,
  -6.061314903319210e-11,   9.321366337106864e-13,   3.979877726295892e-15,  -1.780640069722220e-16,   2.565485175440404e-19,   2.813557441405966e-20,  -2.185711123096201e-22,
  -2.981008905851247e-24,   9.315162529751012e-26,   1.005085046604808e+00,  -1.022365687355900e-02,   1.726120407706209e-05,   6.505422825439684e-07,  -4.495323962876598e-09,
  -6.060006470554491e-11,   9.313584131145191e-13,   3.981302474338928e-15,  -1.778663436477186e-16,   2.546854972250793e-19,   2.810496282565160e-20,  -2.174408648208535e-22,
  -2.971902628083277e-24,   9.286196574046445e-26,   1.005086826788624e+00,  -1.022345525507241e-02,   1.725841949433470e-05,   6.504796669523760e-07,  -4.493881786237502e-09,
  -6.059141796392425e-11,   9.308443370357006e-13,   3.982242009645305e-15,  -1.777357705891577e-16,   2.534562223788653e-19,   2.808475239299634e-20,  -2.166946639450659e-22,
  -2.965892796290119e-24,   9.267054897320808e-26,   1.005087740961070e+00,  -1.022335171684512e-02,   1.725698959354743e-05,   6.504475120081367e-07,  -4.493141262680032e-09,
  -6.058697718544903e-11,   9.305803832978481e-13,   3.982723914834935e-15,  -1.776687272387342e-16,   2.528254798774207e-19,   2.807437867240313e-20,  -2.163116540437137e-22,
  -2.962808760228499e-24,   9.257224273972189e-26,   1.005088059141251e+00,  -1.022331567981695e-02,   1.725649192189915e-05,   6.504363203697024e-07,  -4.492883533094974e-09,
  -6.058543148999883e-11,   9.304885195706689e-13,   3.982891552274848e-15,  -1.776453941225530e-16,   2.526060315469127e-19,   2.807076884801072e-20,  -2.161783757734516e-22,
  -2.961735699505094e-24,   9.253802563185948e-26,   1.005088109631784e+00,  -1.022330996125588e-02,   1.725641294913684e-05,   6.504345444195697e-07,  -4.492842635738851e-09,
  -6.058518620743299e-11,   9.304739424320668e-13,   3.982918149562538e-15,  -1.776416915702586e-16,   2.525712122666378e-19,   2.807019605865956e-20,  -2.161572278587493e-22,
  -2.961565436936567e-24,   9.253259581383647e-26,   1.270820958834248e+00,  -1.044011440716934e-02,  -2.704102288431981e-05,   8.146696884763360e-07,   3.934430649315054e-09,
  -1.205538774799941e-10,  -7.039633888715154e-13,   2.173441713335944e-14,   1.301319301448460e-16,  -4.578209575458401e-18,  -2.900354818321693e-20,   9.944198485362019e-22,
   7.234070761738955e-24,  -1.867155357506468e-25,   1.270818428174718e+00,  -1.043988567852110e-02,  -2.703881533453019e-05,   8.145570269146537e-07,   3.933444709062845e-09,
  -1.205113313079512e-10,  -7.036242864205752e-13,   2.171909781085182e-14,   1.300110003393706e-16,  -4.573134000879102e-18,  -2.895907063914634e-20,   9.930819068728823e-22,
   7.227959883515620e-24,  -1.862160217616682e-25,   1.270813962953693e+00,  -1.043948210891568e-02,  -2.703492052808114e-05,   8.143582661671171e-07,   3.931705388662922e-09,
  -1.204362823720429e-10,  -7.030261920167835e-13,   2.169208051362265e-14,   1.297977700946326e-16,  -4.564183650308426e-18,  -2.888062005531789e-20,   9.907240320774827e-22,
   7.217176895710994e-24,  -1.853365000245093e-25,   1.270808563846344e+00,  -1.043899415203993e-02,  -2.703021165347592e-05,   8.141179776949150e-07,   3.929602842981651e-09,
  -1.203455740777585e-10,  -7.023034082078200e-13,   2.165943457945631e-14,   1.295401894154383e-16,  -4.553370297778919e-18,  -2.878580919059101e-20,   9.878778773730890e-22,
   7.204137525149017e-24,  -1.842761715803238e-25,   1.270803322785461e+00,  -1.043852049781517e-02,  -2.702564116252590e-05,   8.138847675390378e-07,   3.927562418007678e-09,
  -1.202575596642502e-10,  -7.016022009333067e-13,   2.162776724565440e-14,   1.292904063207442e-16,  -4.542882827246693e-18,  -2.869382333893539e-20,   9.851201191855238e-22,
   7.191478583793236e-24,  -1.832501669839226e-25,   1.270799100869232e+00,  -1.043813896098786e-02,  -2.702195980969499e-05,   8.136969378246292e-07,   3.925919172369491e-09,
  -1.201866876432487e-10,  -7.010376459543709e-13,   2.160227419443984e-14,   1.290893789651802e-16,  -4.534441375321535e-18,  -2.861976006601571e-20,   9.829022523231454e-22,
   7.181280273462136e-24,  -1.824260229188921e-25,   1.270796311207098e+00,  -1.043788686433474e-02,  -2.701952751893446e-05,   8.135728435389752e-07,   3.924833586818762e-09,
  -1.201398719676317e-10,  -7.006647588345068e-13,   2.158543752305206e-14,   1.289566389528979e-16,  -4.528866896361187e-18,  -2.857083963359106e-20,   9.814385574165808e-22,
   7.174541183946117e-24,  -1.818826127246510e-25,   1.270794878614551e+00,  -1.043775740561519e-02,  -2.701827850832898e-05,   8.135091214451212e-07,   3.924276161487408e-09,
  -1.201158346065807e-10,  -7.004733131536252e-13,   2.157679377109129e-14,   1.288885000668040e-16,  -4.526005210907052e-18,  -2.854572260689384e-20,   9.806874460246087e-22,
   7.171080265131834e-24,  -1.816039069307195e-25,   1.270794379992760e+00,  -1.043771234711417e-02,  -2.701784379261221e-05,   8.134869433832429e-07,   3.924082156401739e-09,
  -1.201074689356067e-10,  -7.004066866415133e-13,   2.157378566135291e-14,   1.288647883933296e-16,  -4.525009346356398e-18,  -2.853698134396767e-20,   9.804261048783681e-22,
   7.169875648572084e-24,  -1.815069583224089e-25,   1.270794300868594e+00,  -1.043770519698821e-02,  -2.701777480987305e-05,   8.134834240775667e-07,   3.924051371031699e-09,
  -1.201061414545666e-10,  -7.003961143071351e-13,   2.157330833604915e-14,   1.288610258999433e-16,  -4.524851324497459e-18,  -2.853559427094380e-20,   9.803846379117284e-22,
   7.169684491934972e-24,  -1.814915766423543e-25,   1.541928203074785e+00,  -8.879149756756551e-03,  -7.404831878019600e-05,   2.654789006673099e-07,   1.271287835647732e-08,
   5.248325167943402e-11,  -2.131102076756380e-12,  -2.890443493727646e-14,   2.482481185068235e-16,   8.879987843619911e-18,   8.867984666914992e-21,  -2.244089298049501e-21,
  -2.041696687909100e-23,   4.821207879083501e-25,   1.541921275379421e+00,  -8.879074919426778e-03,  -7.404118466859886e-05,   2.655276296009594e-07,   1.270988921549853e-08,
   5.242681749592802e-11,  -2.130449746576624e-12,  -2.887476257407835e-14,   2.482816238124234e-16,   8.868553192937302e-18,   8.745840912903301e-21,  -2.240580725952042e-21,
  -2.032624326702205e-23,   4.818181191471234e-25,   1.541909051893527e+00,  -8.878942856719124e-03,  -7.402859778142271e-05,   2.656135697036427e-07,   1.270461557520029e-08,
   5.232728583706732e-11,  -2.129298630548543e-12,  -2.882243649676796e-14,   2.483403291851764e-16,   8.848391262181655e-18,   8.530769793214376e-21,  -2.234391632922516e-21,
  -2.016642451225758e-23,   4.812812058043441e-25,   1.541894272047112e+00,  -8.878783146227105e-03,  -7.401337991011415e-05,   2.657174163263163e-07,   1.269823990502044e-08,
   5.220701178594413e-11,  -2.127906571421540e-12,  -2.875921654278407e-14,   2.484106093468723e-16,   8.824036282869708e-18,   8.271475768314464e-21,  -2.226910860329496e-21,
  -1.997362055249759e-23,   4.806271180233933e-25,   1.541879924994865e+00,  -8.878628082309874e-03,  -7.399860910073818e-05,   2.658181523456524e-07,   1.269205184688086e-08,
   5.209033627762630e-11,  -2.126555062423012e-12,  -2.869789948350988e-14,   2.484780970981633e-16,   8.800419108263050e-18,   8.020565172768683e-21,  -2.219651963680723e-21,
  -1.978692116458000e-23,   4.799870814612971e-25,   1.541868367888800e+00,  -8.878503150699744e-03,  -7.398671167444302e-05,   2.658992491941880e-07,   1.268706778221258e-08,
   5.199640448894161e-11,  -2.125466217410221e-12,  -2.864854319767870e-14,   2.485319358053105e-16,   8.781412199607107e-18,   7.819012654031980e-21,  -2.213806671345266e-21,
  -1.963685594676285e-23,   4.794678622688351e-25,   1.541860731498108e+00,  -8.878420591198906e-03,  -7.397885092172284e-05,   2.659528097348903e-07,   1.268377486843267e-08,
   5.193436563823217e-11,  -2.124746685673205e-12,  -2.861594898878397e-14,   2.485672530571520e-16,   8.768861966232357e-18,   7.686112914077325e-21,  -2.209945375965349e-21,
  -1.953786057537135e-23,   4.791230063815934e-25,   1.541856809950967e+00,  -8.878378190805820e-03,  -7.397481431336205e-05,   2.659803073453271e-07,   1.268208394418745e-08,
   5.190251487196652e-11,  -2.124377158647378e-12,  -2.859921634544344e-14,   2.485853103230074e-16,   8.762419663573900e-18,   7.617949857004465e-21,  -2.207962778645717e-21,
  -1.948707272928733e-23,   4.789453614576507e-25,   1.541855445037267e+00,  -8.878363432620218e-03,  -7.397340937692875e-05,   2.659898768208466e-07,   1.268149542553035e-08,
   5.189143037786669e-11,  -2.124248539308485e-12,  -2.859339335748058e-14,   2.485915826175374e-16,   8.760177813659095e-18,   7.594238975737536e-21,  -2.207272775299850e-21,
  -1.946940367318920e-23,   4.788834438464389e-25,   1.541855228445054e+00,  -8.878361090683252e-03,  -7.397318643486320e-05,   2.659913953021758e-07,   1.268140203681712e-08,
   5.188967149046461e-11,  -2.124228129092425e-12,  -2.859246937514165e-14,   2.485925773414273e-16,   8.759822084434857e-18,   7.590477044945556e-21,  -2.207163284017639e-21,
  -1.946660022270284e-23,   4.788736142615422e-25,   1.787088345650875e+00,  -5.341996598634963e-03,  -8.185262575534178e-05,  -7.343821627060899e-07,   9.098765947938825e-10,
   1.595786286498978e-10,   2.632247376089094e-12,   9.185222150821886e-15,  -5.144475440281611e-16,  -1.241142157841960e-17,  -9.753851938070859e-20,   1.658933534514166e-21,
   6.209286824747306e-23,   7.691436273715789e-25,   1.787080673051916e+00,  -5.342202615711523e-03,  -8.185209315611138e-05,  -7.342324122176457e-07,   9.135621056569689e-10,
   1.595960498951269e-10,   2.630888747160448e-12,   9.143563032382507e-15,  -5.148467261260537e-16,  -1.240265565093026e-17,  -9.715554110716558e-20,   1.664407366599294e-21,
   6.206704711359237e-23,   7.664172971296566e-25,   1.787067134673218e+00,  -5.342566101822964e-03,  -8.185115169473270e-05,  -7.339681620465017e-07,   9.200636911368587e-10,
   1.596267233906504e-10,   2.628490580560316e-12,   9.070079069537090e-15,  -5.155497767563231e-16,  -1.238716524147147e-17,  -9.647990373505348e-20,   1.674049807910671e-21,
   6.202112912495164e-23,   7.616056383017802e-25,   1.787050763994221e+00,  -5.343005574692542e-03,  -8.185001040269629e-05,  -7.336486056509591e-07,   9.279228232890467e-10,
   1.596637006356920e-10,   2.625589253888796e-12,   8.981262794122838e-15,  -5.163976755544771e-16,  -1.236839525632285e-17,  -9.566314519692595e-20,   1.685681888003238e-21,
   6.196499796139419e-23,   7.557856354774447e-25,   1.787034871699168e+00,  -5.343432146167643e-03,  -8.184889945459970e-05,  -7.333383625620063e-07,   9.355495521629123e-10,
   1.596994787108344e-10,   2.622771192769345e-12,   8.895084813115654e-15,  -5.172184583148506e-16,  -1.235013309082664e-17,  -9.487049192172111e-20,   1.696945136648710e-21,
   6.190987241882596e-23,   7.501339322339537e-25,   1.787022069128002e+00,  -5.343775742764118e-03,  -8.184800233910418e-05,  -7.330884181211370e-07,   9.416915528999697e-10,
   1.597282159712363e-10,   2.620499923915442e-12,   8.825692030482172e-15,  -5.178779919752197e-16,  -1.233539228796157e-17,  -9.423211508076719e-20,   1.705997900511445e-21,
   6.186501009348673e-23,   7.455797630208270e-25,   1.787013609444032e+00,  -5.344002763809918e-03,  -8.184740848856996e-05,  -7.329232511509245e-07,   9.457491015762523e-10,
   1.597471633875432e-10,   2.618998584038082e-12,   8.779853748037004e-15,  -5.183129784669556e-16,  -1.232563762627592e-17,  -9.381037283579379e-20,   1.711969638213906e-21,
   6.183514387708719e-23,   7.425698546311897e-25,   1.787009264999886e+00,  -5.344119343341343e-03,  -8.184710319241862e-05,  -7.328384274952298e-07,   9.478325450820758e-10,
   1.597568809127784e-10,   2.618227411689669e-12,   8.756318310686586e-15,  -5.185361107809644e-16,  -1.232062375234199e-17,  -9.359381464193664e-20,   1.715033266609708e-21,
   6.181973754710045e-23,   7.410239405071426e-25,   1.787007752877646e+00,  -5.344159918858042e-03,  -8.184699687948268e-05,  -7.328089034451534e-07,   9.485576586087083e-10,
   1.597602611361552e-10,   2.617958972237004e-12,   8.748127336948287e-15,  -5.186137335813321e-16,  -1.231887792928315e-17,  -9.351844382708252e-20,   1.716099089870026e-21,
   6.181436431664022e-23,   7.404858420931499e-25,   1.787007512924734e+00,  -5.344166357583556e-03,  -8.184698000662417e-05,  -7.328042183660376e-07,   9.486727218570508e-10,
   1.597607974337225e-10,   2.617916373365741e-12,   8.746827577871086e-15,  -5.186260493307044e-16,  -1.231860085806252e-17,  -9.350648371861134e-20,   1.716268197574243e-21,
   6.181351114083590e-23,   7.404004519193209e-25,   1.955818498682392e+00,  -1.319083669779625e-03,  -2.844144068490203e-05,  -5.172198484339154e-07,  -8.189319248757755e-09,
  -1.112232745268389e-10,  -1.196380816391601e-12,  -6.864987087092200e-15,   1.000093236101746e-16,   4.501219231934292e-18,   1.003285017707766e-19,   1.639181984711788e-21,
   1.947766044297426e-23,   1.107473666208088e-25,   1.955815823036053e+00,  -1.319229505271982e-03,  -2.844605664458931e-05,  -5.173242313736727e-07,  -8.190998433149921e-09,
  -1.112365442867551e-10,  -1.196109459861036e-12,  -6.849574293667829e-15,   1.004364262853276e-16,   4.509700641667545e-18,   1.004481491767890e-19,   1.639944810240924e-21,
   1.945908045806716e-23,   1.098992741073760e-25,   1.955811101462970e+00,  -1.319486858183568e-03,  -2.845420234534846e-05,  -5.175084267539713e-07,  -8.193961066752128e-09,
  -1.112599342084433e-10,  -1.195629733163466e-12,  -6.822354883312233e-15,   1.011904652880813e-16,   4.524669372236216e-18,   1.006591739054599e-19,   1.641285749800088e-21,
   1.942615675105511e-23,   1.084001239827092e-25,   1.955805391484371e+00,  -1.319798092811824e-03,  -2.846405352190706e-05,  -5.177311748836030e-07,  -8.197542979400968e-09,
  -1.112881752768065e-10,  -1.195048083760060e-12,  -6.789401157599340e-15,   1.021029555064636e-16,   4.542775076985042e-18,   1.009141847966758e-19,   1.642898558773798e-21,
   1.938610782711727e-23,   1.065827695389029e-25,   1.955799847705549e+00,  -1.320100276663775e-03,  -2.847361824336047e-05,  -5.179474328105651e-07,  -8.201019676452032e-09,
  -1.113155469146924e-10,  -1.194481795511449e-12,  -6.757368645172577e-15,   1.029895160750720e-16,   4.560357371604324e-18,   1.011615742105976e-19,   1.644455153303479e-21,
   1.934698039340786e-23,   1.048137308962343e-25,   1.955795381257680e+00,  -1.320343742614032e-03,  -2.848132443993013e-05,  -5.181216601967592e-07,  -8.203820055250173e-09,
  -1.113375653846885e-10,  -1.194024430431263e-12,  -6.731533853958643e-15,   1.037042411949885e-16,   4.574525431425561e-18,   1.013607451347793e-19,   1.645702601050173e-21,
   1.931528154916631e-23,   1.033851892093215e-25,   1.955792429687294e+00,  -1.320504635544706e-03,  -2.848641703780297e-05,  -5.182367928184782e-07,  -8.205670298027867e-09,
  -1.113520992348862e-10,  -1.193721638344553e-12,  -6.714448083440908e-15,   1.041767750371264e-16,   4.583889382183942e-18,   1.014922934470897e-19,   1.646523693736057e-21,
   1.929424816082944e-23,   1.024395560483751e-25,   1.955790913846262e+00,  -1.320587266392146e-03,  -2.848903247906175e-05,  -5.182959208662635e-07,  -8.206620425045934e-09,
  -1.113595582475464e-10,  -1.193565962747729e-12,  -6.705669206899641e-15,   1.044195229943353e-16,   4.588698820625312e-18,   1.015598311184944e-19,   1.646944374088306e-21,
   1.928341948083937e-23,   1.019534091057861e-25,   1.955790386233017e+00,  -1.320616027552277e-03,  -2.848994283099668e-05,  -5.183165012331584e-07,  -8.206951115710820e-09,
  -1.113621536585058e-10,  -1.193511750188604e-12,  -6.702612919554453e-15,   1.045040262541219e-16,   4.590372885405080e-18,   1.015833352461113e-19,   1.647090638048105e-21,
   1.927964615546477e-23,   1.017841185697994e-25,   1.955790302507545e+00,  -1.320620591587270e-03,  -2.849008729243406e-05,  -5.183197670685853e-07,  -8.207003591302273e-09,
  -1.113625654780789e-10,  -1.193503146061275e-12,  -6.702127894711980e-15,   1.045174363562702e-16,   4.590638540970535e-18,   1.015870648860455e-19,   1.647113840636597e-21,
   1.927904717634043e-23,   1.017572505699383e-25,   4.267818541196707e-03,  -6.271272773850087e-05,   6.895977385143486e-07,  -6.736734157161269e-09,   6.138310713837585e-11,
  -5.385707354354382e-13,   4.507495422262926e-15,  -3.837633923818551e-17,   2.875242377891730e-19,  -2.544332956807281e-21,   2.420009925369087e-23,   1.464335802387450e-25,
   8.180114947622638e-27,   6.582374977613593e-29,   4.267883260243587e-03,  -6.271462422210528e-05,   6.896323022793627e-07,  -6.737239702749902e-09,   6.138945474574060e-11,
  -5.386464249273212e-13,   4.508252318629473e-15,  -3.838490613966724e-17,   2.876279436147068e-19,  -2.543560477972995e-21,   2.425029552202306e-23,   1.468860969895405e-25,
   8.171173304560438e-27,   6.530106866033434e-29,   4.267997460660372e-03,  -6.271797071301822e-05,   6.896932934923642e-07,  -6.738131803639439e-09,   6.140065606515996e-11,
  -5.387799939306950e-13,   4.509588096494548e-15,  -3.840002044002282e-17,   2.878111059740333e-19,  -2.542195559435199e-21,   2.433882203408233e-23,   1.476814664610591e-25,
   8.155340035792417e-27,   6.437907868347489e-29,   4.268135557526838e-03,  -6.272201752297251e-05,   6.897670496738481e-07,  -6.739210640034571e-09,   6.141420229768451e-11,
  -5.389415303612079e-13,   4.511203712684537e-15,  -3.841829317465531e-17,   2.880328806790859e-19,  -2.540541910046266e-21,   2.444579130768365e-23,   1.486379452713228e-25,
   8.136099628220377e-27,   6.326469385099185e-29,   4.268269624289333e-03,  -6.272594630273923e-05,   6.898386560873583e-07,  -6.740258058856087e-09,   6.142735429307945e-11,
  -5.390983715958618e-13,   4.512772522459280e-15,  -3.843602821414883e-17,   2.882484822273741e-19,  -2.538933262051551e-21,   2.454955337563331e-23,   1.495609397630613e-25,
   8.117322449829883e-27,   6.218339007811773e-29,   4.268377630108170e-03,  -6.272911142474607e-05,   6.898963450012158e-07,  -6.741101919732087e-09,   6.143795047836302e-11,
  -5.392247383812333e-13,   4.514036620276888e-15,  -3.845031259479775e-17,   2.884223875421836e-19,  -2.537634989832756e-21,   2.463308393100215e-23,   1.503005248314223e-25,
   8.102125056254701e-27,   6.131268179356137e-29,   4.268449000083449e-03,  -6.273120295351015e-05,   6.899344666285074e-07,  -6.741659564149566e-09,   6.144495279181130e-11,
  -5.393082478824088e-13,   4.514872053262097e-15,  -3.845975011793359e-17,   2.885374085153669e-19,  -2.536775959299920e-21,   2.468825056650873e-23,   1.507872874168439e-25,
   8.092048306478665e-27,   6.073751822445897e-29,   4.268485652492287e-03,  -6.273227707603674e-05,   6.899540444712662e-07,  -6.741945952430879e-09,   6.144854898274977e-11,
  -5.393511366604775e-13,   4.515301131286539e-15,  -3.846459632260939e-17,   2.885965105067908e-19,  -2.536334449395445e-21,   2.471657233125687e-23,   1.510366627912450e-25,
   8.086862729917893e-27,   6.044220159470161e-29,   4.268498409780285e-03,  -6.273265093778961e-05,   6.899608588083737e-07,  -6.742045634276468e-09,   6.144980069667542e-11,
  -5.393660649148616e-13,   4.515450482703544e-15,  -3.846628302243101e-17,   2.886170867837692e-19,  -2.536180721116438e-21,   2.472642855592152e-23,   1.511233645813322e-25,
   8.085056142734741e-27,   6.033942308925415e-29,   4.268500434190061e-03,  -6.273271026467041e-05,   6.899619401540798e-07,  -6.742061452497101e-09,   6.144999932770582e-11,
  -5.393684338432900e-13,   4.515474183043230e-15,  -3.846655067532481e-17,   2.886203522065500e-19,  -2.536156323864604e-21,   2.472799253536161e-23,   1.511371184234132e-25,
   8.084769381556700e-27,   6.032311399073497e-29,   3.843523277324713e-02,  -5.604725093720326e-04,   6.048511959563885e-06,  -5.707975901239103e-08,   4.915147883909062e-10,
  -3.962170156496126e-12,   2.911216905038095e-14,  -2.097326189149764e-16,   1.086281433250488e-18,  -7.307597623869180e-21,   6.380253558429720e-23,   2.799116199746511e-24,
   6.137312635405607e-26,   7.161679732361876e-28,   3.843580037561228e-02,  -5.604885761195689e-04,   6.048788667385558e-06,  -5.708347701490118e-08,   4.915557610980975e-10,
  -3.962583452143365e-12,   2.911502637822991e-14,  -2.097569000081135e-16,   1.086562654904933e-18,  -7.292972589535089e-21,   6.417812014915251e-23,   2.804094227450764e-24,
   6.128407898521664e-26,   7.114714858987557e-28,   3.843680194004813e-02,  -5.605169269995356e-04,   6.049276941442755e-06,  -5.709003780404869e-08,   4.916280613546603e-10,
  -3.963312757501537e-12,   2.912006878571278e-14,  -2.097997041097973e-16,   1.087060159465585e-18,  -7.267145883004750e-21,   6.484039142216411e-23,   2.812850150730433e-24,
   6.112644076330439e-26,   7.031871140865567e-28,   3.843801307850015e-02,  -5.605512106378966e-04,   6.049867399625825e-06,  -5.709797171789560e-08,   4.917154931737646e-10,
  -3.964194707252939e-12,   2.912616715650224e-14,  -2.098513945862694e-16,   1.087663936448438e-18,  -7.235880903052544e-21,   6.564044173715233e-23,   2.823390371577009e-24,
   6.093495005772655e-26,   6.931741104604877e-28,   3.843918886848139e-02,  -5.605844941205149e-04,   6.050440639695577e-06,  -5.710567438702463e-08,   4.918003763104546e-10,
  -3.965050957779431e-12,   2.913208843845158e-14,  -2.099015028145251e-16,   1.088252363778954e-18,  -7.205492799273699e-21,   6.641630272729203e-23,   2.833572871239560e-24,
   6.074814187938874e-26,   6.834584498044883e-28,   3.844013609663920e-02,  -5.606113079503673e-04,   6.050902458435073e-06,  -5.711187996044341e-08,   4.918687612464113e-10,
  -3.965740791448741e-12,   2.913685932824477e-14,  -2.099418177354711e-16,   1.088728033771122e-18,  -7.180986384468846e-21,   6.704074144035557e-23,   2.841740114552993e-24,
   6.059699920819724e-26,   6.756350916510122e-28,   3.844076202137137e-02,  -5.606290265847319e-04,   6.051207631779674e-06,  -5.711598069030336e-08,   4.919139508430828e-10,
  -3.966196645410381e-12,   2.914001223082670e-14,  -2.099684318305638e-16,   1.089043150911351e-18,  -7.164780205676284e-21,   6.745307244284001e-23,   2.847119434240423e-24,
   6.049680787550470e-26,   6.704672539653326e-28,   3.844108346776535e-02,  -5.606381261162064e-04,   6.051364356527564e-06,  -5.711808667237738e-08,   4.919371584969964e-10,
  -3.966430755700365e-12,   2.914163151593915e-14,  -2.099820916188003e-16,   1.089205226856068e-18,  -7.156453612380088e-21,   6.766473525673883e-23,   2.849876576825222e-24,
   6.044525630108155e-26,   6.678138488624752e-28,   3.844119535077836e-02,  -5.606412933177233e-04,   6.051418906589764e-06,  -5.711881968844811e-08,   4.919452362343723e-10,
  -3.966512241119458e-12,   2.914219514187366e-14,  -2.099868447874888e-16,   1.089261678381652e-18,  -7.153554837824308e-21,   6.773839227477117e-23,   2.850835366662298e-24,
   6.042729762670315e-26,   6.668903909385133e-28,   3.844121310510259e-02,  -5.606417959102311e-04,   6.051427562960820e-06,  -5.711893600846489e-08,   4.919465180648355e-10,
  -3.966525171789660e-12,   2.914228458244564e-14,  -2.099875989907552e-16,   1.089270638336760e-18,  -7.153094812446252e-21,   6.775007995651828e-23,   2.850987472632058e-24,
   6.042444708837268e-26,   6.667438548758656e-28,   1.068954695611060e-01,  -1.534063524931740e-03,   1.590340544755879e-05,  -1.388026654712701e-07,   1.038147905969844e-09,
  -6.500737211832745e-12,   2.684728231370601e-14,  -8.475538774369473e-18,  -2.449336282149694e-18,   2.531737623191388e-20,  -1.469465537542083e-22,   9.670332345453351e-24,
   1.727359418493402e-25,   1.959906985162050e-27,   1.068969616751359e-01,  -1.534102584571920e-03,   1.590398961724720e-05,  -1.388087600277460e-07,   1.038185583691489e-09,
  -6.500752515006729e-12,   2.684084081978162e-14,  -8.388777266888309e-18,  -2.449922256804012e-18,   2.536776264544200e-20,  -1.458887850310143e-22,   9.683913138028973e-24,
   1.724999716467683e-25,   1.946286431414498e-27,   1.068995945784052e-01,  -1.534171507316120e-03,   1.590502041108057e-05,  -1.388195139799247e-07,   1.038252059255922e-09,
  -6.500779378178586e-12,   2.682947347226335e-14,  -8.235546582563438e-18,  -2.450952600086260e-18,   2.545672642841681e-20,  -1.440235385770606e-22,   9.707795784224593e-24,
   1.720821413300798e-25,   1.922260056275585e-27,   1.069027783892008e-01,  -1.534254851812784e-03,   1.590626688737078e-05,  -1.388325177931652e-07,   1.038332429654452e-09,
  -6.500811623368558e-12,   2.681572586195271e-14,  -8.050021905411642e-18,  -2.452192335685364e-18,   2.556439791699309e-20,  -1.417701190154181e-22,   9.736537065165475e-24,
   1.715744157911792e-25,   1.893219628005907e-27,   1.069058692572299e-01,  -1.534335763697648e-03,   1.590747697573348e-05,  -1.388451416901497e-07,   1.038410438687782e-09,
  -6.500842676968539e-12,   2.680237773559668e-14,  -7.869669970177999e-18,  -2.453389395681881e-18,   2.566902327808357e-20,  -1.395846981015984e-22,   9.764294265761087e-24,
   1.710789319610172e-25,   1.865040876027564e-27,   1.069083592773682e-01,  -1.534400947044117e-03,   1.590845182921715e-05,  -1.388553113517939e-07,   1.038473272321817e-09,
  -6.500867514461682e-12,   2.679162309833307e-14,  -7.724203161974805e-18,  -2.454349110049900e-18,   2.575337936579483e-20,  -1.378257033996139e-22,   9.786551715718070e-24,
   1.706779225548851e-25,   1.842349949653859e-27,   1.069100046662511e-01,  -1.534444019911886e-03,   1.590909600582114e-05,  -1.388620312900684e-07,   1.038514787050947e-09,
  -6.500883838993356e-12,   2.678451586358621e-14,  -7.627994274098650e-18,  -2.454981010390798e-18,   2.580915517111889e-20,  -1.366641527274435e-22,   9.801208430817366e-24,
   1.704120363144744e-25,   1.827360868920680e-27,   1.069108496608103e-01,  -1.534466140160623e-03,   1.590942682466624e-05,  -1.388654823020769e-07,   1.038536105422871e-09,
  -6.500892195305772e-12,   2.678086572321809e-14,  -7.578559489311450e-18,  -2.455304822185478e-18,   2.583780946184377e-20,  -1.360678768242579e-22,   9.808719705669772e-24,
   1.702752110110214e-25,   1.819664710732339e-27,   1.069111437702801e-01,  -1.534473839358779e-03,   1.590954196972594e-05,  -1.388666834587544e-07,   1.038543525250118e-09,
  -6.500895099478926e-12,   2.677959522101908e-14,  -7.561348973748744e-18,  -2.455417416541731e-18,   2.584778455930563e-20,  -1.358603751326562e-22,   9.811331582434528e-24,
   1.702275431625083e-25,   1.816986223985661e-27,   1.069111904414678e-01,  -1.534475061117533e-03,   1.590956024168632e-05,  -1.388668740657928e-07,   1.038544702663723e-09,
  -6.500895560126203e-12,   2.677939360804218e-14,  -7.558617698470907e-18,  -2.455435278431815e-18,   2.584936755100093e-20,  -1.358274492575068e-22,   9.811745933042977e-24,
   1.702199768171227e-25,   1.816561196030825e-27,   2.098609056832275e-01,  -2.935035319198977e-03,   2.842787136194138e-05,  -2.141484569581726e-07,   1.138552092159344e-09,
  -1.679378137210052e-12,  -5.856348951599046e-14,   8.538254214152571e-16,  -9.140042286063559e-18,   3.926590365375704e-20,   2.849323476044974e-22,   1.105349659914269e-23,
   4.375068421564168e-25,   3.486248115095782e-27,   2.098635720756297e-01,  -2.935095553827050e-03,   2.842851132961947e-05,  -2.141500172188597e-07,   1.138469454039649e-09,
  -1.677695036293409e-12,  -5.858745521076956e-14,   8.539594570137941e-16,  -9.138753994790959e-18,   3.932382174105233e-20,   2.876177662221605e-22,   1.107747098994924e-23,
   4.370440966179496e-25,   3.458702420405734e-27,   2.098682770157634e-01,  -2.935201839131788e-03,   2.842964052481394e-05,  -2.141527690399255e-07,   1.138323610386235e-09,
  -1.674724962918025e-12,  -5.862974025522822e-14,   8.541961245339912e-16,  -9.136471593109237e-18,   3.942611806537815e-20,   2.923538680463528e-22,   1.111961062647707e-23,
   4.362245115764476e-25,   3.410112928161021e-27,   2.098739663628381e-01,  -2.935330361064554e-03,   2.843100589517704e-05,  -2.141560943828381e-07,   1.138147207980231e-09,
  -1.671133151127275e-12,  -5.868086699343661e-14,   8.544825777400105e-16,  -9.133696021992491e-18,   3.954998411936389e-20,   2.980767757923790e-22,   1.117028751672819e-23,
   4.352282456101163e-25,   3.351384248224568e-27,   2.098794895696149e-01,  -2.935455128567225e-03,   2.843233130550394e-05,  -2.141593202762331e-07,   1.137975910674930e-09,
  -1.667645897524735e-12,  -5.873049491341771e-14,   8.547609469507296e-16,  -9.130985146822699e-18,   3.967040672692902e-20,   3.036282344795155e-22,   1.121919188018781e-23,
   4.342556371583327e-25,   3.294399123201935e-27,   2.098839390555878e-01,  -2.935555640099702e-03,   2.843339899039374e-05,  -2.141619173717307e-07,   1.137837880756493e-09,
  -1.664836335440903e-12,  -5.877047090257223e-14,   8.549854022176244e-16,  -9.128789556426567e-18,   3.976754299868998e-20,   3.080973692510045e-22,   1.125837952269793e-23,
   4.334682183431109e-25,   3.248512585181587e-27,   2.098868792272165e-01,  -2.935622056552471e-03,   2.843410447383163e-05,  -2.141636326820300e-07,   1.137746655891088e-09,
  -1.662979691698717e-12,  -5.879688454782765e-14,   8.551338185283813e-16,  -9.127333000974636e-18,   3.983179013824433e-20,   3.110489976356249e-22,   1.128417167251912e-23,
   4.329460003563274e-25,   3.218201388134627e-27,   2.098883891554816e-01,  -2.935656164647722e-03,   2.843446676599772e-05,  -2.141645133272469e-07,   1.137699802252826e-09,
  -1.662026174484445e-12,  -5.881044866815992e-14,   8.552100684286396e-16,  -9.126583212737229e-18,   3.986480301556661e-20,   3.125643365003918e-22,   1.129738552901222e-23,
   4.326772277181074e-25,   3.202638182080898e-27,   2.098889147013464e-01,  -2.935668036293585e-03,   2.843459286393603e-05,  -2.141648198042858e-07,   1.137683493570419e-09,
  -1.661694287427672e-12,  -5.881516969674877e-14,   8.552366128448959e-16,  -9.126321959162091e-18,   3.987629645504673e-20,   3.130916902009681e-22,   1.130197969504347e-23,
   4.325835852717648e-25,   3.197221751199848e-27,   2.098889980983087e-01,  -2.935669920160805e-03,   2.843461287388675e-05,  -2.141648684360913e-07,   1.137680905567036e-09,
  -1.661641621206472e-12,  -5.881591885480100e-14,   8.552408253127326e-16,  -9.126280488387752e-18,   3.987812044820354e-20,   3.131753704621836e-22,   1.130270848677214e-23,
   4.325687210595871e-25,   3.196362261282398e-27,   3.475341750809898e-01,  -4.678005029224043e-03,   4.063682978408776e-05,  -2.285130039750868e-07,   1.600020229150189e-10,
   1.417478638788565e-11,  -1.983109742178387e-13,   1.240883572363263e-15,  -1.412588134361317e-18,  -1.394381263610905e-19,   2.207829287018135e-21,   1.451170942271572e-23,
   6.475799228849900e-25,   8.637486337176056e-27,   3.475379849537862e-01,  -4.678069251496179e-03,   4.063691821064541e-05,  -2.284996946688892e-07,   1.597231074191554e-10,
   1.417722192378481e-11,  -1.983144868769505e-13,   1.240414990389939e-15,  -1.403146764105290e-18,  -1.393609603535301e-19,   2.211789789812265e-21,   1.457226049626280e-23,
   6.465866531990188e-25,   8.590145536726180e-27,   3.475447075409249e-01,  -4.678182569660576e-03,   4.063707411313813e-05,  -2.284762083343208e-07,   1.592309526925193e-10,
   1.418151871624638e-11,  -1.983206647931710e-13,   1.239588383560164e-15,  -1.386473774580990e-18,  -1.392245485574245e-19,   2.218773103296279e-21,   1.467882268814982e-23,
   6.448286236505150e-25,   8.506635057228617e-27,   3.475528365764599e-01,  -4.678319590003270e-03,   4.063726241459754e-05,  -2.284478052460928e-07,   1.586358272255575e-10,
   1.418671316681804e-11,  -1.983281006886346e-13,   1.238589206140616e-15,  -1.366289537216315e-18,  -1.390591705108497e-19,   2.227208761190936e-21,   1.480719957501141e-23,
   6.426936205540264e-25,   8.405692930831462e-27,   3.475607281153102e-01,  -4.678452601542299e-03,   4.063744498662889e-05,  -2.284202287094728e-07,   1.580580827142183e-10,
   1.419175451278441e-11,  -1.983352831668099e-13,   1.237619604181369e-15,  -1.346670874804492e-18,  -1.388981777786518e-19,   2.235388881218759e-21,   1.493132388715250e-23,
   6.406114072639549e-25,   8.307741872264056e-27,   3.475670854448810e-01,  -4.678559750011975e-03,   4.063759190108849e-05,  -2.283980110387692e-07,   1.575926542409433e-10,
   1.419581479798375e-11,  -1.983410433512443e-13,   1.236838779705867e-15,  -1.330849039909485e-18,  -1.387681648743758e-19,   2.241972163872071e-21,   1.503095740556097e-23,
   6.389271458412803e-25,   8.228863942975073e-27,   3.475712862591692e-01,  -4.678630549904077e-03,   4.063768889964138e-05,  -2.283833288367892e-07,   1.572851049506647e-10,
   1.419849729335597e-11,  -1.983448368769960e-13,   1.236322959253616e-15,  -1.320385789250055e-18,  -1.386820986414209e-19,   2.246319082844457e-21,   1.509661751660547e-23,
   6.378108636148329e-25,   8.176757670039161e-27,   3.475734435795936e-01,  -4.678666908446270e-03,   4.063773868832810e-05,  -2.283757884645432e-07,   1.571271629190540e-10,
   1.419987473813345e-11,  -1.983467811043972e-13,   1.236058102386659e-15,  -1.315009792744226e-18,  -1.386378513238616e-19,   2.248550443625786e-21,   1.513028272088872e-23,
   6.372365636884876e-25,   8.150003218779388e-27,   3.475741944549282e-01,  -4.678679563275903e-03,   4.063775601380237e-05,  -2.283731639117779e-07,   1.570721896284180e-10,
   1.420035414732808e-11,  -1.983474571848176e-13,   1.235965923157222e-15,  -1.313138211438186e-18,  -1.386224429736087e-19,   2.249326931427440e-21,   1.514199154294539e-23,
   6.370365085732229e-25,   8.140691823040593e-27,   3.475743136085123e-01,  -4.678681571418621e-03,   4.063775876292976e-05,  -2.283727474286869e-07,   1.570634661185976e-10,
   1.420043022186934e-11,  -1.983475644397609e-13,   1.235951295897771e-15,  -1.312841197490290e-18,  -1.386199975168049e-19,   2.249450141856006e-21,   1.514384916061618e-23,
   6.370047547616636e-25,   8.139214267750188e-27,   5.199015071004800e-01,  -6.621703958033187e-03,   4.814001996076135e-05,  -1.188187662770516e-07,  -2.193534130529413e-09,
   3.351989444932372e-11,  -1.856286269219210e-13,  -1.425095423922767e-15,   3.292980086352882e-17,  -3.151831636257421e-19,   2.961694770280426e-22,   8.221304507850941e-23,
   5.916796851751643e-25,   1.321640360681320e-26,   5.199060177386189e-01,  -6.621737265145997e-03,   4.813878463308290e-05,  -1.187873651839557e-07,  -2.193794147651945e-09,
   3.351707208056061e-11,  -1.855421578075082e-13,  -1.426148008149432e-15,   3.293116646497558e-17,  -3.147557070725020e-19,   2.997881977664044e-22,   8.230493198344698e-23,
   5.907796979658333e-25,   1.313011801264012e-26,   5.199139767363649e-01,  -6.621796028895466e-03,   4.813660475925889e-05,  -1.187319596166838e-07,  -2.194252853091754e-09,
   3.351209028713923e-11,  -1.853895787077988e-13,  -1.428004134121120e-15,   3.293358846436558e-17,  -3.140010729263672e-19,   3.061688643757000e-22,   8.246655547504701e-23,
   5.891829786599821e-25,   1.297790812313075e-26,   5.199236006808365e-01,  -6.621867074415454e-03,   4.813396863017455e-05,  -1.186649662889089e-07,  -2.194807356037950e-09,
   3.350606338718440e-11,  -1.852050733190043e-13,  -1.430246576520377e-15,   3.293653825987308e-17,  -3.130879142239819e-19,   3.138765221516343e-22,   8.266111882291015e-23,
   5.872374357285460e-25,   1.279392700351455e-26,   5.199329432713108e-01,  -6.621936031365854e-03,   4.813140930981502e-05,  -1.185999341766993e-07,  -2.195345481368997e-09,
   3.350020958149486e-11,  -1.850259533059213e-13,  -1.432421400309953e-15,   3.293942393933308e-17,  -3.122007598748076e-19,   3.213506591160838e-22,   8.284908305225566e-23,
   5.853332960807216e-25,   1.261539797769317e-26,   5.199404694201627e-01,  -6.621991573009911e-03,   4.812934740283492e-05,  -1.185475479126244e-07,  -2.195778861651977e-09,
   3.349549168662386e-11,  -1.848816526850012e-13,  -1.434171904454219e-15,   3.294176440762280e-17,  -3.114855970622135e-19,   3.273657359892350e-22,   8.299984951373339e-23,
   5.837883040378703e-25,   1.247163261202558e-26,   5.199454425062306e-01,  -6.622028269444991e-03,   4.812798485712888e-05,  -1.185129333541376e-07,  -2.196065169691019e-09,
   3.349237313589339e-11,  -1.847862995050004e-13,  -1.435327868962100e-15,   3.294331868064379e-17,  -3.110127943547710e-19,   3.313374476749698e-22,   8.309915262703008e-23,
   5.827620028733056e-25,   1.237666224248241e-26,   5.199479964056272e-01,  -6.622047113430519e-03,   4.812728510173623e-05,  -1.184951575401665e-07,  -2.196212183415312e-09,
   3.349077128630147e-11,  -1.847373304954999e-13,  -1.435921283931105e-15,   3.294411926493393e-17,  -3.107699147132355e-19,   3.333761989261554e-22,   8.315005036816898e-23,
   5.822332805574779e-25,   1.232789886417356e-26,   5.199488853107941e-01,  -6.622053672031003e-03,   4.812704154180587e-05,  -1.184889705718892e-07,  -2.196263349839148e-09,
   3.349021369621789e-11,  -1.847202862893909e-13,  -1.436127791124066e-15,   3.294439829615756e-17,  -3.106853666455033e-19,   3.340856594562253e-22,   8.316775000806181e-23,
   5.820489885960570e-25,   1.231092767195627e-26,   5.199490263676638e-01,  -6.622054712780070e-03,   4.812700289202564e-05,  -1.184879887883919e-07,  -2.196271469101178e-09,
   3.349012521189841e-11,  -1.847175816041576e-13,  -1.436160559247134e-15,   3.294444259263332e-17,  -3.106719494818311e-19,   3.341982341593808e-22,   8.317055794780769e-23,
   5.820197314076445e-25,   1.230823464154126e-26,   7.262994741865433e-01,  -8.536987441401229e-03,   4.503586008263749e-05,   1.604276016804119e-07,  -5.090389928897093e-09,
   2.881130740284368e-11,   2.873332295831011e-13,  -6.656963815136682e-15,   2.403663427326238e-17,   5.481354437582608e-19,  -9.088812098198695e-21,   8.793550040823927e-23,
   2.871375224941357e-24,   2.407342623304297e-27,   7.263036905468041e-01,  -8.536942226498033e-03,   4.503299902925698e-05,   1.604545023158213e-07,  -5.089985131581632e-09,
   2.879823117169016e-11,   2.873955471861636e-13,  -6.655102028871326e-15,   2.399885897006715e-17,   5.485893018402772e-19,  -9.071131579769303e-21,   8.794769291919277e-23,
   2.869542206440903e-24,   2.309213503524413e-27,   7.263111301631334e-01,  -8.536862437956911e-03,   4.502795084077410e-05,   1.605019589534721e-07,  -5.089270789398283e-09,
   2.877516094156810e-11,   2.875054273055578e-13,  -6.651815632026850e-15,   2.393226441752137e-17,   5.493901871478410e-19,  -9.039943433946277e-21,   8.796862402613771e-23,
   2.866290914298154e-24,   2.136108374443462e-27,   7.263201258555333e-01,  -8.536765946344537e-03,   4.502184683315366e-05,   1.605593270512994e-07,  -5.088406878281095e-09,
   2.874726926462980e-11,   2.876381587386868e-13,  -6.647839561763979e-15,   2.385184081770423e-17,   5.503587022677564e-19,  -9.002246492633264e-21,   8.799294066100206e-23,
   2.862330639822831e-24,   1.926865574963627e-27,   7.263288583293438e-01,  -8.536672263010126e-03,   4.501592149897842e-05,   1.606150012330771e-07,  -5.087568081779851e-09,
   2.872019784130792e-11,   2.877668689932376e-13,  -6.643977437158037e-15,   2.377387506731075e-17,   5.512989974852926e-19,  -8.965667885958196e-21,   8.801550670555666e-23,
   2.858455992608606e-24,   1.723818523295712e-27,   7.263358928182243e-01,  -8.536596785091841e-03,   4.501114836383132e-05,   1.606598388959153e-07,  -5.086892267615022e-09,
   2.869839327763416e-11,   2.878704538328088e-13,  -6.640864565941263e-15,   2.371114429726179e-17,   5.520565411121800e-19,  -8.936212819444714e-21,   8.803294054450724e-23,
   2.855313112081804e-24,   1.560305939403305e-27,   7.263405409468250e-01,  -8.536546906788739e-03,   4.500799447720941e-05,   1.606894605904394e-07,  -5.086445657310873e-09,
   2.868398708268137e-11,   2.879388507107117e-13,  -6.638806855671512e-15,   2.366973082285132e-17,   5.525571382921643e-19,  -8.916755422482835e-21,   8.804409577693199e-23,
   2.853225833589781e-24,   1.452289085100574e-27,   7.263429279411036e-01,  -8.536521290706291e-03,   4.500637484141324e-05,   1.607046708200220e-07,  -5.086216287841451e-09,
   2.867658939139010e-11,   2.879739602811430e-13,  -6.637749881631247e-15,   2.364847474164341e-17,   5.528142267606889e-19,  -8.906764973917763e-21,   8.804971173895634e-23,
   2.852150666374517e-24,   1.396826386131328e-27,   7.263437587496094e-01,  -8.536512374605214e-03,   4.500581111805644e-05,   1.607099645728056e-07,  -5.086136451515100e-09,
   2.867401464939757e-11,   2.879861780217956e-13,  -6.637381953711886e-15,   2.364107823352040e-17,   5.529037099969349e-19,  -8.903288002644702e-21,   8.805164847200318e-23,
   2.851775927491671e-24,   1.377523542677975e-27,   7.263438905871585e-01,  -8.536510959733795e-03,   4.500572166319472e-05,   1.607108046038956e-07,  -5.086123782486053e-09,
   2.867360607768087e-11,   2.879881166918740e-13,  -6.637323566794093e-15,   2.363990459811064e-17,   5.529179098127979e-19,  -8.902736269241843e-21,   8.805195495255808e-23,
   2.851716437050000e-24,   1.374460516511997e-27,   9.644943152412797e-01,  -1.005703277371821e-02,   2.462677435334637e-05,   5.704661121492982e-07,  -5.489759847735240e-09,
  -3.751397583721395e-11,   9.693819312538428e-13,  -1.401156595567105e-15,  -1.516445849347143e-16,   1.174210207237798e-18,   1.709113334523184e-20,  -2.420680646338864e-22,
   2.255557107951817e-24,   9.588823908972046e-26,   9.644966178134722e-01,  -1.005687245440100e-02,   2.462369403521380e-05,   5.704309202599341e-07,  -5.488401344494617e-09,
  -3.751667189875541e-11,   9.689853645093338e-13,  -1.397225382419726e-15,  -1.515720437661545e-16,   1.172988642146688e-18,   1.710480319036966e-20,  -2.413821468382770e-22,
   2.249394959823149e-24,   9.561146407510603e-26,   9.645006805045250e-01,  -1.005658957649018e-02,   2.461825938548760e-05,   5.703688215808919e-07,  -5.486004696917433e-09,
  -3.752142286511798e-11,   9.682857713170031e-13,  -1.390292027205983e-15,  -1.514439970978677e-16,   1.170836031061958e-18,   1.712889271045482e-20,  -2.401734780186042e-22,
   2.238509189619151e-24,   9.512320151026622e-26,   9.645055927553314e-01,  -1.005624753121826e-02,   2.461168880611320e-05,   5.702937277253321e-07,  -5.483107416935819e-09,
  -3.752715708584681e-11,   9.674400802240073e-13,  -1.381913816374805e-15,  -1.512890822549308e-16,   1.168237942108983e-18,   1.715796888182347e-20,  -2.387147453274799e-22,
   2.225324622764233e-24,   9.453298029666180e-26,   9.645103610659912e-01,  -1.005591549395715e-02,   2.460531130824004e-05,   5.702208242813045e-07,  -5.480295595826940e-09,
  -3.753271256928185e-11,   9.666193749867797e-13,  -1.373786331739781e-15,  -1.511386105081272e-16,   1.165720857558619e-18,   1.718613982976064e-20,  -2.373015671010168e-22,
   2.212502943044252e-24,   9.396020555098449e-26,   9.645142020560191e-01,  -1.005564801935245e-02,   2.460017447181264e-05,   5.701620916176764e-07,  -5.478031008231242e-09,
  -3.753717997386400e-11,   9.659584240773676e-13,  -1.367243185135776e-15,  -1.510173329516878e-16,   1.163696773451527e-18,   1.720879403455478e-20,  -2.361652310365028e-22,
   2.202158004072364e-24,   9.349893142764349e-26,   9.645167399674042e-01,  -1.005547128193928e-02,   2.459678052999496e-05,   5.701232808493584e-07,  -5.476534892501925e-09,
  -3.754012802943372e-11,   9.655217767340740e-13,  -1.362921669062733e-15,  -1.509371658094754e-16,   1.162361078428928e-18,   1.722374395606647e-20,  -2.354153894015860e-22,
   2.195314453788854e-24,   9.319420154924209e-26,   9.645180432610616e-01,  -1.005538052037995e-02,   2.459503769851596e-05,   5.701033492701452e-07,  -5.475766653126679e-09,
  -3.754164078322054e-11,   9.652975675090903e-13,  -1.360703006207841e-15,  -1.508959871543782e-16,   1.161675686384182e-18,   1.723141539951033e-20,  -2.350306280326447e-22,
   2.191797554751555e-24,   9.303773049584233e-26,   9.645184968771470e-01,  -1.005534893023624e-02,   2.459443110916865e-05,   5.700964118389834e-07,  -5.475499274328095e-09,
  -3.754216711781460e-11,   9.652195342241105e-13,  -1.359930882521546e-15,  -1.508816531153825e-16,   1.161437217135241e-18,   1.723408455114374e-20,  -2.348967589675386e-22,
   2.190573082695633e-24,   9.298327287515555e-26,   9.645185688594302e-01,  -1.005534391732728e-02,   2.459433485270048e-05,   5.700953109612359e-07,  -5.475456845657458e-09,
  -3.754225063069384e-11,   9.652071516438365e-13,  -1.359808361979239e-15,  -1.508793784328822e-16,   1.161399379513808e-18,   1.723450806295337e-20,  -2.348755181951748e-22,
   2.190378757661256e-24,   9.297463137005471e-26,   1.228691022739733e+00,  -1.061645643126410e-02,  -1.696923902744194e-05,   8.576273562362918e-07,   1.405459154275526e-09,
  -1.298337611188291e-10,  -6.295463710791094e-14,   2.312794914142575e-14,  -4.434871038940731e-17,  -4.796063932386870e-18,   1.893709568237757e-20,   1.109478955672164e-21,
  -2.106216795722792e-24,  -1.502329735681001e-25,   1.228689433462682e+00,  -1.061621565135338e-02,  -1.696844896632059e-05,   8.575060177603386e-07,   1.405369269730023e-09,
  -1.297884828453176e-10,  -6.306941167178750e-14,   2.311191031011826e-14,  -4.426921658176248e-17,  -4.790385652668619e-18,   1.892465940234798e-20,   1.108386722418874e-21,
  -2.093231488179754e-24,  -1.501167235770809e-25,   1.228686629218439e+00,  -1.061579081908545e-02,  -1.696705493244570e-05,   8.572919485397171e-07,   1.405210536457946e-09,
  -1.297086142171832e-10,  -6.327176378712120e-14,   2.308362508888878e-14,  -4.412899064005829e-17,  -4.780370810883489e-18,   1.890277976685819e-20,   1.106460138714448e-21,
  -2.070404328975533e-24,  -1.499124932790668e-25,   1.228683238398836e+00,  -1.061527715454630e-02,  -1.696536932242512e-05,   8.570331524419716e-07,   1.405018371976305e-09,
  -1.296120798480033e-10,  -6.351616133296745e-14,   2.304944880079771e-14,  -4.395949962256689e-17,  -4.768268551083761e-18,   1.887643215100817e-20,   1.104131647344509e-21,
  -2.042947265239082e-24,  -1.496670572426925e-25,   1.228679946757191e+00,  -1.061477854730104e-02,  -1.696373303541559e-05,   8.567819791137278e-07,   1.404831589179405e-09,
  -1.295184116198916e-10,  -6.375311589542971e-14,   2.301629879530349e-14,  -4.379503555830590e-17,  -4.756528045988183e-18,   1.885096860638410e-20,   1.101872392325739e-21,
  -2.016444817615218e-24,  -1.494303802906615e-25,   1.228677295130388e+00,  -1.061437691117681e-02,  -1.696241491695137e-05,   8.565796811590314e-07,   1.404680952674050e-09,
  -1.294429864179848e-10,  -6.394378683544001e-14,   2.298961345229651e-14,  -4.366259896504856e-17,  -4.747075892090809e-18,   1.883053711261503e-20,   1.100053225357226e-21,
  -1.995203793324261e-24,  -1.492408506864856e-25,   1.228675543020284e+00,  -1.061411153450592e-02,  -1.696154395375145e-05,   8.564460278190349e-07,   1.404581333175654e-09,
  -1.293931627950490e-10,  -6.406967277759286e-14,   2.297198997893817e-14,  -4.357511337329907e-17,  -4.740832938020928e-18,   1.881707619596489e-20,   1.098851571758716e-21,
  -1.981221398012585e-24,  -1.491161668181325e-25,   1.228674643239554e+00,  -1.061397525624513e-02,  -1.696109668051804e-05,   8.563773970957225e-07,   1.404530148577749e-09,
  -1.293675809296431e-10,  -6.413428844985842e-14,   2.296294248928258e-14,  -4.353019341146194e-17,  -4.737627766985235e-18,   1.881017567266470e-20,   1.098234594603969e-21,
  -1.974057234909724e-24,  -1.490523066810325e-25,   1.228674330064485e+00,  -1.061392782420136e-02,  -1.696094100425401e-05,   8.563535106044569e-07,   1.404512329295749e-09,
  -1.293586777148786e-10,  -6.415677330772971e-14,   2.295979390633941e-14,  -4.351455989199649e-17,  -4.736512318669534e-18,   1.880777583873526e-20,   1.098019870641501e-21,
  -1.971566302299748e-24,  -1.490301067706883e-25,   1.228674280368002e+00,  -1.061392029742974e-02,  -1.696091630063573e-05,   8.563497201976062e-07,   1.404509501430569e-09,
  -1.293572649347078e-10,  -6.416034109727192e-14,   2.295929429231293e-14,  -4.351207912873006e-17,  -4.736335319068746e-18,   1.880739511097766e-20,   1.097985797882688e-21,
  -1.971171149949645e-24,  -1.490265852411482e-25,   1.505251969949974e+00,  -9.455274984441575e-03,  -6.961720323428813e-05,   4.742480645763812e-07,   1.319140909828667e-08,
  -7.184631531231709e-12,  -2.781849711812395e-12,  -1.598324247974691e-14,   5.486833682194718e-16,   7.082471213600454e-18,  -9.997156042549310e-20,  -2.394435260895763e-21,
   1.796485845217550e-23,   9.106131768529527e-25,   1.505245458200851e+00,  -9.455141627136445e-03,  -6.960980505822517e-05,   4.742410679503491e-07,   1.318751404714855e-08,
  -7.215723966465458e-12,  -2.780418045941795e-12,  -1.595965344430165e-14,   5.482652117756372e-16,   7.070377551244668e-18,  -9.985976343773328e-20,  -2.387920309785843e-21,
   1.797901008018473e-23,   9.079987190474544e-25,   1.505233968678173e+00,  -9.454906317715140e-03,  -6.959675263726066e-05,   4.742286987102338e-07,   1.318064280145020e-08,
  -7.270549456159445e-12,  -2.777892739170469e-12,  -1.591806321793074e-14,   5.475277521405561e-16,   7.049065257310588e-18,  -9.966242733019813e-20,  -2.376440056444546e-21,
   1.800374272007387e-23,   9.033901109821947e-25,   1.505220076381202e+00,  -9.454621781851304e-03,  -6.958097253993645e-05,   4.742137015007868e-07,   1.317233680196987e-08,
  -7.336780946565251e-12,  -2.774840628509575e-12,  -1.586782808490190e-14,   5.466366629597641e-16,   7.023340475535859e-18,  -9.942369030924554e-20,  -2.362584387888536e-21,
   1.803324442210436e-23,   8.978252495048484e-25,   1.505206590981414e+00,  -9.454345562299486e-03,  -6.956565666648630e-05,   4.741991004055686e-07,   1.316427639618614e-08,
  -7.401010275567303e-12,  -2.771879280463768e-12,  -1.581911948823830e-14,   5.457722950011867e-16,   6.998415701462315e-18,  -9.919180801190269e-20,  -2.349161141741305e-21,
   1.806146073951656e-23,   8.924312665638172e-25,   1.505195728036298e+00,  -9.454123045529983e-03,  -6.955332067018793e-05,   4.741873078320707e-07,   1.315778512587872e-08,
  -7.452704575132950e-12,  -2.769494794387959e-12,  -1.577992256114552e-14,   5.450764630660969e-16,   6.978371265307068e-18,  -9.900492102117591e-20,  -2.338367305399211e-21,
   1.808388873947512e-23,   8.880918811592797e-25,   1.505188550346994e+00,  -9.453976011446775e-03,  -6.954517037592360e-05,   4.741795007685892e-07,   1.315349683207206e-08,
  -7.486839752193351e-12,  -2.767919725163537e-12,  -1.575404251746469e-14,   5.446169105010183e-16,   6.965143202436133e-18,  -9.888138779645095e-20,  -2.331244596926122e-21,
   1.809856082874468e-23,   8.852273989849702e-25,   1.505184864368736e+00,  -9.453900502729807e-03,  -6.954098515380093e-05,   4.741754869106594e-07,   1.315129490401632e-08,
  -7.504362535597368e-12,  -2.767111023872476e-12,  -1.574075823966028e-14,   5.443809827459955e-16,   6.958355195709254e-18,  -9.881793476288775e-20,  -2.327589733245886e-21,
   1.810604995748926e-23,   8.837572490369493e-25,   1.505183581447543e+00,  -9.453874221280360e-03,  -6.953952850366932e-05,   4.741740891252587e-07,   1.315052855309492e-08,
  -7.510460344746137e-12,  -2.766829575380121e-12,  -1.573613553775614e-14,   5.442988777880263e-16,   6.955993401157916e-18,  -9.879584731939803e-20,  -2.326318100024134e-21,
   1.810864934846341e-23,   8.832456929491615e-25,   1.505183377866440e+00,  -9.453870050778707e-03,  -6.953929735595410e-05,   4.741738672815323e-07,   1.315040694614601e-08,
  -7.511427928199518e-12,  -2.766784914681147e-12,  -1.573540202669512e-14,   5.442858494249117e-16,   6.955618656445622e-18,  -9.879234224985842e-20,  -2.326116331918469e-21,
   1.810906149104011e-23,   8.831645228348363e-25,   1.764355601824737e+00,  -6.031555323029969e-03,  -9.046127669441062e-05,  -6.908106472677080e-07,   4.742571064596016e-09,
   2.235433686618362e-10,   2.587530819353978e-12,  -1.497829024342806e-14,  -1.004930428866132e-15,  -1.384586837313547e-17,   5.342153832369841e-20,   5.418382732126003e-21,
   8.797890588979036e-23,  -7.033211308966263e-27,   1.764347126493239e+00,  -6.031748875918340e-03,  -9.045858865684382e-05,  -6.906013305624108e-07,   4.746178644464932e-09,
   2.235131501244254e-10,   2.584897941685052e-12,  -1.502429209817831e-14,  -1.004687961605403e-15,  -1.381794430051504e-17,   5.395493918442150e-20,   5.418055347452797e-21,
   8.774232079225070e-23,  -1.205466508151993e-26,   1.764332171844553e+00,  -6.032090355222763e-03,  -9.045384392973189e-05,  -6.902320111940840e-07,   4.752541267872982e-09,
   2.234597557670003e-10,   2.580252715347273e-12,  -1.510538648688488e-14,  -1.004258304460846e-15,  -1.376867348855382e-17,   5.489494248733371e-20,   5.417448009377805e-21,
   8.732479016405080e-23,  -2.090099412345772e-26,   1.764314088876739e+00,  -6.032503194126490e-03,  -9.044810375528958e-05,  -6.897854659509259e-07,   4.760229891569262e-09,
   2.233950658872811e-10,   2.574636560498268e-12,  -1.520331606913668e-14,  -1.003735658255970e-15,  -1.370909760045129e-17,   5.602957368960646e-20,   5.416663089856486e-21,
   8.681978579957899e-23,  -3.157401117736006e-26,   1.764296534614533e+00,  -6.032903885626087e-03,  -9.044252836266075e-05,  -6.893520091627478e-07,   4.767688504375225e-09,
   2.233321354349356e-10,   2.569185443024225e-12,  -1.529824763394376e-14,  -1.003225039444794e-15,  -1.365126550894335e-17,   5.712892704745357e-20,   5.415848273079974e-21,
   8.632941092111594e-23,  -4.190998724880167e-26,   1.764282393394311e+00,  -6.033226616329295e-03,  -9.043803479991382e-05,  -6.890028518544298e-07,   4.773693218659184e-09,
   2.232813459555309e-10,   2.564794775608104e-12,  -1.537462526995015e-14,  -1.002811370545902e-15,  -1.360467906083448e-17,   5.801302763702246e-20,   5.415154066161171e-21,
   8.593428303363784e-23,  -5.021844931749460e-26,   1.764273049257747e+00,  -6.033439841085507e-03,  -9.043506450633968e-05,  -6.887721495509537e-07,   4.777659143352253e-09,
   2.232477394102926e-10,   2.561893835648262e-12,  -1.542504627008403e-14,  -1.002536890087692e-15,  -1.357389673873033e-17,   5.859647919449079e-20,   5.414676859056218e-21,
   8.567314698357715e-23,  -5.569968466059629e-26,   1.764268250636682e+00,  -6.033549332940323e-03,  -9.043353880081795e-05,  -6.886536774055342e-07,   4.779695252976678e-09,
   2.232304666954654e-10,   2.560404167934580e-12,  -1.545092502789163e-14,  -1.002395580316823e-15,  -1.355808891272604e-17,   5.889587864916352e-20,   5.414426077385813e-21,
   8.553902809357995e-23,  -5.851182422602050e-26,   1.764266580439070e+00,  -6.033587441108920e-03,  -9.043300771447560e-05,  -6.886124428112113e-07,   4.780403846850811e-09,
   2.232244525174336e-10,   2.559885691981899e-12,  -1.545993000428260e-14,  -1.002346340308997e-15,  -1.355258691349330e-17,   5.900005062001135e-20,   5.414337881409827e-21,
   8.549234472278376e-23,  -5.949017935860413e-26,   1.764266315402015e+00,  -6.033593488280459e-03,  -9.043292343598702e-05,  -6.886058994832098e-07,   4.780516286537732e-09,
   2.232234980433362e-10,   2.559803417774214e-12,  -1.546135885787379e-14,  -1.002338523947003e-15,  -1.355171382482022e-17,   5.901657953237435e-20,   5.414323842772253e-21,
   8.548493661708261e-23,  -5.964541015426531e-26,   1.950044411530681e+00,  -1.573848728395860e-03,  -3.551287250793418e-05,  -6.676613902434851e-07,  -1.071386856027071e-08,
  -1.417001886871474e-10,  -1.313012617625607e-12,  -1.392445954173867e-16,   3.542898837676404e-16,   1.024603169200375e-17,   1.941932426884269e-19,   2.625799222083195e-21,
   1.882347977616365e-23,  -2.246068828073612e-25,   1.950041070086449e+00,  -1.574036975701178e-03,  -3.551890940006711e-05,  -6.677942309831639e-07,  -1.071570375481120e-08,
  -1.416999064137789e-10,  -1.312065604211392e-12,  -1.043134876980477e-16,   3.551127009655044e-16,   1.025950041129999e-17,   1.943049029754668e-19,   2.624009549619165e-21,
   1.872015629422158e-23,  -2.272691369462205e-25,   1.950035173594086e+00,  -1.574369171412165e-03,  -3.552956242797320e-05,  -6.680286301747528e-07,  -1.071894089509387e-08,
  -1.416993522544627e-10,  -1.310392825965525e-12,  -4.264009342460072e-17,   3.565649536120243e-16,   1.028325852517800e-17,   1.945014059532448e-19,   2.620835760948765e-21,
   1.853751544510276e-23,  -2.319708897716596e-25,   1.950028042705669e+00,  -1.574770917814426e-03,  -3.554244560955480e-05,  -6.683120674986305e-07,  -1.072285342089278e-08,
  -1.416985864916192e-10,  -1.308367086247754e-12,   3.199894572585928e-17,   3.583216776060634e-16,   1.031197399528455e-17,   1.947381259697793e-19,   2.616970882297526e-21,
   1.831611014343186e-23,  -2.376633876374501e-25,   1.950021119338590e+00,  -1.575160980511007e-03,  -3.555495387251643e-05,  -6.685872227936171e-07,  -1.072664968491747e-08,
  -1.416977428686845e-10,  -1.306397392610113e-12,   1.045230949753585e-16,   3.600277482688118e-16,   1.033983670526679e-17,   1.949669925881496e-19,   2.613190525185485e-21,
   1.810059354744696e-23,  -2.431969745221788e-25,   1.950015541373644e+00,  -1.575475248812085e-03,  -3.556503143612540e-05,  -6.688088837553001e-07,  -1.072970650866103e-08,
  -1.416969914036191e-10,  -1.304808382318563e-12,   1.629947832460855e-16,   3.614026179975549e-16,   1.036227263383320e-17,   1.951506921407207e-19,   2.610124755141517e-21,
   1.792656051077897e-23,  -2.476600583420734e-25,   1.950011855264653e+00,  -1.575682930736431e-03,  -3.557169103422901e-05,  -6.689553530824063e-07,  -1.073172571873554e-08,
  -1.416964596528820e-10,  -1.303757290417734e-12,   2.016549269017835e-16,   3.623113426734993e-16,   1.037709302778760e-17,   1.952717478918596e-19,   2.608088972286154e-21,
   1.781135906360204e-23,  -2.506117747205419e-25,   1.950009962181895e+00,  -1.575789591226836e-03,  -3.557511121840565e-05,  -6.690305719989502e-07,  -1.073276246789889e-08,
  -1.416961756856170e-10,  -1.303217163523615e-12,   2.215159012857402e-16,   3.627780889333155e-16,   1.038470250020794e-17,   1.953338137812846e-19,   2.607040413717607e-21,
   1.775213467018171e-23,  -2.521284224648305e-25,   1.950009303262869e+00,  -1.575826716324194e-03,  -3.557630167060182e-05,  -6.690567526169615e-07,  -1.073312328420703e-08,
  -1.416960751145762e-10,  -1.303029113134666e-12,   2.284298320244356e-16,   3.629405558020631e-16,   1.038735080621816e-17,   1.953554001312806e-19,   2.606674961788724e-21,
   1.773151105798309e-23,  -2.526564329093270e-25,   1.950009198700819e+00,  -1.575832607610327e-03,  -3.557649058019361e-05,  -6.690609071197712e-07,  -1.073318053918431e-08,
  -1.416960590730302e-10,  -1.302999269551025e-12,   2.295270315743180e-16,   3.629663376051578e-16,   1.038777104448277e-17,   1.953588248160791e-19,   2.606616946264455e-21,
   1.772823789909454e-23,  -2.527402269371622e-25,   4.027515951501913e-03,  -5.750351504245034e-05,   6.143144572901962e-07,  -5.835275968500472e-09,   5.161185873628361e-11,
  -4.423274990656207e-13,   3.549481293206819e-15,  -3.043466913581294e-17,   2.160396763198095e-19,  -1.323452116624633e-21,   4.027603461669905e-03,  -5.750600847707972e-05,
   6.143585687622507e-07,  -5.835906201936498e-09,   5.161944579257434e-11,  -4.424185578782885e-13,   3.550347504113404e-15,  -3.044132961140214e-17,   2.162985117558033e-19,
  -1.318989071864736e-21,   4.027747128321928e-03,  -5.751010204834309e-05,   6.144309895705039e-07,  -5.836940925856280e-09,   5.163190251307192e-11,  -4.425680599698327e-13,
   3.551770276959645e-15,  -3.045224738604617e-17,   2.167237738454702e-19,  -1.311669108627469e-21,   4.027899575926204e-03,  -5.751444590859422e-05,   6.145078400172807e-07,
  -5.838038975316452e-09,   5.164512187773693e-11,  -4.427267126781615e-13,   3.553280965313235e-15,  -3.046380961328138e-17,   2.171754731933954e-19,  -1.303911396451411e-21,
   4.028019557468722e-03,  -5.751786474114652e-05,   6.145683263366501e-07,  -5.838903238267311e-09,   5.165552690649780e-11,  -4.428515872492867e-13,   3.554470621312092e-15,
  -3.047289295745173e-17,   2.175312975469373e-19,  -1.297812817332731e-21,   4.028088802957722e-03,  -5.751983789311686e-05,   6.146032360239533e-07,  -5.839402058299352e-09,
   5.166153238106963e-11,  -4.429236604354603e-13,   3.555157490347143e-15,  -3.047812864711030e-17,   2.177367845567637e-19,  -1.294295933728068e-21,   4.028114805666629e-03,
  -5.752057884582878e-05,   6.146163453082874e-07,  -5.839589377172036e-09,   5.166378759649745e-11,  -4.429507256969629e-13,   3.555415472330353e-15,  -3.048009347517487e-17,
   2.178139722289982e-19,  -1.292975825026788e-21,   4.028119116005723e-03,  -5.752070167011295e-05,   6.146185183782531e-07,  -5.839620428325206e-09,   5.166416143601162e-11,
  -4.429552122075479e-13,   3.555458239482472e-15,  -3.048041910891252e-17,   2.178267685220389e-19,  -1.292757025360087e-21,   3.628599903934952e-02,  -5.146973598610071e-04,
   5.408260139728192e-06,  -4.981366451478544e-08,   4.188044234087299e-10,  -3.330264404271488e-12,   2.369211879017490e-14,  -1.783911678102131e-16,   9.075880227060236e-19,
  -1.328984009159279e-21,   3.628676939419158e-02,  -5.147186431722695e-04,   5.408618020213290e-06,  -4.981840822758477e-08,   4.188550402729552e-10,  -3.330797603651160e-12,
   2.369577026370436e-14,  -1.783966833279171e-16,   9.092765138708450e-19,  -1.280773368823209e-21,   3.628803409323555e-02,  -5.147535846381310e-04,   5.409205570219230e-06,
  -4.982619634858230e-08,   4.189381417024833e-10,  -3.331672947825811e-12,   2.370176962732385e-14,  -1.784055598610332e-16,   9.120511999476602e-19,  -1.201685425162622e-21,
   3.628937608681931e-02,  -5.147906622265217e-04,   5.409829048689270e-06,  -4.983446089267585e-08,   4.190263264321512e-10,  -3.332601770526728e-12,   2.370814205095861e-14,
  -1.784147366382299e-16,   9.149990891609366e-19,  -1.117845583444105e-21,   3.629043227913593e-02,  -5.148198439261994e-04,   5.410319760297133e-06,  -4.984096567229043e-08,
   4.190957338490678e-10,  -3.333332769480526e-12,   2.371316198928595e-14,  -1.784217837530509e-16,   9.173217876119915e-19,  -1.051920286443670e-21,   3.629104184293232e-02,
  -5.148366858340821e-04,   5.410602971898635e-06,  -4.984471992425870e-08,   4.191357924609244e-10,  -3.333754647468622e-12,   2.371606102203417e-14,  -1.784257806399038e-16,
   9.186633394488704e-19,  -1.013896464119619e-21,   3.629127074295085e-02,  -5.148430102472874e-04,   5.410709323003126e-06,  -4.984612972411740e-08,   4.191508352904572e-10,
  -3.333913067635183e-12,   2.371715000223733e-14,  -1.784272682569484e-16,   9.191673087607721e-19,  -9.996224876415516e-22,   3.629130868655050e-02,  -5.148440586150697e-04,
   5.410726952344001e-06,  -4.984636342078187e-08,   4.191533288770608e-10,  -3.333939328086736e-12,   2.371733053552980e-14,  -1.784275141516636e-16,   9.192508596024797e-19,
  -9.972566012408439e-22,   1.010036050910162e-01,  -1.413228620356719e-03,   1.433329559006209e-05,  -1.231980394500420e-07,   9.145176459102711e-10,  -5.867292219692731e-12,
   2.564689958635815e-14,  -7.240741757422337e-17,  -1.516646505797515e-18,   3.065190852229928e-20,   1.010056463951843e-01,  -1.413281245820068e-03,   1.433407675528402e-05,
  -1.232063908407001e-07,   9.145723211330432e-10,  -5.867506024427630e-12,   2.564092209923888e-14,  -7.224638004585642e-17,  -1.513485300303237e-18,   3.080126133965787e-20,
   1.010089976068447e-01,  -1.413367641615204e-03,   1.433535919817988e-05,  -1.232201012193182e-07,   9.146620701753361e-10,  -5.867856669063868e-12,   2.563111823477472e-14,
  -7.198145908257256e-17,  -1.508287992974542e-18,   3.104628356659866e-20,   1.010125536108506e-01,  -1.413459317738202e-03,   1.433672001509470e-05,  -1.232346492885297e-07,
   9.147572883712669e-10,  -5.868228253194216e-12,   2.562072802185820e-14,  -7.169960786013465e-17,  -1.502762845431525e-18,   3.130604663439369e-20,   1.010153522839219e-01,
  -1.413531469868034e-03,   1.433779101837842e-05,  -1.232460989109562e-07,   9.148322165661508e-10,  -5.868520346033529e-12,   2.561255988966740e-14,  -7.147724699688590e-17,
  -1.498407017566042e-18,   3.151031843155728e-20,   1.010169674846392e-01,  -1.413573111290950e-03,   1.433840912863230e-05,  -1.232527067982866e-07,   9.148754554766827e-10,
  -5.868688779730321e-12,   2.560784951961425e-14,  -7.134870083308851e-17,  -1.495890182625066e-18,   3.162814210583141e-20,   1.010175740145733e-01,  -1.413588748251730e-03,
   1.433864123769585e-05,  -1.232551881420001e-07,   9.148916914343463e-10,  -5.868752002004991e-12,   2.560608141317195e-14,  -7.130038939716581e-17,  -1.494944519709568e-18,
   3.167237364974493e-20,   1.010176745559083e-01,  -1.413591340311953e-03,   1.433867971322826e-05,  -1.232555994610985e-07,   9.148943827406906e-10,  -5.868762480616494e-12,
   2.560578836033250e-14,  -7.129237891860407e-17,  -1.494787732689997e-18,   3.167970500563020e-20,   1.985599462473846e-01,  -2.717588832080988e-03,   2.596610081260856e-05,
  -1.962693323315006e-07,   1.092676911655154e-09,  -2.829566677954238e-12,  -3.851690333593272e-14,   5.875206418645632e-16,  -7.343710859972770e-18,   6.701946994920084e-20,
   1.985636432895281e-01,  -2.717672637955048e-03,   2.596703332035579e-05,  -1.962733441361091e-07,   1.092594347780566e-09,  -2.827805285170961e-12,  -3.854599278387532e-14,
   5.878710672626501e-16,  -7.335423179545512e-18,   6.728351828782463e-20,   1.985697126785665e-01,  -2.717810220099215e-03,   2.596856413172415e-05,  -1.962799283487738e-07,
   1.092458761024966e-09,  -2.824912912234611e-12,  -3.859372384802646e-14,   5.884473222996949e-16,  -7.321799248166548e-18,   6.771663637913892e-20,   1.985761528999606e-01,
  -2.717956207071402e-03,   2.597018837155488e-05,  -1.962869122416718e-07,   1.092314832139839e-09,  -2.821842844730155e-12,  -3.864433758673336e-14,   5.890600978506336e-16,
  -7.307318309965012e-18,   6.817571733863118e-20,   1.985812214825541e-01,  -2.718071100804654e-03,   2.597146660661902e-05,  -1.962924068165665e-07,   1.092201515303677e-09,
  -2.819425934269404e-12,  -3.868414723233930e-14,   5.895433137660350e-16,  -7.295903760561149e-18,   6.853665988724350e-20,   1.985841466985681e-01,  -2.718137408713373e-03,
   2.597220428093620e-05,  -1.962955771273461e-07,   1.092136100290590e-09,  -2.818030786562860e-12,  -3.870711267666692e-14,   5.898225710774801e-16,  -7.289309011786635e-18,
   6.874482355485726e-20,   1.985852451534304e-01,  -2.718162308084796e-03,   2.597248128117177e-05,  -1.962967674752553e-07,   1.092111532967076e-09,  -2.817506837718996e-12,
  -3.871573463655957e-14,   5.899275075240457e-16,  -7.286831261148998e-18,   6.882296394248297e-20,   1.985854272384246e-01,  -2.718166435516884e-03,   2.597252719772495e-05,
  -1.962969647853209e-07,   1.092107460405599e-09,  -2.817419982690204e-12,  -3.871716375522382e-14,   5.899449060688391e-16,  -7.286420466979435e-18,   6.883591539732228e-20,
   3.294553247775396e-01,  -4.363820169469472e-03,   3.791859985182157e-05,  -2.239312609817527e-07,   3.986567684306102e-10,   9.823327983849278e-12,  -1.648228822211849e-13,
   1.134254704371434e-15,  -4.594711404725207e-18,  -2.798993698128384e-20,   3.294607215533378e-01,  -4.363915721165772e-03,   3.791893824782358e-05,  -2.239172530648773e-07,
   3.983047248635641e-10,   9.826715554502469e-12,  -1.648407010529312e-13,   1.134122079359857e-15,  -4.571163193081117e-18,  -2.758832586148327e-20,   3.294695812689884e-01,
  -4.364072580415073e-03,   3.791949356231511e-05,  -2.238942533180467e-07,   3.977267611244008e-10,   9.832276520680878e-12,  -1.648698855505589e-13,   1.133905836974296e-15,
  -4.532473579811167e-18,  -2.692955469463764e-20,   3.294789821593107e-01,  -4.364239014324856e-03,   3.792008249855671e-05,  -2.238698440737348e-07,   3.971134599491529e-10,
   9.838176757785271e-12,  -1.649007600929730e-13,   1.133678401557204e-15,  -4.491378330375284e-18,  -2.623128212394991e-20,   3.294863807436169e-01,  -4.364369994430969e-03,
   3.792054578062270e-05,  -2.238506304417803e-07,   3.966307619728335e-10,   9.842820003232731e-12,  -1.649249915339539e-13,   1.133500866349379e-15,  -4.459005413324225e-18,
  -2.568227190282912e-20,   3.294906506250112e-01,  -4.364445583905511e-03,   3.792081306403773e-05,  -2.238395405048227e-07,   3.963521768325068e-10,   9.845499602336255e-12,
  -1.649389491082645e-13,   1.133398991325091e-15,  -4.440310077109582e-18,  -2.536564210548852e-20,   3.294922540105263e-01,  -4.364473968182400e-03,   3.792091341541479e-05,
  -2.238353758634752e-07,   3.962475633215772e-10,   9.846505797965240e-12,  -1.649441852370972e-13,   1.133360846591307e-15,  -4.433287472484131e-18,  -2.524678513867302e-20,
   3.294925197947627e-01,  -4.364478673265570e-03,   3.792093004923716e-05,  -2.238346855008576e-07,   3.962302220281783e-10,   9.846672588214108e-12,  -1.649450529324171e-13,
   1.133354529376353e-15,  -4.432123252943629e-18,  -2.522708504271540e-20,   4.941754426691095e-01,  -6.242837472455600e-03,   4.652485767319990e-05,  -1.488037810619211e-07,
  -1.570369204910688e-09,   2.869475384559378e-11,  -2.124199936061993e-13,  -5.429890099836926e-16,   2.276143343714471e-17,  -2.206732471153977e-19,   4.941820607965456e-01,
  -6.242900855855666e-03,   4.652351426037499e-05,  -1.487629601843093e-07,  -1.570821553004241e-09,   2.869311353751951e-11,  -2.123286648637115e-13,  -5.440942030859835e-16,
   2.279192498146847e-17,  -2.197291314315679e-19,   4.941929253855584e-01,  -6.243004897375133e-03,   4.652130855191681e-05,  -1.486959477996506e-07,  -1.571564014385197e-09,
   2.869041833551878e-11,  -2.121786459400575e-13,  -5.459050660956748e-16,   2.284201517434321e-17,  -2.181799465356238e-19,   4.942044533663320e-01,  -6.243115276358590e-03,
   4.651896774577404e-05,  -1.486248447814683e-07,  -1.572351631287651e-09,   2.868755529985005e-11,  -2.120193445982159e-13,  -5.478217895576294e-16,   2.289520994046061e-17,
  -2.165371436116395e-19,   4.942135258117529e-01,  -6.243202132810884e-03,   4.651712524467189e-05,  -1.485688879996317e-07,  -1.572971350852641e-09,   2.868529974902495e-11,
  -2.118938869200257e-13,  -5.493268287339370e-16,   2.293710708782172e-17,  -2.152449782267077e-19,   4.942187616428834e-01,  -6.243252254402405e-03,   4.651606179128869e-05,
  -1.485365949152248e-07,  -1.573328947363959e-09,   2.868399709494445e-11,  -2.118214480795095e-13,  -5.501940408444848e-16,   2.296129976744936e-17,  -2.144995378061977e-19,
   4.942207277392307e-01,  -6.243271074619898e-03,   4.651566243318471e-05,  -1.485244686673219e-07,  -1.573463217866844e-09,   2.868350775942988e-11,  -2.117942400027391e-13,
  -5.505194276918817e-16,   2.297038681403845e-17,  -2.142196731326583e-19,   4.942210536472988e-01,  -6.243274194290825e-03,   4.651559623276625e-05,  -1.485224585748293e-07,
  -1.573485474568368e-09,   2.868342663578485e-11,  -2.117897295278314e-13,  -5.505733515083634e-16,   2.297189325145010e-17,  -2.141732844946569e-19,   6.928827144443727e-01,
  -8.170336970121031e-03,   4.649219089938757e-05,   8.390654727198107e-08,  -4.459771811743850e-09,   3.357262957357257e-11,   1.142360673675210e-13,  -5.632158521415260e-15,
   3.852606185149089e-17,   3.021641866007092e-19,   6.928893229698512e-01,  -8.170300980306822e-03,   4.648838434245890e-05,   8.395418172122958e-08,  -4.459526142470133e-09,
   3.355582368579674e-11,   1.143892978615093e-13,  -5.630564801466431e-15,   3.851244464943316e-17,   3.038688225038254e-19,   6.929001715429784e-01,  -8.170241882534892e-03,
   4.648213541520424e-05,   8.403236410582839e-08,  -4.459122600319706e-09,   3.352823757247338e-11,   1.146408118615209e-13,  -5.627942156409264e-15,   3.849018657923917e-17,
   3.066651018239604e-19,   6.929116821862175e-01,  -8.170179155299854e-03,   4.647550502705427e-05,   8.411529818517337e-08,  -4.458694089816558e-09,   3.349897129935866e-11,
   1.149076352725598e-13,  -5.625150775118948e-15,   3.846670030879449e-17,   3.096292326135827e-19,   6.929207407382643e-01,  -8.170129774207519e-03,   4.647028702640444e-05,
   8.418055074771597e-08,  -4.458356617343292e-09,   3.347594201563717e-11,   1.151175888927035e-13,  -5.622947754815138e-15,   3.844831132593712e-17,   3.119598866862261e-19,
   6.929259684515946e-01,  -8.170101269630496e-03,   4.646727567620775e-05,   8.421820246612721e-08,  -4.458161762208283e-09,   3.346265274131736e-11,   1.152387421169621e-13,
  -5.621673869178554e-15,   3.843773663253734e-17,   3.133040961429036e-19,   6.929279314807907e-01,  -8.170090564785414e-03,   4.646614489560985e-05,   8.423233977342893e-08,
  -4.458088574558021e-09,   3.345766274690264e-11,   1.152842335050972e-13,  -5.621195043931564e-15,   3.843377289469622e-17,   3.138086980435473e-19,   6.929282568794409e-01,
  -8.170088790246459e-03,   4.646595745313859e-05,   8.423468316655958e-08,  -4.458076441728445e-09,   3.345683559763713e-11,   1.152917742034759e-13,  -5.621115647079714e-15,
   3.843311622618882e-17,   3.138923344737250e-19,   9.247016062343975e-01,  -9.834168518620427e-03,   3.092438058160667e-05,   4.778680817043062e-07,  -6.013128970839048e-09,
  -1.522541878296350e-11,   8.693809402710568e-13,  -5.463336891494441e-15,  -9.922289224852345e-17,   1.692356953159328e-18,   9.247059966973488e-01,  -9.833964583260968e-03,
   3.091925679275712e-05,   4.778462782610816e-07,  -6.011277859143699e-09,  -1.524160732099693e-11,   8.689869824116031e-13,  -5.454675510823578e-15,  -9.915533747271427e-17,
   1.692033862329865e-18,   9.247132038277233e-01,  -9.833629797112935e-03,   3.091084640478299e-05,   4.778104677857295e-07,  -6.008239566688963e-09,  -1.526816472392080e-11,
   8.683404326392613e-13,  -5.440457648102384e-15,  -9.904421341191327e-17,   1.691503529100241e-18,   9.247208504364915e-01,  -9.833274572309534e-03,   3.090192388313705e-05,
   4.777724475605217e-07,  -6.005016528328517e-09,  -1.529631876454388e-11,   8.676546598331221e-13,  -5.425373021404315e-15,  -9.892600110786250e-17,   1.690940891743050e-18,
   9.247268678411759e-01,  -9.832995015167156e-03,   3.089490293380312e-05,   4.777425091298576e-07,  -6.002480577216786e-09,  -1.531845774134289e-11,   8.671151462384839e-13,
  -5.413502517047061e-15,  -9.883274986371592e-17,   1.690498147247767e-18,   9.247303403960253e-01,  -9.832833679937850e-03,   3.089085145638676e-05,   4.777252245394920e-07,
  -6.001017269510900e-09,  -1.533122720204576e-11,   8.668038599303253e-13,  -5.406652288290031e-15,  -9.877884569653376e-17,   1.690242649432044e-18,   9.247316443357674e-01,
  -9.832773097458574e-03,   3.088933017132766e-05,   4.777187327687708e-07,  -6.000467828135696e-09,  -1.533602086747155e-11,   8.666869834922658e-13,  -5.404080048376674e-15,
  -9.875858771009694e-17,   1.690146710639674e-18,   9.247318604803795e-01,  -9.832763055072042e-03,   3.088907800103766e-05,   4.777176565996994e-07,  -6.000376752748572e-09,
  -1.533681541259019e-11,   8.666676103236755e-13,  -5.403653667493101e-15,  -9.875522879225875e-17,   1.690130807570603e-18,   1.186019103529828e+00,  -1.071084112235735e-02,
  -6.628199707714605e-06,   8.594660657901348e-07,  -1.155295167146295e-09,  -1.238832923711831e-10,   5.403490793946183e-13,   1.918436228913952e-14,  -1.920423829872222e-16,
  -3.116938990978392e-18,   1.186018158317758e+00,  -1.071047481838812e-02,  -6.629179669856786e-06,   8.592902524591094e-07,  -1.154150711259797e-09,  -1.238262127372502e-10,
   5.395922073719481e-13,   1.916857308760150e-14,  -1.916401096401629e-16,  -3.110264074673859e-18,   1.186016606499363e+00,  -1.070987352525963e-02,  -6.630787732913675e-06,
   8.590016850196139e-07,  -1.152273064957543e-09,  -1.237325412657746e-10,   5.383508360313070e-13,   1.914267723220055e-14,  -1.909800503419780e-16,  -3.099311584739724e-18,
   1.186014959764495e+00,  -1.070923558031880e-02,  -6.632493056521145e-06,   8.586955722818405e-07,  -1.150282317090882e-09,  -1.236331947544249e-10,   5.370352164474881e-13,
   1.911523325135828e-14,  -1.902801351076131e-16,  -3.087697595537099e-18,   1.186013663677342e+00,  -1.070873356753573e-02,  -6.633834463603213e-06,   8.584547175793395e-07,
  -1.148716731239882e-09,  -1.235550419257676e-10,   5.360009542058948e-13,   1.909365895713518e-14,  -1.897296302483459e-16,  -3.078562734936043e-18,   1.186012915640764e+00,
  -1.070844386747972e-02,  -6.634608338751008e-06,   8.583157387170481e-07,  -1.147813659022410e-09,  -1.235099517800730e-10,   5.354045169843804e-13,   1.908121773294765e-14,
  -1.894120562548084e-16,  -3.073293002271471e-18,   1.186012634738157e+00,  -1.070833508626068e-02,  -6.634898884199737e-06,   8.582635551371197e-07,  -1.147474632959792e-09,
  -1.234930225100464e-10,   5.351806350005390e-13,   1.907654776693196e-14,  -1.892928292244651e-16,  -3.071314576813660e-18,   1.186012588174137e+00,  -1.070831705442929e-02,
  -6.634947043504492e-06,   8.582549051920537e-07,  -1.147418439101550e-09,  -1.234902163745620e-10,   5.351435279001345e-13,   1.907577375014164e-14,  -1.892730669650138e-16,
  -3.070986646202686e-18,   1.466357630048788e+00,  -9.985881767798962e-03,  -6.267616142485822e-05,   6.804145031119617e-07,   1.235465855093085e-08,  -7.713139764716845e-11,
  -2.951696665540207e-12,   4.698681442012225e-15,   7.097739016990047e-16,   1.396974397016355e-18,   1.466348731912169e+00,  -9.985591671189892e-03,  -6.266564796623158e-05,
   6.803048590766237e-07,   1.234839112910959e-08,  -7.711724310626524e-11,  -2.948890682576631e-12,   4.705748013405741e-15,   7.087023874724224e-16,   1.393586797008997e-18,
   1.466334125256076e+00,  -9.985115464447058e-03,  -6.264839227919749e-05,   6.801248752481013e-07,   1.233810645901730e-08,  -7.709399093013719e-11,  -2.944287278860551e-12,
   4.717336608361211e-15,   7.069458315522259e-16,   1.388054396182478e-18,   1.466318627926123e+00,  -9.984610218207457e-03,  -6.263008790180710e-05,   6.799339183464161e-07,
   1.232719949392192e-08,  -7.706929792158228e-11,  -2.939406882115205e-12,   4.729616309932443e-15,   7.050853948297025e-16,   1.382223246497288e-18,   1.466306432503694e+00,
  -9.984212620006616e-03,  -6.261568605351814e-05,   6.797836486405644e-07,   1.231861989928656e-08,  -7.704984945232043e-11,  -2.935569000604149e-12,   4.739268458800671e-15,
   7.036236835551576e-16,   1.377662362150186e-18,   1.466299394710849e+00,  -9.983983171635543e-03,  -6.260737598525792e-05,   6.796969308209791e-07,   1.231367014807498e-08,
  -7.703861937470565e-11,  -2.933355292229178e-12,   4.744834091098569e-15,   7.027810873759668e-16,   1.375041486018352e-18,   1.466296752029770e+00,  -9.983897014009159e-03,
  -6.260425575924420e-05,   6.796643685075259e-07,   1.231181178863101e-08,  -7.703440123797061e-11,  -2.932524250942354e-12,   4.746923133718301e-15,   7.024648703744607e-16,
   1.374059453222114e-18,   1.466296313971781e+00,  -9.983882732282208e-03,  -6.260373855227296e-05,   6.796589708954962e-07,   1.231150375590405e-08,  -7.703370196177897e-11,
  -2.932386505990437e-12,   4.747269374595349e-15,   7.024124627024433e-16,   1.373896779631189e-18,   1.738731122727429e+00,  -6.786765522950257e-03,  -9.813740587760831e-05,
  -5.759831791875851e-07,   9.780001668083963e-09,   2.765368359917330e-10,   1.648729547832819e-12,  -5.416155951021983e-14,  -1.396461156023988e-15,  -5.774394713077675e-18,
   1.738717173886024e+00,  -6.787010037666606e-03,  -9.812903574423362e-05,  -5.755910176484408e-07,   9.783455632937924e-09,   2.763745366433358e-10,   1.643215347870978e-12,
  -5.418932293444808e-14,  -1.394045778708888e-15,  -5.706497790280470e-18,   1.738694275468709e+00,  -6.787411327469428e-03,  -9.811529270442078e-05,  -5.749473881129526e-07,
   9.789117394470510e-09,   2.761080372006221e-10,   1.634169859314562e-12,  -5.423465080582855e-14,  -1.390079313018179e-15,  -5.595183588720031e-18,   1.738669979651541e+00,
  -6.787836962985141e-03,  -9.810070741043683e-05,  -5.742646745627464e-07,   9.795113440860208e-09,   2.758251810811512e-10,   1.624581362195297e-12,  -5.428240732898328e-14,
  -1.385868922211544e-15,  -5.477273962180550e-18,   1.738650859565383e+00,  -6.788171821669028e-03,  -9.808922663418115e-05,  -5.737275398861340e-07,   9.799824024571716e-09,
   2.756025144183523e-10,   1.617042019250365e-12,  -5.431974614029314e-14,  -1.382554126661234e-15,  -5.384625728698162e-18,   1.738639825330379e+00,  -6.788365027588481e-03,
  -9.808260002338005e-05,  -5.734176148990107e-07,   9.802539254462090e-09,   2.754739861965595e-10,   1.612693665195342e-12,  -5.434119663881902e-14,  -1.380640616939841e-15,
  -5.331215662922624e-18,   1.738635681929791e+00,  -6.788437569341155e-03,  -9.808011150827760e-05,  -5.733012474484745e-07,   9.803558219156624e-09,   2.754257182450404e-10,
   1.611061334502493e-12,  -5.434923291377391e-14,  -1.379921985322270e-15,  -5.311170812926676e-18,   1.738634995105232e+00,  -6.788449593700698e-03,  -9.807969899300679e-05,
  -5.732819585354461e-07,   9.803727093849507e-09,   2.754177169131768e-10,   1.610790779732414e-12,  -5.435056406034361e-14,  -1.379802857122425e-15,  -5.307848680937762e-18,
   1.943125349464883e+00,  -1.893157812638827e-03,  -4.465291626504312e-05,  -8.634525532837867e-07,  -1.385513994672449e-08,  -1.715750994085162e-10,  -1.090500077872498e-12,
   1.884330499725443e-14,   8.928341857311155e-16,   2.051541515541532e-17,   1.943118971210605e+00,  -1.893527300338242e-03,  -4.466475931892783e-05,  -8.636962259917584e-07,
  -1.385742491266205e-08,  -1.715170970480245e-10,  -1.086899935217688e-12,   1.894898718259767e-14,   8.948856125418755e-16,   2.053712504170742e-17,   1.943108499053413e+00,
  -1.894133949288492e-03,  -4.468420300566597e-05,  -8.640961938255830e-07,  -1.386117047697141e-08,  -1.714216481323484e-10,  -1.080983815857468e-12,   1.912256124694205e-14,
   8.982523578443553e-16,   2.057266731448924e-17,   1.943097385626323e+00,  -1.894777752762282e-03,  -4.470483615702116e-05,  -8.645205084578736e-07,  -1.386513722546339e-08,
  -1.713200586006339e-10,  -1.074698335485203e-12,   1.930684480071029e-14,   9.018233620451709e-16,   2.061024697048019e-17,   1.943088638099615e+00,  -1.895284503359491e-03,
  -4.472107592754436e-05,  -8.648543867213684e-07,  -1.386825358188287e-08,  -1.712398819632994e-10,  -1.069745823605302e-12,   1.945195500439035e-14,   9.046327604972500e-16,
   2.063972556364532e-17,   1.943083589249381e+00,  -1.895576988650668e-03,  -4.473044876614355e-05,  -8.650470504792223e-07,  -1.387004988795135e-08,  -1.711935201855941e-10,
  -1.066885305320959e-12,   1.953573218634651e-14,   9.062537159779550e-16,   2.065669937809990e-17,   1.943081693264898e+00,  -1.895686825382680e-03,  -4.473396846403774e-05,
  -8.651193931116141e-07,  -1.387072400197884e-08,  -1.711760938117007e-10,  -1.065810712514091e-12,   1.956719725085849e-14,   9.068623243886849e-16,   2.066306586267002e-17,
   1.943081378973529e+00,  -1.895705032688434e-03,  -4.473455190981824e-05,  -8.651313846996438e-07,  -1.387083572403811e-08,  -1.711732042404465e-10,  -1.065632560177500e-12,
   1.957241334676544e-14,   9.069632059026025e-16,   2.066412081061943e-17,   3.806906410396816e-03,  -5.285569785461161e-05,   5.489681821423340e-07,  -5.075906232867702e-09,
   4.355205359725452e-11,  -3.666164074755878e-13,   2.789457834998594e-15,  -2.391879206711322e-17,   2.042057573035517e-19,   8.705337993430092e-22,   3.806984607452000e-03,
  -5.285786671630028e-05,   5.490054026024064e-07,  -5.076428557767923e-09,   4.355801779228956e-11,  -3.666878139084673e-13,   2.790280851580878e-15,  -2.391419245358602e-17,
   2.046560170385358e-19,   8.757716236496354e-22,   3.807112984411364e-03,  -5.286142741519917e-05,   5.490665096971937e-07,  -5.077286112067699e-09,   4.356781025876616e-11,
  -3.668050291025186e-13,   2.791633261420866e-15,  -2.390662229067856e-17,   2.053948655289859e-19,   8.843382705182688e-22,   3.807249207503933e-03,  -5.286520581135127e-05,
   5.491313540576235e-07,  -5.078196143271427e-09,   4.357820255661923e-11,  -3.669293898399314e-13,   2.793070032184587e-15,  -2.389856379752840e-17,   2.061783963244092e-19,
   8.933845319791100e-22,   3.807356419570946e-03,  -5.286817958785854e-05,   5.491823905378310e-07,  -5.078912414874769e-09,   4.358638260603623e-11,  -3.670272524984342e-13,
   2.794202051772192e-15,  -2.389220297275700e-17,   2.067947158486913e-19,   9.004724097654221e-22,   3.807418295265506e-03,  -5.286989587612253e-05,   5.492118461428755e-07,
  -5.079325818189013e-09,   4.359110397642281e-11,  -3.670837269799691e-13,   2.794855872738167e-15,  -2.388852451800736e-17,   2.071502758122410e-19,   9.045503046388976e-22,
   3.807441530490311e-03,  -5.287054037147101e-05,   5.492229072903711e-07,  -5.079481060719012e-09,   4.359287699323043e-11,  -3.671049329578601e-13,   2.795101485453318e-15,
  -2.388714180640385e-17,   2.072837674696142e-19,   9.060792022021324e-22,   3.807445382076506e-03,  -5.287064720643530e-05,   5.492247408483978e-07,  -5.079506794679275e-09,
   4.359317090117206e-11,  -3.671084481125713e-13,   2.795142204363797e-15,  -2.388691252755108e-17,   2.073058943210898e-19,   9.063325126414064e-22,   3.431011031353458e-02,
  -4.737132893101461e-04,   4.848598993430889e-06,  -4.361638050799856e-08,   3.574977342939081e-10,  -2.818269058893100e-12,   1.911428654091512e-14,  -1.475167101509835e-16,
   1.120246214855784e-18,   1.523446186564753e-20,   3.431080091910479e-02,  -4.737319242872215e-04,   4.848904472262213e-06,  -4.362039482208596e-08,   3.575385898783693e-10,
  -2.818708633253303e-12,   1.911882609162595e-14,  -1.474372529029456e-16,   1.123902535298517e-18,   1.528725691163298e-20,   3.431193469140950e-02,  -4.737625178585134e-04,
   4.849405990449374e-06,  -4.362698542014783e-08,   3.576056679786968e-10,  -2.819430093187873e-12,   1.912628901091880e-14,  -1.473066176605819e-16,   1.129901783531644e-18,
   1.537363890894304e-20,   3.431313775426000e-02,  -4.737949816883602e-04,   4.849938174324255e-06,  -4.363397916804288e-08,   3.576768526132610e-10,  -2.820195383245825e-12,
   1.913422202690025e-14,  -1.471677414348212e-16,   1.136263092291280e-18,   1.546490326719099e-20,   3.431408460204193e-02,  -4.738205321139846e-04,   4.850357030679223e-06,
  -4.363948372885464e-08,   3.577328822421721e-10,  -2.820797500440637e-12,   1.914047568860195e-14,  -1.470582557830666e-16,   1.141266307546364e-18,   1.553644380277245e-20,
   3.431463105883752e-02,  -4.738352782536760e-04,   4.850598770833560e-06,  -4.364266069667813e-08,   3.577652208238389e-10,  -2.821144925803719e-12,   1.914408894109341e-14,
  -1.469949937308993e-16,   1.144152486549033e-18,   1.557761700381814e-20,   3.431483626114681e-02,  -4.738408156682765e-04,   4.850689548548245e-06,  -4.364385371335486e-08,
   3.577773648099109e-10,  -2.821275374576492e-12,   1.914544653606458e-14,  -1.469712239033987e-16,   1.145236034074523e-18,   1.559305635735128e-20,   3.431487027649070e-02,
  -4.738417335788884e-04,   4.850704596353159e-06,  -4.364405147472164e-08,   3.577793778772414e-10,  -2.821296997646783e-12,   1.914567161815207e-14,  -1.469672829604216e-16,
   1.145415634839370e-18,   1.559561451207046e-20,   9.557099997386745e-02,  -1.304235717506384e-03,   1.293894664114165e-05,  -1.094718535763782e-07,   8.031394509821159e-10,
  -5.280382031289055e-12,   2.314297899092062e-14,  -9.774271209718498e-17,   1.594946681981571e-19,   6.884016266131325e-20,   9.557284266063365e-02,  -1.304282480009993e-03,
   1.293963267696774e-05,  -1.094793703606648e-07,   8.031888623024963e-10,  -5.280668417741661e-12,   2.314380468095143e-14,  -9.738573978557218e-17,   1.686674676831449e-19,
   6.900109009566592e-20,   9.557586779988465e-02,  -1.304359250550158e-03,   1.294075894633698e-05,  -1.094917106711590e-07,   8.032699803592880e-10,  -5.281137793619175e-12,
   2.314518654927252e-14,  -9.679912228532445e-17,   1.837168309588619e-19,   6.926445302570946e-20,   9.557907780254266e-02,  -1.304440713183458e-03,   1.294195404668613e-05,
  -1.095048050915884e-07,   8.033560547819703e-10,  -5.281634785301268e-12,   2.314668863522663e-14,  -9.617587603150002e-17,   1.996727189917114e-19,   6.954277950698137e-20,
   9.558160416109036e-02,  -1.304504826989629e-03,   1.294289462699068e-05,  -1.095151107565546e-07,   8.034237971945451e-10,  -5.282025157852969e-12,   2.314789670554358e-14,
  -9.568480023240565e-17,   2.122208899206214e-19,   6.976101157786563e-20,   9.558306219990494e-02,  -1.304541829237124e-03,   1.294343746632268e-05,  -1.095210584723722e-07,
   8.034628932283107e-10,  -5.282250143653203e-12,   2.314860429304206e-14,  -9.540115963997953e-17,   2.194589856447635e-19,   6.988663194558280e-20,   9.558360971325100e-02,
  -1.304555724122188e-03,   1.294364131016659e-05,  -1.095232919205365e-07,   8.034775742848203e-10,  -5.282334570231458e-12,   2.314887196188253e-14,  -9.529460613963740e-17,
   2.221762619029389e-19,   6.993374209522546e-20,   9.558370047170325e-02,  -1.304558027407411e-03,   1.294367510032161e-05,  -1.095236621476849e-07,   8.034800078857430e-10,
  -5.282348562094114e-12,   2.314891643535413e-14,  -9.527694107096515e-17,   2.226266523377609e-19,   6.994154802992967e-20,   1.880905456009143e-01,  -2.518988346728850e-03,
   2.371374980171626e-05,  -1.792843103775890e-07,   1.028047776357665e-09,  -3.580459484886185e-12,  -2.490472033920666e-14,   4.042262567230242e-16,  -3.605674339407862e-18,
   1.525469804250885e-19,   1.880939220063265e-01,  -2.519064905114884e-03,   2.371462729199942e-05,  -1.792893953169229e-07,   1.027994449196365e-09,  -3.579238836740135e-12,
  -2.491868393205145e-14,   4.050159757442923e-16,  -3.586209094218958e-18,   1.528544207993941e-19,   1.880994650126298e-01,  -2.519190589666355e-03,   2.371606780139447e-05,
  -1.792977418072410e-07,   1.027906882698714e-09,  -3.577233234080610e-12,  -2.494155146805638e-14,   4.063135528935297e-16,  -3.554270769911400e-18,   1.533574276267039e-19,
   1.881053466935809e-01,  -2.519323952824190e-03,   2.371759624845667e-05,  -1.793065963644201e-07,   1.027813938931960e-09,  -3.575102807674173e-12,  -2.496573966185473e-14,
   4.076919088150387e-16,  -3.520404978368795e-18,   1.538888376851883e-19,   1.881099756963518e-01,  -2.519428911875838e-03,   2.371879911192914e-05,  -1.793135637056135e-07,
   1.027740770779256e-09,  -3.573424465057114e-12,  -2.498472087155446e-14,   4.087777845139433e-16,  -3.493769326112257e-18,   1.543053810910721e-19,   1.881126472200264e-01,
  -2.519489486416487e-03,   2.371949329497234e-05,  -1.793175841964186e-07,   1.027698535634060e-09,  -3.572455184602399e-12,  -2.499565324877856e-14,   4.094049055917815e-16,
  -3.478404171814233e-18,   1.545451033565169e-19,   1.881136504104714e-01,  -2.519512232875941e-03,   2.371975396515287e-05,  -1.793190938365307e-07,   1.027682674335830e-09,
  -3.572091082320301e-12,  -2.499975429828661e-14,   4.096404790353240e-16,  -3.472635692184808e-18,   1.546349942305742e-19,   1.881138167040027e-01,  -2.519516003433361e-03,
   2.371979717483695e-05,  -1.793193440760195e-07,   1.027680045015232e-09,  -3.572030720410611e-12,  -2.500043388614468e-14,   4.096795330943613e-16,  -3.471679552171290e-18,
   1.546498882181505e-19,   3.125898939965248e-01,  -4.071098049075014e-03,   3.527551173482256e-05,  -2.161854511406271e-07,   5.580525649781036e-10,   6.232270979795637e-12,
  -1.350442973916943e-13,   1.004259349794103e-15,  -2.348766532528672e-18,   1.713593130268518e-19,   3.125949149158898e-01,  -4.071190311980393e-03,   3.527598659081901e-05,
  -2.161765566885983e-07,   5.577641981827746e-10,   6.235286423444629e-12,  -1.350528067917930e-13,   1.005150111851516e-15,  -2.307802462899144e-18,   1.718417352930293e-19,
   3.126031576164513e-01,  -4.071341773725573e-03,   3.527676596581667e-05,  -2.161619518980823e-07,   5.572907847274561e-10,   6.240238694751250e-12,  -1.350666585355731e-13,
   1.006614206003105e-15,  -2.240581649845439e-18,   1.726307538379653e-19,   3.126119038252050e-01,  -4.071502482611595e-03,   3.527759270104563e-05,  -2.161464508613265e-07,
   5.567884393113203e-10,   6.245496065942317e-12,  -1.350811962326237e-13,   1.008170114578152e-15,  -2.169293861496256e-18,   1.734639464066735e-19,   3.126187871855272e-01,
  -4.071628958647207e-03,   3.527824317088458e-05,  -2.161342484038668e-07,   5.563930784891926e-10,   6.249635549500331e-12,  -1.350925216143739e-13,   1.009396349614503e-15,
  -2.113218149177098e-18,   1.741167648025583e-19,   3.126227597266381e-01,  -4.071701949357239e-03,   3.527861849954612e-05,  -2.161272049001355e-07,   5.561649031069460e-10,
   6.252025290483545e-12,  -1.350990112820623e-13,   1.010104724470980e-15,  -2.080867089502058e-18,   1.744923531643184e-19,   3.126242514589697e-01,  -4.071729357889901e-03,
   3.527875942592169e-05,  -2.161245597625097e-07,   5.560792200549466e-10,   6.252922806468396e-12,  -1.351014394421581e-13,   1.010370856626623e-15,  -2.068721091921427e-18,
   1.746331699599374e-19,   3.126244987351480e-01,  -4.071733901235708e-03,   3.527878278578563e-05,  -2.161241212808498e-07,   5.560650168138002e-10,   6.253071590213372e-12,
  -1.351018414815822e-13,   1.010414978712970e-15,  -2.066707832365417e-18,   1.746565007339386e-19,   4.699366336057982e-01,  -5.878166536512150e-03,   4.460648739746943e-05,
  -1.696192909123731e-07,  -1.048286577196894e-09,   2.349077223211455e-11,  -2.182967994374960e-13,   1.058164800436926e-16,   1.958992314090889e-17,   8.286639285989505e-20,
   4.699429796313490e-01,  -5.878238832613633e-03,   4.460558968986664e-05,  -1.695858590799659e-07,  -1.048751610078434e-09,   2.349109569981135e-11,  -2.182173554470108e-13,
   1.062663522163700e-16,   1.965676192192139e-17,   8.381466309144291e-20,   4.699533975668986e-01,  -5.878357508051520e-03,   4.460411567081413e-05,  -1.695309749789832e-07,
  -1.049514913529314e-09,   2.349162771254122e-11,  -2.180867431099773e-13,   1.070083666000686e-16,   1.976643099306718e-17,   8.536677504684645e-20,   4.699644516760964e-01,
  -5.878483417847272e-03,   4.460255123301033e-05,  -1.694727382465244e-07,  -1.050324669769657e-09,   2.349219356625638e-11,  -2.179478922420054e-13,   1.078004165392738e-16,
   1.988271977354578e-17,   8.700739691235227e-20,   4.699731512271810e-01,  -5.878582499370218e-03,   4.460131973014046e-05,  -1.694269052989084e-07,  -1.050961830628227e-09,
   2.349263987465072e-11,  -2.178384269194880e-13,   1.084271706469835e-16,   1.997418253305881e-17,   8.829402142065006e-20,   4.699781718717701e-01,  -5.878639677186789e-03,
   4.460060889268477e-05,  -1.694004540749045e-07,  -1.051329499850660e-09,   2.349289784125956e-11,  -2.177751766206680e-13,   1.087902458186372e-16,   2.002694450795584e-17,
   8.903473224303960e-20,   4.699800571668472e-01,  -5.878661147256623e-03,   4.460034194478184e-05,  -1.693905213519739e-07,  -1.051467554077017e-09,   2.349299478475126e-11,
  -2.177514111953456e-13,   1.089268415105009e-16,   2.004675280331059e-17,   8.931253150652434e-20,   4.699803696811283e-01,  -5.878664706187455e-03,   4.460029769321857e-05,
  -1.693888748596389e-07,  -1.051490438054450e-09,   2.349301085845406e-11,  -2.177474709811226e-13,   1.089494977711654e-16,   2.005003608205155e-17,   8.935856250949482e-20,
   6.609499741502275e-01,  -7.795533243963601e-03,   4.709343164750236e-05,   1.801979774081673e-08,  -3.772914283761908e-09,   3.457114224758310e-11,  -2.457331384157230e-14,
  -4.221850757799415e-15,   5.037019087157323e-17,   4.299916205019639e-19,   6.609566694126542e-01,  -7.795525377501592e-03,   4.709020988458251e-05,   1.806888883034984e-08,
  -3.772964338438158e-09,   3.455856158381903e-11,  -2.437143494415357e-14,  -4.219595550492298e-15,   5.042681510801016e-17,   4.319482380814939e-19,   6.609676604384054e-01,
  -7.795512448307375e-03,   4.708492080904720e-05,   1.814946687618168e-08,  -3.773046199196296e-09,   3.453791329274705e-11,  -2.403985540753470e-14,  -4.215886077068631e-15,
   5.051969742609919e-17,   4.351524531778903e-19,   6.609793223162690e-01,  -7.795498708880699e-03,   4.707930865003886e-05,   1.823494885073761e-08,  -3.773132635487117e-09,
   3.451601053417876e-11,  -2.368780295009317e-14,  -4.211940289179039e-15,   5.061814966107305e-17,   4.385416502591435e-19,   6.609884999496743e-01,  -7.795487881000910e-03,
   4.707489182174075e-05,   1.830221090237943e-08,  -3.773200353988276e-09,   3.449877778698315e-11,  -2.341057594261022e-14,  -4.208827886772964e-15,   5.069555711368433e-17,
   4.412012021728387e-19,   6.609937964107984e-01,  -7.795481626056143e-03,   4.707234277189575e-05,   1.834102405296779e-08,  -3.773239312437081e-09,   3.448883437345567e-11,
  -2.325051876164976e-14,  -4.207028837999845e-15,   5.074020030374062e-17,   4.427329692615571e-19,   6.609957852599374e-01,  -7.795479276135065e-03,   4.707138557609190e-05,
   1.835559781410536e-08,  -3.773253918427425e-09,   3.448510089009105e-11,  -2.319040359547821e-14,  -4.206352744688536e-15,   5.075695855088034e-17,   4.433075747574578e-19,
   6.609961149388482e-01,  -7.795478886542552e-03,   4.707122690706826e-05,   1.835801357282627e-08,  -3.773256338350394e-09,   3.448448203116572e-11,  -2.318043800780737e-14,
  -4.206240644459356e-15,   5.075973616842089e-17,   4.434027928085311e-19,   8.858937096051893e-01,  -9.565487436212468e-03,   3.607500464749834e-05,   3.802979065993859e-07,
  -6.122981852126918e-09,   3.504383607666140e-12,   6.816826388536979e-13,  -7.583346258325010e-15,  -3.066607822177093e-17,   2.137697842053952e-18,   8.858988328465962e-01,
  -9.565325061743752e-03,   3.606978481137714e-05,   3.803027038972875e-07,  -6.121528153134742e-09,   3.481896647968396e-12,   6.815622321682470e-13,  -7.572366096169160e-15,
  -3.058005909754109e-17,   2.138774021581220e-18,   8.859072429411966e-01,  -9.565058496330388e-03,   3.606121650202987e-05,   3.803105563820274e-07,  -6.119141855717538e-09,
   3.445004398846926e-12,   6.813648129874260e-13,  -7.554336485089149e-15,  -3.043881841519618e-17,   2.140529138155571e-18,   8.859161659741087e-01,  -9.564775647864499e-03,
   3.605212608181076e-05,   3.803188571533261e-07,  -6.116610060591641e-09,   3.405891132926994e-12,   6.811556729074042e-13,  -7.535200400251520e-15,  -3.028891612303956e-17,
   2.142375679612692e-18,   8.859231879212467e-01,  -9.564553043219201e-03,   3.604497275530347e-05,   3.803253672365210e-07,  -6.114617705990137e-09,   3.375132149082327e-12,
   6.809913225416874e-13,  -7.520136400911413e-15,  -3.017091752945974e-17,   2.143817498287464e-18,   8.859272402131556e-01,  -9.564424573158724e-03,   3.604084478421905e-05,
   3.803291152500563e-07,  -6.113467951876546e-09,   3.357389903848181e-12,   6.808965705394813e-13,  -7.511441155186272e-15,  -3.010280854498048e-17,   2.144645022957915e-18,
   8.859287618491655e-01,  -9.564376331266510e-03,   3.603929475684613e-05,   3.803305209500801e-07,  -6.113036221505826e-09,   3.350729284713509e-12,   6.808610087082711e-13,
  -7.508175717922703e-15,  -3.007723113811556e-17,   2.144954901618395e-18,   8.859290140800098e-01,  -9.564368334476710e-03,   3.603903782114719e-05,   3.803307538744460e-07,
  -6.112964656741452e-09,   3.349625285152098e-12,   6.808551148010672e-13,  -7.507634409883926e-15,  -3.007299122216615e-17,   2.145006222805792e-18,   1.143134322177665e+00,
  -1.072310946197639e-02,   3.495470629932896e-06,   8.220336305477657e-07,  -3.463726820182375e-09,  -1.052479107798228e-10,   9.784821458708262e-13,   1.179852151342054e-14,
  -2.507517065709540e-16,   3.948463819703497e-20,   1.143134813685272e+00,  -1.072275904573410e-02,   3.492524909179499e-06,   8.218841527771524e-07,  -3.461649851175900e-09,
  -1.052126468828406e-10,   9.774949954109241e-13,   1.179879730458622e-14,  -2.501730363922300e-16,   4.223386318638893e-20,   1.143135620273476e+00,  -1.072218382679801e-02,
   3.487690309754349e-06,   8.216387970911574e-07,  -3.458241686966512e-09,  -1.051547548436804e-10,   9.758760911771515e-13,   1.179926014994032e-14,  -2.492236686847584e-16,
   4.673517931410880e-20,   1.143136475716780e+00,  -1.072157353760940e-02,   3.482562162394553e-06,   8.213785050333952e-07,  -3.454627421038150e-09,  -1.050933260268341e-10,
   9.741605678578109e-13,   1.179976495274169e-14,  -2.482171501397158e-16,   5.149512490121801e-20,   1.143137148658999e+00,  -1.072109328210092e-02,   3.478527540191206e-06,
   8.211736895022621e-07,  -3.451784464941123e-09,  -1.050449805721677e-10,   9.728120769479126e-13,   1.180017212658209e-14,  -2.474256191920608e-16,   5.522941487775625e-20,
   1.143137536908416e+00,  -1.072081613540866e-02,   3.476199584445285e-06,   8.210555007590530e-07,  -3.450144336360621e-09,  -1.050170792000756e-10,   9.720344915959181e-13,
   1.180041107320456e-14,  -2.469690536965624e-16,   5.737980795526263e-20,   1.143137682677500e+00,  -1.072071206750068e-02,   3.475325509087939e-06,   8.210111224145002e-07,
  -3.449528564560781e-09,  -1.050066019069836e-10,   9.717426243588772e-13,   1.180050154750846e-14,  -2.467976546708454e-16,   5.818640582948305e-20,   1.143137706839629e+00,
  -1.072069481693631e-02,   3.475180623606622e-06,   8.210037662113057e-07,  -3.449426497520135e-09,  -1.050048651430150e-10,   9.716942497166188e-13,   1.180051658433343e-14,
  -2.467692452487665e-16,   5.832006368789492e-20,   1.425467554508774e+00,  -1.045141253215524e-02,  -5.338828111234281e-05,   8.619900430591783e-07,   1.012757009324988e-08,
  -1.438273174020252e-10,  -2.503928749893394e-12,   2.691595443508575e-14,   6.407513733737983e-16,  -4.929263274159169e-18,   1.425459974292674e+00,  -1.045104525019182e-02,
  -5.337966384420590e-05,   8.617860416643736e-07,   1.012225529463911e-08,  -1.437472746637435e-10,  -2.501391766880594e-12,   2.689121225189283e-14,   6.399706656863866e-16,
  -4.910188909441013e-18,   1.425447531022301e+00,  -1.045044236018028e-02,  -5.336552047393859e-05,   8.614512225151702e-07,   1.011353409794391e-08,  -1.436159246624867e-10,
  -2.497229134665565e-12,   2.685066417304456e-14,   6.386911576957570e-16,  -4.878929500928964e-18,   1.425434328948035e+00,  -1.044980273257889e-02,  -5.335051770781686e-05,
   8.610960651465319e-07,   1.010428554003378e-08,  -1.434766242540241e-10,  -2.492815295669688e-12,   2.680773485112304e-14,   6.373364170353958e-16,  -4.845834557227196e-18,
   1.425423939712949e+00,  -1.044929940404151e-02,  -5.333871366774116e-05,   8.608166352280102e-07,   1.009701071644481e-08,  -1.433670462339469e-10,  -2.489343776325263e-12,
   2.677401817967343e-14,   6.362723358348380e-16,  -4.819842008672100e-18,   1.425417944229608e+00,  -1.044900894804753e-02,  -5.333190261406297e-05,   8.606554031376518e-07,
   1.009281381230810e-08,  -1.433038274920676e-10,  -2.487341173677987e-12,   2.675458723158240e-14,   6.356590767720819e-16,  -4.804862578370184e-18,   1.425415692931647e+00,
  -1.044889988361058e-02,  -5.332934523921007e-05,   8.605948650036366e-07,   1.009123812386490e-08,  -1.432800921691330e-10,  -2.486589342516345e-12,   2.674729593109484e-14,
   6.354289510528881e-16,  -4.799241693238533e-18,   1.425415319750249e+00,  -1.044888180486576e-02,  -5.332892133056891e-05,   8.605848302641866e-07,   1.009097694629065e-08,
  -1.432761579075781e-10,  -2.486464724496908e-12,   2.674608756863847e-14,   6.353908128128243e-16,  -4.798310164177215e-18,   1.709974411149545e+00,  -7.596420431955973e-03,
  -1.039224758902209e-04,  -3.737150690443615e-07,   1.555712304002713e-08,   2.927893664677359e-10,  -4.994939526301117e-13,  -9.850418804725214e-14,  -1.239828900460042e-15,
   1.691610122747281e-17,   1.709959648917191e+00,  -7.596578516356972e-03,  -1.039091989275865e-04,  -3.733008805128636e-07,   1.555599942513080e-08,   2.924963983774887e-10,
  -5.043369828892810e-13,  -9.841628695469822e-14,  -1.235138118205498e-15,   1.696252665935447e-17,   1.709935415687494e+00,  -7.596837910265190e-03,  -1.038874033556110e-04,
  -3.726212237373740e-07,   1.555414740891564e-08,   2.920156344963212e-10,  -5.122741329359435e-13,  -9.827181344427966e-14,  -1.227444640581540e-15,   1.703844060314864e-17,
   1.709909704211282e+00,  -7.597112974397803e-03,  -1.038642775378425e-04,  -3.719004639789768e-07,   1.555217220281295e-08,   2.915057661730880e-10,  -5.206777699239291e-13,
  -9.811828593581495e-14,  -1.219291056749633e-15,   1.711858268831562e-17,   1.709889470486277e+00,  -7.597329326205770e-03,  -1.038460781009904e-04,  -3.713335180213971e-07,
   1.555061042046895e-08,   2.911046850288088e-10,  -5.272782409413215e-13,  -9.799729296932497e-14,  -1.212881235428997e-15,   1.718135957021680e-17,   1.709877793745797e+00,
  -7.597454136927639e-03,  -1.038355751326434e-04,  -3.710064409502661e-07,   1.554970616818004e-08,   2.908732886307683e-10,  -5.310821993510136e-13,  -9.792739917440191e-14,
  -1.209184846137825e-15,   1.721747106897564e-17,   1.709873409115297e+00,  -7.597500995119918e-03,  -1.038316312170680e-04,  -3.708836426572135e-07,   1.554936606142964e-08,
   2.907864112347688e-10,  -5.325096216856573e-13,  -9.790114083007264e-14,  -1.207797352867078e-15,   1.723100895728041e-17,   1.709872682305394e+00,  -7.597508762036202e-03,
  -1.038309774594322e-04,  -3.708632882640297e-07,   1.554930965480709e-08,   2.907720108148677e-10,  -5.327461845246261e-13,  -9.789678747312283e-14,  -1.207567384364597e-15,
   1.723325187795671e-17,   1.934766974717239e+00,  -2.295864336553424e-03,  -5.646163528084345e-05,  -1.113761691092389e-06,  -1.748570249009446e-08,  -1.874104461581973e-10,
  -3.287967872046550e-14,   6.192883186464952e-14,   1.888026582353242e-15,   3.523598829014459e-17,   1.934758909788176e+00,  -2.296340762254225e-03,  -5.647656518675684e-05,
  -1.114026800417981e-06,  -1.748568264371939e-08,  -1.872224952661691e-10,  -2.530654692670872e-14,   6.210905470464743e-14,   1.890447821714061e-15,   3.522535108835247e-17,
   1.934745668365877e+00,  -2.297122973602690e-03,  -5.650107500340259e-05,  -1.114461825773345e-06,  -1.748563835176765e-08,  -1.869135543634347e-10,  -1.286709672442541e-14,
   6.240487798042373e-14,   1.894414871411120e-15,   3.520758339852575e-17,   1.934731616105793e+00,  -2.297953070974252e-03,  -5.652708175469535e-05,  -1.114923156725948e-06,
  -1.748557543256910e-08,  -1.865852154231346e-10,   3.415257433889180e-16,   6.271871206757138e-14,   1.898613589938498e-15,   3.518831573524229e-17,   1.934720555391758e+00,
  -2.298606442074460e-03,  -5.654754915917686e-05,  -1.115286034880016e-06,  -1.748551438223838e-08,  -1.863264281505821e-10,   1.074358033449221e-14,   6.296565918848839e-14,
   1.901910294509477e-15,   3.517285148314548e-17,   1.934714171431515e+00,  -2.298983547414998e-03,  -5.655936127928768e-05,  -1.115495382046889e-06,  -1.748547452454876e-08,
  -1.861769235226073e-10,   1.674953173143141e-14,   6.310816022247979e-14,   1.903809792388674e-15,   3.516380624197011e-17,   1.934711774076443e+00,  -2.299125160286933e-03,
  -5.656379684408831e-05,  -1.115573979445886e-06,  -1.748545868335907e-08,  -1.861207540493591e-10,   1.900534036159974e-14,   6.316166754951003e-14,   1.904522487228215e-15,
   3.516038687706853e-17,   1.934711376674483e+00,  -2.299148634967490e-03,  -5.656453210224238e-05,  -1.115587007322374e-06,  -1.748545601133115e-08,  -1.861114416253939e-10,
   1.937930004598509e-14,   6.317053698408509e-14,   1.904640595697830e-15,   3.515981886609717e-17,   3.603897358765362e-03,  -4.869628443735886e-05,   4.920075313556841e-07,
  -4.434308396248111e-09,   3.683896202249118e-11,  -3.069179254313761e-13,   2.220120532279307e-15,  -1.628706390470388e-17,   2.921524638121062e-19,   4.102728661108296e-21,
   3.603967438360811e-03,  -4.869817908592305e-05,   4.920390130222982e-07,  -4.434745570828206e-09,   3.684371508452120e-11,  -3.069662646367073e-13,   2.221295299100309e-15,
  -1.626615308341246e-17,   2.926677523534714e-19,   4.098769261234323e-21,   3.604082488604491e-03,  -4.870128959326438e-05,   4.920906982124467e-07,  -4.435463313257852e-09,
   3.685151982348251e-11,  -3.070455761717076e-13,   2.223225341826081e-15,  -1.623183966432139e-17,   2.935117257970377e-19,   4.092213868400659e-21,   3.604204570217330e-03,
  -4.870459026558204e-05,   4.921455441895662e-07,  -4.436224960842145e-09,   3.685980372737416e-11,  -3.071296705722747e-13,   2.225275264990464e-15,  -1.619545107959574e-17,
   2.944045877164792e-19,   4.085182874847399e-21,   3.604300652283028e-03,  -4.870718804499918e-05,   4.921887111553292e-07,  -4.436824430268994e-09,   3.686632499451353e-11,
  -3.071958089621184e-13,   2.226890009952685e-15,  -1.616682807893541e-17,   2.951053489529942e-19,   4.079595046583823e-21,   3.604356104402701e-03,  -4.870868732759806e-05,
   4.922136248154299e-07,  -4.437170415342792e-09,   3.687008926364203e-11,  -3.072339609491271e-13,   2.227822489137459e-15,  -1.615031523000257e-17,   2.955089998512649e-19,
   4.076348414893095e-21,   3.604376927467126e-03,  -4.870925033319707e-05,   4.922229803618193e-07,  -4.437300339871940e-09,   3.687150291994395e-11,  -3.072482840412749e-13,
   2.228172753551783e-15,  -1.614411563694373e-17,   2.956604288203029e-19,   4.075125156779464e-21,   3.604380379200883e-03,  -4.870934365996533e-05,   4.922245311891151e-07,
  -4.437321876917187e-09,   3.687173726087641e-11,  -3.072506581216615e-13,   2.228230820650948e-15,  -1.614308802619113e-17,   2.956855226390768e-19,   4.074922167175734e-21,
   3.248965172245998e-02,  -4.369249727246771e-04,   4.357739246746411e-06,  -3.832373810206672e-08,   3.054089214284624e-10,  -2.404362162436737e-12,   1.560282920525289e-14,
  -9.795007471011046e-17,   2.140732000560108e-18,   4.240980531924657e-20,   3.249027238555721e-02,  -4.369413460703618e-04,   4.358000207683739e-06,  -3.832716212516285e-08,
   3.054423299235975e-10,  -2.404651425763859e-12,   1.561145014554813e-14,  -9.773369492404633e-17,   2.145132733642413e-18,   4.237719663226666e-20,   3.249129133138367e-02,
  -4.369682266251396e-04,   4.358428637960336e-06,  -3.833278350948591e-08,   3.054971887261000e-10,  -2.405125831551227e-12,   1.562561538562279e-14,  -9.737859702180557e-17,
   2.152339271049839e-18,   4.232316070092544e-20,   3.249237254822800e-02,  -4.369967504093331e-04,   4.358883263686744e-06,  -3.833874863512846e-08,   3.055554163113356e-10,
  -2.405628578516816e-12,   1.564066285732795e-14,  -9.700198097748788e-17,   2.159961524475698e-18,   4.226514078904940e-20,   3.249322349804596e-02,  -4.370191998186237e-04,
   4.359241076864712e-06,  -3.834344351151064e-08,   3.056012548806223e-10,  -2.406023783931146e-12,   1.565251762418634e-14,  -9.670570625659488e-17,   2.165942578315160e-18,
   4.221898439299831e-20,   3.249371460844065e-02,  -4.370321562291101e-04,   4.359447586002010e-06,  -3.834615313311906e-08,   3.056277144907190e-10,  -2.406251680717020e-12,
   1.565936417609795e-14,  -9.653477032477763e-17,   2.169387265029613e-18,   4.219214862178772e-20,   3.249389902728380e-02,  -4.370370215689799e-04,   4.359525133778188e-06,
  -3.834717064501593e-08,   3.056376513348573e-10,  -2.406337223455540e-12,   1.566193605615188e-14,  -9.647059166509349e-17,   2.170679437668982e-18,   4.218203411734316e-20,
   3.249392959745263e-02,  -4.370378280728668e-04,   4.359537988513421e-06,  -3.834733931333971e-08,   3.056392985616341e-10,  -2.406351401554691e-12,   1.566236243121568e-14,
  -9.645995363462066e-17,   2.170893563006628e-18,   4.218035552065798e-20,   9.055305845442511e-02,  -1.205768173994314e-03,   1.169899604435355e-05,  -9.743719160214997e-08,
   7.028787284601499e-10,  -4.754485964607627e-12,   2.093901349277641e-14,  -4.028761483586308e-17,   3.856634751790230e-18,   1.396242370681504e-19,   9.055472451490704e-02,
  -1.205809795985884e-03,   1.169959644758324e-05,  -9.744395849491992e-08,   7.029236108379769e-10,  -4.754594972881184e-12,   2.095462126889739e-14,  -3.957460420063148e-17,
   3.868278326989395e-18,   1.395401888869249e-19,   9.055745968470609e-02,  -1.205878127311578e-03,   1.170058213444320e-05,  -9.745506755228416e-08,   7.029973167354844e-10,
  -4.754772389023054e-12,   2.098027719837682e-14,  -3.840440387858507e-17,   3.887341695962953e-18,   1.394007733733493e-19,   9.056036199537452e-02,  -1.205950634970681e-03,
   1.170162806216325e-05,  -9.746685526632925e-08,   7.030755573218315e-10,  -4.754958550585306e-12,   2.100754521584042e-14,  -3.716317147102966e-17,   3.907499470020818e-18,
   1.392508919159795e-19,   9.056264619002813e-02,  -1.206007700936715e-03,   1.170245124013635e-05,  -9.747613236396215e-08,   7.031371569405444e-10,  -4.755103547310444e-12,
   2.102903787385141e-14,  -3.618663632014122e-17,   3.923313096929715e-18,   1.391315234972617e-19,   9.056396446784401e-02,  -1.206040635646290e-03,   1.170292632321145e-05,
  -9.748148640017545e-08,   7.031727168590105e-10,  -4.755186621209951e-12,   2.104145474770326e-14,  -3.562318832480311e-17,   3.932419144010978e-18,   1.390620685825117e-19,
   9.056445949888751e-02,  -1.206053003113111e-03,   1.170310472370406e-05,  -9.748349690188029e-08,   7.031860717724389e-10,  -4.755217701653821e-12,   2.104611986961865e-14,
  -3.541163257283903e-17,   3.935834716635495e-18,   1.390358808277614e-19,   9.056454155761219e-02,  -1.206055053205985e-03,   1.170313429624870e-05,  -9.748383017173009e-08,
   7.031882856360287e-10,  -4.755222847635243e-12,   2.104689331018847e-14,  -3.537656547731724e-17,   3.936400694171718e-18,   1.390315342028227e-19,   1.783807739550159e-01,
  -2.337610001103516e-03,   2.165857247276165e-05,  -1.634372076441217e-07,   9.513357234238510e-10,  -4.049393196036829e-12,  -1.418977008624023e-14,   4.033148173439852e-16,
   4.432670674557390e-18,   2.997840018326386e-19,   1.783838577621448e-01,  -2.337679796369397e-03,   2.165938459485656e-05,  -1.634429598230300e-07,   9.513056502075629e-10,
  -4.048163453681943e-12,  -1.417161153422247e-14,   4.048457332499503e-16,   4.456676445878140e-18,   2.996044297508177e-19,   1.783889204142946e-01,  -2.337794378370112e-03,
   2.166071780626066e-05,  -1.634524016808672e-07,   9.512563084336096e-10,  -4.046141328978402e-12,  -1.414173279111169e-14,   4.073582923116033e-16,   4.495981906008229e-18,
   2.993066780103851e-19,   1.783942923932327e-01,  -2.337915961142772e-03,   2.166213242154306e-05,  -1.634624184874140e-07,   9.512039914872240e-10,  -4.043991209314069e-12,
  -1.410993614627814e-14,   4.100233717683712e-16,   4.537546795684441e-18,   2.989867281371213e-19,   1.783985202512305e-01,  -2.338011649171570e-03,   2.166324571306972e-05,
  -1.634703005096198e-07,   9.511628456880776e-10,  -4.042295804277946e-12,  -1.408484482205174e-14,   4.121201180899584e-16,   4.570156292746925e-18,   2.987320240406814e-19,
   1.784009602637627e-01,  -2.338066873304687e-03,   2.166388820811316e-05,  -1.634748488743403e-07,   9.511391108464368e-10,  -4.041316050508132e-12,  -1.407033723453319e-14,
   4.133299151771270e-16,   4.588934859640381e-18,   2.985838671438377e-19,   1.784018765189708e-01,  -2.338087610648226e-03,   2.166412947001778e-05,  -1.634765567351227e-07,
   9.511302002967575e-10,  -4.040947897088921e-12,  -1.406488441303411e-14,   4.137841536216651e-16,   4.595978645589189e-18,   2.985280132137589e-19,   1.784020284017158e-01,
  -2.338091048166733e-03,   2.166416946255941e-05,  -1.634768398324593e-07,   9.511287233574542e-10,  -4.040886857405870e-12,  -1.406398026204991e-14,   4.138594473773212e-16,
   4.597145844920875e-18,   2.985187430465332e-19,   2.968537052916544e-01,  -3.799110690442161e-03,   3.273842819047528e-05,  -2.064260453267430e-07,   6.525521764836201e-10,
   3.327743906190329e-12,  -1.066679539802536e-13,   1.082077256464506e-15,   8.980506586677377e-18,   4.663305198541250e-19,   2.968583653283564e-01,  -3.799198801436694e-03,
   3.273898408091523e-05,  -2.064212820445522e-07,   6.523249200308751e-10,   3.331015647862890e-12,  -1.066311949465170e-13,   1.084456627715437e-15,   9.027674672881549e-18,
   4.659752945204092e-19,   2.968660155899938e-01,  -3.799343448422307e-03,   3.273989652495596e-05,  -2.064134589646377e-07,   6.519518990043380e-10,   3.336391874544621e-12,
  -1.065707142318108e-13,   1.088361396306001e-15,   9.104928520003017e-18,   4.653869466359777e-19,   2.968741331866391e-01,  -3.799496928053175e-03,   3.274086450824361e-05,
  -2.064051534737931e-07,   6.515561727441197e-10,   3.342103441463596e-12,  -1.065063565831266e-13,   1.092502806320111e-15,   9.186655853423233e-18,   4.647556201502368e-19,
   2.968805218341685e-01,  -3.799617715880563e-03,   3.274162617836730e-05,  -2.063986136771761e-07,   6.512447905732167e-10,   3.346603523382195e-12,  -1.064555745485061e-13,
   1.095760769148447e-15,   9.250798281330718e-18,   4.642536684353134e-19,   2.968842088701562e-01,  -3.799687424316879e-03,   3.274206569785363e-05,  -2.063948380964121e-07,
   6.510651085008849e-10,   3.349202632016744e-12,  -1.064262143138950e-13,   1.097640459895780e-15,   9.287744998938806e-18,   4.639619419972314e-19,   2.968855933930993e-01,
  -3.799713600418096e-03,   3.274223073135170e-05,  -2.063934200756356e-07,   6.509976403838413e-10,   3.350179005540595e-12,  -1.064151792584034e-13,   1.098346199448584e-15,
   9.301605412252704e-18,   4.638520103999174e-19,   2.968858228978200e-01,  -3.799717939475759e-03,   3.274225808746554e-05,  -2.063931850050638e-07,   6.509864568040065e-10,
   3.350340873599119e-12,  -1.064133495129124e-13,   1.098463180438910e-15,   9.303902264743150e-18,   4.638337673368479e-19,   4.471244224083046e-01,  -5.529707630288831e-03,
   4.248500817780284e-05,  -1.829156640602884e-07,  -6.302332276876498e-10,   1.836393768948779e-11,  -2.054760161586039e-13,   8.706505275563141e-16,   3.118971930310422e-17,
   5.795055058806581e-19,   4.471304672499190e-01,  -5.529785628607222e-03,   4.248446758104658e-05,  -1.828895084182590e-07,  -6.306703402101011e-10,   1.836658679194327e-11,
  -2.053500551242664e-13,   8.736060729198220e-16,   3.127107206409815e-17,   5.790180942125355e-19,   4.471403907800350e-01,  -5.529913667397908e-03,   4.248357983466897e-05,
  -1.828465669530333e-07,  -6.313877359470580e-10,   1.837094209766179e-11,  -2.051430371134463e-13,   8.784562116183515e-16,   3.140432696346858e-17,   5.782096270215437e-19,
   4.471509203367907e-01,  -5.530049515479853e-03,   4.248263750119451e-05,  -1.828009990040190e-07,  -6.321486827677740e-10,   1.837557207599826e-11,  -2.049230593695310e-13,
   8.836000289318381e-16,   3.154531447957134e-17,   5.773405091195737e-19,   4.471592070985013e-01,  -5.530156420690755e-03,   4.248189561488703e-05,  -1.827651340811754e-07,
  -6.327473595298798e-10,   1.837922216329546e-11,  -2.047497075720134e-13,   8.876463772981855e-16,   3.165597819160206e-17,   5.766483567359693e-19,   4.471639895287636e-01,
  -5.530218114594200e-03,   4.248146735161914e-05,  -1.827444346466389e-07,  -6.330927904282704e-10,   1.838133121279750e-11,  -2.046495715253615e-13,   8.899808529791097e-16,
   3.171972642553523e-17,   5.762456372922507e-19,   4.471657853747313e-01,  -5.530241280666556e-03,   4.248130651443771e-05,  -1.827366615977140e-07,  -6.332224885740065e-10,
   1.838212365672325e-11,  -2.046119521954703e-13,   8.908573293308230e-16,   3.174364222277204e-17,   5.760937954145585e-19,   4.471660830616868e-01,  -5.530245120742891e-03,
   4.248127985231419e-05,  -1.827353730927533e-07,  -6.332439871282168e-10,   1.838225504069638e-11,  -2.046057153434788e-13,   8.910026103027159e-16,   3.174760543206607e-17,
   5.760685929236840e-19,   6.305213255779790e-01,  -7.418894918736005e-03,   4.697008113152168e-05,  -3.688419522358197e-08,  -3.095951520767569e-09,   3.276226153810664e-11,
  -1.172827597637971e-13,  -2.273603525381916e-15,   7.460691166330399e-17,   9.634641936902720e-19,   6.305280044468424e-01,  -7.418910500907979e-03,   4.696743627513689e-05,
  -3.683762874828760e-08,  -3.096198315597133e-09,   3.275554572832142e-11,  -1.169834654392629e-13,  -2.268674628215217e-15,   7.470446965921673e-17,   9.632164446387626e-19,
   6.305389686190664e-01,  -7.418936067209962e-03,   4.696309416402684e-05,  -3.676118921530345e-08,  -3.096603006425175e-09,   3.274453128096221e-11,  -1.164918470855284e-13,
  -2.260584063498008e-15,   7.486415649486276e-17,   9.627964047749401e-19,   6.305506020836589e-01,  -7.418963175523688e-03,   4.695848664304252e-05,  -3.668009029703267e-08,
  -3.097031785417454e-09,   3.273285856215551e-11,  -1.159698245489359e-13,  -2.252000759128045e-15,   7.503295710692768e-17,   9.623326253083511e-19,   6.305597574138748e-01,
  -7.418984495785139e-03,   4.695486035114474e-05,  -3.661627177554534e-08,  -3.097368780956025e-09,   3.272368254036022e-11,  -1.155587173568052e-13,  -2.245246695632080e-15,
   7.516534097440817e-17,   9.619545486664099e-19,   6.305650410267214e-01,  -7.418996794463659e-03,   4.695276748762556e-05,  -3.657944356437908e-08,  -3.097563084910671e-09,
   3.271839107500651e-11,  -1.153213502328289e-13,  -2.241349218234467e-15,   7.524155662215951e-17,   9.617311148556250e-19,   6.305670250556139e-01,  -7.419001411669735e-03,
   4.695198158531114e-05,  -3.656561471605578e-08,  -3.097636013426940e-09,   3.271640487024441e-11,  -1.152321959146630e-13,  -2.239885757821491e-15,   7.527014125765339e-17,
   9.616462236791183e-19,   6.305673539357325e-01,  -7.419002176981286e-03,   4.695185131015983e-05,  -3.656332241346596e-08,  -3.097648100549508e-09,   3.271607567021337e-11,
  -1.152174162239633e-13,  -2.239643172609341e-15,   7.527487771845126e-17,   9.616320995613047e-19,   8.482355252054489e-01,  -9.260287811939476e-03,   4.005576559448888e-05,
   2.837065735287357e-07,  -5.906746229553820e-09,   1.728099179637548e-11,   4.679885705100980e-13,  -7.217975349074283e-15,   5.732561518409413e-17,   2.774578821709570e-18,
   8.482412153044805e-01,  -9.260166605140341e-03,   4.005072783110024e-05,   2.837309856488525e-07,  -5.905744515141746e-09,   1.725964780793580e-11,   4.682190854828420e-13,
  -7.203791435524752e-15,   5.742714199550361e-17,   2.773466114695040e-18,   8.482505560059591e-01,  -9.259967617066375e-03,   4.004245814600548e-05,   2.837710402365767e-07,
  -5.904099682003174e-09,   1.722463881263539e-11,   4.685978020817039e-13,  -7.180510530091529e-15,   5.759321472341419e-17,   2.771617607399587e-18,   8.482604665096173e-01,
  -9.259756465154262e-03,   4.003368421209385e-05,   2.838135115599554e-07,  -5.902353901727262e-09,   1.718753316740438e-11,   4.690000414427107e-13,  -7.155813556842620e-15,
   5.776861503305605e-17,   2.769626575557663e-18,   8.482682656194556e-01,  -9.259590280117400e-03,   4.002677968908344e-05,   2.838469152318651e-07,  -5.900979611992689e-09,
   1.715836094839319e-11,   4.693168888471095e-13,  -7.136381191518582e-15,   5.790606519102456e-17,   2.768038199453093e-18,   8.482727664343809e-01,  -9.259494368528640e-03,
   4.002279519802168e-05,   2.838661845372137e-07,  -5.900186341558375e-09,   1.714153716210621e-11,   4.694998608402167e-13,  -7.125168121521348e-15,   5.798515346619738e-17,
   2.767112936842621e-18,   8.482744564966086e-01,  -9.259458352215035e-03,   4.002129902816313e-05,   2.838734187267208e-07,  -5.899888433972621e-09,   1.713522194458780e-11,
   4.695685900023188e-13,  -7.120957830208720e-15,   5.801480711485948e-17,   2.766763870822949e-18,   8.482747366465814e-01,  -9.259452381966076e-03,   4.002105101902828e-05,
   2.838746178114004e-07,  -5.899839050120039e-09,   1.713417522724630e-11,   4.695799839707927e-13,  -7.120259931493682e-15,   5.801972026875244e-17,   2.766705922657153e-18,
   1.100358756472260e+00,  -1.065678141126968e-02,   1.296229408628682e-05,   7.511465536280435e-07,  -5.311677402451607e-09,  -7.867977249208147e-11,   1.201845682324086e-12,
   4.517936390665914e-15,  -1.820258621258691e-16,   3.761583545168771e-18,   1.100360592010885e+00,  -1.065646112538406e-02,   1.295777322531345e-05,   7.510347033844612e-07,
  -5.309120393476764e-09,  -7.866596536282803e-11,   1.201131847932334e-12,   4.537070009991642e-15,  -1.814720621635254e-16,   3.756496269324433e-18,   1.100363604882014e+00,
  -1.065593535873770e-02,   1.295035307550281e-05,   7.508510974308532e-07,  -5.304923744545355e-09,  -7.864325748596866e-11,   1.199961560795792e-12,   4.568461921297034e-15,
  -1.805641933643917e-16,   3.748120195991104e-18,   1.100366801142544e+00,  -1.065537752653378e-02,   1.294248186341493e-05,   7.506562968124477e-07,  -5.300472262697402e-09,
  -7.861910664788394e-11,   1.198721951271415e-12,   4.601745264105031e-15,  -1.796026192085592e-16,   3.739199293128063e-18,   1.100369316161326e+00,  -1.065493854357145e-02,
   1.293628872751919e-05,   7.505030018307333e-07,  -5.296969998680427e-09,  -7.860005926500098e-11,   1.197747931164938e-12,   4.627920637561410e-15,  -1.788471189507807e-16,
   3.732154457536319e-18,   1.100370767445461e+00,  -1.065468521151333e-02,   1.293271516866345e-05,   7.504145379686311e-07,  -5.294949204435054e-09,  -7.858905040072704e-11,
   1.197186429556286e-12,   4.643019411747655e-15,  -1.784116116348600e-16,   3.728079119264677e-18,   1.100371312382615e+00,  -1.065459008537563e-02,   1.293137337913707e-05,
   7.503813199810329e-07,  -5.294190457486572e-09,  -7.858491339253738e-11,   1.196975698082175e-12,   4.648687723857138e-15,  -1.782481700847005e-16,   3.726546970990161e-18,
   1.100371402711930e+00,  -1.065457431699223e-02,   1.293115096450793e-05,   7.503758136806996e-07,  -5.294064688611758e-09,  -7.858422746226486e-11,   1.196940772545553e-12,
   4.649627252367445e-15,  -1.782210823613408e-16,   3.726292899591587e-18,   1.382876778903660e+00,  -1.083462695747069e-02,  -4.217686117870622e-05,   9.980492063885664e-07,
   6.722299328574478e-09,  -1.927530894805017e-10,  -1.495310973020171e-12,   4.387197360307786e-14,   4.053633783310631e-16,  -7.201662927551361e-18,   1.382870788332560e+00,
  -1.083420183324019e-02,  -4.217113934949057e-05,   9.977760061394775e-07,   6.719126636680188e-09,  -1.926225576620322e-10,  -1.493693704819857e-12,   4.383574726525263e-14,
   4.054635667780125e-16,  -7.176658546536844e-18,   1.382860954425933e+00,  -1.083350400703613e-02,  -4.216174799241851e-05,   9.973276377240429e-07,   6.713920645611730e-09,
  -1.924083463666814e-10,  -1.491038415713918e-12,   4.377636753622992e-14,   4.056268220992140e-16,  -7.135731563509761e-18,   1.382850520686352e+00,  -1.083276367366873e-02,
  -4.215178568825030e-05,   9.968520662653798e-07,   6.708400079423717e-09,  -1.921811572681186e-10,  -1.488220567935619e-12,   4.371348539151419e-14,   4.057983886545748e-16,
  -7.092470141397953e-18,   1.382842309854265e+00,  -1.083218111006127e-02,  -4.214394722162674e-05,   9.964779208274884e-07,   6.704057821413660e-09,  -1.920024346565104e-10,
  -1.486002632724647e-12,   4.366408664324242e-14,   4.059322093556818e-16,  -7.058542673707291e-18,   1.382837571453287e+00,  -1.083184493433322e-02,  -4.213942425831594e-05,
   9.962620469994492e-07,   6.701552804189604e-09,  -1.918993209407375e-10,  -1.484722509530744e-12,   4.363561360437235e-14,   4.060089572434435e-16,  -7.039010316698021e-18,
   1.382835792180217e+00,  -1.083171870326406e-02,  -4.213772598595009e-05,   9.961809942126563e-07,   6.700612331454049e-09,  -1.918606064951838e-10,  -1.484241789921408e-12,
   4.362492848150287e-14,   4.060376855637719e-16,  -7.031684759880703e-18,   1.382835497242538e+00,  -1.083169777898771e-02,  -4.213744448066311e-05,   9.961675590796502e-07,
   6.700456444456400e-09,  -1.918541893265273e-10,  -1.484162102678874e-12,   4.362315762726895e-14,   4.060424428777652e-16,  -7.030470920594734e-18,   1.677904116787003e+00,
  -8.441071168644117e-03,  -1.067251783021578e-04,  -7.961526060908495e-08,   2.104962084203650e-08,   2.439982076518358e-10,  -3.678481498362997e-12,  -1.223598474841135e-13,
  -5.984585326581622e-17,   4.875076690839844e-17,   1.677888965063117e+00,  -8.441103942812247e-03,  -1.067072497060896e-04,  -7.927108350814250e-08,   2.104176717196595e-08,
   2.436365020067236e-10,  -3.678623288262228e-12,  -1.221117590189474e-13,  -5.517106546424818e-17,   4.868892970327648e-17,   1.677864092892369e+00,  -8.441157641424384e-03,
  -1.066778218604355e-04,  -7.870643147133572e-08,   2.102887393362225e-08,   2.430432384189485e-10,  -3.678842693982539e-12,  -1.217047119649600e-13,  -4.751373701593296e-17,
   4.858723492616864e-17,   1.677837704092033e+00,  -8.441214476495677e-03,  -1.066466032283303e-04,  -7.810779508960989e-08,   2.101519299428883e-08,   2.424144664194703e-10,
  -3.679057362690637e-12,  -1.212731169543808e-13,  -3.941192757695458e-17,   4.847908646659269e-17,   1.677816937773818e+00,  -8.441259102286306e-03,  -1.066220387696692e-04,
  -7.763702911169393e-08,   2.100442587487821e-08,   2.419201453568628e-10,  -3.679213197016521e-12,  -1.209336765866347e-13,  -3.305254683128183e-17,   4.839379817824612e-17,
   1.677804953849493e+00,  -8.441284815146964e-03,  -1.066078640518323e-04,  -7.736548669188712e-08,   2.099821190319226e-08,   2.416350737034603e-10,  -3.679297883436971e-12,
  -1.207378700680642e-13,  -2.938914676687237e-17,   4.834450675199449e-17,   1.677800453903574e+00,  -8.441294462729263e-03,  -1.066025416656459e-04,  -7.726354736750669e-08,
   2.099587848469377e-08,   2.415280662785823e-10,  -3.679328692813933e-12,  -1.206643600135805e-13,  -2.801477363931973e-17,   4.832598414733579e-17,   1.677799707980346e+00,
  -8.441296061539911e-03,  -1.066016594230129e-04,  -7.724665091874856e-08,   2.099549168664059e-08,   2.415103303664789e-10,  -3.679333747638270e-12,  -1.206521755796162e-13,
  -2.778701860395072e-17,   4.832291306559399e-17,   1.924588399113670e+00,  -2.806055752339540e-03,  -7.162729141942952e-05,  -1.422833069699017e-06,  -2.106071927905553e-08,
  -1.592912473968496e-10,   2.757488478550348e-12,   1.453427355100034e-13,   3.393242056367954e-15,   4.623110448277191e-17,   1.924578169931205e+00,  -2.806663978166890e-03,
  -7.164523964937761e-05,  -1.423056050851767e-06,  -2.105467248106581e-08,  -1.588531808717217e-10,   2.771011126025663e-12,   1.455757799486013e-13,   3.393357557080342e-15,
   4.609013769075051e-17,   1.924561375231630e+00,  -2.807662547264959e-03,  -7.167470079163083e-05,  -1.423421658383391e-06,  -2.104472481889530e-08,  -1.581335228618389e-10,
   2.793210933744623e-12,   1.459578335249186e-13,   3.393522806000167e-15,   4.585810661248711e-17,   1.924543552255340e+00,  -2.808722198555430e-03,  -7.170595619358399e-05,
  -1.423808981482860e-06,  -2.103414122347911e-08,  -1.573692299344619e-10,   2.816766869806979e-12,   1.463625049818846e-13,   3.393665019447430e-15,   4.561107361442705e-17,
   1.924529523667971e+00,  -2.809556216457678e-03,  -7.173055062707839e-05,  -1.424113361480626e-06,  -2.102579134690907e-08,  -1.567672354236416e-10,   2.835305647356596e-12,
   1.466804635036779e-13,   3.393752944233172e-15,   4.541605687814638e-17,   1.924521426769845e+00,  -2.810037571242124e-03,  -7.174474305774613e-05,  -1.424288846551253e-06,
  -2.102096423985118e-08,  -1.564196155799773e-10,   2.846004781358957e-12,   1.468637548051372e-13,   3.393794063833784e-15,   4.530326838708795e-17,   1.924518386166863e+00,
  -2.810218329802831e-03,  -7.175007217326649e-05,  -1.424354709178470e-06,  -2.101915005758970e-08,  -1.562890436487551e-10,   2.850022419499571e-12,   1.469325430118988e-13,
   3.393807685239694e-15,   4.526086974782313e-17,   1.924517882136157e+00,  -2.810248293388096e-03,  -7.175095553549186e-05,  -1.424365625070376e-06,  -2.101884924884920e-08,
  -1.562673975189585e-10,   2.850688400865607e-12,   1.469439435570789e-13,   3.393809847189118e-15,   4.525383916987434e-17,   3.416660888031616e-03,  -4.496349918412067e-05,
   4.421388092491338e-07,  -3.891230922926420e-09,   3.120260976241215e-11,  -2.578935830347170e-13,   1.921270526037443e-15,  -4.021827295325560e-18,   4.874443311244585e-19,
   6.205657826458625e-21,   3.416723861256403e-03,  -4.496516173330726e-05,   4.421654747913950e-07,  -3.891598021300040e-09,   3.120673398696079e-11,  -2.579051082378822e-13,
   1.923211981994049e-15,  -3.990824176672430e-18,   4.874085456011414e-19,   6.176310483354936e-21,   3.416827244746236e-03,  -4.496789119024871e-05,   4.422092531485272e-07,
  -3.892200684360157e-09,   3.121350756415687e-11,  -2.579239622722879e-13,   1.926399071388555e-15,  -3.940036476033304e-18,   4.873460004399740e-19,   6.128096498603226e-21,
   3.416936946356950e-03,  -4.497078750912972e-05,   4.422557088412201e-07,  -3.892840172269216e-09,   3.122069892363576e-11,  -2.579438776756406e-13,   1.929780644010438e-15,
  -3.886294925683317e-18,   4.872744779083968e-19,   6.076889562571179e-21,   3.417023284807467e-03,  -4.497306703889457e-05,   4.422922722303283e-07,  -3.893343464042224e-09,
   3.122636150844808e-11,  -2.579594860083743e-13,   1.932441827627130e-15,  -3.844107346249707e-18,   4.872144582375273e-19,   6.036554692925367e-21,   3.417073113500483e-03,
  -4.497438264482688e-05,   4.423133746855031e-07,  -3.893633928137474e-09,   3.122963067819134e-11,  -2.579684677827304e-13,   1.933977594347714e-15,  -3.819803100083712e-18,
   4.871783250897101e-19,   6.013262769385282e-21,   3.417091824875271e-03,  -4.497487667639130e-05,   4.423212990578818e-07,  -3.893743001156510e-09,   3.123085850721640e-11,
  -2.579718355991868e-13,   1.934554279559698e-15,  -3.810684749452051e-18,   4.871644743500784e-19,   6.004513802053844e-21,   3.417094926564291e-03,  -4.497495856964057e-05,
   4.423226126460881e-07,  -3.893761081616157e-09,   3.123106204923100e-11,  -2.579723936030344e-13,   1.934649872831656e-15,  -3.809173681553443e-18,   4.871621634975746e-19,
   6.003063397484041e-21,   3.080887567571892e-02,  -4.038230533918051e-04,   3.925650503765827e-06,  -3.380232056384130e-08,   2.608908619773517e-10,  -2.053474213682440e-12,
   1.408383781723064e-14,  -2.963302478188325e-19,   4.072434356989243e-18,   6.008105352969937e-20,   3.080943477293760e-02,  -4.038374946713279e-04,   3.925873435405743e-06,
  -3.380524277118123e-08,   2.609211180858439e-10,  -2.053470308824832e-12,   1.410005343383111e-14,   4.342319471777613e-21,   4.071916628657710e-18,   5.981593446447110e-20,
   3.081035264449297e-02,  -4.038612032712878e-04,   3.926239432517111e-06,  -3.381004004160610e-08,   2.609708133981344e-10,  -2.053463253562211e-12,   1.412667230323967e-14,
   4.969608732661584e-19,   4.071031969962468e-18,   5.938037516005584e-20,   3.081132660839900e-02,  -4.038863611548263e-04,   3.926627809225665e-06,  -3.381513030799863e-08,
   2.610235779595687e-10,  -2.053454892203565e-12,   1.415491462998203e-14,   1.018329068500309e-18,   4.070046120227736e-18,   5.891777505089696e-20,   3.081209314573539e-02,
  -4.039061614294824e-04,   3.926933482195951e-06,  -3.381913636810991e-08,   2.610651285583134e-10,  -2.053447679033633e-12,   1.417713974431905e-14,   1.427679198573602e-18,
   4.069236134142009e-18,   5.855339043101125e-20,   3.081253553849080e-02,  -4.039175889111722e-04,   3.927109899446226e-06,  -3.382144834112312e-08,   2.610891180865134e-10,
  -2.053443262842126e-12,   1.418996557867636e-14,   1.663534419958648e-18,   4.068755008342090e-18,   5.834297071966048e-20,   3.081270166308383e-02,  -4.039218801114691e-04,
   3.927176147277278e-06,  -3.382231650947466e-08,   2.610981282574742e-10,  -2.053441556672248e-12,   1.419478167042987e-14,   1.752026904391837e-18,   4.068571758671165e-18,
   5.826393221695296e-20,   3.081272920070343e-02,  -4.039225914428913e-04,   3.927187128877358e-06,  -3.382246042077879e-08,   2.610996219206439e-10,  -2.053441271326953e-12,
   1.419557999932782e-14,   1.766691922591592e-18,   4.068541246221090e-18,   5.825082919895919e-20,   8.591002506864778e-02,  -1.116669057909219e-03,   1.059417628423597e-05,
  -8.692461361105698e-08,   6.128165386197385e-10,  -4.246420459488498e-12,   2.238708759854117e-14,   1.760195557862379e-16,   9.947798158061713e-18,   1.853119661839071e-19,
   8.591153375055868e-02,  -1.116706189274714e-03,   1.059469980766544e-05,  -8.693065199957362e-08,   6.128647965711294e-10,  -4.245879624307240e-12,   2.242668032466048e-14,
   1.769487926947532e-16,   9.945708206487750e-18,   1.845631720073844e-19,   8.591401055005067e-02,  -1.116767148284627e-03,   1.059555928606069e-05,  -8.694056442944978e-08,
   6.129440808717530e-10,  -4.244989761770417e-12,   2.249167160550112e-14,   1.784715058617537e-16,   9.942177974494684e-18,   1.833329818146780e-19,   8.591663869909967e-02,
  -1.116831833039168e-03,   1.059647129980585e-05,  -8.695108151859736e-08,   6.130282906272428e-10,  -4.244042842042998e-12,   2.256062326904285e-14,   1.800834426360274e-16,
   9.938297349769877e-18,   1.820264044940450e-19,   8.591870711933122e-02,  -1.116882742115303e-03,   1.059718908893019e-05,  -8.695935796822572e-08,   6.130946242260811e-10,
  -4.243295654033833e-12,   2.261488187284094e-14,   1.813493073644903e-16,   9.935145773034403e-18,   1.809972194457892e-19,   8.591990086638740e-02,  -1.116912123473944e-03,
   1.059760335090615e-05,  -8.696413424646980e-08,   6.131329307241031e-10,  -4.242863653530212e-12,   2.264619284082571e-14,   1.820787646534685e-16,   9.933287877030096e-18,
   1.804028962922833e-19,   8.592034913430235e-02,  -1.116923156605257e-03,   1.059775891263535e-05,  -8.696592774432262e-08,   6.131473197464071e-10,  -4.242701285020817e-12,
   2.265794989922636e-14,   1.823524755288130e-16,   9.932582838972747e-18,   1.801796540691019e-19,   8.592042344133799e-02,  -1.116924985512030e-03,   1.059778469933671e-05,
  -8.696622504004046e-08,   6.131497051729164e-10,  -4.242674362309804e-12,   2.265989877231889e-14,   1.823978360715307e-16,   9.932465579587842e-18,   1.801426448928695e-19,
   1.693648069540746e-01,  -2.171933898557177e-03,   1.978593315726186e-05,  -1.488779769695324e-07,   8.679858033053812e-10,  -4.227454061599961e-12,   9.021240534485826e-16,
   7.435027908173394e-16,   1.741624236504468e-17,   3.938961669210177e-19,   1.693676241281331e-01,  -2.171997479029531e-03,   1.978667429778745e-05,  -1.488839738927719e-07,
   8.679885521243261e-10,  -4.225200630437320e-12,   9.714301095252981e-16,   7.454796141090007e-16,   1.741205883624890e-17,   3.923660160664594e-19,   1.693722490516615e-01,
  -2.172101858514040e-03,   1.978789100190276e-05,  -1.488938164822124e-07,   8.679931716346544e-10,  -4.221497015247549e-12,   1.085194011318347e-15,   7.487192092769107e-16,
   1.740498871710506e-17,   3.898521242478162e-19,   1.693771565568004e-01,  -2.172212615727700e-03,   1.978918202175968e-05,  -1.489042570604852e-07,   8.679982185383858e-10,
  -4.217561433085267e-12,   1.205888037075806e-15,   7.521489464293655e-16,   1.739721219447571e-17,   3.871821155127596e-19,   1.693810188643094e-01,  -2.172299784056370e-03,
   1.979019806319481e-05,  -1.489124715535340e-07,   8.680022956311412e-10,  -4.214459943989213e-12,   1.300861393525448e-15,   7.548425724089757e-16,   1.739089338381312e-17,
   3.850789472671395e-19,   1.693832479076334e-01,  -2.172350091332634e-03,   1.979078444139584e-05,  -1.489172113767694e-07,   8.680046907485267e-10,  -4.212668346087116e-12,
   1.355666890381923e-15,   7.563948728199496e-16,   1.738716709895379e-17,   3.838644256001901e-19,   1.693840849412629e-01,  -2.172368982352950e-03,   1.979100463239748e-05,
  -1.489189910533119e-07,   8.680055981048550e-10,  -4.211995268217028e-12,   1.376245853031049e-15,   7.569773528384287e-16,   1.738575280746072e-17,   3.834082206457686e-19,
   1.693842236918686e-01,  -2.172372113817240e-03,   1.979104113221604e-05,  -1.489192860509803e-07,   8.680057489323835e-10,  -4.211883679310946e-12,   1.379657055211129e-15,
   7.570738848565237e-16,   1.738551757541649e-17,   3.833325907662673e-19,   2.821656451780184e-01,  -3.546930012155896e-03,   3.032573642714593e-05,  -1.955807629203499e-07,
   6.962016518161691e-10,   1.181201329515145e-12,  -6.944707145923183e-14,   1.688758626441092e-15,   3.013078233595972e-17,   6.590496969979066e-19,   2.821699619468321e-01,
  -3.547013503794622e-03,   3.032633004367791e-05,  -1.955790388816031e-07,   6.960548344986185e-10,   1.186300752047116e-12,  -6.932709023431111e-14,   1.692062180845797e-15,
   3.012735615024165e-17,   6.563414758691945e-19,   2.821770486826127e-01,  -3.547150568294045e-03,   3.032730447116216e-05,  -1.955762033258933e-07,   6.958139951722815e-10,
   1.194679367904856e-12,  -6.913013352395326e-14,   1.697475446733607e-15,   3.012137846045939e-17,   6.518921400574211e-19,   2.821845683401209e-01,  -3.547296003590016e-03,
   3.032833829161446e-05,  -1.955731874197005e-07,   6.955586975353825e-10,   1.203579348848575e-12,  -6.892116394564845e-14,   1.703205670147850e-15,   3.011455619210599e-17,
   6.471665105195167e-19,   2.821904864102830e-01,  -3.547410461402094e-03,   3.032915182515752e-05,  -1.955708086967432e-07,   6.953579590391872e-10,   1.210590637814636e-12,
  -6.875671632806404e-14,   1.707705483271277e-15,   3.010884015092273e-17,   6.434441404807605e-19,   2.821939018684245e-01,  -3.547476517030902e-03,   3.032962129578025e-05,
  -1.955694338081962e-07,   6.952421819136291e-10,   1.214639775482280e-12,  -6.866181556232160e-14,   1.710298442135060e-15,   3.010540235559054e-17,   6.412945794013656e-19,
   2.821951844114797e-01,  -3.547501321536141e-03,   3.032979757996082e-05,  -1.955689171304191e-07,   6.951987202464456e-10,   1.216160793100414e-12,  -6.862618037542470e-14,
   1.711271373151843e-15,   3.010408517587342e-17,   6.404871510066227e-19,   2.821953970115897e-01,  -3.547505433235808e-03,   3.032982680123328e-05,  -1.955688314629223e-07,
   6.951915165807346e-10,   1.216412951290436e-12,  -6.862027338599537e-14,   1.711432610779996e-15,   3.010386544976146e-17,   6.403532951832717e-19,   4.256712430875570e-01,
  -5.198752717433553e-03,   4.024079822611173e-05,  -1.903185082999929e-07,  -3.096170486212039e-10,   1.386046567675604e-11,  -1.633320399866688e-13,   2.291507895187102e-15,
   5.978037514298874e-17,   9.307444106103246e-19,   4.256769691131746e-01,  -5.198833898696149e-03,   4.024053190348996e-05,  -1.902987253276759e-07,  -3.099628690249128e-10,
   1.386738783882422e-11,  -1.630938157137882e-13,   2.296159354312391e-15,   5.978203324742606e-17,   9.263991536832558e-19,   4.256863692835135e-01,  -5.198967164762994e-03,
   4.024009447926949e-05,  -1.902662412252099e-07,  -3.105302216498468e-10,   1.387876165949560e-11,  -1.627027305342764e-13,   2.303779347093639e-15,   5.978417937691572e-17,
   9.192603454129539e-19,   4.256963435535304e-01,  -5.199108562049476e-03,   4.023963004963283e-05,  -1.902317633563126e-07,  -3.111317271245731e-10,   1.389084369510570e-11,
  -1.622877578273303e-13,   2.311842815274375e-15,   5.978567442961297e-17,   9.116782513757924e-19,   4.257041933294894e-01,  -5.199219836439224e-03,   4.023926433211585e-05,
  -1.902046220463102e-07,  -3.116047534359169e-10,   1.390036210372457e-11,  -1.619611720395083e-13,   2.318172918448873e-15,   5.978628518452317e-17,   9.057058625358405e-19,
   4.257087235778856e-01,  -5.199284052652949e-03,   4.023905318565893e-05,  -1.901889554397342e-07,  -3.118776011997772e-10,   1.390585928006740e-11,  -1.617726931951244e-13,
   2.321819773023771e-15,   5.978641098478224e-17,   9.022569859905248e-19,   4.257104247291638e-01,  -5.199308166023737e-03,   4.023897388224335e-05,  -1.901830719388915e-07,
  -3.119800308474428e-10,   1.390792426413658e-11,  -1.617019175805816e-13,   2.323187998522116e-15,   5.978641539686469e-17,   9.009615035310433e-19,   4.257107067192303e-01,
  -5.199312163136040e-03,   4.023896073573254e-05,  -1.901820966362215e-07,  -3.119970085821830e-10,   1.390826660381128e-11,  -1.616901855135545e-13,   2.323414737923743e-15,
   5.978641386933112e-17,   9.007467379504313e-19,   6.015933394550906e-01,  -7.045698091043556e-03,   4.625134065509034e-05,  -8.134673400438180e-08,  -2.472465299359838e-09,
   2.948948215193477e-11,  -1.415008453937331e-13,   7.778246453872641e-16,   1.187311126781730e-16,   1.383779477056762e-18,   6.015999171118958e-01,  -7.045732671418986e-03,
   4.624922787851496e-05,  -8.130474764826295e-08,  -2.472761731585690e-09,   2.949191686161232e-11,  -1.410279645926372e-13,   7.847432463159368e-16,   1.187215759169843e-16,
   1.377433914966467e-18,   6.016107151828248e-01,  -7.045789427742753e-03,   4.624575923257092e-05,  -8.123581769745505e-08,  -2.473247643609067e-09,   2.949592866465132e-11,
  -1.402516868972136e-13,   7.960776891578622e-16,   1.187050089582681e-16,   1.367008184212576e-18,   6.016221724754172e-01,  -7.045849632976196e-03,   4.624207848502047e-05,
  -8.116267421499415e-08,  -2.473762242467125e-09,   2.950020562919600e-11,  -1.394280421031110e-13,   8.080723715139525e-16,   1.186861931440105e-16,   1.355934215163557e-18,
   6.016311892111454e-01,  -7.045897002058910e-03,   4.623918153934973e-05,  -8.110510738575086e-08,  -2.474166516728828e-09,   2.950358617652942e-11,  -1.387798636379958e-13,
   8.174890401204748e-16,   1.186704900866784e-16,   1.347210675161911e-18,   6.016363928599695e-01,  -7.045924334570918e-03,   4.623750958406434e-05,  -8.107188342892928e-08,
  -2.474399543611337e-09,   2.950554298313415e-11,  -1.384058012978611e-13,   8.229142758201825e-16,   1.186610690514543e-16,   1.342172845662370e-18,   6.016383468656525e-01,
  -7.045934597234752e-03,   4.623688173476176e-05,  -8.105940731085768e-08,  -2.474486993145707e-09,   2.950627888390564e-11,  -1.382653398838144e-13,   8.249497459620323e-16,
   1.186574636275584e-16,   1.340280467330433e-18,   6.016386707692093e-01,  -7.045936298367208e-03,   4.623677765904270e-05,  -8.105733920557661e-08,  -2.474501486289145e-09,
   2.950640092802377e-11,  -1.382420565381732e-13,   8.252870614226482e-16,   1.186568624044751e-16,   1.339966745685089e-18,   8.118545989487259e-01,  -8.927800496490279e-03,
   4.290640296358307e-05,   1.925100868087588e-07,  -5.463701555261490e-09,   2.639109652938489e-11,   3.073608997928034e-13,  -3.682964122999132e-15,   1.655297244092621e-16,
   3.067186661591416e-18,   8.118606954712519e-01,  -8.927718177345804e-03,   4.290174157986277e-05,   1.925475526559611e-07,  -5.463037645237105e-09,   2.638033658753216e-11,
   3.080189267098432e-13,  -3.667510514696029e-15,   1.654565993508887e-16,   3.057524813790929e-18,   8.118707034211015e-01,  -8.927583025603545e-03,   4.289408957606256e-05,
   1.926090479444797e-07,  -5.461946715042649e-09,   2.636270561146484e-11,   3.090989661649659e-13,  -3.642176801360665e-15,   1.653352189711019e-16,   3.041648756388587e-18,
   8.118813219790710e-01,  -8.927439603471308e-03,   4.288597076884845e-05,   1.926742843174701e-07,  -5.460787775260070e-09,   2.634404287560945e-11,   3.102446728129135e-13,
  -3.615344574638909e-15,   1.652046137122242e-16,   3.024783292386036e-18,   8.118896783691735e-01,  -8.927326718142231e-03,   4.287958163079011e-05,   1.927256149262719e-07,
  -5.459874685613743e-09,   2.632938781910748e-11,   3.111461320547069e-13,  -3.594262827631950e-15,   1.651005163616845e-16,   3.011495840407225e-18,   8.118945008165860e-01,
  -8.927261565259267e-03,   4.287589449706635e-05,   1.927552345162130e-07,  -5.459347323745924e-09,   2.632094316199195e-11,   3.116662939175469e-13,  -3.582110319376030e-15,
   1.650399148647807e-16,   3.003821698858091e-18,   8.118963116578741e-01,  -8.927237098843492e-03,   4.287450997246726e-05,   1.927663561530605e-07,  -5.459149218526333e-09,
   2.631777457692096e-11,   3.118616031920501e-13,  -3.577549612786284e-15,   1.650170592354494e-16,   3.000938908251951e-18,   8.118966118288559e-01,  -8.927233043139483e-03,
   4.287428046932116e-05,   1.927681996806478e-07,  -5.459116375762763e-09,   2.631724946873850e-11,   3.118939776185245e-13,  -3.576793751850264e-15,   1.650132653574156e-16,
   3.000460987826532e-18,   1.057993930348782e+00,  -1.051858203977463e-02,   2.141937261049144e-05,   6.551711536155464e-07,  -6.589371465288020e-09,  -4.882813916258342e-11,
   1.271542551068253e-12,   1.455775569178862e-15,   5.635115448863175e-18,   6.234253633687272e-18,   1.057996967199764e+00,  -1.051830257810221e-02,   2.141376169496806e-05,
   6.551017090015047e-07,  -6.586656917232422e-09,  -4.882328793652275e-11,   1.271567537053251e-12,   1.487176322318450e-15,   5.759153750312120e-18,   6.214240578717527e-18,
   1.058001952107634e+00,  -1.051784381794325e-02,   2.140455214414871e-05,   6.549877096229200e-07,  -6.582200507265040e-09,  -4.881525638820270e-11,   1.271608900681785e-12,
   1.538651520623210e-15,   5.960667499314861e-18,   6.181370568140141e-18,   1.058007240699477e+00,  -1.051735706704577e-02,   2.139478237550797e-05,   6.548667545684617e-07,
  -6.577471857183053e-09,  -4.880664267749849e-11,   1.271653256356741e-12,   1.593169782470770e-15,   6.171616413747445e-18,   6.146472191217018e-18,   1.058011402283891e+00,
  -1.051697401259090e-02,   2.138709516455204e-05,   6.547715674730984e-07,  -6.573750344904404e-09,  -4.879979737762234e-11,   1.271688499041552e-12,   1.636002861000487e-15,
   6.335555929643647e-18,   6.118992033074810e-18,   1.058013803789115e+00,  -1.051675295281586e-02,   2.138265938551540e-05,   6.547166352204430e-07,  -6.571602571362895e-09,
  -4.879582028194913e-11,   1.271708971520186e-12,   1.660693366149096e-15,   6.429336023156608e-18,   6.103126727675938e-18,   1.058014705535396e+00,  -1.051666994426760e-02,
   2.138099383126257e-05,   6.546960080079016e-07,  -6.570796058001630e-09,  -4.879432182948766e-11,   1.271716684219869e-12,   1.669959357014510e-15,   6.464394070656596e-18,
   6.097168022523912e-18,   1.058014855010491e+00,  -1.051665618449672e-02,   2.138071774839302e-05,   6.546925887730135e-07,  -6.570662366707207e-09,  -4.879407317512586e-11,
   1.271717964030837e-12,   1.671495035383925e-15,   6.470197146524061e-18,   6.096180222565414e-18,   1.338941474805968e+00,  -1.112261050224781e-02,  -2.968726501948283e-05,
   1.073256679420194e-06,   2.614461751007019e-09,  -2.126621567445552e-10,  -1.218513968459521e-13,   5.307384121423948e-14,   1.871532264254302e-16,  -4.375308528860608e-18,
   1.338937254576354e+00,  -1.112215336950982e-02,  -2.968503409487461e-05,   1.072955381314608e-06,   2.614210663328876e-09,  -2.125039082461854e-10,  -1.210936990153242e-13,
   5.305131270172800e-14,   1.877348593982973e-16,  -4.379460409185149e-18,   1.338930326615467e+00,  -1.112140300477403e-02,  -2.968137182304162e-05,   1.072460914317297e-06,
   2.613799637590114e-09,  -2.122441664546172e-10,  -1.198481704615945e-13,   5.301431252143198e-14,   1.886844406046317e-16,  -4.386356717637189e-18,   1.338922975824751e+00,
  -1.112060693566539e-02,  -2.967748607569521e-05,   1.071936467582123e-06,   2.613365106250491e-09,  -2.119686265849828e-10,  -1.185243410842903e-13,   5.297503058841801e-14,
   1.896848731902433e-16,  -4.393783164419742e-18,   1.338917190939158e+00,  -1.111998051620505e-02,  -2.967442812103112e-05,   1.071523885208903e-06,   2.613024286409845e-09,
  -2.117518232389222e-10,  -1.174808742806269e-13,   5.294409953015365e-14,   1.904670501579930e-16,  -4.399706498960434e-18,   1.338913852458883e+00,  -1.111961903380002e-02,
  -2.967266337518675e-05,   1.071285839967618e-06,   2.612828057396167e-09,  -2.116267210259893e-10,  -1.168780275108001e-13,   5.292624216794959e-14,   1.909163897076680e-16,
  -4.403156449292272e-18,   1.338912598843413e+00,  -1.111948330046321e-02,  -2.967200070682423e-05,   1.071196463729812e-06,   2.612754459340740e-09,  -2.115797475377334e-10,
  -1.166515315261042e-13,   5.291953532797791e-14,   1.910847301268404e-16,  -4.404457882330666e-18,   1.338912391039605e+00,  -1.111946080108381e-02,  -2.967189086065106e-05,
   1.071181648978310e-06,   2.612742264047229e-09,  -2.115719612015543e-10,  -1.166139801960804e-13,   5.291842350861800e-14,   1.911126143365348e-16,  -4.404673926793994e-18,
   1.642434704290541e+00,  -9.292634638626628e-03,  -1.055174400283953e-04,   2.902755064810738e-07,   2.477567971655251e-08,   1.161903456699146e-10,  -6.831964097743103e-12,
  -9.144081175909920e-14,   2.097600065368583e-15,   6.592525080473129e-17,   1.642419730758421e+00,  -9.292510137880161e-03,  -1.054963674772528e-04,   2.904385961961146e-07,
   2.476119531811926e-08,   1.159223725437795e-10,  -6.823613657299874e-12,  -9.110883106919372e-14,   2.097244646753401e-15,   6.571044179998017e-17,   1.642395151435693e+00,
  -9.292305699950681e-03,  -1.054617823805321e-04,   2.907060609338992e-07,   2.473742971252853e-08,   1.154831646131094e-10,  -6.809906166438737e-12,  -9.056462380773590e-14,
   2.096646288188937e-15,   6.535814578033500e-17,   1.642369073800887e+00,  -9.292088707862484e-03,  -1.054250970199408e-04,   2.909894904871867e-07,   2.471223007026107e-08,
   1.150180995842303e-10,  -6.795362989208461e-12,  -8.998825457688269e-14,   2.095991197137451e-15,   6.498480492039396e-17,   1.642348552683570e+00,  -9.291917885007899e-03,
  -1.053962342057036e-04,   2.912122825863941e-07,   2.469241049056518e-08,   1.146527914703484e-10,  -6.783918558418506e-12,  -8.953542799527605e-14,   2.095461051906980e-15,
   6.469132565179572e-17,   1.642336710394480e+00,  -9.291819280191953e-03,  -1.053795804204542e-04,   2.913407527592649e-07,   2.468097730254455e-08,   1.144422455706664e-10,
  -6.777314211056891e-12,  -8.927440501270975e-14,   2.095149258265066e-15,   6.452209006020921e-17,   1.642332263657621e+00,  -9.291782249398662e-03,  -1.053733274216390e-04,
   2.913889742795612e-07,   2.467668498670223e-08,   1.143632364909530e-10,  -6.774834300127752e-12,  -8.917644725422877e-14,   2.095031074686662e-15,   6.445856630894417e-17,
   1.642331526555801e+00,  -9.291776110819236e-03,  -1.053722909325621e-04,   2.913969666157915e-07,   2.467597352455300e-08,   1.143501424003177e-10,  -6.774423224010900e-12,
  -8.916021246386221e-14,   2.095011425962237e-15,   6.444803770394059e-17,   1.912101636542082e+00,  -3.453309514068567e-03,  -9.081224729934708e-05,  -1.780071550678681e-06,
  -2.318527693584527e-08,  -3.050390721807274e-11,   8.588460014775330e-12,   2.788368993403624e-13,   4.818016546965994e-15,   2.288530073443874e-17,   1.912088673695396e+00,
  -3.454069592889490e-03,  -9.083193865039501e-05,  -1.780107909026021e-06,  -2.316671863783156e-08,  -2.966896037561700e-11,   8.607450442687056e-12,   2.789420302002407e-13,
   4.808062666893521e-15,   2.243456342574736e-17,   1.912067391075569e+00,  -3.455317394889208e-03,  -9.086425366630456e-05,  -1.780166737656569e-06,  -2.313622299863539e-08,
  -2.829804077829788e-11,   8.638597372420748e-12,   2.791129475515600e-13,   4.791675640282320e-15,   2.169421281732808e-17,   1.912044805841103e+00,  -3.456641422162410e-03,
  -9.089852672430760e-05,  -1.780227991150443e-06,  -2.310382512194586e-08,  -2.684309316196514e-11,   8.671607279586142e-12,   2.792920309395556e-13,   4.774225122084832e-15,
   2.090811483280787e-17,   1.912027029166841e+00,  -3.457683447818848e-03,  -9.092548844677195e-05,  -1.780275352045908e-06,  -2.307829913687806e-08,  -2.569782901216703e-11,
   8.697557671548197e-12,   2.794313240861999e-13,   4.760446189061774e-15,   2.028907227759129e-17,   1.912016769108578e+00,  -3.458284824865660e-03,  -9.094104403011997e-05,
  -1.780302345824496e-06,  -2.306355609941125e-08,  -2.503678991695128e-11,   8.712522675744906e-12,   2.795110527181529e-13,   4.752475962846310e-15,   1.993165983102955e-17,
   1.912012916205011e+00,  -3.458510648614887e-03,  -9.094688444531097e-05,  -1.780312418155792e-06,  -2.305801777082726e-08,  -2.478854720412212e-11,   8.718140012603713e-12,
   2.795408668101630e-13,   4.749479638100633e-15,   1.979741952341202e-17,   1.912012277523201e+00,  -3.458548082169903e-03,  -9.094785253229619e-05,  -1.780314084407174e-06,
  -2.305709959905694e-08,  -2.474739658074945e-11,   8.719071052007393e-12,   2.795458023382209e-13,   4.748982773722965e-15,   1.977516577715701e-17,   3.243596864112132e-03,
  -4.160505645813580e-05,   3.982773717371144e-07,  -3.430750814060526e-09,   2.650667516459288e-11,  -2.111752846937628e-13,   2.058282512141409e-15,   1.473917602592192e-17,
   6.582726661723915e-19,   1.559245849368353e-21,   3.243653587472413e-03,  -4.160652218158211e-05,   3.983000293874270e-07,  -3.431050959209149e-09,   2.651109947832798e-11,
  -2.111311402735262e-13,   2.060869829374166e-15,   1.474546468428246e-17,   6.565583647541952e-19,   1.495869457683195e-21,   3.243746710385896e-03,  -4.160892849643660e-05,
   3.983372283286774e-07,  -3.431543650617188e-09,   2.651836667843844e-11,  -2.110586575828513e-13,   2.065112373241524e-15,   1.475555449886919e-17,   6.537407453323079e-19,
   1.391911314643875e-21,   3.243845524171719e-03,  -4.161148190833562e-05,   3.983767030075879e-07,  -3.432066372533725e-09,   2.652608313500704e-11,  -2.109817311608556e-13,
   2.069607299211691e-15,   1.476594266983792e-17,   6.507465387337096e-19,   1.281718796476815e-21,   3.243923293441113e-03,  -4.161349154804006e-05,   3.984077724870238e-07,
  -3.432477712718078e-09,   2.653215993013224e-11,  -2.109211777995418e-13,   2.073139944833946e-15,   1.477388818086697e-17,   6.483868379043024e-19,   1.195080294838672e-21,
   3.243968176529506e-03,  -4.161465138693555e-05,   3.984257043736793e-07,  -3.432715087258115e-09,   2.653566853095940e-11,  -2.108862265869664e-13,   2.075176744313771e-15,
   1.477838152637915e-17,   6.470237110603136e-19,   1.145113110050097e-21,   3.243985030749839e-03,  -4.161508692487749e-05,   3.984324381800822e-07,  -3.432804220370341e-09,
   2.653698634085367e-11,  -2.108731011823506e-13,   2.075941212267711e-15,   1.478005140762981e-17,   6.465115985440144e-19,   1.126356293663407e-21,   3.243987824587304e-03,
  -4.161515912188974e-05,   3.984335544156770e-07,  -3.432818995280788e-09,   2.653720480228670e-11,  -2.108709254126172e-13,   2.076067914223839e-15,   1.478032729577813e-17,
   6.464266956575282e-19,   1.123247418537036e-21,   2.925392111244500e-02,  -3.739723992480308e-04,   3.543773061328425e-06,  -2.993797039704940e-08,   2.232850964231244e-10,
  -1.698934910444750e-12,   1.620235192000401e-14,   1.606701224189266e-16,   5.737600210053090e-18,   1.677108035552241e-20,   2.925442580117992e-02,  -3.739851889537941e-04,
   3.543963909589557e-06,  -2.994038404208123e-08,   2.233199493423047e-10,  -1.698453660167432e-12,   1.622488661055908e-14,   1.607405920575034e-16,   5.721852653915375e-18,
   1.619492718512890e-20,   2.925525434910513e-02,  -3.740061860701812e-04,   3.544277239501011e-06,  -2.994434593570862e-08,   2.233772006447482e-10,  -1.697663467760047e-12,
   1.626183542616299e-14,   1.608541517748069e-16,   5.695970170444161e-18,   1.524984822581855e-20,   2.925613352925266e-02,  -3.740284666453150e-04,   3.544609736128169e-06,
  -2.994854913781482e-08,   2.234379956806592e-10,  -1.696824821809996e-12,   1.630097905395096e-14,   1.609717573956777e-16,   5.668465758280121e-18,   1.424809539873194e-20,
   2.925682546802705e-02,  -3.740460023075705e-04,   3.544871433998403e-06,  -2.995185659246050e-08,   2.234858756773325e-10,  -1.696164666921512e-12,   1.633174042462926e-14,
   1.610622224235980e-16,   5.646789974749237e-18,   1.346047242535661e-20,   2.925722480719248e-02,  -3.740561227747801e-04,   3.545022473488794e-06,  -2.995376519377944e-08,
   2.235135217721425e-10,  -1.695783624714012e-12,   1.634947541473251e-14,   1.611135937063827e-16,   5.634268593539758e-18,   1.300622590531942e-20,   2.925737476448843e-02,
  -3.740599231663497e-04,   3.545079191932384e-06,  -2.995448185561265e-08,   2.235239057273624e-10,  -1.695640529463502e-12,   1.635613167651815e-14,   1.611327258194373e-16,
   5.629564451689347e-18,   1.283570976486858e-20,   2.925739962213415e-02,  -3.740605531385779e-04,   3.545088593911367e-06,  -2.995460065062079e-08,   2.235256271522138e-10,
  -1.695616808845904e-12,   1.635723486760766e-14,   1.611358888904221e-16,   5.628784554827260e-18,   1.280744733287367e-20,   8.160647645114667e-02,  -1.035927596670667e-03,
   9.607209538216105e-06,  -7.776738417324259e-08,   5.338713121143995e-10,  -3.608155384217728e-12,   3.270532969509761e-14,   5.891395142872047e-16,   1.513997519136026e-17,
   5.872453576788373e-20,   8.160784454514174e-02,  -1.035960815365640e-03,   9.607665780963646e-06,  -7.777250394105050e-08,   5.339418293127072e-10,  -3.606390750476019e-12,
   3.276471485840323e-14,   5.893964446932067e-16,   1.509467940130322e-17,   5.708669004906707e-20,   8.161009053990993e-02,  -1.036015350807586e-03,   9.608414821038208e-06,
  -7.778090705207025e-08,   5.340576858304640e-10,  -3.603493292101866e-12,   3.286207426775311e-14,   5.898121893731565e-16,   1.502023227659995e-17,   5.440009144889492e-20,
   8.161247377792098e-02,  -1.036073219271010e-03,   9.609209669964659e-06,  -7.778982093339549e-08,   5.341807422850868e-10,  -3.600418156423952e-12,   3.296520202123558e-14,
   5.902451111168734e-16,   1.494112053711794e-17,   5.155238757589892e-20,   8.161434944508221e-02,  -1.036118763608368e-03,   9.609835263362420e-06,  -7.779683441705343e-08,
   5.342776778618831e-10,  -3.597997501202173e-12,   3.304623504557599e-14,   5.905798780816004e-16,   1.487877429878390e-17,   4.931339723966336e-20,   8.161543194784815e-02,
  -1.036145048758321e-03,   9.610196322836420e-06,  -7.780088131891209e-08,   5.343336571262219e-10,  -3.596600292244395e-12,   3.309294901985860e-14,   5.907706968654486e-16,
   1.484275912295478e-17,   4.802210312546031e-20,   8.161583844191102e-02,  -1.036154919211113e-03,   9.610331907528394e-06,  -7.780240083532877e-08,   5.343546846687541e-10,
  -3.596075588522597e-12,   3.311048079273147e-14,   5.908419011738734e-16,   1.482922866069278e-17,   4.753737422377571e-20,   8.161590582430557e-02,  -1.036156555386151e-03,
   9.610354382804302e-06,  -7.780265270977783e-08,   5.343581706420884e-10,  -3.595988609378070e-12,   3.311338641851618e-14,   5.908536805688318e-16,   1.482698545521780e-17,
   4.745703217426506e-20,   1.609826564574566e-01,  -2.020562861830835e-03,   1.807996018570670e-05,  -1.356570464542927e-07,   7.857185561432874e-10,  -3.880521939092182e-12,
   3.151252403794513e-14,   1.503399847823973e-15,   2.858504096555198e-17,   1.359021111121737e-19,   1.609852307185286e-01,  -2.020620796181562e-03,   1.808063145614848e-05,
  -1.356625307001954e-07,   7.857871505075234e-10,  -3.876019585160655e-12,   3.162450308118107e-14,   1.504006412598389e-15,   2.849263443263468e-17,   1.325581165191876e-19,
   1.609894568539374e-01,  -2.020715906480724e-03,   1.808173349800512e-05,  -1.356715293428219e-07,   7.858999310042714e-10,  -3.868626990423804e-12,   3.180806765998686e-14,
   1.504989838120189e-15,   2.834075686360857e-17,   1.270728571116782e-19,   1.609939412043582e-01,  -2.020816828150483e-03,   1.808290290780427e-05,  -1.356810712986710e-07,
   7.860198330198818e-10,  -3.860781188939929e-12,   3.200248051631490e-14,   1.506016554731218e-15,   2.817936272495352e-17,   1.212586360041328e-19,   1.609974704798576e-01,
  -2.020896255693478e-03,   1.808382328165686e-05,  -1.356885763065508e-07,   7.861143651956816e-10,  -3.854605291903297e-12,   3.215522116245706e-14,   1.506812448504630e-15,
   2.805217121940906e-17,   1.166872163301536e-19,   1.609995073210820e-01,  -2.020942095546348e-03,   1.808435446433377e-05,  -1.356929057646988e-07,   7.861689891112768e-10,
  -3.851040579689593e-12,   3.224326516322901e-14,   1.507266911374742e-15,   2.797869714793924e-17,   1.140507298409249e-19,   1.610002721803799e-01,  -2.020959308992530e-03,
   1.808455393191258e-05,  -1.356945311736294e-07,   7.861895136951302e-10,  -3.849701904291068e-12,   3.227630659054136e-14,   1.507436647826992e-15,   2.795109381262856e-17,
   1.130610378556988e-19,   1.610003989670290e-01,  -2.020962162374251e-03,   1.808458699668784e-05,  -1.356948005901900e-07,   7.861929166116844e-10,  -3.849479994918152e-12,
   3.228178262632573e-14,   1.507464735605649e-15,   2.794651747458309e-17,   1.128969999233257e-19,   2.684485418495780e-01,  -3.313521334704687e-03,   2.804613812485911e-05,
  -1.843247925649646e-07,   7.076416555600476e-10,   2.118524495444132e-13,  -5.313282774964667e-15,   2.994384893671007e-15,   4.898438629339470e-17,   2.286266383630185e-19,
   2.684525342360339e-01,  -3.313600025673439e-03,   2.804674229025705e-05,  -1.843244153821613e-07,   7.076325883327563e-10,   2.208169115081058e-13,  -5.121401604220282e-15,
   2.995398494145447e-15,   4.882554643545654e-17,   2.227469349294099e-19,   2.684590884468703e-01,  -3.313729209503893e-03,   2.804773412069215e-05,  -1.843237869484567e-07,
   7.076179972950477e-10,   2.355356139313016e-13,  -4.806856840583893e-15,   2.997040770163737e-15,   4.856447462082204e-17,   2.131021937025080e-19,   2.684660430558808e-01,
  -3.313866283354455e-03,   2.804878652296001e-05,  -1.843231075901685e-07,   7.076029146427951e-10,   2.511561059394685e-13,  -4.473725159319122e-15,   2.998753857677433e-15,
   4.828703641565149e-17,   2.028789308015167e-19,   2.684715164310863e-01,  -3.313974161065240e-03,   2.804961476446174e-05,  -1.843225638502938e-07,   7.075913335071697e-10,
   2.634515304162931e-13,  -4.212001403087406e-15,   3.000080724337156e-15,   4.806838729104012e-17,   1.948408324810570e-19,   2.684746752475469e-01,  -3.314036419349160e-03,
   2.805009275700465e-05,  -1.843222464068386e-07,   7.075847655483771e-10,   2.705482614569300e-13,  -4.061137066828035e-15,   3.000837934121767e-15,   4.794207912259914e-17,
   1.902049680536240e-19,   2.684758614191887e-01,  -3.314059797943901e-03,   2.805027224761603e-05,  -1.843221265155295e-07,   7.075823210787940e-10,   2.732133051662982e-13,
  -4.004520340328487e-15,   3.001120658203531e-15,   4.789462622288398e-17,   1.884647377696261e-19,   2.684760580443623e-01,  -3.314063673280089e-03,   2.805030200073610e-05,
  -1.843221066055259e-07,   7.075819170261150e-10,   2.736550822353201e-13,  -3.995137119040348e-15,   3.001167438542333e-15,   4.788675901690896e-17,   1.881763004634184e-19,
   4.055055280755876e-01,  -4.886026026245065e-03,   3.793578070090981e-05,  -1.932415993938018e-07,  -6.516532756306515e-11,   1.095640506217652e-11,  -6.763774163500397e-14,
   4.687865979961187e-15,   8.625404933246018e-17,   2.822330187043639e-19,   4.055109265023779e-01,  -4.886108469816414e-03,   3.793572426659004e-05,  -1.932258891696858e-07,
  -6.530569415945517e-11,   1.097043305134471e-11,  -6.729923279961750e-14,   4.689056849649570e-15,   8.600493229504867e-17,   2.727226566845748e-19,   4.055197888879825e-01,
  -4.886243809410149e-03,   3.793563153516389e-05,  -1.932000838571669e-07,  -6.553560914346513e-11,   1.099346467299463e-11,  -6.674423610826113e-14,   4.690976733775526e-15,
   8.559546029107024e-17,   2.571223457116343e-19,   4.055291925564101e-01,  -4.886387408556749e-03,   3.793553302412077e-05,  -1.931726828034968e-07,  -6.577886127703220e-11,
   1.101790623362703e-11,  -6.615632153097422e-14,   4.692966172024726e-15,   8.516029288156153e-17,   2.405862275212062e-19,   4.055365932873405e-01,  -4.886500417043056e-03,
   3.793545541168291e-05,  -1.931511038218853e-07,  -6.596979171104777e-11,   1.103714417625280e-11,  -6.569433970041981e-14,   4.694497349130627e-15,   8.481731862082360e-17,
   2.275845728569233e-19,   4.055408643916582e-01,  -4.886565634526965e-03,   3.793541058650961e-05,  -1.931386444738721e-07,  -6.607977701342344e-11,   1.104824768273523e-11,
  -6.542800577294869e-14,   4.695367190173438e-15,   8.461918343131797e-17,   2.200860290003684e-19,   4.055424682333814e-01,  -4.886590123977081e-03,   3.793539374788146e-05,
  -1.931339647882006e-07,  -6.612103897615974e-11,   1.105241733123411e-11,  -6.532804859326410e-14,   4.695691210681381e-15,   8.454474432267755e-17,   2.172711911252643e-19,
   4.055427340930819e-01,  -4.886594183434790e-03,   3.793539095630402e-05,  -1.931331890065203e-07,  -6.612787670060271e-11,   1.105310851916728e-11,  -6.531148210183670e-14,
   4.695744783866467e-15,   8.453240300460527e-17,   2.168046410753996e-19,   5.741434944342498e-01,  -6.680220824243928e-03,   4.505672861723455e-05,  -1.163566777317995e-07,
  -1.912464705590631e-09,   2.682795267026133e-11,  -5.956525678037284e-14,   5.282067410414486e-15,   1.567732159045878e-16,   3.414438903760094e-19,   5.741499030525696e-01,
  -6.680270364096042e-03,   4.505509499525147e-05,  -1.163183661144805e-07,  -1.912584540983258e-09,   2.684375883360598e-11,  -5.894862811526532e-14,   5.283427318591074e-15,
   1.563860192796686e-16,   3.269249482897730e-19,   5.741604236689053e-01,  -6.680351679930115e-03,   4.505241306866107e-05,  -1.162554551262066e-07,  -1.912780323104163e-09,
   2.686970989381598e-11,  -5.793745207974921e-14,   5.285606212297840e-15,   1.557495691519745e-16,   3.031090780964669e-19,   5.741715866279256e-01,  -6.680437946206190e-03,
   4.504956724010379e-05,  -1.161886795939973e-07,  -1.912986776866920e-09,   2.689724956014941e-11,  -5.686603920328968e-14,   5.287845358146351e-15,   1.550731562110586e-16,
   2.778649303810362e-19,   5.741803717702419e-01,  -6.680505826553580e-03,   4.504732748797300e-05,  -1.161361108888315e-07,  -1.913148326565759e-09,   2.691892596862099e-11,
  -5.602393536060041e-14,   5.289554878707272e-15,   1.545400285761588e-16,   2.580167727622778e-19,   5.741854417814847e-01,  -6.680544996952719e-03,   4.504603485520296e-05,
  -1.161057660429915e-07,  -1.913241187312355e-09,   2.693143685212373e-11,  -5.553838351820336e-14,   5.290520362329719e-15,   1.542320354151791e-16,   2.465696948606574e-19,
   5.741873456086140e-01,  -6.680559704943074e-03,   4.504554945345801e-05,  -1.160943700384939e-07,  -1.913275987022938e-09,   2.693613500115796e-11,  -5.535613769663326e-14,
   5.290878921461971e-15,   1.541163215111120e-16,   2.422726574002415e-19,   5.741876611945517e-01,  -6.680562142956363e-03,   4.504546899089222e-05,  -1.160924809236291e-07,
  -1.913281751858660e-09,   2.693691379647210e-11,  -5.532593226081756e-14,   5.290938147332720e-15,   1.540971371432147e-16,   2.415604386980515e-19,   7.768424881282199e-01,
  -8.576752322953358e-03,   4.471065794499650e-05,   1.096911979724040e-07,  -4.866959653689132e-09,   3.322496165092271e-11,   2.936949364906309e-13,   3.170144679395573e-15,
   2.515270358930627e-16,   1.125472644770799e-18,   7.768488424338377e-01,  -8.576705326020494e-03,   4.470650594464468e-05,   1.097385602830269e-07,  -4.866321002081168e-09,
   3.323451706879538e-11,   2.946838110972591e-13,   3.175324075884301e-15,   2.508843154009062e-16,   1.103602473418697e-18,   7.768592736287379e-01,  -8.576628158313077e-03,
   4.469969016175582e-05,   1.098163230452427e-07,  -4.865271033506771e-09,   3.325021464027979e-11,   2.963053508248302e-13,   3.183746126689338e-15,   2.498279680071163e-16,
   1.067727545624326e-18,   7.768703413536161e-01,  -8.576546257517591e-03,   4.469245863025869e-05,   1.098988487585977e-07,  -4.864154873362885e-09,   3.326688556835423e-11,
   2.980234027375405e-13,   3.192572862820482e-15,   2.487054511520940e-16,   1.029700309165388e-18,   7.768790512919855e-01,  -8.576481786756086e-03,   4.468676776901123e-05,
   1.099638066444059e-07,  -4.863274957512584e-09,   3.328001616592656e-11,   2.993736874552872e-13,   3.199440162773335e-15,   2.478208327807187e-16,   9.998008729340835e-19,
   7.768840777996799e-01,  -8.576444573644204e-03,   4.468348361898481e-05,   1.100012990065969e-07,  -4.862766543228476e-09,   3.328759827058420e-11,   3.001522286544576e-13,
   3.203371608420748e-15,   2.473098256419828e-16,   9.825566538321202e-19,   7.768859652715386e-01,  -8.576430598659111e-03,   4.468225041773604e-05,   1.100153784980003e-07,
  -4.862575515697382e-09,   3.329044621340917e-11,   3.004444397266864e-13,   3.204841895217352e-15,   2.471178474347258e-16,   9.760834228023658e-19,   7.768862781453404e-01,
  -8.576428282047712e-03,   4.468204599854677e-05,   1.100177124140935e-07,  -4.862543844194361e-09,   3.329091834215012e-11,   3.004928705660636e-13,   3.205085299281592e-15,
   2.470860195571727e-16,   9.750105053240805e-19,   1.016309490655287e+00,  -1.031763451924947e-02,   2.862203578866525e-05,   5.436036902184363e-07,  -7.256475362906047e-09,
  -1.759453889295315e-11,   1.348268690091780e-12,   5.130909504098434e-15,   2.120413753557442e-16,   4.142509611708939e-18,   1.016313551354703e+00,  -1.031740253081674e-02,
   2.861585625678057e-05,   5.435787843548047e-07,  -7.253587557394499e-09,  -1.757888478873010e-11,   1.349094146787491e-12,   5.151102567768292e-15,   2.111060039721188e-16,
   4.104128688821902e-18,   1.016320217017208e+00,  -1.031702169190152e-02,   2.860571334007254e-05,   5.435379135814229e-07,  -7.248845493947827e-09,  -1.755314309462340e-11,
   1.350446563762543e-12,   5.184110993338205e-15,   2.095687072140620e-16,   4.041168107309988e-18,   1.016327288940435e+00,  -1.031661760276031e-02,   2.859495334784696e-05,
   5.434945686172388e-07,  -7.243812083421203e-09,  -1.752577096460463e-11,   1.351877905302355e-12,   5.218942922720884e-15,   2.079351673058651e-16,   3.974427339874301e-18,
   1.016332853958695e+00,  -1.031629958999713e-02,   2.858648693447820e-05,   5.434604719116676e-07,  -7.239849523191854e-09,  -1.750418694554369e-11,   1.353001713941479e-12,
   5.246216491419744e-15,   2.066478669379035e-16,   3.921949388504625e-18,   1.016336065390059e+00,  -1.031611606162430e-02,   2.858160150619103e-05,   5.434408004595031e-07,
  -7.237562155859950e-09,  -1.749171359017732e-11,   1.353649217046730e-12,   5.261900771119677e-15,   2.059042625897409e-16,   3.891682370328234e-18,   1.016337271267316e+00,
  -1.031604714546440e-02,   2.857976711244545e-05,   5.434334148484189e-07,  -7.236703132939070e-09,  -1.748702655176142e-11,   1.353892158796798e-12,   5.267779824658084e-15,
   2.056249037858154e-16,   3.880320406387631e-18,   1.016337471156244e+00,  -1.031603572165447e-02,   2.857946304244994e-05,   5.434321906417705e-07,  -7.236560732650467e-09,
  -1.748624944097841e-11,   1.353932419205326e-12,   5.268753805476629e-15,   2.055785893188526e-16,   3.878437188388996e-18,   1.294058183652925e+00,  -1.130820289479774e-02,
  -1.669666197464415e-05,   1.081419042845775e-06,  -1.544686433568516e-09,  -1.971989668570360e-10,   1.428916206626465e-12,   5.713582376997174e-14,   7.703179773271255e-17,
  -2.825459912046643e-18,   1.294055804978065e+00,  -1.130774219923818e-02,  -1.669796359260943e-05,   1.081139853439198e-06,  -1.541632741983964e-09,  -1.970284769273137e-10,
   1.429213130973166e-12,   5.711987342455024e-14,   7.655422714956899e-17,  -2.880494689060240e-18,   1.294051899867095e+00,  -1.130698597870754e-02,  -1.670009852353593e-05,
   1.080681694082801e-06,  -1.536619160172239e-09,  -1.967486255189432e-10,   1.429699173895877e-12,   5.709348524918797e-14,   7.576480563464810e-17,  -2.970752431096961e-18,
   1.294047756064286e+00,  -1.130618368684061e-02,  -1.670236128738887e-05,   1.080195789737881e-06,  -1.531298748091339e-09,  -1.964517299012841e-10,   1.430212983003355e-12,
   5.706520950746364e-14,   7.491982716550675e-17,  -3.066399354635452e-18,   1.294044494740722e+00,  -1.130555236329629e-02,  -1.670414023872568e-05,   1.079813552870555e-06,
  -1.527111112014375e-09,  -1.962181066895482e-10,   1.430615956658287e-12,   5.704275677371991e-14,   7.424952064493602e-17,  -3.141584416611271e-18,   1.294042612515446e+00,
  -1.130518804794599e-02,  -1.670516616242955e-05,   1.079593025603371e-06,  -1.524694167760755e-09,  -1.960832923374828e-10,   1.430847958526811e-12,   5.702971890978850e-14,
   7.386055122437736e-17,  -3.184939236047977e-18,   1.294041905711374e+00,  -1.130505125029920e-02,  -1.670555126637258e-05,   1.079510228482272e-06,  -1.523786547631478e-09,
  -1.960326708937097e-10,   1.430934971030032e-12,   5.702480795613083e-14,   7.371408861954060e-17,  -3.201212601430759e-18,   1.294041788547967e+00,  -1.130502857446823e-02,
  -1.670561509544554e-05,   1.079496504363302e-06,  -1.523636094835736e-09,  -1.960242798066995e-10,   1.430949388972912e-12,   5.702399309849252e-14,   7.368978921734691e-17,
  -3.203909785788808e-18,   1.603607616931628e+00,  -1.011598689249742e-02,  -9.960983123933668e-05,   6.956613657560262e-07,   2.530068512069478e-08,  -6.879873752011630e-11,
  -8.113190255184897e-12,   1.070069507809757e-14,   4.111483881188290e-15,   3.630522069195298e-17,   1.603593484966841e+00,  -1.011569024411071e-02,  -9.958832533904978e-05,
   6.955637567033621e-07,   2.528355860572504e-08,  -6.876391284340411e-11,  -8.097004590007931e-12,   1.087968010585845e-14,   4.101985257991196e-15,   3.604343698155282e-17,
   1.603570287255341e+00,  -1.011520327780757e-02,  -9.955303043075401e-05,   6.954035526387485e-07,   2.525546752623448e-08,  -6.870636043818358e-11,  -8.070460517329360e-12,
   1.117254950267881e-14,   4.086398547093060e-15,   3.561445187256844e-17,   1.603545675674172e+00,  -1.011468660973266e-02,  -9.951559407734111e-05,   6.952336142330217e-07,
   2.522569449245631e-08,  -6.864477477006839e-11,  -8.042332318901978e-12,   1.148199866759384e-14,   4.069869114066405e-15,   3.516031779875226e-17,   1.603526308390225e+00,
  -1.011428001878415e-02,  -9.948614179732970e-05,   6.950999085371187e-07,   2.520228739263592e-08,  -6.859593228637517e-11,  -8.020222142196324e-12,   1.172459106116845e-14,
   4.056867082774262e-15,   3.480367275517870e-17,   1.603515132017530e+00,  -1.011404537903702e-02,  -9.946914844796127e-05,   6.950227591406130e-07,   2.518878848609996e-08,
  -6.856759461387584e-11,  -8.007472692213747e-12,   1.186421718643409e-14,   4.049366051778762e-15,   3.459815058079999e-17,   1.603510935342033e+00,  -1.011395727171640e-02,
  -9.946276805803800e-05,   6.949937915742533e-07,   2.518372136187993e-08,  -6.855692527233598e-11,  -8.002687181397718e-12,   1.191657665690933e-14,   4.046549849775196e-15,
   3.452103250357558e-17,   1.603510239691629e+00,  -1.011394266678490e-02,  -9.946171045831500e-05,   6.949889899333235e-07,   2.518288151105842e-08,  -6.855515518607117e-11,
  -8.001894021798511e-12,   1.192525221635580e-14,   4.046083050878860e-15,   3.450825211309999e-17,   1.896691262076183e+00,  -4.271516456428026e-03,  -1.143747288114385e-04,
  -2.141744720077867e-06,  -2.101041684910384e-08,   2.869350533603918e-10,   1.856193724680655e-11,   4.286760056594964e-13,   3.805558060994421e-15,  -1.034048277759568e-16,
   1.896674950093701e+00,  -4.272429331808758e-03,  -1.143924428849821e-04,  -2.141325657217109e-06,  -2.097062344868514e-08,   2.882072718724007e-10,   1.857640814121679e-11,
   4.281243284127823e-13,   3.772194720469564e-15,  -1.042238735294464e-16,   1.896648169547950e+00,  -4.273927832709266e-03,  -1.144214987922972e-04,  -2.140636392831529e-06,
  -2.090527418234902e-08,   2.902946186597036e-10,   1.860006824999680e-11,   4.272156467685095e-13,   3.717402355359853e-15,  -1.055659982190011e-16,   1.896619750892285e+00,
  -4.275517678670029e-03,  -1.144522958995765e-04,  -2.139903257288014e-06,  -2.083590379670936e-08,   2.925078125896707e-10,   1.862504266901368e-11,   4.262473738713141e-13,
   3.659235151969076e-15,  -1.069867280521055e-16,   1.896597383504932e+00,  -4.276768765797953e-03,  -1.144765091559885e-04,  -2.139324992775035e-06,  -2.078128745320722e-08,
   2.942484159485099e-10,   1.864460295078618e-11,   4.254823796780950e-13,   3.613437047864456e-15,  -1.081024039770191e-16,   1.896584474144770e+00,  -4.277490740477565e-03,
  -1.144904733857259e-04,  -2.138990750909600e-06,  -2.074975870202343e-08,   2.952524734934652e-10,   1.865585359628644e-11,   4.250397020364361e-13,   3.586998050544559e-15,
  -1.087452995407817e-16,   1.896579626418727e+00,  -4.277761839282290e-03,  -1.144957152565761e-04,  -2.138865142614971e-06,  -2.073791772108949e-08,   2.956294164990024e-10,
   1.866007114678608e-11,   4.248732484473914e-13,   3.577068439182060e-15,  -1.089865271696106e-16,   1.896578822831734e+00,  -4.277806777268942e-03,  -1.144965840748233e-04,
  -2.138844316117602e-06,  -2.073595482353858e-08,   2.956918954161176e-10,   1.866076988741502e-11,   4.248456445833545e-13,   3.575422384822060e-15,  -1.090265042801831e-16,
   3.083298117555527e-03,  -3.857660638606933e-05,   3.595228074912580e-07,  -3.037565115158995e-09,   2.282278175405092e-11,  -1.544836019253726e-13,   2.755394103640709e-15,
   3.390087735031041e-17,   4.295172432996485e-19,  -1.696258922308176e-20,   3.083349319548119e-03,  -3.857790396310235e-05,   3.595423280309059e-07,  -3.037784114601178e-09,
   2.282868260336993e-11,  -1.543837114612560e-13,   2.757017455450044e-15,   3.381219447046666e-17,   4.252673194549957e-19,  -1.702933700956073e-20,   3.083433377921340e-03,
  -3.858003421324932e-05,   3.595743778046574e-07,  -3.038143535488731e-09,   2.283837226055938e-11,  -1.542199178021081e-13,   2.759670235874893e-15,   3.366636287404217e-17,
   4.182948080027165e-19,  -1.713853484288573e-20,   3.083522573092270e-03,  -3.858229466495579e-05,   3.596083900515302e-07,  -3.038524770123391e-09,   2.284865706612357e-11,
  -1.540463822592660e-13,   2.762468447728035e-15,   3.351129303112612e-17,   4.109024752326905e-19,  -1.725388619234850e-20,   3.083592772144760e-03,  -3.858407371867873e-05,
   3.596351614603024e-07,  -3.038824703443478e-09,   2.285675366534446e-11,  -1.539099989328784e-13,   2.764658646779521e-15,   3.338901302391834e-17,   4.050890638051644e-19,
  -1.734429450615107e-20,   3.083633286186114e-03,  -3.858510047196359e-05,   3.596506132037744e-07,  -3.038997760634334e-09,   2.286142733173274e-11,  -1.538313657070987e-13,
   2.765917841760875e-15,   3.331834714685712e-17,   4.017357979027577e-19,  -1.739632100314954e-20,   3.083648499761868e-03,  -3.858548603305786e-05,   3.596564157592939e-07,
  -3.039062737736807e-09,   2.286318252119213e-11,  -1.538018525714301e-13,   2.766389772751300e-15,   3.329179334399828e-17,   4.004769480578987e-19,  -1.741582912755995e-20,
   3.083651021637745e-03,  -3.858554994559319e-05,   3.596573776302880e-07,  -3.039073508221098e-09,   2.286347347852273e-11,  -1.537969611078169e-13,   2.766467954106614e-15,
   3.328739071874876e-17,   4.002682933605809e-19,  -1.741906138301892e-20,   2.781253911947126e-02,  -3.470009397941514e-04,   3.204905005179711e-06,  -2.661420851037630e-08,
   1.936659661095626e-10,  -1.235628408297813e-12,   2.318882591634330e-14,   3.282700917864666e-16,   3.732780979851189e-18,  -1.526717584937616e-19,   2.781299553410478e-02,
  -3.470123081681088e-04,   3.205070647193153e-06,  -2.661595873734386e-08,   1.937156311794095e-10,  -1.234660179067912e-12,   2.320289477619871e-14,   3.274717125277611e-16,
   3.693960033133050e-18,  -1.532796047233924e-19,   2.781374482969816e-02,  -3.470309717325683e-04,   3.205342606077009e-06,  -2.661883102770844e-08,   1.937971857100565e-10,
  -1.233072409047926e-12,   2.322587951366388e-14,   3.261588190522663e-16,   3.630269365792459e-18,  -1.542740267560837e-19,   2.781453991348782e-02,  -3.470507759490420e-04,
   3.205631217219341e-06,  -2.662187740465387e-08,   1.938837501984947e-10,  -1.231390022917779e-12,   2.325011652360438e-14,   3.247627210607895e-16,   3.562743507395491e-18,
  -1.553244859997209e-19,   2.781516566544668e-02,  -3.470663625014343e-04,   3.205858385937095e-06,  -2.662427394618633e-08,   1.939518977042256e-10,  -1.230067687371474e-12,
   2.326908148526170e-14,   3.236618060711391e-16,   3.509640202484301e-18,  -1.561477985119376e-19,   2.781552680588859e-02,  -3.470753580180004e-04,   3.205989501566677e-06,
  -2.662565664734333e-08,   1.939912352750537e-10,  -1.229305228271301e-12,   2.327998258194659e-14,   3.230255750584545e-16,   3.479009299709637e-18,  -1.566215829608769e-19,
   2.781566241899161e-02,  -3.470787359640615e-04,   3.206038739080492e-06,  -2.662617579172673e-08,   1.940060084923530e-10,  -1.229019047152535e-12,   2.328406774646114e-14,
   3.227864994912162e-16,   3.467510132289342e-18,  -1.567992356011275e-19,   2.781568489887188e-02,  -3.470792959090897e-04,   3.206046901024054e-06,  -2.662626184345454e-08,
   1.940084574472441e-10,  -1.228971615388167e-12,   2.328474448283985e-14,   3.227468606212968e-16,   3.465604141298518e-18,  -1.568286704496997e-19,   7.761076925948313e-02,
  -9.626627172613311e-04,   8.723027043736841e-06,  -6.975350447721637e-08,   4.711762999060709e-10,  -2.570988189305145e-12,   5.580397747078602e-14,   1.033845328992403e-15,
   9.777833631945166e-18,  -4.264151008354221e-19,   7.761201142072618e-02,  -9.626925093995294e-04,   8.723430032402519e-06,  -6.975713743132715e-08,   4.712958518224751e-10,
  -2.567934331678931e-12,   5.584063777634234e-14,   1.031614519932607e-15,   9.666865704609828e-18,  -4.281472918549819e-19,   7.761405067106143e-02,  -9.627414191324870e-04,
   8.724091677454309e-06,  -6.976309838746385e-08,   4.714921709855457e-10,  -2.562925778489416e-12,   5.590050266891714e-14,   1.027945945912188e-15,   9.484807786638259e-18,
  -4.309811300271200e-19,   7.761621452985835e-02,  -9.627933176564302e-04,   8.724793834499639e-06,  -6.976941917691227e-08,   4.717005557389119e-10,  -2.557617913224304e-12,
   5.596359067250417e-14,   1.024044708862528e-15,   9.291785704476693e-18,  -4.339746793169846e-19,   7.761791753907442e-02,  -9.628341631655833e-04,   8.725346508569859e-06,
  -6.977439059956747e-08,   4.718646096878711e-10,  -2.553445377471176e-12,   5.601292770331803e-14,   1.020968206442712e-15,   9.139989363211293e-18,  -4.363209310249550e-19,
   7.761890039541947e-02,  -9.628577363476683e-04,   8.725665496764022e-06,  -6.977725847415557e-08,   4.719593100272766e-10,  -2.551039244326080e-12,   5.604127542557646e-14,
   1.019190213297060e-15,   9.052430210560202e-18,  -4.376711137802317e-19,   7.761926947085515e-02,  -9.628665883951079e-04,   8.725785285519009e-06,  -6.977833515706237e-08,
   4.719948750202726e-10,  -2.550136080311643e-12,   5.605189653496665e-14,   1.018522090411325e-15,   9.019559494974170e-18,  -4.381773863112847e-19,   7.761933065055526e-02,
  -9.628680557530637e-04,   8.725805142510790e-06,  -6.977851362040123e-08,   4.720007706416430e-10,  -2.549986387099162e-12,   5.605365588350645e-14,   1.018411314764499e-15,
   9.014111158428573e-18,  -4.382612694755073e-19,   1.531796688089334e-01,  -1.882226555876416e-03,   1.652512019075220e-05,  -1.236491572777309e-07,   7.196167141128582e-10,
  -2.516114537688302e-12,   8.613362114040538e-14,   2.346220471968725e-15,   1.822094196976808e-17,  -8.542515958426653e-19,   1.531820216926847e-01,  -1.882279356858452e-03,
   1.652573567787407e-05,  -1.236526793653404e-07,   7.198013757157411e-10,  -2.509174603354766e-12,   8.620152717020550e-14,   2.341749450368836e-15,   1.799436620277907e-17,
  -8.577953176713150e-19,   1.531858843957501e-01,  -1.882366039291626e-03,   1.652674621384063e-05,  -1.236584543340518e-07,   7.201046299025292e-10,  -2.497791296311407e-12,
   8.631235469746211e-14,   2.334396573761451e-15,   1.762263613867968e-17,  -8.635929051236963e-19,   1.531899831086980e-01,  -1.882458017514038e-03,   1.652781862591064e-05,
  -1.236645723671814e-07,   7.204265444902351e-10,  -2.485725951039561e-12,   8.642906658677338e-14,   2.326577015317551e-15,   1.722851670834897e-17,  -8.697173895714994e-19,
   1.531932088799309e-01,  -1.882530405915583e-03,   1.652866273231942e-05,  -1.236693803052431e-07,   7.206799927774012e-10,  -2.476240046925117e-12,   8.652027921194152e-14,
   2.320410279472828e-15,   1.691857167777748e-17,  -8.745176830519311e-19,   1.531950705606850e-01,  -1.882572183101102e-03,   1.652914992772810e-05,  -1.236721522613422e-07,
   7.208263026085248e-10,  -2.470769392659722e-12,   8.657266325525760e-14,   2.316846254471350e-15,   1.673978848851009e-17,  -8.772801225723688e-19,   1.531957696450645e-01,
  -1.882587870929698e-03,   1.652933288297301e-05,  -1.236731926295562e-07,   7.208812509236453e-10,  -2.468715835078941e-12,   8.659228550590629e-14,   2.315506968505669e-15,
   1.667267108080862e-17,  -8.783159517483496e-19,   1.531958855285572e-01,  -1.882590471416059e-03,   1.652936321087336e-05,  -1.236733650575834e-07,   7.208903597896232e-10,
  -2.468375466905830e-12,   8.659553561764009e-14,   2.315284912118462e-15,   1.666154633173933e-17,  -8.784875764172097e-19,   2.556294583268440e-01,  -3.097806909650884e-03,
   2.590237720619635e-05,  -1.729438476393815e-07,   7.183122739941812e-10,   1.266686229218758e-12,   9.995724015816309e-14,   4.433909387977300e-15,   3.080005397941440e-17,
  -1.489497577861905e-18,   2.556331456612657e-01,  -3.097880736409613e-03,   2.590299175009588e-05,  -1.729419343468832e-07,   7.185269926006085e-10,   1.279811823376994e-12,
   1.000717816653454e-13,   4.426111877137982e-15,   3.040526562647235e-17,  -1.495740153643121e-18,   2.556391990810732e-01,  -3.098001934369704e-03,   2.590400075633162e-05,
  -1.729387799190733e-07,   7.188796603213638e-10,   1.301342660531564e-12,   1.002586853987248e-13,   4.413288148584383e-15,   2.975755680868375e-17,  -1.505953495889433e-18,
   2.556456223138088e-01,  -3.098130533938268e-03,   2.590507157070593e-05,  -1.729354145592565e-07,   7.192541013483872e-10,   1.324165479578342e-12,   1.004554632055942e-13,
   4.399650193810034e-15,   2.907083384552178e-17,  -1.516743242412853e-18,   2.556506774943385e-01,  -3.098231741868831e-03,   2.590591443817655e-05,  -1.729327527843202e-07,
   7.195489565800768e-10,   1.342110438551780e-12,   1.006092127878102e-13,   4.388894671560829e-15,   2.853077650552280e-17,  -1.525200490822159e-18,   2.556535949629751e-01,
  -3.098290150701273e-03,   2.590640092597410e-05,  -1.729312113255796e-07,   7.197191904653132e-10,   1.352460116313439e-12,   1.006974976620197e-13,   4.382678496627588e-15,
   2.821925868361397e-17,  -1.530067562807623e-18,   2.556546905062039e-01,  -3.098312083752604e-03,   2.590658361690418e-05,  -1.729306314917201e-07,   7.197831276474455e-10,
   1.356345254338860e-12,   1.007305650392433e-13,   4.380342571154816e-15,   2.810231092413459e-17,  -1.531892592987399e-18,   2.556548721084258e-01,  -3.098315719467375e-03,
   2.590661390106444e-05,  -1.729305353231702e-07,   7.197937268180048e-10,   1.356989204617803e-12,   1.007360419746012e-13,   4.379955268971556e-15,   2.808292675819022e-17,
  -1.532194980483912e-18,   3.865537066089064e-01,  -4.591816777274468e-03,   3.561770662142063e-05,  -1.925691856398882e-07,   1.499659277894771e-10,   1.121610339486449e-11,
   1.010206860420624e-13,   7.199921462036880e-15,   5.455705078572566e-17,  -2.449305772660004e-18,   3.865587755302362e-01,  -4.591898932243344e-03,   3.561783590554133e-05,
  -1.925530445581327e-07,   1.501839755507881e-10,   1.123741463299112e-11,   1.012249808535316e-13,   7.187102340148875e-15,   5.392547938127363e-17,  -2.459458717421667e-18,
   3.865670969987112e-01,  -4.592033797902195e-03,   3.561804828167827e-05,  -1.925265245249819e-07,   1.505422444834655e-10,   1.127237261557302e-11,   1.015585485828824e-13,
   7.166020503921758e-15,   5.288928841936398e-17,  -2.476070459867510e-18,   3.865759267386498e-01,  -4.592176893965944e-03,   3.561827381320073e-05,  -1.924983550599373e-07,
   1.509228129063769e-10,   1.130942782388475e-11,   1.019100236362742e-13,   7.143600638895846e-15,   5.179067741715711e-17,  -2.493620705010119e-18,   3.865828758039611e-01,
  -4.592289506376688e-03,   3.561845144101475e-05,  -1.924761640804978e-07,   1.512226232559003e-10,   1.133856298310209e-11,   1.021848516327067e-13,   7.125919680444294e-15,
   5.092669593017630e-17,  -2.507377709337381e-18,   3.865868862508843e-01,  -4.592354495218519e-03,   3.561855400696741e-05,  -1.924633486332109e-07,   1.513957699307082e-10,
   1.135536642478611e-11,   1.023427451039501e-13,   7.115701089381432e-15,   5.042832927106602e-17,  -2.515295035202287e-18,   3.865883922146134e-01,  -4.592378898800048e-03,
   3.561859253161163e-05,  -1.924585346804817e-07,   1.514608109119439e-10,   1.136167419839991e-11,   1.024019005350673e-13,   7.111861157548987e-15,   5.024123574834345e-17,
  -2.518263889382438e-18,   3.865886418497119e-01,  -4.592382944023218e-03,   3.561859891815622e-05,  -1.924577366132055e-07,   1.514715935810484e-10,   1.136271969209483e-11,
   1.024116992661785e-13,   7.111224488932926e-15,   5.021022485991863e-17,  -2.518755798890676e-18,   5.481339947823241e-01,  -6.325831741395963e-03,   4.349446859369526e-05,
  -1.426808795624192e-07,  -1.375317392285312e-09,   2.773065269562788e-11,   1.561241991507876e-13,   9.859944910970290e-15,   1.043248001769228e-16,  -3.879825186417553e-18,
   5.481401820071362e-01,  -6.325892514672870e-03,   4.349329620405106e-05,  -1.426411710685060e-07,  -1.374979459273292e-09,   2.775979350666961e-11,   1.565196717717201e-13,
   9.839648630800160e-15,   1.033494777755306e-16,  -3.895538252686235e-18,   5.481503392180441e-01,  -6.325992271535158e-03,   4.349137174667328e-05,  -1.425759533097059e-07,
  -1.374424088124078e-09,   2.780758875387771e-11,   1.571661006570727e-13,   9.806271468209474e-15,   1.017492836113658e-16,  -3.921247670448366e-18,   5.481611166408592e-01,
  -6.326098104544689e-03,   4.348933003420747e-05,  -1.425067116972247e-07,  -1.373833984118450e-09,   2.785824318782231e-11,   1.578482030965187e-13,   9.770777700758858e-15,
   1.000526581092218e-16,  -3.948410230890352e-18,   5.481695984112596e-01,  -6.326181383561488e-03,   4.348772340266792e-05,  -1.424521888591963e-07,  -1.373368982903400e-09,
   2.789806498612016e-11,   1.583822649918936e-13,   9.742787569615304e-15,   9.871835366853483e-17,  -3.969702457008686e-18,   5.481744933595226e-01,  -6.326229440651836e-03,
   4.348679626717641e-05,  -1.424207109146947e-07,  -1.373100387219027e-09,   2.792102946720520e-11,   1.586893780861762e-13,   9.726611375238446e-15,   9.794868226262691e-17,
  -3.981956586482548e-18,   5.481763314523324e-01,  -6.326247485648634e-03,   4.348644813427142e-05,  -1.424088884136989e-07,  -1.372999482639329e-09,   2.792964955649764e-11,
   1.588044933981137e-13,   9.720532798056132e-15,   9.765973533173898e-17,  -3.986551699706005e-18,   5.481766361420541e-01,  -6.326250476816687e-03,   4.348639042708726e-05,
  -1.424069285478475e-07,  -1.372982753929403e-09,   2.793107828545314e-11,   1.588235643996318e-13,   9.719524962524467e-15,   9.761184206232762e-17,  -3.987313066009440e-18,
   7.432573869617978e-01,  -8.215072487798406e-03,   4.558301549608171e-05,   3.756551827361348e-08,  -4.120044818268657e-09,   4.225193576553575e-11,   4.942594457951413e-13,
   1.083815916554968e-14,   1.878166019291533e-16,  -5.607425404111135e-18,   7.432638666976780e-01,  -8.215056236821533e-03,   4.557950365009259e-05,   3.762591494160648e-08,
  -4.118981299670979e-09,   4.228385461839143e-11,   4.949760926419032e-13,   1.080879706076884e-14,   1.862862845217456e-16,  -5.631195963277651e-18,   7.432745038728902e-01,
  -8.215029539512465e-03,   4.557373904537849e-05,   3.772509848402118e-08,  -4.117234272912366e-09,   4.233619074942787e-11,   4.961481853358915e-13,   1.076050737506614e-14,
   1.837754481177690e-16,  -5.670089173404440e-18,   7.432857902488360e-01,  -8.215001186182992e-03,   4.556762324999680e-05,   3.783038420927086e-08,  -4.115379066356123e-09,
   4.239163657419677e-11,   4.973858898168838e-13,   1.070915025782450e-14,   1.811132051150634e-16,  -5.711181071050400e-18,   7.432946723319456e-01,  -8.214978853553706e-03,
   4.556281073572455e-05,   3.791327668960964e-08,  -4.113917943199366e-09,   4.243520976360114e-11,   4.983556444216376e-13,   1.066864668875569e-14,   1.790194234482590e-16,
  -5.743392513318501e-18,   7.432997982138752e-01,  -8.214965957575572e-03,   4.556003359980840e-05,   3.796112840332783e-08,  -4.113074274170252e-09,   4.246033143689102e-11,
   4.989135755543207e-13,   1.064523718392295e-14,   1.778116315780102e-16,  -5.761930990711667e-18,   7.433017230066885e-01,  -8.214961113612276e-03,   4.555899080684342e-05,
   3.797909962389426e-08,  -4.112757387602715e-09,   4.246976009626586e-11,   4.991227567179807e-13,   1.063644024439147e-14,   1.773582018126037e-16,  -5.768882659411969e-18,
   7.433020420672334e-01,  -8.214960310582414e-03,   4.555881795157827e-05,   3.798207873890657e-08,  -4.112704854876587e-09,   4.247132277933966e-11,   4.991574142133655e-13,
   1.063498168632914e-14,   1.772830450475422e-16,  -5.770034485470426e-18,   9.755354120419346e-01,  -1.006455403505550e-02,   3.444291069362963e-05,   4.265070260212722e-07,
  -7.268778591439647e-09,   1.734138524016456e-11,   1.598777467998140e-12,   1.273279326895898e-14,   2.007455182072549e-16,  -6.367329776365922e-18,   9.755403010796238e-01,
  -1.006437186144090e-02,   3.443672368052092e-05,   4.265320202952828e-07,  -7.265356997579264e-09,   1.737889625948459e-11,   1.599526696019281e-12,   1.269911293211713e-14,
   1.983017872607094e-16,  -6.407002825944033e-18,   9.755483265932200e-01,  -1.006407278617377e-02,   3.442656881127021e-05,   4.265730907989858e-07,  -7.259738768331294e-09,
   1.744040323417139e-11,   1.600749650958346e-12,   1.264367581051564e-14,   1.942924114317505e-16,  -6.471932918805695e-18,   9.755568414232508e-01,  -1.006375543359769e-02,
   3.441579658369273e-05,   4.266167218676351e-07,  -7.253775864152178e-09,   1.750556691321220e-11,   1.602037758131249e-12,   1.258465553815309e-14,   1.900414341710595e-16,
  -6.540557258703024e-18,   9.755635420165428e-01,  -1.006350566777066e-02,   3.440732086479606e-05,   4.266510974297054e-07,  -7.249081925048423e-09,   1.755677855201245e-11,
   1.603044599200580e-12,   1.253806381356080e-14,   1.866982781063186e-16,  -6.594368254749476e-18,   9.755674088103862e-01,  -1.006336151994680e-02,   3.440243019587147e-05,
   4.266709513326714e-07,  -7.246372520729779e-09,   1.758630467675177e-11,   1.603622899580620e-12,   1.251111781834883e-14,   1.847698369343166e-16,  -6.625344731274905e-18,
   9.755688607827574e-01,  -1.006330739042300e-02,   3.440059385873967e-05,   4.266784095222762e-07,  -7.245355029432192e-09,   1.759738652219643e-11,   1.603839534196039e-12,
   1.250098856815416e-14,   1.840458698694557e-16,  -6.636961787516362e-18,   9.755691014654729e-01,  -1.006329841764889e-02,   3.440028946789385e-05,   4.266796459743621e-07,
  -7.245186361309521e-09,   1.759922320600211e-11,   1.603875416900525e-12,   1.249930893255917e-14,   1.839258715648500e-16,  -6.638886693709027e-18,   1.248639443543344e+00,
  -1.139057315220781e-02,  -3.990543911754810e-06,   1.027562951281857e-06,  -5.015225277623209e-09,  -1.435589360813397e-10,   3.040100258668688e-12,   5.673268615569284e-14,
  -1.636345956160682e-16,  -1.325185642792375e-17,   1.248638867122713e+00,  -1.139013517938950e-02,  -3.994789417264295e-06,   1.027360077329081e-06,  -5.008744428050609e-09,
  -1.433905140623879e-10,   3.039385589907340e-12,   5.666278844934271e-14,  -1.666560552180516e-16,  -1.332698187915958e-17,   1.248637920404143e+00,  -1.138941623837307e-02,
  -4.001755105016697e-06,   1.027027199657609e-06,  -4.998106200263804e-09,  -1.431141743319572e-10,   3.038203658305822e-12,   5.654776467163937e-14,  -1.716137146881589e-16,
  -1.344994135786193e-17,   1.248636915277273e+00,  -1.138865347095563e-02,  -4.009140806731129e-06,   1.026674225422240e-06,  -4.986819769135117e-09,  -1.428211637936914e-10,
   3.036937735011913e-12,   5.642534204273974e-14,  -1.768706797689391e-16,  -1.357990628221263e-17,   1.248636123813548e+00,  -1.138805323019491e-02,  -4.014949460651930e-06,
   1.026396602706413e-06,  -4.977938417087716e-09,  -1.425907132866733e-10,   3.035932904606927e-12,   5.632872495150935e-14,  -1.810053915480066e-16,  -1.368182385546409e-17,
   1.248635666874615e+00,  -1.138770684404095e-02,  -4.018300172320265e-06,   1.026236449275150e-06,  -4.972813269433106e-09,  -1.424577761347112e-10,   3.035349574293457e-12,
   5.627285736936746e-14,  -1.833905878486437e-16,  -1.374049591130587e-17,   1.248635495257427e+00,  -1.138757677723056e-02,  -4.019558099984725e-06,   1.026176322931829e-06,
  -4.970888811614926e-09,  -1.424078683274569e-10,   3.035129881097676e-12,   5.625185815262765e-14,  -1.842860580493316e-16,  -1.376250014205194e-17,   1.248635466807729e+00,
  -1.138755521703947e-02,  -4.019766603786275e-06,   1.026166356808286e-06,  -4.970569809732457e-09,  -1.423995959964821e-10,   3.035093429684064e-12,   5.624837615709003e-14,
  -1.844344847635719e-16,  -1.376614619629183e-17,   1.561612275287925e+00,  -1.087276368765240e-02,  -8.891175960263160e-05,   1.079265136808828e-06,   2.208204727820006e-08,
  -2.443265593919686e-10,  -5.873325164100381e-12,   1.489427429703926e-13,   4.019306289982494e-15,  -4.884725064178392e-17,   1.561599660265640e+00,  -1.087230414007045e-02,
  -8.889297486647626e-05,   1.078921162422113e-06,   2.206969573706493e-08,  -2.438854903112016e-10,  -5.857649697287227e-12,   1.486902457285426e-13,   4.002896109797764e-15,
  -4.893162297777757e-17,   1.561578952585286e+00,  -1.087154982358897e-02,  -8.886214424488760e-05,   1.078356924767618e-06,   2.204944268718862e-08,  -2.431619508592609e-10,
  -5.831962952213681e-12,   1.482754228555301e-13,   3.975989262912782e-15,  -4.906951869030970e-17,   1.561556982745399e+00,  -1.087074957846423e-02,  -8.882944084306500e-05,
   1.077758838962900e-06,   2.202798521949850e-08,  -2.423949631247480e-10,  -5.804771251110856e-12,   1.478348466694600e-13,   3.947484014034030e-15,  -4.921500027957828e-17,
   1.561539694254913e+00,  -1.087011988479389e-02,  -8.880371052378187e-05,   1.077288586569604e-06,   2.201112163988607e-08,  -2.417918783782603e-10,  -5.783417478795187e-12,
   1.474878099186243e-13,   3.925082797726109e-15,  -4.932888914818262e-17,   1.561529717486063e+00,  -1.086975651771082e-02,  -8.878886402953568e-05,   1.077017372726602e-06,
   2.200139877218344e-08,  -2.414440423814246e-10,  -5.771112320756631e-12,   1.472874079009445e-13,   3.912167666755423e-15,  -4.939437366011681e-17,   1.561525971253234e+00,
  -1.086962007758949e-02,  -8.878328958559101e-05,   1.076915562867621e-06,   2.199774952055397e-08,  -2.413134673437554e-10,  -5.766495110707818e-12,   1.472121322468614e-13,
   3.907320372525297e-15,  -4.941891780719933e-17,   1.561525350269068e+00,  -1.086959746109950e-02,  -8.878236557137243e-05,   1.076898688200428e-06,   2.199714469883398e-08,
  -2.412918248168970e-10,  -5.765729926609447e-12,   1.471996530329399e-13,   3.906516994196850e-15,  -4.942298392714510e-17,   1.877605158767363e+00,  -5.294418403870167e-03,
  -1.418132640845079e-04,  -2.403528431149273e-06,  -9.794066526135085e-09,   8.851112575109082e-10,   3.136997658328603e-11,   4.414810845087672e-13,  -4.791915125905451e-15,
  -4.028595648412599e-16,   1.877584961647872e+00,  -5.295440032763257e-03,  -1.418212487926072e-04,  -2.402258023484739e-06,  -9.727346847556317e-09,   8.863974829033451e-10,
   3.134966712299538e-11,   4.394094372619556e-13,  -4.850670973940159e-15,  -4.031580846354477e-16,   1.877551804045823e+00,  -5.297116807448845e-03,  -1.418343158861022e-04,
  -2.400171134462964e-06,  -9.617847673772414e-09,   8.885045504739390e-10,   3.131615771713367e-11,   4.360074594887763e-13,  -4.946940503659521e-15,  -4.036386227777368e-16,
   1.877516620234330e+00,  -5.298895458636096e-03,  -1.418481252388030e-04,  -2.397955007076107e-06,  -9.501704187696007e-09,   8.907342227192100e-10,   3.128037342909991e-11,
   4.323963127935164e-13,  -5.048834359203101e-15,  -4.041355688505147e-16,   1.877488929643630e+00,  -5.300294877965610e-03,  -1.418589528484256e-04,  -2.396209618678883e-06,
  -9.410330332836388e-09,   8.924845767559763e-10,   3.125204600420245e-11,   4.295533335139338e-13,  -5.128839976809447e-15,  -4.045173060132429e-16,   1.877472948563752e+00,
  -5.301102354438703e-03,  -1.418651854727754e-04,  -2.395201806668154e-06,  -9.357609429528753e-09,   8.934929723578323e-10,   3.123563162956355e-11,   4.279122035902371e-13,
  -5.174938357198507e-15,  -4.047338640145744e-16,   1.877466947452992e+00,  -5.301405540431787e-03,  -1.418675228233983e-04,  -2.394823266118314e-06,  -9.337814617504294e-09,
   8.938713007392493e-10,   3.122945539111847e-11,   4.272958696778552e-13,  -5.192234676407928e-15,  -4.048144752441799e-16,   1.877465952680014e+00,  -5.301455796295988e-03,
  -1.418679101112052e-04,  -2.394760512482313e-06,  -9.334533471392040e-09,   8.939339964526666e-10,   3.122843093316934e-11,   4.271936996570452e-13,  -5.195101045720966e-15,
  -4.048278003433841e-16,   2.934521687803492e-03,  -3.584022904169304e-05,   3.251736221680973e-07,  -2.693183447327905e-09,   2.047619618431358e-11,  -7.617602071973550e-14,
   3.764597698707179e-15,   3.207881854376292e-17,  -7.349701123120600e-19,  -4.883482763320825e-20,   2.934567997649510e-03,  -3.584137920116637e-05,   3.251911509538892e-07,
  -2.693291079174925e-09,   2.048419595165098e-11,  -7.608412765185821e-14,   3.761564425387399e-15,   3.183002104422886e-17,  -7.400398339633318e-19,  -4.878388988048914e-20,
   2.934644024569154e-03,  -3.584326740717616e-05,   3.252199322189577e-07,  -2.693467681411164e-09,   2.049732412943567e-11,  -7.593380679068154e-14,   3.756570360078797e-15,
   3.142177385173080e-17,  -7.483373939227051e-19,  -4.869952976646835e-20,   2.934724697470932e-03,  -3.584527098465564e-05,   3.252504780594412e-07,  -2.693654944131705e-09,
   2.051124769335298e-11,  -7.577503362965042e-14,   3.751251663383929e-15,   3.098885741070474e-17,  -7.571074777514308e-19,  -4.860901657225328e-20,   2.934788189252907e-03,
  -3.584684784320817e-05,   3.252745226416711e-07,  -2.693802229958349e-09,   2.052220093372660e-11,  -7.565060587048813e-14,   3.747051656136154e-15,   3.064834321165620e-17,
  -7.639847622678146e-19,  -4.853705917163119e-20,   2.934824832317171e-03,  -3.584775789215653e-05,   3.252884011820586e-07,  -2.693887195122530e-09,   2.052852038478516e-11,
  -7.557900758607941e-14,   3.744622082101208e-15,   3.045190368387043e-17,  -7.679438275559800e-19,  -4.849524178498489e-20,   2.934838592287394e-03,  -3.584809962705093e-05,
   3.252936130789528e-07,  -2.693919093522227e-09,   2.053089304613583e-11,  -7.555216166947703e-14,   3.743708682860301e-15,   3.037815345278599e-17,  -7.694286150359751e-19,
  -4.847948430340345e-20,   2.934840873206549e-03,  -3.584815627463122e-05,   3.252944770448232e-07,  -2.693924380776666e-09,   2.053128632996043e-11,  -7.554771368195851e-14,
   3.743557217442952e-15,   3.036592907637426e-17,  -7.696746405819332e-19,  -4.847686939429287e-20,   2.647386331929826e-02,  -3.225881700966331e-04,   2.903417816438102e-06,
  -2.367973025133256e-08,   1.753047944412133e-10,  -5.622183327539068e-13,   3.285527051241400e-14,   3.068526707530921e-16,  -6.820516376441148e-18,  -4.436898004532263e-19,
   2.647427679879363e-02,  -3.225982822943667e-04,   2.903567894689813e-06,  -2.368052292467519e-08,   1.753745920792283e-10,  -5.613374142838856e-13,   3.282713714602366e-14,
   3.045922269524302e-16,  -6.866817846292426e-18,  -4.432266237272307e-19,   2.647495560782417e-02,  -3.226148833469054e-04,   2.903814315404201e-06,  -2.368182333522698e-08,
   1.754891322891341e-10,  -5.598961182294670e-13,   3.278081964009010e-14,   3.008831083373308e-16,  -6.942599636276077e-18,  -4.424595188746423e-19,   2.647567589776919e-02,
  -3.226324986774295e-04,   2.904075845220902e-06,  -2.368320196309950e-08,   1.756106085177207e-10,  -5.583734140239218e-13,   3.273149410683582e-14,   2.969498601720943e-16,
  -7.022697899010059e-18,  -4.416364374301124e-19,   2.647624278502042e-02,  -3.226463622744696e-04,   2.904281712827835e-06,  -2.368428607784662e-08,   1.757061675737108e-10,
  -5.571798308687214e-13,   3.269254527951062e-14,   2.938561312066441e-16,  -7.085509646077043e-18,  -4.409820749107015e-19,   2.647656995286377e-02,  -3.226543633233254e-04,
   2.904400539988240e-06,  -2.368491139258189e-08,   1.757612991583582e-10,  -5.564929114312422e-13,   3.267001538424157e-14,   2.920713879309840e-16,  -7.121668920512942e-18,
  -4.406017909081199e-19,   2.647669280880014e-02,  -3.226573678148559e-04,   2.904445163969733e-06,  -2.368514613858695e-08,   1.757819983215635e-10,  -5.562353293259481e-13,
   3.266154541151167e-14,   2.914013333595019e-16,  -7.135229958651134e-18,  -4.404584922671785e-19,   2.647671317399121e-02,  -3.226578658532888e-04,   2.904452561202267e-06,
  -2.368518504762313e-08,   1.757854293302362e-10,  -5.561926505519172e-13,   3.266014087699666e-14,   2.912902693170987e-16,  -7.137476991149701e-18,  -4.404347121955095e-19,
   7.389456199351306e-02,  -8.961018936430080e-04,   7.929784703462934e-06,  -6.254302765254490e-08,   4.355977967046028e-10,  -8.684057781707847e-13,   8.576376080285586e-14,
   9.498755736308658e-16,  -2.002423152268175e-17,  -1.258072273569121e-18,   7.389569121017046e-02,  -8.961285989201341e-04,   7.930157667242194e-06,  -6.254424044852858e-08,
   4.357798847127499e-10,  -8.656694702505863e-13,   8.568123722733769e-14,   9.434661133591636e-16,  -2.015664565435839e-17,  -1.256759937530074e-18,   7.389754504065164e-02,
  -8.961724403247882e-04,   7.930770059725089e-06,  -6.254622867757768e-08,   4.360786828851565e-10,  -8.611911986384775e-13,   8.554538381584538e-14,   9.329489508725712e-16,
  -2.037337155812401e-17,  -1.254586339026555e-18,   7.389951215052543e-02,  -8.962189599464750e-04,   7.931420007763004e-06,  -6.254833458289772e-08,   4.363955555241865e-10,
  -8.564581838014067e-13,   8.540072067965079e-14,   9.217962680924097e-16,  -2.060244635448282e-17,  -1.252253953194636e-18,   7.390106031431828e-02,  -8.962555714970211e-04,
   7.931931630507376e-06,  -6.254998922568219e-08,   4.366448087741026e-10,  -8.527468669074209e-13,   8.528650001998829e-14,   9.130240305533392e-16,  -2.078208621958407e-17,
  -1.250399543397921e-18,   7.390195380514493e-02,  -8.962767008844878e-04,   7.932226942169250e-06,  -6.255094306578689e-08,   4.367886066358757e-10,  -8.506104395948032e-13,
   8.522043299213660e-14,   9.079634079440416e-16,  -2.088550201656946e-17,  -1.249321799320571e-18,   7.390228932271366e-02,  -8.962846352071211e-04,   7.932337842982381e-06,
  -6.255130103709158e-08,   4.368425945017509e-10,  -8.498092191035366e-13,   8.519559621472460e-14,   9.060634744066505e-16,  -2.092428692794509e-17,  -1.248915674279235e-18,
   7.390234493970507e-02,  -8.962859504361197e-04,   7.932356226819904e-06,  -6.255136036514308e-08,   4.368515432533845e-10,  -8.496764596294205e-13,   8.519147768957094e-14,
   9.057485533336682e-16,  -2.093071351029542e-17,  -1.248848278289008e-18,   1.459060395213647e-01,  -1.755767998799397e-03,   1.510917958098865e-05,  -1.124024964125245e-07,
   6.954688659308215e-10,   3.661568047940408e-13,   1.532015100907947e-13,   2.128326843292710e-15,  -4.205293459649841e-17,  -2.553797343793156e-18,   1.459081908665111e-01,
  -1.755815983868540e-03,   1.510977524308497e-05,  -1.124019235874296e-07,   6.957938264705643e-10,   3.723094367364175e-13,   1.530283475143193e-13,   2.115315613687313e-15,
  -4.232397254348746e-17,  -2.551151533399971e-18,   1.459117227094167e-01,  -1.755894758939127e-03,   1.511075331873533e-05,  -1.124009769603320e-07,   6.963270316728526e-10,
   3.823819214922814e-13,   1.527433001577053e-13,   2.093965666763253e-15,  -4.276759504914255e-17,  -2.546768808538861e-18,   1.459154703515533e-01,  -1.755978345123428e-03,
   1.511179140420996e-05,  -1.123999640482156e-07,   6.968924358443762e-10,   3.930314875312220e-13,   1.524397944623531e-13,   2.071325518434355e-15,  -4.323650456685785e-17,
  -2.542065217489070e-18,   1.459184198263265e-01,  -1.756044127705101e-03,   1.511260857951946e-05,  -1.123991607626904e-07,   6.973371451215235e-10,   4.013851624988953e-13,
   1.522001764531719e-13,   2.053517653233884e-15,  -4.360422924278507e-17,  -2.538325035461157e-18,   1.459201220502358e-01,  -1.756082092045073e-03,   1.511308026614762e-05,
  -1.123986947224462e-07,   6.975936884363762e-10,   4.061951756123085e-13,   1.520615851422566e-13,   2.043244435201193e-15,  -4.381592528402012e-17,  -2.536151122421091e-18,
   1.459207612568418e-01,  -1.756096348018182e-03,   1.511325740405387e-05,  -1.123985192574020e-07,   6.976900027382400e-10,   4.079992940330901e-13,   1.520094855078353e-13,
   2.039387507448047e-15,  -4.389531999713249e-17,  -2.535331892207502e-18,   1.459208672147290e-01,  -1.756098711149038e-03,   1.511328676798263e-05,  -1.123984901471829e-07,
   6.977059671428975e-10,   4.082982422726271e-13,   1.520008462307086e-13,   2.038748207028620e-15,  -4.390847557076931e-17,  -2.535195939931809e-18,   2.436398046902053e-01,
  -2.898690828604749e-03,   2.389738565420271e-05,  -1.610744384986479e-07,   7.779895427742710e-10,   5.198553145527971e-12,   2.260653579621412e-13,   4.022530225004580e-15,
  -7.435571093867958e-17,  -4.458946744856213e-18,   2.436432068050996e-01,  -2.898759568330540e-03,   2.389805264754658e-05,  -1.610669424754045e-07,   7.784684542136717e-10,
   5.210211475425508e-12,   2.257592701344807e-13,   3.999810290513356e-15,  -7.483063564673038e-17,  -4.454410938265484e-18,   2.436487919965117e-01,  -2.898872413382917e-03,
   2.389914791949022e-05,  -1.610546246992447e-07,   7.792541874243064e-10,   5.229301517966750e-12,   2.252554229502203e-13,   3.962529153825048e-15,  -7.560798083334484e-17,
  -4.446895973182837e-18,   2.436547184103742e-01,  -2.898992147533649e-03,   2.390031048766131e-05,  -1.610415385215553e-07,   7.800872610910040e-10,   5.249490964057648e-12,
   2.247189649644170e-13,   3.922994654912565e-15,  -7.642964942513252e-17,  -4.438828800056343e-18,   2.436593825973805e-01,  -2.899086376641842e-03,   2.390122572439587e-05,
  -1.610312280209840e-07,   7.807424229349048e-10,   5.265331986137736e-12,   2.242954424230985e-13,   3.891898042226773e-15,  -7.707402214580787e-17,  -4.432412529314463e-18,
   2.436620744182320e-01,  -2.899140757181288e-03,   2.390175404140601e-05,  -1.610252729827705e-07,   7.811203403482443e-10,   5.274454843008125e-12,   2.240504881894385e-13,
   3.873958527762356e-15,  -7.744498617430278e-17,  -4.428682613323737e-18,   2.436630852288942e-01,  -2.899161177440375e-03,   2.390195245161586e-05,  -1.610230359292757e-07,
   7.812622162806705e-10,   5.277876917953384e-12,   2.239584051697401e-13,   3.867223379352421e-15,  -7.758411368372736e-17,  -4.427276901912494e-18,   2.436632527855025e-01,
  -2.899164562381417e-03,   2.390198534210434e-05,  -1.610226650593707e-07,   7.812857323570364e-10,   5.278443983398148e-12,   2.239431358042815e-13,   3.866107001714570e-15,
  -7.760716692363373e-17,  -4.427043616680788e-18,   3.687417691165402e-01,  -4.316059399957027e-03,   3.332929542989596e-05,  -1.881726645723729e-07,   4.154278528278847e-10,
   1.614557322324664e-11,   3.077486352357893e-13,   6.670739992724038e-15,  -1.162934043330011e-16,  -7.219167210041784e-18,   3.687465128409279e-01,  -4.316139653234290e-03,
   3.332965382724547e-05,  -1.881495254192377e-07,   4.160790612371451e-10,   1.616492089915934e-11,   3.072694326329776e-13,   6.633949477070187e-15,  -1.170592648739043e-16,
  -7.212056900157936e-18,   3.687543004699328e-01,  -4.316271394803247e-03,   3.333024259457584e-05,  -1.881115190973309e-07,   4.171473775407589e-10,   1.619660390205094e-11,
   3.064805597025798e-13,   6.573579056560350e-15,  -1.183128210778354e-16,  -7.200273065038925e-18,   3.687625637974837e-01,  -4.316411173037270e-03,   3.333086786570469e-05,
  -1.880711647811107e-07,   4.182799256951569e-10,   1.623011422202911e-11,   3.056405417924002e-13,   6.509558518956917e-15,  -1.196378731670681e-16,  -7.187618750161274e-18,
   3.687690671168468e-01,  -4.316521172178308e-03,   3.333136035066754e-05,  -1.880393864465321e-07,   4.191705085346207e-10,   1.625640899932749e-11,   3.049773027941051e-13,
   6.459201089465073e-15,  -1.206770256389963e-16,  -7.177550786902171e-18,   3.687728203245217e-01,  -4.316584652001285e-03,   3.333164473095724e-05,  -1.880210388331464e-07,
   4.196841848012219e-10,   1.627155296348261e-11,   3.045936781100247e-13,   6.430149741203367e-15,  -1.212752691595274e-16,  -7.171696761440081e-18,   3.687742296941426e-01,
  -4.316608488770619e-03,   3.333175154836165e-05,  -1.880141476650144e-07,   4.198770192484053e-10,   1.627723376402940e-11,   3.044494615226666e-13,   6.419242739864030e-15,
  -1.214996373407092e-16,  -7.169490282354989e-18,   3.687744633174793e-01,  -4.316612440028082e-03,   3.333176925644610e-05,  -1.880130052784356e-07,   4.199089813573747e-10,
   1.627817512635442e-11,   3.044255470328637e-13,   6.417434857579272e-15,  -1.215368149004100e-16,  -7.169124092658935e-18,   5.235152652766275e-01,  -5.985054801446920e-03,
   4.166949757488692e-05,  -1.599469151553042e-07,  -7.596375770349099e-10,   3.499240816869341e-11,   4.485875979933972e-13,   9.628299611921279e-15,  -1.631304993401015e-16,
  -1.125772592866894e-17,   5.235211938588277e-01,  -5.985122909508760e-03,   4.166885433852321e-05,  -1.598968840245710e-07,  -7.586880654481042e-10,   3.502026550743179e-11,
   4.479130367083716e-13,   9.570916891542129e-15,  -1.643190197349006e-16,  -1.124703925936377e-17,   5.235309265209948e-01,  -5.985234704425650e-03,   4.166779894530470e-05,
  -1.598147215519256e-07,  -7.571303422239706e-10,   3.506587408498696e-11,   4.468022451115970e-13,   9.476754739909058e-15,  -1.662644376101431e-16,  -1.122932278895994e-17,
   5.235412535395050e-01,  -5.985353306417375e-03,   4.166667988402066e-05,  -1.597275024602394e-07,  -7.554789124258411e-10,   3.511410017000227e-11,   4.456190110361640e-13,
   9.376897315322131e-15,  -1.683208852583640e-16,  -1.121029008368199e-17,   5.235493808934668e-01,  -5.985446631559739e-03,   4.166579975040927e-05,  -1.596588328591553e-07,
  -7.541802696661434e-10,   3.515193265260738e-11,   4.446844773967322e-13,   9.298349741648293e-15,  -1.699336774206676e-16,  -1.119514200551988e-17,   5.235540713227704e-01,
  -5.985500485210820e-03,   4.166529203788492e-05,  -1.596191911969941e-07,  -7.534312156228481e-10,   3.517371774766793e-11,   4.441438103998176e-13,   9.253034823338312e-15,
  -1.708621886961623e-16,  -1.118633201294330e-17,   5.235558326207789e-01,  -5.985520706636658e-03,   4.166510143020554e-05,  -1.596043032641899e-07,  -7.531500174914410e-10,
   3.518188905090095e-11,   4.439405335825352e-13,   9.236021735632802e-15,  -1.712104261781521e-16,  -1.118301098127377e-17,   5.235561245808794e-01,  -5.985524058566467e-03,
   4.166506983654481e-05,  -1.596018352657847e-07,  -7.531034090517116e-10,   3.518324307519512e-11,   4.439068243067189e-13,   9.233201737401306e-15,  -1.712681289585984e-16,
  -1.118245979819905e-17,   7.111277887598103e-01,  -7.849656909397755e-03,   4.566855615395763e-05,  -2.083806740146699e-08,  -3.129346291234194e-09,   5.817592480728743e-11,
   8.368980621910225e-13,   1.153209544782175e-14,  -2.135678803954220e-16,  -1.711673897806247e-17,   7.111342823780036e-01,  -7.849665512107135e-03,   4.566589423630835e-05,
  -2.075500085084996e-08,  -3.127570458920216e-09,   5.820899452996041e-11,   8.360087451419843e-13,   1.144484317786631e-14,  -2.154233866373292e-16,  -1.710068147209370e-17,
   7.111449424313420e-01,  -7.849679609150747e-03,   4.566152536008408e-05,  -2.061860022556450e-08,  -3.124656535092276e-09,   5.826309565845696e-11,   8.345434932335647e-13,
   1.130166590675346e-14,  -2.184608150832669e-16,  -1.707405591462261e-17,   7.111562532024563e-01,  -7.849694532274836e-03,   4.565689112892229e-05,  -2.047382327917916e-08,
  -3.121566533421907e-09,   5.832024546775743e-11,   8.329815663904071e-13,   1.114982780865596e-14,  -2.216719528810945e-16,  -1.704544513368128e-17,   7.111651545713823e-01,
  -7.849706251558203e-03,   4.565324503884871e-05,  -2.035985031673185e-08,  -3.119136062641187e-09,   5.836503761468387e-11,   8.317471330759775e-13,   1.103039170408439e-14,
  -2.241905820578389e-16,  -1.702266880645847e-17,   7.111702916182897e-01,  -7.849713004845393e-03,   4.565114123943924e-05,  -2.029406119305340e-08,  -3.117733943453623e-09,
   5.839081387933190e-11,   8.310326411454119e-13,   1.096148749348695e-14,  -2.256407025629598e-16,  -1.700942026999967e-17,   7.111722206102332e-01,  -7.849715538855074e-03,
   4.565035132318935e-05,  -2.026935425044253e-08,  -3.117207538420527e-09,   5.840047910845991e-11,   8.307639502965411e-13,   1.093561796239095e-14,  -2.261845888618463e-16,
  -1.700442569706736e-17,   7.111725403671907e-01,  -7.849715958802326e-03,   4.565022038755538e-05,  -2.026525859070089e-08,  -3.117120284776292e-09,   5.840208051925927e-11,
   8.307193902716654e-13,   1.093132996488522e-14,  -2.262747115932924e-16,  -1.700359674071597e-17,   9.358579583920273e-01,  -9.770474974298676e-03,   3.888174527509349e-05,
   3.151964350319841e-07,  -6.506933154534827e-09,   6.038815182129072e-11,   1.987310062334277e-12,   1.213950275754325e-14,  -3.492531516777239e-16,  -2.492460619145077e-17,
   9.358634804258192e-01,  -9.770340105316197e-03,   3.887621329670839e-05,   3.152826591226120e-07,  -6.502708384990283e-09,   6.042240111343317e-11,   1.985855925586502e-12,
   1.201244842759424e-14,  -3.522779100128522e-16,  -2.490130774942874e-17,   9.358725451730898e-01,  -9.770118669374599e-03,   3.886713426033554e-05,   3.154242443096612e-07,
  -6.495775018489887e-09,   6.047835285549380e-11,   1.983460091301257e-12,   1.180395754706894e-14,  -3.572299696837934e-16,  -2.486264883035307e-17,   9.358821628029911e-01,
  -9.769883672459798e-03,   3.885750423581360e-05,   3.155745237178909e-07,  -6.488421281893007e-09,   6.053734967783872e-11,   1.980906213790478e-12,   1.158285489458603e-14,
  -3.624660362219081e-16,  -2.482107128264915e-17,   9.358897313726582e-01,  -9.769698702390433e-03,   3.884992791456067e-05,   3.156928280072967e-07,  -6.482636103544110e-09,
   6.058351101634569e-11,   1.978887835706291e-12,   1.140893513607737e-14,  -3.665734826100925e-16,  -2.478794656215041e-17,   9.358940991195370e-01,  -9.769591942017600e-03,
   3.884555649684544e-05,   3.157611171569056e-07,  -6.479298268176808e-09,   6.061004363837977e-11,   1.977719603385210e-12,   1.130859860930814e-14,  -3.689386107009429e-16,
  -2.476866831672143e-17,   9.358957392098392e-01,  -9.769551850445755e-03,   3.884391517981729e-05,   3.157867629454594e-07,  -6.478045048928271e-09,   6.061998649408679e-11,
   1.977280281041262e-12,   1.127092806940265e-14,  -3.698257265738254e-16,  -2.476139867743059e-17,   9.358960110760627e-01,  -9.769545204588862e-03,   3.884364311824928e-05,
   3.157910142355545e-07,  -6.477837318932464e-09,   6.062163358822456e-11,   1.977207423354546e-12,   1.126468399880566e-14,  -3.699727252688811e-16,  -2.476019202403306e-17,
   1.203089219111549e+00,  -1.137472846281514e-02,   7.778277241357031e-06,   9.288365639272432e-07,  -7.033581084747037e-09,  -5.271779401493060e-11,   4.452897754502198e-12,
   3.943433005873506e-14,  -1.072028924173960e-15,  -3.895080296301639e-17,   1.203090314049121e+00,  -1.137433218345800e-02,   7.772325193871798e-06,   9.287625078937016e-07,
  -7.024127854432378e-09,  -5.260312376526565e-11,   4.448533794344437e-12,   3.923541268240048e-14,  -1.076500360146222e-15,  -3.892801539964835e-17,   1.203092110962776e+00,
  -1.137368164936610e-02,   7.762559761756037e-06,   9.286410495496145e-07,  -7.008615628390889e-09,  -5.241530322429178e-11,   4.441356898005789e-12,   3.890894738580432e-14,
  -1.083818565788178e-15,  -3.888989043058297e-17,   1.203094016807063e+00,  -1.137299141311885e-02,   7.752205787143022e-06,   9.285123311136630e-07,  -6.992165184876297e-09,
  -5.221659436685785e-11,   4.433724364072770e-12,   3.856266592782299e-14,  -1.091553317436697e-15,  -3.884846569294927e-17,   1.203095516123099e+00,  -1.137244821577901e-02,
   7.744062875328530e-06,   9.284111434186066e-07,  -6.979225288554960e-09,  -5.206063165605831e-11,   4.427705027528455e-12,   3.829023112216187e-14,  -1.097618564766280e-15,
  -3.881516199489906e-17,   1.203096381169909e+00,  -1.137213473487160e-02,   7.739365734198260e-06,   9.283527918119207e-07,  -6.971760105470688e-09,  -5.197079173741496e-11,
   4.424226152360623e-12,   3.813304032815829e-14,  -1.101110098272268e-15,  -3.879566061643722e-17,   1.203096705958652e+00,  -1.137201702135511e-02,   7.737602344232691e-06,
   9.283308888508607e-07,  -6.968957362644147e-09,  -5.193708793389963e-11,   4.422918856493380e-12,   3.807402059549820e-14,  -1.102419532688108e-15,  -3.878828455013894e-17,
   1.203096759794665e+00,  -1.137199750874351e-02,   7.737310059958566e-06,   9.283272585775631e-07,  -6.968492794691886e-09,  -5.193150273300447e-11,   4.422702103736014e-12,
   3.806423759898793e-14,  -1.102636502015687e-15,  -3.878705906098564e-17,   1.516788593466846e+00,  -1.152665984886517e-02,  -7.402232196675242e-05,   1.387478281500727e-06,
   1.618928412446742e-08,  -3.230613747252179e-10,  -3.118801082762129e-13,   2.291013364612343e-13,   3.805400250349285e-16,  -1.502856063923518e-16,   1.516778087337031e+00,
  -1.152606910688648e-02,  -7.400850252618183e-05,   1.387024208231494e-06,   1.618863275626629e-08,  -3.223888792072093e-10,  -3.106371246667967e-13,   2.283392043967169e-13,
   3.673182241354954e-16,  -1.499960315609924e-16,   1.516760841244937e+00,  -1.152509944708496e-02,  -7.398581607487592e-05,   1.386279460104285e-06,   1.618756520274912e-08,
  -3.212865100689732e-10,  -3.086343378358766e-13,   2.270891181790687e-13,   3.456659507352840e-16,  -1.495200268490746e-16,   1.516742543738550e+00,  -1.152407075156416e-02,
  -7.396174453548942e-05,   1.385490157046917e-06,   1.618643482355049e-08,  -3.201190403158667e-10,  -3.065604769571870e-13,   2.257641449599105e-13,   3.227638792053210e-16,
  -1.490141053692414e-16,   1.516728144902389e+00,  -1.152326129915157e-02,  -7.394280049719429e-05,   1.384869645654379e-06,   1.618554690568406e-08,  -3.192018484126430e-10,
  -3.049653781029855e-13,   2.247224456768444e-13,   3.047924528242617e-16,  -1.486153316455145e-16,   1.516719835612667e+00,  -1.152279420296922e-02,  -7.393186767832357e-05,
   1.384511806434936e-06,   1.618503514276361e-08,  -3.186731652406325e-10,  -3.040596411933266e-13,   2.241216865209312e-13,   2.944418900445857e-16,  -1.483849466709763e-16,
   1.516716715497630e+00,  -1.152261881403073e-02,  -7.392776232560500e-05,   1.384377485261528e-06,   1.618484309670802e-08,  -3.184747615535257e-10,  -3.037223276113235e-13,
   2.238961760168618e-13,   2.905591392093887e-16,  -1.482983885414999e-16,   1.516716198299487e+00,  -1.152258974134818e-02,  -7.392708180618372e-05,   1.384355222294801e-06,
   1.618481126894920e-08,  -3.184418797429023e-10,  -3.036665606865712e-13,   2.238587986723245e-13,   2.899157281008578e-16,  -1.482840378510770e-16,   1.853974175535857e+00,
  -6.545327807128745e-03,  -1.708688484826193e-04,  -2.374015388143719e-06,   1.628230028917429e-08,   1.752994358836551e-09,   3.888758147772342e-11,  -1.552594384854273e-14,
  -2.577193220944825e-14,  -7.282228468128613e-16,   1.853949888539768e+00,  -6.546332516823933e-03,  -1.708544831748826e-04,  -2.371521684088337e-06,   1.636408485903175e-08,
   1.752889801065295e-09,   3.878448250688108e-11,  -1.917564552487029e-14,  -2.579213308217284e-14,  -7.252119243132290e-16,   1.853910019055334e+00,  -6.547981141202754e-03,
  -1.708308501137221e-04,  -2.367427996854162e-06,   1.649818819266974e-08,   1.752710322106600e-09,   3.861517394232079e-11,  -2.515601655484055e-14,  -2.582472697558633e-14,
  -7.202615511372661e-16,   1.853867716560455e+00,  -6.549729413728565e-03,  -1.708057055951966e-04,  -2.363084461479318e-06,   1.664026568332155e-08,   1.752509252120107e-09,
   3.843545072664800e-11,  -3.148640917914681e-14,  -2.585853935115737e-14,  -7.149987752920336e-16,   1.853834425804182e+00,  -6.551104556547863e-03,  -1.707858675252539e-04,
  -2.359666212382143e-06,   1.675192462051777e-08,   1.752343323804863e-09,   3.829395492228701e-11,  -3.645741336105109e-14,  -2.588459167388298e-14,  -7.108497366698499e-16,
   1.853815213671557e+00,  -6.551897874985405e-03,  -1.707743988786210e-04,  -2.357693529662403e-06,   1.681630231425433e-08,   1.752244486176631e-09,   3.821227403740921e-11,
  -3.932184468450200e-14,  -2.589940353883623e-14,  -7.084523790834471e-16,   1.853807999440812e+00,  -6.552195716607500e-03,  -1.707700885643063e-04,  -2.356952778343234e-06,
   1.684046489543713e-08,   1.752206790461007e-09,   3.818159813210928e-11,  -4.039662891330660e-14,  -2.590492334614208e-14,  -7.075516083821714e-16,   1.853806803584930e+00,
  -6.552245085094688e-03,  -1.707693738716231e-04,  -2.356829988774694e-06,   1.684446956221303e-08,   1.752200511205521e-09,   3.817651295554862e-11,  -4.057474555287367e-14,
  -2.590583610813194e-14,  -7.074022643706926e-16,   2.796166619553657e-03,  -3.336262599502408e-05,   2.947874308853784e-07,  -2.372608714251135e-09,   1.990755313272816e-11,
   2.046769140960361e-14,   4.029914589278965e-15,  -2.480353212800704e-17,  -2.929518005309395e-18,  -6.609042979500842e-20,   2.796208604250243e-03,  -3.336363881359513e-05,
   2.948044767192998e-07,  -2.372580261973428e-09,   1.991601733600013e-11,   2.038833598963267e-14,   4.018284110130005e-15,  -2.513214477162651e-17,  -2.927511952884200e-18,
  -6.571890887361479e-20,   2.796277530687594e-03,  -3.336530151062760e-05,   2.948324653950076e-07,  -2.372533636744345e-09,   1.992989477487846e-11,   2.025735790857065e-14,
   3.999196825437810e-15,  -2.567024058519422e-17,  -2.924174717866775e-18,  -6.510908145499588e-20,   2.796350669361559e-03,  -3.336706574906396e-05,   2.948621705780921e-07,
  -2.372484278043684e-09,   1.994459545969474e-11,   2.011742580325579e-14,   3.978952004277951e-15,  -2.623933325580717e-17,  -2.920574029356134e-18,  -6.446212831691609e-20,
   2.796408231617912e-03,  -3.336845420558319e-05,   2.948855538020659e-07,  -2.372445515531259e-09,   1.995614734968807e-11,   2.000660888535363e-14,   3.963025260530544e-15,
  -2.668585943773610e-17,  -2.917697210533460e-18,  -6.395306527124915e-20,   2.796441452617454e-03,  -3.336925550762749e-05,   2.948990507561466e-07,  -2.372423178317258e-09,
   1.996280710720889e-11,   1.994237826399498e-14,   3.953836062961672e-15,  -2.694301623791272e-17,  -2.916019719073281e-18,  -6.365931372720586e-20,   2.796453927564653e-03,
  -3.336955640387795e-05,   2.949041193816868e-07,  -2.372414796794407e-09,   1.996530657736001e-11,   1.991820690812037e-14,   3.950385890763176e-15,  -2.703947870037543e-17,
  -2.915386553385158e-18,  -6.354901460827676e-20,   2.796455995472653e-03,  -3.336960628170493e-05,   2.949049595992309e-07,  -2.372413407770892e-09,   1.996572082989005e-11,
   1.991419741162157e-14,   3.949813999806105e-15,  -2.705546332851791e-17,  -2.915281425713257e-18,  -6.353073135125291e-20,   2.522823222016810e-02,  -3.004503359491835e-04,
   2.635864493404215e-06,  -2.091969542150306e-08,   1.724446699160704e-10,   2.881339808727711e-13,   3.563095620318430e-14,  -2.148054510771610e-16,  -2.678415393058814e-17,
  -6.017166344943358e-19,   2.522860762000532e-02,  -3.004592656015320e-04,   2.636012157411043e-06,  -2.091929125092489e-08,   1.725194654929545e-10,   2.874444187220565e-13,
   3.552461616753822e-14,  -2.177972160641179e-16,  -2.676601776420083e-17,  -5.983315449826395e-19,   2.522922391486807e-02,  -3.004739249481809e-04,   2.636254617542206e-06,
  -2.091862846849274e-08,   1.726420906825420e-10,   2.863059877494617e-13,   3.535009631714050e-14,  -2.226961538077485e-16,  -2.673584312681740e-17,  -5.927751105101983e-19,
   2.522987787211483e-02,  -3.004894794811785e-04,   2.636511948626121e-06,  -2.091792619944219e-08,   1.727719828413112e-10,   2.850893369759793e-13,   3.516499200593830e-14,
  -2.278772795989003e-16,  -2.670328155197645e-17,  -5.868803644615247e-19,   2.523039255494168e-02,  -3.005017208597415e-04,   2.636714514493256e-06,  -2.091737423274827e-08,
   1.728740474893547e-10,   2.841255480717682e-13,   3.501936854710983e-14,  -2.319425270968863e-16,  -2.667726260035667e-17,  -5.822419812650083e-19,   2.523068959449380e-02,
  -3.005087855503595e-04,   2.636831437220909e-06,  -2.091705597261040e-08,   1.729328864036648e-10,   2.835668138108341e-13,   3.493534845295038e-14,  -2.342837206396852e-16,
  -2.666208942684814e-17,  -5.795654203237691e-19,   2.523080113693886e-02,  -3.005114384028078e-04,   2.636875346269184e-06,  -2.091693651780689e-08,   1.729549687943953e-10,
   2.833565290439591e-13,   3.490380225938574e-14,  -2.351619283891069e-16,  -2.665636209035820e-17,  -5.785604112359656e-19,   2.523081962675585e-02,  -3.005118781505918e-04,
   2.636882625001836e-06,  -2.091691671936980e-08,   1.729586286228206e-10,   2.833216463132463e-13,   3.489857324762590e-14,  -2.353074546382970e-16,  -2.665541113868475e-17,
  -5.783938201275074e-19,   7.043244419471337e-02,  -8.355477545529499e-04,   7.220895172135633e-06,  -5.559342129746283e-08,   4.403958368094180e-10,   1.389518566525806e-12,
   9.555214884279482e-14,  -5.525263749371484e-16,  -7.675198146877005e-17,  -1.712346528171362e-18,   7.043347253962773e-02,  -8.355714816807055e-04,   7.221272334839179e-06,
  -5.559145911893405e-08,   4.405961849578975e-10,   1.387731838705385e-12,   9.524740139827638e-14,  -5.610400118837520e-16,  -7.670107608622795e-17,  -1.702704758074260e-18,
   7.043516077325979e-02,  -8.356104330002984e-04,   7.221891630970230e-06,  -5.558823977916799e-08,   4.409246192831238e-10,   1.384780414744594e-12,   9.474726231299221e-14,
  -5.749808379627989e-16,  -7.661636082595985e-17,  -1.686878156788562e-18,   7.043695217267883e-02,  -8.356517625450472e-04,   7.222548918379007e-06,  -5.558482639495724e-08,
   4.412724754145818e-10,   1.381624004081794e-12,   9.421678605248030e-14,  -5.897246350835538e-16,  -7.652491777290566e-17,  -1.670087690339741e-18,   7.043836205185562e-02,
  -8.356842885235808e-04,   7.223066327341449e-06,  -5.558214192260770e-08,   4.415457781419632e-10,   1.379122026288947e-12,   9.379945187881182e-14,  -6.012929716085445e-16,
  -7.645182963749339e-17,  -1.656875647540953e-18,   7.043917573610080e-02,  -8.357030596652660e-04,   7.223364982359751e-06,  -5.558059341693382e-08,   4.417033213823095e-10,
   1.377670935324833e-12,   9.355866213305656e-14,  -6.079552125626163e-16,  -7.640920025431257e-17,  -1.649251620570368e-18,   7.043948128553759e-02,  -8.357101083709271e-04,
   7.223477139392169e-06,  -5.558001208082459e-08,   4.417624454524942e-10,   1.377124685990804e-12,   9.346825495663443e-14,  -6.104542906395135e-16,  -7.639310778409026e-17,
  -1.646388898029217e-18,   7.043953193488391e-02,  -8.357112767924262e-04,   7.223495731505802e-06,  -5.557991572360383e-08,   4.417722442680000e-10,   1.377034066144955e-12,
   9.345326929520764e-14,  -6.108684082974274e-16,  -7.639043576058532e-17,  -1.645914370167780e-18,   1.391164413431506e-01,  -1.640098774605866e-03,   1.382804960077807e-05,
  -1.010003065242541e-07,   7.432007475795476e-10,   4.510221445224223e-12,   1.780255172185892e-13,  -9.692619991607174e-16,  -1.574714111484089e-16,  -3.490249595837993e-18,
   1.391184104565881e-01,  -1.640141871288336e-03,   1.382868628565060e-05,  -1.009939151870616e-07,   7.435733379747389e-10,   4.507048602981656e-12,   1.774002123508004e-13,
  -9.866153508912406e-16,  -1.573697124865032e-16,  -3.470602543586641e-18,   1.391216431409024e-01,  -1.640212619503886e-03,   1.382973173452501e-05,  -1.009834261503442e-07,
   7.441840418446692e-10,   4.501802728854219e-12,   1.763739795276208e-13,  -1.015030962880889e-15,  -1.572004119997826e-16,  -3.438352085552489e-18,   1.391250733584301e-01,
  -1.640287686160884e-03,   1.383084134560812e-05,  -1.009723010830036e-07,   7.448307365537485e-10,   4.496186060553027e-12,   1.752854871803765e-13,  -1.045083294436807e-15,
  -1.570175905970716e-16,  -3.404136758753199e-18,   1.391277730225520e-01,  -1.640346762083470e-03,   1.383171483885071e-05,  -1.009635489515575e-07,   7.453387409319424e-10,
   4.491729296699403e-12,   1.744291449596808e-13,  -1.068663089136825e-15,  -1.568714122915907e-16,  -3.377212930790391e-18,   1.391293310775270e-01,  -1.640380855179744e-03,
   1.383221903838331e-05,  -1.009584992755750e-07,   7.456315403545326e-10,   4.489142635910554e-12,   1.739350571198957e-13,  -1.082242772006249e-15,  -1.567861311546380e-16,
  -3.361676279118396e-18,   1.391299161475817e-01,  -1.640393657330167e-03,   1.383240838722826e-05,  -1.009566033278734e-07,   7.457414176643136e-10,   4.488168566845522e-12,
   1.737495457733274e-13,  -1.087336657847870e-15,  -1.567539338112109e-16,  -3.355842427700079e-18,   1.391300131315774e-01,  -1.640395779462133e-03,   1.383243977540127e-05,
  -1.009562890609161e-07,   7.457596276143952e-10,   4.488006955828322e-12,   1.737187958574102e-13,  -1.088180756410783e-15,  -1.567485874971650e-16,  -3.354875400234242e-18,
   2.324154696674240e-01,  -2.715021722961497e-03,   2.204365378618001e-05,  -1.474686829762716e-07,   9.432497304553460e-10,   1.153941250481745e-11,   2.775519650722533e-13,
  -1.418647885027628e-15,  -2.761811355978509e-16,  -6.113663082445082e-18,   2.324186082675599e-01,  -2.715084622727873e-03,   2.204446245087512e-05,  -1.474523018647083e-07,
   9.438291725922203e-10,   1.153468900030892e-11,   2.764551745139023e-13,  -1.449047758423193e-15,  -2.760076000775990e-16,  -6.079362975505970e-18,   2.324237608714946e-01,
  -2.715187877832253e-03,   2.204579035834821e-05,  -1.474254146771475e-07,   9.447787304797795e-10,   1.152686953864393e-11,   2.746551386905607e-13,  -1.498827098459191e-15,
  -2.757185897587058e-16,  -6.023058254698895e-18,   2.324292282965162e-01,  -2.715297432627396e-03,   2.204719985068136e-05,  -1.473968922039482e-07,   9.457839881789220e-10,
   1.151848420759743e-11,   2.727458793581220e-13,  -1.551474271337002e-15,  -2.754063360434934e-16,  -5.963321246050134e-18,   2.324335312713072e-01,  -2.715383647867381e-03,
   2.204830947554834e-05,  -1.473744498998720e-07,   9.465734688231366e-10,   1.151182111052856e-11,   2.712438070157548e-13,  -1.592782948541812e-15,  -2.751565525946961e-16,
  -5.916313189616720e-18,   2.324360146353047e-01,  -2.715433402380509e-03,   2.204895000070220e-05,  -1.473615000338974e-07,   9.470284272688405e-10,   1.150795017261918e-11,
   2.703771437244043e-13,  -1.616572921286821e-15,  -2.750107823623557e-16,  -5.889186192339250e-18,   2.324369471694376e-01,  -2.715452085319266e-03,   2.204919055051131e-05,
  -1.473566376146091e-07,   9.471991427711815e-10,   1.150649177532262e-11,   2.700517433148585e-13,  -1.625496828771431e-15,  -2.749557392790220e-16,  -5.879000182665108e-18,
   2.324371017506484e-01,  -2.715455182263971e-03,   2.204923042646943e-05,  -1.473558316193058e-07,   9.472274346668856e-10,   1.150624977084655e-11,   2.699978056687624e-13,
  -1.626975594921730e-15,  -2.749465990244184e-16,  -5.877311729816711e-18,   3.519966946196770e-01,  -4.058316906617849e-03,   3.112320850097691e-05,  -1.784886695011804e-07,
   8.240217255776533e-10,   2.508141705285990e-11,   3.973777946436516e-13,  -2.007016722151024e-15,  -4.430920232112440e-16,  -9.913245660455173e-18,   3.520011251052718e-01,
  -4.058392981482662e-03,   3.112391676421460e-05,  -1.784530347823627e-07,   8.248490768227171e-10,   2.507463425119416e-11,   3.956180223423293e-13,  -2.056322038573625e-15,
  -4.428201011130515e-16,  -9.858086347417522e-18,   3.520083985382277e-01,  -4.058517859707218e-03,   3.112507999693441e-05,  -1.783945419243873e-07,   8.262045959010154e-10,
   2.506339364874301e-11,   3.927298927614565e-13,  -2.137060482903293e-15,  -4.423670020613543e-16,  -9.767537450072384e-18,   3.520161163131283e-01,  -4.058650350236795e-03,
   3.112631496080700e-05,  -1.783324864616246e-07,   8.276392214399687e-10,   2.505132331058661e-11,   3.896664909976538e-13,  -2.222452683099187e-15,  -4.418771507965392e-16,
  -9.671464536286156e-18,   3.520221903152413e-01,  -4.058754610179706e-03,   3.112728737841896e-05,  -1.782836557586953e-07,   8.287656118258325e-10,   2.504172040740686e-11,
   3.872564018955722e-13,  -2.289455864866008e-15,  -4.414850788026832e-16,  -9.595860090347183e-18,   3.520256957697885e-01,  -4.058814776302654e-03,   3.112784877764319e-05,
  -1.782554775355346e-07,   8.294146046841581e-10,   2.503613696539291e-11,   3.858658254317253e-13,  -2.328044172845620e-15,  -4.412561836165369e-16,  -9.552229717854200e-18,
   3.520270121083404e-01,  -4.058837368461952e-03,   3.112805962603128e-05,  -1.782448968882168e-07,   8.296581059150384e-10,   2.503403250625464e-11,   3.853437134207377e-13,
  -2.342519244065425e-15,  -4.411697361085246e-16,  -9.535846568486780e-18,   3.520272303105879e-01,  -4.058841113392574e-03,   3.112809457914181e-05,  -1.782431430238337e-07,
   8.296984590714652e-10,   2.503368324961130e-11,   3.852571692276312e-13,  -2.344917891288407e-15,  -4.411553800941620e-16,  -9.533130853515712e-18,   5.002293857601660e-01,
  -5.659525511498719e-03,   3.970241266491227e-05,  -1.658416032359088e-07,   6.489340721830552e-11,   4.798130764704050e-11,   5.748630001341000e-13,  -3.319370773670950e-15,
  -6.728285418794610e-16,  -1.549143918029790e-17,   5.002350358302939e-01,  -5.659596072060341e-03,   3.970247483067124e-05,  -1.657734175386034e-07,   6.608878370988615e-11,
   4.797016071843936e-11,   5.721906231930601e-13,  -3.396450231604057e-15,  -6.724250199225047e-16,  -1.540636494880515e-17,   5.002443113425756e-01,  -5.659711887628102e-03,
   3.970257761346209e-05,  -1.656614916518563e-07,   6.804706932562082e-11,   4.795169622603920e-11,   5.678047058801892e-13,  -3.522673622856885e-15,  -6.717521275263962e-16,
  -1.526670147904832e-17,   5.002541533886115e-01,  -5.659834748339827e-03,   3.970268766147557e-05,  -1.655427459965272e-07,   7.011936559279242e-11,   4.793188008978728e-11,
   5.631525857511803e-13,  -3.656178272162626e-15,  -6.710239718490352e-16,  -1.511850879157924e-17,   5.002618991382887e-01,  -5.659931419691430e-03,   3.970277498374538e-05,
  -1.654493044600343e-07,   7.174622274187371e-11,   4.791612288231443e-11,   5.594925699156273e-13,  -3.760937164494347e-15,  -6.704406788357115e-16,  -1.500188232204936e-17,
   5.002663693650006e-01,  -5.659987202332143e-03,   3.970282566494350e-05,  -1.653953823233717e-07,   7.268349029209755e-11,   4.790696432716057e-11,   5.573807993417141e-13,
  -3.821271321391594e-15,  -6.700999563294112e-16,  -1.493457608205484e-17,   5.002680479801715e-01,  -5.660008147702233e-03,   3.970284475021537e-05,  -1.653751349351776e-07,
   7.303513674798365e-11,   4.790351296931001e-11,   5.565879027696948e-13,  -3.843903913326035e-15,  -6.699712390601772e-16,  -1.490930218865655e-17,   5.002683262346945e-01,
  -5.660011619614510e-03,   3.970284791671890e-05,  -1.653717786888604e-07,   7.309341099563617e-11,   4.790294021247347e-11,   5.564564737993794e-13,  -3.847654350522274e-15,
  -6.699498615973304e-16,  -1.490511269439103e-17,   6.804571987396695e-01,  -7.486063891047711e-03,   4.516026234733932e-05,  -6.042030095425709e-08,  -1.745502423557402e-09,
   8.071957420784956e-11,   9.569011269666176e-13,  -7.112011776997261e-15,  -9.942657063525198e-16,  -2.387830429216662e-17,   6.804636224025380e-01,  -7.486089280718285e-03,
   4.515878324429072e-05,  -6.030562821164894e-08,  -1.743506713303807e-09,   8.069642814854359e-11,   9.529513626063764e-13,  -7.230856572679338e-15,  -9.937031181247680e-16,
  -2.374850741913472e-17,   6.804741677347320e-01,  -7.486130926635204e-03,   4.515635627391550e-05,  -6.011739893186570e-08,  -1.740236519197761e-09,   8.065817570966652e-11,
   9.464688977897220e-13,  -7.425478824979484e-15,  -9.927634049689131e-16,  -2.353541092931692e-17,   6.804853569434449e-01,  -7.486175068151057e-03,   4.515378272224632e-05,
  -5.991770667430554e-08,  -1.736774862101083e-09,   8.061724168418391e-11,   9.395928545316969e-13,  -7.631334727682534e-15,  -9.917444179191131e-16,  -2.330928254661677e-17,
   6.804941627620246e-01,  -7.486209772991081e-03,   4.515175851765436e-05,  -5.976057222548520e-08,  -1.734056507450299e-09,   8.058477688141349e-11,   9.341830958252537e-13,
  -7.792871349629795e-15,  -9.909266667223813e-16,  -2.313130821125222e-17,   6.804992447130229e-01,  -7.486229787898520e-03,   4.515059078772261e-05,  -5.966989668276389e-08,
  -1.732490091588098e-09,   8.056594094038489e-11,   9.310617156793746e-13,  -7.885907665428034e-15,  -9.904484043282854e-16,  -2.302859230199189e-17,   6.805011530249895e-01,
  -7.486237301061682e-03,   4.515015238382787e-05,  -5.963584897532626e-08,  -1.731902340388634e-09,   8.055884899856843e-11,   9.298897389869038e-13,  -7.920807885213557e-15,
  -9.902676185672249e-16,  -2.299002087927248e-17,   6.805014693544240e-01,  -7.486238546337087e-03,   4.515007971686962e-05,  -5.963020517872471e-08,  -1.731804936139127e-09,
   8.055767241324933e-11,   9.296954740884381e-13,  -7.926591205366301e-15,  -9.902375878146026e-16,  -2.298362708516967e-17,   8.974197654546890e-01,  -9.445952401808250e-03,
   4.208792288245731e-05,   2.234200521908190e-07,  -4.805183581697465e-09,   1.099472926348974e-10,   2.011880370207909e-12,  -1.661244632521675e-14,  -1.520132895943560e-15,
  -3.647589265870750e-17,   8.974257466730157e-01,  -9.445856467761594e-03,   4.208384389476912e-05,   2.235760690939627e-07,  -4.800960753516733e-09,   1.098947584124582e-10,
   2.005838135721966e-12,  -1.679389658528736e-14,  -1.519439356972103e-15,  -3.627414014060918e-17,   8.974355653954644e-01,  -9.445698928456639e-03,   4.207715015941243e-05,
   2.238321408656099e-07,  -4.794037611516535e-09,   1.098081265773945e-10,   1.995920973691712e-12,  -1.709102915472910e-14,  -1.518275235383679e-15,  -3.594288379698911e-17,
   8.974459832544170e-01,  -9.445531701794801e-03,   4.207005109630469e-05,   2.241037775348619e-07,  -4.786704279219722e-09,   1.097156765125378e-10,   1.985401052015246e-12,
  -1.740529391843341e-14,  -1.517005340666695e-15,  -3.559133523077269e-17,   8.974541817556105e-01,  -9.445400046273590e-03,   4.206446663334845e-05,   2.243175023516731e-07,
  -4.780942070271428e-09,   1.096425369645417e-10,   1.977123988463789e-12,  -1.765188637074698e-14,  -1.515980881297359e-15,  -3.531462421482324e-17,   8.974589131072384e-01,
  -9.445324046356328e-03,   4.206124474672206e-05,   2.244408251524672e-07,  -4.777620258936157e-09,   1.096001742622438e-10,   1.972348013474317e-12,  -1.779390482622157e-14,
  -1.515379625289946e-15,  -3.515491364379485e-17,   8.974606897458810e-01,  -9.445295504051808e-03,   4.206003508822114e-05,   2.244871299311946e-07,  -4.776373579758204e-09,
   1.095842378609988e-10,   1.970554754980542e-12,  -1.784717843269467e-14,  -1.515151955973145e-15,  -3.509493797366151e-17,   8.974609842475342e-01,  -9.445290772567441e-03,
   4.205983458013450e-05,   2.244948053914815e-07,  -4.776166961450445e-09,   1.095815946564956e-10,   1.970257505588943e-12,  -1.785600635515226e-14,  -1.515114116784409e-15,
  -3.508499600496409e-17,   1.157782592116318e+00,  -1.126987211281641e-02,   1.823392541689482e-05,   8.139582200821098e-07,  -6.956020230859760e-09,   6.204437122939618e-11,
   4.829882703464015e-12,  -2.216361444952826e-14,  -2.888111187265062e-15,  -5.644257023028523e-17,   1.157785175110792e+00,  -1.126952430642576e-02,   1.822804363345801e-05,
   8.140459128132786e-07,  -6.945846676054371e-09,   6.197367221039382e-11,   4.818400059836744e-12,  -2.244406398617892e-14,  -2.886931839450253e-15,  -5.611832474077751e-17,
   1.157789414918601e+00,  -1.126895329901233e-02,   1.821839396894459e-05,   8.141898000591606e-07,  -6.929162840952007e-09,   6.185700822765585e-11,   4.799553090463681e-12,
  -2.290326559716015e-14,  -2.884951729550769e-15,  -5.558587968140936e-17,   1.157793912873188e+00,  -1.126834737941979e-02,   1.820816339685073e-05,   8.143423738726076e-07,
  -6.911484057153459e-09,   6.173240456129308e-11,   4.779560027108575e-12,  -2.338888053238855e-14,  -2.882790974378241e-15,  -5.502072573110018e-17,   1.157797452201485e+00,
  -1.126787049103050e-02,   1.820011800904085e-05,   8.144623763863855e-07,  -6.897588175106690e-09,   6.163375246311690e-11,   4.763829075734739e-12,  -2.376987916230712e-14,
  -2.881047315291783e-15,  -5.457581522738368e-17,   1.157799494582406e+00,  -1.126759525880221e-02,   1.819547731254615e-05,   8.145316024825902e-07,  -6.889575569274845e-09,
   6.157658293362304e-11,   4.754751934890806e-12,  -2.398928670167911e-14,  -2.880023756853026e-15,  -5.431899771363426e-17,   1.157800261472411e+00,  -1.126749190435792e-02,
   1.819373514853856e-05,   8.145575919459708e-07,  -6.886568075190456e-09,   6.155507074353094e-11,   4.751343663653839e-12,  -2.407158677433843e-14,  -2.879636142142380e-15,
  -5.422255075323413e-17,   1.157800388593068e+00,  -1.126747477177359e-02,   1.819344638437368e-05,   8.145618997745846e-07,  -6.886069609582347e-09,   6.155150244553645e-11,
   4.750778709019608e-12,  -2.408522446030584e-14,  -2.879571717655070e-15,  -5.420656279647132e-17,   1.469608624255666e+00,  -1.204831898661862e-02,  -5.602708011362390e-05,
   1.596547107444755e-06,   1.015688531841826e-08,  -2.576782814134730e-10,   5.367050983479206e-12,   1.425996282025276e-13,  -5.998259162819856e-15,  -1.838954545912767e-16,
   1.469600668758607e+00,  -1.204763866806539e-02,  -5.601834454535246e-05,   1.596183873378991e-06,   1.016805985346850e-08,  -2.572667732312796e-10,   5.343291647501875e-12,
   1.416803485705943e-13,  -5.991515945360886e-15,  -1.830451167692080e-16,   1.469587609430831e+00,  -1.204652192630308e-02,  -5.600399688911212e-05,   1.595587983049026e-06,
   1.018636808057012e-08,  -2.565931867158488e-10,   5.304306687773037e-12,   1.401743502149924e-13,  -5.980373329373684e-15,  -1.816492385131008e-16,   1.469573753709323e+00,
  -1.204533712810215e-02,  -5.598876367772600e-05,   1.594956263223769e-06,   1.020574482534117e-08,  -2.558811340679649e-10,   5.262967704578456e-12,   1.385806476383977e-13,
  -5.968451769279933e-15,  -1.801682382896353e-16,   1.469562850077844e+00,  -1.204440479505201e-02,  -5.597676838055261e-05,   1.594459505240496e-06,   1.022095845512041e-08,
  -2.553226785235659e-10,   5.230453398043644e-12,   1.373294925825892e-13,  -5.958998360519052e-15,  -1.790027914327718e-16,   1.469556557737418e+00,  -1.204386677123657e-02,
  -5.596984298560096e-05,   1.594172980092453e-06,   1.022972412415529e-08,  -2.550011570397282e-10,   5.211696678279231e-12,   1.366086679957356e-13,  -5.953514172553249e-15,
  -1.783302361212080e-16,   1.469554194968792e+00,  -1.204366474622395e-02,  -5.596724192582278e-05,   1.594065417938006e-06,   1.023301299613530e-08,  -2.548805687294689e-10,
   5.204654844396140e-12,   1.363382258363007e-13,  -5.951449435867064e-15,  -1.780776941903036e-16,   1.469553803309648e+00,  -1.204363125812313e-02,  -5.596681073629610e-05,
   1.594047589599930e-06,   1.023355803005676e-08,  -2.548605872010884e-10,   5.203487638899482e-12,   1.362934085554624e-13,  -5.951106893086312e-15,  -1.780358322500321e-16,
   1.824888707708049e+00,  -8.018817171935767e-03,  -1.964778174540417e-04,  -1.784446949116379e-06,   6.005507265686485e-08,   2.563662245886878e-09,   2.300765936100648e-11,
  -1.244029633610098e-12,  -4.884969030591949e-14,  -3.465091495730774e-16,   1.824860851124841e+00,  -8.019566220661313e-03,  -1.964262754726070e-04,  -1.780830289422945e-06,
   6.010192202538342e-08,   2.559919745571073e-09,   2.281670349365306e-11,  -1.245605035689824e-12,  -4.867198864948832e-14,  -3.390318507868896e-16,   1.824815125376930e+00,
  -8.020794796832244e-03,  -1.963416327699490e-04,  -1.774896816564997e-06,   6.017854019733210e-08,   2.553772551861937e-09,   2.250373127073931e-11,  -1.248163913812098e-12,
  -4.838009322573218e-14,  -3.267947928901077e-16,   1.824766614085527e+00,  -8.022096905164103e-03,  -1.962517820942667e-04,  -1.768606190228785e-06,   6.025944069971567e-08,
   2.547245487170848e-09,   2.217234066131970e-11,  -1.250841920800957e-12,  -4.807014360042025e-14,  -3.138621774845474e-16,   1.824728440702678e+00,  -8.023120581436546e-03,
  -1.961810415405038e-04,  -1.763659234575727e-06,   6.032282250556513e-08,   2.542105480186402e-09,   2.191203943300903e-11,  -1.252922682110393e-12,  -4.782605126387988e-14,
  -3.037216931151931e-16,   1.824706412205179e+00,  -8.023710928343409e-03,  -1.961402047456061e-04,  -1.760805773550426e-06,   6.035928632754514e-08,   2.539137818157842e-09,
   2.176201696623214e-11,  -1.254112789703235e-12,  -4.768511760732487e-14,  -2.978844777571753e-16,   1.824698140683835e+00,  -8.023932526958970e-03,  -1.961248680397591e-04,
  -1.759734558632385e-06,   6.037295712158847e-08,   2.538023193732704e-09,   2.170572031316159e-11,  -1.254557659270953e-12,  -4.763218380164789e-14,  -2.956953916140022e-16,
   1.824696769581800e+00,  -8.023969255748694e-03,  -1.961223256514098e-04,  -1.759557004624967e-06,   6.037522210515843e-08,   2.537838416257634e-09,   2.169639035645871e-11,
  -1.254631295859334e-12,  -4.762340864544883e-14,  -2.953326694156111e-16,   2.667260122271252e-03,  -3.111273369888752e-05,   2.682566202382694e-07,  -2.046011242820752e-09,
   2.116440271220497e-11,   9.625218815967768e-14,   1.708092331154552e-15,  -1.495999199725176e-16,  -4.485475480411275e-18,  -3.493401217239842e-22,   2.667298333538799e-03,
  -3.111360671634296e-05,   2.682747107233131e-07,  -2.045878041126757e-09,   2.116784224760015e-11,   9.580536707138622e-14,   1.690650005447548e-15,  -1.495861372442604e-16,
  -4.464710295672371e-18,   2.342863829140500e-22,   2.667361065384343e-03,  -3.111503987561206e-05,   2.683044112405305e-07,  -2.045659828448525e-09,   2.117346211971111e-11,
   9.507187775124133e-14,   1.662075296341238e-15,  -1.495613784285019e-16,  -4.430640244947277e-18,   1.188580585602117e-21,   2.667427631256946e-03,  -3.111656051384684e-05,
   2.683359285733026e-07,  -2.045428912349322e-09,   2.117938902585185e-11,   9.429364550213410e-14,   1.631836415719472e-15,  -1.495322172720366e-16,  -4.394515871165434e-18,
   2.195968653495952e-21,   2.667480020784806e-03,  -3.111775722471993e-05,   2.683607348917864e-07,  -2.045247632239615e-09,   2.118402735287001e-11,   9.368121558389043e-14,
   1.608096947366381e-15,  -1.495071808325675e-16,  -4.366105257916992e-18,   2.985032615796548e-21,   2.667510256541911e-03,  -3.111844785418925e-05,   2.683750519074531e-07,
  -2.045143193149703e-09,   2.118669374118001e-11,   9.332778816490309e-14,   1.594419953431010e-15,  -1.494918974605426e-16,  -4.349716806964335e-18,   3.438912462706851e-21,
   2.667521610508505e-03,  -3.111870718944301e-05,   2.683804282409305e-07,  -2.045104009481891e-09,   2.118769301705402e-11,   9.319507610758696e-14,   1.589288550266720e-15,
  -1.494860009391082e-16,  -4.343564276337372e-18,   3.609064642753451e-21,   2.667523492598327e-03,  -3.111875017781627e-05,   2.683813194531576e-07,  -2.045097516034850e-09,
   2.118785855694653e-11,   9.317307736850663e-14,   1.588438181162458e-15,  -1.494850152051997e-16,  -4.342544485424405e-18,   3.637254811660944e-21,   2.406708196605174e-02,
  -2.803199386800172e-04,   2.401713197797263e-06,  -1.807204528447070e-08,   1.856919907782453e-10,   9.559795378303933e-13,   1.474922024818335e-14,  -1.354722746033707e-15,
  -4.095897005557381e-17,  -3.395284292254831e-21,   2.406742406666534e-02,  -2.803276493556724e-04,   2.401871916559778e-06,  -1.807071901539436e-08,   1.857215881568884e-10,
   9.519332885895227e-13,   1.458993749893283e-14,  -1.354598019036344e-15,  -4.076977581460669e-17,   1.931128036559216e-21,   2.406798569655733e-02,  -2.803403072768104e-04,
   2.402132496772574e-06,  -1.806854589075534e-08,   1.857699333809403e-10,   9.452910766501939e-13,   1.432899295071954e-14,  -1.354373799521526e-15,  -4.045935802280070e-17,
   1.064044477891288e-20,   2.406858165153012e-02,  -2.803537377654103e-04,   2.402409016462033e-06,  -1.806624569204361e-08,   1.858209007010050e-10,   9.382436899544549e-13,
   1.405284948836333e-14,  -1.354109508206521e-15,  -4.013022130341126e-17,   1.983437490323148e-20,   2.406905068733637e-02,  -2.803643072371841e-04,   2.402626656182988e-06,
  -1.806443951737657e-08,   1.858607731752323e-10,   9.326977493346483e-13,   1.383605787052930e-14,  -1.353882467286076e-15,  -3.987136507616250e-17,   2.703580912852018e-20,
   2.406932138353030e-02,  -2.803704069285427e-04,   2.402752267224328e-06,  -1.806339877959112e-08,   1.858836886456333e-10,   9.294972406750916e-13,   1.371115746363392e-14,
  -1.353743822695348e-15,  -3.972204531071614e-17,   3.117818357414784e-20,   2.406942303386364e-02,  -2.803726973935587e-04,   2.402799436721569e-06,  -1.806300828234921e-08,
   1.858922755557952e-10,   9.282954491907286e-13,   1.366429661014256e-14,  -1.353690323160927e-15,  -3.966598779171089e-17,   3.273109544817883e-20,   2.406943988392580e-02,
  -2.803730770693518e-04,   2.402807255809544e-06,  -1.806294356820324e-08,   1.858936980057762e-10,   9.280962367205756e-13,   1.365653088879912e-14,  -1.353681379086218e-15,
  -3.965669617155595e-17,   3.298837616552559e-20,   6.720173525677715e-02,  -7.803264169517323e-04,   6.597344909410224e-06,  -4.821110532322905e-08,   4.882061424459341e-10,
   3.167562505097710e-12,   3.752984239821131e-14,  -3.814144122973352e-15,  -1.171466222416174e-16,  -1.155768351790492e-20,   6.720267494655448e-02,  -7.803469837689016e-04,
   6.597762181976645e-06,  -4.820669382519164e-08,   4.882808579832875e-10,   3.156170468146490e-12,   3.707423349989995e-14,  -3.813797132400267e-15,  -1.166076762774251e-16,
   3.665685703099059e-21,   6.720421764243710e-02,  -7.803807461901552e-04,   6.598447246850003e-06,  -4.819946335143580e-08,   4.884028186365535e-10,   3.137469607191393e-12,
   3.632782706793417e-14,  -3.813171871135673e-15,  -1.157234010215367e-16,   2.855793435497391e-20,   6.720585462049503e-02,  -7.804165689126415e-04,   6.599174213773093e-06,
  -4.819180717988109e-08,   4.885312823519342e-10,   3.117627988263827e-12,   3.553793699960626e-14,  -3.812433029690868e-15,  -1.147857920808303e-16,   5.483557907871709e-20,
   6.720714297318374e-02,  -7.804447602703135e-04,   6.599746383925819e-06,  -4.818579325854476e-08,   4.886317000949806e-10,   3.102013623675029e-12,   3.491781269829929e-14,
  -3.811797130656851e-15,  -1.140483835173360e-16,   7.541859556078732e-20,   6.720788652369224e-02,  -7.804610295282265e-04,   6.600076611831749e-06,  -4.818232712691011e-08,
   4.886893793449798e-10,   3.093002723818772e-12,   3.456053725581037e-14,  -3.811408375914504e-15,  -1.136230106988018e-16,   8.725835029117189e-20,   6.720816573751125e-02,
  -7.804671386970202e-04,   6.600200618961121e-06,  -4.818102643321376e-08,   4.887109867674124e-10,   3.089619129373758e-12,   3.442649212475993e-14,  -3.811258287027974e-15,
  -1.134633170098863e-16,   9.169690767594458e-20,   6.720821202136766e-02,  -7.804681513739544e-04,   6.600221175089996e-06,  -4.818081087068037e-08,   4.887145657800397e-10,
   3.089058254856570e-12,   3.440427831022763e-14,  -3.811233191102720e-15,  -1.134368475068846e-16,   9.243227241260376e-20,   1.327699152313918e-01,  -1.534111970480551e-03,
   1.269106896740111e-05,  -8.817618721137366e-08,   8.705310194256036e-10,   7.781616427129458e-12,   6.367530586329333e-14,  -7.652703654353624e-15,  -2.400170219014892e-16,
  -3.292761818304351e-20,   1.327717227599127e-01,  -1.534149576435696e-03,   1.269181296712198e-05,  -8.816530637188531e-08,   8.706558841720480e-10,   7.758758943526746e-12,
   6.274171684503776e-14,  -7.652040040069781e-15,  -2.389181343247501e-16,  -1.735688268872561e-21,   1.327746901872383e-01,  -1.534211309386856e-03,   1.269303443667139e-05,
  -8.814746721693231e-08,   8.708594415900588e-10,   7.721236654991694e-12,   6.121223849109628e-14,  -7.650836641651024e-15,  -2.371151116802112e-16,   4.926801246563383e-20,
   1.327778389612719e-01,  -1.534276808324393e-03,   1.269433060982085e-05,  -8.812857043734014e-08,   8.710734932704334e-10,   7.681425418188114e-12,   5.959363565343007e-14,
  -7.649405261932522e-15,  -2.352033106904896e-16,   1.031113297512247e-19,   1.327803171385008e-01,  -1.534328353081201e-03,   1.269535077660505e-05,  -8.811372169869650e-08,
   8.712405516559444e-10,   7.650095906130368e-12,   5.832289291305635e-14,  -7.648167233048552e-15,  -2.336996988187298e-16,   1.452869611325118e-19,   1.327817473733118e-01,
  -1.534358099266069e-03,   1.269593956342430e-05,  -8.810516147102004e-08,   8.713364032514490e-10,   7.632015924620542e-12,   5.759076712948560e-14,  -7.647408143672743e-15,
  -2.328323338227180e-16,   1.695474910136428e-19,   1.327822844464275e-01,  -1.534369269008271e-03,   1.269616066412445e-05,  -8.810194877244075e-08,   8.713722905135569e-10,
   7.625226884578300e-12,   5.731608182900082e-14,  -7.647114681089355e-15,  -2.325067054688523e-16,   1.786424749530123e-19,   1.327823734742858e-01,  -1.534371120539948e-03,
   1.269619731501451e-05,  -8.810141631409197e-08,   8.713782337528018e-10,   7.624101513230519e-12,   5.727056121589241e-14,  -7.647065591741083e-15,  -2.324527319193267e-16,
   1.801493030160463e-19,   2.218972617325075e-01,  -2.545474682852113e-03,   2.037328440442475e-05,  -1.302023834702928e-07,   1.231466558021274e-09,   1.653919404396524e-11,
   8.486559310858852e-14,  -1.314335047717242e-14,  -4.213928910021645e-16,  -9.169258286036319e-20,   2.219001631168827e-01,  -2.545530187204005e-03,   2.037433679159085e-05,
  -1.301791784287762e-07,   1.231628297908145e-09,   1.649993457536833e-11,   8.322634799118969e-14,  -1.314235548725859e-14,  -4.194714813183114e-16,  -3.680087160644537e-20,
   2.219049263174288e-01,  -2.545621299500569e-03,   2.037606454916903e-05,  -1.301411239682311e-07,   1.231891312183082e-09,   1.643548689759895e-11,   8.054078589607466e-14,
  -1.314052147575127e-14,  -4.163188289587096e-16,   5.295739292008504e-20,   2.219099805888760e-01,  -2.545717967074092e-03,   2.037789796004236e-05,  -1.301008001092492e-07,
   1.232166986840774e-09,   1.636710737067381e-11,   7.769870192308916e-14,  -1.313830357064449e-14,  -4.129758931462306e-16,   1.477152265862595e-19,   2.219139584338881e-01,
  -2.545794038006333e-03,   2.037934095500017e-05,  -1.300691047421847e-07,   1.232381483453517e-09,   1.631329572332156e-11,   7.546739857738245e-14,  -1.313636178684895e-14,
  -4.103466504319579e-16,   2.219409823529797e-19,   2.219162541688512e-01,  -2.545837937242283e-03,   2.038017377185433e-05,  -1.300508286479517e-07,   1.232504288442122e-09,
   1.628224139286547e-11,   7.418184636297721e-14,  -1.313516265250234e-14,  -4.088299372733434e-16,   2.646382490696777e-19,   2.219171162482525e-01,  -2.545854421315433e-03,
   2.038048650968980e-05,  -1.300439688021612e-07,   1.232550216866797e-09,   1.627058045925309e-11,   7.369952003453950e-14,  -1.313469755179514e-14,  -4.082605246287657e-16,
   2.806450716352066e-19,   2.219172591506798e-01,  -2.545857153758737e-03,   2.038053835082193e-05,  -1.300428318432849e-07,   1.232557820348090e-09,   1.626864750734566e-11,
   7.361958923813811e-14,  -1.313461967373994e-14,  -4.081661431164316e-16,   2.832970377891576e-19,   3.362482038473401e-01,  -3.817633296436277e-03,   2.907855245073989e-05,
  -1.608250364431650e-07,   1.406880911295963e-09,   3.203956467480020e-11,   9.516138587985841e-14,  -2.088328751969666e-14,  -6.801756988009751e-16,  -2.488913847368161e-19,
   3.362523443566088e-01,  -3.817701797072885e-03,   2.907975466544690e-05,  -1.607799684896314e-07,   1.407052704801819e-09,   3.197717837213939e-11,   9.251539583881687e-14,
  -2.088218125846973e-14,  -6.770775071824365e-16,  -1.596526596606385e-19,   3.362591417966866e-01,  -3.817814238174272e-03,   2.908172839161999e-05,  -1.607060463047281e-07,
   1.407330683435713e-09,   3.187476508495749e-11,   8.818048302609742e-14,  -2.088003904601508e-14,  -6.719938574322689e-16,  -1.372698310613178e-20,   3.362663545745430e-01,
  -3.817933528156579e-03,   2.908382279698122e-05,  -1.606276963416989e-07,   1.407620145917861e-09,   3.176610238981058e-11,   8.359290817251148e-14,  -2.087732395232475e-14,
  -6.666031977552845e-16,   1.403316642235227e-19,   3.362720311906797e-01,  -3.818027396456778e-03,   2.908547119759339e-05,  -1.605660976334926e-07,   1.407843982274508e-09,
   3.168058871813152e-11,   7.999122205279533e-14,  -2.087486802383745e-14,  -6.623632774350239e-16,   2.610124653263526e-19,   3.362753073257856e-01,  -3.818081564262586e-03,
   2.908642255858374e-05,  -1.605305731170336e-07,   1.407971572328498e-09,   3.163123898472210e-11,   7.791612867798062e-14,  -2.087332303495010e-14,  -6.599173725412859e-16,
   3.304337081768682e-19,   3.362765375563441e-01,  -3.818101903787112e-03,   2.908677981100291e-05,  -1.605172380902023e-07,   1.408019183313682e-09,   3.161270803593116e-11,
   7.713757379930074e-14,  -2.087271878968613e-14,  -6.589991080583130e-16,   3.564593739313159e-19,   3.362767414851563e-01,  -3.818105275300362e-03,   2.908683903106839e-05,
  -1.605150278709184e-07,   1.408027059676876e-09,   3.160963628555958e-11,   7.700855217390686e-14,  -2.087261735758352e-14,  -6.588469030075432e-16,   3.607712482777670e-19,
   4.782140451350956e-01,  -5.349771510882474e-03,   3.775243364723533e-05,  -1.564582957955757e-07,   1.140337060875289e-09,   5.775605824231477e-11,   1.059856326833858e-13,
  -3.222851376353751e-14,  -1.047195767601390e-15,  -6.363152538573301e-19,   4.782194195437619e-01,  -5.349838019037948e-03,   3.775340830178838e-05,  -1.563769177069074e-07,
   1.140515056043882e-09,   5.765975969022661e-11,   1.019123637101533e-13,  -3.222804893175919e-14,  -1.042402589526349e-15,  -4.967420537798172e-19,   4.782282426060506e-01,
  -5.349947178021796e-03,   3.775500844960652e-05,  -1.562434214397960e-07,   1.140801032322337e-09,   5.750167343829906e-11,   9.523921658335177e-14,  -3.222677573711517e-14,
  -1.034537462592491e-15,  -2.685007178826562e-19,   4.782376046939082e-01,  -5.350062970293055e-03,   3.775670645664168e-05,  -1.561019061771991e-07,   1.141096017633050e-09,
   5.733393693562080e-11,   8.817721815640010e-14,  -3.222473331951759e-14,  -1.026196984554090e-15,  -2.752877413258615e-20,   4.782449728053446e-01,  -5.350154074925870e-03,
   3.775804288707275e-05,  -1.559906303693944e-07,   1.141322058216401e-09,   5.720193168246919e-11,   8.263294199591844e-14,  -3.222262670878830e-14,  -1.019636679295401e-15,
   1.612420960699988e-19,   4.782492251262584e-01,  -5.350206643377240e-03,   3.775881420273383e-05,  -1.559264499856766e-07,   1.141450062710349e-09,   5.712575073004167e-11,
   7.943866323393873e-14,  -3.222121129823839e-14,  -1.015852097384310e-15,   2.698347794936284e-19,   4.782508219225548e-01,  -5.350226381499085e-03,   3.775910384608513e-05,
  -1.559023569961970e-07,   1.141497667341471e-09,   5.709714439488263e-11,   7.824020620285256e-14,  -3.222064211819259e-14,  -1.014431234559143e-15,   3.105461534713811e-19,
   4.782510866147932e-01,  -5.350229653277493e-03,   3.775915185896580e-05,  -1.558983636278027e-07,   1.141505534109291e-09,   5.709240250533306e-11,   7.804159893847562e-14,
  -3.222054578205618e-14,  -1.014195721310261e-15,   3.172911515782663e-19,   6.512304163693180e-01,  -7.128026575474588e-03,   4.432460546595666e-05,  -7.432745332831647e-08,
   6.066796855493976e-11,   9.696720773976000e-11,   1.968940322567745e-13,  -5.038722922996907e-14,  -1.579547942665787e-15,  -1.459282500519102e-18,   6.512367241943853e-01,
  -7.128057824736823e-03,   4.432465919992799e-05,  -7.419073334436522e-08,   6.101551688230067e-11,   9.681661229403048e-11,   1.907518691589082e-13,  -5.038892462769273e-14,
  -1.572232187048053e-15,  -1.242685177887843e-18,   6.512470795162284e-01,  -7.128109083569796e-03,   4.432474760440870e-05,  -7.396644025553343e-08,   6.157667794702364e-11,
   9.656938556386211e-11,   1.806895543211598e-13,  -5.039091618614784e-14,  -1.560227242210073e-15,  -8.884727097035251e-19,   6.512580673214310e-01,  -7.128163416249714e-03,
   4.432484166546979e-05,  -7.372865846153051e-08,   6.215936135161373e-11,   9.630705991600530e-11,   1.700412473085162e-13,  -5.039195615491121e-14,  -1.547496041907219e-15,
  -5.144829449241256e-19,   6.512667147879510e-01,  -7.128206135175141e-03,   4.432491587567655e-05,  -7.354167535229598e-08,   6.260871752153101e-11,   9.610060972124167e-11,
   1.616816647109310e-13,  -5.039199974668759e-14,  -1.537481654256760e-15,  -2.214948243669610e-19,   6.512717054124189e-01,  -7.128230772602456e-03,   4.432495877664422e-05,
  -7.343382483733849e-08,   6.286435902568315e-11,   9.598146410530722e-11,   1.568654779010702e-13,  -5.039171501512074e-14,  -1.531704240972049e-15,  -5.294405494421009e-20,
   6.512735794419949e-01,  -7.128240021083558e-03,   4.432497490004863e-05,  -7.339333744379237e-08,   6.295965791339134e-11,   9.593672392685548e-11,   1.550585188310874e-13,
  -5.039154960858526e-14,  -1.529535162339038e-15,   1.024670147407128e-20,   6.512738900892461e-01,  -7.128241553987220e-03,   4.432497757345219e-05,  -7.338662668795300e-08,
   6.297541830953247e-11,   9.592930761233648e-11,   1.547590721589880e-13,  -5.039151910671495e-14,  -1.529175627558396e-15,   2.071610769706132e-20,   8.603247376563057e-01,
  -9.099648940402725e-03,   4.438802658093707e-05,   1.664803172362037e-07,  -2.194331743204771e-09,   1.460278516891412e-10,   6.882035429840911e-13,  -8.291073335247972e-14,
  -2.425784359986809e-15,  -2.562378064080138e-18,   8.603310506462677e-01,  -9.099577139927392e-03,   4.438616059876469e-05,   1.666860332418148e-07,  -2.192974390491432e-09,
   1.457800323615812e-10,   6.787724068820212e-13,  -8.291466404449186e-14,  -2.414469840158766e-15,  -2.217813318426058e-18,   8.603414142505664e-01,  -9.099459204835455e-03,
   4.438309808928244e-05,   1.670234944598347e-07,  -2.190760502329262e-09,   1.453731942698495e-10,   6.633222167240100e-13,  -8.291985724059534e-14,  -2.395902024206304e-15,
  -1.654301288026166e-18,   8.603524105769913e-01,  -9.099333981019699e-03,   4.437984961549847e-05,   1.673812204676835e-07,  -2.188430974512401e-09,   1.449415056139679e-10,
   6.469725924342912e-13,  -8.292365998119178e-14,  -2.376209554250402e-15,  -1.059287968318991e-18,   8.603610645563925e-01,  -9.099235367298557e-03,   4.437729383167551e-05,
   1.676625018951025e-07,  -2.186611777741335e-09,   1.446017640887060e-10,   6.341373608651281e-13,  -8.292541980004522e-14,  -2.360718434116044e-15,  -5.931200717937666e-19,
   8.603660588620693e-01,  -9.099178430582206e-03,   4.437581915111704e-05,   1.678247343664348e-07,  -2.185567550169640e-09,   1.444056928785293e-10,   6.267427254061533e-13,
  -8.292594232131969e-14,  -2.351781039992281e-15,  -3.249312352590310e-19,   8.603679342593281e-01,  -9.099157045591104e-03,   4.437526545277572e-05,   1.678856352694721e-07,
  -2.185176502506142e-09,   1.443320662853295e-10,   6.239683904632350e-13,  -8.292604546536504e-14,  -2.348425500722226e-15,  -2.243834831157364e-19,   8.603682451325194e-01,
  -9.099153500475450e-03,   4.437517367245229e-05,   1.678957294633722e-07,  -2.185111737194323e-09,   1.443198616297993e-10,   6.235086326139884e-13,  -8.292605765649011e-14,
  -2.347869300734551e-15,  -2.077246844381664e-19,   1.113054209787265e+00,  -1.108668941702330e-02,   2.739391782876336e-05,   7.184654248207267e-07,  -4.667694222455461e-09,
   1.583370104055286e-10,   2.642609946483653e-12,  -1.415865061556527e-13,  -4.250670474178950e-15,  -5.818344244964845e-19,   1.113058100190696e+00,  -1.108638190557017e-02,
   2.738996309823077e-05,   7.186871797883658e-07,  -4.662249287131621e-09,   1.579141177176744e-10,   2.626062283916640e-12,  -1.415739311681253e-13,  -4.231888265322748e-15,
   1.006015477359969e-21,   1.113064486515848e+00,  -1.108587700814579e-02,   2.738347406610307e-05,   7.190507916054512e-07,  -4.653335867711764e-09,   1.572199081248523e-10,
   2.598950658679816e-12,  -1.415511566471229e-13,  -4.201063039886531e-15,   9.541854967291408e-19,   1.113071262354671e+00,  -1.108534118114473e-02,   2.737659317534662e-05,
   7.194360208730580e-07,  -4.643912411367412e-09,   1.564833511481627e-10,   2.570256560174695e-12,  -1.415241028021770e-13,  -4.168367384037086e-15,   1.960626585130386e-18,
   1.113076594580434e+00,  -1.108491941606248e-02,   2.737118111069319e-05,   7.197387704709584e-07,  -4.636520951052522e-09,   1.559037173145585e-10,   2.547727308219827e-12,
  -1.415007258794413e-13,  -4.142644878244067e-15,   2.749113663576756e-18,   1.113079671753902e+00,  -1.108467598058194e-02,   2.736805899591924e-05,   7.199133216835102e-07,
  -4.632265143807887e-09,   1.555692161255285e-10,   2.534746539282390e-12,  -1.414864005812684e-13,  -4.127803665312409e-15,   3.202727309939257e-18,   1.113080827233225e+00,
  -1.108458456311208e-02,   2.736688685501274e-05,   7.199788349850065e-07,  -4.630668924934621e-09,   1.554436108607329e-10,   2.529876157459936e-12,  -1.414808638789656e-13,
  -4.122231360400776e-15,   3.372792050384396e-18,   1.113081018768885e+00,  -1.108456940909282e-02,   2.736669256875796e-05,   7.199896930424815e-07,  -4.630404427903304e-09,
   1.554227901639491e-10,   2.529069034336638e-12,  -1.414799377927671e-13,  -4.121307709221200e-15,   3.400968383257966e-18,   1.420643699771422e+00,  -1.241747999842744e-02,
  -3.603824289701776e-05,   1.725721066209719e-06,   6.478592483377226e-09,  -1.082318426711012e-10,   5.792760751009465e-12,  -1.369214482158392e-13,  -1.055013174237140e-14,
  -2.705982694325987e-17,   1.420638582524763e+00,  -1.241674380716724e-02,  -3.603264412848397e-05,   1.725563574370121e-06,   6.490471203481052e-09,  -1.086426650612741e-10,
   5.751683729314105e-12,  -1.370280232214635e-13,  -1.050377942643324e-14,  -2.585879724333955e-17,   1.420630182322417e+00,  -1.241553527944285e-02,  -3.602344566665605e-05,
   1.725304602811701e-06,   6.509909180734571e-09,  -1.093173060083135e-10,   5.684382414245175e-12,  -1.371985930541623e-13,  -1.042772428323167e-14,  -2.389465624066418e-17,
   1.420621269855560e+00,  -1.241425300529430e-02,  -3.601367565437060e-05,   1.725029238678214e-06,   6.530449051713495e-09,  -1.100334317704894e-10,   5.613151569460893e-12,
  -1.373736293899960e-13,  -1.034707851252933e-14,  -2.182080329717339e-17,   1.420614256274698e+00,  -1.241324389749082e-02,  -3.600597957266794e-05,   1.724812109045117e-06,
   6.546552348727469e-09,  -1.105972248822551e-10,   5.557223555658291e-12,  -1.375070869420475e-13,  -1.028364994122850e-14,  -2.019609313890348e-17,   1.420610208831577e+00,
  -1.241266154118056e-02,  -3.600153520061027e-05,   1.724686632261701e-06,   6.555821177263462e-09,  -1.109226790999991e-10,   5.524998913674531e-12,  -1.375823894328440e-13,
  -1.024706031057312e-14,  -1.926141659531780e-17,   1.420608689020213e+00,  -1.241244286428980e-02,  -3.599986576370361e-05,   1.724639482908881e-06,   6.559297049629841e-09,
  -1.110449050153413e-10,   5.512908162771148e-12,  -1.376103419296521e-13,  -1.023332363032774e-14,  -1.891099864322611e-17,   1.420608437092034e+00,  -1.241240661566003e-02,
  -3.599958900264330e-05,   1.724631665563075e-06,   6.559872979216703e-09,  -1.110651664777544e-10,   5.510904471156148e-12,  -1.376149583573779e-13,  -1.023104674246498e-14,
  -1.885294151990554e-17,   1.789562532909200e+00,  -9.655938438717459e-03,  -2.103768410800183e-04,  -3.984546882441750e-07,   1.131015383108537e-07,   2.519433530290141e-09,
  -3.357241496626766e-11,  -2.709698178281144e-12,  -3.135236968559969e-14,   1.549881956035490e-15,   1.789532788099170e+00,  -9.656096131773567e-03,  -2.102806845397971e-04,
  -3.949365318632678e-07,   1.130284931082418e-07,   2.511462614044602e-09,  -3.368961583960504e-11,  -2.701757381992950e-12,  -3.097806903619014e-14,   1.549970737261726e-15,
   1.789483967001446e+00,  -9.656353940531014e-03,  -2.101228735248406e-04,  -3.891690544362582e-07,   1.129084008465435e-07,   2.498394215772251e-09,  -3.388095409994845e-11,
  -2.688721463213712e-12,  -3.036569264432020e-14,   1.550048420632918e-15,   1.789432177389395e+00,  -9.656626042804302e-03,  -2.099554857477870e-04,  -3.830603760777506e-07,
   1.127807343644007e-07,   2.484550943893790e-09,  -3.408253338341690e-11,  -2.674889731471855e-12,  -2.971876271349344e-14,   1.550038809079445e-15,   1.789391428353268e+00,
  -9.656839137965249e-03,  -2.098237955553331e-04,  -3.782608149450971e-07,   1.126800876055721e-07,   2.473673091804278e-09,  -3.424013342363757e-11,  -2.664004471737291e-12,
  -2.921168522558938e-14,   1.549964971487975e-15,   1.789367915159498e+00,  -9.656961698505292e-03,  -2.097478125703003e-04,  -3.754940989944063e-07,   1.126219334501927e-07,
   2.467402035044445e-09,  -3.433066988868301e-11,  -2.657722565131194e-12,  -2.891986562169277e-14,   1.549895912976949e-15,   1.789359086453154e+00,  -9.657007641704674e-03,
  -2.097192836078503e-04,  -3.744557750542728e-07,   1.126000829830680e-07,   2.465048469388048e-09,  -3.436458840232286e-11,  -2.655363686732264e-12,  -2.881044023059739e-14,
   1.549864996652452e-15,   1.789357623007305e+00,  -9.657015253254519e-03,  -2.097145547035865e-04,  -3.742836899297499e-07,   1.125964602700548e-07,   2.464658399638869e-09,
  -3.437020672533979e-11,  -2.654972671084483e-12,  -2.879230962069911e-14,   1.549859609240400e-15,   2.546954124797263e-03,  -2.905898001048892e-05,   2.458024355006420e-07,
  -1.691459132735369e-09,   2.308001167259488e-11,   7.180580962006618e-14,  -4.276994404127688e-15,  -2.622353080727666e-16,  -1.464194382832316e-18,   1.800901387426219e-19,
   2.546989143813536e-03,  -2.905970179483610e-05,   2.458220901293760e-07,  -1.691363427955331e-09,   2.307082091884505e-11,   7.103671689672667e-14,  -4.282207338884551e-15,
  -2.613214657120315e-16,  -1.434071513114129e-18,   1.797671353413342e-19,   2.547046635211267e-03,  -2.906088669267248e-05,   2.458543506934039e-07,  -1.691207098069659e-09,
   2.305572509432818e-11,   6.977609479472940e-14,  -4.290679565754926e-15,  -2.598224707466153e-16,  -1.384812514927440e-18,   1.792329965686797e-19,   2.547107640766160e-03,
  -2.906214392295937e-05,   2.458885739096976e-07,  -1.691042285753102e-09,   2.303969684444171e-11,   6.844115061735159e-14,  -4.299553151562904e-15,  -2.582335940645028e-16,
  -1.332806162322163e-18,   1.786609999275036e-19,   2.547155654440999e-03,  -2.906313334246814e-05,   2.459155021581317e-07,  -1.690913348375405e-09,   2.302707504425879e-11,
   6.739247692010692e-14,  -4.306452886915958e-15,  -2.569843569831634e-16,  -1.292065678275182e-18,   1.782070727473052e-19,   2.547183364866263e-03,  -2.906370434489158e-05,
   2.459310407304265e-07,  -1.690839244775007e-09,   2.301978777537173e-11,   6.678804183764763e-14,  -4.310401336665573e-15,  -2.562638877359837e-16,  -1.268629104062427e-18,
   1.779436029796489e-19,   2.547193770556685e-03,  -2.906391875991913e-05,   2.459368751941608e-07,  -1.690811476446201e-09,   2.301705077216284e-11,   6.656121689387088e-14,
  -4.311877692006195e-15,  -2.559934372006415e-16,  -1.259842703924183e-18,   1.778443850844312e-19,   2.547195495456740e-03,  -2.906395430217044e-05,   2.459378423176326e-07,
  -1.690806876523515e-09,   2.301659704514779e-11,   6.652362513697308e-14,  -4.312122085495510e-15,  -2.559486110562242e-16,  -1.258386984608766e-18,   1.778279234269471e-19,
   2.298292943533516e-02,  -2.619216795826961e-04,   2.203326860701058e-06,  -1.494425461151169e-08,   2.045474976438767e-10,   7.161780279380018e-13,  -3.959063594197560e-14,
  -2.383888323700047e-15,  -1.342490736044655e-17,   1.641874660930383e-18,   2.298324333517479e-02,  -2.619280562334536e-04,   2.203501030106197e-06,  -1.494329434278767e-08,
   2.044624270586191e-10,   7.091868669521917e-13,  -3.963845980423848e-14,  -2.375556591652196e-15,  -1.315005013494850e-17,   1.638939954437624e-18,   2.298375867041624e-02,
  -2.619385242554254e-04,   2.203786904706701e-06,  -1.494172504185457e-08,   2.043226991325735e-10,   6.977276883408229e-13,  -3.971618890402415e-14,  -2.361889838594837e-15,
  -1.270058447369209e-17,   1.634086668202181e-18,   2.298430550519955e-02,  -2.619496312534272e-04,   2.204090168153616e-06,  -1.494006958005565e-08,   2.041743414451669e-10,
   6.855929876432629e-13,  -3.979760611102244e-14,  -2.347403559442882e-15,  -1.222605029692164e-17,   1.628889034849614e-18,   2.298473588461277e-02,  -2.619583722433248e-04,
   2.204328786222773e-06,  -1.493877372921968e-08,   2.040575144918306e-10,   6.760605509436021e-13,  -3.986091703095246e-14,  -2.336013843693488e-15,  -1.185431189799728e-17,
   1.624764018828259e-18,   2.298498427202829e-02,  -2.619634167292366e-04,   2.204466476583791e-06,  -1.493802867422816e-08,   2.039900640134150e-10,   6.705662614308125e-13,
  -3.989714912365911e-14,  -2.329445068366116e-15,  -1.164046376518138e-17,   1.622369662168505e-18,   2.298507754530336e-02,  -2.619653109630504e-04,   2.204518176752799e-06,
  -1.493774942869782e-08,   2.039647305369376e-10,   6.685044362369870e-13,  -3.991069690552272e-14,  -2.326979271603214e-15,  -1.156029183199507e-17,   1.621467972029028e-18,
   2.298509300675400e-02,  -2.619656249583219e-04,   2.204526746588456e-06,  -1.493770316770787e-08,   2.039605308793387e-10,   6.681627296237395e-13,  -3.991293960087827e-14,
  -2.326570575055793e-15,  -1.154700905022659e-17,   1.621318367823367e-18,   6.418251702725548e-02,  -7.297240764578136e-04,   6.067811508523686e-06,  -3.988773219876186e-08,
   5.498216311125021e-10,   2.390171195370511e-12,  -1.162225203655976e-13,  -6.761335716908955e-15,  -3.869769222877982e-17,   4.682444233845945e-18,   6.418338146261160e-02,
  -7.297410940161861e-04,   6.068279554899566e-06,  -3.988449786059838e-08,   5.495719251717678e-10,   2.370344525105884e-12,  -1.163605182323086e-13,  -6.737573015819969e-15,
  -3.791239882550654e-17,   4.674132466995667e-18,   6.418480062110755e-02,  -7.297690301341901e-04,   6.069047774192124e-06,  -3.987920840639501e-08,   5.491617880972176e-10,
   2.337847014540482e-12,  -1.165848312105882e-13,  -6.698594240811625e-15,  -3.662823153879258e-17,   4.660385254846213e-18,   6.418630652313222e-02,  -7.297986712157445e-04,
   6.069862704082134e-06,  -3.987362335943420e-08,   5.487263250891112e-10,   2.303434160636938e-12,  -1.168198178725742e-13,  -6.657277823218648e-15,  -3.527243991769773e-17,
   4.645660533509274e-18,   6.418749172312313e-02,  -7.298219979650186e-04,   6.070503905980066e-06,  -3.986924776657214e-08,   5.483834151400668e-10,   2.276401365735879e-12,
  -1.170025683547255e-13,  -6.624792932295870e-15,  -3.421034532815822e-17,   4.633972984547548e-18,   6.418817574412554e-02,  -7.298354599131786e-04,   6.070873895104462e-06,
  -3.986673048319257e-08,   5.481854361072089e-10,   2.260820364837084e-12,  -1.171071633082271e-13,  -6.606057884037793e-15,  -3.359935905564438e-17,   4.627188371875201e-18,
   6.418843260438806e-02,  -7.298405149378046e-04,   6.071012818162649e-06,  -3.986578672128997e-08,   5.481110781379463e-10,   2.254973352136804e-12,  -1.171462748148119e-13,
  -6.599025078148467e-15,  -3.337029947917642e-17,   4.624633243950065e-18,   6.418847518284176e-02,  -7.298413528767618e-04,   6.071035846039373e-06,  -3.986563035851620e-08,
   5.480987514569386e-10,   2.254004326953013e-12,  -1.171527494115213e-13,  -6.597859416194583e-15,  -3.333234918307588e-17,   4.624209303182850e-18,   1.268301731058805e-01,
  -1.436567147313809e-03,   1.172169492259212e-05,  -7.300754623655243e-08,   1.019799819886997e-09,   5.925494041850603e-12,  -2.469020448101116e-13,  -1.370248217305420e-14,
  -8.014787491019577e-17,   9.560227632119952e-18,   1.268318429341321e-01,  -1.436598287316142e-03,   1.172256266590787e-05,  -7.299945231338209e-08,   1.019269428038491e-09,
   5.885319251399250e-12,  -2.471882276894304e-13,  -1.365396077460954e-14,  -7.853945254922020e-17,   9.543434385617018e-18,   1.268345843163079e-01,  -1.436649406252660e-03,
   1.172398687867190e-05,  -7.298620582889802e-08,   1.018398279953421e-09,   5.819470333925016e-12,  -2.476534698977719e-13,  -1.357436881780709e-14,  -7.590924343583012e-17,
   9.515654190897518e-18,   1.268374932554266e-01,  -1.436703644117298e-03,   1.172549763213619e-05,  -7.297220594920067e-08,   1.017473352046649e-09,   5.749741494696782e-12,
  -2.481409284916256e-13,  -1.349000269228445e-14,  -7.313233043671966e-17,   9.485891847809932e-18,   1.268397826932168e-01,  -1.436746327233922e-03,   1.172668627977369e-05,
  -7.296122822654426e-08,   1.016745017451095e-09,   5.694967248191348e-12,  -2.485200851452235e-13,  -1.342366949476303e-14,  -7.095696057973092e-17,   9.462263532547077e-18,
   1.268411040075712e-01,  -1.436770959547789e-03,   1.172737214194800e-05,  -7.295490888964815e-08,   1.016324517362329e-09,   5.663397113312419e-12,  -2.487371139010596e-13,
  -1.338541282583008e-14,  -6.970554442587701e-17,   9.448545393359258e-18,   1.268416001808721e-01,  -1.436780209047734e-03,   1.172762966551080e-05,  -7.295253896113232e-08,
   1.016166584526403e-09,   5.651549989863183e-12,  -2.488182725309951e-13,  -1.337105190191644e-14,  -6.923638661359669e-17,   9.443378695628432e-18,   1.268416824290482e-01,
  -1.436781742275315e-03,   1.172767235243468e-05,  -7.295214627216876e-08,   1.016140403272502e-09,   5.649586569741721e-12,  -2.488317079258531e-13,  -1.336867162863506e-14,
  -6.915865713948489e-17,   9.442521430481044e-18,   2.120319462170267e-01,  -2.388378034402249e-03,   1.893994484815116e-05,  -1.078936231370667e-07,   1.545272573950215e-09,
   1.273097116311029e-11,  -4.524632905189795e-13,  -2.379163487504092e-14,  -1.424939104774344e-16,   1.673498963112081e-17,   2.120346441524593e-01,  -2.388424034753897e-03,
   1.894125876105939e-05,  -1.078760936460606e-07,   1.544300773130162e-09,   1.266122680770891e-11,  -4.529727067698513e-13,  -2.370668818283097e-14,  -1.396641544196715e-16,
   1.670600798951960e-17,   2.120390733845036e-01,  -2.388499546506121e-03,   1.894341516021478e-05,  -1.078473873221647e-07,   1.542704649659247e-09,   1.254691312185664e-11,
  -4.538009499618679e-13,  -2.356734459120987e-14,  -1.350367232291799e-16,   1.665805251701866e-17,   2.120437733246696e-01,  -2.388579663161564e-03,   1.894570244861885e-05,
  -1.078170243204724e-07,   1.541010019721864e-09,   1.242586599281111e-11,  -4.546688731884205e-13,  -2.341964072848369e-14,  -1.301511788867166e-16,   1.660665839567019e-17,
   2.120474723344924e-01,  -2.388642710223128e-03,   1.894750196433974e-05,  -1.077931983581380e-07,   1.539675604141232e-09,   1.233078110188700e-11,  -4.553440587882852e-13,
  -2.330350653620450e-14,  -1.263239478203038e-16,   1.656584451718909e-17,   2.120496071583833e-01,  -2.388679093846985e-03,   1.894854026257632e-05,  -1.077794759139774e-07,
   1.538905194763939e-09,   1.227597780457447e-11,  -4.557305724245146e-13,  -2.323652731832689e-14,  -1.241222691325259e-16,   1.654214398897216e-17,   2.120504088159975e-01,
  -2.388692755868989e-03,   1.894893010899634e-05,  -1.077743282859599e-07,   1.538615843387500e-09,   1.225541223604747e-11,  -4.558751177829758e-13,  -2.321138431335860e-14,
  -1.232968558861439e-16,   1.653321670204094e-17,   2.120505417027501e-01,  -2.388695020524097e-03,   1.894899472925217e-05,  -1.077734752717286e-07,   1.538567876358979e-09,
   1.225200391682212e-11,  -4.558990469114903e-13,  -2.320721694184017e-14,  -1.231601024315593e-16,   1.653173542799306e-17,   3.214313088507130e-01,  -3.592293463147605e-03,
   2.730461371962148e-05,  -1.333061722362009e-07,   2.010968728970685e-09,   2.499705117500900e-11,  -7.633915344805299e-13,  -3.812423751726321e-14,  -2.328511224172392e-16,
   2.699530592792935e-17,   3.214351979319244e-01,  -3.592350252327764e-03,   2.730632148065881e-05,  -1.332715410657974e-07,   2.009329426481454e-09,   2.488530617386789e-11,
  -7.642244773649631e-13,  -3.798718734823902e-14,  -2.282512033442740e-16,   2.694939767739896e-17,   3.214415826625021e-01,  -3.592443470494016e-03,   2.730912403215601e-05,
  -1.332148024214851e-07,   2.006637011106011e-09,   2.470215386708287e-11,  -7.655788085743727e-13,  -3.776237201030064e-14,  -2.207290512039883e-16,   2.687340612768776e-17,
   3.214483575920446e-01,  -3.592542367971306e-03,   2.731209637653963e-05,  -1.331547531403635e-07,   2.003778482736140e-09,   2.450821610172246e-11,  -7.669981289063147e-13,
  -3.752406423385534e-14,  -2.127872998082933e-16,   2.679192820614577e-17,   3.214536896687059e-01,  -3.592620190538183e-03,   2.731443462818495e-05,  -1.331076059938139e-07,
   2.001527607114982e-09,   2.435587622151575e-11,  -7.681023408559184e-13,  -3.733668854281425e-14,  -2.065658862767352e-16,   2.672719707127365e-17,   3.214567669831488e-01,
  -3.592665099352528e-03,   2.731578367838037e-05,  -1.330804412871205e-07,   2.000228105074834e-09,   2.426807415356707e-11,  -7.687344839544779e-13,  -3.722862034742299e-14,
  -2.029869081803376e-16,   2.668959730752792e-17,   3.214579225583127e-01,  -3.592681962282491e-03,   2.731629018442289e-05,  -1.330702491385323e-07,   1.999740039181132e-09,
   2.423512557098978e-11,  -7.689708938063634e-13,  -3.718805293032072e-14,  -2.016451418474020e-16,   2.667543261664233e-17,   3.214581141121221e-01,  -3.592684757513560e-03,
   2.731637414105455e-05,  -1.330685600906634e-07,   1.999659130535815e-09,   2.422966503050837e-11,  -7.690100311881211e-13,  -3.718132900096931e-14,  -2.014228395893054e-16,
   2.667308221449605e-17,   4.574076597836912e-01,  -5.054864974872984e-03,   3.602197491632204e-05,  -1.292065967278112e-07,   2.229019783935616e-09,   4.590828251842429e-11,
  -1.219007032498215e-12,  -5.886379718550687e-14,  -3.616066191746883e-16,   4.174363300411447e-17,   4.574127897725991e-01,  -5.054919910631301e-03,   3.602386331550732e-05,
  -1.291427194430632e-07,   2.226402537034939e-09,   4.573575415926963e-11,  -1.220299544907852e-12,  -5.865183062793411e-14,  -3.544143082814646e-16,   4.167423735594350e-17,
   4.574212116717404e-01,  -5.055010077200422e-03,   3.602696180856411e-05,  -1.290380305902321e-07,   2.222103986807196e-09,   4.545297752504374e-11,  -1.222400962642904e-12,
  -5.830411772716236e-14,  -3.426528607241404e-16,   4.155930926659862e-17,   4.574301482186766e-01,  -5.055105724604667e-03,   3.603024734708425e-05,  -1.289271866332916e-07,
   2.217540306089744e-09,   4.515354988516077e-11,  -1.224603007408730e-12,  -5.793552895655854e-14,  -3.302353249920447e-16,   4.143600588147864e-17,   4.574371815170088e-01,
  -5.055180980599686e-03,   3.603283148830875e-05,  -1.288401247027838e-07,   2.213946805973343e-09,   4.491834756718776e-11,  -1.226316013442294e-12,  -5.764571095252761e-14,
  -3.205076605654708e-16,   4.133799056023216e-17,   4.574412406467198e-01,  -5.055224404691542e-03,   3.603432220728511e-05,  -1.287899487791634e-07,   2.211872185857526e-09,
   4.478278753170878e-11,  -1.227296618428203e-12,  -5.747855737015689e-14,  -3.149116466247565e-16,   4.128103541852976e-17,   4.574427649045974e-01,  -5.055240709431531e-03,
   3.603488186620168e-05,  -1.287711202961027e-07,   2.211093005855567e-09,   4.473191736861653e-11,  -1.227663334671066e-12,  -5.741580964421714e-14,  -3.128136888268215e-16,
   4.125957501264753e-17,   4.574430175729132e-01,  -5.055243412099711e-03,   3.603497463130038e-05,  -1.287679998951114e-07,   2.210963838269798e-09,   4.472348670320088e-11,
  -1.227724043496286e-12,  -5.740540937267129e-14,  -3.124661016347768e-16,   4.125601378881706e-17,   6.234220711981542e-01,  -6.776834679713569e-03,   4.350177797413000e-05,
  -5.816474398767823e-08,   1.904608828817432e-09,   7.937760400977929e-11,  -1.852930434478681e-12,  -9.067575819934810e-14,  -5.448877854762188e-16,   6.373448947394656e-17,
   6.234282650453027e-01,  -6.776859120801299e-03,   4.350338166340174e-05,  -5.805402337740862e-08,   1.900630810212300e-09,   7.911179086859548e-11,  -1.854871862894897e-12,
  -9.035204772113581e-14,  -5.337494780622408e-16,   6.363152606475377e-17,   6.234384334094492e-01,  -6.776899211160578e-03,   4.350601191689862e-05,  -5.787252883065962e-08,
   1.894097374778347e-09,   7.867611292065196e-11,  -1.858027361915047e-12,  -8.982101793261581e-14,  -5.155353325259100e-16,   6.346088641114570e-17,   6.234492230492811e-01,
  -6.776941704453595e-03,   4.350879947217891e-05,  -5.768031735378055e-08,   1.887161015211303e-09,   7.821477221724546e-11,  -1.861332660124521e-12,  -8.925809209042187e-14,
  -4.963053066693630e-16,   6.327765202329904e-17,   6.234577147114092e-01,  -6.776975113862845e-03,   4.351099086881200e-05,  -5.752931223710360e-08,   1.881699275633864e-09,
   7.785238013595568e-11,  -1.863902952428586e-12,  -8.881545838997323e-14,  -4.812409825610368e-16,   6.313188330805729e-17,   6.234626154793262e-01,  -6.776994381855579e-03,
   4.351225459475534e-05,  -5.744227088663156e-08,   1.878546088129851e-09,   7.764351122871639e-11,  -1.865373923026744e-12,  -8.856016373956797e-14,  -4.725750069970360e-16,
   6.304713459596785e-17,   6.234644557784388e-01,  -6.777001614679109e-03,   4.351272895268500e-05,  -5.740960614088116e-08,   1.877361825728416e-09,   7.756513077388238e-11,
  -1.865923947698303e-12,  -8.846432800463733e-14,  -4.693261230598408e-16,   6.301519332493914e-17,   6.234647608349928e-01,  -6.777002813491321e-03,   4.351280757460852e-05,
  -5.740419255426098e-08,   1.877165506270928e-09,   7.755214082900075e-11,  -1.866014998829729e-12,  -8.844844344190690e-14,  -4.687878522577238e-16,   6.300989242481493e-17,
   8.246484546594200e-01,  -8.736927284518987e-03,   4.627189209203236e-05,   1.546902363927895e-07,   6.597465809302713e-10,   1.264129284952432e-10,  -2.614865680184566e-12,
  -1.447324891348097e-13,  -8.219071950917673e-16,   9.950793734349493e-17,   8.246550405578187e-01,  -8.736860621636989e-03,   4.627242357825796e-05,   1.548665549478781e-07,
   6.541307854234194e-10,   1.259884723337087e-10,  -2.617777890854456e-12,  -1.442269303020573e-13,  -8.043182209143610e-16,   9.935303616078761e-17,   8.246658524257822e-01,
  -8.736751130151141e-03,   4.627329262262559e-05,   1.551555771720723e-07,   6.449072466076217e-10,   1.252927480308288e-10,  -2.622508749934173e-12,  -1.433975672572296e-13,
  -7.755564096491316e-16,   9.909607758789488e-17,   8.246773247209521e-01,  -8.736634878479312e-03,   4.627421001991049e-05,   1.554616639213527e-07,   6.351145546463732e-10,
   1.245560103435709e-10,  -2.627460772896386e-12,  -1.425183610309025e-13,  -7.451916869136764e-16,   9.881982758175315e-17,   8.246863535263593e-01,  -8.736543335191365e-03,
   4.627492859358916e-05,   1.557021304323854e-07,   6.274034849023978e-10,   1.239772645947156e-10,  -2.631309103259098e-12,  -1.418270132225666e-13,  -7.214056348432356e-16,
   9.859983054724178e-17,   8.246915642460343e-01,  -8.736490482699222e-03,   4.627534192412591e-05,   1.558407380073787e-07,   6.229516151326893e-10,   1.236436881013785e-10,
  -2.633510479285424e-12,  -1.414282615931637e-13,  -7.077227259091968e-16,   9.847183479768597e-17,   8.246935209267710e-01,  -8.736470632082516e-03,   4.627549687441550e-05,
   1.558927543508646e-07,   6.212795811710114e-10,   1.235185078733311e-10,  -2.634333424281556e-12,  -1.412785716714334e-13,  -7.025930582383095e-16,   9.842357690678618e-17,
   8.246938452748047e-01,  -8.736467341348733e-03,   4.627552254595643e-05,   1.559013751072095e-07,   6.210024011492886e-10,   1.234977617345800e-10,  -2.634469644474055e-12,
  -1.412537608169510e-13,  -7.017431853811521e-16,   9.841556724166487e-17,   1.069198901827060e+00,  -1.083406607422626e-02,   3.567873846874157e-05,   6.709467839012964e-07,
  -1.263887277347334e-09,   1.597679108801069e-10,  -3.030847945215251e-12,  -2.491153679583919e-13,  -1.437289080482491e-15,   1.704731267605532e-16,   1.069203976928353e+00,
  -1.083377885197509e-02,   3.567762228176471e-05,   6.711679891758368e-07,  -1.270416857113583e-09,   1.590372698281397e-10,  -3.035963909396616e-12,  -2.482490870435259e-13,
  -1.407656602603140e-15,   1.702145803304606e-16,   1.069212308407965e+00,  -1.083330726332910e-02,   3.567578583187351e-05,   6.715303876779402e-07,  -1.281143789594594e-09,
   1.578396707284908e-10,  -3.044278373138200e-12,  -2.468279401701735e-13,  -1.359205685569688e-15,   1.697853345301606e-16,   1.069221148587763e+00,  -1.083280678061358e-02,
   3.567383171213580e-05,   6.719139080027706e-07,  -1.292536112518469e-09,   1.565714609604131e-10,  -3.052986508146959e-12,  -2.453213532532288e-13,  -1.308060910724734e-15,
   1.693233887234459e-16,   1.069228105736807e+00,  -1.083241283250425e-02,   3.567228982233790e-05,   6.722150082639029e-07,  -1.301509273703296e-09,   1.555752079848431e-10,
  -3.059757447179413e-12,  -2.441366534188598e-13,  -1.268001515919363e-15,   1.689551731236875e-16,   1.069232120795840e+00,  -1.083218545109037e-02,   3.567139836865425e-05,
   6.723884858616837e-07,  -1.306690785828492e-09,   1.550009860666413e-10,  -3.063632134265959e-12,  -2.434533400695239e-13,  -1.244959231404725e-15,   1.687408104959857e-16,
   1.069233628481405e+00,  -1.083210006214945e-02,   3.567106331664281e-05,   6.724535730295204e-07,  -1.308637045915614e-09,   1.547854989408488e-10,  -3.065080898544015e-12,
  -2.431968250246944e-13,  -1.236321122462192e-15,   1.686599652235111e-16,   1.069233878401391e+00,  -1.083208590744874e-02,   3.567100776102718e-05,   6.724643592376771e-07,
  -1.308959695385749e-09,   1.547497861927577e-10,  -3.065320724097306e-12,  -2.431543079961391e-13,  -1.234889996770222e-15,   1.686465455300661e-16,   1.370530644219685e+00,
  -1.262131382063318e-02,  -1.475980380873858e-05,   1.817636182731163e-06,   5.201067079509316e-09,  -5.193100082065844e-11,  -2.440103881448459e-12,  -4.217261098386600e-13,
  -4.871403764746408e-15,   3.669481346704443e-16,   1.370528552659094e+00,  -1.262053813142924e-02,  -1.475539372914998e-05,   1.817551917891520e-06,   5.195645687416528e-09,
  -5.316163514306046e-11,  -2.458172486398434e-12,  -4.198665328948559e-13,  -4.806322886116189e-15,   3.662006270574938e-16,   1.370525119472365e+00,  -1.261926474043958e-02,
  -1.474815728193185e-05,   1.817412330053074e-06,   5.186718426598658e-09,  -5.517791735678148e-11,  -2.487650071247319e-12,  -4.168165787612796e-13,  -4.699914076630516e-15,
   3.649635636861173e-16,   1.370521477205205e+00,  -1.261791361295144e-02,  -1.474048349844328e-05,   1.817262515249767e-06,   5.177209143744722e-09,  -5.731191136780247e-11,
  -2.518677377795393e-12,  -4.135842244407850e-13,  -4.587592198853648e-15,   3.636375726545260e-16,   1.370518611162800e+00,  -1.261685029675121e-02,  -1.473444756153820e-05,
   1.817143380177486e-06,   5.169698787699807e-09,  -5.898744184555066e-11,  -2.542915058139109e-12,  -4.110431712227232e-13,  -4.499617842534086e-15,   3.625844044417276e-16,
   1.370516957290401e+00,  -1.261623664755035e-02,  -1.473096545788514e-05,   1.817074132520059e-06,   5.165353831557515e-09,  -5.995284718792983e-11,  -2.556830729719644e-12,
  -4.095778178168094e-13,  -4.449015639289358e-15,   3.619727743465272e-16,   1.370516336278264e+00,  -1.261600621832895e-02,  -1.472965814944760e-05,   1.817048036321873e-06,
   5.163720261801875e-09,  -6.031506870832099e-11,  -2.562042545365632e-12,  -4.090277787520614e-13,  -4.430046018190554e-15,   3.617423809038720e-16,   1.370516233338375e+00,
  -1.261596802150106e-02,  -1.472944145787913e-05,   1.817043705598261e-06,   5.163449369075453e-09,  -6.037509640316213e-11,  -2.562905758428716e-12,  -4.089366132982121e-13,
  -4.426903219841573e-15,   3.617041519671364e-16,   1.747590426027481e+00,  -1.132390382711257e-02,  -2.028531630670904e-04,   1.743485133904674e-06,   1.489790838537693e-07,
   7.574521565066250e-10,  -1.119621487209244e-10,  -2.394575504174271e-12,   6.127229451521053e-14,   3.183558615823233e-15,   1.747561811626409e+00,  -1.132315590331023e-02,
  -2.027272944314891e-04,   1.744504961009885e-06,   1.487429801792027e-07,   7.505459316876770e-10,  -1.117186198984897e-10,  -2.378865164509599e-12,   6.124436406656081e-14,
   3.161131181518667e-15,   1.747514849187513e+00,  -1.132192776410130e-02,  -2.025208054800766e-04,   1.746172172109960e-06,   1.483557531535969e-07,   7.392417922261390e-10,
  -1.113189192857017e-10,  -2.353156279060971e-12,   6.119660178079266e-14,   3.124427587071284e-15,   1.747465035705160e+00,  -1.132062420521445e-02,  -2.023019013906095e-04,
   1.747931716873643e-06,   1.479453854220286e-07,   7.272927220838798e-10,  -1.108949331776729e-10,  -2.325988621366921e-12,   6.114334243525640e-14,   3.085637930979212e-15,
   1.747425844748508e+00,  -1.131959800282884e-02,  -2.021297650001582e-04,   1.749309627834319e-06,   1.476227930986214e-07,   7.179216052341203e-10,  -1.105613482507872e-10,
  -2.304688047405828e-12,   6.109957159230557e-14,   3.055222875964471e-15,   1.747403231895923e+00,  -1.131900564353567e-02,  -2.020304787226068e-04,   1.750102102184540e-06,
   1.474367667469926e-07,   7.125264990975971e-10,  -1.103688684541409e-10,  -2.292427284232628e-12,   6.107357090354832e-14,   3.037714852443729e-15,   1.747394741492532e+00,
  -1.131878318449507e-02,  -2.019932065076763e-04,   1.750399165921582e-06,   1.473669399703873e-07,   7.105030653609957e-10,  -1.102965977602181e-10,  -2.287829327495988e-12,
   6.106366806376497e-14,   3.031148935059416e-15,   1.747393334136625e+00,  -1.131874630755269e-02,  -2.019870286725939e-04,   1.750448381161468e-06,   1.473553666580645e-07,
   7.101677831344965e-10,  -1.102846182499557e-10,  -2.287067471018390e-12,   6.106201918823890e-14,   3.030060989598236e-15,   2.434531438590772e-03,  -2.716741236832610e-05,
   2.277430744126015e-07,  -1.318770083393921e-09,   2.289740718939199e-11,  -1.170601764095416e-13,  -1.107021760898372e-14,  -1.749411289313499e-16,   7.505476031355409e-18,
   2.720296521848142e-19,   2.434563887152281e-03,  -2.716797598458453e-05,   2.277624935078619e-07,  -1.318940883436990e-09,   2.287412797704788e-11,  -1.175616697150968e-13,
  -1.104060120469495e-14,  -1.736009002414657e-16,   7.491594983775612e-18,   2.700304895297611e-19,   2.434617158695507e-03,  -2.716890130559867e-05,   2.277943588413948e-07,
  -1.319221786367738e-09,   2.283595691972804e-11,  -1.183820918012809e-13,  -1.099202161549636e-14,  -1.714080178435706e-16,   7.468709887245107e-18,   2.667594990973070e-19,
   2.434673686607858e-03,  -2.716988321579457e-05,   2.278281510659546e-07,  -1.319520533573915e-09,   2.279551633200957e-11,  -1.192487442158516e-13,  -1.094053015254152e-14,
  -1.690911263401785e-16,   7.444296097790811e-18,   2.633035940107234e-19,   2.434718176317362e-03,  -2.717065603725952e-05,   2.278547317212266e-07,  -1.319756145703504e-09,
   2.276373413388886e-11,  -1.199280025945078e-13,  -1.090004621004264e-14,  -1.672748900173600e-16,   7.424988337870757e-18,   2.605945240525850e-19,   2.434743852978323e-03,
  -2.717110206889807e-05,   2.278700663280104e-07,  -1.319892320684864e-09,   2.274540993767477e-11,  -1.203188950761857e-13,  -1.087669825139614e-14,  -1.662295726826580e-16,
   7.413808049424461e-18,   2.590353676255483e-19,   2.434753494967176e-03,  -2.717126956223439e-05,   2.278758235656286e-07,  -1.319943493235732e-09,   2.273853240800942e-11,
  -1.204654675089396e-13,  -1.086793391143564e-14,  -1.658375870619526e-16,   7.409602702376503e-18,   2.584507010070316e-19,   2.434755093272614e-03,  -2.717129732686452e-05,
   2.278767778542784e-07,  -1.319951977795150e-09,   2.273739253774193e-11,  -1.204897528322598e-13,  -1.086648125768418e-14,  -1.657726383809596e-16,   7.408905235424006e-18,
   2.583538269704432e-19,   2.196943960400879e-02,  -2.449561122641963e-04,   2.043875451644972e-06,  -1.163129001057401e-08,   2.039841357082385e-10,  -1.017987730847118e-12,
  -1.013624213556295e-13,  -1.590094759699941e-15,   6.838576532595806e-17,   2.481939054403305e-18,   2.196973081030609e-02,  -2.449610831790800e-04,   2.044048416121579e-06,
  -1.163277698481527e-08,   2.037709681074366e-10,  -1.022545229493362e-12,  -1.010925720621027e-13,  -1.577866990135294e-15,   6.825933770222130e-17,   2.463692243378708e-18,
   2.197020889018497e-02,  -2.449692442083284e-04,   2.044332234772256e-06,  -1.163522270106994e-08,   2.034214339038371e-10,  -1.030001004536721e-12,  -1.006499399612165e-13,
  -1.557859937809222e-15,   6.805089689469161e-17,   2.433837174633481e-18,   2.197071619381859e-02,  -2.449779043279155e-04,   2.044633211035347e-06,  -1.163782404232585e-08,
   2.030511146835274e-10,  -1.037876769254202e-12,  -1.001807762218730e-13,  -1.536721507663489e-15,   6.782852590564970e-17,   2.402294352613403e-18,   2.197111546176658e-02,
  -2.449847203492050e-04,   2.044869952704005e-06,  -1.163987582336122e-08,   2.027600793134963e-10,  -1.044049476603856e-12,  -9.981190724675392e-14,  -1.520150889358511e-15,
   6.765265803166220e-17,   2.377568066355502e-18,   2.197134589404877e-02,  -2.449886541936302e-04,   2.045006529584729e-06,  -1.164106175111953e-08,   2.025922804959209e-10,
  -1.047601640911985e-12,  -9.959917255120393e-14,  -1.510613839859612e-15,   6.755081867755691e-17,   2.363337299270070e-18,   2.197143242497402e-02,  -2.449901314263682e-04,
   2.045057805857209e-06,  -1.164150741946584e-08,   2.025293012431541e-10,  -1.048933583556400e-12,  -9.951931634657939e-14,  -1.507037524715581e-15,   6.751251253124025e-17,
   2.358000917491774e-18,   2.197144676878267e-02,  -2.449903763006883e-04,   2.045066305121488e-06,  -1.164158131333497e-08,   2.025188631589246e-10,  -1.049154270337636e-12,
  -9.950608050462541e-14,  -1.506444959839458e-15,   6.750615934595023e-17,   2.357116726712568e-18,   6.135788852641465e-02,  -6.829443175036335e-04,   5.642851249573186e-06,
  -3.092428659300347e-08,   5.544508151280677e-10,  -2.623917649464924e-12,  -2.915144683764099e-13,  -4.508458892747540e-15,   1.948269578705233e-16,   7.089346811846980e-18,
   6.135869249058725e-02,  -6.829575333598747e-04,   5.643321194687204e-06,  -3.092812918432546e-08,   5.538376667819019e-10,  -2.636835638028126e-12,  -2.907456777786253e-13,
  -4.473532980988626e-15,   1.944670916211116e-16,   7.037183095068021e-18,   6.136001237571478e-02,  -6.829792305383097e-04,   5.644092310165569e-06,  -3.093445047748378e-08,
   5.528322666116932e-10,  -2.657968068621976e-12,  -2.894846346166988e-13,  -4.416387440693794e-15,   1.938737526220631e-16,   6.951833886506709e-18,   6.136141294082850e-02,
  -6.830022545704039e-04,   5.644910013374383e-06,  -3.094117556295536e-08,   5.517670649611312e-10,  -2.680290131639478e-12,  -2.881480027454019e-13,  -4.356010607605262e-15,
   1.932407219736636e-16,   6.861659793684706e-18,   6.136251523996684e-02,  -6.830203758001633e-04,   5.645553181219582e-06,  -3.094648102678657e-08,   5.509299074816898e-10,
  -2.697784704648346e-12,  -2.870971066162538e-13,  -4.308680793580189e-15,   1.927400456705052e-16,   6.790972730317958e-18,   6.136315141720292e-02,  -6.830308343959855e-04,
   5.645924218198535e-06,  -3.094954802834926e-08,   5.504472330108625e-10,  -2.707851957556877e-12,  -2.864910318766264e-13,  -4.281440670551574e-15,   1.924501094115298e-16,
   6.750290082093260e-18,   6.136339031164310e-02,  -6.830347617934651e-04,   5.646063518357505e-06,  -3.095070068338057e-08,   5.502660719003270e-10,  -2.711626797538392e-12,
  -2.862635239050676e-13,  -4.271225860935373e-15,   1.923410499058551e-16,   6.735034537258891e-18,   6.136342991200393e-02,  -6.830354128206023e-04,   5.646086607880361e-06,
  -3.095089180335141e-08,   5.502360464923875e-10,  -2.712252240598769e-12,  -2.862258153791325e-13,  -4.269533354882696e-15,   1.923229619632182e-16,   6.732506829931975e-18,
   1.212663031087584e-01,  -1.346014302242640e-03,   1.094601429122712e-05,  -5.619556962755757e-08,   1.048065667671068e-09,  -4.511954165058725e-12,  -6.023917242320926e-13,
  -9.131552534415568e-15,   3.973531783591464e-16,   1.451143815065999e-17,   1.212678625920468e-01,  -1.346038316873473e-03,   1.094690200507332e-05,  -5.620221024675483e-08,
   1.046798399740929e-09,  -4.538106735022134e-12,  -6.008237387021428e-13,  -9.060065728535589e-15,   3.966204065257759e-16,   1.440450142836106e-17,   1.212704228264944e-01,
  -1.346077742877794e-03,   1.094835855488165e-05,  -5.621313832796277e-08,   1.044720385242176e-09,  -4.580887848109822e-12,  -5.982517773457715e-13,  -8.943100112595425e-15,
   3.954121386325345e-16,   1.422953388144222e-17,   1.212731395557336e-01,  -1.346119579775847e-03,   1.094990301278132e-05,  -5.622476970242094e-08,   1.042518726040531e-09,
  -4.626075030127053e-12,  -5.955256450878749e-13,  -8.819521511518284e-15,   3.941229209569544e-16,   1.404467542265160e-17,   1.212752777246666e-01,  -1.346152507708850e-03,
   1.095111774676256e-05,  -5.623394953456318e-08,   1.040788378274733e-09,  -4.661488150256441e-12,  -5.933822834439696e-13,  -8.722648000824219e-15,   3.931031661740744e-16,
   1.389976586363554e-17,   1.212765117393316e-01,  -1.346171511895517e-03,   1.095181848805796e-05,  -5.623925774698765e-08,   1.039790710119367e-09,  -4.681865974299658e-12,
  -5.921461589302733e-13,  -8.666893822587741e-15,   3.925126025312460e-16,   1.381636587700721e-17,   1.212769751308298e-01,  -1.346178648314098e-03,   1.095208156567637e-05,
  -5.624125298752620e-08,   1.039416255191730e-09,  -4.689506764922164e-12,  -5.916821430560965e-13,  -8.645986535681543e-15,   3.922904555577590e-16,   1.378509181326249e-17,
   1.212770519449580e-01,  -1.346179831285939e-03,   1.095212517151361e-05,  -5.624158383022295e-08,   1.039354193389610e-09,  -4.690772740349586e-12,  -5.916052342917574e-13,
  -8.642522380572592e-15,   3.922536112778208e-16,   1.377990998128751e-17,   2.027738859676302e-01,  -2.241602671386410e-03,   1.779943547594366e-05,  -8.194981158048296e-08,
   1.637459944959035e-09,  -5.967900561232515e-12,  -1.070139495994223e-12,  -1.584012153724989e-14,   6.952512739262104e-16,   2.549819121651714e-17,   2.027764217438228e-01,
  -2.241637688991706e-03,   1.780082086950920e-05,  -8.195868534285418e-08,   1.635208165975540e-09,  -6.013241035553228e-12,  -1.067395914909155e-12,  -1.571452399208461e-14,
   6.939725664649332e-16,   2.530981834778564e-17,   2.027805847714261e-01,  -2.241695178886331e-03,   1.780309383798784e-05,  -8.197329887046569e-08,   1.631515724853574e-09,
  -6.087406727431617e-12,  -1.062895619308240e-12,  -1.550902501189585e-14,   6.918638829484413e-16,   2.500160729584094e-17,   2.027850022564832e-01,  -2.241756183959419e-03,
   1.780550376009748e-05,  -8.198886706373134e-08,   1.627603489547046e-09,  -6.165738788332705e-12,  -1.058125551086709e-12,  -1.529191000492961e-14,   6.896136265660221e-16,
   2.467597385850818e-17,   2.027884789786836e-01,  -2.241804198067142e-03,   1.780739902638822e-05,  -8.200116416653987e-08,   1.624528686040712e-09,  -6.227124005607665e-12,
  -1.054375181408576e-12,  -1.512171489248898e-14,   6.878334892334293e-16,   2.442071213185096e-17,   2.027904855184482e-01,  -2.241831909069771e-03,   1.780849227881207e-05,
  -8.200827900577732e-08,   1.622755817999445e-09,  -6.262445590417752e-12,  -1.052212256250110e-12,  -1.502376221549257e-14,   6.868024859480350e-16,   2.427380126147575e-17,
   2.027912390045511e-01,  -2.241842315039147e-03,   1.780890270341471e-05,  -8.201095408506744e-08,   1.622090402303800e-09,  -6.275689370899595e-12,  -1.051400337756940e-12,
  -1.498703102729219e-14,   6.864146469380726e-16,   2.421871137222755e-17,   2.027913639062101e-01,  -2.241844039988727e-03,   1.780897073175823e-05,  -8.201139769628667e-08,
   1.621980116683956e-09,  -6.277883671787224e-12,  -1.051265765501615e-12,  -1.498094499684646e-14,   6.863503209025354e-16,   2.420958347397528e-17,   3.074896894908049e-01,
  -3.379678555773336e-03,   2.591026687084809e-05,  -9.849133494994565e-08,   2.241371644869810e-09,  -5.894373879764891e-12,  -1.753644603963172e-12,  -2.534474726712274e-14,
   1.122953484966317e-15,   4.135102001080005e-17,   3.074933805183217e-01,  -3.379720635800653e-03,   2.591215976779106e-05,  -9.850033229342075e-08,   2.237680876167139e-09,
  -5.966877510859298e-12,  -1.749213068675889e-12,  -2.514109625800707e-14,   1.120896614807025e-15,   4.104427504880646e-17,   3.074994401288985e-01,  -3.379789719895355e-03,
   2.591526500351539e-05,  -9.851517612551894e-08,   2.231628696001622e-09,  -6.085469371143964e-12,  -1.741943999791020e-12,  -2.480789328240065e-14,   1.117504212945273e-15,
   4.054238847288285e-17,   3.075058701042896e-01,  -3.379863027439505e-03,   2.591855682809137e-05,  -9.853102587118810e-08,   2.225216120695249e-09,  -6.210715185304932e-12,
  -1.734239153011802e-12,  -2.445586217301063e-14,   1.113883420238679e-15,   4.001213428212469e-17,   3.075109307170362e-01,  -3.379920723753308e-03,   2.592114528998916e-05,
  -9.854357140486095e-08,   2.220176087498089e-09,  -6.308858654677675e-12,  -1.728181352018595e-12,  -2.417991186125813e-14,   1.111018625157819e-15,   3.959647385079665e-17,
   3.075138513710688e-01,  -3.379954022586320e-03,   2.592263825213546e-05,  -9.855084035633998e-08,   2.217270069045729e-09,  -6.365328891079527e-12,  -1.724687669441375e-12,
  -2.402109560443020e-14,   1.109359241222866e-15,   3.935724949337312e-17,   3.075149481199596e-01,  -3.379966526849254e-03,   2.592319870615050e-05,  -9.855357533304449e-08,
   2.216179337224833e-09,  -6.386501882380329e-12,  -1.723376209899644e-12,  -2.396154159291361e-14,   1.108734986778242e-15,   3.926754326647287e-17,   3.075151299225389e-01,
  -3.379968599621435e-03,   2.592329160055852e-05,  -9.855402897996744e-08,   2.215998559555926e-09,  -6.390009914001500e-12,  -1.723158840624726e-12,  -2.395167404294063e-14,
   1.108631447691434e-15,   3.925267976146964e-17,   4.377556632927550e-01,  -4.772228152459518e-03,   3.470908898318499e-05,  -8.834974689607904e-08,   2.721324788063961e-09,
  -2.757187073648159e-12,  -2.747705108123392e-12,  -3.904584951875566e-14,   1.744454640388032e-15,   6.440074996982519e-17,   4.377606072573801e-01,  -4.772265888272801e-03,
   3.471137984223566e-05,  -8.835460863335829e-08,   2.715541192254523e-09,  -2.868832439447685e-12,  -2.740820578587051e-12,  -3.872876488094413e-14,   1.741277029982827e-15,
   6.391984081382419e-17,   4.377687238061009e-01,  -4.772327839436884e-03,   3.471513711484641e-05,  -8.836270271280047e-08,   2.706057069615617e-09,  -3.051439785372452e-12,
  -2.729527804418670e-12,  -3.820997987868544e-14,   1.736035285620451e-15,   6.313299893982431e-17,   4.377773364049238e-01,  -4.772393576765604e-03,   3.471911905944341e-05,
  -8.837144401746904e-08,   2.696008061644689e-09,  -3.244282820122418e-12,  -2.717557970175003e-12,  -3.766189654395562e-14,   1.730439433496140e-15,   6.230169250614143e-17,
   4.377841147921622e-01,  -4.772445314108782e-03,   3.472224938952003e-05,  -8.837843384980491e-08,   2.688109844207395e-09,  -3.395388650533314e-12,  -2.708146852957781e-12,
  -3.723227660090559e-14,   1.726011093750803e-15,   6.165004735497545e-17,   4.377880268228112e-01,  -4.772475173435471e-03,   3.472405456968426e-05,  -8.838251196712548e-08,
   2.683555797109812e-09,  -3.482329690380780e-12,  -2.702719213047360e-12,  -3.698502442287671e-14,   1.723445710740372e-15,   6.127500987289361e-17,   4.377894958463820e-01,
  -4.772486386041348e-03,   3.472473216931442e-05,  -8.838405167367829e-08,   2.681846494808207e-09,  -3.514926874136707e-12,  -2.700681780782180e-12,  -3.689230900384154e-14,
   1.722480558413373e-15,   6.113437590219992e-17,   4.377897393589714e-01,  -4.772488244698233e-03,   3.472484447725547e-05,  -8.838430734139668e-08,   2.681563195032166e-09,
  -3.520327685581927e-12,  -2.700344084203743e-12,  -3.687694696236491e-14,   1.722320474496799e-15,   6.111107416169001e-17,   5.970072058039559e-01,  -6.430993675344199e-03,
   4.302883040623858e-05,  -1.827380790702349e-08,   2.842278972726200e-09,   5.037136224202354e-12,  -4.204689072273388e-12,  -5.998034555400696e-14,   2.688988432294268e-15,
   9.917286789097936e-17,   5.970133339013987e-01,  -6.431001456882471e-03,   4.303120719279545e-05,  -1.826808054864327e-08,   2.833429517805836e-09,   4.865647287834520e-12,
  -4.194076447456337e-12,  -5.949226718112076e-14,   2.684114287700400e-15,   9.842438271171958e-17,   5.970233944019069e-01,  -6.431014230103720e-03,   4.303510365127890e-05,
  -1.825885134294256e-08,   2.818918023950636e-09,   4.585161758331374e-12,  -4.176668373032030e-12,  -5.869374778684520e-14,   2.676072433696053e-15,   9.719976824760803e-17,
   5.970340696920521e-01,  -6.431027781559283e-03,   4.303923073236393e-05,  -1.824929322816246e-08,   2.803542373507324e-09,   4.288956942657588e-12,  -4.158216512397561e-12,
  -5.785017283417847e-14,   2.667485259001087e-15,   9.590598243043217e-17,   5.970424714340807e-01,  -6.431038445258585e-03,   4.304247344051596e-05,  -1.824194047775874e-08,
   2.791457695059304e-09,   4.056862002272951e-12,  -4.143708933193295e-12,  -5.718895870717492e-14,   2.660688240943926e-15,   9.489183179353598e-17,   5.970473203368539e-01,
  -6.431044598947150e-03,   4.304434273715470e-05,  -1.823776487059828e-08,   2.784489816971063e-09,   3.923323431782104e-12,  -4.135342006250430e-12,  -5.680843273956008e-14,
   2.656750079763587e-15,   9.430817304851406e-17,   5.970491411656609e-01,  -6.431046909617046e-03,   4.304504427351836e-05,  -1.823620968738244e-08,   2.781874523692959e-09,
   3.873255380225734e-12,  -4.132201217577180e-12,  -5.666574412572390e-14,   2.655268350362466e-15,   9.408931071364748e-17,   5.970494429950268e-01,  -6.431047292638330e-03,
   4.304516054195041e-05,  -1.823595256826364e-08,   2.781441065444315e-09,   3.864959944206817e-12,  -4.131680643686214e-12,  -5.664210213108938e-14,   2.655022579271206e-15,
   9.405304735517787e-17,   7.904533226197017e-01,  -8.358984459072436e-03,   4.826011153285685e-05,   1.806807041220543e-07,   2.233499442398259e-09,   1.607227257283950e-11,
  -6.360257910161344e-12,  -9.561310080199483e-14,   4.250732894877323e-15,   1.558103337077598e-16,   7.904601940696031e-01,  -8.358907250262311e-03,   4.826194289726948e-05,
   1.807012775586937e-07,   2.220121804676571e-09,   1.579871888117461e-11,  -6.343482700319463e-12,  -9.484680363312067e-14,   4.242974493142696e-15,   1.546147631693509e-16,
   7.904714748433235e-01,  -8.358780493685125e-03,   4.826494118566549e-05,   1.807347758521332e-07,   2.198186041250312e-09,   1.535127076654985e-11,  -6.315966196848507e-12,
  -9.359317920947040e-14,   4.230172269153361e-15,   1.526587482215531e-16,   7.904834448557581e-01,  -8.358645987295066e-03,   4.826811147553262e-05,   1.807699454824091e-07,
   2.174945537514097e-09,   1.487871006774179e-11,  -6.286800037401677e-12,  -9.226892112997335e-14,   4.216499742185057e-15,   1.505923673718220e-16,   7.904928654916150e-01,
  -8.358540124400253e-03,   4.827059846171147e-05,   1.807973536250935e-07,   2.156680491109079e-09,   1.450840296453214e-11,  -6.263868624243309e-12,  -9.123100903236973e-14,
   4.205675961227900e-15,   1.489726940006761e-16,   7.904983023940838e-01,  -8.358479026596800e-03,   4.827203052603025e-05,   1.808130631886716e-07,   2.146149533015027e-09,
   1.429533178741233e-11,  -6.250643505343550e-12,  -9.063372419405997e-14,   4.199404102403787e-15,   1.480405824646778e-16,   7.905003440181099e-01,  -8.358456083338886e-03,
   4.827256767131263e-05,   1.808189418608211e-07,   2.142196972774502e-09,   1.421544230602311e-11,  -6.245679054931797e-12,  -9.040976144547117e-14,   4.197044207533069e-15,
   1.476910626652157e-16,   7.905006824472055e-01,  -8.358452280143086e-03,   4.827265667870502e-05,   1.808199152580367e-07,   2.141541880572481e-09,   1.420220585325222e-11,
  -6.244856216672028e-12,  -9.037265347783883e-14,   4.196652771149930e-15,   1.476331509823963e-16,   1.026484277328165e+00,  -1.051656919233059e-02,   4.369488920658457e-05,
   6.699548577762947e-07,   6.407088026372774e-10,   4.991710955550897e-12,  -9.496970712495929e-12,  -1.664567648510160e-13,   7.199867436532550e-15,   2.636894538139375e-16,
   1.026490496303258e+00,  -1.051628316368067e-02,   4.369532348946584e-05,   6.699579538937902e-07,   6.207733352297782e-10,   4.514855773078280e-12,  -9.468576398952836e-12,
  -1.651611685065815e-13,   7.185791019447909e-15,   2.616183538047066e-16,   1.026500705784340e+00,  -1.051581360131958e-02,   4.369602423895533e-05,   6.699625547040911e-07,
   5.880896885025650e-10,   3.734783529755234e-12,  -9.422003721780730e-12,  -1.630418158689925e-13,   7.162569507290551e-15,   2.582303042861826e-16,   1.026511538868884e+00,
  -1.051531535938408e-02,   4.369675122741620e-05,   6.699667830237160e-07,   5.534691011512458e-10,   2.910812437585685e-12,  -9.372642658085050e-12,  -1.608032943974119e-13,
   7.137777680182302e-15,   2.546516001992498e-16,   1.026520064588931e+00,  -1.051492324043952e-02,   4.369731139213575e-05,   6.699696387915209e-07,   5.262654152794514e-10,
   2.265047968045567e-12,  -9.333836028890300e-12,  -1.590489869303901e-13,   7.118157333490258e-15,   2.518469069511223e-16,   1.026524984958770e+00,  -1.051469694098008e-02,
   4.369762987616025e-05,   6.699710981299006e-07,   5.105828228210184e-10,   1.893446710852172e-12,  -9.311456358380663e-12,  -1.580395101099760e-13,   7.106790666708036e-15,
   2.502329732052450e-16,   1.026526832608458e+00,  -1.051461196329484e-02,   4.369774856366011e-05,   6.699716104915461e-07,   5.046971007645341e-10,   1.754110988505700e-12,
  -9.303055673478523e-12,  -1.576610018253916e-13,   7.102514210123866e-15,   2.496278143944197e-16,   1.026527138882940e+00,  -1.051459787702786e-02,   4.369776819000547e-05,
   6.699716935440976e-07,   5.037216293727493e-10,   1.731024866279208e-12,  -9.301663303584156e-12,  -1.575982881994895e-13,   7.101804896704036e-15,   2.495275475575904e-16,
   1.319949214418492e+00,  -1.265085122676037e-02,   7.495212901660520e-06,   1.885213128864416e-06,   2.590678645620366e-09,  -2.550310556769904e-10,  -1.395048786579122e-11,
  -3.013410505380400e-13,   1.358900660053520e-14,   5.525452144986544e-16,   1.319950285156386e+00,  -1.265004769675944e-02,   7.497260119320057e-06,   1.884843000009426e-06,
   2.561533025876051e-09,  -2.558885543000090e-10,  -1.389708885334716e-11,  -2.986321428478615e-13,   1.355315324510666e-14,   5.479808354855153e-16,   1.319952043130296e+00,
  -1.264872868805572e-02,   7.500603172278316e-06,   1.884234509360098e-06,   2.513767759322460e-09,  -2.572905045722729e-10,  -1.380953009887565e-11,  -2.942017166321108e-13,
   1.349409963088386e-14,   5.405164360179902e-16,   1.319953908726097e+00,  -1.264732927544531e-02,   7.504126264526400e-06,   1.883587682399362e-06,   2.463196455516603e-09,
  -2.587702564626661e-10,  -1.371676563409213e-11,  -2.895233090667972e-13,   1.343117763856334e-14,   5.326351529268326e-16,   1.319955377139767e+00,  -1.264622804456019e-02,
   7.506881496403193e-06,   1.883077780610148e-06,   2.423477113744494e-09,  -2.599291783222117e-10,  -1.364386265911172e-11,  -2.858577075237228e-13,   1.338147055374124e-14,
   5.264607349313890e-16,   1.319956224661901e+00,  -1.264559254849287e-02,   7.508464602788491e-06,   1.882783168197623e-06,   2.400586566285252e-09,  -2.605957547777356e-10,
  -1.360183034870826e-11,  -2.837487480004532e-13,   1.335270933266027e-14,   5.229086391677280e-16,   1.319956542928449e+00,  -1.264535392206324e-02,   7.509057754300941e-06,
   1.882672474497535e-06,   2.391997033077678e-09,  -2.608456342998171e-10,  -1.358605463636984e-11,  -2.829580453365226e-13,   1.334189525275062e-14,   5.215769218854029e-16,
   1.319956595686400e+00,  -1.264531436677400e-02,   7.509156008003398e-06,   1.882654122068460e-06,   2.390573516470387e-09,  -2.608870329187352e-10,  -1.358343999995746e-11,
  -2.828270400341700e-13,   1.334010193010691e-14,   5.213562829937144e-16,   1.699239082596783e+00,  -1.282240919610809e-02,  -1.676522079621772e-04,   4.084829008288934e-06,
   1.333961364735608e-07,  -2.414312996384848e-09,  -1.360769773487094e-10,   1.102238202366943e-12,   1.397781995827710e-13,   2.696431871741771e-16,   1.699215450246143e+00,
  -1.282067732636766e-02,  -1.675399148497940e-04,   4.081421227440111e-06,   1.331120542162112e-07,  -2.411002580279548e-09,  -1.355370765730064e-10,   1.103305171824986e-12,
   1.389515857805266e-13,   2.577771616275754e-16,   1.699176665211046e+00,  -1.281783522679807e-02,  -1.673557408279974e-04,   4.075830214977607e-06,   1.326465111669091e-07,
  -2.405565892941370e-09,  -1.346530955298164e-10,   1.105014069257659e-12,   1.375993040505969e-13,   2.384609035805812e-16,   1.699135526630016e+00,  -1.281482095900897e-02,
  -1.671605532044582e-04,   4.069902355972387e-06,   1.321536518572825e-07,  -2.399794338250778e-09,  -1.337183144382674e-10,   1.106769628083056e-12,   1.361708514265452e-13,
   2.181861450209462e-16,   1.699103161448906e+00,  -1.281244974173112e-02,  -1.670071096292748e-04,   4.065240458180462e-06,   1.317665767952154e-07,  -2.395250099271421e-09,
  -1.329849414385207e-10,   1.108109731869671e-12,   1.350512883847080e-13,   2.023890365536709e-16,   1.699084487316344e+00,  -1.281108167752004e-02,  -1.669186224592026e-04,
   4.062551332287651e-06,   1.315435115074900e-07,  -2.392626743098400e-09,  -1.325626194364055e-10,   1.108866568495491e-12,   1.344070207995264e-13,   1.933357227289478e-16,
   1.699077475833989e+00,  -1.281056803359280e-02,  -1.668854075134466e-04,   4.061541793306126e-06,   1.314598093203582e-07,  -2.391641499530659e-09,  -1.324042073456762e-10,
   1.109147647464636e-12,   1.341654418345679e-13,   1.899480785016144e-16,   1.699076313624741e+00,  -1.281048289386290e-02,  -1.668799023393165e-04,   4.061374461198084e-06,
   1.314459377037507e-07,  -2.391478173576111e-09,  -1.323779574489793e-10,   1.109194075938308e-12,   1.341254151100860e-13,   1.893871582644084e-16,   2.329413884369594e-03,
  -2.540281827345250e-05,   2.139888216971303e-07,  -9.866483475643063e-10,   1.767726193356976e-11,  -4.064964744255359e-13,  -1.138464468160755e-14,   1.825055625966157e-16,
   1.296247469804061e-17,  -3.856445988391544e-20,   2.329444366631978e-03,  -2.540324152201152e-05,   2.140037812865721e-07,  -9.872222493945037e-10,   1.765355305752117e-11,
  -4.059545205483480e-13,  -1.133454572741931e-14,   1.822913709466390e-16,   1.288732075124018e-17,  -3.919353328013241e-20,   2.329494409717880e-03,  -2.540393652906187e-05,
   2.140283254299993e-07,  -9.881638461766172e-10,   1.761470757402335e-11,  -4.050652887803564e-13,  -1.125251424956543e-14,   1.819374902516007e-16,   1.276435812197908e-17,
  -4.021577175824294e-20,   2.329547511363543e-03,  -2.540467422442368e-05,   2.140543490585413e-07,  -9.891621978248208e-10,   1.757359326821839e-11,  -4.041223909145637e-13,
  -1.116576279136488e-14,   1.815589579002472e-16,   1.263444743392962e-17,  -4.128627313615358e-20,   2.329589304131404e-03,  -2.540525496763997e-05,   2.140748156167319e-07,
  -9.899473591664438e-10,   1.754131107381612e-11,  -4.033807949301796e-13,  -1.109769859864716e-14,   1.812588680457491e-16,   1.253261288871162e-17,  -4.211856489941192e-20,
   2.329613424153520e-03,  -2.540559019526528e-05,   2.140866215925335e-07,  -9.904002720757628e-10,   1.752271039772418e-11,  -4.029529942890237e-13,  -1.105850129697120e-14,
   1.810848106801406e-16,   1.247400447996642e-17,  -4.259482934319403e-20,   2.329622481574782e-03,  -2.540571608967879e-05,   2.140910537819670e-07,  -9.905703039818180e-10,
   1.751573132550634e-11,  -4.027923866781004e-13,  -1.104379815373336e-14,   1.810192866749727e-16,   1.245202706996083e-17,  -4.277290504435611e-20,   2.329623982977968e-03,
  -2.540573695917122e-05,   2.140917884242798e-07,  -9.905984870204741e-10,   1.751457474319461e-11,  -4.027657655573747e-13,  -1.104136173207673e-14,   1.810084165110826e-16,
   1.244838561443841e-17,  -4.280238327290243e-20,   2.102150832609633e-02,  -2.291103866569765e-04,   1.922753892907046e-06,  -8.672323939165022e-09,   1.572830781994331e-10,
  -3.665686796483347e-12,  -1.041024936561825e-13,   1.668362261205827e-15,   1.181831877764659e-16,  -3.519791054017543e-19,   2.102178221567852e-02,  -2.291141073367844e-04,
   1.922886962392466e-06,  -8.677498680991491e-09,   1.570662654352367e-10,  -3.660732515069766e-12,  -1.036457405998799e-13,   1.666407155338884e-15,   1.174972183845146e-16,
  -3.577272767722765e-19,   2.102223186326025e-02,  -2.291202170220376e-04,   1.923105285398671e-06,  -8.685988774907086e-09,   1.567110293962325e-10,  -3.652603580002800e-12,
  -1.028978603890615e-13,   1.663176970052370e-15,   1.163748771392673e-16,  -3.670678928147697e-19,   2.102270899244756e-02,  -2.291267020265986e-04,   1.923336763693873e-06,
  -8.694990516001742e-09,   1.563350424212271e-10,  -3.643984046238609e-12,  -1.021069511912500e-13,   1.659721739161181e-15,   1.151891215738383e-16,  -3.768493582261834e-19,
   2.102308450890654e-02,  -2.291318073198249e-04,   1.923518808701818e-06,  -8.702069936290485e-09,   1.560398222817513e-10,  -3.637204714350616e-12,  -1.014864151558686e-13,
   1.656982509086563e-15,   1.142596330358904e-16,  -3.844541290927081e-19,   2.102330123212008e-02,  -2.291347543097069e-04,   1.923623818534925e-06,  -8.706153605671532e-09,
   1.558697185590742e-10,  -3.633293953685492e-12,  -1.011290572348854e-13,   1.655393699978554e-15,   1.137246895779219e-16,  -3.888057832562883e-19,   2.102338261484755e-02,
  -2.291358610518800e-04,   1.923663240968821e-06,  -8.707686685715023e-09,   1.558058945813704e-10,  -3.631825750808297e-12,  -1.009950102987929e-13,   1.654795590343202e-15,
   1.135240927888438e-16,  -3.904328624313174e-19,   2.102339610525257e-02,  -2.291360445164701e-04,   1.923669775284565e-06,  -8.707940795715107e-09,   1.557953175676625e-10,
  -3.631582392415259e-12,  -1.009727977198872e-13,   1.654696366330543e-15,   1.134908557501743e-16,  -3.907022048192675e-19,   5.871425098313732e-02,  -6.391416726081953e-04,
   5.321943248137027e-06,  -2.288052902809075e-08,   4.263218473221779e-10,  -1.022494768124685e-11,  -2.986251381111160e-13,   4.783468480222302e-15,   3.371115389250067e-16,
  -1.006647085258724e-18,   5.871500905964494e-02,  -6.391514917699134e-04,   5.322303743859410e-06,  -2.289496003096884e-08,   4.256998167014089e-10,  -1.021074272916432e-11,
  -2.973223645007082e-13,   4.777876213493994e-15,   3.351504070967839e-16,  -1.023115175069866e-18,   5.871625360147843e-02,  -6.391676159384784e-04,   5.322895176937280e-06,
  -2.291863628566581e-08,   4.246806413133142e-10,  -1.018743535754403e-11,  -2.951892365821130e-13,   4.768636697322425e-15,   3.319417409976513e-16,  -1.049874685107837e-18,
   5.871757420622313e-02,  -6.391847309397402e-04,   5.323522218725682e-06,  -2.294373882432075e-08,   4.236019153716840e-10,  -1.016272129612990e-11,  -2.929333975588375e-13,
   4.758753349687514e-15,   3.285518039766071e-16,  -1.077896254015732e-18,   5.871861356504539e-02,  -6.391982048867726e-04,   5.324015331976706e-06,  -2.296348032584748e-08,
   4.227549020784432e-10,  -1.014328346127229e-11,  -2.911635112488883e-13,   4.750917968541676e-15,   3.258945222881899e-16,  -1.099681451290322e-18,   5.871921341375070e-02,
  -6.392059827085886e-04,   5.324299768359167e-06,  -2.297486779076570e-08,   4.222668544696579e-10,  -1.013207043910836e-11,  -2.901442638581505e-13,   4.746373255651445e-15,
   3.243651985976524e-16,  -1.112147261083975e-18,   5.871943866562646e-02,  -6.392089036874887e-04,   5.324406548922647e-06,  -2.297914281206744e-08,   4.220837350855901e-10,
  -1.012786077213818e-11,  -2.897619394763976e-13,   4.744662385420203e-15,   3.237917235926484e-16,  -1.116808164743371e-18,   5.871947600449266e-02,  -6.392093878989307e-04,
   5.324424247846173e-06,  -2.297985140080611e-08,   4.220533881962169e-10,  -1.012716300892345e-11,  -2.896985855203574e-13,   4.744378558527292e-15,   3.236967041420961e-16,
  -1.117579715766079e-18,   1.160534978736143e-01,  -1.260870769752267e-03,   1.036659648301399e-05,  -4.098939796542725e-08,   8.018047434111159e-10,  -2.017962816382850e-11,
  -6.148585646732534e-13,   9.844389177475401e-15,   6.886980513325263e-16,  -2.067551086213744e-18,   1.160549744785065e-01,  -1.260888369564098e-03,   1.036727385701628e-05,
  -4.101786840626516e-08,   8.005237535221694e-10,  -2.015039398427435e-11,  -6.121973660621930e-13,   9.832902389341294e-15,   6.846775994518918e-16,  -2.101408849872221e-18,
   1.160573986330073e-01,  -1.260917271231958e-03,   1.036838509549626e-05,  -4.106457725268486e-08,   7.984248631840435e-10,  -2.010242672785540e-11,  -6.078400287792355e-13,
   9.813923877972563e-15,   6.780996792668274e-16,  -2.156423063881721e-18,   1.160599709414862e-01,  -1.260947949993003e-03,   1.036956314590633e-05,  -4.111409820471195e-08,
   7.962032891482671e-10,  -2.005156439603382e-11,  -6.032320849493827e-13,   9.793622775693456e-15,   6.711502273138928e-16,  -2.214028766982623e-18,   1.160619954292218e-01,
  -1.260972102920534e-03,   1.037048951172505e-05,  -4.115304196587996e-08,   7.944588811716765e-10,  -2.001156065958841e-11,  -5.996168240779762e-13,   9.777528258878371e-15,
   6.657027958907065e-16,  -2.258811686917335e-18,   1.160631638277068e-01,  -1.260986045485854e-03,   1.037102382883488e-05,  -4.117550535539568e-08,   7.934537431113281e-10,
  -1.998848385273655e-11,  -5.975348729093413e-13,   9.768193013080118e-15,   6.625677039198884e-16,  -2.284436214461740e-18,   1.160636025780631e-01,  -1.260991281707541e-03,
   1.037122441229139e-05,  -4.118393834852853e-08,   7.930766047429659e-10,  -1.997982020154848e-11,  -5.967539264813387e-13,   9.764678727112159e-15,   6.613920927703057e-16,
  -2.294016922858280e-18,   1.160636753074842e-01,  -1.260992149720510e-03,   1.037125765881528e-05,  -4.118533612005839e-08,   7.930141045303816e-10,  -1.997838417870770e-11,
  -5.966245180862858e-13,   9.764095720073509e-15,   6.611973052242566e-16,  -2.295602873377975e-18,   1.940866428150142e-01,  -2.102714056889834e-03,   1.696449348032539e-05,
  -5.819644273705348e-08,   1.241564330588993e-09,  -3.371934331454884e-11,  -1.087582708135219e-12,   1.741238558218971e-14,   1.207246522885963e-15,  -3.661532967302877e-18,
   1.940890590929125e-01,  -2.102739070132860e-03,   1.696554076923167e-05,  -5.824399157320073e-08,   1.239297962324122e-09,  -3.366763533440003e-11,  -1.082918485591019e-12,
   1.739204678592146e-14,   1.200164866991274e-15,  -3.721357687445449e-18,   1.940930259099397e-01,  -2.102780147990892e-03,   1.696725868228002e-05,  -5.832199763842338e-08,
   1.235584470812509e-09,  -3.358279325371439e-11,  -1.075281578253056e-12,   1.735844345019214e-14,   1.188578627785219e-15,  -3.818558194183863e-18,   1.940972351531334e-01,
  -2.102823754568199e-03,   1.696907964603308e-05,  -5.840469603647147e-08,   1.231653827420594e-09,  -3.349283056980934e-11,  -1.067205578602506e-12,   1.732249901219416e-14,
   1.176338198115116e-15,  -3.920328655166247e-18,   1.941005479536635e-01,  -2.102858087498945e-03,   1.697051139855928e-05,  -5.846972795285797e-08,   1.228567369890771e-09,
  -3.342207405651735e-11,  -1.060869477580425e-12,   1.729400310287116e-14,   1.166743513706583e-15,  -3.999439097596434e-18,   1.941024598773062e-01,  -2.102877907444617e-03,
   1.697133714819423e-05,  -5.850723824289705e-08,   1.226788908256724e-09,  -3.338125702708072e-11,  -1.057220691888154e-12,   1.727747491917119e-14,   1.161221668768296e-15,
  -4.044703082616694e-18,   1.941031778315211e-01,  -2.102885351115948e-03,   1.697164712288176e-05,  -5.852131978018045e-08,   1.226121605684251e-09,  -3.336593322463906e-11,
  -1.055852028264165e-12,   1.727125286404598e-14,   1.159151074076992e-15,  -4.061626268707664e-18,   1.941032968431243e-01,  -2.102886585068231e-03,   1.697169850021696e-05,
  -5.852365378820435e-08,   1.226011018544264e-09,  -3.336339326448539e-11,  -1.055625231324698e-12,   1.727022065010306e-14,   1.158807996935066e-15,  -4.064427636814683e-18,
   2.943788833143932e-01,  -3.176539012633691e-03,   2.493179684498935e-05,  -6.601140311307206e-08,   1.671350431130045e-09,  -5.123639752377136e-11,  -1.774301135102886e-12,
   2.843896104815015e-14,   1.952865594028365e-15,  -6.036227360117152e-18,   2.943824341196394e-01,  -3.176567449293297e-03,   2.493320300876399e-05,  -6.608360377624515e-08,
   1.667652257443481e-09,  -5.115194945381636e-11,  -1.766757696829064e-12,   2.840545858322040e-14,   1.941337160796826e-15,  -6.133841683244141e-18,   2.943882634826026e-01,
  -3.176614154786104e-03,   2.493550920013927e-05,  -6.620204622038562e-08,   1.661592619205597e-09,  -5.101338828500327e-11,  -1.754406753260036e-12,   2.835010995789489e-14,
   1.922475975377056e-15,  -6.292424528815764e-18,   2.943944490794423e-01,  -3.176663742964018e-03,   2.493795318785492e-05,  -6.632760511393053e-08,   1.655178493456626e-09,
  -5.086646515870354e-11,  -1.741345966596469e-12,   2.829090992309646e-14,   1.902550365174263e-15,  -6.458440837268515e-18,   2.943993173157253e-01,  -3.176702790859228e-03,
   2.493987440682958e-05,  -6.642633544289836e-08,   1.650141829609515e-09,  -5.075090931636014e-11,  -1.731099212462293e-12,   2.824398086871010e-14,   1.886932019666012e-15,
  -6.587475996771450e-18,   2.944021269257937e-01,  -3.176725334873275e-03,   2.494098229409996e-05,  -6.648328051303907e-08,   1.647239589637006e-09,  -5.068424931797017e-11,
  -1.725198472948208e-12,   2.821676243365269e-14,   1.877943645680007e-15,  -6.661298462764383e-18,   2.944031819728397e-01,  -3.176733802020591e-03,   2.494139814948516e-05,
  -6.650465750289745e-08,   1.646150622626357e-09,  -5.065922342094714e-11,  -1.722985114660701e-12,   2.820651627089929e-14,   1.874573192555659e-15,  -6.688897782601962e-18,
   2.944033568625445e-01,  -3.176735205658271e-03,   2.494146707464469e-05,  -6.650820070470539e-08,   1.645970155733917e-09,  -5.065507531577278e-11,  -1.722618346859283e-12,
   2.820481648686329e-14,   1.874014743205031e-15,  -6.693466351725066e-18,   4.192163900671688e-01,  -4.498084793844928e-03,   3.389602582901850e-05,  -4.906591293187023e-08,
   1.958933707162181e-09,  -7.364342930004300e-11,  -2.769937056178968e-12,   4.456457481378084e-14,   3.034434734475140e-15,  -9.708957742337982e-18,   4.192212170180462e-01,
  -4.498106107247767e-03,   3.389766580692547e-05,  -4.916959663529447e-08,   1.953159638109842e-09,  -7.351111738251536e-11,  -2.758218827904972e-12,   4.451080089999916e-14,
   3.016373043945239e-15,  -9.861725572444075e-18,   4.192291414028412e-01,  -4.498141128381707e-03,   3.390035457652736e-05,  -4.933967449306540e-08,   1.943698451349027e-09,
  -7.329402467285625e-11,  -2.739032891381846e-12,   4.442197658868989e-14,   2.986823983449777e-15,  -1.010986798773312e-17,   4.192375500099391e-01,  -4.498178331617837e-03,
   3.390320279149761e-05,  -4.951995585665645e-08,   1.933683661056219e-09,  -7.306383450602070e-11,  -2.718744869716722e-12,   4.432699072968011e-14,   2.955608569788151e-15,
  -1.036958476283628e-17,   4.192441677887722e-01,  -4.498207641952462e-03,   3.390544089736929e-05,  -4.966170478860065e-08,   1.925819499630711e-09,  -7.288279140429210e-11,
  -2.702828458086848e-12,   4.425170732527147e-14,   2.931141802200262e-15,  -1.057140655846950e-17,   4.192479871027769e-01,  -4.498224570017253e-03,   3.390673116892677e-05,
  -4.974345739398328e-08,   1.921287954537421e-09,  -7.277835525949473e-11,  -2.693662934459830e-12,   4.420804909445454e-14,   2.917061510865974e-15,  -1.068685439372912e-17,
   4.192494213053375e-01,  -4.498230929035377e-03,   3.390721541748854e-05,  -4.977414620501298e-08,   1.919587639115670e-09,  -7.273914742111208e-11,  -2.690224992620075e-12,
   4.419161533010229e-14,   2.911781762530035e-15,  -1.073001264083387e-17,   4.192496590455828e-01,  -4.498231983258213e-03,   3.390729567484206e-05,  -4.977923278166945e-08,
   1.919305857354637e-09,  -7.273264863449394e-11,  -2.689655305078234e-12,   4.418888910987341e-14,   2.910906966214314e-15,  -1.073715654230768e-17,   5.719713577844823e-01,
  -6.086897029170274e-03,   4.306691320641386e-05,   2.216813093456428e-08,   1.860670528515850e-09,  -1.034270053986847e-10,  -4.233998101256293e-12,   6.878219061903246e-14,
   4.664959446246142e-15,  -1.589011521419435e-17,   5.719774896163019e-01,  -6.086888078668272e-03,   4.306845203467825e-05,   2.202266895739399e-08,   1.851845687887447e-09,
  -1.032228651511438e-10,  -4.215989457540981e-12,   6.869458463140460e-14,   4.636886939402088e-15,  -1.612499767937093e-17,   5.719875561612633e-01,  -6.086873429452811e-03,
   4.307097289150598e-05,   2.178407895111349e-08,   1.837385761657462e-09,  -1.028879290645882e-10,  -4.186505279848041e-12,   6.854992701186628e-14,   4.590962299808144e-15,
  -1.650640622083639e-17,   5.719982377479884e-01,  -6.086857945922785e-03,   4.307364041434436e-05,   2.153120095553119e-08,   1.822079940070647e-09,  -1.025327994905431e-10,
  -4.155328661703334e-12,   6.839530325616087e-14,   4.542450814642828e-15,  -1.690545074640718e-17,   5.720066443607154e-01,  -6.086845804021259e-03,   4.307573448983993e-05,
   2.133239050006346e-08,   1.810061115605196e-09,  -1.022535021885269e-10,  -4.130870766782153e-12,   6.827280132679624e-14,   4.504429464464318e-15,  -1.721542977296481e-17,
   5.720114960404964e-01,  -6.086838814207697e-03,   4.307694090803859e-05,   2.121773558701920e-08,   1.803135597623385e-09,  -1.020923912804060e-10,  -4.116786945835164e-12,
   6.820177963312125e-14,   4.482549555966234e-15,  -1.739270149978723e-17,   5.720133179056776e-01,  -6.086836192772680e-03,   4.307739353083510e-05,   2.117469711479442e-08,
   1.800537032354586e-09,  -1.020319071205505e-10,  -4.111504240925330e-12,   6.817504940279909e-14,   4.474345313700875e-15,  -1.745896301757570e-17,   5.720136199064986e-01,
  -6.086835758406866e-03,   4.307746853848788e-05,   2.116756369421918e-08,   1.800106390302931e-09,  -1.020218817756077e-10,  -4.110628868556577e-12,   6.817061527911753e-14,
   4.472985969435485e-15,  -1.746993070649007e-17,   7.578040963730875e-01,  -7.963656018035682e-03,   5.062474973205443e-05,   2.101212236464906e-07,   9.107660287843491e-10,
  -1.488169901928831e-10,  -6.435421374659894e-12,   1.071632683331356e-13,   7.314855314590387e-15,  -2.790639168800169e-17,   7.578113020570432e-01,  -7.963567050841044e-03,
   5.062545160993407e-05,   2.099121270337292e-07,   8.973628614876178e-10,  -1.484991926308061e-10,  -6.407197583004138e-12,   1.070108121269054e-13,   7.270126998014818e-15,
  -2.826625518095916e-17,   7.578231314139305e-01,  -7.963421060682322e-03,   5.062659568988395e-05,   2.095691869381873e-07,   8.754024496684559e-10,  -1.479778118270790e-10,
  -6.360990974982760e-12,   1.067592490025758e-13,   7.196960339555575e-15,  -2.885026008804786e-17,   7.578356833576910e-01,  -7.963266240616969e-03,   5.062779856296392e-05,
   2.092057436354726e-07,   8.521591660807506e-10,  -1.474250437146305e-10,  -6.312134811852030e-12,   1.064905928008833e-13,   7.119680087131184e-15,  -2.946079083914118e-17,
   7.578455618623060e-01,  -7.963144459197343e-03,   5.062873721642010e-05,   2.089200321813855e-07,   8.339087869841250e-10,  -1.469903444990440e-10,  -6.273809413746654e-12,
   1.062779181923460e-13,   7.059116528695097e-15,  -2.993470562879667e-17,   7.578512629639926e-01,  -7.963074201912035e-03,   5.062927572298893e-05,   2.087552708705627e-07,
   8.233930275816648e-10,  -1.467396046196532e-10,  -6.251740940777093e-12,   1.061546856176727e-13,   7.024266636357532e-15,  -3.020558953617541e-17,   7.578534037887965e-01,
  -7.963047824355324e-03,   5.062947733152398e-05,   2.086934256147059e-07,   8.194474447114302e-10,  -1.466454745866191e-10,  -6.243463421914658e-12,   1.061083176191063e-13,
   7.011199502109933e-15,  -3.030681534473137e-17,   7.578537586613844e-01,  -7.963043452148415e-03,   5.062951071906405e-05,   2.086831751577086e-07,   8.187935760473973e-10,
  -1.466298725212775e-10,  -6.242091800908794e-12,   1.061006265665753e-13,   7.009034457451981e-15,  -3.032356896342933e-17,   9.851681831303719e-01,  -1.013475644924566e-02,
   5.175605699985699e-05,   6.676063303326152e-07,  -1.748562488722051e-09,  -2.452481511437248e-10,  -9.762725198212325e-12,   1.752514765288632e-13,   1.221962892993859e-14,
  -5.727866702563628e-17,   9.851755451626359e-01,  -1.013447265006939e-02,   5.175444936007476e-05,   6.672616997600186e-07,  -1.768844872139943e-09,  -2.447293642580832e-10,
  -9.715624848715599e-12,   1.749438291092788e-13,   1.214256035879405e-14,  -5.781868253599316e-17,   9.851876309468647e-01,  -1.013400685309729e-02,   5.175179781790518e-05,
   6.666964644179883e-07,  -1.802069859608828e-09,  -2.438783651242653e-10,  -9.638521266973977e-12,   1.744368634614447e-13,   1.201650922918781e-14,  -5.869364295717487e-17,
   9.852004546484073e-01,  -1.013351274953812e-02,   5.174896757781264e-05,   6.660974280263699e-07,  -1.837226703448030e-09,  -2.429763068133028e-10,  -9.557005671226517e-12,
   1.738963573527886e-13,   1.188339530362211e-14,  -5.960643156739948e-17,   9.852105467876743e-01,  -1.013312399092694e-02,   5.174672805609262e-05,   6.656265056779883e-07,
  -1.864824922166962e-09,  -2.422670482255046e-10,  -9.493067119667987e-12,   1.734691288490475e-13,   1.177909299021631e-14,  -6.031357742835770e-17,   9.852163710857742e-01,
  -1.013289967218982e-02,   5.174543073704753e-05,   6.653549365021345e-07,  -1.880724220530312e-09,  -2.418579887703334e-10,  -9.456252784541459e-12,   1.732218323153509e-13,
   1.171908160657818e-14,  -6.071721236688447e-17,   9.852185581538436e-01,  -1.013281544610693e-02,   5.174494266539599e-05,   6.652529991279348e-07,  -1.886689245741708e-09,
  -2.417044335126648e-10,  -9.442444840277456e-12,   1.731288318591922e-13,   1.169658136475251e-14,  -6.086793900869702e-17,   9.852189206909536e-01,  -1.013280148484128e-02,
   5.174486171225745e-05,   6.652361036352961e-07,  -1.887677753566318e-09,  -2.416789822036146e-10,  -9.440156830191031e-12,   1.731134084314912e-13,   1.169285345305444e-14,
  -6.089287974810014e-17,   1.269609331750112e+00,  -1.250021037320724e-02,   3.013398173465780e-05,   1.865892910682721e-06,  -6.219311974452152e-09,  -6.264014614437415e-10,
  -1.391681231416894e-11,   3.572485976032811e-13,   2.322678645233426e-14,  -1.650631135387186e-16,   1.269613609030081e+00,  -1.249941689853807e-02,   3.012850959520596e-05,
   1.865010380517288e-06,  -6.247964311369105e-09,  -6.253476021365948e-10,  -1.382762627918442e-11,   3.563890851130815e-13,   2.306367114407607e-14,  -1.655997713088072e-16,
   1.269620630289122e+00,  -1.249811455166099e-02,   3.011950884252663e-05,   1.863562642602236e-06,  -6.294865936899315e-09,  -6.236193866280360e-10,  -1.368167651992920e-11,
   3.549762245733589e-13,   2.279697573946515e-14,  -1.664600984437377e-16,   1.269628079587229e+00,  -1.249673302801983e-02,   3.010993481313961e-05,   1.862027945059910e-06,
  -6.344447980214397e-09,  -6.217881532826202e-10,  -1.352744085220929e-11,   3.534746219848520e-13,   2.251546068498581e-14,  -1.673450786594274e-16,   1.269633941643763e+00,
  -1.249564602726704e-02,   3.010238299707110e-05,   1.860821189376725e-06,  -6.383336242614006e-09,  -6.203488013799944e-10,  -1.340651015245527e-11,   3.522911122450816e-13,
   2.229496688099911e-14,  -1.680215368105741e-16,   1.269637324518401e+00,  -1.249501880430083e-02,   3.009801789170663e-05,   1.860125171440027e-06,  -6.405726179691158e-09,
  -6.195188606764485e-10,  -1.333690006181748e-11,   3.516073984074672e-13,   2.216813924090224e-14,  -1.684039621964303e-16,   1.269638594777433e+00,  -1.249478329594965e-02,
   3.009637746647459e-05,   1.859863889960621e-06,  -6.414123772750638e-09,  -6.192073491316326e-10,  -1.331079501154968e-11,   3.513505284152241e-13,   2.212059412417435e-14,
  -1.685460665569400e-16,   1.269638805338726e+00,  -1.249474425813016e-02,   3.009610547476860e-05,   1.859820583044383e-06,  -6.415515264058375e-09,  -6.191557189918570e-10,
  -1.330646953037637e-11,   3.513079417808127e-13,   2.211271705317644e-14,  -1.685695434081685e-16,   1.645622497700347e+00,  -1.393600565276121e-02,  -1.079464188732239e-04,
   5.674755169957853e-06,   5.746083697581930e-08,  -4.834007249111911e-09,  -4.881180699042029e-11,   4.662969678535633e-12,   5.252602553501421e-14,  -4.638069753659505e-15,
   1.645607233627694e+00,  -1.393360685195202e-02,  -1.078979319466339e-04,   5.667990280760886e-06,   5.735902501890365e-08,  -4.820435415072666e-09,  -4.861032756609885e-11,
   4.640124810880217e-12,   5.214647670133720e-14,  -4.603693245961389e-15,   1.645582180076907e+00,  -1.392967089294362e-02,  -1.078183948883148e-04,   5.656898429387651e-06,
   5.719219094005410e-08,  -4.798203806343566e-09,  -4.828064204968673e-11,   4.602746564183489e-12,   5.152644544590711e-14,  -4.547522747471280e-15,   1.645555602972207e+00,
  -1.392549733465425e-02,  -1.077340841902442e-04,   5.645147858309630e-06,   5.701558305568587e-08,  -4.774680464137208e-09,  -4.793227724842373e-11,   4.563255119815688e-12,
   5.087268385254108e-14,  -4.488278970093089e-15,   1.645534691462573e+00,  -1.392221474668353e-02,  -1.076677921601372e-04,   5.635913644442469e-06,   5.687689219070918e-08,
  -4.756215222602944e-09,  -4.765916350007016e-11,   4.532297644507697e-12,   5.036115249126953e-14,  -4.441911465019602e-15,   1.645522624949238e+00,  -1.392032111183884e-02,
  -1.076295581316368e-04,   5.630589822481448e-06,   5.679697119182494e-08,  -4.745577674336228e-09,  -4.750196435461979e-11,   4.514480447548199e-12,   5.006712844791157e-14,
  -4.415254775179139e-15,   1.645518094217761e+00,  -1.391961018631568e-02,  -1.076152054821587e-04,   5.628591698647747e-06,   5.676698275573590e-08,  -4.741586775486202e-09,
  -4.744301377741850e-11,   4.507799152080656e-12,   4.995694398178007e-14,  -4.405264328067951e-15,   1.645517343203381e+00,  -1.391949234831398e-02,  -1.076128265681055e-04,
   5.628260535035183e-06,   5.676201293973164e-08,  -4.740925417015960e-09,  -4.743324605348086e-11,   4.506692118735007e-12,   4.993869115810466e-14,  -4.403609291063561e-15,
   2.231157313508790e-03,  -2.373416103964532e-05,   2.035363561870789e-07,  -7.811663078640333e-10,   7.453357014221442e-12,  -5.762031660685357e-13,  -1.346132489949605e-15,
   4.826234308863372e-16,   3.281220039591953e-18,  -4.474101853257118e-19,   2.231186290994236e-03,  -2.373449738947741e-05,   2.035427048224284e-07,  -7.819744388594510e-10,
   7.450631459854574e-12,  -5.747960472804693e-13,  -1.333614053120572e-15,   4.804119299544351e-16,   3.254223641667580e-18,  -4.443880094850085e-19,   2.231233862878390e-03,
  -2.373504980878700e-05,   2.035531254996876e-07,  -7.832996839495720e-10,   7.446176042006266e-12,  -5.724907587980345e-13,  -1.313139513507374e-15,   4.767924261097647e-16,
   3.210122643079672e-18,  -4.394475544797125e-19,   2.231284341210539e-03,  -2.373563630331914e-05,   2.035641804277283e-07,  -7.847039268585777e-10,   7.441474286231345e-12,
  -5.700510779077309e-13,  -1.291518074819255e-15,   4.729668052836652e-16,   3.163623041313974e-18,  -4.342336977869679e-19,   2.231324068564904e-03,  -2.373609811992449e-05,
   2.035728791147618e-07,  -7.858076675625333e-10,   7.437792600100814e-12,  -5.681356659040934e-13,  -1.274576653705307e-15,   4.699668146580975e-16,   3.127240190795621e-18,
  -4.301508072245735e-19,   2.231346996255168e-03,  -2.373636474039326e-05,   2.035778986576466e-07,  -7.864440950534526e-10,   7.435675274566348e-12,  -5.670320966506830e-13,
  -1.264829310273482e-15,   4.682397769820325e-16,   3.106327826612570e-18,  -4.278026583246387e-19,   2.231355605879468e-03,  -2.373646487737148e-05,   2.035797834252353e-07,
  -7.866829736007323e-10,   7.434881603479387e-12,  -5.666180451616721e-13,  -1.261174723505346e-15,   4.675920715647082e-16,   3.098491032778210e-18,  -4.269224455075893e-19,
   2.231357033050496e-03,  -2.373648147747635e-05,   2.035800958460797e-07,  -7.867225655331514e-10,   7.434750115245911e-12,  -5.665494286413788e-13,  -1.260569220593930e-15,
   4.674847480527659e-16,   3.097192815527083e-18,  -4.267766188208905e-19,   2.013522381642939e-02,  -2.141081912451891e-04,   1.830987060680238e-06,  -6.854938167089421e-09,
   6.481448592615808e-11,  -5.218847444738597e-12,  -1.246400933246829e-14,   4.403453051108916e-15,   2.981837585355375e-17,  -4.083248547685091e-18,   2.013548449034082e-02,
  -2.141111436043693e-04,   1.831042259680585e-06,  -6.862256865976532e-09,   6.478922412234114e-11,  -5.206008973596468e-12,  -1.235026061673607e-14,   4.383270736650459e-15,
   2.957237622333930e-17,  -4.055638661831286e-18,   2.013591243442253e-02,  -2.141159926131018e-04,   1.831132862609166e-06,  -6.874258622567605e-09,   6.474792560742224e-11,
  -5.184975663220929e-12,  -1.216422076768649e-14,   4.350238992992103e-15,   2.917051742678677e-17,  -4.010504047253240e-18,   2.013636652387314e-02,  -2.141211408192709e-04,
   1.831228978767623e-06,  -6.886975671915418e-09,   6.470433899201940e-11,  -5.162716177647742e-12,  -1.196776238992796e-14,   4.315326359851422e-15,   2.874680647005520e-17,
  -3.962872005727723e-18,   2.013672390023539e-02,  -2.141251946789550e-04,   1.831304607854800e-06,  -6.896971229767029e-09,   6.467020528072133e-11,  -5.145240095621357e-12,
  -1.181382986780414e-14,   4.287948534773457e-15,   2.841528401991258e-17,  -3.925572302927935e-18,   2.013693015135833e-02,  -2.141275351197053e-04,   1.831348248948254e-06,
  -6.902734726242716e-09,   6.465057371599917e-11,  -5.135171212408732e-12,  -1.172526468127489e-14,   4.272187681642773e-15,   2.822473075115565e-17,  -3.904120611348864e-18,
   2.013700760112854e-02,  -2.141284141445644e-04,   1.831364635493426e-06,  -6.904898006571092e-09,   6.464321464029542e-11,  -5.131393438324637e-12,  -1.169205894238939e-14,
   4.266276764561566e-15,   2.815332220293134e-17,  -3.896079376743995e-18,   2.013702043955885e-02,  -2.141285598642771e-04,   1.831367351738832e-06,  -6.905256550101141e-09,
   6.464199544151072e-11,  -5.130767386483383e-12,  -1.168655732352122e-14,   4.265297337654132e-15,   2.814149291278688e-17,  -3.894747169541708e-18,   5.624123687114894e-02,
  -5.975661933618298e-04,   5.080468461355886e-06,  -1.801861037040654e-08,   1.668364459758266e-10,  -1.468758057402692e-11,  -3.659891754280169e-14,   1.257807108536943e-14,
   8.447665586372069e-17,  -1.167088278466541e-17,   5.624196014475252e-02,  -5.975739585950844e-04,   5.080610494476629e-06,  -1.803920309063805e-08,   1.667621281047650e-10,
  -1.465090913186804e-11,  -3.627674169012511e-14,   1.252038971472106e-14,   8.377588249877734e-17,  -1.159180025312659e-17,   5.624314753000778e-02,  -5.975867127650418e-04,
   5.080843620172656e-06,  -1.807297203507177e-08,   1.666406127472182e-10,  -1.459083025302489e-11,  -3.574982352160363e-14,   1.242598509625406e-14,   8.263113640086947e-17,
  -1.146252323221276e-17,   5.624440745735237e-02,  -5.976002544578861e-04,   5.081090924022914e-06,  -1.810875281764219e-08,   1.665123391141414e-10,  -1.452724905798440e-11,
  -3.519341238816795e-14,   1.232620574452549e-14,   8.142416819329025e-17,  -1.132609470027486e-17,   5.624539904114158e-02,  -5.976109180144319e-04,   5.081285509754136e-06,
  -1.813687584365327e-08,   1.664118662221210e-10,  -1.447733107082415e-11,  -3.475745441747555e-14,   1.224796127715891e-14,   8.047982411492022e-17,  -1.121926150163442e-17,
   5.624597130928730e-02,  -5.976170746343290e-04,   5.081397791510036e-06,  -1.815309152333953e-08,   1.663540729842511e-10,  -1.444857073860680e-11,  -3.450663012100376e-14,
   1.220291778355694e-14,   7.993703943436567e-17,  -1.115782042425505e-17,   5.624618620275357e-02,  -5.976193869735342e-04,   5.081439951127997e-06,  -1.815917790190718e-08,
   1.663324072186228e-10,  -1.443778006940049e-11,  -3.441258942396149e-14,   1.218602481282859e-14,   7.973363599695745e-17,  -1.113478913727737e-17,   5.624622182447889e-02,
  -5.976197703014988e-04,   5.081446939514280e-06,  -1.816018666017418e-08,   1.663288177147375e-10,  -1.443599184247292e-11,  -3.439700854480266e-14,   1.218322568445178e-14,
   7.969994097194149e-17,  -1.113097350356962e-17,   1.111730268092816e-01,  -1.179722641524653e-03,   9.936139634860159e-06,  -3.205518637823752e-08,   2.848891354454778e-10,
  -2.938817997299308e-11,  -7.772545054812795e-14,   2.574451659636863e-14,   1.706842081253820e-16,  -2.391773776639940e-17,   1.111744412823087e-01,  -1.179736471984581e-03,
   9.936381993081444e-06,  -3.209637592073159e-08,   2.847309097379742e-10,  -2.931312378249126e-11,  -7.707474333393381e-14,   2.562632158882064e-14,   1.692563070901260e-16,
  -2.375512670003525e-17,   1.111767633935614e-01,  -1.179759189486385e-03,   9.936779768111088e-06,  -3.216391880009827e-08,   2.844721450629772e-10,  -2.919015939664395e-11,
  -7.601054770899697e-14,   2.543287892618749e-14,   1.669238280010118e-16,  -2.348930901310294e-17,   1.111792273668630e-01,  -1.179783311573876e-03,   9.937201709086694e-06,
  -3.223548329414235e-08,   2.841989157263528e-10,  -2.906002714870161e-11,  -7.488683399580571e-14,   2.522842574343593e-14,   1.644646549704095e-16,  -2.320879228228279e-17,
   1.111811665512635e-01,  -1.179802308127132e-03,   9.937533685656221e-06,  -3.229172994052483e-08,   2.839848503400991e-10,  -2.895785979665427e-11,  -7.400641889770991e-14,
   2.506810066018531e-14,   1.625406359047712e-16,  -2.298913200785644e-17,   1.111822857023062e-01,  -1.179813276354157e-03,   9.937725238553340e-06,  -3.232416095804741e-08,
   2.838616959873310e-10,  -2.889899601508942e-11,  -7.349989421326507e-14,   2.497580608492871e-14,   1.614347843268589e-16,  -2.286280437493583e-17,   1.111827059565047e-01,
  -1.179817395966679e-03,   9.937797161536107e-06,  -3.233633345747078e-08,   2.838155233408168e-10,  -2.887691076955935e-11,  -7.330998725474016e-14,   2.494119236616013e-14,
   1.610203816199567e-16,  -2.281545057398578e-17,   1.111827756197513e-01,  -1.179818078900696e-03,   9.937809083429114e-06,  -3.233835092446438e-08,   2.838078734142923e-10,
  -2.887325080943903e-11,  -7.327852317051435e-14,   2.493545695640233e-14,   1.609517335237002e-16,  -2.280760540339740e-17,   1.859431944994355e-01,  -1.969513173355612e-03,
   1.635910984742910e-05,  -4.490512491685536e-08,   3.665257833529928e-10,  -5.004639999032433e-11,  -1.421692379846279e-13,   4.522121135360123e-14,   2.943034234438822e-16,
  -4.211004571910566e-17,   1.859455231469744e-01,  -1.969532591815406e-03,   1.635942116546390e-05,  -4.497523456036755e-08,   3.662355554264955e-10,  -4.991456798623904e-11,
  -1.410478399162665e-13,   4.501315155093177e-14,   2.918126263378012e-16,  -4.182236345494568e-17,   1.859493460306606e-01,  -1.969564491736267e-03,   1.635993206947802e-05,
  -4.509019666077255e-08,   3.657608024068713e-10,  -4.969858886610721e-11,  -1.392139395709296e-13,   4.467263774057621e-14,   2.877440689585462e-16,  -4.135210506025871e-17,
   1.859534024490510e-01,  -1.969598369048022e-03,   1.636047394095465e-05,  -4.521199815830266e-08,   3.652593615145468e-10,  -4.947002113968952e-11,  -1.372775873833988e-13,
   4.431274929139256e-14,   2.834547413444308e-16,  -4.085585768184112e-17,   1.859565949030138e-01,  -1.969625051671647e-03,   1.636090022538094e-05,  -4.530772487086489e-08,
   3.648663918825217e-10,  -4.929057262476079e-11,  -1.357605631213980e-13,   4.403054232071512e-14,   2.800989983919678e-16,  -4.046727916292324e-17,   1.859584373431966e-01,
  -1.969640459148105e-03,   1.636114617394999e-05,  -4.536291789819333e-08,   3.646402681177413e-10,  -4.918718362510948e-11,  -1.348878144294744e-13,   4.386808584120370e-14,
   2.781703117893654e-16,  -4.024381023437447e-17,   1.859591292001828e-01,  -1.969646246398112e-03,   1.636123851715174e-05,  -4.538363346980120e-08,   3.645554822274843e-10,
  -4.914839292448618e-11,  -1.345606084921946e-13,   4.380715931689570e-14,   2.774475751040910e-16,  -4.016004392886082e-17,   1.859592438855067e-01,  -1.969647205801468e-03,
   1.636125382367744e-05,  -4.538706684711755e-08,   3.645414343863742e-10,  -4.914196454515168e-11,  -1.345063968264822e-13,   4.379706395881160e-14,   2.773278504233565e-16,
  -4.014616629103951e-17,   2.820671415564446e-01,  -2.979889653696870e-03,   2.425982858192137e-05,  -4.939122968848110e-08,   3.190323755635862e-10,  -7.792309410402920e-11,
  -2.386176644622506e-13,   7.327083937029936e-14,   4.646979632298862e-16,  -6.851524275011072e-17,   2.820705944504842e-01,  -2.979911124958742e-03,   2.426009822865782e-05,
  -4.950032156732779e-08,   3.185439218190686e-10,  -7.770951080654686e-11,  -2.368482294282795e-13,   7.293239893077370e-14,   4.607051858294936e-16,  -6.804400468093947e-17,
   2.820762629623438e-01,  -2.979946406755117e-03,   2.426054060256521e-05,  -4.967919608863278e-08,   3.177447325536332e-10,  -7.735960216690783e-11,  -2.339547242648295e-13,
   7.237851397844108e-14,   4.541836171507722e-16,  -6.727372387527825e-17,   2.820822777288841e-01,  -2.979983888614918e-03,   2.426100959563773e-05,  -4.986870064695522e-08,
   3.169003728600126e-10,  -7.698930253255295e-11,  -2.308998094370958e-13,   7.179312989669716e-14,   4.473086825238789e-16,  -6.646090869613154e-17,   2.820870114087937e-01,
  -2.980013419694935e-03,   2.426137840685910e-05,  -5.001762836167695e-08,   3.162384867715489e-10,  -7.669858308390653e-11,  -2.285066253214512e-13,   7.133411176732822e-14,
   4.419304663496140e-16,  -6.582447243879411e-17,   2.820897433188680e-01,  -2.980030475740872e-03,   2.426159113949472e-05,  -5.010349203335552e-08,   3.158575509424780e-10,
  -7.653108661099594e-11,  -2.271298879999511e-13,   7.106987602414389e-14,   4.388395269590465e-16,  -6.545847240103811e-17,   2.820907691803142e-01,  -2.980036882927290e-03,
   2.426167100090531e-05,  -5.013571856209860e-08,   3.157147042206793e-10,  -7.646824352470971e-11,  -2.266137425388049e-13,   7.097077979797815e-14,   4.376812871997220e-16,
  -6.532128089328423e-17,   2.820909392316409e-01,  -2.980037945140510e-03,   2.426168423792736e-05,  -5.014105971969301e-08,   3.156910357950066e-10,  -7.645782920474993e-11,
  -2.265282279514574e-13,   7.095435987081585e-14,   4.374894208877830e-16,  -6.529855235690688e-17,   4.017632368608969e-01,  -4.228871457018750e-03,   3.343659678308348e-05,
  -3.250843743898269e-08,  -2.528769663729462e-11,  -1.153128228151721e-10,  -3.762912387672342e-13,   1.138674842951963e-13,   6.964432601255640e-16,  -1.072727406742882e-16,
   4.017679950820065e-01,  -4.228885904910198e-03,   3.343657083310664e-05,  -3.266974177036680e-08,  -2.605963735914609e-11,  -1.149809601830614e-10,  -3.736417472427498e-13,
   1.133377797455078e-13,   6.903437473030746e-16,  -1.065279831763751e-16,   4.017758064689146e-01,  -4.228909672586466e-03,   3.343652776547291e-05,  -3.293421108459644e-08,
  -2.732288144640358e-11,  -1.144372852921312e-10,  -3.693094491315962e-13,   1.124709015762368e-13,   6.803819884780539e-16,  -1.053106697553891e-16,   4.017840949499231e-01,
  -4.228934958635969e-03,   3.343648143464126e-05,  -3.321437493059977e-08,  -2.865782986282498e-11,  -1.138619385940130e-10,  -3.647359383001613e-13,   1.115547595561177e-13,
   6.698815813294769e-16,  -1.040262175118847e-16,   4.017906180249592e-01,  -4.228954907144296e-03,   3.343644451495486e-05,  -3.343453385148567e-08,  -2.970450576173494e-11,
  -1.134102461533079e-10,  -3.611534349073928e-13,   1.108364089809014e-13,   6.616679916697638e-16,  -1.030205462938103e-16,   4.017943826178810e-01,  -4.228966439146865e-03,
   3.343642302500574e-05,  -3.356145915163674e-08,  -3.030698904794654e-11,  -1.131500091072855e-10,  -3.590926452703938e-13,   1.104228975276268e-13,   6.569478458373520e-16,
  -1.024422308159336e-16,   4.017957962597235e-01,  -4.228970773180038e-03,   3.343641492079149e-05,  -3.360909579820352e-08,  -3.053293048114347e-11,  -1.130523712361300e-10,
  -3.583200703344559e-13,   1.102678204015419e-13,   6.551791695091886e-16,  -1.022254593379988e-16,   4.017960305910811e-01,  -4.228971491800665e-03,   3.343641357558164e-05,
  -3.361699093237259e-08,  -3.057036784876096e-11,  -1.130361907760337e-10,  -3.581920720276254e-13,   1.102421247193856e-13,   6.548861855559087e-16,  -1.021895470077850e-16,
   5.483149924602396e-01,  -5.740980208769165e-03,   4.342788862134485e-05,   3.080842763812621e-08,  -9.877207844225616e-10,  -1.668567628704105e-10,  -5.542401063885698e-13,
   1.744494394438250e-13,   1.011183043098648e-15,  -1.665674470186104e-16,   5.483211708588416e-01,  -5.740967878897978e-03,   4.342703883814851e-05,   3.057525760263882e-08,
  -9.888584923284269e-10,  -1.663485034138237e-10,  -5.503976428989048e-13,   1.736273539453013e-13,   1.002111613976482e-15,  -1.653954554984367e-16,   5.483313136119533e-01,
  -5.740947708371863e-03,   4.342564309361299e-05,   3.019298861467527e-08,  -9.907203940955356e-10,  -1.655158687741236e-10,  -5.441152929009889e-13,   1.722820430483227e-13,
   9.872979310283960e-16,  -1.634799613982574e-16,   5.483420757371763e-01,  -5.740926402229861e-03,   4.342416116781275e-05,   2.978807383172034e-08,  -9.926881138897071e-10,
  -1.646347599438942e-10,  -5.374840069253329e-13,   1.708603578600930e-13,   9.716857221548331e-16,  -1.614590076732181e-16,   5.483505454995655e-01,  -5.740909703873327e-03,
   4.342299421043519e-05,   2.946991138350398e-08,  -9.942310153110555e-10,  -1.639430425514548e-10,  -5.322902306698719e-13,   1.697456655090292e-13,   9.594753841080632e-16,
  -1.598768215804382e-16,   5.483554335302944e-01,  -5.740900094837969e-03,   4.342232046684411e-05,   2.928649683746562e-08,  -9.951191727986556e-10,  -1.635445270423961e-10,
  -5.293028229308886e-13,   1.691040264546913e-13,   9.524591212368805e-16,  -1.589670325075794e-16,   5.483572690278667e-01,  -5.740896491822803e-03,   4.342206741851485e-05,
   2.921766123307225e-08,  -9.954522542715506e-10,  -1.633950104150738e-10,  -5.281829121620257e-13,   1.688634000552608e-13,   9.498302065735305e-16,  -1.586260240713865e-16,
   5.483575732875156e-01,  -5.740895894849584e-03,   4.342202546944785e-05,   2.920625277041024e-08,  -9.955074445987439e-10,  -1.633702327434911e-10,  -5.279973705654734e-13,
   1.688235294137240e-13,   9.493947299412411e-16,  -1.585695300540658e-16,   7.267754286923594e-01,  -7.548598300547181e-03,   5.311210248514128e-05,   1.939552690148370e-07,
  -3.241624714851863e-09,  -2.437484188331536e-10,  -7.060728732917080e-13,   2.704882709130274e-13,   1.432501484892408e-15,  -2.648015569453622e-16,   7.267829813521770e-01,
  -7.548516697503701e-03,   5.310932649885924e-05,   1.936150277968326e-07,  -3.243067730614525e-09,  -2.429608445339566e-10,  -7.006378111911195e-13,   2.691823625215835e-13,
   1.419238293729926e-15,  -2.629002915222566e-16,   7.267953799791605e-01,  -7.548382836342586e-03,   5.310476839761340e-05,   1.930572682435426e-07,  -3.245428432888422e-09,
  -2.416707018848933e-10,  -6.917527929894359e-13,   2.670454358885241e-13,   1.397583672704636e-15,  -2.597932224608293e-16,   7.268085354913724e-01,  -7.548240939757047e-03,
   5.309993071953690e-05,   1.924665299599546e-07,  -3.247922150660532e-09,  -2.403055418465919e-10,  -6.823759035563656e-13,   2.647873861283097e-13,   1.374767493180219e-15,
  -2.565155569899122e-16,   7.268188886667382e-01,  -7.548129367985477e-03,   5.309612258898558e-05,   1.920024021394903e-07,  -3.249876656921338e-09,  -2.392338849142552e-10,
  -6.750328787478248e-13,   2.630170687489491e-13,   1.356927050341745e-15,  -2.539498394913447e-16,   7.268248635736927e-01,  -7.548065018421121e-03,   5.309392450136317e-05,
   1.917348596909672e-07,  -3.251001416809521e-09,  -2.386165034459114e-10,  -6.708097135723164e-13,   2.619980942801952e-13,   1.346677290485306e-15,  -2.524746345534221e-16,
   7.268271071893087e-01,  -7.548040862205956e-03,   5.309309903323142e-05,   1.916344542925288e-07,  -3.251423166938649e-09,  -2.383848768487390e-10,  -6.692266341325988e-13,
   2.616159706426851e-13,   1.342837133497116e-15,  -2.519217215536759e-16,   7.268274790995848e-01,  -7.548036858372904e-03,   5.309296219667914e-05,   1.916178137957219e-07,
  -3.251493045987229e-09,  -2.383464923011080e-10,  -6.689643615768751e-13,   2.615526551380301e-13,   1.342201032481795e-15,  -2.518301231759946e-16,   9.455067389346075e-01,
  -9.689582663308584e-03,   5.940271958404891e-05,   5.900638945765629e-07,  -8.391438290280551e-09,  -3.818287121523675e-10,  -3.699236594716468e-13,   4.401565101441883e-13,
   1.896800852436033e-15,  -4.524868229673069e-16,   9.455151779614530e-01,  -9.689332631519011e-03,   5.939555065178509e-05,   5.895312988574749e-07,  -8.392143236575054e-09,
  -3.805487573935233e-10,  -3.627479494839269e-13,   4.379280245767062e-13,   1.878210247359644e-15,  -4.491237056222863e-16,   9.455290312522400e-01,  -9.688922325695582e-03,
   5.938378128046756e-05,   5.886582586372251e-07,  -8.393289650279729e-09,  -3.784522601718015e-10,  -3.510203837649027e-13,   4.342818614642908e-13,   1.847868355648160e-15,
  -4.436286826792870e-16,   9.455437296620928e-01,  -9.688487179221021e-03,   5.937129251584760e-05,   5.877336621566363e-07,  -8.394491354702940e-09,  -3.762341635576590e-10,
  -3.386476373948487e-13,   4.304296060365043e-13,   1.815913435522701e-15,  -4.378333317653650e-16,   9.455552966621426e-01,  -9.688144875569569e-03,   5.936146339559475e-05,
   5.870072769053824e-07,  -8.395426472381462e-09,  -3.744931678367019e-10,  -3.289614880697999e-13,   4.274098425991875e-13,   1.790937702348650e-15,  -4.332977962166663e-16,
   9.455619719131410e-01,  -9.687947389082309e-03,   5.935579065993320e-05,   5.865885769894849e-07,  -8.395961897293603e-09,  -3.734902686077053e-10,  -3.233919012421641e-13,
   4.256718675335157e-13,   1.776592741801049e-15,  -4.306904075915594e-16,   9.455644784812822e-01,  -9.687873242965222e-03,   5.935366046149904e-05,   5.864314475515908e-07,
  -8.396162152755321e-09,  -3.731140217454778e-10,  -3.213043283816526e-13,   4.250201442754134e-13,   1.771219076281403e-15,  -4.297132225733954e-16,   9.455648939779293e-01,
  -9.687860952819092e-03,   5.935330734904883e-05,   5.864054061892922e-07,  -8.396195305692393e-09,  -3.730516719893223e-10,  -3.209584868510750e-13,   4.249121594500057e-13,
   1.770328999744583e-15,  -4.295513411009887e-16,   1.220228677134397e+00,  -1.217231478674161e-02,   5.146806649737745e-05,   1.652783060443455e-06,  -2.089250194621668e-08,
  -7.689789721479517e-10,   4.204281705365495e-12,   8.158579190586270e-13,   7.615377085663537e-16,  -9.200516485189321e-16,   1.220235965648393e+00,  -1.217161296906712e-02,
   5.145027860131179e-05,   1.651708661151299e-06,  -2.088349570683145e-08,  -7.666126083734391e-10,   4.206992019376688e-12,   8.113409514944275e-13,   7.457452176425162e-16,
  -9.126741124868834e-16,   1.220247929102654e+00,  -1.217046114863564e-02,   5.142108245821602e-05,   1.649947265086209e-06,  -2.086870649552526e-08,  -7.627374691591394e-10,
   4.211397006985680e-12,   8.039524726922168e-13,   7.200028447018473e-16,  -9.006242078407428e-16,   1.220260620777665e+00,  -1.216923942196942e-02,   5.139011066122768e-05,
   1.648081549943307e-06,  -2.085300858378717e-08,  -7.586387033194249e-10,   4.216010938366665e-12,   7.961490998673415e-13,   6.929362133720212e-16,  -8.879215482423712e-16,
   1.220270607401177e+00,  -1.216827823769782e-02,   5.136574117420534e-05,   1.646615580050724e-06,  -2.084065035264435e-08,  -7.554223815807677e-10,   4.219598834959313e-12,
   7.900340438833548e-13,   6.718130670530844e-16,  -8.779844427005432e-16,   1.220276370158883e+00,  -1.216772364804316e-02,   5.135167926368205e-05,   1.645770483872036e-06,
  -2.083351662511501e-08,  -7.535699507315901e-10,   4.221652199941336e-12,   7.865154118969868e-13,   6.596936397609753e-16,  -8.722734792047340e-16,   1.220278533996005e+00,
  -1.216751541840453e-02,   5.134639929173949e-05,   1.645453320060583e-06,  -2.083083754752141e-08,  -7.528750563838631e-10,   4.222420001434527e-12,   7.851961088747714e-13,
   6.551560789255158e-16,  -8.701334678203782e-16,   1.220278892675822e+00,  -1.216748090264256e-02,   5.134552408272299e-05,   1.645400755016242e-06,  -2.083039343668728e-08,
  -7.527599052293213e-10,   4.222547103887210e-12,   7.849775197859611e-13,   6.544046193469242e-16,  -8.697789680563798e-16,   1.588594747355181e+00,  -1.451909351519981e-02,
  -3.760471665992115e-05,   5.802784755817851e-06,  -4.006014572553586e-08,  -4.409708955879281e-09,   7.922054590117515e-11,   3.616265466172817e-12,  -1.073253374888608e-13,
  -2.920828624262876e-15,   1.588589329024576e+00,  -1.451663801639692e-02,  -3.763799362229210e-05,   5.796598499503648e-06,  -3.989590420002092e-08,  -4.399132975174627e-09,
   7.880917329254864e-11,   3.601750016717310e-12,  -1.065353492988913e-13,  -2.904051994280000e-15,   1.588580430682345e+00,  -1.451260880573516e-02,  -3.769252331635864e-05,
   5.786453540733239e-06,  -3.962690124425666e-08,  -4.381801854244743e-09,   7.813607965980875e-11,   3.577981998387756e-12,  -1.052444018924752e-13,  -2.876600583784000e-15,
   1.588570984406934e+00,  -1.450833606598784e-02,  -3.775024807375650e-05,   5.775703591868157e-06,  -3.934231735189548e-08,  -4.363454340407690e-09,   7.742491182393529e-11,
   3.552845615717503e-12,  -1.038826553310748e-13,  -2.847594747003149e-15,   1.588563546923288e+00,  -1.450497525247644e-02,  -3.779557984595084e-05,   5.767253909209336e-06,
  -3.911896158924023e-08,  -4.349045208033486e-09,   7.686741025868982e-11,   3.533123335081931e-12,  -1.028167552500659e-13,  -2.824855280017916e-15,   1.588559253318581e+00,
  -1.450303640444178e-02,  -3.782170250254381e-05,   5.762381670066472e-06,  -3.899030395216767e-08,  -4.340741606196047e-09,   7.654654118139871e-11,   3.521765299368223e-12,
  -1.022039206324190e-13,  -2.811767203197141e-15,   1.588557640784138e+00,  -1.450230848813523e-02,  -3.783150441786671e-05,   5.760552896303155e-06,  -3.894203804480281e-08,
  -4.337625822999216e-09,   7.642621693747081e-11,   3.517504789452681e-12,  -1.019742321083351e-13,  -2.806859166352620e-15,   1.588557373470648e+00,  -1.450218783299410e-02,
  -3.783312883530160e-05,   5.760249793091338e-06,  -3.893403972170030e-08,  -4.337109458715275e-09,   7.640628018437011e-11,   3.516798788606445e-12,  -1.019361809754757e-13,
  -2.806045940452135e-15,   2.139419603473282e-03,  -2.214220309446829e-05,   1.945045440609986e-07,  -7.512477662141524e-10,  -3.302533932829007e-12,  -4.496784728590503e-13,
   1.118451627665487e-14,   3.322230938068456e-16,  -1.155981790301769e-17,  -2.646359035340135e-19,   2.139447277495990e-03,  -2.214252604895729e-05,   1.945018562337848e-07,
  -7.518795051228314e-10,  -3.279186363787465e-12,  -4.487065914152262e-13,   1.113996888048764e-14,   3.309070023373507e-16,  -1.148640245689229e-17,  -2.631513689041513e-19,
   2.139492708629015e-03,  -2.214305642406378e-05,   1.944974579727005e-07,  -7.529156158421468e-10,  -3.240925479793827e-12,  -4.471139077990213e-13,   1.106704576864734e-14,
   3.287518619655293e-16,  -1.136636528790901e-17,  -2.607222486360247e-19,   2.139540914228152e-03,  -2.214361945524644e-05,   1.944928104115794e-07,  -7.540136642003985e-10,
  -3.200419871502486e-12,  -4.454277696158966e-13,   1.098995152145830e-14,   3.264724643953292e-16,  -1.123965493769544e-17,  -2.581555873162938e-19,   2.139578852039366e-03,
  -2.214406275345935e-05,   1.944891667370121e-07,  -7.548768613068560e-10,  -3.168608324765464e-12,  -4.441035323890234e-13,   1.092948211079124e-14,   3.246838921132328e-16,
  -1.114040803730273e-17,  -2.561434261022546e-19,   2.139600746592616e-03,  -2.214431866553059e-05,   1.944870694993896e-07,  -7.553746397275440e-10,  -3.150275902596288e-12,
  -4.433403948425763e-13,   1.089466567611447e-14,   3.236538026851733e-16,  -1.108332042713094e-17,  -2.549852940046931e-19,   2.139608968196306e-03,  -2.214441477741863e-05,
   1.944862830232352e-07,  -7.555614869014611e-10,  -3.143396926328975e-12,  -4.430540378890621e-13,   1.088160716713496e-14,   3.232673960763577e-16,  -1.106191924771398e-17,
  -2.545509937972303e-19,   2.139610331043811e-03,  -2.214443071009726e-05,   1.944861527093223e-07,  -7.555924556149050e-10,  -3.142256902802283e-12,  -4.430065811346631e-13,
   1.087944334465326e-14,   3.232033648565991e-16,  -1.105837358199039e-17,  -2.544790334214027e-19,   1.930758042219782e-02,  -1.997795306882779e-04,   1.751568227236572e-06,
  -6.627096890464190e-09,  -3.259962346344298e-11,  -4.069247071207662e-12,   1.018111679311501e-13,   3.027515707137450e-15,  -1.055507724341365e-16,  -2.410491273413413e-18,
   1.930782962968660e-02,  -1.997823801222066e-04,   1.751541593928126e-06,  -6.632813123559070e-09,  -3.238710827803812e-11,  -4.060390324755684e-12,   1.014044206214433e-13,
   3.015527846445036e-15,  -1.048800584761893e-16,  -2.396967892287274e-18,   1.930823874157594e-02,  -1.997870596757840e-04,   1.751498000673850e-06,  -6.642188214833869e-09,
  -3.203885044202601e-11,  -4.045876201792552e-12,   1.007385852476801e-13,   2.995897359609941e-15,  -1.037834184806623e-16,  -2.374839761560972e-18,   1.930867283747291e-02,
  -1.997920274161399e-04,   1.751451920835701e-06,  -6.652123652458588e-09,  -3.167016331636843e-11,  -4.030510410998531e-12,   1.000346661386232e-13,   2.975135060121439e-15,
  -1.026258187421186e-16,  -2.351458645447351e-18,   1.930901447074234e-02,  -1.997959387703689e-04,   1.751415783008679e-06,  -6.659934029626526e-09,  -3.138061252393644e-11,
  -4.018442614545779e-12,   9.948254331241122e-14,   2.958843535167612e-15,  -1.017191233038148e-16,  -2.333128735743221e-18,   1.930921163298930e-02,  -1.997981967770359e-04,
   1.751394978115932e-06,  -6.664438001406206e-09,  -3.121375037021344e-11,  -4.011488124253022e-12,   9.916464831381789e-14,   2.949460786537776e-15,  -1.011975863873968e-16,
  -2.322578643479742e-18,   1.930928566918608e-02,  -1.997990448109210e-04,   1.751387175296298e-06,  -6.666128617122989e-09,  -3.115113790404970e-11,  -4.008878545735500e-12,
   9.904541634748675e-14,   2.945941135138798e-15,  -1.010020713109300e-16,  -2.318622349995167e-18,   1.930929794173554e-02,  -1.997991853915292e-04,   1.751385882374835e-06,
  -6.666408825517399e-09,  -3.114076141347963e-11,  -4.008446071025152e-12,   9.902565936330304e-14,   2.945357895723482e-15,  -1.009696791346698e-16,  -2.317966820882893e-18,
   5.393092515013072e-02,  -5.577639955416430e-04,   4.870742329952892e-06,  -1.762681980993172e-08,  -1.072791934000937e-10,  -1.143039263599429e-11,   2.894956701272132e-13,
   8.625847311741052e-15,  -3.019800271430012e-16,  -6.861667040401703e-18,   5.393161811527274e-02,  -5.577715774939045e-04,   4.870654146677995e-06,  -1.764287353453801e-08,
  -1.066749994008965e-10,  -1.140515794221225e-11,   2.883320146540388e-13,   8.591722975694923e-15,  -3.000588781039285e-16,  -6.823167259827840e-18,   5.393275572121227e-02,
  -5.577840294001907e-04,   4.870509748084548e-06,  -1.766920259173822e-08,  -1.056848915601587e-10,  -1.136380415057930e-11,   2.864271456240286e-13,   8.535843354815033e-15,
  -2.969177577912813e-16,  -6.760170324290198e-18,   5.393396279752213e-02,  -5.577972484966631e-04,   4.870357030280039e-06,  -1.769710482816461e-08,  -1.046367175938182e-10,
  -1.132002368609111e-11,   2.844133326762073e-13,   8.476741971502343e-15,  -2.936020612536179e-16,  -6.693605906764277e-18,   5.393491276460045e-02,  -5.578076568148313e-04,
   4.870237202305866e-06,  -1.771903877793043e-08,  -1.038135383082896e-10,  -1.128563985485506e-11,   2.828337937083216e-13,   8.430366989160854e-15,  -2.910050491300620e-16,
  -6.641421681998339e-18,   5.393546100584746e-02,  -5.578136655896792e-04,   4.870168192089774e-06,  -1.773168717555232e-08,  -1.033391613996886e-10,  -1.126582494134143e-11,
   2.819243472516379e-13,   8.403658336732450e-15,  -2.895112405411185e-16,  -6.611386064900681e-18,   5.393566687525860e-02,  -5.578159223092151e-04,   4.870142305427605e-06,
  -1.773643486429273e-08,  -1.031611595559534e-10,  -1.125838965771879e-11,   2.815832442498899e-13,   8.393639403487141e-15,  -2.889512395247963e-16,  -6.600122665095009e-18,
   5.393570100102712e-02,  -5.578162964120235e-04,   4.870138015785746e-06,  -1.773722176091034e-08,  -1.031316601311378e-10,  -1.125715743849050e-11,   2.815267227998867e-13,
   8.391979171880920e-15,  -2.888584608285651e-16,  -6.598256400553789e-18,   1.066107294521234e-01,  -1.101738786459495e-03,   9.559775863233267e-06,  -3.205466510668828e-08,
  -2.634037871668707e-10,  -2.279755851418805e-11,   5.886631233791036e-13,   1.758250805455307e-14,  -6.197498512036084e-16,  -1.396831511650925e-17,   1.066120894402687e-01,
  -1.101752584302955e-03,   9.559557902878990e-06,  -3.208667441400058e-08,  -2.621754714324809e-10,  -2.274611990166246e-11,   5.862751228930689e-13,   1.751304103981847e-14,
  -6.157995047476685e-16,  -1.388994215745280e-17,   1.066143220596669e-01,  -1.101775245472950e-03,   9.559200834800136e-06,  -3.213917042369838e-08,  -2.601626336060215e-10,
  -2.266182378657184e-11,   5.823660597647183e-13,   1.739928672841920e-14,  -6.093406782446035e-16,  -1.376170005385511e-17,   1.066166910125809e-01,  -1.101799304004775e-03,
   9.558822974870837e-06,  -3.219480154840339e-08,  -2.580317964590636e-10,  -2.257258084085408e-11,   5.782334577962999e-13,   1.727897387138669e-14,  -6.025229873656738e-16,
  -1.362619439003964e-17,   1.066185553701388e-01,  -1.101818247803305e-03,   9.558526332431844e-06,  -3.223853205114618e-08,  -2.563583852893114e-10,  -2.250249197954158e-11,
   5.749920630038837e-13,   1.718456819129972e-14,  -5.971831196015837e-16,  -1.351996167002694e-17,   1.066196313190014e-01,  -1.101829184488810e-03,   9.558355428715662e-06,
  -3.226374916321313e-08,  -2.553940551370299e-10,  -2.246210068634096e-11,   5.731257833048724e-13,   1.713019731627617e-14,  -5.941116423597508e-16,  -1.345881705439246e-17,
   1.066200353469233e-01,  -1.101833292050192e-03,   9.558291308285044e-06,  -3.227321454542551e-08,  -2.550322092243698e-10,  -2.244694437424837e-11,   5.724258057132681e-13,
   1.710980174770940e-14,  -5.929602083271449e-16,  -1.343588766644369e-17,   1.066201023202515e-01,  -1.101833972975644e-03,   9.558280682338856e-06,  -3.227478336264227e-08,
  -2.549722423031244e-10,  -2.244443257968481e-11,   5.723098181105970e-13,   1.710642200992563e-14,  -5.927694437025191e-16,  -1.343208842774226e-17,   1.783235163337829e-01,
  -1.840771169277590e-03,   1.582298598390414e-05,  -4.680223014410883e-08,  -5.665366194420191e-10,  -3.862697542943153e-11,   1.025650149742707e-12,   3.069440546038041e-14,
  -1.093185989914686e-15,  -2.434532641753548e-17,   1.783257671126957e-01,  -1.840791341559952e-03,   1.582251434749690e-05,  -4.685644272340379e-08,  -5.643970822214058e-10,
  -3.853717411478213e-11,   1.021438338351134e-12,   3.057333007870811e-14,  -1.086197451097148e-15,  -2.420879205695315e-17,   1.783294620840777e-01,  -1.840824474179373e-03,
   1.582174138465261e-05,  -4.694534988005978e-08,  -5.608911075898319e-10,  -3.839000988277149e-11,   1.014543827333671e-12,   3.037506531518500e-14,  -1.074771363864995e-15,
  -2.398537717586436e-17,   1.783333826712192e-01,  -1.840859652931494e-03,   1.582092298231842e-05,  -4.703956294384029e-08,  -5.571797089189448e-10,  -3.823420888963929e-11,
   1.007255135287275e-12,   3.016536924611264e-14,  -1.062710681343591e-15,  -2.374930421852446e-17,   1.783364681482952e-01,  -1.840887355060065e-03,   1.582028017594273e-05,
  -4.711361923653043e-08,  -5.542651129118129e-10,  -3.811184681855706e-11,   1.001538327754975e-12,   3.000082719867646e-14,  -1.053264495653529e-15,  -2.356422664223737e-17,
   1.783382488191879e-01,  -1.840903349016372e-03,   1.581990971257417e-05,  -4.715632257874771e-08,  -5.525855613285822e-10,  -3.804133099057242e-11,   9.982468166147858e-13,
   2.990606274756825e-14,  -1.047831150490232e-15,  -2.345769996945081e-17,   1.783389174753654e-01,  -1.840909356137172e-03,   1.581977069674686e-05,  -4.717235130988904e-08,
  -5.519553485718271e-10,  -3.801487080330927e-11,   9.970122878809027e-13,   2.987051475148772e-14,  -1.045794314586068e-15,  -2.341775197916364e-17,   1.783390283145158e-01,
  -1.840910351968368e-03,   1.581974765799139e-05,  -4.717500794296458e-08,  -5.518509068623888e-10,  -3.801048566135891e-11,   9.968077243787720e-13,   2.986462411300470e-14,
  -1.045456861143197e-15,  -2.341113286617760e-17,   2.705319545169582e-01,  -2.788212009831352e-03,   2.364723732439420e-05,  -5.636762990135875e-08,  -1.131707960291067e-09,
  -5.966898759851040e-11,   1.647275989169347e-12,   4.928574298664626e-14,  -1.782666286316974e-15,  -3.901921445160787e-17,   2.705353177887439e-01,  -2.788236369874972e-03,
   2.364629044437751e-05,  -5.645132858617241e-08,  -1.128272906333381e-09,  -5.952478886415795e-11,   1.640408776252826e-12,   4.909168206765240e-14,  -1.771220229365633e-15,
  -3.880071665392723e-17,   2.705408390495633e-01,  -2.788276386374253e-03,   2.364473808181452e-05,  -5.658858648816772e-08,  -1.122644179598711e-09,  -5.928847869366353e-11,
   1.629167658145041e-12,   4.877389999568063e-14,  -1.752506642699945e-15,  -3.844317424470604e-17,   2.705466974062244e-01,  -2.788318881666657e-03,   2.364309374789450e-05,
  -5.673402813019836e-08,  -1.116685868245285e-09,  -5.903829894575164e-11,   1.617284044557595e-12,   4.843779404263143e-14,  -1.732754303936930e-15,  -3.806536295851697e-17,
   2.705513078712683e-01,  -2.788352350785256e-03,   2.364180170394107e-05,  -5.684834713279730e-08,  -1.112006907738541e-09,  -5.884181349801394e-11,   1.607963400180214e-12,
   4.817406091054029e-14,  -1.717284269835919e-15,  -3.776915644629336e-17,   2.705539686237785e-01,  -2.788371676523154e-03,   2.364105686314942e-05,  -5.691426506833778e-08,
  -1.109310694577901e-09,  -5.872858093873086e-11,   1.602596998914157e-12,   4.802216903511385e-14,  -1.708386240178243e-15,  -3.759866305687536e-17,   2.705549677558103e-01,
  -2.788378935429674e-03,   2.364077732348145e-05,  -5.693900699163409e-08,  -1.108299015052169e-09,  -5.868609177316085e-11,   1.600584263329616e-12,   4.796519134130844e-14,
  -1.705050605763899e-15,  -3.753472663506743e-17,   2.705551333758771e-01,  -2.788380138797535e-03,   2.364073099397860e-05,  -5.694310774382505e-08,  -1.108131355571464e-09,
  -5.867905020920436e-11,   1.600250750194392e-12,   4.795574959514920e-14,  -1.704497975141347e-15,  -3.752413276787011e-17,   3.853800277184997e-01,  -3.963119025790585e-03,
   3.296934115566442e-05,  -5.077108213948155e-08,  -2.166014795055294e-09,  -8.718744672683508e-11,   2.540364401834942e-12,   7.556848360748376e-14,  -2.798018259961655e-15,
  -5.971464617839018e-17,   3.853847158395142e-01,  -3.963141132479539e-03,   3.296752165527605e-05,  -5.089329378657196e-08,  -2.160719584395731e-09,  -8.696634245957993e-11,
   2.529588231127369e-12,   7.527146014471661e-14,  -2.779935805131310e-15,  -5.938157083448353e-17,   3.853924119667420e-01,  -3.963177461465372e-03,   3.296453787849192e-05,
  -5.109369852714437e-08,  -2.152043067983213e-09,  -8.660399982504102e-11,   2.511948777801288e-12,   7.478506826207010e-14,  -2.750373051464658e-15,  -5.883651315876678e-17,
   3.854005779052038e-01,  -3.963216059953985e-03,   3.296137624177222e-05,  -5.130603738670666e-08,  -2.142858898679612e-09,  -8.622038895976310e-11,   2.493301585759201e-12,
   7.427062372881576e-14,  -2.719170587804727e-15,  -5.826052349751364e-17,   3.854070043627436e-01,  -3.963246473793193e-03,   3.295889118476966e-05,  -5.147292786870114e-08,
  -2.135647010569067e-09,  -8.591910866729209e-11,   2.478676412520046e-12,   7.386694857970697e-14,  -2.694733721430641e-15,  -5.780892014987065e-17,   3.854107131253736e-01,
  -3.963264040886302e-03,   3.295745827814231e-05,  -5.156915500645645e-08,  -2.131491332078441e-09,  -8.574548346848404e-11,   2.470256038443989e-12,   7.363445802920281e-14,
  -2.680678526181057e-15,  -5.754897251248484e-17,   3.854121057890775e-01,  -3.963270640276418e-03,   3.295692044702089e-05,  -5.160527251381688e-08,  -2.129932049990066e-09,
  -8.568033260324502e-11,   2.467097897386601e-12,   7.354724580639859e-14,  -2.675409676187151e-15,  -5.745148823353318e-17,   3.854123366423064e-01,  -3.963271734365998e-03,
   3.295683130644819e-05,  -5.161125862480968e-08,  -2.129673640808865e-09,  -8.566953539967485e-11,   2.466574590263773e-12,   7.353279389275120e-14,  -2.674536764038598e-15,
  -5.743533560146044e-17,   5.260475497807822e-01,  -5.392597012010524e-03,   4.359484041520390e-05,  -1.076057673158564e-08,  -4.067203091488557e-09,  -1.234888266058516e-10,
   3.881462784189142e-12,   1.133584365576598e-13,  -4.355253271419861e-15,  -8.942317608453343e-17,   5.260537467559689e-01,  -5.392602216366622e-03,   4.359141337944957e-05,
  -1.093351642886467e-08,  -4.059116029933802e-09,  -1.231571436020028e-10,   3.864694854926915e-12,   1.129135162147418e-13,  -4.326828137241624e-15,  -8.892915119731403e-17,
   5.260639197487547e-01,  -5.392610812872885e-03,   4.358579227372145e-05,  -1.121708671352326e-08,  -4.045865370117750e-09,  -1.226135847428515e-10,   3.837248333893076e-12,
   1.121849178497619e-13,  -4.280358276151049e-15,  -8.812063565480231e-17,   5.260747136119028e-01,  -5.392620006016284e-03,   4.357983453526168e-05,  -1.151751756974037e-08,
  -4.031840067270262e-09,  -1.220381191403102e-10,   3.808234893676325e-12,   1.114142740749740e-13,  -4.231313646982597e-15,  -8.726613749618929e-17,   5.260832080999699e-01,
  -5.392627292854426e-03,   4.357515060023844e-05,  -1.175362622564679e-08,  -4.020827130258817e-09,  -1.215861587187054e-10,   3.785480162959050e-12,   1.108095471840249e-13,
  -4.192905262662833e-15,  -8.659609873472903e-17,   5.260881102993402e-01,  -5.392631518975069e-03,   4.357244934623711e-05,  -1.188975620058096e-08,  -4.014481372848735e-09,
  -1.213256973785052e-10,   3.772379551459002e-12,   1.104612571960927e-13,  -4.170814939170666e-15,  -8.621038887624891e-17,   5.260899510982918e-01,  -5.392633109844473e-03,
   4.357143536425458e-05,  -1.194084924772982e-08,  -4.012100370390934e-09,  -1.212279621528121e-10,   3.767466102839260e-12,   1.103306048327034e-13,  -4.162534119940534e-15,
  -8.606573650048440e-17,   5.260902562357134e-01,  -5.392633373760555e-03,   4.357126730151595e-05,  -1.194931732725206e-08,  -4.011705784942513e-09,  -1.212117648629370e-10,
   3.766651942657551e-12,   1.103089543981532e-13,  -4.161162210169428e-15,  -8.604176808005576e-17,   6.974438445132390e-01,  -7.115637063908505e-03,   5.497152406368349e-05,
   1.047228438457443e-07,  -7.683555617734749e-09,  -1.734755000980183e-10,   6.087701133575385e-12,   1.694904711076975e-13,  -6.937071985303989e-15,  -1.334884436149878e-16,
   6.974516543172645e-01,  -7.115593211998433e-03,   5.496503518641123e-05,   1.044801530193109e-07,  -7.670876487914536e-09,  -1.729795680638322e-10,   6.061007489266755e-12,
   1.688258362902793e-13,  -6.891093153269685e-15,  -1.327688062585980e-16,   6.974644747188881e-01,  -7.115521295902753e-03,   5.495439036906872e-05,   1.040822424561447e-07,
  -7.650102327513945e-09,  -1.721668385048763e-10,   6.017316140532854e-12,   1.677373697106546e-13,  -6.815930717979653e-15,  -1.315908050411189e-16,   6.974780772652891e-01,
  -7.115445087734875e-03,   5.494310588030168e-05,   1.036607150948548e-07,  -7.628114520331591e-09,  -1.713064006834345e-10,   5.971133224446466e-12,   1.665860023400659e-13,
  -6.736609817907180e-15,  -1.303454688359202e-16,   6.974887818963171e-01,  -7.115385184109302e-03,   5.493423250924066e-05,   1.033294672668818e-07,  -7.610849868606442e-09,
  -1.706306272962939e-10,   5.934914775579119e-12,   1.656824566434004e-13,  -6.674495527058677e-15,  -1.293687181653205e-16,   6.974949594899804e-01,  -7.115350641636750e-03,
   5.492911454859029e-05,   1.031384964526135e-07,  -7.600902053455587e-09,  -1.702411839247429e-10,   5.914063480217439e-12,   1.651620377660570e-13,  -6.638772666944024e-15,
  -1.288063515259907e-16,   6.974972791890359e-01,  -7.115337676088874e-03,   5.492719327676168e-05,   1.030668225608122e-07,  -7.597169561877480e-09,  -1.700950495642951e-10,
   5.906243250816602e-12,   1.649668107197038e-13,  -6.625381861560865e-15,  -1.285954294326154e-16,   6.974976637097843e-01,  -7.115335527153502e-03,   5.492687482868880e-05,
   1.030549435675487e-07,  -7.596551006783633e-09,  -1.700708312654919e-10,   5.904947444003568e-12,   1.649344593463101e-13,  -6.623163381548496e-15,  -1.285604793746378e-16,
   9.077397303811962e-01,  -9.188883193199614e-03,   6.543566273186521e-05,   3.983464425147785e-07,  -1.514682195696191e-08,  -2.508646309172128e-10,   1.041614259790158e-11,
   2.557386104086117e-13,  -1.186980494495197e-14,  -2.004320432573343e-16,   9.077490165975706e-01,  -9.188714368053286e-03,   6.542285235839995e-05,   3.979957474644647e-07,
  -1.512512727335404e-08,  -2.501162945657963e-10,   1.037050786617674e-11,   2.547385898068258e-13,  -1.178918493940627e-14,  -1.994302054718061e-16,   9.077642601269796e-01,
  -9.188437320989697e-03,   6.540183527489490e-05,   3.974207878824464e-07,  -1.508958146832062e-08,  -2.488899219688640e-10,   1.029581998084444e-11,   2.531005762598713e-13,
  -1.165740507347708e-14,  -1.977891681488463e-16,   9.077804329269730e-01,  -9.188143497579172e-03,   6.537955246577060e-05,   3.968117472452532e-07,  -1.505195892639500e-08,
  -2.475915535379987e-10,   1.021688058093395e-11,   2.513675141698894e-13,  -1.151834938103258e-14,  -1.960528546177236e-16,   9.077931597297728e-01,  -9.187912361849064e-03,
   6.536202874938161e-05,   3.963331781548719e-07,  -1.502241791714008e-08,  -2.465718325931139e-10,   1.015497876660652e-11,   2.500071972467181e-13,  -1.140946909609732e-14,
  -1.946899571305192e-16,   9.078005041053238e-01,  -9.187779010890917e-03,   6.535192066362783e-05,   3.960572865383439e-07,  -1.500539648318796e-08,  -2.459841730945275e-10,
   1.011934354319335e-11,   2.492235777175557e-13,  -1.134685476834901e-14,  -1.939048427065221e-16,   9.078032618947728e-01,  -9.187728944213016e-03,   6.534812595785549e-05,
   3.959537431523731e-07,  -1.499900991207030e-08,  -2.457636600091042e-10,   1.010597905617792e-11,   2.489295938663209e-13,  -1.132338445054799e-14,  -1.936102968131159e-16,
   9.078037190327527e-01,  -9.187720645362912e-03,   6.534749698278889e-05,   3.959365823421947e-07,  -1.499795151785435e-08,  -2.457271151882517e-10,   1.010376459171417e-11,
   2.488808762352608e-13,  -1.131949612208697e-14,  -1.935614859877450e-16,   1.172479045371768e+00,  -1.168801523251546e-02,   6.882651967980717e-05,   1.208383171006734e-06,
  -3.352413200547693e-08,  -4.204236128748419e-10,   2.275008847325232e-11,   3.719513846892367e-13,  -2.450065398413868e-14,  -2.721888835938215e-16,   1.172488782872557e+00,
  -1.168750142657834e-02,   6.879816358946752e-05,   1.207794057594611e-06,  -3.347668214521648e-08,  -4.193339317754360e-10,   2.265599356271657e-11,   3.705794238550471e-13,
  -2.432934347053918e-14,  -2.713563597695400e-16,   1.172504765682593e+00,  -1.168665811059545e-02,   6.875164140892449e-05,   1.206828044288365e-06,  -3.339892882873511e-08,
  -4.175479925393106e-10,   2.250200779383615e-11,   3.683302485857117e-13,  -2.404935130619011e-14,  -2.699845869740859e-16,   1.172521720775708e+00,  -1.168576353108633e-02,
   6.870231705145407e-05,   1.205804538749050e-06,  -3.331662091201354e-08,  -4.156569767045992e-10,   2.233927591299243e-11,   3.659479505700467e-13,  -2.375393906957900e-14,
  -2.685222719208791e-16,   1.172535061698003e+00,  -1.168505966877550e-02,   6.866352691927006e-05,   1.205000125943201e-06,  -3.325198455334660e-08,  -4.141716331832490e-10,
   2.221168062495327e-11,   3.640761547961575e-13,  -2.352266009388250e-14,  -2.673666115552354e-16,   1.172542759873105e+00,  -1.168465352675978e-02,   6.864115174582323e-05,
   1.204536320655812e-06,  -3.321473782313178e-08,  -4.133155722372412e-10,   2.213823301718403e-11,   3.629971440627791e-13,  -2.338966861793774e-14,  -2.666977558881233e-16,
   1.172545650400488e+00,  -1.168450102974921e-02,   6.863275179335033e-05,   1.204362239718828e-06,  -3.320076191101920e-08,  -4.129943319471689e-10,   2.211068858701123e-11,
   3.625921993187031e-13,  -2.333982030387318e-14,  -2.664462377232150e-16,   1.172546129535492e+00,  -1.168447575189130e-02,   6.863135949425552e-05,   1.204333387665960e-06,
  -3.319844576272047e-08,  -4.129410933270291e-10,   2.210612459466727e-11,   3.625250863099431e-13,  -2.333156204429693e-14,  -2.664045262730242e-16,   1.530334505687196e+00,
  -1.455818615703771e-02,   2.568244402105910e-05,   4.586147680112003e-06,  -1.033184663456961e-07,  -1.740305349239839e-09,   1.242272338396768e-10,  -4.323651625201560e-13,
  -1.144286870505037e-13,   2.184556685336571e-15,   1.530337986065807e+00,  -1.455623701382196e-02,   2.559569610004635e-05,   4.583661747650649e-06,  -1.030585635277184e-07,
  -1.741430593272508e-09,   1.237819700809896e-10,  -4.218403934039040e-13,  -1.139120562573406e-13,   2.159501680548588e-15,   1.530343690982371e+00,  -1.455303794887959e-02,
   2.545344407280905e-05,   4.579579598395957e-06,  -1.026325722841916e-07,  -1.743255559336057e-09,   1.230524762865910e-10,  -4.046533239460419e-13,  -1.130655164640978e-13,
   2.118599794697695e-15,   1.530349732540416e+00,  -1.454964453914750e-02,   2.530271916895555e-05,   4.575246655112230e-06,  -1.021814873423952e-07,  -1.745161782748799e-09,
   1.222804341778710e-10,  -3.865397877424227e-13,  -1.121694401850710e-13,   2.075510955678395e-15,   1.530354478742063e+00,  -1.454697466489671e-02,   2.518425372024775e-05,
   4.571835553200993e-06,  -1.018271496479795e-07,  -1.746640203635590e-09,   1.216742842555932e-10,  -3.723732311803927e-13,  -1.114657949607707e-13,   2.041824120612000e-15,
   1.530357214448304e+00,  -1.454543413175983e-02,   2.511594740386112e-05,   4.569866520758635e-06,  -1.016229220923737e-07,  -1.747484723355322e-09,   1.213250443712106e-10,
  -3.642329479389135e-13,  -1.110603381048463e-13,   2.022472366186634e-15,   1.530358241087138e+00,  -1.454485570361788e-02,   2.509030949207600e-05,   4.569127050711671e-06,
  -1.015462831661157e-07,  -1.747800206661710e-09,   1.211940110757568e-10,  -3.611828889824322e-13,  -1.109082042794708e-13,   2.015222480917755e-15,   1.530358411233144e+00,
  -1.454475982390049e-02,   2.508606026298704e-05,   4.569004468819725e-06,  -1.015335818329912e-07,  -1.747852415979057e-09,   1.211722962195634e-10,  -3.606776510769131e-13,
  -1.108829922133506e-13,   2.014021598759461e-15,   2.053903734178364e-03,  -2.062370131807134e-05,   1.849296383747325e-07,  -8.591196366884171e-10,  -9.098850339945384e-12,
  -1.166833894139592e-13,   1.458357979839068e-14,  -9.093015439844850e-17,  -1.193710573512671e-17,   2.180053913696223e-19,   2.053930035752176e-03,  -2.062406868977869e-05,
   1.849220423603934e-07,  -8.592878229644704e-10,  -9.068270648826118e-12,  -1.169383236544449e-13,   1.453710043038371e-14,  -8.987122699637617e-17,  -1.188463054219425e-17,
   2.158305062108392e-19,   2.053973213289879e-03,  -2.062467184230062e-05,   1.849095909709877e-07,  -8.595641832503307e-10,  -9.018140270910136e-12,  -1.173545895270764e-13,
   1.446094708963516e-14,  -8.814074166899662e-17,  -1.179866916683408e-17,   2.122783793351399e-19,   2.054019026973151e-03,  -2.062531190501457e-05,   1.848964044720877e-07,
  -8.598577685913698e-10,  -8.965044616345034e-12,  -1.177932312041204e-13,   1.438034616693393e-14,  -8.631528391479165e-17,  -1.170770899266423e-17,   2.085340700247436e-19,
   2.054055081844000e-03,  -2.062581568936956e-05,   1.848860449907895e-07,  -8.600890711282552e-10,  -8.923327863623655e-12,  -1.181362445152066e-13,   1.431706004161609e-14,
  -8.488637253533643e-17,  -1.163630483057477e-17,   2.056051375555748e-19,   2.054075889519190e-03,  -2.062610645388091e-05,   1.848800736860629e-07,  -8.602226599677819e-10,
  -8.899280259184014e-12,  -1.183333247243380e-13,   1.428059532055953e-14,  -8.406481034550123e-17,  -1.159516899887038e-17,   2.039219267558871e-19,   2.054083702952255e-03,
  -2.062621564276173e-05,   1.848778327911068e-07,  -8.602728426968814e-10,  -8.890255423425361e-12,  -1.184071643552908e-13,   1.426691358638271e-14,  -8.375688858965746e-17,
  -1.157973586062943e-17,   2.032912096542709e-19,   2.054084998137678e-03,  -2.062623374258821e-05,   1.848774614039686e-07,  -8.602811621929355e-10,  -8.888759706106532e-12,
  -1.184193955834957e-13,   1.426464623010613e-14,  -8.370587688044364e-17,  -1.157717832367494e-17,   2.031867301638531e-19,   1.853596428345337e-02,  -1.860991627275523e-04,
   1.666718465826076e-06,  -7.645764017652615e-09,  -8.487870565608888e-11,  -1.038031748294413e-12,   1.327132320780721e-13,  -8.328186955248836e-16,  -1.087968995806322e-16,
   1.994051817676746e-18,   1.853620132718746e-02,  -1.861024321644635e-04,   1.666647566794291e-06,  -7.647260789698828e-09,  -8.460043266675319e-11,  -1.040366861469482e-12,
   1.322896060845530e-13,  -8.231327355756148e-16,  -1.083188662172409e-16,   1.974164642299096e-18,   1.853659046581096e-02,  -1.861077999408193e-04,   1.666531344702357e-06,
  -7.649720321748434e-09,  -8.414425085752702e-11,  -1.044179747437804e-12,   1.315955225158565e-13,  -8.073040428521451e-16,  -1.075357801292976e-16,   1.941683981473976e-18,
   1.853700336242374e-02,  -1.861134962008645e-04,   1.666408255101710e-06,  -7.652333242143239e-09,  -8.366108669640725e-11,  -1.048197628685535e-12,   1.308609014982665e-13,
  -7.906066084047243e-16,  -1.067071514266252e-16,   1.907446043017704e-18,   1.853732830732634e-02,  -1.861179796471268e-04,   1.666311550034700e-06,  -7.654391908119133e-09,
  -8.328147020139894e-11,  -1.051339598949024e-12,   1.302840920958934e-13,  -7.775363543514224e-16,  -1.060566705412795e-16,   1.880663933113856e-18,   1.853751583661979e-02,
  -1.861205673159942e-04,   1.666255806573649e-06,  -7.655580917066180e-09,  -8.306264083821928e-11,  -1.053144846795875e-12,   1.299517410436779e-13,  -7.700215146692655e-16,
  -1.056819280829281e-16,   1.865272692840948e-18,   1.853758625521213e-02,  -1.861215390462426e-04,   1.666234886992413e-06,  -7.656027573882162e-09,  -8.298051634941184e-11,
  -1.053821217387463e-12,   1.298270413230391e-13,  -7.672049487193682e-16,  -1.055413337963972e-16,   1.859505432527505e-18,   1.853759792807423e-02,  -1.861217001262797e-04,
   1.666231419939181e-06,  -7.656101622715015e-09,  -8.296690557719964e-11,  -1.053933255480266e-12,   1.298063759069597e-13,  -7.667383435854435e-16,  -1.055180348866015e-16,
   1.858550074973815e-18,   5.177640078820183e-02,  -5.196879252694168e-04,   4.642772988211462e-06,  -2.073419266887767e-08,  -2.531201095917604e-10,  -2.811806196333413e-12,
   3.770959947168605e-13,  -2.398303026360871e-15,  -3.100860664368586e-16,   5.725630489585392e-18,   5.177706106335792e-02,  -5.196967914999556e-04,   4.642561335673307e-06,
  -2.073825046313490e-08,  -2.523294590882203e-10,  -2.818531992007112e-12,   3.758885738675089e-13,  -2.370490236733498e-15,  -3.087250160911368e-16,   5.668563275018532e-18,
   5.177814499086303e-02,  -5.197113481178654e-04,   4.642214357186755e-06,  -2.074491872521207e-08,  -2.510333262406679e-10,  -2.829514378285581e-12,   3.739102895317098e-13,
  -2.325038732628829e-15,  -3.064954019038107e-16,   5.575358603062959e-18,   5.177929509317947e-02,  -5.197267955356818e-04,   4.641846842569061e-06,  -2.075200338877827e-08,
  -2.496605373066146e-10,  -2.841087466073791e-12,   3.718164595221243e-13,  -2.277092479256309e-15,  -3.041360888143795e-16,   5.477111563336536e-18,   5.178020020910340e-02,
  -5.197389539817151e-04,   4.641558081380744e-06,  -2.075758563519144e-08,  -2.485819586326274e-10,  -2.850137762688769e-12,   3.701724231178126e-13,  -2.239561443211423e-15,
  -3.022839860364173e-16,   5.400259458177526e-18,   5.178072256093448e-02,  -5.197459713588296e-04,   4.641391621794844e-06,  -2.076080988747876e-08,  -2.479602158569078e-10,
  -2.855337765647783e-12,   3.692251463871196e-13,  -2.217982639708326e-15,  -3.012169800324880e-16,   5.356093873830549e-18,   5.178091870767943e-02,  -5.197486065482847e-04,
   4.641329150484989e-06,  -2.076202112212653e-08,  -2.477268823960069e-10,  -2.857286059731349e-12,   3.688697232878910e-13,  -2.209894882050111e-15,  -3.008166636625067e-16,
   5.339544574707614e-18,   5.178095122172763e-02,  -5.197490433736462e-04,   4.641318796865652e-06,  -2.076222192774069e-08,  -2.476882112669557e-10,  -2.857608787601749e-12,
   3.688108220480457e-13,  -2.208555026752304e-15,  -3.007503242191428e-16,   5.336803152705713e-18,   1.023541548152175e-01,  -1.026899862164787e-03,   9.137624302614492e-06,
  -3.902614201054987e-08,  -5.510610212559239e-10,  -5.277370789102795e-12,   7.657139330299004e-13,  -4.975769042057901e-15,  -6.325077959727333e-16,   1.181835543556028e-17,
   1.023554542385046e-01,  -1.026916550253462e-03,   9.137162863396976e-06,  -3.903376912734860e-08,  -5.494556956406467e-10,  -5.291329442842756e-12,   7.632509621504098e-13,
  -4.918357126465241e-15,  -6.297362751558864e-16,   1.170067965519245e-17,   1.023575874061819e-01,  -1.026943948833161e-03,   9.136406317703603e-06,  -3.904630425595134e-08,
  -5.468240633746874e-10,  -5.314122842682394e-12,   7.592155233942305e-13,  -4.824534443063348e-15,  -6.251960151976663e-16,   1.150848687854174e-17,   1.023598507995714e-01,
  -1.026973024082613e-03,   9.135604896876344e-06,  -3.905962393124647e-08,  -5.440368145931013e-10,  -5.338143109551489e-12,   7.549443686165192e-13,  -4.725561386323585e-15,
  -6.203915443246728e-16,   1.130589710274189e-17,   1.023616320569389e-01,  -1.026995908803505e-03,   9.134975138340578e-06,  -3.907012024210221e-08,  -5.418469343701549e-10,
  -5.356927902987037e-12,   7.515907242411626e-13,  -4.648087492640932e-15,  -6.166198776764271e-16,   1.114742508391685e-17,   1.023626600373234e-01,  -1.027009116964725e-03,
   9.134612078414734e-06,  -3.907618332507184e-08,  -5.405845927794565e-10,  -5.367721289256967e-12,   7.496583839218429e-13,  -4.603543006278444e-15,  -6.144469724889715e-16,
   1.105635411711957e-17,   1.023630460507655e-01,  -1.027014076938588e-03,   9.134475818729130e-06,  -3.907846110232279e-08,  -5.401108506997032e-10,  -5.371765315445431e-12,
   7.489333589196527e-13,  -4.586847652847930e-15,  -6.136317425451117e-16,   1.102222892225258e-17,   1.023631100378388e-01,  -1.027014899134643e-03,   9.134453235582119e-06,
  -3.907883873075564e-08,  -5.400323359214963e-10,  -5.372435196377448e-12,   7.488132066560522e-13,  -4.584081821656230e-15,  -6.134966443629135e-16,   1.101657602241064e-17,
   1.712097598448217e-01,  -1.716636774199832e-03,   1.518642145785052e-05,  -6.049567748449483e-08,  -1.045950145552987e-09,  -8.124939794139419e-12,   1.330646349235078e-12,
  -8.924635839619477e-15,  -1.105663189685469e-15,   2.102097331874978e-17,   1.712119192202167e-01,  -1.716662642769348e-03,   1.518554415842229e-05,  -6.050744990473793e-08,
  -1.043160737693705e-09,  -8.149989781126611e-12,   1.326340665108343e-12,  -8.822510804463370e-15,  -1.100831011539272e-15,   2.081196963752022e-17,   1.712154640967921e-01,
  -1.716705113895148e-03,   1.518410563471074e-05,  -6.052680133552190e-08,  -1.038588063173252e-09,  -8.190896387174591e-12,   1.319286008952849e-12,  -8.655616669516789e-15,
  -1.092914816906994e-15,   2.047061740669021e-17,   1.712192253658535e-01,  -1.716750184051009e-03,   1.518258156528465e-05,  -6.054736868869029e-08,  -1.033745046712746e-09,
  -8.234007425406431e-12,   1.311819231446063e-12,  -8.479559328503918e-15,  -1.084537686437470e-15,   2.011080038118106e-17,   1.712221854183148e-01,  -1.716785658130300e-03,
   1.518138378932765e-05,  -6.056357981860078e-08,  -1.029940034333569e-09,  -8.267723849776833e-12,   1.305956398973496e-12,  -8.341744424893854e-15,  -1.077961171486902e-15,
   1.982934121996978e-17,   1.712238936880018e-01,  -1.716806132371186e-03,   1.518069320013022e-05,  -6.057294537443144e-08,  -1.027746676587947e-09,  -8.287097430932494e-12,
   1.302578272720770e-12,  -8.262505730823386e-15,  -1.074172280223708e-15,   1.966759215528113e-17,   1.712245351537438e-01,  -1.716813820927567e-03,   1.518043400372649e-05,
  -6.057646408158933e-08,  -1.026923537992341e-09,  -8.294356397434632e-12,   1.301310778054773e-12,  -8.232806837874565e-15,  -1.072750750534737e-15,   1.960698324400363e-17,
   1.712246414855289e-01,  -1.716815095430368e-03,   1.518039104489521e-05,  -6.057704745505724e-08,  -1.026787116778680e-09,  -8.295558831318704e-12,   1.301100726742510e-12,
  -8.227886774180998e-15,  -1.072515176874354e-15,   1.959694327255146e-17,   2.597526439934610e-01,  -2.602122506084176e-03,   2.283073575146891e-05,  -8.153197262298733e-08,
  -1.854788539577484e-09,  -1.076972127084306e-11,   2.126955812639694e-12,  -1.492196610319306e-14,  -1.779728755711739e-15,   3.468098105303615e-17,   2.597558898412665e-01,
  -2.602157369335791e-03,   2.282917726929193e-05,  -8.154765023645393e-08,  -1.850330423863026e-09,  -1.081164037466641e-11,   2.120024550030694e-12,  -1.475345858206368e-14,
  -1.771981378459177e-15,   3.433686657000452e-17,   2.597612182696352e-01,  -2.602214607926071e-03,   2.282662149381126e-05,  -8.157342959058847e-08,  -1.843022314159634e-09,
  -1.088009929963554e-11,   2.108667922850244e-12,  -1.447807855955182e-14,  -1.759288938615027e-15,   3.377484782704391e-17,   2.597668719319566e-01,  -2.602275349188588e-03,
   2.282391331876495e-05,  -8.160084038008451e-08,  -1.835282244451712e-09,  -1.095225433259267e-11,   2.096647742627647e-12,  -1.418757528919157e-14,  -1.745856790622233e-15,
   3.318242945187173e-17,   2.597713212405397e-01,  -2.602323157733675e-03,   2.282178464708030e-05,  -8.162245385848661e-08,  -1.829201179930663e-09,  -1.100869059049272e-11,
   2.087209543204393e-12,  -1.396017123470569e-14,  -1.735311325755645e-15,   3.271902409675706e-17,   2.597738889620864e-01,  -2.602350750926713e-03,   2.282055722090587e-05,
  -8.163494382039986e-08,  -1.825695847121130e-09,  -1.104112108572125e-11,   2.081771279796903e-12,  -1.382942086828018e-14,  -1.729235634277772e-15,   3.245271461388423e-17,
   2.597748531554522e-01,  -2.602361112813258e-03,   2.282009651265934e-05,  -8.163963701915119e-08,  -1.824380347100206e-09,  -1.105327264771662e-11,   2.079730802072392e-12,
  -1.378041504616307e-14,  -1.726956098770660e-15,   3.235292601409489e-17,   2.597750129836915e-01,  -2.602362830463699e-03,   2.282002015435246e-05,  -8.164041514708789e-08,
  -1.824162325661897e-09,  -1.105528555082392e-11,   2.079392650393831e-12,  -1.377229649145823e-14,  -1.726578335842110e-15,   3.233639586411407e-17,   3.700502265108531e-01,
  -3.702498697606076e-03,   3.210682656085095e-05,  -9.554427307462936e-08,  -3.186264442094720e-09,  -1.206827641880099e-11,   3.251752925028852e-12,  -2.431273749602010e-14,
  -2.741192667871384e-15,   5.532287502368476e-17,   3.700547901553509e-01,  -3.702539550373720e-03,   3.210414453600563e-05,  -9.556202068673838e-08,  -3.179449699056966e-09,
  -1.213666679220581e-11,   3.241075678283794e-12,  -2.404389252739564e-14,  -2.729333768145406e-15,   5.477555530318207e-17,   3.700622818468910e-01,  -3.702606622414180e-03,
   3.209974572367762e-05,  -9.559122484934981e-08,  -3.168278538479570e-09,  -1.224836935032272e-11,   3.223581180161080e-12,  -2.360453187585106e-14,  -2.709904270040658e-15,
   5.388165532594788e-17,   3.700702307446368e-01,  -3.702677798669834e-03,   3.209508389962387e-05,  -9.562230561874484e-08,  -3.156447256675282e-09,  -1.236612027562315e-11,
   3.205064218491138e-12,  -2.314103412758853e-14,  -2.689340814437174e-15,   5.293940431293657e-17,   3.700764863041273e-01,  -3.702733820295126e-03,   3.209141911025497e-05,
  -9.564683335801285e-08,  -3.147152014391435e-09,  -1.245823221541137e-11,   3.190524567791202e-12,  -2.277820503308641e-14,  -2.673195457457515e-15,   5.220235066962000e-17,
   3.700800964037457e-01,  -3.702766153693354e-03,   3.208930572697302e-05,  -9.566101557538702e-08,  -3.141793970029965e-09,  -1.251116848007716e-11,   3.182146781664118e-12,
  -2.256958696655624e-14,  -2.663892965720767e-15,   5.177878120517622e-17,   3.700814520120063e-01,  -3.702778295626382e-03,   3.208851244002796e-05,  -9.566634619091719e-08,
  -3.139783183988586e-09,  -1.253100443219552e-11,   3.179003357401886e-12,  -2.249139551827967e-14,  -2.660402681304803e-15,   5.162006585893596e-17,   3.700816767224221e-01,
  -3.702780308347768e-03,   3.208838095768490e-05,  -9.566723008301505e-08,  -3.139449931384599e-09,  -1.253429030376547e-11,   3.178482422611935e-12,  -2.247844189923282e-14,
  -2.659824269362897e-15,   5.159377439435939e-17,   5.051720985764445e-01,  -5.045611779723060e-03,   4.301236482166514e-05,  -8.976164058937529e-08,  -5.437434462267668e-09,
  -9.619552597029510e-12,   4.889059849250936e-12,  -4.004799929127229e-14,  -4.147189626250817e-15,   8.809643271083252e-17,   5.051782103331289e-01,  -5.045650152837855e-03,
   4.300778005057691e-05,  -8.977627687005773e-08,  -5.427189632016321e-09,  -9.732437366580132e-12,   4.872902289502467e-12,  -3.961978657022972e-14,  -4.129434703944508e-15,
   8.722873845433241e-17,   5.051882433088319e-01,  -5.045713153252861e-03,   4.300025966856173e-05,  -8.980041800045976e-08,  -5.410395818564887e-09,  -9.916845943691053e-12,
   4.846427857536703e-12,  -3.891996397394141e-14,  -4.100342193410005e-15,   8.581158378240249e-17,   5.051988884439329e-01,  -5.045780008018634e-03,   4.299228846391802e-05,
  -8.982618709401018e-08,  -5.392609856543310e-09,  -1.011128457361884e-11,   4.818405416895887e-12,  -3.818167527548990e-14,  -4.069547673801311e-15,   8.431776338175078e-17,
   5.052072657671111e-01,  -5.045832627759587e-03,   4.298602123308699e-05,  -8.984657823974961e-08,  -5.378636484456268e-09,  -1.026341888114431e-11,   4.796401482239754e-12,
  -3.760372348446277e-14,  -4.045366473181672e-15,   8.314924908931764e-17,   5.052121003022009e-01,  -5.045862997525353e-03,   4.298240675435192e-05,  -8.985839062611981e-08,
  -5.370581897159045e-09,  -1.035086279453877e-11,   4.783722550454545e-12,  -3.727140917107724e-14,  -4.031432784757254e-15,   8.247772474463516e-17,   5.052139156838251e-01,
  -5.045874402031109e-03,   4.298104994687208e-05,  -8.986283464431040e-08,  -5.367559155209348e-09,  -1.038363172237899e-11,   4.778965257190279e-12,  -3.714685443731895e-14,
  -4.026204659340484e-15,   8.222609780429269e-17,   5.052142166075011e-01,  -5.045876292510012e-03,   4.298082506114787e-05,  -8.986357174404027e-08,  -5.367058189272324e-09,
  -1.038906010250431e-11,   4.778176866645367e-12,  -3.712621996687452e-14,  -4.025338239733062e-15,   8.218441534407341e-17,   6.698655738471598e-01,  -6.673134164474850e-03,
   5.540503856494085e-05,  -3.690515917560827e-08,  -9.448224248836095e-09,   2.212876835606465e-12,   7.432554003624492e-12,  -6.967415601294780e-14,  -6.307744604529968e-15,
   1.450259875396306e-16,   6.698734423467668e-01,  -6.673149915137291e-03,   5.539705935106601e-05,  -3.690366345615446e-08,  -9.432649911194455e-09,   2.015852975207287e-12,
   7.407967998589098e-12,  -6.896894166873018e-14,  -6.281273212861560e-15,   1.436082345235930e-16,   6.698863589560426e-01,  -6.673175772319776e-03,   5.538396969914700e-05,
  -3.690140602546558e-08,  -9.407119756595813e-09,   1.693905339884847e-12,   7.367681906330635e-12,  -6.781637836953385e-14,  -6.237889697963896e-15,   1.412926464792265e-16,
   6.699000633815627e-01,  -6.673203208713742e-03,   5.537009349128341e-05,  -3.689927903063235e-08,  -9.380081383049435e-09,   1.354325125491137e-12,   7.325038169668598e-12,
  -6.660040888263419e-14,  -6.191956562829554e-15,   1.388517156552546e-16,   6.699108480439112e-01,  -6.673224801270829e-03,   5.535918219056341e-05,  -3.689779868842435e-08,
  -9.358838984081776e-09,   1.088539553989174e-12,   7.291551750580937e-12,  -6.564847622648209e-14,  -6.155879558861250e-15,   1.369422884781028e-16,   6.699170717658826e-01,
  -6.673237262754355e-03,   5.535288880935354e-05,  -3.689702174966929e-08,  -9.346594372395041e-09,   9.357355295614938e-13,   7.272255886606796e-12,  -6.510111211088063e-14,
  -6.135087960939560e-15,   1.358449536830690e-16,   6.699194087753653e-01,  -6.673241942165678e-03,   5.535052628935844e-05,  -3.689674460455080e-08,  -9.341999192855497e-09,
   8.784666790886838e-13,   7.265015727338780e-12,  -6.489595153826120e-14,  -6.127286022759489e-15,   1.354337673139124e-16,   6.699197961649733e-01,  -6.673242717845127e-03,
   5.535013470515276e-05,  -3.689669943353846e-08,  -9.341237623415743e-09,   8.689793764800738e-13,   7.263815864201026e-12,  -6.486196327070485e-14,  -6.125993030808727e-15,
   1.353656533354290e-16,   8.720552453796313e-01,  -8.650681499656277e-03,   6.864483325830032e-05,   1.310552718072422e-07,  -1.732077387904676e-08,   3.917638239759656e-11,
   1.191034761651378e-11,  -1.377333546788094e-13,  -9.902589290799681e-15,   2.608557847814795e-16,   8.720649845894655e-01,  -8.650625364561281e-03,   6.863018524397776e-05,
   1.311077358084348e-07,  -1.729580771871804e-08,   3.878492611116089e-11,   1.187171029074862e-11,  -1.364638513602175e-13,  -9.862969315816628e-15,   2.583452745864693e-16,
   8.720809715949709e-01,  -8.650533194286058e-03,   6.860615341987395e-05,   1.311934696345866e-07,  -1.725488090083466e-08,   3.814498626742704e-11,   1.180839450970925e-11,
  -1.343888960384423e-13,  -9.798006942434746e-15,   2.542445933846179e-16,   8.720979330279237e-01,  -8.650435373591081e-03,   6.858067451962956e-05,   1.312839054322172e-07,
  -1.721153471158113e-08,   3.746961809571103e-11,   1.174136589326744e-11,  -1.321995882322163e-13,  -9.729186429671543e-15,   2.499215177756585e-16,   8.721112803061828e-01,
  -8.650358373101468e-03,   6.856063747932991e-05,   1.313546931220607e-07,  -1.717747911707385e-08,   3.694073950609451e-11,   1.168872565107000e-11,  -1.304855224418881e-13,
  -9.675104096182873e-15,   2.465394703421381e-16,   8.721189826970005e-01,  -8.650313928581475e-03,   6.854907971440382e-05,   1.313953918372211e-07,  -1.715784822582927e-08,
   3.663656870053103e-11,   1.165839065178886e-11,  -1.294998708178275e-13,  -9.643924240207020e-15,   2.445957087682102e-16,   8.721218749109003e-01,  -8.650297238084170e-03,
   6.854474079273569e-05,   1.314106455014764e-07,  -1.715048102407306e-08,   3.652254868684568e-11,   1.164700800530057e-11,  -1.291304221869050e-13,  -9.632221981077934e-15,
   2.438673317020944e-16,   8.721223543309269e-01,  -8.650294471335347e-03,   6.854402161417106e-05,   1.314131724802066e-07,  -1.714926003661404e-08,   3.650365873550538e-11,
   1.164512161425647e-11,  -1.290692162796013e-13,  -9.630282485633720e-15,   2.437466731347954e-16,   1.126906586398718e+00,  -1.108895461771281e-02,   7.993315463771874e-05,
   6.363014240170856e-07,  -3.609763356930493e-08,   1.604363426767660e-10,   2.219593989084965e-11,  -3.665542540467914e-13,  -1.644828687373290e-14,   5.815057262997059e-16,
   1.126917900027255e+00,  -1.108868219291468e-02,   7.990259662512528e-05,   6.365209091341468e-07,  -3.605101743722338e-08,   1.593859708985474e-10,   2.213152540144200e-11,
  -3.637168886611925e-13,  -1.639410238095027e-14,   5.761880107293094e-16,   1.126936470079055e+00,  -1.108823489782402e-02,   7.985245922734030e-05,   6.368801677038693e-07,
  -3.597458829237158e-08,   1.576676528883648e-10,   2.202593494481923e-11,  -3.590782738055751e-13,  -1.630509598490056e-14,   5.674993855243199e-16,   1.126956170127118e+00,
  -1.108776019404927e-02,   7.979929830839323e-05,   6.372599291327077e-07,  -3.589362518079645e-08,   1.558525670858759e-10,   2.191410788272684e-11,  -3.541826004546222e-13,
  -1.621058263948109e-14,   5.583359798756436e-16,   1.126971671119999e+00,  -1.108738653529983e-02,   7.975748840506624e-05,   6.375577636359976e-07,  -3.583000378768721e-08,
   1.544299915022805e-10,   2.182625336506998e-11,  -3.503486244690524e-13,  -1.613615085035700e-14,   5.511646567092252e-16,   1.126980615824533e+00,  -1.108717086376527e-02,
   7.973337031522090e-05,   6.377292338382610e-07,  -3.579332548624399e-08,   1.536113570756042e-10,   2.177561254185212e-11,  -3.481435345537949e-13,  -1.609317566845805e-14,
   5.470420622917310e-16,   1.126983974419189e+00,  -1.108708987209517e-02,   7.972431585288874e-05,   6.377935440950534e-07,  -3.577955975803812e-08,   1.533043974100013e-10,
   2.175660808029039e-11,  -3.473169301242507e-13,  -1.607703451559506e-14,   5.454970275641955e-16,   1.126984531142150e+00,  -1.108707644631007e-02,   7.972281505798052e-05,
   6.378042003014319e-07,  -3.577727827859870e-08,   1.532535379474987e-10,   2.175345843451819e-11,  -3.471799839198444e-13,  -1.607435870324693e-14,   5.452410762022850e-16,
   1.472819334760540e+00,  -1.416233386839440e-02,   7.014697780083629e-05,   2.806129013357729e-06,  -1.110622310267549e-07,   7.700039961040421e-10,   7.547366995687015e-11,
  -2.496892725714147e-12,  -1.238517796770686e-14,   2.617710891729339e-15,   1.472829128334745e+00,  -1.416113222649909e-02,   7.005305669525716e-05,   2.807163735834442e-06,
  -1.109017840524691e-07,   7.627507368090210e-10,   7.541877836570140e-11,  -2.483799624521399e-12,  -1.265512453112109e-14,   2.605883237517963e-15,   1.472845196557545e+00,
  -1.415915923170868e-02,   6.989896880025738e-05,   2.808855026287643e-06,  -1.106384719726807e-07,   7.508714117601714e-10,   7.532790504102727e-11,  -2.462348986338851e-12,
  -1.309522238807779e-14,   2.586464600907123e-15,   1.472862233258705e+00,  -1.415706531824387e-02,   6.973560388096091e-05,   2.810639610075077e-06,  -1.103591971854411e-07,
   7.383046327024154e-10,   7.523045345175628e-11,  -2.439647739008909e-12,  -1.355805200893240e-14,   2.565858220800478e-15,   1.472875631878249e+00,  -1.415541709891320e-02,
   6.960713200485064e-05,   2.812036854539400e-06,  -1.101394936064405e-07,   7.284420583593154e-10,   7.515301801580544e-11,  -2.421824845390931e-12,  -1.391930953832426e-14,
   2.549640051969944e-15,   1.472883360735553e+00,  -1.415446575999678e-02,   6.953302731703743e-05,   2.812840336613764e-06,  -1.100127334695116e-07,   7.227612025556219e-10,
   7.510803290597147e-11,  -2.411556184525604e-12,  -1.412660287008251e-14,   2.540280022617393e-15,   1.472886262290077e+00,  -1.415410850026015e-02,   6.950520762975812e-05,
   2.813141505414550e-06,  -1.099651404301352e-07,   7.206300676546104e-10,   7.509108482387025e-11,  -2.407703466266625e-12,  -1.420421807795128e-14,   2.536765214748449e-15,
   1.472886743226913e+00,  -1.415404927815830e-02,   6.950059650663025e-05,   2.813191399624633e-06,  -1.099572515540427e-07,   7.202769113857535e-10,   7.508827250044485e-11,
  -2.407064995364265e-12,  -1.421707202457297e-14,   2.536182584153530e-15,   1.974298929319005e-03,  -1.918803772163801e-05,   1.737273068503782e-07,  -1.005885546705212e-09,
  -8.324719719087657e-12,   1.685053633771363e-13,   8.175711162427422e-15,  -3.093296480922306e-16,  -1.317151361322293e-18,   2.883114955261202e-19,   1.974323637896840e-03,
  -1.918846633748288e-05,   1.737202972925943e-07,  -1.005653341553865e-09,  -8.307336499432823e-12,   1.676038842410661e-13,   8.169981974803204e-15,  -3.078895760505388e-16,
  -1.340572762917956e-18,   2.869320037936935e-19,   1.974364200322271e-03,  -1.918916990989679e-05,   1.737088006744372e-07,  -1.005273056933361e-09,  -8.278808222363559e-12,
   1.661270468500363e-13,   8.160510638555032e-15,  -3.055305514156342e-16,  -1.378759925992001e-18,   2.846701601177619e-19,   1.974407239234698e-03,  -1.918991635981138e-05,
   1.736966164203384e-07,  -1.004870791084231e-09,  -8.248549926091744e-12,   1.645641970469272e-13,   8.150371601581052e-15,  -3.030343513631946e-16,  -1.418923512101686e-18,
   2.822740181015340e-19,   1.974441110393321e-03,  -1.919050375130331e-05,   1.736870378777732e-07,  -1.004555106185535e-09,  -8.224745516439922e-12,   1.633372541357377e-13,
   8.142327852565871e-15,  -3.010748253698818e-16,  -1.450275770722369e-18,   2.803910462218253e-19,   1.974460657824220e-03,  -1.919084271899531e-05,   1.736815141334526e-07,
  -1.004373278751969e-09,  -8.211011159307508e-12,   1.626303736486107e-13,   8.137659989412321e-15,  -2.999459459560942e-16,  -1.468267211130023e-18,   2.793054763006887e-19,
   1.974467998026550e-03,  -1.919096999955557e-05,   1.736794407100391e-07,  -1.004305068826784e-09,  -8.205854460009008e-12,   1.623651619414980e-13,   8.135902323260405e-15,
  -2.995224186065909e-16,  -1.475003830582089e-18,   2.788980482632397e-19,   1.974469214767390e-03,  -1.919099109785721e-05,   1.736790970524995e-07,  -1.004293765645795e-09,
  -8.204999699644209e-12,   1.623212113782271e-13,   8.135610710063452e-15,  -2.994522328279549e-16,  -1.476119502100467e-18,   2.788305225542096e-19,   1.781762071443532e-02,
  -1.731560167999364e-04,   1.566659899412266e-06,  -9.010848718007959e-09,  -7.737161031670626e-11,   1.555173629656440e-12,   7.422947720525519e-14,  -2.820179081083859e-15,
  -1.184720784418262e-17,   2.628314079050283e-18,   1.781784353061112e-02,  -1.731598561691929e-04,   1.566594730048058e-06,  -9.008704793600257e-09,  -7.721377867377956e-11,
   1.546954773378517e-12,   7.417786302165199e-14,  -2.807050581293748e-15,  -1.206189180330832e-17,   2.615756155697812e-18,   1.781820931287596e-02,  -1.731661584699461e-04,
   1.566487841190953e-06,  -9.005193561599501e-09,  -7.695475443160542e-11,   1.533490329278228e-12,   7.409252546913044e-14,  -2.785544331865948e-15,  -1.241192648160600e-17,
   2.595165639762678e-18,   1.781859742723659e-02,  -1.731728448226078e-04,   1.566374555928290e-06,  -9.001479228620970e-09,  -7.668002156082012e-11,   1.519241701474956e-12,
   7.400115790026545e-14,  -2.762787422672255e-15,  -1.278008526837381e-17,   2.573352170718989e-18,   1.781890286884379e-02,  -1.731781063844775e-04,   1.566285495435380e-06,
  -8.998564238419777e-09,  -7.646388673785063e-11,   1.508055562751475e-12,   7.392866195723662e-14,  -2.744923103682769e-15,  -1.306748072870784e-17,   2.556210114432100e-18,
   1.781907914259040e-02,  -1.731811426814169e-04,   1.566234135198832e-06,  -8.996885227231948e-09,  -7.633918385936932e-11,   1.501610875171853e-12,   7.388658792297327e-14,
  -2.734631476100918e-15,  -1.323240435762805e-17,   2.546327276936722e-18,   1.781914533464806e-02,  -1.731822827932763e-04,   1.566214856160420e-06,  -8.996255362564229e-09,
  -7.629236289469588e-11,   1.499192918127759e-12,   7.387074436289604e-14,  -2.730770309788270e-15,  -1.329415790884663e-17,   2.542618103345135e-18,   1.781915630690339e-02,
  -1.731824717806139e-04,   1.566211660765827e-06,  -8.996150986214261e-09,  -7.628460197739645e-11,   1.498792217207159e-12,   7.386811572960355e-14,  -2.730130447754754e-15,
  -1.330438511988226e-17,   2.542003356708904e-18,   4.977025862352377e-02,  -4.836110958565548e-04,   4.369295508883726e-06,  -2.478238572556864e-08,  -2.291170223873855e-10,
   4.544424235600791e-12,   2.099122904243132e-13,  -8.043697893169547e-15,  -3.282972381145481e-17,   7.494572582461350e-18,   4.977088001809722e-02,  -4.836216538919213e-04,
   4.369102406767967e-06,  -2.477611605424456e-08,  -2.286706643790630e-10,   4.520982363226799e-12,   2.097687653156356e-13,  -8.006259481367044e-15,  -3.344882622723222e-17,
   7.458870776002909e-18,   4.977190011843149e-02,  -4.836389847275423e-04,   4.368785673293148e-06,  -2.476584723820058e-08,  -2.279381235708497e-10,   4.482578980355438e-12,
   2.095314021348118e-13,  -7.944929933384279e-15,  -3.445828425353091e-17,   7.400330867187045e-18,   4.977298249734719e-02,  -4.836573715214791e-04,   4.368449968128562e-06,
  -2.475498361913948e-08,  -2.271611526131094e-10,   4.441938926380707e-12,   2.092771826985265e-13,  -7.880033339700361e-15,  -3.552005524891060e-17,   7.338311773427350e-18,
   4.977383431615448e-02,  -4.836718401730073e-04,   4.368186036784545e-06,  -2.474645730870924e-08,  -2.265498990240213e-10,   4.410033717256199e-12,   2.090754113150070e-13,
  -7.829088718286659e-15,  -3.634893741817672e-17,   7.289572605529299e-18,   4.977432590979807e-02,  -4.836801895734148e-04,   4.368033825207729e-06,  -2.474154598247661e-08,
  -2.261972238449583e-10,   4.391652114652169e-12,   2.089582866955002e-13,  -7.799739388498716e-15,  -3.682460969006278e-17,   7.261472569012194e-18,   4.977451050665473e-02,
  -4.836833247162989e-04,   4.367976688726300e-06,  -2.473970350108962e-08,  -2.260648080940015e-10,   4.384755592439664e-12,   2.089141773397349e-13,  -7.788728210924112e-15,
  -3.700272161425702e-17,   7.250926091613901e-18,   4.977454110614980e-02,  -4.836838444037253e-04,   4.367967218616976e-06,  -2.473939817679243e-08,  -2.260428592008893e-10,
   4.383612709064101e-12,   2.089068588435751e-13,  -7.786903466858726e-15,  -3.703221945476784e-17,   7.249178145543472e-18,   9.838957689519234e-02,  -9.558239275485102e-04,
   8.615944431263453e-06,  -4.777157643294737e-08,  -4.939452399808223e-10,   9.620167800656290e-12,   4.229867019535950e-13,  -1.642912897971459e-14,  -6.388679055030064e-17,
   1.529883389761053e-17,   9.839080216958938e-02,  -9.558442754248091e-04,   8.615527773917104e-06,  -4.775828937427016e-08,  -4.930457033860260e-10,   9.572287612587955e-12,
   4.227057208826186e-13,  -1.635269575189083e-14,  -6.517331266387556e-17,   1.522631048348220e-17,   9.839281361383445e-02,  -9.558776757517525e-04,   8.614844317480350e-06,
  -4.773652525988903e-08,  -4.915694158466433e-10,   9.493848365956680e-12,   4.222408213189844e-13,  -1.622748573814948e-14,  -6.727111920502978e-17,   1.510738895806065e-17,
   9.839494785462828e-02,  -9.559131106450289e-04,   8.614119870192493e-06,  -4.771349800628196e-08,  -4.900035716804308e-10,   9.410840606827549e-12,   4.217426243416507e-13,
  -1.609499150597731e-14,  -6.947778737095155e-17,   1.498139207071537e-17,   9.839662747209714e-02,  -9.559409941634986e-04,   8.613550271305081e-06,  -4.769542326193238e-08,
  -4.887716888415111e-10,   9.345673799189835e-12,   4.213470085125349e-13,  -1.599098064140102e-14,  -7.120055200653151e-17,   1.488236902707400e-17,   9.839759679565527e-02,
  -9.559570847145128e-04,   8.613221763045229e-06,  -4.768501112058782e-08,  -4.880609242175765e-10,   9.308129109112353e-12,   4.211172807293879e-13,  -1.593105920344508e-14,
  -7.218924144390789e-17,   1.482527620998706e-17,   9.839796078316738e-02,  -9.559631265794060e-04,   8.613098446201321e-06,  -4.768110487415479e-08,  -4.877940589680075e-10,
   9.294042857548956e-12,   4.210307498092271e-13,  -1.590857799510823e-14,  -7.255945696577842e-17,   1.480384778459296e-17,   9.839802111914284e-02,  -9.559641280893311e-04,
   8.613078006846600e-06,  -4.768045754859632e-08,  -4.877498240254787e-10,   9.291708500607724e-12,   4.210163920622638e-13,  -1.590485246197113e-14,  -7.262077029575458e-17,
   1.480029627098934e-17,   1.645811932734912e-01,  -1.598335447996187e-03,   1.435993780116254e-05,  -7.694206114050909e-08,  -9.264601907184902e-10,   1.766245090239079e-11,
   7.268398038503321e-13,  -2.878512440943355e-14,  -1.037054878218298e-16,   2.677306351981774e-17,   1.645832352251211e-01,  -1.598368210092995e-03,   1.435915550499669e-05,
  -7.691763253959613e-08,  -9.249142104113812e-10,   1.757855897411129e-11,   7.263791385276578e-13,  -2.865134098513173e-14,  -1.060155338987714e-16,   2.664708465791151e-17,
   1.645865873402357e-01,  -1.598421987005292e-03,   1.435787219148872e-05,  -7.687761444182341e-08,  -9.223769691518680e-10,   1.744112357139472e-11,   7.256163737101573e-13,
  -2.843217862110641e-14,  -1.097825781577664e-16,   2.644049393017243e-17,   1.645901440862090e-01,  -1.598479038460983e-03,   1.435651179060630e-05,  -7.683526805801035e-08,
  -9.196857652482786e-10,   1.729568318841837e-11,   7.247982157058799e-13,  -2.820026162153522e-14,  -1.137454824913261e-16,   2.622159201452432e-17,   1.645929431863795e-01,
  -1.598523931024011e-03,   1.435544208460337e-05,  -7.680202502807990e-08,  -9.175685056424738e-10,   1.718150220403549e-11,   7.241479765417062e-13,  -2.801819836786829e-14,
  -1.168396291062000e-16,   2.604953909257313e-17,   1.645945585707308e-01,  -1.598549836504549e-03,   1.435482511173621e-05,  -7.678287337387980e-08,  -9.163468885379167e-10,
   1.711571876687248e-11,   7.237701777773367e-13,  -2.791330902777411e-14,  -1.186154605009216e-16,   2.595033441095301e-17,   1.645951651577429e-01,  -1.598559563723261e-03,
   1.435459350323309e-05,  -7.677568807335907e-08,  -9.158882150559628e-10,   1.709103770564235e-11,   7.236278330242094e-13,  -2.787395659751801e-14,  -1.192804427747882e-16,
   2.591309923096314e-17,   1.645952657079128e-01,  -1.598561176120158e-03,   1.435455511455090e-05,  -7.677449734108496e-08,  -9.158121863133703e-10,   1.708694758832818e-11,
   7.236042121799013e-13,  -2.786743519175784e-14,  -1.193905750700789e-16,   2.590692787418907e-17,   2.497025368384959e-01,  -2.423894123851070e-03,   2.167553918150385e-05,
  -1.103987404985163e-07,  -1.621014854935363e-09,   3.021862544725845e-11,   1.143300441233089e-12,  -4.651629861716800e-14,  -1.483930551069437e-16,   4.316359687007693e-17,
   2.497056186715469e-01,  -2.423941107837550e-03,   2.167416886504372e-05,  -1.103568787130911e-07,  -1.618582432003450e-09,   3.008305044047491e-11,   1.142629874677343e-12,
  -4.630055358493184e-14,  -1.522528665766533e-16,   4.296273070189521e-17,   2.497106778606852e-01,  -2.424018227006078e-03,   2.167192076725867e-05,  -1.102882938390464e-07,
  -1.614590292270916e-09,   2.986094462934375e-11,   1.141518153217425e-12,  -4.594711452474729e-14,  -1.585477802965029e-16,   4.263329842900050e-17,   2.497160458631379e-01,
  -2.424100039236178e-03,   2.166953739790163e-05,  -1.102157073108997e-07,  -1.610355795120804e-09,   2.962590090287360e-11,   1.140323811855263e-12,  -4.557309521718631e-14,
  -1.651708458007502e-16,   4.228418725890813e-17,   2.497202703730577e-01,  -2.424164413479068e-03,   2.166766314761746e-05,  -1.101587167563406e-07,  -1.607024296211180e-09,
   2.944137404286658e-11,   1.139373252960146e-12,  -4.527946851318280e-14,  -1.703426108702335e-16,   4.200975821126710e-17,   2.497227083657596e-01,  -2.424201560143979e-03,
   2.166658207185143e-05,  -1.101258806109213e-07,  -1.605102055320898e-09,   2.933506165792419e-11,   1.138820432175056e-12,  -4.511030262583641e-14,  -1.733111061549352e-16,
   4.185151050839104e-17,   2.497236238459487e-01,  -2.424215508147461e-03,   2.166617622879217e-05,  -1.101135605516224e-07,  -1.604380316732918e-09,   2.929517461161735e-11,
   1.138612044067349e-12,  -4.504683428991556e-14,  -1.744227439114763e-16,   4.179211174782189e-17,   2.497237755993500e-01,  -2.424217820179190e-03,   2.166610896038522e-05,
  -1.101115188654497e-07,  -1.604260682562745e-09,   2.928856457218013e-11,   1.138577458684691e-12,  -4.503631641296985e-14,  -1.746068524113754e-16,   4.178226686580661e-17,
   3.557454644196759e-01,  -3.451089448517507e-03,   3.065918180120026e-05,  -1.445975545095285e-07,  -2.744400792242692e-09,   5.009007834036957e-11,   1.708108758512587e-12,
  -7.213498811850379e-14,  -1.869976130681584e-16,   6.663190141466660e-17,   3.557498227759852e-01,  -3.451150935171684e-03,   3.065685910387503e-05,  -1.445280430879673e-07,
  -2.740765206904240e-09,   4.987981413796458e-11,   1.707235036609124e-12,  -7.180180393972632e-14,  -1.932578761325940e-16,   6.632702130976031e-17,   3.557569774878448e-01,
  -3.451251854431626e-03,   3.065304826041492e-05,  -1.444141429072921e-07,  -2.734798220709538e-09,   4.953534577467052e-11,   1.705783029753375e-12,  -7.125595400421803e-14,
  -2.034690399354582e-16,   6.582691878353448e-17,   3.557645688703531e-01,  -3.451358909015342e-03,   3.064900770494901e-05,  -1.442935765481401e-07,  -2.728468725668578e-09,
   4.917080775365232e-11,   1.704218452494364e-12,  -7.067829425420718e-14,  -2.142143945125306e-16,   6.529683245855029e-17,   3.557705430968778e-01,  -3.451443140891615e-03,
   3.064582997008886e-05,  -1.441989002318289e-07,  -2.723488794828615e-09,   4.888461534072751e-11,   1.702969909006656e-12,  -7.022477951087230e-14,  -2.226065078104693e-16,
   6.488006366441963e-17,   3.557739908471042e-01,  -3.451491744488704e-03,   3.064399692031216e-05,  -1.441443447703150e-07,  -2.720615350345085e-09,   4.871972872451018e-11,
   1.702242476931103e-12,  -6.996349060434298e-14,  -2.274239723574119e-16,   6.463970522039086e-17,   3.557752854940766e-01,  -3.451509994061487e-03,   3.064330875880218e-05,
  -1.441238745340029e-07,  -2.719536451738621e-09,   4.865786515998729e-11,   1.701968023004379e-12,  -6.986545778675053e-14,  -2.292281136677993e-16,   6.454948001471327e-17,
   3.557755000994193e-01,  -3.451513019107061e-03,   3.064319469498652e-05,  -1.441204821368737e-07,  -2.719357614579435e-09,   4.864761318362730e-11,   1.701922460047498e-12,
  -6.984921186233165e-14,  -2.295269195246940e-16,   6.453452557730234e-17,   4.856689688947487e-01,  -4.707276444109721e-03,   4.142593613430261e-05,  -1.725323210716669e-07,
  -4.610342794984074e-09,   8.271770296399391e-11,   2.482055795904755e-12,  -1.104740303640071e-13,  -1.879844711092934e-16,   1.011377666117109e-16,   4.856748562543537e-01,
  -4.707349696205247e-03,   4.142202956675181e-05,  -1.724173197350736e-07,  -4.605056254284049e-09,   8.239561894100365e-11,   2.481097437143078e-12,  -1.099679748928532e-13,
  -1.981701831523370e-16,   1.006874626979597e-16,   4.856845209112446e-01,  -4.707469916524235e-03,   4.141561956236079e-05,  -1.722288543666709e-07,  -4.596379130676190e-09,
   8.186795110009499e-11,   2.479495399649741e-12,  -1.091388672163723e-13,  -2.147872635967530e-16,   9.994862318415631e-17,   4.856947753202213e-01,  -4.707597432263776e-03,
   4.140882248024267e-05,  -1.720293231311996e-07,  -4.587174214735251e-09,   8.130952765905317e-11,   2.477756622126109e-12,  -1.082613809037300e-13,  -2.322778538242014e-16,
   9.916522352767871e-17,   4.857028452039119e-01,  -4.707697753609620e-03,   4.140347634639973e-05,  -1.718726127782637e-07,  -4.579931496690850e-09,   8.087111036519209e-11,
   2.476360164268888e-12,  -1.075724308954763e-13,  -2.459410360473524e-16,   9.854910371773825e-17,   4.857075023352851e-01,  -4.707755637320541e-03,   4.140039227279024e-05,
  -1.717823009968627e-07,  -4.575752229656758e-09,   8.061851752319624e-11,   2.475543047034900e-12,  -1.071754800611184e-13,  -2.537855638851642e-16,   9.819370046209697e-17,
   4.857092511048881e-01,  -4.707777370641908e-03,   4.139923441529929e-05,  -1.717484123560078e-07,  -4.574182996380943e-09,   8.052374692355245e-11,   2.475234100582925e-12,
  -1.070265449790840e-13,  -2.567235727296806e-16,   9.806027581172641e-17,   4.857095409869231e-01,  -4.707780973114540e-03,   4.139904249665610e-05,  -1.717427961118315e-07,
  -4.573922880013260e-09,   8.050804158667448e-11,   2.475182777053694e-12,  -1.070018633931831e-13,  -2.572101844680826e-16,   9.803816050614603e-17,   6.440531629330402e-01,
  -6.234173607776570e-03,   5.408535400746209e-05,  -1.790344539463107e-07,  -7.872706029247167e-09,   1.399431668524225e-10,   3.575514756924640e-12,  -1.720130397875886e-13,
  -5.143765255143787e-17,   1.545879275548787e-16,   6.440608462460490e-01,  -6.234249353712371e-03,   5.407867514271106e-05,  -1.788395292987110e-07,  -7.865080845982461e-09,
   1.394414528843391e-10,   3.574955417292999e-12,  -1.712386710281545e-13,  -6.867550539391476e-17,   1.539325129728930e-16,   6.440734589681800e-01,  -6.234373643764135e-03,
   5.406771540826432e-05,  -1.785200398643727e-07,  -7.852563922819406e-09,   1.386194693679698e-10,   3.573988495971764e-12,  -1.699698455933531e-13,  -9.680494371343474e-17,
   1.528566232963798e-16,   6.440868411177934e-01,  -6.234505444796238e-03,   5.405609267420964e-05,  -1.781817303357282e-07,  -7.839283966444824e-09,   1.377495361089878e-10,
   3.572896629548727e-12,  -1.686268208968789e-13,  -1.264231479015261e-16,   1.517151526768507e-16,   6.440973722715270e-01,  -6.234609114814671e-03,   5.404695014852688e-05,
  -1.779159803081699e-07,  -7.828833664542273e-09,   1.370665243294817e-10,   3.571989827721246e-12,  -1.675722404067144e-13,  -1.495674124420602e-16,   1.508169228672970e-16,
   6.441034497384462e-01,  -6.234668921547517e-03,   5.404167567283274e-05,  -1.777628114960838e-07,  -7.822803039738676e-09,   1.366729976244087e-10,   3.571447523608365e-12,
  -1.669645781324075e-13,  -1.628583110692891e-16,   1.502985884161905e-16,   6.441057318370936e-01,  -6.234691375176260e-03,   5.403969540529603e-05,  -1.777053329946713e-07,
  -7.820538566218704e-09,   1.365253477213712e-10,   3.571240305399920e-12,  -1.667365757311307e-13,  -1.678367039888616e-16,   1.501039591293877e-16,   6.441061101249399e-01,
  -6.234695096954872e-03,   5.403936716609868e-05,  -1.776958071095854e-07,  -7.820163201889931e-09,   1.365008791383453e-10,   3.571205767477839e-12,  -1.666987906086284e-13,
  -1.686612865139052e-16,   1.500716971080612e-16,   8.385543407952593e-01,  -8.099791682703231e-03,   6.862600013695396e-05,  -1.261109430444586e-07,  -1.413542585023841e-08,
   2.526241055304594e-10,   5.207417925000139e-12,  -2.842868569794213e-13,   6.067851554717570e-16,   2.446824817278159e-16,   8.385640826359989e-01,  -8.099844278226827e-03,
   6.861399378920493e-05,  -1.257584302549897e-07,  -1.412429010131532e-08,   2.517941077737393e-10,   5.209175577094509e-12,  -2.830583937111750e-13,   5.746945102445369e-16,
   2.437505368474710e-16,   8.385800742198919e-01,  -8.099930515146139e-03,   6.859429030384631e-05,  -1.251805690305758e-07,  -1.410600660278807e-08,   2.504341692231606e-10,
   5.211970310746225e-12,  -2.810451347340717e-13,   5.223063592006066e-16,   2.422190587434408e-16,   8.385970408628755e-01,  -8.100021873704604e-03,   6.857339273085707e-05,
  -1.245685613313997e-07,  -1.408660325988476e-08,   2.489947492352305e-10,   5.214812880518986e-12,  -2.789136198165470e-13,   4.671165782987457e-16,   2.405919984798672e-16,
   8.386103924959710e-01,  -8.100093668150444e-03,   6.855695299967974e-05,  -1.240877378777289e-07,  -1.407133051442490e-08,   2.478645068723738e-10,   5.216961405513321e-12,
  -2.772395176758500e-13,   4.239691812801315e-16,   2.393100521684567e-16,   8.386180975019575e-01,  -8.100135059988032e-03,   6.854746802269378e-05,  -1.238105775123414e-07,
  -1.406251544689997e-08,   2.472132585318644e-10,   5.218165967565965e-12,  -2.762747287394957e-13,   3.991827961997457e-16,   2.385696506745820e-16,   8.386209907171271e-01,
  -8.100150595073866e-03,   6.854390683238795e-05,  -1.237065637927659e-07,  -1.405920513974005e-08,   2.469689041109935e-10,   5.218611616890874e-12,  -2.759126995793037e-13,
   3.898969261981197e-16,   2.382915172090051e-16,   8.386214703041436e-01,  -8.100153169816847e-03,   6.854331654117733e-05,  -1.236893253393467e-07,  -1.405865640047401e-08,
   2.469284091946998e-10,   5.218685137815480e-12,  -2.758527017125486e-13,   3.883588022698946e-16,   2.382454070849160e-16,   1.083864728961628e+00,  -1.042835433441959e-02,
   8.429149588829128e-05,   1.090516568949402e-07,  -2.861482150194473e-08,   5.307123017978152e-10,   7.840593729041089e-12,  -5.489411235860673e-13,   3.947217975351373e-15,
   4.136171707030076e-16,   1.083876675322077e+00,  -1.042830516016465e-02,   8.426715914331108e-05,   1.097933607251712e-07,  -2.859791833432557e-08,   5.291051582000549e-10,
   7.854797530752602e-12,  -5.468509989086388e-13,   3.873208133987475e-15,   4.125515308375858e-16,   1.083896284719002e+00,  -1.042822420695116e-02,   8.422721691999826e-05,
   1.110093484242889e-07,  -2.857014793821982e-08,   5.264712674799235e-10,   7.877905574923742e-12,  -5.434237411102747e-13,   3.752293751761629e-15,   4.107922207396885e-16,
   1.083917088425124e+00,  -1.042813800284074e-02,   8.418484938695594e-05,   1.122973801036868e-07,  -2.854065288544801e-08,   5.236826109300759e-10,   7.902140783921328e-12,
  -5.397926389205782e-13,   3.624786923221843e-15,   4.089121430313375e-16,   1.083933458604734e+00,  -1.042806993805667e-02,   8.415151624065649e-05,   1.133094586435695e-07,
  -2.851741961479316e-08,   5.214923400178184e-10,   7.921008962769288e-12,  -5.369389276555912e-13,   3.525010690413507e-15,   4.074229721056706e-16,   1.083942905175005e+00,
  -1.042803056774244e-02,   8.413228317057136e-05,   1.138929045805332e-07,  -2.850400306403211e-08,   5.202300609237492e-10,   7.931816196664403e-12,  -5.352935975456969e-13,
   3.467656757016382e-15,   4.065597510440749e-16,   1.083946452270772e+00,  -1.042801576702290e-02,   8.412506174429937e-05,   1.141118726148245e-07,  -2.849896347583136e-08,
   5.197563967970834e-10,   7.935858957057033e-12,  -5.346760632011223e-13,   3.446162982754372e-15,   4.062348902142860e-16,   1.083947040242893e+00,  -1.042801331270702e-02,
   8.412386473082999e-05,   1.141481632815574e-07,  -2.849812801084161e-08,   5.196778978163899e-10,   7.936528287380880e-12,  -5.345737140681626e-13,   3.442602359367373e-15,
   4.061810023761196e-16,   1.417465173626573e+00,  -1.349498080307618e-02,   9.392081510696198e-05,   1.227148693488557e-06,  -8.312640463230535e-08,   1.770001223310562e-09,
   1.120971465567628e-11,  -1.808146213438007e-12,   4.185811477969723e-14,   3.999346612369158e-16,   1.417478396815283e+00,  -1.349444817640350e-02,   9.384998539407111e-05,
   1.229622249835749e-06,  -8.310057687824174e-08,   1.764633610971291e-09,   1.137035308576730e-11,  -1.805918796794160e-12,   4.156102777018372e-14,   4.066553091468096e-16,
   1.417500097559206e+00,  -1.349357303081888e-02,   9.373372349243898e-05,   1.233677487214859e-06,  -8.305793186118740e-08,   1.755826732263298e-09,   1.163321592966607e-11,
  -1.802237813832007e-12,   4.107408850145359e-14,   4.176130617713835e-16,   1.417523113859336e+00,  -1.349264341165327e-02,   9.361038318300176e-05,   1.237972927644681e-06,
  -8.301235051602546e-08,   1.746488676038569e-09,   1.191097819559373e-11,  -1.798299108042555e-12,   4.055846791183449e-14,   4.291380157198221e-16,   1.417541220665783e+00,
  -1.349191105721012e-02,   9.351333010479391e-05,   1.241348048450400e-06,  -8.297623817095214e-08,   1.739144466409237e-09,   1.212874290010620e-11,  -1.795175625689420e-12,
   4.015344164642489e-14,   4.381345045362395e-16,   1.417551667594973e+00,  -1.349148810504145e-02,   9.345732546785493e-05,   1.243293727450179e-06,  -8.295530117734620e-08,
   1.734907946746159e-09,   1.225408451783561e-11,  -1.793363541880778e-12,   3.992000253220101e-14,   4.432970699131560e-16,   1.417555589979685e+00,  -1.349132922635904e-02,
   9.343629641829383e-05,   1.244023939345682e-06,  -8.294742103284884e-08,   1.733317464196895e-09,   1.230108832741239e-11,  -1.792681302806653e-12,   3.983240241846582e-14,
   4.452300991758806e-16,   1.417556240142551e+00,  -1.349130288699303e-02,   9.343281061824958e-05,   1.244144960796668e-06,  -8.294611383203850e-08,   1.733053838631871e-09,
   1.230887654775386e-11,  -1.792568117936145e-12,   3.981788453937945e-14,   4.455502330289266e-16,   1.900247178496663e-03,  -1.784845528507605e-05,   1.609952441881530e-07,
  -1.104379869171401e-09,  -3.682840096272424e-12,   2.642413851264643e-13,   2.045571128050584e-16,  -2.258884342576648e-16,   5.142104228248724e-18,   6.139539698819259e-20,
   1.900270082987036e-03,  -1.784892546176869e-05,   1.609921035322042e-07,  -1.104009484311168e-09,  -3.682169516899585e-12,   2.635716109069164e-13,   2.243357432246015e-16,
  -2.255596119268248e-16,   5.107747697833646e-18,   6.193430988361135e-20,   1.900307684093692e-03,  -1.784969721995843e-05,   1.609869481247132e-07,  -1.103402124297252e-09,
  -3.681038513583149e-12,   2.624727875114928e-13,   2.567072962610883e-16,  -2.250178544732390e-16,   5.051463677980551e-18,   6.281197115988857e-20,   1.900347581337675e-03,
  -1.785051596166219e-05,   1.609814785115525e-07,  -1.102758601222123e-09,  -3.679797553233298e-12,   2.613078309253651e-13,   2.909226454063830e-16,  -2.244403822824841e-16,
   4.991902135176468e-18,   6.373368370733546e-20,   1.900378980362523e-03,  -1.785116020472310e-05,   1.609771743921446e-07,  -1.102252820260465e-09,  -3.678791378710342e-12,
   2.603917152604610e-13,   3.177538874228986e-16,  -2.239840187108852e-16,   4.945142898415867e-18,   6.445218228926703e-20,   1.900397101227174e-03,  -1.785153196554210e-05,
   1.609746906016386e-07,  -1.101961194676450e-09,  -3.678198879088635e-12,   2.598632926971072e-13,   3.332001211304032e-16,  -2.237198884503227e-16,   4.918203749203473e-18,
   6.486408604573179e-20,   1.900403905768120e-03,  -1.785167155702857e-05,   1.609737579518986e-07,  -1.101851737484265e-09,  -3.677974158661555e-12,   2.596649188394043e-13,
   3.389930452820546e-16,  -2.236205628468337e-16,   4.908096625790382e-18,   6.501824003222414e-20,   1.900405033716918e-03,  -1.785169469587260e-05,   1.609736033538821e-07,
  -1.101833596084124e-09,  -3.677936790404711e-12,   2.596320383870941e-13,   3.399529209281935e-16,  -2.236040907224039e-16,   4.906421689439747e-18,   6.504376585346053e-20,
   1.714935241704986e-02,  -1.610734435802462e-04,   1.452368989681226e-06,  -9.929790576899638e-09,  -3.474465289488623e-11,   2.421120272038883e-12,   1.618489107649742e-15,
  -2.055526127677031e-15,   4.694168827075791e-17,   5.557447541425588e-19,   1.714955904023547e-02,  -1.610776708461565e-04,   1.452339355897640e-06,  -9.926396560882824e-09,
  -3.473906241694067e-11,   2.415025278849439e-12,   1.799054792786939e-15,  -2.052547929257665e-15,   4.662848017552706e-17,   5.606880442591791e-19,   1.714989824260311e-02,
  -1.610846095522348e-04,   1.452290711368772e-06,  -9.920830983206199e-09,  -3.472960959120943e-11,   2.405025877745662e-12,   2.094586701491011e-15,  -2.047640915751729e-15,
   4.611536884836015e-17,   5.687388289890007e-19,   1.715025815841307e-02,  -1.610919706500108e-04,   1.452239101458922e-06,  -9.914933964200571e-09,  -3.471920621234521e-11,
   2.394424617735923e-12,   2.406953006447023e-15,  -2.042410107631649e-15,   4.557237359403401e-17,   5.771940433572238e-19,   1.715054141106562e-02,  -1.610977628557427e-04,
   1.452198488383909e-06,  -9.910299122645972e-09,  -3.471074908293205e-11,   2.386087814120976e-12,   2.651907921741562e-15,  -2.038276095789056e-15,   4.514608784236614e-17,
   5.837853526241051e-19,   1.715070488051538e-02,  -1.611011052435825e-04,   1.452175051489478e-06,  -9.907626726565154e-09,  -3.470576042746434e-11,   2.381279070023463e-12,
   2.792924281421607e-15,  -2.035883360038758e-15,   4.490049281250652e-17,   5.875641466959166e-19,   1.715076626469346e-02,  -1.611023602664915e-04,   1.452166251027703e-06,
  -9.906623680418360e-09,  -3.470386677029630e-11,   2.379473828643618e-12,   2.845810863880382e-15,  -2.034983560616981e-15,   4.480834937275013e-17,   5.889783705655697e-19,
   1.715077643998770e-02,  -1.611025683004435e-04,   1.452164792242417e-06,  -9.906457435698384e-09,  -3.470355179560681e-11,   2.379174609902088e-12,   2.854574066990297e-15,
  -2.034834337322306e-15,   4.479307949616178e-17,   5.892125479868610e-19,   4.790376241108885e-02,  -4.499002990286019e-04,   4.053589538982608e-06,  -2.752328837939109e-08,
  -1.057776935147987e-10,   6.974116104778361e-12,   3.182413283760201e-15,  -5.839616392229921e-15,   1.342416174820753e-16,   1.561313721236491e-18,   4.790433908519004e-02,
  -4.499120148091388e-04,   4.053499297447595e-06,  -2.751350978169478e-08,  -1.057647922165911e-10,   6.956799301469684e-12,   3.698839108833211e-15,  -5.831239090461353e-15,
   1.333484829824901e-16,   1.575589459316359e-18,   4.790528577981804e-02,  -4.499312451763435e-04,   4.053351161248837e-06,  -2.749747438563246e-08,  -1.057428256739199e-10,
   6.928389303108683e-12,   4.544080884449759e-15,  -5.817434923526295e-15,   1.318852908220957e-16,   1.598840842956845e-18,   4.790629028343560e-02,  -4.499516460316311e-04,
   4.053193990990375e-06,  -2.748048371061585e-08,  -1.057184500604776e-10,   6.898269080313947e-12,   5.437480352922116e-15,  -5.802718054662697e-15,   1.303368546274002e-16,
   1.623262306600446e-18,   4.790708082397561e-02,  -4.499676986815660e-04,   4.053070307294305e-06,  -2.746712941508247e-08,  -1.056984951747421e-10,   6.874582440711604e-12,
   6.138083719134616e-15,  -5.791085714353346e-15,   1.291212145697389e-16,   1.642301685885618e-18,   4.790753705673828e-02,  -4.499769618058761e-04,   4.052998931140317e-06,
  -2.745942938410671e-08,  -1.056866702597948e-10,   6.860919702221787e-12,   6.541412049509615e-15,  -5.784352481551785e-15,   1.284208429338751e-16,   1.653217552698045e-18,
   4.790770837598914e-02,  -4.499804399793850e-04,   4.052972129472564e-06,  -2.745653926754409e-08,  -1.056821716315623e-10,   6.855790586713914e-12,   6.692676310429239e-15,
  -5.781820320294624e-15,   1.281580729191451e-16,   1.657302959271584e-18,   4.790773677457089e-02,  -4.499810165247322e-04,   4.052967686754258e-06,  -2.745606025906972e-08,
  -1.056814228479345e-10,   6.854940435176262e-12,   6.717740531481725e-15,  -5.781400379957808e-15,   1.281145269783063e-16,   1.657979456478260e-18,   9.470033883114708e-02,
  -8.893063275695721e-04,   8.002978214255659e-06,  -5.373865554208914e-08,  -2.365880896985104e-10,   1.445496734255637e-11,   1.956638098990592e-15,  -1.185192970922274e-14,
   2.753170831642385e-16,   3.110842448078228e-18,   9.470147730771432e-02,  -8.893291982188734e-04,   8.002776305777081e-06,  -5.371838158644635e-08,  -2.365713836004990e-10,
   1.441981723765875e-11,   3.015954045489820e-15,  -1.183520413922943e-14,   2.734938487839725e-16,   3.140571059541866e-18,   9.470334628056175e-02,  -8.893667379056511e-04,
   8.002444854588014e-06,  -5.368513464772199e-08,  -2.365423434663017e-10,   1.436214928287399e-11,   4.749776910035658e-15,  -1.180763918780460e-14,   2.705068400670335e-16,
   3.188995949660817e-18,   9.470532937709265e-02,  -8.894065620143471e-04,   8.002093179171118e-06,  -5.364990603740645e-08,  -2.365093399627251e-10,   1.430100903543374e-11,
   6.582418089935693e-15,  -1.177824568509524e-14,   2.673457230304748e-16,   3.239864379221951e-18,   9.470689006413445e-02,  -8.894378977198727e-04,   8.001816423609006e-06,
  -5.362221636881741e-08,  -2.364817840904527e-10,   1.425292757313786e-11,   8.019598639780495e-15,  -1.175500848875719e-14,   2.648639422772390e-16,   3.279527090815297e-18,
   9.470779075898846e-02,  -8.894559797337758e-04,   8.001656708649352e-06,  -5.360625031743995e-08,  -2.364652480700985e-10,   1.422519337738670e-11,   8.846974723356035e-15,
  -1.174155621434558e-14,   2.634340784057319e-16,   3.302268902175192e-18,   9.470812897732103e-02,  -8.894627692498417e-04,   8.001596735260842e-06,  -5.360025758927336e-08,
  -2.364589191235302e-10,   1.421478166620596e-11,   9.157275702442554e-15,  -1.173649690565851e-14,   2.628976079145083e-16,   3.310780693454664e-18,   9.470818504176952e-02,
  -8.894638946850529e-04,   8.001586793875219e-06,  -5.359926435031986e-08,  -2.364578637088313e-10,   1.421305592148400e-11,   9.208692124322483e-15,  -1.173565783949086e-14,
   2.628087043961567e-16,   3.312190169532424e-18,   1.584114486317704e-01,  -1.487369509094195e-03,   1.336167762545580e-05,  -8.826227849435731e-08,  -4.626893812556710e-10,
   2.581762624958589e-11,  -7.722961043591401e-15,  -2.057288578621724e-14,   4.851728976205549e-16,   5.248501478628996e-18,   1.584133493022878e-01,  -1.487407062326847e-03,
   1.336128260354034e-05,  -8.822605293811010e-08,  -4.626837808927155e-10,   2.575660031977922e-11,  -5.855741844345232e-15,  -2.054457727835331e-14,   4.819822115881330e-16,
   5.302029522697221e-18,   1.584164695200279e-01,  -1.487468700980031e-03,   1.336063412154479e-05,  -8.816664540145328e-08,  -4.626717411479043e-10,   2.565647843374964e-11,
  -2.799527860012124e-15,  -2.049791112986837e-14,   4.767547342945982e-16,   5.389233657477467e-18,   1.584197802571503e-01,  -1.487534089339912e-03,   1.335994604712194e-05,
  -8.810369442500482e-08,  -4.626551059904295e-10,   2.555032593635176e-11,   4.309616574382714e-16,  -2.044813358168930e-14,   4.712223254121243e-16,   5.480855021043990e-18,
   1.584223857848061e-01,  -1.487585539459733e-03,   1.335940454060841e-05,  -8.805421319846728e-08,  -4.626392252756008e-10,   2.546684476443443e-11,   2.964416502985846e-15,
  -2.040877036319810e-14,   4.668786869660385e-16,   5.552305541922245e-18,   1.584238894697902e-01,  -1.487615227978252e-03,   1.335909203153447e-05,  -8.802568126721918e-08,
  -4.626289443150261e-10,   2.541869081820233e-11,   4.422936594772837e-15,  -2.038597805762784e-14,   4.643760581675747e-16,   5.593278792092912e-18,   1.584244541154348e-01,
  -1.487626375489981e-03,   1.335897468222942e-05,  -8.801497190173780e-08,  -4.626248730332468e-10,   2.540061320240208e-11,   4.969948070524174e-15,  -2.037740518156810e-14,
   4.634370846126748e-16,   5.608615172162525e-18,   1.584245477133733e-01,  -1.487628223306247e-03,   1.335895522995374e-05,  -8.801319691684358e-08,  -4.626241870515203e-10,
   2.539761682534683e-11,   5.060587333224735e-15,  -2.037598335978093e-14,   4.632814779067749e-16,   5.611154788285507e-18,   2.403448262954320e-01,  -2.256176427852190e-03,
   2.021871316258857e-05,  -1.304453355624256e-07,  -8.452166102668254e-10,   4.270836278881360e-11,  -3.658233244647303e-14,  -3.280601200196609e-14,   7.901260824801500e-16,
   8.013707206369697e-18,   2.403477021151306e-01,  -2.256231906185222e-03,   2.021799125865032e-05,  -1.303853796253635e-07,  -8.452587170857173e-10,   4.261102237543379e-11,
  -3.354040173325430e-14,  -3.276257588233288e-14,   7.849824667950203e-16,   8.103442339130285e-18,   2.403524231644600e-01,  -2.256322964541751e-03,   2.021680612184099e-05,
  -1.302870520764400e-07,  -8.453232054288590e-10,   4.245131767845303e-11,  -2.856129826612343e-14,  -3.269094445015102e-14,   7.765550001789482e-16,   8.249660511622215e-18,
   2.403574324619507e-01,  -2.256419559633768e-03,   2.021554858170641e-05,  -1.301828545634511e-07,  -8.453853431113208e-10,   4.228198861146172e-11,  -2.329806149857825e-14,
  -3.261449981364421e-14,   7.676354016777140e-16,   8.403323327015317e-18,   2.403613747324743e-01,  -2.256495562491282e-03,   2.021455887891518e-05,  -1.301009487199544e-07,
  -8.454297017937801e-10,   4.214882013612407e-11,  -1.917030960922685e-14,  -3.255402198138692e-14,   7.606320050135237e-16,   8.523184316207465e-18,   2.403636498646517e-01,
  -2.256539418020615e-03,   2.021398769763098e-05,  -1.300537185839915e-07,  -8.454534837943021e-10,   4.207200393826042e-11,  -1.679388598042897e-14,  -3.251899314193816e-14,
   7.565967762875107e-16,   8.591929671467856e-18,   2.403645041938832e-01,  -2.256555884846495e-03,   2.021377321258528e-05,  -1.300359906299914e-07,  -8.454620708818245e-10,
   4.204316587341988e-11,  -1.590260745707747e-14,  -3.250581573563750e-14,   7.550827498480292e-16,   8.617663328969001e-18,   2.403646458108905e-01,  -2.256558614386776e-03,
   2.021373765857815e-05,  -1.300330523598764e-07,  -8.454634762136851e-10,   4.203838593051787e-11,  -1.575492288186174e-14,  -3.250363014177497e-14,   7.548318438329787e-16,
   8.621924786112587e-18,   3.424197247674953e-01,  -3.213415916067922e-03,   2.869897272663101e-05,  -1.789400444950320e-07,  -1.491602035485295e-09,   6.803775862395353e-11,
  -1.058035012153142e-13,  -4.991393473410003e-14,   1.237794211252111e-15,   1.138580753329363e-17,   3.424238062791130e-01,  -3.213491972115453e-03,   2.869769819895780e-05,
  -1.788444717872529e-07,  -1.491771483045686e-09,   6.788959492200799e-11,  -1.010356163847855e-13,  -4.985172679960242e-14,   1.229856233666502e-15,   1.153186926127740e-17,
   3.424305066099698e-01,  -3.213616801231696e-03,   2.869560576868415e-05,  -1.786877256908152e-07,  -1.492042389617099e-09,   6.764649707753057e-11,  -9.323108091141501e-14,
  -4.974907455861422e-14,   1.216849497314694e-15,   1.176992880355879e-17,   3.424376160008258e-01,  -3.213749214919744e-03,   2.869338542285600e-05,  -1.785216124304578e-07,
  -1.492319982339499e-09,   6.738873808375316e-11,  -8.498070355515460e-14,  -4.963943868096651e-14,   1.203082003327980e-15,   1.202019139351260e-17,   3.424432109998891e-01,
  -3.213853396499031e-03,   2.869163791723391e-05,  -1.783910298444849e-07,  -1.492531325307722e-09,   6.718601599243293e-11,  -7.850990994909150e-14,  -4.955264049806621e-14,
   1.192271311495856e-15,   1.221546254927432e-17,   3.424464399315868e-01,  -3.213913510232287e-03,   2.869062936540867e-05,  -1.783157279563708e-07,  -1.492650444767525e-09,
   6.706907561930344e-11,  -7.478441590818136e-14,  -4.950234235907272e-14,   1.186042039181571e-15,   1.232748291005156e-17,   3.424476524177816e-01,  -3.213936081365312e-03,
   2.869025063816529e-05,  -1.782874626632994e-07,  -1.492694637084573e-09,   6.702517366807524e-11,  -7.338714202806261e-14,  -4.948341622720624e-14,   1.183704736869559e-15,
   1.236942039745059e-17,   3.424478534042085e-01,  -3.213939822739148e-03,   2.869018785838876e-05,  -1.782827778832320e-07,  -1.492701934214258e-09,   6.701789683623136e-11,
  -7.315561280608705e-14,  -4.948027691196870e-14,   1.183317393251224e-15,   1.237636542709421e-17,   4.674879812537776e-01,  -4.385262898476731e-03,   3.897521344030271e-05,
  -2.308525907437973e-07,  -2.602092256929801e-09,   1.072955162165112e-10,  -2.607423314600601e-13,  -7.432909311333671e-14,   1.920929617652316e-15,   1.509033246755886e-17,
   4.674935232397665e-01,  -4.385360922049294e-03,   3.897298904552290e-05,  -2.307017641374663e-07,  -2.602561234292521e-09,   1.070747363280916e-10,  -2.533373271476102e-13,
  -7.424545196056649e-14,   1.908889902800930e-15,   1.532872915783083e-17,   4.675026210777816e-01,  -4.385521797507858e-03,   3.896933707962344e-05,  -2.304543843651109e-07,
  -2.603319843897759e-09,   1.067124751319534e-10,  -2.412152845878113e-13,  -7.410727894553719e-14,   1.889160214086484e-15,   1.571741304962257e-17,   4.675122742759971e-01,
  -4.385692436188060e-03,   3.896546170940198e-05,  -2.301922030490453e-07,  -2.604109468705678e-09,   1.063283400635022e-10,  -2.283996525335684e-13,  -7.395949985990021e-14,
   1.868273743319580e-15,   1.612620032366459e-17,   4.675198711684950e-01,  -4.385826684421072e-03,   3.896241152066161e-05,  -2.299860877055003e-07,  -2.604719839264391e-09,
   1.060262070322823e-10,  -2.183475172276908e-13,  -7.384235636039323e-14,   1.851870974147292e-15,   1.644529295855599e-17,   4.675242553934264e-01,  -4.385904143550873e-03,
   3.896065109704780e-05,  -2.298672237638674e-07,  -2.605067666814592e-09,   1.058519138808830e-10,  -2.125597813372862e-13,  -7.377441500211722e-14,   1.842418660526549e-15,
   1.662839783532431e-17,   4.675259016964200e-01,  -4.385933226794877e-03,   3.895999002168099e-05,  -2.298226060383846e-07,  -2.605197443238467e-09,   1.057864790356569e-10,
  -2.103889879274678e-13,  -7.374883908888934e-14,   1.838871879620221e-15,   1.669695743197680e-17,   4.675261745938058e-01,  -4.385938047577969e-03,   3.895988043798779e-05,
  -2.298152109014443e-07,  -2.605218911442558e-09,   1.057756330109735e-10,  -2.100292828022471e-13,  -7.374459618210142e-14,   1.838284090130396e-15,   1.670831172292349e-17,
   6.199655133397685e-01,  -5.811990741809904e-03,   5.128426976674574e-05,  -2.795282584782977e-07,  -4.588281854708736e-09,   1.720021444977473e-10,  -6.114068928542687e-13,
  -1.107847925994884e-13,   3.043055286051247e-15,   1.784479421205880e-17,   6.199728035765545e-01,  -5.812109224201637e-03,   5.128034555122397e-05,  -2.792862665566080e-07,
  -4.589447996147265e-09,   1.716727230530462e-10,  -5.996617263033202e-13,  -1.106826376834917e-13,   3.024686778053893e-15,   1.824863807074045e-17,   6.199847712758274e-01,
  -5.812303658207654e-03,   5.127390264037433e-05,  -2.788893357742690e-07,  -4.591344486808248e-09,   1.711321519783976e-10,  -5.804327543787614e-13,  -1.105134704336248e-13,
   2.994580807351410e-15,   1.890737460700826e-17,   6.199974693803003e-01,  -5.812509867180050e-03,   5.126706530125774e-05,  -2.784686209387876e-07,  -4.593332500552896e-09,
   1.705588752449723e-10,  -5.601007659885137e-13,  -1.103319905423915e-13,   2.962702664459755e-15,   1.960059878960605e-17,   6.200074624574430e-01,  -5.812672081979364e-03,
   5.126168362327996e-05,  -2.781378486686107e-07,  -4.594879511924593e-09,   1.701079299237750e-10,  -5.441510454640436e-13,  -1.101877377798854e-13,   2.937662748390729e-15,
   2.014202070104574e-17,   6.200132294982054e-01,  -5.812765670166769e-03,   5.125857749020300e-05,  -2.779470867780675e-07,  -4.595765292605150e-09,   1.698477717851939e-10,
  -5.349668380579868e-13,  -1.101039168266718e-13,   2.923231142128385e-15,   2.045282638435370e-17,   6.200153950492171e-01,  -5.812800807954759e-03,   5.125741105710651e-05,
  -2.778754789736769e-07,  -4.596096584708943e-09,   1.697500971117388e-10,  -5.315219847322715e-13,  -1.100723337770804e-13,   2.917815605341508e-15,   2.056922378904254e-17,
   6.200157540187043e-01,  -5.812806632255595e-03,   5.125721770153160e-05,  -2.778636102835065e-07,  -4.596151431126775e-09,   1.697339070501588e-10,  -5.309511570842402e-13,
  -1.100670927725548e-13,   2.916918096577327e-15,   2.058850181195711e-17,   8.072387236390535e-01,  -7.560266698975999e-03,   6.593729185392073e-05,  -3.076459115732732e-07,
  -8.437925597016357e-09,   2.907932091874425e-10,  -1.481772503334139e-12,  -1.697734183013042e-13,   5.142793389224717e-15,   1.374992975257708e-17,   8.072480924783522e-01,
  -7.560396593741922e-03,   6.593007071090880e-05,  -3.072363611852118e-07,  -8.440853160202637e-09,   2.902873320833936e-10,  -1.461879725938573e-12,  -1.696830976777006e-13,
   5.113858374378774e-15,   1.449697156718650e-17,   8.072634721994809e-01,  -7.560609711653139e-03,   6.591821430329878e-05,  -3.065645376126135e-07,  -8.445628855660329e-09,
   2.894570608118827e-10,  -1.429305489734142e-12,  -1.695321084218517e-13,   5.066418543699546e-15,   1.571635257613388e-17,   8.072797902599453e-01,  -7.560835675929207e-03,
   6.590563139371059e-05,  -3.058523870299932e-07,  -8.450655027728131e-09,   2.885763645052569e-10,  -1.394854382145463e-12,  -1.693682236570147e-13,   5.016165387646438e-15,
   1.700070403762746e-17,   8.072926319262794e-01,  -7.561013387769486e-03,   6.589572688802964e-05,  -3.052924319545759e-07,  -8.454580869373007e-09,   2.878834612139849e-10,
  -1.367822681330691e-12,  -1.692365968771843e-13,   4.976677100211805e-15,   1.800462835784701e-17,   8.073000428091898e-01,  -7.561115899372567e-03,   6.589001012942052e-05,
  -3.049694758029416e-07,  -8.456834629250032e-09,   2.874836579019807e-10,  -1.352254802573494e-12,  -1.691595744444977e-13,   4.953912261406883e-15,   1.858126521121749e-17,
   8.073028256138740e-01,  -7.561154384169194e-03,   6.588786330250121e-05,  -3.048482412756292e-07,  -8.457678687621282e-09,   2.873335438940210e-10,  -1.346415076365631e-12,
  -1.691304522077375e-13,   4.945368502682190e-15,   1.879727938978456e-17,   8.073032869006527e-01,  -7.561160763082981e-03,   6.588750742850659e-05,  -3.048281469599124e-07,
  -8.457818483686793e-09,   2.873086612008124e-10,  -1.345447383424019e-12,  -1.691256142637131e-13,   4.943952498713082e-15,   1.883305948340470e-17,   1.043498392816474e+00,
  -9.755722405009973e-03,   8.322313683510966e-05,  -2.584742477889846e-07,  -1.724425897866204e-08,   5.590270891835362e-10,  -4.207309249064284e-12,  -2.794355235473443e-13,
   1.018753024012972e-14,  -3.310225876431687e-17,   1.043510206373636e+00,  -9.755829969187153e-03,   8.320836493183660e-05,  -2.576857795165394e-07,  -1.725277105602486e-08,
   5.581900973900189e-10,  -4.167715746719247e-12,  -2.795606967448001e-13,   1.013931475035868e-14,  -3.143634078207323e-17,   1.043529598713276e+00,  -9.756006311555954e-03,
   8.318410935633742e-05,  -2.563922428553115e-07,  -1.726668445369498e-08,   5.568157981465470e-10,  -4.102855244324709e-12,  -2.797601138907944e-13,   1.006019913522243e-14,
  -2.871388997321387e-17,   1.043550173409804e+00,  -9.756193096180286e-03,   8.315836539733040e-05,  -2.550208716078825e-07,  -1.728136546188316e-08,   5.553572389935069e-10,
  -4.034221598062982e-12,  -2.799634797369601e-13,   9.976303860860449e-15,  -2.584202475235722e-17,   1.043566364301812e+00,  -9.756339859107682e-03,   8.313809977284559e-05,
  -2.539424432503761e-07,  -1.729286008239018e-08,   5.542091181327946e-10,  -3.980342885269642e-12,  -2.801175898915507e-13,   9.910316622109170e-15,  -2.359404807257381e-17,
   1.043575707779943e+00,  -9.756424463677407e-03,   8.312640208827429e-05,  -2.533204011163855e-07,  -1.729947006842934e-08,   5.535464259188028e-10,  -3.949303056650865e-12,
  -2.802041553913760e-13,   9.872249893536090e-15,  -2.230158078253011e-17,   1.043579216235052e+00,  -9.756456215548059e-03,   8.312200911467922e-05,  -2.530868823689759e-07,
  -1.730194769205287e-08,   5.532975617584514e-10,  -3.937657616001751e-12,  -2.802362135680464e-13,   9.857958474078405e-15,  -2.181716900696571e-17,   1.043579797805700e+00,
  -9.756461477926345e-03,   8.312128089656743e-05,  -2.530481766841169e-07,  -1.730235815675469e-08,   5.532563080889482e-10,  -3.935727762093625e-12,  -2.802415040530098e-13,
   9.855589626554387e-15,  -2.173691947540848e-17,   1.365052902182204e+00,  -1.270461031009643e-02,   1.018416828063716e-04,   1.805128338275380e-07,  -4.833880899863352e-08,
   1.585258969375869e-09,  -2.060249301647479e-11,  -5.170458397831579e-13,   3.278587000644099e-14,  -6.276838089826860e-16,   1.365067311515479e+00,  -1.270452532559174e-02,
   1.018001693179372e-04,   1.827552714899401e-07,  -4.838124802864278e-08,   1.583664975277746e-09,  -2.047279642416713e-11,  -5.201192020454646e-13,   3.274107257704970e-14,
  -6.223785174094345e-16,   1.365090962460842e+00,  -1.270438512100506e-02,   1.017319925038622e-04,   1.864349362240084e-07,  -4.845071897247425e-08,   1.581041629996897e-09,
  -2.026001114552198e-11,  -5.251450206763752e-13,   3.266689237128658e-14,  -6.136745003738571e-16,   1.365116052086650e+00,  -1.270423541729227e-02,   1.016596167677080e-04,
   1.903370857173684e-07,  -4.852416186493568e-08,   1.578249184532391e-09,  -2.003441082412077e-11,  -5.304511723533053e-13,   3.258731752518923e-14,  -6.044464405322699e-16,
   1.365135793513656e+00,  -1.270411692235538e-02,   1.016026314910627e-04,   1.934064593037705e-07,  -4.858176557875073e-08,   1.576045108932820e-09,  -1.985699423776491e-11,
  -5.346078698096688e-13,   3.252406867737794e-14,  -5.971894954081297e-16,   1.365147184977122e+00,  -1.270404826517742e-02,   1.015697340928032e-04,   1.951771970603992e-07,
  -4.861493118013566e-08,   1.574770531819909e-09,  -1.975465684638318e-11,  -5.369990591961393e-13,   3.248731760451844e-14,  -5.930036432632633e-16,   1.365151462263553e+00,
  -1.270402243242954e-02,   1.015573788893237e-04,   1.958420022607946e-07,  -4.862737033524808e-08,   1.574291431911453e-09,  -1.971623822225590e-11,  -5.378955154215494e-13,
   3.247347025844765e-14,  -5.914322477143937e-16,   1.365152171268048e+00,  -1.270401814757600e-02,   1.015553307371401e-04,   1.959521966713919e-07,  -4.862943151952020e-08,
   1.574211988753031e-09,  -1.970987031810972e-11,  -5.380440389041098e-13,   3.247117238802366e-14,  -5.911717893783655e-16,   1.831344454562811e-03,  -1.661411118623069e-05,
   1.475593558366459e-07,  -1.122563106951490e-09,   1.238620200635650e-12,   2.125638345696648e-13,  -3.741470944909907e-15,  -6.046345866896057e-17,   4.391091231429549e-18,
  -7.418662946974255e-20,   1.831365455380777e-03,  -1.661458937037765e-05,   1.475603694418293e-07,  -1.122262192374496e-09,   1.230839156970377e-12,   2.123773881024236e-13,
  -3.724146923350774e-15,  -6.082577332193212e-17,   4.382817372296018e-18,  -7.352388798700864e-20,   1.831399931720582e-03,  -1.661537429458803e-05,   1.475620287020421e-07,
  -1.121768386531856e-09,   1.218091950051327e-12,   2.120705349615567e-13,  -3.695730872133044e-15,  -6.141813102128674e-17,   4.369181088480392e-18,  -7.243768709681474e-20,
   1.831436513915251e-03,  -1.661620703422087e-05,   1.475637828767201e-07,  -1.121244684642336e-09,   1.204602357639807e-12,   2.117438949670242e-13,  -3.665612128826963e-15,
  -6.204335524054715e-17,   4.354639712539102e-18,  -7.128759321360170e-20,   1.831465304391203e-03,  -1.661686231376281e-05,   1.475651587739387e-07,  -1.120832720181954e-09,
   1.194012156149299e-12,   2.114860731583447e-13,  -3.641932393148655e-15,  -6.253301412297498e-17,   4.343143560503727e-18,  -7.038424251510348e-20,   1.831481919976483e-03,
  -1.661724045196157e-05,   1.475659509705109e-07,  -1.120595044381028e-09,   1.187910832127577e-12,   2.113369774874761e-13,  -3.628275945743359e-15,  -6.281464641444034e-17,
   4.336488149139496e-18,  -6.986361630886224e-20,   1.831488159301273e-03,  -1.661738243972916e-05,   1.475662480968010e-07,  -1.120505809310894e-09,   1.185621706055930e-12,
   2.112809336514419e-13,  -3.623149629302118e-15,  -6.292022091315261e-17,   4.333985063609586e-18,  -6.966825139177711e-20,   1.831489193559050e-03,  -1.661740597587077e-05,
   1.475662973312055e-07,  -1.120491018088971e-09,   1.185242355175154e-12,   2.112716405823190e-13,  -3.622299964805161e-15,  -6.293771183972096e-17,   4.333569935225822e-18,
  -6.963587400894240e-20,   1.652753330655684e-02,  -1.499369626462137e-04,   1.331434943903128e-06,  -1.011261521583915e-08,   1.031523261834784e-11,   1.945468039153121e-12,
  -3.424056522327025e-14,  -5.473799206208325e-16,   3.998518697509149e-17,  -6.779887845575089e-19,   1.652772279642618e-02,  -1.499412702169388e-04,   1.331443348926897e-06,
  -1.010986097479182e-08,   1.024401409385175e-11,   1.943779623762667e-12,  -3.408280499060018e-14,  -5.506915589676212e-16,   3.991023612889776e-17,  -6.719492352969259e-19,
   1.652803387552398e-02,  -1.499483409451397e-04,   1.331457103776093e-06,  -1.010534120061199e-08,   1.012733991922514e-11,   1.941000768395258e-12,  -3.382403469218412e-14,
  -5.561059088074215e-16,   3.978670273258124e-17,  -6.620506058596163e-19,   1.652836395558943e-02,  -1.499558423844026e-04,   1.331471639889305e-06,  -1.010054776440175e-08,
   1.000386907426608e-11,   1.938042635165791e-12,  -3.354975734003260e-14,  -5.618207591399986e-16,   3.965496230116496e-17,  -6.515695746579882e-19,   1.652862373113038e-02,
  -1.499617452242496e-04,   1.331483037345662e-06,  -1.009677704096430e-08,   9.906935270239356e-12,   1.935707672810527e-12,  -3.333411593275734e-14,  -5.662965418489766e-16,
   3.955080517373566e-17,  -6.433370613321857e-19,   1.652877365299291e-02,  -1.499651515350155e-04,   1.331489598009124e-06,  -1.009460157963949e-08,   9.851088390455549e-12,
   1.934357362914922e-12,  -3.320975196373410e-14,  -5.688708598699234e-16,   3.949050380733753e-17,  -6.385923937955898e-19,   1.652882995020315e-02,  -1.499664305755477e-04,
   1.331492058386879e-06,  -1.009378480412203e-08,   9.830135379132791e-12,   1.933849787739536e-12,  -3.316306850572182e-14,  -5.698358902672446e-16,   3.946782418500539e-17,
  -6.368119502733585e-19,   1.652883928227475e-02,  -1.499666425914988e-04,   1.331492466060080e-06,  -1.009364941884709e-08,   9.826663069527872e-12,   1.933765622456090e-12,
  -3.315533092266624e-14,  -5.699957707638060e-16,   3.946406282365372e-17,  -6.365168810200285e-19,   4.616689997627212e-02,  -4.188110837735427e-04,   3.717641647849281e-06,
  -2.814226509927123e-08,   2.382590213033580e-11,   5.591375642285981e-12,  -9.840409003504635e-14,  -1.538505616681837e-15,   1.137541005429095e-16,  -1.943241115989383e-18,
   4.616742906255374e-02,  -4.188230703658857e-04,   3.717660834157916e-06,  -2.813434838947329e-08,   2.362117330190854e-11,   5.586627091352668e-12,  -9.795522926527586e-14,
  -1.548000095902758e-15,   1.135431900425904e-16,  -1.926032498932371e-18,   4.616829764512893e-02,  -4.188427458643724e-04,   3.717692206932764e-06,  -2.812135677522600e-08,
   2.328576795398547e-11,   5.578811367300604e-12,  -9.721896715388764e-14,  -1.563523445287852e-15,   1.131955353305038e-16,  -1.897827508618391e-18,   4.616921928083764e-02,
  -4.188636197835481e-04,   3.717725326686330e-06,  -2.810757840184132e-08,   2.293081441309146e-11,   5.570490888844237e-12,  -9.643857484688009e-14,  -1.579908880799043e-15,
   1.128247384514399e-16,  -1.867962201249639e-18,   4.616994461476408e-02,  -4.188800452751167e-04,   3.717751269794232e-06,  -2.809673963358941e-08,   2.265214244155624e-11,
   5.563922855350342e-12,  -9.582501096322101e-14,  -1.592742084649350e-15,   1.125315449471584e-16,  -1.844503361747412e-18,   4.617036321986868e-02,  -4.188895237886780e-04,
   3.717766193100406e-06,  -2.809048632913539e-08,   2.249158716954869e-11,   5.560124408020935e-12,  -9.547115591576498e-14,  -1.600123461040974e-15,   1.123617887078626e-16,
  -1.830983022932452e-18,   4.617052041038245e-02,  -4.188930828835745e-04,   3.717771787701826e-06,  -2.808813852205870e-08,   2.243134841986276e-11,   5.558696561115153e-12,
  -9.533832613862675e-14,  -1.602890534702518e-15,   1.122979401583549e-16,  -1.825909450472200e-18,   4.617054646696718e-02,  -4.188936728449392e-04,   3.717772714599369e-06,
  -2.808774935900626e-08,   2.242136569348239e-11,   5.558459796390500e-12,  -9.531631014656474e-14,  -1.603348968547378e-15,   1.122873508998402e-16,  -1.825068615326103e-18,
   9.126701457968128e-02,  -8.279048061695241e-04,   7.344686712591146e-06,  -5.530302042702504e-08,   3.142546740760219e-11,   1.154871849989477e-11,  -2.032950051694929e-13,
  -3.069166712908732e-15,   2.313723642104754e-16,  -3.999280731126010e-18,   9.126805983166679e-02,  -8.279283584857031e-04,   7.344711153121501e-06,  -5.528666609460062e-08,
   3.100234589362174e-11,   1.153923592898696e-11,  -2.023818796985147e-13,  -3.088715625455628e-15,   2.309509717011015e-16,  -3.964196289146542e-18,   9.126977578415174e-02,
  -8.279670183981255e-04,   7.344751018520666e-06,  -5.525982769211237e-08,   3.030912753267478e-11,   1.152362713797557e-11,  -2.008840668138747e-13,  -3.120679107240403e-15,
   2.302562577006511e-16,  -3.906690743714266e-18,   9.127159654532579e-02,  -8.280080327238331e-04,   7.344792969045204e-06,  -5.523136352497617e-08,   2.957547648881548e-11,
   1.150700859697072e-11,  -1.992964483080571e-13,  -3.154419395483475e-15,   2.295151493501946e-16,  -3.845797351322307e-18,   9.127302949607513e-02,  -8.280403062704473e-04,
   7.344825731474891e-06,  -5.520897183378234e-08,   2.899946931072263e-11,   1.149388899716433e-11,  -1.980482017767056e-13,  -3.180846306311059e-15,   2.289290387025779e-16,
  -3.797964360209542e-18,   9.127385648082663e-02,  -8.280589299842391e-04,   7.344844538079727e-06,  -5.519605306836472e-08,   2.866759722385209e-11,   1.148630113609593e-11,
  -1.973283035333629e-13,  -3.196046984835763e-15,   2.285896434724849e-16,  -3.770395363250003e-18,   9.127416702198521e-02,  -8.280659229995743e-04,   7.344851581027122e-06,
  -5.519120268463205e-08,   2.854308043010199e-11,   1.148344874575370e-11,  -1.970580671950543e-13,  -3.201745393242585e-15,   2.284619824295878e-16,  -3.760049815662736e-18,
   9.127421849863573e-02,  -8.280670821722134e-04,   7.344852747488168e-06,  -5.519039870321706e-08,   2.852244549996008e-11,   1.148297575922282e-11,  -1.970132765429013e-13,
  -3.202689479830658e-15,   2.284408094691384e-16,  -3.758335256591681e-18,   1.526689224592231e-01,  -1.384800191832283e-03,   1.227466232337914e-05,  -9.170784854117355e-08,
   1.450541677208345e-11,   2.052668549775326e-11,  -3.616690755734298e-13,  -5.193446019605370e-15,   4.028384020729653e-16,  -7.081858842136810e-18,   1.526706692501194e-01,
  -1.384839241243008e-03,   1.227467045093288e-05,  -9.167877374212974e-08,   1.375226265847886e-11,   2.051061487677741e-11,  -3.600788457389755e-13,  -5.228085450640987e-15,
   4.021242852014170e-16,  -7.020578647599502e-18,   1.526735368903246e-01,  -1.384903338233001e-03,   1.227468333481277e-05,  -9.163105950972287e-08,   1.251828374728109e-11,
   2.048415859510709e-11,  -3.574703127887797e-13,  -5.284725938447649e-15,   4.009466931643573e-16,  -6.920131491735977e-18,   1.526765796785399e-01,  -1.384971337949646e-03,
   1.227469638286073e-05,  -9.158045383477054e-08,   1.121225854804972e-11,   2.045598646079433e-11,  -3.547053018988346e-13,  -5.344519384753561e-15,   3.996900702306001e-16,
  -6.813759647564409e-18,   1.526789743690722e-01,  -1.385024845293956e-03,   1.227470620150601e-05,  -9.154064345235769e-08,   1.018681352208752e-11,   2.043374266788843e-11,
  -3.525312894807539e-13,  -5.391355484168778e-15,   3.986959820407623e-16,  -6.730197356329776e-18,   1.526803563918865e-01,  -1.385055721905944e-03,   1.227471168777382e-05,
  -9.151767474672116e-08,   9.595972192166728e-12,   2.042087647750345e-11,  -3.512774545365145e-13,  -5.418296744161048e-15,   3.981202308238596e-16,  -6.682033416926852e-18,
   1.526808753552106e-01,  -1.385067315715039e-03,   1.227471371387544e-05,  -9.150905102649890e-08,   9.374287368184198e-12,   2.041603964794534e-11,  -3.508067842010606e-13,
  -5.428396686766414e-15,   3.979036452999408e-16,  -6.663959025181248e-18,   1.526809613808107e-01,  -1.385069237519730e-03,   1.227471404793529e-05,  -9.150762158778463e-08,
   9.337549533880330e-12,   2.041523758705227e-11,  -3.507287721525669e-13,  -5.430070012452066e-15,   3.978677228522393e-16,  -6.660963551013768e-18,   2.316334651477032e-01,
  -2.100854726856100e-03,   1.859953514519392e-05,  -1.374426463157456e-07,  -5.906273900445369e-11,   3.373536836466058e-11,  -5.957525344247176e-13,  -7.982061963531865e-15,
   6.449698333854924e-16,  -1.160722691887302e-17,   2.316361118825474e-01,  -2.100913235327335e-03,   1.859947769593360e-05,  -1.373948482473753e-07,  -6.030421658915658e-11,
   3.371061155755717e-11,  -5.932055454892684e-13,  -8.038887666734223e-15,   6.438716340701304e-16,  -1.150871776747421e-17,   2.316404569192518e-01,  -2.101009271755371e-03,
   1.859938262709547e-05,  -1.373164058173439e-07,  -6.233838570951234e-11,   3.366984822056374e-11,  -5.890274638098304e-13,  -8.131813276948521e-15,   6.420600074258434e-16,
  -1.134723501020905e-17,   2.316450673296251e-01,  -2.101111153858973e-03,   1.859928072477421e-05,  -1.372332075153954e-07,  -6.449147523266389e-11,   3.362643110615965e-11,
  -5.845985764479484e-13,  -8.229921698437339e-15,   6.401258870014305e-16,  -1.117621133780460e-17,   2.316486957399903e-01,  -2.101191321155363e-03,   1.859919978461820e-05,
  -1.371677555379526e-07,  -6.618211752048753e-11,   3.359214315916843e-11,  -5.811162009187421e-13,  -8.306777099182231e-15,   6.385951905699514e-16,  -1.104184899307220e-17,
   2.316507897638176e-01,  -2.101237581476816e-03,   1.859915277518428e-05,  -1.371299921703040e-07,  -6.715627749446843e-11,   3.357230754465219e-11,  -5.791077329590975e-13,
  -8.350989100135358e-15,   6.377083889812380e-16,  -1.096440006891223e-17,   2.316515760900673e-01,  -2.101254951592746e-03,   1.859913506652461e-05,  -1.371158135893591e-07,
  -6.752179274089164e-11,   3.356485013394138e-11,  -5.783537754399741e-13,  -8.367564179242902e-15,   6.373747439093725e-16,  -1.093533507516668e-17,   2.316517064348710e-01,
  -2.101257830880342e-03,   1.859913212809964e-05,  -1.371134633889662e-07,  -6.758236674847272e-11,   3.356361349005738e-11,  -5.782288089750059e-13,  -8.370310313600603e-15,
   6.373194036213915e-16,  -1.093051807893595e-17,   3.300112051882981e-01,  -2.992718475790969e-03,   2.645185628739031e-05,  -1.924504503650667e-07,  -2.458200197349216e-10,
   5.328176056757712e-11,  -9.453554439608981e-13,  -1.150739759505323e-14,   9.864926480753720e-16,  -1.833412650659462e-17,   3.300149690370804e-01,  -2.992800370385610e-03,
   2.645163524716114e-05,  -1.923749302044701e-07,  -2.477917328057053e-10,   5.324594323980584e-11,  -9.414577161904859e-13,  -1.159726842186578e-14,   9.849130780625855e-16,
  -1.818273769401125e-17,   3.300211479796809e-01,  -2.992934790389225e-03,   2.645127117169347e-05,  -1.922509890658276e-07,  -2.510226231322736e-10,   5.318695181074510e-11,
  -9.350635951931791e-13,  -1.174424790489344e-14,   9.823058298172844e-16,  -1.793454463454505e-17,   3.300277042822468e-01,  -2.993077388841161e-03,   2.645088322766791e-05,
  -1.921195289116592e-07,  -2.544427026749151e-10,   5.312409775485149e-11,  -9.282852531761237e-13,  -1.189944678708193e-14,   9.795202195441429e-16,  -1.767165171190498e-17,
   3.300328641028146e-01,  -2.993189591726376e-03,   2.645057673378820e-05,  -1.920161060690789e-07,  -2.571284293088210e-10,   5.307444384959374e-11,  -9.229552515780886e-13,
  -1.202104106644707e-14,   9.773141527948612e-16,  -1.746508771994983e-17,   3.300358419265238e-01,  -2.993254337049467e-03,   2.645039937773952e-05,  -1.919564335789938e-07,
  -2.586760531151020e-10,   5.304571264776682e-11,  -9.198810486764514e-13,  -1.209099599481791e-14,   9.760354876080402e-16,  -1.734601009669211e-17,   3.300369601271142e-01,
  -2.993278647831725e-03,   2.645033268954619e-05,  -1.919340287765609e-07,  -2.592567550086429e-10,   5.303490964741384e-11,  -9.187270043618005e-13,  -1.211722329825467e-14,
   9.755542989412807e-16,  -1.730132075308171e-17,   3.300371454847715e-01,  -2.993282677600583e-03,   2.645032163031764e-05,  -1.919303150082314e-07,  -2.593529911216379e-10,
   5.303311814957833e-11,  -9.185357234490923e-13,  -1.212156866212529e-14,   9.754744803789702e-16,  -1.729391420094144e-17,   4.505521976423076e-01,  -4.085092001647049e-03,
   3.602326726122647e-05,  -2.562395848935362e-07,  -6.509853761776646e-10,   8.306032389923975e-11,  -1.486851911120249e-12,  -1.577803822235856e-14,   1.479140066939614e-15,
  -2.875090785407964e-17,   4.505573228645035e-01,  -4.085200979946022e-03,   3.602269386672654e-05,  -2.561218030314835e-07,  -6.540898133536285e-10,   8.301092818374203e-11,
  -1.481003047330257e-12,  -1.591921725871779e-14,   1.476996702224143e-15,  -2.852277673235387e-17,   4.505657366846933e-01,  -4.085379849221578e-03,   3.602175065298249e-05,
  -2.559284967719618e-07,  -6.591772497687028e-10,   8.292953614469817e-11,  -1.471407493960890e-12,  -1.615014414922432e-14,   1.473455251559613e-15,  -2.814870970989361e-17,
   4.505746643145320e-01,  -4.085569594104745e-03,   3.602074725939563e-05,  -2.557234543615815e-07,  -6.645631871622241e-10,   8.284276484053751e-11,  -1.461234472272397e-12,
  -1.639403289182768e-14,   1.469666678071256e-15,  -2.775240705467324e-17,   4.505816903454768e-01,  -4.085718888679053e-03,   3.601995572434544e-05,  -2.555621360617690e-07,
  -6.687931006120203e-10,   8.277418070210691e-11,  -1.453234506747360e-12,  -1.658514811526487e-14,   1.466662835159231e-15,  -2.744096030055881e-17,   4.505857451809875e-01,
  -4.085805035210991e-03,   3.601949816958480e-05,  -2.554690566650124e-07,  -6.712307212358373e-10,   8.273448159478130e-11,  -1.448620087073780e-12,  -1.669511338721090e-14,
   1.464920386197161e-15,  -2.726139781555469e-17,   4.505872678074396e-01,  -4.085837381390393e-03,   3.601932621261524e-05,  -2.554341083149917e-07,  -6.721454021185859e-10,
   8.271955193902810e-11,  -1.446887803402087e-12,  -1.673634389515563e-14,   1.464264406179858e-15,  -2.719400436105839e-17,   4.505875202043257e-01,  -4.085842743090195e-03,
   3.601929770087082e-05,  -2.554283153310223e-07,  -6.722969882312708e-10,   8.271707596204711e-11,  -1.446600677767866e-12,  -1.674317514317851e-14,   1.464155579933444e-15,
  -2.718283473002366e-17,   5.975154253867696e-01,  -5.416130116431583e-03,   4.759799183269474e-05,  -3.270736897461635e-07,  -1.489368832047021e-09,   1.310248763208228e-10,
  -2.384085816498931e-12,  -2.046197268241827e-14,   2.224643209894935e-15,  -4.613902812427807e-17,   5.975221963161843e-01,  -5.416269094714920e-03,   4.759669195465049e-05,
  -3.268877817707094e-07,  -1.494353380918000e-09,   1.309601154615851e-10,  -2.375277898814532e-12,  -2.068911440488640e-14,   2.221960808293593e-15,  -4.579469462104471e-17,
   5.975333117547792e-01,  -5.416497192831098e-03,   4.759455495142131e-05,  -3.265826518372752e-07,  -1.502522765938770e-09,   1.308533154004209e-10,  -2.360826218171136e-12,
  -2.106073332391331e-14,   2.217519388779088e-15,  -4.522994700520728e-17,   5.975451059067480e-01,  -5.416739144796305e-03,   4.759228329463580e-05,  -3.262589782123567e-07,
  -1.511172694352373e-09,   1.307393351310185e-10,  -2.345502720681992e-12,  -2.145332345819101e-14,   2.212755486853252e-15,  -4.463143492112771e-17,   5.975543878304711e-01,
  -5.416929505969643e-03,   4.759049250129879e-05,  -3.260043127829265e-07,  -1.517966901930033e-09,   1.306491574453348e-10,  -2.333450951584911e-12,  -2.176104497172869e-14,
   2.208969342670412e-15,  -4.416093539697270e-17,   5.975597445556567e-01,  -5.417039344562582e-03,   4.758945780308588e-05,  -3.258573674764254e-07,  -1.521882629823719e-09,
   1.305969242787726e-10,  -2.326498823489157e-12,  -2.193813670907891e-14,   2.206769531782041e-15,  -4.388961605623111e-17,   5.975617560489253e-01,  -5.417080585782256e-03,
   4.758906903763408e-05,  -3.258021931817090e-07,  -1.523352015075051e-09,   1.305772743658704e-10,  -2.323888833784390e-12,  -2.200454187777474e-14,   2.205940698348725e-15,
  -4.378777380209282e-17,   5.975620894821827e-01,  -5.417087421879789e-03,   4.758900458227751e-05,  -3.257930475233916e-07,  -1.523595533461934e-09,   1.305740152219784e-10,
  -2.323456222514820e-12,  -2.201554449845239e-14,   2.205803160694575e-15,  -4.377089415078788e-17,   7.780265910149542e-01,  -7.049407709568577e-03,   6.161754500035290e-05,
  -3.993444539627609e-07,  -3.268553001747314e-09,   2.162035707720198e-10,  -4.056184901910389e-12,  -2.354577765022221e-14,   3.451300572379916e-15,  -7.916788498766498e-17,
   7.780353539345277e-01,  -7.049577113974210e-03,   6.161470611159009e-05,  -3.990374326952773e-07,  -3.277048770051287e-09,   2.161269806648264e-10,  -4.042489172583842e-12,
  -2.393709687982655e-14,   3.448649643312968e-15,  -7.863626056909274e-17,   7.780497393859842e-01,  -7.049855124148923e-03,   6.161004042464978e-05,  -3.985334889359852e-07,
  -3.290974849313331e-09,   2.160004096328859e-10,  -4.020013438248228e-12,  -2.457754540737745e-14,   3.444230066608677e-15,  -7.776393204895355e-17,   7.780650030549128e-01,
  -7.050149985912914e-03,   6.160508272149666e-05,  -3.979988766716211e-07,  -3.305722826954467e-09,   2.158649741499914e-10,  -3.996175955378030e-12,  -2.525444066198915e-14,
   3.439448912055954e-15,  -7.683890541752197e-17,   7.780770153477600e-01,  -7.050381950631405e-03,   6.160117588519331e-05,  -3.975782147528043e-07,  -3.317308811430086e-09,
   2.157575666119884e-10,  -3.977423784514955e-12,  -2.578522825371766e-14,   3.435619999927027e-15,  -7.611133481981770e-17,   7.780839477586108e-01,  -7.050515784715413e-03,
   6.159891913192841e-05,  -3.973354750196563e-07,  -3.323986993268164e-09,   2.156952518864181e-10,  -3.966604795512232e-12,  -2.609078173778179e-14,   3.433383833034590e-15,
  -7.569161510978476e-17,   7.780865509254625e-01,  -7.050566033696855e-03,   6.159807131296461e-05,  -3.972443299905934e-07,  -3.326493145296543e-09,   2.156717902135288e-10,
  -3.962542776123173e-12,  -2.620537376583497e-14,   3.432539144311766e-15,  -7.553403972092588e-17,   7.780869824364496e-01,  -7.050574362812982e-03,   6.159793075449530e-05,
  -3.972292217224240e-07,  -3.326908492961093e-09,   2.156678978430498e-10,  -3.961869470977688e-12,  -2.622436131515700e-14,   3.432398862263799e-15,  -7.550792112273466e-17,
   1.005781869919282e+00,  -9.106231052548493e-03,   7.881144507133894e-05,  -4.524526513426265e-07,  -7.527588019621401e-09,   3.982825854241514e-10,  -7.953831645121524e-12,
  -1.234868124991660e-14,   5.780012745173064e-15,  -1.588397030823056e-16,   1.005793072249920e+00,  -9.106422213768632e-03,   7.880492317787698e-05,  -4.518862953253111e-07,
  -7.544292445433064e-09,   3.982330867015571e-10,  -7.930775940272029e-12,  -1.313972724786021e-14,   5.781333311858117e-15,  -1.579950599852545e-16,   1.005811462003310e+00,
  -9.106735861203976e-03,   7.879420621200954e-05,  -4.509565863688526e-07,  -7.571679881508590e-09,   3.981501326729303e-10,  -7.892923271816808e-12,  -1.443522322416288e-14,
   5.783360576956818e-15,  -1.566075728953370e-16,   1.005830974021033e+00,  -9.107068428028215e-03,   7.878282080202268e-05,  -4.499701705078450e-07,  -7.600691706494396e-09,
   3.980598136495860e-10,  -7.852754811901902e-12,  -1.580558348292253e-14,   5.785320941766897e-15,  -1.551341866221884e-16,   1.005846329406349e+00,  -9.107329988030202e-03,
   7.877385038381598e-05,  -4.491939126781174e-07,  -7.623489148691458e-09,   3.979870709290996e-10,  -7.821139406338574e-12,  -1.688097777474265e-14,   5.786726024053040e-15,
  -1.539738074236276e-16,   1.005855191028698e+00,  -9.107480870544341e-03,   7.876866935835066e-05,  -4.487459420525655e-07,  -7.636631961538390e-09,   3.979444247636077e-10,
  -7.802892545667844e-12,  -1.750037123935426e-14,   5.787481829267594e-15,  -1.533038091781544e-16,   1.005858518604811e+00,  -9.107537515410500e-03,   7.876672307199456e-05,
  -4.485777289944675e-07,  -7.641564565289399e-09,   3.979282851422950e-10,  -7.796040487332369e-12,  -1.773272567450335e-14,   5.787755241860600e-15,  -1.530521583348557e-16,
   1.005859070195481e+00,  -9.107546904421103e-03,   7.876640040709986e-05,  -4.485498455033791e-07,  -7.642382074997749e-09,   3.979256031478770e-10,  -7.794904651216344e-12,
  -1.777122940385356e-14,   5.787800015613351e-15,  -1.530104404676987e-16,   1.315862021126886e+00,  -1.189214206610524e-02,   1.003176438096291e-04,  -3.691959513437916e-07,
  -2.222904668088776e-08,   1.014241409831665e-09,  -2.385607217975902e-11,   1.680041576474119e-13,   1.095069620627779e-14,  -4.899963473964576e-16,   1.315876258317429e+00,
  -1.189229457040645e-02,   1.002983784338092e-04,  -3.677487449918976e-07,  -2.227943740997321e-08,   1.014703648348059e-09,  -2.381135839356424e-11,   1.655094297294650e-13,
   1.100305035247238e-14,  -4.894291401725168e-16,   1.315899628943352e+00,  -1.189254448345169e-02,   1.002667202724075e-04,  -3.653724626061549e-07,  -2.236209239151545e-08,
   1.015457109472851e-09,  -2.373780468773717e-11,   1.614161266075210e-13,   1.108865106505519e-14,  -4.884852065229819e-16,   1.315924424227904e+00,  -1.189280905231666e-02,
   1.002330865047110e-04,  -3.628504226171199e-07,  -2.244970105870556e-08,   1.016249283185881e-09,  -2.365955685295400e-11,   1.570758266549796e-13,   1.117900809398664e-14,
  -4.874663031350405e-16,   1.315943936250523e+00,  -1.189301682899861e-02,   1.002065861538203e-04,  -3.608651168527986e-07,  -2.251858090843898e-08,   1.016867439863566e-09,
  -2.359782981418225e-11,   1.536621880744643e-13,   1.124977768344492e-14,  -4.866519146789201e-16,   1.315955196219539e+00,  -1.189313656442959e-02,   1.001912801038503e-04,
  -3.597191796619089e-07,  -2.255830527348648e-08,   1.017222071096731e-09,  -2.356214771888247e-11,   1.516929991302567e-13,   1.129048310583670e-14,  -4.861769125627569e-16,
   1.315959424298463e+00,  -1.189318149290154e-02,   1.001855302286068e-04,  -3.592888352229720e-07,  -2.257321695781327e-08,   1.017354838207680e-09,  -2.354873775111451e-11,
   1.509537178515565e-13,   1.130574247859237e-14,  -4.859976002464861e-16,   1.315960125155076e+00,  -1.189318893867823e-02,   1.001845769830980e-04,  -3.592174977005758e-07,
  -2.257568850800142e-08,   1.017376825133575e-09,  -2.354651427785355e-11,   1.508311803193640e-13,   1.130827057059420e-14,  -4.859678268779529e-16,   1.767164504154572e-03,
  -1.548689287852279e-05,   1.343310360030686e-07,  -1.073937398319060e-09,   4.525699133970396e-12,   1.156864290304899e-13,  -3.899329141171789e-15,   3.400994130147396e-17,
   1.557262208065859e-18,  -6.879171655457895e-20,   1.767183628124003e-03,  -1.548735078143949e-05,   1.343348535495775e-07,  -1.073771961951990e-09,   4.517450923333274e-12,
   1.157825029402543e-13,  -3.893001661231619e-15,   3.366132381813531e-17,   1.563206601246638e-18,  -6.865108517282121e-20,   1.767215023601021e-03,  -1.548810245197254e-05,
   1.343411156039155e-07,  -1.073500274866769e-09,   4.503919977305176e-12,   1.159394733051014e-13,  -3.882597235548813e-15,   3.308954170367214e-17,   1.572917045080822e-18,
  -6.841899769736302e-20,   1.767248337153307e-03,  -1.548889996288908e-05,   1.343477532456703e-07,  -1.073211863121228e-09,   4.489575967070824e-12,   1.161050116260563e-13,
  -3.871534520362679e-15,   3.248355932289813e-17,   1.583155053278851e-18,  -6.817108550945946e-20,   1.767274555473705e-03,  -1.548952755775700e-05,   1.343529721245744e-07,
  -1.072984787226647e-09,   4.478296846410204e-12,   1.162345536031294e-13,  -3.862811646166033e-15,   3.200717313111302e-17,   1.591165009392312e-18,  -6.797478805279273e-20,
   1.767289686731224e-03,  -1.548988973481508e-05,   1.343559820462637e-07,  -1.072853699582348e-09,   4.471791333488197e-12,   1.163090193287851e-13,  -3.857770926895424e-15,
   3.173245247097417e-17,   1.595768717466468e-18,  -6.786102587503085e-20,   1.767295368697632e-03,  -1.549002573208100e-05,   1.343571119247442e-07,  -1.072804467754695e-09,
   4.469349184031386e-12,   1.163369261196217e-13,  -3.855876845714740e-15,   3.162933211129016e-17,   1.597493866728391e-18,  -6.781821744652470e-20,   1.767296310566410e-03,
  -1.549004827537289e-05,   1.343572991983869e-07,  -1.072796306499605e-09,   4.468944401605288e-12,   1.163415491248718e-13,  -3.855562809237975e-15,   3.161224054657867e-17,
   1.597779645611102e-18,  -6.781111661473287e-20,   1.594832733045628e-02,  -1.397654322253277e-04,   1.212204555922957e-06,  -9.683862954426610e-09,   4.041061025103580e-11,
   1.060216421749512e-12,  -3.559813382357244e-14,   3.119755675053919e-16,   1.413691583927241e-17,  -6.265713098225224e-19,   1.594849990459243e-02,  -1.397695611219506e-04,
   1.212238633968541e-06,  -9.682346791008356e-09,   4.033530614028365e-11,   1.061098071138118e-12,  -3.554068402512472e-14,   3.088000555895852e-16,   1.419129378415830e-17,
  -6.252986846530880e-19,   1.594878321641214e-02,  -1.397763389046351e-04,   1.212294532342194e-06,  -9.679856877532680e-09,   4.021177147966832e-11,   1.062538604882926e-12,
  -3.544621679321567e-14,   3.035917350786585e-16,   1.428012466001338e-17,  -6.231983173867177e-19,   1.594908383683110e-02,  -1.397835300179077e-04,   1.212353782005208e-06,
  -9.677213686789191e-09,   4.008081304923483e-11,   1.064057836997317e-12,  -3.534577103058175e-14,   2.980718453609894e-16,   1.437378435528554e-17,  -6.209545732240014e-19,
   1.594932043006845e-02,  -1.397891889998073e-04,   1.212400366333377e-06,  -9.675132615893038e-09,   3.997783606865158e-11,   1.065246762197549e-12,  -3.526656910675853e-14,
   2.937324164865702e-16,   1.444706325214804e-17,  -6.191778529363477e-19,   1.594945697400960e-02,  -1.397924547236771e-04,   1.212427232842150e-06,  -9.673931243085936e-09,
   3.991844134437646e-11,   1.065930222579913e-12,  -3.522079994663942e-14,   2.912299583668049e-16,   1.448918095002911e-17,  -6.181481258437756e-19,   1.594950824787377e-02,
  -1.397936810004472e-04,   1.212437318040907e-06,  -9.673480050352491e-09,   3.989614471173137e-11,   1.066186360187133e-12,  -3.520360181834610e-14,   2.902906223688330e-16,
   1.450496387899666e-17,  -6.177606332138790e-19,   1.594951674726421e-02,  -1.397938842715271e-04,   1.212438989625377e-06,  -9.673405255256772e-09,   3.989244907805580e-11,
   1.066228791837218e-12,  -3.520075038398122e-14,   2.901349330908001e-16,   1.450757840135076e-17,  -6.176963575556435e-19,   4.454901834304328e-02,  -3.904066791582120e-04,
   3.385472285715172e-06,  -2.700287379493475e-08,   1.103810162814180e-10,   3.055010848621739e-12,  -1.017986139903908e-13,   9.008806387313790e-16,   3.996252973157718e-17,
  -1.783430861951363e-18,   4.454950030767772e-02,  -3.904181918411462e-04,   3.385565314642232e-06,  -2.699850490901880e-08,   1.101656502218925e-10,   3.057558826840867e-12,
  -1.016361631144785e-13,   8.918407667536287e-16,   4.011869178107986e-17,  -1.779857480548908e-18,   4.455029154002461e-02,  -3.904370904209301e-04,   3.385717904392243e-06,
  -2.699133011470442e-08,   1.098123443065010e-10,   3.061722283078184e-12,  -1.013690311300494e-13,   8.770138265849812e-16,   4.037380698271832e-17,  -1.773959171709104e-18,
   4.455113111146616e-02,  -3.904571414362477e-04,   3.385879634203976e-06,  -2.698371363369094e-08,   1.094378027263040e-10,   3.066113597041308e-12,  -1.010849839162306e-13,
   8.612996720488989e-16,   4.064280591931119e-17,  -1.767657249434440e-18,   4.455179186784245e-02,  -3.904729203592572e-04,   3.386006786370932e-06,  -2.697771691952847e-08,
   1.091432853850655e-10,   3.069550457314033e-12,  -1.008610047373770e-13,   8.489459042594024e-16,   4.085328084174308e-17,  -1.762666337848580e-18,   4.455217320696998e-02,
  -3.904820261504734e-04,   3.386080116266755e-06,  -2.697425509779178e-08,   1.089734135152803e-10,   3.071526273767096e-12,  -1.007315691041460e-13,   8.418216729693675e-16,
   4.097425777901650e-17,  -1.759773494727902e-18,   4.455231640430388e-02,  -3.904854453647158e-04,   3.386107642525872e-06,  -2.697295496049360e-08,   1.089096438224389e-10,
   3.072266764639844e-12,  -1.006829321233289e-13,   8.391474701698373e-16,   4.101959281022804e-17,  -1.758684847588111e-18,   4.455234014134857e-02,  -3.904860121430949e-04,
   3.386112204877973e-06,  -2.697273943417409e-08,   1.088990740795281e-10,   3.072389435232728e-12,  -1.006748681285548e-13,   8.387042364714769e-16,   4.102710283451377e-17,
  -1.758504264587091e-18,   8.806874024288190e-02,  -7.717775681547937e-04,   6.690783222936959e-06,  -5.323348354668798e-08,   2.103729521836814e-10,   6.333357644146436e-12,
  -2.087009983196065e-13,   1.875011632418091e-15,   8.045728961198613e-17,  -3.630225928310630e-18,   8.806969274663844e-02,  -7.718002626945680e-04,   6.690960348582453e-06,
  -5.322442615185367e-08,   2.099313534549532e-10,   6.338667303857823e-12,  -2.083737685482800e-13,   1.856606453082525e-15,   8.077964380271422e-17,  -3.623111564411085e-18,
   8.807125645357544e-02,  -7.718375166504980e-04,   6.691250857718740e-06,  -5.320955163268040e-08,   2.092069060268784e-10,   6.347344341421112e-12,  -2.078356541184258e-13,
   1.826418213708687e-15,   8.130629729007912e-17,  -3.611366041562612e-18,   8.807291569176552e-02,  -7.718770421654166e-04,   6.691558741850939e-06,  -5.319376138335392e-08,
   2.084389029735002e-10,   6.356497523007371e-12,  -2.072634351976753e-13,   1.794422771027860e-15,   8.186166289857207e-17,  -3.598813572568692e-18,   8.807422153850507e-02,
  -7.719081461930002e-04,   6.691800781602633e-06,  -5.318132915341421e-08,   2.078349819141131e-10,   6.363662178887177e-12,  -2.068122027626420e-13,   1.769268802179954e-15,
   8.229623888226420e-17,  -3.588870129804138e-18,   8.807497517523080e-02,  -7.719260958288321e-04,   6.691940360623289e-06,  -5.317415218343693e-08,   2.074866484359881e-10,
   6.367781438710552e-12,  -2.065514307240863e-13,   1.754762656785715e-15,   8.254603966900141e-17,  -3.583105772194121e-18,   8.807525817464508e-02,  -7.719328358863709e-04,
   6.691992753742515e-06,  -5.317145676606897e-08,   2.073558837986613e-10,   6.369325313566620e-12,  -2.064534408816228e-13,   1.749317481780002e-15,   8.263965310975198e-17,
  -3.580936331915185e-18,   8.807530508591893e-02,  -7.719339531363465e-04,   6.692001437586935e-06,  -5.317100994130200e-08,   2.073342096960350e-10,   6.369581077417925e-12,
  -2.064371941126861e-13,   1.748414973105647e-15,   8.265516089573978e-17,  -3.580576459646974e-18,   1.473191891529005e-01,  -1.290972938041389e-03,   1.118750165230704e-05,
  -8.868952346164394e-08,   3.329314530037241e-10,   1.130854786918679e-11,  -3.673421636924151e-13,   3.370646754036006e-15,   1.380019756455006e-16,  -6.327154710485689e-18,
   1.473207817793069e-01,  -1.291010744399786e-03,   1.118778152237674e-05,  -8.867335031166751e-08,   3.321540097001841e-10,   1.131810875825849e-11,  -3.667804731475147e-13,
   3.338557329166705e-15,   1.385751572771773e-16,  -6.315161995150975e-18,   1.473233963614675e-01,  -1.291072804648475e-03,   1.118824049674620e-05,  -8.864678984657693e-08,
   3.308785835028244e-10,   1.133373540621811e-11,  -3.658567418341526e-13,   3.285922637817509e-15,   1.395117000287059e-16,  -6.295356331005325e-18,   1.473261706734762e-01,
  -1.291138648562279e-03,   1.118872685516505e-05,  -8.861859410207090e-08,   3.295264453090074e-10,   1.135022263061600e-11,  -3.648743894753217e-13,   3.230134955919610e-15,
   1.404994296090588e-16,  -6.274181629117451e-18,   1.473283540992890e-01,  -1.291190463139123e-03,   1.118910915223758e-05,  -8.859639449344317e-08,   3.284631663496574e-10,
   1.136313025065161e-11,  -3.640996841552612e-13,   3.186274682917608e-15,   1.412724254999669e-16,  -6.257402098568628e-18,   1.473296142081116e-01,  -1.291220364368312e-03,
   1.118932959520832e-05,  -8.858357890343777e-08,   3.278498727138892e-10,   1.137055228210447e-11,  -3.636519514816090e-13,   3.160980131105584e-15,   1.417167926196196e-16,
  -6.247672383370113e-18,   1.473300873936004e-01,  -1.291231592203616e-03,   1.118941233818362e-05,  -8.857876581213611e-08,   3.276196401892013e-10,   1.137333418771594e-11,
  -3.634837035877806e-13,   3.151485197917670e-15,   1.418833273634988e-16,  -6.244010116963235e-18,   1.473301658309787e-01,  -1.291233453358321e-03,   1.118942605214083e-05,
  -8.857796793594246e-08,   3.275814793004171e-10,   1.137379505722083e-11,  -3.634558077751793e-13,   3.149911457564357e-15,   1.419109154991933e-16,  -6.243402587380840e-18,
   2.235172314509893e-01,  -1.958625752061817e-03,   1.696418432976218e-05,  -1.338060687065026e-07,   4.648917201720007e-10,   1.868078217680493e-11,  -5.965643190299308e-13,
   5.630349149064792e-15,   2.162863017102870e-16,  -1.014387857404636e-17,   2.235196463627855e-01,  -1.958682782401420e-03,   1.696457412453208e-05,  -1.337793502040629e-07,
   4.636287841171041e-10,   1.869678670295922e-11,  -5.956830430318349e-13,   5.578877667987790e-15,   2.172308142607367e-16,  -1.012557956070839e-17,   2.235236108704008e-01,
  -1.958776398660918e-03,   1.696521325969024e-05,  -1.337354713366279e-07,   4.615568400920678e-10,   1.872294987210851e-11,  -5.942336062775242e-13,   5.494448120480000e-15,
   2.187742996015230e-16,  -1.009534475694003e-17,   2.235278175724640e-01,  -1.958875721501975e-03,   1.696589037725327e-05,  -1.336888906186438e-07,   4.593602113988547e-10,
   1.875056044417926e-11,  -5.926920112661270e-13,   5.404956309851984e-15,   2.204024319236090e-16,  -1.006300053265466e-17,   2.235311283074909e-01,  -1.958953880955640e-03,
   1.696642250940394e-05,  -1.336522155789725e-07,   4.576328044590119e-10,   1.877218115623286e-11,  -5.914761480261560e-13,   5.334594485602537e-15,   2.216768151064232e-16,
  -1.003735593322810e-17,   2.235330390127955e-01,  -1.958998985039458e-03,   1.696672930757457e-05,  -1.336310433911979e-07,   4.566364264152939e-10,   1.878461523966055e-11,
  -5.907734022935532e-13,   5.294014940172695e-15,   2.224094955027409e-16,  -1.002248019981880e-17,   2.235337565045433e-01,  -1.959015921454195e-03,   1.696684445557250e-05,
  -1.336230918343197e-07,   4.562623791172171e-10,   1.878927611346866e-11,  -5.905093166798675e-13,   5.278782153389014e-15,   2.226840968656551e-16,  -1.001687992781967e-17,
   2.235338754392237e-01,  -1.959018728874797e-03,   1.696686353995430e-05,  -1.336217736872280e-07,   4.562003808359801e-10,   1.879004828495254e-11,  -5.904655302932867e-13,
   5.276257377456721e-15,   2.227295881519494e-16,  -1.001595084960460e-17,   3.184489366584760e-01,  -2.790335442378540e-03,   2.414986237130010e-05,  -1.891447410284929e-07,
   5.825669770789766e-10,   2.965690327792167e-11,  -9.292202863397468e-13,   9.100262544438375e-15,   3.208607980843445e-16,  -1.554124476906748e-17,   3.184523743390035e-01,
  -2.790416042522460e-03,   2.415034865063386e-05,  -1.891023192466001e-07,   5.805990529025438e-10,   2.968283939584680e-11,  -9.279108268300647e-13,   9.021349948555495e-15,
   3.223628100740363e-16,  -1.551523531358844e-17,   3.184580178963534e-01,  -2.790548347566547e-03,   2.415114574737559e-05,  -1.890326508705937e-07,   5.773704234506126e-10,
   2.972524774683326e-11,  -9.257568733405877e-13,   8.891900782760992e-15,   3.248177898594026e-16,  -1.547222807095870e-17,   3.184640062126276e-01,  -2.790688715586485e-03,
   2.415198988552904e-05,  -1.889586918870403e-07,   5.739473695083146e-10,   2.977001538055244e-11,  -9.234655844486622e-13,   8.754679882779910e-15,   3.274080180936150e-16,
  -1.542617615643749e-17,   3.184687190965584e-01,  -2.790799173023265e-03,   2.415265303759122e-05,  -1.889004601851259e-07,   5.712554174667897e-10,   2.980508065575888e-11,
  -9.216581582017010e-13,   8.646784304884256e-15,   3.294359055067449e-16,  -1.538963157261759e-17,   3.184714390130787e-01,  -2.790862914984877e-03,   2.415303527914335e-05,
  -1.888668432969494e-07,   5.697026456905347e-10,   2.982525056552036e-11,  -9.206133901037915e-13,   8.584555096764118e-15,   3.306019768961756e-16,  -1.536842048757371e-17,
   3.184724603723766e-01,  -2.790886849745141e-03,   2.415317872461066e-05,  -1.888542178897056e-07,   5.691197169727882e-10,   2.983281191734112e-11,  -9.202207547262222e-13,
   8.561194883836782e-15,   3.310390428715249e-16,  -1.536043278289492e-17,   3.184726296774895e-01,  -2.790890817222540e-03,   2.415320249800081e-05,  -1.888521249459168e-07,
   5.690230962429443e-10,   2.983406465238999e-11,  -9.201556532102624e-13,   8.557322988896203e-15,   3.311114503269044e-16,  -1.535910750837472e-17,   4.347686278148009e-01,
  -3.809269175354020e-03,   3.293423066316100e-05,  -2.553711708546289e-07,   6.410446729486671e-10,   4.643589166412410e-11,  -1.426196537060234e-12,   1.466379426977075e-14,
   4.598376295297478e-16,  -2.334902236169081e-17,   4.347733156637709e-01,  -3.809377964161339e-03,   3.293476090481865e-05,  -2.553047369035977e-07,   6.380227159249921e-10,
   4.647781918873770e-11,  -1.424315300467333e-12,   1.454511763550129e-14,   4.622125507967259e-16,  -2.331440357319165e-17,   4.347810115785762e-01,  -3.809556538019205e-03,
   3.293562952452343e-05,  -2.551956324804740e-07,   6.330646126170055e-10,   4.654639428929189e-11,  -1.421220198906026e-12,   1.435042258924364e-14,   4.660952297634923e-16,
  -2.325708414258797e-17,   4.347891776096376e-01,  -3.809745990713497e-03,   3.293654867326925e-05,  -2.550798068538916e-07,   6.278076671505834e-10,   4.661881038915395e-11,
  -1.417926912359422e-12,   1.414401628174258e-14,   4.701931225572952e-16,  -2.319560384179552e-17,   4.347956043700741e-01,  -3.809895070722713e-03,   3.293727022157819e-05,
  -2.549886100300431e-07,   6.236733133768366e-10,   4.667555085137482e-11,  -1.415328477638644e-12,   1.398170466065884e-14,   4.734023113563044e-16,  -2.314674229742987e-17,
   4.347993133996435e-01,  -3.809981099589527e-03,   3.293768590929014e-05,  -2.549359619828450e-07,   6.212884568542696e-10,   4.670819615386631e-11,  -1.413826230771833e-12,
   1.388808430540899e-14,   4.752480348580918e-16,  -2.311835297754766e-17,   4.348007061809911e-01,  -3.810013402749184e-03,   3.293784186584858e-05,  -2.549161889888236e-07,
   6.203931389189208e-10,   4.672043575590476e-11,  -1.413261624049569e-12,   1.385293895128104e-14,   4.759399200180511e-16,  -2.310765658704010e-17,   4.348009370546392e-01,
  -3.810018757379279e-03,   3.293786771058470e-05,  -2.549129111670896e-07,   6.202447387345030e-10,   4.672246364114708e-11,  -1.413168006146602e-12,   1.384711363511525e-14,
   4.760545464598451e-16,  -2.310588161387413e-17,   5.765872798421829e-01,  -5.051272316231338e-03,   4.360630665339265e-05,  -3.331185375328970e-07,   5.474904205378280e-10,
   7.341830830224468e-11,  -2.212409098175371e-12,   2.428725830188048e-14,   6.438203077485326e-16,  -3.519567525462394e-17,   5.765934862261529e-01,  -5.051414160574780e-03,
   4.360674756185875e-05,  -3.330134718463965e-07,   5.427993193181424e-10,   7.348802885726274e-11,  -2.209764341728189e-12,   2.410809003355653e-14,   6.476686705148729e-16,
  -3.515390814802681e-17,   5.766036750512945e-01,  -5.051646988471580e-03,   4.360746849948526e-05,  -3.328409189904448e-07,   5.351022397074087e-10,   7.360210019045909e-11,
  -2.205411600233984e-12,   2.381411689485126e-14,   6.539623994712867e-16,  -3.508455550716181e-17,   5.766144862384049e-01,  -5.051893992617111e-03,   4.360822955050552e-05,
  -3.326577314377960e-07,   5.269406550021226e-10,   7.372261395078681e-11,  -2.200778166776256e-12,   2.350240848620696e-14,   6.606079387106102e-16,  -3.500990280776646e-17,
   5.766229947400182e-01,  -5.052088354132065e-03,   4.360882566492276e-05,  -3.325134927986627e-07,   5.205215151415627e-10,   7.381707914017380e-11,  -2.197120916719882e-12,
   2.325725272213717e-14,   6.658144137486973e-16,  -3.495038254606003e-17,   5.766279051788911e-01,  -5.052200511114556e-03,   4.360916855747044e-05,  -3.324302222280054e-07,
   5.168185379056302e-10,   7.387144466696200e-11,  -2.195005961466061e-12,   2.311583323757260e-14,   6.688097124002325e-16,  -3.491572506824173e-17,   5.766297491005763e-01,
  -5.052242624747919e-03,   4.360929710221965e-05,  -3.323989480847352e-07,   5.154283422370894e-10,   7.389183070509478e-11,  -2.194210966045394e-12,   2.306274109247257e-14,
   6.699326887947387e-16,  -3.490265287268534e-17,   5.766300547571505e-01,  -5.052249605557313e-03,   4.360931839902054e-05,  -3.323937636728355e-07,   5.151979137196414e-10,
   7.389520846576313e-11,  -2.194079141541394e-12,   2.305394095835462e-14,   6.701187438790971e-16,  -3.490048291329741e-17,   7.507836251694482e-01,  -6.576230982475041e-03,
   5.663704600390737e-05,  -4.223712585581897e-07,   8.201726301325708e-11,   1.208186466945223e-10,  -3.588808789491160e-12,   4.322000395737202e-14,   8.775232610335167e-16,
  -5.471289862160607e-17,   7.507916850904880e-01,  -6.576410690737003e-03,   5.663707289737452e-05,  -4.221982759752038e-07,   7.439992316742301e-11,   1.209433470702483e-10,
  -3.585174476743596e-12,   4.294073533870211e-14,   8.841945338565603e-16,  -5.467584302467357e-17,   7.508049167515581e-01,  -6.576705657320913e-03,   5.663711236025119e-05,
  -4.219141706542509e-07,   6.190050679860431e-11,   1.211474604007358e-10,  -3.579189157503049e-12,   4.248241800552021e-14,   8.951104931524339e-16,  -5.461367087744544e-17,
   7.508189565613138e-01,  -6.577018566780465e-03,   5.663714786518353e-05,  -4.216125414800168e-07,   4.864539521627546e-11,   1.213632217286377e-10,  -3.572812496465572e-12,
   4.199631079237293e-14,   9.066442022163877e-16,  -5.454588517843359e-17,   7.508300059613472e-01,  -6.577264775383667e-03,   5.663717119850533e-05,  -4.213750338517599e-07,
   3.821916579251537e-11,   1.215324344161895e-10,  -3.567775413878045e-12,   4.161389088782515e-14,   9.156858223413787e-16,  -5.449122568773243e-17,   7.508363827844934e-01,
  -6.577406846018524e-03,   5.663718281751104e-05,  -4.212379139844212e-07,   3.220423901553363e-11,   1.216298528667977e-10,  -3.564860967209771e-12,   4.139324931745764e-14,
   9.208896950712591e-16,  -5.445915585909993e-17,   7.508387773446703e-01,  -6.577460190953694e-03,   5.663718683150006e-05,  -4.211864147517859e-07,   2.994600073736297e-11,
   1.216663895794120e-10,  -3.563765157546603e-12,   4.131040771943187e-14,   9.228411121218696e-16,  -5.444701425960771e-17,   7.508391742772775e-01,  -6.577469033429182e-03,
   5.663718747846301e-05,  -4.211778775233570e-07,   2.957168793258401e-11,   1.216724436947984e-10,  -3.563583437282023e-12,   4.129667614778143e-14,   9.231644455637527e-16,
  -5.444499639293756e-17,   9.705813659492004e-01,  -8.498966002808984e-03,   7.288907552999819e-05,  -5.193473457544256e-07,  -1.412299930170065e-09,   2.191399658275397e-10,
  -6.509079453555157e-12,   9.055394404565597e-14,   1.069403833362765e-15,  -9.159308709416972e-17,   9.705917360160858e-01,  -8.499186613632356e-03,   7.288779125871337e-05,
  -5.190332789890176e-07,  -1.426139956202721e-09,   2.194030670417126e-10,  -6.504540009594053e-12,   9.008377778600715e-14,   1.082865647915532e-15,  -9.163011053581857e-17,
   9.706087600150314e-01,  -8.499548684586081e-03,   7.288567439567468e-05,  -5.185174200614096e-07,  -1.448853448196247e-09,   2.198339741638229e-10,  -6.497049316335711e-12,
   8.931180590595139e-14,   1.104911600822079e-15,  -9.168834053881122e-17,   9.706268235973515e-01,  -8.499932737411014e-03,   7.288341665815673e-05,  -5.179696908810443e-07,
  -1.472944468071546e-09,   2.202898188300363e-10,  -6.489048924934783e-12,   8.849252904053989e-14,   1.128230851920400e-15,  -9.174666616568792e-17,   9.706410395890647e-01,
  -8.500234893076943e-03,   7.288163142294997e-05,  -5.175383627742464e-07,  -1.491897142201995e-09,   2.206475709302152e-10,  -6.482714857177796e-12,   8.784764564366605e-14,
   1.146530143507777e-15,  -9.179006666859449e-17,   9.706492438586281e-01,  -8.500409234557098e-03,   7.288059776875322e-05,  -5.172893298693522e-07,  -1.502832252636949e-09,
   2.208536357630760e-10,  -6.479044245802990e-12,   8.747542878625463e-14,   1.157069719792691e-15,  -9.181411222246300e-17,   9.706523246325982e-01,  -8.500474694245230e-03,
   7.288020898631550e-05,  -5.171957957049632e-07,  -1.506937955969125e-09,   2.209309393790062e-10,  -6.477663043871524e-12,   8.733564986779455e-14,   1.161023406090172e-15,
  -9.182295237733504e-17,   9.706528353144095e-01,  -8.500485544741887e-03,   7.288014450656383e-05,  -5.171802900325799e-07,  -1.507618506585937e-09,   2.209437495621426e-10,
  -6.477433939549842e-12,   8.731247910435254e-14,   1.161678573545021e-15,  -9.182440778252637e-17,   1.269863730625543e+00,  -1.111201890288419e-02,   9.432761228039465e-05,
  -5.915637718803504e-07,  -7.144433535295727e-09,   5.238359552774089e-10,  -1.642253716148000e-11,   3.023511848311071e-13,  -6.297092511042651e-16,  -1.702326362123028e-16,
   1.269877141467098e+00,  -1.111226879290337e-02,   9.432131331451934e-05,  -5.908108200720131e-07,  -7.179508031561998e-09,   5.247252008676225e-10,  -1.642421839039566e-11,
   3.014579186335832e-13,  -5.897923413469614e-16,  -1.710250513446081e-16,   1.269899156854779e+00,  -1.111267879373439e-02,   9.431095089088858e-05,  -5.895738191154049e-07,
  -7.237090648576436e-09,   5.261830983221949e-10,  -1.642686356166049e-11,   2.999885795347954e-13,  -5.242835382752863e-16,  -1.723211409542852e-16,   1.269922515958477e+00,
  -1.111311351802120e-02,   9.429992613133690e-05,  -5.882600315852067e-07,  -7.298193087368340e-09,   5.277273959532973e-10,  -1.642951425305383e-11,   2.984255682389874e-13,
  -4.548030276555650e-16,  -1.736898748802946e-16,   1.269940899025779e+00,  -1.111345541775399e-02,   9.429122828106427e-05,  -5.872251813761648e-07,  -7.346283001698267e-09,
   5.289408491202647e-10,  -1.643148741183259e-11,   2.971926331543062e-13,  -4.001431680854793e-16,  -1.747623491955490e-16,   1.269951507984484e+00,  -1.111365264231400e-02,
   9.428620004071176e-05,  -5.866275916042805e-07,  -7.374037397749637e-09,   5.296403872894655e-10,  -1.643258089394417e-11,   2.964799475378564e-13,  -3.686067067634935e-16,
  -1.753793979470641e-16,   1.269955491703109e+00,  -1.111372668461661e-02,   9.428431027212633e-05,  -5.864031231690566e-07,  -7.384459591267897e-09,   5.299029253023322e-10,
  -1.643298295263864e-11,   2.962121128393665e-13,  -3.567661327181106e-16,  -1.756107470068897e-16,   1.269956152058809e+00,  -1.111373895726578e-02,   9.428399693076989e-05,
  -5.863659107510632e-07,  -7.386187226432839e-09,   5.299464370561882e-10,  -1.643304914835020e-11,   2.961677041136974e-13,  -3.548034771242218e-16,  -1.756490774850491e-16,
   1.707286540405281e-03,  -1.446241786143011e-05,   1.219392069421725e-07,  -9.877024823959163e-10,   6.001174674866074e-12,   3.716477542508140e-14,  -2.563165705393011e-15,
   5.246643264552139e-17,  -1.488591345423704e-19,  -2.664582227370650e-20,   1.707303903491634e-03,  -1.446283934167797e-05,   1.219442999765668e-07,  -9.876482912019259e-10,
   5.995697872416755e-12,   3.731934446226684e-14,  -2.563638449173467e-15,   5.232752982268457e-17,  -1.430491390249705e-19,  -2.673573678621979e-20,   1.707332408327688e-03,
  -1.446353125271256e-05,   1.219526576354213e-07,  -9.875591695274655e-10,   5.986706149202431e-12,   3.757279298504390e-14,  -2.564397849830698e-15,   5.209917120194382e-17,
  -1.335194443577741e-19,  -2.688257909084284e-20,   1.707362654868142e-03,  -1.446426540066194e-05,   1.219615211616768e-07,  -9.874643898973177e-10,   5.977164345349139e-12,
   3.784131121702165e-14,  -2.565180969958579e-15,   5.185642198072540e-17,  -1.234191098511236e-19,  -2.703734770033308e-20,   1.707386459565694e-03,  -1.446484316218560e-05,
   1.219684934758230e-07,  -9.873896425552030e-10,   5.969654261843385e-12,   3.805233915113736e-14,  -2.565780891749497e-15,   5.166505749420429e-17,  -1.154783966105696e-19,
  -2.715839657835232e-20,   1.707400197927037e-03,  -1.446517659292956e-05,   1.219725160007410e-07,  -9.873464422046640e-10,   5.965319795407665e-12,   3.817400821682048e-14,
  -2.566120548746861e-15,   5.155448960924524e-17,  -1.108989982536303e-19,  -2.722795365226553e-20,   1.707405356857058e-03,  -1.446530179821684e-05,   1.219740262467172e-07,
  -9.873302082926947e-10,   5.963692113266899e-12,   3.821967360362747e-14,  -2.566246852018930e-15,   5.151294618076754e-17,  -1.091800220997719e-19,  -2.725401582742207e-20,
   1.707406212025595e-03,  -1.446532255271821e-05,   1.219742765783040e-07,  -9.873275166696404e-10,   5.963422299190569e-12,   3.822724210485419e-14,  -2.566267723119750e-15,
   5.150605849326549e-17,  -1.088951106566877e-19,  -2.725833298849125e-20,   1.540794218474123e-02,  -1.305203019398008e-04,   1.100436794311283e-06,  -8.910429731617647e-09,
   5.396437456508997e-11,   3.436304837025387e-13,  -2.338586203659614e-14,   4.787723455112180e-16,  -1.386996013130464e-18,  -2.420573119374413e-19,   1.540809887706669e-02,
  -1.305241042266393e-04,   1.100482588324292e-06,  -8.909928829197787e-09,   5.391440381857697e-11,   3.450410622364781e-13,  -2.339029189032109e-14,   4.775103600030259e-16,
  -1.334071234935647e-18,  -2.428799958005610e-19,   1.540835611755083e-02,  -1.305303461386997e-04,   1.100557735755692e-06,  -8.909105074342331e-09,   5.383236249698612e-11,
   3.473540152336437e-13,  -2.339741222256929e-14,   4.754356128941428e-16,  -1.247262104016991e-18,  -2.442235865304822e-19,   1.540862907593610e-02,  -1.305369690760252e-04,
   1.100637431055857e-06,  -8.908229047887045e-09,   5.374530194256708e-11,   3.498045097847179e-13,  -2.340476099931278e-14,   4.732300914086761e-16,  -1.155253965288152e-18,
  -2.456397553137722e-19,   1.540884390021612e-02,  -1.305421812075249e-04,   1.100700121314102e-06,  -8.907538193393649e-09,   5.367677886842363e-11,   3.517303604204967e-13,
  -2.341039514767886e-14,   4.714914100216193e-16,  -1.082918089674385e-18,  -2.467474194415559e-19,   1.540896788135097e-02,  -1.305451891683491e-04,   1.100736288917021e-06,
  -8.907138920126141e-09,   5.363723050639156e-11,   3.528407227005923e-13,  -2.341358687837025e-14,   4.704868144237538e-16,  -1.041201840396494e-18,  -2.473839207028194e-19,
   1.540901443784808e-02,  -1.305463186757887e-04,   1.100749867911064e-06,  -8.906988881803674e-09,   5.362237926182141e-11,   3.532574698247050e-13,  -2.341477409711799e-14,
   4.701093583519994e-16,  -1.025542697368082e-18,  -2.476224128093139e-19,   1.540902215527225e-02,  -1.305465059071937e-04,   1.100752118702330e-06,  -8.906964005147879e-09,
   5.361991743226904e-11,   3.533265408109234e-13,  -2.341497029917022e-14,   4.700467779870057e-16,  -1.022947272581566e-18,  -2.476619188330661e-19,   4.303955444838924e-02,
  -3.645851832738735e-04,   3.073648871769840e-06,  -2.487023021285933e-08,   1.496155696688501e-10,   1.007362553730996e-12,  -6.679216395927056e-14,   1.367957856680719e-15,
  -4.130491881467114e-18,  -6.852191014662859e-19,   4.303999210646140e-02,  -3.645957957319018e-04,   3.073775811389341e-06,  -2.486876268191080e-08,   1.494728405037429e-10,
   1.011393403724255e-12,  -6.680549976482856e-14,   1.364384482662469e-15,  -3.979816299733953e-18,  -6.875826068487133e-19,   4.304071060596668e-02,  -3.646132173390432e-04,
   3.073984115193972e-06,  -2.486634937015899e-08,   1.492385085580048e-10,   1.018002937434387e-12,  -6.682695991581729e-14,   1.358509608628882e-15,  -3.732669033825526e-18,
  -6.914428656372826e-19,   4.304147300707002e-02,  -3.646317023845779e-04,   3.074205021855871e-06,  -2.486378306184168e-08,   1.489898389010691e-10,   1.025005608433211e-12,
  -6.684914301253694e-14,   1.352264262297806e-15,  -3.470715013673537e-18,  -6.955119605425145e-19,   4.304207303348210e-02,  -3.646462497586927e-04,   3.074378789835356e-06,
  -2.486175931403452e-08,   1.487941165061828e-10,   1.030509097204719e-12,  -6.686617592194681e-14,   1.347340737982092e-15,  -3.264765715999660e-18,  -6.986948527735962e-19,
   4.304241932556231e-02,  -3.646546451506553e-04,   3.074479039969394e-06,  -2.486058974742848e-08,   1.486811541367123e-10,   1.033682199052530e-12,  -6.687583555193989e-14,
   1.344495917531233e-15,  -3.145992856942072e-18,  -7.005239418721487e-19,   4.304254936264661e-02,  -3.646577976693796e-04,   3.074516678320507e-06,  -2.486015025706563e-08,
   1.486387343038604e-10,   1.034873149940899e-12,  -6.687943064309659e-14,   1.343427025652007e-15,  -3.101408484453097e-18,  -7.012093047999887e-19,   4.304257091820554e-02,
  -3.646583202426651e-04,   3.074522917069292e-06,  -2.486007738908274e-08,   1.486317025389696e-10,   1.035070536470976e-12,  -6.688002488269082e-14,   1.343249808132874e-15,
  -3.094018832598517e-18,  -7.013228355302638e-19,   8.508472813269659e-02,  -7.207413245765215e-04,   6.075533993558082e-06,  -4.910463407037277e-08,   2.922525522132460e-10,
   2.140420262449520e-12,  -1.366587732601350e-13,   2.801056861196072e-15,  -8.994370072658440e-18,  -1.382667692406067e-18,   8.508559322427357e-02,  -7.207622774062540e-04,
   6.075781876783934e-06,  -4.910151850149912e-08,   2.919604979372738e-10,   2.148675558182084e-12,  -1.366882537849987e-13,   2.793843326053080e-15,  -8.687561305422779e-18,
  -1.387549228794084e-18,   8.508701343737884e-02,  -7.207966738907055e-04,   6.076188636885771e-06,  -4.909639534789586e-08,   2.914810014596681e-10,   2.162212297418505e-12,
  -1.367357696300717e-13,   2.781983368168707e-15,  -8.184302751625832e-18,  -1.395522867339653e-18,   8.508852042759527e-02,  -7.208331698906221e-04,   6.076619995694596e-06,
  -4.909094781996111e-08,   2.909721621396989e-10,   2.176554513401504e-12,  -1.367849906464165e-13,   2.769374963591641e-15,  -7.650877178084347e-18,  -1.403928877733172e-18,
   8.508970646167575e-02,  -7.208618914713712e-04,   6.076959299876937e-06,  -4.908665229211610e-08,   2.905716625994437e-10,   2.187826466946126e-12,  -1.368228617343117e-13,
   2.759434717897477e-15,  -7.231483942052568e-18,  -1.410504886210991e-18,   8.509039095509900e-02,  -7.208784668708899e-04,   6.077155047814606e-06,  -4.908416993635625e-08,
   2.903405105127330e-10,   2.194325534938951e-12,  -1.368443708737557e-13,   2.753691068104947e-15,  -6.989611220078370e-18,  -1.414284166897661e-18,   8.509064799106882e-02,
  -7.208846910251631e-04,   6.077228539664939e-06,  -4.908323715934325e-08,   2.902537076099302e-10,   2.196764827695083e-12,  -1.368523822025366e-13,   2.751532961348760e-15,
  -6.898817323189259e-18,  -1.415700325934888e-18,   8.509069059855930e-02,  -7.208857227639691e-04,   6.077240721281692e-06,  -4.908308250509232e-08,   2.902393186288360e-10,
   2.197169113546307e-12,  -1.368537067365119e-13,   2.751175155261452e-15,  -6.883768610522435e-18,  -1.415934916377908e-18,   1.423277038387661e-01,  -1.205625200488835e-03,
   1.016120473167211e-05,  -8.199362468728184e-08,   4.803715486341127e-10,   3.941171231523202e-12,  -2.398305652118267e-13,   4.922708334557167e-15,  -1.714502604536864e-17,
  -2.379361585408879e-18,   1.423291506717793e-01,  -1.205660185103273e-03,   1.016161198941530e-05,  -8.198789376577395e-08,   4.798589399797237e-10,   3.955683565080547e-12,
  -2.398877934794153e-13,   4.910287285597856e-15,  -1.661004411401698e-17,  -2.388047297305399e-18,   1.423315259238229e-01,  -1.205717616214590e-03,   1.016228025237551e-05,
  -8.197847068645231e-08,   4.790173274889265e-10,   3.979480931161675e-12,  -2.399802062059168e-13,   4.889864486974398e-15,  -1.573248224087626e-17,  -2.402236632151868e-18,
   1.423340463062089e-01,  -1.205778552620330e-03,   1.016298890080182e-05,  -8.196845191174986e-08,   4.781242008648703e-10,   4.004695073123380e-12,  -2.400761758125063e-13,
   4.868151464125889e-15,  -1.480227453921646e-17,  -2.417197907203016e-18,   1.423360299012066e-01,  -1.205826508121806e-03,   1.016354629932382e-05,  -8.196055249955992e-08,
   4.774212263700587e-10,   4.024512132450782e-12,  -2.401501939149655e-13,   4.851032284109010e-15,  -1.407089049566844e-17,  -2.428903922289318e-18,   1.423371746890246e-01,
  -1.205854183469291e-03,   1.016386786003391e-05,  -8.195598775234204e-08,   4.770154946517722e-10,   4.035938271575484e-12,  -2.401923060242685e-13,   4.841140114176640e-15,
  -1.364907412559729e-17,  -2.435632193870679e-18,   1.423376045713250e-01,  -1.205864575703168e-03,   1.016398858567435e-05,  -8.195427254064727e-08,   4.768631324637000e-10,
   4.040226881930149e-12,  -2.402080051885291e-13,   4.837423174877722e-15,  -1.349073090407623e-17,  -2.438153528576272e-18,   1.423376758306326e-01,  -1.205866298357599e-03,
   1.016400859643207e-05,  -8.195398816154288e-08,   4.768378759402253e-10,   4.040937673969653e-12,  -2.402106015180141e-13,   4.836806916114856e-15,  -1.346448604957607e-17,
  -2.438571201650713e-18,   2.159441960954575e-01,  -1.829184867878842e-03,   1.541312233025411e-05,  -1.240930023310270e-07,   7.108763774525174e-10,   6.745036381901536e-12,
  -3.878560107105116e-13,   7.980811939317915e-15,  -3.074836032014132e-17,  -3.746463920321582e-18,   2.159463907070780e-01,  -1.829237811264883e-03,   1.541372460950641e-05,
  -1.240832052156819e-07,   7.100472375028792e-10,   6.768573093484621e-12,  -3.879607430467601e-13,   7.961236847684526e-15,  -2.989018218840238e-17,  -3.760786241969158e-18,
   2.159499935785357e-01,  -1.829324723334660e-03,   1.541471283632900e-05,  -1.240670975865657e-07,   7.086859179194878e-10,   6.807169887226258e-12,  -3.881302126097376e-13,
   7.929048968664342e-15,  -2.848239327451420e-17,  -3.784187881338446e-18,   2.159538165869166e-01,  -1.829416939586224e-03,   1.541576072541020e-05,  -1.240499734461588e-07,
   7.072412478987755e-10,   6.848066208679869e-12,  -3.883066837493064e-13,   7.894824424970288e-15,  -2.699005517592267e-17,  -3.808868236389108e-18,   2.159568253748982e-01,
  -1.829489511237248e-03,   1.541658491569520e-05,  -1.240364730001784e-07,   7.061041384071056e-10,   6.880209888420613e-12,  -3.884431439029636e-13,   7.867838505716572e-15,
  -2.581662275158632e-17,  -3.828182735214283e-18,   2.159585618294406e-01,  -1.829531392543134e-03,   1.541706037001344e-05,  -1.240286721519505e-07,   7.054478320602899e-10,
   6.898743807068814e-12,  -3.885209266816137e-13,   7.852244009559509e-15,  -2.513983324659876e-17,  -3.839285777501489e-18,   2.159592138899545e-01,  -1.829547119160561e-03,
   1.541723886965400e-05,  -1.240257410653877e-07,   7.052013715600275e-10,   6.905700295373465e-12,  -3.885499514032961e-13,   7.846384273357418e-15,  -2.488577194842694e-17,
  -3.843446812960123e-18,   2.159593219785590e-01,  -1.829549726060403e-03,   1.541726845651003e-05,  -1.240252551013971e-07,   7.051605166287168e-10,   6.906853264949498e-12,
  -3.885547529879863e-13,   7.845412735386404e-15,  -2.484366187267097e-17,  -3.844136127975251e-18,   3.076598915089945e-01,  -2.606019332599718e-03,   2.195197436189763e-05,
  -1.761886825100432e-07,   9.773932563105024e-10,   1.112784163989083e-11,  -6.005499256994548e-13,   1.240988039745796e-14,  -5.398695705099130e-17,  -5.594907995698174e-18,
   3.076630170996890e-01,  -2.606094494333320e-03,   2.195280162663551e-05,  -1.761725380431648e-07,   9.761091241192371e-10,   1.116445903020429e-11,  -6.007377696515509e-13,
   1.238060979148010e-14,  -5.267131224889497e-17,  -5.617694862320149e-18,   3.076681483467410e-01,  -2.606217879433175e-03,   2.195415892245703e-05,  -1.761459968194541e-07,
   9.740007379294457e-10,   1.122450878742021e-11,  -6.010423652363870e-13,   1.233247424205411e-14,  -5.051292704359519e-17,  -5.654935616018938e-18,   3.076735931106954e-01,
  -2.606348793691038e-03,   2.195559804020990e-05,  -1.761177836428312e-07,   9.717632061629029e-10,   1.128813966494374e-11,  -6.013604287934978e-13,   1.228128608772702e-14,
  -4.822470936946919e-17,  -5.694223086506112e-18,   3.076778782512278e-01,  -2.606451818921542e-03,   2.195672985286150e-05,  -1.760955429093301e-07,   9.700019907511314e-10,
   1.133815475439985e-11,  -6.016070298001201e-13,   1.224091947207374e-14,  -4.642532559445655e-17,  -5.724977488620341e-18,   3.076803513227577e-01,  -2.606511274799478e-03,
   2.195738273115603e-05,  -1.760826925990813e-07,   9.689854530356993e-10,   1.136699426386375e-11,  -6.017478588435662e-13,   1.221759062033803e-14,  -4.538745294688694e-17,
  -5.742660273217812e-18,   3.076812799919707e-01,  -2.606533600695185e-03,   2.195762783430020e-05,  -1.760778643933785e-07,   9.686037131045293e-10,   1.137781902479805e-11,
  -6.018004601447422e-13,   1.220882427437286e-14,  -4.499783279114912e-17,  -5.749287822635889e-18,   3.076814339325158e-01,  -2.606537301512038e-03,   2.195766846053433e-05,
  -1.760770639022044e-07,   9.685404331988194e-10,   1.137961313259505e-11,  -6.018091647197485e-13,   1.220737080391277e-14,  -4.493325355730917e-17,  -5.750385773681212e-18,
   4.200394155464079e-01,  -3.557819498944060e-03,   2.995637427256268e-05,  -2.393838174840763e-07,   1.266434365434675e-09,   1.813124906149523e-11,  -9.138573630265239e-13,
   1.902067414558511e-14,  -9.559175474838142e-17,  -8.098003816857223e-18,   4.200436807106019e-01,  -3.557921604248336e-03,   2.995744453311141e-05,  -2.393575418312589e-07,
   1.264479657635609e-09,   1.818741122678966e-11,  -9.141972504127099e-13,   1.897822663273260e-14,  -9.361382615583281e-17,  -8.134027811253770e-18,   4.200506827764237e-01,
  -3.558089218416637e-03,   2.995920033149491e-05,  -2.393143486108241e-07,   1.261270185754378e-09,   1.827951820548304e-11,  -9.147495448877981e-13,   1.890841064011812e-14,
  -9.036860431681524e-17,  -8.192920297072879e-18,   4.200581126568860e-01,  -3.558267058832003e-03,   2.996106172800304e-05,  -2.392684391922934e-07,   1.257864009649731e-09,
   1.837712522381794e-11,  -9.153278477038341e-13,   1.883415221702703e-14,  -8.692773270372560e-17,  -8.255074247936247e-18,   4.200639601185641e-01,  -3.558407012077321e-03,
   2.996252546837801e-05,  -2.392322517525090e-07,   1.255182843760553e-09,   1.845385139750688e-11,  -9.157773848252338e-13,   1.877558177814544e-14,  -8.422161812848303e-17,
  -8.303746646912808e-18,   4.200673348458009e-01,  -3.558487778584108e-03,   2.996336974513621e-05,  -2.392113446444841e-07,   1.253635296367147e-09,   1.849809503040112e-11,
  -9.160345814330900e-13,   1.874172818536489e-14,  -8.266062121102885e-17,  -8.331738948252884e-18,   4.200686020975161e-01,  -3.558518106596379e-03,   2.996368668939819e-05,
  -2.392034895420378e-07,   1.253054140387532e-09,   1.851470204289600e-11,  -9.161307380171019e-13,   1.872900611606395e-14,  -8.207459463203483e-17,  -8.342231902800960e-18,
   4.200688121630533e-01,  -3.558523133866114e-03,   2.996373922269530e-05,  -2.392021872208596e-07,   1.252957803541084e-09,   1.851745452819217e-11,  -9.161466550186122e-13,
   1.872689673918359e-14,  -8.197745991279220e-17,  -8.343970287645062e-18,   5.570549097779434e-01,  -4.718168511884430e-03,   3.970125751086666e-05,  -3.152369063972845e-07,
   1.547667216164240e-09,   2.981427143254298e-11,  -1.399429075575700e-12,   2.949076663269280e-14,  -1.760999324796145e-16,  -1.152215118761442e-17,   5.570605621815440e-01,
  -4.718302940831131e-03,   3.970256200601534e-05,  -3.151937434933692e-07,   1.544672469078757e-09,   2.990143196884366e-11,  -1.400068903689060e-12,   2.943018255332217e-14,
  -1.731169318961167e-16,  -1.158042193190523e-17,   5.570698416485785e-01,  -4.718523614219287e-03,   3.970470169545167e-05,  -3.151227953541103e-07,   1.539755152673054e-09,
   3.004438823188383e-11,  -1.401110706018116e-12,   2.933051092294032e-14,  -1.682219291362025e-16,  -1.167572369261087e-17,   5.570796880592679e-01,  -4.718757747399609e-03,
   3.970696955606194e-05,  -3.150473926751704e-07,   1.534536210055913e-09,   3.019589641164420e-11,  -1.402204482494995e-12,   2.922446278563915e-14,  -1.630308060633677e-16,
  -1.177635776492314e-17,   5.570874373657313e-01,  -4.718941998152659e-03,   3.970875255292169e-05,  -3.149879626629106e-07,   1.530427946592595e-09,   3.031500401161316e-11,
  -1.403056853506667e-12,   2.914079379552518e-14,  -1.589474561647368e-16,  -1.185520332266686e-17,   5.570919096939129e-01,  -4.719048327533942e-03,   3.970978082510409e-05,
  -3.149536293024918e-07,   1.528056617220503e-09,   3.038369110798162e-11,  -1.403545392473869e-12,   2.909242337795019e-14,  -1.565917217327516e-16,  -1.190056463405393e-17,
   5.570935891074218e-01,  -4.719088254265827e-03,   3.971016681351415e-05,  -3.149407301450631e-07,   1.527166089713992e-09,   3.040947391623775e-11,  -1.403728204773565e-12,
   2.907424406287216e-14,  -1.557072810482554e-16,  -1.191757140510163e-17,   5.570938674947667e-01,  -4.719094872639945e-03,   3.971023078933669e-05,  -3.149385915748933e-07,
   1.527018468358957e-09,   3.041374726438311e-11,  -1.403758474824604e-12,   2.907122975125793e-14,  -1.555606808639184e-16,  -1.192038910394019e-17,   7.253530317576997e-01,
  -6.143230683622092e-03,   5.164226243583696e-05,  -4.059596512031105e-07,   1.744855729582709e-09,   5.085791581057870e-11,  -2.223054036737552e-12,   4.790418474803912e-14,
  -3.535251579586594e-16,  -1.620479117264061e-17,   7.253603837722957e-01,  -6.143403736589678e-03,   5.164372528914682e-05,  -4.058860808281206e-07,   1.740094923427512e-09,
   5.099970036081649e-11,  -2.224366509929858e-12,   4.781848372716465e-14,  -3.488888099273410e-16,  -1.630520789405205e-17,   7.253724534406090e-01,  -6.143687808070244e-03,
   5.164612385672604e-05,  -4.057651578869049e-07,   1.732277315642938e-09,   5.123227580196353e-11,  -2.226507802025289e-12,   4.767742372730081e-14,  -3.412788032166349e-16,
  -1.646953809098294e-17,   7.253852604905189e-01,  -6.143989198621210e-03,   5.164866492203872e-05,  -4.056366519798143e-07,   1.723979558025413e-09,   5.147880194950575e-11,
  -2.228761743578950e-12,   4.752724921285893e-14,  -3.332058297217446e-16,  -1.664319732639506e-17,   7.253953398500519e-01,  -6.144226371927205e-03,   5.165066185697557e-05,
  -4.055353743734360e-07,   1.717447253766991e-09,   5.167263481149363e-11,  -2.230522479064657e-12,   4.740870065979505e-14,  -3.268537248978968e-16,  -1.677935485240740e-17,
   7.254011569031974e-01,  -6.144363240197809e-03,   5.165181316582054e-05,  -4.054768678796682e-07,   1.713676564363910e-09,   5.178442547324377e-11,  -2.231533372041519e-12,
   4.734013977192620e-14,  -3.231883628908743e-16,  -1.685772806450242e-17,   7.254033412753917e-01,  -6.144414633877070e-03,   5.165224527421192e-05,  -4.054548873000863e-07,
   1.712260488018915e-09,   5.182638996446023e-11,  -2.231911977923878e-12,   4.731436725425626e-14,  -3.218120908370509e-16,  -1.688711902808444e-17,   7.254037033669242e-01,
  -6.144423153024428e-03,   5.165231689078131e-05,  -4.054512431342318e-07,   1.712025745455536e-09,   5.183334543992923e-11,  -2.231974684806519e-12,   4.731009365524063e-14,
  -3.215839597724708e-16,  -1.689198894514817e-17,   9.377120895329020e-01,  -7.940883824655220e-03,   6.664091383175218e-05,  -5.144713292089529e-07,   1.622832681914455e-09,
   9.473516242106100e-11,  -3.878518147180710e-12,   8.736166356133194e-14,  -8.510930340173540e-16,  -2.169283758215916e-17,   9.377215757153429e-01,  -7.941102979354976e-03,
   6.664225233489001e-05,  -5.143343273707586e-07,   1.614515413426598e-09,   9.499436704943580e-11,  -3.881748721094258e-12,   8.724520767018519e-14,  -8.433532012208459e-16,
  -2.189174015731903e-17,   9.377371489496397e-01,  -7.941462714487027e-03,   6.664444455950555e-05,  -5.141091508482262e-07,   1.600856372026675e-09,   9.541963841209864e-11,
  -3.887029916245150e-12,   8.705329537774916e-14,  -8.306427847138450e-16,  -2.221755453943952e-17,   9.377536735320818e-01,  -7.941844363086011e-03,   6.664676368525205e-05,
  -5.138698600093328e-07,   1.586356433981025e-09,   9.587053678798713e-11,  -3.892603338381685e-12,   8.684866944167766e-14,  -8.171503961521738e-16,  -2.256229272449438e-17,
   9.377666785934027e-01,  -7.942144680380535e-03,   6.664858378426616e-05,  -5.136812754967294e-07,   1.574940114252080e-09,   9.622514396859481e-11,  -3.896967683179648e-12,
   8.668691055613983e-14,  -8.065277941729863e-16,  -2.283289489510411e-17,   9.377741841198749e-01,  -7.942317982453012e-03,   6.664963216821938e-05,  -5.135723349564693e-07,
   1.568349616798723e-09,   9.642969338534215e-11,  -3.899477624534335e-12,   8.659326923188060e-14,  -8.003956948088115e-16,  -2.298878003613835e-17,   9.377770025293827e-01,
  -7.942383055906846e-03,   6.665002546293026e-05,  -5.135314069096602e-07,   1.565874457889408e-09,   9.650648454805233e-11,  -3.900418467594882e-12,   8.655805176233548e-14,
  -7.980927332071166e-16,  -2.304726257824886e-17,   9.377774697216112e-01,  -7.942393842594540e-03,   6.665009063690507e-05,  -5.135246214561311e-07,   1.565464145810549e-09,
   9.651921277010832e-11,  -3.900574337964842e-12,   8.655221110336405e-14,  -7.977109687423197e-16,  -2.305695405257313e-17,   1.226878085993046e+00,  -1.038706533385527e-02,
   8.682698296193331e-05,  -6.406959121902886e-07,   4.636556318354973e-11,   2.248457497588021e-10,  -8.868266138093223e-12,   2.234823896445306e-13,  -3.340071315707305e-15,
  -7.529782460203183e-18,   1.226890441970607e+00,  -1.038733770961494e-02,   8.682691434521475e-05,  -6.403703096330440e-07,   2.728111458052444e-11,   2.255127368366832e-10,
  -8.881279565099605e-12,   2.234291833428598e-13,  -3.325880134935969e-15,  -8.074731563799531e-18,   1.226910726283604e+00,  -1.038778475672768e-02,   8.682678987305708e-05,
  -6.398350946594718e-07,  -4.069017382501403e-12,   2.266075796472268e-10,  -8.902602064666264e-12,   2.233398189463375e-13,  -3.302534768155455e-15,  -8.969324673654307e-18,
   1.226932249474398e+00,  -1.038825896982576e-02,   8.682664171824321e-05,  -6.392662583802203e-07,  -3.736096975802135e-11,   2.277691209950257e-10,  -8.925170886510031e-12,
   2.232422543535759e-13,  -3.277698092296136e-15,  -9.918510460817418e-18,   1.226949188314226e+00,  -1.038863207770053e-02,   8.682651347181633e-05,  -6.388179066289197e-07,
  -6.358146097796318e-11,   2.286831340946488e-10,  -8.942892064090197e-12,   2.231634852519484e-13,  -3.258104225031856e-15,  -1.066548525242320e-17,   1.226958964039957e+00,
  -1.038884736530559e-02,   8.682643478754200e-05,  -6.385588836680544e-07,  -7.872164663308517e-11,   2.292105777836105e-10,  -8.953103006595791e-12,   2.231172303010337e-13,
  -3.246777306622364e-15,  -1.109656135700133e-17,   1.226962634920273e+00,  -1.038892820033171e-02,   8.682640435778692e-05,  -6.384615668648331e-07,  -8.440841528800583e-11,
   2.294086283932664e-10,  -8.956934234674309e-12,   2.230997107029505e-13,  -3.242520365247481e-15,  -1.125843116293577e-17,   1.226963243421129e+00,  -1.038894159949278e-02,
   8.682639926703077e-05,  -6.384454325157299e-07,  -8.535115655694815e-11,   2.294414576010216e-10,  -8.957569152902116e-12,   2.230967986443930e-13,  -3.241814528003322e-15,
  -1.128526320714712e-17,   1.651315185395902e-03,  -1.353264442222415e-05,   1.106779131245902e-07,  -8.885989849698844e-10,   6.242592410090091e-12,  -7.922026058350182e-15,
  -1.261069623271268e-15,   3.830723464878126e-17,  -5.863969939373411e-19,  -1.375486543953321e-21,   1.651330946363619e-03,  -1.353302382094202e-05,   1.106832279063415e-07,
  -8.886092934771736e-10,   6.239873414701364e-12,  -7.807699214810477e-15,  -1.263357220838958e-15,   3.829796734619371e-17,  -5.840428721112802e-19,  -1.458283687898310e-21,
   1.651356821087873e-03,  -1.353364666831350e-05,   1.106919512944022e-07,  -8.886260990329878e-10,   6.235406240287920e-12,  -7.620034654682254e-15,  -1.267105870213049e-15,
   3.828244770747180e-17,  -5.801725375082993e-19,  -1.594112800971211e-21,   1.651384276910802e-03,  -1.353430756153789e-05,   1.107012051903336e-07,  -8.886437713096588e-10,
   6.230661467272146e-12,  -7.420937574785945e-15,  -1.271074209602536e-15,   3.826556467751462e-17,  -5.760581426156593e-19,  -1.738106823546035e-21,   1.651405885323953e-03,
  -1.353482769087731e-05,   1.107084863939350e-07,  -8.886575638547845e-10,   6.226923867258196e-12,  -7.264268786257081e-15,  -1.274190596793229e-15,   3.825197697188654e-17,
  -5.728145582340309e-19,  -1.851335151418085e-21,   1.651418356176650e-03,  -1.353512786884692e-05,   1.107126878527486e-07,  -8.886654774555721e-10,   6.224765448292662e-12,
  -7.173860940663721e-15,  -1.275986430081691e-15,   3.824401476873288e-17,  -5.709404105068814e-19,  -1.916642813161419e-21,   1.651423039146468e-03,  -1.353524058887753e-05,
   1.107142654163638e-07,  -8.886684403317441e-10,   6.223954680435831e-12,  -7.139913565503436e-15,  -1.276660273741012e-15,   3.824100211789792e-17,  -5.702362321332992e-19,
  -1.941159160250094e-21,   1.651423815417889e-03,  -1.353525927384754e-05,   1.107145269134687e-07,  -8.886689310087803e-10,   6.223820270342796e-12,  -7.134286390520271e-15,
  -1.276771946082587e-15,   3.824050152712852e-17,  -5.701194824948088e-19,  -1.945222708324503e-21,   1.490281196122252e-02,  -1.221294837416313e-04,   9.988322851020524e-07,
  -8.018128869099149e-09,   5.625771358136112e-11,  -6.778056261222436e-14,  -1.151164765832090e-14,   3.491508555177281e-16,  -5.352323292523037e-18,  -1.211555214508617e-20,
   1.490295419870657e-02,  -1.221329071655042e-04,   9.988801796673576e-07,  -8.018216528939073e-09,   5.623289328978364e-11,  -6.673849715932903e-14,  -1.153252962297889e-14,
   3.490685607221463e-16,  -5.330931504275619e-18,  -1.286969038555597e-20,   1.490318770946730e-02,  -1.221385272950021e-04,   9.989587909539172e-07,  -8.018359365502035e-09,
   5.619211478257699e-11,  -6.502796893281532e-14,  -1.156674884289511e-14,   3.489306745497660e-16,  -5.295761624289608e-18,  -1.410686810665065e-20,   1.490343548910640e-02,
  -1.221444907208065e-04,   9.990421826728838e-07,  -8.018509470325487e-09,   5.614880222136750e-11,  -6.321322897494226e-14,  -1.160297386506778e-14,   3.487805821102810e-16,
  -5.258373495701920e-18,  -1.541842860675441e-20,   1.490363049781640e-02,  -1.221491839927598e-04,   9.991077972303450e-07,  -8.018626549652954e-09,   5.611468361690304e-11,
  -6.178521187981290e-14,  -1.163142211025354e-14,   3.486597198606921e-16,  -5.228898219126763e-18,  -1.644977185398466e-20,   1.490374304309295e-02,  -1.221518925815564e-04,
   9.991456585934270e-07,  -8.018693695973442e-09,   5.609498053356024e-11,  -6.096115342171696e-14,  -1.164781566101058e-14,   3.485888705487059e-16,  -5.211867227914907e-18,
  -1.704463250062773e-20,   1.490378530532946e-02,  -1.221529096854261e-04,   9.991598747620353e-07,  -8.018718830240775e-09,   5.608757945568669e-11,  -6.065172614551851e-14,
  -1.165396697139265e-14,   3.485620585737491e-16,  -5.205468104243517e-18,  -1.726794259766200e-20,   1.490379231091941e-02,  -1.221530782850482e-04,   9.991622312348085e-07,
  -8.018722992393326e-09,   5.608635249588417e-11,  -6.060043493230738e-14,  -1.165498639477337e-14,   3.485576031676441e-16,  -5.204407156702208e-18,  -1.730495595473872e-20,
   4.162856079463193e-02,  -3.411480398564406e-04,   2.789986351409093e-06,  -2.238977915246987e-08,   1.566828447520244e-10,  -1.679158711329670e-13,  -3.291072870286124e-14,
   9.951687960717801e-16,  -1.530043619322683e-17,  -3.206347270673345e-20,   4.162895809840284e-02,  -3.411575992972520e-04,   2.790119731735680e-06,  -2.238999303383833e-08,
   1.566118857583290e-10,  -1.649455158608160e-13,  -3.297043456976949e-14,   9.949469615780974e-16,  -1.523984273668409e-17,  -3.420998855534649e-20,   4.162961035051718e-02,
  -3.411732927270558e-04,   2.790338653118769e-06,  -2.239034110108474e-08,   1.564953036376718e-10,  -1.600697134262181e-13,  -3.306827605326610e-14,   9.945748542121763e-16,
  -1.514022004231432e-17,  -3.773144814567907e-20,   4.163030245900682e-02,  -3.411899447509088e-04,   2.790570885783798e-06,  -2.239070627748906e-08,   1.563714768594863e-10,
  -1.548968215059310e-13,  -3.317185486693338e-14,   9.941692467567044e-16,  -1.503431117908527e-17,  -4.146471073433019e-20,   4.163084716547989e-02,  -3.412030500401053e-04,
   2.790753610759965e-06,  -2.239099066887636e-08,   1.562739347721584e-10,  -1.508262507592178e-13,  -3.325319902892580e-14,   9.938422356847316e-16,  -1.495081497800242e-17,
  -4.440041477032132e-20,   4.163116153162974e-02,  -3.412106133822540e-04,   2.790859047531414e-06,  -2.239115359249010e-08,   1.562176053835938e-10,  -1.484772566053926e-13,
  -3.330007496499864e-14,   9.936503875249886e-16,  -1.490256958492872e-17,  -4.609370115881042e-20,   4.163127958026427e-02,  -3.412134534968636e-04,   2.790898636800584e-06,
  -2.239121454432716e-08,   1.561964463491211e-10,  -1.475952262679039e-13,  -3.331766422623958e-14,   9.935777563808930e-16,  -1.488444199812951e-17,  -4.672936371422302e-20,
   4.163129914856892e-02,  -3.412139242867459e-04,   2.790905199115195e-06,  -2.239122463595991e-08,   1.561929385782572e-10,  -1.474490192486763e-13,  -3.332057920580511e-14,
   9.935656855944709e-16,  -1.488143651334114e-17,  -4.683472419166697e-20,   8.229535463868462e-02,  -6.744123583691554e-04,   5.515240469309144e-06,  -4.423871800929280e-08,
   3.082961647386171e-10,  -2.649017605923497e-13,  -6.742950782147971e-14,   2.029910066253026e-15,  -3.135527087300185e-17,  -5.747982165144256e-20,   8.229614002560949e-02,
  -6.744312459937848e-04,   5.515502881712263e-06,  -4.423904383023705e-08,   3.081507788178052e-10,  -2.588422821604702e-13,  -6.755190041592407e-14,   2.029498405371559e-15,
  -3.123288243545222e-17,  -6.184893348897081e-20,   8.229742939225228e-02,  -6.744622531759065e-04,   5.515933583970571e-06,  -4.423957248840276e-08,   3.079119168167848e-10,
  -2.488956327734477e-13,  -6.775247343356142e-14,   2.028806454574869e-15,  -3.103165509973049e-17,  -6.901686180913654e-20,   8.229879754646999e-02,  -6.744951543133452e-04,
   5.516390469744007e-06,  -4.424012496952623e-08,   3.076582112675610e-10,  -2.383427998017775e-13,  -6.796481499116676e-14,   2.028050311505743e-15,  -3.081772154465566e-17,
  -7.661618147614971e-20,   8.229987431749443e-02,  -6.745210477680103e-04,   5.516749952425787e-06,  -4.424055364587206e-08,   3.074583596348029e-10,  -2.300386433353552e-13,
  -6.813157961470480e-14,   2.027439352822095e-15,  -3.064905469610708e-17,  -8.259220734129885e-20,   8.230049575371592e-02,  -6.745359914214793e-04,   5.516957381290093e-06,
  -4.424079858663652e-08,   3.073429476581573e-10,  -2.252465494421899e-13,  -6.822768259990174e-14,   2.027080397626895e-15,  -3.055159383867242e-17,  -8.603920003126772e-20,
   8.230072911120141e-02,  -6.745416029184345e-04,   5.517035266156648e-06,  -4.424089009999825e-08,   3.072995953941145e-10,  -2.234471461937809e-13,  -6.826374372380527e-14,
   2.026944404768893e-15,  -3.051497369181406e-17,  -8.733322150209985e-20,   8.230076779365061e-02,  -6.745425331047176e-04,   5.517048176332777e-06,  -4.424090524515276e-08,
   3.072924084017429e-10,  -2.231488733548860e-13,  -6.826971997276902e-14,   2.026921798623078e-15,  -3.050890218568036e-17,  -8.754770512905399e-20,   1.376617408732742e-01,
  -1.128136411567419e-03,   9.225108606055958e-06,  -7.394488907590428e-08,   5.122202460124649e-10,  -2.812589224455295e-13,  -1.185312370258772e-13,   3.547884840944988e-15,
  -5.517371287403883e-17,  -8.066267914321851e-20,   1.376630545505703e-01,  -1.128167981350604e-03,   9.225544512990689e-06,  -7.394519990606589e-08,   5.119646749712033e-10,
  -2.706665104881809e-13,  -1.187466949762232e-13,   3.547267366486175e-15,  -5.496279873501820e-17,  -8.827665913554061e-20,   1.376652112091276e-01,  -1.128219808335531e-03,
   9.226259966260178e-06,  -7.394569929351044e-08,   5.115447836537302e-10,  -2.532788180800121e-13,  -1.190997935192730e-13,   3.546225546637417e-15,  -5.461600369353424e-17,
  -1.007685863323082e-19,   1.376674996512505e-01,  -1.128274800874560e-03,   9.227018901936196e-06,  -7.394621438184092e-08,   5.110987984078752e-10,  -2.348311584117179e-13,
  -1.194736277153977e-13,   3.545081872482318e-15,  -5.424728844488728e-17,  -1.140129951419417e-19,   1.376693007111772e-01,  -1.128318080364510e-03,   9.227616032158516e-06,
  -7.394660904389661e-08,   5.107474816423891e-10,  -2.203142462401014e-13,  -1.197672351086533e-13,   3.544154133130725e-15,  -5.395657440088219e-17,  -1.244287477125907e-19,
   1.376703401556952e-01,  -1.128343057833161e-03,   9.227960585067953e-06,  -7.394683251614702e-08,   5.105446001128339e-10,  -2.119368594077266e-13,  -1.199364401112272e-13,
   3.543607632557438e-15,  -5.378858449340721e-17,  -1.304367857329758e-19,   1.376707304807771e-01,  -1.128352437126381e-03,   9.228089956272705e-06,  -7.394691562043844e-08,
   5.104683915721073e-10,  -2.087911831126264e-13,  -1.199999325876548e-13,   3.543400321653526e-15,  -5.372546239545529e-17,  -1.326922757235485e-19,   1.376707951829221e-01,
  -1.128353991878768e-03,   9.228111400777043e-06,  -7.394692935334095e-08,   5.104557576230838e-10,  -2.082697483723094e-13,  -1.200104549637341e-13,   3.543365846421506e-15,
  -5.371499688427396e-17,  -1.330661243854236e-19,   2.088649183123911e-01,  -1.711635663873645e-03,   1.399526382654406e-05,  -1.120728260895892e-07,   7.698105242397086e-10,
  -8.479474764659432e-14,  -1.920159519729204e-13,   5.708484589253913e-15,  -8.961140439675737e-17,  -8.592601859487418e-20,   2.088669112582921e-01,  -1.711683510122359e-03,
   1.399591877682681e-05,  -1.120728028465824e-07,   7.693964957404489e-10,  -6.774812923464133e-14,  -1.923660947858732e-13,   5.707717023570863e-15,  -8.927862851194336e-17,
  -9.812918099266514e-20,   2.088701830686176e-01,  -1.711762057444608e-03,   1.399699372691606e-05,  -1.120727471614376e-07,   7.687162644073997e-10,  -3.976521638785662e-14,
  -1.929399473519416e-13,   5.706411838105121e-15,  -8.873142556473539e-17,  -1.181514932187709e-19,   2.088736548034239e-01,  -1.711845402169342e-03,   1.399813398285517e-05,
  -1.120726642542841e-07,   7.679937579949714e-10,  -1.007577810679346e-14,  -1.935475383501113e-13,   5.704965660967302e-15,  -8.814958477972264e-17,  -1.393814095765060e-19,
   2.088763871429682e-01,  -1.711910994863643e-03,   1.399903111730950e-05,  -1.120725817598152e-07,   7.674246149169825e-10,   1.328804503865404e-14,  -1.940247654065733e-13,
   5.703783165905746e-15,  -8.769079530190437e-17,  -1.560782703682812e-19,   2.088779640560046e-01,  -1.711948849672548e-03,   1.399954876969992e-05,  -1.120725272378506e-07,
   7.670959403879281e-10,   2.677098048371420e-14,  -1.942998012016951e-13,   5.703082954872093e-15,  -8.742566801565011e-17,  -1.657098302029947e-19,   2.088785562075306e-01,
  -1.711963064526299e-03,   1.399974313414009e-05,  -1.120725054577564e-07,   7.669724799913275e-10,   3.183380703402975e-14,  -1.944030077703166e-13,   5.702816660676195e-15,
  -8.732604386860861e-17,  -1.693257169524844e-19,   2.088786543653857e-01,  -1.711965420841594e-03,   1.399977535181617e-05,  -1.120725017784683e-07,   7.669520125621456e-10,
   3.267303506111924e-14,  -1.944201119313028e-13,   5.702772341470383e-15,  -8.730952624981676e-17,  -1.699250564739296e-19,   2.975740473289734e-01,  -2.438582351477028e-03,
   1.993665775514869e-05,  -1.594402998622091e-07,   1.082351097687934e-09,   5.533605630649106e-13,  -2.977320509416392e-13,   8.785123901978457e-15,  -1.397091763261524e-16,
  -4.005912120258058e-20,   2.975768863129044e-01,  -2.438650416446127e-03,   1.993757827345294e-05,  -1.594392908435042e-07,   1.081709081210955e-09,   5.796022021016186e-13,
  -2.982783659672173e-13,   8.784417407434009e-15,  -1.392107606078849e-16,  -5.874285056212705e-20,   2.975815470587296e-01,  -2.438762155748737e-03,   1.993908905500368e-05,
  -1.594376073901210e-07,   1.080654269879068e-09,   6.226802485931284e-13,  -2.991737869151235e-13,   8.783188510405563e-15,  -1.383911068294441e-16,  -8.940051624378246e-20,
   2.975864925983465e-01,  -2.438880719291753e-03,   1.994069156949878e-05,  -1.594357844409930e-07,   1.079533896682542e-09,   6.683867880216872e-13,  -3.001219335588728e-13,
   8.781790711806851e-15,  -1.375194612356173e-16,  -1.219104659450555e-19,   2.975903848567309e-01,  -2.438974029062599e-03,   1.994195236454927e-05,  -1.594343232176710e-07,
   1.078651334942667e-09,   7.043561299512572e-13,  -3.008667060702087e-13,   8.780622715736355e-15,  -1.368320787162504e-16,  -1.474811632294791e-19,   2.975926311923164e-01,
  -2.439027879810285e-03,   1.994267983670979e-05,  -1.594334692737590e-07,   1.078141662064980e-09,   7.251139398223326e-13,  -3.012959575123444e-13,   8.779921424241500e-15,
  -1.364348198862601e-16,  -1.622325204689172e-19,   2.975934747206891e-01,  -2.439048101273852e-03,   1.994295297999671e-05,  -1.594331465976596e-07,   1.077950212639373e-09,
   7.329085499808256e-13,  -3.014570376399789e-13,   8.779652938767816e-15,  -1.362855401439499e-16,  -1.677706623088394e-19,   2.975936145479615e-01,  -2.439051453269421e-03,
   1.994299825583693e-05,  -1.594330930033538e-07,   1.077918473876737e-09,   7.342006100065715e-13,  -3.014837332746221e-13,   8.779608162136236e-15,  -1.362607893493797e-16,
  -1.686886283089441e-19,   4.062697603167770e-01,  -3.329293776462481e-03,   2.721392645803447e-05,  -2.172393720817537e-07,   1.450221078374074e-09,   2.049774149578268e-12,
  -4.532887232135615e-13,   1.327380449720365e-14,  -2.149533548906441e-16,   1.324825920904264e-19,   4.062736355372980e-01,  -3.329386509182987e-03,   2.721515917702566e-05,
  -2.172361202108921e-07,   1.449243510290233e-09,   2.089439614250992e-12,  -4.541301477678323e-13,   1.327373102326704e-14,  -2.142287995199529e-16,   1.044511299583224e-19,
   4.062799974650487e-01,  -3.329538743874363e-03,   2.721718227835280e-05,  -2.172307409414494e-07,   1.447637383877184e-09,   2.154556247637991e-12,  -4.555093828098300e-13,
   1.327350673607255e-14,  -2.130370838647802e-16,   5.844992319614027e-20,   4.062867481334626e-01,  -3.329700275177465e-03,   2.721932812064420e-05,  -2.172249776745103e-07,
   1.445931407914190e-09,   2.223649027275493e-12,  -4.569700008128629e-13,   1.327312789237581e-14,  -2.117695438557326e-16,   9.662498793320178e-21,   4.062920610690336e-01,
  -3.329827400091964e-03,   2.722101631244619e-05,  -2.172204018089138e-07,   1.444587528985766e-09,   2.278024586622886e-12,  -4.581174435657266e-13,   1.327272778396897e-14,
  -2.107697900244876e-16,  -2.871624250703725e-20,   4.062951273177628e-01,  -3.329900765935357e-03,   2.722199036138412e-05,  -2.172177448957562e-07,   1.443811442810793e-09,
   2.309405424232372e-12,  -4.587788240323151e-13,   1.327245601383966e-14,  -2.101919354184202e-16,  -5.085837468314867e-20,   4.062962787340477e-01,  -3.329928315457492e-03,
   2.722235608115296e-05,  -2.172167441569755e-07,   1.443519918892220e-09,   2.321189168794655e-12,  -4.590270217638860e-13,   1.327234623966708e-14,  -2.099747797229950e-16,
  -5.917163385193179e-20,   4.062964695982738e-01,  -3.329932882180814e-03,   2.722241670204974e-05,  -2.172165781097476e-07,   1.443471589575129e-09,   2.323142489234748e-12,
  -4.590681557943611e-13,   1.327232763569568e-14,  -2.099387743308008e-16,  -6.054960504758284e-20,   5.387941385912635e-01,  -4.415234062314914e-03,   3.608148804352327e-05,
  -2.872632824318467e-07,   1.870473236328132e-09,   5.229169833810390e-12,  -6.930854391061895e-13,   2.016361599518657e-14,  -3.351683819507351e-16,   6.236807265246351e-19,
   5.387992764465835e-01,  -4.415356673151351e-03,   3.608307665761525e-05,  -2.872553318951067e-07,   1.868978192769421e-09,   5.289458581905067e-12,  -6.943993361402797e-13,
   2.016568029293618e-14,  -3.341301040776956e-16,   5.815484987650536e-19,   5.388077112299001e-01,  -4.415557956116299e-03,   3.608568369723121e-05,  -2.872422177788474e-07,
   1.866521821127458e-09,   5.388436044619345e-12,  -6.965532999296152e-13,   2.016891326968515e-14,  -3.324220042214559e-16,   5.123957568880044e-19,   5.388166614074615e-01,
  -4.415771529401126e-03,   3.608844870650937e-05,  -2.872282183907807e-07,   1.863912684034468e-09,   5.493463661143654e-12,  -6.988347243478141e-13,   2.017213185430383e-14,
  -3.306046983935536e-16,   4.390390737689492e-19,   5.388237054038892e-01,  -4.415939610158053e-03,   3.609062386963097e-05,  -2.872171397638929e-07,   1.861857299827434e-09,
   5.576124334531616e-12,  -7.006272461104108e-13,   2.017451153399474e-14,  -3.291709447048534e-16,   3.813216642187828e-19,   5.388277706959543e-01,  -4.416036611828540e-03,
   3.609187883236680e-05,  -2.872107216054046e-07,   1.860670304549220e-09,   5.623830735537889e-12,  -7.016605529905340e-13,   2.017582342627916e-14,  -3.283420875086615e-16,
   3.480178392183534e-19,   5.388292972656420e-01,  -4.416073036727071e-03,   3.609235001407226e-05,  -2.872083068986356e-07,   1.860224426238960e-09,   5.641745205421351e-12,
  -7.020483444342240e-13,   2.017630443788668e-14,  -3.280305772442863e-16,   3.355130756802068e-19,   5.388295503170566e-01,  -4.416079074665175e-03,   3.609242811552894e-05,
  -2.872079063824641e-07,   1.860150507627199e-09,   5.644714797851702e-12,  -7.021126145129869e-13,   2.017638355962189e-14,  -3.279789259270798e-16,   3.334402933968630e-19,
   7.015762831358167e-01,  -5.749043424177733e-03,   4.696360800399291e-05,  -3.723756710487374e-07,   2.328871228741275e-09,   1.195505508500565e-11,  -1.094420467142503e-12,
   3.174472359966748e-14,  -5.491566038147320e-16,   2.013882901168074e-18,   7.015829703738707e-01,  -5.749202336459467e-03,   4.696558310294083e-05,  -3.723578559141683e-07,
   2.326509485710473e-09,   1.205005615507153e-11,  -1.096577797817846e-12,   3.175329334476342e-14,  -5.476761787470743e-16,   1.948803532850230e-18,   7.015939487587365e-01,
  -5.749463211011013e-03,   4.696882408195995e-05,  -3.723285117172128e-07,   2.322628990215235e-09,   1.220603316358850e-11,  -1.100115106588515e-12,   3.176712093909344e-14,
  -5.452396972715780e-16,   1.841958447431313e-18,   7.016055979471681e-01,  -5.749740011341112e-03,   4.697226101826621e-05,  -3.722972423684193e-07,   2.318506986816397e-09,
   1.237156015615804e-11,  -1.103862612679820e-12,   3.178146549542149e-14,  -5.426460942866416e-16,   1.728579160913013e-18,   7.016147661177117e-01,  -5.749957849044794e-03,
   4.697496446139307e-05,  -3.722725370047063e-07,   2.315259694849713e-09,   1.250184743720361e-11,  -1.106807675158988e-12,   3.179251754468582e-14,  -5.405989121248425e-16,
   1.639343624313010e-18,   7.016200573275723e-01,  -5.750083565190001e-03,   4.697652409224784e-05,  -3.722582404832976e-07,   2.313384315887768e-09,   1.257704538225823e-11,
  -1.108505624408460e-12,   3.179880081781790e-14,  -5.394150409688101e-16,   1.587842078468311e-18,   7.016220442444879e-01,  -5.750130772426235e-03,   4.697710963966400e-05,
  -3.722528647063772e-07,   2.312679846220417e-09,   1.260528419846685e-11,  -1.109142898885783e-12,   3.180114227787000e-14,  -5.389700319939206e-16,   1.568502387872812e-18,
   7.016223736051982e-01,  -5.750138597678848e-03,   4.697720669675330e-05,  -3.722519732097669e-07,   2.312563057303060e-09,   1.260996525166250e-11,  -1.109248519239579e-12,
   3.180152946030634e-14,  -5.388962414696434e-16,   1.565296539580430e-18,   9.069764853996031e-01,  -7.431894707806557e-03,   6.067131692211594e-05,  -4.776360642130033e-07,
   2.766896727623408e-09,   2.748400315397814e-11,  -1.877130251304430e-12,   5.484009521004135e-14,  -1.015261382103945e-15,   6.666877541693256e-18,   9.069851240779662e-01,
  -7.432098477809092e-03,   6.067365642517938e-05,  -4.775955641413022e-07,   2.762842304540434e-09,   2.764838421487930e-11,  -1.881132670249219e-12,   5.487136946800164e-14,
  -1.013200609950250e-15,   6.559687504890072e-18,   9.069993061039524e-01,  -7.432432986433816e-03,   6.067749458095861e-05,  -4.775289074359942e-07,   2.756180160533057e-09,
   2.791830801215661e-11,  -1.887697286006131e-12,   5.492231354627625e-14,  -1.009805698947769e-15,   6.383615554025460e-18,   9.070143546521375e-01,  -7.432787908497196e-03,
   6.068156373782597e-05,  -4.774579494128832e-07,   2.749102754363374e-09,   2.820480681947312e-11,  -1.894654673884549e-12,   5.497582846998837e-14,  -1.006187390895941e-15,
   6.196652065917893e-18,   9.070261981720465e-01,  -7.433067221376118e-03,   6.068476370564272e-05,  -4.774019384432962e-07,   2.743526752218560e-09,   2.843034680666364e-11,
  -1.900124239839275e-12,   5.501755337009221e-14,  -1.003328161554825e-15,   6.049412258193712e-18,   9.070330333925061e-01,  -7.433228413222199e-03,   6.068660947499059e-05,
  -4.773695466135261e-07,   2.740306310015768e-09,   2.856053584387447e-11,  -1.903278449504752e-12,   5.504147659096603e-14,  -1.001673398796024e-15,   5.964398114966287e-18,
   9.070356001034308e-01,  -7.433288941402574e-03,   6.068730239167111e-05,  -4.773573705315850e-07,   2.739096544257385e-09,   2.860942792721247e-11,  -1.904462435463229e-12,
   5.505043031092837e-14,  -1.001051141457692e-15,   5.932467095193807e-18,   9.070360255734381e-01,  -7.433298974764154e-03,   6.068741724260639e-05,  -4.773553515055195e-07,
   2.738895984125418e-09,   2.861753274300103e-11,  -1.904658674269743e-12,   5.505191295188325e-14,  -1.000947947121295e-15,   5.927173684128231e-18,   1.186670749081827e+00,
  -9.722913945000045e-03,   7.925931464034033e-05,  -6.136311355208171e-07,   2.860010585789370e-09,   7.523322248192435e-11,  -4.059227051990627e-12,   1.238713569045057e-13,
  -2.652871193973461e-15,   3.294930768664305e-17,   1.186682033074162e+00,  -9.723175527656190e-03,   7.926170677822743e-05,  -6.135209232757441e-07,   2.851220575428335e-09,
   7.560601239733072e-11,  -4.069765953715722e-12,   1.240350795810799e-13,  -2.651369965758545e-15,   3.276080582777717e-17,   1.186700557812357e+00,  -9.723604923185674e-03,
   7.926562839532100e-05,  -6.133396075099742e-07,   2.836774107571117e-09,   7.621835771429234e-11,  -4.087062771490581e-12,   1.243031536626746e-13,  -2.648875509422964e-15,
   3.245066071215932e-17,   1.186720214315319e+00,  -9.724060497757522e-03,   7.926978210207167e-05,  -6.131466946635207e-07,   2.821423216467964e-09,   7.686857872699266e-11,
  -4.105409875495114e-12,   1.245866438923300e-13,  -2.646187990211003e-15,   3.212063807860865e-17,   1.186735684320796e+00,  -9.724419003062141e-03,   7.927304570575164e-05,
  -6.129944925591039e-07,   2.809326006696046e-09,   7.738064955639256e-11,  -4.119844648051319e-12,   1.248090581377402e-13,  -2.644043418885295e-15,   3.186023293088096e-17,
   1.186744612457325e+00,  -9.724625889726812e-03,   7.927492703510911e-05,  -6.129065019036151e-07,   2.802338066699211e-09,   7.767631311041869e-11,  -4.128173423595475e-12,
   1.249371391760879e-13,  -2.642793926117360e-15,   3.170967759150964e-17,   1.186747965079104e+00,  -9.724703575124428e-03,   7.927563308453109e-05,  -6.128734318311997e-07,
   2.799712815501000e-09,   7.778736367150631e-11,  -4.131300617315175e-12,   1.249851821837637e-13,  -2.642322495079586e-15,   3.165309149420205e-17,   1.186748520825087e+00,
  -9.724716452453727e-03,   7.927575010077681e-05,  -6.128679484788056e-07,   2.799277578694924e-09,   7.780577326025000e-11,  -4.131818976236245e-12,   1.249931432189760e-13,
  -2.642244230774228e-15,   3.164370884552885e-17,   1.598890290639511e-03,  -1.268819695252688e-05,   1.006043638680083e-07,  -7.913027054283840e-10,   5.857518371002682e-12,
  -2.740370693846211e-14,  -4.434984956997549e-16,   2.073850880962028e-17,  -4.706080880097740e-19,   5.719795212403516e-21,   1.598904617426098e-03,  -1.268853491289736e-05,
   1.006093597747525e-07,  -7.913411754210847e-10,   5.856549484531613e-12,  -2.734127853743429e-14,  -4.453673174866277e-16,   2.076692575250030e-17,  -4.703058368866171e-19,
   5.686880882599742e-21,   1.598928137678639e-03,  -1.268908974130526e-05,   1.006175607594679e-07,  -7.914042657422145e-10,   5.854956020644817e-12,  -2.723873140862245e-14,
  -4.484343932402389e-16,   2.081345423479125e-17,  -4.698048940345850e-19,   5.632760201898212e-21,   1.598953095182653e-03,  -1.268967847310736e-05,   1.006262618152444e-07,
  -7.914711218928341e-10,   5.853261318986385e-12,  -2.712983848533711e-14,  -4.516875701668482e-16,   2.086265784931701e-17,  -4.692669030131263e-19,   5.575216770516056e-21,
   1.598972737374996e-03,  -1.269014181969106e-05,   1.006331089953424e-07,  -7.915236746147745e-10,   5.851924747131804e-12,  -2.704407956904999e-14,  -4.542469428678586e-16,
   2.090126051921710e-17,  -4.688388314354202e-19,   5.529845186183939e-21,   1.598984073470929e-03,  -1.269040923069675e-05,   1.006370603975035e-07,  -7.915539783875851e-10,
   5.851152250075537e-12,  -2.699456256319208e-14,  -4.557236463464851e-16,   2.092349039390655e-17,  -4.685899115831629e-19,   5.503626530604904e-21,   1.598988330325977e-03,
  -1.269050964706363e-05,   1.006385441430346e-07,  -7.915653529479037e-10,   5.850861955189130e-12,  -2.697596393012517e-14,  -4.562780948074343e-16,   2.093182876414581e-17,
  -4.684960860564241e-19,   5.493774781231757e-21,   1.598989035962653e-03,  -1.269052629255994e-05,   1.006387900927054e-07,  -7.915672381904358e-10,   5.850813823338073e-12,
  -2.697288070292977e-14,  -4.563699989631299e-16,   2.093321048454312e-17,  -4.684805144774360e-19,   5.492141376248417e-21,   1.442968732774482e-02,  -1.145085790084908e-04,
   9.079303664449397e-07,  -7.140883622864593e-09,   5.283212686457404e-11,  -2.457857119054997e-13,  -4.061554649703189e-15,   1.889490009483224e-16,  -4.288112641622046e-18,
   5.223843086402043e-20,   1.442981662351952e-02,  -1.145116288268609e-04,   9.079754264751454e-07,  -7.141228587866900e-09,   5.282325482694442e-11,  -2.452169147583469e-13,
  -4.078583762426810e-15,   1.892085714041054e-16,  -4.285391301677402e-18,   5.193934702295200e-20,   1.443002888809219e-02,  -1.145166357027724e-04,   9.080493942699266e-07,
  -7.141794317001235e-09,   5.280866369831649e-11,  -2.442825867443398e-13,  -4.106531722009808e-15,   1.896335848971946e-16,  -4.280880536917523e-18,   5.144756198116554e-20,
   1.443025412350676e-02,  -1.145219485283539e-04,   9.081278722826947e-07,  -7.142393801588016e-09,   5.279314572352769e-11,  -2.432904389360438e-13,  -4.136175610738857e-15,
   1.900830422337549e-16,  -4.276035511102224e-18,   5.092466865894338e-20,   1.443043138952112e-02,  -1.145261298536612e-04,   9.081896294291628e-07,  -7.142865021271073e-09,
   5.278090718276000e-11,  -2.425090688296704e-13,  -4.159497448105555e-15,   1.904356694901101e-16,  -4.272179923500087e-18,   5.051237550776383e-20,   1.443053369503197e-02,
  -1.145285430197852e-04,   9.082252684942979e-07,  -7.143136739658391e-09,   5.277383373622143e-11,  -2.420579069151141e-13,  -4.172953688445765e-15,   1.906387370192988e-16,
  -4.269937746287015e-18,   5.027412384292502e-20,   1.443057211211405e-02,  -1.145294491955069e-04,   9.082386509031174e-07,  -7.143238728810294e-09,   5.277117563154669e-11,
  -2.418884499764750e-13,  -4.178006024482480e-15,   1.907149075772233e-16,  -4.269092565847410e-18,   5.018459961924726e-20,   1.443057848031352e-02,  -1.145295994075173e-04,
   9.082408692070571e-07,  -7.143255632660955e-09,   5.277073490951110e-11,  -2.418603578932972e-13,  -4.178843488949521e-15,   1.907275295408684e-16,  -4.268952295204404e-18,
   5.016975662154468e-20,   4.030696632465786e-02,  -3.198607317521077e-04,   2.536124218097026e-06,  -1.994414999848470e-08,   1.474001173558755e-10,  -6.777621792270936e-13,
  -1.168587493556668e-14,   5.381219201469802e-16,  -1.221518755748866e-17,   1.495145463042454e-19,   4.030732748656581e-02,  -3.198692497057168e-04,   2.536249929929896e-06,
  -1.994510081555502e-08,   1.473745965200793e-10,  -6.761421966142140e-13,  -1.173438832722991e-14,   5.388650900258490e-16,  -1.220762733410033e-17,   1.486674158840478e-19,
   4.030792040521368e-02,  -3.198832335957306e-04,   2.536456290321977e-06,  -1.994666006452565e-08,   1.473326251732834e-10,  -6.734811425424758e-13,  -1.181400843345219e-14,
   5.400819697814864e-16,  -1.219509296139445e-17,   1.472744476337131e-19,   4.030854955529277e-02,  -3.198980719785654e-04,   2.536675232976696e-06,  -1.994831227609547e-08,
   1.472879887382183e-10,  -6.706554007105573e-13,  -1.189846077651733e-14,   5.413688822885504e-16,  -1.218162584609011e-17,   1.457933286589560e-19,   4.030904471243086e-02,
  -3.199097501494259e-04,   2.536847526286749e-06,  -1.994961092951948e-08,   1.472527860888876e-10,  -6.684299676835710e-13,  -1.196490280255639e-14,   5.423785788275891e-16,
  -1.217090615291367e-17,   1.446254626801189e-19,   4.030933048239634e-02,  -3.199164899645993e-04,   2.536946953821321e-06,  -1.995035974787069e-08,   1.472324404780025e-10,
  -6.671450026703082e-13,  -1.200323876101217e-14,   5.429600464757876e-16,  -1.216467111719043e-17,   1.439505776700859e-19,   4.030943779282371e-02,  -3.199190208538331e-04,
   2.536984288656997e-06,  -1.995064081184585e-08,   1.472247949285857e-10,  -6.666623676852045e-13,  -1.201763258111481e-14,   5.431781573404080e-16,  -1.216232063545784e-17,
   1.436969843003556e-19,   4.030945558111389e-02,  -3.199194403860903e-04,   2.536990477377497e-06,  -1.995068739564040e-08,   1.472235272754942e-10,  -6.665823578140644e-13,
  -1.202001847228559e-14,   5.432142998837149e-16,  -1.216193052607129e-17,   1.436549387480230e-19,   7.968270415257882e-02,  -6.323309227330080e-04,   5.013560551324388e-06,
  -3.941898937929720e-08,   2.908400881692672e-10,  -1.312366703182148e-12,  -2.416800927198232e-14,   1.096209577060392e-15,  -2.489483518424904e-17,   3.069899246108203e-19,
   7.968341811785792e-02,  -6.323477580622981e-04,   5.013808583876107e-06,  -3.942082908713494e-08,   2.907873247207711e-10,  -1.309066427649809e-12,  -2.426689347423070e-14,
   1.097736249863100e-15,  -2.488004299333956e-17,   3.052790003297583e-19,   7.968459023291198e-02,  -6.323753965419558e-04,   5.014215736527993e-06,  -3.942384586072323e-08,
   2.907005525823714e-10,  -1.303645223551074e-12,  -2.442918386172632e-14,   1.100236159887570e-15,  -2.485550892248913e-17,   3.024655747174628e-19,   7.968583397223428e-02,
  -6.324047238683226e-04,   5.014647712163801e-06,  -3.942704226173546e-08,   2.906082735521181e-10,  -1.297888473489904e-12,  -2.460132626476753e-14,   1.102880090213005e-15,
  -2.482913629547918e-17,   2.994739875385494e-19,   7.968681282671075e-02,  -6.324278051805274e-04,   5.014987646785516e-06,  -3.942955449321835e-08,   2.905354995649659e-10,
  -1.293354676902497e-12,  -2.473675931355693e-14,   1.104954594425431e-15,  -2.480813474344391e-17,   2.971150265097892e-19,   7.968737775282876e-02,  -6.324411260783638e-04,
   5.015183816672597e-06,  -3.943100300664586e-08,   2.904934401942804e-10,  -1.290736851860204e-12,  -2.481490266394411e-14,   1.106149310466755e-15,  -2.479591568968991e-17,
   2.957517980275873e-19,   7.968758989010480e-02,  -6.324461282497587e-04,   5.015257477951436e-06,  -3.943154668366336e-08,   2.904776351278523e-10,  -1.289753590376638e-12,
  -2.484424290944118e-14,   1.106597461454127e-15,  -2.479130867100193e-17,   2.952395475801934e-19,   7.968762505499509e-02,  -6.324469574334719e-04,   5.015269688232724e-06,
  -3.943163679250066e-08,   2.904750146128899e-10,  -1.289590587942825e-12,  -2.484910629756982e-14,   1.106671723736423e-15,  -2.479054400830633e-17,   2.951546165701373e-19,
   1.332913722043306e-01,  -1.057746851983081e-03,   8.386340493042535e-06,  -6.591870708984764e-08,   4.851779667068815e-10,  -2.129091314843279e-12,  -4.300164945146180e-14,
   1.912206829812263e-15,  -4.346251947048076e-17,   5.416646016887173e-19,   1.332925664741891e-01,  -1.057775004654556e-03,   8.386754226658597e-06,  -6.592168829383061e-08,
   4.850841246039946e-10,  -2.123333856296247e-12,  -4.317431789383179e-14,   1.914902446082665e-15,  -4.343823401807985e-17,   5.387164729692383e-19,   1.332945271039733e-01,
  -1.057821222730946e-03,   8.387433378803030e-06,  -6.592657648302131e-08,   4.849298014741839e-10,  -2.113876285328573e-12,  -4.345770865054141e-14,   1.919316757693749e-15,
  -4.339792971880431e-17,   5.338683776252616e-19,   1.332966075415145e-01,  -1.057870264917941e-03,   8.388153932063138e-06,  -6.593175515385908e-08,   4.847656910738082e-10,
  -2.103833241354449e-12,  -4.375830901088345e-14,   1.923985745720076e-15,  -4.335457159694089e-17,   5.287129702194366e-19,   1.332982448986451e-01,  -1.057908862270854e-03,
   8.388720953522266e-06,  -6.593582494545254e-08,   4.846362735436201e-10,  -2.095923653933413e-12,  -4.399481075641996e-14,   1.927649435378630e-15,  -4.332001991093846e-17,
   5.246475487900838e-19,   1.332991898662390e-01,  -1.057931137916090e-03,   8.389048169524635e-06,  -6.593817135612922e-08,   4.845614792370488e-10,  -2.091356611322869e-12,
  -4.413127137183454e-14,   1.929759477438019e-15,  -4.329990768440170e-17,   5.222980798011401e-19,   1.332995447141380e-01,  -1.057939502710041e-03,   8.389171038005289e-06,
  -6.593905201322177e-08,   4.845333734022994e-10,  -2.089641213694434e-12,  -4.418250815588188e-14,   1.930550997473181e-15,  -4.329232288099518e-17,   5.214152203269560e-19,
   1.332996035354237e-01,  -1.057940889297939e-03,   8.389191404983430e-06,  -6.593919797134405e-08,   4.845287134118743e-10,  -2.089356839429711e-12,  -4.419100109376947e-14,
   1.930682159885706e-15,  -4.329106387884041e-17,   5.212688415471693e-19,   2.022340760325138e-01,  -1.604845169742940e-03,   1.272355929058630e-05,  -9.997122194801244e-08,
   7.333321274982261e-10,  -3.090995249141652e-12,  -7.068107688779468e-14,   3.067918158363443e-15,  -6.983471347552541e-17,   8.830232112060877e-19,   2.022358879458700e-01,
  -1.604887864909769e-03,   1.272418456672229e-05,  -9.997554259787637e-08,   7.331779555563672e-10,  -3.081756879408759e-12,  -7.095858792945981e-14,   3.072316727455731e-15,
  -6.979910215828605e-17,   8.783724487250519e-19,   2.022388625591501e-01,  -1.604957957252995e-03,   1.272521096253183e-05,  -9.998262611269312e-08,   7.329244296021949e-10,
  -3.066581180785047e-12,  -7.141406066406275e-14,   3.079520367379454e-15,  -6.973994283936763e-17,   8.707239291051492e-19,   2.022420189410906e-01,  -1.605032332435131e-03,
   1.272629991697950e-05,  -9.999012931040231e-08,   7.326548376982509e-10,  -3.050465810204394e-12,  -7.189720652188508e-14,   3.087140415145745e-15,  -6.967622235239843e-17,
   8.625899019050491e-19,   2.022445030935056e-01,  -1.605090867388150e-03,   1.272715683501149e-05,  -9.999602497961062e-08,   7.324422466684426e-10,  -3.037773690943568e-12,
  -7.227733833741488e-14,   3.093120345297365e-15,  -6.962538785736766e-17,   8.561751249343702e-19,   2.022459367717898e-01,  -1.605124649572384e-03,   1.272765134111011e-05,
  -9.999942372152873e-08,   7.323193875806536e-10,  -3.030445123046119e-12,  -7.249667686044914e-14,   3.096564623358838e-15,  -6.959577528941963e-17,   8.524677303758296e-19,
   2.022464751370330e-01,  -1.605137335216393e-03,   1.272783702587038e-05,  -1.000006992713048e-07,   7.322732208982359e-10,  -3.027692474660554e-12,  -7.257903249913479e-14,
   3.097856687219623e-15,  -6.958460350641752e-17,   8.510745662592821e-19,   2.022465643790309e-01,  -1.605139438048631e-03,   1.272786780539746e-05,  -1.000009106743935e-07,
   7.322655664284191e-10,  -3.027236146968742e-12,  -7.259268369387878e-14,   3.098070796866368e-15,  -6.958274888201307e-17,   8.508435766142341e-19,   2.881270010016054e-01,
  -2.286449126834606e-03,   1.812659440648155e-05,  -1.423476900407007e-07,   1.039332185839108e-09,  -4.130523394973955e-12,  -1.114209792039891e-13,   4.701756949725237e-15,
  -1.073023596970316e-16,   1.383516390661514e-18,   2.881295823309487e-01,  -2.286509918520665e-03,   1.812748045531985e-05,  -1.423534484183961e-07,   1.039089280063503e-09,
  -4.116362520502702e-12,  -1.118475289348730e-13,   4.708657262559048e-15,  -1.072548054081932e-16,   1.376552139117847e-18,   2.881338200918745e-01,  -2.286609719663748e-03,
   1.812893489641234e-05,  -1.423628871164960e-07,   1.038689853349835e-09,  -4.093100370408657e-12,  -1.125476362937474e-13,   4.719959294380137e-15,  -1.071756712733567e-16,
   1.365097845669338e-18,   2.881383168074919e-01,  -2.286715618768839e-03,   1.813047796473871e-05,  -1.423728824390233e-07,   1.038265137162486e-09,  -4.068397370909471e-12,
  -1.132903082001916e-13,   4.731916314341025e-15,  -1.070902551692878e-16,   1.352915009718818e-18,   2.881418558359061e-01,  -2.286798963641530e-03,   1.813169221823611e-05,
  -1.423807344205672e-07,   1.037930236416778e-09,  -4.048941480485397e-12,  -1.138746515794248e-13,   4.741300953106330e-15,  -1.070219835402729e-16,   1.343306149847826e-18,
   2.881438983143197e-01,  -2.286847064286357e-03,   1.813239292773551e-05,  -1.423852601823621e-07,   1.037736699380619e-09,  -4.037707301344733e-12,  -1.142118296870213e-13,
   4.746706739264158e-15,  -1.069821623322263e-16,   1.337752327135688e-18,   2.881446652920617e-01,  -2.286865126686957e-03,   1.813265603978458e-05,  -1.423869585600184e-07,
   1.037663975298714e-09,  -4.033487659239442e-12,  -1.143384324269025e-13,   4.748734722809650e-15,  -1.069671296354546e-16,   1.335665233108601e-18,   2.881447924299589e-01,
  -2.286868120795262e-03,   1.813269965377466e-05,  -1.423872400328690e-07,   1.037651917656291e-09,  -4.032788135359157e-12,  -1.143594180620375e-13,   4.749070787580892e-15,
  -1.069646335602946e-16,   1.335319184184337e-18,   3.933720546955961e-01,  -3.121615547595490e-03,   2.474602561108421e-05,  -1.941862770687584e-07,   1.408622454098653e-09,
  -5.118404190002298e-12,  -1.726985552249850e-13,   7.060258154487132e-15,  -1.618435073311554e-16,   2.142736391233512e-18,   3.933755786511846e-01,  -3.121698475059249e-03,
   2.474722621921882e-05,  -1.941933811976187e-07,   1.408246165721210e-09,  -5.097134418837373e-12,  -1.733422286093919e-13,   7.070962922302419e-15,  -1.617867550410594e-16,
   2.132614803505193e-18,   3.933813639179276e-01,  -3.121834616066162e-03,   2.474919697718372e-05,  -1.942050218269121e-07,   1.407627434994376e-09,  -5.062193701967647e-12,
  -1.743987500671795e-13,   7.088498801382783e-15,  -1.616919918562769e-16,   2.115965267896961e-18,   3.933875027006938e-01,  -3.121979075121032e-03,   2.475128778453669e-05,
  -1.942173435922208e-07,   1.406969565186656e-09,  -5.025087761164258e-12,  -1.755195639258671e-13,   7.107054379062369e-15,  -1.615892730495293e-16,   2.098253647458937e-18,
   3.933923340763464e-01,  -3.122092767270923e-03,   2.475293302956435e-05,  -1.942270192696606e-07,   1.406450841822887e-09,  -4.995862680027294e-12,  -1.764014766999165e-13,
   7.121620487892024e-15,  -1.615068634292416e-16,   2.084281876138358e-18,   3.933951224063537e-01,  -3.122158382080500e-03,   2.475388243981991e-05,  -1.942325946239723e-07,
   1.406151085088856e-09,  -4.978987302430463e-12,  -1.769103755583872e-13,   7.130011933801224e-15,  -1.614586741840669e-16,   2.076205437838501e-18,   3.933961694611922e-01,
  -3.122183021253884e-03,   2.475423893525711e-05,  -1.942346865861533e-07,   1.406038449492302e-09,  -4.972648728397862e-12,  -1.771014587847818e-13,   7.133160179238911e-15,
  -1.614404597531129e-16,   2.073170190237315e-18,   3.933963430260040e-01,  -3.122187105557986e-03,   2.475429802855228e-05,  -1.942350332723648e-07,   1.406019774628213e-09,
  -4.971597929272011e-12,  -1.771331328582272e-13,   7.133681896851864e-15,  -1.614374341786062e-16,   2.072666924550101e-18,   5.216893965445490e-01,  -4.139859083830048e-03,
   3.281489103364245e-05,  -2.572320641070113e-07,   1.848396737914366e-09,  -5.787805061902201e-12,  -2.689411467759387e-13,   1.062306224104678e-14,  -2.453973297292617e-16,
   3.370865444963773e-18,   5.216940695116697e-01,  -4.139968929956249e-03,   3.281646595206524e-05,  -2.572400300266615e-07,   1.847811053628737e-09,  -5.755789596043102e-12,
  -2.699178030087380e-13,   1.063994069820795e-14,  -2.453439242043648e-16,   3.356364010443688e-18,   5.217017411051661e-01,  -4.140149262550038e-03,   3.281905107047930e-05,
  -2.572530743314067e-07,   1.846848051852670e-09,  -5.703194823811991e-12,  -2.715209748070734e-13,   1.066759532238908e-14,  -2.452538629570508e-16,   3.332504717619080e-18,
   5.217098814785526e-01,  -4.140340612626615e-03,   3.282179358426296e-05,  -2.572668704202237e-07,   1.845824185582460e-09,  -5.647338565910546e-12,  -2.732218326117853e-13,
   1.069686538951409e-14,  -2.451550561516929e-16,   3.307116481872663e-18,   5.217162881542911e-01,  -4.140491208496329e-03,   3.282395159703302e-05,  -2.572776954704489e-07,
   1.845016915509794e-09,  -5.603343869569955e-12,  -2.745602461505318e-13,   1.071984769459258e-14,  -2.450749452101474e-16,   3.287084012346654e-18,   5.217199856359124e-01,
  -4.140578121259703e-03,   3.282519688396803e-05,  -2.572839297680309e-07,   1.844550430169895e-09,  -5.577939445373528e-12,  -2.753326014576374e-13,   1.073308980268296e-14,
  -2.450277698069795e-16,   3.275502155318546e-18,   5.217213740890820e-01,  -4.140610758044507e-03,   3.282566447428003e-05,  -2.572862683414435e-07,   1.844375148019423e-09,
  -5.568397144848806e-12,  -2.756226153375658e-13,   1.073805829225284e-14,  -2.450098769582725e-16,   3.271149139325786e-18,   5.217216042457048e-01,  -4.140616168068124e-03,
   3.282574198262584e-05,  -2.572866558632829e-07,   1.844346086571579e-09,  -5.566815230267784e-12,  -2.756706885892054e-13,   1.073888167658625e-14,  -2.450069015712820e-16,
   3.270427358262779e-18,   6.793041348429577e-01,  -5.390564879860997e-03,   4.272268168828567e-05,  -3.343602258735997e-07,   2.367503988133847e-09,  -5.517379799322152e-12,
  -4.319363376638411e-13,   1.646317175175560e-14,  -3.856478960985696e-16,   5.590596900438841e-18,   6.793102186487273e-01,  -5.390707651783400e-03,   4.272469783102671e-05,
  -3.343676579310729e-07,   2.366563721205247e-09,  -5.467732715328485e-12,  -4.334728205075006e-13,   1.649125509038119e-14,  -3.856430920884639e-16,   5.569911259400558e-18,
   6.793202064073262e-01,  -5.390942037202278e-03,   4.272800706964308e-05,  -3.343798076048740e-07,   2.365017750371664e-09,  -5.386168694368689e-12,  -4.359951709728101e-13,
   1.653728117503399e-14,  -3.856315440230311e-16,   5.535864213070940e-18,   6.793308044722299e-01,  -5.391190741231784e-03,   4.273151763038144e-05,  -3.343926296588493e-07,
   2.363374134154931e-09,  -5.299541106234760e-12,  -4.386715266961664e-13,   1.658601322545330e-14,  -3.856143132342829e-16,   5.499617945525354e-18,   6.793391454085055e-01,
  -5.391386474764425e-03,   4.273427988230723e-05,  -3.344026701992864e-07,   2.362078267001734e-09,  -5.231305544019004e-12,  -4.407777897399978e-13,   1.662428930975028e-14,
  -3.855971478854040e-16,   5.471005401298388e-18,   6.793439592075001e-01,  -5.391499437274983e-03,   4.273587380008017e-05,  -3.344084445464754e-07,   2.361329461735416e-09,
  -5.191901762253124e-12,  -4.419933366042803e-13,   1.664634855732405e-14,  -3.855857962361677e-16,   5.454457898513801e-18,   6.793457668523069e-01,  -5.391541855983536e-03,
   4.273647228821107e-05,  -3.344106090436966e-07,   2.361048101189897e-09,  -5.177100772814676e-12,  -4.424497828213829e-13,   1.665462622942577e-14,  -3.855812603901005e-16,
   5.448237604077123e-18,   6.793460664961211e-01,  -5.391548887500219e-03,   4.273657149387190e-05,  -3.344109676381463e-07,   2.361001452329305e-09,  -5.174647060815365e-12,
  -4.425254451148552e-13,   1.665599806623025e-14,  -3.855804940959596e-16,   5.447206156221252e-18,   8.781844476867692e-01,  -6.968669899405811e-03,   5.521679167304871e-05,
  -4.309565560336579e-07,   2.972637892309171e-09,  -2.530365012919551e-12,  -7.491367885235945e-13,   2.761515683584777e-14,  -6.651008406216945e-16,   1.051310105839125e-17,
   8.781923105272721e-01,  -6.968853894348585e-03,   5.521932058749333e-05,  -4.309594522345198e-07,   2.971007234076474e-09,  -2.446991766047029e-12,  -7.517916536995885e-13,
   2.766823481194806e-14,  -6.653330144092353e-16,   1.048415759972943e-17,   8.782052189115048e-01,  -6.969155952562343e-03,   5.522347119356878e-05,  -4.309641207094322e-07,
   2.968326146067902e-09,  -2.310006947391301e-12,  -7.561506791904943e-13,   2.775526248608483e-14,  -6.657082188702041e-16,   1.043647765101399e-17,   8.782189160568652e-01,
  -6.969476460661281e-03,   5.522787392483697e-05,  -4.309689572301655e-07,   2.965475733571902e-09,  -2.164500469251818e-12,  -7.607767952597920e-13,   2.784745789696659e-14,
  -6.660982536299011e-16,   1.038566206098976e-17,   8.782296960370840e-01,  -6.969728702923942e-03,   5.523133789537117e-05,  -4.309726787689682e-07,   2.963228410058717e-09,
  -2.049873984907706e-12,  -7.644181832010090e-13,   2.791990898488613e-14,  -6.663993548848724e-16,   1.034550827326199e-17,   8.782359174766053e-01,  -6.969874277144847e-03,
   5.523333661844754e-05,  -4.309747925217014e-07,   2.961929818592906e-09,  -1.983675889031230e-12,  -7.665199415824211e-13,   2.796167887315440e-14,  -6.665707769105091e-16,
   1.032226999017349e-17,   8.782382537083151e-01,  -6.969928941764596e-03,   5.523408708280241e-05,  -4.309755798247394e-07,   2.961441878915734e-09,  -1.958809361240370e-12,
  -7.673092182414925e-13,   2.797735573413852e-14,  -6.666347033876225e-16,   1.031353155200711e-17,   8.782386409731797e-01,  -6.969938003210521e-03,   5.523421147899895e-05,
  -4.309757099921151e-07,   2.961360979804208e-09,  -1.954686930826232e-12,  -7.674400545378305e-13,   2.797995396817858e-14,  -6.666452766794454e-16,   1.031208238566799e-17,
   1.149001818423397e+00,  -9.117430631579089e-03,   7.220564754264294e-05,  -5.601059716644991e-07,   3.626541176824729e-09,   1.095016956297109e-11,  -1.599223967465542e-12,
   5.797973388061106e-14,  -1.497579936929688e-15,   2.808050242879076e-17,   1.149012100004317e+00,  -9.117669692568301e-03,   7.220872426157104e-05,  -5.600889044488960e-07,
   3.623056073214992e-09,   1.112572626852510e-11,  -1.605228786286823e-12,   5.812292799982804e-14,  -1.499399189804152e-15,   2.805613294247841e-17,   1.149028979197158e+00,
  -9.118062144268239e-03,   7.221377302022327e-05,  -5.600607043256437e-07,   3.617325426922116e-09,   1.141423988192334e-11,  -1.615091850065721e-12,   5.835791119530412e-14,
  -1.502375710003777e-15,   2.801574314677517e-17,   1.149046889751725e+00,  -9.118478558208416e-03,   7.221912718637358e-05,  -5.600305349300484e-07,   3.611232145207762e-09,
   1.172079479308400e-11,  -1.625564349655797e-12,   5.860711918083240e-14,  -1.505520309782032e-15,   2.797236525717878e-17,   1.149060985760933e+00,  -9.118806272608115e-03,
   7.222333879984770e-05,  -5.600066125680560e-07,   3.606427557574985e-09,   1.196235888281545e-11,  -1.633811336759346e-12,   5.880315435934820e-14,  -1.507985177034175e-15,
   2.793784911249575e-17,   1.149069120967176e+00,  -9.118995400759975e-03,   7.222576854433242e-05,  -5.599927347523533e-07,   3.603651070043033e-09,   1.210189197705910e-11,
  -1.638572864405655e-12,   5.891625268711660e-14,  -1.509403706381498e-15,   2.791777779094409e-17,   1.149072175841392e+00,  -9.119066419838003e-03,   7.222668077489992e-05,
  -5.599875099271472e-07,   3.602607778308081e-09,   1.215431104704633e-11,  -1.640361248605646e-12,   5.895871513944229e-14,  -1.509935622734976e-15,   2.791021219167161e-17,
   1.149072682231753e+00,  -9.119078192244364e-03,   7.222683198159119e-05,  -5.599866431217095e-07,   3.602434801204408e-09,   1.216300147177443e-11,  -1.640657719089868e-12,
   5.896575352386545e-14,  -1.510023755610953e-15,   2.790895657539991e-17,   1.549689224339955e-03,  -1.191979587291574e-05,   9.165156456183158e-08,  -7.023760224563536e-10,
   5.242070055143098e-12,  -3.258677450065156e-14,  -4.205666887064341e-17,   9.022023591130081e-18,  -2.662407873227430e-19,   5.046111741526223e-21,   1.549702276030642e-03,
  -1.192009589568851e-05,   9.165603988542173e-08,  -7.024221643487456e-10,   5.241967594291060e-12,  -3.255940201708197e-14,  -4.312387891727756e-17,   9.047734397577689e-18,
  -2.665483147527131e-19,   5.040930108374223e-21,   1.549723702954086e-03,  -1.192058844582478e-05,   9.166338678633651e-08,  -7.024978854094508e-10,   5.241797738295554e-12,
  -3.251441021134571e-14,  -4.487675213493387e-17,   9.089923181328897e-18,  -2.670513383284780e-19,   5.032360004366904e-21,   1.549746439202375e-03,  -1.192111109888236e-05,
   9.167118232438069e-08,  -7.025781927823606e-10,   5.241615264827573e-12,  -3.246659509839691e-14,  -4.673787267753083e-17,   9.134661884397545e-18,  -2.675825918136853e-19,
   5.023180012430872e-21,   1.549764333202855e-03,  -1.192152244355180e-05,   9.167731738699263e-08,  -7.026413671892480e-10,   5.241470032582127e-12,  -3.242890983095433e-14,
  -4.820344115966727e-17,   9.169851931852495e-18,  -2.679988835113243e-19,   5.015892725763358e-21,   1.549774660362267e-03,  -1.192175984420151e-05,   9.168085802467563e-08,
  -7.026778151759539e-10,   5.241385564775753e-12,  -3.240713907709025e-14,  -4.904959209854950e-17,   9.190152927521391e-18,  -2.682384082668438e-19,   5.011662005370212e-21,
   1.549778538347687e-03,  -1.192184899156399e-05,   9.168218756422840e-08,  -7.026914996397343e-10,   5.241353723123356e-12,  -3.239895981354916e-14,  -4.936739487616807e-17,
   9.197774661990898e-18,  -2.683282150110510e-19,   5.010068586792667e-21,   1.549779181181092e-03,  -1.192186376907116e-05,   9.168240795417027e-08,  -7.026937679237426e-10,
   5.241348438416370e-12,  -3.239760376573686e-14,  -4.942007864580481e-17,   9.199037994806406e-18,  -2.683430945251606e-19,   5.009804204753610e-21,   1.398565695168869e-02,
  -1.075739282797130e-04,   8.271365655308193e-07,  -6.338649024235814e-09,   4.729757174711574e-11,  -2.935071112171840e-13,  -4.037360664999495e-16,   8.222879513589521e-17,
  -2.424246435623099e-18,   4.597743340379486e-20,   1.398577474049971e-02,  -1.075766358564392e-04,   8.271769446870495e-07,  -6.339064596648763e-09,   4.729659441050408e-11,
  -2.932576330447028e-13,  -4.134537513172771