/*
 *  utility.c - contains utilities for bandwidthcalc
 *  Copyright (c) 2007-2008 Christoph Goehre <christoph.goehre@gmx.de>
 *
 *  This file is part of the bandwidthcalc package.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>

#include "utility.h"

void calc_time (long runtime, char* result)
{
    long hour, min, sec;

    hour = runtime / 3600;
    sec = runtime % 60;
    min = (runtime - (hour * 3600) - sec) / 60;
    sprintf (result, "%ldh %ldmin %ldsec", hour, min, sec);
}

