//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/CoreAndShellItem.h
//! @brief     Defines class CoreAndShellItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_COREANDSHELLITEM_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_COREANDSHELLITEM_H

#include "GUI/Model/Sample/ItemWithParticles.h"
#include <memory>

class CoreAndShell;
class ParticleItem;
class MaterialModel;

class CoreAndShellItem : public ItemWithParticles {
public:
    CoreAndShellItem(const MaterialModel* materials);

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    std::unique_ptr<CoreAndShell> createCoreAndShell() const;

    ParticleItem* coreItem() const;
    ParticleItem* createCoreItem(const MaterialModel* materials);

    ParticleItem* shellItem() const;
    ParticleItem* createShellItem(const MaterialModel* materials);

    QVector<ItemWithParticles*> containedItemsWithParticles() const override;

    bool isExpandMain() const { return m_expandMain; }
    void setExpandMain(bool b) { m_expandMain = b; }

    bool isExpandCore() const { return m_expandCore; }
    void setExpandCore(bool b) { m_expandCore = b; }

    bool isExpandShell() const { return m_expandShell; }
    void setExpandShell(bool b) { m_expandShell = b; }

private:
    std::unique_ptr<ParticleItem> m_core;
    std::unique_ptr<ParticleItem> m_shell;
    const MaterialModel* m_materialModel;
    bool m_expandMain = true;
    bool m_expandCore = true;
    bool m_expandShell = true;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_COREANDSHELLITEM_H
