//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Info/ProjectLoadProblemDialog.h
//! @brief     Defines class ProjectLoadProblemDialog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INFO_PROJECTLOADPROBLEMDIALOG_H
#define BORNAGAIN_GUI_VIEW_INFO_PROJECTLOADPROBLEMDIALOG_H

#include <QDialog>
#include <QString>

//! @class ProjectLoadProblemDialog
//! @brief The dialog to inform user about encountered problems during the loading of old project

class ProjectLoadProblemDialog : public QDialog {
    Q_OBJECT
public:
    ProjectLoadProblemDialog(QWidget* parent, const QStringList& details, QString documentVersion);

private:
    QWidget* createWarningWidget();
    QLayout* buttonLayout();
    QString explanationText() const;

    QString m_projectDocumentVersion;
};

#endif // BORNAGAIN_GUI_VIEW_INFO_PROJECTLOADPROBLEMDIALOG_H
