/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DECIMATIONDIALOG_H
#define DECIMATIONDIALOG_H

#include <QWidget>
namespace Ui {
class ui_DecimationWidget;
}

class Decimation;

/**
 * Decimate a VTK mesh (the UI).
 */
class DecimationWidget : public QWidget {
    Q_OBJECT

public:
    /**Default Constructor*/
    DecimationWidget(Decimation*);

    /**Destructor*/
    virtual ~DecimationWidget();

    /// update the target component to decimate
    void updateTargets();

public slots :
    virtual void on_editDetailsCheckBox_toggled(bool toggled);

    virtual void on_applyButton_clicked();

    virtual void on_cancelButton_clicked();

private :
    /// Qt model designed by QtDesigner (with qt4, nor more inheritance from the ui)
    Ui::ui_DecimationWidget *ui;

    /// the action using this widget
    Decimation *myAction;
};
#endif // DECIMATIONDIALOG_H


