/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef OBJ_EXTENSION_H
#define OBJ_EXTENSION_H

#include <QObject>
#include <MeshComponentExtension.h>
/**
 * @ingroup group_sdk_components_obj
 *
 * @brief
 * This simple OBJ Component allows you to manipulate obj files
 *  (alias wavefront).
 *
 **/
class ObjExtension : public camitk::MeshComponentExtension {
    Q_OBJECT
    Q_INTERFACES(camitk::ComponentExtension)
    Q_PLUGIN_METADATA(IID "fr.imag.camitk.sdk.component.obj")

public:
    /// the constructor (do nothing really)
    ObjExtension() : MeshComponentExtension() {}

    /// get the plugin name
    virtual QString getName() const;

    /// get the plugin description (can be html)
    virtual QString getDescription() const;

    /// get the list of managed extensions (each file with an extension in the list can be loaded by this extension)
    virtual QStringList getFileExtensions() const;

    /// get a new instance from data stored in a file (this is the most important method to redefine in your subclass)
    virtual camitk::Component * open(const QString &) throw (camitk::AbortException);

    /// save a component as a OBJ file.
    virtual bool save ( camitk::Component* component ) const;

protected:
    /// the destructor
    virtual ~ObjExtension() {};
};

#endif
