// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Created by postproc-cld2 4.0 on 2013-07-20 13:11:39
// From command line:
//  --cld2 --cc --opensource --just_read_raw --quad --standard --minchars=2 
//  --mincount=2 --max_items_per_langscript=12000 --flatmap --rr_alloc 
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=18 --thresh=240 
//  --v25 --kentries=1024 --tablename=Quad0720 --suppress=bs-Latn bs-Cyrl 
//  sr-ME-Latn    az-Arab az-Cyrl kk-Latn ku-Latn my-Latn ru-Latn tg-Arab 
//  tk-Arab ug-Latn za-Hani zzb-Latn zze-Latn zzh-Latn 
//  --remap=xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl 
//  sr-ME-Cyrl=>sr-Cyrl  --ko_english --force_to_lang_soft --nosoft_cram2 
//  --nomsidlevel --shapeflatprob --langpriorpercent=10 --skipnuc 
//  --noshapeforcetop --noshapeeventop --noshapesteep2 --langcounts 
//  --writebin --list_items=120 --max_langs_per_item=3 
//  i18n/encodings/cld2/prob_data/vetted_quad_prob_20130527.utf8 
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives SLOVENIAN
static const uint32 kQuad0720BuildDate = 20130720;    // yyyymmdd


// Of 1044268 offered items into 1048576 table entries:
// 834679 filled (79%), 4666 merged (0%), 204923 dropped (19%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 139 languages in range ENGLISH..X_KLINGON:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN 
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH 
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN 
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG 
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN LATIN 
//     MALAY WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE OCCITAN URDU 
//     BIHARI ARABIC CATALAN ESPERANTO BASQUE INTERLINGUA 
//     SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE VIETNAMESE 
//     FRISIAN SLOVAK FAROESE SUNDANESE UZBEK AMHARIC AZERBAIJANI 
//     TIGRINYA PERSIAN NORWEGIAN_N XHOSA ZULU GUARANI SESOTHO 
//     TURKMEN KYRGYZ BRETON YIDDISH SOMALI UIGHUR KURDISH MONGOLIAN 
//     SINDHI RHAETO_ROMANCE AFRIKAANS LUXEMBOURGISH TIBETAN ASSAMESE 
//     CORSICAN INTERLINGUE KAZAKH LINGALA PASHTO QUECHUA SHONA TAJIK 
//     TATAR TONGA YORUBA MAORI WOLOF ABKHAZIAN AFAR AYMARA BASHKIR 
//     BISLAMA DZONGKHA FIJIAN GREENLANDIC HAUSA HAITIAN_CREOLE 
//     INUPIAK KASHMIRI KINYARWANDA MALAGASY NAURU OROMO RUNDI SAMOAN 
//     SANGO SANSKRIT SISWANT TSONGA TSWANA VOLAPUK ZHUANG KHASI 
//     SCOTS GANDA MANX AKAN IGBO MAURITIAN_CREOLE HAWAIIAN CEBUANO 
//     HMONG NYANJA PEDI SESELWA VENDA WARAY_PHILIPPINES X_PIG_LATIN 
//     X_KLINGON 

// TopLanguage  TokenCount
//  ENGLISH 5403
//  DANISH 7728
//  DUTCH 4283
//  FINNISH 8637
//  FRENCH 5035
//  GERMAN 7252
//  HEBREW 8944
//  ITALIAN 1465
//  NORWEGIAN 3351
//  POLISH 8748
//  PORTUGUESE 4776
//  RUSSIAN 8835
//  SPANISH 2937
//  SWEDISH 8647
//  CZECH 14519
//  ICELANDIC 8889
//  LATVIAN 8894
//  LITHUANIAN 8855
//  ROMANIAN 11442
//  HUNGARIAN 8844
//  ESTONIAN 7982
//  Unknown 14320
//  BULGARIAN 8816
//  CROATIAN 9478
//  SERBIAN 11810
//  IRISH 7658
//  GALICIAN 4063
//  TAGALOG 1753
//  TURKISH 8887
//  UKRAINIAN 8854
//  HINDI 14450
//  MACEDONIAN 8758
//  BENGALI 8876
//  INDONESIAN 2084
//  LATIN 4863
//  MALAY 1700
//  WELSH 7017
//  NEPALI 8883
//  ALBANIAN 7710
//  BELARUSIAN 8850
//  JAVANESE 4268
//  OCCITAN 2034
//  URDU 8772
//  BIHARI 9142
//  ARABIC 8849
//  CATALAN 4972
//  ESPERANTO 6568
//  BASQUE 4348
//  INTERLINGUA 496
//  SCOTS_GAELIC 5653
//  SWAHILI 3514
//  SLOVENIAN 6518
//  MARATHI 8850
//  MALTESE 8145
//  VIETNAMESE 7590
//  FRISIAN 4147
//  SLOVAK 8881
//  ChineseT 570
//  FAROESE 8141
//  SUNDANESE 4830
//  UZBEK 22260
//  AMHARIC 8891
//  AZERBAIJANI 8990
//  TIGRINYA 8846
//  PERSIAN 8944
//  NORWEGIAN_N 3997
//  XHOSA 5142
//  ZULU 3089
//  GUARANI 8112
//  SESOTHO 1648
//  TURKMEN 14952
//  KYRGYZ 17625
//  BRETON 5450
//  YIDDISH 8889
//  SOMALI 6092
//  UIGHUR 15151
//  KURDISH 8864
//  MONGOLIAN 8839
//  SINDHI 8869
//  RHAETO_ROMANCE 3966
//  AFRIKAANS 4858
//  LUXEMBOURGISH 5681
//  TIBETAN 5014
//  ASSAMESE 3057
//  CORSICAN 2684
//  INTERLINGUE 1266
//  KAZAKH 17563
//  LINGALA 1323
//  PASHTO 8792
//  QUECHUA 4955
//  SHONA 3032
//  TAJIK 8741
//  TATAR 17741
//  TONGA 2578
//  YORUBA 8740
//  MAORI 4267
//  WOLOF 5668
//  ABKHAZIAN 8801
//  AFAR 3445
//  AYMARA 1408
//  BASHKIR 8785
//  BISLAMA 837
//  DZONGKHA 606
//  FIJIAN 1542
//  GREENLANDIC 3234
//  HAUSA 2800
//  HAITIAN_CREOLE 6132
//  INUPIAK 892
//  KASHMIRI 7093
//  KINYARWANDA 3354
//  MALAGASY 3001
//  NAURU 2350
//  OROMO 3091
//  RUNDI 1219
//  SAMOAN 2525
//  SANGO 1408
//  SANSKRIT 17677
//  SISWANT 2516
//  TSONGA 1794
//  TSWANA 1059
//  VOLAPUK 2508
//  ZHUANG 2851
//  KHASI 1551
//  SCOTS 2142
//  GANDA 4407
//  MANX 5458
//  AKAN 2293
//  IGBO 3234
//  MAURITIAN_CREOLE 1390
//  HAWAIIAN 1366
//  CEBUANO 1414
//  HMONG 2073
//  NYANJA 2128
//  PEDI 281
//  SESELWA 711
//  VENDA 313
//  WARAY_PHILIPPINES 1701
//  X_PIG_LATIN 6917
//  X_KLINGON 5878



// Recognized language-script combinations [151]:
static const char* const kQuad0720RecognizedLangScripts = 
  "aa-Latn ab-Cyrl af-Latn ak-Latn am-Ethi ar-Arab as-Beng ay-Latn "
  "az-Latn ba-Cyrl be-Cyrl bg-Cyrl bh-Deva bi-Latn blu-Latn bn-Beng "
  "bo-Tibt br-Latn ca-Latn ceb-Latn co-Latn crs-Latn cs-Latn cy-Latn "
  "da-Latn de-Latn dz-Tibt en-Latn eo-Latn es-Latn et-Latn eu-Latn "
  "fa-Arab fi-Latn fj-Latn fo-Latn fr-Latn fy-Latn ga-Latn gd-Latn "
  "gl-Latn gn-Latn gv-Latn ha-Latn haw-Latn hi-Deva hr-Latn ht-Latn "
  "hu-Latn ia-Latn id-Latn ie-Latn ig-Latn ik-Latn is-Latn it-Latn "
  "iw-Hebr jw-Latn kha-Latn kk-Arab kk-Cyrl kl-Latn ks-Arab ks-Deva "
  "ku-Arab ky-Arab ky-Cyrl la-Latn lb-Latn lg-Latn ln-Latn lt-Latn "
  "lv-Latn mfe-Latn mg-Latn mi-Latn mk-Cyrl mn-Cyrl mr-Deva ms-Latn "
  "mt-Latn na-Latn ne-Deva nl-Latn nn-Latn no-Latn nso-Latn ny-Latn "
  "oc-Latn om-Latn pl-Latn ps-Arab pt-Latn qu-Latn rm-Latn rn-Latn "
  "ro-Cyrl ro-Latn ru-Cyrl rw-Latn sa-Deva sa-Latn sco-Latn sd-Arab "
  "sg-Latn sk-Latn sl-Latn sm-Latn sn-Latn so-Latn sq-Latn sr-Cyrl "
  "sr-Latn ss-Latn st-Latn su-Latn sv-Latn sw-Latn tg-Cyrl ti-Ethi "
  "tk-Cyrl tk-Latn tl-Latn tlh-Latn tn-Latn to-Latn tr-Latn ts-Latn "
  "tt-Cyrl tt-Latn ug-Arab ug-Cyrl uk-Cyrl un-Cyrl un-Latn ur-Arab "
  "uz-Arab uz-Cyrl uz-Latn ve-Latn vi-Latn vo-Latn war-Latn wo-Latn "
  "xh-Latn yi-Hebr yo-Latn za-Latn zh-Hant-Latn zu-Latn zzp-Latn ";

static const uint32 kQuad0720Size = 262144;    // Bucket count
static const uint32 kQuad0720KeyMask = 0xfffc0000;    // Mask hash key

static const IndirectProbBucket4 kQuad0720[kQuad0720Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x58fc0002,0x7bc40003,0x39580004,0x24740005}},	// [000] _ཟུངས_, rniu, _pbrs_, _lām_, 
   {{0x27ec0006,0x7bc40007,0x63a80008,0x69c40009}},	//   _ahen_, sniu, hhen, gnhe, 
   {{0x6b8c000a,0x27ec000b,0x52e0000c,0x2450000d}},	//   bjag, _bhen_, _पर्स, _nơm_, 
   {{0x63a8000e,0x6fdc000f,0x69c40010,0x00000000}},	//   jhen, bécu, anhe, --, 
   {{0x27ec0011,0x13b40012,0x00000000,0x00000000}},	//   _dhen_, یٖتھ_, --, --, 
   {{0x6fdc0013,0x24500014,0x99740015,0x63a80016}},	//   léct, _bơm_, _тумш, ehen, 
   {{0x93a40017,0x24500014,0x26cc0018,0x81c80019}},	//   ишид, _cơm_, _exeo_, লতা_, 
   {{0x6fdc001a,0x63a8001b,0x27ec001c,0xb444001d}},	//   néct, ghen, _ghen_, _የክልሉ, 
   {{0x5184001e,0x0604001f,0xca44001d,0x20a00020}},	//   ауна, _внук_, _ዕይታዎ, _ዝመረጹ_, 
   {{0x0f1c0021,0x63a80022,0x68040023,0x00000000}},	//   पर्स_, ahen, _sėdi, --, 
   {{0x63a80024,0x75280025,0x6aac0026,0x27ec0027}},	//   bhen, _iedz, zzaf, _yhen_, 
   {{0x75280028,0x6e3c0029,0x6f1c002a,0x00000000}},	//   _hedz, trsb, ubsc, --, 
   {{0x7528002b,0xd174002c,0x69c4002d,0x6f1c002e}},	//   _kedz, _ҡыҫы, ynhe, rbsc, 
   {{0x7528002f,0x7bc8000b,0x41a00030,0xe1d40031}},	//   _jedz, édun, _ओतएस, _ỳörg, 
   {{0x75280032,0x6b8c0033,0x6fdc0034,0x70580035}},	//   _medz, tjag, féct, _сайр_, 
   {{0x75280036,0x69c40037,0x6d400038,0x2fc80039}},	//   _ledz, wnhe, ólab, _ujag_, 
   {{0x6b8c003a,0x7528003b,0x6934003c,0x27ec003d}},	// [010] rjag, _oedz, йнау, _rhen_, 
   {{0x27ec003e,0x7528003f,0x63a80040,0x7ac40041}},	//   _shen_, _nedz, zhen, істе, 
   {{0x69c40042,0x2b580043,0x27ec0044,0x6fdc0045}},	//   rnhe, _tbsc_, _phen_, sécu, 
   {{0x63a80046,0x75280047,0x24500048,0xd73c0049}},	//   xhen, _aedz, _rơm_, уiрд, 
   {{0x7528004a,0xd5ac004b,0x2450000d,0x00000000}},	//   _bedz, کہٕ_, _sơm_, --, 
   {{0x27ec004c,0x63a8004d,0x7df4004e,0x2474004f}},	//   _when_, when, _uńst, _pām_, 
   {{0x27ec0050,0x21680051,0x75280052,0x63a80053}},	//   _then_, қини_, _dedz, then, 
   {{0x27ec0039,0x62880054,0x2b480055,0x387c0056}},	//   _uhen_, txeo, ngac_, ævre_, 
   {{0x16580057,0x63a80058,0xe2980041,0x67280059}},	//   _مسلک_, rhen, уап_, _ieej, 
   {{0x2474005a,0x2168005b,0x21a4005c,0x7528005d}},	//   _tām_, ћини_, сиом, _gedz, 
   {{0x6608005e,0x2a68005f,0x66000060,0xc4440061}},	//   _huek, hwab_, _iilk, _ئیبن_, 
   {{0x66080062,0xf3740063,0x63a40064,0x66000065}},	//   _kuek, _وطند, êhnd, _hilk, 
   {{0x66000066,0x67280067,0x75280068,0x2a680039}},	//   _kilk, _meej, _yedz, jwab_, 
   {{0x67280069,0x6608006a,0x6600006b,0x3cf4006c}},	//   _leej, _muek, _jilk, ंधले_, 
   {{0x6600006d,0x7b84006e,0x6608006f,0x97400070}},	//   _milk, يارە, _luek, šćic, 
   {{0x67280071,0x66000072,0x28bc0073,0x1e840074}},	//   _neej, _lilk, ्पनि, _глим, 
   {{0x6d400075,0x00000000,0x00000000,0x00000000}},	// [020] ólac, --, --, --, 
   {{0x46d80076,0x2d98002c,0x66000077,0x75e40078}},	//   _बड़ह, _көсө_, _nilk, tòzm, 
   {{0x75280079,0x6728007a,0x63b8007b,0x4d78007c}},	//   _redz, _beej, _omwn, _ערטע, 
   {{0x7528007d,0x6608007e,0x2a68007f,0x67280080}},	//   _sedz, _buek, bwab_, _ceej, 
   {{0x66000081,0x66080039,0x75280082,0x2a680083}},	//   _bilk, _cuek, _pedz, cwab_, 
   {{0xdb140084,0x66080085,0x63b80086,0x66000087}},	//   ábær, _duek, _amwn, _cilk, 
   {{0x6600004b,0x75280088,0x67280089,0x986c001d}},	//   _dilk, _vedz, _feej, _ባልሆኑ_, 
   {{0x7528008a,0x6608008b,0x6728008c,0x6600008d}},	//   _wedz, _fuek, _geej, _eilk, 
   {{0x6608008e,0x6fdc008f,0x00000000,0x00000000}},	//   _guek, kécr, --, --, 
   {{0x41380090,0x75280088,0x20080091,0x67280083}},	//   _በአገሪ, _uedz, _čair_, _zeej, 
   {{0x81e40092,0x67280093,0x66080094,0x28bc0095}},	//   _মূহ_, _yeej, _zuek, ्पयि, 
   {{0x7bc80096,0x66080083,0x61340031,0x00000000}},	//   édul, _yuek, _aýlı, --, 
   {{0x2fd80097,0xa3c40098,0x00000000,0x00000000}},	//   rosg_, उचर_, --, --, 
   {{0x6600004b,0x4ea40099,0xa2c4009a,0xad24009b}},	//   _xilk, арҳа, ापर्, تىسى, 
   {{0x63b8009c,0x4170009d,0x7c84009e,0x6fb40075}},	//   _ymwn, _راوس, путе, _ومتا, 
   {{0x48ec0030,0x00000000,0x00000000,0x00000000}},	//   _अरबो_, --, --, --, 
   {{0x6814009f,0x672800a0,0xedd40075,0x00000000}},	// [030] _işdə, _reej, _ويبد, --, 
   {{0x672800a1,0x660800a2,0xf1c80095,0x00000000}},	//   _seej, _ruek, िचिन, --, 
   {{0xd24400a3,0xe71800a4,0x672800a5,0x66080054}},	//   _ڪن_, ليات_, _peej, _suek, 
   {{0xd36400a6,0x932800a7,0x950c00a8,0x00000000}},	//   _غه_, ተንቀሳ, _ākāṃ, --, 
   {{0x660000a9,0xf1c800aa,0x672800ab,0x00000000}},	//   _pilk, िचान, _veej, --, 
   {{0xcfcc00ac,0x67280029,0xe8940020,0xd00400ad}},	//   রতিন, _weej, _ዘጸግም_, _يل_, 
   {{0x660000ae,0x672800af,0x680400b0,0x00000000}},	//   _vilk, _teej, _pėdu, --, 
   {{0xe3b000b1,0x625800b2,0xa2c400b3,0x660800b4}},	//   برت_, арор_, ापल्, _tuek, 
   {{0x660000b5,0x660800b6,0x680400b0,0x1db80098}},	//   _tilk, _uuek, _vėdu, _उगलत, 
   {{0x66000028,0x11d40075,0x201000b7,0x00000000}},	//   _uilk, يوية_, ízio_, --, 
   {{0xdf1400b8,0x00000000,0x00000000,0x00000000}},	//   жьгь, --, --, --, 
   {{0x14d400b9,0x63b800ba,0x225800bb,0x00000000}},	//   _וועל_, _umwn, _виды_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa0a400bc,0x5be00095,0x00000000,0x00000000}},	//   _малд, पत्व, --, --, 
   {{0x28d800bd,0x00000000,0x00000000,0x00000000}},	//   _बुलि, --, --, --, 
   {{0xd43c001d,0x00000000,0x00000000,0x00000000}},	//   _አይጠቅ, --, --, --, 
   {{0xda6400be,0x5f8000bf,0x00000000,0x00000000}},	// [040] غاري, _فۇگە, --, --, 
   {{0x999000c0,0x5f4400c1,0x00000000,0x00000000}},	//   kryť_, _انکل, --, --, 
   {{0xdbdc00c2,0xe7c800c3,0x00000000,0x00000000}},	//   rţân, ﻫﯟﺍﻟ, --, --, 
   {{0x6ac400c4,0x00000000,0x00000000,0x00000000}},	//   étfú, --, --, --, 
   {{0x8d900061,0x00000000,0x00000000,0x00000000}},	//   _رلێش, --, --, --, 
   {{0x45b400c5,0x00000000,0x00000000,0x00000000}},	//   огію_, --, --, --, 
   {{0xdb0400c6,0x00000000,0x00000000,0x00000000}},	//   _alké, --, --, --, 
   {{0x81e400c7,0xd32400c8,0xd25800c9,0x8c1800ca}},	//   _মূল_, цьки, ацо_, בוקי, 
   {{0xdcfc0025,0x2c1000a1,0x00000000,0x00000000}},	//   _kopē, _दूनू_, --, --, 
   {{0x60cc00cb,0xd76400cc,0x00000000,0x00000000}},	//   _śama, _دەچى_, --, --, 
   {{0xdb0400cd,0xdcfc00ce,0xef1000cc,0x897800cf}},	//   _elké, _mopē, нүйө, בריצ, 
   {{0x28bc00d0,0x09a400d0,0xb4c800d1,0x649800cc}},	//   ्पति, _गत्य, ैथी_, _утур_, 
   {{0x230800d2,0xa1a800cc,0xdb1400d3,0x00000000}},	//   _اتمي_, ртөз_, diyà, --, 
   {{0x24a8001e,0xdcfc00d4,0xa11400d5,0x717400d6}},	//   _ñumí_, _nopē, _ٹوٹت, _رهبا, 
   {{0xac9400d7,0xac1800d8,0x2ca400d9,0x00000000}},	//   чавш, собу_, áld_, --, 
   {{0x2d8400da,0x7b8800db,0x81c800dc,0x00000000}},	//   űle_, ољуб_, লতঃ_, --, 
   {{0x1ea800dd,0x00000000,0x00000000,0x00000000}},	// [050] _هاٿي_, --, --, --, 
   {{0x3ea400de,0x0c8400df,0xdcfc00e0,0xc87800e1}},	//   ømte_, _дымм, _copē, иџе_, 
   {{0xbdf800e2,0x610c00e3,0xfeb8005e,0x00000000}},	//   _بريا_, _hőlé, _هایت_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa9c000e4,0xff7c007c,0x680400e5,0x00000000}},	//   _كۅرۉ, יטאמ, _pėds, --, 
   {{0xdc5400e6,0x00000000,0x00000000,0x00000000}},	//   _بریک, --, --, --, 
   {{0xdb1400c4,0xa8240061,0xb50800e7,0x00000000}},	//   liyá, _رکان, زۉنۅ_, --, 
   {{0xd90c00e8,0x00000000,0x00000000,0x00000000}},	//   _لیے_, --, --, --, 
   {{0x78b800e9,0x970000c3,0xa0c400ea,0x00000000}},	//   ćavš, _كېمى, ړيدو, --, 
   {{0xd6c400eb,0x00000000,0x00000000,0x00000000}},	//   _عملی, --, --, --, 
   {{0x9d4400ec,0x00000000,0x00000000,0x00000000}},	//   үемд, --, --, --, 
   {{0x6d4000ed,0x5f0400ee,0x63ac00ef,0x00000000}},	//   ólan, язма, ďans, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdd9000f0,0xddc4007b,0x75e400f1,0x610c00f2}},	//   روز_, mukŋ, tòzi, _dőlé, 
   {{0xa0a400f3,0x00000000,0x00000000,0x00000000}},	//   _хайд, --, --, --, 
   {{0x5f7400f4,0x3c180078,0x9b0800f5,0x00000000}},	//   _رابر, _nčve_, снаб_, --, 
   {{0x0b4000f6,0x00000000,0x00000000,0x00000000}},	// [060] энтн, --, --, --, 
   {{0x7e6400f7,0xeb9800f8,0x00000000,0x00000000}},	//   _ipip, биӣ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x55e400f9,0x00000000,0x00000000,0x00000000}},	//   подб, --, --, --, 
   {{0x7e6400fa,0x00000000,0x00000000,0x00000000}},	//   _mpip, --, --, --, 
   {{0x7e6400fb,0x339400fc,0x00000000,0x00000000}},	//   _lpip, дайё, --, --, 
   {{0x7e6400fd,0x00000000,0x00000000,0x00000000}},	//   _opip, --, --, --, 
   {{0x154400b7,0x00000000,0x00000000,0x00000000}},	//   _неам, --, --, --, 
   {{0x301400fe,0xc0f000ff,0x4a980100,0xdddc0101}},	//   мдор, _ግርም_, צייג, _çyňs, 
   {{0x7e640102,0xc0540103,0x25a00104,0x00000000}},	//   _apip, пія_, öhle_, --, 
   {{0xdb140105,0x92680106,0x50c80049,0x00000000}},	//   yiyá, _грка_, _қылм_, --, 
   {{0xc7b00107,0x00000000,0x00000000,0x00000000}},	//   תבר_, --, --, --, 
   {{0xbf140108,0x0dc80109,0x00000000,0x00000000}},	//   _җүрә, суми_, --, --, 
   {{0x7e64010a,0x415800ca,0x00000000,0x00000000}},	//   _epip, _הדוג, --, --, 
   {{0x7e64010b,0x00000000,0x00000000,0x00000000}},	//   _fpip, --, --, --, 
   {{0xeb9800fc,0x2dd4010c,0x7ac40091,0x00000000}},	// [070] биң_, _ожир, нсфе, --, 
   {{0xdb140101,0x00000000,0x00000000,0x00000000}},	//   mnyý, --, --, --, 
   {{0xdd14010d,0xdb14010e,0x9a64010f,0xd1c0001d}},	//   _توپخ, siyá, ስተኛው_, _ስኬት_, 
   {{0xdb140110,0xdc34007c,0xdba00020,0x00000000}},	//   piyá, _קארט_, _ወለዶም_, --, 
   {{0xa5080111,0x25d80112,0x00000000,0x00000000}},	//   оела_, омды_, --, --, 
   {{0xddd40113,0xf6500114,0xf6d40115,0x00000000}},	//   _kryš, طئه_, رزند, --, 
   {{0x07440116,0x00000000,0x00000000,0x00000000}},	//   _нхам, --, --, --, 
   {{0xc0f00117,0x22140118,0x33f40119,0x4a28011a}},	//   _ግርማ_, мфор, нчыс, _སྦོལ_, 
   {{0xd24c011b,0xd11c00b3,0x28bc011c,0x00000000}},	//   لني_, _म्हण_, ्पवि, --, 
   {{0xd24c0063,0x6d40011d,0x6d1c011e,0xb0c80098}},	//   گنی_, ólal, _ब्लग_, ाऊंग, 
   {{0x5f4400e2,0x00000000,0x00000000,0x00000000}},	//   وندل, --, --, --, 
   {{0xd24c011f,0xe2900120,0xdd8400d5,0x00000000}},	//   دنی_, _لذت_, ڈجسٹ, --, 
   {{0xdcb00121,0xf1a80122,0x4e240123,0xc2e80124}},	//   ھىر_, زایه_, моян_, _اعام_, 
   {{0x44c40125,0x4a280126,0xdcb00127,0xd1280128}},	//   _kɑ_, _སྦེལ_, پىر_, _ۇقۇۇ_, 
   {{0x3a200105,0x5fd40129,0x00000000,0x00000000}},	//   wpip_, _оциф, --, --, 
   {{0x44c40125,0x5f4400e2,0x00000000,0x00000000}},	//   _mɑ_, _ځنګل, --, --, 
   {{0x3a20012a,0x98b0012b,0x00000000,0x00000000}},	// [080] upip_, _ıbız_, --, --, 
   {{0xddd4012c,0x1dd00095,0x00000000,0x00000000}},	//   _fryš, _सदित, --, --, 
   {{0x44c4012d,0xddc400a2,0x00000000,0x00000000}},	//   _nɑ_, nukō, --, --, 
   {{0x3a20012e,0x00000000,0x00000000,0x00000000}},	//   ppip_, --, --, --, 
   {{0x9f500039,0x7bc4012f,0x35c400f8,0x1dd00095}},	//   _chyé_, miiu, надҳ, _सदात, 
   {{0x44c40130,0x28d80131,0x7bc40132,0xddc400a2}},	//   _bɑ_, _बुकि, liiu, kukō, 
   {{0x5efc00cb,0x799c0133,0x00000000,0x00000000}},	//   रेत्_, _iorw, --, --, 
   {{0xb2740134,0x799c0135,0x28bc0136,0x7bc40034}},	//   елиш, _horw, ्परि, niiu, 
   {{0x799c0137,0x6f080138,0x31340139,0x95c800b7}},	//   _korw, žeck, непр, _длаб_, 
   {{0x799c013a,0xdb14013b,0x7bc4013c,0x00000000}},	//   _jorw, liyä, hiiu, --, 
   {{0x799c013d,0x7bc4008b,0x6d40013e,0x93a8013f}},	//   _morw, kiiu, ólam, _واصف_, 
   {{0x799c0140,0xdb0400f2,0xefd00020,0xee200049}},	//   _lorw, _alkí, ኩምዎ_, лемi_, 
   {{0x799c0141,0x41700142,0xdcfc00e5,0xeac80143}},	//   _oorw, رایس, _kopė, _শর্ম, 
   {{0x799c0144,0x00000000,0x00000000,0x00000000}},	//   _norw, --, --, --, 
   {{0xe94400d5,0xdb14012b,0x00000000,0x00000000}},	//   ہرای, kiyä, --, --, 
   {{0x4a280145,0x7bc4012e,0xdb0400e3,0x00000000}},	//   _སྦུལ_, giiu, _elkí, --, 
   {{0x799c0146,0x6f0c0147,0xed000143,0x00000000}},	// [090] _borw, _igac, ্রেস_, --, 
   {{0x6e2c0148,0x7bc4008b,0x799c0149,0x316c014a}},	//   _iwab, aiiu, _corw, nedz_, 
   {{0x6e2c014b,0x799c014c,0x23b0014d,0x7bc4014e}},	//   _hwab, _dorw, _háje_, biiu, 
   {{0x6e2c014f,0xa6340150,0x44c40151,0xdb140152}},	//   _kwab, енді, _rɑ_, giyä, 
   {{0x6e2c00c4,0x799c0153,0x6f0c0154,0x00000000}},	//   _jwab, _forw, _mgac, --, 
   {{0xe2980155,0x44c40125,0x6b9c0156,0xc8640157}},	//   ҷаи_, _pɑ_, _hosg, _отби, 
   {{0x6e2c0158,0x6b9c0159,0x69c4015a,0x316c015b}},	//   _lwab, _kosg, mihe, dedz_, 
   {{0x6f0c015c,0xe2980155,0x6e2c015d,0x6b9c011a}},	//   _ngac, заи_, _owab, _josg, 
   {{0x6e2c00c4,0x6560015e,0x6b9c015f,0x51f400d5}},	//   _nwab, _tblh, _mosg, کسٹر, 
   {{0x69c40160,0x6f0c0161,0x6b9c0162,0x36d40116}},	//   nihe, _agac, _losg, _роур, 
   {{0xa0a40163,0x60e80164,0x00000000,0x00000000}},	//   ханд, ямом_, --, --, 
   {{0x69c40165,0x6e2c0166,0x6b9c0167,0x82800168}},	//   hihe, _bwab, _nosg, _ақид, 
   {{0x69c40169,0x1d0800cc,0x00000000,0x00000000}},	//   kihe, зеги_, --, --, 
   {{0x236c016a,0x69c4016b,0x6f0c016c,0x224c0054}},	//   leej_, jihe, _egac, muek_, 
   {{0xae04016d,0x30740041,0x6b9c016e,0x6e2c016f}},	//   торҙ, _ауыс, _bosg, _ewab, 
   {{0x63a80170,0x6b9c0171,0x799c0172,0x61e00173}},	//   nken, _cosg, _sorw, loll, 
   {{0x6e2c0174,0x63a80175,0x799c0176,0x6b9c0177}},	// [0a0] _gwab, iken, _porw, _dosg, 
   {{0x61e00178,0x236c0179,0x63a8017a,0x69c4017b}},	//   noll, heej_, hken, gihe, 
   {{0x799c017c,0x6b9c017d,0x5744017e,0x7bc4012f}},	//   _vorw, _fosg, енеб, piiu, 
   {{0x63a8017f,0x1bb80180,0x236c0181,0x224c0182}},	//   jken, _راجع_, jeej_, kuek_, 
   {{0x61e00183,0x63a80184,0x69c40185,0x799c0104}},	//   koll, dken, bihe, _torw, 
   {{0x69c40186,0x63a80187,0x61e00188,0x224c0189}},	//   cihe, eken, joll, duek_, 
   {{0x61e0018a,0x316c018b,0x63a8018c,0x9f500152}},	//   doll, vedz_, fken, _biyü_, 
   {{0x63a8018d,0x6f0800e9,0x00000000,0x00000000}},	//   gken, žeci, --, --, 
   {{0x61e0018e,0x224c008e,0x6d400038,0x6f0c018f}},	//   foll, guek_, ólak, _rgac, 
   {{0x6e2c0190,0x75640191,0x6f0c0177,0x23b00192}},	//   _rwab, _شیعہ_, _sgac, _ráje_, 
   {{0x6e2c0193,0x316c0059,0x2ee80039,0x63a80194}},	//   _swab, redz_, _syaf_, bken, 
   {{0x63a80195,0x69c40196,0x61e00197,0xb4cc0198}},	//   cken, zihe, aoll, रपी_, 
   {{0x61e00199,0x69c4019a,0x6e2c019b,0x6b9c019c}},	//   boll, yihe, _qwab, _rosg, 
   {{0x61e0019d,0x6b9c0043,0x69c4000f,0x28d800bd}},	//   coll, _sosg, xihe, _बुझि, 
   {{0x6b9c019e,0x6454019f,0x6f0c01a0,0x69c401a1}},	//   _posg, _äzit, _tgac, vihe, 
   {{0x6e2c01a2,0x69c40148,0x6f0c01a3,0x09b801a4}},	//   _twab, wihe, _ugac, ोच्य, 
   {{0x6e2c01a5,0x6b9c01a6,0x29d40041,0xff500075}},	// [0b0] _uwab, _vosg, پياس, _اخى_, 
   {{0x63a801a7,0x00000000,0x00000000,0x00000000}},	//   zken, --, --, --, 
   {{0x69c401a8,0x63a801a9,0x6b9c0097,0x224c01aa}},	//   rihe, yken, _tosg, zuek_, 
   {{0x224c0054,0xc6d00182,0x38c80182,0x63a801ab}},	//   yuek_, лслө, хуун_, xken, 
   {{0x63a801ac,0x61e001ad,0x224c0054,0xf73800d5}},	//   vken, yoll, xuek_, ريوں_, 
   {{0x61e001ae,0x00000000,0x00000000,0x00000000}},	//   xoll, --, --, --, 
   {{0x61e001af,0x69d401b0,0x9f5001b1,0xa71401b2}},	//   voll, _ijze, _miyò_, _амбі, 
   {{0x61e001b3,0x224c01a7,0x63a801b4,0x85b801b5}},	//   woll, tuek_, uken, _کارس_, 
   {{0x61e001b6,0xe73801b7,0xe1f801a0,0x7d0801b8}},	//   toll, _нең_, мги_, _kérü, 
   {{0x4db001b9,0x236c01ba,0x224c0182,0xf7700012}},	//   ঁচুৱ, seej_, ruek_, _پاہ_, 
   {{0x63a801bb,0x224c0094,0x7d0800f2,0x00000000}},	//   pken, suek_, _mérü, --, 
   {{0x61e001bc,0x00000000,0x00000000,0x00000000}},	//   soll, --, --, --, 
   {{0x61e001bd,0x224c0054,0xdb5001b5,0x33b00128}},	//   poll, quek_, یَس_, _دەير, 
   {{0x614401be,0x61e001bf,0x00000000,0x00000000}},	//   _река, qoll, --, --, 
   {{0xb02401c0,0x1fb401c1,0xdb7800b8,0x00000000}},	//   _trườ, _аспр, мсаш_, --, 
   {{0x1e8401c2,0x69d401c3,0xede401c4,0xdb0400e3}},	//   _алим, _ajze, кһөҙ_, _alká, 
   {{0x7eb800d3,0xdcfc0059,0x7d0800e3,0xda6400ea}},	// [0c0] _dúpé, _kopī, _bérü, خازي, 
   {{0xdb0401c5,0x00000000,0x00000000,0x00000000}},	//   _omkö, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d401c6,0xdb0400e3,0x00000000,0x00000000}},	//   _ejze, _elká, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xceb00100,0xd94401c7,0x00000000,0x00000000}},	//   סיג_, _шеги, --, --, 
   {{0xd39401c8,0x629c01c9,0x52c80095,0x6d4001ca}},	//   кәдә_, äson, ाप्स, ólai, 
   {{0x07a001cb,0xc7a001cc,0x4380006e,0x08740100}},	//   _касн, _киск, للىق, _בעלט_, 
   {{0xa66401cd,0x07a001ce,0xc7a0018f,0x00000000}},	//   _مطلو, _татн, _титк, --, 
   {{0x6e9401cf,0x00000000,0x00000000,0x00000000}},	//   ҳиму, --, --, --, 
   {{0x3db80143,0x61440108,0x00000000,0x00000000}},	//   ঁচাল, چىۋە, --, --, 
   {{0x614401d0,0x753801d1,0x12e401d2,0x00000000}},	//   نىۋە, lavz, _иілг, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcfc01d3,0x753801d1,0x26140098,0xc23400ca}},	//   _gopī, navz, _फंसी_, _ירדו_, 
   {{0xc1f4007c,0x387801d4,0x00000000,0x00000000}},	//   _שמוץ_, _nsrr_, --, --, 
   {{0x7d080191,0x23b0012c,0x6ce40128,0x00000000}},	//   _sérü, _kája_, _ۅزجە, --, 
   {{0x39580197,0x23b001d5,0x317c012b,0xdb0401d5}},	// [0d0] _bcrs_, _jája_, _kavz_, _plká, 
   {{0x23b0018b,0x395801d6,0x700001d7,0x6f1c01d8}},	//   _mája_, _ccrs_, _ịcha, lcsc, 
   {{0x23b000b8,0xc7b801d9,0xeff801da,0x7d0800f2}},	//   _lája_, мёд_, _ወረድ_, _vérü, 
   {{0xe6d40182,0x6f1c01db,0x66b401d2,0x00000000}},	//   лцлэ, ncsc, лбеу, --, 
   {{0x499000cd,0x2b5801dc,0x9de401b5,0x3aa400ea}},	//   _پیار, _icsc_, _شہہٕ_, _پیلې, 
   {{0x6d5401dd,0x24840039,0x2730001c,0x854401de}},	//   ngza, _prlm_, ạn_, тэде, 
   {{0x2a7801df,0xa3e80152,0x87d801e0,0x00000000}},	//   _hssb_, ндка_, _قبرس_, --, 
   {{0xe3e801e1,0x23b000f2,0x94c800ea,0x00000000}},	//   رکان_, _bája_, عاوې_, --, 
   {{0xd1c001e2,0xdb040085,0x21ec01e3,0x3d1400aa}},	//   ስጠት_, _elkæ, _bаhо_, _दलले_, 
   {{0x057401e4,0x2bc401e5,0x45a00121,0x6d54018c}},	//   _جارد, ịcha_, _خەتك, jgza, 
   {{0x9fc801e6,0x6e3c002a,0x00000000,0x00000000}},	//   егна_, essb, --, --, 
   {{0x442401b4,0xc5f801e7,0x26180048,0x3c1801e8}},	//   mpn_, ɓɓai_, _kèo_, _sčvo_, 
   {{0xdb040055,0x00000000,0x00000000,0x00000000}},	//   _ilkç, --, --, --, 
   {{0xd00c01e9,0x237c01ea,0x26180014,0x5fc400a1}},	//   _کلي_, _hawj_, _mèo_, _लगवल, 
   {{0x261801eb,0x00000000,0x00000000,0x00000000}},	//   _lèo_, --, --, --, 
   {{0x291001ec,0x2010007c,0x6d5401ed,0x9f40005e}},	//   _agza_, ŭzis_, agza, koké_, 
   {{0xeb5401ee,0x198801ef,0x26180048,0x4424015e}},	// [0e0] شىلگ, нбаи_, _nèo_, hpn_, 
   {{0x237c01ba,0xa78401b8,0xa3e401f0,0x00000000}},	//   _lawj_, یشنو, पकड_, --, 
   {{0x395801f1,0x57480074,0x180c01f2,0x00000000}},	//   _vcrs_, езем_, िदेव_, --, 
   {{0x237c01f3,0x291001f4,0x26180048,0xded00020}},	//   _nawj_, _egza_, _bèo_, _ኩሉን_, 
   {{0x9f40005e,0x473001f5,0x200001f6,0x629c0139}},	//   goké_, сніс, imki_, äsol, 
   {{0xa5080121,0x23b000f2,0x00000000,0x00000000}},	//   ھىيە_, _rája_, --, --, 
   {{0xdd30009f,0x44240078,0x00000000,0x00000000}},	//   zəşt, gpn_, --, --, 
   {{0x237c0008,0x7f4401f7,0x6d5401f8,0x23b001d5}},	//   _cawj_, _ndiq, zgza, _pája_, 
   {{0x237c01f9,0x753801f6,0x00000000,0x00000000}},	//   _dawj_, pavz, --, --, 
   {{0x74c401fa,0x104801fb,0x4638007c,0x7f4401fc}},	//   _پښتن, нями_, _נעבע, _adiq, 
   {{0x942401fd,0x442401fe,0x667401ff,0x260000aa}},	//   _смее, cpn_, _مدەر, षगरी_, 
   {{0xae4c0200,0xddd40201,0x23b000f2,0x00000000}},	//   _ﺑﻪﺭﯞ_, _gryź, _tája_, --, 
   {{0x6e3c0202,0xcae00203,0x518400c3,0x5fa00204}},	//   ussb, _कुंड_, _буйа, تەيم, 
   {{0xad240205,0x7c840206,0x6e3c0207,0x00000000}},	//   شىرى, әуре, rssb, --, 
   {{0x2ca40208,0x67380209,0x237c020a,0xef1000e7}},	//   âld_, yawj, _yawj_, _мүнө, 
   {{0x8bb40108,0x00000000,0x00000000,0x00000000}},	//   уқму_, --, --, --, 
   {{0xeff80117,0x680400b0,0xdcec01d5,0x00000000}},	// [0f0] _ወረዳ_, _gėdy, odbě, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d44020b,0x7640020c,0xac9400df,0xba28020d}},	//   _idha, _avmy, _танш, نسەم_, 
   {{0x4424020e,0x6d40020f,0x9f400210,0x00000000}},	//   vpn_, ðlaf, toké_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44240211,0x237c008e,0x9f400212,0x64a40213}},	//   tpn_, _sawj_, roké_, иала, 
   {{0x9f400214,0x6d440215,0xd5ac004b,0x27e80181}},	//   soké_, _mdha, بہٕ_, ƴan_, 
   {{0x67d40216,0xd3440217,0x26180048,0x00000000}},	//   _тобу, لیمه_, _tèo_, --, 
   {{0x6d440218,0x602000e0,0x00000000,0x00000000}},	//   _odha, _mēme, --, --, 
   {{0x6d440219,0x4424021a,0x2114021b,0x1304021c}},	//   _ndha, ppn_, шфиё, шный_, 
   {{0x237c0069,0xdb04021d,0x3d1c00d3,0x680400e5}},	//   _tawj_, _ilkå, _làwó_, _sėdy, 
   {{0x6d44021e,0xe7b4021f,0x64400220,0x00000000}},	//   _adha, ंसिप, _ivli, --, 
   {{0xdea00221,0x7f440222,0xd1e8001d,0x00000000}},	//   زیدی, _vdiq, መሮች_, --, 
   {{0x23b00223,0x224c0039,0x6d4400a8,0x5bac0224}},	//   _kájo_, mrek_, _cdha, घस्व, 
   {{0xe7b40225,0x6d4401d3,0x06dc0143,0x00000000}},	//   ंसाप, _ddha, বেচি, --, 
   {{0x23b000d3,0x6d440226,0xf9a40020,0x00000000}},	//   _májo_, _edha, _ወከፎም_, --, 
   {{0x26140227,0x224c0228,0x9d4400fc,0x23b00229}},	// [100] _फूली_, nrek_, _кепд, _lájo_, 
   {{0xd944022a,0x3d1c00d3,0x644000aa,0x6d40022b}},	//   режи, _dàwó_, _ovli, ólat, 
   {{0x3f80022c,0xa3e4022d,0x9f040122,0x1b48022e}},	//   _kaiu_, पका_, _حوکو, _изни_, 
   {{0xd628022f,0xad240230,0x06dc0143,0x00000000}},	//   воде_, _پریو, বেছি, --, 
   {{0x64400231,0x3f800232,0x6d40020f,0x224c0039}},	//   _avli, _maiu_, ðlag, jrek_, 
   {{0x224c0233,0x00000000,0x00000000,0x00000000}},	//   drek_, --, --, --, 
   {{0x224c0234,0xdcec0078,0x98a40235,0x39380020}},	//   erek_, kebč, _тиве, ዮናውያ, 
   {{0x224c0236,0x98500122,0xb17c0237,0x3d1c0223}},	//   frek_, _هێڕش, toĥo, _yàwó_, 
   {{0x64400238,0x9f400239,0x224c023a,0x672c00b8}},	//   _evli, tokî_, grek_, ñaje, 
   {{0xb17c0237,0xdd180126,0xd5a8023b,0x00000000}},	//   roĥo, għżi, _कविज, --, 
   {{0x09f4023c,0x224c023d,0x6d440095,0x00000000}},	//   שמים_, arek_, _rdha, --, 
   {{0x224c023e,0x3f80023f,0xc4740240,0x4fc40241}},	//   brek_, _caiu_, _כתבו_, рсоа, 
   {{0x224c0242,0x80c40143,0x00000000,0x00000000}},	//   crek_, _রুদ্, --, --, 
   {{0x60200243,0x705801a0,0x0dc80244,0x412400b7}},	//   _sēme, _бакр_, туми_, _кољо_, 
   {{0x8bc40245,0xab94005b,0x7c840246,0xe7e800bd}},	//   асад, бављ, оуте, टकमा_, 
   {{0x21f80247,0x00000000,0x00000000,0x00000000}},	//   mèha_, --, --, --, 
   {{0x2fc80248,0x6d400084,0x21f80249,0xe4ec0030}},	// [110] _imag_, ólas, lèha_, _चुनि_, 
   {{0x6d44024a,0x48a8024b,0x6d40014e,0xbd6c0020}},	//   _udha, ктем_, ðlad, _ድሌቶም_, 
   {{0x2d800243,0x2fc801d1,0xb44000fb,0xec1401e0}},	//   _iahe_, _kmag_, _доiи, _دوجد, 
   {{0xd364024c,0x2d80024d,0xc60c024e,0x224c024f}},	//   _عه_, _hahe_, ाद्य_, yrek_, 
   {{0x2d800250,0xb644006b,0x00000000,0x00000000}},	//   _kahe_, _şürä, --, --, 
   {{0x2d800251,0xcfcc0252,0x224c0253,0x69340254}},	//   _jahe_, ৰতিন, vrek_, _ынгу, 
   {{0x2d800255,0x23b001b8,0x00000000,0x00000000}},	//   _mahe_, _fájl_, --, --, 
   {{0x86b00256,0x224c0257,0x2d800076,0xe3b00258}},	//   _мәлі, trek_, _lahe_, ثرت_, 
   {{0x6aac0259,0x27ec025a,0xe044025b,0xe81c025c}},	//   nyaf, _iken_, әнми, _बंडा_, 
   {{0x224c025d,0x2fc8025e,0x3f80025f,0x2d800260}},	//   rrek_, _amag_, _saiu_, _nahe_, 
   {{0x60080261,0x27ec0262,0x25a40177,0x224c0039}},	//   лном_, _kken_, _ioll_, srek_, 
   {{0x25a40263,0x2fc80264,0x224c0265,0x6aac0266}},	//   _holl_, _cmag_, prek_, kyaf, 
   {{0x4ac40267,0x21680268,0x25a40269,0x2d80026a}},	//   _रेलव, _били_, _koll_, _bahe_, 
   {{0x3f80026b,0x2fc8026c,0x6aac0047,0x00000000}},	//   _waiu_, _emag_, dyaf, --, 
   {{0x27ec026d,0x2fc800b0,0x6054026e,0x00000000}},	//   _oken_, _fmag_, _انعط, --, 
   {{0x25a4026f,0x6d400270,0x27ec0207,0x69d8000b}},	//   _loll_, ólar, _nken_, éwen, 
   {{0x6aac0271,0x1dd80272,0x2b380254,0xdfd001ac}},	// [120] gyaf, _مبدع_, рясэ_, _ويڻ_, 
   {{0x20100273,0x0d800274,0x25a40275,0x2d800276}},	//   _hiyi_, _ельн, _noll_, _gahe_, 
   {{0x20100277,0xddd40023,0x18340075,0x00000000}},	//   _kiyi_, _kryž, صراح, --, 
   {{0x27ec0278,0x6aac0279,0x20100029,0xe7e800c5}},	//   _cken_, byaf, _jiyi_, афік_, 
   {{0x95c8027a,0x6aac0211,0x20100012,0x631c0143}},	//   лука_, cyaf, _miyi_, নরায়_, 
   {{0x27ec027b,0x2010027c,0x4e780100,0x00000000}},	//   _eken_, _liyi_, טאנצ, --, 
   {{0x9484027d,0x25a4027e,0x00000000,0x00000000}},	//   сылд, _doll_, --, --, 
   {{0x2ca4020c,0x2914027f,0xe81c0280,0x20100281}},	//   øldi_, ğdaş_, _बंता_, _niyi_, 
   {{0x1a980282,0x51840283,0x25a40284,0x154400fc}},	//   ריִע, буна, _foll_, _гезм, 
   {{0x25a40285,0x20100278,0x2fc80286,0x00000000}},	//   _goll_, _aiyi_, _smag_, --, 
   {{0x201000ba,0x2ed000cb,0xeaf40287,0x00000000}},	//   _biyi_, सप्त, _आर्त_, --, 
   {{0x03a00288,0x25a40289,0x6aac028a,0x2010028b}},	//   _нихо, _zoll_, yyaf, _ciyi_, 
   {{0x2d80028c,0xa3e40203,0xddd4028d,0xdb0400f2}},	//   _pahe_, पकर_, _dryž, _elkú, 
   {{0x25a4028e,0x00000000,0x00000000,0x00000000}},	//   _xoll_, --, --, --, 
   {{0x2d80028f,0x2d180098,0xe81c0290,0x4bd8005e}},	//   _vahe_, _दलील_, _बंधा_, هبرد_, 
   {{0x2fc80291,0x6d400270,0x2d80005e,0xddd4028d}},	//   _umag_, ðlab, _wahe_, _gryž, 
   {{0x0dc80292,0x2d800293,0xaa580294,0xe94401a0}},	// [130] _буни_, _tahe_, ризу_, قرای, 
   {{0x20100295,0x60200296,0xe81c0203,0x27ec0297}},	//   _ziyi_, _hēma, _बंदा_, _sken_, 
   {{0x20100298,0x60200299,0x25a400ca,0x6aac029a}},	//   _yiyi_, _kēma, _roll_, syaf, 
   {{0x25a4029b,0xaa94029c,0x9f40001e,0x00000000}},	//   _soll_, _димч, mokã_, --, 
   {{0x25a4029d,0xe5a4029e,0x6020015b,0x00000000}},	//   _poll_, жили, _mēma, --, 
   {{0x3c18029f,0x631c007e,0x25a402a0,0x00000000}},	//   _sčvi_, নৰায়_, _qoll_, --, 
   {{0x25a402a1,0xd5840061,0x00000000,0x00000000}},	//   _voll_, تێله_, --, --, 
   {{0x27ec01f5,0x25a4000b,0xe79402a2,0x661c0249}},	//   _uken_, _woll_, _باسک, _ésko, 
   {{0x25a402a3,0x7d000223,0xe81c02a4,0x00000000}},	//   _toll_, _kárí, _बूता_, --, 
   {{0xd58402a5,0x201002a6,0xa5f802a7,0x00000000}},	//   _وێنه_, _siyi_, _тезу_, --, 
   {{0x349402a8,0x20100078,0xa06802a9,0xddd402aa}},	//   _нафр, _piyi_, шана_, _pryž, 
   {{0x7d000223,0x00000000,0x00000000,0x00000000}},	//   _lárí, --, --, --, 
   {{0x614402ab,0x712402ac,0x23b000f2,0x00000000}},	//   _дела, غریل, _lájk_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1d0802ad,0x201002ae,0x628802af,0x00000000}},	//   реви_, _tiyi_, lveo, --, 
   {{0x3be40030,0x00000000,0x00000000,0x00000000}},	//   ककेँ_, --, --, --, 
   {{0x7d000223,0x660002b0,0x00000000,0x00000000}},	// [140] _bárí, _ohlk, --, --, 
   {{0x7e6402b1,0x63b80086,0x3e640139,0x7cf402b2}},	//   _iqip, _llwn, möt_, gþrú, 
   {{0x2d9402b3,0xdb0402b4,0x3e640274,0xdcfc02b5}},	//   _хрыс, _kokë, löt_, _kapč, 
   {{0x6288013c,0x00000000,0x00000000,0x00000000}},	//   kveo, --, --, --, 
   {{0x672c004e,0x3e6402b6,0x75f4018f,0x182802ac}},	//   ñaja, nöt_, _bоzо, اقچی_, 
   {{0xdcfc02b7,0xd1c0010f,0x85000122,0xd4f00182}},	//   _lapč, ድበት_, ژوون, мжлө, 
   {{0xa3e40095,0x00000000,0x00000000,0x00000000}},	//   पकं_, --, --, --, 
   {{0x938802b8,0xdb04000b,0x3e6402b9,0x8c1800ca}},	//   рска_, _nokë, köt_, סופי, 
   {{0x60200296,0x62880010,0x15b802ba,0x00000000}},	//   _rēma, gveo, _кыжы_, --, 
   {{0x5064002c,0x71740075,0x00000000,0x00000000}},	//   отма, أهدا, --, --, 
   {{0x7e64012a,0xdb0402bb,0x1c1402bc,0xab30012b}},	//   _aqip, _bokë, _दंगल_, _uñçı_, 
   {{0x3e640038,0x4fc402bd,0xe2a80012,0xa3e40095}},	//   föt_, існа, _گامن_, पकः_, 
   {{0x8d7402be,0x776002bf,0xdcfc02c0,0x00000000}},	//   ياسا, _mcmx, _dapč, --, 
   {{0xe2a802c1,0x75e401e8,0x00000000,0x00000000}},	//   _دامن_, tòzy, --, --, 
   {{0x60200059,0x7e6402ba,0x3b2801d7,0x629c02c2}},	//   _tēma, _eqip, _ọyị_, äsov, 
   {{0xc05002c3,0x35cc00d1,0x00000000,0x00000000}},	//   _חזק_, ़फड़, --, --, 
   {{0x9a9401e2,0x7ac402c4,0xdb2402c5,0xdb1400f1}},	// [150] _መካከል_, мсфе, سولی, tiyò, 
   {{0xf7700122,0x9f40001e,0x00000000,0x00000000}},	//   ێان_, pokã_, --, --, 
   {{0x9f4002c6,0xe71802c7,0xdb140078,0x00000000}},	//   loká_, ميات_, riyò, --, 
   {{0x5c780282,0x6b7402c8,0xbb940027,0x2ca4014e}},	//   _פארה, _элму, _жающ, øldu_, 
   {{0xa5f802c9,0x00000000,0x00000000,0x00000000}},	//   беду_, --, --, --, 
   {{0x75f401e3,0x3618021d,0x00000000,0x00000000}},	//   _qоzо, іцію_, --, --, 
   {{0x23b000ef,0xe3b00075,0x00000000,0x00000000}},	//   _háji_, فرة_, --, --, 
   {{0x33f402ca,0x58000121,0x23b001d5,0xe1f002cb}},	//   мчыс, _كۈلك, _káji_, کسب_, 
   {{0xdcfc00f1,0x68f401d5,0xe6b801c3,0xf3c80061}},	//   _rapč, _hyzd, _угаљ_, تبوه_, 
   {{0x23b002cc,0x312400bf,0x7abc00ca,0x6288013c}},	//   _máji_, үдөг, יצחו, rveo, 
   {{0x7e6402bb,0x602402cd,0xdfe80123,0xdef40020}},	//   _sqip, ядна, йдод_, ሉውን_, 
   {{0xdee40155,0x3e6402ce,0xd24c02cf,0xb3980152}},	//   зоми, töt_, خنی_, _мкхф_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e6402d0,0xdca402d1,0x00000000,0x00000000}},	//   röt_, паги, --, --, 
   {{0x9f9002d2,0xdb0402b4,0x3e6402d3,0x00000000}},	//   lší_, _tokë, söt_, --, 
   {{0x656002d4,0x9f400113,0xab6400e0,0x3e6402d5}},	//   _lclh, boká_, _neļā, pöt_, 
   {{0x9f9002d6,0x2bac02d7,0x99740027,0x00000000}},	// [160] nší_, _टकरा, зуеш, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xad240121,0x985402d8,0x9f9002d9,0xdb0400f2}},	//   _تىپى, яташ, hší_, _moké, 
   {{0xdb04008f,0xab64015b,0x9f9001d4,0x00000000}},	//   _loké, _ceļā, kší_, --, 
   {{0x9f9002da,0x656c02db,0x35c402dc,0x0b4000fc}},	//   jší_, đahn, мадҳ, _янян, 
   {{0x8af80240,0x9f9002dd,0xbbdc0095,0x00000000}},	//   _להכי, dší_, _यदुक, --, 
   {{0x68f400fc,0x00000000,0x00000000,0x00000000}},	//   _gyzd, --, --, --, 
   {{0xdb040074,0xc8d800ca,0x440000bf,0x97c402de}},	//   _pokè, _הקלט, нчыб, _эйбе, 
   {{0xe890010f,0xd04402df,0x518401c3,0x00000000}},	//   _የሚሰጡ_, əmək, пуна, --, 
   {{0xdb040039,0x9f400113,0x00000000,0x00000000}},	//   _coké, voká_, --, --, 
   {{0x261402e0,0x602000e0,0x00000000,0x00000000}},	//   _फूटी_, _dēmo, --, --, 
   {{0x21240177,0x764402b1,0xef1802e1,0x57d80098}},	//   aclh_, šiyu, өмү_, _भदोह, 
   {{0xc20401a0,0xc7b000ca,0x718802e2,0x00000000}},	//   تقین_, גבר_, _мадҳ_, --, 
   {{0x9f400212,0x23b00192,0x8d8400fc,0x00000000}},	//   roká_, _ráji_, чумд, --, 
   {{0x9f400214,0x00000000,0x00000000,0x00000000}},	//   soká_, --, --, --, 
   {{0xdb0402e3,0x2d8401d1,0xe8780012,0x00000000}},	//   _zoké, žle_, ۪ماغ_, --, 
   {{0xfe7002e4,0xdcf00059,0x6a1402e5,0x68f402e6}},	// [170] _یدی_, īgāk, дмау, _syzd, 
   {{0x6e2c02e7,0x68f400b0,0xfe240116,0x2ca402e8}},	//   _itab, _pyzd, _џьын, ølds_, 
   {{0x6e2c0039,0x672c001e,0x00000000,0x00000000}},	//   _htab, ñajo, --, --, 
   {{0x68f40113,0xaa5c0049,0x00000000,0x00000000}},	//   _vyzd, _кемi, --, --, 
   {{0xd24402e9,0x6e2802ea,0xc66802eb,0x76240049}},	//   _جن_, _îmbă, сшее_, еміз, 
   {{0x9f9002ec,0x6e2c01ac,0x68f402d9,0xd90c0046}},	//   vší_, _mtab, _tyzd, ایې_, 
   {{0x240802ed,0x2a6802ee,0xdb040039,0xdcfc0095}},	//   онки_, ltab_, _roké, _kapā, 
   {{0x9f9002ef,0x6e2c02f0,0xdcfc02f1,0x46f000cc}},	//   tší_, _otab, _japā, _كۋار, 
   {{0x6e2c02f2,0xd76402f3,0x2a6802f4,0x6728011a}},	//   _ntab, _تنقی, ntab_, _ifej, 
   {{0x80b002f5,0x9f9002f6,0xd24c0063,0xdcfc00d4}},	//   ুপস্, rší_, شچه_, _lapā, 
   {{0x2a6802f7,0xe1f80197,0x00000000,0x00000000}},	//   htab_, йѳү_, --, --, 
   {{0x9f9002f6,0x2a6802f8,0x67280126,0x6d40020f}},	//   pší_, ktab_, _jfej, ðlan, 
   {{0x6e2c0177,0xfe7802f9,0x6728011a,0xc61c02fa}},	//   _ctab, чүп_, _mfej, নীরা_, 
   {{0xfd6402fb,0x6e2c0272,0x2a680056,0x00000000}},	//   энгү, _dtab, dtab_, --, 
   {{0x98b8004d,0x9b9402fc,0x00000000,0x00000000}},	//   kapā_, ولست, --, --, 
   {{0x67280126,0x7e640116,0xdb1c012b,0x00000000}},	//   _nfej, _зеиҧ, _äyüp, --, 
   {{0xdcfc004f,0xd94402fd,0x00000000,0x00000000}},	// [180] _dapā, дези, --, --, 
   {{0x8d7402fe,0xdb0401c8,0x00000000,0x00000000}},	//   _قاپا, _ilkü, --, --, 
   {{0x2a6800b6,0x1d08023f,0xfa8c010f,0x00000000}},	//   atab_, _фени_, _መካኒክ_, --, 
   {{0x2a6802ff,0x36e40300,0x00000000,0x00000000}},	//   btab_, нбеҳ, --, --, 
   {{0x4cd00301,0x47300302,0xc6e0024b,0x2fd800c6}},	//   _দুপু, тніс, кішп, érgi_, 
   {{0x672800e0,0x00000000,0x00000000,0x00000000}},	//   _efej, --, --, --, 
   {{0xdcfc004f,0x00000000,0x00000000,0x00000000}},	//   _yapā, --, --, --, 
   {{0x4338001d,0x00000000,0x00000000,0x00000000}},	//   _በኢየሩ, --, --, --, 
   {{0xe7bc0303,0x21280304,0xa6500061,0x00000000}},	//   ्फरप, _şaha_, _مێنت, --, 
   {{0xa1140305,0x00000000,0x00000000,0x00000000}},	//   کوپت, --, --, --, 
   {{0x20000296,0x00000000,0x00000000,0x00000000}},	//   _ūhia_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdde002db,0xc33000ca,0x2a680306,0x00000000}},	//   _šušk, _סוס_, xtab_, --, 
   {{0x6e2c0307,0x2a680308,0xdcfc01d3,0x00000000}},	//   _vtab, vtab_, _sapā, --, 
   {{0xdb0400cd,0xdb140078,0xdcfc0309,0x00000000}},	//   _elkü, lkyè, _papā, --, 
   {{0x2a68030a,0x6e2c030b,0x19c0006b,0xdd9802dc}},	//   ttab_, _ttab, ңәрг, ошӣ_, 
   {{0x6e2c030c,0x6934030d,0x635402df,0xdb1401b1}},	// [190] _utab, ензу, lənç, nkyè, 
   {{0x2a68030e,0x3df4021c,0x98b80296,0xdb04030f}},	//   rtab_, _изыс, wapā_, _alkó, 
   {{0x2a680310,0x98b80311,0x2250002f,0xdcfc0312}},	//   stab_, tapā_, ązki_, _tapā, 
   {{0x2a680313,0x3ec40314,0xdb140027,0x00000000}},	//   ptab_, _örtü_, viyö, --, 
   {{0x2a680315,0xc79001c4,0xa5f80027,0x00000000}},	//   qtab_, ерҙы, педу_, --, 
   {{0xdb4c01b5,0xdb0400e3,0xf65002cf,0xb5c801e1}},	//   _پێے_, _elkó, شئه_, وونم_, 
   {{0x98b80299,0x67280126,0xb8d40143,0x39140123}},	//   papā_, _tfej, _জে_, _амрр, 
   {{0x67280085,0xf80400ee,0xe3b00316,0x22340182}},	//   _ufej, _ачун, طرب_, нхоё, 
   {{0xe7380317,0xd24c0318,0x4cd00252,0xd76401a0}},	//   _мең_, مني_, _দুমু, _سنلی, 
   {{0xd1c40319,0x11e00200,0x1300031a,0x85b800bf}},	//   елье_, лжым, ызым, _بارس_, 
   {{0x21f8031b,0x23b000f2,0xe7e00143,0x236c0085}},	//   nèhi_, _bájt_, বতীয, pfej_, 
   {{0xd24c01d0,0x00000000,0x00000000,0x00000000}},	//   شچۇ_, --, --, --, 
   {{0xe298031c,0xf1a8031d,0xb17c01c6,0x33b000c3}},	//   _хал_, سایه_, toĥt, _خەير, 
   {{0xd24c031e,0x6fdc001e,0x00000000,0x00000000}},	//   _انو_, hĩch, --, --, 
   {{0xa07400df,0x23b000d5,0x00000000,0x00000000}},	//   _чылш, _fájt_, --, --, 
   {{0xefe0010f,0x248401e3,0x00000000,0x00000000}},	//   ነችው_, _mslm_, --, --, 
   {{0xdb0401b1,0x1a040091,0x00000000,0x00000000}},	// [1a0] _alkò, епам, --, --, 
   {{0xdcfc0254,0x9984031f,0xce3400ca,0xd82401c7}},	//   _capă, علاو, _ראית_, еджи, 
   {{0x9f400247,0x0d3800ca,0x00000000,0x00000000}},	//   pokä_, _מגיב, --, --, 
   {{0x627801c6,0x9a9c0320,0xd70800b7,0x00000000}},	//   rʈoj, _лугi, пнее_, --, 
   {{0x2b140320,0x00000000,0x00000000,0x00000000}},	//   _аьрр, --, --, --, 
   {{0xa5c0001e,0x00000000,0x00000000,0x00000000}},	//   аҩуе, --, --, --, 
   {{0x799c02b0,0x09e00321,0x00000000,0x00000000}},	//   _inrw, _сорн, --, --, 
   {{0x7bc40139,0x00000000,0x00000000,0x00000000}},	//   nhiu, --, --, --, 
   {{0xc3e000ea,0x629c0027,0x00000000,0x00000000}},	//   دګلو, äsop, --, --, 
   {{0x32180139,0x00000000,0x00000000,0x00000000}},	//   öry_, --, --, --, 
   {{0x7bc40322,0xdb100084,0xc1b401a7,0x320c0323}},	//   khiu, _ágæt, хлэх_, rmdy_, 
   {{0xe3b00012,0x00000000,0x00000000,0x00000000}},	//   _پرٔ_, --, --, --, 
   {{0x82b00324,0xee2001d2,0x80a000bf,0x23b000f2}},	//   _محوط, регi_, _ەمىن, _vájt_, 
   {{0x09ac0098,0x00000000,0x00000000,0x00000000}},	//   _टवेय, --, --, --, 
   {{0xb3a40325,0x23b000f2,0x00000000,0x00000000}},	//   _खचाख, _tájt_, --, --, 
   {{0x7bc40326,0x7b640327,0x799c0328,0x91a400d5}},	//   ghiu, лтуе, _anrw, _آچکے_, 
   {{0xdbcc0329,0x21f80324,0x8880032a,0x00000000}},	// [1b0] _añón, wèhi_, گیزن, --, 
   {{0x7bc40243,0x00000000,0x00000000,0x00000000}},	//   ahiu, --, --, --, 
   {{0x799c02b0,0xbdf8032b,0x00000000,0x00000000}},	//   _dnrw, _ثريا_, --, --, 
   {{0x7bc4032c,0x57b0032d,0x21f80249,0x00000000}},	//   chiu, ғбәт, rèhi_, --, 
   {{0x6b9c032e,0x6b8c032f,0xdbcc001e,0x21f8005e}},	//   _insg, mdag, _eñón, sèhi_, 
   {{0x6b8c0330,0x24840039,0xfa780020,0x00000000}},	//   ldag, _pslm_, _ካላኣይ_, --, 
   {{0x6b8c0331,0x765c00a8,0x00000000,0x00000000}},	//   odag, _ārye, --, --, 
   {{0xe2980332,0xe65c0333,0x00000000,0x00000000}},	//   даи_, ştığ, --, --, 
   {{0x6b8c0334,0x2484008f,0x27fc0335,0x00000000}},	//   idag, _wslm_, mlwn_, --, 
   {{0x27fc0336,0x69c40337,0x6b8c0338,0x9e7c0020}},	//   llwn_, nhhe, hdag, _ዕላማና_, 
   {{0x6b8c02ac,0x60200299,0x6e280100,0x00000000}},	//   kdag, _kēmi, ŭebl, --, 
   {{0x6b8c0339,0x1fb4033a,0x7bc40222,0x00000000}},	//   jdag, тсор, xhiu, --, 
   {{0x63a8033b,0x93b4033c,0x6b8c033d,0x2168033e}},	//   mjen, _שלנו_, ddag, _жили_, 
   {{0x63a8033f,0x1d080340,0x7bc40341,0x6b8c0342}},	//   ljen, деги_, whiu, edag, 
   {{0x2250002f,0x63a80343,0x6b8c0344,0x44240039}},	//   ązku_, ojen, fdag, nqn_, 
   {{0x63a80345,0x6b8c0346,0xa0080272,0x88bc0143}},	//   njen, gdag, _تقبل_, _আশংক, 
   {{0x4b2000c8,0xd00c0347,0x65bc005e,0x8b200348}},	// [1c0] рмув, _بلي_, _rèhn, рдуе, 
   {{0x63a80349,0x7f440337,0x3878034a,0xdb040247}},	//   hjen, _heiq, _pprr_, _pokâ, 
   {{0x63a8034b,0x7bc4034c,0x6b8c034d,0x00000000}},	//   kjen, phiu, bdag, --, 
   {{0x7bc40322,0x9980034e,0x63a8034f,0x47c80046}},	//   qhiu, _kukū_, jjen, وانۍ_, 
   {{0x63a80350,0xcf900282,0x7f44034c,0x2b5c0098}},	//   djen, יטא_, _meiq, ówce_, 
   {{0x69c40351,0x986400cd,0x589401c4,0x94740352}},	//   chhe, _لیئے_, _ишбу, ندعا, 
   {{0xa6140329,0x63a80353,0x53e4001e,0x00000000}},	//   ызшә, fjen, кциа, --, 
   {{0x63a80354,0x61e00355,0x6604016d,0x00000000}},	//   gjen, enll, _ҡотҡ, --, 
   {{0x61e00086,0x721801d9,0x9f400356,0x00000000}},	//   fnll, нжир_, bokú_, --, 
   {{0xa3f40357,0x6b8c0358,0x3dd8007e,0xdcfc02d9}},	//   ější_, zdag, _দীঘল, _dopĺ, 
   {{0x63a80359,0x6b8c035a,0x3014035b,0xe3b001b5}},	//   bjen, ydag, лдор, _گرٕ_, 
   {{0x63a8035c,0x7f440008,0x69c40151,0x6b8c018f}},	//   cjen, _ceiq, zhhe, xdag, 
   {{0x7f44034c,0xe3b001b5,0x6b8c035d,0x81400108}},	//   _deiq, _درٕ_, vdag, اھۇم, 
   {{0x225801d4,0x3df40074,0x00000000,0x00000000}},	//   áske_, изяс, --, --, 
   {{0x80a0035e,0x6b8c035f,0x4fc40360,0x764001f3}},	//   _نمون, tdag, _аспа, _lwmy, 
   {{0x7f440361,0x8e240362,0x6b8c0363,0x225801d4}},	//   _geiq, _ифод, udag, šske_, 
   {{0x321c0364,0x69c40365,0xc9840366,0x00000000}},	// [1d0] _kivy_, thhe, кужи, --, 
   {{0x6b8c0367,0x63a80368,0x60200369,0x69c40337}},	//   sdag, zjen, _sēmi, uhhe, 
   {{0x6b8c036a,0x660c036b,0xdb04001e,0xe7940294}},	//   pdag, ïakm, _pokã, лижњ, 
   {{0x6d44036c,0x321c036d,0x6b8c02ac,0x69c4036e}},	//   _heha, _livy_, qdag, shhe, 
   {{0x6d44036f,0x63a80370,0x61e00336,0x7b840121}},	//   _keha, vjen, ynll, _ئاپە, 
   {{0x6d440371,0x2b480012,0xa5080372,0x660401ec}},	//   _jeha, laac_, нела_, ыпла, 
   {{0x6d440373,0x63a80374,0x23280375,0x9f4002cc}},	//   _meha, tjen, нойи_, rokú_, 
   {{0x6d440376,0x63840182,0x63a802e3,0x61e0006f}},	//   _leha, угиа, ujen, wnll, 
   {{0x63a80377,0x7f44034c,0x44240378,0x6d440379}},	//   rjen, _reiq, sqn_, _oeha, 
   {{0x6d44037a,0x0044037b,0x7f44008e,0x63a8037c}},	//   _neha, نیتي_, _seiq, sjen, 
   {{0x63a8037d,0x0464037e,0x321c00ef,0x61e00335}},	//   pjen, _штам, _divy_, rnll, 
   {{0xdb04037f,0x64400380,0x1ec80087,0x23280381}},	//   _ilkö, _iwli, елми_, _џоли_, 
   {{0x7f440382,0x6d440383,0x69d40384,0x64400335}},	//   _veiq, _beha, _omze, _hwli, 
   {{0x61440385,0x6d440386,0x7dd40387,0xbbbc0388}},	//   _сека, _ceha, _küsə, ईस्क, 
   {{0x6d440389,0x2b480012,0x2fd8038a,0x1be800b7}},	//   _deha, faac_, bisg_, едви_, 
   {{0x69d4038b,0x7dd4038c,0x6d44038d,0x1f64038e}},	//   _amze, _müsə, _eeha, _ским, 
   {{0x6d44038f,0x224c0390,0x9b040391,0xdb0400d5}},	// [1e0] _feha, nsek_, узад, _boká, 
   {{0x6d440392,0x98a40393,0x64400394,0x00000000}},	//   _geha, лизе, _owli, --, 
   {{0xdb040214,0x9f040395,0x00000000,0x00000000}},	//   _doká, _جوکو, --, --, 
   {{0x6d440396,0x224c0397,0x69d40202,0x2b48028b}},	//   _zeha, ksek_, _emze, caac_, 
   {{0x6d440398,0x64400399,0xdb0400e3,0x224c039a}},	//   _yeha, _awli, _alkö, jsek_, 
   {{0xf4840046,0x64400323,0x6d4401aa,0x2570039b}},	//   لابی, _bwli, _xeha, يۇقس, 
   {{0x321c0078,0x6d40014e,0xd3240027,0x044001c3}},	//   _rivy_, ðlai, льпи, бејн, 
   {{0xd468039c,0x321c039d,0x3254039e,0x43800121}},	//   _җиде_, _sivy_, авир, ملىق, 
   {{0x8230039f,0x64400037,0xdb040191,0x224c03a0}},	//   یریا, _ewli, _elkö, gsek_, 
   {{0x60200025,0x64400323,0x2fd80086,0x867800ca}},	//   _lēmu, _fwli, wisg_, _ארמו, 
   {{0x46100063,0x09f40107,0x6d4403a1,0x936403a2}},	//   _اولر, רמים_, _reha, _مٿان, 
   {{0x6d4403a3,0xf4840122,0x2fd80177,0x00000000}},	//   _seha, _ماڵی, uisg_, --, 
   {{0x6d4403a4,0x224c00d5,0x2fd80306,0x00000000}},	//   _peha, csek_, risg_, --, 
   {{0x313400fc,0x709403a5,0x6d4402bb,0x2b48028b}},	//   _текр, _вакф, _qeha, waac_, 
   {{0x48bc02fa,0xdb0400b8,0x46d8025c,0x2b48028b}},	//   _আশ্র, _roká, _मेनह, taac_, 
   {{0x6d4403a6,0xdb040191,0x4ea403a7,0x6e980094}},	//   _weha, _soká, _броа, _авир_, 
   {{0x6d4403a8,0x2b4803a9,0x2d840045,0xdb0403aa}},	// [1f0] _teha, raac_, ôles_, _poká, 
   {{0x2b4803ab,0x6d4402b0,0xd00c01ac,0x00000000}},	//   saac_, _ueha, _بلڊ_, --, 
   {{0x765c00cb,0xdb0403ac,0x224c03ad,0x00000000}},	//   _ārya, _voká, zsek_, --, 
   {{0xe71803ae,0xdcfc002f,0x224c03af,0xe75803b0}},	//   نيات_, _napę, ysek_, тиді_, 
   {{0x98a80059,0x644000fb,0xdb040247,0xdd0c0055}},	//   ējām_, _swli, _toká, _kışa, 
   {{0x2d9003b1,0x69d4009d,0xdb040085,0xefc8001d}},	//   ndze_, _umze, _bokæ, _አዛዥ_, 
   {{0x2d900047,0x2bc8022d,0x00000000,0x00000000}},	//   idze_, रसपा, --, --, 
   {{0x7c2803b2,0xe3b003b3,0x7dd403b4,0x00000000}},	//   ídri, ترت_, _vüsə, --, 
   {{0x779003b5,0xae1403b6,0xa2340007,0xa1c402ac}},	//   _ریوا, णगान_, шэйш, ибид, 
   {{0x224c03b7,0x00000000,0x00000000,0x00000000}},	//   rsek_, --, --, --, 
   {{0x224c03b8,0xa0680294,0x600803b9,0x02a403ba}},	//   ssek_, њама_, кном_, _әрем, 
   {{0x2d9003bb,0x224c03bc,0x9f8000d3,0x00000000}},	//   edze_, psek_, _tóí_, --, 
   {{0x2bc800b6,0x21a403bd,0x00000000,0x00000000}},	//   रसना, _вилм, --, --, 
   {{0x629803be,0x2dc40049,0xdcfc03bf,0x00000000}},	//   _irwo, йқын_, _zapę, --, 
   {{0xdd0c0333,0x5ea401a0,0x51b40100,0x00000000}},	//   _dışa, _چمبل, _כּהן_, --, 
   {{0xb7b002fa,0x5ea40012,0x69d8000b,0x2d9001d4}},	//   _কষ্ট, _نمبل, èwen, adze_, 
   {{0x5d7402dc,0x00000000,0x00000000,0x00000000}},	// [200] _кунф, --, --, --, 
   {{0x200003c0,0x27ec0237,0x2038001d,0x00000000}},	//   llki_, _ĉena_, _የተተከ, --, 
   {{0xdca403c1,0xdb04034a,0x27e801e3,0x5fb80192}},	//   _тани, _alkô, еan_, _उकाल, 
   {{0x629802b0,0xed0400c3,0x6d4003c2,0xd9e00030}},	//   _orwo, _دوپپ, ðlav, _खदकत_, 
   {{0x23a803c3,0x958400e7,0xdd0c0152,0x00000000}},	//   कानद, илде, _yışa, --, 
   {{0xd9b800b8,0x00000000,0x00000000,0x00000000}},	//   _рымч_, --, --, --, 
   {{0x92e00301,0xfcd802b4,0x44a003c4,0x48e003c5}},	//   _ধরে_, _ጭቡጥ_, قموق, _дорв, 
   {{0x672c0105,0x00000000,0x00000000,0x00000000}},	//   ñajt, --, --, --, 
   {{0x95a400dd,0xd62802d1,0x00000000,0x00000000}},	//   _پٽان, _розе_, --, --, 
   {{0xda1403c6,0xddd400b0,0x145800fc,0x629803c7}},	//   थगित_, _asyž, _ашды_, _drwo, 
   {{0x60cc0181,0x629803c8,0xc95002c3,0x938801ec}},	//   _ƙama, _erwo, חמת_, _асла_, 
   {{0x03a003c9,0x225800ef,0x43d000e2,0x00000000}},	//   _михо, šska_, _وڅيړ, --, 
   {{0xf19403ca,0xd1c801c4,0x94a800ec,0x00000000}},	//   _гиль, _илде_, _ятҡа_, --, 
   {{0x2d9003cb,0x200003cc,0xdcfc01d4,0x00d403cd}},	//   udze_, alki_, _dopľ, ابیت_, 
   {{0x705403ce,0xf2e802fa,0x2d9003cf,0xac940027}},	//   _انبا, _পরিণ, rdze_, щавш, 
   {{0x23a803d0,0x00000000,0x00000000,0x00000000}},	//   कायद, --, --, --, 
   {{0x290403d1,0x37dc0252,0xe97803d2,0x21280031}},	// [210] _šla_, যকাৰ, лбаш_, _şahi_, 
   {{0x09c000b8,0x00000000,0x00000000,0x00000000}},	//   әаҧҟ, --, --, --, 
   {{0x6d400270,0xbef803d3,0x65bc0249,0xa4200143}},	//   ðlau, _مریض_, _wèhk, _নব্য_, 
   {{0xdc98007c,0x7d0800b6,0x00000000,0x00000000}},	//   _עירל, üdse, --, --, 
   {{0xc984009e,0x466803d4,0x27e800cf,0xdb0402a0}},	//   _куви, трем_, ĵan_, _rokç, 
   {{0x7c9403d5,0x65bc0249,0xdcfc00aa,0x5f080030}},	//   _اشیا, _kèhi, _napě, _सरस्_, 
   {{0x23d403d6,0xf87001d4,0x00000000,0x00000000}},	//   йцир, ľším_, --, --, 
   {{0x92e00252,0x62980078,0xf8700113,0x850000dd}},	//   _ধৰে_, _prwo, žším_, ٽوڊن, 
   {{0xe1f803d7,0x661c0078,0x00000000,0x00000000}},	//   лги_, _èsko, --, --, 
   {{0xa2e403d8,0x944003d9,0xe3b001ac,0x00000000}},	//   _қолд, _کھون, ترڪ_, --, 
   {{0x66e401c4,0x349403da,0x00000000,0x00000000}},	//   _тоҡа, _мафр, --, --, 
   {{0x9f400113,0x3b7c001d,0x629803db,0x98780100}},	//   boký_, _ቢሮዎች_, _trwo, נארט, 
   {{0xcd3c03dc,0x62980172,0x33f401b8,0x828403dd}},	//   ﯨﻨﯩﯔ_, _urwo, _بسلس, _خجال, 
   {{0xa06803de,0x8e04021d,0xdc680094,0x00000000}},	//   _бака_, йняв_, лагд_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf2e8007e,0xdcfc03df,0xdca401d9,0x1868018f}},	//   _পৰিণ, _topľ, _ғами, ғади_, 
   {{0x62880335,0x0b4001c7,0x765c004f,0x00000000}},	// [220] nweo, янтн, _āryo, --, 
   {{0x5d8403e0,0xf1c003e1,0x6d4003e2,0x00000000}},	//   _الدل, एसएन, ðlat, --, 
   {{0x97240075,0x00000000,0x00000000,0x00000000}},	//   مفاو, --, --, --, 
   {{0x98a4002c,0xd62803e3,0xa3d803e4,0x99800192}},	//   _һиге, годе_, डोम_, _tuků_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4d780100,0x9f4003aa,0x00000000,0x00000000}},	//   ָרקע, voký_, --, --, 
   {{0xd39400c3,0xdcfc00ce,0x00000000,0x00000000}},	//   йәдә_, _nopļ, --, --, 
   {{0x136802ed,0xb6c403e5,0x62880086,0xdef401da}},	//   ушки_, _мөлд, fweo, ለሞን_, 
   {{0x9f4003e6,0x023401b8,0x00000000,0x00000000}},	//   hokó_, یثیت_, --, --, 
   {{0x9f400212,0x272c02b2,0xd9f803e7,0x779000e3}},	//   roký_, _tónó_, ्तित_, _ریڈا, 
   {{0x9f400212,0x672c03e8,0x39580085,0x344802dc}},	//   soký_, žaje, _mdrs_, _тӯли_, 
   {{0x926803e9,0x00000000,0x00000000,0x00000000}},	//   _брка_, --, --, --, 
   {{0x63ac007f,0xa3d403ea,0xd9f803eb,0xdcfc0095}},	//   _òana, सफर_, ्तात_, _āyāt, 
   {{0xea00001c,0xe2a80012,0x2b94000d,0x00000000}},	//   _đắp_, _خامن_, _ục_, --, 
   {{0x6ae003ec,0x8d840197,0x00000000,0x00000000}},	//   पप्र, _һунд, --, --, 
   {{0x3958015e,0x27ec00cf,0x4fc401ec,0xeb3803d6}},	//   _adrs_, _ĉeno_, _ысла, рзаш_, 
   {{0x8d840254,0x6d4003ed,0xdd8c00e3,0x00000000}},	// [230] _лунд, ðlas, رڈی_, --, 
   {{0x6f0c03ee,0x9f400110,0x248803ef,0x49b803f0}},	//   _izac, bokó_, łami_, دارد_, 
   {{0x2fc803f1,0x645c03f2,0x6d4003f3,0x7c0400c3}},	//   _klag_, _āsio, ılad, زبېك, 
   {{0x6e3c03f4,0x00000000,0x00000000,0x00000000}},	//   opsb, --, --, --, 
   {{0xe61003f5,0x00000000,0x00000000,0x00000000}},	//   وشت_, --, --, --, 
   {{0x6f0c03f6,0x00000000,0x00000000,0x00000000}},	//   _mzac, --, --, --, 
   {{0x628803f4,0x6aac028b,0xa50803f7,0x00000000}},	//   wweo, lxaf, шека_, --, 
   {{0x057403f8,0xd24c00e2,0x395801d1,0x6f0c02b0}},	//   _گارد, چني_, _zdrs_, _ozac, 
   {{0x27ec03f9,0x6f0c00ba,0x6aac03fa,0xd24c0272}},	//   _ijen_, _nzac, nxaf, نني_, 
   {{0x057403fb,0x2fc803fc,0x3958005e,0x22580113}},	//   _دارد, _alag_, _xdrs_, šsko_, 
   {{0x6f0c03fd,0x2fc803fe,0xe10803ff,0x6e3c0400}},	//   _azac, _blag_, ренд_, epsb, 
   {{0x2fc80401,0xf3f00075,0x00000000,0x00000000}},	//   _clag_, _كأن_, --, --, 
   {{0xb92400b8,0x6f0c0098,0x21280101,0xdb140402}},	//   resẽ_, _czac, _şahu_, ücün, 
   {{0x6f0c0403,0x27ec01df,0x6aac028b,0xf1940027}},	//   _dzac, _ljen_, dxaf, _ничь, 
   {{0x6f0c0404,0x2fc80405,0xc1000094,0x00000000}},	//   _ezac, _flag_, _хүнл, --, 
   {{0x27ec0406,0x6d400407,0x2fc80408,0xdee40409}},	//   _njen_, ðlar, _glag_, _мойи, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [240] --, --, --, --, 
   {{0x27ec040a,0xdd04040b,0x00000000,0x00000000}},	//   _ajen_, şqın, --, --, 
   {{0x2b5800c2,0x2fc80151,0x27ec040c,0x00000000}},	//   _fdsc_, _ylag_, _bjen_, --, 
   {{0xdb040223,0x00000000,0x00000000,0x00000000}},	//   _mokú, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x27ec040d,0xd1bc0020,0x7bc4028d,0x1dcc040e}},	//   _ejen_, ቶታት_, lkiu, होचत, 
   {{0x94a8040f,0xb17c01c6,0xa8640197,0x00000000}},	//   ртла_, niĥe, _нерҙ, --, 
   {{0x27ec0410,0x7bc40023,0xc3240411,0x440000cc}},	//   _gjen_, nkiu, يكىن_, мчыб, 
   {{0x7bc4028d,0xd5740027,0x00000000,0x00000000}},	//   ikiu, _мужь, --, --, 
   {{0x2fc80412,0x05600413,0xe6d40094,0x00000000}},	//   _slag_, _овун, _эцсэ, --, 
   {{0x2fc80414,0x6f0c002f,0x7bc40415,0xc1b40094}},	//   _plag_, _szac, kkiu, цлэх_, 
   {{0xea000014,0xdb0402cc,0xac540020,0x00000000}},	//   _đập_, _dokú, ዝኣብሄ, --, 
   {{0x2fc80416,0x2bdc00aa,0x00000000,0x00000000}},	//   _vlag_, नोफा, --, --, 
   {{0x6e3c0417,0x7dd001c5,0x6f0c01d4,0x25dc025c}},	//   rpsb, _läsf, _vzac, कोपी_, 
   {{0x6194009d,0x00000000,0x00000000,0x00000000}},	//   _راوړ, --, --, --, 
   {{0x2fc800df,0x6e3c0418,0x6aac028b,0xa5bc00a8}},	//   _ulag_, ppsb, txaf, _puųk, 
   {{0x6d400419,0xfd680247,0x2b58000d,0x6f0c041a}},	// [250] ılab, nesỹ, _vdsc_, _uzac, 
   {{0x27ec0351,0x88c4041b,0xad4000e7,0x2a84001d}},	//   _sjen_, يتال, _سۉرۉ, ርተኞች_, 
   {{0x6e2c01ba,0x6e24041c,0x48a8041d,0x6aac041e}},	//   _huab, _iihb, штам_, sxaf, 
   {{0x6e2c041f,0xdb040229,0x7bc40420,0x8b640249}},	//   _kuab, _lokù, ckiu, _بادم, 
   {{0xe5a40421,0x27ec0422,0xf7700423,0x25a401f1}},	//   зили, _vjen_, ضان_, _pnll_, 
   {{0x6e2c0424,0x6e240156,0x00000000,0x00000000}},	//   _muab, _jihb, --, --, 
   {{0xc4440191,0x27ec0425,0x60cc01e7,0x69c400e2}},	//   زیشن_, _tjen_, _ƙamm, mkhe, 
   {{0x89d403a2,0x6e240140,0xd5e001d7,0x6e2c0426}},	//   _اوڀر_, _lihb, twọ, _ouab, 
   {{0x6e2c0271,0x6728017b,0x03a00427,0x00000000}},	//   _nuab, _igej, зиқо, --, 
   {{0xdb04018b,0x6e240428,0x7bc40054,0xbbb80098}},	//   _pokú, _nihb, zkiu, _इक्क, 
   {{0xa0a40429,0x6e2c0177,0x2a68042a,0x7bc40007}},	//   чанд, _auab, huab_, ykiu, 
   {{0x6e2c042b,0x27fc0426,0x547800ca,0x69c4042c}},	//   _buab, nown_, _לטעו, hkhe, 
   {{0x6e2c042d,0xdb040010,0x6e240140,0x6728042e}},	//   _cuab, _enkê, _bihb, _mgej, 
   {{0x69c4042f,0x6e2c0430,0x20540431,0x7dd0006b}},	//   jkhe, _duab, _етир, _mäsg, 
   {{0x7bc40322,0xc18001b8,0x1d0803a7,0x63b80432}},	//   tkiu, _فیکٹ, севи_, _kown, 
   {{0x61e00433,0x67280434,0x69c40435,0x236c0436}},	//   lill, _ngej, ekhe, ngej_, 
   {{0xc0400090,0x61e00437,0x6e2c0438,0x63b80086}},	// [260] _የተባለ, oill, _guab, _mown, 
   {{0x6e24008e,0x63b8011a,0x6d400439,0x6728043a}},	//   _gihb, _lown, ılac, _agej, 
   {{0x60c001ec,0x27fc043b,0x00000000,0x00000000}},	//   nylm, fown_, --, --, 
   {{0x3ea0043c,0x27fc0353,0x88b002ac,0x00000000}},	//   _krit_, gown_, ریقچ, --, 
   {{0xd5b8043d,0x3f8000dd,0x2a6801f3,0x60c0043e}},	//   йск_, _mbiu_, cuab_, hylm, 
   {{0x61e0043f,0x67280091,0x95f403ef,0xa3d80440}},	//   jill, _egej, इवेट_, डोस_, 
   {{0x63b80335,0x672c00b0,0x741402cf,0x00000000}},	//   _bown, žaja, ووتا, --, 
   {{0xb9e80422,0x660c036b,0x61e00441,0x60c000df}},	//   _ዮም_, ïakr, eill, dylm, 
   {{0x63b80442,0x5928011a,0xdb0400d3,0xe7e00030}},	//   _down, _སྔོས_, _pokù, _खगता_, 
   {{0x61e00443,0x3f800034,0x63b802b0,0x6e2c0306}},	//   gill, _abiu_, _eown, _ruab, 
   {{0x6e240444,0x3ea00445,0x6e2c0446,0x853800ca}},	//   _rihb, _arit_, _suab, _הגבי, 
   {{0x3ea00447,0x61e00448,0x6e240449,0x95c8044a}},	//   _brit_, aill, _sihb, _куçа_, 
   {{0x6e240380,0x23a8044b,0x3ea00426,0xe2a800dd}},	//   _pihb, कारद, _crit_, _واهن_, 
   {{0x61e0044c,0x6e2c044d,0x3ea0044e,0x6e240140}},	//   cill, _vuab, _drit_, _qihb, 
   {{0x3ea0044f,0x6e240380,0x60c002b0,0x7c840450}},	//   _erit_, _vihb, cylm, нуте, 
   {{0xcf240451,0x3ea00452,0x6e2c0453,0x2a680454}},	//   _عربي, _frit_, _tuab, tuab_, 
   {{0x3ea00455,0xadf40456,0x46d80457,0x7dd000fc}},	// [270] _grit_, _опиш, _मेंह, _bäsd, 
   {{0xfbd00191,0xfb3401a7,0x8a9001eb,0x069000d5}},	//   پتہ_, _үнээ, nộim, ہاتھ, 
   {{0x69c40458,0x2a680069,0x2d8001d6,0x00000000}},	//   rkhe, suab_, _ibhe_, --, 
   {{0x69c40459,0x7dd000fc,0xda6400dd,0x00000000}},	//   skhe, _päsg, _ڪاٽي, --, 
   {{0x27fc045a,0x63b8045b,0x61e0045c,0x2608006c}},	//   rown_, _rown, yill, ितली_, 
   {{0xd124045d,0x61e0045e,0x63b803c7,0x27fc006f}},	//   _لم_, xill, _sown, sown_, 
   {{0xdb04029f,0x63b8045f,0xf6740094,0x00000000}},	//   _ankè, _pown, _үгсэ, --, 
   {{0x29100460,0x6728017b,0xf7940254,0x61e00461}},	//   _izza_, _ugej, _пасэ, will, 
   {{0x61e00462,0x248800df,0x61440123,0xc6a401e3}},	//   till, ňam_, мепа, _эрви, 
   {{0x61e00463,0x7dd00464,0x3ea00020,0x20c4021d}},	//   uill, _käse, _rrit_, дйом, 
   {{0x61e00465,0x7dd00466,0x00000000,0x00000000}},	//   rill, _jäse, --, --, 
   {{0x61e00467,0x94240468,0xdee40469,0x60c001ec}},	//   sill, _قولۇ, доми, rylm, 
   {{0x7dd0046a,0x9f40046b,0xe06003b5,0x00000000}},	//   _läse, kokö_, رێکی, --, 
   {{0x61e0046c,0xbb2c046d,0x2910007b,0x3ea0046e}},	//   qill, ﻧﺪﻩ_, _ozza_, _vrit_, 
   {{0x9f400020,0x7dd001c8,0x3ea0046f,0x00000000}},	//   nikë_, _näse, _writ_, --, 
   {{0xea000014,0x3ea00470,0xdb04000b,0x00000000}},	//   _đạp_, _trit_, _unkë, --, 
   {{0x3ea00471,0x29100472,0x2ca00086,0x2fd8018c}},	// [280] _urit_, _azza_, _erhd_, ërge_, 
   {{0x7dd0012b,0x4e00001e,0xea940182,0x260c0098}},	//   _bäse, _изыб, эшсэ, _ढीली_, 
   {{0xf8a40182,0x9f400222,0x672c00c0,0x00000000}},	//   эгжү, jikë_, ľajn, --, 
   {{0xbb2c03dc,0x6aa80091,0x672c0473,0x2bdc0474}},	//   ﻧﺪﻯ_, _šefe, žajn, नोदा, 
   {{0x29100472,0x7dd0012b,0xdb0400f2,0x00000000}},	//   _ezza_, _täsd, _onké, --, 
   {{0x9f400475,0x00000000,0x00000000,0x00000000}},	//   fikë_, --, --, --, 
   {{0x9f8001ca,0x438000c3,0x629c0056,0x00000000}},	//   _dóú_, چلىق, æson, --, 
   {{0x43800476,0xdb0400f2,0xa3d80477,0x00000000}},	//   نلىق, _anké, डोल_, --, 
   {{0x248400ba,0xd1640348,0xdcfc00d4,0xc040001d}},	//   _eplm_, мъни, _kapē, _የተቻለ, 
   {{0x7dd00478,0x056001d9,0x00000000,0x00000000}},	//   _läsb, _авфн, --, --, 
   {{0x1cd8011a,0xdcfc015b,0x00000000,0x00000000}},	//   ྡགས_, _mapē, --, --, 
   {{0x7dd00479,0x9f4000f1,0xdb04047a,0x68e00031}},	//   _näsb, nikè_, _enké, _ýlde, 
   {{0x441800b9,0xc7b0047b,0xff04047c,0xa3bc0098}},	//   _וואס, דבר_, вярн, ीघर_, 
   {{0x224802e6,0x00000000,0x00000000,0x00000000}},	//   _çaka_, --, --, --, 
   {{0xc04c0041,0xac18047d,0x65c4024b,0xc17000ca}},	//   _ші_, зову_, ﯩﺰﯨﻠ, _יחס_, 
   {{0x7dd001c8,0x7b64047e,0xc0c8047f,0x00000000}},	//   _räse, ктуе, _አካሉ_, --, 
   {{0x9f4002b4,0x98b800a2,0xbdf801ac,0x00000000}},	// [290] zikë_, kapē_, _ڪريا_, --, 
   {{0x7dd0013b,0x2d800095,0xac9401c3,0x00000000}},	//   _päse, _ubhe_, _заош, --, 
   {{0xbb2c0480,0x6ce40481,0x00000000,0x00000000}},	//   ﻧﻪﻥ_, _سزدە, --, --, 
   {{0x6d540482,0x1adc007e,0xdb040247,0x7dd001c9}},	//   laza, _ভঁৰা, _hoký, _väse, 
   {{0x24840483,0xa564032a,0x672c01f6,0x7fd80100}},	//   _splm_, فگان, žajo, וואס_, 
   {{0x6d540484,0x9f400422,0xdcec0007,0x6b8c0485}},	//   naza, tikë_, gebė, leag, 
   {{0x26c80486,0x29100472,0x67d4021c,0x7dd0002a}},	//   šao_, _uzza_, _зову, _häsc, 
   {{0x6b8c0487,0x6d540488,0x7dd00489,0x9f4002b4}},	//   neag, haza, _käsc, rikë_, 
   {{0x6014048a,0xcaa002b4,0x6b8c0331,0x21740123}},	//   náme, _ወጺኦም_, ieag, нунр, 
   {{0x6b8c048b,0x7dd0048c,0x9f4002bb,0x00000000}},	//   heag, _mäsc, pikë_, --, 
   {{0x7dd0048d,0x6d54048e,0x6b8c048f,0x9f400490}},	//   _läsc, daza, keag, liké_, 
   {{0xc0c80491,0x6b8c01e3,0x00000000,0x00000000}},	//   _አካል_, jeag, --, --, 
   {{0x6d540332,0x712400cd,0x6d400492,0x7dd001ab}},	//   faza, ٹریل, ılan, _näsc, 
   {{0x6b8c00a0,0x00800152,0x00000000,0x00000000}},	//   eeag, _аккү, --, --, 
   {{0x6b8c0493,0x9f400249,0xdb0401d4,0x48c00143}},	//   feag, hiké_, _doký, ্পুর, 
   {{0x6b8c0331,0x7dd00202,0x00000000,0x00000000}},	//   geag, _bäsc, --, --, 
   {{0x20000494,0x7dd001c9,0xdcfc00ce,0x80c00061}},	// [2a0] moki_, _väsb, _papē, _سمکۆ, 
   {{0x20000495,0x7dd00496,0x8d740121,0xa7340020}},	//   loki_, _däsc, _كاپا, _ብሓፈሻ, 
   {{0x6b8c0497,0x7dd00152,0x00000000,0x00000000}},	//   beag, _täsb, --, --, 
   {{0x20000498,0x2ca40499,0x48c000ac,0x6014049a}},	//   noki_, ælde_, ্পূর, lámb, 
   {{0x7dd0049b,0x601400c4,0xdcfc00ce,0x69d000d4}},	//   _gäsc, cáme, _tapē, _ūdeņ, 
   {{0x2000049c,0x38c8049d,0x00000000,0x00000000}},	//   hoki_, _قازی_, --, --, 
   {{0x2000049e,0x046000fc,0x765c004f,0x00000000}},	//   koki_, гтым, _āryu, --, 
   {{0x6d54049f,0x601400c4,0x200004a0,0x00000000}},	//   zaza, hámb, joki_, --, 
   {{0x6d5404a1,0x9f400324,0x281000c3,0x00000000}},	//   yaza, ciké_, _ئۈنس, --, 
   {{0x6b8c01a7,0xb9e4010f,0x74a00121,0x362401b8}},	//   zeag, _ጫና_, _ﺋﯧﭽﯩ, _شواہ, 
   {{0xc05404a2,0x2000038f,0xdb0404a3,0x6d5404a4}},	//   нія_, foki_, _kokó, vaza, 
   {{0x6d5404a5,0x6b8c0182,0xdb040031,0xd65c021d}},	//   waza, xeag, _soký, _вiдд, 
   {{0x6d5404a6,0xdb0404a7,0x6014000f,0x6b8c04a8}},	//   taza, _mokó, xáme, veag, 
   {{0xdb0404a9,0x2bc804aa,0x717404ab,0x601404ac}},	//   _dokü, रस्थ, _شهبا, váme, 
   {{0x6d5404ad,0x200004ae,0x6b8c04af,0xc19804b0}},	//   raza, boki_, teag, _משגי, 
   {{0x6d5404b1,0x2000017b,0xfc300272,0x7dd0000b}},	//   saza, coki_, صحف_, _päsc, 
   {{0x6b8c04b2,0x764002ba,0x00000000,0x00000000}},	// [2b0] reag, _ntmy, --, --, 
   {{0x601404b3,0x6b8c04b4,0x59280126,0xd9f804b5}},	//   ráme, seag, _སྔངས_, ्तगत_, 
   {{0x7dd004b6,0x636001d7,0x76400031,0x9f400249}},	//   _wäsc, ịnii, _atmy, wiké_, 
   {{0x7dd00202,0x9f400249,0x6b8c018f,0x377404b7}},	//   _täsc, tiké_, qeag, гышс, 
   {{0x2b4802ea,0xdb04012b,0x00000000,0x00000000}},	//   mbac_, _xokü, --, --, 
   {{0x200004b8,0x2a6801a0,0xa50804b9,0x77a801b5}},	//   zoki_, mrab_, мела_, ٘ێہہ_, 
   {{0x200004ba,0xd5ac04bb,0x7640007b,0x23f402dc}},	//   yoki_, تہٕ_, _etmy, кчиё, 
   {{0xa82403b5,0x200000e2,0x66640012,0xe3b00075}},	//   _شکان, xoki_, _لُرٕ, شرب_, 
   {{0x7dd004bc,0x200004bd,0x2a6804be,0x65940329}},	//   _läsa, voki_, nrab_, _иаау, 
   {{0x2000007b,0xd5840061,0x25dc00bd,0x00000000}},	//   woki_, _لێهه_, कोशी_, --, 
   {{0x200004bf,0x2a68018f,0x7dd004c0,0xb928004f}},	//   toki_, hrab_, _näsa, _byuṅ_, 
   {{0x644004c1,0x25dc04c2,0x23e804c3,0x22480475}},	//   _itli, कोरी_, _غذای_, _çako_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7dd0012b,0xa06800bf,0xd6540107,0x7a4800d3}},	//   _bäsa, _жака_, כישת_, _létò, 
   {{0x200004c4,0x60cc01e7,0x7dd004c5,0xa0740329}},	//   poki_, _ƙamu, _cäsa, _рылш, 
   {{0x6014000f,0x225803aa,0x6aa804c6,0x2bdc04c7}},	//   sámb, šsku_, _šefa, नोला, 
   {{0x3ae8031b,0x50180107,0x2a6804c8,0x48c00143}},	// [2c0] ربری_, _קופו, grab_, ্পোর, 
   {{0xd94404c9,0x656004ca,0x18a402ac,0x7dd0012b}},	//   тежи, _ndlh, казм, _fäsa, 
   {{0x644004cb,0x2a6801ac,0xdb0404cc,0x00000000}},	//   _ntli, arab_, _pokó, --, 
   {{0x656004cd,0x5b1400e7,0x00000000,0x00000000}},	//   _adlh, _үмүт, --, --, 
   {{0x644004ce,0x320c01ec,0xdb04001e,0x46b4006c}},	//   _atli, yldy_, _vokó, _आपणह, 
   {{0xdb04002f,0x00000000,0x00000000,0x00000000}},	//   _wokó, --, --, --, 
   {{0x799c036b,0x656001c7,0x00000000,0x00000000}},	//   _iarw, _ddlh, --, --, 
   {{0x656004cd,0x799c04cf,0x3298023f,0xb27404d0}},	//   _edlh, _harw, евиќ_, глиш, 
   {{0x644004d1,0x799c04d2,0x87780282,0x313404d3}},	//   _etli, _karw, _קאמי, лепр, 
   {{0x799c04d4,0x5ec40143,0xd5840061,0x00000000}},	//   _jarw, _লেভে, _شێعه_, --, 
   {{0x799c04d5,0xdc8c0422,0x225c013c,0x73c401c4}},	//   _marw, ዝነበረ_, _evwk_, _бәпе, 
   {{0x6d4004d6,0x799c04d7,0x444401b5,0x64980108}},	//   ılam, _larw, _شرمہ, _ятур_, 
   {{0x5ec404d8,0x00000000,0x00000000,0x00000000}},	//   _লেবে, --, --, --, 
   {{0x2d8404d9,0x799c04da,0x7dd004db,0x64400479}},	//   ýle_, _narw, _päsa, _ytli, 
   {{0xf4140282,0x2ca404dc,0x8c340123,0x00000000}},	//   ָפּ_, íld_, тобӣ_, --, 
   {{0x2a6804dd,0xdcfc028d,0x7dd00207,0x04dc004f}},	//   trab_, _lapė, _väsa, _cāṇu, 
   {{0x799c04de,0x2ec400fc,0xdb0400d3,0x00000000}},	// [2d0] _barw, _сөнм, _sokò, --, 
   {{0x6f0c04df,0x2a6804e0,0x799c04e1,0xc27802c3}},	//   _iyac, rrab_, _carw, ורמי, 
   {{0x2d900161,0xd24404e2,0x48c000ac,0x601404e3}},	//   meze_, _گن_, ্প্র, láma, 
   {{0x2d9004e4,0x6f0c007b,0x7dd001c5,0x26780254}},	//   leze_, _kyac, _jäsn, ескэ_, 
   {{0xd24404e5,0x799c04e6,0x644004e7,0x6b9c017d}},	//   _دن_, _farw, _stli, _iasg, 
   {{0x799c04e8,0x2d9004e9,0x6f0c04ea,0x7dd004eb}},	//   _garw, neze_, _myac, _läsn, 
   {{0xfd5000a5,0x6b9c04ec,0x601404ed,0x6d40014e}},	//   _aghụ, _kasg, háma, ðlay, 
   {{0x2d9004ee,0x799c0172,0xe2b80294,0x7d080030}},	//   heze_, _zarw, ећој_, üdsi, 
   {{0x2d9004ef,0x799c019a,0x6f0c04f0,0x6b9c04f1}},	//   keze_, _yarw, _nyac, _masg, 
   {{0x2d9004f2,0x6b9c04f3,0xc0c4001d,0x00000000}},	//   jeze_, _lasg, _ችሏል_, --, 
   {{0x6f0c04f4,0x2d9004f5,0xddc4015b,0x00000000}},	//   _ayac, deze_, jukš, --, 
   {{0x2d9004f6,0xa0a404f7,0x6f0c04f8,0xd24c04f9}},	//   eeze_, _ҡалд, _byac, _کنو_, 
   {{0xdcb004fa,0x6f0c04fb,0x2d9004fc,0x626404fd}},	//   ڭىز_, _cyac, feze_, _свла, 
   {{0x2d9004fe,0x6f0c006f,0x6b9c02b0,0x00000000}},	//   geze_, _dyac, _aasg, --, 
   {{0x6b9c04ff,0xd00c009d,0x6f0c00dc,0x9f4003e6}},	//   _basg, _ډلو_, _eyac, likí_, 
   {{0x799c0500,0x6b9c0501,0xabd40106,0x69d80502}},	//   _sarw, _casg, ацуј, ëwen, 
   {{0xfeb40503,0x60140504,0x799c0505,0x6b9c0506}},	// [2e0] _төнь, cáma, _parw, _dasg, 
   {{0x62980507,0x799c0508,0x6b9c0509,0x3c94050a}},	//   _mswo, _qarw, _easg, _پیرز, 
   {{0x6b9c050b,0x799c0403,0x47c800e2,0x00000000}},	//   _fasg, _varw, کالۍ_, --, 
   {{0x799c050c,0x6b9c0336,0xb8cc00d1,0x62980098}},	//   _warw, _gasg, _कछ_, _oswo, 
   {{0x799c050d,0x629803f2,0xdcfc028d,0xa5bc00a8}},	//   _tarw, _nswo, _papė, _puųp, 
   {{0xd498050e,0x9f8000d3,0x7dd002d9,0xd1d4001d}},	//   ери_, _kóó_, _mäso, ርቱት_, 
   {{0x6298018c,0x6b9c03af,0x9484050f,0x9f8000f2}},	//   _aswo, _yasg, уылд, _jóó_, 
   {{0x2d900510,0x88f0004b,0x6298011a,0x9f40008b}},	//   zeze_, _آفت, _bswo, fikí_, 
   {{0x15440511,0x2d900512,0x7dd001c5,0x00000000}},	//   _безм, yeze_, _näso, --, 
   {{0x6f0c0211,0x60140105,0x2d900513,0x31540123}},	//   _ryac, váma, xeze_, швоё, 
   {{0x62980078,0xe4740007,0x2ba40203,0x6f0c01ab}},	//   _eswo, _вучэ, _ऑफला, _syac, 
   {{0x2d900514,0x8f4402b3,0xb4c00515,0xdb0400d3}},	//   weze_, ыход, ँही_, _onkà, 
   {{0x6b9c0516,0x7dd001c5,0x00000000,0x00000000}},	//   _rasg, _väsn, --, --, 
   {{0x6f0c0517,0x6aa80518,0x6b9c0519,0x6014051a}},	//   _vyac, _šefo, _sasg, ráma, 
   {{0x6b9c051b,0x5064028e,0x80a00324,0xac94051c}},	//   _pasg, _стла, _همون, шавш, 
   {{0x2d90051d,0x672c03e8,0x6b9c0428,0x7dd00139}},	//   seze_, žaji, _qasg, _häsl, 
   {{0xeb98051e,0x2d90051f,0x6b9c0520,0x6f0c0521}},	// [2f0] ниң_, peze_, _vasg, _uyac, 
   {{0x6b9c0522,0xa2c40523,0x00000000,0x00000000}},	//   _wasg, िहत्, --, --, 
   {{0x6b9c0524,0x84e0025c,0x7dd00087,0x00000000}},	//   _tasg, _केंट_, _mäsl, --, 
   {{0x6b9c0272,0x7dd001c5,0x00000000,0x00000000}},	//   _uasg, _läsl, --, --, 
   {{0x200c0271,0x9f800223,0x00000000,0x00000000}},	//   _ɔfi_, _kóò_, --, --, 
   {{0xe4c40525,0xe5a40526,0x7dd00527,0x9f800528}},	//   ийли, рики, _näsl, _yóó_, 
   {{0x23d40529,0xdb0400cd,0xd85400fc,0x69d400ce}},	//   ицир, _inká, _весө, _ilze, 
   {{0xea0001c0,0x6264052a,0x9f40052b,0x57b00200}},	//   _đẹp_, авиа, tikí_, _мұхт, 
   {{0x7dd001ec,0x766800e2,0x00000000,0x00000000}},	//   _bäsl, _مینې_, --, --, 
   {{0xa3d80203,0x5bd0052c,0x1b000143,0xd1c4044a}},	//   डोज_, _सत्व, লেকে_, илые_, 
   {{0x7dd0046a,0xa068052d,0xdb0c02e8,0x00000000}},	//   _säso, ъана_, ádúg, --, 
   {{0x6298052e,0x6fcc0028,0x5438007c,0x944000d5}},	//   _tswo, _jûch, _סענא, _بھون, 
   {{0x442c052f,0x7dd00031,0x3344006b,0xdde801d9}},	//   _iig_, _fäsl, _уҗым_, نرسه_, 
   {{0x442c0530,0xdb04019f,0x5c9002b4,0x1c4401a0}},	//   _hig_, _kokö, _ምልክታ_, ингм, 
   {{0x442c0531,0x1d080532,0x3f840030,0xe0d001b5}},	//   _kig_, теви_, õmus_, _گٲں_, 
   {{0x69d40533,0x442c0534,0xdb040116,0x6014000f}},	//   _alze, _jig_, _mokö, mámo, 
   {{0x442c0535,0x3d1c0223,0xdcfc00a8,0x3964018f}},	// [300] _mig_, _báwí_, _kapī, йнаҳ, 
   {{0x442c0536,0x9c580108,0x7dd00030,0x9f800537}},	//   _lig_, _ишму_, _käsm, _tóó_, 
   {{0x442c0538,0x6fcc0539,0xa2d4053a,0xdcfc015b}},	//   _oig_, _bûch, मैत्, _mapī, 
   {{0x442c053b,0xcc38007c,0x7dd0012b,0xdcfc015b}},	//   _nig_, _שעכט, _mäsm, _lapī, 
   {{0x7c24053c,0x9f80053d,0x2d840128,0x3c3c00d5}},	//   mmir, _yóò_, òleg_, _hív_, 
   {{0x442c053e,0x7c24038c,0x98a4053f,0xdc2c02a0}},	//   _aig_, lmir, _киге, _yığn, 
   {{0x442c0540,0x3958000b,0xb4c000a1,0x550403e9}},	//   _big_, _iers_, ँहे_, јчла, 
   {{0x442c0541,0x93880542,0x6fcc0028,0x7c240543}},	//   _cig_, тска_, _gûch, nmir, 
   {{0x442c0544,0x3c3c0545,0x7c240546,0x39580547}},	//   _dig_, _lív_, imir, _kers_, 
   {{0x442c0548,0x39580085,0x867800ca,0x00000000}},	//   _eig_, _jers_, _ברמו, --, 
   {{0x39580549,0x442c054a,0x321c034a,0x6014054b}},	//   _mers_, _fig_, _vhvy_, gámo, 
   {{0x395800cc,0x6e94054c,0xf4840061,0x00000000}},	//   _lers_, биму, _ناڵی, --, 
   {{0xd24c03d9,0x3958054d,0x55f80252,0x7dd00152}},	//   _کنڈ_, _oers_, েগীক_, _täsl, 
   {{0x442c054e,0x3958054f,0x7c24000f,0xbd6800bf}},	//   _zig_, _ners_, emir, ирсе_, 
   {{0x442c0550,0xdb040551,0xf04404c3,0xe20400d5}},	//   _yig_, _mokõ, _اعتی, _ابنٹ, 
   {{0x7c2404ec,0x9f400552,0x69d400ef,0x80f40553}},	//   gmir, rikã_, _slze, _әхәт_, 
   {{0x39580554,0x8d840555,0x69d402ef,0x6fcc0556}},	// [310] _bers_, _кунд, _plze, _rûch, 
   {{0xc6680090,0x7c240557,0x6fcc0010,0x6d98021c}},	//   _አፍሪካ_, amir, _sûch, _своё_, 
   {{0x39580558,0x9f400559,0xb4c00030,0x00000000}},	//   _ders_, liká_, ँहो_, --, 
   {{0x3958055a,0x7c24055b,0xbb9402eb,0x26dc000b}},	//   _eers_, cmir, _дающ, tzwo_, 
   {{0x3958055c,0x2b580043,0xe688055d,0x9f400212}},	//   _fers_, _iesc_, انتى_, niká_, 
   {{0x442c055e,0x3958055f,0x9f800038,0xc9d000ea}},	//   _sig_, _gers_, _lóð_, _بڅرک, 
   {{0xe3b003e0,0xd90c03a2,0x6014000f,0x98a80560}},	//   كرة_, _ٻڌل_, xámo, _rebħ_, 
   {{0x7dd0039c,0x442c0561,0x86e402ac,0x2bf800cb}},	//   _räsm, _qig_, _кўзд, ्किं_, 
   {{0x442c0562,0x36d40563,0x2b580564,0x07500121}},	//   _vig_, _дотр, _mesc_, _ﺋﻪﯓ_, 
   {{0x7c240025,0x442c0426,0x9f4000c0,0x05740565}},	//   zmir, _wig_, diká_, _خارد, 
   {{0x442c0566,0x65140567,0x21a40568,0x29100031}},	//   _tig_, _اوائ, _ҳилм, _jyza_, 
   {{0x42b0009d,0x672c0070,0x442c0569,0x601400ef}},	//   _ولاړ, žaju, _uig_, rámo, 
   {{0x53980107,0x02c0056a,0xe1f001d2,0x00000000}},	//   _תינו, _филү, _ىست_, --, 
   {{0x32b80272,0x2b5802e3,0xdb040329,0x7dd0021c}},	//   _خدمة_, _aesc_, _mokô, _täsm, 
   {{0x7c24056b,0x98b80296,0x3958056c,0x91b800ca}},	//   tmir, rapī_, _rers_, _תמצי, 
   {{0x9f80056d,0x2b58056e,0x3958056f,0x7dd00570}},	//   _góð_, _cesc_, _sers_, _käsk, 
   {{0x2b580571,0xeb540572,0x00000000,0x00000000}},	// [320] _desc_, زىلگ, --, --, 
   {{0x7dd00573,0x248803ef,0x601401b8,0x00000000}},	//   _mäsk, łamy_, záml, --, 
   {{0x39580574,0x7dd00575,0x2b580151,0x00000000}},	//   _vers_, _läsk, _fesc_, --, 
   {{0x7f44011a,0x39580335,0x291002e6,0x00000000}},	//   _jfiq, _wers_, _dyza_, --, 
   {{0x39580576,0xada80577,0xe774009f,0xdb0400b8}},	//   _ters_, _صدیق_, zıçı, _pokõ, 
   {{0x7e6401f6,0x0514004f,0xfb8400e3,0x00000000}},	//   _mvip, _hūṃp, _ادھی, --, 
   {{0x66d00191,0x291000fc,0x7f440475,0x9f4002d9}},	//   tókö, _gyza_, _ofiq, ziká_, 
   {{0x7e640578,0x2b5802ba,0x7dd00207,0x544400cc}},	//   _ovip, _xesc_, _bäsk, _ۇنئك, 
   {{0x9f800579,0x6b88012b,0x00000000,0x00000000}},	//   _róð_, _öege, --, --, 
   {{0x1048057a,0x16840122,0x6aa800e9,0xdb0400fc}},	//   лями_, _ناڕێ, _šefk, _inkä, 
   {{0x672c057b,0x7e640095,0x00000000,0x00000000}},	//   žajt, _avip, --, --, 
   {{0x9424057c,0xb4d4057d,0x9f4002d9,0x00000000}},	//   _умее, हनी_, tiká_, --, 
   {{0x7dd0012b,0x7e64004f,0x4ed400dc,0x00000000}},	//   _gäsk, _cvip, সপ্ল, --, 
   {{0x2b58023f,0x604001d7,0xf53801c6,0x7e64057e}},	//   _sesc_, _ịmep, _maĥo_, _dvip, 
   {{0xad24006e,0x25dc057f,0x7dd0012b,0x00000000}},	//   زىرى, कोटी_, _mäsh, --, 
   {{0x1b0002fa,0xdb04000b,0x7dd00207,0x29100580}},	//   লেছে_, _onkä, _läsh, _ryza_, 
   {{0xb4d400bd,0x00000000,0x00000000,0x00000000}},	// [330] हनु_, --, --, --, 
   {{0x2ba80581,0x2b580139,0xeb18006c,0x29100201}},	//   _चोरा, _wesc_, _दरीत_, _pyza_, 
   {{0x8a740155,0xa8980041,0x7e640582,0x998000e5}},	//   риҷӣ_, ркеу_, _zvip, _aukų_, 
   {{0x61c40583,0x2b5800b7,0x998000b0,0x7e64001e}},	//   _लक्ष, _uesc_, _bukų_, _yvip, 
   {{0x25ec0584,0x00000000,0x00000000,0x00000000}},	//   _अगदी_, --, --, --, 
   {{0x3e5c007c,0xd65c044a,0x00000000,0x00000000}},	//   נדוס, _гiод, --, --, 
   {{0x67d40585,0x29040586,0xdb0401c9,0x6d440177}},	//   _дову, _âla_, _enkä, _mfha, 
   {{0x666401b5,0xb7640587,0x25dc0098,0x00000000}},	//   _وُزٕ, _нтуй, कोजी_, --, 
   {{0x6d4401ab,0x622400c3,0x00000000,0x00000000}},	//   _ofha, يىبل, --, --, 
   {{0xd24c0588,0x7dd0046a,0x672c0091,0x7f44011a}},	//   کنی_, _väsk, žajs, _sfiq, 
   {{0x7e640084,0x8c4001ec,0x00000000,0x00000000}},	//   _svip, üşle, --, --, 
   {{0x6d440589,0x24640059,0x1e00058a,0x6234058b}},	//   _afha, mēm_, लक्ष_, _деду, 
   {{0x7dd001ec,0x6304058c,0x6d440509,0x24640059}},	//   _häsi, _بوشل, _bfha, lēm_, 
   {{0x7dd0058d,0x224c058e,0x25dc058f,0xd138012b}},	//   _käsi, mpek_, कोची_, _taƅa_, 
   {{0x8c400590,0x24640059,0x60140113,0x7a300223}},	//   десе, nēm_, námk, _lótì, 
   {{0xb0680591,0x1b480592,0x7dd002cc,0x224c0593}},	//   _اصول_, рзаи_, _mäsi, opek_, 
   {{0x19c40594,0x224c0091,0x80d403ef,0x9a680272}},	// [340] обам, npek_, मनवे, شمال_, 
   {{0x3ea00595,0xca180200,0x00000000,0x00000000}},	//   _isit_, ﻴﺩﺓ_, --, --, 
   {{0x9f0402ac,0x7dd00596,0xd7c40027,0x6d400055}},	//   _دوکو, _näsi, жёло, ılat, 
   {{0x224c0597,0x246400d4,0x3ea001f6,0x7644001e}},	//   kpek_, dēm_, _ksit_, зҭаа, 
   {{0xd5b80598,0x07a0001e,0x9f4002e6,0x00000000}},	//   иск_, ьацн, mikä_, --, 
   {{0x7dd00031,0x9f400087,0x00000000,0x00000000}},	//   _bäsi, likä_, --, --, 
   {{0xb4d40599,0x26080098,0x00000000,0x00000000}},	//   हने_, ाक़ी_, --, --, 
   {{0x7dd0013b,0x6aa8059a,0x98b80007,0xb9e4001d}},	//   _däsi, _šefi, lapį_, _ኩሽ_, 
   {{0x73c401c4,0x7e6000c2,0xfbe8000d,0x00000000}},	//   жәһе, âmpl, _đế_, --, 
   {{0x3f800007,0xcb100107,0xd4680254,0x112800f8}},	//   _aciu_, ולח_, _виже_, июни_, 
   {{0x24640059,0x3ea0024f,0x629c0353,0x00000000}},	//   cēm_, _asit_, æsor, --, 
   {{0x6014059b,0xe80c0095,0x8c40059c,0x00000000}},	//   námh, िकया_, üşme, --, 
   {{0x7dd0019f,0x9f400031,0x00000000,0x00000000}},	//   _zäsi, dikä_, --, --, 
   {{0x8210059d,0x68e000af,0x7dd0012b,0x00000000}},	//   _قونص, _üldg, _yäsi, --, 
   {{0x10140272,0x3ea0059e,0x8bc4059f,0x7dd0012b}},	//   _وبعد, _esit_, осад, _xäsi, 
   {{0x320c05a0,0x9e6401b8,0xb17c0237,0x00000000}},	//   lody_, _کاٹن, riĥu, --, 
   {{0x24640059,0x320c0028,0xfb8400b8,0x00000000}},	// [350] zēm_, oody_, ьырн, --, 
   {{0x7dc405a1,0x320c05a2,0x7a38021d,0x0948041c}},	//   _يقين, nody_, цпфр_, рчаи_, 
   {{0x2d8005a3,0x9f40006b,0x0ffc0030,0x00000000}},	//   _iche_, bikä_, _उदाश_, --, 
   {{0x320c05a4,0x7dd005a5,0xdec002b4,0xda140012}},	//   hody_, _räsi, _ኻልእ_, ٚسۅک, 
   {{0x320c03ef,0x9bb800ca,0x00000000,0x00000000}},	//   kody_, _הצרפ, --, --, 
   {{0x24640025,0x64a405a6,0x572000e7,0x0dc40020}},	//   tēm_, зака, رۉلك, _ጽሓፊ_, 
   {{0x2d8001dc,0xd5ac05a7,0x00000000,0x00000000}},	//   _mche_, طفي_, --, --, 
   {{0x3cfc05a8,0x7dd005a9,0xe3b805aa,0x2fc805ab}},	//   ילונ, _väsi, сби_, _noag_, 
   {{0x27ec05ac,0x320c0364,0x2d8000a5,0x24640059}},	//   _imen_, fody_, _oche_, sēm_, 
   {{0x7dd001ec,0x2d8000a5,0x320c002f,0x3f800100}},	//   _täsi, _nche_, gody_, _sciu_, 
   {{0x601405ad,0x224c05ae,0x2fc801d6,0x9fb4008b}},	//   lámi, spek_, _boag_, māú_, 
   {{0xd8d40240,0x25a40107,0x224c05af,0x27ec0192}},	//   פורט_, _hall_, ppek_, _jmen_, 
   {{0x320c05b0,0x25a405b1,0x02a40254,0x27ec0078}},	//   body_, _kall_, _фрем, _mmen_, 
   {{0x21a405b2,0x25a405b3,0x7dd001c9,0x2d8005b4}},	//   _хикм, _jall_, _läsv, _cche_, 
   {{0x27ec05b5,0x25a400ca,0x91b80107,0x712400bf}},	//   _omen_, _mall_, _למסי, _ۉرۉل, 
   {{0x2d8005b6,0x9e6405b7,0x27ec05b8,0x3ea005b9}},	//   _eche_, _евид, _nmen_, _tsit_, 
   {{0x6d4005ba,0x3ea005bb,0x9b4400cc,0x00000000}},	// [360] ılar, _usit_, _ۉندو, --, 
   {{0x0b4005bc,0x25a405bd,0x27ec05be,0xd7e801c4}},	//   _үнэн, _nall_, _amen_, әмде_, 
   {{0x9b4400cc,0x183402cf,0x00000000,0x00000000}},	//   _ىندو, سراح, --, --, 
   {{0x779405bf,0x291c0181,0x6ac805c0,0x25a405c1}},	//   بیرا, ƙwan_, ðsfó, _aall_, 
   {{0xb4e4021f,0x25a405c2,0x601401ca,0x00000000}},	//   _पेड़_, _ball_, rámh, --, 
   {{0x25a405c3,0x60780090,0x2d800074,0x7ae405c4}},	//   _call_, _በሰጡት_, _xche_, mzit, 
   {{0x25a405c5,0x320c02f6,0x7ae405c6,0x6fdc021f}},	//   _dall_, vody_, lzit, _पतलू, 
   {{0x2ca4020c,0x25a400a1,0x320c05c7,0xc7a005c8}},	//   ældi_, _eall_, wody_, _писк, 
   {{0x7ae405c9,0x320c05ca,0x25a405cb,0x2fc80177}},	//   nzit, tody_, _fall_, _roag_, 
   {{0x2010012d,0x7dd000b6,0x27ec05cc,0x25a405cd}},	//   _akyi_, _käsu, _zmen_, _gall_, 
   {{0x931405ce,0x2fc805cf,0x320c05d0,0xc1b401a7}},	//   _کوشش, _poag_, rody_, члэх_, 
   {{0x2d8005d1,0x25a405d2,0x27ec000d,0x320c05d3}},	//   _sche_, _zall_, _xmen_, sody_, 
   {{0xe80c011e,0x7ae4018c,0x7dd00207,0x3dac01ee}},	//   िकता_, jzit, _läsu, ﻴﻠﯩﻘ, 
   {{0x20100271,0x7ae405d4,0xee200049,0xd6e00201}},	//   _ekyi_, dzit, тегi_, _igłę_, 
   {{0x7ae4018c,0x104801a0,0x622400e7,0x00000000}},	//   ezit, _уяли_, _تووە, --, 
   {{0x7bc402bb,0x00000000,0x00000000,0x00000000}},	//   gjiu, --, --, --, 
   {{0xfd1003d9,0x25ec05d5,0x2d8005d6,0x00000000}},	// [370] نجہ_, _अगली_, _tche_, --, 
   {{0x2d8005b6,0x2ca005d7,0xab90010f,0xd6e00201}},	//   _uche_, _tshd_, ዝበዋል_, _mgłę_, 
   {{0x25a405d8,0x7ae4007b,0x6d540151,0x00000000}},	//   _rall_, azit, mbza, --, 
   {{0x25a405d9,0x6014000f,0xa64c0020,0x7ae40126}},	//   _sall_, támi, _ዝተወደ, bzit, 
   {{0xf77005da,0xe5a405db,0x25a405dc,0x6b8c05dd}},	//   طان_, дили, _pall_, mfag, 
   {{0xd6cc05de,0xf65005df,0x601405e0,0x2f2405e1}},	//   شقى_, ائن_, rámi, _gūgū_, 
   {{0x25a405e2,0x6b8c03f2,0x7dd002eb,0x6aac05e3}},	//   _vall_, ofag, _iäst, lvaf, 
   {{0x7dd005e4,0x27ec05e5,0x25a405e6,0x21280237}},	//   _häst, _umen_, _wall_, _ŝaho_, 
   {{0x644805e7,0x6b8c05cf,0x7dd005e8,0x25a400ca}},	//   _žlič, ifag, _käst, _tall_, 
   {{0x69c4052e,0x7dd005e9,0xe0600122,0xc5f80075}},	//   njhe, _jäst, نێتی, _اعرض_, 
   {{0x7ae405ea,0x7dd0046a,0x6b8c05eb,0x00000000}},	//   zzit, _mäst, kfag, --, 
   {{0x5ec40301,0x7dd005ec,0x68e40593,0xc10000c3}},	//   _লেগে, _läst, izhd, _җүмл, 
   {{0x6b8c05ed,0x216805ee,0xdf00007b,0x71f80012}},	//   dfag, _дили_, kuŋŋ_, _کرنس_, 
   {{0x63a805ef,0x7dd005f0,0x6aac01e3,0x00000000}},	//   lden, _näst, dvaf, --, 
   {{0x628805f1,0xf1a803b5,0x317803ef,0x5ec40143}},	//   lteo, _راوه_, órze_, _লেখে, 
   {{0x7ae401a7,0x7dd0012b,0x00000000,0x00000000}},	//   tzit, _räsu, --, --, 
   {{0x7dd005f0,0x628805f2,0x63a805f3,0x7ae401ac}},	// [380] _bäst, nteo, iden, uzit, 
   {{0x7ae405f4,0x62880272,0x63a805f5,0x22580113}},	//   rzit, iteo, hden, ásky_, 
   {{0x63a80101,0x7ae401b8,0x628805f6,0x6aa8015b}},	//   kden, szit, hteo, _šeft, 
   {{0x63a805f7,0xca7402b4,0x628805f8,0xdb0402bb}},	//   jden, _ኢልኩም_, kteo, _jakë, 
   {{0x7dd0046a,0x63a805f9,0x1dd00030,0x00000000}},	//   _fäst, dden, _हवात, --, 
   {{0x63a805fa,0x7dd005fb,0xdb0402bb,0xaabc00bd}},	//   eden, _gäst, _lakë, ोहरक, 
   {{0x7dd005fc,0x97bc0007,0x287400fc,0x349405fd}},	//   _häss, _краi, _пытр, хайр, 
   {{0x63a8020a,0xb9e80422,0xdef4010f,0x7dd00027}},	//   gden, _ኮም_, ፉልን_, _käss, 
   {{0x3a3805fe,0x7dd00139,0x826001ac,0x00000000}},	//   _kirp_, _jäss, نهين, --, 
   {{0x63a805ff,0x7dd00600,0x764002b0,0xfbe40143}},	//   aden, _mäss, _iumy, নচিত, 
   {{0x63a80601,0x7dd00602,0x62880139,0xc0540103}},	//   bden, _läss, ateo, мія_, 
   {{0x76400603,0x9598001d,0x6aac014e,0x63a8012b}},	//   _kumy, ፊዎችን_, yvaf, cden, 
   {{0x7dd00604,0x62880605,0x764000b0,0x68e40039}},	//   _näss, cteo, _jumy, zzhd, 
   {{0x76400606,0x60140034,0xfe240094,0x00000000}},	//   _mumy, dámu, вьсн, --, 
   {{0x3b4c01e5,0xab94005b,0x76400078,0x7dd00607}},	//   _ọdịk, нављ, _lumy, _räst, 
   {{0xdb040324,0x7dd00104,0x2ba80608,0x8b58059b}},	//   _kakè, _bäss, _चोखा, تجسس_, 
   {{0x69c40609,0x6b8c060a,0x7dd000c0,0x764000e5}},	// [390] tjhe, rfag, _päst, _numy, 
   {{0x63a8060b,0xdb0401e8,0x6aac060c,0xdb24060d}},	//   zden, _makè, rvaf, رولی, 
   {{0x7dd004bc,0x63a8060e,0x77600083,0x61ec060f}},	//   _väst, yden, _bemx, _ïale, 
   {{0x76400610,0x7dd00611,0x2ca405c0,0x63a80008}},	//   _bumy, _fäss, ældu_, xden, 
   {{0x7dd00612,0x63a80613,0x60140034,0xa3d400a1}},	//   _täst, vden, cámu, _सकब_, 
   {{0x63a80614,0xd1240615,0x3a380616,0x00000000}},	//   wden, _مم_, _girp_, --, 
   {{0x23d40617,0x2a6802e3,0x7dd0006b,0x00000000}},	//   ецпр, lsab_, _käsr, --, 
   {{0x63a8038b,0x77600618,0x33f40119,0x601400c0}},	//   uden, _gemx, кчыс, námt, 
   {{0x2a680619,0x7640061a,0x95340087,0x7dd0012b}},	//   nsab_, _gumy, мзәт_, _mäsr, 
   {{0x6288061b,0xdb0400f1,0x21a4061c,0x00000000}},	//   rteo, _dakè, хиом, --, 
   {{0x6288061d,0x63a8061e,0xdb0402b4,0x764000ba}},	//   steo, pden, _pakë, _zumy, 
   {{0x6440061f,0x76400620,0x65600621,0x2a6800a1}},	//   _iuli, _yumy, _helh, ksab_, 
   {{0x64400622,0x65600623,0x2a6801f9,0x201c0059}},	//   _huli, _kelh, jsab_, ēti_, 
   {{0x7dd001c8,0x65600616,0xdca40624,0x9200015b}},	//   _räss, _jelh, наги, _žāva, 
   {{0x65600625,0x64400626,0xdb0402bb,0x00000000}},	//   _melh, _juli, _takë, --, 
   {{0x64400627,0x3a380628,0xdb04008f,0x65600629}},	//   _muli, _sirp_, _haké, _lelh, 
   {{0x6440062a,0x89d4062b,0x9b04062c,0x00000000}},	// [3a0] _luli, کولر_, хзад, --, 
   {{0xdb0402ef,0x6440062d,0x7dd001c5,0x656001d5}},	//   _jaké, _ouli, _väss, _nelh, 
   {{0x6440062e,0xdb04062f,0x7dd00630,0x76400031}},	//   _nuli, _maké, _wäss, _sumy, 
   {{0x7dd00466,0x2a6801f9,0x3a3802b1,0x966401ec}},	//   _täss, bsab_, _wirp_, екде, 
   {{0x64400631,0x65600632,0x60140192,0x00000000}},	//   _auli, _belh, láms, --, 
   {{0x64400633,0x991402b3,0xdb0401b1,0x86200634}},	//   _buli, _зьбі, _rakè, льще, 
   {{0x6560061e,0x60140635,0x76400636,0xdb0404c3}},	//   _delh, náms, _wumy, _sakè, 
   {{0x64400637,0xdb04029f,0x76400638,0x65600639}},	//   _duli, _pakè, _tumy, _eelh, 
   {{0x6560063a,0x6440063b,0x8a100012,0x5184063c}},	//   _felh, _euli, _شِہت, нуна, 
   {{0x6440063d,0x656001ab,0x8e700375,0x82300061}},	//   _fuli, _gelh, ққош, ێریا, 
   {{0x91a4063e,0xdb040249,0xa64c0020,0xe0840012}},	//   _atọ_, _daké, _ዝተዓደ, نێوو_, 
   {{0x04d80240,0x6560018c,0x7de40049,0x1ab000bd}},	//   _מקבל, _zelh, ңірд, ीमाथ, 
   {{0x6440063f,0xa3d40076,0xbed8044a,0xdb0400f2}},	//   _zuli, _सकत_, едях_, _faké, 
   {{0x64400640,0x2d840641,0x00000000,0x00000000}},	//   _yuli, üle_, --, --, 
   {{0x64400642,0xac180643,0xd12c0012,0xefc0001d}},	//   _xuli, дову_, _دۅد_, ትሄው_, 
   {{0xfba80644,0x00000000,0x00000000,0x00000000}},	//   нтуй_, --, --, --, 
   {{0x2b480105,0xdec000b8,0x2a6800f1,0x00000000}},	// [3b0] rcac_, _кәро, usab_, --, 
   {{0xc8640645,0x5e14001e,0x2b4801c6,0x2a680386}},	//   етди, _изыӡ, scac_, rsab_, 
   {{0xd3640646,0x2a680647,0x6560052b,0x6b740553}},	//   _په_, ssab_, _relh, _илну, 
   {{0xed780648,0x65600649,0x6440064a,0x2a68013c}},	//   _እምበር_, _selh, _ruli, psab_, 
   {{0x6440064b,0x656000bd,0x7dd0013c,0xf1b0064c}},	//   _suli, _pelh, _käsp, जयान, 
   {{0x65600428,0x7dd00139,0xe8940329,0x00000000}},	//   _qelh, _jäsp, _иагь, --, 
   {{0x6560064d,0x6440064e,0xdb04064f,0x00000000}},	//   _velh, _quli, _raké, --, 
   {{0x64400650,0xdb040651,0x7dd00479,0x65600652}},	//   _vuli, _saké, _läsp, _welh, 
   {{0x9f4002b4,0x65600653,0xdb040654,0x64400655}},	//   shkë_, _telh, _paké, _wuli, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64400656,0x00000000,0x00000000,0x00000000}},	//   _uuli, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3f8c002f,0xdb04018b,0x73c40075,0x93100122}},	//   ędu_, _také, _حينم, _پووش, 
   {{0x00e001b8,0x603c00c2,0xa0c40657,0xe9f8001e}},	//   _متعی, gămî, _ليتو, tvẽ_, 
   {{0xa3d4002f,0xa0a40658,0xdcb000c3,0x6aa800e0}},	//   _सका_, _райд, جىز_, _šefp, 
   {{0xd00c0659,0x8d740012,0x00000000,0x00000000}},	//   _ولو_, _یاپا, --, --, 
   {{0xd944065a,0x0ea400bf,0x9f44065b,0xdb200055}},	// [3c0] вези, _акый_, _ñoñ_, _ütüy, 
   {{0x7dd00207,0x1c44065c,0xc0f40020,0xa3d40030}},	//   _gäsp, _ином, _ዋላስ_, _सकऽ_, 
   {{0x1d08065d,0x8dd800ca,0x00000000,0x00000000}},	//   _цени_, _חקיק, --, --, 
   {{0x62980028,0x00000000,0x00000000,0x00000000}},	//   _opwo, --, --, --, 
   {{0xc6200252,0x68e000af,0x2704004f,0x00000000}},	//   _পঢ়া_, _üldn, _āṃśa, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6298065e,0x0460065f,0x44a00660,0x00000000}},	//   _apwo, атым, لموق, --, 
   {{0xc0d40661,0x00000000,0x00000000,0x00000000}},	//   ኮነስ_, --, --, --, 
   {{0xdb0400c4,0xd20805bc,0x6f0803ef,0x836001a0}},	//   _inkó, дэнд_, żecz, شگنل, 
   {{0xb9cc0020,0xba0800a7,0x80c80143,0x14c800b8}},	//   _ዳአ_, _ፋና_, ানন্, _ҭыҧи_, 
   {{0x62980662,0xdb0403c8,0x066c0121,0xb0340663}},	//   _epwo, _ankü, ﭽﯩﻠﯩ, лнош, 
   {{0x81d00664,0x54340665,0xb4c00030,0x00000000}},	//   সোল_, _شرار, ुही_, --, 
   {{0xd33402b3,0x00000000,0x00000000,0x00000000}},	//   _рэжы, --, --, --, 
   {{0x20000666,0x337801d2,0x00000000,0x00000000}},	//   anki_, _ﭼﻴﻠﻲ_, --, --, 
   {{0x61ec060f,0x70940667,0x9f400192,0xd7e0040e}},	//   _ïala, _сайф, liký_, पसाच, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7b640320,0x3b640668,0xeb9801ec,0x7c340049}},	// [3d0] ртсе, ръсв, миң_, ретх, 
   {{0x60140669,0x00000000,0x00000000,0x00000000}},	//   lámp, --, --, --, 
   {{0xdd900012,0x00000000,0x00000000,0x00000000}},	//   _اوپ_, --, --, --, 
   {{0xba2800c3,0xc7b80027,0x00000000,0x00000000}},	//   ىسەم_, ьёз_, --, --, 
   {{0xd1c40020,0x00000000,0x00000000,0x00000000}},	//   ሽሓት_, --, --, --, 
   {{0xa82403b5,0x28f80329,0x16a4066a,0x68e00030}},	//   _ڵکان, _зегь_, увши_, _üldo, 
   {{0x4788066b,0x2000002f,0x6298006f,0x02d800cb}},	//   _осам_, ynki_, _spwo, यन्न, 
   {{0xe2840074,0xd344066c,0x778400cc,0x00000000}},	//   глии, هیمه_, _ەجەك, --, 
   {{0xba080090,0x21680108,0x6144066d,0x9f840121}},	//   _ገቢ_, нипи_, лепа, ңгод, 
   {{0x85b8066e,0xa3b40200,0x5f740061,0x00000000}},	//   _تارس_, _әбді, گادر, --, 
   {{0x20d40256,0xf4840007,0x00000000,0x00000000}},	//   уіпс, _вучн, --, --, 
   {{0xd24c0572,0xb22400bf,0x00000000,0x00000000}},	//   زچۇ_, лмөл, --, --, 
   {{0xf1a8049d,0xe298066f,0x00000000,0x00000000}},	//   رایه_, _чал_, --, --, 
   {{0xdb1c0670,0x326400c3,0xa0680671,0x00000000}},	//   _éxéc, _өтәв, _зака_, --, 
   {{0xa07400b8,0x59740049,0x00000000,0x00000000}},	//   _сылш, ғызу, --, --, 
   {{0x1d0800fc,0x30740672,0x00000000,0x00000000}},	//   _җеми_, _тушс, --, --, 
   {{0xdb0401b1,0x00000000,0x00000000,0x00000000}},	// [3e0] _ankò, --, --, --, 
   {{0x80a40030,0x00000000,0x00000000,0x00000000}},	//   _औनाइ, --, --, --, 
   {{0x68e00030,0x00000000,0x00000000,0x00000000}},	//   _üldl, --, --, --, 
   {{0xd7080673,0x80a80674,0x00000000,0x00000000}},	//   ннее_, _जनने, --, --, 
   {{0xcc380282,0xdb0401e8,0xdb080675,0x00000000}},	//   _רעכט, _enkò, änäh, --, 
   {{0xe9380121,0x394c059c,0x94a800b8,0x0f340676}},	//   رسەت_, _üds_, етиа_, ארנט_, 
   {{0x2d8402ba,0x2464001e,0x09e001c7,0x00000000}},	//   òlei_, ахыҳ, _уорн, --, 
   {{0xb2740677,0xedd002ef,0x752400bd,0xd25803a7}},	//   алиш, _सक्छ, řizo, нцо_, 
   {{0xd620044a,0x00000000,0x00000000,0x00000000}},	//   _дiаа, --, --, --, 
   {{0xb6a40678,0xbbe000aa,0x00000000,0x00000000}},	//   _йиғл, नसुक, --, --, 
   {{0x5064024b,0x709402dc,0x335400cc,0x569400ec}},	//   ытпа, шанф, _күйө_, _шаҡт, 
   {{0x75280059,0x9f4001b8,0x89340100,0x00000000}},	//   _izdz, dikó_, טריע_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0dc80679,0xc330067a,0x00000000,0x00000000}},	//   хуми_, _פוס_, --, --, 
   {{0x263c0031,0x00000000,0x00000000,0x00000000}},	//   _oňon_, --, --, --, 
   {{0xeeb8006b,0x00000000,0x00000000,0x00000000}},	//   _алиш_, --, --, --, 
   {{0xf33002b4,0xdb04067b,0x1ccc011a,0xab38024b}},	// [3f0] _ብትብዓ, _fakí, ྱའུ_, тпау_, 
   {{0x960c025c,0x00000000,0x00000000,0x00000000}},	//   ाकोट_, --, --, --, 
   {{0xa3d40310,0xf988067c,0x2904012c,0x00000000}},	//   _सकल_, انمي_, _žlab_, --, 
   {{0x68e00030,0x00000000,0x00000000,0x00000000}},	//   _üldm, --, --, --, 
   {{0xe610067d,0xa63401f5,0x8728018f,0x00000000}},	//   يشت_, анді, хўжа_, --, 
   {{0xdb04067e,0xd1dc00a7,0x236801df,0x1d68001d}},	//   _fakâ, ንበብ_, _žaj_, ቲስቶች_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe8e000b3,0xe298067f,0x6d400680,0xe3b80681}},	//   पनीच, ваи_, ılay, тби_, 
   {{0xdb04034a,0x7cc40682,0xf65000cc,0x53c402ba}},	//   _zakâ, ﺯﻣﯘﻧ, _فئل_, ргым_, 
   {{0x84640683,0xdb040247,0x20b40007,0x67280059}},	//   _бъде, _hakã, аёмс, _izej, 
   {{0x23c40684,0x349400fc,0xdb0402b2,0xe12400b7}},	//   वादद, _гахр, _rakí, рмни, 
   {{0xa2780685,0x22940686,0x44240687,0x00000000}},	//   _абду_, _видя, _صراف, --, 
   {{0x61ec036b,0x2ec000b8,0x00000000,0x00000000}},	//   _ïalo, зҩым, --, --, 
   {{0x5f740688,0x00000000,0x00000000,0x00000000}},	//   داگر, --, --, --, 
   {{0xdca40689,0xd00c00dd,0x30b400ea,0x67280201}},	//   шави, _ڪلي_, _هلوځ, _lzej, 
   {{0x3cec0048,0xd12c068a,0xbbe003bf,0x00000000}},	//   _đkvđ_, _غمي_, नसेक, --, 
  
   {{0x68e000b6,0xdb0401d4,0xd00c068b,0x00000000}},	// [400] _üldj, _takí, _تلي_, --, 
   {{0x7e64068c,0xad2400c3,0x00000000,0x00000000}},	//   _iwip, _گىپى, --, --, 
   {{0x18a4068d,0x00000000,0x00000000,0x00000000}},	//   раем, --, --, --, 
   {{0x7e64068e,0x00000000,0x00000000,0x00000000}},	//   _kwip, --, --, --, 
   {{0x7f440636,0x7e64042e,0xdcfc02cc,0x67280201}},	//   _mgiq, _jwip, _napĺ, _czej, 
   {{0xd498068f,0x5d7800b9,0x7e6400ba,0x67280059}},	//   ври_, דאַק, _mwip, _dzej, 
   {{0x1ccc0037,0x67280690,0xdb04034a,0x00000000}},	//   ྱའི_, _ezej, _hakà, --, 
   {{0x7f4400f8,0x00000000,0x00000000,0x00000000}},	//   _ngiq, --, --, --, 
   {{0x958401c7,0x00000000,0x00000000,0x00000000}},	//   _влзе, --, --, --, 
   {{0x7f440034,0x00000000,0x00000000,0x00000000}},	//   _agiq, --, --, --, 
   {{0x7e640209,0x46100691,0x30140692,0x752800ce}},	//   _awip, _بولر, йдор, _uzdz, 
   {{0xa4d400cc,0x88480020,0x00000000,0x00000000}},	//   _уюуш, _ንነብሰ, --, --, 
   {{0xdb040693,0x22780694,0x9f4001e8,0x00000000}},	//   _nakà, _ملنگ_, tikò_, --, 
   {{0x7e640695,0x8d840696,0x2714001c,0xfd440697}},	//   _dwip, шумд, ềng_, жэтн, 
   {{0x30840272,0xdcfc00c0,0xbc4802ba,0xed5001ac}},	//   _العف, _zapĺ, ичте_, يھھ_, 
   {{0x80a80698,0x8d78001d,0x7ff40075,0x00000000}},	//   _जनते, ርሳቸው_, _وسيا, --, 
   {{0x6e940699,0x7e640593,0xdb0400b8,0xbea800dd}},	// [410] _الخا, _gwip, _rakã, _نهين_, 
   {{0x68e000a1,0xdb04001e,0x00000000,0x00000000}},	//   _üldk, _sakã, --, --, 
   {{0x6d44069a,0x5c3002ac,0x7a300207,0x6728069b}},	//   _igha, تکیز, kätf, _szej, 
   {{0xdb04069c,0xddd402e6,0x27680324,0xef180126}},	//   _fakà, _atyň, اشای_, żżu_, 
   {{0x46a4069d,0x9a80001d,0x00000000,0x00000000}},	//   ршеб, ንደኛው_, --, --, 
   {{0xa508069e,0x6d44043b,0xe5a4069f,0x625806a0}},	//   лела_, _jgha, сики, қрир_, 
   {{0x6d4406a1,0x00000000,0x00000000,0x00000000}},	//   _mgha, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d406a2,0x6d4406a3,0x672806a4,0x02c401a0}},	//   _koze, _ogha, _uzej, рқли_, 
   {{0x6d4406a5,0x69d406a6,0xbbd406a7,0x27fc009c}},	//   _ngha, _joze, _धक्क, liwn_, 
   {{0x7e6406a8,0x69d406a9,0xa8780282,0xc34003d6}},	//   _swip, _moze, װאָר, _мĕн_, 
   {{0x6d4406aa,0xdb0406ab,0x312406ac,0x64440237}},	//   _agha, _laká, өдөг, ŭhis, 
   {{0xfe7806ad,0x6d4406ae,0x69d402b0,0x26dc0083}},	//   шүп_, _bgha, _ooze, nywo_, 
   {{0x69d406af,0x27fc0086,0xbbe00095,0x2168012b}},	//   _noze, hiwn_, नस्क, _сики_, 
   {{0x6d440126,0xe0540272,0x63ac05c0,0x68e000b6}},	//   _dgha, _اختب, _óans, _üldh, 
   {{0x69d4038b,0x6d4402b0,0x7e6406b0,0x442c02b2}},	//   _aoze, _egha, _twip, _jhg_, 
   {{0x69d406b1,0x6d44011a,0x4a400385,0x1ccc011a}},	// [420] _boze, _fgha, знув, ྱའང_, 
   {{0x69d406b2,0xdb0400c4,0x3ea006b3,0x442c06b4}},	//   _coze, _caká, _ipit_, _lhg_, 
   {{0x442c06b5,0x27fc0335,0xdb040223,0xdc680074}},	//   _ohg_, fiwn_, _wakà, _щанд_, 
   {{0x69d406b6,0x263c02d9,0x442c06b7,0x6d44043b}},	//   _eoze, _dňom_, _nhg_, _zgha, 
   {{0x236c0008,0x7c2401b4,0x8c1800ca,0x224c0126}},	//   daej_, mlir, _תוכי, jqek_, 
   {{0x7c2406b8,0x442c05b8,0xd1dc0117,0x3ea00693}},	//   llir, _ahg_, ንበት_, _mpit_, 
   {{0x3ea00278,0x442c0095,0x27fc0335,0x224c0126}},	//   _lpit_, _bhg_, biwn_, eqek_, 
   {{0xdb0405a4,0x73d806b9,0x46e4039c,0x325406ba}},	//   _zaká, рдир_, рдән_, овир, 
   {{0x69d406bb,0xdb0406bc,0x316c06bd,0x442c000d}},	//   _yoze, _enkö, tadz_, _dhg_, 
   {{0x1ad4007e,0x442c06be,0xf8dc03ec,0x7c2401e3}},	//   _সেৱা, _ehg_, _यथाय, hlir, 
   {{0x3ea006bf,0x316c06c0,0x46100122,0x6d4400a8}},	//   _apit_, radz_, _عومر, _rgha, 
   {{0x7c2406c1,0x68e8012c,0x316c01d4,0xaab80098}},	//   jlir, _ředk, sadz_, _उछलक, 
   {{0xc0e406c2,0x316c0039,0x23c4044b,0x00000000}},	//   لفین_, padz_, वारद, --, 
   {{0x94240121,0xf15806c3,0x6d440126,0x799c02b0}},	//   _ئوچۇ, _тикш_, _qgha, _nbrw, 
   {{0x7c2406c4,0x3ea0034c,0x818402be,0x442c00fc}},	//   flir, _epit_, _انىق_, _yhg_, 
   {{0x68e00076,0x7c24052b,0x69d40091,0xdb0406c5}},	//   _üldi, glir, _soze, _saká, 
   {{0x69d406c6,0x6d44043b,0xdb0401d5,0xdde80061}},	// [430] _poze, _tgha, _paká, _چرپه_, 
   {{0x6d4406c7,0x7c2406c8,0x799c0379,0x6d9802eb}},	//   _ugha, alir, _cbrw, _твоё_, 
   {{0x7c2406c9,0x69d406ca,0xdb0406cb,0xd1500020}},	//   blir, _voze, _vaká, _ዘጠቓል, 
   {{0x69d406cc,0x799c0335,0x80a806cd,0xe50c00bd}},	//   _woze, _ebrw, _जनसे, ाअघि_, 
   {{0x69d406ce,0x61e00105,0x442c0086,0xdb0406cf}},	//   _toze, ykll, _rhg_, _taká, 
   {{0x27fc009c,0x442c06d0,0x799c0379,0x941c0387}},	//   siwn_, _shg_, _gbrw, _istə_, 
   {{0x442c06d1,0xd1e8010f,0x2bfc0095,0x545000c3}},	//   _phg_, ሆኑት_, _एषां_, үвәт, 
   {{0xe7880046,0x61e00105,0xc2b00049,0x8704012b}},	//   _خپره_, wkll, зөкш, _лязе, 
   {{0xd7e800c3,0x00000000,0x00000000,0x00000000}},	//   _ئوقۇ_, --, --, --, 
   {{0x442c06d2,0xbb3c0100,0xe2400020,0x7cf000d5}},	//   _whg_, נעזי, _ከነመሓ, _jóré, 
   {{0x3ea006d3,0x6008022f,0xa06806d4,0x04b4004b}},	//   _spit_, ином_, јама_, _دپاں_, 
   {{0xd9a406d5,0x7a3006d6,0x3ea006d7,0x00000000}},	//   _ऑस्ट, mäte, _ppit_, --, 
   {{0xfbcc01b9,0xa4900046,0x224c011a,0x00000000}},	//   ৰোঁত, _ریښت, qqek_, --, 
   {{0x6b9c02b0,0x73040023,0x00000000,0x00000000}},	//   _absg, _эпіз, --, --, 
   {{0xdb04012b,0x7dd0006b,0x7a3006d8,0x7c24018f}},	//   _kakç, _mäsx, näte, tlir, 
   {{0x1ae406d9,0x7c2406da,0x799c02b0,0x68e00031}},	//   ообм, ulir, _sbrw, _ýldy, 
   {{0x533400b9,0x7c2406db,0x3ea006dc,0x9e6406dd}},	// [440] ַנען_, rlir, _upit_, _باعن, 
   {{0xa2b006de,0x7a3006df,0x7c24061a,0x99880023}},	//   _अनन्, käte, slir, _ribų_, 
   {{0x0d2003c4,0x7c2406e0,0x9b4406e1,0x799c06e2}},	//   _жүрү, plir, _وندو, _vbrw, 
   {{0x779406e3,0x6abc0308,0x7a3006e4,0x7dd00139}},	//   ثیرا, _frsf, däte, _räsy, 
   {{0xdb04012a,0xc7a00111,0x00000000,0x00000000}},	//   _sakæ, ќичк, --, --, 
   {{0x88c401d5,0xdcec0055,0x7a30006b,0x00000000}},	//   _spěš, lebı, fäte, --, 
   {{0xdb04039c,0xe97006e5,0x73c406e6,0xd14801a0}},	//   _bakç, _سۇند, зәле, یشدن_, 
   {{0x6830036d,0x7dd00274,0xd6a80324,0x99980078}},	//   gådd, _väsy, _پدرم_, wopň_, 
   {{0xd1c80329,0xdcfc01d4,0x7dd00152,0x95c80139}},	//   аунд_, _napľ, _fäsx, _клаб_, 
   {{0x68e800aa,0x2be0002f,0x69cc02ef,0x7a300087}},	//   _ředi, _नवभा, सायी, bäte, 
   {{0xc9500240,0x26c000a2,0x4410006b,0x7a30012b}},	//   ומת_, āhoe_, яфәт, cäte, 
   {{0x784c0422,0x683006e7,0x80a80021,0x386c0085}},	//   _ብኣንጻ, rådg, _जनरे, _ædru_, 
   {{0x37bc0143,0x68e00030,0x614000b8,0x00000000}},	//   _অকার, _üldv, мҵәа, --, 
   {{0x68300056,0x9f400139,0x00000000,0x00000000}},	//   måde, yikö_, --, --, 
   {{0xad2406e8,0x683006e9,0x4ef400ea,0xec240108}},	//   سىرى, låde, _ژوبڼ_, كىسپ, 
   {{0x3eb006ea,0xf1e0025c,0xaa5406eb,0x9f400139}},	//   ältä_, _पकडन, зваш, vikö_, 
   {{0x161806ec,0x7a3001c8,0x68300085,0x21e800f2}},	// [450] धवार_, zäte, nåde, _húha_, 
   {{0xba4400b0,0x9f400027,0x00000000,0x00000000}},	//   _šįry, tikö_, --, --, 
   {{0x6d54002f,0xa8980200,0x7f840565,0x00000000}},	//   mcza, скеу_, _علین, --, 
   {{0x27e80191,0x6d5403ef,0x8038007c,0x68300207}},	//   óan_, lcza, ַנגע_, kåde, 
   {{0xf1bc06ed,0x6b8c06ee,0xbb380200,0x9f40021c}},	//   ्ञान, mgag, ﮕﯩﻦ_, sikö_, 
   {{0x7a3006ef,0x6b8c0437,0x6aac06f0,0xe298002c}},	//   täte, lgag, mwaf, ҡай_, 
   {{0x7d18007e,0x69cc00b3,0x6aac0472,0x6b8c00a0}},	//   _øvst, साठी, lwaf, ogag, 
   {{0x7a3006f1,0x6aac01dc,0x6d5402b0,0xc6a401c3}},	//   räte, owaf, hcza, _мрзи, 
   {{0x7a3006f2,0x65140191,0xe1f800df,0x683006f3}},	//   säte, _کوائ, йги_, rådd, 
   {{0xc4c406f4,0x7a3006f5,0xc6840122,0x6b8c06f6}},	//   _وتاو, päte, _هێڵن_, hgag, 
   {{0x6d5406f7,0x6aac06f8,0x6b8c06f9,0xc61406fa}},	//   dcza, hwaf, kgag, दकीय_, 
   {{0x6aac06fb,0x21e800c0,0xdd9006fc,0x6d5403ef}},	//   kwaf, _dúha_, کوس_, ecza, 
   {{0x63a806fd,0x33f406fe,0xdea002ac,0x245006ff}},	//   meen, _تسلس, ریدی, _hám_, 
   {{0x63a80700,0x6b8c007b,0x52d400ca,0x00000000}},	//   leen, egag, _מונע_, --, 
   {{0x71f80701,0x245002b2,0x00000000,0x00000000}},	//   _برنس_, _jám_, --, --, 
   {{0x245005a4,0x6b8c0702,0x2f1401d7,0x6d540703}},	//   _mám_, ggag, ụga_, acza, 
   {{0x20000704,0x24500705,0xdcec0386,0x6d5403bf}},	// [460] miki_, _lám_, rebı, bcza, 
   {{0x20000706,0x63a80707,0x6b8c0708,0x4ef80107}},	//   liki_, heen, agag, _להפו, 
   {{0x63a80709,0x2450070a,0xf1d0001c,0x4dd80107}},	//   keen, _nám_, _hạch_, _החיו, 
   {{0x6b8c070b,0x63a8070c,0xb8d4070d,0x00000000}},	//   cgag, jeen, _झन_, --, 
   {{0x63a8070e,0x20000243,0xdb0401c9,0x1a640122}},	//   deen, iiki_, _bakå, _ریای_, 
   {{0x2000070f,0xf1d00710,0x2450001c,0x00000000}},	//   hiki_, _mạch_, _bám_, --, 
   {{0x24500710,0x63a80711,0x05700712,0xf1d00048}},	//   _cám_, feen, راود, _lạch_, 
   {{0x63a80713,0x20000714,0x24500715,0x6d54002f}},	//   geen, jiki_, _dám_, zcza, 
   {{0x20000716,0x6d54002f,0xd14802ac,0x628801d5}},	//   diki_, ycza, یشگن_, gueo, 
   {{0x683000de,0x20000369,0xe56001d4,0x00000000}},	//   råde, eiki_, _päťč, --, 
   {{0x80dc0301,0x63a80717,0x20000718,0x68e000b6}},	//   _ফেব্, been, fiki_, _üldt, 
   {{0x63a803fa,0xf1d00710,0x20000719,0x6d54002f}},	//   ceen, _bạch_, giki_, wcza, 
   {{0xf194071a,0xf1d001eb,0x00000000,0x00000000}},	//   _жиль, _cạch_, --, --, 
   {{0x20000243,0x7e440320,0x00000000,0x00000000}},	//   aiki_, ехсе, --, --, 
   {{0x2000071b,0x24500014,0x6d54002f,0x6b8c071c}},	//   biki_, _xám_, rcza, tgag, 
   {{0x6b8c071d,0x6aac0271,0x7f84071e,0x20000098}},	//   ugag, twaf, _كلىن, ciki_, 
   {{0x6b8c071f,0xf1d00014,0xe1e8004b,0xdb140078}},	// [470] rgag, _gạch_, _دى۪و_, ndyè, 
   {{0x2fc801ba,0x6aac0211,0x63a80720,0x7870001e}},	//   _hnag_, rwaf, zeen, _ẽvae, 
   {{0x6aac0721,0x63a80722,0x67d40723,0x2fc80039}},	//   swaf, yeen, можу, _knag_, 
   {{0x24500724,0x63a80725,0x6aac0726,0x00000000}},	//   _rám_, xeen, pwaf, --, 
   {{0x24500214,0x63a80727,0x0ae80728,0xaa580139}},	//   _sám_, veen, _طرحي_, _фигу_, 
   {{0x20000729,0x63a8072a,0x64a4072b,0x2fc801ca}},	//   ziki_, ween, дака, _lnag_, 
   {{0x2000072c,0x2bd0072d,0xb7c800e7,0x00000000}},	//   yiki_, हापा, تبەك_, --, 
   {{0x2450072e,0x2fc8072f,0x7a300730,0x320c034a}},	//   _vám_, _nnag_, mäta, endy_, 
   {{0x20000731,0x63a80732,0x27ec0733,0x6584001e}},	//   viki_, reen, _ilen_, _ҕыҕз, 
   {{0x13040734,0x63a80735,0x2fc80736,0x68e00076}},	//   ьный_, seen, _anag_, _ülds, 
   {{0xf1d00710,0x2fc80097,0x1fa80737,0x7a30013b}},	//   _sạch_, _bnag_, окни_, näta, 
   {{0x2fc80738,0x63a803fa,0x27ec0085,0x21200085}},	//   _cnag_, qeen, _jlen_, _øhhm_, 
   {{0x62880739,0x2fc8073a,0x784c024f,0x02a40074}},	//   queo, _dnag_, _işve, _хрем, 
   {{0xb8e00002,0xdca4073b,0xf1d0001c,0x27ec03c7}},	//   _ཀླ_, маги, _vạch_, _llen_, 
   {{0x27ec073c,0x2000073d,0x7a300027,0x5bb40123}},	//   _olen_, piki_, jäta, мсаф, 
   {{0x7a30019f,0xfcd00020,0xf1d0000d,0xbb500200}},	//   däta, _ብደገ_, _tạch_, _ﺎﻨﻲ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [480] --, --, --, --, 
   {{0x27ec073e,0xbe3400cc,0xfaa400ec,0x00000000}},	//   _alen_, _سۉزب, мағо, --, 
   {{0x16c4073f,0x2fc80740,0xdb0400ef,0x27ec0475}},	//   लम्ब, _ynag_, _jakú, _blen_, 
   {{0x27ec015e,0xdb0401d5,0x00000000,0x00000000}},	//   _clen_, _makú, --, --, 
   {{0xdb04001e,0x320c00df,0x1ccc0126,0x39580055}},	//   _lakú, yndy_, ྱའམ_, _tfrs_, 
   {{0x7ae4017b,0x18680741,0xdcfc0055,0x39580055}},	//   myit, _маги_, _hapı, _ufrs_, 
   {{0xdcfc0397,0xc9240742,0x27ec0743,0xdb0402cc}},	//   _kapı, _жорж_, _flen_, _nakú, 
   {{0x27ec0744,0x7ae40745,0x21e804ac,0x2bd003ec}},	//   _glen_, oyit, _búho_, हाया, 
   {{0x51840746,0x12bc02fa,0x2fc80747,0x68e00030}},	//   муна, েন্দ, _rnag_, _üldr, 
   {{0x2fc80748,0x22580749,0x978c0320,0x00000000}},	//   _snag_, íska_, _гiур_, --, 
   {{0x7648074a,0x27ec021c,0x7ae4074b,0x68300479}},	//   _iidy, _ylen_, hyit, låda, 
   {{0x33b40012,0xa2a80303,0xd24c01b5,0xa2d8006c}},	//   _سٕتر, _जैक्, _پۆد_, _फॅक्, 
   {{0xb8d0074c,0x201002d9,0x683006e9,0x74b80095}},	//   _དག_, ézia_, nåda, ्मकृ, 
   {{0x7a300209,0x2f1401e5,0xdb0400c0,0x76480201}},	//   yäta, ụgo_, _fakú, _jidy, 
   {{0x7648074d,0xd12c0012,0x7ae4074e,0x2fc80306}},	//   _midy, _خۅد_, eyit, _tnag_, 
   {{0xdcfc0055,0x7648074f,0x68300479,0x7a300027}},	//   _capı, _lidy, kåda, väta, 
   {{0x3c440023,0xdb0402d9,0x2bd00750,0x00000000}},	// [490] тэрв, _zakú, हाबा, --, 
   {{0x7a300638,0x27ec0085,0x68300207,0x00000000}},	//   täta, _slen_, dåda, --, 
   {{0x27ec0751,0x7ae40752,0x3d1000b3,0x79940413}},	//   _plen_, ayit, णपणे_, тихф, 
   {{0x7ae404f8,0x76480753,0xcbc40046,0x2b580111}},	//   byit, _aidy, _تېرو_, _ufsc_, 
   {{0xf7700754,0x764805b8,0x27ec02b4,0x7ae40172}},	//   شان_, _bidy, _vlen_, cyit, 
   {{0x7a30013b,0x2d90011a,0x00000000,0x00000000}},	//   päta, ngze_, --, --, 
   {{0xdcfc0755,0x76480756,0x24e80757,0x27ec0098}},	//   _yapı, _didy, ямки_, _tlen_, 
   {{0xdb04018b,0x76480151,0x27ec0758,0x95d400c3}},	//   _rakú, _eidy, _ulen_, ддәт_, 
   {{0x52a40759,0x263c01d4,0x68e4075a,0x00000000}},	//   евым_, _sňou_, lyhd, --, 
   {{0x7648075b,0x6728001e,0xa4d4075c,0x2bd0006c}},	//   _gidy, _iyej, _позі, हाडा, 
   {{0x752800b0,0x68e402eb,0x35d4018f,0x7a300087}},	//   _gydz, nyhd, _шофё, kätn, 
   {{0x6e24010f,0x7648075d,0x67280472,0x7ae4075e}},	//   _akhb, _zidy, _kyej, yyit, 
   {{0xdcb0075f,0xdb040229,0x63b80323,0x59d00095}},	//   گىز_, _fakù, _iawn, सामर, 
   {{0xf1d00710,0x63b80037,0x7ae40760,0x7648052e}},	//   _hạnh_, _hawn, vyit, _xidy, 
   {{0x22980761,0x63b80762,0x67280763,0xe7240061}},	//   lèk_, _kawn, _lyej, _چڵ_, 
   {{0xdcfc009f,0xef2000a5,0x7ae40083,0x63b80764}},	//   _qapı, ụzịa, tyit, _jawn, 
   {{0xf1d00765,0x6728069c,0x22980766,0x63b80086}},	// [4a0] _mạnh_, _nyej, nèk_, _mawn, 
   {{0xf1d00710,0x7ae40767,0x63b80768,0x4b20021d}},	//   _lạnh_, ryit, _lawn, умув, 
   {{0xdcfc0769,0x672800d3,0xdca4076a,0x8d8402b4}},	//   _tapı, _ayej, _џами, _ንምባል_, 
   {{0x764802d4,0x6728076b,0x63b80086,0x7ac400b8}},	//   _sidy, _byej, _nawn, _иҩба, 
   {{0x76480335,0xdb08013c,0x00000000,0x00000000}},	//   _pidy, önäi, --, --, 
   {{0x86c0076c,0x7a3001c8,0x6830076d,0x2298076e}},	//   ايون, mäto, råda, dèk_, 
   {{0x7648076f,0x67280123,0x3f800770,0x68e000b6}},	//   _vidy, _eyej, _odiu_, _üldp, 
   {{0xf1d00710,0x76480771,0x67280222,0xc0d80222}},	//   _cạnh_, _widy, _fyej, ሕኒሕ_, 
   {{0x764806a8,0x63b80772,0x7528002f,0x22980249}},	//   _tidy, _dawn, _wydz, gèk_, 
   {{0xa2b000cb,0x7528002f,0xa300006b,0x3f800773}},	//   _अनर्, _tydz, шүче, _adiu_, 
   {{0xeb0c0774,0x63b80775,0x6814002f,0x09f40107}},	//   _सख्त_, _fawn, ląda, גמים_, 
   {{0x63b80331,0x20d40023,0x22980776,0xb4bc0777}},	//   _gawn, džią_, bèk_, इटी_, 
   {{0x91e40778,0x2d840779,0xd954010f,0x22980249}},	//   _поде, óleo_, ውንታን, cèk_, 
   {{0x92f00492,0x3f80059e,0xd1740152,0x00000000}},	//   ığım, _ediu_, _чыды, --, 
   {{0x63b8077a,0xe570007c,0x7c84029c,0x7a300207}},	//   _yawn, יַן_, луте, tätn, 
   {{0x7e0400cc,0x00000000,0x00000000,0x00000000}},	//   _ۅسپۅ, --, --, --, 
   {{0xdb24077b,0x00000000,0x00000000,0x00000000}},	// [4b0] پولی, --, --, --, 
   {{0xe9440061,0x8fd00197,0x00000000,0x00000000}},	//   نرای, _рәүә, --, --, 
   {{0x7a30039c,0xa774077c,0x2d80077d,0x67280078}},	//   mätl, влеч, _idhe_, _syej, 
   {{0x7a30006b,0x2298077e,0x6674077f,0xd1240122}},	//   lätl, yèk_, ندتر, _ۆم_, 
   {{0x63b80780,0x69c00781,0xd1240782,0x68e402eb}},	//   _rawn, _óleo, _چم_, syhd, 
   {{0xd1240783,0x63b80361,0x69340784,0x229801b1}},	//   _نم_, _sawn, _ангу, vèk_, 
   {{0x47880254,0x2298005e,0x00000000,0x00000000}},	//   _нсам_, wèk_, --, --, 
   {{0xe79400cd,0x22980785,0x7a300152,0x00000000}},	//   _جاسک, tèk_, hätl, --, 
   {{0x88b002fa,0x661c05c0,0x7a3001c8,0x3f84020f}},	//   _টপিক, _ísko, kätl, ómum_, 
   {{0x22980786,0x2d80004f,0x60e801c3,0x00000000}},	//   rèk_, _ndhe_, дмом_, --, 
   {{0x63b80787,0x7a3001c8,0xa0680788,0x2298076e}},	//   _tawn, dätl, ьана_, sèk_, 
   {{0x2d800789,0xdee404e7,0x22980324,0xb22400cc}},	//   _adhe_, воми, pèk_, кмөл, 
   {{0x7a300152,0x00000000,0x00000000,0x00000000}},	//   fätl, --, --, --, 
   {{0x62880075,0x91e00673,0x7a30078a,0x00000000}},	//   mreo, _воше, väto, --, 
   {{0x443c078b,0x62880085,0x00000000,0x00000000}},	//   omu_, lreo, --, --, 
   {{0x2d80078c,0x443c078d,0xb7bc0301,0x63ac078e}},	//   _edhe_, nmu_, _অক্ট, _ñand, 
   {{0x443c078f,0x7a30039c,0x62880790,0x8eb0005e}},	// [4c0] imu_, bätl, nreo, _نميش, 
   {{0x443c0791,0x59d00792,0x628801ca,0x18680027}},	//   hmu_, साधर, ireo, дажи_, 
   {{0x443c0793,0x81c000ac,0x6288059b,0x9f040794}},	//   kmu_, _একা_, hreo, _سوگو, 
   {{0x1cc00795,0x443c0796,0x62880797,0xd7080798}},	//   _གླར_, jmu_, kreo, мнее_, 
   {{0x443c0560,0x96940683,0xfac801c8,0x7c240799}},	//   dmu_, треш, _яңал_, moir, 
   {{0x6288079a,0x09b00002,0x7c24079b,0x1dc001a4}},	//   dreo, _དྲྭ_, loir, शयित, 
   {{0x6288014a,0x7c240177,0x00000000,0x00000000}},	//   ereo, ooir, --, --, 
   {{0x443c079c,0x6288079d,0x9388079e,0x00000000}},	//   gmu_, freo, фска_, --, 
   {{0x6288079f,0x7a3001c8,0x427007a0,0x98800192}},	//   greo, yätl, агыс, _míče_, 
   {{0x443c07a1,0x7c2407a2,0x7a3001c8,0x00000000}},	//   amu_, hoir, xätl, --, 
   {{0x7c2407a3,0x443c07a4,0x6fb407a5,0x62880247}},	//   koir, bmu_, همدا, areo, 
   {{0x628807a6,0x25a80070,0x443c07a7,0x7a30012b}},	//   breo, đale_, cmu_, dätm, 
   {{0x7c2407a8,0x628807a9,0x2bd00474,0xc01400f9}},	//   doir, creo, हासा, рмящ, 
   {{0x827400b9,0xdb04030f,0x80a807aa,0x00000000}},	//   _יעדע_, _bakþ, _जनचे, --, 
   {{0x7c2407ab,0x7a3001c8,0xc0e001c3,0x00000000}},	//   foir, rätl, _војк, --, 
   {{0x0a6807ac,0x6830021d,0x00000000,0x00000000}},	//   држи_, vådo, --, --, 
   {{0x3b5407ad,0x63ac0551,0xba740075,0x00000000}},	// [4d0] ркур, _ñane, لالت, --, 
   {{0x7c240139,0x2d800475,0x7a30012b,0x00000000}},	//   aoir, _udhe_, bätm, --, 
   {{0x443c07ae,0xef100046,0xcc840122,0x628802e3}},	//   ymu_, _خټک_, _جۆزه_, zreo, 
   {{0x628807af,0xe6780041,0x7c24077d,0x3b640348}},	//   yreo, ейді_, coir, _върв, 
   {{0xdb0402e6,0x443c07b0,0x00000000,0x00000000}},	//   _kaký, vmu_, --, --, 
   {{0xdb0400aa,0x443c07b1,0xf62401f5,0x628807b2}},	//   _jaký, wmu_, адіо, vreo, 
   {{0x443c07b3,0xe3b00272,0xbe9c018f,0x00000000}},	//   tmu_, مرة_, _ta談i, --, 
   {{0x628807b4,0x8d8402b4,0x1cc00560,0x693402ac}},	//   treo, _ንዝብል_, _གླས_, _анҳу, 
   {{0x32d402b3,0x63b007b5,0x6ad007b6,0x68140098}},	//   ацэс, _čenč, _सपोर, lądo, 
   {{0xe0d807b7,0x628807b8,0x7c240182,0x00000000}},	//   ево_, rreo, zoir, --, 
   {{0x7c24042e,0x443c04c3,0x62880306,0x00000000}},	//   yoir, pmu_, sreo, --, 
   {{0x628807b9,0x7c240054,0x7a300139,0x00000000}},	//   preo, xoir, vätm, --, 
   {{0x21a407ba,0x7c2407bb,0xdb0402e6,0x784c0387}},	//   _билм, voir, _baký, _xğvq, 
   {{0x7c240088,0xa0c407bc,0x41b407bd,0x127800cf}},	//   woir, _ميتو, _असिस, _טאנע, 
   {{0x7c2407be,0xa0a407bf,0xdb0402e6,0x27140048}},	//   toir, _сайд, _daký, ềnh_, 
   {{0x0ca00422,0xabf407c0,0xd12c0075,0x9ad407c1}},	//   _ምግላጽ_, ачущ, _عمي_, люзі, 
   {{0x7c2407c2,0x00000000,0x00000000,0x00000000}},	// [4e0] roir, --, --, --, 
   {{0x7e6407c3,0x7c2407c4,0x00000000,0x00000000}},	//   _itip, soir, --, --, 
   {{0x7c2407c5,0x1d0802ba,0x00000000,0x00000000}},	//   poir, _чени_, --, --, 
   {{0x788005a4,0x38c801d9,0x00000000,0x00000000}},	//   _návš, _یازی_, --, --, 
   {{0x2bd007c6,0x7a300139,0x00000000,0x00000000}},	//   हारा, nätk, --, --, 
   {{0x1cc007c7,0x7e64075d,0xda6400dd,0x00000000}},	//   _གློ_, _mtip, _لاڳي, --, 
   {{0x54a40075,0x00000000,0x00000000,0x00000000}},	//   احتف, --, --, --, 
   {{0x7e6407c8,0x59d0064c,0x7a3007c9,0x00000000}},	//   _otip, सावर, kätk, --, 
   {{0x71740128,0x7a3007ca,0x325400e1,0x00000000}},	//   لۇشا, jätk, јвор, --, 
   {{0x506401a7,0xdb040201,0x7a3007cb,0x00000000}},	//   лтма, _hakó, dätk, --, 
   {{0x7e6407cc,0x301407cd,0xc05407ce,0x6ad007cf}},	//   _atip, идор, лія_, _सप्र, 
   {{0x1cc00560,0xdb040201,0x7a30012b,0x00000000}},	//   _གླེ_, _jakó, fätk, --, 
   {{0x81e002fa,0xb8d00126,0xcb000030,0xdb0407d0}},	//   _নগর_, _ྐད_, _रेंड_, _makó, 
   {{0xdb040191,0xfe5400e5,0x00000000,0x00000000}},	//   _lakó, скрэ, --, --, 
   {{0x9f500078,0xc98400c3,0x0ba40116,0x2bd0040e}},	//   _olyè_, ғузи, лшам, हाला, 
   {{0xdb040238,0x7a30018b,0x7e640034,0x49b807d1}},	//   _fakü, bätk, _ftip, کارد_, 
   {{0x69c007d2,0xdb04018b,0x7b6407d3,0x01b40143}},	// [4f0] _ólek, _taký, стсе, জারদ, 
   {{0x2c5003ef,0x68300207,0x69340094,0x00000000}},	//   _sądu_, rådm, анзу, --, 
   {{0xdb0407d4,0x87e407d5,0x48a80023,0x00000000}},	//   _bakó, люде, этам_, --, 
   {{0xf86807d6,0xaa9407d7,0xdb04012b,0x377404b7}},	//   امني_, _кимч, _yakü, бышс, 
   {{0xc79007d8,0xe9a801b5,0xdae40191,0xa5640128}},	//   арҙы, _لگان_, _پہلو_, لگان, 
   {{0xdb0c0270,0x7a300139,0xa50802d1,0x2a680030}},	//   _þjál, jäth, кела_, mpab_, 
   {{0x98f000ea,0xdb0400f2,0x35f807d9,0x88a00061}},	//   _وګما, _fakó, درند_, _چیڕۆ, 
   {{0x69c807da,0xaac807db,0x23280123,0x62d407dc}},	//   _होती, रिपक, койи_, لآخر, 
   {{0x221407dd,0x620401a0,0x00000000,0x00000000}},	//   ифор, аtlа, --, --, 
   {{0x7a300274,0xdb0407de,0x245000b0,0x7e640152}},	//   vätk, _kakò, _všmb_, _rtip, 
   {{0xa0a407df,0xdb04029f,0x7e6407e0,0xf48401b2}},	//   шанд, _jakò, _stip, _гучн, 
   {{0x7e6407e1,0xdb0401b1,0xf1a807e2,0x602407e3}},	//   _ptip, _makò, پایه_, рдма, 
   {{0xdb04029f,0x3f8c07e4,0x236c0380,0xd1e8001d}},	//   _lakò, ğdu_, mbej_, _ህጎች_, 
   {{0x614407e5,0x7e640214,0x3f8c009f,0x910403b5}},	//   _кела, _vtip, şdu_, اسیۆ, 
   {{0xdcb0006e,0x00000000,0x00000000,0x00000000}},	//   غىر_, --, --, --, 
   {{0x7e640094,0x1ec802dc,0x236c0380,0x7a3007e6}},	//   _ttip, _алии_, nbej_, pätk, 
   {{0x7e6407e7,0x1a0407e8,0x7a3007e9,0xdb0407ea}},	// [500] _utip, апам, läti, _rakó, 
   {{0x236c07eb,0xdb0400f1,0x8e780107,0x00000000}},	//   hbej_, _bakò, _שניה, --, 
   {{0xd82407ec,0xdc680094,0x00000000,0x00000000}},	//   аджи, _шанд_, --, --, 
   {{0x2a6801f9,0x236c0156,0x00000000,0x00000000}},	//   bpab_, jbej_, --, --, 
   {{0xddd40214,0x59740007,0x236c0140,0xc6d000e7}},	//   _zvyš, _выбу, dbej_, قتوت, 
   {{0xc6f407ce,0x7a300027,0x85740121,0x4730021d}},	//   шніх_, käti, қсәт_, цніс, 
   {{0x7a3002eb,0x3ea00126,0x9f40021c,0xa8180108}},	//   jäti, _lqit_, lkkä_, ختەر_, 
   {{0x25a80473,0xd7f00272,0x236c0140,0xb27403a7}},	//   đala_, _بكر_, gbej_, блиш, 
   {{0xaac803eb,0xc6d40061,0xf1b8011a,0x9f400027}},	//   रियक, _نگوڕ_, loġi_, nkkä_, 
   {{0x7a30019f,0x316001df,0x00000000,0x00000000}},	//   fäti, _đizs_, --, --, 
   {{0x236c0380,0x799c0379,0x04b400e3,0x00000000}},	//   bbej_, _mcrw, _نھيں_, --, 
   {{0xc0cc02b4,0x95c800fb,0x00000000,0x00000000}},	//   ባብሮ_, _пуçа_, --, --, 
   {{0x63ac07ed,0x799c0379,0x216400cc,0x00000000}},	//   _ñana, _ocrw, штөг, --, 
   {{0x7a30019f,0x230807ee,0x2d8407ef,0xfccc0020}},	//   bäti, _حتمي_, ûle_, _ኣሞጽ_, 
   {{0x52b407f0,0x320c07f1,0x69c002b2,0xf07801d9}},	//   _अनुस, midy_, _ólei, _ёйиш_, 
   {{0x80dc007e,0x320c00ef,0x00f400ca,0xcf2403dd}},	//   _ফেক্, lidy_, _כמוך_, _پربي, 
   {{0xdd900063,0xab38038e,0x320c01d4,0x98a80201}},	// [510] _کوپ_, упау_, oidy_, _izbę_, 
   {{0x320c069c,0x53a40095,0x672c0560,0x00000000}},	//   nidy_, क्तश, żajk, --, 
   {{0xb9c407f2,0x236c0140,0x00000000,0x00000000}},	//   تقلي, ybej_, --, --, 
   {{0x320c039d,0xb5c801b5,0x2a680030,0x799c02b0}},	//   hidy_, یونم_, ppab_, _ecrw, 
   {{0x320c039d,0x26c8000f,0x236c0156,0x7b8400cc}},	//   kidy_, íao_, vbej_, _باپە, 
   {{0xe29807f3,0x78bc015e,0x320c02e3,0x6abc02b0}},	//   ҳаи_, _fsrv, jidy_, _issf, 
   {{0x320c0364,0xfa3403b5,0x236c0380,0x00000000}},	//   didy_, _گرێد, tbej_, --, 
   {{0x248807f4,0x81c000ac,0xe3b807f5,0xe29802dc}},	//   čam_, _একই_, уби_, гаи_, 
   {{0x320c07f6,0x236c07f7,0xa6f40123,0x00000000}},	//   fidy_, rbej_, _узаш, --, 
   {{0x7a3007f8,0x85b801b5,0x236c0156,0x00000000}},	//   täti, _جارس_, sbej_, --, 
   {{0xe12407f9,0x236c0156,0xa3e00030,0x00000000}},	//   смни, pbej_, नउआ_, --, 
   {{0x7a3007fa,0x7124020d,0x6abc06e2,0x236c0156}},	//   räti, تىپم, _ossf, qbej_, 
   {{0x626407fb,0x7a3006ea,0x6d4001ec,0x320c0364}},	//   _увла, säti, ýlan, bidy_, 
   {{0x7a3007fc,0x1d0800bf,0x8d6007fd,0x44c4000d}},	//   päti, геги_, звре, _kđ_, 
   {{0x6abc043e,0x23bc03ec,0x00000000,0x00000000}},	//   _assf, ्यपद, --, --, 
   {{0x6830012f,0x44c4000d,0x7a300479,0x00000000}},	//   bådi, _mđ_, nätv, --, 
   {{0x5ac807fe,0x44c40048,0x6b9c015e,0xbd540122}},	// [520] ылам_, _lđ_, _dcsg, _وردژ, 
   {{0x9f4007ff,0x200c03ef,0x6b9c0086,0x00000000}},	//   rkkä_, ślić_, _ecsg, --, 
   {{0x44c4001c,0x6abc06e2,0x18a40027,0x00000000}},	//   _nđ_, _essf, саем, --, 
   {{0xd4980800,0x1cc00126,0x77940801,0x00000000}},	//   ҳри_, _གླག_, تیرا, --, 
   {{0xec340122,0xd37800c3,0x52b40802,0x41b40803}},	//   _گوێگ, ңчи_, _अनेस, _असंस, 
   {{0x99d40804,0xd4980805,0x44c40048,0x7bc40806}},	//   _اتحا, гри_, _bđ_, ldiu, 
   {{0x320c0364,0x44c40014,0x1ccc0126,0x00000000}},	//   vidy_, _cđ_, ཱའི_, --, 
   {{0x7bc40807,0xc7a00808,0x07a005bc,0x44c40048}},	//   ndiu, _ниск, _насн, _dđ_, 
   {{0x320c0809,0xe6b4032a,0xca34080a,0x7bc4080b}},	//   tidy_, _ولفگ, ﻗﯘﺕ_, idiu, 
   {{0xca18006e,0x63ac080c,0x6830036d,0x46e400c3}},	//   ﺷﻘﺎ_, _ñann, vådi, _удун_, 
   {{0x82f40012,0x44c40048,0x5468023f,0x53a40087}},	//   لریز_, _gđ_, _саем_, _гаеб, 
   {{0x69c0014e,0x7bc40475,0x00000000,0x00000000}},	//   _ólev, jdiu, --, --, 
   {{0x74c00523,0x09b0011a,0x320c00ef,0xd33400cc}},	//   विकृ, _དྲྀ_, pidy_, _اعاع, 
   {{0x1cc0080d,0x68300132,0x6abc080e,0x7bc4080f}},	//   _གླང_, rådi, _rssf, ediu, 
   {{0x50640810,0x44c4000d,0x00000000,0x00000000}},	//   _утла, _xđ_, --, --, 
   {{0xbea800dd,0x00000000,0x00000000,0x00000000}},	//   _ڇهين_, --, --, --, 
   {{0xeb980811,0x34b40095,0x7a300139,0x4e940249}},	// [530] лиң_, ंबुद, hätu, _اشعر, 
   {{0x7bc40812,0x6fa40813,0xde440012,0x7a3001c5}},	//   adiu, ग्रं, _ویَو_, kätu, 
   {{0x317806f7,0x7a300274,0xfbc40814,0x6abc0010}},	//   órzy_, jätu, _लोकम, _wssf, 
   {{0x7a300152,0x00000000,0x00000000,0x00000000}},	//   dätu, --, --, --, 
   {{0x6abc02b0,0x44c401eb,0x7a300027,0x00000000}},	//   _ussf, _sđ_, vätv, --, 
   {{0x25a80815,0x24e80816,0x2bd00192,0x4b400012}},	//   đalo_, имли_, हाका, _وٹھہ, 
   {{0x69d40212,0x69c40817,0x44c40014,0xa2b00095}},	//   _inze, mdhe, _qđ_, _अनङ्, 
   {{0x69c40818,0xca1806e8,0x44c401eb,0x00000000}},	//   ldhe, ﺴﯩﺰ_, _vđ_, --, 
   {{0xe1f80819,0x6fdc0584,0xca1800c3,0x23bc081a}},	//   иги_, यानं, ﺷﺘﺎ_, ्यबद, 
   {{0x69c4081b,0x26cc081c,0x7bc40008,0x44c40048}},	//   ndhe, _ireo_, zdiu, _tđ_, 
   {{0x69c4081d,0x7a30081e,0x290000bf,0x63ac0247}},	//   idhe, mätt, nzha_, _ñano, 
   {{0x7a30081f,0x26cc0820,0xa2d40821,0x6fa400b3}},	//   lätt, _kreo_, _ويات, ग्लं, 
   {{0xeef40822,0x69d40823,0x63a80824,0x69c40324}},	//   пярэ, _onze, mfen, kdhe, 
   {{0x63a80825,0xdd900826,0x442c0249,0x69c40827}},	//   lfen, بوس_, _hkg_, jdhe, 
   {{0x69c40828,0x27140073,0x442c02e3,0x788001d5}},	//   ddhe, तपुर_, _kkg_, _mává, 
   {{0x69d40829,0x63a8082a,0x7a30082b,0xa2cc082c}},	//   _anze, nfen, hätt, तिप्, 
   {{0x63a8082d,0x7bc4082e,0xda64082f,0x69c40830}},	// [540] ifen, rdiu, تازي, fdhe, 
   {{0x8eb000cd,0x69c40831,0x7a300832,0x4a400833}},	//   _کمیش, gdhe, jätt, днув, 
   {{0x26cc007c,0x7a300834,0x442c0835,0x9d440836}},	//   _areo_, dätt, _okg_, _фенд, 
   {{0x69c40837,0x442c01c6,0x63a8018c,0x6a140838}},	//   adhe, _nkg_, jfen, يبەر, 
   {{0x26cc0839,0x69c4083a,0x33f8038a,0x63a803c7}},	//   _creo_, bdhe, _néxa_, dfen, 
   {{0xdb04019f,0x63a8083b,0x26cc083c,0x69c4028b}},	//   _bakö, efen, _dreo_, cdhe, 
   {{0x63a8083d,0x5fc8083e,0x26cc034a,0x442c083f}},	//   ffen, ियाल, _ereo_, _bkg_, 
   {{0x63a8009c,0x26cc03b2,0x0440023f,0x27fc03c7}},	//   gfen, _freo_, мејн, chwn_, 
   {{0x26cc0840,0x7a300841,0x442c0842,0x6b600843}},	//   _greo_, bätt, _dkg_, _hágó, 
   {{0x91480844,0x15440254,0x63a8000b,0x7a300104}},	//   ична_, _дезм, afen, pätu, 
   {{0x53a40845,0x1ddc0846,0x26cc0070,0x96c00813}},	//   _мажб, मानत, _zreo_, लिकॉ, 
   {{0x6d4000df,0x63a80847,0x442c030f,0x00000000}},	//   ýlam, cfen, _gkg_, --, 
   {{0x531404c3,0x69c40848,0x7a300207,0x20f4000d}},	//   _بذار, ydhe, näts, ái_, 
   {{0x3f840849,0x69c401b5,0x2a6c084a,0xaac8084b}},	//   ómur_, xdhe, _çebi_, रिसक, 
   {{0xdb1401e8,0x442c0031,0xf1b8011a,0x00000000}},	//   leyè, _ykg_, meġ_, --, 
   {{0x3958015b,0x69c4084c,0x7a30084d,0x00000000}},	//   _agrs_, wdhe, käts, --, 
   {{0x8bfc0252,0x7a30084e,0x69c40020,0xdb1400f1}},	// [550] ্কলন_, yätt, tdhe, neyè, 
   {{0x39580496,0xe738002c,0x7a300496,0x69c4084f}},	//   _cgrs_, ҙел_, däts, udhe, 
   {{0x69c40850,0x26cc0473,0x27fc0086,0x63a80851}},	//   rdhe, _sreo_, thwn_, yfen, 
   {{0x26cc0091,0x69c40020,0x6b60030f,0x29000852}},	//   _preo_, sdhe, _dágó, rzha_, 
   {{0x9ba00853,0x7a300854,0x63a80151,0x24400247}},	//   _سەلى, tätt, vfen, nóme_, 
   {{0x69d40855,0x26cc009e,0x442c0856,0x69c40080}},	//   _unze, _vreo_, _skg_, qdhe, 
   {{0x7a300857,0x6ab8038c,0xdb2000d3,0xa2cc0095}},	//   rätt, şafı, _àtòy, तिभ्, 
   {{0x26cc0858,0x7a300859,0x63a8085a,0xa2e407fd}},	//   _treo_, sätt, ufen, зоид, 
   {{0xdb040064,0x63a8085b,0x63ac04db,0x26cc01c6}},	//   _wakö, rfen, _ñanm, _ureo_, 
   {{0x130402eb,0xe1f80094,0x00000000,0x00000000}},	//   яный_, сго_, --, --, 
   {{0x63a8085c,0x442c0039,0x35680254,0x363401d9}},	//   pfen, _tkg_, _фрун_, _آرقس, 
   {{0x442c085d,0x6014028d,0xdb14085e,0x00000000}},	//   _ukg_, kšme, beyè, --, 
   {{0x6448085f,0x317c01d1,0xf1b80560,0x626403d6}},	//   mmei, _fevz_, beġ_, _эвла, 
   {{0x64480860,0x6d580031,0xc0e00020,0x00000000}},	//   lmei, _şwar, ምሃር_, --, 
   {{0xdb04034a,0x1fb40861,0xd65c024b,0x00000000}},	//   _lakô, _еспр, _бiзд, --, 
   {{0x64480862,0x1e840863,0x39580496,0x717000c3}},	//   nmei, _елим, _sgrs_, _كۇۋا, 
   {{0x6448077d,0x8f98023c,0x00000000,0x00000000}},	// [560] imei, _היפי, --, --, 
   {{0x64480864,0xb10000df,0x5fc800a1,0x7a300865}},	//   hmei, _öýün, ियवल, väts, 
   {{0x23bc0866,0x6448008e,0xdb140078,0x00000000}},	//   ्याद, kmei, zeyè, --, 
   {{0x7a3006ef,0x6448015b,0x6b6000d5,0x00000000}},	//   täts, jmei, _vágó, --, 
   {{0x64480867,0xdb0400b8,0x7e600105,0x998400cc}},	//   dmei, _pakõ, ímph, _ىلحو, 
   {{0xdb04034a,0x7a300868,0x64480869,0x00000000}},	//   _dakô, räts, emei, --, 
   {{0x6448086a,0x7a30006b,0xd9440091,0x00000000}},	//   fmei, bätr, _хеви, --, 
   {{0x4380086b,0x2794022e,0x7a30013c,0x00000000}},	//   ىلىق, _ошур, päts, --, 
   {{0x68300056,0x00000000,0x00000000,0x00000000}},	//   rådt, --, --, --, 
   {{0x6448086c,0x68300056,0xdb140078,0x444401b5}},	//   amei, båds, reyè, _ہرنہ, 
   {{0x6448013c,0xf1b80002,0x00000000,0x00000000}},	//   bmei, reġ_, --, --, 
   {{0x04d80107,0xdb1401e8,0x661c02b2,0x644800ce}},	//   _לקבל, peyè, _ískr, cmei, 
   {{0x80a0086d,0x1ad4006c,0x00000000,0x00000000}},	//   ومین, ठमोठ, --, --, 
   {{0x9f400027,0x00000000,0x00000000,0x00000000}},	//   yhkö_, --, --, --, 
   {{0x7d24086e,0x6fa4006c,0x00000000,0x00000000}},	//   ефте, _कापू, --, --, 
   {{0x2c0c00b3,0x00000000,0x00000000,0x00000000}},	//   _सगळं_, --, --, --, 
   {{0x2cc800b0,0x7a300139,0x00000000,0x00000000}},	// [570] _žudė_, vätr, --, --, 
   {{0xa2cc086f,0x64480870,0xa93c0023,0xdde000c2}},	//   तित्, zmei, адзi, ăuţi, 
   {{0x68300207,0xe7f80098,0x64480086,0x2714006c}},	//   dådr, ंसला_, ymei, तप्र_, 
   {{0x27e80871,0xbea802ac,0xf5400023,0xa7a80023}},	//   ðan_, _بهین_, _якiм_, ікла_, 
   {{0x6fa40872,0x64480873,0x00000000,0x00000000}},	//   _कानू, vmei, --, --, 
   {{0x25a00874,0x7a300479,0xf58400c3,0x00000000}},	//   ühl_, sätr, ىشىپ, --, 
   {{0x64480875,0x63ac04db,0x00000000,0x00000000}},	//   tmei, _ñank, --, --, 
   {{0xf990004b,0x6448002a,0x3cfc067a,0x68300876}},	//   _لبہ_, umei, מלונ, råds, 
   {{0xb9dc02b4,0x1cc00560,0x59080126,0x00000000}},	//   _በታ_, _གླན_, _གཟོས_, --, 
   {{0x64480877,0xa878007c,0x00000000,0x00000000}},	//   smei, ֿאָר, --, --, 
   {{0x6448036d,0xddd402e6,0xd5a4032a,0xc4280878}},	//   pmei, _atyş, _آلمی, _люде_, 
   {{0xa2cc0879,0xa2f4087a,0xdea0087b,0x00000000}},	//   तिद्, _опеч, پیدی, --, 
   {{0x21a401a0,0x00000000,0x00000000,0x00000000}},	//   _жилм, --, --, --, 
   {{0xdd900075,0x23bc0095,0x00000000,0x00000000}},	//   ضور_, ्यवद, --, --, 
   {{0xab380200,0xa008059b,0x00000000,0x00000000}},	//   ﻣﯩﺘﯟ_, _وقتل_, --, --, 
   {{0x8c40087c,0xaac80280,0xf3f800d4,0x00000000}},	//   весе, रिंक, _kuģa_, --, 
   {{0x19c401c3,0x3a440123,0x598400b7,0x00000000}},	// [580] мбам, емаҳ, длзб, --, 
   {{0x0d80087d,0xd7c400b3,0x00000000,0x00000000}},	//   _ильн, _रोजच, --, --, 
   {{0x3f80087e,0x1c44087f,0x4dd800ca,0xaaa800bf}},	//   _keiu_, _оном, _וחיו, _ۉچكۅ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3e00440,0x3f800880,0x00000000,0x00000000}},	//   दान_, _meiu_, --, --, 
   {{0x3f80013c,0x628400a8,0x00000000,0x00000000}},	//   _leiu_, _āhop, --, --, 
   {{0xe8b00128,0x4d7800ca,0x00000000,0x00000000}},	//   _مەلج, קרקע, --, --, 
   {{0x3f8000b6,0x4bf8007c,0x93ec006c,0x00000000}},	//   _neiu_, ַליס, _जवळच_, --, 
   {{0x6fdc0881,0x03e400e2,0x00000000,0x00000000}},	//   यासं, بډلي_, --, --, 
   {{0x3f800882,0xfce00020,0x00000000,0x00000000}},	//   _aeiu_, _ነውጺ_, --, --, 
   {{0x3f800770,0xd4c40883,0x69c80101,0xe7f400bd}},	//   _beiu_, _تغذي, _öleň, _आवमा_, 
   {{0xb4bc0884,0xc95000ca,0xa49401ac,0x00000000}},	//   ेटी_, כמת_, _سُهڻ, --, 
   {{0xb8d00885,0x3f800039,0x00000000,0x00000000}},	//   _ཐད_, _deiu_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c84038e,0x3f800408,0x8bc40886,0x7a300027}},	//   куте, _feiu_, мсад, vätp, 
   {{0x25a80473,0xa3e00887,0x20000888,0xdfd001ac}},	//   đali_, दाय_, chki_, _ميٺ_, 
   {{0x59080126,0x24400889,0x00000000,0x00000000}},	// [590] _གཟུས_, nóma_, --, --, 
   {{0x2fc8088a,0x69c800b6,0x00000000,0x00000000}},	//   _haag_, _होखी, --, --, 
   {{0xa3e0088b,0xd7d800b3,0x2fc8088c,0x79a40668}},	//   दाम_, णांच, _kaag_, ърте, 
   {{0x2fc80520,0xfaf00191,0xf770088d,0x2440088e}},	//   _jaag_, دثہ_, لاه_, kóma_, 
   {{0x2d80088f,0x2fc80890,0x63ac001e,0x98a80201}},	//   _kehe_, _maag_, _ñani, _rybą_, 
   {{0x2fc80891,0xa2cc0828,0x6d4000df,0x2d8000b8}},	//   _laag_, तिस्, ýlaw, _jehe_, 
   {{0x2d800892,0x6fa40698,0xd4640893,0x7f8c012b}},	//   _mehe_, _काढू, нище_, _yöqı, 
   {{0x2d800894,0x2fc80012,0x00000000,0x00000000}},	//   _lehe_, _naag_, --, --, 
   {{0x3f80013c,0x2c5003bf,0xdb0c014e,0x244002b2}},	//   _reiu_, _bądz_, ídøg, góma_, 
   {{0x2d800895,0x27ec0896,0x35b40254,0xc65002ac}},	//   _nehe_, _hoen_, _ибур, _شفاک, 
   {{0x2fc8038a,0xb544001e,0x00000000,0x00000000}},	//   _baag_, _иҧша_, --, --, 
   {{0x27ec0897,0x2fc80898,0x5f040074,0x00000000}},	//   _joen_, _caag_, езма, --, 
   {{0x2fc80899,0x27ec089a,0x3f800264,0x645800ea}},	//   _daag_, _moen_, _veiu_, _iiwi, 
   {{0x2000089b,0x27ec089c,0x64580299,0x21a4089d}},	//   shki_, _loen_, _hiwi, _чикм, 
   {{0x6458089e,0x6288089f,0x2fc800a0,0x2d8008a0}},	//   _kiwi, lseo, _faag_, _dehe_, 
   {{0x27ec08a1,0x2d8008a2,0x645808a3,0x2fc8006f}},	//   _noen_, _eehe_, _jiwi, _gaag_, 
   {{0x645808a4,0x628808a5,0x00000000,0x00000000}},	// [5a0] _miwi, nseo, --, --, 
   {{0x7f4408a6,0x2d8008a7,0x645808a8,0x62880272}},	//   _iziq, _gehe_, _liwi, iseo, 
   {{0x27ec08a9,0x2fc8038a,0xe2340020,0x00000000}},	//   _boen_, _yaag_, _ርእስና, --, 
   {{0x645808aa,0x2d800278,0x1ddc08ab,0x25a403c7}},	//   _niwi, _zehe_, मावत, _acll_, 
   {{0x27ec08ac,0x2d8002a6,0xf98400f8,0x628808ad}},	//   _doen_, _yehe_, _аҳзо, jseo, 
   {{0x27ec0278,0x64580047,0x25a402ba,0x2d8001aa}},	//   _eoen_, _aiwi, _ccll_, _xehe_, 
   {{0x645808ae,0x8cd008af,0x201000b8,0x59080126}},	//   _biwi, डियो, _omyi_, _གཟིས_, 
   {{0x27ec048d,0xb4b00310,0x645808b0,0x645401e8}},	//   _goen_, _ओही_, _ciwi, _èzil, 
   {{0x7ae408b1,0xa2cc0828,0x645808b2,0x2fc808b3}},	//   nxit, तिष्, _diwi, _raag_, 
   {{0x645808b4,0x27ec08b5,0x2fc808b6,0x7ae402ba}},	//   _eiwi, _zoen_, _saag_, ixit, 
   {{0x2d80078e,0x7f4408b7,0x2fc80616,0x89940100}},	//   _rehe_, _aziq, _paag_, עכטס_, 
   {{0x2d8008b8,0xa2cc00cb,0x645808b9,0x24400116}},	//   _sehe_, तिश्, _giwi, póma_, 
   {{0x2d8008ba,0xb8ec0126,0x04400320,0xb4b00030}},	//   _pehe_, _ྱག_, _сецн, _ओहु_, 
   {{0xa2cc0828,0x645808bb,0x2fc8062d,0x2ee000a1}},	//   तिर्, _ziwi, _waag_, _पपीत, 
   {{0x7f4408bc,0x2fc808bd,0x2d8008be,0x645808bf}},	//   _eziq, _taag_, _vehe_, _yiwi, 
   {{0x2d800160,0x41b00128,0x2fc800f2,0x00000000}},	//   _wehe_, _لمۇر, _uaag_, --, 
   {{0x2d8008c0,0x27ec08c1,0x6d40019f,0x7ae408c2}},	// [5b0] _tehe_, _roen_, ülab, gxit, 
   {{0x27ec08c3,0xfe7008c4,0x2d8003e6,0xb4b00076}},	//   _soen_, _ادي_, _uehe_, _ओहू_, 
   {{0xf770049d,0xe61008c5,0x27ec08c6,0x600402b2}},	//   ڵان_, یشت_, _poen_, _dómf, 
   {{0xe7180272,0x6d4408c7,0x62880139,0x80a008c8}},	//   ويات_, _izha, yseo, _कमसे, 
   {{0xf77008c9,0x645808ca,0x27ec02e3,0x7ae4000d}},	//   صان_, _riwi, _voen_, cxit, 
   {{0x645808cb,0x6aac00dd,0x27ec08cc,0x2bc800bd}},	//   _siwi, mtaf, _woen_, ाएका, 
   {{0x27ec08cd,0x5908011a,0x2c500098,0x628801d6}},	//   _toen_, _གཟགས_, _sądy_, wseo, 
   {{0xc44400cd,0x628808ce,0x645802b1,0x6aac08cf}},	//   ریشن_, tseo, _qiwi, otaf, 
   {{0x645808d0,0x62880320,0x764801d9,0x75280139}},	//   _viwi, useo, _fhdy, _exdz, 
   {{0x645808d1,0x628808d2,0x6d440593,0x6aac08d3}},	//   _wiwi, rseo, _ozha, itaf, 
   {{0xa3e008d4,0x628808d5,0x6728011a,0x660008d6}},	//   दाद_, sseo, _hxej, _illk, 
   {{0xbec808d7,0x628808d8,0x93100061,0xbbe00098}},	//   еңиз_, pseo, اویش, _पचेक, 
   {{0x6d4408d9,0x76480274,0x7ae408da,0xc2b000fc}},	//   _azha, _yhdy, xxit, _сөйш, 
   {{0xdb140101,0x00000000,0x00000000,0x00000000}},	//   gdyý, --, --, --, 
   {{0x6aac0547,0xc22001b8,0x5fa8006c,0xa13400cf}},	//   etaf, _لکھو, _कापल, _באַק_, 
   {{0x7ae401a7,0x6aac03ed,0x9f040046,0x00000000}},	//   txit, ftaf, _لوبو, --, 
   {{0xdfd0063a,0x7f44019b,0x6d4408db,0x660002b0}},	// [5c0] _ميں_, _uziq, _ezha, _ollk, 
   {{0x8a0008dc,0x7ae401e3,0x00000000,0x00000000}},	//   азуе, rxit, --, --, 
   {{0x7e6408dd,0x18a4043d,0x6aac08de,0x80ac0143}},	//   _huip, таем, ataf, টিক্, 
   {{0x7ae408df,0x660008e0,0x6004030f,0x0d2002ba}},	//   pxit, _allk, _dómg, _түсү, 
   {{0xc7a008e1,0x07a008e2,0x7e640139,0x68e40177}},	//   ричк, рачн, _juip, axhd, 
   {{0x7e6403f2,0x864000cc,0x00000000,0x00000000}},	//   _muip, анчж, --, --, 
   {{0x48e000f8,0x7e6408e3,0x985408e4,0x00000000}},	//   _корв, _luip, _аташ, --, 
   {{0xd1e002b4,0xccf000ca,0x44f00134,0x8cd008e5}},	//   ምዓት_, שכה_, شسىز, डितो, 
   {{0x7e6400a2,0x6014028d,0x98a803bf,0x00000000}},	//   _nuip, ešmo, _rybę_, --, 
   {{0xca3408e6,0x4644001e,0x00000000,0x00000000}},	//   ﻗﻘﺎ_, _азун_, --, --, 
   {{0x09f40107,0xcff001e0,0x00000000,0x00000000}},	//   דמים_, ليدک, --, --, 
   {{0xc0580822,0x80a008e7,0x00000000,0x00000000}},	//   кія_, _कमरे, --, --, 
   {{0x7e6408e8,0x67280126,0x66000222,0x1ddc08e9}},	//   _cuip, _xxej, _yllk, मांत, 
   {{0x27300710,0xd1740329,0xfd54004f,0x6e4408ea}},	//   ỡng_, _рыды, _hreṣ, انسم, 
   {{0xdeb00256,0xab9408eb,0xfe2408ec,0xb4b008ed}},	//   _құры, ливі, рьян, _ओहो_, 
   {{0x6aac08ee,0x63ac08ef,0x7e64015e,0x6d4401f6}},	//   ttaf, _ñant, _fuip, _vzha, 
   {{0xfb840007,0xdcec00d4,0x600402e8,0xaed403a7}},	// [5d0] рысн, fabē, _dómd, _сопш, 
   {{0x6aac08f0,0x49b808f1,0xa4cc07b5,0x6d44015b}},	//   rtaf, بارد_, ščič, _tzha, 
   {{0x67d40385,0x7e6401ed,0x5fa808f2,0x6e3401d4}},	//   ложу, _zuip, _कामल, mozb, 
   {{0x6e3408f3,0xb5fc011a,0x6aac08f4,0x21e801d4}},	//   lozb, _jiġf, ptaf, _dúhy_, 
   {{0xa3e008f5,0x3a8408f6,0x24500192,0x7cfc021c}},	//   दास_, _высв, _mšmt_, pärö, 
   {{0xd1240588,0x80a008f7,0x2a6808f8,0x600402e8}},	//   _هم_, _कमले, mqab_, _tómg, 
   {{0xc7c408f9,0x64b408fa,0x600406b4,0x00000000}},	//   _исаи, احتر, _hóme, --, 
   {{0x6e3401aa,0x600402b2,0x00000000,0x00000000}},	//   hozb, _kóme, --, --, 
   {{0xca3408e6,0x316c015e,0xdb1400f1,0x00000000}},	//   ﻗﺘﺎ_, fcdz_, ldyò, --, 
   {{0xa07408fb,0x60e808fc,0x660008fd,0x6e340070}},	//   лымш, емом_, _ullk, jozb, 
   {{0x7e6408fe,0xdcfc01d1,0x2a6801e3,0x902001ac}},	//   _suip, _pepč, hqab_, ڍڙيو, 
   {{0x7e6408ff,0x00000000,0x00000000,0x00000000}},	//   _puip, --, --, --, 
   {{0x443c0900,0xd24c0901,0x7e64044f,0x600400e3}},	//   mlu_, تنی_, _quip, _nóme, 
   {{0x443c0902,0xdca40903,0x91e00111,0x245002cc}},	//   llu_, лаги, _гоше, _všmu_, 
   {{0x443c0904,0x5bb40362,0x63ac04db,0xf1a80122}},	//   olu_, лсаф, _ñans, _شاوه_, 
   {{0x443c0905,0x7e640906,0x236c01d1,0x00000000}},	//   nlu_, _tuip, ncej_, --, 
   {{0x443c0907,0x8eb00908,0x6d4001ec,0x8c400909}},	// [5e0] ilu_, _هميش, ýlar, сете, 
   {{0x443c090a,0x7a3003c8,0x600402b2,0x9984042e}},	//   hlu_, lätz, _dóme, الاو, 
   {{0x443c090b,0x9d380125,0x00000000,0x00000000}},	//   klu_, _ɔyɛɛ_, --, --, 
   {{0x443c090c,0x2a6801f9,0xda64090d,0xae940229}},	//   jlu_, bqab_, _ماسي, _mẹnu, 
   {{0x6004090e,0x443c090f,0x74140305,0xfd680223}},	//   _góme, dlu_, یوتا, dasẹ, 
   {{0x443c0910,0x7c24038e,0x7a300911,0xd1d402b4}},	//   elu_, lnir, hätz, ራቤት_, 
   {{0x443c0912,0x29540683,0x5fa80698,0x7c240913}},	//   flu_, _вътр, _काढल, onir, 
   {{0x443c0914,0x73d80915,0xdb140031,0x06e403ba}},	//   glu_, тдир_, ldyñ, тмәк_, 
   {{0x7c240916,0x51840917,0xca3400c3,0x00000000}},	//   inir, луна, ﺗﯘﺵ_, --, 
   {{0x443c0918,0x29240919,0x236c02cc,0x00000000}},	//   alu_, špaš_, acej_, --, 
   {{0x443c091a,0x7c24091b,0x52380020,0x1164001d}},	//   blu_, knir, _ከባቢኦ, _ተናግሮ_, 
   {{0x443c091c,0x7c24091d,0xb4e00750,0x2a68018f}},	//   clu_, jnir, दमी_, yqab_, 
   {{0xa3e008e7,0x4ea4091e,0x15f80098,0x6e3401d1}},	//   दार_, ырна, _्तार_, tozb, 
   {{0x2fcc091d,0x2a6801f9,0xae9400d3,0x43700087}},	//   žeg_, vqab_, _fẹnu, _куәт, 
   {{0x2a6801f9,0x02140107,0x6004091f,0x6e3403aa}},	//   wqab_, _תחום_, _sóme, rozb, 
   {{0x7c240920,0xab740921,0x6b740922,0x0a680923}},	//   gnir, ргаш, рлау, ержи_, 
   {{0x7c280045,0x7a300274,0x6a140924,0xba740075}},	// [5f0] édra, läty, амау, مالت, 
   {{0x7c240925,0x443c0926,0x6fdc0098,0x2a680927}},	//   anir, zlu_, याकं, rqab_, 
   {{0xdd9003dc,0x443c0928,0x7a30021c,0xfbd00012}},	//   _بوپ_, ylu_, näty, _کتٍ_, 
   {{0x443c0929,0x78bc0043,0x600404ac,0x7c24092a}},	//   xlu_, _dprv, _tóme, cnir, 
   {{0x443c090c,0x66e4092b,0x7a300027,0x00000000}},	//   vlu_, рола, häty, --, 
   {{0x6abc02b0,0x443c092c,0x7a300139,0xd5ac0012}},	//   _ipsf, wlu_, käty, ِہٕ_, 
   {{0xfdf802c3,0x7a300139,0xd5840061,0xc6a402de}},	//   רצות_, jäty, شێنه_, _әрби, 
   {{0x443c092d,0x7a3002eb,0x00000000,0x00000000}},	//   ulu_, däty, --, --, 
   {{0x443c092e,0xa204092f,0x13e401c8,0x36d400fb}},	//   rlu_, ипид, рмый_, _лотр, 
   {{0xd24c0930,0xa1f40931,0x7c24007b,0x7a300932}},	//   وني_, рџиј, znir, wätz, 
   {{0x443c0933,0x7c240934,0x6004014e,0x9f400139}},	//   plu_, ynir, _rómb, nkkö_, 
   {{0x443c0935,0xdcfc0059,0x6abc0379,0x44c40031}},	//   qlu_, _nepā, _opsf, _iő_, 
   {{0x63ac0936,0xf38c007c,0x217400bf,0x7a30002a}},	//   _ñanq, _טראָ, _куйр, rätz, 
   {{0x7a30032e,0xdd9002ac,0xae940223,0xf348021d}},	//   sätz, غوز_, _tẹnu, _спіл_, 
   {{0xd24c009d,0xa0a40937,0xa2cc00cb,0x6abc0379}},	//   _تنو_, _тайд, तिक्, _apsf, 
   {{0xdcfc015b,0x7c2400c2,0xdca401d9,0x9e6401c3}},	//   _cepā, unir, лаҳи, _квид, 
   {{0x7c240938,0x999c01e5,0x600402ba,0x0ca002b4}},	// [600] rnir, _ótū_, _tómb, _ዝግለጽ_, 
   {{0x99740256,0x7c240513,0x00000000,0x00000000}},	//   руаш, snir, --, --, 
   {{0x44c40191,0x6abc02b0,0xee08007c,0xdddc01d4}},	//   _nő_, _epsf, _תּפֿ, _ripň, 
   {{0xdddc00f1,0x7c240105,0x6fc8040e,0x00000000}},	//   _sipň, qnir, िजयं, --, 
   {{0x6abc01d4,0x7bc40254,0xdb14012b,0x00000000}},	//   _gpsf, meiu, deyç, --, 
   {{0x7bc40939,0x44c400d5,0x00000000,0x00000000}},	//   leiu, _bő_, --, --, 
   {{0x7a3001c8,0xb4e0093a,0xb5fc0002,0xa3e00095}},	//   dätx, दमे_, _niġe, दां_, 
   {{0xc7a0093b,0x07a0093c,0xb6c401ec,0xf3f800d4}},	//   _миск, _масн, _гөкд, _kuģi_, 
   {{0x47d0093d,0x836001a0,0x0ca000b6,0xa2cc0095}},	//   _بيقر, زگنل, _ओम्म, तिग्, 
   {{0x44c400cd,0x1ce0011a,0xe87400cc,0x7a300027}},	//   _fő_, ྦྷོ_, _ئچەگ, täty, 
   {{0x69d8007c,0x25f4093e,0xd6b4044a,0xdb1402e6}},	//   אַרו, ्सरी_, _гiум, leyä, 
   {{0x24f4093f,0xa3e000cb,0xb5fc043b,0x63ac04db}},	//   _учур, दाः_, _diġe, _ñanp, 
   {{0x7bc40940,0xc7b00240,0x9f500223,0xb5fc0126}},	//   deiu, חבר_, _joyè_, _tiġd, 
   {{0x82300941,0x1ddc0095,0x7a300139,0x9f400139}},	//   _وروا, मागत, päty, ykkö_, 
   {{0x7bc40243,0x09cc02fa,0x00000000,0x00000000}},	//   feiu, রামা, --, --, 
   {{0x95fc00ac,0xb5fc0002,0x110400dd,0xce680942}},	//   ্চিম_, _jiġb, _مٺڙي_, _ирод_, 
   {{0xb5fc0002,0x20100943,0x3c58009e,0xdcec00e5}},	// [610] _miġb, ëzie_, ритэ_, kabė, 
   {{0x2b8401eb,0x00000000,0x00000000,0x00000000}},	//   ặc_, --, --, --, 
   {{0xc7c40944,0x7bc4034c,0x60040945,0xac180300}},	//   исди, beiu, _hóma, _бону_, 
   {{0x7bc40254,0xf7f404c3,0x600400f1,0xb5fc0560}},	//   ceiu, يسند, _kóma, _niġb, 
   {{0x6b8c0946,0x25f405d5,0x09cc02fa,0xa5f80947}},	//   maag, ्सली_, রাবা, леду_, 
   {{0x6b8c0948,0x63b80335,0x80ac0143,0x2c040123}},	//   laag, _sbwn, য়িত্, _тӯҳм, 
   {{0x69c40949,0x247c010f,0x070400e2,0xe380001d}},	//   mehe, _ጥቅምት_, ديږي_, _የቀረበ_, 
   {{0x6b8c094a,0x69c4094b,0xf7700121,0xb5fc0560}},	//   naag, lehe, _ياق_, _riġe, 
   {{0x6004094c,0x65940254,0x6b8c012a,0x2168094d}},	//   _nóma, _газу, iaag, липи_, 
   {{0xa204094e,0x69c4094f,0x26cc0074,0x6b8c0950}},	//   спод, nehe, _iseo_, haag, 
   {{0x6b8c0951,0x629c0212,0x6d4000af,0x00000000}},	//   kaag, ásob, ülal, --, 
   {{0x92c4007e,0xdcfc0513,0x6b8c0952,0xb5fc011a}},	//   _উপৰ_, _lepă, jaag, _viġe, 
   {{0x69c40953,0x6b8c0954,0xe2980955,0x7bc40956}},	//   kehe, daag, _сал_, veiu, 
   {{0x63a80957,0x69c40958,0x60040959,0x26cc034a}},	//   lgen, jehe, _dóma, _mseo_, 
   {{0x63a8095a,0x6b8c095b,0x7bc400c2,0x6c740094}},	//   ogen, faag, teiu, жуух, 
   {{0x63a8095c,0x6b8c095d,0x15a4095e,0x60140023}},	//   ngen, gaag, ﺎﻗﺘﯩ, kšmi, 
   {{0x69c4039d,0x63a8095f,0x7bc40960,0x60040961}},	// [620] fehe, igen, reiu, _góma, 
   {{0x63a80962,0x20000963,0x9f50014a,0x7bc40034}},	//   hgen, lkki_, _noyé_, seiu, 
   {{0x63a8002c,0x395c046a,0x26cc0964,0xdcfc038e}},	//   kgen, ävs_, _aseo_, _depă, 
   {{0x6b8c070b,0x200006ea,0x63a80965,0xa6e80048}},	//   caag, nkki_, jgen, _trự, 
   {{0x9f5007d4,0x69c40966,0xb4e00828,0xa3e00967}},	//   _boyé_, behe, दम्_, दाई_, 
   {{0x69c400f5,0x63a80968,0x473001f5,0xb694001d}},	//   cehe, egen, чніс, _ኃይለኛ_, 
   {{0x63a80969,0x26cc00cf,0x24840086,0xddd4004f}},	//   fgen, _eseo_, _cwlm_, _atyū, 
   {{0x63a8096a,0x681406f7,0xc87c039c,0xb274096b}},	//   ggen, ządz, ışta_, олиш, 
   {{0xb1c80121,0xdcec028d,0x00000000,0x00000000}},	//   иңда_, pabė, --, --, 
   {{0x6004096c,0x6b8c096d,0x2000096e,0xa2cc0095}},	//   _róma, zaag, ekki_, तिज्, 
   {{0x6b8c096f,0xd24c00dd,0x24840086,0xb5fc043b}},	//   yaag, ونڊ_, _gwlm_, _tiġb, 
   {{0x63a8014a,0xc4d00107,0x69c40970,0x6b8c0080}},	//   cgen, _מגע_, zehe, xaag, 
   {{0x69c40971,0x934400df,0x03a00123,0x70540012}},	//   yehe, _унде, _хичо, ٝنگا, 
   {{0x6b8c0972,0x38780177,0x20000027,0x15f800aa}},	//   waag, _otrr_, akki_, ्सिर_, 
   {{0x6b8c0973,0x69c40974,0x15a40975,0x00000000}},	//   taag, vehe, ﺎﺗﺘﯩ, --, 
   {{0x69c40976,0x60040977,0x68140098,0xa2cc0474}},	//   wehe, _tóma, sądz, तिच्, 
   {{0x69c40978,0x15f80979,0xea18097a,0xdb2000d3}},	// [630] tehe, ्सार_, ажаш_, _àtìy, 
   {{0x26cc072f,0x6b8c097b,0x63a8097c,0x69c40039}},	//   _rseo_, saag, zgen, uehe, 
   {{0x63a8097d,0x0948097e,0x6b8c097f,0x69c40980}},	//   ygen, учаи_, paag, rehe, 
   {{0x69c40981,0x600400c4,0x6b8c0982,0x2678038e}},	//   sehe, _lómn, qaag, аскэ_, 
   {{0x69c404f7,0xefd00020,0xe7380106,0x00000000}},	//   pehe, _ብኢድ_, јел_, --, 
   {{0x601401c3,0x69c40083,0x2a7800ce,0x41d403bf}},	//   ršmi, qehe, _itsb_, _भोंस, 
   {{0x63a80983,0x20000984,0xa3e80985,0x9f5000f1}},	//   tgen, ykki_, идка_, _voyé_, 
   {{0x63a80986,0x26cc0987,0xe2980329,0xe2c80988}},	//   ugen, _tseo_, ааи_, لوبو_, 
   {{0x23280989,0xe298098a,0xa0240139,0x00000000}},	//   ропи_, шап_, htöä, --, 
   {{0x63a8098b,0xdb04014a,0x00000000,0x00000000}},	//   sgen, âmée, --, --, 
   {{0xd12c0191,0x60040038,0x00000000,0x00000000}},	//   ہمی_, _dómn, --, --, 
   {{0x20540023,0x00000000,0x00000000,0x00000000}},	//   ўтор, --, --, --, 
   {{0x200006ea,0xe2980106,0x00000000,0x00000000}},	//   rkki_, _ђак_, --, --, 
   {{0x320c0335,0x00000000,0x00000000,0x00000000}},	//   chdy_, --, --, --, 
   {{0x2120098c,0x3d040098,0x00000000,0x00000000}},	//   _ähh_, रनें_, --, --, 
   {{0x1c4407ce,0xcb640668,0x63bc01d9,0x00000000}},	//   інам, жате_, еsni, --, 
   {{0x198800f8,0x8af402df,0x00000000,0x00000000}},	// [640] ибаи_, şənl, --, --, 
   {{0x7f44019b,0xa2a0098d,0x00000000,0x00000000}},	//   _iyiq, _खिन्, --, --, 
   {{0x247401d3,0x00000000,0x00000000,0x00000000}},	//   _yāme_, --, --, --, 
   {{0xefd00020,0x87e0012b,0x00000000,0x00000000}},	//   _ብኢደ_, дюше, --, --, 
   {{0xdddc0197,0x244001d4,0x00000000,0x00000000}},	//   _lipō, nómu_, --, --, 
   {{0xd498098e,0x15b800cc,0x5d780100,0x1dc80095}},	//   ари_, рыды_, באַק, ाजित, 
   {{0x1db0098f,0x999800a2,0xc9240094,0x00000000}},	//   _जानत, hopū_, _дорж_, --, 
   {{0x7f440990,0x99980299,0x045001e0,0xa3e003bf}},	//   _oyiq, kopū_, وئيد, दाग_, 
   {{0x2488091d,0x1dc80991,0x320c0335,0x247401d3}},	//   ćama_, ाजात, thdy_, _rāme_, 
   {{0x2474008b,0x6ed800bd,0x244002b2,0x00000000}},	//   _sāme_, मिसु, dómu_, --, 
   {{0x7f440992,0x60040993,0x10480994,0xdb0403c8}},	//   _ayiq, _cómo, иями_, _abkü, 
   {{0x320c0995,0x15f8006c,0x8f08018f,0x00000000}},	//   shdy_, ्सवर_, ахга_, --, 
   {{0x81bc0143,0x201002bb,0x24740095,0x00000000}},	//   ঁয়_, ëzia_, _vāme_, --, 
   {{0xa0240139,0x00000000,0x00000000,0x00000000}},	//   ttöä, --, --, --, 
   {{0x7f440996,0x24740997,0x0b880123,0xcf980197}},	//   _eyiq, _tāme_, исаи_, _кјп_, 
   {{0x3864042e,0xa2a000bd,0x00000000,0x00000000}},	//   _nimr_, _खिम्, --, --, 
   {{0x09cc0143,0xa0240027,0x00000000,0x00000000}},	// [650] রাসা, stöä, --, --, 
   {{0x1db00828,0x386400c2,0x00000000,0x00000000}},	//   _जायत, _aimr_, --, --, 
   {{0x2d900998,0x60300059,0x02b40095,0x00000000}},	//   maze_, sāme, _अह्न, --, 
   {{0x2d900999,0xdcd80100,0x0ca4011e,0x00000000}},	//   laze_, _פֿיש, गढीम, --, 
   {{0xc87c01c8,0x4dfc0227,0xb5fc043b,0x1db00098}},	//   ışqa_, _ईकाई_, _siġa, _जामत, 
   {{0x2d90099a,0xb5fc0126,0xdc540122,0x00000000}},	//   naze_, _piġa, _ورێک, --, 
   {{0x69d4099b,0xf8b4038e,0x92a802fa,0x4ab800b6}},	//   _iaze, _обрэ, খবো_, _उहँव, 
   {{0x6d44002a,0x600402d9,0x00000000,0x00000000}},	//   _myha, _rómo, --, --, 
   {{0x2d90099c,0x69d4099d,0x600404ac,0x26d804ac}},	//   kaze_, _kaze, _sómo, _éso_, 
   {{0x69d4099e,0x659405bc,0x2d90099f,0x232806a0}},	//   _jaze, _хажу, jaze_, _қоли_, 
   {{0x69d409a0,0x6d4409a1,0x3b0009a2,0x290001b8}},	//   _maze, _nyha, zyiq_, nyha_, 
   {{0x69d409a3,0x3170002c,0x4ab80030,0x00000000}},	//   _laze, нғәт, _उहंव, --, 
   {{0x6d4409a4,0x216809a5,0xb5fc0560,0x2d900237}},	//   _ayha, _лили_, _miġn, faze_, 
   {{0x2d9009a6,0x69d409a7,0x6d440790,0x6004000f}},	//   gaze_, _naze, _byha, _tómo, 
   {{0x290000b8,0xdcb009a8,0xacf40012,0x00000000}},	//   jyha_, عىر_, وسِت, --, 
   {{0x9f8402c2,0x00000000,0x00000000,0x00000000}},	//   _эгид, --, --, --, 
   {{0x7f44019b,0x6d44043e,0xee3802dc,0x9f0409a9}},	// [660] _uyiq, _eyha, ёнӣ_, _رودو, 
   {{0x4a4009aa,0x442c0078,0x6d440086,0xed5802dc}},	//   енув, _ljg_, _fyha, соӣ_, 
   {{0x9d4409ab,0x290001b8,0x1c440027,0x00000000}},	//   _хенд, gyha_, _нном, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d409ac,0xb4e409ad,0x00000000,0x00000000}},	//   _faze, कम्प_, --, --, 
   {{0x442c09ae,0x00000000,0x00000000,0x00000000}},	//   _ajg_, --, --, --, 
   {{0x2d840191,0x7e6002ba,0x948402ba,0x00000000}},	//   űleg_, ímpy, чылд, --, 
   {{0x69d409af,0x2d9009b0,0x442c018c,0x799c02b0}},	//   _zaze, zaze_, _cjg_, _hdrw, 
   {{0xa3e009b1,0x2d9009b2,0x69d409b3,0x442c00f2}},	//   दाज_, yaze_, _yaze, _djg_, 
   {{0x2d90041c,0x8af8067a,0xd2580106,0x69d4012b}},	//   xaze_, צהיי, љци_, _xaze, 
   {{0xd54801b5,0x442c006f,0x2d900192,0x600409b4}},	//   _الاو_, _fjg_, vaze_, _tóml, 
   {{0x2d9009b5,0x4dc80256,0x9f500031,0x6d440085}},	//   waze_, ﻪﺗﯩﻨ, _alyñ_, _ryha, 
   {{0x2d9009b6,0x91e409b7,0x00000000,0x00000000}},	//   taze_, _ноде, --, --, 
   {{0x6d440329,0x1db0006c,0x00000000,0x00000000}},	//   _pyha, _जाणत, --, --, 
   {{0x69d409b8,0xc1b80240,0xa3e0006c,0x38a00254}},	//   _raze, _המוש, दाच_, nără_, 
   {{0x69d409b9,0x2d9009ba,0x799c054f,0x6d440113}},	//   _saze, saze_, _adrw, _vyha, 
   {{0xfb3409bb,0x247409bc,0xed5800df,0xb5fc011a}},	// [670] ентэ, _māma_, соң_, _riġn, 
   {{0x799c0379,0x603009bd,0x69d402df,0x5e68004b}},	//   _cdrw, māma, _qaze, _گٔیہ_, 
   {{0x3d200252,0x799c0336,0x09cc00dc,0x00000000}},	//   _মুঠ্_, _ddrw, রালা, --, 
   {{0x2474076f,0x69d409be,0x290009bf,0x8d84005e}},	//   _nāma_, _waze, ryha_, _بشکن, 
   {{0x603009c0,0xd7ec09c1,0x69d409c2,0x799c02b0}},	//   nāma, شكو_, _taze, _fdrw, 
   {{0x68e00191,0x7d0809c3,0x29000329,0x212000fc}},	//   _áldo, ødsg, pyha_, _ýhhg_, 
   {{0x24880815,0x60300828,0xfbd00122,0x00000000}},	//   ćamo_, hāma, _شتێ_, --, 
   {{0x60300828,0xe7940061,0xd074001d,0x00000000}},	//   kāma, _زارک, _አሰራሩ_, --, 
   {{0x7c2803b2,0x247409c4,0x00000000,0x00000000}},	//   édri, _dāma_, --, --, 
   {{0x85b801b5,0x38a00254,0xa3b009c5,0x603009c6}},	//   _دارس_, bără_, ञ्ज_, dāma, 
   {{0x6b9c0379,0x9fc809c7,0x00000000,0x00000000}},	//   _odsg, огна_, --, --, 
   {{0x603003f2,0x442c01e3,0x00000000,0x00000000}},	//   fāma, _ujg_, --, --, 
   {{0x644809c8,0x443c09c9,0x9440013f,0x00000000}},	//   mlei, mou_, _جھون, --, 
   {{0x443c09ca,0x6b9c021d,0xe10802ba,0x00000000}},	//   lou_, _adsg, _мелд_, --, 
   {{0x644809cb,0x1d0809cc,0x247400a8,0x00000000}},	//   olei, цеви_, _yāma_, --, 
   {{0x644809cd,0x443c09ce,0xa3b009cf,0xcbf403ef}},	//   nlei, nou_, ञ्च_, ीसगढ_, 
   {{0x644809d0,0x443c09d1,0x600400c4,0x8c4009d2}},	// [680] ilei, iou_, _lómk, тете, 
   {{0x644809d3,0xeb54041b,0x443c09d4,0x3e740027}},	//   hlei, رىلگ, hou_, _iät_, 
   {{0x644809d5,0x443c09d6,0x3e7409d7,0xd7f8038e}},	//   klei, kou_, _hät_, жул_, 
   {{0x443c09d8,0x64480337,0x3e7409d9,0x5748041c}},	//   jou_, jlei, _kät_, озем_, 
   {{0x443c09da,0x644809db,0x247400cb,0x629c0191}},	//   dou_, dlei, _rāma_, ásol, 
   {{0x644809dc,0x7c24030b,0x443c05d8,0x3e7409dd}},	//   elei, liir, eou_, _mät_, 
   {{0x443c09de,0x3e7401c9,0x94a800c5,0xd9440091}},	//   fou_, _lät_, ітка_, _цеви, 
   {{0x644809df,0x443c09e0,0x7c2409e1,0x60300828}},	//   glei, gou_, niir, yāma, 
   {{0x3e7401c9,0xcd4c001d,0x24740095,0x56280074}},	//   _nät_, _በድንገ, _vāma_, _джам_, 
   {{0x7c2409e2,0x644809e3,0x38a000c2,0x00000000}},	//   hiir, alei, pără_, --, 
   {{0x644809e4,0x6fb409e5,0x931403a2,0x7c2409e6}},	//   blei, ىمدا, _ڪوشش, kiir, 
   {{0x443c09e7,0x60300828,0x7c2409e8,0x940003a2}},	//   cou_, tāma, jiir, _ڳوڙه, 
   {{0x7c2409e9,0x6b9c0177,0x25f4006c,0x69c0012b}},	//   diir, _rdsg, ्सची_, _öleg, 
   {{0x603009ea,0x3e740638,0x6004059b,0x14c0006c}},	//   rāma, _dät_, _lómh, _शहाण, 
   {{0x7c2409eb,0x603000cb,0xb5fc0560,0x00000000}},	//   fiir, sāma, _riġl, --, 
   {{0x7c240266,0x7df80152,0x09a4072d,0x4fc40152}},	//   giir, _aşsı, खल्य, _цска, 
   {{0xfc640668,0xaa5400e1,0xc27800cf,0x00000000}},	// [690] търн, еваш, ַראי, --, 
   {{0x443c09ec,0x644809ed,0x7c24007b,0xa2a000a1}},	//   zou_, zlei, aiir, _खिस्, 
   {{0x443c09ee,0x7c2409ef,0x644809f0,0x3d00052c}},	//   you_, biir, ylei, रहणे_, 
   {{0x27e809f1,0x443c09f2,0x7c2409f3,0x64480008}},	//   ñan_, xou_, ciir, xlei, 
   {{0x443c09f4,0x644809f5,0x600409f6,0x65c40091}},	//   vou_, vlei, _dómh, ебла, 
   {{0x443c09f7,0x644809f8,0x6aac09f9,0x19e40126}},	//   wou_, wlei, muaf, སྐྱབ, 
   {{0x443c09fa,0x6004045d,0x644809fb,0xe3b003e0}},	//   tou_, _fómh, tlei, هرة_, 
   {{0x37a809fc,0x443c00a2,0xd180006b,0x00000000}},	//   _отун_, uou_, ңлый, --, 
   {{0x644809fd,0x6aac09fe,0x20100222,0xb5fc043b}},	//   rlei, nuaf, ëzim_, _miġj, 
   {{0x443c09ff,0xe1f003e0,0xb6100828,0x3e740a00}},	//   sou_, اسة_, āṣit, _rät_, 
   {{0x60240a01,0x443c0a02,0x6aac03e6,0xa438021c}},	//   една, pou_, huaf, _езжу_, 
   {{0x60040a03,0x443c0264,0x6aac0a04,0x64480008}},	//   _kómi, qou_, kuaf, qlei, 
   {{0x7c240a05,0x4f040a06,0x247401d3,0x600400f2}},	//   viir, енян_, _kāmo_, _jómi, 
   {{0xdd900a07,0x2c740184,0x600402ba,0x69c00a08}},	//   طور_, _båd_, _mómi, र्मी, 
   {{0x7c240a09,0xd00c0a0a,0x3e74012b,0x91b40a0b}},	//   tiir, _گلي_, _wät_, _נפקא_, 
   {{0x3e740a0c,0x6aac0a0d,0x2c740a0e,0x8c400a0f}},	//   _tät_, fuaf, _dåd_, гесе, 
   {{0x60040a10,0x7c240a11,0x1f640302,0xd00c0a12}},	// [6a0] _nómi, riir, _яким, _دلي_, 
   {{0x7c2404bb,0x0b400a13,0x600401ca,0xa3b00098}},	//   siir, унун, _sómh, फ़्त_, 
   {{0x7c240a14,0x1be80a15,0xdb140387,0x6d400a16}},	//   piir, _едни_, leyü, ülat, 
   {{0x95f803b6,0x7c240a17,0x2c0001c4,0x00000000}},	//   ्स्ट_, qiir, _күсм, --, 
   {{0x60040993,0xdb04002a,0x3d080030,0x6d400126}},	//   _cómi, _abkö, सनके_, żlat, 
   {{0x20100a18,0x60040a19,0x99980098,0x0f340100}},	//   ëzij_, _dómi, żyły_, ערסט_, 
   {{0x6fb0006c,0x60040a1a,0x00000000,0x00000000}},	//   _झालं, _tómh, --, --, 
   {{0xccf00a1b,0xb5fc0126,0x044003e9,0x148401ac}},	//   רכה_, _xiġj, лејн, وپڙي_, 
   {{0x07b40075,0x600402b2,0x07a00074,0xc7a00129}},	//   _سهلة_, _gómi, _щатн, _щитк, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3134039c,0x531400ea,0xe9f8000d,0x00000000}},	//   тенр, _ګذار, huế_, --, 
   {{0x2c740a1c,0x00000000,0x00000000,0x00000000}},	//   _råd_, --, --, --, 
   {{0x69c0040e,0x2474004f,0x00000000,0x00000000}},	//   र्डी, _yāmo_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa4a400d3,0x00000000,0x00000000,0x00000000}},	//   _ibòí, --, --, --, 
   {{0xdfd00a1d,0x59c40021,0x6aac0a1e,0x7c840385}},	//   _نيٺ_, _रॉबर, tuaf, ѓусе, 
   {{0x7b740272,0x314c02b4,0x49c80798,0x53c00a1f}},	// [6b0] اطفا, _ማሕበር, зуем_, व्यश, 
   {{0x6d400a20,0x00000000,0x00000000,0x00000000}},	//   ülas, --, --, --, 
   {{0x6aac0271,0x48a80a21,0x247400cb,0xac180a22}},	//   suaf, ятам_, _rāmo_, _жону_, 
   {{0xa2a003b6,0x629c0191,0x6aac05e1,0xf7700a23}},	//   _खिल्, ások, puaf, ماه_, 
   {{0x6aac0074,0xc6680673,0x00000000,0x00000000}},	//   quaf, чшее_, --, --, 
   {{0x60040a24,0x64a40a25,0xa5640a26,0xd7000a27}},	//   _vómi, вака, نگان, рзши, 
   {{0xe8940182,0x69c001a4,0x2904030f,0xb60400e5}},	//   _шавь, र्णी, _æla_, ыяцк, 
   {{0x600409b4,0x69c00386,0x86b001d2,0x00000000}},	//   _tómi, _öleb, _бәкі, --, 
   {{0x27ec0a28,0x69c00a29,0x64b401d5,0x05840027}},	//   _inen_, र्थी, dřiš, _зуем, 
   {{0x60300a2a,0x09cc0143,0x00000000,0x00000000}},	//   tāmo, রাকা, --, --, 
   {{0xba04010f,0x21680111,0xf4840a2b,0x399c01d5}},	//   _ግድ_, ќини_, _бучн, lásí_, 
   {{0x69c00a2c,0xe1f00a2d,0x00000000,0x00000000}},	//   र्ती, اسک_, --, --, 
   {{0xf58400cc,0x00000000,0x00000000,0x00000000}},	//   _ششەپ, --, --, --, 
   {{0x603000a2,0xfe780182,0x21a40a2e,0x614400ec}},	//   pāmo, _үүн_, _рикм, _иела, 
   {{0x64580a2f,0x27ec0a30,0xaec0024b,0x20180075}},	//   _khwi, _onen_, _құрл, _يتبع_, 
   {{0xdb1400f1,0x27ec002a,0x00000000,0x00000000}},	//   deyò, _nnen_, --, --, 
   {{0x19940106,0xdb0c0a31,0xda640a32,0x00000000}},	// [6c0] вјер, _öküz, ناطي, --, 
   {{0x204c0090,0x27ec0a33,0x00000000,0x00000000}},	//   _ማህበረ, _anen_, --, --, 
   {{0x69c00a34,0x00000000,0x00000000,0x00000000}},	//   र्धी, --, --, --, 
   {{0x645804cd,0x8c40039c,0x661c0007,0x1dc80a35}},	//   _nhwi, äşte, _įska, ाजकत, 
   {{0xc6d00a36,0x00000000,0x00000000,0x00000000}},	//   لتوت, --, --, --, 
   {{0x27ec0a37,0x997402ba,0x00000000,0x00000000}},	//   _enen_, _шумш, --, --, 
   {{0xb5fc0002,0xaad400d3,0x00000000,0x00000000}},	//   _jiġi, _òlòó_, --, --, 
   {{0x64580a38,0x98340822,0x38bc0a39,0x27ec0278}},	//   _chwi, _рэгі, mír_, _gnen_, 
   {{0x51840a3a,0xf5b400cd,0x96640a3b,0xb5fc0002}},	//   куна, _مشاھ, _акае, _liġi, 
   {{0xf66400cc,0x5330001e,0x00000000,0x00000000}},	//   _сезү, леқт, --, --, 
   {{0x6004014e,0x7648012c,0x9f9c0152,0x00000000}},	//   _lómu, _ikdy, kçäk_, --, 
   {{0x53440a3c,0x03a00a3d,0x09dc006c,0x00000000}},	//   _ихла, _вицо, _नफ्य, --, 
   {{0x38bc0a3e,0x40340a3f,0x4ea40348,0x61ec059b}},	//   hír_, реяс, ърна, ánlí, 
   {{0x2704007e,0x420402dc,0x00000000,0x00000000}},	//   _শেডো_, _инчо_, --, --, 
   {{0x82bc0002,0x600404dc,0x3d94044a,0x64b40192}},	//   _མདོའ, _rómv, риср, přiš, 
   {{0xb5fc0002,0x645808c2,0xc0c40a40,0x600406b4}},	//   _diġi, _xhwi, _руше_, _bómu, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6d0] --, --, --, --, 
   {{0x27ec01e7,0x6004020f,0x8d54006b,0x09040a41}},	//   _snen_, _dómu, _үтүч, кчем, 
   {{0xe5a40409,0x27ec01df,0x38bc02b2,0x00000000}},	//   ҳили, _pnen_, gír_, --, 
   {{0xac1800c8,0x764802e6,0xfb84070b,0x9200004f}},	//   _чому_, _akdy, _вырн, _śālo, 
   {{0xf7700a42,0xe5a40a43,0xa6c40a44,0x82bc043b}},	//   زان_, гили, اقتى, _མདེའ, 
   {{0xd6cc0200,0x64580a45,0x00000000,0x00000000}},	//   سقى_, _shwi, --, --, 
   {{0x25a80a46,0x6458075d,0x00000000,0x00000000}},	//   ğal_, _phwi, --, --, 
   {{0x27ec0a47,0x00000000,0x00000000,0x00000000}},	//   _unen_, --, --, --, 
   {{0x36d40302,0xdb1405c0,0x53c400fc,0x00000000}},	//   _котр, neyð, угым_, --, 
   {{0x71a40049,0xd24c00e3,0x00000000,0x00000000}},	//   ңаөз, ےنی_, --, --, 
   {{0x66000151,0xe1240a48,0x00000000,0x00000000}},	//   _iolk, умни, --, --, 
   {{0x66000a49,0x6abc0126,0xc5e802fa,0xb5fc0126}},	//   _holk, _oqsf, _কতটা_, _riġi, 
   {{0x66000a4a,0x76480937,0xb5fc043b,0x7e6001ed}},	//   _kolk, _ykdy, _siġi, ïmpo, 
   {{0x6004014e,0xb5fc0126,0x66000a4b,0x712402ac}},	//   _rómu, _piġi, _jolk, اریل, 
   {{0x66000a4c,0x6abc06e2,0x38bc03aa,0x44e002a0}},	//   _molk, _aqsf, xír_, _jı_, 
   {{0x66000a4d,0x44e00a4e,0x600404ac,0x59c40a4f}},	//   _lolk, _mı_, _pómu, र्नर, 
   {{0x44e00a50,0x600402b2,0xdee401f1,0x66000a51}},	// [6e0] _lı_, _dómt, _сопи, _oolk, 
   {{0x3ea00960,0xdddc00f1,0xb5fc0002,0x4d440108}},	//   _ivit_, _sipņ, _tiġi, _әпюн_, 
   {{0x44e00a52,0x3ea0021d,0x57a40094,0x00000000}},	//   _nı_, _hvit_, гшла, --, 
   {{0xb8dc0a53,0x3ea0007e,0x204c010f,0x1cdc0126}},	//   _आम_, _kvit_, _ማኅበረ, _རླག_, 
   {{0xc7a00a54,0x224403f4,0xd7080152,0xf1b8011a}},	//   сичк, kolk_, энде_, siġi_, 
   {{0x7ae40a55,0x38bc0a56,0x66000060,0x44e00a57}},	//   mvit, pír_, _colk, _bı_, 
   {{0x7ae40a58,0x44e0038c,0x3f800243,0x66000085}},	//   lvit, _cı_, _ofiu_, _dolk, 
   {{0x33740a59,0x8d58007c,0x44e00a5a,0x7ae40a5b}},	//   шгир, עכקי, _dı_, ovit, 
   {{0x66000a5c,0x7ae40a5d,0x22440a5e,0x69c00a5f}},	//   _folk, nvit, folk_, र्वी, 
   {{0x66000a60,0x7e600400,0x66800a61,0x7ae40a62}},	//   _golk, ïmpl, _بیول, ivit, 
   {{0x59c40a63,0x3ea000f1,0x7ae40a64,0x44e001c8}},	//   र्यर, _avit_, hvit, _gı_, 
   {{0x66000a65,0x5338070b,0x00000000,0x00000000}},	//   _zolk, _пулă, --, --, 
   {{0x66000a66,0x3ea002db,0x22440a67,0x7ae40444}},	//   _yolk, _cvit_, bolk_, jvit, 
   {{0x27300710,0x7ae40a68,0x44e00333,0x1cdc0560}},	//   ạng_, dvit, _yı_, _རླང_, 
   {{0x3ea00a69,0x7bc40a6a,0x8bc40a6b,0xfe240a6c}},	//   _evit_, ffiu, лсад, сьян, 
   {{0x60040984,0x3a38034a,0x60c400af,0x7ac40a6d}},	//   _dóms, _ajrp_, _ähma, әсте, 
   {{0xaed404e7,0xce680118,0x7ae40a6e,0x59c40a6f}},	// [6f0] _топш, _прод_, gvit, र्भर, 
   {{0x09cc0252,0xdb140a70,0x7bc4012a,0xfaa80a71}},	//   ৰাভা, reyð, afiu, اهلي_, 
   {{0x2d800a72,0x7ae40a73,0x2ee80593,0xb5fc0560}},	//   _ifhe_, avit, _hraf_, _jiġu, 
   {{0x2ee80a74,0x66000a75,0x47700200,0x44e00a76}},	//   _kraf_, _solk, сқау, _rı_, 
   {{0xb8fc0a77,0x44e00a78,0x6f1c0a79,0x00000000}},	//   _तै_, _sı_, nzsc, --, 
   {{0x6b8c0a7a,0x24740296,0x66000012,0x69c00a7b}},	//   lbag, _hāmi_, _qolk, र्शी, 
   {{0x66000a7c,0x2244062d,0x67d40a7d,0x6b8c0331}},	//   _volk, volk_, _кову, obag, 
   {{0x66000a7e,0x69c40a7f,0x6b8c0a80,0x22440a81}},	//   _wolk, lfhe, nbag, wolk_, 
   {{0x21f40302,0x625801ef,0xe2980294,0xca340a82}},	//   аїнс, крор_, њао_, ﺗﺘﺎ_, 
   {{0x2fc8025e,0x20c40302,0x69c40075,0x6b8c0a83}},	//   _abag_, айом, nfhe, hbag, 
   {{0x7ae40a84,0x3ea00a85,0x2ee80a86,0x6b8c036d}},	//   zvit, _svit_, _araf_, kbag, 
   {{0x6aac0a87,0x71580a88,0x2ee80336,0x2d940130}},	//   kraf, ырыс_, _braf_, ɔdeɛ_, 
   {{0x1f540a89,0x68e00010,0x60300a8a,0xfbd00252}},	//   ртнё, _âldf, nāmi, ৱামত, 
   {{0x62880a8b,0x6aac0a8c,0x2ee80a8d,0x2484034a}},	//   mpeo, draf, _draf_, _ktlm_, 
   {{0x2ee80a8e,0x7bc40a03,0x62880a8f,0x6b8c006f}},	//   _eraf_, tfiu, lpeo, fbag, 
   {{0x6b8c0a90,0x7ae40a91,0x69c40a92,0x62880a93}},	//   gbag, tvit, efhe, opeo, 
   {{0x7bc40a94,0x9aa40a95,0x6e34018c,0x7ae40496}},	// [700] rfiu, شماو, bnzb, uvit, 
   {{0x20e40299,0x6b8c0a96,0x60040038,0x61e008c2}},	//   _kēi_, abag, _tóms, ndll, 
   {{0x7ae40a97,0x60c00a98,0x6b8c0a99,0x186801f1}},	//   svit, ntlm, bbag, важи_, 
   {{0x6aac0085,0x69c00a9a,0x60300369,0x69c40a9b}},	//   braf, _ölen, fāmi, afhe, 
   {{0xda640a9c,0x603000cb,0x68e40177,0xae18006b}},	//   _ناسي, gāmi, avhd, _çıñg, 
   {{0x25a40335,0x69c40a9d,0xceb000ca,0x00000000}},	//   _cdll_, cfhe, קיו_, --, 
   {{0x59c40a9e,0xdcfc00ce,0x61e00335,0x6f1c0207}},	//   र्णर, _iepē, ddll, zzsc, 
   {{0xd944022e,0xb2b80a2e,0x00000000,0x00000000}},	//   _беҳи, глиф_, --, --, 
   {{0x73c4016d,0x3878006f,0x603000e0,0xd408005e}},	//   _ғәйе, _hurr_, cāmi, فتکم_, 
   {{0x1db00a9f,0x387802b4,0xde780200,0x2ee802bb}},	//   _जागत, _kurr_, ﻣﻪﺗﺮ_, _rraf_, 
   {{0x7d080aa0,0x855400d5,0x6b8c0aa1,0x00000000}},	//   ødsl, _پیٹر_, ybag, --, 
   {{0x6f1c0aa2,0x38780aa3,0x2ee80254,0x64c001d7}},	//   tzsc, _murr_, _praf_, ịich, 
   {{0xac1800f8,0xb8e8011a,0xb8d8011a,0x69c403f4}},	//   ҳову_, _ཉཱ_, _མཀ_, yfhe, 
   {{0x6aac01c7,0x6f1c0aa4,0x8d1400f8,0xb5fc011a}},	//   vraf, rzsc, ангӣ_, _tiġu, 
   {{0xac18005b,0x6b8c0aa5,0x24500048,0xd0180aa6}},	//   гову_, tbag, _sơmi_, _афп_, 
   {{0x6aac0aa7,0x2ee80aa8,0x6b740aa9,0x6b8c006f}},	//   traf, _traf_, слау, ubag, 
   {{0x6b8c0aaa,0xed58002c,0x6aac018c,0xc9840aab}},	// [710] rbag, тоң_, uraf, لشاي, 
   {{0x6aac0aac,0x38780aad,0xdcfc015b,0x6b8c0aae}},	//   rraf, _burr_, _cepē, sbag, 
   {{0x38780aaf,0xc86402ac,0x69c40075,0x24740ab0}},	//   _curr_, атди, rfhe, _tāmi_, 
   {{0x62880ab1,0x24840ab2,0x6aac0ab3,0x64a401c4}},	//   ypeo, _rtlm_, praf, ҡала, 
   {{0xa6c80ab4,0x66e400b2,0x6aac009f,0x69c4002a}},	//   улла_, сола, qraf, pfhe, 
   {{0x3878011a,0x00000000,0x00000000,0x00000000}},	//   _furr_, --, --, --, 
   {{0x38780ab5,0x00000000,0x00000000,0x00000000}},	//   _gurr_, --, --, --, 
   {{0xd3440122,0xa0a400ec,0x00000000,0x00000000}},	//   ڕینه_, ҙамд, --, --, 
   {{0xa71406d4,0x26cc00dd,0xb6e4012b,0x00000000}},	//   _удаљ, _upeo_, _мюфк, --, 
   {{0xe1f80ab6,0xe0e400d3,0x00000000,0x00000000}},	//   уго_, _òòka_, --, --, 
   {{0xd24c0ab7,0x655400dd,0x62880ab8,0x244001d4}},	//   رچه_, _اپاء, speo, zómy_, 
   {{0x60040ab9,0x9f040272,0x7d08021d,0x62880aba}},	//   _cómp, موجو, ødsm, ppeo, 
   {{0x201c0822,0x61e0070b,0x64480abb,0xe2840abc}},	//   ėti_, pdll, moei, _улли, 
   {{0x64480abd,0x99e00143,0x00000000,0x00000000}},	//   loei, _মক্ক, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64480abe,0xb5fc0002,0x1e840152,0x244000c0}},	//   noei, _jiġr, _ллим, tómy_, 
   {{0x2a700308,0x3878006f,0x2a780080,0x00000000}},	// [720] _bizb_, _surr_, _cusb_, --, 
   {{0x644801ed,0x38780abf,0xd94401c7,0x00000000}},	//   hoei, _purr_, бези, --, 
   {{0x1d080ac0,0x64480618,0xb4c8025c,0xcd7400cf}},	//   _сени_, koei, _ोने_, _לעיק_, 
   {{0x2ca40ac1,0xb5fc011a,0x644800b7,0x3878013c}},	//   âlde_, _niġr, joei, _vurr_, 
   {{0x5ec8007e,0x6448007f,0x00000000,0x00000000}},	//   িয়ৰূ, doei, --, --, 
   {{0x38780ac2,0x19f80254,0x3a2c0ac3,0xcaf401ac}},	//   _turr_, _сэмь_, _ödp_, _اسٽب, 
   {{0x64480ac4,0x38780177,0x00000000,0x00000000}},	//   foei, _uurr_, --, --, 
   {{0x64480ac5,0x1cdc0126,0x24740ac6,0x61e402b2}},	//   goei, _རླབ_, _nāmu_, _óhlj, 
   {{0x6004000f,0xd20801a7,0x2a78011a,0x877800ca}},	//   _rómp, гэнд_, _xusb_, _תאמי, 
   {{0x6448007f,0x836001d9,0x39a400f2,0x2a70012b}},	//   aoei, سگنل, _fésű_, _xizb_, 
   {{0x50640ac7,0x64480ac8,0x603000cb,0x683002cc}},	//   йтма, boei, hāmu, sťde, 
   {{0x68e00a18,0xcfa80ac9,0xa2a008c8,0x00000000}},	//   _âlde, دادم_, _खिच्, --, 
   {{0x0e40010f,0x247400ce,0x00000000,0x00000000}},	//   _የህክም, _dāmu_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0ba40007,0x3b38001d,0x6a680023,0x6c840075}},	//   йшам, _በመጨመ, _užfi, تلزم, 
   {{0x09b00095,0x59c40192,0x00000000,0x00000000}},	//   ुभ्य, र्सर, --, --, 
   {{0xfd1001b8,0xca700122,0x3c58038e,0xa37c0086}},	// [730] وجہ_, سناک, ситэ_, ndŵa, 
   {{0x6fb40aca,0xff180240,0xae0c00bd,0x00000000}},	//   _امکا, _לקחת_, _सकिन_, --, 
   {{0x9f5001b1,0x91c80095,0x69c00acb,0x00000000}},	//   _anyè_, त्यै, _ölem, --, 
   {{0x644803b2,0x00000000,0x00000000,0x00000000}},	//   xoei, --, --, --, 
   {{0x47d8007e,0xc9840acc,0x644800b7,0xc79000ec}},	//   ণালী, _губи, voei, орҙы, 
   {{0xa5080acd,0xf9640122,0xb5fc043b,0xe8940668}},	//   иела_, _کۆمێ, _siġr, _магь, 
   {{0x64480ace,0xf6500acf,0xe3b802dc,0x00000000}},	//   toei, رئه_, абй_, --, 
   {{0x24080ad0,0x00000000,0x00000000,0x00000000}},	//   рнии_, --, --, --, 
   {{0x64480ad1,0x13040ad2,0x1cdc0560,0x59c40ad3}},	//   roei, жный_, _རླན_, र्वर, 
   {{0x7d080aa0,0xd1c40027,0x00000000,0x00000000}},	//   ødsk, олье_, --, --, 
   {{0x64480ad4,0x247404c4,0xdbc400b6,0xb5fc043b}},	//   poei, _pāmu_, mööd, _tiġr, 
   {{0xdbc4013c,0x00000000,0x00000000,0x00000000}},	//   lööd, --, --, --, 
   {{0xe29805bc,0xd24c0ad5,0x21a40ad6,0x942400bf}},	//   _тал_, رچۇ_, _дилм, _بونۇ, 
   {{0x21680074,0x00000000,0x00000000,0x00000000}},	//   _кили_, --, --, --, 
   {{0xd24c0ad7,0x00000000,0x00000000,0x00000000}},	//   _جنو_, --, --, --, 
   {{0x60300ad8,0x6fc0072d,0x6f0c0306,0x00000000}},	//   tāmu, _वायू, íocá, --, 
   {{0x21e00296,0x5d7402dc,0x1a040ad9,0x00000000}},	// [740] _tōhē_, _мунф, опам, --, 
   {{0x20000ada,0x00000000,0x00000000,0x00000000}},	//   ljki_, --, --, --, 
   {{0xa3e80adb,0x69d80098,0xdca400b7,0x00000000}},	//   मया_, नज़ी, _ќами, --, 
   {{0x200001f6,0x00000000,0x00000000,0x00000000}},	//   njki_, --, --, --, 
   {{0x0aa00041,0x87000673,0xd5b80123,0x00000000}},	//   _оңтү, дяще, асй_, --, 
   {{0x82c4043b,0xdbc40030,0x94a80116,0xcb10023c}},	//   _ཁྱེའ, gööd, атиа_, _חלש_, 
   {{0x1fb00092,0xf8b00191,0x799c0932,0x08c00931}},	//   ট্যস, _سکا_, _ierw, _обрн, 
   {{0x799c0adc,0xf3f800e1,0x59c4011e,0x00000000}},	//   _herw, сниш_, र्रर, --, 
   {{0x799c00df,0x69c000aa,0xcfe00143,0x1dc80add}},	//   _kerw, र्की, যামন, िभात, 
   {{0x32180066,0x799c0ade,0xd2580adf,0x63ac028a}},	//   óry_, _jerw, јци_, _ƴanc, 
   {{0x799c0ae0,0xf4840ae1,0x3dd8018c,0x6d40043b}},	//   _merw, _راضی, derw_, żlaz, 
   {{0x799c0ae2,0x61ec0ae3,0x661c00e5,0xf43000ea}},	//   _lerw, _ɗali, _įski, _ښېګڼ, 
   {{0x799c0ae4,0x161c00a1,0x61ec059b,0xdcfc028d}},	//   _oerw, _भतार_, íoló, _kepė, 
   {{0x799c0ae5,0x00000000,0x00000000,0x00000000}},	//   _nerw, --, --, --, 
   {{0xcfe401a0,0xc0f0001d,0x00000000,0x00000000}},	//   _дўпп, ቃብር_, --, --, 
   {{0x799c0ae6,0xef9801d9,0x7d080207,0x00000000}},	//   _aerw, _укиш_, ädsa, --, 
   {{0x799c0ae7,0x0dc80063,0x3e8800c2,0x00000000}},	// [750] _berw, _куни_, _cîtă_, --, 
   {{0x799c0086,0x7b6401c4,0x7a20002a,0x00000000}},	//   _cerw, фтсе, _lötf, --, 
   {{0x799c0ae8,0x69c00ae9,0x79a403d6,0xdbc400af}},	//   _derw, र्गी, ьрте, vööd, 
   {{0x799c0aea,0x6fac0252,0x7a200207,0xdddc0152}},	//   _eerw, ট্ৰে, _nötf, _kipş, 
   {{0x799c0aeb,0x7db404e2,0xf7700aec,0xdbc400b6}},	//   _ferw, _عصیا, ناه_, tööd, 
   {{0x6b9c03c7,0x00000000,0x00000000,0x00000000}},	//   _hesg, --, --, --, 
   {{0x6b9c01ec,0x7a2001c5,0x240800fc,0x87d40075}},	//   _kesg, _bötf, йнки_, _وغرا, 
   {{0x6b9c0aed,0xe2980aee,0x4428052b,0x59240560}},	//   _jesg, баи_, òc_, _རྟིས_, 
   {{0x799c0aef,0x6b9c00fc,0x9f500031,0x7c2802ba}},	//   _yerw, _mesg, _boyý_, èdri, 
   {{0xdafc0552,0x6b9c0af0,0xd26001c8,0x35b40af1}},	//   _pãºc, _lesg, нкый, _обур, 
   {{0x55740100,0x6b9c043e,0xa3d40074,0x00000000}},	//   _זעען_, _oesg, _ножч, --, 
   {{0x34940182,0xf408024b,0x3dd803c7,0xd12c00ea}},	//   _цацр, _ويلى_, werw_, ږمۍ_, 
   {{0xe2840af2,0x6d400670,0x00000000,0x00000000}},	//   _элли, ûlan, --, --, 
   {{0x1d080af3,0xc4bc02ef,0x649c0223,0x00000000}},	//   беги_, _एमाओ, _ṣiye, --, 
   {{0x799c0af4,0x6b9c000b,0x3dd800ba,0xa0680af5}},	//   _rerw, _besg, rerw_, _лака_, 
   {{0x799c0af6,0x6b9c0af7,0x00000000,0x00000000}},	//   _serw, _cesg, --, --, 
   {{0x6b9c0af8,0x799c0af9,0xcb64038e,0x3de40143}},	// [760] _desg, _perw, зате_, মাবল, 
   {{0x09e00afa,0x00000000,0x00000000,0x00000000}},	//   ноун, --, --, --, 
   {{0x799c0afb,0x6b9c0043,0x99480afc,0x5f7400e2}},	//   _verw, _fesg, حلال_, _باګر, 
   {{0x799c0afd,0x6b9c03c7,0x00000000,0x00000000}},	//   _werw, _gesg, --, --, 
   {{0x799c0afe,0x15f80aff,0x00000000,0x00000000}},	//   _terw, _एचआर_, --, --, 
   {{0x98a40b00,0xd4980b01,0x6b9c0083,0x18a400fc}},	//   _ниге, бри_, _zesg, _нагм, 
   {{0x6298028b,0xcfe00143,0x2c40028d,0x00000000}},	//   _awwo, যাতন, lėda_, --, 
   {{0x046001c1,0xb4ac0b02,0x49380107,0xe87400c3}},	//   нтым, _कटी_, _הגלו, _قەلب_, 
   {{0xdb140249,0x24a4001d,0x00000000,0x00000000}},	//   èbèr, _ሊደርስ_, --, --, 
   {{0xe60800e2,0x00000000,0x00000000,0x00000000}},	//   _وزلو_, --, --, --, 
   {{0x69c00b03,0xe0840012,0x00000000,0x00000000}},	//   र्टी, وێوو_, --, --, 
   {{0x5ed402fa,0x7a2000fc,0x00000000,0x00000000}},	//   দিনে, _hötd, --, --, 
   {{0x6b9c0b04,0x24480a1d,0xb4ac0b05,0x7a2001c5}},	//   _resg, _بجلي_, _कटु_, _götg, 
   {{0x82c40b06,0x99cc0301,0x6b9c0b07,0x7e280023}},	//   _ཁྱིའ, রযুক, _sesg, піса_, 
   {{0x3b000337,0xdddc01b8,0x6b9c0b08,0x7a20012b}},	//   exiq_, _cipő, _pesg, _mötd, 
   {{0x261801e8,0x00000000,0x00000000,0x00000000}},	//   _nèon_, --, --, --, 
   {{0xd9e4007e,0x6b9c0247,0x8d8400bf,0xeb980108}},	// [770] নানম, _vesg, _нунд, йиң_, 
   {{0x6b9c0b09,0x00000000,0x00000000,0x00000000}},	//   _wesg, --, --, --, 
   {{0x386402b2,0xe6100122,0xddcc0b0a,0x00000000}},	//   _bhmr_, ێشت_, dobň, --, 
   {{0x6d440b0b,0x69c00b0c,0xe7180b0d,0x1ee802ac}},	//   _ixha, र्जी, ييات_, _اویی_, 
   {{0x37740b0e,0x36e80b0f,0x443802a0,0x7c280222}},	//   нышс, كروپ_, _ıq_, ëdre, 
   {{0x8f480020,0x9574001d,0x00000000,0x00000000}},	//   _ሓድነቶ, _ራሳችን_, --, --, 
   {{0x07440046,0x39a401b5,0x59c4025c,0x94d001c3}},	//   _کړای_, _سینہ, _रॉटर, војц, 
   {{0x60c401ec,0x6d440b10,0x3e6401c9,0x41cc0095}},	//   _ähmi, _mxha, möte_, त्नस, 
   {{0x651400a3,0x76680046,0x3e640b11,0x00000000}},	//   _ڪوائ, _ځینې_, löte_, --, 
   {{0x6d440b12,0x7a200101,0x69c00b13,0x06380b14}},	//   _oxha, _götd, र्ची, _اسرع_, 
   {{0x6d4401f9,0x34940b15,0x442401b8,0x65140b16}},	//   _nxha, _захр, _ٹراف, _توائ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d440b17,0x3b0003fa,0x7a2002a0,0x6d480254}},	//   _axha, xxiq_, _höte, şeal, 
   {{0x7a200b18,0x026802eb,0x00000000,0x00000000}},	//   _köte, _ушей_, --, --, 
   {{0x442c004b,0xdcfc015b,0x602401f1,0x1be80027}},	//   _kmg_, _iepī, _одка, одви_, 
   {{0x7a2004bc,0x1d080123,0x00000000,0x00000000}},	//   _möte, беҳи_, --, --, 
   {{0x435402b4,0x6d440b19,0x7a200104,0x91c80095}},	// [780] _ምትብባ, _exha, _löte, त्वै, 
   {{0x442c01c3,0x4a400b1a,0x00000000,0x00000000}},	//   _lmg_, внув, --, --, 
   {{0x41cc0b1b,0xb4ac0b1c,0x57e80319,0xd7e40b1d}},	//   त्यस, _कटे_, ждем_, діло, 
   {{0x7d080b1e,0x442c042e,0xc7ac0b1f,0x00000000}},	//   ødsu, _nmg_, لّم_, --, 
   {{0xc7a00b20,0x07a00947,0x00000000,0x00000000}},	//   тичк, тачн, --, --, 
   {{0x7a200573,0x9508043b,0x41cc0095,0xd9440b21}},	//   _böte, ཀྱའི_, त्मस, _жеги, 
   {{0x442c01ec,0xa3e800cb,0x4484002c,0xddcc01d4}},	//   _bmg_, मयं_, үбән_, robň, 
   {{0xdec00b22,0x00000000,0x00000000,0x00000000}},	//   ድሶን_, --, --, --, 
   {{0x26b0006e,0x07a001a7,0x39580207,0x327402dc}},	//   _مەنز, _шатн, _hyrs_, нгиё, 
   {{0x8af80100,0x6fc0006c,0xe2340020,0x00000000}},	//   קהיי, _वाहू, _ክብርና, --, 
   {{0x7a200b23,0x442c0b24,0x7d0801c5,0x00000000}},	//   _göte, _fmg_, ädsl, --, 
   {{0x442c0b25,0x4de40227,0xa3e80095,0x00000000}},	//   _gmg_, _छोड़े_, मयः_, --, 
   {{0x80bc0098,0x24480b26,0x00000000,0x00000000}},	//   लूबे, _عجمي_, --, --, 
   {{0x3e640027,0x00000000,0x00000000,0x00000000}},	//   yöte_, --, --, --, 
   {{0xfe240b27,0x395805c1,0x442c0b28,0xc1b800ca}},	//   тьян, _nyrs_, _ymg_, _ומוש, 
   {{0x50640063,0x91c80b29,0x442c02ba,0x5fc40203}},	//   _ўтка, त्रै, _xmg_, _वायल, 
   {{0x3958006f,0x625c0249,0xc05400ca,0xea1800cc}},	// [790] _ayrs_, kèol, _בזק_, пжаш_, 
   {{0x6d440b2a,0xc9580007,0x39580b2b,0x00000000}},	//   _txha, оўе_, _byrs_, --, 
   {{0xe9440b2c,0x6d44019b,0xd24405de,0xff500046}},	//   ررئی, _uxha, _ەن_, _مخی_, 
   {{0x39580085,0xc61400cb,0xd2440122,0x7a20005f}},	//   _dyrs_, थस्य_, _ڕن_, _röte, 
   {{0x442c0b2d,0x7a200152,0x368800ec,0x00000000}},	//   _rmg_, _söte, үсән_, --, 
   {{0x37a80b2e,0x7a20019f,0x39580b2f,0xe4c400c3}},	//   птән_, _pöte, _fyrs_, ейки, 
   {{0x7a20012b,0x00000000,0x00000000,0x00000000}},	//   _qöte, --, --, --, 
   {{0xe7940b30,0x7bc00638,0xe7380336,0xe2980636}},	//   _سارک, _ömut, _ddŵr_, паи_, 
   {{0x66b401ac,0x6e340031,0x00000000,0x00000000}},	//   _سٽاء, kizb, --, --, 
   {{0x7a200b31,0x6e3400c0,0x97300b32,0x00000000}},	//   _töte, jizb, _حکما, --, 
   {{0x442c0b33,0x6e340b34,0x90b00329,0x00000000}},	//   _tmg_, dizb, гәыш, --, 
   {{0x7a20012b,0x00000000,0x00000000,0x00000000}},	//   _xötb, --, --, --, 
   {{0x7df00130,0xef7802ba,0x80a800bd,0x00000000}},	//   lɔsɔ, дёръ_, _झिके, --, 
   {{0x91e000f8,0x61440b35,0x9f50014e,0x62640182}},	//   _боше, _пела, _doyð_, _явла, 
   {{0x1d080b36,0xc0e400cb,0x61380100,0x00000000}},	//   чеви_, yāṇi_, _מײַס, --, 
   {{0xc87c0386,0x00000000,0x00000000,0x00000000}},	//   ışla_, --, --, --, 
   {{0x34dc0b37,0xcfe002fa,0x7e64001e,0xeb540b0f}},	// [7a0] _मन्द, যাশন, _иеиҧ, پىلگ, 
   {{0x443c0b38,0x7df00130,0x8e940107,0x39580086}},	//   hnu_, kɔsɔ, _רדיו_, _pyrs_, 
   {{0xd7f8009e,0x68e00028,0x00000000,0x00000000}},	//   зул_, _âldl, --, --, 
   {{0x443c0b39,0x41cc0b3a,0x96e80103,0xf6ec011a}},	//   jnu_, त्तस, зька_, _རླུང, 
   {{0x443c0b3b,0xc0e40828,0x7c240403,0xd3780b3c}},	//   dnu_, rāṇi_, mhir, үчи_, 
   {{0x443c0b3d,0xd4980b3e,0x00000000,0x00000000}},	//   enu_, при_, --, --, 
   {{0x1dd0076f,0x3b380090,0x443c0b3f,0x5fc40698}},	//   द्यत, _በመጀመ, fnu_, _वाढल, 
   {{0x443c0b40,0x7c240403,0x73d8018f,0x00000000}},	//   gnu_, nhir, фдир_, --, 
   {{0xe7d40b41,0xd65c070b,0x7c24015e,0xc7a40b42}},	//   lığı, _дiад, ihir, _سگنل_, 
   {{0x443c0b43,0x00000000,0x00000000,0x00000000}},	//   anu_, --, --, --, 
   {{0x443c0b44,0xd1380302,0xca3400ca,0xc614023c}},	//   bnu_, яхи_, תניה_, _רחבי_, 
   {{0x6fc0006c,0xfd54004f,0x00000000,0x00000000}},	//   _वाळू, _upeṣ, --, --, 
   {{0x7c240b45,0x6e340b46,0xad240121,0x4ea40007}},	//   dhir, tizb, ھىرى, эрна, 
   {{0xad24039b,0xf1a4006c,0x00000000,0x00000000}},	//   پىرى, _खजिन, --, --, 
   {{0xc0e0030d,0x8c640b47,0x6e340b48,0x00000000}},	//   _бојк, етад, rizb, --, 
   {{0xe7d40b49,0x50640b4a,0x2ef40b4b,0x9998028d}},	//   dığı, _ятла, _азир, kopų_, 
   {{0xf1a40774,0x6b740b4c,0xc87c0b4d,0x7d080085}},	// [7b0] _खजान, тлау, ışma_, ødsr, 
   {{0x443c0b39,0x7c2403a2,0xa93c0007,0xe918021d}},	//   znu_, ahir, одзi, мозі_, 
   {{0x443c0b4e,0x7c240b4f,0xdb1401b8,0xac9401d2}},	//   ynu_, bhir, rgyá, _шанш, 
   {{0x7c240b50,0x68e00028,0x443c028b,0x3e640479}},	//   chir, _âldm, xnu_, möta_, 
   {{0x443c0b51,0x66e40b52,0x3e640207,0xa7fc00e3}},	//   vnu_, тола, löta_, _kiűz, 
   {{0x27e80b53,0x7bc00038,0xe7d40b54,0x31200095}},	//   žan_, _ömur, bığı, मनाः_, 
   {{0x443c0b55,0x88b80126,0xe7d40314,0x00000000}},	//   tnu_, _པའིར, cığı, --, 
   {{0xd7ec00a3,0x443c0b56,0xf9900012,0x67d401c4}},	//   _وڃن_, unu_, _نبہ_, _шобу, 
   {{0x443c0b57,0x7a2000a2,0x13e40087,0x69c00b58}},	//   rnu_, _höta, тмый_, _öles, 
   {{0x443c0b59,0xd24c0930,0x7c240b5a,0x7a20012b}},	//   snu_, يني_, zhir, _köta, 
   {{0x443c0b5b,0x59c4083e,0x65180b5c,0x61440b5d}},	//   pnu_, र्टर, _تقاس_, тена, 
   {{0x443c0b5e,0x7a200479,0x7c240475,0x00000000}},	//   qnu_, _möta, xhir, --, 
   {{0x69d40b5f,0xdb040113,0x7c240403,0x92e400fc}},	//   _obze, _odká, vhir, _аңың_, 
   {{0x7c240b60,0xdb2400d3,0x5d680b61,0x00000000}},	//   whir, _ìpér, дигм_, --, 
   {{0x7c240b62,0x27300014,0xe0440b63,0xa3b40b64}},	//   thir, ạnh_, _инки, _जया_, 
   {{0x7c240322,0x8c400385,0x69d40104,0x44e001b8}},	//   uhir, аесе, _abze, _mű_, 
   {{0xeab0063a,0x68f40496,0x68e00028,0x7c240086}},	// [7c0] یعے_, _arzd, _âldj, rhir, 
   {{0x7c240b65,0x68f40214,0x3ea00b66,0x7a2002b1}},	//   shir, _brzd, _iwit_, _böta, 
   {{0x7c240b67,0x3ea00151,0x70500061,0x00000000}},	//   phir, _hwit_, _خۆێا, --, 
   {{0x7c240b68,0x3ea0029f,0x59c40b69,0xe7d40b6a}},	//   qhir, _kwit_, र्जर, rığı, 
   {{0xe7d401c8,0xd6280b6b,0x68f4002a,0x3ea00201}},	//   sığı, моде_, _erzd, _jwit_, 
   {{0x7ae40b6c,0x3ea00b66,0xdcec0b6d,0xceb00107}},	//   mwit, _mwit_, labı, שיג_, 
   {{0x7a20046a,0x7ae4062d,0x98a40121,0x04c40075}},	//   _göta, lwit, _шиве, نووي_, 
   {{0x7bc40b6e,0xa784045d,0x0b9c00a7,0x6d40014a}},	//   ngiu, _مشكو, _ጎንደር_, ûlai, 
   {{0x32540b6f,0x6f08038a,0x3ea00b70,0x7bc40420}},	//   лвир, _mëbë, _nwit_, igiu, 
   {{0x3f800b71,0x7bc40008,0x7a200139,0x7e600513}},	//   _agiu_, hgiu, _yöta, împl, 
   {{0x3ea00b72,0x9f4c0214,0xdcec01c8,0xa08401c4}},	//   _awit_, čným_, kabı, лъяҙ, 
   {{0xc950033c,0x7ae40b73,0x6f080029,0x6e940b74}},	//   ימת_, kwit, _nëbë, лиму, 
   {{0xcd940020,0x00000000,0x00000000,0x00000000}},	//   _ጉዕዞና_, --, --, --, 
   {{0x7ae40b75,0x7bc40b76,0x01300122,0xc10001ac}},	//   dwit, egiu, اعید, _چووي, 
   {{0x1dd00a9e,0x7ae40320,0x8bc40b77,0xc87c039c}},	//   द्धत, ewit, ксад, ışka_, 
   {{0x7bc40b78,0xdfd000a3,0x3ea001e8,0x6e3801d4}},	//   ggiu, _هيٺ_, _fwit_, _šabľ, 
   {{0x41cc0828,0x3c580254,0x7a200479,0x7ae40b79}},	// [7d0] त्वस, титэ_, _söta, gwit, 
   {{0xf7f4031b,0x2ee80b7a,0x628c00c2,0x7bd00023}},	//   یسند, _isaf_, _înoţ, _čiuž, 
   {{0x2d800b7b,0x3ea005e5,0x7ae40110,0x6d400b7c}},	//   _ighe_, _zwit_, awit, úlad, 
   {{0x7ae40b7d,0x7a20013c,0xdcec0b7e,0x00000000}},	//   bwit, _vöta, cabı, --, 
   {{0x4630078e,0x52ac0121,0x9ba00108,0xa3b80030}},	//   аҭар, _ﺳﻪﯞﻩ, _دەقى, _अएब_, 
   {{0x6aac0b7f,0x6b8c0b80,0xc9840b81,0x7a2000a2}},	//   msaf, lcag, _шуми, _töta, 
   {{0x6aac0b82,0xd5ac0b83,0x7a2001b8,0x68f40201}},	//   lsaf, سفي_, _kötn, _urzd, 
   {{0x6b8c0b84,0x2fc801f9,0x69c40b85,0xd4640b86}},	//   ncag, _ncag_, lghe, лище_, 
   {{0x6aac0b87,0x2bd40b88,0x2d800b89,0x65940b8a}},	//   nsaf, ड्या, _oghe_, _базу, 
   {{0x2d800765,0x27ec0b8b,0x6aac0b8c,0x7bc40337}},	//   _nghe_, _haen_, isaf, zgiu, 
   {{0x69c40b8d,0x27ec0b8e,0x2ee80b8f,0x3ea00b90}},	//   ighe, _kaen_, _asaf_, _swit_, 
   {{0x25a40b91,0x7ae40b92,0x248401c7,0x27ec0b93}},	//   _hell_, ywit, _iulm_, _jaen_, 
   {{0x25a40b94,0x63a80b95,0x64580b96,0x27ec0b97}},	//   _kell_, maen, _ikwi, _maen_, 
   {{0x63a80b98,0x27ec0b99,0x24840b9a,0x25a40b9b}},	//   laen, _laen_, _kulm_, _jell_, 
   {{0x61e00b9c,0xdcec0b9d,0x25a40b9e,0x68e00010}},	//   mell, tabı, _mell_, _âldh, 
   {{0x63a80b9f,0x61e00ba0,0x6b8c070b,0x41cc0b1b}},	//   naen, lell, gcag, त्रस, 
   {{0x64580b75,0x7bc40ba1,0xdcec0ba2,0x3ea0005e}},	// [7e0] _mkwi, rgiu, rabı, _uwit_, 
   {{0x25a40ba3,0x7ae40ba4,0x63a80ba5,0xdcec0ba6}},	//   _nell_, rwit, haen, sabı, 
   {{0x61e00348,0x63a80ba7,0x27ec0ba8,0x60c00ba9}},	//   iell, kaen, _baen_, nulm, 
   {{0x27ec008e,0x6b8c0baa,0x64580bab,0x69c40437}},	//   _caen_, ccag, _nkwi, aghe, 
   {{0x61e00bac,0x63a80bad,0x27ec0bae,0x60c00baf}},	//   kell, daen, _daen_, hulm, 
   {{0x64580bb0,0x20100bb1,0x25a40bb2,0x61e00bb3}},	//   _akwi, _loyi_, _cell_, jell, 
   {{0x61e00bb4,0x09bc0145,0x63a80361,0x27ec008e}},	//   dell, _ཁྐྲ_, faen, _faen_, 
   {{0x63a80bb5,0x61e006ea,0x201004cd,0x27ec045f}},	//   gaen, eell, _noyi_, _gaen_, 
   {{0x61e00bb6,0x57440bb7,0x63800329,0x25a40bb8}},	//   fell, _снаб, әҳәа, _fell_, 
   {{0x64580bb9,0x25a40bba,0x2fc80bbb,0x22880bbc}},	//   _ekwi, _gell_, _scag_, _dúk_, 
   {{0x63a80bbd,0x20100bbe,0x27ec0008,0xd24c03a2}},	//   baen, _boyi_, _yaen_, ينڊ_, 
   {{0x25a4079f,0x63a8008e,0x0ee80bbf,0x6aac0bc0}},	//   _zell_, caen, ньги_, ysaf, 
   {{0x25a40bc1,0x0bc00041,0x248401a0,0x5fc40bc2}},	//   _yell_, ﺭﺗﻜﻮ, _zulm_, _वारल, 
   {{0x2fc800b7,0x60c00bc3,0x25a400cc,0x7a200bc4}},	//   _wcag_, bulm, _xell_, _sötn, 
   {{0x6b8c070b,0x60c00bc5,0x420401b5,0x1b100143}},	//   tcag, culm, _حسنہ, _ঠেলে_, 
   {{0x6aac0bc6,0x7c8408fb,0x20100ae3,0x2ee80181}},	//   tsaf, суре, _goyi_, _tsaf_, 
   {{0x6b8c0bc7,0x6d40020c,0x27ec008e,0x92d40252}},	// [7f0] rcag, úlab, _raen_, ায়ৰ_, 
   {{0x6b8c0bc8,0xe9b4078e,0x27ec0bc9,0x69c40bca}},	//   scag, рбжь, _saen_, ughe, 
   {{0x63a80bcb,0xa3e40267,0x6aac0bcc,0x20100181}},	//   yaen, _फसल_, ssaf, _yoyi_, 
   {{0x61e00bcd,0x67d40bce,0x25a40bcf,0x63a8000f}},	//   zell, роду, _sell_, xaen, 
   {{0x63a80bd0,0x25a40bd1,0x60c00bd2,0x69c40636}},	//   vaen, _pell_, zulm, pghe, 
   {{0x63a80bd3,0x27ec0bd4,0x60c00bd5,0x64580bd6}},	//   waen, _waen_, yulm, _skwi, 
   {{0x25a40bd7,0x63a80bd8,0x61e00bd9,0x27ec0bda}},	//   _vell_, taen, vell, _taen_, 
   {{0x61e00bdb,0x25a40bdc,0x81c00329,0x60c00bdd}},	//   well, _well_, әанҧ, vulm, 
   {{0x63a80bde,0x61e00bdf,0x25a40be0,0x212801e7}},	//   raen, tell, _tell_, _ƙaho_, 
   {{0x63a80be1,0x60c00be2,0x20100be3,0x04640200}},	//   saen, tulm, _soyi_, _өтем, 
   {{0x63a80be4,0x360401d9,0xd24c00e2,0x201001e3}},	//   paen, _دولف, ړنی_, _poyi_, 
   {{0x61e00be5,0x64580be6,0x60c00be2,0x22880110}},	//   sell, _ukwi, rulm, _túk_, 
   {{0x60c00be7,0x61e00be8,0x00000000,0x00000000}},	//   sulm, pell, --, --, 
   {{0x61e00be9,0x20100636,0x6e24006f,0x53300381}},	//   qell, _woyi_, _clhb, _фељт, 
   {{0x7a200638,0x201001e3,0x60c00444,0x00000000}},	//   _söto, _toyi_, qulm, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
  
   {{0x92d40bea,0xdee40beb,0xb0680bec,0xa2bc0021}},	// [800] ায়ী_, _топи, _حصول_, _शिफ्, 
   {{0x6d4003e0,0x6494011a,0x6e240054,0x7a200386}},	//   úlac, _iġif, _glhb, _götl, 
   {{0x2d940371,0x57a40bed,0xa3e403ef,0x00000000}},	//   _урыс, ашла, _फसं_, --, 
   {{0xded401e2,0x9f400222,0xb17c01c6,0xa7840bee}},	//   _ይሁን_, jekë_, neĥa, مشهو, 
   {{0xc6a00bef,0xdb040475,0xdddc004f,0x7d0806e9}},	//   орщи, _mekë, _nipū, ådsf, 
   {{0xdb040020,0x15b80bf0,0x7a200087,0xe9a80bf1}},	//   _lekë, тыды_, _kötm, _مدفن_, 
   {{0x55040bf2,0x62840299,0x7d1c01d5,0x00000000}},	//   рчла, _ōhop, nyrs, --, 
   {{0x43800bf3,0x98680254,0x999800a2,0x44f001ee}},	//   يلىق, _рибб_, kipū_, زسىز, 
   {{0x3a38012b,0x7d1c0b08,0x926803a7,0x00000000}},	//   _kmrp_, hyrs, кроа_, --, 
   {{0xd4d402b3,0x7d1c060f,0xf53801c6,0xc0340012}},	//   _відэ, kyrs, _leĥi_, ۪ژوک, 
   {{0xe4f800cb,0xdb040bf4,0x506402ac,0x765800ef}},	//   ्मणि_, _bekë, итма, movy, 
   {{0x3244002c,0xdb040222,0x7d1c0085,0x7a200152}},	//   реүг, _cekë, dyrs, _sötl, 
   {{0x329403e0,0x00000000,0x00000000,0x00000000}},	//   _التأ, --, --, --, 
   {{0x765800ef,0x7d1c02e8,0x83180100,0x00000000}},	//   novy, fyrs, _בודז, --, 
   {{0x0ba40bf5,0x0c8400fc,0x7d1c0101,0x161c03bf}},	//   ишам, рыгм, gyrs, _बकनर_, 
   {{0xf21c0267,0xdb0401ab,0x4ea40bf6,0x60c401c5}},	//   _पकड़_, _gekë, _кроа, _åhma, 
   {{0xaed4005b,0xc9840551,0x76580bf7,0xdde003b4}},	// [810] _уопш, ауеи, kovy, _çuşk, 
   {{0x76580bf8,0x0ca80087,0x7a200031,0xdb040475}},	//   jovy, _итми_, _hötj, _zekë, 
   {{0x6f1c02b0,0x76580bf9,0x7d0801c5,0x00000000}},	//   lysc, dovy, ädst, --, 
   {{0xd1240bfa,0xa7740bfb,0xb8680111,0x6aa80560}},	//   _ہم_, блеч, ајче_, _ħeff, 
   {{0x8b640063,0xd12400e2,0x6f1c0bfc,0x48e000bd}},	//   _خادم, _ځم_, nysc, _ऐनको_, 
   {{0x2d900bfd,0xdddc01d3,0x00000000,0x00000000}},	//   ncze_, _ripū, --, --, 
   {{0xdb2403b5,0xf6080122,0x9f400475,0x34840197}},	//   _نوێی, شتوه_, tekë_, ҙгөг, 
   {{0xa3e80bfe,0x5fc40021,0xded4001d,0x6f1c01d4}},	//   удиа_, _वाइल, _ይሁኑ_, kysc, 
   {{0x9f400bff,0x765800b8,0xdb040475,0x6fc0006c}},	//   rekë_, bovy, _rekë, _वाजू, 
   {{0xdb040085,0x32d40023,0x765801d4,0x9f4002bb}},	//   _udkå, іцыс, covy, sekë_, 
   {{0x1fa801a0,0x00000000,0x00000000,0x00000000}},	//   лкни_, --, --, --, 
   {{0xdee409c7,0x99980299,0x9f4003aa,0x7a200479}},	//   боми, tipū_, leké_, _rötm, 
   {{0x7a2001c5,0x9db80023,0x28c80440,0x00000000}},	//   _sötm, лыву_, ांडि, --, 
   {{0x21680c00,0x7d1c0c01,0x999800a2,0x00000000}},	//   _йили_, tyrs, ripū_, --, 
   {{0x6fc000b3,0x65600027,0x5bb40375,0x8eb000d5}},	//   _वाचू, _jylh, йсаф, _ہميش, 
   {{0x6d40020c,0x62640121,0x6f1c0c02,0x65600c03}},	//   úlaa, _ئاچق, bysc, _mylh, 
   {{0x88d00126,0x80bc00b3,0x20d00c04,0x00000000}},	// [820] _ཌཱུར, लंके, lái_, --, 
   {{0x7d1c060f,0xf9c40a2d,0x00000000,0x00000000}},	//   pyrs, تحری, --, --, 
   {{0xd2380282,0x7a200139,0x2ca40028,0x20d00c05}},	//   נגעל, _hötk, âldt_, nái_, 
   {{0x6494011a,0x7a200087,0x9f4000f1,0xb6c800d5}},	//   _mġid, _kötk, tekè_, لاتے_, 
   {{0x9f500101,0x3cf8015e,0x765800ef,0x20d000b8}},	//   _anyú_, lvrv_, tovy, hái_, 
   {{0xdb040c06,0x3a28006b,0x20d00329,0x00000000}},	//   _rekè, _тегү_, kái_, --, 
   {{0x26180c07,0x76580c08,0x6f1c06f7,0xdb040249}},	//   _बकरी_, rovy, zysc, _sekè, 
   {{0x76580c09,0xb2b800f8,0x29040c0a,0x53e40023}},	//   sovy, алиф_, _šlag_, сцка, 
   {{0x7a200479,0xdb040c0b,0x76580247,0x46a00c0c}},	//   _nötk, _beké, povy, _натв, 
   {{0xe4640937,0xdb040c0d,0xf238023f,0x38880386}},	//   _ýöne_, _ceké, рпош_, _ağri_, 
   {{0x20d000b8,0xa5cc00bd,0x00000000,0x00000000}},	//   gái_, _सातौ, --, --, 
   {{0x6f1c070b,0x2d90002f,0x4ea40094,0x89780a0b}},	//   tysc, wcze_, йрга, טריצ, 
   {{0x20d00329,0x814001d9,0xdb0400e3,0x8cc803bf}},	//   aái_, قنین, _feké, तंभो, 
   {{0xdb04000b,0x2d84036d,0x20d00c0e,0x38880386}},	//   _geké, øle_, bái_, _eğri_, 
   {{0xe6a40021,0x2d90002f,0x20d00c0f,0xf1a000c3}},	//   _ऑब्ज, rcze_, cái_, _ﺋﯘﻗﯘ, 
   {{0x64940560,0x95580020,0x6f1c02b0,0x8cc80098}},	//   _wġig, _ኲናትን_, pysc, तंबो, 
   {{0x64940126,0x7a200c10,0xdd9001ac,0xa6680197}},	// [830] _iġie, _köth, _ڪوپ_, _йыhа, 
   {{0x30ec00cb,0x6d180126,0x64940002,0xa9c00128}},	//   _जनाः_, ུགདེ_, _uġig, بۅسۉ, 
   {{0xda1800b6,0x9f400c11,0x00000000,0x00000000}},	//   _धवरत_, veké_, --, --, 
   {{0x2bc8039b,0x64940560,0x9f400249,0x7d080085}},	//   _өлүп_, _jġie, weké_, ådse, 
   {{0x65600c12,0x64940560,0x9f400249,0xd7e40049}},	//   _sylh, _mġie, teké_, імше_, 
   {{0xa93400fc,0xc1b403ef,0xdb0c00d3,0x20d00247}},	//   _дегш, _आयेग, _àjál, yái_, 
   {{0x24080c13,0xdb040039,0x00000000,0x00000000}},	//   инки_, _reké, --, --, 
   {{0xa2bc0b02,0x6a1402dc,0x2ea80c14,0xb17c0237}},	//   _शिद्, _умҳу, _कबूत, teĥn, 
   {{0x625c052b,0xe4f80095,0x00000000,0x00000000}},	//   dèor, ्महि_, --, --, 
   {{0xf7700c15,0x68e00ac1,0x7e940041,0x7a200139}},	//   _ساق_, _âlds, _ﻜﺎﻨﺕ_, _rötk, 
   {{0x21680c16,0xa0a4039c,0x7a20006b,0x00000000}},	//   рини_, әшүл, _sötk, --, 
   {{0x8c4001c8,0x7a2002eb,0x20d00329,0x00000000}},	//   äşle, _pötk, rái_, --, 
   {{0x6d400545,0x64480c17,0x83640c18,0x20d000b8}},	//   úlan, mnei, _ادال, sái_, 
   {{0x443c0c19,0x6494043b,0x7a2001c5,0x62980c1a}},	//   liu_, _iġib, _göth, _itwo, 
   {{0xdcb00c1b,0x443c0062,0x64480c1c,0x64940126}},	//   بىز_, oiu_, onei, _fġie, 
   {{0x64480c1d,0x1b4800b7,0x00000000,0x00000000}},	//   nnei, азби_, --, --, 
   {{0x64480c1e,0x443c008b,0x6494043b,0x8c4000b7}},	// [840] inei, iiu_, _jġib, фете, 
   {{0x6448020a,0x443c0c1f,0xc1b40c20,0x62980078}},	//   hnei, hiu_, _आयोग, _mtwo, 
   {{0x443c0c21,0x1d080c22,0x8d740a1d,0xe3b80028}},	//   kiu_, _тени_, _واپا, nhűs_, 
   {{0x443c0c23,0x64480008,0x6298002f,0x7a200139}},	//   jiu_, jnei, _otwo, _möti, 
   {{0x443c0c24,0x64940126,0x00000000,0x00000000}},	//   diu_, _nġib, --, --, 
   {{0x7c240076,0x1da800b3,0x8c1c02fa,0x18a40c25}},	//   lkir, करित, নোদন_, _магм, 
   {{0x7a200874,0x443c0c26,0x7c240c27,0xdddc01d5}},	//   _nöti, fiu_, okir, _lipů, 
   {{0x7c240c28,0x443c0c29,0x64480c2a,0x24e40023}},	//   nkir, giu_, gnei, яціг, 
   {{0x7c2406da,0x63b80335,0x6494043b,0x1da80c2b}},	//   ikir, _ddwn, _rġie, करात, 
   {{0x443c0c2c,0x64480ac5,0x7c240105,0x63ac00cf}},	//   aiu_, anei, hkir, _ĵane, 
   {{0x443c0c2d,0x7c240c2e,0x62980c2f,0x82300c30}},	//   biu_, kkir, _etwo, بريا, 
   {{0x644801d6,0x7c2401c3,0x00000000,0x00000000}},	//   cnei, jkir, --, --, 
   {{0xc7b0033c,0xaaa803ef,0x7c240c31,0x926800e1}},	//   ובר_, _चौंक, dkir, _крка_, 
   {{0x99cc007e,0x7c240c32,0x7a200038,0x66e002b2}},	//   ৰযুক, ekir, _föti, _hákö, 
   {{0x7c240126,0x7a2002b2,0x7d0801c5,0x00000000}},	//   fkir, _göti, ädsp, --, 
   {{0x7c240c33,0x9be4043b,0x09c00c34,0xdd9802dc}},	//   gkir, _སྒྱོ, शल्य, ишӣ_, 
   {{0x8d840c35,0x00000000,0x00000000,0x00000000}},	// [850] _мунд, --, --, --, 
   {{0x6448020a,0x443c0c36,0x7c240c37,0x3b54021b}},	//   znei, ziu_, akir, фкур, 
   {{0xdb140937,0x64480274,0x443c01e7,0xab940302}},	//   mgyý, ynei, yiu_, _нині, 
   {{0x443c0c38,0x9f5001e8,0x64480337,0xa7740c39}},	//   xiu_, _bayè_, xnei, плеч, 
   {{0x9be40c3a,0x443c0c3b,0x66040683,0x64480b1e}},	//   _སྒྲོ, viu_, зпла, vnei, 
   {{0x656400a1,0x9f5001b1,0x443c002f,0x64480335}},	//   ühho, _dayè_, wiu_, wnei, 
   {{0x443c0c3c,0x6298002f,0x64480008,0x666401b5}},	//   tiu_, _stwo, tnei, _ہُرٕ, 
   {{0x64480c3d,0xa0240027,0x88a00061,0x00000000}},	//   unei, isöä, _فیڕۆ, --, 
   {{0x443c0c3e,0xe298005b,0x13040c3f,0x28c800b3}},	//   riu_, љао_, зный_, ांवि, 
   {{0x443c0c40,0x7a200638,0x7c240c41,0x64480c42}},	//   siu_, _pöti, zkir, snei, 
   {{0x443c0c43,0x6d4005c0,0x7c240c44,0x644801c6}},	//   piu_, úlal, ykir, pnei, 
   {{0xdee40c45,0x44240c46,0x0d38001d,0xecd00143}},	//   поми, _ظراف, _አስፋል, াবাড, 
   {{0x629806f7,0xe3b80028,0x7c240c47,0xd5d00c48}},	//   _utwo, shűs_, vkir, _सामज, 
   {{0x7c2408df,0x7a200299,0xe1f00c49,0x9f500537}},	//   wkir, _töti, _سست_, _jayé_, 
   {{0x9f500c4a,0x0bb80c4b,0x69c00055,0xa3c001d5}},	//   _mayé_, өттө_, _öley, _्ञा_, 
   {{0x5fc40698,0x9f40008b,0x2f3000cb,0x9f500528}},	//   _वाटल, lekí_, ṅga_, _layé_, 
   {{0x7c240c4c,0xfe7801d2,0x00000000,0x00000000}},	// [860] rkir, _мүм_, --, --, 
   {{0x7c240c4d,0x4ef80282,0x4dd800aa,0xe9a800e7}},	//   skir, _פליג, ख्दै_, ۅدۅن_, 
   {{0xd00c01a0,0xc9740152,0x00000000,0x00000000}},	//   _شلی_, зәтч_, --, --, 
   {{0x7c24004e,0x7f3c010f,0x00000000,0x00000000}},	//   qkir, _አንዳች, --, --, 
   {{0x9f500c4e,0xa2bc0c4f,0x38c80122,0x47800c50}},	//   _bayé_, _शिष्, _ژاری_, нышб, 
   {{0x28c80c51,0x00000000,0x00000000,0x00000000}},	//   ांशि, --, --, --, 
   {{0x48e00164,0x98a40c52,0x00000000,0x00000000}},	//   _порв, _хибе, --, --, 
   {{0xe9700476,0x18a40c53,0x32980385,0x9f5000f1}},	//   _شۇند, _маҳм, овиќ_, _tayè_, 
   {{0x9f50038a,0x5fc400b3,0xb2740121,0xe7d00bc2}},	//   _fayé_, _वाजल, млиш, _हातप, 
   {{0xa2bc0c54,0xf8e00457,0x42700c55,0x7a2000d5}},	//   _शिर्, _नहाय, нгыс, _eötv, 
   {{0x85980240,0x85e40182,0x00000000,0x00000000}},	//   _השבו, _хдхв_, --, --, 
   {{0x6d400579,0x68e0006b,0x00000000,0x00000000}},	//   úlam, _älde, --, --, 
   {{0x7a2002b2,0xcf240075,0x03a00074,0x00000000}},	//   _hötu, سرحي, _чичо, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5fc40698,0x7a2002b2,0xaaf402a0,0x00000000}},	//   _वाचल, _jötu, _köçü_, --, 
   {{0x7a200c56,0x7e6000c2,0x2d9c0101,0x00000000}},	//   _mötu, împr, _şwed_, --, 
   {{0x22880028,0xadbc0c57,0x00000000,0x00000000}},	// [870] _tźke_, _капi, --, --, 
   {{0xe9440c58,0x7ed40272,0x79f40074,0x3e6402b2}},	//   ورای, _أزيا, нзух, fötu_, 
   {{0x9f500670,0xf9880272,0xac180c59,0x3e640038}},	//   _rayé_, أنمي_, _дону_, götu_, 
   {{0xa2bc0c5a,0x6fac025c,0x00000000,0x00000000}},	//   _शिल्, चरिं, --, --, 
   {{0x9f500c5b,0xa6c801f5,0x92cc0143,0x00000000}},	//   _payé_, ілка_, শবু_, --, 
   {{0x7a200c5c,0xdb040028,0xd90c00e2,0xb17c01c6}},	//   _bötu, _fekâ, دیې_, reĥj, 
   {{0x80d803ea,0x00000000,0x00000000,0x00000000}},	//   _बहें, --, --, --, 
   {{0x7a20019f,0x9f500c5d,0x3e640191,0xe29802dc}},	//   _dötu, _wayé_, lött_, оаи_, 
   {{0x65940c5e,0x9f40008b,0x9f5000d3,0xb9fc001d}},	//   _жазу, tekí_, _tayé_, _ቅቤ_, 
   {{0xf4c400df,0x7a200038,0x3f9c01d5,0x1fc4006c}},	//   çýän_, _fötu, _řvu_, वल्ड, 
   {{0x7a200270,0x34480152,0xd5d00c5f,0x00000000}},	//   _götu, ючән_, _सातज, --, 
   {{0xeb0c0457,0xaaf40386,0x7a2006b4,0x00000000}},	//   _सपूत_, _göçü_, _hött, --, 
   {{0xd0900c60,0xd24c009d,0x7a200c61,0xdb040c62}},	//   _müəy, انۍ_, _kött, _pekí, 
   {{0x3e640191,0x7a200191,0xfd6401de,0x00000000}},	//   jött_, _jött, енгү, --, 
   {{0x7a200c63,0x2120012a,0x3e640191,0x00000000}},	//   _mött, _æhh_, dött_, --, 
   {{0x7a200c64,0x00000000,0x00000000,0x00000000}},	//   _lött, --, --, --, 
   {{0xcb640c65,0x3e640207,0x00000000,0x00000000}},	// [880] дате_, fött_, --, --, 
   {{0x3e640191,0x7a200479,0x00000000,0x00000000}},	//   gött_, _nött, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x57440116,0x7a200c66,0x00000000,0x00000000}},	//   мнеб, _rötu, --, --, 
   {{0xc68c01b5,0x7a200104,0xe6b401d9,0xdb1401b8}},	//   لِن_, _bött, فلنگ, rgyó, 
   {{0xd4980c67,0x3e640207,0x00000000,0x00000000}},	//   ори_, möts_, --, --, 
   {{0x7a200479,0x00000000,0x00000000,0x00000000}},	//   _dött, --, --, --, 
   {{0xf3180155,0x61e40386,0x480000b7,0x00000000}},	//   зоиш_, _ıhla, _ипсв, --, 
   {{0x7a2001c9,0x02a00254,0x1dcc0098,0x00000000}},	//   _fött, крэм, ़लात, --, 
   {{0x7a200c68,0xcc8801ee,0x6d40014e,0xb11401c3}},	//   _gött, ﺒﻪﺭﮔ, úlak, емош, 
   {{0x84540476,0xd5480122,0xd13802eb,0x40a40c69}},	//   ярәт_, _بلاو_, юхи_, мъян_, 
   {{0x3e64063a,0x53440c6a,0x8f0801d9,0x7a200c6b}},	//   zött_, _охла, охга_, _köts, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x425006e6,0x9f5000f2,0x42040123,0x6c8400ea}},	//   _үтәт, _anyó_, _ончо_, ځلسم, 
   {{0x7a200c6c,0x826003a2,0xdb0400ef,0x46380100}},	//   _löts, _جهون, _odkó, קעלע, 
   {{0x321c0116,0x9f400693,0xeeb8006e,0xad2400e2}},	//   _hovy_, bekà_, _елиш_, ورځو, 
   {{0x3e640191,0x7c840c6d,0x321c0113,0x7a2001c5}},	// [890] tött_, туре, _kovy_, _nöts, 
   {{0x26d800e0,0x00000000,0x00000000,0x00000000}},	//   _īso_, --, --, --, 
   {{0x7a200c6e,0x64dc0c6f,0x26d8028d,0xdd9000cc}},	//   _rött, _महेश, _ūso_, _حوپ_, 
   {{0x9f400c70,0x7a20012b,0x38c4030f,0x3e640207}},	//   leká_, _sött, _sérð_, sött_, 
   {{0x200c0130,0xa9080012,0x7a200c10,0x00000000}},	//   _ɑfi_, _کٲزٕ_, _pött, --, 
   {{0xf7700c71,0x321c09f4,0x9f40008b,0x2c0c006c}},	//   جام_, _novy_, neká_, हावं_, 
   {{0x9f4c00bd,0x7a20013c,0x6d400579,0x35f8005e}},	//   čném_, _vött, úlah, برند_, 
   {{0xe8e8009d,0x13e8011a,0x68f400f2,0x00000000}},	//   _ورځو_, _རྒྱཔ, _iszd, --, 
   {{0xdddc0c72,0x7a200c73,0x68f4015e,0xe28401f1}},	//   _lipš, _göts, _hszd, нлии, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64440c74,0x321c018c,0xb5c80012,0xa878007c}},	//   éhis, _dovy_, _زونم_, ּאָר, 
   {{0xdb040c75,0xa294021d,0x934001d2,0x00000000}},	//   _leká, _заді, _әнше, --, 
   {{0xd12c0c76,0x442c0c77,0x69d4002f,0xd24c0c78}},	//   لمی_, _ilg_, _ocze, _گنو_, 
   {{0xd00c0256,0x321c0101,0xdc980c79,0x00000000}},	//   _ۇلى_, _govy_, зташ_, --, 
   {{0x22440c7a,0x442c0039,0xb28400b8,0x00000000}},	//   milk_, _klg_, _рыцк, --, 
   {{0x69d4086c,0x321c039d,0x5210006e,0xbfa80012}},	//   _acze, _zovy_, _адәт, _کاژٕ_, 
   {{0x442c0c7b,0xba4401b8,0xde3c001d,0x2f540023}},	// [8a0] _mlg_, نچسٹ, ደማይገ, _атэс, 
   {{0x4a400385,0x7a200207,0x00000000,0x00000000}},	//   гнув, _röts, --, --, 
   {{0xd8240c7c,0x442c0c7d,0x9d440c7e,0x7a2001c5}},	//   нджи, _olg_, _ченд, _söts, 
   {{0x3d1c0457,0x2244006f,0x7a200139,0xd5d0006c}},	//   नहीं_, hilk_, _pöts, _साहज, 
   {{0xdb0400ef,0x2c0c0095,0x8c1800ca,0x00000000}},	//   _feká, हारं_, _זוכי, --, 
   {{0xceb004b0,0x8ca40c7f,0xd94401f1,0x00000000}},	//   ריג_, टीको, _зеги, --, 
   {{0x85b4004b,0x442c013c,0x321c00b8,0x2244015e}},	//   راوس_, _blg_, _rovy_, dilk_, 
   {{0x442c059b,0x3ea00c80,0x7a200139,0x321c01d5}},	//   _clg_, _otit_, _töts, _sovy_, 
   {{0x442c02e3,0x9f50012b,0x06800121,0x325401c3}},	//   _dlg_, _bayí_, ъгән, квир, 
   {{0x442c0c81,0xc214021d,0xf5440222,0x00000000}},	//   _elg_, еєю_, _ንፕረዚ, --, 
   {{0x442c0c82,0x6d480254,0x3ea00c83,0xc1b401a7}},	//   _flg_, şeaz, _atit_, элэх_, 
   {{0x442c0c84,0x6e94012b,0x00000000,0x00000000}},	//   _glg_, киму, --, --, 
   {{0x93440c85,0x321c001e,0x3ea00048,0x9f4002cc}},	//   _янде, _tovy_, _ctit_, teká_, 
   {{0xbe880c86,0x44100c87,0xdb0c0223,0x00000000}},	//   ессе_, _афәт, _àjùl, --, 
   {{0x2d840c88,0xdb040116,0x248800c0,0x00000000}},	//   äle_, _reká, ňame_, --, 
   {{0x3ea00c89,0x656400b6,0x799c0c8a,0xdb040c8b}},	//   _ftit_, ühhi, _afrw, _seká, 
   {{0x64940560,0xdb040c8c,0x00000000,0x00000000}},	// [8b0] _aġil, _peká, --, --, 
   {{0x799c0379,0x7a2006b4,0x00000000,0x00000000}},	//   _cfrw, _sötr, --, --, 
   {{0x6c540155,0x2d58044a,0xd424012b,0x00000000}},	//   _акну, _цинь_, _ışnı_, --, 
   {{0x69d406f7,0x00000000,0x00000000,0x00000000}},	//   _wcze, --, --, --, 
   {{0x69d40c8d,0x799c009c,0x8038007c,0xc6a40c8e}},	//   _tcze, _ffrw, ענדע_, хреи, 
   {{0x69d406f7,0xdb040c8f,0x442c01d1,0xe3ac0143}},	//   _ucze, _bekæ, _slg_, _গাইব, 
   {{0x442c0c90,0xcacc0252,0x22440c91,0x00000000}},	//   _plg_, ৰিওফ, vilk_, --, 
   {{0x2ca001e3,0x4784001e,0x00000000,0x00000000}},	//   _mthd_, _зызб, --, --, 
   {{0xdc2c076f,0xe6940b4c,0x442c0c92,0x22440913}},	//   _jñān, _ризы, _vlg_, tilk_, 
   {{0x442c03f2,0x20c40095,0x9f40012b,0x00000000}},	//   _wlg_, _विदध, lekç_, --, 
   {{0xa2bc0c93,0xc4c40c94,0x65140c95,0x442c0c96}},	//   _शिक्, _ستاو, _جوائ, _tlg_, 
   {{0x442c0c97,0x3ea00c98,0x22440c99,0x728801a7}},	//   _ulg_, _ptit_, silk_, мбөг_, 
   {{0x53980a1b,0x26dc002a,0x22440c9a,0xc2b800ea}},	//   _חינו, ntwo_, pilk_, _راشئ_, 
   {{0x78780c9b,0xabc401c4,0x27fc0c9c,0x00000000}},	//   míve, ҫарҙ, hdwn_, --, 
   {{0xdc28009d,0x78780c9d,0x81b40143,0x00000000}},	//   وسره_, líve, _ছাপ_, --, 
   {{0x5f040c9e,0x26dc0078,0x153c004f,0x00000000}},	//   _азиа, ktwo_, _cāṇī, --, 
   {{0x78780c9f,0x27fc0ca0,0x3ea0012a,0x63a803c8}},	// [8c0] níve, ddwn_, _utit_, iben, 
   {{0x3b000ca1,0x7f400034,0xed58041c,0x00000000}},	//   rviq_, úmqu, фоӣ_, --, 
   {{0xd7f80ca2,0x5f440ca3,0x63a80361,0x28c80325}},	//   дул_, _سنگل, kben, ांगि, 
   {{0x69c00239,0x63a80ca4,0x96e80ca5,0x00000000}},	//   _ôlen, jben, дька_, --, 
   {{0x63a80ca6,0x3b000ca7,0x6d4005c0,0x00000000}},	//   dben, qviq_, úlav, --, 
   {{0x63a80ca8,0x787800aa,0x64440249,0x9f400ca9}},	//   eben, díve, èhin, mekä_, 
   {{0xd9440caa,0x63a803f4,0xdb04059c,0x73c40a6d}},	//   _реви, fben, _bekç, гәле, 
   {{0x63a80cab,0xd7040cac,0x73d8018f,0xb9dc001d}},	//   gben, _изби, хдир_, _አሳ_, 
   {{0x97e8038c,0x26dc06f7,0xd1c80cad,0x78780111}},	//   ışdı, ctwo_, мунд_, gíve, 
   {{0x63a80cae,0x64880094,0x00000000,0x00000000}},	//   aben, мсөг_, --, --, 
   {{0x1be00caf,0x427001a7,0x00000000,0x00000000}},	//   खभाल_, ргэс, --, --, 
   {{0x9f5000d3,0x78780111,0xdb040139,0x88c4012c}},	//   _bayà_, bíve, _kekä, _utěš, 
   {{0x787801f1,0xdd380513,0x6140001e,0x00000000}},	//   cíve, _păşe, иҵәа, --, 
   {{0xd24c01b5,0xdb040139,0xdb1401b1,0x2ba408e5}},	//   _گنڈ_, _mekä, mayè, गुना, 
   {{0xdb040638,0x00000000,0x00000000,0x00000000}},	//   _lekä, --, --, --, 
   {{0xc61c0cb0,0x7a200207,0x26dc006f,0xe7d00098}},	//   _भव्य_, _sötp, ytwo_, _हाइप, 
   {{0xdb0407e9,0x06d400ac,0x9f5002ba,0xeb0c02ef}},	// [8d0] _nekä, _দৈনি, _gayà_, समेत_, 
   {{0x63a80cb1,0x4b3c0cb2,0x4e400061,0x00000000}},	//   zben, _ኮንግረ, _ئێسق, --, 
   {{0x63a80cb3,0x656c01e7,0xaab4024b,0x78780cb4}},	//   yben, ƙahi, _әйгі, zíve, 
   {{0xdb040cb5,0x6d400cb6,0x64a4024b,0xdb1400f1}},	//   _bekä, úlau, ңала, kayè, 
   {{0x78780111,0x070400e2,0x27fc03c7,0x63a801c5}},	//   xíve, کيږي_, rdwn_, vben, 
   {{0x787801f1,0x9f500223,0xdb04006b,0x63a80cb7}},	//   víve, _jayá_, _dekä, wben, 
   {{0x26dc002f,0x74a40294,0xdb040386,0x154000ec}},	//   stwo_, ајње, _pekç, йешм, 
   {{0x78780cb8,0x63a80cb9,0xc6a4038e,0xdb1401e8}},	//   tíve, uben, _аржи, fayè, 
   {{0x63a80cba,0x81b4007e,0xdb040b46,0x06980665}},	//   rben, _ছাব_, _gekä, _آخرت_, 
   {{0x63a80cbb,0x787801f1,0x7d080cbc,0x9f9800d3}},	//   sben, ríve, ådsk, _ṣàn_, 
   {{0x7878023f,0x9f4c00aa,0x516400e7,0x63a803f4}},	//   síve, čním_, лүшү_, pben, 
   {{0xdb080212,0x05dc0a1f,0x2ba40cbd,0x00000000}},	//   šnéh, प्रब, गुमा, --, 
   {{0x9f500223,0x55f4007e,0x6448000f,0x838402eb}},	//   _bayá_, চাৰক_, miei, _рыже, 
   {{0xdd900cbe,0x64480cbf,0x00000000,0x00000000}},	//   صور_, liei, --, --, 
   {{0x1fb40254,0x644800a0,0x61440027,0x00000000}},	//   _йспр, oiei, _щека, --, 
   {{0xaca800cd,0x8c400cc0,0x62800083,0xdb140670}},	//   کھیے_, бесе, lmlo, layé, 
   {{0x99e40cc1,0x9b0401d2,0x00000000,0x00000000}},	// [8e0] лжад, ызад, --, --, 
   {{0x9a680cc2,0x6448036b,0xd5d003bf,0x00000000}},	//   رمال_, hiei, _साइज, --, 
   {{0x64480cc3,0x6d4005c0,0xf7700200,0xdb0402eb}},	//   kiei, úlat, ﺴﺘﯩﻚ_, _sekä, 
   {{0x7d5401e2,0x00000000,0x00000000,0x00000000}},	//   _መሆናቸ, --, --, --, 
   {{0xb3140126,0x64480cc4,0x764400b8,0xf1d4040e}},	//   ིདབང_, diei, аҭаа, _दालन, 
   {{0x38c80cc5,0x62800cc6,0xdb1401e8,0x00000000}},	//   _لاری_, jmlo, vayè, --, 
   {{0x64480cc7,0x629c0b07,0x54e40272,0x20c402a4}},	//   fiei, íson, استق, _विषध, 
   {{0x4d78007c,0x6280084f,0xdef0001d,0x77940122}},	//   ערקע, emlo, _ልጁን_, _ئیشا, 
   {{0xd5d40cc8,0x73c4002c,0x634002b4,0x23d40203}},	//   _متاث, гәһе, _ክትግበ, _धारद, 
   {{0xdb140cc9,0xdb040207,0x6448006f,0x74140cca}},	//   rayè, _gekå, aiei, اوکا, 
   {{0x64480039,0xdcfc015b,0x80a00ccb,0xf1b80560}},	//   biei, _cepļ, یمین, raġ_, 
   {{0x644801fc,0x3d080ccc,0xa3b40098,0x00000000}},	//   ciei, हिने_, झरण_, --, 
   {{0x6e940ccd,0x00000000,0x00000000,0x00000000}},	//   ригу, --, --, --, 
   {{0x2c000cce,0xc2c001ac,0x705400bf,0x00000000}},	//   _একেই_, _ايوي, انڭا, --, 
   {{0x28c80203,0x621000cb,0x00000000,0x00000000}},	//   ांछि, तारौ_, --, --, 
   {{0x80a00ccf,0x21640049,0x00000000,0x00000000}},	//   _امين, _ттіг, --, --, 
   {{0xe9d800df,0x3c58038e,0xead401b2,0xfd100cd0}},	// [8f0] кмач_, уитэ_, розь, يجہ_, 
   {{0x6d400cd1,0x64480c2a,0xbf140012,0x7f3c007c}},	//   úlas, ziei, _اوٝب, _רעזו, 
   {{0x64480336,0x00000000,0x00000000,0x00000000}},	//   yiei, --, --, --, 
   {{0xead40cd2,0x79940123,0x00000000,0x00000000}},	//   _комь, _ҳирф, --, --, 
   {{0x2ba400cb,0x6280006f,0x69dc0095,0x9bb800ca}},	//   गुणा, ymlo, _पापी, _בצרפ, 
   {{0xc98400f8,0x787800c0,0x79940cd3,0x00000000}},	//   _буби, tívc, _гирф, --, 
   {{0x3d080cd4,0x64a40128,0x64480cd5,0x00000000}},	//   हिये_, шайа, tiei, --, 
   {{0x7cec00f2,0x57b000bf,0x00000000,0x00000000}},	//   _hörö, _ۇڭۇز, --, --, 
   {{0x64480b66,0x7cec0191,0x00000000,0x00000000}},	//   riei, _körö, --, --, 
   {{0x3d080cd6,0x78780cd7,0x64480cd8,0x00000000}},	//   हिमे_, míva, siei, --, 
   {{0x78780cd9,0xc3200301,0x69dc0cda,0x62800cdb}},	//   líva, _বেশি_, _पानी, rmlo, 
   {{0x5f0402ac,0x660c028a,0x649400b0,0xdb140670}},	//   азма, ɓaka, _ašig, sayé, 
   {{0x02a4005b,0x9e640cdc,0x38bc0229,0xdb140670}},	//   _срем, لاسن, _kárá_, payé, 
   {{0xd3540cdd,0x38bc00d3,0x21a40cde,0x00000000}},	//   _דיני_, _járá_, _тикм, --, 
   {{0xdea001b8,0x9200015b,0x7cf00223,0x00000000}},	//   _ڈیجی, _šāga, dòrò, --, 
   {{0x38bc00d3,0x38ac00d3,0x7878001e,0x00000000}},	//   _lárá_, _lòrò_, kíva, --, 
   {{0x20100cdf,0x6d400ce0,0x19940ce1,0xa29c02a0}},	// [900] _inyi_, úlar, ајер, _ərşə_, 
   {{0x787800aa,0x00000000,0x00000000,0x00000000}},	//   díva, --, --, --, 
   {{0x26180ce2,0xc8c401b5,0x7cec00e3,0xa3b40030}},	//   पानी_, لوٕن_, _dörö, झरा_, 
   {{0x20000ce3,0x2ca4000f,0xe9a800e7,0x1b480123}},	//   ndki_, ílde_, ندۅن_, _азми_, 
   {{0x38bc00d3,0x38ac0229,0x7cec01c9,0x8f9802c3}},	//   _bárá_, _bòrò_, _förö, דיני, 
   {{0x7cec0191,0x4788070b,0x69dc0608,0xb8dc0143}},	//   _görö, ĕсем_, _पायी, _আম_, 
   {{0x01b80ce4,0xf1ac0ce5,0xdb0402cc,0xe8500122}},	//   ংলাদ, _ﺳﯘﻟﺘ, _nekú, _کۆند, 
   {{0x20100ce6,0x94840ce7,0xd404012b,0xdb2400d3}},	//   _nnyi_, шылд, ряки, _ìpór, 
   {{0x6458010b,0x46a00ce8,0x38bc0229,0x38ac00d3}},	//   _djwi, _матв, _fárá_, _fòrò_, 
   {{0x201005b6,0x38ac0b66,0x51840182,0x15440a22}},	//   _anyi_, _gòrò_, иуна, _кезм, 
   {{0xdb1403af,0x22580249,0x9f8c00af,0x85200123}},	//   kayï, éska_, _mõõk_, _мӯъҷ, 
   {{0x4ea40ce9,0x92000059,0x13680cea,0x04d800ca}},	//   ирга, _šāda, _ишли_, _יקבל, 
   {{0xb8d80ceb,0xdb040223,0x2eec0cec,0xc43800ca}},	//   _ཚས_, _eekú, ïef_, _בתאי, 
   {{0x20100ced,0xdb0400d3,0x20000201,0x00000000}},	//   _enyi_, _fekú, adki_, --, 
   {{0x1e3801b5,0x2ca401ab,0x412403e9,0xdd380513}},	//   اغُک_, ëld_, _војо_, răşa, 
   {{0x7cec0cee,0x8f440cef,0x7054031b,0x00000000}},	//   _sörö, _вход, _دنبا, --, 
   {{0x76480083,0x64940cf0,0xf3f80143,0x7cec00d5}},	// [910] _omdy, _išie, _আচার_, _pörö, 
   {{0x6d340cf1,0xe918021d,0x9abc0cf2,0x00000000}},	//   _геоф, лозі_, вiта_, --, 
   {{0x7cec0cf3,0x69dc00b3,0x88c40340,0x38bc0528}},	//   _vörö, _पाठी, شتال, _rárá_, 
   {{0x27e804d9,0xa7b800e7,0x6e240380,0x78780cf4}},	//   ýan_, улду_, _hohb, tíva, 
   {{0x7cec00cd,0x7648015e,0xab000192,0x38bc00d3}},	//   _törö, _bmdy, _kříž_, _párá_, 
   {{0xd6cc0051,0x76480085,0x787803b2,0xf770031e}},	//   رقى_, _cmdy, ríva, ذان_, 
   {{0x6e240156,0x29040cf5,0xab00012c,0x78780247}},	//   _mohb, _éla_, _mříž_, síva, 
   {{0xd36c0a1d,0x95d40cf6,0x3d080881,0x6e24002a}},	//   ڙهي_, адәт_, हिते_, _lohb, 
   {{0xdb040cf7,0x03a000f8,0xe2140075,0x38ac0223}},	//   _sekú, биқо, مبدع, _tòrò_, 
   {{0x6e240140,0x6494028d,0x764800b0,0x22140cd3}},	//   _nohb, _ašie, _gmdy, сфир, 
   {{0x26180cf8,0x20000264,0x9f5c00bd,0x660002b0}},	//   पाठी_, tdki_, ětí_, _ialk, 
   {{0x66000cf9,0xca300853,0x6e240177,0x3ec802dc}},	//   _halk, ﺭﺍﺭ_, _aohb, ақим_, 
   {{0x238401b5,0x53980107,0x1858007c,0x81e00143}},	//   _أشِ, _עיסו, רכרע, _পোঃ_, 
   {{0x660006ea,0xdb040a03,0x63b80cfa,0x00000000}},	//   _jalk, _tekú, _hewn, --, 
   {{0x66000cfb,0x62980047,0xdca40cfc,0x6d40014e}},	//   _malk, _huwo, саби, úlap, 
   {{0x66000cfd,0x62980cfe,0xebb8076f,0xdd940200}},	//   _lalk, _kuwo, yoḥ_, раңы, 
   {{0x63b8009c,0x6298010b,0x186802ac,0x7b840121}},	// [920] _mewn, _juwo, қади_, زارە, 
   {{0x63b80264,0x69dc0698,0x62980cff,0x66000d00}},	//   _lewn, _पाणी, _muwo, _nalk, 
   {{0xa3f800b3,0xd9440d01,0x62980140,0x5fbc0d02}},	//   ्याप_, щежи, _luwo, _्याल, 
   {{0x63b80d03,0x764802a6,0x62980b66,0xb9000d04}},	//   _newn, _smdy, _ouwo, _दम_, 
   {{0x62980d05,0x6e240140,0xe6b402ac,0xef400020}},	//   _nuwo, _yohb, قلنگ, _ኣድናቖ, 
   {{0x06d40cce,0xceb004b0,0x66000d06,0x7a20002a}},	//   _দৈহি, ליד_, _calk, _lötz, 
   {{0x66000d07,0x7ae40d08,0x69dc0203,0xf1b8011a}},	//   _dalk, ltit, _पाती, jjġa_, 
   {{0x78780043,0x62980d09,0x7ae40046,0xb6c800d5}},	//   mívo, _buwo, otit, _ناطے_, 
   {{0x8c18033c,0x66000d0a,0x136802eb,0x2fdc0101}},	//   רופי, _falk, ышки_, _öwgi_, 
   {{0x66000d0b,0x7ae40d0c,0x62980d0d,0x8af80282}},	//   _galk, itit, _duwo, נהיי, 
   {{0x7ae40673,0xefe402b4,0x63b80336,0x78780d0e}},	//   htit, _ምሳይ_, _fewn, nívo, 
   {{0x6e240d0f,0x7ae40d10,0x7878018b,0xa0340121}},	//   _sohb, ktit, zívn, قىپت, 
   {{0x447800b9,0x62980266,0x6e24006f,0x7ae40237}},	//   _ענדע, _guwo, _pohb, jtit, 
   {{0x66000d11,0x63b8002f,0xdb1400c4,0x3c3c02e8}},	//   _xalk, _zewn, gayí, _lívd_, 
   {{0x90a40d12,0x63b80d13,0x7ae40d14,0x8bc40d15}},	//   _احتم, _yewn, etit, йсад, 
   {{0x7a200d16,0x6e240130,0x7ae40d17,0xb938010f}},	//   _götz, _wohb, ftit, _በሚካሄ, 
   {{0x2fc80d18,0x7ae40d19,0x78780032,0x3eac0212}},	// [930] _idag_, gtit, tívn, čitý_, 
   {{0x80d802fa,0xdb240d1a,0x182802ac,0x00000000}},	//   ববর্, غولی, یقلی_, --, 
   {{0x7ae40a94,0x6f0c0212,0x27d80254,0x10a00041}},	//   atit, _hrac, иджь_, _ﺍﻟﺪﯨ, 
   {{0x6f0c0d1b,0x66000d1c,0x2df40012,0x7878018b}},	//   _krac, _salk, _آگر, sívn, 
   {{0x66000d1d,0x8c9c0203,0x7a2000e3,0xfe700801}},	//   _palk, _खंडो, _löty, _زدی_, 
   {{0xd1240d1e,0x6f0c0d1f,0x62980047,0x6aac0d20}},	//   _قم_, _mrac, _ruwo, mpaf, 
   {{0x66000d21,0x63b80066,0xe3b003e0,0xfd6c0200}},	//   _valk, _pewn, ورة_, ﺳﻘﺎﻥ_, 
   {{0x64940091,0x66000d22,0x6f0c0d23,0x2fc80085}},	//   _ašic, _walk, _orac, _ndag_, 
   {{0x68e404cd,0x6f0c01e5,0x66000d24,0x27ec0d25}},	//   lthd, _nrac, _talk, _iben_, 
   {{0x2fc80d26,0x63b8002f,0x317c02db,0x60e80d27}},	//   _adag_, _wewn, _bzvz_, амом_, 
   {{0x6f0c0d28,0x27ec018c,0x62980636,0x7ae40094}},	//   _arac, _kben_, _wuwo, ztit, 
   {{0x62980d29,0x7ae40d2a,0x68e40336,0xdb040085}},	//   _tuwo, ytit, ithd, _tekø, 
   {{0xc3040d2b,0x27ec0d2c,0x64940002,0x7ae400fb}},	//   _دباو, _mben_, _eġit, xtit, 
   {{0x7ae4070b,0x2fc8012a,0xf38001c4,0x5bb00290}},	//   vtit, _edag_, _яғым, जर्व, 
   {{0x27ec0981,0x6f0c0d2d,0x7ae40d2e,0x6350001d}},	//   _oben_, _erac, wtit, _ይቆጣጠ, 
   {{0x27ec0054,0x5ba80d2f,0xe81c00d1,0x00000000}},	//   _nben_, ркам_, फाफा_, --, 
   {{0x7ae40d30,0x6f0c0d31,0x68e40335,0x9aa401b5}},	// [940] utit, _grac, ethd, زماو, 
   {{0x27ec0d32,0x7ae40d33,0x78780d34,0x2fc8015e}},	//   _aben_, rtit, tívo, _zdag_, 
   {{0x7ae40d35,0x6f0c0b34,0x6aac03f4,0xd2380100}},	//   stit, _zrac, apaf, סגעל, 
   {{0x7ae40d36,0xb6c80191,0x27ec02bb,0x787802ba}},	//   ptit, ماتے_, _cben_, rívo, 
   {{0x7ae40d37,0xd9d0006e,0xc7a00d38,0xdb0c0223}},	//   qtit, _يەرگ, фичк, _ájàl, 
   {{0xd9440d39,0xfd6c0200,0x1f5c001d,0x00000000}},	//   _деги, ﺳﺘﺎﻥ_, _ወንድም, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25a4006f,0x00000000,0x00000000,0x00000000}},	//   _efll_, --, --, --, 
   {{0x2fc80085,0xcc380100,0x00000000,0x00000000}},	//   _rdag_, יעקט, --, --, 
   {{0x6f0c0d3a,0x4270006b,0xe6d8030f,0x7a200d3b}},	//   _rrac, мгыс, _óráð, _pöty, 
   {{0x1ae402f5,0x4a7800b9,0x649400aa,0x2fc800ba}},	//   নিয়া, שריב, _všic, _pdag_, 
   {{0x6f0c0d3c,0x403400bb,0x6aac020c,0x35e003ea}},	//   _prac, деюс, ypaf, _नाड़, 
   {{0x2fc803f4,0x00000000,0x00000000,0x00000000}},	//   _vdag_, --, --, --, 
   {{0xe3b80028,0x8d7401ff,0x649401df,0x68e40335}},	//   njűn_, قازا, _ušic, ythd, 
   {{0x6f0c0d3d,0xac180d3e,0x70540049,0x3d94041c}},	//   _wrac, бову_, _ىنتا, дирр, 
   {{0x26100d3f,0x2fc800c6,0x69dc00b3,0x3134006e}},	//   _धोनी_, _udag_, _पाही, _меһр, 
   {{0x6f0c0d40,0x27ec036b,0x97e80d41,0x785c0078}},	// [950] _urac, _rben_, ışlı, tčvn, 
   {{0x0ba800c3,0x6aac0d42,0x27ec0d43,0x00000000}},	//   _ھاجى_, rpaf, _sben_, --, 
   {{0xeff002b4,0x649400c0,0x6aac0d44,0xc8640d45}},	//   _ውሑድ_, _ošia, spaf, отди, 
   {{0x9ce801b5,0x68e40d46,0x3d080224,0x9cd40d47}},	//   _اوَے_, rthd, हिरे_, _צורה_, 
   {{0xe5a40d48,0x00000000,0x00000000,0x00000000}},	//   пили, --, --, --, 
   {{0xe5a40a3a,0x59e00d49,0x978001d9,0x0ed00030}},	//   чики, _पायर, ریله, _तिनड, 
   {{0x94c800ea,0x00000000,0x00000000,0x00000000}},	//   مايې_, --, --, --, 
   {{0x26180d4a,0x27ec0d4b,0x63780254,0x537000dd}},	//   पाही_, _uben_, йспр_, ڙهيء, 
   {{0xe70803a2,0x051802fa,0xe3b00d4c,0x00000000}},	//   _دڪان_, তনের_, ورک_, --, 
   {{0x46600bf3,0x00000000,0x00000000,0x00000000}},	//   _تۇتق, --, --, --, 
   {{0x21680d4d,0xa30801b5,0x00000000,0x00000000}},	//   сини_, _گراے_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x443c0068,0xdb140d2e,0x00000000,0x00000000}},	//   mhu_, kayá, --, --, 
   {{0x443c0d4e,0x3d080d4f,0x161c0203,0x61440d50}},	//   lhu_, हिले_, पायर_, _нела, 
   {{0x91b80107,0x443c0d51,0x20540d52,0xc3200143}},	//   _המצי, ohu_, _нтир, _বইটি_, 
   {{0x443c0d53,0x4ac40d54,0x7038001e,0x98a400fc}},	//   nhu_, _लिखव, _мчыс_, җиде, 
   {{0x443c0d55,0x8c400d56,0x00000000,0x00000000}},	// [960] ihu_, хете, --, --, 
   {{0x443c0d57,0x6d400177,0x97e80d58,0x00000000}},	//   hhu_, ùlac, ışmı, --, 
   {{0x443c0d59,0xaab80d5a,0xd8880191,0x69dc0d5b}},	//   khu_, مدەر_, مپئن_, _पारी, 
   {{0x443c0d5c,0x26100d5d,0x7c140d5e,0xca300108}},	//   jhu_, _धोबी_, _تېرش, ﺭﺍﺵ_, 
   {{0x443c0d5f,0x7c2402e8,0x787802aa,0x90a001d2}},	//   dhu_, mjir, lívk, _ﺍﻟﺤﻔ_, 
   {{0x443c0d60,0x7c240d61,0xa7fc0556,0x4b780107}},	//   ehu_, ljir, _skűt, _לאכו, 
   {{0x443c0d62,0xe3b80010,0x785c00f1,0x5fbc0674}},	//   fhu_, rjűn_, lčvm, ्णाल, 
   {{0x7c240d63,0x443c0d64,0x3f800770,0xe3b80028}},	//   njir, ghu_, _oziu_, sjűn_, 
   {{0xdb0400cd,0x97000121,0x2618006c,0xa3ac0030}},	//   _nekü, _سېغى, पाशी_, _कभर_, 
   {{0x31340d65,0xdb040116,0x7c240770,0x96640d66}},	//   деор, _hekó, hjir, _экзе, 
   {{0x443c0d67,0x26180d68,0x649402e6,0xd5380094}},	//   bhu_, पारी_, _išin, _уяач_, 
   {{0x443c0d69,0x7c240d6a,0xdb040191,0x7878012c}},	//   chu_, jjir, _bekü, dívk, 
   {{0x69dc0203,0x7c240028,0x2d740121,0x649400c0}},	//   _पाली, djir, ﺸﯩﻨﻰ_, _ušia, 
   {{0xdb0403ef,0xdcfc00a8,0x00000000,0x00000000}},	//   _lekó, _śvād, --, --, 
   {{0xda080076,0xc2780107,0x629c00ef,0x7d080d6b}},	//   _होइत_, _הרגי, ísov, ådsp, 
   {{0x7c240d6c,0x41580107,0xdb0401b8,0x00000000}},	//   gjir, _לדוג, _fekü, --, 
   {{0x7b180254,0xdb040d6d,0x649401df,0x629c01c6}},	// [970] потр_, _gekü, _ošin, ŭsov, 
   {{0x443c0870,0x7c2400dd,0xca700a42,0x79a400e1}},	//   zhu_, ajir, رناک, ерце, 
   {{0x443c0551,0x7c380b07,0x7c240080,0x8bc00320}},	//   yhu_, ñará, bjir, _пинç, 
   {{0xf770031b,0x443c0475,0x3fb00108,0x00000000}},	//   گام_, xhu_, ﺳﻤﺎﻧ, --, 
   {{0x26180d6e,0x66e40362,0xdb1404ac,0xdb040d6f}},	//   पाली_, фола, payá, _dekó, 
   {{0xf7700d70,0x00000000,0x00000000,0x00000000}},	//   دام_, --, --, --, 
   {{0xb6cc02a0,0x00000000,0x00000000,0x00000000}},	//   _şütü, --, --, --, 
   {{0xd24c0046,0x29100039,0x443c0d71,0x00000000}},	//   یني_, _irza_, uhu_, --, 
   {{0x36d40d72,0x443c06a8,0x13040d73,0x64840306}},	//   _потр, rhu_, дный_, hóig, 
   {{0x68e0046a,0x3c3c0247,0x7d080b1e,0x6484001e}},	//   _älds, _míva_, ædsk, kóig, 
   {{0x443c0d74,0xdb040d75,0x3c3c02e8,0x91c000df}},	//   phu_, _jekò, _líva_, тәчл, 
   {{0x443c0990,0x261000a1,0x3c3c001e,0x7c240060}},	//   qhu_, _धोती_, _oíva_, xjir, 
   {{0xdb040cc9,0x9424006e,0x7c24018f,0x23280d76}},	//   _lekò, _تونۇ, vjir, _фоли_, 
   {{0x291000c2,0x00000000,0x00000000,0x00000000}},	//   _orza_, --, --, --, 
   {{0xdcb0006e,0x64840075,0xa2d80d77,0x7c24043b}},	//   ئىر_, róif, फूर्, tjir, 
   {{0x6e200270,0xbd0801d2,0x97e80386,0x8c9c0030}},	//   ölbr, _ورﯨﻨ, ışkı, _खंरो, 
   {{0x7c240d78,0x59e00d79,0x291000fc,0x5f740d7a}},	// [980] rjir, _पादर, _arza_, _تاثر, 
   {{0x29100473,0x64840272,0x3ea00d7b,0x7c24028b}},	//   _brza_, lóid, _iuit_, sjir, 
   {{0x78780d7c,0xd00c0d7d,0x3ea00d7e,0x28a40200}},	//   lívi, _صلی_, _huit_, ешіг, 
   {{0x3ea00d7f,0xc320007e,0xdb0400f1,0x64840d80}},	//   _kuit_, _বেছি_, _dekò, nóid, 
   {{0x3ea00043,0x29100039,0x46a00007,0x7bc40151}},	//   _juit_, _erza_, вачв, maiu, 
   {{0x64840075,0x7bc40d81,0x00000000,0x00000000}},	//   hóid, laiu, --, --, 
   {{0xa8180d82,0x3ea00034,0xdb040247,0xda0800b6}},	//   تتەر_, _luit_, _tekó, _होएत_, 
   {{0x7bc40d83,0x672c0020,0x3ea00078,0x159000c3}},	//   naiu, ënjë, _ouit_, ﻟﯘﺷﯩ, 
   {{0x3ea00d84,0x68e004bc,0xa3ac0774,0x64840075}},	//   _nuit_, _äldr, कड़_, dóid, 
   {{0x7bc40d85,0x649400b0,0x656c0055,0x00000000}},	//   haiu, _ušin, şaha, --, 
   {{0x7bc40d86,0x64940192,0x64840d87,0xdb140d88}},	//   kaiu, _kšil, fóid, bayç, 
   {{0x3ea00d89,0x68e004bc,0x6484059b,0x28d0011e}},	//   _buit_, _ålde, góid, _हिसि, 
   {{0x3ea00d8a,0xdb1401c8,0x7bc40177,0xc7b00107}},	//   _cuit_, nayä, daiu, כבר_, 
   {{0x3ea00d8b,0x246404c4,0x3c3c02e8,0x3b00011a}},	//   _duit_, rēme_, _ríva_, dwiq_, 
   {{0x2f240d8c,0x3ea0034c,0xac180d8d,0x648401ca}},	//   _bëgë_, _euit_, пову_, bóid, 
   {{0x3ea00d8e,0xdb04065e,0xdb140d8f,0x64840d87}},	//   _fuit_, _rekò, kayä, cóid, 
   {{0x2f240029,0x787800cc,0x291001df,0x00000000}},	// [990] _dëgë_, cívi, _srza_, --, 
   {{0xdb040078,0xaf54001e,0x64840247,0x00000000}},	//   _pekò, _онқә, póig, --, 
   {{0x3ea003f4,0x7bc400c2,0xe7f40094,0x30bc0143}},	//   _zuit_, baiu, ечлэ, _অমুস, 
   {{0xec3400b9,0x1ee802ac,0x799c0379,0x7bc400b7}},	//   _נאָר_, _بویی_, _egrw, caiu, 
   {{0x6b9c0379,0xe8780012,0x9b4001b5,0x00000000}},	//   _igsg, _ہجرچ_, _یۆہو, --, 
   {{0x2ca0010b,0x648401f1,0x60140d90,0x291003bf}},	//   _kuhd_, zóid, _kümä, _trza_, 
   {{0x67d4005b,0x291001d1,0x00000000,0x00000000}},	//   _пову, _urza_, --, --, 
   {{0x69c40d91,0x2ca00d92,0x58000121,0x232802dc}},	//   lahe, _muhd_, _مۈمك, зоии_, 
   {{0xe354012b,0xae5c01d2,0x00000000,0x00000000}},	//   эткэ, _ﺍﺳﺎﯞ_, --, --, 
   {{0x69c40d93,0x3ea00d94,0x26dc0b75,0x64940023}},	//   nahe, _ruit_, muwo_, _išim, 
   {{0x26dc0d95,0x64840d96,0x3ea00d97,0x00000000}},	//   luwo_, tóid, _suit_, --, 
   {{0x69c40d98,0x78780214,0x6b9c0d99,0x3ea00d9a}},	//   hahe, tívi, _ngsg, _puit_, 
   {{0x69c40d9b,0x63a80d9c,0x64840d9d,0x82800108}},	//   kahe, mcen, róid, _иңиз, 
   {{0x69c40d9e,0x3ea000e7,0x2ca00249,0x248c0d9f}},	//   jahe, _vuit_, _buhd_, lmem_, 
   {{0x69c40da0,0xe06003b5,0x6abc0379,0x6484059b}},	//   dahe, _مێدی, _awsf, póid, 
   {{0x26dc0da1,0x3ea001d6,0x248c0da2,0xdb1404db}},	//   kuwo_, _tuit_, nmem_, yayä, 
   {{0x8d740121,0x69c40da3,0xcb640254,0xf21400b6}},	// [9a0] _ۋاپا, fahe, еате_, _थोड़_, 
   {{0x63a80308,0x26dc0047,0x3b0002b1,0xda0800b6}},	//   hcen, duwo_, rwiq_, _होखत_, 
   {{0x63a80da4,0xdb140da5,0x7bc40a65,0x248c03af}},	//   kcen, wayä, paiu, kmem_, 
   {{0x26dc0da6,0x63a80da7,0x5e440012,0x59e00021}},	//   fuwo_, jcen, _آنگٕ, _पावर, 
   {{0x69c40da8,0x26dc0da9,0x248c01f6,0x2ca001e3}},	//   bahe, guwo_, dmem_, _zuhd_, 
   {{0x63a80daa,0x69c40dab,0x5504009e,0xdb1403c0}},	//   ecen, cahe, ечиа, rayä, 
   {{0x649400e9,0x63a80034,0x00000000,0x00000000}},	//   _išij, fcen, --, --, 
   {{0x26dc075d,0x63a80dac,0xdb140105,0xc51001d2}},	//   buwo_, gcen, payä, ابوت, 
   {{0x9f5003af,0x88540107,0x28740116,0x64840306}},	//   _mayó_, _נשמע_, _рырр, fóib, 
   {{0x63a80dad,0x25a80dae,0x7e600daf,0xdbdc00d3}},	//   acen, _قدمي_, émpl, _síìf, 
   {{0x63a805e3,0x00000000,0x00000000,0x00000000}},	//   bcen, --, --, --, 
   {{0x63a80db0,0x69c40db1,0x161c00b3,0x853800ca}},	//   ccen, zahe, पावर_, _מגבי, 
   {{0x69c40db2,0x9f500031,0x91e000ec,0x24480db3}},	//   yahe, _tayý_, _йәнһ, _تجلي_, 
   {{0x28d00db4,0x69c4028b,0x00000000,0x00000000}},	//   _हिलि, xahe, --, --, 
   {{0x69c40db5,0xbd680db6,0x2258029f,0x26dc075d}},	//   vahe, ерте_, èske_, zuwo_, 
   {{0x69c40db7,0x9f5000dc,0x41780100,0x8aa40027}},	//   wahe, _cayó_, _מנוב, ержд, 
   {{0x63bc03e2,0x8c34041c,0x00000000,0x00000000}},	// [9b0] ðsni, _ҷонӣ_, --, --, 
   {{0x248c0db8,0x320c00b7,0x290003f4,0x6e9401c7}},	//   zmem_, nddy_, twha_, _шипу, 
   {{0x69c40db9,0x63a80dba,0x26dc0dbb,0x29000dbc}},	//   rahe, ycen, wuwo_, uwha_, 
   {{0x69c40dbd,0x63a80dbe,0x26dc0dbf,0x22bc0078}},	//   sahe, xcen, tuwo_, yňk_, 
   {{0x69c40dc0,0x1cdc0002,0x29000dc1,0x37740dc2}},	//   pahe, _ལའོ_, swha_, лышс, 
   {{0x26dc0dc3,0x649402dd,0x24f40dc4,0xdb1c0223}},	//   ruwo_, _všim, вчир, _ìyáp, 
   {{0x26dc0403,0x9f5000d3,0x248c0dc5,0x61e401c5}},	//   suwo_, _jayò_, tmem_, _öhli, 
   {{0x64940091,0x26dc075d,0x756801b8,0x9f400139}},	//   _išik, puwo_, رینہ_, mekö_, 
   {{0x64940dc6,0x14200dc7,0x2b48014a,0x9f500229}},	//   _ušim, рдым, nzac_, _layò_, 
   {{0x248c0477,0x2b480054,0xc0240020,0xe298001e}},	//   smem_, izac_, _ሲቪላው, ьап_, 
   {{0x80b40664,0x63a80dc8,0x1cdc0126,0x00000000}},	//   _অমঙ্, pcen, _ལའེ_, --, 
   {{0x321c0dc9,0x00000000,0x00000000,0x00000000}},	//   _envy_, --, --, --, 
   {{0xa2e40dca,0x9f5003b4,0x00000000,0x00000000}},	//   _ролд, _ücün_, --, --, 
   {{0x649401df,0x442c0426,0x2f8400ec,0x2b480dcb}},	//   _ošik, _hog_, ыҙын_, dzac_, 
   {{0x1fb40dcc,0x21740282,0xdca40dcd,0x61440041}},	//   _испр, _בײַם_, таби, _шека, 
   {{0x442c0dce,0xdb04019f,0x9f5000d3,0x785c00f1}},	//   _jog_, _mekö, _dayò_, pčvi, 
   {{0x442c0dcf,0x4f0403c4,0x1e840dd0,0xfaa40dd1}},	// [9c0] _mog_, _анын_, _илим, اجری, 
   {{0x4a400dd2,0x442c0dd3,0x8f3400ca,0x0a140012}},	//   анув, _log_, _סניף_, نہُک_, 
   {{0x442c0dd4,0x2dd80282,0x0d200dd5,0x26cc0dd6}},	//   _oog_, _אַרב, _күрү, _aveo_, 
   {{0xca300dd7,0x442c0dd8,0x00000000,0x00000000}},	//   ﺭﺍﺕ_, _nog_, --, --, 
   {{0x2b480dd9,0x98b00055,0x656c0dda,0x00000000}},	//   czac_, ıcım_, şahl, --, 
   {{0x442c0ddb,0x64940ddc,0xdb040ddd,0xdef001da}},	//   _aog_, _ušij, _bekö, _ሌኒን_, 
   {{0x442c0dde,0x5d780100,0x58940ddf,0x5504028e}},	//   _bog_, ואַק, _ашау, тчла, 
   {{0x442c0de0,0x78780de1,0x00000000,0x00000000}},	//   _cog_, tívu, --, --, 
   {{0x442c0bcf,0xb2740121,0xdc44001d,0x932400d5}},	//   _dog_, ллиш, _መወሰኑ, ئربن, 
   {{0xc0d0010f,0x442c0de2,0x3324011a,0x00000000}},	//   ራለሁ_, _eog_, rxmx_, --, 
   {{0x442c0de3,0xdb04019f,0xd4040de4,0x76580139}},	//   _fog_, _gekö, _аяли, mivy, 
   {{0x76580a1d,0x442c0de5,0x312401a7,0x64840d87}},	//   livy, _gog_, вдүг, róic, 
   {{0x787805c0,0x1cdc0126,0x9f500223,0xdfcc01ac}},	//   lívs, _ལའུ_, _sayò_, سڊي_, 
   {{0x442c0179,0xc20c04bb,0xdb0c0223,0x00000000}},	//   _zog_, _ؤن_, _ájùl, --, 
   {{0x442c0de6,0x2d840de7,0xe81400bd,0x00000000}},	//   _yog_, åle_, णयमा_, --, 
   {{0x3d080698,0x76580de8,0x64b00de9,0x442c01b5}},	//   हिजे_, hivy, _fāif, _xog_, 
   {{0xbd680254,0xfb340dea,0x76580deb,0x00000000}},	// [9d0] ерӂе_, антэ, kivy, --, 
   {{0x2b480dec,0x201c0059,0x9f500229,0x5fb40098}},	//   rzac_, ētie_, _tayò_, ूरथल, 
   {{0x2d580396,0x39a40833,0x76580ded,0x26cc0070}},	//   _чинь_, ршув, divy, _sveo_, 
   {{0xdd3800ca,0x672c0027,0x00000000,0x00000000}},	//   _נערכ, äajo, --, --, 
   {{0x442c0dee,0xd7ec0def,0xdb040638,0xdcfc0059}},	//   _rog_, سكو_, _sekö, _izpā, 
   {{0x442c04e7,0x69dc0584,0x7f3c0107,0xfd100df0}},	//   _sog_, _पाटी, ועדו, _اجی_, 
   {{0x442c0df1,0x64980df2,0x46dc00b6,0x78780df3}},	//   _pog_, нтир_, _नमकह, tívt, 
   {{0x442c0df4,0x78ac03aa,0x00000000,0x00000000}},	//   _qog_, žové, --, --, 
   {{0x97e80df5,0xe2980332,0x442c0df6,0x76580bf8}},	//   ıştı, наи_, _vog_, bivy, 
   {{0x442c061a,0x76580df7,0x93c8004b,0x00000000}},	//   _wog_, civy, ٘ایہ_, --, 
   {{0xd7740020,0x009c01d2,0x00000000,0x00000000}},	//   _ክሓተካ_, _ﺍﻟﺒﺤ_, --, --, 
   {{0xe0440df8,0xe2980116,0x00000000,0x00000000}},	//   унми, ьаҿ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f400df9,0x21680dfa,0x59e00192,0x00000000}},	//   ngké_, _пили_, _पाइर, --, 
   {{0xc0c00200,0x00000000,0x00000000,0x00000000}},	//   ﻩﻛﻪﺗ, --, --, --, 
   {{0x5f040329,0x6bb4021d,0x30740320,0x00000000}},	//   _бзиа, исує, _вуьс, --, 
   {{0x20000dfb,0x1ec801a0,0xaab801b5,0x58940049}},	// [9e0] meki_, _ялпи_, ندٕر_, ңшеу, 
   {{0xde040111,0x00000000,0x00000000,0x00000000}},	//   _спои, --, --, --, 
   {{0x1cdc0c89,0x9c640dfc,0x61e401c5,0xae040108}},	//   _ལའི_, _مهدو, _öhlu, _ئوپى, 
   {{0x6494043b,0xb6c800d5,0x5380001d,0x00000000}},	//   _eġiz, ناتے_, _የዳዊት_, --, 
   {{0x237c0008,0xdb04001e,0x6d680513,0x00000000}},	//   _nywj_, _pekõ, ăpaţ, --, 
   {{0x20000dfd,0xdb040028,0x00000000,0x00000000}},	//   heki_, _dekô, --, --, 
   {{0x76580dfe,0x20000dff,0xd4980e00,0xd9440e01}},	//   rivy, keki_, нри_, _севи, 
   {{0x20000e02,0x76580e03,0x97e80e04,0x53e40023}},	//   jeki_, sivy, ışsı, уцка, 
   {{0x20000397,0xe8500e05,0x02a00152,0x03e400ea}},	//   deki_, _بۆند, йрэм, اډمي_, 
   {{0x32540e06,0xf23800cc,0x00000000,0x00000000}},	//   рвор, тпош_, --, --, 
   {{0x46380100,0x64840e07,0x42700094,0x00000000}},	//   _רעבע, móin, сгэс, --, 
   {{0x20000e08,0x64840e09,0xc95000ca,0x53a40123}},	//   geki_, lóin, ממת_, _садб, 
   {{0x2618006c,0x00000000,0x00000000,0x00000000}},	//   पाची_, --, --, --, 
   {{0xf1940e0a,0xc32c0b0f,0x64840e0b,0x00000000}},	//   _киль, _رەپ_, nóin, --, 
   {{0x20000e0c,0x64b001d6,0x8c6400fc,0x00000000}},	//   beki_, _gāid, гтад, --, 
   {{0x20000397,0xade80cda,0xb3740020,0x00000000}},	//   ceki_, ञ्जन_, _ካናዳን_, --, 
   {{0xaa540e0d,0xdf5400e2,0xadd40106,0x0dc80106}},	// [9f0] аваш, _پريښ, _копљ, _пуни_, 
   {{0xdb040556,0x64840e0e,0x00000000,0x00000000}},	//   _rekô, jóin, --, --, 
   {{0xe7b40e0f,0x64840e10,0x00000000,0x00000000}},	//   لماد, dóin, --, --, 
   {{0x64b00059,0x27e80030,0x6fb40e11,0x69b40030}},	//   _jāie, üan_, ंडिं, ेरही, 
   {{0x65c40e12,0xe694001e,0xbd88005e,0x00000000}},	//   абла, аиды, _لنین_, --, 
   {{0x20000e13,0x64840e10,0xade80095,0x00000000}},	//   zeki_, góin, ञ्चन_, --, 
   {{0x85540e14,0x7dd00191,0x69d401d1,0x200000ea}},	//   دیار_, lósí, _idze, yeki_, 
   {{0x200004cd,0x00000000,0x00000000,0x00000000}},	//   xeki_, --, --, --, 
   {{0x20000e15,0x009c0049,0x00000000,0x00000000}},	//   veki_, _ﺍﻟﺘﺤ_, --, --, 
   {{0x20000e16,0xf7700e17,0x99480e18,0xba9001d2}},	//   weki_, _راق_, nışa_, _ﺒﺎﻟﻙ_, 
   {{0x21680e19,0x60240e1a,0x8c380104,0x69ac0030}},	//   тини_, адна, _mißb, _जलनी, 
   {{0x20540e1b,0x00000000,0x00000000,0x00000000}},	//   ртор, --, --, --, 
   {{0x1cdc0037,0x443c0e1c,0x20000e1d,0x4f0401ec}},	//   _ལའང_, mku_, reki_, анян_, 
   {{0x64480e1e,0x443c0e1f,0x20000e20,0x69d406a8}},	//   lhei, lku_, seki_, _ndze, 
   {{0xdd900e21,0x20000849,0x628002bb,0x5c540123}},	//   زور_, peki_, mllo, атаф, 
   {{0x64480e22,0x443c0e23,0x69d40e24,0x0d80016d}},	//   nhei, nku_, _adze, өһөн, 
   {{0x443c0e25,0x62800e26,0x64480e27,0x1ae40e28}},	// [a00] iku_, ollo, ihei, розм, 
   {{0x443c0e29,0x64480e2a,0x6f08024f,0x62800e2b}},	//   hku_, hhei, çece, nllo, 
   {{0x64480e2c,0x62800e2d,0xaab80e2e,0x3c3c020c}},	//   khei, illo, ندەر_, _lívi_, 
   {{0x443c0473,0x64480e2f,0x62800e30,0x69d40e31}},	//   jku_, jhei, hllo, _edze, 
   {{0x64480e32,0x64840191,0x628002bb,0x8b64021d}},	//   dhei, tóin, kllo, _вияв_, 
   {{0x7ae40e33,0x443c0e34,0x1dc400cb,0x6448018c}},	//   muit, eku_, वरित, ehei, 
   {{0x7ae40e35,0x644803e0,0x443c01b5,0x628004cd}},	//   luit, fhei, fku_, dllo, 
   {{0x64480e36,0x62800e37,0x443c0e38,0x7ae4042e}},	//   ghei, ello, gku_, ouit, 
   {{0x77940e39,0x78a0009d,0x55e40e3a,0x973401a7}},	//   _ایشا, _iimv, _возб, _тэвч, 
   {{0x443c0e3b,0x64480028,0x7ae40296,0xe2940122}},	//   aku_, ahei, iuit, مێنت_, 
   {{0x7ae40e3c,0x78a007d4,0x64480e3d,0x443c0e1c}},	//   huit, _kimv, bhei, bku_, 
   {{0x443c0e3e,0x7ae40a84,0x62800e3f,0x3f8001e7}},	//   cku_, kuit, allo, _byiu_, 
   {{0xad240e40,0x7ae40132,0x78a00047,0xd37004c3}},	//   ڭىزى, juit, _mimv, _بهش_, 
   {{0x7ae40e41,0x78a008a2,0x6e940e42,0x2abc0223}},	//   duit, _limv, сигу, _lábò_, 
   {{0x8bc40573,0x0ed000b3,0xb0f80e43,0xc0e00e44}},	//   исад, _तिकड, _сейф_, _дојк, 
   {{0x78a0017b,0x7ae40e45,0xada400c3,0x00000000}},	//   _nimv, fuit, раңл, --, 
   {{0x7ae40e46,0x99880078,0x9948027f,0x49c802eb}},	// [a10] guit, _dabō_, tışa_, вуем_, 
   {{0x64480361,0x443c0e47,0x656c009f,0x8c380e48}},	//   zhei, zku_, şahi, _bißc, 
   {{0x443c0b92,0x64480141,0x78a007d4,0x99480e49}},	//   yku_, yhei, _bimv, rışa_, 
   {{0x7ae40e4a,0x6f0c0308,0x64480008,0x443c028b}},	//   buit, _ksac, xhei, xku_, 
   {{0x443c0113,0x62800e4b,0x7ae40e4c,0x3b640683}},	//   vku_, yllo, cuit, _дърв, 
   {{0x64a40e4d,0x6f0c042e,0x2fc80e4e,0x9574010f}},	//   бака, _msac, _leag_, ርጉትን_, 
   {{0xd5ac0e4f,0x6f0c01e3,0x62800475,0xe578001e}},	//   رفي_, _lsac, vllo, ызк_, 
   {{0x6f0c0b75,0x240800f8,0x2fc800c2,0x644805ab}},	//   _osac, унии_, _neag_, uhei, 
   {{0x6f0c01e5,0x27ec0e50,0x628000cc,0x398c00d3}},	//   _nsac, _icen_, tllo, _tósí_, 
   {{0x64480e51,0x78a00e52,0xe20800d3,0x00000000}},	//   shei, _zimv, _gbọ́_, --, 
   {{0x2fc80e53,0x64480e54,0x6f0c0e55,0x84640683}},	//   _beag_, phei, _asac, _къде, 
   {{0x7ae40ca7,0x53740090,0x64480008,0x443c04db}},	//   yuit, _አዳዲስ_, qhei, qku_, 
   {{0x64580e56,0x9e640272,0x02a40e57,0x6f0c0e58}},	//   _imwi, ماسن, _трем, _csac, 
   {{0x7ae40e59,0xe1f00e5a,0x62800105,0x00000000}},	//   vuit, _رست_, qllo, --, 
   {{0x6f0c0990,0x64580043,0x27ec0e5b,0x6efc01c9}},	//   _esac, _kmwi, _ocen_, _påbö, 
   {{0x68e40840,0x27ec0324,0x2fc805ab,0x64840247}},	//   duhd, _ncen_, _geag_, kóim, 
   {{0x78a00e5c,0x7ae401f1,0xdb140031,0xb3780020}},	// [a20] _rimv, uuit, bayý, _ርትዕን_, 
   {{0x20100e5d,0x78a00e5e,0x27ec0e5f,0x64840306}},	//   _hayi_, _simv, _acen_, dóim, 
   {{0x64580e60,0x20100e61,0x00000000,0x00000000}},	//   _omwi, _kayi_, --, --, 
   {{0x7ae40e62,0x20100e63,0x00000000,0x00000000}},	//   puit, _jayi_, --, --, 
   {{0x20100e64,0x25a40086,0x00000000,0x00000000}},	//   _mayi_, _bgll_, --, --, 
   {{0x64580e65,0x20100e66,0x27ec0e67,0x00000000}},	//   _amwi, _layi_, _ecen_, --, 
   {{0x78a00e68,0x1868005b,0x00000000,0x00000000}},	//   _timv, _бави_, --, --, 
   {{0x20100e69,0x00000000,0x00000000,0x00000000}},	//   _nayi_, --, --, --, 
   {{0x66100274,0xd1c800b8,0xcc380100,0x90a00049}},	//   ökkä, лунд_, טעקט, _ﺍﻟﺘﻔ_, 
   {{0x64580b66,0xdb140105,0x6f0c0177,0x2010028b}},	//   _emwi, layó, _rsac, _aayi_, 
   {{0x20100e6a,0x53140e6b,0x25ec0030,0x00000000}},	//   _bayi_, _گذار, _घाती_, --, 
   {{0x20100110,0x0ee80e6c,0x6f0c011e,0x00000000}},	//   _cayi_, льги_, _psac, --, 
   {{0x64b00341,0x20100e6d,0x64940e6e,0x708400bf}},	//   _iāia, _dayi_, _všit, йгүз, 
   {{0x42700049,0x0af00182,0x00000000,0x00000000}},	//   _егіс, үүнэ, --, --, 
   {{0x64940e6f,0x201000ba,0x64b000a2,0x2fc801d6}},	//   _tšit, _fayi_, _kāia, _teag_, 
   {{0x6f0c03c0,0x649403aa,0x4fb40e70,0xe1640324}},	//   _tsac, _ušit, _اصغر, _بدهي, 
   {{0x6f0c0e71,0x6a34005b,0x64b00299,0x69c0013c}},	// [a30] _usac, онађ, _māia, _õlek, 
   {{0x27ec0e72,0x6aac0020,0x20100e73,0xa3800030}},	//   _scen_, rqaf, _zayi_, öõig, 
   {{0x20100e74,0x6e24034a,0x36e80e75,0xfe24001e}},	//   _yayi_, _inhb, ەرىپ_, _хьын, 
   {{0xac180e76,0x64b004c4,0xf990067d,0x764800df}},	//   _тому_, _nāia, ربل_, _aldy, 
   {{0x68e40274,0x667404c3,0xe7280e77,0x6aac0560}},	//   suhd, يدتر, ролд_, qqaf, 
   {{0xf7700e78,0x68e40027,0x648401ca,0xe618001e}},	//   ران_, puhd, róim, рдк_, 
   {{0x27ec01c7,0xdee40020,0xdb140247,0x64840306}},	//   _tcen_, _ምጣነ_, mbyá, sóim, 
   {{0xdb1400f1,0x648400b8,0x47f00094,0x00000000}},	//   mayò, móik, _хүдр, --, 
   {{0x20100e79,0x52a40e7a,0x2bb000aa,0x00000000}},	//   _rayi_, овым_, _झलना, --, 
   {{0x20100e7b,0x00000000,0x00000000,0x00000000}},	//   _sayi_, --, --, --, 
   {{0xdde80e7c,0x20100e7d,0x6484001e,0xdd0c0152}},	//   یرسه_, _payi_, nóik, dışe, 
   {{0x64580161,0x44f00e7e,0x6e2401eb,0x00000000}},	//   _umwi, mã_, _anhb, --, 
   {{0x201004cd,0x44f00c09,0x2d840e7f,0x00000000}},	//   _vayi_, lã_, ülen_, --, 
   {{0x20100e80,0xdca40381,0x44f00151,0x6484001e}},	//   _wayi_, жави, oã_, kóik, 
   {{0xdfd000cd,0x20100e81,0x44f00e82,0x1d080e83}},	//   _ہيں_, _tayi_, nã_, шеви_, 
   {{0x44f00e84,0x00000000,0x00000000,0x00000000}},	//   iã_, --, --, --, 
   {{0xf7cc0e85,0xdd940e86,0x44f00e87,0x7b8400c3}},	// [a40] ﮔﻪﻧﺪ, саңы, hã_, سارە, 
   {{0x09e00121,0x44f00116,0xe838012c,0x00000000}},	//   дофн, kã_, _ější, --, 
   {{0x7e7c0e88,0x44f00552,0x57a40e89,0x6d400151}},	//   morp, jã_, ошла, ùlat, 
   {{0x7e7c0e8a,0x00000000,0x00000000,0x00000000}},	//   lorp, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e7c0e8b,0xdb140078,0xc68c01b5,0x00000000}},	//   norp, bayò, نِن_, --, 
   {{0x3af40e8c,0x1ab00252,0x44f00e84,0xdb1402b1}},	//   läp_, _চিয়া, gã_, mayñ, 
   {{0x7e7c0e8d,0x18680e8e,0xdfe40e8f,0x77940e90}},	//   horp, _таби_, _कागद_, _فیضا, 
   {{0x7e7c0e91,0x16640683,0x44f00c09,0x3a380002}},	//   korp, _двам, aã_, _korp_, 
   {{0x44f00552,0x518404e7,0x7e7c012e,0x00000000}},	//   bã_, жума, jorp, --, 
   {{0x32d000c4,0x7e7c0952,0x44f00e84,0x64840247}},	//   _bôyá_, dorp, cã_, kóih, 
   {{0x64b00b60,0x3af40031,0x00000000,0x00000000}},	//   _kāin, käp_, --, --, 
   {{0xdb140d2e,0x3c3c0579,0x64b000ce,0xfd54004f}},	//   kayñ, _lívs_, _jāin, _iveṣ, 
   {{0x9de40c3a,0x7e7c0e92,0x421401b5,0x3af40e93}},	//   _སྐྱེ, gorp, _وٲنج_, däp_, 
   {{0x25b8009f,0xac940e94,0x518401f1,0x25ec0030}},	//   _əsl_, завш, _ќула, _घासी_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x44f00e84,0x7e7c0e95,0x3af40101,0x00000000}},	// [a50] zã_, borp, gäp_, --, 
   {{0x09e000ac,0x44f00e84,0x3a380e96,0xba7400e2}},	//   ন্না, yã_, _corp_, والت, 
   {{0x3a380e97,0x44f00e84,0xefc80020,0x00000000}},	//   _dorp_, xã_, _ኽሳዕ_, --, 
   {{0x3af40e98,0x44f00e84,0x3a3801d6,0xb8680111}},	//   bäp_, vã_, _eorp_, ојче_, 
   {{0x870406e3,0xdb140078,0x3af40087,0xd364059b}},	//   تبال, sayò, cäp_, _أه_, 
   {{0xd12403e0,0x44f00e99,0x3a380e9a,0xdb14029f}},	//   _كم_, tã_, _gorp_, payò, 
   {{0x44f00e9b,0x5b50001d,0x35f80249,0x00000000}},	//   uã_, _መመደቡ, ترند_, --, 
   {{0x44f00e9c,0x7e7c0085,0x00000000,0x00000000}},	//   rã_, zorp, --, --, 
   {{0xfd5400cb,0x44f00e9d,0x00000000,0x00000000}},	//   _dveṣ, sã_, --, --, 
   {{0x44f00e9e,0xfd5400a8,0x217402dc,0x00000000}},	//   pã_, _eveṣ, зумр, --, 
   {{0x7e7c0e9f,0xd12c03b5,0x00000000,0x00000000}},	//   vorp, ۆمی_, --, --, 
   {{0x44d4009e,0xa068005b,0x7e7c0400,0x29100098}},	//   mă_, сама_, worp, _msza_, 
   {{0x09e00ea0,0x44d40241,0xd12c0ea1,0xcf400393}},	//   ন্যা, lă_, _ەمى_, еняй, 
   {{0x629c02ef,0x2910010b,0x539800ca,0x04fc00dc}},	//   ůsob, _osza_, _פיסו, ্মীর_, 
   {{0x44d40241,0x64b00299,0x7e7c0ea2,0x5c68001d}},	//   nă_, _māio, rorp, _ተለይቶ_, 
   {{0x09e000ac,0x5ba80ea3,0x3a38030f,0x00000000}},	//   ন্মা, скам_, _sorp_, --, 
   {{0x7e7c01c6,0x1cdc0126,0x9aa40ea4,0x8f60001d}},	// [a60] porp, _ལའམ_, سماو, ለካከቶ, 
   {{0x3af40ea5,0x64b00296,0x7e7c0ea6,0x9e080075}},	//   räp_, _rāin, qorp, _ايدك_, 
   {{0x44d40254,0x18a40ea7,0x00000000,0x00000000}},	//   jă_, чаем, --, --, 
   {{0x44d4038e,0x64b00296,0x3a38018c,0x38c80122}},	//   dă_, _pāin, _worp_, ماڵی_, 
   {{0x3a380ea8,0x0688080a,0xe79401b5,0x291000f2}},	//   _torp_, ﻪﻟﯩﮕ, ٘اوک, _esza_, 
   {{0x7ae40ea9,0x44d40513,0x7bc40023,0xfd5401d3}},	//   mrit, fă_, lbiu, _sveṣ, 
   {{0x64b004c4,0x19840a1d,0x44d4038e,0x7ae40eaa}},	//   _wāin, _رجسٽ, gă_, lrit, 
   {{0x64b00eab,0x236802db,0x7bc40034,0x00000000}},	//   _tāin, _žaja_, nbiu, --, 
   {{0x7ae40eac,0x5748012b,0x00000000,0x00000000}},	//   nrit, _узам_, --, --, 
   {{0x7ae40ead,0x44d40254,0xc0d0010f,0x7bc402bb}},	//   irit, bă_, ያለሁ_, hbiu, 
   {{0x44d40241,0x7ae40eae,0x66800eaf,0x7d1c00c0}},	//   că_, hrit, _جیول, jvrs, 
   {{0x7d1c0eb0,0x2d840eb1,0x00000000,0x00000000}},	//   dvrs, ülem_, --, --, 
   {{0x9fa401c4,0x00000000,0x00000000,0x00000000}},	//   дырҙ, --, --, --, 
   {{0x8d7401ee,0x00000000,0x00000000,0x00000000}},	//   كازا, --, --, --, 
   {{0x7ae40eb2,0x09e00019,0x01f80107,0x82300eb3}},	//   erit, ন্ডা, _הפול, _سروا, 
   {{0x81340eb4,0x7ae40eb5,0xfe700eb6,0x10780121}},	//   _ءسوز_, frit, ندۀ_, ﻧﺎﺯﯨ, 
   {{0x44d40241,0xdb100229,0x00000000,0x00000000}},	// [a70] ză_, _ògìr, --, --, 
   {{0x6d58028a,0x00000000,0x00000000,0x00000000}},	//   _ƙwad, --, --, --, 
   {{0x7ae40eb7,0xd36403b5,0x3d240007,0x693401d5}},	//   arit, _ڤه_, _зьяв, _ořeš, 
   {{0x44d4038e,0x9cd40107,0xf9900272,0x648401db}},	//   vă_, _קורה_, ابك_, lóiv, 
   {{0x8b640eb8,0xf77001ac,0x00000000,0x00000000}},	//   _راحم, ٿان_, --, --, 
   {{0x44d40241,0xa5640eb9,0x6abc06e2,0x3cf80eba}},	//   tă_, وگان, _itsf, _بعید_, 
   {{0x69c40ebb,0x44d40513,0x6d540ebc,0x00000000}},	//   mbhe, uă_, nzza, --, 
   {{0x44d40241,0x69c4077d,0x8a600122,0x00000000}},	//   ră_, lbhe, _تێڕۆ, --, 
   {{0x44d4009e,0x7d1c0ebd,0x04fc00ac,0x64840116}},	//   să_, zvrs, ্মের_, kóiv, 
   {{0xe0d80ebe,0x44d4038e,0x7bc40ebf,0x61440ec0}},	//   ово_, pă_, zbiu, деоа, 
   {{0x69c40ec1,0x7ae4018b,0x45480111,0xd05802a0}},	//   ibhe, zrit, _учам_, lutə, 
   {{0x7ae40ec2,0x69c40ec3,0x64b0015b,0x715800fc}},	//   yrit, hbhe, _jāim, ярыс_, 
   {{0x6d400ec4,0x00000000,0x00000000,0x00000000}},	//   ølan, --, --, --, 
   {{0x7ae40ec5,0x09e000ac,0xd34401e0,0x00000000}},	//   vrit, ন্তা, _تفهی, --, 
   {{0x7ae40ec6,0x6abc02b0,0x69c40ec7,0xd12c0ec8}},	//   writ, _atsf, dbhe, _نمو_, 
   {{0xb5fc0126,0x69c40083,0x00000000,0x00000000}},	//   _imġe, ebhe, --, --, 
   {{0x7ae40ec9,0x6d540eca,0x7bc40ecb,0x64b003f2}},	// [a80] urit, azza, rbiu, _sāil, 
   {{0x1cb80ecc,0xd94400df,0xdb100223,0x00000000}},	//   _واجب_, мези, _ògír, --, 
   {{0x27fc0323,0x00000000,0x00000000,0x00000000}},	//   ffwn_, --, --, --, 
   {{0x776402ba,0x6abc002a,0x00000000,0x00000000}},	//   úixo, _ftsf, --, --, 
   {{0xc7a00ecd,0x202c0090,0x69c40479,0x4a400320}},	//   вицк, _እየተከ, bbhe, анăв, 
   {{0xf67405bc,0x75d40ece,0x4aa40121,0x69c40097}},	//   эглэ, ريبا, _окян_, cbhe, 
   {{0xdb040056,0x693400bd,0x00000000,0x00000000}},	//   _afkø, _přeš, --, --, 
   {{0xd704005b,0x09e002fa,0x73d80816,0x046004b7}},	//   _озби, ন্দা, чдир_, ктым, 
   {{0x6934012c,0x9dec0098,0x00000000,0x00000000}},	//   _vřeš, _जांघ_, --, --, 
   {{0xba080ecf,0xd6240ed0,0x6204012c,0x82900108}},	//   _ዋና_, _تعري, _čulí, نۇنچ, 
   {{0x63b80335,0x42700182,0x693400bd,0xdcfc01d5}},	//   _ffwn, тгэс, _třeš, _vzpě, 
   {{0x741403b5,0x7c58001d,0x00000000,0x00000000}},	//   _سوتا, _ሀገሪቱ, --, --, 
   {{0x2d980121,0x69c40636,0x2450014e,0x41bc011c}},	//   ﻘﯩﻨﻰ_, ybhe, _dámd_, _श्वस, 
   {{0x6d540104,0x68e00353,0x1e700ed1,0x6f1c0ed2}},	//   tzza, _ældg, лғыс, rvsc, 
   {{0x6d5401c7,0x320c0ed3,0x00000000,0x00000000}},	//   uzza, medy_, --, --, 
   {{0xc17000ca,0x320c012c,0x00000000,0x00000000}},	//   _שחק_, ledy_, --, --, 
   {{0xe2300324,0x6484001e,0x69c40306,0x00000000}},	// [a90] _شکیب, póiv, tbhe, --, 
   {{0x69c4015e,0x648401ca,0x00000000,0x00000000}},	//   ubhe, lóit, --, --, 
   {{0x69c40ed4,0x2450001e,0xf8b000c3,0xa2d40098}},	//   rbhe, _háme_, لةن_, _मौन्, 
   {{0x2aac01d1,0x6abc0207,0x648400b8,0x69c408fa}},	//   _ažbe_, _ttsf, nóit, sbhe, 
   {{0x320c0c75,0x0c6402b4,0x66e401ef,0x66040ed5}},	//   kedy_, _ተፈጢሩ_, хола, епла, 
   {{0x247c0661,0x245002f6,0xd6cc09c1,0x7a1c0078}},	//   _ኣባላት_, _máme_, حقو_, pٍta, 
   {{0x64b004c4,0xf418007e,0x24500b0a,0x6b5400f2}},	//   _tāim, থানৰ_, _láme_, _fügé, 
   {{0xe7f80357,0x233401c7,0x00000000,0x00000000}},	//   _एउटा_, ехор, --, --, 
   {{0x64b00299,0x63040ed6,0x25a8031b,0x13040673}},	//   _kāik, رودل, _فضای_, еный_, 
   {{0x320c0ed7,0xc0880b22,0x00000000,0x00000000}},	//   gedy_, _ማህጸን_, --, --, 
   {{0x64b00299,0x61440320,0x00000000,0x00000000}},	//   _māik, хена, --, --, 
   {{0xdee40ed8,0x1b0402fa,0x00000000,0x00000000}},	//   номи, রিতে_, --, --, 
   {{0xe8000584,0x644803c8,0x232800b2,0x320c069c}},	//   ळ्या_, mkei, _холи_, bedy_, 
   {{0x64480274,0x24500ed9,0x320c0113,0x975400ca}},	//   lkei, _dáme_, cedy_, גישו_, 
   {{0x62800eda,0xda000c5f,0x00000000,0x00000000}},	//   molo, र्फत_, --, --, 
   {{0x62800edb,0x64480edc,0x26cc0039,0x6484000f}},	//   lolo, nkei, _oweo_, cóit, 
   {{0x6d58028a,0xd1280340,0x64480027,0x1e840edd}},	// [aa0] _ƙwac, _وقۇۇ_, ikei, _плим, 
   {{0x644807ff,0x09e002fa,0x3d1800d1,0x79540061}},	//   hkei, ন্সা, _पनपे_, پێرا, 
   {{0x64480ede,0x0d200edf,0x64840ee0,0x18680393}},	//   kkei, _йүрү, nóis, пажи_, 
   {{0x38600011,0xdad0006e,0x69940ee1,0x6d400139}},	//   òir_, _مەرھ, трух, älae, 
   {{0x0c200348,0xdb100223,0x00000000,0x00000000}},	//   _смян, _ògàr, --, --, 
   {{0x62800ee2,0x64b00299,0x64840247,0xa5c000b8}},	//   jolo, _kāih, kóis, иҩуе, 
   {{0x320c00c0,0x00000000,0x00000000,0x00000000}},	//   vedy_, --, --, --, 
   {{0x62800ee3,0x64480ee4,0x64b00299,0xd6d00ee5}},	//   eolo, gkei, _māih, _مقر_, 
   {{0x68e001c9,0xb27400c3,0x00000000,0x00000000}},	//   _åldr, клиш, --, --, 
   {{0x42700ee6,0x245000c0,0x644802eb,0xa6a80128}},	//   лгыс, _ráme_, akei, _قالق_, 
   {{0x320c0ee7,0xda00064c,0x00000000,0x00000000}},	//   redy_, र्यत_, --, --, 
   {{0x64480ee8,0x628003f2,0xb1440087,0x68e00085}},	//   ckei, aolo, енүл, _ælde, 
   {{0x62800ee9,0x320c0eea,0xc4380240,0x00d403b5}},	//   bolo, pedy_, _מתאי, وبێت_, 
   {{0x62800788,0x6e94018f,0xee2001d2,0xa2c0012b}},	//   colo, тигу, шегi_, _тәък, 
   {{0xfd100eeb,0x814002fc,0x648401ca,0x00000000}},	//   یجہ_, _منون, móir, --, 
   {{0x64840423,0xeb40001d,0x00000000,0x00000000}},	//   lóir, _የመግለ, --, --, 
   {{0x4ea40eec,0x64b000a2,0x660400af,0x00000000}},	// [ab0] _проа, _pāik, õhkk, --, 
   {{0x64840ee0,0xdbdc06b4,0x60cc03ef,0xc9d00061}},	//   nóir, _bíóf, _łami, اماک, 
   {{0x26cc0197,0xe7380335,0x6fd4006c,0x0d480eed}},	//   _sweo_, _ngŵr_, ढरपू, _رشدي_, 
   {{0x62800eee,0x648403e0,0x00000000,0x00000000}},	//   zolo, hóir, --, --, 
   {{0x64b00296,0x98c000cb,0x648400b8,0x00000000}},	//   _tāik, āvād_, kóir, --, 
   {{0xa50809ac,0x62800eef,0xdb140186,0xc9840836}},	//   дека_, xolo, rayô, _зуби, 
   {{0x62800ef0,0x648403e0,0x08bc0ef1,0x6448021c}},	//   volo, dóir, ﺭﻛﻪﺯ, tkei, 
   {{0x62800ef2,0x232802dc,0x00000000,0x00000000}},	//   wolo, доии_, --, --, 
   {{0x64480ef3,0xe2980332,0x648401ca,0xe50800ea}},	//   rkei, маи_, fóir, سيکو_, 
   {{0x648403e0,0x628005e1,0xdb04014a,0xfa44001d}},	//   góir, uolo, îmée, _የከተሞ, 
   {{0x62800ef4,0x03e00143,0x00000000,0x00000000}},	//   rolo, ক্ষী_, --, --, 
   {{0x648403e0,0x64b00299,0xb5fc011a,0x00000000}},	//   róis, _rāih, _imġa, --, 
   {{0x649401d5,0x9e640ef5,0x942400bf,0x00000000}},	//   _ošiz, ناسن, _جونۇ, --, 
   {{0x62800ef6,0x64b000a2,0x1d080937,0x3f8c0ef7}},	//   qolo, _pāih, меги_, ādu_, 
   {{0x8d600ef8,0x248c0d8c,0x11d40075,0x3e880152}},	//   авре, olem_, _شوية_, _җинү_, 
   {{0x960c0203,0x00000000,0x00000000,0x00000000}},	//   _िस्ट_, --, --, --, 
   {{0xcb640ef9,0x248c00aa,0x70540320,0x508400ea}},	// [ac0] вате_, ilem_, _сĕте, _جاوې, 
   {{0x248c0efa,0x64b000a2,0xddcc00b0,0x00000000}},	//   hlem_, _tāih, lobž, --, 
   {{0x98a40efb,0x00000000,0x00000000,0x00000000}},	//   виже, --, --, --, 
   {{0x248c0091,0xa9940108,0x00000000,0x00000000}},	//   jlem_, ھشەت, --, --, 
   {{0x248c0efc,0x9aa40efd,0xd7300094,0x00000000}},	//   dlem_, _لمحو, рдлө, --, 
   {{0x248c0efe,0x629c0400,0x00000000,0x00000000}},	//   elem_, ïsol, --, --, 
   {{0x81d400ac,0xd4980320,0xda000d49,0x00000000}},	//   িলা_, мри_, र्णत_, --, 
   {{0x3dd8000b,0x248c0eff,0x3394041c,0x00000000}},	//   harw_, glem_, лайё, --, 
   {{0x648403e0,0xa2d40f00,0xc7a00f01,0x07a00129}},	//   tóir, _मौद्, _витк, _ватн, 
   {{0x54c4001e,0x248c0f02,0x39680020,0x00000000}},	//   _абжб, alem_, _ተኸሳሲ_, --, 
   {{0x648403e0,0x3864034a,0xebb800cb,0xc9cc00c3}},	//   róir, _kmmr_, liḥ_, _ﺗﯘﻳﻐ, 
   {{0x64840272,0x248c034c,0x00000000,0x00000000}},	//   sóir, clem_, --, --, 
   {{0xb8f40f03,0x291c0341,0xebb80828,0x64840f04}},	//   _ེས_, āwai_, niḥ_, póir, 
   {{0x3dd80335,0x00000000,0x00000000,0x00000000}},	//   garw_, --, --, --, 
   {{0xebb8076f,0x24500f05,0x8c38002a,0xbd6800b7}},	//   hiḥ_, _háma_, _mißv, врте_, 
   {{0x09c800cb,0x64840247,0x245000f2,0x00000000}},	//   िर्य, nóip, _káma_, --, 
   {{0x24500f06,0x6e440f07,0x50f00030,0x00000000}},	// [ad0] _jáma_, _منظم, _अमुआ_, --, 
   {{0x321c0f08,0x248c0f09,0x29d40046,0xdb0402b2}},	//   _javy_, zlem_, اياس, _afkó, 
   {{0x248c0f0a,0xb8b40272,0x64840247,0xeb9800ec}},	//   ylem_, لإنت, kóip, фиҡ_, 
   {{0xdd900f0b,0x2fd80177,0x00000000,0x00000000}},	//   _دوپ_, nasg_, --, --, 
   {{0x2450012c,0xc6840061,0xb814001e,0x00000000}},	//   _náma_, نێرن_, шҧтә, --, 
   {{0x248c0c12,0x321c0f0c,0xfd4c00d3,0x00000000}},	//   wlem_, _navy_, _ninọ, --, 
   {{0x69d40f0d,0x79a40f0e,0x94d001c3,0x00000000}},	//   _ieze, _врте, бојц, --, 
   {{0x69d40f0f,0x72080012,0x00000000,0x00000000}},	//   _heze, ێہنہ_, --, --, 
   {{0x248c0f10,0x69d400cd,0x321c069c,0xb51c03e1}},	//   rlem_, _keze, _bavy_, पटॉप_, 
   {{0x69d40f11,0x25ec0f12,0x248c012c,0x321c006f}},	//   _jeze, _घाटी_, slem_, _cavy_, 
   {{0x69d40f13,0x248c0f14,0xa0680f15,0x00000000}},	//   _meze, plem_, еана_, --, 
   {{0x69d40f16,0x6d580181,0x2fd8017d,0x245000f2}},	//   _leze, _ƙwan, gasg_, _fáma_, 
   {{0x442c0f17,0x321c069c,0x64b000a2,0xa06800c3}},	//   _ing_, _favy_, _pāiw, _җапа_, 
   {{0x69d40f18,0x442c0039,0x321c0101,0xf1a80061}},	//   _neze, _hng_, _gavy_, عایه_, 
   {{0x442c0f19,0xdc9803d6,0xa0680f1a,0x00000000}},	//   _kng_, еташ_, _пака_, --, 
   {{0x69d408be,0x442c0f1b,0x62200121,0x63ac00b7}},	//   _aeze, _jng_, _ئۈگە, _ºand, 
   {{0x442c0f1c,0x0fc004f7,0xdd940f1d,0x3dd80249}},	// [ae0] _mng_, _уйын, таңы, parw_, 
   {{0x442c0f1e,0xdbd00f1f,0x69d40f20,0x4a4000b7}},	//   _lng_, rüñi, _ceze, бнув, 
   {{0x442c0f21,0x9d440f22,0x20d00919,0x2d840191}},	//   _ong_, _сенд, nši_, ület_, 
   {{0xebb8076f,0x442c0f23,0x69d4043e,0x37c401c4}},	//   tiḥ_, _nng_, _eeze, рҙаб, 
   {{0x69d40f24,0x649c024b,0xf48401e1,0x2d84043b}},	//   _feze, _ﺟﺎﭘﭙ, یابی, żlet_, 
   {{0x442c0f25,0x69d40f26,0x20d00f27,0xebb800cb}},	//   _ang_, _geze, kši_, riḥ_, 
   {{0x442c0f28,0x20d00f29,0xdcfc0059,0x550401a7}},	//   _bng_, jši_, _izpē, учла, 
   {{0x20d000bd,0x987c00b0,0x00000000,0x00000000}},	//   dši_, _iįį_, --, --, 
   {{0x69d40024,0x32540f2a,0xd24405bc,0x442c0f2b}},	//   _yeze, ивир, гэни, _dng_, 
   {{0x442c0f2c,0x2450012c,0x69d40f2d,0xcb1000ca}},	//   _eng_, _váma_, _xeze, צלת_, 
   {{0x321c07f6,0x442c0f2e,0xf19401f5,0x00000000}},	//   _vavy_, _fng_, ринь, --, 
   {{0xa0340f2f,0x442c0f30,0x312405bc,0x321c0426}},	//   لىپت, _gng_, гдүг, _wavy_, 
   {{0x321c0f31,0x752800c0,0x3b000444,0x8c38002a}},	//   _tavy_, _hrdz, jtiq_, _mißt, 
   {{0x442c02db,0x20d00c91,0x82f400ca,0x00000000}},	//   _zng_, bši_, _עצוב_, --, 
   {{0x442c0f32,0xefc40f33,0x752801d4,0xad2400c3}},	//   _yng_, _ጸጋይ_, _jrdz, جىزى, 
   {{0xda00021f,0x95dc0513,0x6b740668,0x00000000}},	//   र्सत_, răși_, албу, --, 
   {{0x69d401a7,0xdbdc0f34,0x3e900222,0x00000000}},	// [af0] _peze, _víðf, _ሓብሬታ_, --, 
   {{0x6f0c0b92,0x69d403b4,0x00000000,0x00000000}},	//   _ipac, _qeze, --, --, 
   {{0x69d40f35,0x7e60000b,0x00000000,0x00000000}},	//   _veze, ëmpe, --, --, 
   {{0x69d40f36,0x6f0c01d7,0x26dc0197,0x64b000a2}},	//   _weze, _kpac, tswo_, _māit, 
   {{0x64b005cf,0x442c01d4,0x752800b0,0x998800b0}},	//   _lāit, _rng_, _ardz, _bobų_, 
   {{0x20d00b92,0xc8d40a23,0x26dc0104,0x442c0f37}},	//   yši_, _مزرع, rswo_, _sng_, 
   {{0xe3b00699,0x442c0f38,0x057400cc,0x6f0c004f}},	//   يرة_, _png_, داشد, _lpac, 
   {{0x20d00b53,0x29000f39,0xc8b4002c,0xa4440f3a}},	//   vši_, mtha_, _асҡы, рнид, 
   {{0x442c0f3b,0x29000f3c,0xf7940023,0x20d00d2e}},	//   _vng_, ltha_, _гатэ, wši_, 
   {{0x20d00f3d,0x67280f3e,0x29000f3f,0x6d580ae3}},	//   tši_, _irej, otha_, _ƙwal, 
   {{0x6f0c0f40,0x29000f41,0x442c0f42,0x672800c0}},	//   _apac, ntha_, _tng_, _hrej, 
   {{0x442c0f43,0x67280f44,0x20d00f45,0xa0680f46}},	//   _ung_, _krej, rši_, тама_, 
   {{0x6f0c0308,0x29000747,0x00000000,0x00000000}},	//   _cpac, htha_, --, --, 
   {{0x21a40f47,0x20d0059a,0x67280f48,0x29000f49}},	//   _килм, pši_, _mrej, ktha_, 
   {{0xdb1000ed,0x6f0c0f4a,0x20d003c0,0xe0d40f4b}},	//   _ágús, _epac, qši_, _тюль, 
   {{0x67280f4c,0x3b000f4d,0x245001d5,0x29000f4e}},	//   _orej, ttiq_, _mámo_, dtha_, 
   {{0x2d840f4f,0x29000f50,0x5ba80f51,0x24500229}},	// [b00] üler_, etha_, ткам_, _lámo_, 
   {{0x2900006f,0x3b0001d9,0x00000000,0x00000000}},	//   ftha_, rtiq_, --, --, 
   {{0x290003e0,0xd7f80f52,0x67280f53,0x4f8401b5}},	//   gtha_, вул_, _arej, _مایہ, 
   {{0x6f0c0f54,0xe8e80f55,0x75280306,0x38c80122}},	//   _ypac, ارلو_, _rrdz, ناڵی_, 
   {{0x29000f56,0x68e00085,0x3b000140,0x1dd80098}},	//   atha_, _ældn, qtiq_, _बजात, 
   {{0x67280648,0x29000075,0xdcfc00e0,0x00000000}},	//   _drej, btha_, _uzpē, --, 
   {{0x29000272,0x67280191,0x98a40302,0x0f28001d}},	//   ctha_, _erej, _виве, _ሲያስረ, 
   {{0x67280f57,0x64b000a2,0x249c0335,0x44a00128}},	//   _frej, _rāit, _chwm_, يموق, 
   {{0x67280f58,0x00000000,0x00000000,0x00000000}},	//   _grej, --, --, --, 
   {{0x64b00299,0x6f0c0f59,0x32540f5a,0xdcfc03bf}},	//   _pāit, _rpac, свор, _wypę, 
   {{0x6f0c0f5b,0x543401b5,0x6728018b,0xf3e802fa}},	//   _spac, _پرار, _zrej, ক্ষর_, 
   {{0x7c3c010f,0x50640f5c,0xe1f40116,0x7ea00104}},	//   _አገሪቱ, ртоа, аҳә_, nöpf, 
   {{0x53a40f5d,0x4c1401d9,0xd2500075,0x00000000}},	//   _тадб, یبرس, _ونص_, --, 
   {{0x7ea00f5e,0x64b00341,0x7f940302,0x8d740f5f}},	//   höpf, _tāit, іарх, لازا, 
   {{0x8c640f60,0xa3bc0f61,0x7ea00e48,0x7d240b1e}},	//   атад, _आलम_, köpf, офте, 
   {{0x6e940324,0xceb800b7,0x00000000,0x00000000}},	//   _گلخا, _иљо_, --, --, 
   {{0x22980249,0x9f940031,0xeab000d5,0x00000000}},	// [b10] lèka_, _küýi_, سٹا_, --, 
   {{0x67280222,0x29000095,0x00000000,0x00000000}},	//   _rrej, ttha_, --, --, 
   {{0x672801c3,0x3d24021c,0x290001df,0x00000000}},	//   _srej, _дьяв, utha_, --, 
   {{0x67280f62,0x29000f63,0x5cc001a7,0x00000000}},	//   _prej, rtha_, _хөрв, --, 
   {{0x29000f64,0xdee402b4,0xdc34067a,0x27680061}},	//   stha_, _ዝባን_, _הארט_, دشای_, 
   {{0x29000f65,0x4f28010f,0x67280475,0xa93401f5}},	//   ptha_, _ሲያደር, _vrej, _легш, 
   {{0x48a80f66,0xe89401a7,0x6728011a,0x29000560}},	//   _атам_, _гавь, _wrej, qtha_, 
   {{0x67280f67,0x00000000,0x00000000,0x00000000}},	//   _trej, --, --, --, 
   {{0x67280f68,0xe4d80122,0x00000000,0x00000000}},	//   _urej, _ڕوات_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25d800b8,0x75800108,0x516400bf,0x00000000}},	//   _амҷы_, _оңша, йүшү_, --, 
   {{0x20540f69,0x237c01f3,0x823c001d,0x00000000}},	//   стор, _txwj_, _ይገመታ, --, 
   {{0x443c0f6a,0x2450030f,0x00000000,0x00000000}},	//   mju_, _jámm_, --, --, 
   {{0xb6cc0f6b,0xd00c00e2,0x41d803ef,0x00000000}},	//   _şükü, ولۍ_, _मजिस, --, 
   {{0xdd900f6c,0x443c02b3,0x20e40012,0x00000000}},	//   سور_, oju_, _آبٲ, --, 
   {{0x1fb40f6d,0x00000000,0x00000000,0x00000000}},	//   _ускр, --, --, --, 
   {{0x3a440155,0x8c400f6e,0xbbb800b3,0x99e40128}},	// [b20] омаҳ, чете, _अलीक, йжад, 
   {{0x443c0f6f,0xda640f70,0x4a400f71,0x995801f1}},	//   hju_, حاري, пнув, лјеф_, 
   {{0x443c020f,0xdc680f72,0x7ea0002a,0xf8a801ac}},	//   kju_, _банд_, töpf, لگره_, 
   {{0x443c0f73,0x00000000,0x00000000,0x00000000}},	//   jju_, --, --, --, 
   {{0x443c0f74,0xeb7402b3,0x7c240f75,0x38c80f76}},	//   dju_, _дырэ, mdir, _چاری_, 
   {{0x7c240f77,0x443c0f78,0x38c80f79,0x8f98023c}},	//   ldir, eju_, _ناری_, ניסי, 
   {{0x89d80107,0x7c24028b,0x443c0f7a,0x00000000}},	//   _תחלי, odir, fju_, --, 
   {{0x443c0f7b,0xa3a80f7c,0x78c401e5,0xc51000c3}},	//   gju_, _गृह_, _ịkwọ_, سبىت, 
   {{0x64b000a2,0x938804b7,0x3f8002bb,0x55e40f7d}},	//   _pāir, ыска_, _nxiu_, _гозб, 
   {{0x443c0f7e,0x28d40f7f,0x8eb00108,0x960400ea}},	//   aju_, डीवि, ۋەبت, _دبرم, 
   {{0x7c240f80,0x443c0f81,0xdcfc0192,0x00000000}},	//   kdir, bju_, _vypě, --, 
   {{0x443c0f82,0x7c240353,0x64b000a2,0x6d400139}},	//   cju_, jdir, _wāir, älam, 
   {{0x7c240f83,0x3f800029,0x64b00299,0x7ea00031}},	//   ddir, _cxiu_, _tāir, köpd, 
   {{0x7c240f84,0xdb1000d3,0x00000000,0x00000000}},	//   edir, _ògùr, --, --, 
   {{0x62640f85,0x7c240f86,0x00000000,0x00000000}},	//   _بانق, fdir, --, --, 
   {{0x7c240f87,0xc5fc015b,0x00000000,0x00000000}},	//   gdir, _ķēms_, --, --, 
   {{0x64b000a2,0xada40108,0x49c80123,0x00000000}},	// [b30] _māip, саңл, гуем_, --, 
   {{0x443c0c89,0x7b7403e0,0x7c2400af,0x3b540f88}},	//   zju_, أطفا, adir, чкур, 
   {{0x7c240f89,0x443c0f8a,0xba7401d2,0x00000000}},	//   bdir, yju_, ساكت, --, 
   {{0xd90c0046,0x7c240237,0xf9a40012,0x00000000}},	//   کیې_, cdir, سٕنُ, --, 
   {{0xe7380f8b,0x443c0f8c,0xba0800c3,0x7b640e00}},	//   рел_, vju_, شتەك_, _етре, 
   {{0x1b0402fa,0x6d1c025c,0x09e00143,0x00000000}},	//   রিখে_, _पनाग_, ন্জা, --, 
   {{0x443c0f8d,0x2eb40813,0x00000000,0x00000000}},	//   tju_, ंदुत, --, --, 
   {{0x443c0f8e,0x9f54038a,0x15940049,0x00000000}},	//   uju_, ëgëm_, _ﺀﻭﺗﯩ, --, 
   {{0x443c0f8f,0xa9680087,0xa5f8005b,0x7ea00207}},	//   rju_, _сиңа_, _везу_, löpe, 
   {{0x443c0f90,0x7c240f91,0x95e400cc,0x00000000}},	//   sju_, zdir, _ويقۇ, --, 
   {{0x443c0f92,0x7c240f93,0xa0a40f94,0x257401d9}},	//   pju_, ydir, жанд, _بهاس, 
   {{0x1fa80f95,0xbbb803b6,0x00000000,0x00000000}},	//   икни_, _अलेक, --, --, 
   {{0x64580f96,0x7c240f97,0x00000000,0x00000000}},	//   _ilwi, vdir, --, --, 
   {{0x64580197,0x7ea00f98,0x00000000,0x00000000}},	//   _hlwi, köpe, --, --, 
   {{0xa3bc0584,0x7c240f99,0xed340254,0x00000000}},	//   _आला_, tdir, пэтэ, --, 
   {{0x7c240f9a,0xdbc80182,0x00000000,0x00000000}},	//   udir, ргад_, --, --, 
   {{0x7c240f9b,0x53800020,0x6d40014e,0x00000000}},	// [b40] rdir, _ከዳዓት_, ølar, --, 
   {{0x7c240f9c,0xe27000c3,0x19940ce1,0x1f94001d}},	//   sdir, ﺴﺎﻻﻡ_, ојер, መዘገበ_, 
   {{0x64580990,0x7c2401ec,0x00000000,0x00000000}},	//   _olwi, pdir, --, --, 
   {{0x7c240f9d,0xb5fc0002,0xdc78001d,0x00000000}},	//   qdir, _imġi, _የብሉይ_, --, 
   {{0x16a80f9e,0xc6f40f9f,0x00000000,0x00000000}},	//   авди_, жніх_, --, --, 
   {{0x64580fa0,0x7ae40fa1,0xd4c40091,0x00000000}},	//   _alwi, msit, осип, --, 
   {{0x7ae40fa2,0x81cc00ac,0xdd24028d,0x00000000}},	//   lsit, ষণা_, _lūžt, --, 
   {{0xd8300012,0x4adc025c,0xb17c0100,0xbbb80fa3}},	//   _تٍر_, _पौडव, naĥe, _अलोक, 
   {{0x7ae40fa4,0x78bc0380,0x60c80271,0x7bc40fa5}},	//   nsit, _hurv, ɔmmɔ, iciu, 
   {{0x78bc0fa6,0x24500272,0x64580323,0x3cf80fa7}},	//   _kurv, _lámh_, _elwi, kurv_, 
   {{0x78bc0027,0xdfd000e2,0x7bc40fa8,0xe6340094}},	//   _jurv, کيټ_, kciu, _эхтэ, 
   {{0x7ae40fa9,0x7648036d,0x7bc40008,0x506400e5}},	//   ksit, _hody, jciu, ітна, 
   {{0x78bc0faa,0x7ae400e9,0xb17c01c6,0x83f4021d}},	//   _lurv, jsit, daĥe, _феіс_, 
   {{0x764801b1,0x7ae40fab,0x2488018b,0x30e40108}},	//   _jody, dsit, čame_, _есиң, 
   {{0x7ae40fac,0x78bc0614,0x76480fad,0x463800cf}},	//   esit, _nurv, _mody, סעלע, 
   {{0x25840064,0xeb5c010f,0x76480fae,0x66d00528}},	//   lêlë_, _ለመግለ, _lody, _jókò, 
   {{0x7ae40faf,0x94f8043b,0x06cc02fa,0xdd2400b0}},	// [b50] gsit, _དཀའི_, _রিভি, _gūžt, 
   {{0x7bc40fb0,0x76480336,0x7a380254,0x78bc00d4}},	//   aciu, _nody, опур_, _burv, 
   {{0xfe700fb1,0x7ae40fb2,0xa8140128,0x00000000}},	//   _جدي_, asit, здеш, --, 
   {{0xf7700fb3,0x7ae40fb4,0x78bc0fb5,0x7bc40fb6}},	//   ھان_, bsit, _durv, cciu, 
   {{0x2ca80fb7,0x7ae40fb8,0x78bc0145,0x76480fb9}},	//   mmad_, csit, _eurv, _body, 
   {{0x2ca80fba,0xc9840fbb,0x6e240fbc,0x76480095}},	//   lmad_, _дуби, _jahb, _cody, 
   {{0x69c40fbd,0x67d40e7a,0x76480028,0x6e240fbe}},	//   mche, _нову, _dody, _mahb, 
   {{0x69c40fbf,0x7d7c0282,0x32c000f1,0x2ca80c8f}},	//   lche, ינוו, _bòy_, nmad_, 
   {{0x76480fc0,0x2ca800b6,0x68e40080,0x00000000}},	//   _fody, imad_, lshd, --, 
   {{0x2ca80fc1,0x69c40fc2,0x09ac00ac,0x6abc0fc3}},	//   hmad_, nche, _চ্যা, _musf, 
   {{0x69c40fc4,0x6ab401e7,0x766401b5,0x2ca80060}},	//   iche, _mizf, _تُلم, kmad_, 
   {{0x6458009d,0x7ae40fc5,0x7bc40337,0x271c00f1}},	//   _ulwi, ysit, xciu, _kňn_, 
   {{0x248c010b,0x6e240fc6,0x7648075d,0x24500fc7}},	//   moem_, _bahb, _yody, _námi_, 
   {{0x69c40fc8,0x248c0952,0x6e240177,0x27fc0008}},	//   jche, loem_, _cahb, hgwn_, 
   {{0x61e00fc9,0xdca40fca,0x6abc0fcb,0x69c40fcc}},	//   mall, зави, _ausf, dche, 
   {{0x61e00fcd,0x248c0141,0x24500223,0x27fc0337}},	//   lall, noem_, _bámi_, jgwn_, 
   {{0x78bc0fce,0x7ae40cbf,0x7bc40fcf,0x69c40fd0}},	// [b60] _surv, usit, rciu, fche, 
   {{0x61e00fd1,0x7bc40fd2,0x78bc0fd3,0x69c401ca}},	//   nall, sciu, _purv, gche, 
   {{0x764802b3,0xda000fd4,0x7bc40fd5,0x61e0012a}},	//   _rody, र्गत_, pciu, iall, 
   {{0x69c40fd6,0x7ae40fd7,0x248c0fd8,0x764802b3}},	//   ache, psit, joem_, _sody, 
   {{0x61e00fd9,0x248c0fda,0x69c40fdb,0x7ae40fdc}},	//   kall, doem_, bche, qsit, 
   {{0x69c40fdd,0x78bc0fde,0x9a180340,0x1dbc0fdf}},	//   cche, _turv, _уюму_, ्डित, 
   {{0x20c001c0,0x76480047,0x00000000,0x00000000}},	//   _nói_, _vody, --, --, 
   {{0x76480fe0,0x518400f8,0x6ab40083,0x6d400274}},	//   _wody, ҷума, _zizf, älai, 
   {{0x19580fe1,0xd65c044a,0x00000000,0x00000000}},	//   _таңы_, _кiад, --, --, 
   {{0x20c00014,0xc0c00020,0x51840fe2,0x147401ac}},	//   _bói_, _ጸማም_, зума, _کائج, 
   {{0x6e240063,0x03d8007e,0x60cc0473,0x248c018c}},	//   _rahb, _ধাৰণ, _čamc, boem_, 
   {{0x61e00fe3,0x20c00111,0x578802b4,0x69c40b11}},	//   aall, _dói_, _ንሓንቲ_, zche, 
   {{0x61e00fe4,0x69c40fe5,0x6e240140,0x6f1c01ed}},	//   ball, yche, _pahb, uwsc, 
   {{0x61e00fe6,0x6e240140,0xbb60010f,0x6f1c000b}},	//   call, _qahb, _ለመቋቋ, rwsc, 
   {{0x69c40fe7,0x20c00710,0xac940fe8,0x6e240fe9}},	//   vche, _gói_, давш, _vahb, 
   {{0x3a3800c2,0x6abc0fea,0x2ca80feb,0x00000000}},	//   _anrp_, _pusf, umad_, --, 
   {{0x69c40fec,0x2ca80fed,0x6e240156,0x2fc8014a}},	// [b70] tche, rmad_, _tahb, _ifag_, 
   {{0x69c40fee,0x245000aa,0x248c0ac8,0x2ca800a0}},	//   uche, _vámi_, zoem_, smad_, 
   {{0x69c40fef,0xc0200ff0,0x29180ff1,0xfaa80272}},	//   rche, ধাৰণ_, تقاد_, أهلي_, 
   {{0x69c40ff2,0xd1240ff3,0x68e4028b,0x6abc00e3}},	//   sche, _یم_, rshd, _tusf, 
   {{0x69c40ff4,0x7ea00ff5,0x27fc0335,0x46300116}},	//   pche, löpa, rgwn_, нҭар, 
   {{0x61e00ff6,0x660c0070,0x63b80086,0x69c40444}},	//   xall, đako, _sgwn, qche, 
   {{0x7ea00638,0xf6080ff7,0x070400ea,0xa2d400bd}},	//   nöpa, ستوه_, تيږي_, _मौज्, 
   {{0x20c00ff8,0xd3440122,0x624c06b4,0x482000cc}},	//   _rói_, ژینه_, _núor, _سۉتق, 
   {{0x27ec0ff9,0x20c00014,0x320c0086,0x00000000}},	//   _iden_, _sói_, ffdy_, --, 
   {{0x45a00853,0x248c0ffa,0x60e80ffb,0x8cac025c}},	//   _كەشك, soem_, омом_, ंगडो, 
   {{0x26cc0ffc,0x61e00ffd,0x624c00c0,0x00000000}},	//   _hteo_, rall, _súos, --, 
   {{0xd36c0ffe,0x94240121,0xdee40fff,0x20c001eb}},	//   اهی_, _يولۇ, моми, _vói_, 
   {{0x61e01000,0xfe781001,0xfbdc00aa,0xd12c03dd}},	//   pall, зүп_, बरसम, همی_, 
   {{0x61e01002,0x13e000ac,0x02a40587,0xdbf40388}},	//   qall, _যায়, _эрем, इल्ड_, 
   {{0x27ec01c5,0x61ec0181,0x23d0081a,0x00000000}},	//   _oden_, _ɓall, _सभाद, --, 
   {{0x27ec1003,0x26cc0070,0x9f4002bb,0x00000000}},	//   _nden_, _oteo_, nakë_, --, 
   {{0x2010017b,0xe8b80126,0x5dd400bf,0xa2d0006c}},	// [b80] _ibyi_, _བཤུག, _оюну, ढीच्, 
   {{0x27ec1004,0x6d58028a,0xcf900107,0x00000000}},	//   _aden_, _ƙwat, _בטח_, --, 
   {{0x26cc025e,0xa3bc0698,0xf3e802fa,0x00000000}},	//   _ateo_, _आलं_, ক্টর_, --, 
   {{0x27ec1005,0xb17c0237,0x8d741006,0x00000000}},	//   _cden_, naĥa, _زاپا, --, 
   {{0xda641007,0x245001d5,0xaa080012,0x9ac400d5}},	//   _قاسي, _jámu_, _کزُل_, _آگرہ_, 
   {{0x27ec1008,0x8500049d,0xd02402fa,0x245001d5}},	//   _eden_, چوون, যায়_, _mámu_, 
   {{0x201004cd,0x34940329,0xdb0401c8,0x85001009}},	//   _obyi_, накр, şmäd, نوون, 
   {{0xb9e80090,0x3e5800f1,0x22980249,0x00000000}},	//   _ክስ_, _lٍt_, lèkh_, --, 
   {{0x60cc0473,0x2450030f,0xd7cc006c,0x76d80123}},	//   _čama, _námu_, हुणच, _хубӣ_, 
   {{0x2488091d,0x65780272,0x60cc00a2,0xdbd4100a}},	//   čama_, ábhá, _ōama, _hääd, 
   {{0x09f4033c,0x7bc80130,0x2ee80038,0x65b80213}},	//   ומים_, _ɑdur, _svaf_, _хуур_, 
   {{0xdbd4100b,0x9f400475,0x00000000,0x00000000}},	//   _jääd, cakë_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x245000ef,0x7ea002eb,0x00000000,0x00000000}},	//   _dámu_, töpa, --, --, 
   {{0x2d84039c,0xf27001b5,0x313400bf,0x01f800ca}},	//   çle_, _لێکھ, _чейр, _ופול, 
   {{0x4ba40340,0x9f400249,0xcf9801f1,0xd938001d}},	//   дөгү_, kakè_, _мјп_, _የሚያዋ, 
   {{0x27ec0278,0x78c400a5,0x9f4000f1,0x7ea00139}},	// [b90] _rden_, _ịkpọ_, jakè_, söpa, 
   {{0x7ea001c5,0x614400cc,0x00000000,0x00000000}},	//   löpn, _زىۋە, --, --, 
   {{0x26cc0243,0xc8640182,0x00000000,0x00000000}},	//   _steo_, мтди, --, --, 
   {{0xc1980107,0xad10001e,0x6d400027,0x00000000}},	//   חשבי, _иҿҳә, älau, --, 
   {{0x6d540191,0x7ac4100c,0x4ab00329,0x00000000}},	//   lyza, _ассе, _аҩар, --, 
   {{0xe5a4100d,0x00000000,0x00000000,0x00000000}},	//   нили, --, --, --, 
   {{0xdb10007f,0xe8b8043b,0x7aa40375,0x9f4002bb}},	//   _ògòr, _བཤིག, _риёз, takë_, 
   {{0x27ec100e,0xd58403b5,0x39a40012,0x00000000}},	//   _uden_, رێنه_, _شینہ, --, 
   {{0x7790100f,0x2cb80177,0x9f400222,0x229804c3}},	//   _پیوا, _misd_, rakë_, lèki_, 
   {{0x64b00059,0x24500c8b,0x00000000,0x00000000}},	//   _jāiz, _rámu_, --, --, 
   {{0x9f401010,0x398c0020,0x00000000,0x00000000}},	//   maké_, _ንታሕቲ_, --, --, 
   {{0x2cb801d6,0x9f4004c3,0x00000000,0x00000000}},	//   _nisd_, laké_, --, --, 
   {{0x91dc007e,0x24500579,0x2d840028,0xe3740197}},	//   _মাৰ্, _dámt_, ûlen_, _ялды, 
   {{0x2cb801d6,0x22980249,0x9f4004c3,0xd65c0320}},	//   _aisd_, kèki_, naké_, _кiед, 
   {{0x9f400249,0x6d5402b0,0xd12c005e,0x00000000}},	//   iaké_, gyza, _همو_, --, 
   {{0x9f40031b,0x6d580e66,0x00000000,0x00000000}},	//   haké_, _ƙwar, --, --, 
   {{0x9f401011,0x8540028d,0x00000000,0x00000000}},	// [ba0] kaké_, _šėls, --, --, 
   {{0x9f400214,0xdbd406ea,0xcfb40240,0x2cb80097}},	//   jaké_, _sääd, _אלפי_, _eisd_, 
   {{0x7ea0019f,0xdbd407ff,0x9f400324,0x69a40095}},	//   löpo, _pääd, daké_, _करणी, 
   {{0x22980249,0x57a40094,0x00000000,0x00000000}},	//   sèkh_, ншла, --, --, 
   {{0x9f400324,0xf4e401d2,0x00000000,0x00000000}},	//   faké_, _ﺍﻹﺸﻜ, --, --, 
   {{0x6d400faa,0x9f400324,0x00000000,0x00000000}},	//   ålag, gaké_, --, --, 
   {{0x22980249,0x24500038,0x00000000,0x00000000}},	//   cèki_, _náms_, --, --, 
   {{0x69a41012,0x7ea00139,0x00000000,0x00000000}},	//   _करती, köpo, --, --, 
   {{0x08740282,0xb5fc043b,0x9f400324,0x841000fc}},	//   _נעמט_, _alġe, baké_, умых, 
   {{0x9f40005e,0x7ea00207,0x00000000,0x00000000}},	//   caké_, döpo, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25a003c8,0xe5340100,0x00000000,0x00000000}},	//   ühle_, _שטײט_, --, --, 
   {{0x2cb800ba,0x2d980121,0xbfa81013,0x814001d9}},	//   _risd_, ﺘﯩﻨﻰ_, етре_, ننین, 
   {{0x6d54002f,0xc3240075,0xfe241014,0x83b400ca}},	//   tyza, _أكون_, льсн, _נפגע_, 
   {{0xf1a800e2,0x3cdc00bd,0x00000000,0x00000000}},	//   _ډاډه_, गीले_, --, --, 
   {{0x6d5406f7,0xbc381015,0x9f400249,0x301400b8}},	//   ryza, ىسقا_, zaké_, _рдир, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [bb0] --, --, --, --, 
   {{0x06cc0143,0xb17c00cf,0x6d4002eb,0x00000000}},	//   _রিলি, naĥo, älas, --, 
   {{0x9f400247,0x6d4001c5,0x00000000,0x00000000}},	//   vaké_, ålad, --, --, 
   {{0x6b741016,0x817400cf,0x00000000,0x00000000}},	//   _алму, עגאס_, --, --, 
   {{0x9f4004c3,0x7ea001c5,0x660401c3,0x00000000}},	//   také_, köpl, впла, --, 
   {{0xf6d40324,0x00000000,0x00000000,0x00000000}},	//   ازند, --, --, --, 
   {{0x60cc01c3,0x9f40031b,0x00000000,0x00000000}},	//   _čamo, raké_, --, --, 
   {{0x24881017,0x9f4004c3,0x00000000,0x00000000}},	//   čamo_, saké_, --, --, 
   {{0x9f401018,0x130400bb,0xb88400fc,0x97300012}},	//   paké_, вный_, _сурй, _پکنا, 
   {{0x68e00c8f,0xf7701019,0xfa700020,0x00000000}},	//   _ælds, _طاق_, _በየናይ_, --, 
   {{0x2168101a,0x3f8c0386,0x00000000,0x00000000}},	//   фини_, ğdum_, --, --, 
   {{0x2054101b,0x3f8c101c,0x7ea00027,0x645401c3}},	//   ттор, şdum_, töpo, _швеђ, 
   {{0xb17c01c6,0x00000000,0x00000000,0x00000000}},	//   baĥo, --, --, --, 
   {{0xc4440324,0x6448101d,0x00000000,0x00000000}},	//   _آیکن_, ljei, --, --, 
   {{0x26080325,0xa188101e,0x00000000,0x00000000}},	//   _सानी_, _юбка_, --, --, 
   {{0x6448101f,0x7ea00139,0x00000000,0x00000000}},	//   njei, pöpo, --, --, 
   {{0x62801020,0x00000000,0x00000000,0x00000000}},	// [bc0] onlo, --, --, --, 
   {{0x628001b9,0x1b0401b9,0x64481021,0x0f54023c}},	//   nnlo, ৰিলে_, hjei, _סיים_, 
   {{0xa3d01022,0x628003f4,0xdc6800cc,0x4de000ec}},	//   वडा_, inlo, _жанд_, _өйөң, 
   {{0x3860045d,0x62800104,0x00000000,0x00000000}},	//   óir_, hnlo, --, --, 
   {{0x8d901023,0x8cac025c,0x62800126,0x00000000}},	//   _ملیش, ंगरो, knlo, --, 
   {{0x628001ed,0x00000000,0x00000000,0x00000000}},	//   jnlo, --, --, --, 
   {{0x9f400299,0x97c40124,0xf3f80049,0x00000000}},	//   kakï_, _айбе, еңе_, --, 
   {{0xb8b40041,0x98a41024,0x62801025,0xf49800c3}},	//   _сөзі, _рибе, enlo, رھات_, 
   {{0x68e00499,0x799c009c,0x84600668,0xd36c00c3}},	//   _ældr, _hyrw, ръще, غۇت_, 
   {{0x799c036b,0xd4f400fc,0x628006b4,0x00000000}},	//   _kyrw, _аяды, gnlo, --, 
   {{0x66801026,0xd1640668,0xc68c08ea,0x867800ca}},	//   _دیول, тъпи, _بِل_, _קרבו, 
   {{0x62801027,0x7528028d,0xaed40375,0xd37801d9}},	//   anlo, _isdz, ломш, _очл_, 
   {{0xad2402be,0x92681028,0x2eec065b,0x26081029}},	//   گىزى, _орка_, éef_, _सामी_, 
   {{0x03a000f8,0xc7b0023c,0xc17000d5,0xe47000d3}},	//   _тичо, יבר_, ادیت, _ìbò̟, 
   {{0xac18102a,0x5064102b,0x8cac102c,0x998800ce}},	//   нову_, _атпа, ंगलो, _dabū_, 
   {{0x660c01f8,0x7d2401f1,0x627800c0,0x00000000}},	//   đaki, јфре, pňoc, --, 
   {{0x6a14102d,0x69a400b6,0xa3b40030,0x98b800b0}},	// [bd0] лмау, _करही, छेप_, lypė_, 
   {{0x6f0c011a,0x79d4021d,0x00000000,0x00000000}},	//   _iqac, ижує, --, --, 
   {{0x9f4c00cd,0xe7f40094,0x00000000,0x00000000}},	//   önöm_, гчлэ, --, --, 
   {{0x1ee806e3,0x38340246,0x00000000,0x00000000}},	//   _تویی_, инхр, --, --, 
   {{0x3c4405bc,0x6280036b,0x69a4064c,0x00000000}},	//   _тээв, ynlo, _करवी, --, 
   {{0x416c0200,0x6604102e,0x00000000,0x00000000}},	//   ﺴﻭﺭﻱ_, упка, --, --, 
   {{0x26080698,0x799c0323,0x6b9c0323,0x62800616}},	//   _साठी_, _gyrw, _hysg, vnlo, 
   {{0x62800442,0x00000000,0x00000000,0x00000000}},	//   wnlo, --, --, --, 
   {{0x86c00046,0x2900102f,0x387c1030,0x64481031}},	//   _څيړن, luha_, èvre_, rjei, 
   {{0x64481032,0xe0d800b8,0x20d41033,0x86c000ea}},	//   sjei, нво_, лімс, _ميړن, 
   {{0x29001034,0x6f0c02b1,0x62801035,0x6b9c1036}},	//   nuha_, _aqac, rnlo, _lysg, 
   {{0x34941037,0x942400e7,0x26081038,0x00000000}},	//   _кахр, _مومۇ, _साडी_, --, 
   {{0x29001039,0x6728043b,0x6b9c103a,0x00000000}},	//   huha_, _jsej, _nysg, --, 
   {{0x2900103b,0xfd64103c,0x4e7802b4,0x67280002}},	//   kuha_, ангү, _ኣብርሃ_, _msej, 
   {{0x9f4007d4,0x6b9c02b0,0x99980296,0x29000116}},	//   makí_, _aysg, tepō_, juha_, 
   {{0x2900103d,0x6728103e,0x9f40103f,0x6b9c0323}},	//   duha_, _osej, lakí_, _bysg, 
   {{0xabc4016d,0xcb641040,0x6b9c0336,0x67280126}},	// [be0] рауҙ, гате_, _cysg, _nsej, 
   {{0x6b9c0ca0,0x29001041,0x9f4003e6,0xdd3802ea}},	//   _dysg, fuha_, nakí_, _căţe, 
   {{0x29001042,0x18a4030d,0x6728013c,0x2298076e}},	//   guha_, гажм, _asej, lèks_, 
   {{0x9f40008b,0xdc6801a7,0x00000000,0x00000000}},	//   hakí_, _чамд_, --, --, 
   {{0x6b9c1043,0x22980078,0x799c0098,0x00000000}},	//   _gysg, nèks_, _wyrw, --, 
   {{0x29001044,0x799c060f,0x9f401045,0x00000000}},	//   buha_, _tyrw, jakí_, --, 
   {{0x18681046,0x00000000,0x00000000,0x00000000}},	//   _зави_, --, --, --, 
   {{0x26081047,0x04601048,0xc89400cc,0xc2fc0143}},	//   _साथी_, йтым, _бууө, ্বনি_, 
   {{0x07a00937,0x9f40001e,0x00000000,0x00000000}},	//   _гатн, hakâ_, --, --, 
   {{0x471805a8,0x229801e8,0xb27400cc,0x00000000}},	//   _אומג, dèks_, рлош, --, 
   {{0x260800b6,0x8a940100,0x92480152,0x94041049}},	//   _साती_, רכיװ_, _үзеб_, _مواه, 
   {{0xb0e800e7,0x70940074,0x00000000,0x00000000}},	//   ндүз_, рамф, --, --, 
   {{0x08740282,0x0490104a,0x29000ddc,0xa3d00d49}},	//   רעכט_, _النح, zuha_, वडर_, 
   {{0x2900104b,0x6b9c104c,0x69a40030,0x00000000}},	//   yuha_, _rysg, _करली, --, 
   {{0x70a402b4,0x6b9c002a,0xecc40094,0x2900011a}},	//   ገብረሉ_, _sysg, ршгү, xuha_, 
   {{0x6b9c009c,0xe944104d,0xc9840108,0x00000000}},	//   _pysg, یرای, қузи, --, 
   {{0x2900104e,0x00000000,0x00000000,0x00000000}},	// [bf0] wuha_, --, --, --, 
   {{0x29000329,0x7ed4104f,0x2608006c,0xdb241050}},	//   tuha_, _ازيا, _साधी_, ؤولی, 
   {{0x6674031b,0x6b9c0618,0x67281051,0x00000000}},	//   یدتر, _wysg, _ssej, --, 
   {{0x29001052,0x38640177,0xab940302,0x00000000}},	//   ruha_, _clmr_, _вимі, --, 
   {{0x29001053,0x66b41054,0x26080227,0x6b9c043e}},	//   suha_, абду, _सादी_, _uysg, 
   {{0x29001055,0x09dc00ac,0x24f40099,0x957002b4}},	//   puha_, _ঢাকা, ачир, _እንቋዕ_, 
   {{0x2900011a,0x0ba8024b,0x00000000,0x00000000}},	//   quha_, _زاڭى_, --, --, 
   {{0x67281056,0x3ce802e0,0xf7700061,0x00000000}},	//   _tsej, _जबसे_, _کاف_, --, 
   {{0xe3a80155,0x67281057,0x9f4003e6,0x62641058}},	//   ъкид_, _usej, takí_, ивиа, 
   {{0x9f400247,0x00000000,0x00000000,0x00000000}},	//   hakã_, --, --, --, 
   {{0xe0441059,0x21a40409,0x9a740107,0xb464105a}},	//   анни, ринм, שתתף_, ркөл, 
   {{0x1b2c0090,0xf484105b,0x229801b1,0x00000000}},	//   _ብርቱካ, _лучн, tèks_, --, 
   {{0xa2e4105c,0x442c105d,0x00000000,0x00000000}},	//   _толд, _iag_, --, --, 
   {{0x442c0a69,0x00000000,0x00000000,0x00000000}},	//   _hag_, --, --, --, 
   {{0x442c105e,0x94ec02df,0xa0a400fc,0x216800c3}},	//   _kag_, _bəə_, _какд, _шики_, 
   {{0x442c105f,0x00000000,0x00000000,0x00000000}},	//   _jag_, --, --, --, 
  
   {{0x6b840272,0x94ec0387,0x7ea00139,0x59d40108}},	// [c00] مشكل, _dəə_, höpi, لغار, 
   {{0x442c1060,0x7ea004bc,0x4a401061,0xd0e41062}},	//   _lag_, köpi, онув, _حکیم_, 
   {{0x442c1063,0xdca41064,0xdbd00031,0x590801c7}},	//   _oag_, _вани, jüçi, теем_, 
   {{0x442c1065,0x49040076,0x7c1400e2,0x6a84001e}},	//   _nag_, _हमरो_, _دېرش, алӡа, 
   {{0x7c241066,0x7e7c01ca,0x00000000,0x00000000}},	//   meir, oirp, --, --, 
   {{0x7c241067,0x442c1068,0x7e7c1069,0xe6b401d9}},	//   leir, _aag_, nirp, ملنگ, 
   {{0xa3c000cb,0x442c0bcf,0x9f400693,0x00000000}},	//   ःखं_, _bag_, hakà_, --, 
   {{0x7c24106a,0x442c106b,0x7e7c0177,0x00000000}},	//   neir, _cag_, hirp, --, 
   {{0xa3000087,0x7c24106c,0x7e7c106d,0xb27400c3}},	//   зүче, ieir, kirp, йлиш, 
   {{0x442c106e,0x59a803d0,0xc0f4010f,0xb17c01c6}},	//   _eag_, _करार, ላለሁ_, laĥi, 
   {{0x442c106f,0x25a801e7,0xd5480012,0x7e7c1070}},	//   _fag_, ƙala_, _جلاو_, dirp, 
   {{0x442c008e,0x7c241071,0x04401072,0xb17c00cf}},	//   _gag_, jeir, _мехн, naĥi, 
   {{0x7c241073,0x236c06f7,0xe2f80012,0x7e7c1074}},	//   deir, czej_, _مونڈ_, firp, 
   {{0x442c1075,0xbe880673,0x7e7c01df,0x00000000}},	//   _zag_, ассе_, girp, --, 
   {{0x7c240ca0,0x442c1076,0xd08400bb,0x6ce0025c}},	//   feir, _yag_, _выпи, गींग_, 
   {{0x7c241077,0x442c0012,0x2b4802ba,0xc1b800ca}},	//   geir, _xag_, txac_, _במוש, 
   {{0x60cc00e9,0x3570001d,0x7e7c01e3,0x4ba400cc}},	// [c10] _čami, ቻልበት_, birp, рөнү_, 
   {{0x1cac011a,0x24880c91,0x9f400329,0x7e7c015b}},	//   ནཏུ_, čami_, sakã_, cirp, 
   {{0x7c241078,0x9f4002c6,0xc0d001da,0x2d58044a}},	//   beir, maká_, ካፈል_, _синь_, 
   {{0x7c241079,0x9f40107a,0x260800d1,0x00000000}},	//   ceir, laká_, _साही_, --, 
   {{0x442c107b,0xfe70107c,0x8d74010f,0xfb8400fc}},	//   _rag_, _ردی_, ረጋቸው_, _дырн, 
   {{0x9f4002c6,0xc0f4010f,0x7ea00139,0x00000000}},	//   naká_, ላለህ_, töpi, --, 
   {{0xe298107d,0x442c107e,0x98780828,0x649808e4}},	//   ған_, _pag_, ṣām_, лтир_, 
   {{0x442c01ba,0xe3e8107f,0x4a7000dd,0x236c000b}},	//   _qag_, اکان_, _اُڀر, tzej_, 
   {{0x442c1080,0xe2981081,0x9f4002c6,0xd8b400cd}},	//   _vag_, лаи_, kaká_, _اگلا_, 
   {{0x442c1082,0x7c241083,0x22480155,0x9f4002dd}},	//   _wag_, zeir, упои_, jaká_, 
   {{0x442c1084,0x236c06f7,0x21741085,0x00000000}},	//   _tag_, szej_, супр, --, 
   {{0x442c1086,0x7c241087,0x21a41088,0x672c043b}},	//   _uag_, xeir, _қийм, ħajf, 
   {{0x7c241089,0x6d40108a,0x7374001e,0x00000000}},	//   veir, ålan, _мышх, --, 
   {{0x1d08108b,0x7c240336,0x5398023c,0xb17c00cf}},	//   леги_, weir, _גינו, zaĥi, 
   {{0x7c24108c,0xc32c01b5,0x00000000,0x00000000}},	//   teir, _رٕژ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c24108d,0x7e7c0353,0x5ba80f1a,0xd7f801cf}},	// [c20] reir, pirp, укам_, ҳул_, 
   {{0x7c24108e,0x7e7c0d2e,0x0f3400ca,0x46c800bd}},	//   seir, qirp, _פריט_, ादनह, 
   {{0x7c240ac5,0xd7f8108f,0x2fcc0ddc,0x97c40272}},	//   peir, гул_, žege_, مقاو, 
   {{0x18a41090,0x6b8801d1,0x57441091,0x00000000}},	//   щаем, _žege, йнеб, --, 
   {{0xd4981092,0xb17c01c6,0x00000000,0x00000000}},	//   һри_, raĥi, --, --, 
   {{0xc7a009c7,0x00000000,0x00000000,0x00000000}},	//   чичк, --, --, --, 
   {{0x26081093,0x09e01094,0xa2ac0095,0x3984005e}},	//   _सारी_, _хосн, ुगन्, _بیاف, 
   {{0xe9e40552,0x6d580181,0x00000000,0x00000000}},	//   ãºva_, _ƙwaz, --, --, 
   {{0xe850100f,0xe80c1095,0x00000000,0x00000000}},	//   _تۆند, _हाता_, --, --, 
   {{0x71741096,0x00000000,0x00000000,0x00000000}},	//   يۇشا, --, --, --, 
   {{0x6614024f,0x3b000428,0x614000b8,0x00000000}},	//   _özka, hriq_, ҧҵәа, --, 
   {{0x51841097,0xc9500107,0xdbd40087,0xf48401d9}},	//   _қула, למת_, _cäüd, _باطی, 
   {{0x9f4002c6,0x645c0139,0x00000000,0x00000000}},	//   taká_, ösie, --, --, 
   {{0xf1c8006e,0x8d740128,0x00000000,0x00000000}},	//   _ئاشۇ_, مازا, --, --, 
   {{0x86581098,0xdd380254,0xc2040d5a,0xdbd4012b}},	//   נדלי, văţa, _اقىن_, _fäüd, 
   {{0x9f401099,0x4fc4109a,0x3dcc0130,0xd7b800b3}},	//   saká_, _уска, _ɔkwɑ_, ेशाच, 
   {{0x2608109b,0x9f400243,0xaa540e06,0xbea800dd}},	// [c30] _साली_, paká_, оваш, _ڏهين_, 
   {{0x4e9400ea,0x7f9400fb,0x00000000,0x00000000}},	//   _دشعر, _хаьх, --, --, 
   {{0x3b00109c,0xac9401ef,0xc5f40143,0xdd3802ea}},	//   ariq_, _маош, _আউলা_, răţa, 
   {{0xf770109d,0x27e8109e,0xbd88031b,0x0ff8025c}},	//   کام_, úan_, _چنین_, ्लिश_, 
   {{0x94f40002,0x65c4109f,0x499010a0,0x00000000}},	//   ྗེའི_, обла, _کیار, --, 
   {{0xa56410a1,0x6e3400b0,0xdde40095,0x00000000}},	//   يگان, ndzb, _āpūr, --, 
   {{0x6d580ae3,0x00000000,0x00000000,0x00000000}},	//   _ƙway, --, --, --, 
   {{0xe45810a2,0x8cac0203,0x66d000b8,0x7ea00207}},	//   ржи_, ंगटो, _ẽkur, löpt, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x625810a3,0xdbd4039c,0xe29010a4,0xf56800ec}},	//   ррир_, _säüd, بذب_, ршәк_, 
   {{0x602410a5,0x6aa40151,0xa3b800e2,0x63f810a6}},	//   одна, ilhf, داګر_, _نفاس_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d40202,0x24800249,0x7ea00f98,0xaaa80192}},	//   _ofze, éhmu_, köpt, कताक, 
   {{0x68f40113,0xa3d0006c,0x00000000,0x00000000}},	//   _ovzd, वडक_, --, --, 
   {{0x29000126,0xdbd4012b,0x00000000,0x00000000}},	//   jrha_, _täüd, --, --, 
   {{0x8c4010a7,0x69d410a8,0x20f403f2,0xc5f002fa}},	//   месе, _afze, māi_, চ্চা_, 
   {{0x29000126,0x00000000,0x00000000,0x00000000}},	// [c40] erha_, --, --, --, 
   {{0x3b000560,0x7ea00027,0x00000000,0x00000000}},	//   rriq_, töpu, --, --, 
   {{0x2900010b,0x2d840028,0x17c800b8,0x3b000247}},	//   grha_, ûlet_, агеи_, sriq_, 
   {{0x18680c9f,0x00000000,0x00000000,0x00000000}},	//   јади_, --, --, --, 
   {{0xc5f000ac,0x160c10a9,0x3b000105,0xc6d001d2}},	//   চ্ছা_, _सादर_, qriq_, وتوت, 
   {{0x473010aa,0x38c803b5,0x8f98023c,0x95700020}},	//   ьніс, _هاری_, סיסי, _እንቛዕ_, 
   {{0xc1e00030,0xd94400b7,0x9f40012b,0x00000000}},	//   _ग़जब_, _ќеби, lakä_, --, 
   {{0xe8b000cc,0x00000000,0x00000000,0x00000000}},	//   _كەلج, --, --, --, 
   {{0x2450012c,0x83300182,0x00000000,0x00000000}},	//   _jámy_, дных, --, --, 
   {{0xd25807b7,0x20f403f2,0x245003aa,0xc56000dd}},	//   рци_, fāi_, _mámy_, _ڪڏهي, 
   {{0xc1b40094,0x645c002a,0x6e2000af,0x98c800bd}},	//   жлэх_, ösic, õlbm, िदिए, 
   {{0x7ea001c9,0xc56000dd,0xe4e810ab,0x741410ac}},	//   köps, _تڏهي, _طعمه_, _روتا, 
   {{0x78a0041c,0x00000000,0x00000000,0x00000000}},	//   _mkmv, --, --, --, 
   {{0x41700046,0x00000000,0x00000000,0x00000000}},	//   _ښايس, --, --, --, 
   {{0xa6e801eb,0xc10000bf,0x705802dc,0x11f800ea}},	//   _giươ, _قووي, _гайр_, _موږک_, 
   {{0x3e5410ad,0x3f8c059c,0x4bd8005e,0x00000000}},	//   _aştı_, ğdur_, شبرد_, --, 
   {{0x3f8c0c60,0x00000000,0x00000000,0x00000000}},	// [c50] şdur_, --, --, --, 
   {{0x24500113,0xe80c1095,0x7c60010f,0x00000000}},	//   _dámy_, _हाहा_, ደሌለው_, --, 
   {{0xf7d801d7,0xfeb810ae,0x278801c4,0xa7a80108}},	//   _ịrụp, _بايت_, әреү_, әкла_, 
   {{0x2ee80181,0x29000034,0x245000ef,0xac940427}},	//   _kwaf_, rrha_, _fámy_, _хамш, 
   {{0x4904002f,0x87240272,0x4630001e,0x00000000}},	//   _हमको_, تعام, мҭар, --, 
   {{0x80d80143,0xe80c0802,0x00000000,0x00000000}},	//   _ভিস্, _हावा_, --, --, 
   {{0x224810af,0x2fc8025e,0x00000000,0x00000000}},	//   _đak_, _ogag_, --, --, 
   {{0x2fc810b0,0xd700024b,0x26c8000f,0x00000000}},	//   _ngag_, _бiра, íaos_, --, 
   {{0xc6a410b1,0xa0a402dc,0xa3b40098,0xe8b8006c}},	//   _држи, ҷанд, छें_, ेदीच, 
   {{0x27ec10b2,0x2fc810b3,0xf7700f70,0x00000000}},	//   _heen_, _agag_, _شاق_, --, 
   {{0xa0a410b4,0x644c007f,0xba04010f,0x614410b5}},	//   занд, _òaio, _ውድ_, чена, 
   {{0x26c410b6,0x248810b7,0x26cc00a2,0x27ec0331}},	//   _hilo_, _ñam_, _kueo_, _jeen_, 
   {{0x27ec10b8,0x25a403c7,0x00000000,0x00000000}},	//   _meen_, _hyll_, --, --, 
   {{0x27ec10b9,0x645810ba,0x2ee810bb,0xd35410bc}},	//   _leen_, _howi, _dwaf_, _מיני_, 
   {{0x645810bd,0x2fcc10be,0x9730001d,0x00000000}},	//   _kowi, žega_, _በውድድ, --, 
   {{0x26c410bf,0x27ec10c0,0xd0f8007c,0x3eb800e9}},	//   _lilo_, _neen_, _פּור, smrt_, 
   {{0x2ee80181,0x20100211,0x645810c1,0x2d840045}},	// [c60] _gwaf_, _icyi_, _mowi, ûler_, 
   {{0x628010c2,0x26c410c3,0x645810c4,0x9e28004b}},	//   nilo, _nilo_, _lowi, _آدم_, 
   {{0x27ec10c5,0x0e58023c,0x9f4000b8,0x5ca400fb}},	//   _been_, _הדיב, sakä_, _ниоб, 
   {{0x26c40ac4,0xad2401b5,0x27ec10c6,0x958410c7}},	//   _ailo_, _کریو, _ceen_, үлде, 
   {{0x27ec10c8,0x628010c9,0x26c410ca,0xc04c010f}},	//   _deen_, kilo, _bilo_, _እየተገ, 
   {{0x6b8810cb,0x628010cc,0x26c401f8,0x00000000}},	//   _þega, jilo, _cilo_, --, 
   {{0x628010cd,0x26c410ce,0x34940822,0x645810cf}},	//   dilo, _dilo_, макр, _bowi, 
   {{0x27ec10d0,0x645810d1,0x26c40243,0x62800151}},	//   _geen_, _cowi, _eilo_, eilo, 
   {{0x645810d2,0x26c410d3,0x00000000,0x00000000}},	//   _dowi, _filo_, --, --, 
   {{0x628010d4,0x25a410d5,0x26c40249,0x64580379}},	//   gilo, _fyll_, _gilo_, _eowi, 
   {{0x2ee810d6,0x27ec065b,0x7ea00139,0x978c044a}},	//   _swaf_, _yeen_, yöpr, _кiур_, 
   {{0x628005e1,0x645810d7,0x76440181,0x2f880116}},	//   ailo, _gowi, ɓiya, жәон_, 
   {{0x27e810d8,0xe45410d9,0x26c410da,0x889800ca}},	//   ðani_, _تفنگ, _yilo_, מבטי, 
   {{0xdee401e2,0x628010db,0xc0f40090,0x26c410dc}},	//   ሜሪካ_, cilo, ላለም_, _xilo_, 
   {{0x645810dd,0xe80c0774,0xbfec0252,0x8c640cc1}},	//   _yowi, _हाला_, _কাৰণ_, птад, 
   {{0x4fc4070b,0x2ee8015e,0x00000000,0x00000000}},	//   _эска, _twaf_, --, --, 
   {{0x27ec10de,0xfbd00272,0x998801d1,0xddc802ea}},	// [c70] _reen_, اتف_, _rabš_, _înşi, 
   {{0x27ec0be0,0x49c800b8,0x4a2400b8,0x00000000}},	//   _seen_, суам_, џьаб, --, 
   {{0x88c410df,0x80a410e0,0x26c40840,0x27ec10e1}},	//   ستال, _زمین, _rilo_, _peen_, 
   {{0x764810e2,0x2c08031b,0x26cc068c,0x7f840063}},	//   _andy, _بعدی_, _pueo_, _آلین, 
   {{0x26c40956,0x645810e3,0x27ec10e4,0x2ca810e5}},	//   _pilo_, _rowi, _veen_, mlad_, 
   {{0x2ca810e6,0x645810e7,0x27ec10e8,0x628010e9}},	//   llad_, _sowi, _ween_, xilo, 
   {{0x645810ea,0x26c4090c,0x27ec10eb,0x2ca80080}},	//   _powi, _vilo_, _teen_, olad_, 
   {{0x764810ec,0x2ca810ed,0x26080203,0x628010ee}},	//   _endy, nlad_, _साकी_, wilo, 
   {{0x628010ef,0x26c410f0,0x2ca8009c,0xe29810f1}},	//   tilo, _tilo_, ilad_, жап_, 
   {{0x64580130,0x2ca810f2,0x62800cbf,0x00000000}},	//   _wowi, hlad_, uilo, --, 
   {{0x628010f3,0x2ca810f4,0x25a4006f,0x645810f5}},	//   rilo, klad_, _uyll_, _towi, 
   {{0x1de410f6,0x62780212,0x660c028a,0xd5980107}},	//   कर्ष_, jňov, ɗaka, _ובעל, 
   {{0x764810f7,0x62780212,0xe374002c,0x248c10f8}},	//   _yndy, dňov, _юлды, mnem_, 
   {{0x248c10f9,0x628010fa,0x216810fb,0x627800c0}},	//   lnem_, qilo, _мили_, eňov, 
   {{0x248c0d8e,0x2ca801b5,0xdca410fc,0x2d9410fd}},	//   onem_, flad_, дави, ертс, 
   {{0x248c10fe,0x9f0410ff,0x4e1c1100,0x39440b0a}},	//   nnem_, _قوبو, म्बई_, _čms_, 
   {{0x248c1101,0xfb840249,0x00000000,0x00000000}},	// [c80] inem_, ردری, --, --, 
   {{0x248c1102,0x2ca81103,0x77f81104,0xdb0402bb}},	//   hnem_, alad_, ुल्क_, _hykë, 
   {{0x248c1105,0x2ca81106,0x9f4002d9,0x627800c0}},	//   knem_, blad_, jakú_, bňov, 
   {{0x9f94012b,0x248c1107,0x62780b0a,0x28740152}},	//   _cüçi_, jnem_, cňov, нычр, 
   {{0x248c1108,0x59a80d02,0x00000000,0x00000000}},	//   dnem_, _करकर, --, --, 
   {{0xa3c00d3f,0x644c007f,0xf4841109,0x248c034c}},	//   ंधन_, _òaij, کاتی, enem_, 
   {{0xceb000b9,0x6ed403ef,0x44f0110a,0xc0f40020}},	//   דיג_, _यूनु, پسىز, ዋፈሩ_, 
   {{0x7414110b,0x00000000,0x00000000,0x00000000}},	//   روخا, --, --, --, 
   {{0xd62403e0,0x3a38110c,0x7ea00139,0x00000000}},	//   _يعطي, _karp_, yöpp, --, 
   {{0x5184110d,0x7648110e,0x627803aa,0x7178110f}},	//   дума, _undy, zňov, збор_, 
   {{0x248c1110,0x3a3802ba,0x627803aa,0x2ca81111}},	//   bnem_, _marp_, yňov, ylad_, 
   {{0x248c1112,0x2ca801c5,0x00000000,0x00000000}},	//   cnem_, xlad_, --, --, 
   {{0x627802dd,0xcfa80324,0x25b400cc,0x7ea00207}},	//   vňov, تادم_, _قۇۇد_, töpp, 
   {{0x3a381113,0x2ca81114,0x8d680c9f,0x91f00227}},	//   _narp_, wlad_, ојба_, _आजिज_, 
   {{0x627809f4,0xf1b8043b,0x7ea01115,0x2ca8013c}},	//   tňov, teġu_, röpp, tlad_, 
   {{0xa3b4021f,0x4fc41116,0x3a380426,0x2ca81117}},	//   छेक_, _оспа, _aarp_, ulad_, 
   {{0x7b180bbf,0x2ca81118,0x0dc81119,0x62780113}},	// [c90] мотр_, rlad_, _муни_, rňov, 
   {{0x7054111a,0x248c111b,0x27880128,0x62780113}},	//   _آنکا, znem_, үрдү_, sňov, 
   {{0x248c111c,0x62780212,0x25a80181,0x3a38111d}},	//   ynem_, pňov, ƙali_, _darp_, 
   {{0x248c0337,0x67d4041c,0x00000000,0x00000000}},	//   xnem_, ходу, --, --, 
   {{0x248c0f68,0x2ef80083,0x64a4001e,0x00000000}},	//   vnem_, nssf_, ҽака, --, 
   {{0x248c111e,0x00000000,0x00000000,0x00000000}},	//   wnem_, --, --, --, 
   {{0x64a4111f,0x248c1120,0x00000000,0x00000000}},	//   нака, tnem_, --, --, 
   {{0x248c002a,0x00000000,0x00000000,0x00000000}},	//   unem_, --, --, --, 
   {{0x9700006e,0x248c1121,0x3a3802b1,0x09d0040e}},	//   _مېنى, rnem_, _yarp_, _तलाठ, 
   {{0x248c1122,0x22141123,0x3f8402e8,0x00000000}},	//   snem_, хфир, úmum_, --, 
   {{0x248c1124,0x00000000,0x00000000,0x00000000}},	//   pnem_, --, --, --, 
   {{0x24180027,0x00000000,0x00000000,0x00000000}},	//   _ходы_, --, --, --, 
   {{0x270c0698,0x00000000,0x00000000,0x00000000}},	//   _समोर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa0681125,0x00000000,0x00000000,0x00000000}},	//   _нака_, --, --, --, 
   {{0x3a380a9a,0x00000000,0x00000000,0x00000000}},	//   _sarp_, --, --, --, 
   {{0x3a380201,0x00000000,0x00000000,0x00000000}},	// [ca0] _parp_, --, --, --, 
   {{0x7f441126,0x9aa41127,0x4aa41128,0x00000000}},	//   _iriq, رماو, екун_, --, 
   {{0x3a3802b2,0x58040075,0x00000000,0x00000000}},	//   _varp_, فواك, --, --, 
   {{0x3a381129,0x8d74112a,0xcdcc0046,0x7f440387}},	//   _warp_, _ساپا, _نښې_, _kriq, 
   {{0x3a3802b3,0xb5fc0126,0x6d40112b,0x7d1c01d1}},	//   _tarp_, _joġg, ålav, ltrs, 
   {{0x7ae4112c,0x7f440249,0x38980078,0xe6b401d9}},	//   mpit, _mriq, dčre_, نلنگ, 
   {{0x7ae4112d,0x7d1c112e,0xd4c40121,0x00000000}},	//   lpit, ntrs, нсип, --, 
   {{0x7ae403a2,0x38c80061,0x7f4402a0,0x00000000}},	//   opit, _زازی_, _oriq, --, 
   {{0x7ae4112f,0x96b81130,0x2608025c,0x13680a41}},	//   npit, _فائز_, _साची_, яшки_, 
   {{0xc0f4010f,0x7ae41131,0x4b780100,0x7d1c012b}},	//   ዋለሁ_, ipit, פטיג, ktrs, 
   {{0x7f440919,0x27e80e84,0x25a0002a,0x558801d2}},	//   _ariq, ñang_, ühlt_, _эбжм_, 
   {{0x7f441132,0xa0341133,0x00000000,0x00000000}},	//   _briq, نىپت, --, --, 
   {{0x7f440d8a,0x7ae40237,0x00000000,0x00000000}},	//   _criq, jpit, --, --, 
   {{0x82e8011a,0x00000000,0x00000000,0x00000000}},	//   _རྦིའ, --, --, --, 
   {{0xac181134,0xcee80324,0x00000000,0x00000000}},	//   мову_, _کربن_, --, --, 
   {{0xef100128,0x6aa80095,0x00000000,0x00000000}},	//   _күмө, कत्र, --, --, 
   {{0x7ae41135,0x00000000,0x00000000,0x00000000}},	// [cb0] gpit, --, --, --, 
   {{0x6f1c0e48,0x7a380320,0x00000000,0x00000000}},	//   mtsc, нпур_, --, --, 
   {{0x6f1c1136,0xfe700046,0x7ae41137,0x6e200030}},	//   ltsc, _ددي_, apit, õlbu, 
   {{0x6d44009d,0x6f1c1138,0xbd880012,0x39a41139}},	//   _irha, otsc, _سنُن_, ушув, 
   {{0xd364113a,0x6f1c113b,0xb8d80774,0x2be000cb}},	//   _ئه_, ntsc, _घी_, गुणं_, 
   {{0x6f1c113c,0x6d4401df,0xfa0802fa,0x389800f1}},	//   itsc, _krha, র্বল_, včre_, 
   {{0x6f1c113d,0xc4440191,0xbba800c3,0x5ed80143}},	//   htsc, ٹیشن_, ﺋﯩﻠﻪ_, বীপে, 
   {{0x6d4401d4,0x6f1c002a,0xa44401d9,0x68e4002a}},	//   _mrha, ktsc, тнид, mphd, 
   {{0xe71801fa,0x6f1c01ed,0xa9a400c3,0x92f40075}},	//   _زيات_, jtsc, _чиңд, نفيذ_, 
   {{0x21680332,0xe58404f7,0x6d44113e,0x6264113f}},	//   диои_, _итеү, _orha, твоа, 
   {{0x6f1c1140,0x6d4401ba,0xd24c1141,0x3e740027}},	//   etsc, _nrha, غچه_, _jäte_, 
   {{0x6f1c0630,0x7ae403c0,0x3e74012b,0x3370001e}},	//   ftsc, ypit, _mäte_, рҳәр, 
   {{0x6d441142,0x54780107,0x67280560,0xdb04001e}},	//   _arha, _קטנו, _jpej, _tyké, 
   {{0xa1881143,0x6d4400a8,0x8d8c0020,0x00000000}},	//   _обла_, _brha, _ዘስምዖ_, --, 
   {{0x6f1c1144,0x80d802fa,0x7ae402b1,0x6b88030f}},	//   atsc, _ভিক্, wpit, _þegj, 
   {{0x7f441145,0x2c741146,0x7bc000c4,0x6d4401f6}},	//   _triq, _nådd_, _úmuk, _drha, 
   {{0x6d441147,0x7d1c0f68,0x6f1c0c2f,0x7ae40ddc}},	// [cc0] _erha, strs, ctsc, upit, 
   {{0x7ae41148,0x00000000,0x00000000,0x00000000}},	//   rpit, --, --, --, 
   {{0xd83802fb,0x7ae41149,0x67280528,0x1be80673}},	//   дэл_, spit, _apej, _одни_, 
   {{0x7ae4114a,0xa3c00021,0xa90402ac,0x00000000}},	//   ppit, ंधा_, ابلن, --, 
   {{0x7ae404db,0x00000000,0x00000000,0x00000000}},	//   qpit, --, --, --, 
   {{0x09e009ab,0x6d440086,0x00000000,0x00000000}},	//   _ворн, _yrha, --, --, 
   {{0xe9d000ea,0x00000000,0x00000000,0x00000000}},	//   _چغې_, --, --, --, 
   {{0x7434038e,0x733800e1,0x04600027,0x00000000}},	//   униф, езир_, итым, --, 
   {{0xd2080182,0x6f1c114b,0x2bc4064c,0x00000000}},	//   мэнд_, xtsc, लेपा, --, 
   {{0x6f1c0496,0x313401c7,0x00000000,0x00000000}},	//   vtsc, геор, --, --, 
   {{0x09f400ca,0x00000000,0x00000000,0x00000000}},	//   כמים_, --, --, --, 
   {{0x6f1c0630,0x2c740085,0xc5780107,0x93880f1a}},	//   ttsc, _kåde_, _קראת, _осла_, 
   {{0x15b403dc,0x6f1c114c,0x7bc000c4,0x8140005e}},	//   ﻤﯩﺰﺩ, utsc, _úmuh, هپیم, 
   {{0x6f1c114d,0x2c740499,0x9f50029f,0x8d74114e}},	//   rtsc, _måde_, _meyè_, نازا, 
   {{0x6f1c114f,0x2bc41150,0x00000000,0x00000000}},	//   stsc, लेना, --, --, 
   {{0x6f1c1151,0x6d4403aa,0x3e741152,0xb0140ce1}},	//   ptsc, _vrha, _räte_, _смиљ, 
   {{0x201c1153,0x2c741154,0x3e741155,0x00000000}},	// [cd0] əti_, _nåde_, _säte_, --, 
   {{0xadbc02b3,0x160c03ea,0x3a741156,0x6d440113}},	//   _напi, _सागर_, алур, _trha, 
   {{0x67281157,0x7ac41158,0x2cb80043,0x6d441159}},	//   _spej, рсте, _thsd_, _urha, 
   {{0x2c74115a,0x9f500078,0x6728011a,0x3e74115b}},	//   _både_, _beyè_, _ppej, _väte_, 
   {{0x160c00b3,0x8d7400c3,0xf7700a71,0x362400d3}},	//   _साखर_, _ساھا, ياه_, _ẹ́hì, 
   {{0xa3e400d1,0x9f40048a,0x9f5001b1,0x3e74002a}},	//   बुन_, jaký_, _deyè_, _täte_, 
   {{0x6ed403ef,0x00000000,0x00000000,0x00000000}},	//   _यूसु, --, --, --, 
   {{0x9f5000f1,0x67280560,0x00000000,0x00000000}},	//   _feyè_, _tpej, --, --, 
   {{0x2c740056,0x86b00049,0xd5ac00d5,0x00000000}},	//   _gåde_, _кәкі, قہے_, --, 
   {{0x57a401c4,0xf770115c,0x00000000,0x00000000}},	//   _сысҡ, _باف_, --, --, 
   {{0x2168115d,0x64140272,0x250807bc,0x2088115e}},	//   хини_, _مواط, _سرای_, ейни_, 
   {{0xdee4115f,0x2054038e,0xf4840a3b,0x33d401d2}},	//   ломи, утор, _кучн, _кішт, 
   {{0x443c1160,0x3db00e85,0x7304021d,0x8508023b}},	//   mdu_, ﺳﺘﯩﻘ, _впіз, संकट_, 
   {{0x443c1161,0x91e00294,0x9f4001d4,0xd00c00ea}},	//   ldu_, _лоше, caký_, يلۍ_, 
   {{0x443c1162,0x66140386,0x00000000,0x00000000}},	//   odu_, _özku, --, --, 
   {{0x443c1163,0x41dc1164,0xda6401ac,0x672c0002}},	//   ndu_, पुरस, گاري, ħajj, 
   {{0x443c1165,0xc0dc0090,0x8c401166,0x6d400479}},	// [ce0] idu_, ኒየም_, щете, ålar, 
   {{0xda641167,0x443c1168,0x2c741169,0x00000000}},	//   داري, hdu_, _råde_, --, 
   {{0x9f50116a,0xf8a8116b,0x2bc40a7b,0xf1c00041}},	//   _seyè_, نگره_, लेबा, _ﻭﺍﻟﺘ, 
   {{0x3860116c,0x443c116d,0x7794116e,0x00000000}},	//   ðir_, jdu_, لیزا, --, 
   {{0x9f50008f,0x4bf80d47,0x2af40023,0xd68400cc}},	//   _beyé_, _אלכס, _вясё, лукп, 
   {{0x443c116f,0x0f34033c,0xda701170,0x2c740056}},	//   edu_, טרנט_, _اُس_, _våde_, 
   {{0x7c240083,0x443c015e,0xca740049,0x48e000fb}},	//   ofir, fdu_, _сәті_, _госв, 
   {{0x443c1171,0x7c241172,0x2fcc01f8,0x98a406e6}},	//   gdu_, nfir, žegi_, _сибе, 
   {{0xb2741173,0x55e41174,0x335400e7,0x7c240472}},	//   илиш, _бозб, рүлө_, ifir, 
   {{0x7c241175,0x443c1176,0x427002ca,0xc5b40094}},	//   hfir, adu_, йгыс, _өрхө, 
   {{0x443c1177,0x256401b5,0x13e81178,0xb2a80012}},	//   bdu_, _پالُ, _змей_, ٹُھم_, 
   {{0x94180125,0x443c1179,0x7c24117a,0x00000000}},	//   _ɔpɛ_, cdu_, jfir, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c24117b,0x6b88030f,0x00000000,0x00000000}},	//   efir, _þegi, --, --, 
   {{0x7c24117c,0x00000000,0x00000000,0x00000000}},	//   ffir, --, --, --, 
   {{0x7c24117d,0xaed4023f,0x00000000,0x00000000}},	//   gfir, _коиш, --, --, 
   {{0x6e9400c8,0xeeb801d9,0x629c001e,0x645c0139}},	// [cf0] _випу, _илиш_, ésog, ösii, 
   {{0x443c117e,0x28d80e8f,0xce3000e2,0x7c24117f}},	//   zdu_, _बंदि, _اودک, afir, 
   {{0xa934038e,0x69340049,0x5ed80143,0x00000000}},	//   рееш, рнеу, বীদে, --, 
   {{0x443c1180,0x7c24015e,0x00000000,0x00000000}},	//   xdu_, cfir, --, --, 
   {{0xe7381181,0x443c1182,0xa6340049,0x00000000}},	//   тел_, vdu_, инді, --, 
   {{0xa5081183,0xe6441184,0xf9d400fc,0xdb4c0012}},	//   века_, рекп, _горэ, _کێے_, 
   {{0x443c1185,0x37a80b4c,0x3e7400a1,0x64981186}},	//   tdu_, ктән_, _jäta_, ктир_, 
   {{0x443c1187,0x23280155,0x3e7401c9,0x00000000}},	//   udu_, воии_, _mäta_, --, 
   {{0xe2980155,0xe3b81188,0xe1f0005e,0x6b880031}},	//   каи_, ъби_, يسد_, _ýegd, 
   {{0xc6a41189,0x443c0156,0xf59801ec,0xe12400f8}},	//   _срби, sdu_, ýýär_, амои, 
   {{0x7c240270,0x09d000d1,0x443c0156,0x00000000}},	//   yfir, _तलैय, pdu_, --, 
   {{0x9424118a,0x443c118b,0x44f00254,0xa0a4118c}},	//   _نومۇ, qdu_, mţ_, рамд, 
   {{0xa3c000b3,0x00000000,0x00000000,0x00000000}},	//   ंधळ_, --, --, --, 
   {{0x9f400a03,0x6144070b,0x1d0800fc,0x38bc00b8}},	//   wakó_, _века, кеги_, míre_, 
   {{0x44f00254,0x4d60118d,0xd24c118e,0x00000000}},	//   nţ_, окрв, _زني_, --, 
   {{0xdf480094,0x00000000,0x00000000,0x00000000}},	//   _азид_, --, --, --, 
   {{0x5f7403b5,0x0b400b61,0x38bc00b8,0x657c03b4}},	// [d00] _ڕاگر, онтн, níre_, _əsha, 
   {{0x7c24118f,0xa3e41190,0x4ef800ca,0x00000000}},	//   sfir, बुत_, _שהיו, --, 
   {{0xd00c1191,0x9f5c039c,0x7c241192,0x38bc0306}},	//   _علی_, ştä_, pfir, híre_, 
   {{0x7c241193,0x5974001e,0x18a41194,0x47c800ea}},	//   qfir, лыҵу, шаем, چاهۍ_, 
   {{0x27e81195,0x3e7401c5,0x2bc41196,0x00000000}},	//   ñana_, _zäta_, लेदा, --, 
   {{0xd944070b,0x00000000,0x00000000,0x00000000}},	//   _кеги, --, --, --, 
   {{0x74a800fc,0x985400cc,0x00000000,0x00000000}},	//   лсиң_, _кташ, --, --, 
   {{0x2c7401c5,0xe9700049,0x493800ca,0x00000000}},	//   _kåda_, _عۇند, _בגלו, --, 
   {{0x04c407bc,0xe72800e2,0x9f4001e8,0x3b0001e3}},	//   جويي_, _مسلو_, zakò_, nsiq_, 
   {{0x6b8802e6,0x96b801c3,0x00000000,0x00000000}},	//   _ýege, _рубу_, --, --, 
   {{0x70541197,0x3864034a,0x2c7401c9,0xc220005e}},	//   مندا, _komr_, _låda_, تکنو, 
   {{0x2248028a,0x3e7401c5,0x160c023b,0x09d0040e}},	//   _ɗaki_, _räta_, सलकर_, _तल्य, 
   {{0x83801198,0xc37001b5,0x248003f4,0x69c00192}},	//   _мыше, _وُمب, ëhme_, _úlev, 
   {{0x3e7400c0,0x25a80055,0x00000000,0x00000000}},	//   _päta_, şale_, --, --, 
   {{0xbd680241,0x6b8801c6,0x6fa8006c,0x672c011a}},	//   арте_, _ɾegu, _घडवू, ħaji, 
   {{0x2c7404bc,0x80a40046,0x3e740207,0xbbe80012}},	//   _båda_, _ومون, _väta_, ٔرٕم_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [d10] --, --, --, --, 
   {{0x3e740479,0x00000000,0x00000000,0x00000000}},	//   _täta_, --, --, --, 
   {{0xac981199,0x00000000,0x00000000,0x00000000}},	//   _مندا_, --, --, --, 
   {{0x2fcc01df,0x1ee80324,0xec340100,0x00000000}},	//   žegu_, _جویی_, _פאָר_, --, 
   {{0x321c0247,0x00000000,0x00000000,0x00000000}},	//   _ocvy_, --, --, --, 
   {{0x2ca8119a,0xf770119b,0x6e3400ef,0x490c0098}},	//   load_, بام_, nezb, _डिपो_, 
   {{0x6d4009b4,0x00000000,0x00000000,0x00000000}},	//   ælah, --, --, --, 
   {{0x290003a2,0x4ad800a1,0x38bc119c,0x2ca80151}},	//   msha_, _बढाव, tíre_, noad_, 
   {{0x2900119d,0x4e1400aa,0x00000000,0x00000000}},	//   lsha_, तलाई_, --, --, 
   {{0x38bc119e,0x2900119f,0x27fc03c7,0x6e3401df}},	//   ríre_, osha_, lawn_, jezb, 
   {{0x290011a0,0xa06811a1,0xa18811a2,0xd1c40094}},	//   nsha_, гана_, убна_, йлье_, 
   {{0x290011a3,0x3b000105,0x27fc03c7,0x00000000}},	//   isha_, ysiq_, nawn_, --, 
   {{0x248c11a4,0xa0a40121,0x290011a5,0x6fa403ef}},	//   miem_, _қаид, hsha_, _गुआं, 
   {{0x290011a6,0x248c0025,0x3d380299,0x27fc0336}},	//   ksha_, liem_, _pōw_, hawn_, 
   {{0xb3240126,0xf1a80122,0x29000222,0xdcb011a7}},	//   _འདོང_, _پاوه_, jsha_, كىس_, 
   {{0x248c11a8,0x2900036b,0x2ca80593,0x23840020}},	//   niem_, dsha_, goad_, _ክስዕብ_, 
   {{0x27fc0337,0x290011a9,0xdca411aa,0x59d40075}},	// [d20] dawn_, esha_, _ҳани, مغار, 
   {{0x290011ab,0x248c11ac,0x3b000444,0x00000000}},	//   fsha_, hiem_, rsiq_, --, 
   {{0x248c11ad,0x68f40337,0x27fc11ae,0x61e00110}},	//   kiem_, _cwzd, fawn_, icll, 
   {{0x69d411af,0x248c11a4,0x17f803e0,0x27fc0086}},	//   _egze, jiem_, اراة_, gawn_, 
   {{0x248c11b0,0x50180a1b,0x29000012,0xb3240126}},	//   diem_, רונו, asha_, _འདེང_, 
   {{0x290011b1,0x47300023,0x00000000,0x00000000}},	//   bsha_, яніс, --, --, 
   {{0x490c0c48,0xa6340122,0x248c00ce,0x00000000}},	//   _डियो_, زبوڵ, fiem_, --, 
   {{0x248c11b2,0x2bc411b3,0x73d802ac,0x06e400ec}},	//   giem_, लेवा, шдир_, шмәк_, 
   {{0x6e340008,0x00000000,0x00000000,0x00000000}},	//   yezb, --, --, --, 
   {{0x85740cf6,0x248c0028,0x00000000,0x00000000}},	//   рсәт_, aiem_, --, --, 
   {{0x248c11b4,0x9598038e,0x69c003aa,0xc0e411b5}},	//   biem_, _стау_, _úlet, یفین_, 
   {{0x248c11b6,0x645c002a,0x00000000,0x00000000}},	//   ciem_, ösit, --, --, 
   {{0x9344009e,0x6e340094,0x2fcc000b,0x00000000}},	//   _ынде, tezb, äeg_, --, 
   {{0x290011b7,0x00000000,0x00000000,0x00000000}},	//   ysha_, --, --, --, 
   {{0x90e411b8,0x2ca811b9,0x6e3400e9,0x7ae80078}},	//   _استن, toad_, rezb, _čdta, 
   {{0x81dc0143,0x6b740613,0x00000000,0x00000000}},	//   তরণ_, олбу, --, --, 
   {{0x290011ba,0x6e34002a,0xfbd00075,0x00000000}},	// [d30] wsha_, pezb, فتك_, --, 
   {{0x290011bb,0x248c11bc,0x2ee8011a,0x00000000}},	//   tsha_, ziem_, _itaf_, --, 
   {{0x27e811bd,0x290011be,0xdb040113,0x39580126}},	//   ñano_, usha_, _vyká, _ġesù_, 
   {{0x290011bf,0x248c02ba,0x68f401d5,0xc5b002ba}},	//   rsha_, xiem_, _vwzd, үркө, 
   {{0x248c11c0,0x27fc11c1,0x290011c2,0x2bc40095}},	//   viem_, rawn_, ssha_, लेशा, 
   {{0xf1c811c3,0x248c06f7,0x9ba00121,0x24e80074}},	//   रधान, wiem_, _غەلى, амки_, 
   {{0x248c11b0,0xe4c411c4,0xe578041c,0x00000000}},	//   tiem_, ойки, рзй_, --, 
   {{0x7b080084,0x2ee8019f,0x2b480070,0x00000000}},	//   _ástæ, _otaf_, ovac_, --, 
   {{0x248c11c5,0x00000000,0x00000000,0x00000000}},	//   riem_, --, --, --, 
   {{0x248c0025,0x38bc0212,0x3e7411c6,0xbb3c007c}},	//   siem_, míra_, _räto_, רעזי, 
   {{0x645c06ef,0x248c11c7,0x2ee811c8,0x7de000d3}},	//   ösis, piem_, _ataf_, _làsó, 
   {{0x9fc811c9,0x2c740085,0x356800c3,0xd0480387}},	//   игна_, _sådn_, _урун_, _kufə, 
   {{0x1ea800ea,0x00000000,0x00000000,0x00000000}},	//   لاسي_, --, --, --, 
   {{0x82200002,0xa3e400a1,0x00000000,0x00000000}},	//   _འཁྲི_, बुर_, --, --, 
   {{0xa3c003c3,0xc4d40143,0x9cc811ca,0x00000000}},	//   ंधक_, _সবুজ, ғыңа_, --, 
   {{0x33b00121,0x1be800f8,0xda70004b,0x38bc01d5}},	//   _تەۋر, рдаи_, ڈُر_, kíra_, 
   {{0x81dc007e,0x68e80c91,0x5ea411cb,0x717000c3}},	// [d40] তৰণ_, _čeda, _ومبل, _يۇۋا, 
   {{0xb9e80664,0x38bc006b,0x00000000,0x00000000}},	//   খণ্ড_, díra_, --, --, 
   {{0x6ee411cc,0x21240140,0xdca400b7,0xd7f811cd}},	//   _وسیل, ntlh_, _маои, аул_, 
   {{0x574800fc,0x38bc02b2,0x00000000,0x00000000}},	//   изем_, fíra_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x81dc007e,0xad2402cf,0x00000000,0x00000000}},	//   তৰত_, _بریو, --, --, 
   {{0x92e402fa,0x81dc0143,0x00000000,0x00000000}},	//   _বটে_, তরা_, --, --, 
   {{0xa3e411ce,0xe7080128,0x00000000,0x00000000}},	//   बुल_, شتۇن_, --, --, 
   {{0x0a4c02b4,0x67640197,0x00e001d2,0x00000000}},	//   _መማህራ, _ентҡ, _ﺍﻟﺨﺘ, --, 
   {{0x862811cf,0x672c0126,0x00000000,0x00000000}},	//   _نغمہ_, ħajt, --, --, 
   {{0xaabc11d0,0x00000000,0x00000000,0x00000000}},	//   ्गतक, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb324043b,0x00000000,0x00000000,0x00000000}},	//   _འདིང_, --, --, --, 
   {{0xdb74001d,0x00000000,0x00000000,0x00000000}},	//   _የመያዝ_, --, --, --, 
   {{0xdb0402eb,0x8c64018f,0x80a401ac,0x00000000}},	//   _lykä, отад, _ڪمين, --, 
   {{0xe5700282,0x2b480c0a,0x00000000,0x00000000}},	//   ײַל_, tvac_, --, --, 
   {{0xdddc03ef,0xdb0411d1,0x2ee802b2,0x00000000}},	// [d50] _dopł, _nykä, _utaf_, --, 
   {{0x38bc00ef,0x8a1411d2,0x63bc014e,0x00000000}},	//   víra_, تظرا, ýsni, --, 
   {{0x4c8002ac,0x090411d3,0x00000000,0x00000000}},	//   _قیسق, ючам, --, --, 
   {{0xe9e40552,0x00000000,0x00000000,0x00000000}},	//   ãºba_, --, --, --, 
   {{0x24e4024b,0x00000000,0x00000000,0x00000000}},	//   _ﺍﻨﺘﻬ, --, --, --, 
   {{0xf8040152,0x00000000,0x00000000,0x00000000}},	//   пчән, --, --, --, 
   {{0x9fa0038a,0xa9540023,0x00000000,0x00000000}},	//   tëër_, _экві, --, --, 
   {{0xe8640094,0x00000000,0x00000000,0x00000000}},	//   _эхгү, --, --, --, 
   {{0x383407ce,0x672c043b,0x00000000,0x00000000}},	//   _інфр, ħajs, --, --, 
   {{0x7d0800c0,0xaabc11d4,0x00000000,0x00000000}},	//   ádsk, ्गिक, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x55b80107,0x00000000,0x00000000,0x00000000}},	//   _המעו, --, --, --, 
   {{0x442c11d5,0xaabc11d6,0x64880105,0x00000000}},	//   _ibg_, ्गाक, 鯵ill, --, 
   {{0x68e80b34,0x442c0207,0x00000000,0x00000000}},	//   _čedn, _hbg_, --, --, 
   {{0xdddc0098,0x9f400192,0x5fac040e,0x00000000}},	//   _popł, ické_, _घडवल, --, 
   {{0x442c07e7,0xda1c00b3,0xa7fc00e3,0x98a40126}},	//   _jbg_, _पाहत_, _elűz, ċoċ_, 
   {{0x200011d7,0x442c0202,0x3e74013c,0xc1b811d8}},	// [d60] maki_, _mbg_, _jätk_, _उरुग, 
   {{0x200011d9,0xdb0411da,0xa6e8001c,0x442c11db}},	//   laki_, _szkó, _khươ, _lbg_, 
   {{0xceb011dc,0x4dd80107,0x20000243,0x442c01f1}},	//   _איז_, _לחיו, oaki_, _obg_, 
   {{0x200011dd,0xdca411de,0xdb04021c,0x442c11df}},	//   naki_, _хами, _pykä, _nbg_, 
   {{0x20000369,0x60d40380,0x9f40001e,0xe7fc0030}},	//   iaki_, _miym, pakõ_, _उजरा_, 
   {{0x200011e0,0x442c11e1,0xc1b8023b,0x00000000}},	//   haki_, _abg_, _उरूग, --, 
   {{0x200011e2,0x442c11e3,0xa6e801eb,0x00000000}},	//   kaki_, _bbg_, _nhươ, --, 
   {{0x200011e4,0x28f80241,0xdb0402eb,0xc51011e5}},	//   jaki_, _фэрэ_, _tykä, ربىت, 
   {{0x200011e6,0x442c028b,0x00000000,0x00000000}},	//   daki_, _dbg_, --, --, 
   {{0x877811e7,0x2000008b,0xd25811e8,0x442c014e}},	//   _האמי, eaki_, сци_, _ebg_, 
   {{0x2bb811e9,0x200011ea,0xa6e80765,0x442c11eb}},	//   _आर्थ, faki_, _chươ, _fbg_, 
   {{0x442c11ec,0x200011ed,0x9f500031,0x00000000}},	//   _gbg_, gaki_, _adyñ_, --, 
   {{0xefc80090,0x60d411ee,0x00000000,0x00000000}},	//   _በዚያ_, _diym, --, --, 
   {{0xf1e011ef,0x3eb8006f,0xdb040223,0x8bc40116}},	//   _नलिन, glrt_, _òmùg, ҧсад, 
   {{0x200011f0,0x68e811f1,0x61ec0055,0x3d180192}},	//   baki_, _čedo, _şalg, बूले_, 
   {{0x200011f2,0x60d4024f,0x00000000,0x00000000}},	//   caki_, _giym, --, --, 
   {{0xead80049,0xfc140094,0x00000000,0x00000000}},	// [d70] імжі_, эмтэ, --, --, 
   {{0x6d4011f3,0xcc840061,0x49c800e5,0x00000000}},	//   ælas, _کۆره_, буем_, --, 
   {{0x20e411f4,0xba740121,0xda1c00a1,0x6d4011f5}},	//   _kēia_, راكت, _पारत_, çlad, 
   {{0x6b8802e6,0x00000000,0x00000000,0x00000000}},	//   _ýego, --, --, --, 
   {{0xcb4405bc,0x442c0151,0x28d8025c,0x00000000}},	//   _эхни, _rbg_, _बंकि, --, 
   {{0x442c11f6,0x00000000,0x00000000,0x00000000}},	//   _sbg_, --, --, --, 
   {{0x200011f7,0x0a50010f,0x64a411f8,0xb9340ce1}},	//   yaki_, _ለማሳካ, мака, _перј, 
   {{0x2000009d,0xf7700061,0xc864018f,0x00000000}},	//   xaki_, _ڵاق_, _этги, --, 
   {{0x20000382,0x973000e2,0x60d40140,0xc6a402eb}},	//   vaki_, _ټکنا, _riym, _ержи, 
   {{0xa6e80765,0x200011f9,0x7cdc0296,0x60d401d9}},	//   _phươ, waki_, _hōre, _siym, 
   {{0x200011fa,0x7cdc11fb,0xa0a411fc,0x26c411fd}},	//   taki_, _kōre, данд, _ihlo_, 
   {{0x60d411fe,0x44e011ff,0x205400f8,0x200003e6}},	//   _qiym, _iñ_, фтор, uaki_, 
   {{0x20001200,0x64480ca0,0x7cdc04c4,0x00000000}},	//   raki_, mdei, _mōre, --, 
   {{0x20001201,0xa6e801c0,0xe2c81202,0x44e00919}},	//   saki_, _thươ, _بوتو_, _kñ_, 
   {{0x62801203,0x26c403e6,0xed3409bb,0xa0681204}},	//   mhlo, _mhlo_, нэтэ, _мака_, 
   {{0x64481205,0x39940310,0x20001206,0x62801207}},	//   ndei, _तs_, qaki_, lhlo, 
   {{0x3e7400a1,0x6d40020c,0x06e000ac,0x64481208}},	// [d80] _läti_, ælar, নীতি, idei, 
   {{0x62801209,0x7f44120a,0x26c40636,0x44e0120b}},	//   nhlo, _isiq, _nhlo_, _oñ_, 
   {{0x6458120c,0x3e74012b,0x00000000,0x00000000}},	//   _onwi, _näti_, --, --, 
   {{0x7d1c120d,0xccf002c3,0x10e401d2,0x00000000}},	//   murs, _שכר_, _ﺍﻟﺯﻨ, --, 
   {{0x44e0120e,0x6448120f,0xc6f41210,0x7d1c1211}},	//   _añ_, ddei, дніх_, lurs, 
   {{0x64581212,0x26c4048d,0x64481213,0x7d1c015e}},	//   _anwi, _chlo_, edei, ours, 
   {{0x26c40a65,0x6448018c,0x7d1c0402,0x7ae41214}},	//   _dhlo_, fdei, nurs, lqit, 
   {{0x3ae41215,0x73c41216,0x6448008e,0x7f440083}},	//   _köp_, нәле, gdei, _osiq, 
   {{0x44e00d7f,0x7ae41217,0xb5fc043b,0x73340682}},	//   _eñ_, nqit, _loġi, رىدا, 
   {{0x64581218,0x64481219,0x6280121a,0x57c800aa}},	//   _enwi, adei, ghlo, िधीह, 
   {{0x7f44121b,0x7648025e,0x20e40062,0x3ae401c5}},	//   _asiq, _iady, _pēia_, _löp_, 
   {{0x7d1c121c,0x6280121d,0x7648121e,0xc56000dd}},	//   durs, ahlo, _hady, _جڏهي, 
   {{0x27e8121f,0x76481220,0x62801221,0x2eec0029}},	//   ñani_, _kady, bhlo, ëef_, 
   {{0x62801222,0x7ae403fa,0x7d1c1223,0x6b18011a}},	//   chlo, dqit, furs, ུངལོ_, 
   {{0x76481224,0x7f4408a6,0x64580010,0xa3e41225}},	//   _mady, _esiq, _ynwi, बुक_, 
   {{0x76481226,0x290c0237,0x3c580254,0x00000000}},	//   _lady, _ĉea_, мисэ_, --, 
   {{0x7ae401fa,0x7cdc0299,0x10e40041,0x3ae40055}},	// [d90] gqit, _rōre, _ﺍﻟﺠﻨ, _cöp_, 
   {{0x7d1c1227,0x76481228,0x7a381229,0x2bc4122a}},	//   burs, _nady, мпур_, लेगा, 
   {{0x6f1c122b,0x6e24122c,0x80a403f5,0x6448009c}},	//   lusc, _ichb, _سمین, ydei, 
   {{0x6d44122d,0x7648122e,0x64480337,0xa7e401ee}},	//   _isha, _aady, xdei, ركتى, 
   {{0x6f1c122f,0x76481230,0x07040046,0x6d4401a0}},	//   nusc, _bady, ړيږي_, _hsha, 
   {{0x6d440c12,0x64480008,0x64580177,0x76480080}},	//   _ksha, wdei, _snwi, _cady, 
   {{0x76481231,0x7cdc0341,0x6f1c0496,0x629c0670}},	//   _dady, _tōre, husc, ésom, 
   {{0x6d441232,0x4dd8007e,0x7648071c,0x00000000}},	//   _msha, _বজোৱ, _eady, --, 
   {{0x64481233,0x6f1c1234,0x7d1c1235,0x62801236}},	//   rdei, jusc, zurs, thlo, 
   {{0x27281237,0x6d441238,0x76481239,0xe1f003e0}},	//   mún_, _osha, _gady, دسة_, 
   {{0x6d44123a,0x27280272,0x7f440636,0x66000028}},	//   _nsha, lún_, _ssiq, _ielk, 
   {{0x628004e7,0x6e24123b,0x764801ec,0x6600123c}},	//   shlo, _achb, _zady, _helk, 
   {{0x6600123d,0x6d44123e,0x764800cb,0x26d804ac}},	//   _kelk, _asha, _yady, _ésos_, 
   {{0x6600123f,0x9d4401c3,0x21a41240,0x00000000}},	//   _jelk, негд, _пилм, --, 
   {{0x66001241,0x27281242,0x6d441243,0x7b840121}},	//   _melk, hún_, _csha, ھارە, 
   {{0x6f1c1244,0x8c401245,0x660000cd,0x7d1c1246}},	//   busc, лесе, _lelk, rurs, 
   {{0x6d441247,0x7f440990,0x6f1c1248,0x1fb40103}},	// [da0] _esha, _usiq, cusc, _яскр, 
   {{0x6d440422,0x7ae41249,0x6600124a,0xabc400ec}},	//   _fsha, rqit, _nelk, тауҙ, 
   {{0x7648124b,0xdb040353,0x7d1c01e3,0x2a780229}},	//   _rady, _lykø, qurs, _ńgbé_, 
   {{0x3ae40573,0xd704124c,0x7648124d,0xfe20124e}},	//   _töp_, езди, _sady, _बाँस_, 
   {{0x2728124f,0x76481250,0x66001251,0x7ae40e92}},	//   gún_, _pady, _belk, qqit, 
   {{0x66001252,0x2c74012a,0x76480080,0x6d441253}},	//   _celk, _rådi_, _qady, _ysha, 
   {{0x76481254,0x6d4404e7,0x66001255,0x6f1c1256}},	//   _vady, _xsha, _delk, zusc, 
   {{0x66001257,0x6f1c0964,0x64a003f2,0x76481258}},	//   _eelk, yusc, sēin, _wady, 
   {{0xc7a00f5c,0x660000cd,0x76480828,0xfe200774}},	//   _битк, _felk, _tady, _बांस_, 
   {{0x60c80271,0x73c4002c,0x6f1c059e,0x71781259}},	//   ɛmmɔ, нәһе, vusc, дбор_, 
   {{0x2b90018b,0x7334020d,0x85f40d47,0x00000000}},	//   môcť_, رىگا, _נמאס_, --, 
   {{0x6f1c125a,0x6d4401e3,0x8230125b,0x00000000}},	//   tusc, _rsha, پریا, --, 
   {{0x6600125c,0x6f1c000b,0x9324005e,0xf28802ba}},	//   _yelk, uusc, _سرشن, _жөнд_, 
   {{0x6f1c125d,0x6d44006a,0xdddc00bd,0x877800ca}},	//   rusc, _psha, _kopř, לאכי, 
   {{0x8d74125e,0xac94125f,0xdcec00e0,0x63b80201}},	//   راسا, вавш, dzbē, _zywn, 
   {{0x6f1c1260,0xc1b800ca,0xbf1400ec,0x89d800d3}},	//   pusc, _ממוש, _әүрә, dìpẹ, 
   {{0x00d81261,0x92dc02fa,0xfaf01262,0x272803b2}},	// [db0] _ثبوت_, _তবু_, مثل_, xún_, 
   {{0x6d441263,0xdb241264,0x6f0c1265,0x6e241266}},	//   _tsha, ئولی, _ivac, _uchb, 
   {{0x6d441267,0x2bc4006c,0x7d080306,0x8fd000ec}},	//   _usha, लेजा, ádst, _шәүә, 
   {{0x660006ea,0x6f0c0828,0x27281268,0xf8d800ec}},	//   _selk, _kvac, tún_, еңсә_, 
   {{0x660006ea,0x36e8006e,0x00000000,0x00000000}},	//   _pelk, ۈرۈپ_, --, --, 
   {{0x27281269,0x6934126a,0x7cdc0341,0xd6c401d9}},	//   rún_, _ингу, _hōra, نمنی, 
   {{0x6600126b,0x7cdc04c4,0x2728126c,0xb5fc0247}},	//   _velk, _kōra, sún_, _noġu, 
   {{0x6600126d,0x3e7408c3,0xdddc00bd,0xb6880122}},	//   _welk, _hätt_, _dopř, وپۆل_, 
   {{0x1300126e,0x7cdc0296,0x3e74126f,0xd84000bd}},	//   азым, _mōra, _kätt_, áčů_, 
   {{0x60e81123,0x00000000,0x00000000,0x00000000}},	//   ммом_, --, --, --, 
   {{0xfdac04d8,0x21a41270,0x6f0c1271,0x4e1800a1}},	//   _খণ্ড, тинм, _avac, _बाड़े_, 
   {{0x3e7404bc,0xdee41272,0xd24c0012,0x00000000}},	//   _lätt_, коми, ٕنی_, --, 
   {{0x10e40049,0x00000000,0x00000000,0x00000000}},	//   _ﺍﻟﺼﻨ, --, --, --, 
   {{0x443c1273,0x91e01274,0x6f0c00aa,0x3e7401c5}},	//   leu_, _коше, _dvac, _nätt_, 
   {{0x6f0c1275,0x27ec1276,0xdcb01277,0x443c011a}},	//   _evac, _ofen_, لىس_, oeu_, 
   {{0x443c1278,0x7cdc0177,0x00000000,0x00000000}},	//   neu_, _cōra, --, --, 
   {{0x443c1279,0x1e8402ba,0x8c40012b,0x00000000}},	// [dc0] ieu_, _алпм, шете, --, 
   {{0x27ec127a,0x3e7400af,0x00000000,0x00000000}},	//   _afen_, _pätu_, --, --, 
   {{0x443c127b,0x6f0c0582,0xdca400b8,0x98480668}},	//   keu_, _zvac, _аани, дяла_, 
   {{0xd6e00098,0x9b0402ba,0x00000000,0x00000000}},	//   ykłą_, _измд, --, --, 
   {{0x443c127c,0x38bc0116,0x83c8080a,0x00000000}},	//   deu_, níri_, ﻗﯩﺮﺳ, --, 
   {{0x7c240007,0x27ec0028,0x15d40012,0xdddc00bd}},	//   lgir, _efen_, نگاں_, _popř, 
   {{0x92dc0ce4,0x443c127d,0x27ec0278,0x3494001e}},	//   _তবে_, feu_, _ffen_, лакр, 
   {{0x443c127e,0x38c8127f,0x9998012c,0x00000000}},	//   geu_, _سازی_, lepů_, --, 
   {{0x7c241280,0xb9d0001d,0x68e801d5,0x61ec00fc}},	//   igir, _ሴራ_, _čedi, _şala, 
   {{0x6f0c01f8,0x3e7401c5,0x7c241281,0x38bc0247}},	//   _rvac, _mäts_, hgir, díri_, 
   {{0x51841282,0x443c1283,0x6f0c1284,0x14240329}},	//   тупа, beu_, _svac, _адем, 
   {{0x443c1285,0x61f40a52,0x638000b8,0x7c240031}},	//   ceu_, ızla, рҳәа, jgir, 
   {{0xb8e40126,0x38bc0247,0xff041286,0x00000000}},	//   _ཌེ_, gíri_, иярн, --, 
   {{0x7cdc0341,0x7c241287,0xb5fc0247,0x00000000}},	//   _rōra, egir, _toġu, --, 
   {{0x3e7405f0,0x313400bf,0x826800d5,0x00000000}},	//   _rätt_, _сейр, _تشنہ_, --, 
   {{0x3e7405f0,0x7c241288,0x6abc1289,0x7cdc04c4}},	//   _sätt_, ggir, ्ग्र, _pōra, 
   {{0x4ea4128a,0x3e74128b,0x6f0c00a8,0xfbd00075}},	// [dd0] _арна, _pätt_, _uvac, قتك_, 
   {{0x443c009e,0x7c24007b,0x637800d3,0x248800c0}},	//   zeu_, agir, _hùnú, ďami_, 
   {{0x443c128c,0x7c24128d,0xc0bc0020,0x069000d5}},	//   yeu_, bgir, _ሰጊሩ_, یاتھ, 
   {{0x7cdc04c4,0x443c00e7,0xc1980107,0xdd300387}},	//   _tōra, xeu_, ושבי, ləşs, 
   {{0x443c128e,0xd3641262,0x3b641166,0x3e7401c9}},	//   veu_, _اه_, _кърв, _tätt_, 
   {{0xe5a4128f,0x443c1290,0x2cb80151,0xd1b8010f}},	//   лили, weu_, _hksd_, _ታላቁ_, 
   {{0x443c1291,0x2cb80151,0x1a9800cf,0x00000000}},	//   teu_, _kksd_, _טישע, --, 
   {{0x443c0062,0x27ec0278,0xdddc01b1,0x67d41072}},	//   ueu_, _ufen_, _enpň, _бобу, 
   {{0x443c1292,0xe3b81293,0x062401c7,0x00000000}},	//   reu_, эби_, _афем, --, 
   {{0x443c1294,0x53c402ca,0x7c241295,0xd2a40254}},	//   seu_, ыгым_, zgir, лкые_, 
   {{0x443c1296,0x00000000,0x00000000,0x00000000}},	//   peu_, --, --, --, 
   {{0xa3541297,0x7c24006a,0xa0681298,0x38bc001e}},	//   _مختص, xgir, хама_, tíri_, 
   {{0x6d401299,0xbe840108,0x7c2402e8,0x8364129a}},	//   çlan, иқии, vgir, _جدال, 
   {{0x5398129b,0x10a00200,0x3cec0a03,0xdb040031}},	//   _אינו, _қиын, ídvo_, _cyký, 
   {{0x5bbc0828,0x7c24129c,0x00000000,0x00000000}},	//   ्ध्व, tgir, --, --, 
   {{0xb5fc0002,0x3e740030,0x7c2400c2,0xb1a4069d}},	//   _inġe, _päts_, ugir, _әшәк, 
   {{0x2c74036d,0x5f44129d,0x3d1800d1,0x5ba8022e}},	// [de0] _rådt_, _صندل, बूजे_, хкам_, 
   {{0x7c24129e,0xd1b80090,0xddb4129f,0x00000000}},	//   sgir, _ታላቅ_, _محجب, --, 
   {{0x7c2412a0,0x00000000,0x00000000,0x00000000}},	//   pgir, --, --, --, 
   {{0xd70812a1,0xc0bc02b4,0x178400cc,0x00000000}},	//   енде_, _ሰፊሩ_, лгем, --, 
   {{0x7cdc00a2,0x7d1c012a,0x2c740056,0x3a4800b8}},	//   _hōro, lrrs, _vådt_, _иҟам_, 
   {{0x09e012a2,0x7cdc0341,0xc7a012a3,0xa614001e}},	//   _горн, _kōro, щичк, азшә, 
   {{0x98a400fc,0x74a800fc,0x04c4005e,0x00000000}},	//   _биве, ксиң_, گويي_, --, 
   {{0x7cdc0299,0x67300353,0x00000000,0x00000000}},	//   _mōro, økjæ, --, --, 
   {{0xe9d0009d,0xb5fc011a,0x88b012a4,0x97000121}},	//   _هغې_, _anġe, _اینچ, _چېچى, 
   {{0xd9f40192,0x00000000,0x00000000,0x00000000}},	//   ेरित_, --, --, --, 
   {{0x27e80ebd,0x3cf8018b,0x00000000,0x00000000}},	//   žane_, jprv_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb0400ef,0x00000000,0x00000000,0x00000000}},	//   _mykó, --, --, --, 
   {{0x0cbc12a5,0x38bc012c,0x00000000,0x00000000}},	//   ्ष्म, míru_, --, --, 
   {{0xc278007c,0x202802eb,0x00000000,0x00000000}},	//   _ארגי, ätiö_, --, --, 
   {{0x2c740a0e,0x629c01d4,0x00000000,0x00000000}},	//   _råds_, ésov, --, --, 
   {{0x3a380249,0x395801d1,0x7d1c12a6,0xebc40152}},	// [df0] _bbrp_, _arrs_, arrs, рәнн, 
   {{0x09e00143,0x00000000,0x00000000,0x00000000}},	//   যর্থ, --, --, --, 
   {{0x7ac412a7,0xdb040201,0x00000000,0x00000000}},	//   ссте, _bykó, --, --, 
   {{0xa564031b,0x6f1c084f,0x8ca000cc,0xa8340106}},	//   یگان, orsc, _اەرو, редљ, 
   {{0x660412a8,0x395800af,0x6e480020,0x00000000}},	//   апла, _errs_, _ብምንጽ, --, 
   {{0x2b5802ba,0x955c010f,0x6f1c12a9,0xc79000ec}},	//   _irsc_, ተሰቡን_, irsc, ирҙы, 
   {{0x6f1c0fcc,0x81e00143,0x61ec12aa,0x00000000}},	//   hrsc, _ফজল_, _şalo, --, 
   {{0x23340155,0x00000000,0x00000000,0x00000000}},	//   ахор, --, --, --, 
   {{0x27fc0361,0xe3b00272,0x130412ab,0x00000000}},	//   mbwn_, غرب_, аный_, --, 
   {{0x659412ac,0x6b8c01aa,0x6f1c01df,0x957402a0}},	//   _казу, izag, drsc, _baхı, 
   {{0xd24c0122,0x6b8c018f,0x34840094,0x00000000}},	//   بچن_, hzag, ргөг, --, 
   {{0x7cdc0299,0x622400c3,0x00000000,0x00000000}},	//   _rōro, _چىشل, --, --, 
   {{0xdee412ad,0x224812ae,0x6b8c12af,0x63040121}},	//   роги, _апли_, jzag, _ئوتل, 
   {{0x6b8c0b75,0x7cdc0296,0xe29812b0,0x41e401b2}},	//   dzag, _pōro, _шал_, _сіда, 
   {{0x6f1c12b1,0x9cb412b2,0x00000000,0x00000000}},	//   arsc, لمست, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d5401c6,0x3ae812b3,0x2b580139,0xfce412b4}},	// [e00] _eĥe_, ابری_, _crsc_, роғо, 
   {{0x2b5812b5,0x7cdc0296,0x00000000,0x00000000}},	//   _drsc_, _tōro, --, --, 
   {{0x3eb812b6,0xd82412b7,0x6b8c0028,0x61ec0152}},	//   mort_, иджи, azag, _ğall, 
   {{0x2b5812b8,0x3eb812b9,0x386004ac,0x61ec0a16}},	//   _frsc_, lort_, ñir_, _şall, 
   {{0x870012ba,0x68f402b0,0x30d800cf,0x00000000}},	//   ояще, _etzd, אַװע, --, 
   {{0x38980341,0xc68c01b5,0x66cc0038,0x3eb8002a}},	//   pōro_, وِن_, júkd, nort_, 
   {{0x321806f7,0x5c44001d,0x956402ba,0x00000000}},	//   órym_, _የሻዕቢ, рълд, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x27e801d1,0x00000000,0x00000000,0x00000000}},	//   žanc_, --, --, --, 
   {{0x6f1c01df,0xd25812bb,0xd6280edd,0x00000000}},	//   vrsc, тци_, _јоже_, --, 
   {{0x6b8c12bc,0x3eb812bd,0xd44800cc,0x2fc800e3}},	//   zzag, dort_, _аялд_, _szag_, 
   {{0x85980240,0x6d40024f,0xd7a8006c,0x38bc00bd}},	//   _בשבו, çlam, _कशाच, píru_, 
   {{0x3eb812be,0x4fc40182,0x6f1c12bf,0x25a80055}},	//   fort_, рсна, ursc, şalt_, 
   {{0x6f1c12c0,0xd1b8010f,0x3eb812c1,0x00000000}},	//   rrsc, _ታዋቂ_, gort_, --, 
   {{0x70580396,0xac180617,0x8cb801b5,0x320c12c2}},	//   _байр_, лову_, ندرس_, mady_, 
   {{0x320c12c3,0x3d180774,0x6b8c01a7,0x66cc00c4}},	//   lady_, _फिरे_, tzag, múke, 
   {{0x3eb800d5,0x0ca4040e,0x00000000,0x00000000}},	// [e10] bort_, _गदीम, --, --, 
   {{0x320c12c4,0x6b8c12c5,0xdb240eba,0xed5001b5}},	//   nady_, rzag, صومی, _ٹھس_, 
   {{0x7ed40272,0xab64015b,0x00000000,0x00000000}},	//   _بزيا, _spļā, --, --, 
   {{0x320c12c6,0x4c8004e7,0x00000000,0x00000000}},	//   hady_, _بیرق, --, --, 
   {{0x320c12c7,0xe73803bd,0x61ec0031,0x00000000}},	//   kady_, уел_, _şalm, --, 
   {{0x232800f8,0x320c12c8,0x2368043b,0x2ee80386}},	//   ҳоии_, jady_, _ħaj_, _muaf_, 
   {{0xbe3c0107,0x561000dd,0x320c02e6,0x00000000}},	//   דעות, سويء, dady_, --, 
   {{0x6b880101,0x3eb812c9,0x00000000,0x00000000}},	//   _ýegs, zort_, --, --, 
   {{0x320c0364,0x228800c0,0xa5f80139,0x00000000}},	//   fady_, _lúke_, _безу_, --, 
   {{0xf67403e0,0x320c12ca,0xe1f802ba,0x00000000}},	//   _والخ, gady_, ыго_, --, 
   {{0x3eb812cb,0xe0d812cc,0x61440a41,0x00000000}},	//   vort_, лво_, щена, --, 
   {{0x3eb80602,0xa0a412cd,0x00000000,0x00000000}},	//   wort_, самд, --, --, 
   {{0xd12c12ce,0x3eb812cf,0x23680475,0x320c12d0}},	//   ومی_, tort_, _çaj_, bady_, 
   {{0x201c12d1,0xdddc00c2,0xfd640182,0x320c028b}},	//   şti_, _copş, онгү, cady_, 
   {{0xdee40362,0x628012d2,0xd24c12d3,0x224412d4}},	//   роҳи, mklo, _سني_, melk_, 
   {{0xe29812d5,0xd12c0075,0x00000000,0x00000000}},	//   _шаһ_, _أمي_, --, --, 
   {{0x3eb812d6,0xcb6412d7,0x32c401ee,0x0590004f}},	// [e20] port_, бате_, ﺮﯨﮕﻪ, _vāṇy, 
   {{0x628012d8,0x9be40049,0x5e4812d9,0xd9c800d3}},	//   nklo, ріңк, _спом_, _ẹ̀kẹ, 
   {{0x2b4801b5,0x628003f4,0x57d40ce5,0x1ea800dd}},	//   awac_, iklo, ﻜﺘﯩﺮ, _لاھي_, 
   {{0xea980828,0xda70004b,0xac680020,0x00000000}},	//   tuṃ_, _کُس_, _ሰሪሖም_, --, 
   {{0xb5fc0247,0x62800029,0x4cb800ca,0x224412da}},	//   _anġa, kklo, _תזכו, kelk_, 
   {{0x628001c3,0x27e800c0,0x00000000,0x00000000}},	//   jklo, ľana_, --, --, 
   {{0x99840699,0x320c12db,0x27e812dc,0x5d78007c}},	//   _الأو, vady_, žana_, טאַק, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x320c12c6,0xd20801a7,0x68e00249,0x00000000}},	//   tady_, лэнд_, _èlda, --, 
   {{0xd0ac0130,0x9f500964,0x66cc0a03,0x81c002fa}},	//   _fɛɛf, _leyó_, túke, ্শন_, 
   {{0x320c12dd,0x940412de,0x527412df,0x85f40107}},	//   rady_, _هواه, _қуду, _הצבע_, 
   {{0x62800ca7,0x320c12e0,0x629c12e1,0x2b480098}},	//   aklo, sady_, ésor, ywac_, 
   {{0x320c12e2,0xff0412e3,0x82600061,0x00000000}},	//   pady_, зясн, زهێن, --, 
   {{0xacf812e4,0xdddc00f1,0x320c028b,0x0ba40197}},	//   ингу_, _enpō, qady_, ҡшам, 
   {{0x60dc0078,0x00000000,0x00000000,0x00000000}},	//   ňsma, --, --, --, 
   {{0xce30031b,0x00000000,0x00000000,0x00000000}},	//   _کودک, --, --, --, 
   {{0xeaf4006c,0x00000000,0x00000000,0x00000000}},	// [e30] ेठेत_, --, --, --, 
   {{0x2b4812e5,0x61ec012b,0xac9812e6,0x00000000}},	//   rwac_, _ğalk, _چندا_, --, 
   {{0x61ec12e7,0xac9812e8,0x00000000,0x00000000}},	//   _şalk, _نندا_, --, --, 
   {{0xb0c812e9,0xb4c80320,0xbdf80210,0x00000000}},	//   रतिग, _йоiа, _پریا_, --, 
   {{0x2ca812ea,0x628012eb,0x00000000,0x00000000}},	//   mnad_, yklo, --, --, 
   {{0x2ca812ec,0x49f00126,0xc68c0012,0x00000000}},	//   lnad_, _བཅིལ_, ڈِچ_, --, 
   {{0x2ca80145,0x6ac412ed,0x00000000,0x00000000}},	//   onad_, वतीर, --, --, 
   {{0x2ca812ee,0xa6c800ec,0x22440306,0x00000000}},	//   nnad_, ылһа_, welk_, --, 
   {{0x2ca80078,0x4df800bd,0x25fc12ef,0x224412f0}},	//   inad_, ्राई_, _र्थी_, telk_, 
   {{0xe29806d4,0x2ca8009c,0x628000f1,0x00000000}},	//   рао_, hnad_, uklo, --, 
   {{0xe04412f1,0x628012f2,0xa06812f3,0x00000000}},	//   онни, rklo, аана_, --, 
   {{0x628012f4,0xa09812d9,0x00000000,0x00000000}},	//   sklo, ртоф_, --, --, 
   {{0x628012f5,0xd9c4025c,0x2ca812f6,0x6b880098}},	//   pklo, _वर्ट, dnad_, _żegn, 
   {{0xb9400090,0x3f8c002f,0x9f5000f1,0x248c12f7}},	//   _ነዋሪዎ, ądu_, _beyò_, lhem_, 
   {{0x7cdc0296,0xdc9812f8,0x1d0812f9,0x854400b0}},	//   _hōri, аташ_, реби_, brėš, 
   {{0x90c012fa,0x9f50065e,0x248c12fb,0x7cdc0341}},	//   _обще, _deyò_, nhem_, _kōri, 
   {{0x9e900661,0x8af4038c,0x2d9001c7,0x200000d1}},	// [e40] _ሃገርና_, _şəra, azze_, mbki_, 
   {{0xed580155,0x7cdc0296,0x2ca812fc,0x4a40023f}},	//   шоӣ_, _mōri, anad_, мнув, 
   {{0x248c0c12,0xdb0401c9,0x442c01ca,0x2ca8028b}},	//   khem_, _nykö, _ocg_, bnad_, 
   {{0x442c000f,0x2ca8028b,0xaf340324,0x00000000}},	//   _ncg_, cnad_, _بویژ, --, 
   {{0x7d000223,0x248c12fd,0xdd9000e2,0x00000000}},	//   _fàrò, dhem_, _روڼ_, --, 
   {{0x442c01d6,0x248c0560,0x20d00306,0x00000000}},	//   _acg_, ehem_, láid_, --, 
   {{0x442c04ba,0x248c0002,0x00000000,0x00000000}},	//   _bcg_, fhem_, --, --, 
   {{0x442c01d6,0x248c01c5,0x068012fe,0x998800f1}},	//   _ccg_, ghem_, згән, _rebň_, 
   {{0x926812ff,0x442c014a,0xc7a00aa9,0x845000e7}},	//   арна_, _dcg_, _житк, بۉنچ, 
   {{0xc2140302,0x154400df,0x91e000ec,0x00000000}},	//   оєю_, _мезм, мәйһ, --, 
   {{0x442c006a,0x2ca8028b,0x10e4024b,0x00000000}},	//   _fcg_, ynad_, _ﺍﻟﺒﻨ, --, 
   {{0x2ca80080,0xbfc000d3,0x00000000,0x00000000}},	//   xnad_, _íbọm_, --, --, 
   {{0xb4c8057f,0x2ca81300,0xf4840061,0xc6c0044a}},	//   ोगी_, vnad_, _واڵی, _айăк, 
   {{0x9f5000f1,0x6b880201,0x00000000,0x00000000}},	//   _peyò_, _żego, --, --, 
   {{0x2d841301,0x66cc0c75,0x2ca801b9,0x442c015e}},	//   ále_, núka, tnad_, _ycg_, 
   {{0x61ec039c,0x20d0059b,0x2ca800af,0x4e1400bd}},	//   _ğali, gáid_, unad_, _भएकै_, 
   {{0x2d840ada,0x2ca81302,0x228802b2,0x61ec02a0}},	// [e50] šle_, rnad_, _húka_, _şali, 
   {{0x2ca81303,0x6e94001e,0x2288030f,0x3b6c001d}},	//   snad_, _хиоу, _kúka_, _ተጫዋች_, 
   {{0x248c1304,0x2288014e,0x2ca80479,0xc0f4001d}},	//   yhem_, _júka_, pnad_, ፋፈር_, 
   {{0x63ac0084,0x66cc05c0,0x25fc1305,0x228802cc}},	//   _þang, dúka, रुनी_, _múka_, 
   {{0x22881306,0x27e80b34,0xbba80668,0x236c0002}},	//   _lúka_, žano_, _държ_, xxej_, 
   {{0xd6240d7f,0x442c02ba,0x7cdc0299,0xf6640128}},	//   _རྐྱབ_, _scg_, _rōri, дешү, 
   {{0x442c0e84,0x07080021,0x200003ef,0x16a4021d}},	//   _pcg_, _सौरव_, ybki_, явши_, 
   {{0x7cdc0296,0x248c00f1,0x00000000,0x00000000}},	//   _pōri, uhem_, --, --, 
   {{0x248c1307,0x9f500b7c,0xec780048,0x442c000d}},	//   rhem_, _neyð_, _độc_, _vcg_, 
   {{0x248c1308,0x228800c4,0xdb040139,0x00000000}},	//   shem_, _búka_, _tykö, --, 
   {{0x63ac1309,0x6b8803ef,0x248c0055,0x00000000}},	//   _žand, _żegl, phem_, --, 
   {{0x442c11c6,0x7cdc0341,0x9f500579,0x228802b2}},	//   _ucg_, _tōri, _beyð_, _dúka_, 
   {{0x6448006f,0xef640182,0x1ea8130a,0x00000000}},	//   meei, мъёо, ماسي_, --, 
   {{0x9f5005c0,0x228801d4,0x6448130b,0x12f800ca}},	//   _deyð_, _fúka_, leei, _ההסב, 
   {{0x40b40254,0x8d6003a7,0x00000000,0x00000000}},	//   _ориӂ, нвре, --, --, 
   {{0xb5fc043b,0x6448130c,0x00000000,0x00000000}},	//   _anġl, neei, --, --, 
   {{0x20d003e0,0xcb64130d,0x63ac02b2,0x00000000}},	// [e60] ráid_, пате_, _þand, --, 
   {{0x64480062,0x20d00272,0x00000000,0x00000000}},	//   heei, sáid_, --, --, 
   {{0x8e780107,0x64480616,0xc4c803ef,0x5f74130e}},	//   _הניה, keei, ाताओ, _ذاکر, 
   {{0x8d74130f,0x6448006f,0x1ae41310,0x00000000}},	//   _راپا, jeei, _номм, --, 
   {{0x64481311,0xbab401b5,0x00000000,0x00000000}},	//   deei, _قۅرب, --, --, 
   {{0x3b0002b1,0x00000000,0x00000000,0x00000000}},	//   mpiq_, --, --, --, 
   {{0xd4981312,0x644801f1,0x00000000,0x00000000}},	//   йри_, feei, --, --, 
   {{0x73c41313,0xb4c81314,0x64481315,0xb78801c4}},	//   мәле, ोगे_, geei, _мәле_, 
   {{0x1784021b,0x3b0003c0,0x10e40200,0x25fc040e}},	//   _эгам, npiq_, _ﺍﻟﺘﻨ, _र्वी_, 
   {{0x46a008eb,0x4b78007c,0x9f500579,0x673c0030}},	//   _заув, צטיג, _reyð_, _äsja, 
   {{0x7f441316,0x86b41317,0x7cdc00a2,0x461001d9}},	//   _apiq, _عُمر_, _hōru, _سونر, 
   {{0x7cdc04c4,0x63ac1318,0x66cc02d9,0x91c00108}},	//   _kōru, _žane, núkn, мәқл, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7cdc00a2,0x2ee403c8,0xdb98010f,0x61ec1319}},	//   _mōru, ölf_, _ለመያዝ_, _şalv, 
   {{0x728000ff,0x7f44131a,0x00000000,0x00000000}},	//   _ዕለታዊ_, _epiq, --, --, 
   {{0x6ac40881,0x3e7400c0,0xeab000e3,0x00000000}},	//   वत्र, _mäty_, ھٹا_, --, 
   {{0x94080271,0x20d001ca,0xcd2801ac,0x00000000}},	// [e70] ɑbɔ_, báib_, _ڏسجن_, --, 
   {{0x1ee804c3,0x00000000,0x00000000,0x00000000}},	//   _گویی_, --, --, --, 
   {{0xbec800e0,0x6448131b,0x66cc00c0,0xac9401d2}},	//   _dzīļ, yeei, fúkn, _жанш, 
   {{0x6d44131c,0xdcb0080a,0xb4c80095,0x61e4012c}},	//   _ipha, _لىپ_, ोगो_, _úhle, 
   {{0xb8f4131d,0xfe7012a4,0x0ae803a2,0x64480cfa}},	//   _सी_, _شدی_, _درجي_, veei, 
   {{0x3e740932,0xc0f4001d,0x00000000,0x00000000}},	//   _sätz_, ፋለህ_, --, --, 
   {{0x6448002a,0x00000000,0x00000000,0x00000000}},	//   teei, --, --, --, 
   {{0x6d44131e,0x2900131f,0x15401320,0x76580028}},	//   _mpha, mpha_, теъм, advy, 
   {{0x64481321,0x29001322,0x6d44010b,0x00000000}},	//   reei, lpha_, _lpha, --, 
   {{0x64481323,0xe29800c8,0x00000000,0x00000000}},	//   seei, іан_, --, --, 
   {{0x6d4401f3,0xaa5c010f,0x6448006f,0x66cc00c0}},	//   _npha, _ለማሟላ, peei, lúko, 
   {{0xa068005b,0x55b80107,0xd5a400e3,0x00000000}},	//   цама_, _ומעו, _تلمی, --, 
   {{0x6d441324,0x2900072f,0xdd901325,0xdb0802df}},	//   _apha, hpha_, ھور_, ünüi, 
   {{0xdd901326,0x6d4400c4,0x9d440ce1,0x91580095}},	//   پور_, _bpha, мегд, _āśvā, 
   {{0x92901327,0xfbe00c5f,0x00000000,0x00000000}},	//   _јајц, पेनम, --, --, 
   {{0x5f281072,0x2a6c01e7,0x27e80b34,0x8c401328}},	//   _доим_, _ɗebe_, žanj_, кесе, 
   {{0x6d441329,0x92c001b9,0x60d40088,0x69c00085}},	// [e80] _epha, ্দৰ_, _ihym, _ølej, 
   {{0x6d44006f,0x3b00132a,0x9a6806fe,0x00000000}},	//   _fpha, rpiq_, غمال_, --, 
   {{0xceb000b9,0x9948132b,0x00000000,0x00000000}},	//   _ביז_, تلال_, --, --, 
   {{0x7cdc0296,0x2288001e,0x3e740139,0x5ca4021d}},	//   _pōru, _oúko_, _räty_, _цимб, 
   {{0x3b0400d3,0x3b0002b1,0x38c800d5,0x00000000}},	//   _dépò_, qpiq_, _ہاری_, --, 
   {{0x3e7400c0,0x6d4402b0,0xc5100108,0x00000000}},	//   _päty_, _ypha, ھبىت, --, 
   {{0x98a4132c,0x745400d5,0x00000000,0x00000000}},	//   _живе, ٹھائ, --, --, 
   {{0x7cdc0296,0x28f801a7,0x60d40335,0x00000000}},	//   _tōru, _хэрэ_, _nhym, --, 
   {{0x65600616,0x00000000,0x00000000,0x00000000}},	//   _erlh, --, --, --, 
   {{0x3254132d,0x73c4016d,0xd12c0340,0x877800ca}},	//   хвор, мәһе, لۅت_, _ואמי, 
   {{0xd73c0320,0x00000000,0x00000000,0x00000000}},	//   _гiуд, --, --, --, 
   {{0x60d4132e,0x6d4400c4,0x61ec01c8,0x25a8132f}},	//   _chym, _rpha, _şalt, _عدلي_, 
   {{0x6d441330,0xe2a81331,0x00000000,0x00000000}},	//   _spha, _کانن_, --, --, 
   {{0x2bd41332,0x29001333,0x6d44021d,0x60d4006f}},	//   _दरबा, ypha_, _ppha, _ehym, 
   {{0x417008fa,0x00000000,0x00000000,0x00000000}},	//   _لايس, --, --, --, 
   {{0x20d0059b,0x60d400f2,0x00000000,0x00000000}},	//   ráic_, _ghym, --, --, 
   {{0x92c002fa,0x66cc01d4,0x27e801d1,0x20d001ca}},	// [e90] ্দী_, fúkl, žank_, sáic_, 
   {{0x6f0c1334,0x2fc8025e,0x8d840128,0x66cc01d4}},	//   _iwac, _iyag_, _жумд, vúko, 
   {{0x6d44131c,0x6f0c1335,0xdeb0024b,0x7ac401c7}},	//   _upha, _hwac, _сұры, тсте, 
   {{0x29001336,0x6f0c1337,0xa7140041,0x229400d3}},	//   rpha_, _kwac, емді, _kùkù_, 
   {{0x29000034,0x61341338,0xba080108,0x00000000}},	//   spha_, _külç, ستەك_, --, 
   {{0x6f0c08bb,0x29000320,0xaa4406ea,0x92c002fa}},	//   _mwac, ppha_, ävää_, ্দু_, 
   {{0x6f0c0083,0xe8940cd2,0x00000000,0x00000000}},	//   _lwac, _завь, --, --, 
   {{0xc0bc0422,0x6f0c1339,0x2fc80c0d,0x20d00247}},	//   _ሰፊሕ_, _owac, _oyag_, káia_, 
   {{0x27ec133a,0x6f0c0496,0xa2e4133b,0x60d4133c}},	//   _igen_, _nwac, ноид, _rhym, 
   {{0x68e8133d,0x60d4133e,0x00000000,0x00000000}},	//   _hied, _shym, --, --, 
   {{0x68e80066,0x60d40335,0xa0a4133f,0x656002b0}},	//   _kied, _phym, еанд, _urlh, 
   {{0x6f0c1340,0x20540288,0x68e8028d,0xb4e80b0f}},	//   _bwac, хтор, _jied, _قىلم_, 
   {{0x68e81341,0x443c1342,0x6f0c007b,0xdb0405c0}},	//   _mied, mfu_, _cwac, _ómøg, 
   {{0x68e81343,0x64581344,0x00000000,0x00000000}},	//   _lied, _hawi, --, --, 
   {{0x60d41345,0x27ec1346,0x64581347,0x6f0c0996}},	//   _thym, _ogen_, _kawi, _ewac, 
   {{0x68e81348,0x64581349,0x443c134a,0x27ec134b}},	//   _nied, _jawi, nfu_, _ngen_, 
   {{0x6d40134c,0x6458134d,0x443c03a2,0x6f0c134e}},	// [ea0] çlar, _mawi, ifu_, _gwac, 
   {{0x27ec134f,0x64581350,0x201004ca,0x68e80068}},	//   _agen_, _lawi, _heyi_, _aied, 
   {{0x68e81351,0xd7f81352,0x20101353,0x35c40774}},	//   _bied, пул_, _keyi_, _लुढ़, 
   {{0x64581354,0xb5fc0002,0x68e800e0,0x25fc00a1}},	//   _nawi, _inġi, _cied, रुसी_, 
   {{0x6d500828,0x20101355,0x443c11ae,0x00000000}},	//   ādaś, _meyi_, dfu_, --, 
   {{0x20101356,0x27ec1357,0x64581358,0x443c1359}},	//   _leyi_, _egen_, _aawi, efu_, 
   {{0x443c135a,0x68e8135b,0x6458135c,0x00000000}},	//   ffu_, _fied, _bawi, --, 
   {{0x68e8135d,0x6458135e,0x2010135f,0x443c1360}},	//   _gied, _cawi, _neyi_, gfu_, 
   {{0x64581361,0x645c034a,0x36e4001e,0x335400cc}},	//   _dawi, ôsia, _абаҳ, түлө_, 
   {{0x68e81362,0x6f0c1363,0x201000d3,0x443c1364}},	//   _zied, _rwac, _aeyi_, afu_, 
   {{0x20101365,0x6f0c1366,0x13e81367,0x68e80636}},	//   _beyi_, _swac, _емей_, _yied, 
   {{0x64581368,0x6f0c0078,0x443c006a,0x92c002fa}},	//   _gawi, _pwac, cfu_, ্দে_, 
   {{0x20101369,0xb4cc040e,0x00000000,0x00000000}},	//   _deyi_, ळती_, --, --, 
   {{0x645806f7,0x81dc02fa,0x00000000,0x00000000}},	//   _zawi, ধুই_, --, --, 
   {{0x20d00272,0xb810136a,0xc0bc0020,0xf1700122}},	//   máin_, ाराम_, ሰሎም_, _ئێجگ, 
   {{0x27e8136b,0x6f0c0172,0x20d00075,0x64580060}},	//   žani_, _twac, láin_, _xawi, 
   {{0xeeb80063,0x27ec0278,0x6f0c136c,0x6d40011a}},	// [eb0] _олиш_, _rgen_, _uwac, ħlaq, 
   {{0x68e8136d,0x20100181,0x20d00272,0x443c0047}},	//   _sied, _zeyi_, náin_, zfu_, 
   {{0x68e8136e,0x20100271,0x443c136f,0x27ec0249}},	//   _pied, _yeyi_, yfu_, _pgen_, 
   {{0x20d00699,0x26c40212,0x68e8011a,0x88c41370}},	//   háin_, _sklo_, _qied, رتال, 
   {{0x64581371,0x68e81372,0xe7381373,0xed580059}},	//   _rawi, _vied, фел_, āžu_, 
   {{0x64581374,0x68e81375,0xe5a41376,0x443c045f}},	//   _sawi, _wied, кили, wfu_, 
   {{0x68e81377,0x443c1378,0x20d00272,0xdddc01e8}},	//   _tied, tfu_, dáin_, _enpņ, 
   {{0x27ec0184,0x645804db,0x69d41379,0x443c137a}},	//   _ugen_, _qawi, _izze, ufu_, 
   {{0x443c137b,0xe298137c,0x64580068,0x20100078}},	//   rfu_, дап_, _vawi, _reyi_, 
   {{0x64580a1d,0x2010137d,0x20d00272,0x443c137e}},	//   _wawi, _seyi_, gáin_, sfu_, 
   {{0x2010137f,0x443c1380,0x6fe800e0,0xeaec00bd}},	//   _peyi_, pfu_, _līcī, जदुत_, 
   {{0xa0a41381,0x1e0804c7,0x23740075,0x443c1382}},	//   тамд, वर्ष_, _لاتح, qfu_, 
   {{0xe2b40254,0x20d00075,0x612400d5,0x2d8408ad}},	//   _искэ, báin_, رےکہ_, ølen_, 
   {{0x9f9c0c9f,0x20100130,0x69d4007b,0x20d00e10}},	//   _ação_, _weyi_, _ozze, cáin_, 
   {{0x71641383,0xdca41384,0x228802b2,0x00000000}},	//   _مايك, вави, _lúkk_, --, 
   {{0x1f641385,0xeaec0477,0xb92400b8,0xa0c40657}},	//   _аким, जदूत_, pysẽ_, _جيبو, 
   {{0x69d41386,0xdddc00e5,0x00000000,0x00000000}},	// [ec0] _azze, _kopū, --, --, 
   {{0x8a001387,0xdee41388,0x64940306,0x00000000}},	//   изуе, _шопи, _fáig, --, 
   {{0x649400ef,0xd00c0041,0x00000000,0x00000000}},	//   _káid, _الۋ_, --, --, 
   {{0x66cc00c4,0x00000000,0x00000000,0x00000000}},	//   lúkh, --, --, --, 
   {{0x69d400cd,0x16a00329,0x64940306,0x7de800e3}},	//   _ezze, аҳаҭ, _máid, _fésü, 
   {{0x649403e0,0x1dd41389,0xc7a0138a,0xdddc00ce}},	//   _láid, _धरात, шичк, _nopū, 
   {{0xc60800ac,0xd498138b,0x20d001ca,0xe8500061}},	//   _রাখা_, дрп_, váin_, _گۆند, 
   {{0xb4cc00b3,0x058000cc,0x2368015b,0xdb240223}},	//   ळते_, рушм, _šaja_, _òpóp, 
   {{0x7054138c,0x20d00272,0x5eec08e7,0x97c40324}},	//   ۇندا, táin_, _इंग्_, _شترم, 
   {{0x76940029,0x28740116,0x3ce00444,0x38bc03aa}},	//   _bàye, _аӡәы_, hmiv_, víry_, 
   {{0x63ac00ed,0x20d0138d,0x7054138e,0x649401ca}},	//   _þann, ráin_, هندا, _báid, 
   {{0x20d0045d,0x2ebc0fa3,0x64940306,0x5344044a}},	//   sáin_, ोत्त, _ráig, _ахка, 
   {{0x20d0138f,0x8f08070b,0x64940306,0x00000000}},	//   máil_, ьхна_, _dáid, --, 
   {{0x6fe80059,0x20d00075,0x8d741390,0x2fcc03ef}},	//   _rīcī, láil_, پاسا, żego_, 
   {{0x649401ca,0xac941391,0x42500061,0xd17402ba}},	//   _fáid, гавш, _ئۆپر, _шыды, 
   {{0xb5fc043b,0x20d00075,0x64940509,0x7058023f}},	//   _inġu, náil_, _gáid, _чаир_, 
   {{0x09d80095,0x00000000,0x00000000,0x00000000}},	// [ed0] बध्य, --, --, --, 
   {{0x20d0045d,0xc9840329,0x6f1c1392,0xdb24109d}},	//   háil_, куеи, mssc, اولی, 
   {{0x2bd41393,0x6f1c1394,0x1ea803a2,0x66cc03c2}},	//   _दरवा, lssc, _ساٿي_, súkk, 
   {{0xf7700a1d,0xb4cc00b3,0x00000000,0x00000000}},	//   ڪام_, ळतो_, --, --, 
   {{0xfeb81011,0x9cd41395,0x20d003e0,0x6f1c1396}},	//   _سایت_, _תורה_, dáil_, nssc, 
   {{0x2ca81397,0xf7701398,0xd7640340,0x6e340361}},	//   liad_, تام_, دەكى_, ngzb, 
   {{0x64a41399,0x8880031b,0xdbd80152,0xe7f400aa}},	//   лака, _پیشن, _eçäk, ुँदा_, 
   {{0x20d0045d,0x2ca80ca0,0x6378139a,0x224801c6}},	//   gáil_, niad_, есор_, _ŝak_, 
   {{0x228802e8,0x6494059b,0xf4840ce1,0x638400b7}},	//   _húki_, _ráid, рујн, угпа, 
   {{0x2ca8139b,0x68f401d9,0x6f1c139c,0x85a40106}},	//   hiad_, _kuzd, dssc, _ијед, 
   {{0xe434139d,0x6f1c000b,0x20d0059b,0xe3c400bf}},	//   _مفاد, essc, báil_, _өрдү, 
   {{0x68f4139e,0x20d003e0,0x27e80070,0x6f1c0e48}},	//   _muzd, cáil_, žanu_, fssc, 
   {{0x2ca80f32,0x10a0139f,0x3f840a03,0x6f1c13a0}},	//   diad_, сиян, âmu_, gssc, 
   {{0x248c02ef,0x61e400bd,0xa29c00bd,0x00000000}},	//   lkem_, _úhlo, _ओगट्, --, 
   {{0x2ca8009c,0xdcb013a1,0x6f1c006f,0x68f400e9}},	//   fiad_, مىس_, assc, _nuzd, 
   {{0x2ca80ca0,0xaa700090,0x7d1c13a2,0x1be813a3}},	//   giad_, _ለማረጋ, rsrs, едби_, 
   {{0x2b580043,0x3958028d,0x6f1c02b0,0x509001ac}},	// [ee0] _cssc_, _ssrs_, cssc, _دليء, 
   {{0x248c0310,0x68f413a4,0x60c4061a,0x395800d4}},	//   hkem_, _buzd, lokm, _psrs_, 
   {{0xdca413a5,0x248c0fdc,0x2ca80336,0x81c00143}},	//   _бани, kkem_, biad_, ্শক_, 
   {{0x68f413a6,0x2ca80323,0x395801f6,0x649401ca}},	//   _duzd, ciad_, _vsrs_, _láib, 
   {{0x248c00aa,0xc60802fa,0x91c800b6,0x236801d1}},	//   dkem_, _রাজা_, _सुनै, _šajn_, 
   {{0x248c13a7,0x60c40197,0x3a380105,0x395800e5}},	//   ekem_, hokm, _ucrp_, _tsrs_, 
   {{0x20d0045d,0x60c4005e,0x68f401df,0x00000000}},	//   táil_, kokm, _guzd, --, 
   {{0xd37802e5,0x00000000,0x00000000,0x00000000}},	//   ечо_, --, --, --, 
   {{0x20d0045d,0xb2b804e7,0x60c403aa,0xd7d00061}},	//   ráil_, клиф_, dokm, _اڵاک, 
   {{0x2ca80d7f,0x20d003e0,0x68f413a8,0xcb5400ca}},	//   ziad_, sáil_, _yuzd, נסיה_, 
   {{0xd1480ae1,0x20d0059b,0x649401ca,0xd1d0001d}},	//   رشدن_, páil_, _dáib, ረፍት_, 
   {{0x6f1c114c,0x248c13a9,0x2ca80039,0x63800116}},	//   tssc, ckem_, xiad_, сҳәа, 
   {{0xb4c013aa,0x6d5413ab,0x6f1c13ac,0x03a00673}},	//   ंकी_, wwza, ussc, _лицо, 
   {{0x2ca8045b,0x6f1c13ad,0x20bc01e5,0x00000000}},	//   wiad_, rssc, ọkpụ_, --, 
   {{0x3d940155,0x2ca80336,0x60c4021d,0xac180d3e}},	//   бирр, tiad_, bokm, кову_, 
   {{0x2b5803f2,0x81a802fa,0x2ca80151,0x6f1c13ae}},	//   _pssc_, _খরচ_, uiad_, pssc, 
   {{0x68f413af,0x2ca813b0,0x64940329,0xb5fc011a}},	// [ef0] _suzd, riad_, _háic, _gaġg, 
   {{0x2ca8009c,0x68f413b1,0x228806b4,0x00000000}},	//   siad_, _puzd, _púki_, --, 
   {{0x2ca813b2,0xc0f4010f,0x00000000,0x00000000}},	//   piad_, ፋፈል_, --, --, 
   {{0x764813b3,0xf77000dd,0x68f40152,0x6c7800cf}},	//   _abdy, ڻان_, _vuzd, _סאָפ, 
   {{0xdc3400b9,0x61d013b4,0x2cb8015b,0x27fc0335}},	//   _דארט_, _हर्ष, _ijsd_, rcwn_, 
   {{0x68f413b5,0x00000000,0x00000000,0x00000000}},	//   _tuzd, --, --, --, 
   {{0x248c13b6,0x60c40337,0xa2b40095,0xb4c00e8f}},	//   tkem_, yokm, ैकस्, ंकू_, 
   {{0x64940306,0x3218018f,0x38c80094,0x00000000}},	//   _sáib, аryo_, _буун_, --, 
   {{0x248c13b7,0x2a70018c,0xa9a40108,0x98a401c4}},	//   rkem_, _knzb_, _сиңд, _турҙ, 
   {{0x248c13b8,0x36340046,0x64940306,0x13e4006b}},	//   skem_, _هرمس, _báic, шмый_, 
   {{0xe0d813b9,0x614413ba,0x05440128,0x2a6001ca}},	//   кво_, шена, _сүйл_, idhb_, 
   {{0x6e240011,0x00000000,0x00000000,0x00000000}},	//   _adhb, --, --, --, 
   {{0xa3e813bb,0x1ea80324,0x6494059b,0x98780100}},	//   _मणि_, ناسي_, _táib, דארט, 
   {{0x60c40a65,0x53980107,0xc1b00116,0xd36c13bc}},	//   sokm, _בינו, _гәмы, _آهو_, 
   {{0x212403b5,0x60c40210,0x5de40668,0x00000000}},	//   _ڵبژێ, pokm, ржва, --, 
   {{0x91b8023c,0x00000000,0x00000000,0x00000000}},	//   _במצי, --, --, --, 
   {{0x63ac13bd,0xcc140182,0xaf4801d9,0x0c340075}},	// [f00] _žanj, рчсө, _یشیل_, شكلة_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd8380396,0x2a700299,0x5fa80608,0xf1b8011a}},	//   вэл_, _dnzb_, _चेतल, raġg_, 
   {{0xb5fc0126,0xdddc00f1,0x2d9413be,0xd1d00020}},	//   _maġe, _rapň, _ырыс, ረፍቲ_, 
   {{0x769400d3,0x47300302,0x66cc0116,0xc7a002c2}},	//   _aàya, жніс, húku, оицк, 
   {{0xd05c0387,0x00000000,0x00000000,0x00000000}},	//   _diqə, --, --, --, 
   {{0x66cc0f34,0x00000000,0x00000000,0x00000000}},	//   júku, --, --, --, 
   {{0xd70413bf,0xb4c00cd4,0x228800c0,0x132c001d}},	//   _взаи, ंके_, _múku_, _በነጻነ, 
   {{0x228801d4,0x00000000,0x00000000,0x00000000}},	//   _lúku_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x09f40240,0x00000000,0x00000000,0x00000000}},	//   ימים_, --, --, --, 
   {{0xdcec02b3,0x672c13c0,0x93e401a0,0x629c0128}},	//   mybė, šaje, _кўлл, èsor, 
   {{0xbfa813c1,0x6b4801c6,0xdcec0023,0xd14801d9}},	//   атре_, _oɾga, lybė, رشگن_, 
   {{0xc0cc0090,0x228807d4,0x6b5c0085,0x00000000}},	//   _አየር_, _búku_, _lægå, --, 
   {{0xdcec0007,0x64940247,0xabe00200,0x8e7c001d}},	//   nybė, _uáic, ﻋﯩﻨﺎ, _ያገኛሉ_, 
   {{0x30140396,0x228800c4,0x00000000,0x00000000}},	//   _удир, _dúku_, --, --, 
   {{0x91c80224,0x3c580254,0xebc400c3,0x6100015b}},	// [f10] _सुतै, шитэ_, сәнн, _vēle, 
   {{0xdcec0007,0x3a74009e,0x63ac00e9,0xba740027}},	//   kybė, олур, _žank, огущ, 
   {{0xd36413c2,0x1618002f,0x29040037,0x61000034}},	//   _که_, _नज़र_, _ħlas_, _tēle, 
   {{0xb4c013c3,0x684402ac,0x4ba40128,0x6c540128}},	//   ंको_, ёнла, _көзү_, _укму, 
   {{0xdd140031,0xd12400ea,0x00000000,0x00000000}},	//   _käşg, _ډم_, --, --, 
   {{0x6b8c00cb,0x00000000,0x00000000,0x00000000}},	//   myag, --, --, --, 
   {{0xdd1401c8,0xe56800e7,0xdcec0023,0xc794001e}},	//   _mäşg, امبى_, gybė, ырҧы, 
   {{0xe4580590,0xb5fc0002,0x6b8c074e,0xb83400fc}},	//   ужи_, _raġe, oyag, _месщ, 
   {{0x13040673,0xf7940023,0x00000000,0x00000000}},	//   бный_, _датэ, --, --, 
   {{0x6b8c0616,0x66cc0247,0x25fc0098,0x00000000}},	//   iyag, túku, रुखी_, --, 
   {{0x91c8006c,0x60e80106,0xf65000cc,0x00000000}},	//   _सुदै, лмом_, _زئل_, --, 
   {{0x65cc0012,0x6b8c13c4,0x10a002dc,0x93100122}},	//   ीपà_, kyag, зиюн, _کووش, 
   {{0x23280a3a,0x6b8c04f8,0x630413c5,0xdd1402e6}},	//   _соли_, jyag, _اوتل, _bäşg, 
   {{0xf4840121,0xb5fc0126,0xc20c0012,0x00000000}},	//   _гуән, _taġe, _کٔژ_, --, 
   {{0x753c06ef,0xdcf813c6,0x6b8c0472,0x3178000b}},	//   _ärzt, افرت_, eyag, ärzt_, 
   {{0x307403d6,0x00000000,0x00000000,0x00000000}},	//   _дуьс, --, --, --, 
   {{0x5f4401b8,0x6b8c13c7,0xdddc01d5,0x00000000}},	// [f20] _انخل, gyag, _topů, --, 
   {{0x78101093,0x00000000,0x00000000,0x00000000}},	//   ार्क_, --, --, --, 
   {{0x6b8c0cfa,0x00000000,0x00000000,0x00000000}},	//   ayag, --, --, --, 
   {{0xdcec0007,0x6b8c13c8,0x200003ef,0x00000000}},	//   vybė, byag, ncki_, --, 
   {{0x6b8c13c9,0xcb40010f,0x958401d2,0x00000000}},	//   cyag, ንተርኔ, өлде, --, 
   {{0xdcec0822,0x386000e9,0xb4c0025c,0x00000000}},	//   tybė, žir_, ंक्_, --, 
   {{0x22880028,0x00000000,0x00000000,0x00000000}},	//   _lúks_, --, --, --, 
   {{0x629c0222,0xf4840324,0x9f5000f2,0xd8b400ea}},	//   ëson, تاتی, _egyé_, _امرخ, 
   {{0xd6d013ca,0xdcec00e5,0x00000000,0x00000000}},	//   _فقر_, sybė, --, --, 
   {{0x32180c75,0xd25813cb,0x00000000,0x00000000}},	//   úry_, уци_, --, --, 
   {{0xe6b40012,0x66cc03c2,0x6b8c0055,0x920000a8}},	//   _ظلمگ, rúkt, zyag, _ũāsa, 
   {{0x6b8c13cc,0x64940306,0x00000000,0x00000000}},	//   yyag, _háin, --, --, 
   {{0xe8180227,0x13f40098,0x00000000,0x00000000}},	//   दरता_, ीडीह_, --, --, 
   {{0x0dc813cd,0x20000353,0xc3240075,0xf19413ce}},	//   губи_, acki_, _اكون_, _миль, 
   {{0x64940075,0x6b8c007b,0x25fc0b13,0x816400e5}},	//   _máin, wyag, रुटी_, _грыб_, 
   {{0x6b8c13cf,0x63ac13d0,0x64940306,0xaa70001d}},	//   tyag, _žani, _láin, _ለማሸጋ, 
   {{0xcf24138e,0x8af403b4,0x00000000,0x00000000}},	// [f30] _اربي, _şəba, --, --, 
   {{0x6b8c13d1,0x6494030f,0x00000000,0x00000000}},	//   ryag, _náin, --, --, 
   {{0x2bd40d54,0xad4000e7,0xc864022e,0x00000000}},	//   _दरका, _تۉزۉ, йтди, --, 
   {{0x66cc0407,0x63ac01ec,0xc6a413d2,0x6100015b}},	//   júkr, _ýang, әрди, _jēla, 
   {{0x41cc13d3,0x649401ca,0x69b813d4,0x00000000}},	//   _सुनस, _báin, ्थही, --, 
   {{0x64940075,0x63ac06b4,0x00000000,0x00000000}},	//   _cáin, _þani, --, --, 
   {{0x649413d5,0x200013d6,0xdaa00108,0x00000000}},	//   _dáin, ycki_, _تەلپ, --, 
   {{0x25fc13d7,0x6d4013d8,0x00bc080a,0x20d00306}},	//   रुजी_, çlay, ﻧﺎﺗﺘ, láiv_, 
   {{0x64940272,0xe2980123,0x00000000,0x00000000}},	//   _fáin, иаи_, --, --, 
   {{0x649401ca,0x66cc02e8,0x00000000,0x00000000}},	//   _gáin, rúks, --, --, 
   {{0xdb040038,0xa1c40393,0x160003bf,0x00000000}},	//   _ómög, юбод, _र्टर_, --, 
   {{0x7de00223,0x6100015b,0xa91008e7,0x00000000}},	//   _lásí, _cēla, डीएफ_, --, 
   {{0x2d8413d9,0x6448021d,0x430813da,0x610000ce}},	//   älen_, mfei, _схем_, _dēla, 
   {{0x216813db,0x644813dc,0xdddc0254,0xae0400ec}},	//   _вики_, lfei, _nopţ, зорҙ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x644813dd,0xdee400f8,0x1c440007,0xceb400ec}},	//   nfei, соҳи, ўнам, йҙө_, 
   {{0xbbb4006c,0x644813de,0x92f00055,0x63ac00fc}},	// [f40] ंपेक, ifei, _üğüm, _ýand, 
   {{0x7cf80237,0x62800c0d,0x6d400177,0x64480086}},	//   _aŭre, njlo, àlac, hfei, 
   {{0x358c0422,0x7de00223,0x588413df,0x649401ca}},	//   ንያታት_, _dásí, жыла, _ráin, 
   {{0x20c811c3,0x64480028,0x64940306,0x00000000}},	//   रविध, jfei, _sáin, --, 
   {{0x7de013e0,0x2ca403f4,0x64480335,0x00000000}},	//   _fásí, ëlde_, dfei, --, 
   {{0x7cf801c6,0x5504009e,0x00000000,0x00000000}},	//   _eŭre, очиа, --, --, 
   {{0xd49813e1,0x86c00a12,0xc92400f5,0x15b8012b}},	//   ири_, بيون, _морж_, шыды_, 
   {{0x64480008,0xb1980014,0x7f440083,0x672c13e2}},	//   gfei, _ngưỡ, _oqiq, šaja, 
   {{0x6494059b,0x569400ec,0x00000000,0x00000000}},	//   _táin, _һаҡт, --, --, 
   {{0x3b000008,0x386401d5,0x228801d4,0x6494059b}},	//   iqiq_, _hamr_, _súkr_, _háil, 
   {{0x386401e7,0xc0f402b4,0x999813e3,0x7f4413e4}},	//   _kamr_, ጋገሪ_, kapō_, _aqiq, 
   {{0x765813e5,0x92c800ac,0x64480086,0x00000000}},	//   levy, লগে_, cfei, --, 
   {{0x61000025,0x649401ca,0xff040668,0x630000c3}},	//   _vēla, _máil, дясн, _كۈيل, 
   {{0x765803a2,0x3b0013e6,0xbbb400b3,0x00000000}},	//   nevy, dqiq_, ंपैक, --, 
   {{0xbd6813e7,0x7f440083,0x2ee00243,0xc0bc02b4}},	//   орте_, _eqiq, _vhhf_, ደሎም_, 
   {{0x765813e8,0x321c034a,0x90e413e9,0x00000000}},	//   hevy, _hevy_, _بستن, --, 
   {{0x765813ea,0x610000e0,0x4a7401c4,0x00000000}},	// [f50] kevy, _jēln, ҙыҡт, --, 
   {{0x321c0329,0x69b800aa,0x753801d5,0x00000000}},	//   _jevy_, ्थली, kuvz, --, 
   {{0x27880340,0x64480336,0x6494059b,0x220002b2}},	//   өрдү_, yfei, _báil, _hæhó_, 
   {{0x6d4413eb,0x649403e0,0x3864028b,0x6448000b}},	//   _iqha, _cáil, _camr_, xfei, 
   {{0x64940272,0xca74002c,0x2d9013ec,0x1ee803f5}},	//   _dáil, _һуңы, lyze_, _خویی_, 
   {{0x96600041,0xc0f400a7,0x321c01d4,0x00000000}},	//   екше, ጋገሩ_, _nevy_, --, 
   {{0x499013ed,0x649403e0,0x855413ee,0x64480b1e}},	//   _تیار, _fáil, تیار_, tfei, 
   {{0x233400c3,0x20d00f3c,0x9200004f,0x00000000}},	//   пхор, náit_, _ũāpa, --, 
   {{0x644813ef,0xe3b003e0,0x765813f0,0x321c006f}},	//   rfei, عرب_, bevy, _bevy_, 
   {{0xe29806d4,0x644813f1,0x6d4413f2,0x7f440560}},	//   сао_, sfei, _oqha, _rqiq, 
   {{0x29000b68,0x644813f3,0x649400b8,0xe4e401a7}},	//   nqha_, pfei, _háim, _есдү, 
   {{0x69d40222,0x386401e3,0xa1b8018f,0x00000000}},	//   _myze, _xamr_, _қулф_, --, 
   {{0x6d4413f4,0x29000105,0x69d40201,0x00000000}},	//   _aqha, hqha_, _lyze, --, 
   {{0xa5280560,0x00000000,0x00000000,0x00000000}},	//   _ལྷོག_, --, --, --, 
   {{0x649403e0,0x99980299,0x63ac0101,0x00000000}},	//   _láim, tapō_, _ýanb, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d4408b7,0x46c813f5,0x999800a2,0x6494059b}},	// [f60] _eqha, िवाह, rapō_, _ráil, 
   {{0xc0f40117,0x5cf40d15,0x6494059b,0x2d9000c0}},	//   ጋገር_, _няму, _sáil, byze_, 
   {{0x649400b8,0xae0413f6,0x8df800ca,0x2d8413f7}},	//   _páil, _توپى, _להית, ølet_, 
   {{0x20d013f8,0x69d413f9,0x629c0020,0xbc7413fa}},	//   máis_, _dyze, ësoj, _تۇرب, 
   {{0x765813fb,0x672c0ddc,0x3b00015e,0x20d001ca}},	//   tevy, šajn, qqiq_, láis_, 
   {{0x35d413fc,0x6494059b,0x00000000,0x00000000}},	//   молё, _dáim, --, --, 
   {{0x321c13fd,0x64940272,0x765813fe,0x20d013ff}},	//   _revy_, _táil, revy, náis_, 
   {{0x321c0932,0x753800ef,0xd3a41400,0x00000000}},	//   _sevy_, ruvz, зроп, --, 
   {{0x321c001e,0xd62800df,0x07a01401,0x20d001ca}},	//   _pevy_, _гозе_, _затн, háis_, 
   {{0xcb100107,0x610000d4,0x00000000,0x00000000}},	//   עלת_, _cēlo, --, --, 
   {{0x9f501402,0x59bc1403,0x20d004ac,0x30340027}},	//   _ngyâ_, ्थिर, jáis_, менё, 
   {{0x25640012,0x20d01404,0x610000ce,0x814000d5}},	//   _زامُ, dáis_, _tēln, ڈنین, 
   {{0x814012a4,0xdddc00b0,0xcb180440,0x00000000}},	//   ونین, _ropš, _पौंड_, --, 
   {{0xdddc0091,0x20d001ca,0x00000000,0x00000000}},	//   _sopš, fáis_, --, --, 
   {{0xad240256,0x20d01405,0x00000000,0x00000000}},	//   بىزى, gáis_, --, --, 
   {{0x2d9000f1,0xc1b800ca,0x00000000,0x00000000}},	//   ryze_, _למוש, --, --, 
   {{0x290008df,0x69d40475,0x20d00f3c,0xff500ac9}},	// [f70] wqha_, _syze, ráit_, _یخی_, 
   {{0x6f0c1406,0x64940306,0x20d00335,0x2d840085}},	//   _itac, _ráim, sáit_, øles_, 
   {{0xb5fc0c89,0x6d441407,0x962002fa,0xdde800e2}},	//   _paġn, _uqha, নলাম_, _ورپه_, 
   {{0xdddc1408,0x20d00272,0x69d4018b,0x00000000}},	//   _uopš, láir_, _vyze, --, 
   {{0x29001409,0x69d40098,0x00000000,0x00000000}},	//   sqha_, _wyze, --, --, 
   {{0x20d003e0,0xa5280002,0x6f0c042e,0x69d4028d}},	//   náir_, _ལྷུག_, _mtac, _tyze, 
   {{0x644c0116,0x24e80bb4,0x2900011a,0x00000000}},	//   _ñaik, омки_, qqha_, --, 
   {{0x649403e0,0xc21c02e0,0x00d80121,0x6f0c140a}},	//   _táim, _मजहब_, ﯟﺍﺗﻘ, _otac, 
   {{0x6f0c140b,0x86b0024b,0x20d003b2,0xa2e4140c}},	//   _ntac, _пәкі, záis_, моид, 
   {{0x20d0140d,0x67280379,0xc0cc001d,0x4abc03ec}},	//   yáis_, _ivej, _አየሁ_, ्विव, 
   {{0x61000059,0xb3840182,0x5bb8140e,0x2b480bdd}},	//   _vēlo, длөл, _इश्व, htac_, 
   {{0xe2f80256,0x20d00964,0x00000000,0x00000000}},	//   _деді_, váis_, --, --, 
   {{0x10a0140f,0x93600551,0x4abc0c4f,0x2b480105}},	//   тиян, _аҭыҧ, ्वाव, jtac_, 
   {{0x12f80240,0x443c1410,0x20d01411,0x672800ba}},	//   _והסב, lgu_, táis_, _mvej, 
   {{0xdcb01412,0x443c1413,0x6f0c1414,0x236c0056}},	//   نىس_, ogu_, _etac, lvej_, 
   {{0x20d003e0,0x67281415,0x236c00c0,0x00000000}},	//   ráis_, _ovej, ovej_, --, 
   {{0x9f041416,0x443c1417,0x8c4000df,0x236c0c8f}},	// [f80] _توخو, igu_, ъете, nvej_, 
   {{0x7cf80237,0x629c0020,0x443c1418,0xb5fc043b}},	//   _eŭra, ësoh, hgu_, _raġo, 
   {{0xaf580090,0x443c1419,0xd7f8009e,0xfe1402ef}},	//   ያደርገ, kgu_, оул_, _त्यस_, 
   {{0x236c0353,0x00000000,0x00000000,0x00000000}},	//   kvej_, --, --, --, 
   {{0x7c24141a,0x2dd401ee,0xbab400e7,0x236c0085}},	//   mair, ﺘﯩﻠﻤ, _كۅرب, jvej_, 
   {{0x7c24141b,0x443c141c,0x6728141d,0x236c141e}},	//   lair, egu_, _dvej, dvej_, 
   {{0xd82407ac,0x249c0335,0x090000b8,0x236c0085}},	//   _одви, _blwm_, _апсн, evej_, 
   {{0x7c24141f,0x443c1420,0x09e01421,0x38c81422}},	//   nair, ggu_, _росн, _رازی_, 
   {{0x61ec01c6,0x236c0353,0x81a800dc,0x00000000}},	//   _ĝala, gvej_, _কুল_, --, 
   {{0x7c241423,0x443c1424,0x6f0c02ac,0x00000000}},	//   hair, agu_, _rtac, --, 
   {{0x7c241425,0x67281426,0x6f0c1427,0xca3400ca}},	//   kair, _zvej, _stac, וניה_, 
   {{0x7c241428,0xe7f4021f,0x249c0086,0x6f0c011e}},	//   jair, ुँचा_, _glwm_, _ptac, 
   {{0x7c241429,0x53e0142a,0xdddc0098,0x20d00306}},	//   dair, _परिश, _napł, táir_, 
   {{0x7694038a,0x6f0c01d4,0x8d740012,0x63ac00fc}},	//   _bàyi, _vtac, ٘ارا, _ýana, 
   {{0x7c24142b,0x8c6400e7,0xac180123,0xbdd40027}},	//   fair, мтад, зобу_, ворщ, 
   {{0x6f0c070b,0x7c24142c,0x20d00306,0x00000000}},	//   _ttac, gair, sáir_, --, 
   {{0x6f0c142d,0xfbd00075,0xaed401f1,0x4fc4012b}},	// [f90] _utac, لتك_, _поиш, _юска, 
   {{0x443c142e,0x7c240247,0x00000000,0x00000000}},	//   zgu_, aair, --, --, 
   {{0x7c24142f,0x443c1430,0x67281431,0xac9401a7}},	//   bair, ygu_, _svej, _занш, 
   {{0x7c241432,0x4b940090,0xe8c80698,0x672c1433}},	//   cair, መልክቶ_, िकेच, šajm, 
   {{0xfe700191,0x443c02bb,0x00000000,0x00000000}},	//   _صدی_, vgu_, --, --, 
   {{0x443c1434,0x7f3c0100,0x236c1435,0x00000000}},	//   wgu_, קעוו, vvej_, --, 
   {{0xdddc002f,0xe2981436,0xfd6400a8,0x249c03c7}},	//   _zapł, җан_, _bhuṃ, _plwm_, 
   {{0xfdf80240,0x443c1437,0x67d411de,0xa4441438}},	//   וצות_, ugu_, _зобу, хнид, 
   {{0x61000059,0x67281439,0x60280247,0x00000000}},	//   _vēlm, _uvej, hêmí, --, 
   {{0x7c24143a,0x443c0ca0,0x236c143b,0x00000000}},	//   zair, sgu_, rvej_, --, 
   {{0x236c0184,0xa068143c,0x7c24143d,0xb524044a}},	//   svej_, пана_, yair, _аьчк, 
   {{0x7c2401ab,0x236c0c8f,0x8af403b4,0xa06801c3}},	//   xair, pvej_, _şəla, чама_, 
   {{0x442c143e,0xc0cc010f,0xa29401f5,0x41cc143f}},	//   _idg_, _አየለ_, _паді, _सुरस, 
   {{0x7c241440,0x442c0932,0xdea002ac,0x00000000}},	//   wair, _hdg_, ایدی, --, 
   {{0x7c241441,0x008400df,0x442c002a,0xdc981442}},	//   tair, _акйү, _kdg_, пташ_, 
   {{0xda641443,0x442c1444,0x27e803aa,0x00000000}},	//   کاري, _jdg_, žany_, --, 
   {{0x442c1445,0x5ba81446,0x6fe800e0,0xda581058}},	// [fa0] _mdg_, чкам_, _cūcī, зреш_, 
   {{0xd00c1447,0x4a401448,0x00000000,0x00000000}},	//   _پلی_, лнув, --, --, 
   {{0x442c1449,0x00000000,0x00000000,0x00000000}},	//   _odg_, --, --, --, 
   {{0x442c144a,0xdca4144b,0x5ca40dc4,0x4c800b1e}},	//   _ndg_, _чами, _чимб, _блюв, 
   {{0x2904144c,0x00000000,0x00000000,0x00000000}},	//   _élan_, --, --, --, 
   {{0x442c144d,0x6100015b,0x00000000,0x00000000}},	//   _adg_, _cēlk, --, --, 
   {{0x38c813ed,0x442c00c6,0x60d4001e,0x98a40108}},	//   _قاری_, _bdg_, _okym, _зиве, 
   {{0x94a800e5,0x67480207,0x52b803bf,0x00000000}},	//   ятла_, ösjö, ैक्स, --, 
   {{0x442c144e,0x78a006b4,0x00000000,0x00000000}},	//   _ddg_, _ilmv, --, --, 
   {{0x442c144f,0x60d400df,0x91e01450,0x00000000}},	//   _edg_, _akym, ләйһ, --, 
   {{0x442c1451,0x63ac0031,0xc1b40094,0x00000000}},	//   _fdg_, _ýann, елэх_, --, 
   {{0x3958040e,0x312400e7,0x442c0086,0x00000000}},	//   _mprs_, ндүг, _gdg_, --, 
   {{0x7cf800cf,0xb5fc0560,0x44740100,0xd25013bc}},	//   _aŭro, _raġj, _רעדל_, _منش_, 
   {{0x92dc0252,0x7c94020d,0x442c015e,0x8d8401d9}},	//   _দূৰ_, ۇشقا, _zdg_, нубд, 
   {{0x41701452,0x6fe801d3,0x00000000,0x00000000}},	//   _مايس, _sūcī, --, --, 
   {{0x29040247,0x6fe8015b,0x442c02a0,0x41d800ca}},	//   _ũlao_, _pūcī, _xdg_, _מחוס, 
   {{0x7cf800b9,0xebc40cf6,0x6fb80302,0x6ad802fa}},	// [fb0] _eŭro, тәнн, _ігор_, _ভূগো, 
   {{0x8d8401d9,0x00000000,0x00000000,0x00000000}},	//   _зумд, --, --, --, 
   {{0xdeb00200,0x69c01453,0x64940306,0x7ac41454}},	//   _тұры, _žleb, _iáiv, усте, 
   {{0x6494001e,0x00000000,0x00000000,0x00000000}},	//   _háiv, --, --, --, 
   {{0x442c1455,0x220401e3,0x877001d2,0x00000000}},	//   _rdg_, 壮hma_, ығаш, --, 
   {{0xf5480661,0x2b580043,0x442c0177,0xe81003ef}},	//   _ዘይኮነ, _ipsc_, _sdg_, _ड्रा_, 
   {{0x442c1456,0x64a41457,0x56901458,0x00000000}},	//   _pdg_, кака, рајт, --, 
   {{0x29101459,0x61ec01c6,0xe39801c3,0x00000000}},	//   _itza_, _ŝalo, дњој_, --, 
   {{0xfa240252,0xa6f400fc,0x68e802b0,0xa6c801d2}},	//   _পাতল_, _азаш, _ihed, _قورل_, 
   {{0x60d4145a,0x442c01e5,0xb9280048,0x610000e0}},	//   _skym, _wdg_, _nhuệ_, _hēli, 
   {{0xa0a40332,0x442c02ba,0x68e8145b,0x39580139}},	//   ванд, _tdg_, _khed, _xprs_, 
   {{0x442c145c,0x68e8145d,0x00480046,0x6100015b}},	//   _udg_, _jhed, ریخي_, _jēli, 
   {{0x6264145e,0x68e8145f,0x840400f2,0x00000000}},	//   _авла, _mhed, _esőé, --, 
   {{0x68e8006f,0x63a80151,0x00000000,0x00000000}},	//   _lhed, mzen, --, --, 
   {{0xdef800df,0x63a81460,0x26d801ab,0x68e80207}},	//   зың_, lzen, _ësou_, _ohed, 
   {{0x3958017b,0x68e8006f,0x6dbc00b8,0x60d40031}},	//   _rprs_, _nhed, _ẽkõi, _ukym, 
   {{0x63a81461,0x1ec80155,0x644c007f,0xc0c0001d}},	// [fc0] nzen, _олии_, _ñaiu, ቶአል_, 
   {{0x68e81462,0x63a80d7f,0xfce4002c,0x7be80152}},	//   _ahed, izen, тоғо, _ıruı, 
   {{0x68e8076f,0x3eb81463,0x63a81464,0x2d940074}},	//   _bhed, mirt_, hzen, _бряс, 
   {{0x68e81465,0x26c40237,0x7794031b,0x38c81466}},	//   _ched, _ajlo_, هیزا, راضی_, 
   {{0x68e81467,0x63a81468,0x610000d4,0x3eb81469}},	//   _dhed, jzen, _dēli, oirt_, 
   {{0x63a8146a,0x68e811b9,0xc6f4021d,0x00000000}},	//   dzen, _ehed, вніх_, --, 
   {{0x68e80d62,0x63a8146b,0xb5fc0002,0xd9e41095}},	//   _fhed, ezen, _jaġi, _करित_, 
   {{0x3eb8146c,0x7afc146d,0x68e80437,0xb5fc043b}},	//   hirt_, _hirt, _ghed, _maġi, 
   {{0x44f41049,0x63ac02e6,0x96640027,0x00000000}},	//   خروج_, _ýanl, _икае, --, 
   {{0x7afc146e,0x07a0146f,0xd9e40c14,0xa35400ea}},	//   _jirt, _таун, _करात_, اريږ, 
   {{0x63a81470,0x7afc07e0,0x00000000,0x00000000}},	//   azen, _mirt, --, --, 
   {{0x228802cc,0xdddc015b,0x68e802bb,0x08ac0229}},	//   _múky_, _kapņ, _xhed, _àìtó_, 
   {{0x63a81471,0x7afc1472,0x228802cc,0xb4c003bf}},	//   czen, _oirt, _lúky_, ूकी_, 
   {{0x90ac00cb,0x71741473,0x7afc013c,0x3eb81474}},	//   dṛśy, _مهتا, _nirt, girt_, 
   {{0xb5fc0002,0xc0bc02b4,0xdddc0078,0x00000000}},	//   _baġi, _ደጊም_, _lapņ, --, 
   {{0x7afc045d,0x3eb80f56,0x672c0059,0xfbd0009d}},	//   _airt, airt_, šaji, ښتل_, 
   {{0x68e8009c,0x7afc1475,0x6b741476,0x3eb81477}},	// [fd0] _rhed, _birt, ылау, birt_, 
   {{0x64940272,0x3eb8059b,0x610000e0,0x29c800ec}},	//   _háit, cirt_, _sēli, нтеү_, 
   {{0x68e81478,0x63a81479,0x88c4147a,0x7afc147b}},	//   _phed, zzen, پتال, _dirt, 
   {{0x7afc147c,0x63a807e1,0x8c6401d2,0x7ce80247}},	//   _eirt, yzen, _جەرل_, tÿre, 
   {{0xf77003a2,0x61000059,0x64940075,0xfb84012b}},	//   ٺان_, _vēli, _máit, _кырн, 
   {{0xf770147d,0x6494045d,0x4aa4147e,0x68e8147f}},	//   غان_, _láit, _गतिव, _whed, 
   {{0x68e81480,0x6fd40021,0x355801b8,0x6e241481}},	//   _thed, _युसू, نسٹھ_, _mehb, 
   {{0x63a81482,0x76480a65,0x6e241483,0x7afc01aa}},	//   tzen, _ecdy, _lehb, _zirt, 
   {{0x7afc1484,0x63a80852,0x00000000,0x00000000}},	//   _yirt, uzen, --, --, 
   {{0x63a81485,0x7afc01b5,0x6e240156,0x9f4c0039}},	//   rzen, _xirt, _nehb, _énéh_, 
   {{0x63a81486,0x60cc0282,0xe2981487,0xe1940254}},	//   szen, _ĉamb, _җай_, урпэ, 
   {{0x23741488,0x3eb80e48,0x649401ca,0x1fa800fc}},	//   _ماتح, wirt_, _cáit, екми_, 
   {{0x6e2409a2,0x2b4c0932,0xd12c0a61,0x6494059b}},	//   _behb, _äech_, يمی_, _dáit, 
   {{0x61441489,0xc0bc0020,0x3eb80177,0x9d4400fc}},	//   _бека, _ደጊመ_, uirt_, легд, 
   {{0x6e24043b,0xdca4148a,0x649401ca,0xd24c148b}},	//   _dehb, гави, _fáit, _رني_, 
   {{0x7afc148c,0xe724049d,0x33b0006e,0x6100034c}},	//   _sirt, _وڵ_, _دەۋر, _cœle, 
   {{0x7afc148d,0x3eb802b4,0x64940075,0xb5fc0560}},	// [fe0] _pirt, pirt_, _háis, _vaġi, 
   {{0x9a68148e,0x9e64148f,0x7afc0012,0x6e24002a}},	//   عمال_, _свод, _qirt, _gehb, 
   {{0x7afc1490,0xdddc0059,0xc0bc02b4,0x61ec01c6}},	//   _virt, _sapņ, _ደጊሙ_, _ŝalj, 
   {{0x7afc1491,0x64940272,0x98d81492,0xd8241493}},	//   _wirt, _máis, رباز_, удди, 
   {{0x3ce01494,0xd6d8001e,0x13e00095,0x00000000}},	//   mliv_, нтк_, _परेभ, --, 
   {{0x7afc1495,0x47c800e2,0x3ce01496,0x0538001d}},	//   _uirt, رانۍ_, lliv_, _አክራሪ, 
   {{0x6494045d,0xd4040e0a,0x3904001e,0x63ac0031}},	//   _náis, ляпи, _тҟеб, _ýanj, 
   {{0x9388023f,0x3ce01497,0x6d40077d,0xb4c000b6}},	//   есоа_, nliv_, àlai, ूके_, 
   {{0x649403e0,0x00000000,0x00000000,0x00000000}},	//   _ráit, --, --, --, 
   {{0x61000243,0x73c4002c,0x6494059b,0x99980078}},	//   _lēlu, ләһе, _báis, rapņ_, 
   {{0x6e241498,0x4ea40332,0xdd10038c,0x649401ca}},	//   _rehb, ҳрва, _rüşv, _cáis, 
   {{0x93e40063,0x6e241499,0x629c02b4,0x76440181}},	//   _йўлл, _sehb, ësor, ɗiya, 
   {{0xe4380828,0x52740d5e,0x00000000,0x00000000}},	//   āṇāṃ_, _ماغز, --, --, 
   {{0x4ea40572,0x6e240140,0x6494149a,0x644c0247}},	//   урма, _qehb, _fáis, _ñair, 
   {{0x6e24149b,0xc2c0149c,0xdddc012c,0x6e5401da}},	//   _vehb, _ديوي, _kapř, _ምዝገባ, 
   {{0x649403e0,0x3ce0149d,0x610000ce,0x6e24011a}},	//   _háir, gliv_, _cēlu, _wehb, 
   {{0x6e240156,0x610000e0,0x80a400e2,0xfbc401ac}},	// [ff0] _tehb, _dēlu, _دمين, ٽيلٽ, 
   {{0xb5fc0116,0x2904005e,0xd1dc0020,0x610000ce}},	//   _haġu, _élak_, _ቓላት_, _vēlv, 
   {{0x64940272,0xb5fc0126,0x28140395,0x3ce00085}},	//   _máir, _kaġu, لواس, bliv_, 
   {{0xdddc02ef,0xb4c00357,0xb5fc011a,0x64940075}},	//   _např, ूको_, _jaġu, _láir, 
   {{0xd364149e,0x2ca803e0,0x070400ea,0x00000000}},	//   _به_, mhad_, ږيږي_, --, 
   {{0xd124149f,0x2ca80145,0x64940075,0x947001b5}},	//   _وم_, lhad_, _náir, ۪گلا, 
   {{0xe5a4006e,0x00000000,0x00000000,0x00000000}},	//   рийи, --, --, --, 
   {{0x2ca80335,0x63ac0101,0x649400f2,0x00000000}},	//   nhad_, _ýank, _ráis, --, 
   {{0x64940075,0xe2c814a0,0x2ca803c7,0xbd08004f}},	//   _báir, клид_, ihad_, _kuũã, 
   {{0xe29806d4,0x6494059b,0x2ca80126,0xbb3c00cf}},	//   тао_, _páis, hhad_, געזי, 
   {{0x2ca814a1,0x64940075,0x20c40302,0x41cc06ed}},	//   khad_, _dáir, ийом, _सुखस, 
   {{0x2c1403d0,0x672c0473,0x241814a2,0xdef40020}},	//   _फ्लू_, šaju, _роды_, _ገዝኡ_, 
   {{0x645814a3,0xfe780128,0x248c01df,0x2ca814a4}},	//   _ibwi, гүп_, mjem_, dhad_, 
   {{0x2ca814a5,0x6494059b,0xdddc0192,0x332002a0}},	//   ehad_, _gáir, _zapř, _çixa_, 
   {{0x3ce014a6,0x290414a7,0x1d080128,0x69c001d1}},	//   tliv_, _élah_, теби_, _žlen, 
   {{0x248c0406,0x2ca814a8,0x98b80d71,0x9f0400d5}},	//   njem_, ghad_, kupā_, _پودو, 
  
   {{0x645814a9,0x3d1c00d3,0xe8a002b4,0x2d8414aa}},	// [1000] _mbwi, _bàwò_, _ገምጋም_, äler_, 
   {{0x3ce014ab,0x248c14ac,0x8e80001e,0xe8a00020}},	//   sliv_, hjem_, _дгье, _ገምገም_, 
   {{0x645814ad,0x186814ae,0x248c0252,0x2ca814af}},	//   _obwi, кажи_, kjem_, bhad_, 
   {{0x2ca80011,0x248c0c89,0x96200143,0x2138018f}},	//   chad_, jjem_, _নাইম_, хshi_, 
   {{0x248c14b0,0x3d1c00d3,0x966401ec,0x9f5000f2}},	//   djem_, _fàwò_, икде, _agyú_, 
   {{0x645814b1,0x81a80143,0xdef40020,0x00000000}},	//   _abwi, _কুছ_, _ገዝኣ_, --, 
   {{0xf77000c3,0x780402dc,0x649400e3,0x00000000}},	//   غاچ_, _лӯла, _ráir, --, 
   {{0xd764063a,0x248c0020,0x649401ca,0xd37814b2}},	//   _پارٹ, gjem_, _sáir, вчо_, 
   {{0x6494045d,0xb5fc0037,0x660c00cb,0x796000d3}},	//   _páir, _raġu, śaka, bàwò, 
   {{0x829003c4,0x645814b3,0x248c01df,0x2ca808be}},	//   يۇنچ, _ebwi, ajem_, zhad_, 
   {{0x672c14b4,0x7cf80237,0x248c07b5,0x6ecc0030}},	//   šajt, _eŭri, bjem_, _सदबु, 
   {{0x644c00b8,0x248c01df,0xe6040387,0x2ca80475}},	//   _ñaip, cjem_, _köşə, xhad_, 
   {{0x6494045d,0x70941310,0x9fa40197,0x00000000}},	//   _táir, _ҳайф, бырҙ, --, 
   {{0x649400b8,0x6100015b,0x00000000,0x00000000}},	//   _háip, _cēls, --, --, 
   {{0x2ca8017d,0x6e94016d,0xb5fc0247,0x7094006b}},	//   thad_, _ғину, _taġu, _гайф, 
   {{0xf5480422,0xbd440272,0xacf800bf,0x01f800ca}},	//   _ዘይኰነ, تنفي, унбу_, _בפול, 
   {{0x90a414b5,0x2ca814b6,0x3d1c00d3,0x7f940123}},	// [1010] _محکم, rhad_, _pàwò_, _маъх, 
   {{0x248c14b7,0x00000000,0x00000000,0x00000000}},	//   zjem_, --, --, --, 
   {{0xc86414b8,0x248c00c0,0x00000000,0x00000000}},	//   итди, yjem_, --, --, 
   {{0x66f80031,0x659400b8,0x00000000,0x00000000}},	//   _iňki, ҩаду, --, --, 
   {{0x6d40020c,0x248c07b5,0x3d1c0223,0xa2a800bd}},	//   álaf, vjem_, _tàwò_, टसम्, 
   {{0xe5a414b9,0xe60402df,0xaa940075,0x27e800cf}},	//   йили, _döşə, _الآث, ĥan_, 
   {{0x248c14ba,0x27e800ef,0x00000000,0x00000000}},	//   tjem_, ťan_, --, --, 
   {{0xdb4c0012,0x64940075,0xd73c024b,0x00000000}},	//   _تێے_, _cáip, _бiрд, --, 
   {{0x248c14bb,0xa9a40c87,0x7de403e4,0x070400ea}},	//   rjem_, _тиңд, _गर्ग_, _څيړي_, 
   {{0x248c13bd,0x00000000,0x00000000,0x00000000}},	//   sjem_, --, --, --, 
   {{0x6458015e,0xfa980100,0x248c01f6,0x63b400b8}},	//   _tbwi, ידזש_, pjem_, шәҧх, 
   {{0x645814bc,0x00000000,0x00000000,0x00000000}},	//   _ubwi, --, --, --, 
   {{0x644814bd,0xe3740128,0x00000000,0x00000000}},	//   mgei, _ылды, --, --, 
   {{0x644814be,0xdc34012b,0x20c400bf,0x64a4044a}},	//   lgei, _bäğd, рсүг, _каçа, 
   {{0x644803f4,0xd9e400b6,0x00000000,0x00000000}},	//   ogei, _करइत_, --, --, 
   {{0x644814bf,0xede401c4,0xdddc012c,0x63ac0031}},	//   ngei, өһөҙ_, _topž, _žany, 
   {{0x1be800f8,0x644814c0,0xbd4401b5,0x00000000}},	// [1020] удаи_, igei, _ژھرى, --, 
   {{0x6448008e,0x00000000,0x00000000,0x00000000}},	//   hgei, --, --, --, 
   {{0xd8380396,0xceb0007c,0x64480618,0x00000000}},	//   гэл_, _מיז_, kgei, --, 
   {{0x63ac00fc,0x00000000,0x00000000,0x00000000}},	//   _ýanw, --, --, --, 
   {{0x644814c1,0xb8d000d1,0x19300020,0x97540106}},	//   dgei, _ओत_, _ኣፍጋኒ, стељ, 
   {{0x6d400cb6,0x00000000,0x00000000,0x00000000}},	//   álag, --, --, --, 
   {{0x64940272,0x7d1c0249,0x74a800df,0x644814c2}},	//   _páip, nprs, исиң_, fgei, 
   {{0x733800f8,0x6d4000e9,0x644814c3,0x00000000}},	//   азир_, šlag, ggei, --, 
   {{0x4c980100,0x00000000,0x00000000,0x00000000}},	//   טשקע, --, --, --, 
   {{0x644814c4,0x92680182,0x00000000,0x00000000}},	//   agei, уриа_, --, --, 
   {{0x86780240,0xd4d402b3,0x64480308,0xdb0402b2}},	//   _תרבו, _лідэ, bgei, _ómæg, 
   {{0x7d1c0113,0x27e80098,0x63ac0201,0x00000000}},	//   dprs, żane_, _żane, --, 
   {{0xdc340152,0x00000000,0x00000000,0x00000000}},	//   _säğd, --, --, --, 
   {{0x2c7401e5,0xe4640031,0x52b00128,0xc7b000ca}},	//   _ụd_, _çöre_, _رەجئ, לבר_, 
   {{0x2cb814c5,0x2a700091,0x70940385,0x61000059}},	//   _pmsd_, _razb_, _макф, _vēlr, 
   {{0xdc340152,0x6ad00095,0x00000000,0x00000000}},	//   _väğd, तक्र, --, --, 
   {{0x3a380043,0x405414c6,0x1ea814c7,0xdc3401c8}},	// [1030] _bdrp_, _رئيس, _چاپي_, _wäğd, 
   {{0xff5003e0,0x5e6403c4,0x64480361,0x3a380086}},	//   _أخي_, _ۇنۋە, zgei, _cdrp_, 
   {{0x6d400075,0x7c5814c8,0x6f1c14c9,0x644814ca}},	//   álad, شلەر_, lpsc, ygei, 
   {{0x6d5414cb,0x6448002a,0x6f1c00b0,0x00000000}},	//   mtza, xgei, opsc, --, 
   {{0x6d5402fb,0x644814cc,0x00000000,0x00000000}},	//   ltza, vgei, --, --, 
   {{0x89f8013f,0x6d5414cd,0x6448011a,0x7ac40246}},	//   _معزز_, otza, wgei, _ессе, 
   {{0x6d5402fb,0x644814ce,0x3b640012,0x00000000}},	//   ntza, tgei, _وێہہ, --, 
   {{0x6d5405bc,0x67d414cf,0xe5a40121,0x98b800c2}},	//   itza, _добу, йиһи, rupă_, 
   {{0x1cb00d7f,0xc64814d0,0xc538010f,0x66640012}},	//   ྐྲི_, _مجال_, _አይችሉ, _وُرٕ, 
   {{0xadf814d1,0x27ec01a7,0x644814d2,0x21f814d3}},	//   ंधान_, _izen_, sgei, ихнэ_, 
   {{0x208814d4,0x6f1c018c,0x00000000,0x00000000}},	//   айни_, epsc, --, --, 
   {{0x34940a54,0x00000000,0x00000000,0x00000000}},	//   _нахр, --, --, --, 
   {{0x6d540054,0x9e6400cc,0x23280027,0xd24c0061}},	//   etza, ياسن, _толи_, رنێ_, 
   {{0x712414d5,0x6b8c0054,0x61ec01c6,0x6d5402b0}},	//   _کرول, dxag, _ŝalu, ftza, 
   {{0x7a400229,0xc0d400c3,0x00000000,0x00000000}},	//   _látà, ﻟﯟﻩﺗ, --, --, 
   {{0x27ec14d6,0x00000000,0x00000000,0x00000000}},	//   _ozen_, --, --, --, 
   {{0x6d5405bc,0x765c0084,0x6b8c14d7,0x7d1c0070}},	// [1040] atza, _öryg, gxag, sprs, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x656001ba,0x27ec14d8,0x7ca8001d,0x9204004f}},	//   _nplh, _azen_, _መፈለግ_, _upāũ, 
   {{0x7a400537,0xf98400f8,0x00000000,0x00000000}},	//   _bátà, оҳҳо, --, --, 
   {{0x9a8401c4,0x905800ca,0x00000000,0x00000000}},	//   _һуңл, שכנת, --, --, 
   {{0x65600039,0x27ec14d9,0x66cc00c0,0x00000000}},	//   _bplh, _dzen_, tĺka, --, 
   {{0x98a414da,0x27ec14db,0x09e00121,0x186814dc}},	//   _диве, _ezen_, _жорн, _кави_, 
   {{0x2c00011a,0x00000000,0x00000000,0x00000000}},	//   _མུཉྩ_, --, --, --, 
   {{0xb9e814dd,0xccf00a1b,0x27e803e2,0xe8e814de}},	//   _ሮሜ_, וכה_, ýant_, _طرفو_, 
   {{0xd12c0340,0x610000e0,0x00000000,0x00000000}},	//   نۅت_, _sēlp, --, --, 
   {{0x95c400e2,0x52a800d1,0x00000000,0x00000000}},	//   _بياه, _छतीस, --, --, 
   {{0xe464059c,0x00000000,0x00000000,0x00000000}},	//   _çöpe_, --, --, --, 
   {{0xf31401a7,0x6b8c03fa,0x61ec0100,0x27ec0207}},	//   _эдлэ, xxag, _ŝalt, _xzen_, 
   {{0x6f1c01ed,0xadbc0023,0x00000000,0x00000000}},	//   rpsc, гагi, --, --, 
   {{0x6d540094,0x00000000,0x00000000,0x00000000}},	//   utza, --, --, --, 
   {{0x6d540396,0x6f1c0fd0,0xebb800cb,0xfa2402fa}},	//   rtza, ppsc, heḥ_, _পাগল_, 
   {{0x6d5414df,0x6d4005c0,0x00000000,0x00000000}},	// [1050] stza, álab, --, --, 
   {{0xdb2402ac,0x528000c3,0x00000000,0x00000000}},	//   سومی, _ﺩﯦﯖﯩ, --, --, 
   {{0x27ec14e0,0xeb9801c4,0x6b8c01e3,0x8880005e}},	//   _szen_, шиҡ_, sxag, ویسن, 
   {{0x6f0c0a1d,0xdddc0386,0x53c80474,0x00000000}},	//   _kuac, _hapş, ापाश, --, 
   {{0x0a68005b,0xdddc0055,0x807c0100,0x00000000}},	//   _крви_, _kapş, ינאצ, --, 
   {{0x6f0c118e,0x6f040380,0x48a80252,0xa50814e1}},	//   _muac, _jihc, চচেৰ, бека_, 
   {{0x6f0c14e2,0x00000000,0x00000000,0x00000000}},	//   _luac, --, --, --, 
   {{0x27ec01a7,0x2b4802e3,0xd1cc0020,0x7bc004c6}},	//   _tzen_, ouac_, ቦነት_, _žmui, 
   {{0x6f0c045d,0x466814e3,0x69c001d1,0x27ec14e4}},	//   _nuac, _врем_, _žleh, _uzen_, 
   {{0x672800dd,0x6f0414e5,0xf77014e6,0x7eb0002a}},	//   _iwej, _nihc, _جاف_, _zäpf, 
   {{0x630414e7,0x2b4804ac,0x216814e8,0x672814e9}},	//   _کوتل, huac_, щини_, _hwej, 
   {{0x672814ea,0x6f0c14eb,0x205400cc,0xf468001d}},	//   _kwej, _buac, чтор, ዲቀርብ_, 
   {{0x6f0c14ec,0x33740182,0x2d8414ed,0x00000000}},	//   _cuac, _огцр, ålen_, --, 
   {{0x6f040361,0xc4440063,0x6728007b,0x201c00cf}},	//   _cihc, _ایکن_, _mwej, ŝti_, 
   {{0x91e014ee,0x6f0c0034,0x21a401a7,0xae0400ec}},	//   _поше, _euac, _хийм, дорҙ, 
   {{0x672814ef,0x6f0c14f0,0x236c002f,0x62200121}},	//   _owej, _fuac, owej_, _تۈگە, 
   {{0x6f0c14f1,0x00000000,0x00000000,0x00000000}},	// [1060] _guac, --, --, --, 
   {{0x6d40045d,0x6f040361,0x1ea801ac,0x5e480027}},	//   álac, _gihc, _چاھي_, _упом_, 
   {{0x588414f2,0x1ea803a2,0xdc6814f3,0x236c0444}},	//   зыла, _ناھي_, _ланд_, hwej_, 
   {{0x672814f4,0x3f8014f5,0x00000000,0x00000000}},	//   _bwej, _kriu_, --, --, 
   {{0x7c2414f6,0xebb80828,0x6f040083,0xc7a014f7}},	//   mbir, teḥ_, _yihc, ницк, 
   {{0x7c2414f8,0x67280560,0xd65c0200,0x7528015e}},	//   lbir, _dwej, _мiнд, _pwdz, 
   {{0x7c24007b,0x00000000,0x00000000,0x00000000}},	//   obir, --, --, --, 
   {{0x7c2414f9,0x67280126,0x49380107,0xe3b80028}},	//   nbir, _fwej, _לגלו, rbűn_, 
   {{0x7c240dbc,0x12e414fa,0x00000000,0x00000000}},	//   ibir, зінг, --, --, 
   {{0x0bb40107,0x6f0c14fb,0x7c2401e3,0x1d340020}},	//   פלים_, _ruac, hbir, _ክግንዘ, 
   {{0x3f8014fc,0x6f0c14fd,0x00000000,0x00000000}},	//   _ariu_, _suac, --, --, 
   {{0xd0a802dc,0x00000000,0x00000000,0x00000000}},	//   стод_, --, --, --, 
   {{0x7c2414fe,0x6f0c14ff,0x3f801500,0x00000000}},	//   dbir, _quac, _criu_, --, 
   {{0x3f800264,0x6f040140,0x6f0c000d,0x7764011a}},	//   _driu_, _qihc, _vuac, ħixh, 
   {{0xa2d81501,0x51841502,0x6c8400e2,0x3f8000b0}},	//   नकर्, _хула, ولسم, _eriu_, 
   {{0xfd7405bc,0x6f0c1503,0x2b480054,0x00000000}},	//   элсэ, _tuac, tuac_, --, 
   {{0xdddc1504,0x3f801505,0x786400f1,0x6f040140}},	// [1070] _tapş, _griu_, _mčvč, _tihc, 
   {{0x7c241506,0x67281507,0x0dc81508,0x00000000}},	//   abir, _rwej, _гуми_, --, 
   {{0x7c241509,0x7eb00101,0xad4000e7,0x00000000}},	//   bbir, _däpd, _جۉزۉ, --, 
   {{0x7c240055,0x00000000,0x00000000,0x00000000}},	//   cbir, --, --, --, 
   {{0x3b64150a,0xe7380091,0x00000000,0x00000000}},	//   _първ, цел_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5550150b,0xdaa00572,0x00000000,0x00000000}},	//   نپور, _جەلپ, --, --, 
   {{0x67280472,0x2d8001d1,0x3fbc00c3,0x00000000}},	//   _twej, _mrhe_, ﻧﻼﺭﻧ, --, 
   {{0x7eb0021c,0x6728011a,0xe3b8150c,0x00000000}},	//   _häpe, _uwej, юби_, --, 
   {{0x21a40121,0x7eb0150d,0x236c038a,0x00000000}},	//   диом, _käpe, rwej_, --, 
   {{0x7c240064,0xa068150e,0x8544150f,0xe1f001a0}},	//   ybir, оана_, _хэзе, کسک_, 
   {{0x3f801510,0x7eb0019f,0x7c241511,0xa8780100}},	//   _priu_, _mäpe, xbir, קאָר, 
   {{0x7eb00675,0x2d80004f,0x7f0400fc,0x00000000}},	//   _läpe, _arhe_, нҗид, --, 
   {{0xf3f407d8,0x76941420,0x442c1512,0xa1c40302}},	//   _яңы_, _bàyy, _heg_, _облд, 
   {{0x442c0d13,0xaf34049d,0x69d400b7,0x7eb01513}},	//   _keg_, ووێژ, _nxze, _näpe, 
   {{0x442c1514,0x3cf8002f,0x7c24030b,0xa3e0006c}},	//   _jeg_, ंगें_, ubir, _धडा_, 
   {{0x442c1515,0x7c241516,0x9b0400f8,0x5f440046}},	// [1080] _meg_, rbir, дзад, _غندل, 
   {{0x7c241517,0x4a400385,0xda6414c6,0x442c027e}},	//   sbir, кнув, باري, _leg_, 
   {{0x99841518,0x442c013c,0x2d80004f,0x00000000}},	//   بلاو, _oeg_, _grhe_, --, 
   {{0x442c1519,0x28a4024b,0x7c24151a,0x57e80123}},	//   _neg_, ншіг, qbir, одем_, 
   {{0x69d4151b,0x3c4800e2,0x158c00c3,0x00000000}},	//   _exze, _وګړی_, _ﻛﯧﺴﯩ, --, 
   {{0x442c151c,0xa3e003bf,0x00000000,0x00000000}},	//   _aeg_, _धड़_, --, --, 
   {{0x442c151d,0x9854151e,0x00000000,0x00000000}},	//   _beg_, _оташ, --, --, 
   {{0x442c0069,0x3374151f,0x068002de,0x00000000}},	//   _ceg_, егир, егән, --, 
   {{0x442c1520,0x92681521,0xd24400df,0x2d8000c3}},	//   _deg_, орна_, мэни, _ﺧﯧﻠﻰ_, 
   {{0xc5a400a3,0x395801f9,0x46441522,0xa300006b}},	//   _ڪڏهن_, _kqrs_, _озун_, гүче, 
   {{0x70541412,0x442c1523,0x00000000,0x00000000}},	//   ىندا, _feg_, --, --, 
   {{0xc5a400a3,0x442c1524,0x3cf8002f,0x312400bf}},	//   _تڏهن_, _geg_, ंगों_, мдүг, 
   {{0xcee81525,0x9f4c00d3,0x00000000,0x00000000}},	//   قرآن_, _ńfò_, --, --, 
   {{0x442c1526,0x8d7403f5,0x00000000,0x00000000}},	//   _zeg_, وازا, --, --, 
   {{0x442c1527,0x649400f2,0x00000000,0x00000000}},	//   _yeg_, _ráiz, --, --, 
   {{0x442c015e,0x7eb002eb,0x5fd80098,0x00000000}},	//   _xeg_, _räpe, _युकल, --, 
   {{0x3eb40192,0x6af400b7,0x00000000,0x00000000}},	// [1090] _šatů_, езаф, --, --, 
   {{0x7eb0019f,0x76940d8c,0xe73800df,0x00000000}},	//   _päpe, _tàyy, җек_, --, 
   {{0x2d800e84,0xac1800f8,0xab6c010f,0x00000000}},	//   _urhe_, _нону_, ስተዋል_, --, 
   {{0x1cb0043b,0x6e3402db,0xf9900075,0xcc840061}},	//   ྐྲད_, lazb, جبك_, _تۆره_, 
   {{0x442c1528,0xfeb804c3,0x98b8012c,0x00000000}},	//   _reg_, _رایت_, lupě_, --, 
   {{0x442c1529,0x2ca801c5,0xdb2403cd,0xa50800e5}},	//   _seg_, lkad_, _سوفی, пека_, 
   {{0x26c8091d,0xc5e40143,0x00000000,0x00000000}},	//   đao_, গেনা_, --, --, 
   {{0x2ca8152a,0x23280123,0x09a80095,0x00000000}},	//   nkad_, поии_, चनीय, --, 
   {{0x442c152b,0x2910152c,0xe3b00272,0x6e34152d}},	//   _veg_, _huza_, طرة_, kazb, 
   {{0x442c152e,0x2910152f,0x5fd80a77,0x75380039}},	//   _weg_, _kuza_, _युगल, bsvz, 
   {{0x442c1530,0x2ca81531,0x29101532,0x00000000}},	//   _teg_, kkad_, _juza_, --, 
   {{0x442c1533,0x257000b0,0x2ca80207,0x00000000}},	//   _ueg_, _išl_, jkad_, --, 
   {{0x2ca81534,0xc0000301,0x29101535,0x6d401536}},	//   dkad_, ূর্ণ_, _luza_, álan, 
   {{0x53981537,0x291000f1,0xabd801d2,0x00000000}},	//   _מינו, _ouza_, _ﺃﺼﻘﺎ, --, 
   {{0xd24c1538,0x29101507,0x427802b4,0x6d401539}},	//   _انى_, _nuza_, _እሙናት_, šlan, 
   {{0x2ca805b8,0xe0d401ac,0x00000000,0x00000000}},	//   gkad_, _سڏجڻ_, --, --, 
   {{0x60c4153a,0xcb6403e3,0xdca40116,0x19880123}},	// [10a0] mikm, нате_, _ҷани, ӯбаи_, 
   {{0x38c002a0,0x8c400386,0x00000000,0x00000000}},	//   _içrə_, ışab, --, --, 
   {{0x98a4153b,0x2910153c,0xb8e400e2,0xaec00049}},	//   ниже, _cuza_, نګره, _тұрл, 
   {{0x60c4153d,0x2ca8046a,0x2910153e,0x998800bd}},	//   nikm, ckad_, _duza_, _webů_, 
   {{0x61000034,0xab6c001d,0x00000000,0x00000000}},	//   _cœli, ስተውል_, --, --, 
   {{0x60c40919,0x29100047,0x00000000,0x00000000}},	//   hikm, _fuza_, --, --, 
   {{0x2910153f,0x55040254,0x00000000,0x00000000}},	//   _guza_, нчиа, --, --, 
   {{0x09e01540,0x60c41541,0x20d00560,0x73c403ba}},	//   _сосн, jikm, wġin_, кәле, 
   {{0x29101542,0xe7080572,0x46e40087,0x60c401e3}},	//   _zuza_, ستۇن_, ьдән_, dikm, 
   {{0x29101543,0xdb08005e,0x4b7800ca,0x00000000}},	//   _yuza_, ènèh, לאפו, --, 
   {{0xc68c04bb,0x60c41544,0xd4681545,0xefd402b4}},	//   _دِل_, fikm, _ниже_, ከይድ_, 
   {{0x60c41546,0x25a00104,0x00000000,0x00000000}},	//   gikm, ähle_, --, --, 
   {{0x6e3401aa,0x00000000,0x00000000,0x00000000}},	//   tazb, --, --, --, 
   {{0xc00001b9,0x00000000,0x00000000,0x00000000}},	//   ূৰ্ণ_, --, --, --, 
   {{0x6e341547,0x2ca81548,0xc2780240,0x60c41549}},	//   razb, tkad_, _מרגי, bikm, 
   {{0x2910154a,0x60c4154b,0x20d0011a,0x6fb40e09}},	//   _ruza_, cikm, nġil_, _لمبا, 
   {{0x2910154c,0x2ca8154d,0x2ef4154e,0x7bc0154f}},	// [10b0] _suza_, rkad_, _изир, _žmur, 
   {{0x2ca81550,0x291001df,0xed500012,0x6e3403b4}},	//   skad_, _puza_, _پھس_, qazb, 
   {{0xba7401ff,0xe8580023,0x00000000,0x00000000}},	//   داقت, даеш_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7eb000a2,0xe6941551,0x97300395,0x00000000}},	//   _häpa, киды, لکلا, --, 
   {{0x60c41552,0xa6c8070b,0x7eb000af,0x29101553}},	//   zikm, ьлла_, _käpa, _tuza_, 
   {{0x60c40a16,0x00000000,0x00000000,0x00000000}},	//   yikm, --, --, --, 
   {{0x38c801a7,0x60c4028b,0x00000000,0x00000000}},	//   _зуун_, xikm, --, --, 
   {{0x7eb00030,0x00000000,0x00000000,0x00000000}},	//   _läpa, --, --, --, 
   {{0x2b48014a,0xf65000dd,0x6ecc0388,0x00000000}},	//   irac_, _هئم_, _सदगु, --, 
   {{0x60c41554,0x7eb0013c,0x00000000,0x00000000}},	//   tikm, _näpa, --, --, 
   {{0x2b480ddc,0x622000c3,0x00000000,0x00000000}},	//   krac_, _ھۈجە, --, --, 
   {{0x2bdc1555,0x60c41556,0x3f8402ef,0x6d4000ef}},	//   _मडगा, rikm, ímu_, šlal, 
   {{0x60c41557,0x2b480ddc,0xc32c0012,0x3af4013c}},	//   sikm, drac_, _نٕچ_, käpa_, 
   {{0xda70004b,0x60c400f1,0x00000000,0x00000000}},	//   یُر_, pikm, --, --, 
   {{0x9f841558,0x8c401559,0x6b8801d1,0xdcb0155a}},	//   _агид, иесе, _šega, جىر_, 
   {{0x25b802df,0x2b4803bf,0x00000000,0x00000000}},	// [10c0] _əsla_, grac_, --, --, 
   {{0x0f34007c,0x00000000,0x00000000,0x00000000}},	//   _שריט_, --, --, --, 
   {{0x3864155b,0x9d380125,0x293c01ee,0x8c380104}},	//   _pbmr_, _ɛyɛɛ_, ﯞﻻﭖ_, _soße, 
   {{0xdca4155c,0x8d74155d,0x2b48155e,0xc3240143}},	//   _рами, _شاپا, brac_, _মিনি_, 
   {{0x2b480034,0xdb08059b,0x81b40143,0x22bc01d5}},	//   crac_, únói, চপি_, lňku_, 
   {{0xad240061,0x00000000,0x00000000,0x00000000}},	//   _جریو, --, --, --, 
   {{0xceb0033c,0x60d40247,0xd944118d,0xdb2400ea}},	//   שיו_, _ojym, _јеби, _سوځی, 
   {{0x14c800b8,0x00000000,0x00000000,0x00000000}},	//   ьыли_, --, --, --, 
   {{0xf9f402fa,0x83300182,0x00000000,0x00000000}},	//   _জলিল_, аных, --, --, 
   {{0x73c4016d,0x78a00380,0x60d40031,0x00000000}},	//   кәһе, _homv, _ajym, --, 
   {{0xc1b401a7,0x78a0155f,0x00000000,0x00000000}},	//   влэх_, _komv, --, --, 
   {{0x93441560,0x660c0828,0x823002b4,0x7eb01561}},	//   _анде, śakt, _ጻዕርታ, _räpa, 
   {{0x78a01562,0xddcc028d,0x628c0306,0x00000000}},	//   _momv, bebū, ánoí, --, 
   {{0x78a01563,0x00000000,0x00000000,0x00000000}},	//   _lomv, --, --, --, 
   {{0x2d84126c,0x8c38002a,0x2b480060,0x60dc0078}},	//   íle_, _roßb, wrac_, ōsma, 
   {{0x78a0019b,0x60d40020,0x00000000,0x00000000}},	//   _nomv, _gjym, --, --, 
   {{0x09c800cb,0x61000034,0x80a41564,0x00000000}},	// [10d0] ऽप्य, _cœlu, _خمين, --, 
   {{0x7eb01565,0x94080130,0x2b481566,0x6144020d}},	//   _täpa, ɔbɔ_, rrac_, _شىۋە, 
   {{0x6cd41567,0x78a00380,0x1af00143,0x00000000}},	//   _مقدا, _bomv, _অংশে_, --, 
   {{0xdd9000dd,0xa52400c3,0x3af4001e,0x00000000}},	//   _اوٽ_, қмид, räpa_, --, 
   {{0x78a001c6,0x46300116,0x00000000,0x00000000}},	//   _domv, иҭар, --, --, 
   {{0xc984001e,0x00000000,0x00000000,0x00000000}},	//   _иуби, --, --, --, 
   {{0x090400b8,0x3af402b1,0xa2e41568,0x00000000}},	//   _ачам, qäpa_, ғонд, --, 
   {{0x57b01569,0x00000000,0x00000000,0x00000000}},	//   рбәт, --, --, --, 
   {{0x68e8156a,0xa0a400b2,0xa2e4156b,0x386001d6}},	//   _iked, ҳанд, лоид, òire_, 
   {{0x27ec156c,0x78a0156d,0x6258156e,0x60d4036d}},	//   _iyen_, _zomv, хрир_, _sjym, 
   {{0xa0a4156f,0x24541570,0x68e8007b,0x78a01571}},	//   ганд, _مناس, _kked, _yomv, 
   {{0xe3b80027,0x00000000,0x00000000,0x00000000}},	//   _плеч_, --, --, --, 
   {{0x64580083,0x27ec0078,0x9344039b,0x64a4001e}},	//   _icwi, _jyen_, _مىنۇ, _иаҧа, 
   {{0x63a81572,0x27ec1573,0x00000000,0x00000000}},	//   myen, _myen_, --, --, 
   {{0xdef81574,0x27ec1575,0x68e81576,0x92541577}},	//   дың_, _lyen_, _oked, _сајт_, 
   {{0x290c0062,0x27ec0964,0x68e800d3,0x7c2400b8}},	//   _niea_, _oyen_, _nked, рзаҧ, 
   {{0x27ec0039,0x64580426,0x7b840108,0x78a01578}},	// [10e0] _nyen_, _mcwi, جازە, _romv, 
   {{0x290c1579,0x78a0157a,0x68e8157b,0xf8ac06de}},	//   _aiea_, _somv, _aked, चस्प, 
   {{0x7eb00299,0x78a0075d,0x27ec01e8,0x63a8008e}},	//   _häpo, _pomv, _ayen_, hyen, 
   {{0xd7f8157c,0x27ec157d,0xeaf8157e,0x26c40964}},	//   нул_, _byen_, ىرەت_, _amlo_, 
   {{0x63a8157f,0x96e81580,0x8c08007e,0x78a00151}},	//   jyen, нька_, ষুবন_, _vomv, 
   {{0x68e81581,0x78a01582,0x27ec0028,0x63a81583}},	//   _eked, _womv, _dyen_, dyen, 
   {{0x1c1c0d49,0x78a0000d,0x201000e3,0x00000000}},	//   युअल_, _tomv, _ogyi_, --, 
   {{0x27ec01a8,0x00000000,0x00000000,0x00000000}},	//   _fyen_, --, --, --, 
   {{0x63a81584,0x82f40a1d,0x53e400e5,0xd6f80094}},	//   gyen, گريز_, ыцка, _зхжш_, 
   {{0x645803c7,0x201000d5,0x00000000,0x00000000}},	//   _ecwi, _agyi_, --, --, 
   {{0x63a80618,0x68e802b0,0x461000ea,0x00000000}},	//   ayen, _yked, _اومر, --, 
   {{0x63a806a8,0x6fb40075,0x00000000,0x00000000}},	//   byen, لمجا, --, --, 
   {{0x63a81585,0x4fc41586,0xb3d4002c,0x32e002e6}},	//   cyen, усна, _әйҙә, _açyş_, 
   {{0x6458036d,0x64bc00cb,0x6b8801df,0x00000000}},	//   _zcwi, ṇita, _šego, --, 
   {{0xccf806d4,0x62641587,0x7eb000b6,0x8c641588}},	//   ећа_, _خانق, _täpn, лтад, 
   {{0x7b640d56,0x61f41589,0x27e8158a,0x953c001d}},	//   әтте, üzle, żani_, _አይነተ, 
   {{0x7afc0177,0x68e80085,0xed5001b5,0xfce8158b}},	// [10f0] _bhrt, _rked, _ژھر_, افقي_, 
   {{0x68e8158c,0x290c158d,0x7afc00ef,0x27ec00f1}},	//   _sked, _siea_, _chrt, _ryen_, 
   {{0x63a8158e,0x7afc158f,0xe9441590,0x27ec00f1}},	//   zyen, _dhrt, شرای, _syen_, 
   {{0x63a81591,0x27ec0078,0x7afc002a,0x39e800fc}},	//   yyen, _pyen_, _ehrt, уьун_, 
   {{0x68e8013c,0xae180030,0xa2a403bf,0x8bc8012b}},	//   _vked, _दलान_, _चकल्, _чынб_, 
   {{0x89341592,0x63a81593,0x27ec1594,0xdd0c006b}},	//   _معرا, vyen, _vyen_, _kışn, 
   {{0x290c1595,0x63a803f4,0x00000000,0x00000000}},	//   _tiea_, wyen, --, --, 
   {{0x63a81596,0x68e81597,0x9f4802bb,0xf9881598}},	//   tyen, _uked, çkës_, _حنفي_, 
   {{0xe2981599,0x27ec01eb,0xb4840197,0x00000000}},	//   вап_, _uyen_, скыһ, --, 
   {{0x63a8159a,0x26c400ea,0x52a4021c,0x7a48015b}},	//   ryen, _umlo_, ивым_, cītē, 
   {{0x63a8159b,0x7eb0159c,0xa3e000b3,0xaadc0523}},	//   syen, _däpl, _धडक_, _मदनक, 
   {{0x63a8159d,0xd59800ca,0x60dc0078,0x00000000}},	//   pyen, _בבעל, čsmo, --, 
   {{0x63a802bb,0x2d840056,0x779800fb,0x00000000}},	//   qyen, ælen_, _укăр_, --, 
   {{0x27e801ec,0xe2c8159e,0xe2980931,0x7eb0012b}},	//   ýany_, _جوتو_, _јак_, _gäpl, 
   {{0x7a400270,0x00000000,0x00000000,0x00000000}},	//   hátí, --, --, --, 
   {{0xdddc0299,0x16d000cb,0xdca401a0,0x7afc011a}},	//   _hapū, _तद्ब, шаби, _shrt, 
   {{0x9b44159f,0x2c0000b3,0x7a40096c,0x5b34038e}},	// [1100] شناو, लेलं_, játí, рэбу, 
   {{0x628015a0,0xcb640663,0x00000000,0x00000000}},	//   ndlo, рафе_, --, --, 
   {{0x81e400ac,0x2d8415a1,0x69c00031,0x00000000}},	//   _মৃত_, ålet_, _ýlel, --, 
   {{0x57a415a2,0x25e803ef,0x62800086,0x00000000}},	//   ишла, _छड़ी_, hdlo, --, 
   {{0xd704140c,0x00000000,0x00000000,0x00000000}},	//   азди, --, --, --, 
   {{0x7d0415a3,0x63ac0937,0x628001ed,0xdddc004f}},	//   lmis, _ýany, jdlo, _napū, 
   {{0xc81c0090,0x057015a4,0x7eb00139,0x628015a5}},	//   ስትመን, قايد, _räpl, ddlo, 
   {{0x7d0415a6,0x48e015a7,0x6d400272,0x99980341}},	//   nmis, _досв, álai, hapū_, 
   {{0x7d0415a8,0x999804c4,0x7eb00638,0x60cc007c}},	//   imis, kapū_, _päpl, _ĉamp, 
   {{0x7d0415a9,0x6d4013e2,0xe8f800f8,0x51840f0e}},	//   hmis, šlai, _алӣ_, аума, 
   {{0x7d0415aa,0x00000000,0x00000000,0x00000000}},	//   kmis, --, --, --, 
   {{0x628015ab,0xd01800b2,0x64bc00cb,0x324401c4}},	//   adlo, ъфо_, ṇira, шеүг, 
   {{0x7d0415ac,0x4ea415ad,0x7eb0078a,0xe504020e}},	//   dmis, арва, _täpl, _ابلي, 
   {{0xb8f80795,0x7d0415ae,0x00000000,0x00000000}},	//   _ོམ_, emis, --, --, 
   {{0x02f8047b,0x7d040056,0xdd0c012b,0x00000000}},	//   _שלומ, fmis, _qışn, --, 
   {{0x7d0415af,0xb03415b0,0x00000000,0x00000000}},	//   gmis, _униш, --, --, 
   {{0x80240012,0xcee80063,0xf07800b8,0x00000000}},	// [1110] _بر٘م, _لردن_, _аиқә_, --, 
   {{0x7d0406ea,0xe84002b4,0xc9840116,0xca240123}},	//   amis, _ከምዘሎ, иуеи, рфаи, 
   {{0xacb4009d,0x7d0415b1,0x7658015e,0x2814059b}},	//   _همدغ, bmis, dgvy, مواس, 
   {{0x6d5415b2,0x7f840eb6,0x6204009f,0x7d0415b3}},	//   muza, _الین, ürlə, cmis, 
   {{0x7bd80397,0x3cf415b4,0x38600177,0x628003c7}},	//   şvur, ंतरे_, òira_, ydlo, 
   {{0x2f1c000d,0x36c4021d,0x00000000,0x00000000}},	//   _mìg_, обіг, --, --, 
   {{0x20d00032,0x98580828,0xe5a4006e,0xf9d401ec}},	//   lšie_, ṇāt_, сийи, _дорэ, 
   {{0x6f1c070b,0x3a380291,0x7eb00139,0x216815b5}},	//   kqsc, _zerp_, _räpm, қими_, 
   {{0x6d5415b6,0x158c0121,0x20d002d9,0xdddc15b7}},	//   huza, _ﻛﯧﺘﯩ, nšie_, _papū, 
   {{0x6d5415b8,0x7d0415b9,0x66e80123,0x62800085}},	//   kuza, zmis, _субҳ_, udlo, 
   {{0x628015ba,0x7d0406ea,0x20d0018b,0xe5f415bb}},	//   rdlo, ymis, hšie_, _اكاد, 
   {{0x6d540167,0x349415bc,0x20d000c0,0x05740061}},	//   duza, _махр, kšie_, _ماڵد, 
   {{0x20d00032,0xa0a41072,0x256003fa,0xdfd015bd}},	//   jšie_, _ҳайд, lól_, سيس_, 
   {{0x6d5415be,0xb37001b5,0x20d002cc,0x00000000}},	//   fuza, _کۯیش, dšie_, --, 
   {{0x7d040310,0x6d5415bf,0xa0a415c0,0x256015c1}},	//   tmis, guza, _гайд, nól_, 
   {{0x3a3815c2,0x7d0415c3,0x00000000,0x00000000}},	//   _serp_, umis, --, --, 
   {{0x20d00091,0x2d841169,0x5e6000bf,0x256006b4}},	// [1120] ršid_, åler_, _ىچسە, hól_, 
   {{0x7f440ca7,0x7d1c015e,0xd1f40020,0x00000000}},	//   _iviq, pqrs, ለውቲ_, --, 
   {{0x5d8403e0,0xd238007c,0x7d0415c4,0x2560020f}},	//   _الجل, רגעל, pmis, jól_, 
   {{0x25600110,0x3a38062d,0x20d002cc,0x7d0401e3}},	//   dól_, _werp_, bšie_, qmis, 
   {{0x3a380556,0x6da4028a,0x6d400b7c,0x69d80104}},	//   _terp_, nɗan, álav, ßwer, 
   {{0x6da40181,0x7eb00101,0x00000000,0x00000000}},	//   iɗan, _säpj, --, --, 
   {{0xed6c001d,0x00000000,0x00000000,0x00000000}},	//   _ሴክተር_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d5415c5,0x00000000,0x00000000,0x00000000}},	//   zuza, --, --, --, 
   {{0x2560063a,0x273c02c6,0x6d5415c6,0x53e4001e}},	//   ból_, _wâná_, yuza, ицҿа, 
   {{0x76480ca0,0x25600075,0x7f4402a0,0x4a980100}},	//   _iddy, cól_, _aviq, אייג, 
   {{0x9f500110,0x6d5415c7,0x09f400ca,0x65b815c8}},	//   _iyyê_, vuza, ממים_, _туур_, 
   {{0x6d5415c9,0x73c400ec,0x00000000,0x00000000}},	//   wuza, _фәйе, --, --, 
   {{0x6d5415ca,0x20d00c75,0xd1b803c4,0x12180007}},	//   tuza, všie_, _ماعا_, _сюды_, 
   {{0xf1580182,0x55f40143,0x00000000,0x00000000}},	//   _тийш_, _চলুক_, --, --, 
   {{0x6d5415cb,0x85380282,0xe8c4011a,0x20d002cc}},	//   ruza, טגלי, _གཏེག, tšie_, 
   {{0x7b1415cc,0x764815cd,0x6d5415ce,0x31740098}},	// [1130] здух, _oddy, suza, ńczę_, 
   {{0x6d5415cf,0x705415d0,0x20d00c75,0x69c00031}},	//   puza, _انکا, ršie_, _ýlek, 
   {{0x256003fa,0x6e9400e2,0xe97815d1,0x693415d2}},	//   xól_, _هلکا, рбеш_, інду, 
   {{0x6d4415d3,0x76480ca0,0x20d00c75,0xab940b1e}},	//   _ivha, _addy, pšie_, _димі, 
   {{0x656015d4,0x752800d4,0x2cb80f37,0x25600078}},	//   _sqlh, _atdz, _ilsd_, wól_, 
   {{0xf77015d5,0x2560063a,0x7f3c007c,0x00000000}},	//   عان_, tól_, נעוו, --, 
   {{0x79a415d6,0x0ba80128,0x00000000,0x00000000}},	//   _ерте, _شاڭى_, --, --, 
   {{0x256015d7,0x76480437,0x09bc0143,0x00000000}},	//   ról_, _eddy, _আশপা, --, 
   {{0xc10405bc,0x87d80012,0x8c38002a,0x00000000}},	//   үүлл, _صبرس_, _roßl, --, 
   {{0x6728043b,0xc6d401b8,0x00000000,0x00000000}},	//   _itej, _اترت, --, --, 
   {{0x216815d8,0xe0d815d9,0x2a300020,0x00000000}},	//   шини_, иво_, _ብኢትዮ, --, 
   {{0x237c042a,0x67280560,0x98b40560,0x55b800ca}},	//   _tswj_, _ktej, ġgħu_, _דמעו, 
   {{0x443c15da,0xe29805db,0x6728043b,0x10a015db}},	//   mau_, _вал_, _jtej, фиян, 
   {{0x443c15dc,0x672815dd,0x630415de,0x7eb015df}},	//   lau_, _mtej, _بوتل, _käpi, 
   {{0xa0a415e0,0x443c006f,0xde040049,0x929003a7}},	//   _макд, oau_, іпби, _цајц, 
   {{0x443c15e1,0x1b4800bf,0x00000000,0x00000000}},	//   nau_, изби_, --, --, 
   {{0x6d4415e2,0x672815e3,0x7eb00274,0x00000000}},	// [1140] _evha, _ntej, _läpi, --, 
   {{0x443c15e4,0xe8c40002,0x3f800956,0xe7ec0098}},	//   hau_, _གཏུག, _isiu_, _जड़ा_, 
   {{0x443c15e5,0x6d4015e6,0xdc6815e7,0x3f80011a}},	//   kau_, álat, _канд_, _hsiu_, 
   {{0x186815e8,0x443c15e9,0x2cb801c3,0x4524011a}},	//   ради_, jau_, _glsd_, _ལྕེར_, 
   {{0x443c15ea,0x47300302,0xd70815eb,0x07a00007}},	//   dau_, дніс, анде_, мацн, 
   {{0x443c15ec,0xdddc15ed,0x2cb801f6,0x00000000}},	//   eau_, _japů, _zlsd_, --, 
   {{0x443c15ee,0x672801e5,0x7c2401c7,0x00000000}},	//   fau_, _etej, ocir, --, 
   {{0x443c15ef,0x7c2415f0,0x9998012c,0x00000000}},	//   gau_, ncir, lapů_, --, 
   {{0xa8a40075,0x25b803b4,0x00000000,0x00000000}},	//   _عصفو, _əsli_, --, --, 
   {{0x443c03f2,0xe7d40063,0x764815f1,0xdddc012c}},	//   aau_, _عملگ, _uddy, _napů, 
   {{0x69c015f2,0x3f800614,0x8af8067a,0x7c240207}},	//   _žlez, _asiu_, שהיי, kcir, 
   {{0xa0200386,0x00000000,0x00000000,0x00000000}},	//   _çöla, --, --, --, 
   {{0x64d8007c,0xbfa815f3,0x7c2406e9,0xbf3412a3}},	//   _פֿעס, отре_, dcir, мнящ, 
   {{0x69c0013c,0x00000000,0x00000000,0x00000000}},	//   _üleg, --, --, --, 
   {{0xac9415f4,0x7c240139,0xccc801f1,0x00000000}},	//   павш, fcir, аѓал_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1ea800dd,0x3b640074,0xfbd015f5,0x00000000}},	// [1150] _ڇاپي_, дъхв, نتك_, --, 
   {{0x443c15f6,0x6d4015f7,0x6384012f,0xba980302}},	//   zau_, álas, lîná, овує_, 
   {{0x443c15f8,0x67280357,0x2cb80d13,0x20d0018b}},	//   yau_, _stej, _tlsd_, lšia_, 
   {{0x2d8015f9,0x443c15fa,0x5d780282,0x7c2415fb}},	//   _ishe_, xau_, _פארק, ccir, 
   {{0x443c15fc,0x7b6415fd,0x7eb00675,0x20d002cc}},	//   vau_, _отре, _säpi, nšia_, 
   {{0x443c15fe,0x00000000,0x00000000,0x00000000}},	//   wau_, --, --, --, 
   {{0x443c15ff,0xeaf81600,0xe57802dc,0xdb0803c2}},	//   tau_, ्गीत_, ёзи_, _ónát, 
   {{0x443c0eab,0x6728043b,0x38c80094,0x00000000}},	//   uau_, _ttej, _дуун_, --, 
   {{0x443c1601,0x20d0018b,0x6728042e,0x00000000}},	//   rau_, jšia_, _utej, --, 
   {{0x443c1602,0x7eb01603,0x20d002cc,0x00000000}},	//   sau_, _täpi, dšia_, --, 
   {{0x443c1604,0xc0e8010f,0x69c0101d,0x98b800b0}},	//   pau_, _መማር_, _üled, gupė_, 
   {{0x443c1605,0x3f8000b7,0x00000000,0x00000000}},	//   qau_, _psiu_, --, --, 
   {{0x2d800e66,0x7c2407e7,0xa29400c8,0xf3801606}},	//   _ashe_, vcir, _наді, _ағым, 
   {{0xca341607,0xc174012b,0x00000000,0x00000000}},	//   _koʝu_, _дҗо_, --, --, 
   {{0x5974001d,0x00000000,0x00000000,0x00000000}},	//   _ጽሁፎች_, --, --, --, 
   {{0x0d800182,0xa0a41608,0x20d000c0,0x6c740094}},	//   элсн, _хаид, bšia_, муух, 
   {{0x7c241609,0x6d400407,0x5f44160a,0x2d80160b}},	// [1160] rcir, álar, _عندل, _eshe_, 
   {{0x7c24160c,0xca80160d,0x2bdc0098,0x00000000}},	//   scir, нгуй, _यशरा, --, 
   {{0xca340062,0x8e7800ca,0x00000000,0x00000000}},	//   _noʝu_, _פנטה, --, --, 
   {{0x76440ae3,0x00000000,0x00000000,0x00000000}},	//   ɗiyy, --, --, --, 
   {{0x8d9001d9,0x00000000,0x00000000,0x00000000}},	//   _قلیش, --, --, --, 
   {{0xd944160e,0x3ca40e85,0x7bc4160f,0x00000000}},	//   _неги, ﺎﻳﺴﻰ_, mziu, --, 
   {{0xfa2c0126,0x7bc41610,0xf77000e7,0x09e01611}},	//   _ཧྥརན_, lziu, عاچ_, _зорн, 
   {{0x89d80240,0x00000000,0x00000000,0x00000000}},	//   _החלי, --, --, --, 
   {{0x7bc41612,0x00000000,0x00000000,0x00000000}},	//   nziu, --, --, --, 
   {{0x7eb000af,0x7bc400b0,0x20d002cc,0x00000000}},	//   _käpu, iziu, všia_, --, 
   {{0x70541613,0x00000000,0x00000000,0x00000000}},	//   وندا, --, --, --, 
   {{0x69c000a1,0x85980107,0x53a41614,0x20d000c0}},	//   _ülee, _לשבו, _наеб, tšia_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bc41615,0x20d01616,0x00000000,0x00000000}},	//   dziu, ršia_, --, --, 
   {{0x7eb000a1,0x7bc400e5,0x00000000,0x00000000}},	//   _näpu, eziu, --, --, 
   {{0x20d002d9,0x7c941617,0x661400c0,0x00000000}},	//   pšia_, ىشقا, _úzke, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1170] --, --, --, --, 
   {{0x2d801618,0x6da401e7,0x20d0012c,0x00000000}},	//   _tshe_, nɗak, nšin_, --, 
   {{0x7bc41510,0x2d801619,0xfc3001b8,0xb62801f5}},	//   aziu, _ushe_, ئحہ_, _унiа, 
   {{0x6b880091,0x6d54161a,0x318c012c,0x00000000}},	//   _šegu, mrza, _měz_, --, 
   {{0x7bc4161b,0x2cf800b3,0x0b8800e1,0x996000bd}},	//   cziu, ंतील_, _усни_, _míře_, 
   {{0x6b8c04f8,0x6d54161c,0xe6100324,0x00000000}},	//   mvag, orza, پشت_, --, 
   {{0x56901458,0x6b8c161d,0xe578021d,0x00000000}},	//   тајт, lvag, ізи_, --, 
   {{0xe3b8161e,0x6adc161f,0x850000c3,0x00000000}},	//   жби_, _मदुर, رۈشن, --, 
   {{0x69c40aa3,0x6b8c1620,0x6d541621,0x00000000}},	//   lzhe, nvag, hrza, --, 
   {{0x6b8c0ca7,0x6cfc011a,0x00000000,0x00000000}},	//   ivag, _དེའེ_, --, --, 
   {{0x69c41622,0x6d54002f,0x7bc40880,0xf8c40095}},	//   nzhe, jrza, zziu, लोकय, 
   {{0x94241623,0x6d541624,0x69c40145,0x7eb0013c}},	//   _قومۇ, drza, izhe, _läpt, 
   {{0x6d5403ef,0x996001d5,0xf43400cc,0x4fa0021d}},	//   erza, _díře_, _чечэ, вияв, 
   {{0xe298009e,0x712401d9,0x8fa00106,0x128800ea}},	//   _фак_, بریل, њаре, _ومنی_, 
   {{0x6b8c1625,0x6d540098,0xa068044a,0x00000000}},	//   evag, grza, _дайа_, --, 
   {{0xa2d41626,0x7bc40054,0xeff80020,0x69c4015b}},	//   यचक्, tziu, ለይዎ_, dzhe, 
   {{0x69c40d7f,0xcb641627,0x09a800ac,0x6d54018c}},	// [1180] ezhe, мате_, _গেলা, arza, 
   {{0x9f500552,0x7eb00638,0x7bc41628,0x0f540107}},	//   _czyå_, _päpu, rziu, _קיים_, 
   {{0x58841629,0x6b8c162a,0x9f940551,0x7bc40496}},	//   дыла, avag, _хықә, sziu, 
   {{0x7e7c0a94,0x7bc41510,0x00000000,0x00000000}},	//   lerp, pziu, --, --, 
   {{0x69c40593,0x6b8c015b,0x00000000,0x00000000}},	//   azhe, cvag, --, --, 
   {{0x7e7c0a94,0x07a006d4,0x20d0028d,0xca8001e3}},	//   nerp, таљн, kšio_, еrеn, 
   {{0x7e7c01ab,0x20d001d1,0xe9700049,0x00000000}},	//   ierp, všin_, _مۇلد, --, 
   {{0x7e7c162b,0xe464162c,0x00000000,0x00000000}},	//   herp, _çöle_, --, --, 
   {{0x46e401c8,0x20c0059b,0x16640106,0x73d801d9}},	//   ядән_, _móid_, _овам, ядир_, 
   {{0xeb900282,0x7e7c0aa0,0xd258162d,0x00000000}},	//   אָט_, jerp, цци_, --, 
   {{0x20d0162e,0x6b8c162f,0x7eb00027,0xca5400cf}},	//   ršin_, zvag, _läps, וייז_, 
   {{0x3b1802b1,0x04900272,0x20c001ca,0x00000000}},	//   _lirq_, _للمح, _nóid_, --, 
   {{0x8260049d,0x7e7c0104,0x7eb00139,0x20d000e9}},	//   رهێن, ferp, _näps, pšin_, 
   {{0x7e7c1630,0xdcfc00bd,0x6d540dcb,0x20d00d2e}},	//   gerp, _trpě, trza, qšin_, 
   {{0x7eb0019f,0x41c00012,0xf388000d,0x6d5402b0}},	//   _räpt, _لٲوِ, _hợ_, urza, 
   {{0x20c00272,0x20d000ef,0x8f6400d5,0x00000000}},	//   _cóid_, nšil_, _قلعے_, --, 
   {{0x6b8c1631,0x69c40337,0x8d98001d,0xfa3401d9}},	// [1190] uvag, wzhe, ገላቸው_, چرمد, 
   {{0x6b8c1632,0x3b180496,0x32c000d3,0x69c40104}},	//   rvag, _cirq_, _fòye_, tzhe, 
   {{0x6b8c1633,0x6ab401c6,0xf388000d,0xe8540075}},	//   svag, _ĉefĵ, _lợ_, فناد, 
   {{0x69c40d7f,0x23b40229,0x807c0100,0x4c8001a0}},	//   rzhe, _jùjú_, ַנוצ, _جیرق, 
   {{0xf3880014,0xe7381634,0x7eb0012b,0x00000000}},	//   _nợ_, чел_, _täpt, --, 
   {{0xdddc1635,0xbb481636,0x66041637,0x9998004b}},	//   _hapš, _زلفن_, нпла, _کپٲر_, 
   {{0x492000f8,0x7eb00139,0xdddc00b0,0xe5701638}},	//   _рӯзҳ, _käpr, _kapš, اطت_, 
   {{0x63840116,0x7e7c0379,0x23341639,0xf38801eb}},	//   егиа, zerp, нхор, _bợ_, 
   {{0x7e7c044a,0x4680163a,0x2b48014a,0x00000000}},	//   yerp, _ақла, nsac_, --, 
   {{0x1304163b,0x7e7c01aa,0xdddc163c,0x26180388}},	//   нный_, xerp, _lapš, _पलटी_, 
   {{0xd12c163d,0xe1f802b3,0xd2f4005e,0x00000000}},	//   یمی_, яго_, رکها_, --, 
   {{0x20d0163e,0xd36c0324,0x7eb00139,0xa0a4163f}},	//   ršio_, جهی_, _näpr, хамд, 
   {{0x7e7c1640,0x20c00306,0xc1ec0030,0xefcc0222}},	//   terp, _róid_, _घुरब_, _ባውዛ_, 
   {{0xdcb00200,0x7e7c1641,0x7eb00027,0x20c00306}},	//   گىر_, uerp, _räps, _sóid_, 
   {{0x7e7c1642,0x7eb00027,0xf388000d,0x224400b0}},	//   rerp, _säps, _zợ_, malk_, 
   {{0xdcb01643,0x7e7c1644,0xd12c1645,0x7eb00104}},	//   دىر_, serp, _امي_, _päps, 
   {{0xfa2c0560,0x3b180380,0x6b880070,0xdddc00b0}},	// [11a0] _ཧྥུན_, _pirq_, _šegr, _dapš, 
   {{0x3b181646,0x7e7c0d2e,0x1ce40126,0xab78010f}},	//   _qirq_, qerp, ྫོང_, _የያዘው_, 
   {{0x2d840353,0x2bd40030,0x00000000,0x00000000}},	//   ælet_, _ठेठा, --, --, 
   {{0x7eb00076,0x22441647,0x0d8008dc,0x20d00070}},	//   _täps, halk_, _слюн, kšim_, 
   {{0x224406f3,0x2b480513,0x20d00c91,0xb8d800b6}},	//   kalk_, csac_, jšim_, _छव_, 
   {{0x09bc02fa,0x0cc002fa,0x6a140411,0x22441648}},	//   _আশরা, ্কৃত, ربەر, jalk_, 
   {{0xf3880710,0xceb00240,0xd6c404e7,0x5d780100}},	//   _sợ_, ריו_, ومچی, לאַק, 
   {{0x33740155,0xd3a41649,0x69c000b6,0x00000000}},	//   вгир, ероп, _ülea, --, 
   {{0x20d0164a,0x2244164b,0x8500132f,0x00000000}},	//   ršil_, falk_, دوين, --, 
   {{0xf3880710,0x00000000,0x00000000,0x00000000}},	//   _vợ_, --, --, --, 
   {{0xf484164c,0x20d003aa,0x25a00104,0x3ce0164d}},	//   _لاشی, pšil_, ählt_, kniv_, 
   {{0x20d001d1,0x2b48006f,0xf388000d,0x6adc0136}},	//   bšim_, ysac_, _tợ_, _मद्र, 
   {{0x2244164e,0x73c4164f,0xdfd000dd,0x60d40078}},	//   balk_, _шәке, ليٽ_, èzma, 
   {{0x3ce0013c,0x00000000,0x00000000,0x00000000}},	//   eniv_, --, --, --, 
   {{0x7eb0013b,0x20c00306,0x00000000,0x00000000}},	//   _päpr, _dóib_, --, --, 
   {{0xfaa401a0,0xd7880095,0x00000000,0x00000000}},	//   қшун, _oṃ_, --, --, 
   {{0xafc401c4,0x3c580254,0x00000000,0x00000000}},	// [11b0] _рәнй, эитэ_, --, --, 
   {{0x2d840056,0x00000000,0x00000000,0x00000000}},	//   æles_, --, --, --, 
   {{0xdddc1650,0x2b481651,0xd78801d3,0xb4b0006c}},	//   _tapš, ssac_, _aṃ_, _ऐकू_, 
   {{0x48cc00ac,0xf9680254,0x00000000,0x00000000}},	//   িক্র, эруй_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d40584,0x2ca800a1,0x20d00518,0x7eb01652}},	//   _येथी, ljad_, všim_, _jäpp, 
   {{0x6da401e7,0xfa2c0126,0xe5a4006e,0x224407b5}},	//   rɗaw, _ཧྥིན_, тийи, valk_, 
   {{0x7eb01653,0x442801d6,0x3af40479,0x2ca81654}},	//   _läpp, ùc_, läpp_, njad_, 
   {{0xe3b00272,0x69d400b3,0x752401c6,0xd764024b}},	//   شرة_, _येती, ĉiza, _لەنى_, 
   {{0x7eb01655,0x20d001df,0xf77011d2,0x2ca81656}},	//   _näpp, ršim_, _داف_, hjad_, 
   {{0xb3840396,0xd7000023,0x224401f6,0x1fb800bd}},	//   влөл, _лiта, ralk_, उन्ड, 
   {{0x2ca81657,0x20d0059a,0x645c03b2,0x3af4000b}},	//   jjad_, pšim_, ósid, häpp_, 
   {{0x248c1658,0x3af41659,0x2ca8165a,0x2244165b}},	//   mdem_, käpp_, djad_, palk_, 
   {{0x248c165c,0xe1941442,0x236c0098,0x00000000}},	//   ldem_, _ариэ, mtej_, --, 
   {{0x20c00306,0x236c0156,0xdd900075,0x00000000}},	//   _cóic_, ltej_, جوز_, --, 
   {{0x248c165d,0x3ce0021d,0x1fb4165e,0xa3e40cd4}},	//   ndem_, univ_, _асор, _नशा_, 
   {{0x248c165f,0x236c0069,0x5a6411aa,0x8b200049}},	// [11c0] idem_, ntej_, ккаб, идте, 
   {{0x1d240f5d,0x248c1660,0x3ce01661,0x2ca80030}},	//   _имом, hdem_, sniv_, ajad_, 
   {{0x69d403bf,0x00000000,0x00000000,0x00000000}},	//   _येदी, --, --, --, 
   {{0xd7f81662,0x248c1663,0x236c0475,0x00000000}},	//   мул_, jdem_, ktej_, --, 
   {{0x248c1664,0x69c01665,0x56900049,0x00000000}},	//   ddem_, _ülen, ғақт, --, 
   {{0x248c0037,0x7ccc1666,0x00000000,0x00000000}},	//   edem_, rşru, --, --, 
   {{0x248c0034,0xa2c41667,0x00000000,0x00000000}},	//   fdem_, िसन्, --, --, 
   {{0x09e001a7,0x248c1668,0x00000000,0x00000000}},	//   _тосн, gdem_, --, --, 
   {{0x2c6c00cd,0xd6281669,0xb9ec0020,0x53e40668}},	//   lódó_, _жозе_, _ኔራ_, ъцка, 
   {{0x8574166a,0x248c166b,0x20d001d1,0x00000000}},	//   хсәт_, adem_, lših_, --, 
   {{0x7eb011d1,0x236c00c0,0x154401f1,0x4a58023c}},	//   _räpp, atej_, _реем, ודיו, 
   {{0xc5a4166c,0x236c0428,0xa5d80100,0x813401a0}},	//   _جڏهن_, btej_, _אַני, کسیز_, 
   {{0x35a813aa,0x2ca807b5,0x59c00523,0x00000000}},	//   _कपड़, vjad_, वैतर, --, 
   {{0x7a480059,0xb6e0011a,0x2ca80080,0x00000000}},	//   nūtē, _སམྦྷ, wjad_, --, 
   {{0x91040c00,0x8c6403c4,0x2ca800a1,0x20d00070}},	//   _ичид, ктад, tjad_, kših_, 
   {{0x20d014ba,0x2d84012f,0x02140107,0x2ca8013c}},	//   jših_, æleq_, _בחום_, ujad_, 
   {{0x2ca8166d,0x7eb0166e,0x0a6800b8,0xe7bc0143}},	// [11d0] rjad_, _täpp, дреи_, _আখ্য, 
   {{0x2ca800b6,0x248c166f,0x00000000,0x00000000}},	//   sjad_, zdem_, --, --, 
   {{0xe9b40329,0x29d400cc,0x2ca800af,0x7ff40061}},	//   ыбжь, دياس, pjad_, _مسیا, 
   {{0xcc84049d,0xa2140100,0x00000000,0x00000000}},	//   _جۆره_, אַנס_, --, --, 
   {{0x27e81670,0x20c00111,0xa2c41671,0x3af4000b}},	//   çan_, _jóia_, िसम्, päpp_, 
   {{0x69c00030,0x236c1672,0x27e80560,0x26c0001e}},	//   _üleo, vtej_, ħan_, óho_, 
   {{0x248c03c8,0x24f40182,0x20d007b5,0x00000000}},	//   tdem_, лчир, bših_, --, 
   {{0xdb1c0212,0x248c1673,0xdcfc0513,0x25a801df}},	//   _švéd, udem_, _ispă, ćal_, 
   {{0x248c1674,0xd82c01ac,0xe2b40094,0x00000000}},	//   rdem_, _رڍن_, гснэ, --, 
   {{0xf7701675,0x248c044f,0x6d5804c4,0x236c1676}},	//   _گاہ_, sdem_, _āwan, rtej_, 
   {{0x236c0d3c,0x248c02ba,0xe4741677,0xe0d80320}},	//   stej_, pdem_, _булэ, евн_, 
   {{0xd5b80282,0xf77001b5,0x20c000b7,0x236c1678}},	//   _אזעל, _داہ_, _bóia_, ptej_, 
   {{0x442c0693,0x64480062,0x00000000,0x00000000}},	//   _ifg_, maei, --, --, 
   {{0x66f406f7,0x35d8021f,0x64481679,0xdcfc0513}},	//   ेतिक_, _भेड़, laei, _ospă, 
   {{0x5de40348,0x68e801c6,0xf1a80324,0xdc980320}},	//   ужва, _ĉedn, _لايه_, нташ_, 
   {{0x6448167a,0x442c002a,0x27e80098,0x7e64001e}},	//   naei, _jfg_, żany_, ыхҭҵ, 
   {{0x442c06ef,0x20d0167b,0xda580074,0x00000000}},	// [11e0] _mfg_, vših_, ереш_, --, 
   {{0x7bc00c60,0x6448167c,0x442c01f1,0x1e84167d}},	//   _ümum, haei, _lfg_, _слом, 
   {{0x5f74167e,0x69c0167f,0x1ce40126,0x62800513}},	//   _شاکر, _ülel, ྫོད_, ielo, 
   {{0x5ca41680,0x62801681,0x2bd400b3,0x3b780020}},	//   _симб, helo, _ठेवा, _ኣጋይሽ_, 
   {{0x62801682,0x38c81683,0x64481658,0x90380100}},	//   kelo, _یاری_, daei, גענה, 
   {{0x62801684,0x442c04e7,0xd94401ac,0x69c003bf}},	//   jelo, _afg_, _مئري, लनशी, 
   {{0x62801685,0x20d003e8,0x60d40116,0x644802b2}},	//   delo, pših_, _omym, faei, 
   {{0x442c1686,0x62801687,0x55040087,0x64481688}},	//   _cfg_, eelo, ычла, gaei, 
   {{0x62801689,0xb4e40e8f,0x00000000,0x00000000}},	//   felo, _नदी_, --, --, 
   {{0x6280168a,0x6448168b,0x0374168c,0x00000000}},	//   gelo, aaei, احيت_, --, 
   {{0xc1b405bc,0x645c0b07,0x64480034,0x00000000}},	//   глэх_, ósic, baei, --, 
   {{0x62800197,0x442c01d4,0x312400cc,0x6604002a}},	//   aelo, _gfg_, лдүг, ühke, 
   {{0xba00010f,0xb4c002d7,0x00000000,0x00000000}},	//   _ቁጭ_, ँसी_, --, --, 
   {{0x940003a2,0x1db0006c,0x8d8401d9,0x00000000}},	//   _پوڙه, ीनंत, лубд, --, 
   {{0xf17003b5,0xc6b400ca,0x00000000,0x00000000}},	//   _بێجگ, נהלי_, --, --, 
   {{0x317c01d5,0xd13c001d,0x28b8168d,0x00000000}},	//   _ipvz_, ካባቢው, _आवधि, --, 
   {{0x4bd804c3,0x7cf800ec,0x00000000,0x00000000}},	// [11f0] ربرد_, ѳнсѳ_, --, --, 
   {{0x6e9400bf,0x00000000,0x00000000,0x00000000}},	//   _ئلدا, --, --, --, 
   {{0xa2c400cb,0xad8400c3,0x20c001ca,0x69d4006c}},	//   िसत्, _ئاخۇ, _móin_, _येशी, 
   {{0x6280168e,0xac94168f,0x69c01690,0x20c0059b}},	//   zelo, _тамш, _ülem, _lóin_, 
   {{0x49901691,0x492000f8,0x64481692,0x442c00c2}},	//   _گیار, рӯҳҳ, vaei, _rfg_, 
   {{0x62801693,0x9ba002be,0x65f802dc,0x20c00306}},	//   xelo, _بەكى, кэйр_, _nóin_, 
   {{0x499002a5,0x62801694,0x64a41695,0xb4c000b6}},	//   _دیار, velo, иака, ँसू_, 
   {{0x62801696,0x57b0006e,0x00000000,0x00000000}},	//   welo, сбәт, --, --, 
   {{0x62801697,0x290c1698,0x383410f3,0x240802dc}},	//   telo, _ihea_, _ынтр, ънии_, 
   {{0x27ec02ba,0x628003f4,0x68e802bb,0x60d40086}},	//   _ixen_, uelo, _hjed, _smym, 
   {{0x26c41699,0x6280169a,0x68e80c81,0x64481607}},	//   _illo_, relo, _kjed, paei, 
   {{0x6280169b,0x442c169c,0x00000000,0x00000000}},	//   selo, _ufg_, --, --, 
   {{0x6280169d,0x68e802b4,0x5f04169e,0x20c00075}},	//   pelo, _mjed, изма, _fóin_, 
   {{0x68e8169f,0x290c0616,0x62800110,0xe1f80836}},	//   _ljed, _lhea_, qelo, _игл_, 
   {{0x68e816a0,0x290c01aa,0x63a803b2,0xadc401c4}},	//   _ojed, _ohea_, lxen, барһ, 
   {{0x68e816a1,0x27ec16a2,0x63a816a3,0x290c0306}},	//   _njed, _oxen_, oxen, _nhea_, 
   {{0x63a816a4,0x26c416a5,0xdee416a6,0x69c000a1}},	// [1200] nxen, _ollo_, _вопи, _ülej, 
   {{0x290c16a7,0x63a80128,0x68e816a8,0x1994005b}},	//   _ahea_, ixen, _ajed, ијер, 
   {{0x68e800e9,0x598403ba,0x00000000,0x00000000}},	//   _bjed, рлеб, --, --, 
   {{0x290c16a9,0x26c416aa,0x7f440046,0x68e802db}},	//   _chea_, _allo_, _kwiq, _cjed, 
   {{0x68e807e7,0x290c16ab,0x907400cf,0x00000000}},	//   _djed, _dhea_, שענא_, --, 
   {{0x68e816ac,0x290c0299,0x00000000,0x00000000}},	//   _ejed, _ehea_, --, --, 
   {{0x09e005bc,0x27ec018c,0x290c16ad,0x68e80056}},	//   _дорн, _exen_, _fhea_, _fjed, 
   {{0x68e816ae,0x26c416af,0xb4c016b0,0x290c006a}},	//   _gjed, _ello_, ँसे_, _ghea_, 
   {{0x63a813eb,0xa5080121,0xd1d400ff,0x20d002cc}},	//   gxen, دىيە_, ርደት_, nšiu_, 
   {{0x68e816b1,0x0634010f,0x00000000,0x00000000}},	//   _zjed, ከናወነ, --, --, 
   {{0xd7f816b2,0x7afc02a0,0x20d002cc,0x00000000}},	//   _чуң_, _mkrt, hšiu_, --, 
   {{0xefe8010f,0x764816b3,0x2f88001e,0x4fc40094}},	//   _መላው_, _hedy, гәон_, асга, 
   {{0xdc2c038c,0x752816b4,0x764816b5,0x20d002d9}},	//   _sığo, _hudz, _kedy, jšiu_, 
   {{0x752816b6,0x764806f7,0x7b1006ef,0x0ea40aff}},	//   _kudz, _jedy, läuf, खाधड, 
   {{0x764816b7,0x75280201,0x00000000,0x00000000}},	//   _medy, _judz, --, --, 
   {{0x752816b8,0x764816b9,0x00000000,0x00000000}},	//   _mudz, _ledy, --, --, 
   {{0x752816ba,0x290c16bb,0x68e8046e,0x00000000}},	// [1210] _ludz, _rhea_, _rjed, --, 
   {{0x68e816bc,0x69c000a1,0x75280088,0xdd900a1d}},	//   _sjed, _ülek, _oudz, _کوٽ_, 
   {{0xc8a80683,0xdb080009,0x6e2402b0,0x7b100104}},	//   къде_, _ónýt, _ighb, käuf, 
   {{0x27ec01e3,0x2cac0030,0x20d000c0,0xa81400b7}},	//   _pxen_, _õed_, bšiu_, бдеш, 
   {{0x68e802b4,0x752816bd,0x764816be,0x63a816bf}},	//   _vjed, _audz, _bedy, xxen, 
   {{0x752816c0,0x290c04c4,0x65c416c1,0x764816c2}},	//   _budz, _whea_, йбла, _cedy, 
   {{0x68e80cb1,0x290c16c3,0x764816c4,0x752816c5}},	//   _tjed, _thea_, _dedy, _cudz, 
   {{0x68e816c6,0x75280082,0x764816c7,0x63a816c8}},	//   _ujed, _dudz, _eedy, txen, 
   {{0xe29816c9,0x6e240380,0x82600121,0x764803c7}},	//   гап_, _oghb, قۇشن, _fedy, 
   {{0x6d44147c,0x63a816a5,0x68f816ca,0x26c416cb}},	//   _owha, rxen, lowd, _ullo_, 
   {{0xd24c16cc,0x63a8000f,0x752816cd,0x67280475}},	//   ژنی_, sxen, _gudz, _huej, 
   {{0x672016ce,0x6e240444,0xf4840836,0x673c011a}},	//   _hilj, _aghb, _мучн, _ħsjj, 
   {{0x443c16cf,0x6d4416d0,0x660016d1,0xbec816d2}},	//   mbu_, _awha, _hylk, иңиз_, 
   {{0x443c16d3,0x6d4416d4,0x7528003b,0x6600021c}},	//   lbu_, _bwha, _yudz, _kylk, 
   {{0x2d9416d5,0xdca416d6,0xdafc0552,0x91e002c9}},	//   ортс, бави, pãºl, _ноше, 
   {{0x443c16d7,0x672016d8,0x6e240156,0x660002bb}},	//   nbu_, _lilj, _eghb, _mylk, 
   {{0x443c16d9,0x6d4400a2,0x68f816da,0x672800e5}},	// [1220] ibu_, _ewha, dowd, _nuej, 
   {{0x443c16db,0x6ab40337,0x9e6416dc,0xeb5416dd}},	//   hbu_, _cozf, _увод, زىمگ, 
   {{0x764816de,0x66000027,0x6d440086,0x68f80080}},	//   _redy, _nylk, _gwha, fowd, 
   {{0x443c16df,0x752816e0,0xad240012,0x67280085}},	//   jbu_, _rudz, _گریو, _buej, 
   {{0x7d0416e1,0x752816e2,0x672802ba,0x764816e3}},	//   mlis, _sudz, _cuej, _pedy, 
   {{0x7d0416e4,0x672016e5,0x660016e6,0x6d440c2f}},	//   llis, _cilj, _bylk, _ywha, 
   {{0x672016e7,0x7d0416e8,0x75280088,0x6d5800a2}},	//   _dilj, olis, _qudz, _āwak, 
   {{0x7d0416e9,0x443c05a3,0x7648009c,0x68f816ea}},	//   nlis, gbu_, _wedy, cowd, 
   {{0x7d0416eb,0x672800b8,0x57e80027,0x00000000}},	//   ilis, _guej, _сдам_, --, 
   {{0x7d0416ec,0x660016ed,0x672016ee,0x76480249}},	//   hlis, _fylk, _gilj, _uedy, 
   {{0x7d0416ef,0x443c16f0,0x8af805a8,0x5228001d}},	//   klis, bbu_, רהיי, _ተናግሯ, 
   {{0x7d0416f1,0xa0340041,0x672002bb,0x443c16f2}},	//   jlis, يىپت, _zilj, cbu_, 
   {{0x7d0416f3,0x7eb00027,0x66000201,0x00000000}},	//   dlis, _häpy, _zylk, --, 
   {{0x7d0416f4,0x7eb002eb,0xdcfc004f,0x00000000}},	//   elis, _käpy, _āvād, --, 
   {{0x7d0416f5,0x1cb00560,0x6ab400ef,0x799c015e}},	//   flis, _དྭང_, _rozf, _nrrw, 
   {{0x09c00664,0x69c00030,0x00000000,0x00000000}},	//   ্পমা, _ülei, --, --, 
   {{0xcee816f6,0x20d016f7,0x7eb00027,0x930800dc}},	// [1230] _مردن_, ršit_, _läpy, রদীপ_, 
   {{0x443c16f8,0x6e240140,0x67280475,0xdb0c0229}},	//   zbu_, _ughb, _ruej, _òjìj, 
   {{0x7d0416f9,0x443c0113,0x20d016fa,0x6ab40048}},	//   blis, ybu_, mšir_, _vozf, 
   {{0x2d800197,0x1f2401b5,0x01f800cf,0x00000000}},	//   _iphe_, _دِیہ, נפאל, --, 
   {{0xd36416fb,0x672816fc,0x443c0214,0x68f816fd}},	//   _ته_, _quej, vbu_, rowd, 
   {{0xd12416fe,0xe5a404e7,0x660016ff,0xaa5c024b}},	//   _يم_, жики, _pylk, _шегi, 
   {{0x67201700,0x645c00b7,0xd6d40061,0x00000000}},	//   _vilj, ósio, تووش_, --, 
   {{0x2d8001c4,0x672802bb,0x68f80080,0x00000000}},	//   _mphe_, _tuej, qowd, --, 
   {{0x443c1701,0x7b100e48,0x6720011a,0x78ac03aa}},	//   rbu_, bäud, _tilj, ťové, 
   {{0x66001471,0x443c1702,0x7d041703,0x67200616}},	//   _tylk, sbu_, zlis, _uilj, 
   {{0x60e80f15,0xd04c02df,0xd24c00e2,0x7b10002a}},	//   имом_, licə, کنۍ_, säug, 
   {{0x7d0402ac,0x443c0110,0xa0681704,0x6b9c1705}},	//   xlis, qbu_, шама_, _orsg, 
   {{0x2d801706,0x7d041707,0x64581708,0x7880030f}},	//   _aphe_, vlis, _idwi, _hávæ, 
   {{0x7d041709,0xe3f800dd,0x69100353,0x00000000}},	//   wlis, _ٽوڙڻ_, låed, --, 
   {{0x7d04170a,0x9310049d,0xd440001d,0x00000000}},	//   tlis, _تووش, _የቀበሌ, --, 
   {{0x1be8023f,0xda6400dd,0x69100056,0x5f28170b}},	//   адби_, ڪاري, nåed, _коим_, 
   {{0x7d04170c,0x2d80042e,0x5ba8170d,0x3f8000b0}},	// [1240] rlis, _ephe_, шкам_, _upiu_, 
   {{0x7d04170e,0xda6403e0,0xd1c000ff,0xd04c02a0}},	//   slis, تاري, _ድርብ_, dicə, 
   {{0x645806f7,0x1d08170f,0x98481710,0x5ea4005e}},	//   _odwi, _вени_, аяла_, _همکل, 
   {{0x645808a2,0x7d0403af,0x23c80a9e,0x2bd400a1}},	//   _ndwi, qlis, िनाद, _ठेका, 
   {{0xda6403a2,0x6d5800a2,0x473000ea,0x00000000}},	//   _واسي, _āwai, وروز, --, 
   {{0x8f981711,0xd9440332,0x64581712,0x3ce0013c}},	//   ייני, _меги, _adwi, liiv_, 
   {{0x77f400dd,0x628402e8,0x79540061,0x00000000}},	//   _کڻائ, _óhoy, _رێشا, --, 
   {{0x69100353,0x6458002a,0xd3780320,0x81ac0143}},	//   gåed, _cdwi, ачо_, ওনা_, 
   {{0xb8640046,0x88b00063,0xc47402ac,0xf9ec00dc}},	//   _واړو, _تینچ, تینچ_, _করিল_, 
   {{0x64581713,0x3ce00310,0x37c40121,0x4b781714}},	//   _edwi, hiiv_, _мәһб, סטיג, 
   {{0xc0cc0020,0x00000000,0x00000000,0x00000000}},	//   _ቢሎም_, --, --, --, 
   {{0x6ab81715,0x00000000,0x00000000,0x00000000}},	//   _ेत्र, --, --, --, 
   {{0x69c00076,0x2d800636,0x73c4002c,0x00000000}},	//   _ülev, _sphe_, _хәйе, --, 
   {{0x752400df,0x7b100630,0x2bd407aa,0x00000000}},	//   ňizd, häub, _ठेगा, --, 
   {{0x823000e2,0x463800cf,0x00000000,0x00000000}},	//   _غروا, שעלע, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1250] --, --, --, --, 
   {{0x7f841716,0x6b5006b4,0x705401b8,0xc98401d9}},	//   _کلین, _aðgá, _بچھا, жуди, 
   {{0x2d80041c,0xa2a0025c,0xd6c00143,0x00000000}},	//   _uphe_, _कोफ्, ্চায, --, 
   {{0xd04c0c60,0x26f41717,0x6d5401b8,0x8ca00e75}},	//   ticə, ेत्र_, msza, _تەرو, 
   {{0x6d5400cd,0x478803d6,0xdc34007c,0x23d80030}},	//   lsza, рсем_, _מארט_, _बेंद, 
   {{0x6b8c1718,0x6a241719,0x00000000,0x00000000}},	//   mwag, _رفرم, --, --, 
   {{0x6b8c171a,0x6d54171b,0x69100353,0x00000000}},	//   lwag, nsza, tåed, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b8c171c,0x2cb800f2,0x00000000,0x00000000}},	//   nwag, _mosd_, --, --, 
   {{0x6594171d,0x2cb80177,0x6b8c01ed,0x6d54171e}},	//   _назу, _losd_, iwag, ksza, 
   {{0x6b8c171f,0xe2980f5d,0x6d541720,0x7b10002a}},	//   hwag, _ҳал_, jsza, läuc, 
   {{0x69c000b6,0x34f00152,0x00000000,0x00000000}},	//   _üleu, _үҗәт, --, --, 
   {{0xe2981721,0xe7bc1722,0x10a01723,0x6d5403ef}},	//   _гал_, ्निप, хиян, esza, 
   {{0x2cb801d6,0x5398023c,0x6b8c1724,0x00000000}},	//   _aosd_, _לינו, dwag, --, 
   {{0x6d5400cd,0x3ce00030,0xdca41725,0x00000000}},	//   gsza, tiiv_, пави, --, 
   {{0x2cb801d6,0x6b8c0c92,0x91b800ca,0xe7bc03ec}},	//   _cosd_, fwag, _למצי, ्नाप, 
   {{0x6b8c1726,0x2cb800c4,0x00000000,0x00000000}},	// [1260] gwag, _dosd_, --, --, 
   {{0xff2407bc,0xcff40107,0x0dc40020,0x3ce0013c}},	//   _تبعی, _מצפה_, _ጽሒፉ_, siiv_, 
   {{0x6b8c007b,0x7b100a79,0xd83801a7,0x00000000}},	//   awag, täub, бэл_, --, 
   {{0x6b8c1727,0x18681728,0x77940191,0x8f5001d9}},	//   bwag, сади_, ویزا, _تنیش, 
   {{0x7b10007f,0x6b8c0211,0x47301729,0x5ba0002c}},	//   räub, cwag, еніс, _яһағ, 
   {{0x7b10002a,0x00000000,0x00000000,0x00000000}},	//   säub, --, --, --, 
   {{0xda6401ac,0xd94400b7,0x00000000,0x00000000}},	//   _واڳي, _хеби, --, --, 
   {{0xd94402dc,0xdc38021d,0x00000000,0x00000000}},	//   _меҳи, ацiї_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb6c8063a,0x6d54172a,0x2618006c,0x31340123}},	//   _بارے_, ysza, येही_, меор, 
   {{0x6b8c172b,0x69c000a1,0x97000121,0xd4980111}},	//   zwag, _ület, _قېچى, _грл_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0440172c,0xc4d000ca,0xbef8006c,0x4ea403a7}},	//   _чечн, _אגף_, ंकून_, прва, 
   {{0x5274172d,0x6d54172e,0x0ee8172f,0x00000000}},	//   _худу, tsza, сьми_, --, 
   {{0x6b8c1730,0xdcfc0192,0x00000000,0x00000000}},	//   wwag, _uspě, --, --, 
   {{0x6d541731,0x6b8c1732,0x85380100,0x00000000}},	//   rsza, twag, מגלי, --, 
   {{0x6d54063a,0x2ef41733,0xfc301734,0x4ba402ba}},	// [1270] ssza, _озир, احف_, чөнү_, 
   {{0x6b8c1735,0x6d541736,0x00000000,0x00000000}},	//   rwag, psza, --, --, 
   {{0x7c580121,0x2cb801d6,0x00000000,0x00000000}},	//   زلەر_, _tosd_, --, --, 
   {{0xd1dc02b4,0x6b8c018c,0x7b10000b,0x00000000}},	//   _ዓዋተ_, pwag, täuc, --, 
   {{0x3a380172,0xfb8400fb,0x00000000,0x00000000}},	//   _ffrp_, _пырн, --, --, 
   {{0x3a381737,0x66041738,0x7b100e48,0x00000000}},	//   _gfrp_, мпла, räuc, --, 
   {{0xf6501739,0x06ac0143,0x00000000,0x00000000}},	//   ائه_, _কতদি, --, --, 
   {{0xfbc403ef,0x233402dc,0xf7700061,0x61ec004f}},	//   लैकम, мхор, _ڕام_, _śalo, 
   {{0xd36c03a2,0xd7000007,0x00000000,0x00000000}},	//   لهي_, _кiра, --, --, 
   {{0x69c00076,0x1304173a,0x41400108,0xa1c4173b}},	//   _üles, мный_, ндоң, дбод, 
   {{0x2088173c,0xf380024b,0xc1040108,0x00000000}},	//   ойни_, _ұғым, нүкл, --, 
   {{0xd36c0324,0x00000000,0x00000000,0x00000000}},	//   دهی_, --, --, --, 
   {{0x34380324,0xd24c00cc,0x00000000,0x00000000}},	//   _رسند_, اچۇ_, --, --, 
   {{0x62240108,0x00000000,0x00000000,0x00000000}},	//   _قىشل, --, --, --, 
   {{0x2b58000d,0x00000000,0x00000000,0x00000000}},	//   _avsc_, --, --, --, 
   {{0xdcb00121,0xa2c4173d,0x6e340094,0x00000000}},	//   خىر_, िसक्, _үхэх, --, 
   {{0x2b5802ba,0xd9d000c3,0x9f180075,0x00000000}},	// [1280] _cvsc_, ھەرگ, _وآخر_, --, 
   {{0xd94400b7,0x2b5800d5,0xd9d00108,0x00000000}},	//   дежи, _dvsc_, پەرگ, --, 
   {{0x224000b6,0xab6400ce,0x00000000,0x00000000}},	//   _õhku_, _atļā, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x46a01166,0x00000000,0x00000000,0x00000000}},	//   качв, --, --, --, 
   {{0x6aa00306,0x26180030,0x00000000,0x00000000}},	//   _ólfa, येली_, --, --, 
   {{0x23c80813,0x27f8014a,0x05140075,0x00000000}},	//   िनंद, égné_, وزيع_, --, 
   {{0x69c000b6,0xe87401a0,0x48e0173e,0x12880668}},	//   _üler, _سنلگ, _ротв, ощни_, 
   {{0x96c80012,0x4cc402fa,0x00000000,0x00000000}},	//   _ببرِ_, রোপু, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2248173f,0xd4c40272,0xe4a40302,0x00000000}},	//   _đake_, _تغطي, _пріо, --, 
   {{0x3cf40a9e,0x00000000,0x00000000,0x00000000}},	//   ्कने_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6ee802db,0x00000000,0x00000000,0x00000000}},	//   džbe, --, --, --, 
   {{0x24881740,0x7bc40034,0x00000000,0x00000000}},	// [1290] _ñame_, gyiu, --, --, 
   {{0xed501741,0x00000000,0x00000000,0x00000000}},	//   _مھر_, --, --, --, 
   {{0x80681742,0xdb241743,0x59c4081a,0x00000000}},	//   _عمیق_, رومی, लनगर, --, 
   {{0xf7700122,0x00000000,0x00000000,0x00000000}},	//   ڤان_, --, --, --, 
   {{0xd364024c,0x64bc00cb,0x00000000,0x00000000}},	//   _حه_, ṇika, --, --, 
   {{0xda7c02cc,0x00000000,0x00000000,0x00000000}},	//   íďte_, --, --, --, 
   {{0x2d90017b,0xd6240074,0x00000000,0x00000000}},	//   nwze_, ноше_, --, --, 
   {{0xe3b80332,0xf7701744,0x69c4042e,0x00000000}},	//   зби_, _چال_, myhe, --, 
   {{0xf7701745,0x69c41746,0x291c0472,0x07e400e2}},	//   _نال_, lyhe, mmwa_, _کېږی_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69c41747,0xd7001748,0x20100098,0x4fa00123}},	//   nyhe, _кiта, _szyi_, ҳияв, 
   {{0xe0d00324,0x00000000,0x00000000,0x00000000}},	//   ازد_, --, --, --, 
   {{0x248c1749,0x291c0088,0x7bc40008,0x6f0401eb}},	//   meem_, imwa_, xyiu, _bkhc, 
   {{0x248c174a,0xe298174b,0x69c4174c,0xd35400cf}},	//   leem_, _хак_, kyhe, _װיקי_, 
   {{0xdd90174d,0x2ee00353,0x21a400cc,0x1d1401f1}},	//   دوز_, _dmhf_, _чийм, еќар, 
   {{0x248c174e,0x02dc00b6,0x00000000,0x00000000}},	//   neem_, _फगुन, --, --, 
   {{0x5ac8174f,0x80cc006c,0x00000000,0x00000000}},	// [12a0] плам_, ासीं, --, --, 
   {{0x248c1750,0x19f40e44,0xd1c0001d,0x00000000}},	//   heem_, нџер, _ድርቅ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2a01751,0x248c1752,0x7bc4001e,0x58941753}},	//   _कोस्, jeem_, pyiu, عجاز, 
   {{0x248c1754,0x5724024b,0xc7a00139,0x00000000}},	//   deem_, ىرتق, лицк, --, 
   {{0x69c41755,0x00000000,0x00000000,0x00000000}},	//   byhe, --, --, --, 
   {{0x248c1756,0x69c01757,0x69c4015e,0x34941758}},	//   feem_, _ülep, cyhe, вайр, 
   {{0x248c0d8c,0x69101759,0x00000000,0x00000000}},	//   geem_, låen, --, --, 
   {{0xf3180155,0x20c001ca,0x7414175a,0x53e40023}},	//   моиш_, _lóis_, کوکا, эцка, 
   {{0x35c400b8,0x7b100104,0xdb040152,0x1a9800cf}},	//   _иазҳ, zäun, _ömäg, ליִע, 
   {{0xb9cc0422,0x20c0175b,0x248c175c,0x00000000}},	//   _ሰነ_, _nóis_, beem_, --, 
   {{0x248c175d,0x85f400ca,0x00000000,0x00000000}},	//   ceem_, _אצבע_, --, --, 
   {{0xbfa8175e,0x7b1002eb,0x00000000,0x00000000}},	//   нтре_, väun, --, --, 
   {{0x63ac000e,0xf48403b5,0x841001f5,0x00000000}},	//   _šang, _ساڵی, _сміх, --, 
   {{0x5184175f,0xc0e00222,0x51a80074,0x00000000}},	//   _чула, ነሎም_, _хълм_, --, 
   {{0xdd9802dc,0x3b180426,0x6604002a,0x00000000}},	//   ӯшӣ_, _ahrq_, ühki, --, 
   {{0x7bf81760,0x8244001d,0xa2c4040e,0x00000000}},	// [12b0] ентр_, _የአባቶ, िसच्, --, 
   {{0x69c41761,0x69101762,0x20f40299,0x248c1763}},	//   tyhe, gåen, māia_, zeem_, 
   {{0x291c00ba,0x20c001f1,0x248c007b,0x6ac01764}},	//   tmwa_, _góis_, yeem_, _शकीर, 
   {{0x69c41765,0x291c1766,0x248c1767,0x00000000}},	//   ryhe, umwa_, xeem_, --, 
   {{0x8d2400fc,0xd754020d,0x248c00b7,0xdcfc004f}},	//   _онүң_, پلىت_, veem_, _uppā, 
   {{0x248c038a,0x00000000,0x00000000,0x00000000}},	//   weem_, --, --, --, 
   {{0x20f400a2,0x248c1768,0xa2a004aa,0x20c0059b}},	//   hāia_, teem_, _कोष्, _móir_, 
   {{0x262401e7,0x71540020,0x00000000,0x00000000}},	//   rɓo_, _መሰላቶ, --, --, 
   {{0x248c065b,0xc6a400e1,0x00000000,0x00000000}},	//   reem_, _пржи, --, --, 
   {{0x248c1769,0x8244001d,0x00000000,0x00000000}},	//   seem_, _የበሽታ, --, --, 
   {{0x63ac176a,0x64a400c3,0xc0e00020,0x00000000}},	//   _šand, _җаһа, _ነጊሱ_, --, 
   {{0xa2a00280,0x98a8015b,0x20c00306,0x726c001d}},	//   _कोर्, _kubā_, _róis_, _ተጠየቀ_, 
   {{0x6448176b,0x1ea803a2,0x20c000b7,0x442c0f37}},	//   mbei, واسي_, _sóis_, _igg_, 
   {{0x20c00272,0xa2e4038e,0x601c02cc,0x0d740012}},	//   _cóir_, _шолд, _rámč, ھیُک_, 
   {{0x442c025e,0xb8e4043b,0x6910021d,0x6280176c}},	//   _kgg_, _ཏྭ_, våen, mflo, 
   {{0x6448176d,0x753c0191,0x442c0207,0x6c740182}},	//   nbei, _érze, _jgg_, луух, 
   {{0x6910176e,0x6448176f,0xfca800e2,0x6280018c}},	// [12c0] tåen, ibei, واړو_, oflo, 
   {{0x62801770,0x64480337,0x4a401771,0xcb6401f1}},	//   nflo, hbei, инув, тафе_, 
   {{0x6910021d,0x64481772,0x9d441773,0xcee001d2}},	//   råen, kbei, _шенд, _тұрқ, 
   {{0x442c0249,0x6a140121,0xc8601774,0xd7e41775}},	//   _ngg_, ھبەر, атши, кіло, 
   {{0x7d041776,0x2bc80021,0x7b100a79,0x62801777}},	//   mois, _रथया, läum, kflo, 
   {{0x7d041778,0x442c1779,0xa2a0177a,0x6448177b}},	//   lois, _agg_, _कोल्, ebei, 
   {{0x442c177c,0x0570177d,0x6448177e,0x2eec0d8c}},	//   _bgg_, لايد, fbei, éefi_, 
   {{0x7d04177f,0x22481780,0xd3a41781,0x62800c92}},	//   nois, _đaka_, вроп, eflo, 
   {{0x62801782,0x7b100104,0x44b001d2,0xf48402cf}},	//   fflo, häum, рбыс, ناکی, 
   {{0x7d041783,0x45300329,0x628005c0,0x442c027e}},	//   hois, ыхәт, gflo, _egg_, 
   {{0x7d0406ea,0x76581784,0xf4841785,0x442c1786}},	//   kois, mavy, _ماشی, _fgg_, 
   {{0x7d04021c,0x6ee801df,0x20f40296,0x63ac00e9}},	//   jois, džba, tāia_, _šane, 
   {{0x7d041787,0xc0e40007,0x248800b8,0x20c00306}},	//   dois, роўк, _ñama_, _póir_, 
   {{0x76581788,0xa4400122,0x00000000,0x00000000}},	//   navy, _پێیو, --, --, 
   {{0x2fcc0b53,0x7d0405e1,0x442c0aa0,0x1ee80ac9}},	//   šeg_, fois, _ygg_, روفی_, 
   {{0x7d041789,0x8c3803c8,0x6910178a,0x765800cb}},	//   gois, _maßg, gåel, havy, 
   {{0x20c003e0,0x7658178b,0xe7bc00ac,0xfb34178c}},	// [12d0] _tóir_, kavy, _অধ্য, интэ, 
   {{0x7658178d,0x7b100104,0x00000000,0x00000000}},	//   javy, bäum, --, --, 
   {{0x7d04178e,0x7658178f,0x6d4001c6,0x2d84043b}},	//   bois, davy, ŭlab, ħles_, 
   {{0xe7f401a7,0x00000000,0x00000000,0x00000000}},	//   лчлэ, --, --, --, 
   {{0x62800336,0x00000000,0x00000000,0x00000000}},	//   yflo, --, --, --, 
   {{0x442c1790,0xba281643,0xfb84006b,0x2ed01791}},	//   _sgg_, رسەم_, _тыюн, _हतोत, 
   {{0x64481792,0xa5080091,0xc87801f1,0x00000000}},	//   tbei, нека_, _оџа_, --, 
   {{0x261805d5,0x38a403e9,0x00000000,0x00000000}},	//   येगी_, _кјуб, --, --, 
   {{0x64481793,0x76581794,0xf79402b3,0xd76409e5}},	//   rbei, bavy, _катэ, _مەنى_, 
   {{0x7d041795,0x64481796,0x39540223,0x6280002a}},	//   zois, sbei, _àasà_, uflo, 
   {{0x62801797,0x7d0400dd,0x7d0000c2,0x27380048}},	//   rflo, yois, _hârş, _hèn_, 
   {{0x62800959,0x20c00272,0x8fa00329,0x27380048}},	//   sflo, _cóip_, әаре, _kèn_, 
   {{0x2738065e,0x7d041798,0x6e28038c,0xe36401f5}},	//   _jèn_, vois, əmbə, _скли, 
   {{0x249c042a,0x7d040ee1,0x7d0000c2,0xd12c125b}},	//   _hawm_, wois, _mârş, _کمي_, 
   {{0xa0a402fb,0x249c0179,0x7d0406ea,0x6910106f}},	//   _байд, _kawm_, tois, tåel, 
   {{0x7b1006ef,0x76581799,0x00000000,0x00000000}},	//   räum, zavy, --, --, 
   {{0x7d04179a,0xcb64179b,0x8c040252,0x7658179c}},	// [12e0] rois, лате_, লেসন_, yavy, 
   {{0x249c0b2a,0x7f44179d,0x8f9811e7,0x7d040274}},	//   _lawm_, _itiq, _טיפי, sois, 
   {{0x7d04179e,0x98a402ed,0x9a140254,0x49b002de}},	//   pois, лиже, уфаш, бәту, 
   {{0x2738179f,0x249c01f9,0x765801dc,0x00000000}},	//   _bèn_, _nawm_, wavy, --, 
   {{0x765817a0,0xe7940012,0xabb402ba,0x00000000}},	//   tavy, لاوک, _кёръ, --, 
   {{0x273817a1,0x1ae400cc,0x70e000bd,0x41d003ec}},	//   _dèn_, _согм, _पग्ल, दनास, 
   {{0x765817a2,0x7f44018f,0x00000000,0x00000000}},	//   ravy, _ltiq, --, --, 
   {{0x765817a3,0x249c0069,0x2ed017a4,0x280800c0}},	//   savy, _cawm_, _हत्त, ätný_, 
   {{0x249c01ba,0x765817a5,0x07a017a6,0xe70817a7}},	//   _dawm_, pavy, _латн, رتۇن_, 
   {{0x63ac0214,0x4b78007c,0x325400f8,0x45d0001e}},	//   _šanc, עטיג, швор, рцәт, 
   {{0x249c01f9,0x7f4417a8,0xf0b417a9,0x814017aa}},	//   _fawm_, _atiq, айнь, ینین, 
   {{0x273817ab,0x249c01f9,0x6ac000cb,0x00000000}},	//   _yèn_, _gawm_, _शक्र, --, 
   {{0xe4c800dd,0x00000000,0x00000000,0x00000000}},	//   _جبلن_, --, --, --, 
   {{0x11d417ac,0x249c01f9,0x8c380e48,0x00000000}},	//   _متعد, _zawm_, _maße, --, 
   {{0x249c0069,0xdb04000b,0xbdd40027,0x0ca80123}},	//   _yawm_, _erkë, борщ, нтаи_, 
   {{0x2bd80210,0x00000000,0x00000000,0x00000000}},	//   پارک_, --, --, --, 
   {{0xaa540cac,0x0a68059f,0x00000000,0x00000000}},	// [12f0] иваш, ереи_, --, --, 
   {{0x273817ad,0x3864014a,0x00000000,0x00000000}},	//   _rèn_, _admr_, --, --, 
   {{0x2738029f,0xa90817ae,0x7ed400e2,0x2eec038a}},	//   _sèn_, پيشل_, _دزيا, éefu_, 
   {{0x386411c6,0x273801e8,0xdd9000dd,0x8c040143}},	//   _cdmr_, _pèn_, _بوٽ_, লেষন_, 
   {{0x0a6817af,0x249c01ba,0x3cf407bd,0xc20800b6}},	//   _први_, _rawm_, ्करे_, _सुनब_, 
   {{0xc0e00422,0x249c01f3,0x65c401a0,0x0a6817b0}},	//   _ነዊሕ_, _sawm_, ибла, _ярми_, 
   {{0x8c040143,0x00000000,0x00000000,0x00000000}},	//   লেশন_, --, --, --, 
   {{0xe79406c2,0x6d441582,0x386003e0,0xdb040249}},	//   _پارک, _mtha, óirt_, _arkè, 
   {{0x6d440840,0x14b417b1,0xc600015b,0x00000000}},	//   _ltha, _आचरण, dzēš_, --, 
   {{0xa2e417b2,0x6ee801df,0x48ec00bd,0x00000000}},	//   роод, džbo, ेकको_, --, 
   {{0x249c0179,0x6d4417b3,0x25b817b4,0x7f4402ba}},	//   _tawm_, _ntha, _جهاد_, _stiq, 
   {{0x602417b5,0x205417b6,0xdb04000b,0xb9dc0222}},	//   идна, штор, _erkè, _ኡይ_, 
   {{0x6d4417b7,0x10a017b8,0x443c17b9,0x629401d4}},	//   _atha, циян, mcu_, ôzos, 
   {{0x443c17ba,0x6d440c12,0x7f44034c,0x00000000}},	//   lcu_, _btha, _vtiq, --, 
   {{0x443c17bb,0x1c380007,0x91e017bc,0xc10401ec}},	//   ocu_, вязь_, _моше, _гүнл, 
   {{0x443c17bd,0x1c4417be,0x6d4417bf,0xe2a803a2}},	//   ncu_, рнам, _dtha, _ساڻن_, 
   {{0x6d4417c0,0x7f44165f,0x443c17c1,0x5f7417c2}},	// [1300] _etha, _utiq, icu_, _ئابر, 
   {{0x443c0337,0x2eec000b,0x9a6817c3,0x00000000}},	//   hcu_, éeft_, ئمال_, --, 
   {{0x60d4036d,0x584417c4,0x443c17c5,0x8c380104}},	//   _klym, لپاق, kcu_, _saße, 
   {{0xa3d417c6,0x443c17c7,0x186804e7,0xdca417c8}},	//   सना_, jcu_, тади_, _тами, 
   {{0x443c17c9,0x2b48011a,0x00000000,0x00000000}},	//   dcu_, cpac_, --, --, 
   {{0x236c17ca,0xbb240853,0xdb040039,0x60d403c7}},	//   drej_, ﻼﺩﻯ_, _orké, _llym, 
   {{0x6d4401d6,0x98640012,0x53780020,0xd6d80210}},	//   _xtha, _نیاے_, _ጠባያት_, _یورش_, 
   {{0x63ac17cb,0x38640254,0xdcec00ef,0x39a40012}},	//   _šana, _udmr_, kubč, _پیچہ, 
   {{0xa36417cc,0xdb0417cd,0x78a00034,0x236c17ce}},	//   مپيۇ, _arké, _iamv, grej_, 
   {{0x443c17cf,0x60d401ec,0x78a017d0,0x73c400ec}},	//   acu_, _alym, _hamv, иәһе, 
   {{0x78a017d1,0x443c17d2,0x60d417d3,0x799c02b0}},	//   _kamv, bcu_, _blym, _jsrw, 
   {{0x443c17d4,0x78a017d5,0x6d4400cb,0x60d40323}},	//   ccu_, _jamv, _rtha, _clym, 
   {{0x77f417d6,0x6d4417d7,0xca300853,0x65600113}},	//   _अशोक_, _stha, ﺮﻻﺭ_, _zvlh, 
   {{0x60d40088,0x0ee817d8,0x78a017d9,0x6ee803aa}},	//   _elym, тьми_, _lamv, ržbo, 
   {{0x799c0379,0x3da417da,0x41b017db,0x00000000}},	//   _nsrw, ортб, _ومهر, --, 
   {{0x60d417dc,0x3f8002bb,0xebc400c3,0x78a001eb}},	//   _glym, _fqiu_, бәгн, _namv, 
   {{0x6cd400bf,0x00000000,0x00000000,0x00000000}},	// [1310] _ۇقدا, --, --, --, 
   {{0x6e9417dd,0x6d44007f,0x443c17de,0x00000000}},	//   _الدا, _ttha, zcu_, --, 
   {{0x6d4408bc,0x2b480d7f,0x78a017df,0x60d400df}},	//   _utha, spac_, _bamv, _ylym, 
   {{0x443c0110,0xe6d802b2,0x00000000,0x00000000}},	//   xcu_, _þrúð, --, --, 
   {{0x78a008be,0xfe7017e0,0x8d64001d,0x00000000}},	//   _damv, _عدی_, ስጣቸው_, --, 
   {{0x236c0091,0x443c03ef,0x00000000,0x00000000}},	//   vrej_, wcu_, --, --, 
   {{0xe29817e1,0x443c17e2,0x799c02b0,0x9f90014e}},	//   қан_, tcu_, _gsrw, _løða_, 
   {{0xfdf802c3,0x443c0059,0x00000000,0x00000000}},	//   ימוש_, ucu_, --, --, 
   {{0x443c17e3,0x290c17e4,0xe3e8031b,0x7c200212}},	//   rcu_, _ikea_, دکان_, _úmrt, 
   {{0x443c17e5,0x236c17e6,0x78a017e7,0x60d403f4}},	//   scu_, rrej_, _zamv, _slym, 
   {{0x60d417e8,0x78a017e9,0x26c417ea,0xe3a40324}},	//   _plym, _yamv, _iolo_, _گشای, 
   {{0x26c417eb,0x236c0f68,0x6b9c043e,0x00000000}},	//   _holo_, prej_, _ossg, --, 
   {{0x26c417ec,0x68e801c4,0x60d40618,0x6458043e}},	//   _kolo_, _mmed, _vlym, _iewi, 
   {{0x26c417ed,0x8ff801ac,0xdca400b8,0x00000000}},	//   _jolo_, ارٽر_, әааи, --, 
   {{0x645817ee,0x68e817ef,0x9f500110,0x290c00a2}},	//   _kewi, _omed, _ayyô_, _okea_, 
   {{0x26c417f0,0x68e80043,0x290c01d7,0x645817f1}},	//   _lolo_, _nmed, _nkea_, _jewi, 
   {{0x645817f2,0x78a00156,0x5ba80007,0x5a6400bf}},	// [1320] _mewi, _ramv, ыкам_, йкаб, 
   {{0x290c1607,0x68e817f3,0x26c417f4,0x201003af}},	//   _akea_, _amed, _nolo_, _iyyi_, 
   {{0x78a017f5,0x66dc0078,0xceb00cdd,0x6b9c002a}},	//   _pamv, _kèkf, _זית_, _essg, 
   {{0x64580ca0,0x26c40062,0xd7f810f3,0x2fdc024f}},	//   _newi, _aolo_, лул_, _özgü_, 
   {{0x26c40032,0x96e817f6,0x78a00156,0x00000000}},	//   _bolo_, лька_, _vamv, --, 
   {{0x68e817f7,0x26c417f8,0x290c17f9,0x78a017fa}},	//   _emed, _colo_, _ekea_, _wamv, 
   {{0x26c417fb,0x290c0243,0x98a417fc,0x78a00b75}},	//   _dolo_, _fkea_, _ливе, _tamv, 
   {{0x64580039,0x00000000,0x00000000,0x00000000}},	//   _cewi, --, --, --, 
   {{0x645817fd,0x26c417fe,0x77f40a1d,0x00000000}},	//   _dewi, _folo_, _بڻائ, --, 
   {{0x26c417ff,0x09dc007e,0x9f90020c,0x68e80c91}},	//   _golo_, _বুটা, _røða_, _zmed, 
   {{0x20100181,0x70540a1d,0x6458038a,0xd9f802ef}},	//   _ayyi_, يندا, _fewi, ्थित_, 
   {{0x64581800,0x26c41801,0x2ed000cb,0xdddc03ef}},	//   _gewi, _zolo_, हस्त, _odpł, 
   {{0x26c408c2,0xe51c0095,0xf2880587,0x00000000}},	//   _yolo_, _पठति_, _көнд_, --, 
   {{0xd9f81802,0x26c4041c,0xee20024b,0x6d400306}},	//   ्थात_, _xolo_, дегi_, ílao, 
   {{0x6458019b,0x8c641803,0xa2a00a5f,0xad2406e5}},	//   _yewi, йтад, _कोट्, قىسى, 
   {{0x7afc0091,0xdbd4020c,0x09dc02fa,0xd24c004b}},	//   _ajrt, tøða, _বুঝা, _تۆگ_, 
   {{0x68e80207,0x39a80055,0xaf5400dd,0x4fc400cc}},	// [1330] _rmed, _ağs_, _برعڪ, _ыска, 
   {{0x290c0556,0x4338007c,0xdbd405c0,0xcc840122}},	//   _skea_, טעמב, røða, _گۆره_, 
   {{0x26c41804,0x09dc0664,0x8d78001d,0xe9440122}},	//   _rolo_, _বুজা, ርሲቲው_, زرای, 
   {{0x26c41805,0x98a80201,0x81c80143,0x7f841806}},	//   _solo_, _kubę_, _রেড_, _بلین, 
   {{0x64581807,0x68e80088,0x26c41808,0x645c01a0}},	//   _rewi, _vmed, _polo_, аsin, 
   {{0x64581809,0x26c401b5,0x321c00ef,0x63ac012c}},	//   _sewi, _qolo_, _ozvy_, _šano, 
   {{0x645803ef,0xe4500075,0x00000000,0x00000000}},	//   _pewi, وضة_, --, --, 
   {{0x68e8180a,0x26c407d4,0x00000000,0x00000000}},	//   _umed, _wolo_, --, --, 
   {{0x26c4180b,0x46680074,0x108c00c3,0x00000000}},	//   _tolo_, _брем_, _ﻛﯚﺯﯨ, --, 
   {{0x6458180c,0x21300039,0x26c4180d,0xf6d40128}},	//   _wewi, _siyh_, _uolo_, _ىزلد, 
   {{0x6458007f,0x6aa40306,0x00000000,0x00000000}},	//   _tewi, idhf, --, --, 
   {{0x7b1003c8,0x140801e5,0xa8780100,0x64a400ec}},	//   läut, ịrịo, סאָר, _єала, 
   {{0x79500078,0x00000000,0x00000000,0x00000000}},	//   _kòwò, --, --, --, 
   {{0x63a8180e,0x21740254,0xa2a00098,0x7304021d}},	//   mven, _дуир, _कोच्, _епіз, 
   {{0x63a8180f,0x712404e7,0x108c00c3,0xdca40106}},	//   lven, تریل, _ﻛﯚﺭﯨ, оави, 
   {{0x161c021f,0x63a80243,0x79600223,0x7b100104}},	//   येटर_, oven, _láwá, häut, 
   {{0x9b441810,0x00000000,0x00000000,0x00000000}},	// [1340] زناو, --, --, --, 
   {{0x63a81811,0xeb541812,0x00000000,0x00000000}},	//   iven, سىمگ, --, --, 
   {{0x18a408dc,0x63a81813,0x63ac0101,0x00000000}},	//   жаем, hven, _šanl, --, 
   {{0x0d2002ba,0x00000000,0x00000000,0x00000000}},	//   _жүсү, --, --, --, 
   {{0x63a81526,0xd7041814,0x00000000,0x00000000}},	//   jven, озди, --, --, 
   {{0x63a81815,0x645c1816,0x4ff8007c,0x2d8400e7}},	//   dven, ðsin, יִונ, àleg_, 
   {{0x63a81817,0x8c3806ef,0x00000000,0x00000000}},	//   even, _maßn, --, --, 
   {{0x94a81818,0xa3d41819,0x00000000,0x00000000}},	//   ртка_, सनं_, --, --, 
   {{0x63a8181a,0x60cc0560,0x00000000,0x00000000}},	//   gven, _ċamp, --, --, 
   {{0x717802dc,0x1440010f,0x0bb40107,0x7b100104}},	//   ббор_, _የጀመሩ, קלים_, mäus, 
   {{0x63a80496,0x7b100630,0x3fd00049,0x00000000}},	//   aven, läus, _ﮔﺮﺍﻧ, --, 
   {{0x859800ca,0x00000000,0x00000000,0x00000000}},	//   _כשבו, --, --, --, 
   {{0x63a8009e,0x4ea4181b,0xdb0402b2,0x941c025c}},	//   cven, орва, _arkí, _परिच_, 
   {{0xd138181c,0x00000000,0x00000000,0x00000000}},	//   _кхи_, --, --, --, 
   {{0x7b1006ef,0xd1f402b4,0x230800e3,0x00000000}},	//   häus, ፈልቲ_, _اتني_, --, 
   {{0xdcec00d4,0x00000000,0x00000000,0x00000000}},	//   tubā, --, --, --, 
   {{0x6b74181d,0x2ef401c7,0xfb8400e5,0x00000000}},	// [1350] ялау, _нзир, дыхн, --, 
   {{0x39580086,0x7054181e,0x3a380426,0x423400cf}},	//   _bwrs_, _بنکا, _cgrp_, ַנדל_, 
   {{0x63a80403,0x3958009c,0x00000000,0x00000000}},	//   zven, _cwrs_, --, --, 
   {{0xe5a4181f,0x6ee81635,0x63a81820,0xa3cc0b02}},	//   ҷики, džbi, yven, रहम_, 
   {{0x66dc0324,0x248802b1,0x98a801d5,0x63a80085}},	//   _lèke, _ñami_, _hubě_, xven, 
   {{0x63a81821,0xe5a41822,0x98a801d5,0x00000000}},	//   vven, зики, _kubě_, --, 
   {{0x3958009c,0x7b100104,0x16840061,0x00000000}},	//   _gwrs_, räut, ساوێ, --, 
   {{0x79500078,0x7b1001ab,0xa51c0023,0xdb0c00d3}},	//   _wòwò, bäus, ыялi, _òjòj, 
   {{0x3a38044a,0x63a81823,0xed8002b4,0x00000000}},	//   _ygrp_, uven, _ይግበር_, --, 
   {{0x672013bd,0x39640027,0x926011e5,0x00000000}},	//   _uhlj, _ässä_, ىگىم, --, 
   {{0x66dc0249,0xa0a41824,0x00000000,0x00000000}},	//   _cèke, панд, --, --, 
   {{0x21040c93,0xd12c049d,0x659400b8,0x454400e2}},	//   रवेश_, ێمی_, _маҷу, _هرچې, 
   {{0xdfd0090d,0x2b5800ba,0xa3481013,0x63a81825}},	//   ريس_, _nwsc_, _узла_, qven, 
   {{0x6fd00306,0x0afc0143,0xdea01826,0x00000000}},	//   _sócú, ্গুল_, ریجی, --, 
   {{0x2cf81827,0x00000000,0x00000000,0x00000000}},	//   ्कूल_, --, --, --, 
   {{0x201c0c60,0x2b580560,0xd94400fc,0x1f6400b7}},	//   ətin_, _bwsc_, җеди, _еким, 
   {{0x0df002b4,0x2b580086,0x71241828,0x6d6000a8}},	// [1360] _ግደፍ_, _cwsc_, _ترول, _āvaś, 
   {{0x39580335,0x8c38002a,0x2a6002b2,0x00000000}},	//   _pwrs_, _haßl, gahb_, --, 
   {{0xda080075,0x1d081829,0x00000000,0x00000000}},	//   حياه_, _гени_, --, --, 
   {{0x7b100b46,0x00000000,0x00000000,0x00000000}},	//   täus, --, --, --, 
   {{0x69100b1e,0x8c38002a,0x00000000,0x00000000}},	//   vået, _maßl, --, --, 
   {{0x7b1003c8,0x00000000,0x00000000,0x00000000}},	//   räus, --, --, --, 
   {{0xceb00240,0x7b10002a,0x1d90001d,0xc510005e}},	//   תיו_, säus, _ምግቦች_, کبوت, 
   {{0x15b8024b,0x1cb80126,0xd378182a,0xf43400df}},	//   _қызы_, _ཙོས_, бчо_, мейэ, 
   {{0x66dc0249,0xab64015b,0x629401c6,0x00000000}},	//   _sèke, _guļā, ĵzon, --, 
   {{0x66dc0249,0x43d00075,0xe97000e7,0x00000000}},	//   _pèke, عزيز, _سۇۇد, --, 
   {{0x112802dc,0xa6a800cc,0x00000000,0x00000000}},	//   йюми_, _باقق_, --, --, 
   {{0x09f40107,0x855400cf,0x00000000,0x00000000}},	//   למים_, _זשאב_, --, --, 
   {{0xdfd00a1d,0xa3cc182b,0x9fa4002c,0xbff804d3}},	//   نيٽ_, रहण_, мырҙ, зеях_, 
   {{0x9f4c020c,0x00000000,0x00000000,0x00000000}},	//   ðnám_, --, --, --, 
   {{0xa3cc0030,0x00000000,0x00000000,0x00000000}},	//   रहथ_, --, --, --, 
   {{0xc8a803ea,0xd7bc006c,0x01f800ca,0x00000000}},	//   _घोंट, ्हाच, _לפול, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1370] --, --, --, --, 
   {{0x8018182c,0x63ac15b9,0xa3cc0030,0x98a801d5}},	//   _عزيز_, _šank, रहत_, _tubě_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ce0182d,0xeff00020,0x00000000,0x00000000}},	//   chiv_, _ቃልዕ_, --, --, 
   {{0xd364024c,0x478803d6,0x00000000,0x00000000}},	//   _جه_, ссем_, --, --, 
   {{0x2ca8182e,0x7b100e48,0xae00161f,0xc98404fd}},	//   ldad_, säur, _ईशान_, _нуби, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2ca8182f,0xdddc0078,0x81c802fa,0xdb0400e3}},	//   ndad_, _depň, _রইল_, _irká, 
   {{0x2ca81830,0x2cb80181,0xe738009c,0xdb0401d4}},	//   idad_, _mnsd_, _grŵp_, _hrká, 
   {{0x2ca80361,0xe2980294,0xe1f81831,0x00000000}},	//   hdad_, цао_, жго_, --, 
   {{0x93c80eeb,0xb5fc043b,0x2cb80207,0x00000000}},	//   مایہ_, _reġg, _onsd_, --, 
   {{0x14c800e2,0xe3b800b7,0x00000000,0x00000000}},	//   _وهلی_, _млеч_, --, --, 
   {{0x2ca81832,0xdddc00f1,0x613c01d4,0x33b00481}},	//   ddad_, _zepň, dálň, _مەير, 
   {{0x2ca80d7f,0xdb0400f2,0x248c1833,0x00000000}},	//   edad_, _orká, lfem_, --, 
   {{0xa0a4086b,0x3ce001f9,0x248c0207,0x93100128}},	//   _жайд, thiv_, ofem_, _جووش, 
   {{0xb5fc0126,0xc97c001d,0x00000000,0x00000000}},	//   _weġg, _ያልፋል_, --, --, 
   {{0xdb041834,0x24880d8c,0x3ce001d1,0x69c00537}},	// [1380] _arká, _ñamu_, rhiv_, _àlej, 
   {{0x3ce001f9,0x2ca811c6,0x8d64001d,0x9db80f1a}},	//   shiv_, adad_, ድባቸው_, _дыму_, 
   {{0x1d2400c3,0x2ca81835,0x69100479,0xb8200030}},	//   _омом, bdad_, våer, _बरहम_, 
   {{0xa3cc1836,0xdddc00f1,0xeaf800c3,0xf1a00030}},	//   रहा_, _repň, يرەت_, _ओईसन, 
   {{0xd7080254,0xdaa00116,0x2c0000cc,0x8cd81029}},	//   онде_, _иҳаҩ, _бүтм, नसरो, 
   {{0x473000c8,0x248c036d,0x38c8066c,0x00000000}},	//   вніс, efem_, _کاسی_, --, 
   {{0x248c03c7,0x691001c5,0x00000000,0x00000000}},	//   ffem_, råer, --, --, 
   {{0xe8e81837,0x00000000,0x00000000,0x00000000}},	//   _فرقو_, --, --, --, 
   {{0x2248024f,0x81c80143,0x69100207,0xf3f8018f}},	//   _şaka_, _রেল_, påer, яниш_, 
   {{0xd6281838,0x660c11f5,0x00000000,0x00000000}},	//   _дозе_, şaka, --, --, 
   {{0x94841839,0x02a002b3,0x9700006e,0x2ca80060}},	//   _жылд, трым, _كېچى, ydad_, 
   {{0x3d0803ef,0x00000000,0x00000000,0x00000000}},	//   वकों_, --, --, --, 
   {{0x0440183a,0xb5fc0126,0xdcfc00b0,0xef640182}},	//   _речн, _deġe, _aspį, ээнү, 
   {{0x2cb8183b,0x823002cf,0x00000000,0x00000000}},	//   _snsd_, عریا, --, --, 
   {{0xdc38183c,0xc324045d,0x2ca80337,0x201c02df}},	//   _açık, _تكون_, tdad_, ətim_, 
   {{0x63ac0091,0x2ca8183d,0x00000000,0x00000000}},	//   _šani, udad_, --, --, 
   {{0x2ca8183e,0x2d8c0029,0xb034018f,0x00000000}},	// [1390] rdad_, ŋee_, _яниш, --, 
   {{0xcf24183f,0x7a540075,0x00000000,0x00000000}},	//   _تربي, نضما, --, --, 
   {{0x7c580121,0xeb340121,0xfd741840,0x00000000}},	//   سلەر_, _ۋىجد, _илээ, --, 
   {{0x2ca80060,0xfb24080a,0x00000000,0x00000000}},	//   qdad_, ىرەپ, --, --, 
   {{0xf7f41841,0xf7480075,0x00000000,0x00000000}},	//   پسند, وجوه_, --, --, 
   {{0xf7701842,0xdb040056,0x16a41843,0x3f7c0100}},	//   شاه_, _arkæ, евши_, קאוס, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x291800c4,0xfb0000a2,0x00000000,0x00000000}},	//   _ósa_, āīō_, --, --, 
   {{0x248c1844,0xe3b01845,0x93a0018f,0x00000000}},	//   rfem_, ارب_, _ro惣x, --, 
   {{0x248c0078,0x1420001e,0xe3b000bf,0x00000000}},	//   sfem_, ыдым, _ۅرت_, --, 
   {{0x668000ea,0x00000000,0x00000000,0x00000000}},	//   _لیږل, --, --, --, 
   {{0xe3b00075,0x00000000,0x00000000,0x00000000}},	//   _مرت_, --, --, --, 
   {{0x95201846,0xca341847,0xb5fc043b,0xcf4002c2}},	//   _حکوم, _iaʝu_, _veġe, лняй, 
   {{0xd36c166c,0x64481848,0x622406e5,0xdb040386}},	//   _اهو_, lcei, _كىشل, _irkç, 
   {{0xca341607,0x00000000,0x00000000,0x00000000}},	//   _kaʝu_, --, --, --, 
   {{0x64481849,0x6280184a,0x7cfc012b,0x00000000}},	//   ncei, lglo, gärе, --, 
   {{0x6280000f,0x6448184b,0x00000000,0x00000000}},	// [13a0] oglo, icei, --, --, 
   {{0x6280061e,0xb4cc184c,0x00000000,0x00000000}},	//   nglo, _रक्_, --, --, 
   {{0x6280184d,0x98480668,0x00000000,0x00000000}},	//   iglo, пяла_, --, --, 
   {{0x3860045d,0x1d0817da,0xe8e802cb,0x00000000}},	//   úir_, _хеми_, ورنو_, --, 
   {{0x64480008,0x66dc0078,0xcc380100,0x47d00143}},	//   dcei, _sèka, _מעכט, _দেবী, 
   {{0x628001f6,0x00000000,0x00000000,0x00000000}},	//   jglo, --, --, --, 
   {{0x86c0184e,0x25a400b7,0x9a7c001d,0x00000000}},	//   ايىن, _csll_, _ያምናል_, --, 
   {{0x6280184f,0xd378023f,0x64480086,0x00000000}},	//   eglo, пчо_, gcei, --, 
   {{0x48e01850,0xcc3800cf,0x00000000,0x00000000}},	//   _сотв, העפט, --, --, 
   {{0x62801851,0x66dc0078,0x15b00411,0x00000000}},	//   gglo, _tèka, _مەتس, --, 
   {{0x66101852,0xb5fc0126,0xdb04006b,0x00000000}},	//   _پژوا, _weġb, _irkä, --, 
   {{0x64481853,0x628000b7,0xfbe00303,0x1db8025c}},	//   ccei, aglo, फनाम, _उपजत, 
   {{0x6280006a,0x63ac0091,0xb4dc184c,0x00000000}},	//   bglo, _šanv, डसी_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x42a402b4,0x7094006b,0x00000000,0x00000000}},	//   _ገበናት_, _раиф, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [13b0] --, --, --, --, 
   {{0xff5003e0,0x64480337,0xbb1800c3,0x3f640668}},	//   _اخي_, zcei, ىزلا_, _стъб, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1cb80560,0x6d5401ed,0x79a40116,0x00000000}},	//   _ཙོག_, mpza, ыруе, --, 
   {{0x6280052b,0x6d54084f,0x00000000,0x00000000}},	//   yglo, lpza, --, --, 
   {{0xbdf81854,0x6d54018c,0x62800616,0x6b8c1855}},	//   _آریا_, opza, xglo, mtag, 
   {{0x6b8c1856,0x66040668,0xa5081857,0x94ec0387}},	//   ltag, ъпка, мека_, lşən_, 
   {{0xdb041858,0x62801859,0xe3b8185a,0x69c408c2}},	//   _erkä, wglo, дби_, mxhe, 
   {{0x232800f8,0x6448185b,0xf770185c,0x291c08c2}},	//   моии_, rcei, _هال_, mlwa_, 
   {{0x6b8c185d,0x291c185e,0x6448185f,0x628001c3}},	//   itag, llwa_, scei, uglo, 
   {{0x291c1860,0x6b8c0cfa,0x69c41861,0x00000000}},	//   olwa_, htag, nxhe, --, 
   {{0x62801862,0x6b8c1863,0x64480337,0x291c0078}},	//   sglo, ktag, qcei, nlwa_, 
   {{0x6b8c1864,0x69c40475,0x00000000,0x00000000}},	//   jtag, hxhe, --, --, 
   {{0xe1f01011,0x6b8c1865,0x1cb80037,0xe3b003a2}},	//   _پست_, dtag, _ཙོང_, _مرڪ_, 
   {{0x8d6015b0,0x6b8c1866,0x00000000,0x00000000}},	//   ивре, etag, --, --, 
   {{0x6b8c1867,0x01c000b8,0x00000000,0x00000000}},	//   ftag, _арҩҭ, --, --, 
   {{0x6b8c107e,0xcb641868,0xd12c009d,0x291c1869}},	// [13c0] gtag, кате_, _بمي_, dlwa_, 
   {{0x291c06f9,0x1e94186a,0xc0c400ec,0x61ec0095}},	//   elwa_, _ррир, _рәүи, _śaly, 
   {{0x7f440ca7,0x598400f5,0x00000000,0x00000000}},	//   _huiq, тлеб, --, --, 
   {{0x6b8c186b,0x291c01e8,0x1b48018f,0x00000000}},	//   btag, glwa_, _озми_, --, 
   {{0x6b8c00a0,0x2728018b,0x660c186c,0x386800bf}},	//   ctag, kúnd_, şakl, _үзгү_, 
   {{0x66dc0078,0x291c186d,0xd5b8186e,0x00000000}},	//   _dèko, alwa_, дси_, --, 
   {{0x1dd0186f,0x66dc077e,0x186801d9,0x34940094}},	//   सहित, _tèkn, _оави_, гайр, 
   {{0xdddc00a2,0xb4dc1870,0xa3cc0095,0x00000000}},	//   _nepō, डसे_, रहं_, --, 
   {{0x07a01871,0xccf0033c,0xc7a00b2e,0x7f44044d}},	//   _катн, יכה_, _китк, _nuiq, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebb8076f,0x6b8c1872,0xdb040222,0xa59401ac}},	//   maḥ_, ztag, _askë, _مُلڪ, 
   {{0xebb80828,0x6b8c1873,0x85f400ca,0x290402e8}},	//   laḥ_, ytag, _בצבע_, _ílat_, 
   {{0x7f44165f,0xdddc0078,0x6b8c1874,0xa3cc00cb}},	//   _cuiq, _depō, xtag, रहः_, 
   {{0xebb81113,0x291c08c2,0x94ec02df,0x41c00012}},	//   naḥ_, zlwa_, vşən_, _چٲوِ, 
   {{0xdb04038a,0x51841875,0xcfc80143,0x00000000}},	//   _eskë, _рула, _লেখন, --, 
   {{0xebb81113,0x6b8c1876,0xa25001b5,0x00000000}},	//   haḥ_, ttag, _پھیش, --, 
   {{0xebb8076f,0x6b8c1877,0xfc640668,0x7b4400c3}},	// [13d0] kaḥ_, utag, ръсн, ۇئەل, 
   {{0x6b8c1878,0x7a400214,0xebb80828,0x2fd80336}},	//   rtag, vští, jaḥ_, mysg_, 
   {{0x6b8c1879,0xebb8076f,0x291c187a,0xac980075}},	//   stag, daḥ_, tlwa_, _كندا_, 
   {{0x6b8c187b,0x69c4187c,0x6d400237,0x25b8014d}},	//   ptag, rxhe, ŭlas, _čsl_, 
   {{0x6d44187d,0x0a68187e,0x63880475,0x2728001e}},	//   _huha, _орви_, _mënç, húne_, 
   {{0x6f1402fa,0xebb80828,0x660400fc,0x7bc000e9}},	//   nozc, gaḥ_, лпла, _šmug, 
   {{0x6d44187f,0x291c1880,0x8c38002a,0x253801f1}},	//   _juha, plwa_, _paßw, нчиќ_, 
   {{0x66dc01e8,0x63880222,0xe3a80106,0xdb080139}},	//   _zèkl, _nënç, екид_, änöi, 
   {{0x6d441881,0x82600121,0xdddc00f1,0x937000d3}},	//   _luha, لۇشن, _repō, _è̟̟t, 
   {{0x2fd80ca0,0x63ac1882,0x130400bb,0xebb80828}},	//   dysg_, _šans, лный_, caḥ_, 
   {{0x333c1883,0xc0cc02b4,0x7f441884,0x638802bb}},	//   _divx_, _ኣምር_, _suiq, _bënç, 
   {{0xf1d41885,0x00000000,0x00000000,0x00000000}},	//   рөшө, --, --, --, 
   {{0x6d441847,0x7f441886,0x776001f9,0x50d4005e}},	//   _auha, _quiq, _xwmx, ازپر, 
   {{0x6d441887,0x201c1888,0x7f440048,0x272801d4}},	//   _buha, āti_, _vuiq, búne_, 
   {{0x21740182,0x236c00c0,0x9b04018f,0x00000000}},	//   _сулр, lsej_, ҳзад, --, 
   {{0x7f441889,0xeff00020,0x00000000,0x00000000}},	//   _tuiq, _ሃልዩ_, --, --, 
   {{0xebb81113,0x6d44188a,0x9c2401d2,0x236c01d4}},	// [13e0] yaḥ_, _euha, удад, nsej_, 
   {{0x6d44034a,0x65600379,0x00000000,0x00000000}},	//   _fuha, _owlh, --, --, 
   {{0x6d4404fe,0xebb8076f,0x79e801b8,0xdc68022e}},	//   _guha, vaḥ_, خواہ_, _панд_, 
   {{0xf7540661,0x5e440012,0x236c188b,0xe6b401a0}},	//   _ዝተፈላ, _جنگٕ, ksej_, یلنگ, 
   {{0xebb8188c,0x7d04188d,0x6d44188e,0x236c00c0}},	//   taḥ_, mnis, _zuha, jsej_, 
   {{0x7d04188f,0x6d440039,0x236c02d9,0xb4dc1890}},	//   lnis, _yuha, dsej_, डस्_, 
   {{0xebb81113,0x0570177d,0xb9240223,0x00000000}},	//   raḥ_, مايد, _musẹ_, --, 
   {{0xebb8076f,0x33741891,0x2ed01892,0x7d041893}},	//   saḥ_, агир, _सक्त, nnis, 
   {{0x7d041894,0xd7081895,0xebb80828,0xdb0401d4}},	//   inis, _знае_, paḥ_, _aské, 
   {{0x7d041896,0x92b41897,0xe4680340,0x2728001e}},	//   hnis, احظا, ىلۉۉ_, túne_, 
   {{0x6f140113,0xf48403b5,0x25640012,0x2fd80335}},	//   vozc, _ناشی, _نانُ, wysg_, 
   {{0x2ba406d5,0x6d441898,0x7d041899,0x27280247}},	//   _ऑनला, _ruha, jnis, rúne_, 
   {{0x7d04189a,0x6d44189b,0xdb040247,0x799c06e2}},	//   dnis, _suha, _eské, _lprw, 
   {{0x6d44189c,0x0dc8189d,0x69c00b7c,0x02a01166}},	//   _puha, нуби_, _áleg, _гръм, 
   {{0x7d04189e,0x6d440029,0x864802b4,0x799c02b0}},	//   fnis, _quha, _ሓጢኣት, _nprw, 
   {{0x7d04189f,0x6d44052e,0x6c5418a0,0xfd440023}},	//   gnis, _vuha, ркау, сэрн, 
   {{0x6d4418a1,0xdbc406ef,0x799c071c,0x6f1401c6}},	// [13f0] _wuha, röße, _aprw, pozc, 
   {{0x6d4418a2,0x7d0418a3,0x9f400e84,0xaa5818a4}},	//   _tuha, anis, szkã_, тижу_, 
   {{0x7d0418a5,0x629c0130,0x2b480d2e,0xe8540075}},	//   bnis, ɑsod, sqac_, لناد, 
   {{0xd24402a5,0x01f8007c,0x660c0386,0x00000000}},	//   _ژن_, עפאל, şakk, --, 
   {{0x2d900396,0x0b881166,0x00000000,0x00000000}},	//   ltze_, _ясни_, --, --, 
   {{0x2d9001aa,0x6b9c02b0,0x00000000,0x00000000}},	//   otze_, _ipsg, --, --, 
   {{0x2d9018a6,0x47d00143,0xe4c4148a,0x00000000}},	//   ntze_, _দেশী, ийки, --, 
   {{0x67d418a7,0xa44418a8,0x2d9001aa,0xe72401eb}},	//   _кобу, шнид, itze_, _dưỡ, 
   {{0xd3440122,0xd7640049,0x78a40030,0x00000000}},	//   لینه_, _نەنى_, õive, --, 
   {{0x3ae404bc,0xe2980106,0x00000000,0x00000000}},	//   _köpa_, њан_, --, --, 
   {{0x7d0418a9,0x20c418aa,0x03c40049,0x236c01d4}},	//   ynis, айнм, _әсем, ssej_, 
   {{0xf53003e0,0x236c18ab,0x00000000,0x00000000}},	//   _فإن_, psej_, --, --, 
   {{0x7d0418ac,0x3ae418ad,0x8c380e48,0x2d9018ae}},	//   vnis, _löpa_, _maßs, etze_, 
   {{0x7d0418af,0x00000000,0x00000000,0x00000000}},	//   wnis, --, --, --, 
   {{0x041402fa,0x6b9c0379,0x1cb8011a,0xaac817d6}},	//   দেশী_, _apsg, _ཙོད_, रानक, 
   {{0x7d0418b0,0x8c4018b1,0x00000000,0x00000000}},	//   unis, жете, --, --, 
  
   {{0x7d0418b2,0x959802b4,0x2d9018b3,0x5a6418b4}},	// [1400] rnis, _ለይትን_, atze_, икаб, 
   {{0x7d0418b5,0x799c0379,0x9f4001d5,0x00000000}},	//   snis, _pprw, czká_, --, 
   {{0x7d0418b6,0x8e7800ca,0x6ee400ea,0x00000000}},	//   pnis, _בניה, _دسيل, --, 
   {{0xd7f818b7,0x7d0418b8,0x3ae401c5,0xfc040152}},	//   кул_, qnis, _döpa_, _гомү, 
   {{0x9ac40012,0x00000000,0x00000000,0x00000000}},	//   _پۯاہ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x18a40568,0x98a4044a,0x00000000,0x00000000}},	//   _кавм, _киве, --, --, 
   {{0x63b80335,0xe9700049,0xd4980b1e,0xb78818b9}},	//   _brwn, _ءۇند, трк_, _бәке_, 
   {{0x63b80323,0x00000000,0x00000000,0x00000000}},	//   _crwn, --, --, --, 
   {{0xaac80474,0x00000000,0x00000000,0x00000000}},	//   रायक, --, --, --, 
   {{0x61ec01e7,0x80b00143,0x3ce000af,0xd4a401e3}},	//   _ƙala, টান্, kkiv_, _вией, 
   {{0x1cb00126,0x63b80086,0x8c38002a,0x00000000}},	//   ྟབས_, _frwn, _maßr, --, 
   {{0x8934007c,0xaac80523,0x63b80335,0x645c02e3}},	//   ירטע_, रामक, _grwn, ñsie, 
   {{0xafc418ba,0x00000000,0x00000000,0x00000000}},	//   _ۇيعى, --, --, --, 
   {{0xdb040209,0x27280272,0x8c6401a0,0x2d9001aa}},	//   _askï, núna_, итад, utze_, 
   {{0x2d9001a7,0x8bb400c3,0x00000000,0x00000000}},	//   rtze_, ақму_, --, --, 
   {{0x6f940272,0x00000000,0x00000000,0x00000000}},	// [1410] _الخض, --, --, --, 
   {{0x8d8402ba,0x7bc0015b,0x8aa40edd,0x00000000}},	//   _кумд, _šmuc, јрад, --, 
   {{0xdb2401b8,0xc98418bb,0x0dc818bc,0x41bc184c}},	//   حولی, рузи, _рупи_, एमएस, 
   {{0xcc840122,0x00000000,0x00000000,0x00000000}},	//   _خۆره_, --, --, --, 
   {{0xfbc809c5,0x478803d6,0x00000000,0x00000000}},	//   रमणम, тсем_, --, --, 
   {{0x272800c4,0xd594001d,0x00000000,0x00000000}},	//   fúna_, _መርምሮ_, --, --, 
   {{0x272818bd,0x00000000,0x00000000,0x00000000}},	//   gúna_, --, --, --, 
   {{0xe91800c8,0x64440444,0xe2840108,0x00000000}},	//   _собі_, _ğhis, әлни, --, 
   {{0xdd0002db,0xa82418be,0xa774006b,0xd5ac0012}},	//   šuću, _اکان, _ылач, وہے_, 
   {{0xa2e418bf,0x272818c0,0x00000000,0x00000000}},	//   соод, búna_, --, --, 
   {{0xa06818c1,0xb5fc011a,0xe04401a0,0xa0c418c2}},	//   лана_, _leġj, йнни, ميدو, 
   {{0x21a40f72,0xa3b800dd,0xb22400cc,0xaac803bf}},	//   _ҳикм, _ماتر_, өмөл, राडक, 
   {{0xe29818c3,0x63b8017b,0xdcb018c4,0xc32c0012}},	//   _бал_, _urwn, ۋىس_, _ہٕچ_, 
   {{0x63a818c5,0x00000000,0x00000000,0x00000000}},	//   mwen, --, --, --, 
   {{0x3ce001d4,0x80b00143,0xd00c00cc,0x00000000}},	//   tkiv_, টাব্, _ۋلى_, --, 
   {{0x1c4418c6,0x6c5801c3,0x00000000,0x00000000}},	//   снам, ијус_, --, --, 
   {{0x3ce018c7,0x25540028,0xd0f8007c,0x0b400123}},	// [1420] rkiv_, _hāld_, _תּור, знун, 
   {{0x60d40964,0x25540028,0x63a801ab,0x9a6818c8}},	//   _hoym, _kāld_, iwen, امال_, 
   {{0x63a818c9,0x60d418ca,0x9988015b,0xdca418cb}},	//   hwen, _koym, _izbū_, _лани, 
   {{0x57e818cc,0x272800c4,0x5ca40074,0x69c000bd}},	//   лдем_, vúna_, _уимб, _šlec, 
   {{0x63a818cd,0x00000000,0x00000000,0x00000000}},	//   jwen, --, --, --, 
   {{0x60d40444,0x8f98023c,0xaac80803,0x00000000}},	//   _loym, ריסי, राणक, --, 
   {{0xc7ac0191,0x63a808cc,0x38600579,0xc0f8001d}},	//   وڑے_, ewen, ðirs_, ፈጽሙ_, 
   {{0xf4d818ce,0x98a40070,0x272818cf,0x00000000}},	//   рмиш_, dmoć_, rúna_, --, 
   {{0x969418d0,0xdcfc015b,0x73340108,0x00000000}},	//   _греш, _appī, يىبا, --, 
   {{0xd34418d1,0x00000000,0x00000000,0x00000000}},	//   لیچه_, --, --, --, 
   {{0x60d418d2,0x63a8000b,0x51840027,0x00000000}},	//   _boym, awen, щупа, --, 
   {{0x63a818d3,0x395804ac,0x60d4006f,0x00000000}},	//   bwen, _mtrs_, _coym, --, 
   {{0x63a818d4,0x60d40be2,0x00000000,0x00000000}},	//   cwen, _doym, --, --, 
   {{0x395818d5,0x66dc00f1,0xb5fc0002,0x63bc18d6}},	//   _otrs_, _pèki, _reġj, æsne, 
   {{0x705818d7,0xc1700075,0x00000000,0x00000000}},	//   _кайр_, _فديت, --, --, 
   {{0x99840066,0x60d4020c,0x90e418d8,0x00000000}},	//   łoś_, _goym, _دستن, --, 
   {{0xdb040247,0x4f6801d9,0x206800ec,0x00000000}},	// [1430] _eskí, _ёшим_, _өшөп_, --, 
   {{0x6e9818d9,0xaac80192,0x00000000,0x00000000}},	//   _твор_, राधक, --, --, 
   {{0x7f3c0282,0x63a818da,0x255400cb,0x39580308}},	//   _געזו, zwen, _kāle_, _ctrs_, 
   {{0x0ca818db,0x63a818dc,0x8ca81166,0x6aa40104}},	//   _стои_, ywen, _съоб_, sehf, 
   {{0x63a818dd,0x395800cc,0x2554004f,0x78a4013c}},	//   xwen, _etrs_, _māle_, õiva, 
   {{0x9ba018de,0xe73818df,0x63a80036,0x201c0513}},	//   _تەكى, шел_, vwen, ştig_, 
   {{0x63a818e0,0x555018e1,0x04140223,0x00000000}},	//   wwen, وپور, _àjẹk, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x63a818e2,0xd36c0a1d,0x98f00046,0x68e818e3}},	//   uwen, نهي_, _تګلا, _iled, 
   {{0x63a818e4,0x68e80357,0x13000007,0x60d40a16}},	//   rwen, _hled, дзьм, _soym, 
   {{0x2b5806d1,0x68e818e5,0x60d401a0,0x74e80182}},	//   _ltsc_, _kled, _poym, рдөг_, 
   {{0x60d418e6,0x63a81880,0x68e80249,0x00000000}},	//   _qoym, pwen, _jled, --, 
   {{0x63a808a6,0x2b5818e7,0x60d40616,0x2554015b}},	//   qwen, _ntsc_, _voym, _dāle_, 
   {{0x68e818e8,0x539802c3,0x77640002,0x00000000}},	//   _lled, _כינו, ġixx, --, 
   {{0x2b580039,0x823418e9,0x290c000f,0x68e818ea}},	//   _atsc_, _ارشا, _ojea_, _oled, 
   {{0x39580091,0xb370004b,0xdf480254,0xa2d40098}},	//   _rtrs_, _تۯیش, _кзид_, मॉर्, 
   {{0xa2cc18eb,0xda6410ab,0xc0f0001d,0x611018ec}},	// [1440] ताप्, قاضي, _ሃምሳ_, gāle, 
   {{0x68e8013b,0x290c0054,0x25540059,0xe7240122}},	//   _aled, _ajea_, _zāle_, _سڵ_, 
   {{0x68e818ed,0x00000000,0x00000000,0x00000000}},	//   _bled, --, --, --, 
   {{0x68e818ee,0x718c00cf,0x00000000,0x00000000}},	//   _cled, רװאַ, --, --, 
   {{0x68e80249,0x26c401ca,0x27280e0b,0x00000000}},	//   _dled, _bnlo_, rúnn_, --, 
   {{0x68e818ef,0x61ec0ae3,0x290c0b07,0xda700012}},	//   _eled, _ƙall, _ejea_, _زُر_, 
   {{0x68e818f0,0xa2cc06ed,0x7a3000d3,0xf8b80553}},	//   _fled, तान्, _dótí, _гөл_, 
   {{0x68e818f1,0xe3b80560,0x7afc0139,0x86040121}},	//   _gled, _ཙནྡ྄, _hmrt, تقىق_, 
   {{0xded00661,0x00000000,0x00000000,0x00000000}},	//   _ከምኡ_, --, --, --, 
   {{0xb5fc0002,0x068000bf,0x68e801d5,0x00000000}},	//   _leġi, _огун, _zled, --, 
   {{0x112802dc,0x68e80379,0x394418f2,0x255400a8}},	//   июми_, _yled, _kims_, _pāle_, 
   {{0x394405d9,0x00000000,0x00000000,0x00000000}},	//   _jims_, --, --, --, 
   {{0x394418f3,0xc4980107,0xe8e000fc,0x660c0386}},	//   _mims_, _כשאת, lỳär_, şakt, 
   {{0xdb0401d5,0xdcec015b,0x00000000,0x00000000}},	//   _prký, kubē, --, --, 
   {{0xccf8005b,0xad240cc2,0xe2a818f4,0xc27800ca}},	//   аћа_, كىسى, _دانن_, _כרגי, 
   {{0x39440638,0x20140045,0x8b640272,0x7afc004f}},	//   _nims_, écié_, قائم, _amrt, 
   {{0xebc40087,0x00000000,0x00000000,0x00000000}},	// [1450] чәнн, --, --, --, 
   {{0x394418f5,0x68e818f6,0x61100059,0x29c801c4}},	//   _aims_, _sled, rāle, йтеү_, 
   {{0x39440085,0xe94418f7,0xba740d5a,0xdb0401d4}},	//   _bims_, سرای, باقت, _arkó, 
   {{0xaac80d5b,0x394418f8,0x66dc0078,0x764802e6}},	//   राहक, _cims_, _lèkt, _agdy, 
   {{0x39440353,0x68e800f1,0xa2cc18f9,0x00000000}},	//   _dims_, _vled, ताम्, --, 
   {{0x2ca818fa,0x9ba00bf3,0x68e8139b,0xf77018fb}},	//   lead_, _سەمى, _wled, ئان_, 
   {{0xd6cc18fc,0x394400f1,0x68e80249,0x00000000}},	//   اقى_, _fims_, _tled, --, 
   {{0x2ca818fd,0xaac800cb,0xa2cc00cb,0x3944028d}},	//   nead_, रावक, ताभ्, _gims_, 
   {{0x291c18fe,0xe29818ff,0x53c402ba,0x00000000}},	//   mowa_, бап_, згым_, --, 
   {{0x291c1900,0x66dc00d3,0x26c400d3,0x00000000}},	//   lowa_, _pèku, _unlo_, --, 
   {{0x7d080212,0xd1dc02b4,0xe1241901,0xe29818b9}},	//   édsk, _ዕርቂ_, змни, _ғай_, 
   {{0x291c1902,0xd5980107,0x00000000,0x00000000}},	//   nowa_, _לבעל, --, --, 
   {{0x2ca80bc1,0xb5fc0c89,0x4438175c,0x76480031}},	//   dead_, _reġi, _àq_, _ygdy, 
   {{0x291c1903,0x248c1904,0x83500191,0x442c01d9}},	//   howa_, lgem_, _ٹھکا, _izg_, 
   {{0x291c1905,0x2ca80272,0xb4540122,0xdd901906}},	//   kowa_, fead_, _رخۆش, عور_, 
   {{0x7afc1907,0x248c08c3,0x2ca80320,0x66dc00f1}},	//   _smrt, ngem_, gead_, _kèks, 
   {{0x291c1908,0x6ab40237,0x67201909,0x3944190a}},	// [1460] dowa_, _bazf, _oklj, _rims_, 
   {{0xe32808be,0x8b200734,0x4b200c9f,0xdddc0078}},	//   _ཤེསཔ_, едуе, емув, _repņ, 
   {{0x61e0190b,0x66dc0249,0x3944015b,0x00000000}},	//   nyll, _lèks, _pims_, --, 
   {{0x291c190c,0x442c018f,0x2ca80097,0x61e000a0}},	//   gowa_, _ozg_, cead_, iyll, 
   {{0x61e0190d,0x4cb8033c,0x6cc404e7,0x442c015e}},	//   hyll, _הזכו, _ўқув_, _nzg_, 
   {{0xb4b40267,0x61e0061e,0x248c000b,0x645c0151}},	//   _छोड़_, kyll, egem_, ñsin, 
   {{0x61e0190e,0x291c190f,0x39440638,0x442c01ed}},	//   jyll, bowa_, _tims_, _azg_, 
   {{0x38c802a5,0x94a81910,0x442c0593,0x61e01911}},	//   _باسی_, стка_, _bzg_, dyll, 
   {{0x61e000a0,0x57e80182,0x69d000c2,0x00000000}},	//   eyll, _удам_, ădeş, --, 
   {{0x248c0385,0x61e01912,0x76480007,0x6b4800e5}},	//   agem_, fyll, _ugdy, _užge, 
   {{0xbbc81913,0x442c01e3,0x7bc0015b,0x61e01914}},	//   रमुक, _ezg_, _šmul, gyll, 
   {{0xc0580041,0x9f4c0212,0x706000ff,0x442c0104}},	//   зір_, žným_, _ገንዘቦ, _fzg_, 
   {{0xdb040085,0x61e00cfa,0xc2040eba,0x2ca81915}},	//   _iskæ, ayll, ققین_, vead_, 
   {{0x61e01916,0x61340270,0x291c1917,0x00000000}},	//   byll, jálf, zowa_, --, 
   {{0x291c028a,0x61e00034,0xac941918,0x42980107}},	//   yowa_, cyll, мавш, _הסוב, 
   {{0x291c1919,0x255400a8,0x00000000,0x00000000}},	//   xowa_, _jāla_, --, --, 
   {{0x2ca8191a,0x66dc029f,0x8aa4191b,0x0f240302}},	// [1470] read_, _mèkr, зред, _ньом, 
   {{0x2ca8191c,0x291c191d,0x61100a8a,0xf1b0191e}},	//   sead_, wowa_, māla, _जनान, 
   {{0x291c191f,0xa2cc1920,0x80b002fa,0x2ca800b6}},	//   towa_, तात्, টার্, pead_, 
   {{0xfbd01921,0xdddc02ef,0xd49000c2,0xd1e0010f}},	//   ختہ_, _nepř, _ncπ_, _ምኞት_, 
   {{0x291c1922,0x61101923,0xa7b800e7,0x61340306}},	//   rowa_, nāla, юлду_, bálf, 
   {{0x291c1924,0xd24403e0,0xdb04012e,0xe5a4006e}},	//   sowa_, _لن_, _askæ, дики, 
   {{0x67200f68,0x15d00121,0x61101925,0x66dc076e}},	//   _vklj, _ﻛﯧﺮﻩ, hāla, _sèks, 
   {{0x61101926,0x61e01927,0x00000000,0x00000000}},	//   kāla, vyll, --, --, 
   {{0x248c1928,0x61e0009c,0xed800422,0xddcc007f}},	//   rgem_, wyll, _ክግበር_, rabũ, 
   {{0xb9dc0648,0x61e01929,0x67200b53,0x80a00523}},	//   _በቲ_, tyll, _uklj, ग्ने, 
   {{0x61e0006f,0xdfd000dd,0x442c0201,0x00000000}},	//   uyll, ھيس_, _wzg_, --, 
   {{0x61e0192a,0xd30800cb,0x66dc0078,0xa2bc168d}},	//   ryll, rṇa_, _tèks, _वोर्, 
   {{0x61e00f32,0x1ea8192b,0xa2cc1671,0xf484070b}},	//   syll, ياسي_, ताद्, _чухн, 
   {{0x61e00c12,0x216800c3,0x63bc036d,0xdddc012c}},	//   pyll, _дики_, åsnu, _zepř, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1be8138a,0x00000000,0x00000000,0x00000000}},	//   одби_, --, --, --, 
   {{0x64581562,0xaac80d49,0x613401ca,0x00000000}},	// [1480] _mfwi, रांक, tálf, --, 
   {{0x4f04192c,0x4aa4192d,0x3ae4192e,0xec3401a0}},	//   _онын_, мкун_, _köpi_, رولگ, 
   {{0x9848192f,0x64581930,0x61341931,0xd1dc001d}},	//   ояла_, _ofwi, rálf, _ዕይታ_, 
   {{0x395c0059,0x48e01932,0x00000000,0x00000000}},	//   īvs_, кохв, --, --, 
   {{0x7d041933,0xda641934,0x48dc00b6,0x00000000}},	//   miis, _ياسي, _ककरो_, --, 
   {{0x7d041935,0x64581526,0x3f540299,0x66dc005e}},	//   liis, _afwi, _mäu_, _sèkr, 
   {{0x05701936,0xdddc0192,0x255400a8,0x857001ac}},	//   نايد, _pepř, _pāla_, نديئ, 
   {{0x46e4039c,0x73d81937,0xd378070b,0x80a0012c}},	//   здән_, здир_, очо_, ग्मे, 
   {{0xdddc0192,0x2554004f,0x00000000,0x00000000}},	//   _vepř, _vāla_, --, --, 
   {{0x7d041938,0x66800012,0x68e80126,0x733401ff}},	//   hiis, _میٖل, _ċedi, عىدا, 
   {{0x7d041939,0xdb0401c8,0x2554193a,0x00000000}},	//   kiis, _iskä, _tāla_, --, 
   {{0x7d04193b,0x61100a8a,0xcfa40182,0x321401d3}},	//   jiis, tāla, мшги, _ādyā_, 
   {{0x7d04193c,0x23080046,0xc0e40007,0xb9e0010f}},	//   diis, _کتني_, тоўк, _ጥጥ_, 
   {{0x69c001c3,0x61100a8a,0x7520193d,0x6064001e}},	//   _šlem, rāla, lomz, _ҧхыҷ, 
   {{0x7d04004b,0x2fcc00c2,0x00000000,0x00000000}},	//   fiis, ţeg_, --, --, 
   {{0x7d04193e,0x201c0254,0x611000cb,0x752008c2}},	//   giis, ştia_, pāla, nomz, 
   {{0xfd4402b3,0xdb0401c5,0x00000000,0x00000000}},	// [1490] тэрн, _oskä, --, --, 
   {{0x0dc80683,0xc98404e7,0x705401b5,0x9400009f}},	//   _думи_, дуди, _تچھا, ükə_, 
   {{0x7d04193f,0x7520019b,0x61ec028a,0x00000000}},	//   biis, komz, _ƙali, --, 
   {{0x7d041940,0x00000000,0x00000000,0x00000000}},	//   ciis, --, --, --, 
   {{0x78640256,0xa8740041,0xc7a81941,0x2cb800b7}},	//   ткіз, _үлгі, تدال_, _iasd_, 
   {{0x6b8c1942,0x00000000,0x00000000,0x00000000}},	//   muag, --, --, --, 
   {{0xa2cc0828,0x27e80518,0x6b8c1943,0x2cb81658}},	//   तास्, šan_, luag, _kasd_, 
   {{0x75201944,0xdb04006b,0x00000000,0x00000000}},	//   gomz, _eskä, --, --, 
   {{0x61340212,0x6b8c1945,0x24081946,0xe2981947}},	//   nále, nuag, янии_, пап_, 
   {{0xe1f81948,0x7d041949,0xd1b800dd,0x6b8c006f}},	//   зго_, ziis, ڳاپا_, iuag, 
   {{0x6b8c03f2,0xb59400b8,0x77500020,0x7d04194a}},	//   huag, _аихш, _ንተሳተ, yiis, 
   {{0x7d040012,0x68f8194b,0x8cd003e1,0x6134012c}},	//   xiis, _çadı, डाफो, kále, 
   {{0x7d04194c,0x6b8c04ac,0x6134194d,0xdb0402eb}},	//   viis, juag, jále, _yskä, 
   {{0x6b8c194e,0x7d04194f,0x6134048a,0x2d540252}},	//   duag, wiis, dále, _båe_, 
   {{0x7d041950,0xdca41951,0xa0a41952,0x6b8c006f}},	//   tiis, нави, _зайд, euag, 
   {{0x6b8c08ff,0xa2cc1953,0x61101954,0x3f5400a2}},	//   fuag, ताव्, mālo, _täu_, 
   {{0x7d041955,0x61341956,0x6b8c1957,0x2a700091}},	// [14a0] riis, ráld, guag, _bezb_, 
   {{0x7d041958,0x2cb802ba,0x0c200128,0xd1f40222}},	//   siis, _easd_, умун, ገውቲ_, 
   {{0x7d040e92,0x75201959,0x6b8c00a0,0x2ee4002a}},	//   piis, yomz, auag, ölfe_, 
   {{0x6b8c0a65,0x7d040012,0x2cb80097,0x2120195a}},	//   buag, qiis, _gasd_, nokh_, 
   {{0xe7940012,0xbb440116,0x8254010f,0x25540095}},	//   ناوک, _аҵак, _ቁሳቁሶ, _bālo_, 
   {{0xdb040207,0xdb0c00d3,0x00000000,0x00000000}},	//   _arkö, _ìjàl, --, --, 
   {{0x18680332,0x6b48195b,0x940802df,0xaa280012}},	//   _нави_, _užga, əbə_, _ہسہٕ_, 
   {{0xdb04000b,0x2cb80029,0xd944012b,0x9324005e}},	//   _opkë, _xasd_, _чеби, کربن, 
   {{0xc6c00041,0x7520195c,0x00000000,0x00000000}},	//   _өйтк, romz, --, --, 
   {{0xb6c8195d,0x877810bc,0x5184195e,0xd30800cb}},	//   _تارے_, _מאמי, нума, rṇo_, 
   {{0x61340212,0xe6d80270,0x7520042e,0x6b8c195f}},	//   zále, _þráð, pomz, zuag, 
   {{0x6b8c05d7,0x81440122,0x69c004c6,0x00000000}},	//   yuag, ێنین, _šlek, --, 
   {{0x201c1960,0xa2cc00cb,0x2cb80151,0x2d540085}},	//   ştin_, ताश्, _rasd_, _såe_, 
   {{0x3ddc0143,0x00000000,0x00000000,0x00000000}},	//   _ডেইল, --, --, --, 
   {{0xa2cc0828,0x00000000,0x00000000,0x00000000}},	//   तार्, --, --, --, 
   {{0x6b8c1961,0x0ccc00ac,0x80a01962,0x2cb801d9}},	//   tuag, রস্ত, ग्दे, _qasd_, 
   {{0x7d241963,0x00000000,0x00000000,0x00000000}},	// [14b0] افقن, --, --, --, 
   {{0x6b8c1964,0xbb840b5c,0xca700122,0x2cb800f1}},	//   ruag, اللي, اناک, _wasd_, 
   {{0x6b8c1965,0xbf141966,0x613402c6,0x00000000}},	//   suag, _сүрә, sále, --, 
   {{0x6b8c0493,0x6c780282,0x61340113,0xa2cc006c}},	//   puag, _קאָפ, pále, ताऱ्, 
   {{0x6b8c1967,0x255400a8,0x00000000,0x00000000}},	//   quag, _pālo_, --, --, 
   {{0x68e8011a,0xf1b003ef,0x660400b7,0x00000000}},	//   _ċedu, जबान, кпла, --, 
   {{0xdb0c00d3,0x00000000,0x00000000,0x00000000}},	//   _ìjál, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x255400e0,0x69c00192,0xd9b000cc,0x2334041c}},	//   _tālo_, _šleh, _مەەد, кхор, 
   {{0xa2e41968,0x00000000,0x00000000,0x00000000}},	//   тоод, --, --, --, 
   {{0xe3b018d8,0x182800d5,0x00000000,0x00000000}},	//   _چرت_, _فقہی_, --, --, 
   {{0x65601969,0xf494196a,0xd24c0012,0x00000000}},	//   _itlh, _مشهد, ٝنی_, --, 
   {{0x3ae4046a,0xfe78196b,0xe298196c,0x98780100}},	//   _köpt_, нүп_, _жал_, וארט, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x61ec0ae3,0x65600428,0x81c400e0,0x00000000}},	//   _ƙalu, _jtlh, _blēž, --, 
   {{0xe6d80038,0x3ae401c5,0x00000000,0x00000000}},	//   _þræð, _löpt_, --, --, 
   {{0x1c44196d,0x23d00095,0x00000000,0x00000000}},	// [14c0] тнам, तमिद, --, --, 
   {{0x6560196e,0xc10401ac,0x00000000,0x00000000}},	//   _otlh, _جوڊي, --, --, 
   {{0x6560196f,0xdcec024f,0x00000000,0x00000000}},	//   _ntlh, şkır, --, --, 
   {{0x3ae400a2,0xb4b000a1,0x6b4800b0,0xd86000b8}},	//   _röpu_, _ओसे_, _užgn, рҵаҩ, 
   {{0x65601970,0x00000000,0x00000000,0x00000000}},	//   _atlh, --, --, --, 
   {{0xb72801ee,0xb870001d,0x00000000,0x00000000}},	//   رۋام_, _አሮጌው_, --, --, 
   {{0x3ae401c5,0xe8b001d0,0xb27400c3,0x00000000}},	//   _döpt_, _گەنج, ңлиш, --, 
   {{0x399c1971,0x48e01972,0x97c400bf,0x98a41973}},	//   mís_, _косв, _ийбе, _шибе, 
   {{0x399c1974,0x65601975,0x96941976,0xd1e00020}},	//   lís_, _etlh, _ареш, ምዒት_, 
   {{0xf1b0011e,0x69c01977,0x00000000,0x00000000}},	//   _जनआन, _šlei, --, --, 
   {{0x399c1978,0x00000000,0x00000000,0x00000000}},	//   nís_, --, --, --, 
   {{0x3ae401c5,0x7cf800d5,0x13e802ba,0x00000000}},	//   _köps_, _hírf, _омей_, --, 
   {{0x399c03e0,0x53b4093e,0xca4c095e,0x9fa401c4}},	//   hís_, _अनिश, ﺎﻻﺭ_, лырҙ, 
   {{0x80b00252,0x272803e2,0x59e00095,0x00000000}},	//   টাগ্, búnu_, पहार, --, 
   {{0x799c0034,0x00000000,0x00000000,0x00000000}},	//   _nqrw, --, --, --, 
   {{0x399c1979,0x69c003ed,0xdeb001d2,0x53b40095}},	//   dís_, _álei, _құсы, _अनाश, 
   {{0x19c0002c,0x3ae4013c,0xeb38044a,0x7b74059b}},	// [14d0] ҙәрг, _nöps_, езаш_, لطلا, 
   {{0x6134116c,0x399c0272,0x7af4021d,0x29cc06b4}},	//   mála, fís_, азує, jóað_, 
   {{0xd364197a,0xce30197b,0x613400cd,0x399c197c}},	//   _گه_, _خودک, lála, gís_, 
   {{0xfc640ba3,0x2d90197d,0x656001ab,0x50c000cb}},	//   _върн, muze_, _rtlh, षयिष, 
   {{0xd364197e,0x613400cd,0x9cd40240,0x2d90197f}},	//   _ده_, nála, _עושה_, luze_, 
   {{0xa5b8005b,0x76c40121,0x3ae401c5,0xddcc1980}},	//   ећих_, لغىل, _döps_, labš, 
   {{0x399c1981,0x613403e0,0xf9d41982,0x2d90017b}},	//   cís_, hála, _корэ, nuze_, 
   {{0xdddc00c2,0x65600428,0x00000000,0x00000000}},	//   _lepş, _vtlh, --, --, 
   {{0x2d901983,0x61340038,0xecc402fa,0x00000000}},	//   huze_, jála, _একাড, --, 
   {{0xba0800a7,0x61341984,0xdb0402e8,0xdec00020}},	//   _ገባ_, dála, _sskú, ትትን_, 
   {{0x2d901985,0x65600380,0xb1d80027,0x00000000}},	//   juze_, _utlh, вьях_, --, 
   {{0x2d9000f8,0x201c0333,0x00000000,0x00000000}},	//   duze_, ştim_, --, --, 
   {{0x61341986,0x2d90018c,0xd24c00e2,0x638402eb}},	//   gála, euze_, تنۍ_, _сгла, 
   {{0xe2981987,0x27281988,0x2d901989,0x6d40198a}},	//   _чак_, múns_, fuze_, ïlan, 
   {{0x2d90198b,0x9310198c,0xd3340107,0x399c02ba}},	//   guze_, _دووش, _גרסה_, xís_, 
   {{0x399c198d,0x613401ca,0x00000000,0x00000000}},	//   vís_, bála, --, --, 
   {{0x6134198e,0x5f280111,0x00000000,0x00000000}},	// [14e0] cála, _поим_, --, --, 
   {{0x2d90198f,0x80a00f7c,0x399c1990,0x3f801991}},	//   buze_, ग्रे, tís_, _iviu_, 
   {{0x58841992,0x8cbc1993,0x80d81994,0x2d900172}},	//   гыла, _लोको, यापे, cuze_, 
   {{0x399c1995,0xd8380182,0x7cf800f2,0x00000000}},	//   rís_, нэл_, _sírf, --, 
   {{0xdef401e2,0xb8dc1996,0x399c1997,0xd70800fc}},	//   _ለምን_, _अस_, sís_, ннде_, 
   {{0xd5b81998,0x399c0306,0xdb080139,0x00000000}},	//   еси_, pís_, änäi, --, 
   {{0x7bc41999,0x63b80105,0x98a403f2,0x6aa0002a}},	//   lviu, _aswn, aloā_, _ölfa, 
   {{0xdb040252,0x7bc400b0,0x00000000,0x00000000}},	//   _askø, oviu, --, --, 
   {{0x2728199a,0x7054199b,0x12e40041,0x80d8199c}},	//   gúns_, یندا, гінг, याने, 
   {{0x613400cd,0x2d90199d,0xd574199e,0x7bc4199f}},	//   vála, yuze_, _будь, iviu, 
   {{0x3f8019a0,0xb9cc02b4,0x48f819a1,0x546819a2}},	//   _aviu_, _ኰነ_, लोको_, _заем_, 
   {{0x2d9019a3,0xd1c801c8,0x613419a4,0x27280306}},	//   vuze_, _үлде_, tála, súnt_, 
   {{0x8cbc0066,0x8fe004f7,0x2d9019a5,0x72d4079e}},	//   _लोगो, сәйҙ, wuze_, _волф, 
   {{0x438003e0,0x613403e0,0x8380009d,0x2d90017b}},	//   _الوق, rála, _اټوم, tuze_, 
   {{0x613419a6,0x518419a7,0xad24177d,0x3f8002ba}},	//   máln, _сула, لىسى, _eviu_, 
   {{0x2d900be3,0x61340191,0xaf5400b8,0x00000000}},	//   ruze_, láln, _ҩнқә, --, 
   {{0x7bc40ca7,0xc0c0010f,0x2d900472,0x23680126}},	// [14f0] gviu, ትንም_, suze_, _ħajk_, 
   {{0x613419a8,0x2fc819a9,0x3a3811ae,0x2d9019aa}},	//   náln, _irag_, _bzrp_, puze_, 
   {{0xc3300240,0x7bc40132,0x2d900636,0xa85400bf}},	//   צוע_, aviu, quze_, акеч, 
   {{0x2fc80141,0x3f8019ab,0x80d819ac,0xcb4401ec}},	//   _krag_, _yviu_, याये, _әхми, 
   {{0x613419ad,0x6f1400fb,0x7bc400c2,0x140c0440}},	//   káln, onzc, cviu, ापोह_, 
   {{0x6b8c19ae,0x2fc80177,0x613400ef,0x80380100}},	//   mrag, _mrag_, jáln, אנדע_, 
   {{0xeb3419af,0x80d8186f,0xdac4006e,0x24f4009e}},	//   _مىڭد, यामे, _خېلى_, ичир, 
   {{0x2bc819b0,0x7cf819b1,0x638419b2,0x6b8c0cfa}},	//   रिपा, _vírg, агиа, orag, 
   {{0x2fc801f9,0xe6940254,0x613404e3,0x6b8c19b3}},	//   _nrag_, _визы, fáln, nrag, 
   {{0x611019b4,0x613419b5,0x6b8c0cfa,0x201c024f}},	//   māli, gáln, irag, ştik_, 
   {{0x7cf8063a,0x6b8c19b6,0x2fc801b5,0x7bc40403}},	//   _híre, hrag, _arag_, zviu, 
   {{0xe04419b7,0x2fc819b8,0x6b8c19b9,0x6f140008}},	//   инни, _brag_, krag, enzc, 
   {{0x613419ba,0x2fc819bb,0x61100059,0x27fc0078}},	//   báln, _crag_, nāli, nzwn_, 
   {{0x7cf80272,0xd5c00299,0xdcec00bd,0x613400ef}},	//   _míre, _whāū_, ědče, cáln, 
   {{0x442c19bc,0x6b8c19bd,0xdcb019be,0xdc9819bf}},	//   _hyg_, erag, يىس_, кташ_, 
   {{0x6b8c19c0,0xa2cc0846,0x2fc819c1,0x164c010f}},	//   frag, ताक्, _frag_, _ማዳበሪ, 
   {{0x6b8c19c2,0x613400cd,0x9b0419c3,0x7bc4012a}},	// [1500] grag, lálo, азад, uviu, 
   {{0x7bc419c4,0x442c0353,0x0f7800ca,0x611019c5}},	//   rviu, _myg_, _שאיב, dāli, 
   {{0x442c19c6,0x6b8c19c7,0x7e7c19c8,0x613419c9}},	//   _lyg_, arag, marp, nálo, 
   {{0x6b8c0cfa,0x7e7c19ca,0x98a419cb,0x3860017d}},	//   brag, larp, риде, ùir_, 
   {{0x7bc40ca7,0x69c4021d,0x6b8c19cc,0xc7a019cd}},	//   qviu, avhe, crag, жичк, 
   {{0x7cf8045d,0x7e7c0a94,0x6e2801c8,0x6ed800cb}},	//   _díre, narp, şebe, मायु, 
   {{0x7e7c012e,0x7cf80075,0x442c01d9,0x00000000}},	//   iarp, _tírd, _ayg_, --, 
   {{0x442c0c8f,0xd3a419ce,0x7cf800d5,0x23d003bf}},	//   _byg_, ароп, _hírb, तमंद, 
   {{0x2bc819cf,0x613405a4,0x395801ab,0x08f80012}},	//   रिया, táln, _hurs_, _شرٲب_, 
   {{0xa2cc0095,0x7e7c19d0,0x06f00c2b,0x00000000}},	//   ताग्, jarp, _अतएव_, --, 
   {{0x613405a4,0x7e7c19d1,0xc68c0012,0x442c0139}},	//   ráln, darp, _زِن_, _eyg_, 
   {{0x6b8c0437,0x395819d2,0x2d8400bd,0xd3881166}},	//   yrag, _murs_, álem_, _айде_, 
   {{0x7e7c0336,0x03a001f1,0xb7f80030,0x00000000}},	//   farp, _мицо, ्छिम_, --, 
   {{0x6b8c19d3,0x395819d4,0x7e7c19d5,0x2fc819d6}},	//   vrag, _ours_, garp, _vrag_, 
   {{0x13b4040e,0x395819d7,0x6b8c19d8,0x613419d9}},	//   _अनुभ, _nurs_, wrag, cálo, 
   {{0x2fc819da,0x90e403b5,0x7e7c012e,0x61340191}},	//   _trag_, _خستن, aarp, náll, 
   {{0x6b8c19db,0x2fc8008f,0x3d081095,0x6e9408ec}},	// [1510] urag, _urag_, _सगरे_, _липу, 
   {{0x6b8c19dc,0x3958024f,0x2bc80c5f,0x00000000}},	//   rrag, _burs_, रिबा, --, 
   {{0x395819dd,0x6b8c19de,0x6e28059c,0x7cf819df}},	//   _curs_, srag, şebb, _dírb, 
   {{0x6b8c19e0,0x395819e1,0x69c00059,0x61100059}},	//   prag, _durs_, _šles, tāli, 
   {{0xa7a80106,0xd5ac004b,0x9cd400ca,0x9f4001d5}},	//   укла_, ہہٕ_, _הורה_, lyká_, 
   {{0x69c404cd,0x7cf80075,0x61100059,0x442c19e2}},	//   pvhe, _víre, rāli, _ryg_, 
   {{0x442c0c8f,0xa50819e3,0x395819e4,0x094800b8}},	//   _syg_, лека_, _gurs_, _ачаи_, 
   {{0x201c009e,0x61340191,0xa84819e5,0x7e7c19e6}},	//   ştii_, gáll, _ملزم_, zarp, 
   {{0xe3b00272,0x7e7c19e7,0x23280123,0x7cf800d5}},	//   سرة_, yarp, лоии_, _hírc, 
   {{0x613419e8,0xd34407e2,0x69c002b2,0x00000000}},	//   tálo, مینه_, _áles, --, 
   {{0x7e7c19e9,0xe12402dc,0x2bc819ea,0xb5c80352}},	//   varp, ймои, रिडा, _پونم_, 
   {{0x613419eb,0x66dc0078,0x7e7c19ec,0x442c19ed}},	//   rálo, _rèky, warp, _tyg_, 
   {{0x7e7c19ee,0x442c04e7,0x6144006e,0x62240121}},	//   tarp, _uyg_, _һека, شىڭل, 
   {{0x7e7c012f,0x5de4001e,0x959819ef,0x00000000}},	//   uarp, бжга, _ወርቅን_, --, 
   {{0x61440cac,0x7e7c19f0,0x80d819f1,0xd24c00dd}},	//   _лека, rarp, यादे, _ٻني_, 
   {{0x7e7c19f2,0x3d080698,0x2b58015e,0xfbc8041c}},	//   sarp, _सगळे_, _busc_, ағми_, 
   {{0x7e7c19f3,0xbe540046,0x395819f4,0x8c4019f5}},	// [1520] parp, _وردګ, _surs_, зете, 
   {{0x7e7c064b,0x39581510,0x61340191,0x6ed80095}},	//   qarp, _purs_, záll, माणु, 
   {{0x8e3803a2,0x1d0800df,0x8e54007c,0xd12c0122}},	//   _مسٽر_, _бени_, _לייג_, _زمی_, 
   {{0x2b5819f6,0x395801d1,0xd00c0324,0x613401d4}},	//   _fusc_, _vurs_, _آلی_, kálm, 
   {{0x255419f7,0x613419f8,0x02b419f9,0x2bc800cb}},	//   _mālu_, váll, _असून, रिणा, 
   {{0x3ce01547,0x6110068c,0x395819fa,0x7cf80306}},	//   ljiv_, mālu, _turs_, _fírc, 
   {{0xceb00240,0x611003f2,0x395801ed,0x613401b8}},	//   פיה_, lālu, _uurs_, táll, 
   {{0x3ce00070,0x4d780100,0xd49819fb,0x8a1400ca}},	//   njiv_, ארקע, урк_, _החלו_, 
   {{0xe508001c,0xbee800b3,0x38140122,0x38600105}},	//   vặt_, _ऐकून_, _بژار, ñiru_, 
   {{0x27f800a1,0x2bc80b37,0xd36c01ac,0xd70000e5}},	//   _üsna_, रिता, وڇڙ_, _пiса, 
   {{0x2d840126,0x00000000,0x00000000,0x00000000}},	//   ġlek_, --, --, --, 
   {{0x46380282,0x61100062,0x61340191,0xca340107}},	//   _געבע, kālu, lálj, מניה_, 
   {{0x304800dd,0xd4340128,0x00000000,0x00000000}},	//   شلسٽ_, _اعاب, --, --, 
   {{0x613400cd,0x2b5802ba,0x926800cc,0x00000000}},	//   nálj, _rusc_, _ёрла_, --, 
   {{0xc27819fc,0xe2a819fd,0x0ca802dc,0x6b48028d}},	//   _גרוי, _خانن_, лтаи_, _užgi, 
   {{0xdb040191,0x61b00061,0x00000000,0x00000000}},	//   _eskü, _کڕیا, --, --, 
   {{0x61100cbf,0xa2cc0991,0x996002cc,0x3b5402dc}},	// [1530] gālu, ताच्, _ríše_, зкур, 
   {{0xdd900a1d,0x7cf802ba,0x34c40477,0x6e940075}},	//   _ڪوٽ_, _pírc, वयुद, _بلدا, 
   {{0x99600214,0x2b58075d,0x0dc819fe,0x690801e3}},	//   _píše_, _wusc_, _супи_, аsdа, 
   {{0xdcb019ff,0x2b580034,0x4a7401c4,0x38581049}},	//   _قىپ_, _tusc_, рыҡт, مشهد_, 
   {{0x6fc8025c,0x66e401d9,0x7f4800e3,0x00000000}},	//   िटिं, жола, _خلیق_, --, 
   {{0x38a000a2,0x613401b8,0xff7c0d47,0xf7480eed}},	//   _rōrō_, gálj, נטומ, ملني_, 
   {{0x7cf80191,0x00000000,0x00000000,0x00000000}},	//   _híra, --, --, --, 
   {{0xe9180302,0x24e802dc,0x2ca80306,0x00000000}},	//   _тобі_, рмии_, nfad_, --, 
   {{0x80d8186f,0x87040027,0x00000000,0x00000000}},	//   यासे, _ляже, --, --, 
   {{0x7cf81a00,0x43000087,0x613400ef,0x00000000}},	//   _míra, яҗла, rálm, --, 
   {{0xf748045d,0x047404e2,0x61441a01,0xf6500128}},	//   _اللي_, _هلاک_, жена, _كئم_, 
   {{0xa2a803d0,0x6fb80560,0x2d901a02,0x613400ef}},	//   _जॉर्, _བརྡའ, drze_, málk, 
   {{0x3f8402da,0x613400cd,0x0364004b,0x22c000a2}},	//   ému_, lálk, _أتی_, _pōkē_, 
   {{0x236c1a03,0x00000000,0x00000000,0x00000000}},	//   mpej_, --, --, --, 
   {{0xdd901a04,0x255400d4,0x2ca80479,0xb2c4132f}},	//   ظور_, _tālu_, ffad_, _رغوو, 
   {{0xdcb01a05,0xdc6805bc,0x61101a06,0x20d40103}},	//   بىر_, раад_, tālu, _фікс, 
   {{0x69c01a07,0x60d41a08,0x2d901a09,0x9b88005e}},	// [1540] _šlep, _inym, arze_, شنال_, 
   {{0x2d9006f7,0x80d80698,0x7cf800d3,0x61341a0a}},	//   brze_, यावे, _díra, kálk, 
   {{0x3eb81a0b,0xa2a00c5f,0x9db80023,0x200001d1}},	//   mert_, _खान्, _тыпу_, lzki_, 
   {{0x3eb81a0c,0x61341a0d,0x2bd0025c,0x2ca80306}},	//   lert_, dálk, समखा, cfad_, 
   {{0x39400025,0x3eb80d13,0x7cf806b4,0x236c1a0e}},	//   ķis_, oert_, _gíra, jpej_, 
   {{0x3eb81a0f,0xdb0401e8,0xd5641a10,0xf77000dd}},	//   nert_, _eskò, отип, واڙ_, 
   {{0x3eb8048d,0x7cf81a11,0x00000000,0x00000000}},	//   iert_, _zíra, --, --, 
   {{0x3eb81a12,0x60d4007b,0x00000000,0x00000000}},	//   hert_, _nnym, --, --, 
   {{0x3eb81a13,0x14a41a14,0x2554015b,0x287400b8}},	//   kert_, क्षण, _bāls_, _хыср, 
   {{0x60d41a15,0x613400cd,0x2000002f,0xa3000087}},	//   _anym, lálh, dzki_, нүче, 
   {{0xd6281a16,0x74141a17,0x00000000,0x00000000}},	//   _тоже_, توکا, --, --, 
   {{0x613400cd,0x3eb801ed,0x00000000,0x00000000}},	//   nálh, eert_, --, --, 
   {{0x3eb81a18,0x30c801b8,0x20040031,0x53380320}},	//   fert_, لڈکپ_, _ýoil_, _кукă, 
   {{0x6ef800d3,0x2d90002f,0x2554015b,0x2bc80095}},	//   _bìba, trze_, _gāls_, रिसा, 
   {{0x4170086b,0x7cf81a19,0x26d80271,0x2d840191}},	//   _قايس, _síra, _ɑso_, éle_, 
   {{0xac580a6d,0x7cf802b2,0xc10400ea,0x01f800ca}},	//   сааф_, _píra, _يووي, _כפול, 
   {{0x200006f7,0x3eb81a1a,0x2ca81a1b,0x80d800aa}},	// [1550] czki_, bert_, rfad_, यारे, 
   {{0x3eb81a1c,0x8a681a1d,0x0a6802dc,0x2ca80085}},	//   cert_, ршаб_, рраи_, sfad_, 
   {{0xfd1000cd,0x6d341a1e,0x2bc81164,0x80b002fa}},	//   رجہ_, _неоф, रिहा, য়ার্, 
   {{0x7cf81a1f,0x7c3805c0,0x02b4191e,0xac180152}},	//   _tíra, ðaræ, _अस्न, _гому_, 
   {{0x39480134,0x00000000,0x00000000,0x00000000}},	//   ڭشەپ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe29804f7,0x7cf800aa,0xd6cc1a20,0x00000000}},	//   ҙан_, _mírn, طقي_, --, 
   {{0xd5ac1a21,0xe2980551,0x61341a22,0xa0240126}},	//   افي_, әан_, rálk, _རྙྀང_, 
   {{0x613400ef,0x25a8038a,0x00000000,0x00000000}},	//   sálk, ŋal_, --, --, 
   {{0x61341a23,0x68e81a24,0x290c008b,0xa2040302}},	//   máli, _hoed, _hmea_, зпод, 
   {{0x3eb81a25,0x68e81a26,0x26c403f2,0x236c00d4}},	//   vert_, _koed, _ialo_, spej_, 
   {{0x3eb81800,0x26c41a27,0x00000000,0x00000000}},	//   wert_, _halo_, --, --, 
   {{0x290c1a28,0x68e80a92,0x3eb81a29,0x26c41a2a}},	//   _mmea_, _moed, tert_, _kalo_, 
   {{0x26c40ee9,0x68e81a2b,0x3eb81a2c,0x717000c3}},	//   _jalo_, _loed, uert_, رۇۋا, 
   {{0x62801a2d,0x3eb8036a,0x26c41a2e,0xca30046d}},	//   malo, rert_, _malo_, ﺯﯨﺮ_, 
   {{0x3eb81a2f,0x68e81a30,0x61341a31,0x9f840074}},	//   sert_, _noed, káli, _егид, 
   {{0x6458051f,0x26c403f2,0xed340023,0x909800ca}},	// [1560] _mgwi, _oalo_, фэрэ, _הספק, 
   {{0x290c1a32,0x9ccc0126,0x7cf802b2,0x34b80095}},	//   _amea_, _ཌོམྦ, _gírn, _आस्द, 
   {{0x68e81a33,0x6458051f,0xf8b801c4,0x628003c7}},	//   _boed, _ogwi, ҙөң_, ialo, 
   {{0x62801a34,0x64581a35,0x61341a36,0x68e80336}},	//   halo, _ngwi, fáli, _coed, 
   {{0x62801a37,0x26c41a38,0x68e81a39,0x613401b8}},	//   kalo, _balo_, _doed, gáli, 
   {{0x62801a3a,0x26c41a3b,0x64580b75,0xda701a3c}},	//   jalo, _calo_, _agwi, _سُر_, 
   {{0x26c41a3d,0x62801a3e,0x68e8044f,0x7cf8012c}},	//   _dalo_, dalo, _foed, _jíro, 
   {{0x68e81a3f,0x290c0243,0x23680126,0x7cf80192}},	//   _goed, _gmea_, _ħajr_, _míro, 
   {{0x62801a40,0x26c41a41,0x61341a42,0x82f400ea}},	//   falo, _falo_, cáli, ګريز_, 
   {{0x26c41a43,0xa2a01a44,0x00000000,0x00000000}},	//   _galo_, _खाण्, --, --, 
   {{0x5694016d,0x68e80088,0x290c018c,0x3944042e}},	//   _маҡт, _yoed, _ymea_, _khms_, 
   {{0x26c408a6,0x62801a45,0x64580126,0x93a81a46}},	//   _zalo_, aalo, _ggwi, _هاتف_, 
   {{0x26c41a47,0xe5041a48,0x25540059,0x93441a49}},	//   _yalo_, _تبلي, _tālr_, _енде, 
   {{0x26c40014,0x0e080937,0x7cf800d5,0x332c0126}},	//   _xalo_, бэби_, _bíro, qodx_, 
   {{0xa2a00698,0x39441a4a,0x6aa00104,0x645802b0}},	//   _खात्, _ohms_, _ölfi, _ygwi, 
   {{0x7cf801d5,0x2bc81a4b,0x00000000,0x00000000}},	//   _díro, रिला, --, --, 
   {{0x68e80f32,0x201c0a4e,0x00000000,0x00000000}},	// [1570] _roed, ştir_, --, --, 
   {{0x68e81a4c,0x7cf800cd,0x61340d6f,0x00000000}},	//   _soed, _hírl, váli, --, 
   {{0x26c41a4d,0x68e81a4e,0x7bc00239,0x7afc00e0}},	//   _ralo_, _poed, _âmun, _dlrt, 
   {{0xf9901a4f,0x61341a50,0x39440088,0xa81400bf}},	//   ابل_, táli, _chms_, мдеш, 
   {{0x26c41a51,0x62801a52,0x68e81a53,0x79a401c4}},	//   _palo_, yalo, _voed, _үрсе, 
   {{0x61341a54,0x6280175c,0x68e81a55,0x10680ef1}},	//   ráli, xalo, _woed, _ﺳﯩﺰﯨ, 
   {{0x62801a56,0x61341a57,0x26c41a58,0x68e81a59}},	//   valo, sáli, _valo_, _toed, 
   {{0x62801a5a,0x22480100,0x290c1a5b,0x613419eb}},	//   walo, _ŝako_, _umea_, páli, 
   {{0xa2a006ec,0x26c41a5c,0xf7940007,0x2408041c}},	//   _खाद्, _talo_, _патэ, юнии_, 
   {{0x628005e1,0x613401b8,0x00000000,0x00000000}},	//   ualo, nálv, --, --, 
   {{0x62801a5d,0x64580151,0x291c1a5e,0x44241a5f}},	//   ralo, _tgwi, onwa_, _کراف, 
   {{0x645800ba,0x291c1a60,0x6134014e,0x00000000}},	//   _ugwi, nnwa_, hálv, --, 
   {{0x73e40302,0x2d840010,0x7cf80842,0x00000000}},	//   _поїз, âlen_, _síro, --, 
   {{0x63a81a61,0x6134020c,0x62801a62,0x00000000}},	//   mten, jálv, qalo, --, 
   {{0xdca404e7,0xdddc00e0,0x00000000,0x00000000}},	//   мави, _iepū, --, --, 
   {{0x20541a63,0x7cf81a64,0x3f84034c,0x00000000}},	//   _отпр, _víro, ámus_, --, 
   {{0x0fc003e5,0xd1e002b4,0x9f8400e5,0x00000000}},	// [1580] _айын, _ዝሞተ_, _ўгод, --, 
   {{0x63a81a65,0xdb1c019f,0xe9080560,0x8e8000b8}},	//   iten, _ävüd, _གཏུབ_, _игье, 
   {{0x63a81a66,0x8fe403b5,0xdb040207,0x18a41a67}},	//   hten, _فزیۆ, _oskö, даем, 
   {{0x63a81a68,0x2d9401a7,0xdddc00b0,0xf4d80143}},	//   kten, _ярьс, _lepū, _তত্ব, 
   {{0x09bc0037,0x63a81a69,0x00000000,0x00000000}},	//   _ཀརྨ_, jten, --, --, 
   {{0x6134056d,0x752402db,0x291c007b,0x47c800e2}},	//   málu, čizm, anwa_, غانۍ_, 
   {{0x63a8009e,0xceb00240,0x613401b8,0x00000000}},	//   eten, דיו_, lálu, --, 
   {{0x63a81154,0x89d40075,0x6b480023,0xf484116e}},	//   ften, _توفر_, _užgr, رابی, 
   {{0x63a81a6a,0x613401b8,0xb3541a6b,0x00000000}},	//   gten, nálu, нкиш, --, 
   {{0xdcfc015b,0x00000000,0x00000000,0x00000000}},	//   _appļ, --, --, --, 
   {{0xae940229,0x54681a6c,0x572000bf,0x00000000}},	//   _mẹtt, _даем_, _كۉچك, --, 
   {{0x63a800b9,0x776000e2,0x1e701a6d,0x00000000}},	//   bten, _kumx, ңғыс, --, 
   {{0x63a81a6e,0x0fcc01b9,0x6f4000a8,0xc0581a6f}},	//   cten, ৱন্ধ, _aśiṣ, дір_, 
   {{0x7cf801ca,0xf4240143,0x00000000,0x00000000}},	//   _dírm, _পরপর_, --, --, 
   {{0xdb040139,0x291c0078,0x00000000,0x00000000}},	//   _yskö, ynwa_, --, --, 
   {{0x0ccc01b9,0x6c5401f1,0xdec00222,0xdbd8012b}},	//   ৰস্ত, екбу, ስትኻ_, kçäv, 
   {{0x8aa41a70,0x09c4006c,0x8f4401c7,0x00000000}},	// [1590] дред, रट्य, _оход, --, 
   {{0x2d841a71,0x272801d4,0x00000000,0x00000000}},	//   áles_, búny_, --, --, 
   {{0x63a81a72,0x6f141a73,0x00000000,0x00000000}},	//   zten, mizc, --, --, 
   {{0x6f140397,0x291c01e7,0xd2440340,0x00000000}},	//   lizc, unwa_, _ۅن_, --, 
   {{0x6d4c1a74,0x0ba8071e,0x291c00f1,0x00000000}},	//   mmaa, _باجى_, rnwa_, --, 
   {{0xd2441a75,0x6d4c1a76,0x613400cd,0x6f1413d8}},	//   _من_, lmaa, lált, nizc, 
   {{0x6d4c1a77,0x16841a78,0x3860059a,0x79a403d6}},	//   omaa, راوێ, žira_, _ирте, 
   {{0x6d4c1a79,0x613400cd,0xe3b0104d,0x00000000}},	//   nmaa, nált, هرخ_, --, 
   {{0x63a81a7a,0x6d4c1a7b,0x6f14059c,0x7cf801b8}},	//   uten, imaa, kizc, _bírj, 
   {{0x6d4c1a7c,0x061c0020,0x61340306,0x00000000}},	//   hmaa, ትራውነ, hált, --, 
   {{0xa0a40332,0x6d4c1a7d,0xe1f011d2,0x6aa00038}},	//   нанд, kmaa, اسخ_, _ölfu, 
   {{0x6d4c028b,0x3604005e,0x00000000,0x00000000}},	//   jmaa, _جومف, --, --, 
   {{0xc4cc00cd,0x6d4c1a7e,0xf4841a7f,0x6560018c}},	//   _مےں_, dmaa, _рухн, _hulh, 
   {{0x65601a80,0x6d4c1a81,0x201c0254,0x00000000}},	//   _kulh, emaa, ăti_, --, 
   {{0x656009ac,0x613400b7,0x6d4c03f4,0xd1b801b8}},	//   _julh, fált, fmaa, _فاٹا_, 
   {{0x656009ac,0x6d4c1a82,0x613401b8,0x10a0044a}},	//   _mulh, gmaa, gált, _биън, 
   {{0x7cf801b8,0x00000000,0x00000000,0x00000000}},	// [15a0] _hírk, --, --, --, 
   {{0x6f141a83,0x80d800aa,0xed5802dc,0x61341a84}},	//   cizc, याके, зоӣ_, rálu, 
   {{0x656001c6,0x613401b8,0x6d4c0080,0x2d841a85}},	//   _nulh, bált, bmaa, šler_, 
   {{0x6d4c004b,0x57a41a86,0x613403ed,0x97a41a87}},	//   cmaa, ешка, máls, еркл, 
   {{0x65600379,0x613401b8,0x00000000,0x00000000}},	//   _aulh, láls, --, --, 
   {{0x65601a88,0x7d041a89,0x8f980282,0xc6f40302}},	//   _bulh, lhis, פיצי, нніх_, 
   {{0x65600335,0x948400fc,0x64bc03bf,0x00000000}},	//   _culh, ныпд, ्यूश, --, 
   {{0x73d80155,0x38c81a8a,0x42700087,0xe8b41a8b}},	//   ддир_, _غازی_, ңгыс, mışı, 
   {{0xe8b41a8c,0x7d041a8d,0xa5080121,0xb4b40116}},	//   lışı, ihis, بىيە_, еиқә, 
   {{0x55e40302,0x668001b5,0x7d041a8e,0x00000000}},	//   _позб, _نیٖل, hhis, --, 
   {{0xc0cc0661,0x7d041a8f,0xe8b41a90,0x6d4c1a91}},	//   _ኢሎም_, khis, nışı, ymaa, 
   {{0x7d041a92,0x6d4c004b,0x80d813f5,0x7cf80192}},	//   jhis, xmaa, यागे, _dírk, 
   {{0x7d041a93,0x0454045d,0x73c4016d,0x65601a94}},	//   dhis, _كلمة_, _рәйе, _zulh, 
   {{0xe8b40333,0x7d040139,0x02a00668,0x7cf800d5}},	//   kışı, ehis, _бръм, _hírh, 
   {{0x6d4c1a95,0xd24c01b5,0x7cf802b2,0x7d0401ca}},	//   tmaa, _دۆد_, _gírk, fhis, 
   {{0x7d041a96,0x6d4c1a97,0xe8b41a98,0x823800ca}},	//   ghis, umaa, dışı, _מעוצ, 
   {{0x61341a99,0xf078001e,0x00000000,0x00000000}},	// [15b0] rált, _еиқә_, --, --, 
   {{0xadf40822,0x6d4c1a9a,0xde100122,0x7d04028b}},	//   _апош, smaa, اژید, ahis, 
   {{0x7d041a9b,0x6d4c1a9c,0xe8b401c8,0x4db80143}},	//   bhis, pmaa, gışı, _উপকূ, 
   {{0x69c00064,0x6d4c1a9d,0xfe701a9e,0x613401b8}},	//   _âlem, qmaa, _پدی_, lálr, 
   {{0xd3641a9f,0x65601aa0,0xa2a01aa1,0x00000000}},	//   _خه_, _sulh, _खाल्, --, 
   {{0x65601aa2,0xe8b4006b,0x00000000,0x00000000}},	//   _pulh, bışı, --, --, 
   {{0xd5ac004b,0x2bc81722,0x65600140,0xf9d400fc}},	//   قہٕ_, रिका, _qulh, _йорэ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe85805bc,0x7cf81aa3,0xd3441aa4,0xa44402dc}},	//   _цааш_, _dírh, چینه_, ънид, 
   {{0x7790063a,0xdb0c0064,0xf59800df,0x69d41aa5}},	//   _ایوا, _âkôz, çýär_, _krze, 
   {{0x7d041aa6,0x7644028a,0xb0dc0b02,0x51f400dd}},	//   yhis, ƙiya, यांग, نسٽر, 
   {{0x69d41aa7,0x7d041aa8,0x00000000,0x00000000}},	//   _mrze, xhis, --, --, 
   {{0x7d04052e,0x0fc002dc,0xe8b40402,0x00000000}},	//   vhis, айян, zışı, --, 
   {{0x69d4002f,0xe8b4027f,0x63b8011a,0x613403ac}},	//   _orze, yışı, _ipwn, táls, 
   {{0x7d041aa9,0xe8b4009f,0xc0c00020,0x00000000}},	//   this, xışı, ድሕር_, --, 
   {{0x69c005c0,0x6ef80177,0xad380302,0xa3d40388}},	//   _áley, _lìbh, ечує_, हिप_, 
   {{0x7d041356,0x69d41aaa,0x5ba81aab,0x00000000}},	// [15c0] rhis, _arze, ькам_, --, 
   {{0x69d41aac,0x7cf81aad,0xe8b41aae,0x00000000}},	//   _brze, _míri, tışı, --, 
   {{0x7d041aaf,0x7cf81ab0,0x1d081ab1,0xfd240122}},	//   phis, _líri, _жени_, _مودێ, 
   {{0xe8b40a52,0x69d41aa5,0xd83801a7,0x4c800246}},	//   rışı, _drze, мэл_, _клюв, 
   {{0x69d41ab2,0x45240252,0x1cc00560,0xdb040056}},	//   _erze, মতাক_, _གྲར_, _opkø, 
   {{0x47301ab3,0xa3d41ab4,0xbc680191,0x75c801ec}},	//   аніс, हिन_, _تجھے_, етиң_, 
   {{0x69d406f7,0x05801ab5,0x75d41ab6,0x5ee801d2}},	//   _grze, ауым, ايبا, _ءﻭﺭ_, 
   {{0x0efc1ab7,0x88b00122,0xd94400b7,0x00000000}},	//   _उत्स_, _نیمچ, _реби, --, 
   {{0x7cf801f1,0x69d40098,0x660c01c6,0x00000000}},	//   _círi, _zrze, ĝaka, --, 
   {{0x7cf80272,0xe6c40272,0x6e280333,0x42b4020d}},	//   _díri, _متمي, şebi, نچىڭ_, 
   {{0xcb1002c3,0x4a98007c,0x00000000,0x00000000}},	//   שלת_, וייג, --, --, 
   {{0x7cf80272,0x00000000,0x00000000,0x00000000}},	//   _fíri, --, --, --, 
   {{0x7cf81ab8,0x339400e5,0x00000000,0x00000000}},	//   _gíri, _салё, --, --, 
   {{0x04401ab9,0xe5700191,0x439001c4,0xda00006c}},	//   _течн, _خطے_, _ташс, लनात_, 
   {{0x6fe80d8c,0x7f5801c8,0xac940a41,0x00000000}},	//   _bëcë, тарс_, лавш, --, 
   {{0xdde004db,0x00000000,0x00000000,0x00000000}},	//   ñušu, --, --, --, 
   {{0xdb241aba,0x00000000,0x00000000,0x00000000}},	// [15d0] گولی, --, --, --, 
   {{0x69d41abb,0x2fc80080,0xd3580108,0x00000000}},	//   _prze, _isag_, ﯜﺯﯛﭖ_, --, 
   {{0xbf141abc,0x80d800b3,0x20a80a1f,0x00000000}},	//   _түрә, याचे, _कामध, --, 
   {{0x7c581abd,0x1cc0043b,0xa3d40e11,0x69d401f6}},	//   رلەر_, _གིར_, हिम_, _vrze, 
   {{0x6d5c1abe,0x69d406f7,0xfb840007,0x00000000}},	//   _iisa, _wrze, _высн, --, 
   {{0x69d40066,0x6d5c1abf,0x6b8c1ac0,0x00000000}},	//   _trze, _hisa, msag, --, 
   {{0x7cf81ac1,0x6b8c1ac2,0x48a81ac3,0xdb24109d}},	//   _síri, lsag, _отам_, _صوفی, 
   {{0x6d5c1ac4,0x7cf80209,0x61340cb6,0x2fc801d6}},	//   _jisa, _píri, jálp, _osag_, 
   {{0x6d5c1ac5,0x6b8c1ac6,0xc6a4001e,0xed100048}},	//   _misa, nsag, _ареи, _đối_, 
   {{0x6d5c1ac7,0x6b8c0616,0x6aa40008,0xa3d41ac8}},	//   _lisa, isag, nghf, हिब_, 
   {{0x69c41ac9,0x6b8c1aca,0x5ed002fa,0x6d5c00b8}},	//   nwhe, hsag, _সকলে, _oisa, 
   {{0x6d5c1acb,0xd5f8007c,0xdfd003a2,0x7cf800e3}},	//   _nisa, _אפער, ٽيس_, _hírv, 
   {{0xe2981acc,0x2d800296,0x69c4015e,0x952000e2}},	//   _зал_, _awhe_, hwhe, _دکوم, 
   {{0x6b8c1acd,0x61100059,0x21a40abc,0x53980d47}},	//   dsag, nālz, _бикм, _ניצו, 
   {{0x6d5c1ace,0xa6cc007e,0x69c00064,0x6b8c1acf}},	//   _bisa, লাপট, _âleh, esag, 
   {{0x6d5c1ad0,0xa0a41ad1,0x6b8c0270,0x69c4011a}},	//   _cisa, _саид, fsag, dwhe, 
   {{0x6d5c1ad2,0x6b8c1ad3,0x69c4006a,0x09bc0560}},	// [15e0] _disa, gsag, ewhe, _ཀརྴ_, 
   {{0x2bc8044b,0xcb9401d9,0x4aa400bf,0x00000000}},	//   रिजा, انلش_, лкун_, --, 
   {{0x6d5c1ad4,0x6b8c0437,0x2d941ad5,0x69c4018c}},	//   _fisa, asag, _кряс, gwhe, 
   {{0x98481ad6,0x6aa4036d,0xbb740e75,0x386002e8}},	//   няла_, aghf, _نۇرع, øir_, 
   {{0x9b441317,0x69c400a2,0x6b8c16ad,0x88e800ea}},	//   _منحو, awhe, csag, عظمې_, 
   {{0x6d5c1ad7,0x36d41ad8,0xc86c02b4,0x7e7c015e}},	//   _zisa, рокр, _ብዓይኒ_, nbrp, 
   {{0x1cc0080d,0x6d5c1ad9,0x7b0002eb,0x00000000}},	//   _གྲོ_, _yisa, _yöun, --, 
   {{0x1cc01ada,0x6d5c1adb,0x80d41adc,0xd3781add}},	//   _གིས_, _xisa, _बोले, нчо_, 
   {{0x28e013d3,0x96941ade,0xdec00020,0x32e4018f}},	//   फारि, _бреш, ስስን_, аёнғ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd34401a0,0x22280012,0x61340247,0x00000000}},	//   نیچه_, ہٲیی_, tálp, --, 
   {{0x6b8c1adf,0x7cf800d3,0x93a400bf,0x0524044a}},	//   ysag, _kíru, _бшкд, _йохк_, 
   {{0x2d800271,0x1cc0043b,0xcfa40027,0x00000000}},	//   _swhe_, _གྲེ_, ышни, --, 
   {{0x6d5c1ae0,0x6b8c1ae1,0x0fe0002c,0x69c41ae2}},	//   _sisa, vsag, _ғөмү, ywhe, 
   {{0x6b8c0426,0x032000ea,0xd1380320,0x00000000}},	//   wsag, _دفوټ, _пхи_, --, 
   {{0x2fc801f9,0x6d5c1ae3,0x4638007c,0xe7f800aa}},	//   _tsag_, _qisa, געלע, ्नमा_, 
   {{0x6d5c1ae4,0x6e94009e,0x6b8c012f,0xab941ae5}},	// [15f0] _visa, _кипу, usag, شلاغ, 
   {{0x6b8c1ae6,0xa3d40a7b,0x6d5c1ae7,0x80240012}},	//   rsag, हित_, _wisa, _در٘م, 
   {{0x6b8c1ae8,0x6d5c1ae9,0x69c41aea,0xfaa800dd}},	//   ssag, _tisa, uwhe, اهمي_, 
   {{0x6b8c1aeb,0x69c41aec,0xfc640668,0x5d780676}},	//   psag, rwhe, _гърн, _שארק, 
   {{0x7af800df,0x75dc0513,0x764802e6,0x00000000}},	//   ýatç, _lăză, _azdy, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xba74063a,0x6eac1aed,0xf77001b8,0xb50800e7}},	//   _چاہت, _जानु, _ہال_, گۉنۅ_, 
   {{0x291801c5,0xa77412a3,0xe3b8021d,0x00000000}},	//   _ösa_, _влач, вби_, --, 
   {{0xf7701aee,0x7cf802b2,0x232802dc,0x320c02d9}},	//   _فال_, _gíru, коии_, ezdy_, 
   {{0xdec01aef,0x257800b8,0x05841af0,0x7cf800d5}},	//   ስትን_, _абжь_, _будм, _hírt, 
   {{0x75dc0513,0xc0c00020,0xb6e400cc,0x00000000}},	//   _căză, _ድሑር_, _уютк, --, 
   {{0xa3d41af1,0xa2a8052c,0xa0a401d2,0x00000000}},	//   हिद_, ज्ज्, шамд, --, 
   {{0x320c002f,0xa2e401c3,0xe3b000dd,0xbcc400ec}},	//   azdy_, _волд, _ڇرڪ_, ҡҡол, 
   {{0x539800ca,0x00000000,0x00000000,0x00000000}},	//   _יינו, --, --, --, 
   {{0x1cc01af2,0x21a405bc,0x2cb801d6,0xd12c00dd}},	//   _གྲུ_, _тийм, _bbsd_, _ڪمي_, 
   {{0x25ec1af3,0xd24c1af4,0xa074006b,0xa3c803bf}},	//   _अपनी_, _غني_, _тыкш, _ऊना_, 
   {{0xcb64038e,0x2cb80308,0x712400e2,0x113800ca}},	// [1600] иате_, _dbsd_, _درول, _בתקל, 
   {{0x1e9414b2,0x7cf800d3,0x00000000,0x00000000}},	//   _трир, _ríru, --, --, 
   {{0x9f041331,0xda5801c4,0x9d441af5,0x0e9800ca}},	//   _موکو, траш_, _венд, _בשיל, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6eac03ea,0xf7040152,0x00000000,0x00000000}},	//   _जामु, бҗам, --, --, 
   {{0x7cf81af6,0xd5b801d9,0x00000000,0x00000000}},	//   _víru, вси_, --, --, 
   {{0x95c81af7,0x55040241,0x2b5401d9,0x34941af8}},	//   тула_, ичиа, _ایلد_, байр, 
   {{0x764803aa,0x75dc00c2,0x320c01d4,0x00000000}},	//   _vzdy, _răză, vzdy_, --, 
   {{0x7cf801b8,0x764803bf,0x00000000,0x00000000}},	//   _hírs, _wzdy, --, --, 
   {{0x25700340,0x96b80027,0x00000000,0x00000000}},	//   زۇۇس, _шубу_, --, --, 
   {{0x0a440020,0x00000000,0x00000000,0x00000000}},	//   _ንኢሰያ, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72d419cd,0x00000000,0x00000000,0x00000000}},	//   _голф, --, --, --, 
   {{0xe7f8022d,0xb8d8011a,0xff041af9,0xef54001e}},	//   ्नता_, _མཁ_, оясн, скгь, 
   {{0x51841afa,0xad241afb,0x0ca80568,0x00000000}},	//   _тула, مىسى, ктаи_, --, 
   {{0x1cc0011a,0x00000000,0x00000000,0x00000000}},	//   _གྲཱ_, --, --, --, 
   {{0xebd800fc,0xc5f00095,0xc0c0001d,0x00000000}},	// [1610] ыдаш_, _अथ्य_, ስንም_, --, 
   {{0x61b002a5,0xd5c41afc,0x7cf800d5,0x00000000}},	//   _بڕیا, लबाज, _bírs, --, 
   {{0xba740e40,0x63b40513,0xc33000ca,0x00000000}},	//   تاقت, ăzni, קוע_, --, 
   {{0xe57800f8,0x835400a8,0x00000000,0x00000000}},	//   қзи_, _mātṝ, --, --, 
   {{0x1cc00002,0x2d9003ef,0x00000000,0x00000000}},	//   _གྲི_, lsze_, --, --, 
   {{0x2ca800b6,0xa3d41afd,0xeb34071e,0x6378018f}},	//   lgad_, हिस_, _چىڭد, қсир_, 
   {{0x7cf802b2,0x79940152,0x569001f1,0x253801f1}},	//   _gírs, _мирф, чајт, лчиќ_, 
   {{0x2ca81afe,0x6fb8006c,0x7cf800e3,0x00000000}},	//   ngad_, ेबां, _hírr, --, 
   {{0x291c1aff,0x233400f8,0x2ca81b00,0x00000000}},	//   miwa_, йхор, igad_, --, 
   {{0x291c1b01,0xdddc1b02,0x13041b03,0x0a440020}},	//   liwa_, _lepš, йный_, _ንኢሳያ, 
   {{0x2d90002f,0x27fc015e,0x00000000,0x00000000}},	//   jsze_, lywn_, --, --, 
   {{0x291c1b04,0xf1a8049d,0xb9f0010f,0x14c81b05}},	//   niwa_, گایه_, _ዐዐ_, _مهمی_, 
   {{0x2ca80297,0x00000000,0x00000000,0x00000000}},	//   dgad_, --, --, --, 
   {{0x291c1b06,0xf1a8049d,0x5438007c,0xdcb00095}},	//   hiwa_, دایه_, _גענא, ुज्ञ, 
   {{0x291c1b07,0x236c0020,0x2ca80078,0x6b48028d}},	//   kiwa_, lqej_, fgad_, _užgy, 
   {{0x291c1b08,0x2ca81b09,0xf1a8049d,0xdddc00ce}},	//   jiwa_, ggad_, _ئاوه_, _cepš, 
   {{0x291c1b0a,0x817c010f,0x33840020,0x7cf800e3}},	// [1620] diwa_, _የተባሉ_, _ሓደሓደ_, _sírs, 
   {{0xee3800f8,0xbb4001ee,0x2ca802e3,0x60c01b0b}},	//   унӣ_, ﻜﯩﻢ_, agad_, _ñomb, 
   {{0x291c1b0c,0x236c02bb,0x248c012b,0x00000000}},	//   fiwa_, hqej_, kaem_, --, 
   {{0x98a41b0d,0x291c1b0e,0x18a402eb,0xcca000cc}},	//   сиде, giwa_, садм, _ىڭقى, 
   {{0xc7a01b0f,0x1cc0043b,0x07a000e5,0x248c1b10}},	//   зичк, _གྲག_, зачн, daem_, 
   {{0xd3781b11,0xaee40828,0xf1a81b12,0x05d0040e}},	//   қчи_, miṣy, _कमलन, थिंब, 
   {{0xe7080122,0x60c40055,0x00000000,0x00000000}},	//   گتۆن_, kekm, --, --, 
   {{0x291c1b13,0x248c0249,0x94a81b14,0x33741b15}},	//   ciwa_, gaem_, утка_, огир, 
   {{0x2d841b16,0x442c000f,0x0374125b,0x2d900098}},	//   ález_, _cxg_, یحیت_, zsze_, 
   {{0x35c40288,0x442c000d,0xd90c00ea,0x00000000}},	//   _мазҳ, _dxg_, _غیږ_, --, 
   {{0x7bc0019f,0x2ca81b17,0x248c012b,0x00000000}},	//   _ämuf, ygad_, baem_, --, 
   {{0xa3d403ef,0x442c0426,0xd4681b18,0x00000000}},	//   हिश_, _fxg_, _сиде_, --, 
   {{0x2d900066,0xe4e4044b,0x6eac0388,0xdddc1b19}},	//   wsze_, कारि_, _जादु, _repš, 
   {{0x291c0123,0x0dc81b1a,0xa3d407aa,0x00000000}},	//   ziwa_, луби_, हिर_, --, 
   {{0x1cc00037,0x2d841b1b,0x80d400aa,0xd1cc010f}},	//   _གྲང_, èle_, _बोके, ቤቶች_, 
   {{0x2d901b1c,0x291c1b1d,0x50641b1e,0x60c4024f}},	//   rsze_, xiwa_, _утка, cekm, 
   {{0x291c1b1f,0x2ca81b20,0x2d9001b8,0x00000000}},	// [1630] viwa_, rgad_, ssze_, --, 
   {{0x291c1b21,0x2d9006f7,0xbb841b22,0x2d84014a}},	//   wiwa_, psze_, سلمي, âles_, 
   {{0x291c1b23,0x9bb8043b,0xdf540046,0xba741b24}},	//   tiwa_, _པདྨོ, _بريښ, سالت, 
   {{0x27fc0249,0x877001a0,0x00000000,0x00000000}},	//   tywn_, зғаш, --, --, 
   {{0x291c1b25,0x69d80098,0x00000000,0x00000000}},	//   riwa_, _नज़री, --, --, 
   {{0x291c1b26,0xbb400121,0xc6a41b27,0x7cf800d5}},	//   siwa_, ﻜﯩﻦ_, срди, _hírp, 
   {{0x291c1b28,0x24e80ba3,0x248c0b8e,0x7d080028}},	//   piwa_, имки_, taem_, êdsg, 
   {{0xf3f40252,0xa3d40813,0x291c1b29,0xa8340106}},	//   েছনৰ_, हिल_, qiwa_, _дебљ, 
   {{0x248c01f1,0xe3b00075,0x00000000,0x00000000}},	//   raem_, ذرة_, --, --, 
   {{0xe29807ac,0x248c059b,0x60c40249,0x6d0400aa}},	//   јан_, saem_, wekm, रसँग_, 
   {{0x60c40025,0xfcbc010f,0xc10400bf,0x1ea800ea}},	//   tekm, _ታዳጊ_, зүйл, یاسي_, 
   {{0xaee4076f,0x00000000,0x00000000,0x00000000}},	//   yiṣy, --, --, --, 
   {{0x60c41b2a,0x00000000,0x00000000,0x00000000}},	//   rekm, --, --, --, 
   {{0xaee4076f,0x1cc008be,0x60c40f8e,0xbdb40041}},	//   viṣy, _གིང_, sekm, _ﻴﻘﻭل_, 
   {{0x62801b2b,0xdd901b2c,0x63b400c2,0x00000000}},	//   mblo, بوز_, ăznu, --, 
   {{0x62801b2d,0xd47c010f,0x00000000,0x00000000}},	//   lblo, _የቀድሞ_, --, --, 
   {{0x5f741b2e,0x8c401b2f,0x00000000,0x00000000}},	// [1640] _بابر, дете, --, --, 
   {{0xaee40828,0x0ae41166,0x00000000,0x00000000}},	//   riṣy, одуй_, --, --, 
   {{0xd12c1b30,0x76440181,0x49b00087,0x628003f4}},	//   _سمی_, ƙiyi, мәту, iblo, 
   {{0x7d080028,0xd7f8009e,0x00000000,0x00000000}},	//   êdsd, иул_, --, --, 
   {{0x7d041b31,0xacb01b32,0x62801b33,0x80bc0828}},	//   mkis, _سەلب, kblo, ष्ये, 
   {{0x7d041b34,0x62801b35,0x96b81b36,0x00000000}},	//   lkis, jblo, руду_, --, 
   {{0x20a80227,0x7d041b37,0xf1a80030,0x00000000}},	//   _कांध, okis, _कमइन, --, 
   {{0x7d041b38,0x62801b39,0xa3d41b3a,0x00000000}},	//   nkis, eblo, हिं_, --, 
   {{0x62801b3b,0x00000000,0x00000000,0x00000000}},	//   fblo, --, --, --, 
   {{0x7d0407ca,0x273000cc,0x8c1800ca,0x00000000}},	//   hkis, _كۉنس, יופי, --, 
   {{0x7d041b3c,0x45300087,0x157001d9,0x914801d9}},	//   kkis, яхәт, _ўқиё, ичма_, 
   {{0x386001c3,0x62800139,0x00000000,0x00000000}},	//   žiru_, ablo, --, --, 
   {{0xf6c80002,0x62801b3d,0x10481b3e,0x7d040080}},	//   _གྲོང, bblo, ряни_, dkis, 
   {{0x69c00573,0x8d741b3f,0x62800128,0x7d041b40}},	//   _äleg, قارا, cblo, ekis, 
   {{0xc278007c,0x9f40021c,0x3eb002cc,0x53d01b41}},	//   _דרוי, yykö_, _žltá_, तिकश, 
   {{0xab7400f8,0x7d041b42,0x752008c2,0x4598007c}},	//   згаш, gkis, nimz, יסלע, 
   {{0x0a68078e,0x00000000,0x00000000,0x00000000}},	// [1650] ареи_, --, --, --, 
   {{0x7d041b43,0xfbd0195d,0x61340191,0x80bc052c}},	//   akis, کتہ_, dály, ष्ठे, 
   {{0x7d041b44,0x0dc80108,0xe73801c4,0x75201b45}},	//   bkis, _тупи_, ҙек_, kimz, 
   {{0x62801b46,0x4a7401c4,0x39a4021d,0x3cf401d4}},	//   zblo, сыҡт, ьшув, ľavá_, 
   {{0x66e41b47,0x09bc011a,0xa7a8018f,0x00000000}},	//   зола, ཀས྄_, ёкка_, --, 
   {{0x62800184,0xff7c007c,0xeb081b24,0x7ac41b48}},	//   xblo, סטומ, _اقسى_, _оссе, 
   {{0x80ac0584,0xe3c8001e,0xe5a40121,0x27e81b49}},	//   _झाले, kuñá_, чийи, ţan_, 
   {{0x6134063a,0x62800043,0x24e80155,0x00000000}},	//   bály, wblo, смии_, --, 
   {{0x13e40152,0x00000000,0x00000000,0x00000000}},	//   змый_, --, --, --, 
   {{0x46600108,0x00000000,0x00000000,0x00000000}},	//   _قۇشق, --, --, --, 
   {{0x7d041b4a,0xa0681b4b,0x59dc03ef,0x61441b4c}},	//   ykis, йана_, _नज़ार, зена, 
   {{0x62801b4d,0x55b800ca,0x00000000,0x00000000}},	//   sblo, _למעו, --, --, 
   {{0x62801b4e,0x25701b4f,0x442410ab,0x7d040386}},	//   pblo, _hál_, _براف, vkis, 
   {{0x63a81b50,0x7d040b68,0x25701b51,0x00000000}},	//   muen, wkis, _kál_, --, 
   {{0x7d041b52,0x33180324,0xdc980320,0x00000000}},	//   tkis, _بزند_, йташ_, --, 
   {{0x25701b53,0x63a8038b,0x7d041b54,0x20c81b55}},	//   _mál_, ouen, ukis, _طبعي_, 
   {{0x21200197,0x7d041b56,0x63a81b57,0x80bc03ec}},	// [1660] mikh_, rkis, nuen, ष्णे, 
   {{0x7d041b58,0x7520042e,0x7d080028,0x2120028b}},	//   skis, zimz, êdsb, likh_, 
   {{0x60d41b59,0x9d441b5a,0x7d3c010f,0x2c7401e5}},	//   _kaym, _неод, _በፖለቲ, _ụde_, 
   {{0x63a81b5b,0x60d400b7,0x61340191,0x57e81b5c}},	//   kuen, _jaym, tály, йдем_, 
   {{0x60d4078e,0x87e01198,0x63a80094,0x9f40001e}},	//   _maym, еюще, juen, sykõ_, 
   {{0x63a81b5d,0x60d40154,0x61340191,0x25701b5e}},	//   duen, _laym, rály, _bál_, 
   {{0x38c803b5,0x2570000f,0x75200b1e,0x63a8034c}},	//   _واری_, _cál_, timz, euen, 
   {{0x257000aa,0xd3a40302,0x60d41b5f,0x61340191}},	//   _dál_, проп, _naym, pály, 
   {{0x63a81b60,0x07a01b61,0x1cc00126,0xc7a01b62}},	//   guen, _патн, _གྲབ_, _питк, 
   {{0x8778129b,0x2570059b,0xd62804fd,0x00000000}},	//   _לאמי, _fál_, _лозе_, --, 
   {{0x60d41b63,0x63a8006f,0xe6b401d9,0x54341b64}},	//   _baym, auen, _آلمگ, _کرار, 
   {{0x26d80125,0x00000000,0x00000000,0x00000000}},	//   _ɔsom_, --, --, --, 
   {{0x63a81b65,0x60d41b66,0x35a4006b,0x5ed40143}},	//   cuen, _daym, _хаҗг, দানে, 
   {{0x4170005e,0x73341b67,0x00000000,0x00000000}},	//   بایس, _تىتا, --, --, 
   {{0xb118004b,0x69d800a2,0x60d4002a,0x00000000}},	//   _وقتا_, āwek, _faym, --, 
   {{0x60d41b68,0x80b400bf,0x00000000,0x00000000}},	//   _gaym, _كەپش, --, --, 
   {{0xa3d40066,0x3c58038e,0x64540028,0x200003bf}},	// [1670] हिए_, зитэ_, ęzig, cyki_, 
   {{0xdb1401e8,0x60d4012b,0x88e40049,0x00000000}},	//   ntyè, _zaym, _ﺍﻗﺘﻀ, --, 
   {{0x60d41b69,0x63a81b6a,0x00000000,0x00000000}},	//   _yaym, zuen, --, --, 
   {{0x60d4175c,0x12800222,0x00000000,0x00000000}},	//   _xaym, ረትኣብ_, --, --, 
   {{0x25701b6b,0x6134000f,0x63a80094,0xdb1401b1}},	//   _sál_, rálx, xuen, ktyè, 
   {{0x63a801ea,0xb9041b6c,0x25701b6d,0xe64400b7}},	//   vuen, _भो_, _pál_, мелп, 
   {{0x200006f7,0x2120041c,0xd6cc0d1e,0xf664006b}},	//   zyki_, yikh_, شقي_, нешү, 
   {{0x63a81b6e,0x200001e7,0x2408001e,0xa9081b6f}},	//   tuen, yyki_, жнии_, _بيرل_, 
   {{0x60d41b70,0x290c1b71,0xfbe01b72,0xe7b400e2}},	//   _raym, _ilea_, नियम, _زماد, 
   {{0x63a81b73,0x68e81b74,0x257000e3,0x00000000}},	//   ruen, _hned, _tál_, --, 
   {{0x63a81b75,0x68e81b76,0x2120034c,0x290c1b77}},	//   suen, _kned, tikh_, _klea_, 
   {{0x200006f7,0x60d41b78,0x245401d9,0x2120028b}},	//   tyki_, _qaym, _قناس, uikh_, 
   {{0xe2981b79,0x63a81b7a,0x21201b7b,0x68e81b7c}},	//   _дал_, quen, rikh_, _mned, 
   {{0x60d41b7d,0x200003ef,0x00000000,0x00000000}},	//   _waym, ryki_, --, --, 
   {{0xa3d410f6,0x60d41b7e,0x68e81b7f,0x290c1b80}},	//   हिक_, _taym, _oned, _olea_, 
   {{0x59080560,0x68e81b81,0x60d402b0,0x00000000}},	//   _གཞེས_, _nned, _uaym, --, 
   {{0xe3b80191,0x2ba40c2b,0x00000000,0x00000000}},	// [1680] ntű_, गंगा, --, --, 
   {{0x290c1b82,0x68e81b83,0x272000bd,0x00000000}},	//   _alea_, _aned, nčně_, --, 
   {{0x68e8043b,0x290c0496,0x00000000,0x00000000}},	//   _bned, _blea_, --, --, 
   {{0x09b4007e,0x290c1b84,0x58b80075,0x00000000}},	//   ীয়ভা, _clea_, تائج_, --, 
   {{0x2720012c,0x00000000,0x00000000,0x00000000}},	//   kčně_, --, --, --, 
   {{0x290c0de9,0x68e81b85,0x6b880054,0x00000000}},	//   _elea_, _ened, _çega, --, 
   {{0x7afc0444,0x63ac0237,0x290c0426,0xcb6403f7}},	//   _iort, _ĥana, _flea_, _царе_, 
   {{0x7afc1b86,0x68e8006f,0x14ac00b3,0x97c41b87}},	//   _hort, _gned, _टाळण, _ойбе, 
   {{0x1cc00002,0x96b81b88,0xf4841b89,0xdec019ef}},	//   _གིན_, _мужу_, واکی, ድስን_, 
   {{0x69c00638,0x7afc175c,0x3944013c,0x00000000}},	//   _älec, _jort, _hkms_, --, 
   {{0x7afc1b8a,0x776802b0,0x673c06b4,0x00000000}},	//   _mort, _iidx, _ísja, --, 
   {{0x7afc0396,0x249c042e,0x00000000,0x00000000}},	//   _lort, _gdwm_, --, --, 
   {{0x7afc0141,0x764800fc,0x00000000,0x00000000}},	//   _oort, _hydy, --, --, 
   {{0x7afc1b8b,0x15f01b8c,0x00000000,0x00000000}},	//   _nort, _अपार_, --, --, 
   {{0x645403ef,0xccf80294,0x7768006b,0x00000000}},	//   ęzie, оћа_, _midx, --, 
   {{0x7afc1b8d,0x3cf0076f,0x50641b8e,0x61e406b4}},	//   _aort, ṣṭvā_, _отпа, _áhla, 
   {{0x7afc1b8f,0x7648028d,0x00000000,0x00000000}},	// [1690] _bort, _lydy, --, --, 
   {{0x5908043b,0x290c006f,0x76480101,0xcf2401ac}},	//   _གཞུས_, _slea_, _oydy, _زرخي, 
   {{0x7afc1b90,0x1cc0043b,0x290c0dc9,0x80bc0095}},	//   _dort, _གྲམ_, _plea_, ष्वे, 
   {{0xe94401a0,0xfe240116,0xa7b401f1,0x00000000}},	//   ررای, _шьын, ескј, --, 
   {{0x293c0041,0x31b80191,0x764800fc,0x3944028b}},	//   ﻟﯩﭗ_, héz_, _aydy, _dkms_, 
   {{0x7afc1b91,0x9de401b5,0x316800ef,0x76481b92}},	//   _gort, _تہہٕ_, _liaz_, _bydy, 
   {{0x76480336,0xe2980329,0x68e80560,0x6e200306}},	//   _cydy, ҟан_, _tned, úlbh, 
   {{0x67d41b93,0x68e81b94,0x7afc1b95,0x76480323}},	//   _побу, _uned, _zort, _dydy, 
   {{0x7afc0573,0x776803b2,0x69d400f2,0x54c00197}},	//   _yort, _fidx, _hsze, убыб, 
   {{0x7afc1b96,0x69d4011a,0x18281b97,0x0574115c}},	//   _xort, _ksze, _عقلی_, _قاصد, 
   {{0x76481b98,0xe1241b99,0xe7f802ef,0xf4f801b8}},	//   _gydy, емни, ्नका_, سویں_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x31681b9a,0xb0b0025c,0x00000000,0x00000000}},	//   _diaz_, _झारग, --, --, 
   {{0xdea00115,0x00000000,0x00000000,0x00000000}},	//   دیدی, --, --, --, 
   {{0x2c7405b6,0x23b8029f,0x31b801d4,0x00000000}},	//   _ụda_, lèj_, céz_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1ae41b9b,0x67200207,0xa3d4102c,0x23b801e8}},	// [16a0] ноам, _omlj, हिट_, nèj_, 
   {{0x7afc1b9c,0x9b441b9d,0xcca001d2,0xda5800b7}},	//   _qort, رناو, _ەڭلى, преш_, 
   {{0x7afc1b9e,0x39441b9f,0x291c0078,0x59841194}},	//   _vort, _pkms_, ďwan_, хлеб, 
   {{0x76480ca0,0x7afc0dc9,0x3f800039,0x00000000}},	//   _rydy, _wort, _ktiu_, --, 
   {{0x69d41ba0,0x7afc0f63,0x76480323,0x00000000}},	//   _esze, _tort, _sydy, --, 
   {{0x8f98023c,0x69d400f2,0xcf9000ca,0x00000000}},	//   ליני, _fsze, נטו_, --, 
   {{0xceb00282,0xd5641ba1,0x09e000fb,0x00000000}},	//   טיג_, нтип, _йорн, --, 
   {{0x59081ba2,0x69c00638,0x38c80046,0x799c0379}},	//   _གཞིས_, _älea, _تاسی_, _ivrw, 
   {{0x44f01617,0x764803bf,0x69d403bf,0x00000000}},	//   اسىز, _wydy, _zsze, --, 
   {{0x0bb40107,0x78a00932,0x71781ba3,0x76480086}},	//   עלים_, _hdmv, мбор_, _tydy, 
   {{0x316807d4,0x3f801ba4,0x95c81ba5,0x00000000}},	//   _piaz_, _atiu_, _хлеб_, --, 
   {{0x80bc00bd,0x76440386,0x00000000,0x00000000}},	//   ष्ले, ğiyd, --, --, 
   {{0x64540010,0x5064009e,0x316800c0,0x76440386}},	//   ęzic, этоа, _viaz_, şiyd, 
   {{0xad24039b,0x00000000,0x00000000,0x00000000}},	//   چىسى, --, --, --, 
   {{0xad241ba6,0xac941ba7,0x31680207,0x0ca8001e}},	//   نىسى, кавш, _tiaz_, зтзи_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8aa41ba8,0x799c02b0,0xcee800dd,0xc0c0001d}},	// [16b0] еред, _avrw, _فردن_, ድንም_, 
   {{0x2fc81135,0xef100128,0xfd6c0200,0x4f280cb2}},	//   _ipag_, _түгө, _ﻳﯟﺍﻥ_, ደጊዮር, 
   {{0x7dc41ba9,0x39781baa,0x00000000,0x00000000}},	//   _یقین, есію_, --, --, 
   {{0x2d801bab,0x2fc805b8,0xd2440122,0x6b88012b}},	//   _ithe_, _kpag_, _ۆن_, _çego, 
   {{0xd2441bac,0x69d406f7,0x6d4c1bad,0x63ac01c6}},	//   _چن_, _wsze, mlaa, _ĥano, 
   {{0xd2441596,0x6d4c1bae,0x2d800475,0xe5a4118d}},	//   _نن_, llaa, _kthe_, вики, 
   {{0x6d4c1420,0xe6580020,0x69d403bf,0xbb581baf}},	//   olaa, _ቅንጸላ, _usze, _чарх_, 
   {{0x6d4c1bb0,0x23b801b1,0x00000000,0x00000000}},	//   nlaa, tèj_, --, --, 
   {{0x6d4c1bb1,0xe6940329,0x46681bb2,0xe3e802cb}},	//   ilaa, _аизы, _ерем_, بکان_, 
   {{0x2d801bb3,0x6d4c1bb4,0x21740427,0x9f4c0055}},	//   _othe_, hlaa, кумр, ünüm_, 
   {{0x6d4c0310,0x3f80009e,0x2d8001ba,0x2d6c006e}},	//   klaa, _stiu_, _nthe_, _ﻳﺎﻛﻰ_, 
   {{0x3f8000c2,0x341000cb,0x6d4c018c,0x23b80078}},	//   _ptiu_, ūyaḥ_, jlaa, pèj_, 
   {{0x6d4c1a9d,0x02c01bb5,0x4ab000cb,0xe1f00324}},	//   dlaa, _билү, ुभाव, _چسب_, 
   {{0x63a81bb6,0x6d4c1bb7,0x53a01bb8,0x00000000}},	//   mren, elaa, _ташб, --, 
   {{0x2d800762,0x6d4c1bb9,0x613801a7,0x9d4400d5}},	//   _cthe_, flaa, _очир_, نئرن, 
   {{0x6d4c1bba,0x63a80074,0x23c40192,0x00000000}},	//   glaa, oren, _वहाद, --, 
   {{0x2d8008a6,0xefc802b4,0x765c03aa,0x8d60024b}},	// [16c0] _ethe_, ሽቶይ_, _úryv, рвте, 
   {{0xc04801e2,0x6d4c1bbb,0x63a81bbc,0xed5802dc}},	//   _ማስታወ, alaa, iren, доӣ_, 
   {{0x63a81bbd,0x6d4c1bbe,0xdca400b8,0x00000000}},	//   hren, blaa, _иани, --, 
   {{0x63a80518,0x26c405d9,0x6d4c1a9d,0x98480074}},	//   kren, _ablo_, claa, мяла_, 
   {{0x63a81bbf,0x5c5403a7,0xcba000fb,0x00000000}},	//   jren, _штоф, _каяй, --, 
   {{0xdce4028d,0x799c02b0,0x5018023c,0x14d8006c}},	//   _mikč, _tvrw, וונו, _मोजण, 
   {{0x2a34009e,0x28dc1bc0,0x00000000,0x00000000}},	//   _бэтр, _नोकि, --, --, 
   {{0x26c400cf,0x46e401c8,0x73d800df,0xd3781bc1}},	//   _eblo_, едән_, едир_, мчо_, 
   {{0x63a81bc2,0xda640a1d,0xdce40091,0x59d8072d}},	//   gren, _ساڳي, _nikč, णिकर, 
   {{0x14ac00b3,0x00000000,0x00000000,0x00000000}},	//   _टाकण, --, --, --, 
   {{0x63a81bc3,0x6d4c1bc4,0xdce400b0,0x2fc80126}},	//   aren, ylaa, _aikč, _spag_, 
   {{0x94240994,0x14241bc5,0x6d4c0d8c,0x2d800095}},	//   _имее, _идем, xlaa, _rthe_, 
   {{0x63a81bc6,0x73c4002c,0x6d4c0952,0x5fa011e5}},	//   cren, _сәйе, vlaa, مەيم, 
   {{0xb9040560,0xdce400b0,0x6d4c0080,0xebc40108}},	//   _ཨལ_, _dikč, wlaa, қәмн, 
   {{0x6d4c1bc7,0x7e281bc8,0x6a7800d3,0xd1381bc9}},	//   tlaa, віта_, _lúfó, _охи_, 
   {{0x0fe00128,0x6d4c1bca,0x00000000,0x00000000}},	//   _көгү, ulaa, --, --, 
   {{0x6d4c1bcb,0x25701bcc,0x4ea41bcd,0xfbd00272}},	// [16d0] rlaa, _išle_, _ирна, يتك_, 
   {{0x6d4c1bce,0xadd80329,0x6b9c0056,0x7b140023}},	//   slaa, _змоу_, _vvsg, адух, 
   {{0x6d4c1bcf,0x63a81bd0,0x2d800a3a,0x7b640041}},	//   plaa, zren, _uthe_, ртте, 
   {{0xa8140128,0x6d4c0012,0x6a780579,0x78b801d4}},	//   лдеш, qlaa, _búfó, _ľavá, 
   {{0x499000cd,0xa6c8070b,0xb30c0126,0x61e002b0}},	//   _چیئر, елла_, གྲོང_, zvll, 
   {{0x63a81bd1,0xc6a41bd2,0x9ba00128,0x00000000}},	//   vren, трди, _دەكى, --, 
   {{0x855401b8,0x257002db,0x63a81bd3,0x00000000}},	//   نیئر_, _ošle_, wren, --, 
   {{0x61e0015e,0x00000000,0x00000000,0x00000000}},	//   vvll, --, --, --, 
   {{0xe2981bd4,0x63a81bd5,0xa9a40108,0x98f000ea}},	//   нап_, uren, _шиңд, _دګلا, 
   {{0xe1f81bd6,0x63a81bd7,0xe2840329,0x00000000}},	//   его_, rren, ылои, --, 
   {{0x63a81bd8,0x9af80107,0xdee402dc,0x00000000}},	//   sren, תפתח, қови, --, 
   {{0x6454038c,0x63a81bd9,0xd1b81bda,0x00000000}},	//   əzin, pren, راپا_, --, 
   {{0xdca41bdb,0x84640668,0x00000000,0x00000000}},	//   ғази, _ръже, --, --, 
   {{0xd1b8010f,0xb3700012,0xdee401c3,0x00000000}},	//   ታለች_, _گۯیش, ћови, --, 
   {{0xd7d80098,0x2744012c,0x00000000,0x00000000}},	//   _मैनच, míně_, --, --, 
   {{0x7e7c02db,0xd24c0272,0x1e840108,0x27440192}},	//   scrp, _عني_, _өлим, líně_, 
   {{0xdc280046,0xbb500108,0x00000000,0x00000000}},	// [16e0] رسره_, ﻏﯘﻝ_, --, --, 
   {{0x2744012c,0x00000000,0x00000000,0x00000000}},	//   níně_, --, --, --, 
   {{0x69c0013b,0x2cb8015e,0x5d6801f1,0x59080094}},	//   _älel, _fcsd_, _пиом_, нежм_, 
   {{0x2cb81737,0x00000000,0x00000000,0x00000000}},	//   _gcsd_, --, --, --, 
   {{0x6ac80301,0xccf000ca,0x00000000,0x00000000}},	//   রয়ো, _הכר_, --, --, 
   {{0x3ce01bdc,0x69d80296,0xda641bdd,0x2d8400cc}},	//   ldiv_, āwer, _مازي, íleg_, 
   {{0x645c1bde,0xceb00240,0x644802a0,0x6b580223}},	//   ýsin, ציה_, _əmiş, bìgb, 
   {{0xd9441bdf,0x3ce00fab,0x00000000,0x00000000}},	//   _себи, ndiv_, --, --, 
   {{0x28dc136a,0x33741be0,0x249802e8,0x274401d5}},	//   _नोटि, јгор, ðsma_, fíně_, 
   {{0x51840476,0x89d41be1,0x7d080010,0x274401d5}},	//   лума, _جوہر_, êdsj, gíně_, 
   {{0x1ac40095,0x00000000,0x00000000,0x00000000}},	//   र्यथ, --, --, --, 
   {{0x66040139,0x00000000,0x00000000,0x00000000}},	//   ähke, --, --, --, 
   {{0x3ce00308,0xf2c400ec,0xb4e01be2,0x00000000}},	//   ddiv_, _көни, दयी_, --, 
   {{0x4ea41be3,0x52741be4,0x2744012c,0xefd00020}},	//   ырма, _суду, cíně_, _ብኣይ_, 
   {{0xc27819fc,0x3ce0015e,0x62241be5,0x00000000}},	//   _ארוי, fdiv_, _پويە, --, 
   {{0x25700ada,0x3ce00308,0x00000000,0x00000000}},	//   _ušle_, gdiv_, --, --, 
   {{0xc0c802eb,0x00000000,0x00000000,0x00000000}},	// [16f0] _суще_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c580121,0x00000000,0x00000000,0x00000000}},	//   پلەر_, --, --, --, 
   {{0x69c000df,0x6ce40340,0x2cb80426,0x4a740197}},	//   _älem, _ئزدە, _ucsd_, тыҡт, 
   {{0x6d5c1be6,0x18540572,0xa92400c0,0x478803d6}},	//   _ihsa, ۇرۇڭ, _nižň, хсем_, 
   {{0x16a408eb,0x6604174f,0xf7701be7,0x00000000}},	//   авши_, ипла, ساه_, --, 
   {{0x3694024b,0x00000000,0x00000000,0x00000000}},	//   сшіс, --, --, --, 
   {{0x77901be8,0x6d5c006f,0x24e80123,0x00000000}},	//   _کیوا, _jhsa, тмии_, --, 
   {{0x7dcc013b,0x739801a7,0x23340a27,0xe4580074}},	//   _kösö, лтэс_, ихор, ъжи_, 
   {{0xa1c40822,0xae0403ea,0x13041be9,0xf3c81bea}},	//   абод, रहान_, иный_, ابيه_, 
   {{0xdce400d4,0xe3b000dd,0x00000000,0x00000000}},	//   _likā, _ڀرت_, --, --, 
   {{0x61441beb,0xd24c00e2,0x7dcc0207,0x3ce00308}},	//   рема, ړنۍ_, _lösö, xdiv_, 
   {{0xfe780468,0x248c1bec,0x31d00828,0x3484002c}},	//   лүп_, mbem_, āraṃ_, _уҡып_, 
   {{0x6458017b,0x6d5c1bed,0xf1a80122,0x3ce0015e}},	//   _izwi, _ahsa, خایه_, wdiv_, 
   {{0x3ce00308,0xdce41bee,0x00000000,0x00000000}},	//   tdiv_, _aikā, --, --, 
   {{0xdcb0041b,0x6d5c1bef,0x248c03af,0x25dc00a1}},	//   تىر_, _chsa, nbem_, _कईनी_, 
   {{0x3ce01bf0,0x1b4800f8,0xdc6801a7,0xeb541bf1}},	// [1700] rdiv_, взаи_, таад_, ڭىلگ, 
   {{0x6d5c1bf2,0x33c00121,0x3ce01bf3,0xdce41bf4}},	//   _ehsa, _ﻣﻪﺯﻣ, sdiv_, _dikā, 
   {{0xa2bc186f,0x2f38010f,0x3ce0015e,0x5fdc0d5b}},	//   _शान्, _የህፃና, pdiv_, मिकल, 
   {{0x497002b3,0x1d081bf5,0x8cb4024b,0x00000000}},	//   іліс, _реми_, _ەگەس_, --, 
   {{0x64581bf6,0xbd4403a2,0x87d400e7,0x18340075}},	//   _nzwi, _ننڍي, لبوس_, جراح, 
   {{0x3eb801d1,0x00000000,0x00000000,0x00000000}},	//   ngrt_, --, --, --, 
   {{0x64581bf7,0xe9380121,0xc6d001d9,0x6d5c0101}},	//   _azwi, خسەت_, زتوت, _yhsa, 
   {{0xb4e000cb,0x3e7c00d3,0xf49800c3,0xf4d800b7}},	//   दये_, _yàtó_, اھات_, умиш_, 
   {{0x74140252,0x00000000,0x00000000,0x00000000}},	//   াপ্ট_, --, --, --, 
   {{0x645803ef,0x59b8081a,0x6fac03bf,0x00000000}},	//   _dzwi, _उमार, _जिबू, --, 
   {{0x6458041c,0x248c0110,0x25a81af4,0xd2581166}},	//   _ezwi, bbem_, _مدني_, ъци_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x53f81bf8,0x25701bf9,0x9fa4002c,0x348400ec}},	//   _جراح_, _išla_, йырҙ, _кѳҙг, 
   {{0xad241bfa,0x6d5c018f,0xdce4004f,0x00000000}},	//   ڭىرى, _shsa, _rikā, --, 
   {{0x2d841bfb,0xdce40243,0x4d240385,0x70941166}},	//   ële_, _sikā, аќаа, _лайф, 
   {{0xff140664,0x3e7c0537,0xdce4004f,0x463800cf}},	//   _সদৃশ_, _pàtó_, _pikā, דעלע, 
   {{0x320c00df,0x6458015e,0x7dcc0027,0xa2bc0095}},	// [1710] lydy_, _xzwi, _pösö, _शाम्, 
   {{0xdce400cb,0x332c015e,0x91d81bfc,0x69c0012b}},	//   _vikā, nidx_, _बनाई, _älek, 
   {{0x6d5c04ca,0x257002db,0x0a68041c,0x3eb401d4}},	//   _thsa, _ošla_, траи_, ňatí_, 
   {{0x6f040140,0xdb140191,0xb4e000cb,0x332c0560}},	//   _hohc, rtyá, दयो_, hidx_, 
   {{0x27e81bfd,0x2ee00064,0x80bc12e9,0x320c0031}},	//   ían_, _kahf_, ष्टे, hydy_, 
   {{0x355800d5,0x320c0031,0x00000000,0x00000000}},	//   یسٹھ_, kydy_, --, --, 
   {{0x27e80100,0x6f040380,0xa2bc1bfe,0x2fd80086}},	//   ŭan_, _mohc, _शाब्, hwsg_, 
   {{0x25a81bff,0xe3b802d1,0x398c00d3,0x8d280020}},	//   čal_, гби_, _wòsò_, _ተወሃሂ, 
   {{0x64a41c00,0x6f04006f,0xb6e00027,0x00000000}},	//   _ғала, _oohc, öään, --, 
   {{0xf770045d,0x6f040140,0x65940182,0x00000000}},	//   _قال_, _nohc, _гажу, --, 
   {{0xa2e404e7,0xa2281c01,0xea6007c1,0x320c0101}},	//   _ҳолд, ужна_, огiя_, gydy_, 
   {{0x201c01c6,0xf49400cc,0x00000000,0x00000000}},	//   ŝtim_, _ۇشۇد, --, --, 
   {{0xa2e41c02,0x638406d4,0x6f040428,0x64581c03}},	//   _голд, _угла, _bohc, _uzwi, 
   {{0xe2981c04,0x8e801c05,0x320c0101,0x00000000}},	//   _сак_, згре, bydy_, --, 
   {{0x6f040444,0x2c8401e5,0x320c0201,0x00000000}},	//   _dohc, _ụmị_, cydy_, --, 
   {{0x2d6c046d,0xdee400f8,0x8d500020,0x00000000}},	//   _ﺳﺎﻧﻰ_, шоҳи, _መብርሂ, --, 
   {{0x5ac81c06,0x6e2c0090,0x6ae002fa,0xe3c00386}},	// [1720] ллам_, ደሚገባ, নানো, _çığ_, 
   {{0xda640272,0x3ce800b6,0x9f0400d5,0x00000000}},	//   ماضي, _चोरे_, _چوکو, --, 
   {{0x58841c07,0xda58044a,0x80dc00bd,0x00000000}},	//   была, ураш_, _बसाइ, --, 
   {{0xd8380396,0xd5b80155,0xe7b40108,0x00000000}},	//   лэл_, ҳси_, ﭼﯘﺭﻟ, --, 
   {{0xdc2c0090,0xd498006e,0x37f80254,0x6280015e}},	//   _በመሆኑ, ңри_, релэ_, kclo, 
   {{0x99741c08,0x473001f5,0xe7d401d9,0x8f780676}},	//   _гуаш, пніс, تمهگ, אנסק, 
   {{0x6d4000ed,0x6280006a,0x2c7401e5,0x7d080028}},	//   élag, dclo, _ụdi_, êdsw, 
   {{0x18681c09,0x76440333,0xe9701c0a,0x7bc40034}},	//   _баби_, şiyo, _قۇلد, otiu, 
   {{0x7bc41c0b,0x68fc01d6,0x00000000,0x00000000}},	//   ntiu, _òsda, --, --, 
   {{0x62801c0c,0x8a100012,0x7bc40034,0x00000000}},	//   gclo, _بِہت, itiu, --, 
   {{0x14c81c0d,0xcfa40121,0x8af81714,0x7bc40139}},	//   _были_, әшми, אליז, htiu, 
   {{0x7bc40322,0x320c1c0e,0x6f040380,0xdb140027}},	//   ktiu, rydy_, _sohc, ltyä, 
   {{0x2570091d,0x6f040428,0x62800426,0x41c00012}},	//   _ušla_, _pohc, bclo, _ہٲوِ, 
   {{0x7bc40034,0x6280006f,0xdb140027,0x256006b4}},	//   dtiu, cclo, ntyä, gólf_, 
   {{0x91841c0f,0x51841c10,0x7bc40034,0xd1f00020}},	//   _اجتم, _уула, etiu, ግሰቲ_, 
   {{0xdb1402eb,0x7bc402bb,0x00000000,0x00000000}},	//   htyä, ftiu, --, --, 
   {{0x101400e2,0x00000000,0x00000000,0x00000000}},	// [1730] _دبغد, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x764401e7,0x7bc41c11,0x104c010f,0xc278007c}},	//   ƙiyy, atiu, _ማስቀመ, ארבי, 
   {{0x2040010f,0xfbd00191,0x76440333,0x7bc4077d}},	//   _የሕብረ, بتہ_, ğiyl, btiu, 
   {{0x7bc41c12,0xdcfc00cb,0x764407e4,0xc7c41186}},	//   ctiu, _utpā, şiyl, ссеи, 
   {{0xe7381c13,0xdb14012b,0x00000000,0x00000000}},	//   јек_, gtyä, --, --, 
   {{0x6b8c0351,0xe6180123,0x00000000,0x00000000}},	//   lpag, рдй_, --, --, 
   {{0x69c41c14,0x63840116,0xe3a802dc,0x62800428}},	//   mthe, огиа, акид_, wclo, 
   {{0x6b8c1c15,0x00000000,0x00000000,0x00000000}},	//   npag, --, --, --, 
   {{0x6b8c1c16,0x27ec1c17,0xe29806d4,0x25dc0227}},	//   ipag, _iren_, шао_, _कैथी_, 
   {{0x27ec1c18,0x69c41c19,0x63ac0237,0x62801c1a}},	//   _hren_, nthe, _ĥanu, rclo, 
   {{0x69c41c1b,0x291c1c1c,0x27ec1345,0x25701c1d}},	//   ithe, nhwa_, _kren_, _išlo_, 
   {{0x291c0088,0x7bc41c1e,0x00000000,0x00000000}},	//   ihwa_, xtiu, --, --, 
   {{0x6b8c1c1f,0x69c41c20,0x00000000,0x00000000}},	//   dpag, kthe, --, --, 
   {{0x291c1c21,0x1d081c22,0x6b8c01ed,0xdca41c23}},	//   khwa_, аеви_, epag, жаби, 
   {{0x27ec1c24,0x6b8c1c25,0x7bc41c26,0x1d0800cc}},	//   _oren_, fpag, ttiu, шеби_, 
   {{0x6b8c1c27,0xdee41c28,0x92cc0ff0,0x291c0088}},	// [1740] gpag, _допи, ৱাৰ_, dhwa_, 
   {{0x7bc41c29,0x00000000,0x00000000,0x00000000}},	//   rtiu, --, --, --, 
   {{0x7bc41c2a,0xd88808e6,0x69c41c2b,0x27ec1c2c}},	//   stiu, لپان_, gthe, _aren_, 
   {{0x6b8c1c2d,0x27ec1c2e,0x7bc40960,0x57e802d8}},	//   bpag, _bren_, ptiu, идем_, 
   {{0x69c41c2f,0x7bc40ca1,0x6b8c00fb,0x27ec1c30}},	//   athe, qtiu, cpag, _cren_, 
   {{0x69c406d2,0x15a8041c,0x00000000,0x00000000}},	//   bthe, аъии_, --, --, 
   {{0x27ec1c31,0x25dc03e1,0xb2740108,0xdb140139}},	//   _eren_, _कैदी_, үлиш, rtyä, 
   {{0x291c1c32,0x27ec1c33,0xd1b801e2,0xd3a41c34}},	//   chwa_, _fren_, ታወቀ_, ороп, 
   {{0x27ec1c35,0xc0d00222,0x00000000,0x00000000}},	//   _gren_, _ብሳላ_, --, --, 
   {{0xb6c80012,0x63ac01c6,0x92681c36,0xd6281298}},	//   _دارے_, _ĥant, ирна_, _козе_, 
   {{0xf4841c37,0x6b8c1c38,0x00000000,0x00000000}},	//   _فاشی, zpag, --, --, 
   {{0x6b8c1c39,0xe1ec00dd,0xb8a4001d,0x00000000}},	//   ypag, اڳو_, _ሊቀጥል_, --, 
   {{0xd1b80090,0x6b8c1c3a,0x69c41c3b,0x8f081c3c}},	//   ታወቁ_, xpag, zthe, ахва_, 
   {{0xb8fc0795,0x69c41c3d,0x291c0088,0xadbc1c3e}},	//   _འི_, ythe, zhwa_, лагi, 
   {{0x062801e2,0x6b8c1c3f,0x69c40569,0x00000000}},	//   _እንደነ, wpag, xthe, --, 
   {{0x69c40043,0x6b8c1c40,0xf4ac0252,0x645c00af}},	//   vthe, tpag, ক্ৰব, üsig, 
   {{0x6b8c1c41,0x8c38002a,0xbd6801d2,0xdb9c01d2}},	// [1750] upag, _meßg, ірсе_, _ﺀﯨﺮﻯ_, 
   {{0x27ec1c42,0xfbac0095,0x00000000,0x00000000}},	//   _rren_, _चिरम, --, --, 
   {{0x291c1c43,0xa2bc1c44,0x69c41c45,0x41241c46}},	//   thwa_, _शास्, uthe, _رفیق, 
   {{0x27ec1c47,0x6b8c1c48,0x69c41c49,0xa6340049}},	//   _pren_, ppag, rthe, үнді, 
   {{0x6b8c1c4a,0x27ec01f1,0x6d4c0027,0xe75801d2}},	//   qpag, _qren_, moaa, биді_, 
   {{0x69c41c4b,0xa5941058,0x2040001d,0x6d4c1c4c}},	//   pthe, прищ, _የንብረ, loaa, 
   {{0x6ecc0a9e,0x79a41c4d,0x27ec1c2f,0x291c1562}},	//   द्यु, _орте, _wren_, phwa_, 
   {{0x6d4c1c4e,0x291c1c4f,0x00000000,0x00000000}},	//   noaa, qhwa_, --, --, 
   {{0x27ec1c50,0xe3b003e0,0x7bc0013b,0xd1b8010f}},	//   _uren_, ررة_, _ämut, ታወቅ_, 
   {{0x6d4c1c51,0x00000000,0x00000000,0x00000000}},	//   hoaa, --, --, --, 
   {{0x81d00252,0x257000e9,0xf74800e2,0x2248092f}},	//   হয়ন_, _ušlo_, _بللي_, спни_, 
   {{0x74f8022e,0xfbac00d1,0x613400e5,0x00000000}},	//   _мехр_, _चिलम, kšle, --, 
   {{0x645c1c52,0x02c001a7,0x256003ef,0x6ecc0095}},	//   üsid, _жилү, góle_, द्भु, 
   {{0x65681c53,0x00000000,0x00000000,0x00000000}},	//   lmeh, --, --, --, 
   {{0x6d4c05cf,0x6568069c,0x12f80107,0x21680139}},	//   foaa, omeh, _להסב, _лики_, 
   {{0x65680e48,0xc2c003a2,0x6ecc0095,0x25600201}},	//   nmeh, _ريڊي, द्बु, bóle_, 
   {{0x25dc1c54,0x00000000,0x00000000,0x00000000}},	// [1760] _कैसी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d4c069c,0x58841c55,0xed8000c3,0x4f840012}},	//   boaa, пыла, _аңси, _وایہ, 
   {{0x65680444,0x2bdc0095,0x9d4400ec,0x00000000}},	//   jmeh, _नैवा, _хемд, --, 
   {{0xebc004f7,0x7d0405c0,0x65681c56,0x00000000}},	//   _иҡти, mjis, dmeh, --, 
   {{0x7d041c57,0x7c241c58,0x96b81c59,0x00000000}},	//   ljis, mzir, суду_, --, 
   {{0x7c24038e,0x97bc024b,0x00000000,0x00000000}},	//   lzir, _әрбi, --, --, 
   {{0x48e01c5a,0x56300020,0x6568013c,0x00000000}},	//   _посв, _ክንክእ, gmeh, --, 
   {{0xa2bc1c5b,0xb9f80222,0x00000000,0x00000000}},	//   _शाश्, _ዘሁ_, --, --, 
   {{0x7d041c5c,0x7c24007b,0x656802cc,0x47d00995}},	//   hjis, izir, ameh, _سيمر, 
   {{0x7c2409d7,0xa2bc1c5d,0x7d0402e8,0xf8e0006c}},	//   hzir, _शार्, kjis, _नसाय, 
   {{0x7d041c5e,0x00000000,0x00000000,0x00000000}},	//   jjis, --, --, --, 
   {{0x0f7002ac,0x85001c5f,0x7c2400e9,0x6d4c0139}},	//   нғир, _سوون, jzir, voaa, 
   {{0x7c241c60,0x941c07e4,0x69c00085,0x645c0104}},	//   dzir, ığıy, _åleg, üsie, 
   {{0x932401ac,0x6d4c1c61,0x7d04030f,0x00000000}},	//   _ورڪن, toaa, fjis, --, 
   {{0x7d040661,0x6edc0152,0xd0180668,0xfd740094}},	//   gjis, _bābü, _гфо_, елсэ, 
   {{0x61441c62,0x6f000191,0x6d4c1c63,0x6b740152}},	// [1770] _تىيە, ölcs, roaa, длау, 
   {{0x6d4c1c64,0x3b541c65,0x7d0402eb,0x25dc0030}},	//   soaa, екур, ajis, _कईली_, 
   {{0x7c240472,0xdce400e5,0x995c0192,0x2bdc0866}},	//   azir, _likę, _kůň_, _नैरा, 
   {{0x7d040012,0x7c240070,0x79241c66,0x00000000}},	//   cjis, bzir, ньчж, --, 
   {{0x66e41c67,0xdce401df,0x066400c3,0xa7a8001e}},	//   дола, _sikć, ﻴﯩﻨﯩ, цкла_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd5ac0d07,0x656805e8,0x00000000,0x00000000}},	//   لہٕ_, tmeh, --, --, 
   {{0xfdf80240,0x00000000,0x00000000,0x00000000}},	//   לצות_, --, --, --, 
   {{0x0474063a,0x65681c68,0x94701c69,0x25dc0203}},	//   _ہلاک_, rmeh, نگها, _कैरी_, 
   {{0x69c00638,0x65681c6a,0xdb1404ac,0x1a980100}},	//   _äles, smeh, tuyé, ֿירע, 
   {{0xf7481c6b,0x7c240668,0x21681c6c,0x61441c6d}},	//   _علمي_, zzir, жини_, дена, 
   {{0x8c38002a,0xb0640012,0xa3e403bf,0x00000000}},	//   _meßb, کھى۪, _पनप_, --, 
   {{0xd9a813d3,0xb0f80094,0x00000000,0x00000000}},	//   _चट्ट, чээх_, --, --, 
   {{0x69d41c6e,0xf1a80046,0xdb140670,0x7c2401d1}},	//   _opze, _ځايه_, puyé, vzir, 
   {{0x7d041c6f,0x6ecc0095,0x00000000,0x00000000}},	//   tjis, द्धु, --, --, 
   {{0x7c2401a7,0x7d04028b,0x00000000,0x00000000}},	//   tzir, ujis, --, --, 
   {{0x7d041c70,0x7c241c71,0x5f28021c,0x69d41977}},	// [1780] rjis, uzir, _моим_, _apze, 
   {{0x7d041c72,0x2a6c01c6,0x76441319,0x00000000}},	//   sjis, _ŝeba_, şiyi, --, 
   {{0x3f800034,0x1d081c73,0x02cc00cb,0x25dc00d1}},	//   _huiu_, _дени_, त्यभ, _कैली_, 
   {{0xb7c400b8,0x3940013c,0x00000000,0x00000000}},	//   еркқ, õis_, --, --, 
   {{0x2000000d,0x00000000,0x00000000,0x00000000}},	//   nxki_, --, --, --, 
   {{0x386001c6,0x02cc0095,0x8ba000b7,0x00000000}},	//   ĥir_, त्मभ, _јирж, --, 
   {{0x75840223,0x00000000,0x00000000,0x00000000}},	//   _ẹgbé, --, --, --, 
   {{0x068001b7,0xfd6400a8,0x00000000,0x00000000}},	//   нгән, _pauṃ, --, --, 
   {{0x69c0000b,0xa3d80203,0x661c03b4,0x9bd001d2}},	//   _äler, डौल_, _əski, ерiл, 
   {{0x59d00967,0x78a001c9,0xa3000087,0x25440059}},	//   _सहार, _hemv, лүче, vēle_, 
   {{0x321819eb,0x5f000095,0xc1b40094,0x00000000}},	//   áry_, शान्_, млэх_, --, 
   {{0x92bc00ac,0x3f80059e,0xdce400b0,0x00000000}},	//   ঁজে_, _buiu_, _tikę, --, 
   {{0x78a01c74,0x3f800034,0x066400c3,0x00000000}},	//   _memv, _cuiu_, ﻴﯩﻠﯩ, --, 
   {{0x78a01c75,0x3f80059e,0x00000000,0x00000000}},	//   _lemv, _duiu_, --, --, 
   {{0x6ef40101,0x31341c76,0x78a002bb,0x00000000}},	//   _aýbä, _пекр, _oemv, --, 
   {{0x3f800770,0x78a0014b,0xde3c010f,0xecc40094}},	//   _fuiu_, _nemv, ደሚያገ, эшгү, 
   {{0x3f801c77,0x3c580254,0x7c841c78,0xaa940668}},	// [1790] _guiu_, дитэ_, тусе, еизч, 
   {{0x799c0086,0xc2780100,0x00000000,0x00000000}},	//   _bwrw, ַרדי, --, --, 
   {{0x78a01c79,0x7ac40348,0x799c0086,0x4ca802fa}},	//   _bemv, ъсте, _cwrw, ঙ্গু, 
   {{0x25600270,0x1cdc043b,0x3d1c00d3,0xa3340020}},	//   kóla_, _རིར_, _tíwa_, _ብወትሃ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25701bf9,0x78a000e2,0x7c20024f,0xaad40229}},	//   _išli_, _eemv, _ümra, _àlàó_, 
   {{0x2d801c7a,0x78a00207,0x6aa40249,0x799c0086}},	//   _juhe_, _femv, mahf, _gwrw, 
   {{0x2d801c7b,0x6aa41c7c,0x66100560,0x2120000d}},	//   _muhe_, lahf, _ċekċ, xhkh_, 
   {{0x2d801c7d,0x2fc801f9,0xf7780126,0x25600e0b}},	//   _luhe_, _nqag_, _fiħ_, góla_, 
   {{0x68e81c7e,0x290c1847,0x78a01c7f,0xa2041c80}},	//   _haed, _hoea_, _zemv, епод, 
   {{0x68e81c81,0x3f800264,0x78a01c82,0x290c0299}},	//   _kaed, _suiu_, _yemv, _koea_, 
   {{0x4acc0a63,0x257002db,0x3f8002ea,0x290c01df}},	//   स्तव, _ošli_, _puiu_, _joea_, 
   {{0x290c1c83,0x2d800243,0x256000c4,0xa3b800dd}},	//   _moea_, _auhe_, cóla_, _ڀاڪر_, 
   {{0x290c1c84,0x68e81c85,0x657800a2,0x63a81c86}},	//   _loea_, _laed, _hiwh, msen, 
   {{0x63a81c87,0x6aa402b0,0x9cf40320,0x00000000}},	//   lsen, dahf, нчаш, --, 
   {{0x68e81c88,0x2000004e,0x2d801c89,0x00000000}},	//   _naed, pxki_, _duhe_, --, 
   {{0x1c441c8a,0x78a00068,0x63a81c8b,0x65780428}},	// [17a0] хнам, _remv, nsen, _miwh, 
   {{0x63a81c8c,0x78a01c8d,0x64580308,0x68e80308}},	//   isen, _semv, _mywi, _aaed, 
   {{0x63a81c8e,0x68e81c8f,0x25700091,0xefbc010f}},	//   hsen, _baed, _ešli_, ታየው_, 
   {{0x63a81c90,0x68e8165f,0x26c40d2e,0x65780296}},	//   ksen, _caed, _aclo_, _niwh, 
   {{0x63a81c91,0x68e8034c,0x64581c92,0x2880021b}},	//   jsen, _daed, _nywi, рқув, 
   {{0x63a81c93,0x78a01c94,0x290c0078,0x68e81c95}},	//   dsen, _wemv, _eoea_, _eaed, 
   {{0x63a81c96,0x68e8001d,0x64580d2e,0x78a01c97}},	//   esen, _faed, _aywi, _temv, 
   {{0x1cdc1c98,0x68e81c99,0x64580323,0x612406b4}},	//   _རིས_, _gaed, _bywi, _hólf, 
   {{0x63a80008,0x65781c9a,0x64581c9b,0x57b00200}},	//   gsen, _diwh, _cywi, _сұлт, 
   {{0x25600770,0x290c042e,0x64580098,0x00000000}},	//   róla_, _zoea_, _dywi, --, 
   {{0x290c0264,0x63a81c9c,0x13040087,0xca38010f}},	//   _yoea_, asen, _үзем, _ጨዋታዎ, 
   {{0x63a81c9d,0x2d801c9e,0x63800329,0x645803c7}},	//   bsen, _ruhe_, ыҳәа, _fywi, 
   {{0x64580336,0x2d801c9f,0xdd680ce5,0x63a800d5}},	//   _gywi, _suhe_, _ﺳﺎﭘﺎ_, csen, 
   {{0x2d80021c,0x44740100,0x613400b0,0x00000000}},	//   _puhe_, _נעגל_, ršla, --, 
   {{0xdb0c0229,0x82d40d47,0xd13800fb,0x64581ca0}},	//   _àjùm, _נוהג_, _нхи_, _zywi, 
   {{0xdb140078,0xb918004f,0x66040027,0x9f40006b}},	//   lryè, _gneḥ_, ähki, evkä_, 
   {{0x68e81ca1,0xfe700191,0x612406b4,0x00000000}},	// [17b0] _raed, لدہ_, _bólf, --, 
   {{0x68e8008e,0x5e3000d5,0xcf2401ac,0x49a400b7}},	//   _saed, اڑیا, _سرخي, ејда, 
   {{0x290c025e,0xc3300240,0xe94401d9,0x63a81ca2}},	//   _poea_, נוע_, پرای, zsen, 
   {{0x9f5001e8,0x6ecc1ca3,0x1d78010f,0x00000000}},	//   _aryè_, द्रु, _በሴቶች_, --, 
   {{0x2570091d,0x290c1ca4,0x68e80068,0x65780296}},	//   _ušli_, _voea_, _vaed, _riwh, 
   {{0xd7ec0ad5,0x61240270,0x63a81ca5,0x64581ca6}},	//   زكى_, _gólf, vsen, _rywi, 
   {{0x68e81658,0x290c1ca7,0x657800a2,0x63a80308}},	//   _taed, _toea_, _piwh, wsen, 
   {{0x63a81ca8,0x26c40320,0x6458000f,0x4ac40203}},	//   tsen, _wclo_, _pywi, _लाडव, 
   {{0xa774039c,0xe2981ca9,0x23280668,0xd9b00122}},	//   _алач, мап_, допи_, _مڕۆد, 
   {{0xdedc02b4,0x31680034,0x65940094,0x00000000}},	//   ሕትን_, _ahaz_, _аажу, --, 
   {{0x657804c4,0x6458002f,0x3168011a,0x672002b0}},	//   _tiwh, _wywi, _bhaz_, _illj, 
   {{0x63a81caa,0xa2bc1cab,0x6e2800cf,0x3d1c00d3}},	//   psen, _शाक्, ĝebl, _ríwo_, 
   {{0xa3e41cac,0x61e0009c,0x25600a03,0x6e2800cf}},	//   _पनि_, swll, lólo_, ŝebl, 
   {{0xb4640302,0x539800ca,0x61e00335,0x00000000}},	//   _скіл, _חיסו, pwll, --, 
   {{0xdca41b99,0xdb1400fc,0xd6c40143,0x00000000}},	//   кави, gtyý, _এসময, --, 
   {{0x31680560,0x326001b5,0x61240579,0xa3e400bd}},	//   _ghaz_, _دۆپہ, _sólf, _पना_, 
   {{0x4fe401a7,0x4c801cad,0xfb841cae,0x3d1c0223}},	// [17c0] _амын_, рлув, ادری, _wíwo_, 
   {{0x25600be3,0x61241caf,0x4b201cb0,0x9b3c001d}},	//   kólo_, _bólg, амув, _በየካቲ, 
   {{0x9d44039c,0x18a41cb1,0x00000000,0x00000000}},	//   _аенд, ваем, --, --, 
   {{0x67201cb2,0x7b841cb3,0xdcfc1cb4,0xe99404c3}},	//   _allj, _ماسە, _kupč, اهنگ, 
   {{0x6ac8007e,0x6720006f,0x2ba81cb5,0x3ab40152}},	//   ৰয়ো, _bllj, _चौपा, _бәет, 
   {{0xcf9000b9,0x6124030f,0x00000000,0x00000000}},	//   סטו_, _fólg, --, --, 
   {{0x645c00df,0xdcfc01d1,0x394401f1,0x4ac403ef}},	//   üsin, _lupč, _tjms_, _लातव, 
   {{0x672000e0,0x18680b1a,0x13a400d5,0x9868018f}},	//   _ellj, _жаби_, نچتی_, _жибб_, 
   {{0x67400012,0xdb1400f1,0x98340023,0x00000000}},	//   _گێوٕ, tryè, _рэві, --, 
   {{0x51841cb6,0x31680088,0x60d41cb7,0x00000000}},	//   кума, _shaz_, _abym, --, 
   {{0x54c40254,0x1d30010f,0x2f1c00d3,0xcb1000cf}},	//   _абеб, _በገንዘ, _sìgo_, ילז_, 
   {{0x498402b4,0xf8b41cb8,0xf1c40474,0x00000000}},	//   _ንነብሱ_, ुलिय, लंबन, --, 
   {{0xc0580302,0xf2c400c3,0x6d400029,0x4ea40edd}},	//   вір_, _йөни, élam, крва, 
   {{0x82301cb9,0xdcfc0091,0x256002b2,0x00000000}},	//   اریا, _dupč, hóll_, --, 
   {{0x5fb00030,0xc20c1cba,0xfc38001d,0x00000000}},	//   _जिअल, _тє_, _በመፈለ, --, 
   {{0x8d740122,0x612401ca,0x00000000,0x00000000}},	//   ئاسا, _rólg, --, --, 
   {{0x8aa41cbb,0xdcfc01df,0x61241cbc,0x00000000}},	// [17d0] вред, _gupč, _sólg, --, 
   {{0xef100046,0x6e980668,0x00000000,0x00000000}},	//   _چټک_, _явор_, --, --, 
   {{0xdcfc0070,0xce680b61,0x6d34138a,0x00000000}},	//   _zupč, _юрид_, _бенф, --, 
   {{0x3ce00104,0x205c001d,0xd2441b67,0x00000000}},	//   ceiv_, _ለሕብረ, _ۇن_, --, 
   {{0x2ca81cbd,0xaac403a2,0x8c640007,0xb81400b8}},	//   maad_, _مڪان, _штод, аҧтә, 
   {{0xd2441cbe,0x2ca8004b,0x2eb000b6,0xe5a400c3}},	//   _هن_, laad_, _जयोत, гики, 
   {{0xa2e4018f,0x00000000,0x00000000,0x00000000}},	//   қонд, --, --, --, 
   {{0xa3e81cbf,0xdedc1cc0,0x2ca81cc1,0x4acc0095}},	//   едиа_, ሕትና_, naad_, स्रव, 
   {{0x291c1cc2,0xa0a41cc3,0x612400d5,0x2ba80cbd}},	//   mkwa_, һанд, _jóle, _चौमा, 
   {{0x2ca80012,0x291c0083,0xdcfc02db,0xb9dc0020}},	//   haad_, lkwa_, _rupč, _አቲ_, 
   {{0xbbd01cc4,0x2ca81cc5,0xf7700075,0x612400f2}},	//   _सङ्क, kaad_, _ذاك_, _lóle, 
   {{0x291c1cc6,0xdcfc00e9,0xe1241cc7,0x2ca80080}},	//   nkwa_, _pupč, умми, jaad_, 
   {{0x2ca8004b,0x291c1cc8,0xf48403d6,0xd36c0324}},	//   daad_, ikwa_, _тухн, تهی_, 
   {{0x248c1cc9,0xfe78155a,0xdb140105,0x944001b8}},	//   lcem_, күп_, kuyá, _چھین, 
   {{0x14e401b9,0x3ce00c2a,0x2ca80012,0x25601cca}},	//   কাৰী_, teiv_, faad_, hólm_, 
   {{0x248c1ccb,0x2ca81ccc,0x02cc1ccd,0x69cc1cce}},	//   ncem_, gaad_, त्रभ, _सहजी, 
   {{0x6124054b,0x3ce0007e,0x20040222,0x248c02bf}},	// [17e0] _cóle, reiv_, _çoi_, icem_, 
   {{0x291c1ccf,0x4f98067a,0x5eac0143,0x248c0055}},	//   ekwa_, _רביצ, ঞ্জে, hcem_, 
   {{0x2ca8004b,0x99141cd0,0xeb740007,0x248c01d1}},	//   baad_, льді, рытэ, kcem_, 
   {{0x60c4060f,0x2ca81cd1,0x248c1cd2,0x00000000}},	//   ngkm, caad_, jcem_, --, 
   {{0xb8dc1cd3,0x645c00a1,0x248c1cd4,0x420c00cb}},	//   _आय_, üsil, dcem_, ाहुः_, 
   {{0x291c0130,0x2c101cd5,0x248c00b7,0xcc380100}},	//   akwa_, णहरू_, ecem_, _װעלט, 
   {{0xf484058c,0x948401ec,0x8b2001f1,0xd1cc001d}},	//   қуқн, лыпд, _удре, ጥቃት_, 
   {{0x82bc0126,0x73d801d9,0x00000000,0x00000000}},	//   _མཐུའ, вдир_, --, --, 
   {{0x56f01cd6,0xede000bd,0x00000000,0x00000000}},	//   _гүлс, _पन्छ, --, --, 
   {{0x0b380090,0x2ca81cd7,0x3254118d,0x46100061}},	//   _በከተማ, zaad_, ивпр, _گومر, 
   {{0x2ca8004b,0x248c0192,0x8b54067a,0xaf34001d}},	//   yaad_, bcem_, רייס_, _ባለማወ, 
   {{0x2ca804bb,0x4610009d,0xc20404e7,0x248c0d8c}},	//   xaad_, _دومر, چقین_, ccem_, 
   {{0xbf9401b8,0x3d080c14,0xbe34001d,0x00000000}},	//   یگیڈ, हाने_, _አስገዳ, --, 
   {{0x2ca8004b,0x61240270,0x11f40012,0xabdc01d2}},	//   waad_, _róle, _موتک_, _ﺇﺴﻨﺎ, 
   {{0x2d841cd8,0x2ca81cd9,0x70940362,0xa634010f}},	//   êle_, taad_, _кайф, _እንደሰ, 
   {{0xad241a05,0x612400b7,0x00000000,0x00000000}},	//   جىرى, _póle, --, --, 
   {{0x2ca81cda,0x99980031,0x00000000,0x00000000}},	// [17f0] raad_, lypň_, --, --, 
   {{0x2ca81cdb,0xdec000c3,0x659000a8,0x0c84001e}},	//   saad_, _мәсо, _hāhe, _әынм, 
   {{0x2ca81cdc,0x65900296,0x7b641cdd,0xdb140031}},	//   paad_, _kāhe, стте, gtyñ, 
   {{0x612407d4,0x2ba802e0,0x2ca80012,0x291c042e}},	//   _tóle, _चौथा, qaad_, ukwa_, 
   {{0x65901cde,0xef480020,0xa6c803d6,0xab7801ac}},	//   _māhe, _ዓብደል, влла_, _لمحا_, 
   {{0x291c1cdf,0x645c00b6,0xc6a41ce0,0x248c03ef}},	//   skwa_, üsim, урди, wcem_, 
   {{0x2ba80979,0x6ab402b0,0xff1800ca,0x248c1ce1}},	//   _चौता, _idzf, רקות_, tcem_, 
   {{0xfe380100,0x659001d3,0xa7fc00e3,0x00000000}},	//   טרוי_, _nāhe, _nyűg, --, 
   {{0xa6340090,0xe4500075,0x00000000,0x00000000}},	//   _እንዲሰ, غضب_, --, --, 
   {{0x248c1ce2,0xd36c1ce3,0xe1f80302,0xdedc0020}},	//   scem_, وهي_, вго_, ሕድና_, 
   {{0x248c1ce4,0x62641ce5,0xc79403d6,0x30a001d2}},	//   pcem_, рвна, _арçы, _ﺃﺩﺒﻴ_, 
   {{0x6124020f,0xa91c00e0,0x6590004f,0xe474012b}},	//   _sólb, _dižg, _cāhe, _кулэ, 
   {{0xdcfc1ce6,0x6590004f,0x5f8000c3,0x84640074}},	//   _atpğ, _dāhe, غۇدە, _съже, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9d5401d9,0xdcfc00a8,0xe5080095,0xdd90115c}},	//   لنست, _aupā, वापि_, توز_, 
   {{0x06ac0019,0xa2cc02a4,0x10a0044a,0x00000000}},	//   চ্চি, थभक्, _диън, --, 
  
   {{0x1be800f8,0x5ac81ce7,0x00000000,0x00000000}},	// [1800] ъдаи_, клам_, --, --, 
   {{0x25600959,0xdd880375,0x5a940681,0x00000000}},	//   fólk_, _ибод_, рраф, --, 
   {{0xd12c049d,0x2d8400aa,0x00000000,0x00000000}},	//   _رمی_, ílet_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x59d00879,0xe5080095,0x00000000,0x00000000}},	//   _सहकर, वानि_, --, --, 
   {{0x5018047b,0x256005c0,0x473001f5,0xda64068a}},	//   כונו, bólk_, оніс, _نازي, 
   {{0xceb00107,0x98a401f5,0x613400e9,0x7bc41ce8}},	//   קיה_, _вибе, ršlj, luiu, 
   {{0xd9440937,0x00000000,0x00000000,0x00000000}},	//   _теби, --, --, --, 
   {{0x7bc41ce9,0x65900299,0x53441cea,0x569400ec}},	//   nuiu, _rāhe, ихоа, _ҡаҡт, 
   {{0x7bc41ceb,0x4c2c001d,0x9654044a,0x00000000}},	//   iuiu, _በጉባኤ, _къеч, --, 
   {{0x79801cec,0x65900341,0x00000000,0x00000000}},	//   _kimw, _pāhe, --, --, 
   {{0x7bc40132,0xa91c0031,0x1cdc011a,0xfa2800dc}},	//   kuiu, _gižd, _རིཊ_, _মশাল_, 
   {{0x79801ced,0x50641cee,0x7bc4012a,0x25a80070}},	//   _mimw, ртна, juiu, ćale_, 
   {{0x79801cef,0x65900299,0x3004001e,0xd7000023}},	//   _limw, _wāhe, азҭг, _мiха, 
   {{0xfd880800,0x65900341,0x8d8400e7,0x3f840635}},	//   иёти_, _tāhe, ругд, ímur_, 
   {{0x79801cf0,0xc2780282,0xdc100252,0x00000000}},	//   _nimw, _ברוי, _সেইস_, --, 
   {{0x7bc41cf1,0xdb140919,0x0b8801f1,0x612403bf}},	// [1810] guiu, kuyä, тсби_, _wólc, 
   {{0x798006e2,0xa91c01d1,0xbcf001c6,0x693400c3}},	//   _aimw, _miže, roɩa, әнду, 
   {{0x798004fe,0xbd8804bb,0xa91c1cf2,0x7bc4008b}},	//   _bimw, _پنُن_, _liže, auiu, 
   {{0x645c00a1,0xdcfc00a2,0x7bc40496,0x79800086}},	//   üsik, _tupā, buiu, _cimw, 
   {{0x6124056d,0x79801cf3,0x6d5c1cf4,0x7bc4165f}},	//   _jóla, _dimw, _iksa, cuiu, 
   {{0x6d5c0840,0x79800882,0x66e41cf5,0xe5081cf6}},	//   _hksa, _eimw, сока, वाभि_, 
   {{0xa3a81cf7,0xfd100061,0x00000000,0x00000000}},	//   गीन_, _رجێ_, --, --, 
   {{0x69c41cf8,0x24e80155,0x224802db,0x00000000}},	//   muhe, умии_, _ćak_, --, 
   {{0x69c41cf9,0xf79402b3,0x3d081cfa,0xd05c0387}},	//   luhe, _матэ, हाते_, _taqə, 
   {{0x79800161,0x27ec1cfb,0xa91c1cfc,0x6d5c015b}},	//   _zimw, _isen_, _diže, _lksa, 
   {{0x69c40308,0x7980017b,0x04b40012,0xa91c00e0}},	//   nuhe, _yimw, _نپاں_, _eiže, 
   {{0x592c0002,0x61241cfd,0x61441cfe,0x25601cff}},	//   ྩིགས_, _bóla, сема, kóli_, 
   {{0x69c41d00,0x00000000,0x00000000,0x00000000}},	//   huhe, --, --, --, 
   {{0x6d5c1d01,0x612419e8,0x53980240,0x22940075}},	//   _aksa, _dóla, _עיצו, _الغس, 
   {{0xb638010f,0x27ec1d02,0x41d81d03,0x61240306}},	//   _እንደቀ, _lsen_, _बहिस, _eóla, 
   {{0x2ba80774,0x61341d04,0x7bc41d05,0x612406b4}},	//   _चौहा, kšli, tuiu, _fóla, 
   {{0x79801d06,0x27ec0130,0xf388001c,0x6b8c1d07}},	// [1820] _rimw, _nsen_, _lợn_, gqag, 
   {{0x79801d08,0xa3a81d09,0x7bc41d0a,0x00000000}},	//   _simw, गीय_, ruiu, --, 
   {{0x27ec1d0b,0x69c41d0c,0x6d5c03e6,0x79800428}},	//   _asen_, guhe, _fksa, _pimw, 
   {{0x1d081d0d,0x79800d2e,0xac080329,0x00000000}},	//   _семи_, _qimw, ынӡа_, --, 
   {{0x7bc41d0e,0x27ec01c7,0x69c41d0f,0x798001dc}},	//   quiu, _csen_, auhe, _vimw, 
   {{0x69c41d10,0x798000ba,0x1cdc0126,0x25a403c7}},	//   buhe, _wimw, _རིཌ_, _bwll_, 
   {{0x79801d11,0x27ec1d12,0xa91c00e0,0xc6d01d13}},	//   _timw, _esen_, _siže, ستوت, 
   {{0x25a40335,0x81bc02fa,0xf3f800fc,0xecc01d14}},	//   _dwll_, ুবা_, иңе_, एलएफ, 
   {{0xb6380090,0x4acc0021,0xccf002c3,0xd3781d15}},	//   _እንዲቀ, स्कव, לכה_, лчо_, 
   {{0x61241d16,0x79540031,0x73381d17,0x00000000}},	//   _róla, _düwş, рзор_, --, 
   {{0x61240635,0x23a80d04,0xf38801eb,0x16a80123}},	//   _sóla, चीबद, _gợn_, _авҷи_, 
   {{0x61241d18,0xc5f00107,0x4a780100,0xe5080095}},	//   _póla, _מדע_, טריב, वाणि_, 
   {{0x69c41d19,0x00000000,0x00000000,0x00000000}},	//   zuhe, --, --, --, 
   {{0x65901d1a,0x69c404cd,0xa7fc01b8,0x84600020}},	//   _hāha, yuhe, _szűk, ትኩምን_, 
   {{0xd044038c,0xe1880014,0x65901d1b,0xdce8004f}},	//   _əməl, _hẳn_, _kāha, _śnāt, 
   {{0x69c40593,0x612402b2,0xfd880123,0x59d00c5f}},	//   vuhe, _hóln, сёри_, _सहजर, 
   {{0x659004c4,0xdcfc0254,0x69c41d1c,0x8d8401d9}},	// [1830] _māha, _supă, wuhe, руҳд, 
   {{0x69c41d1d,0x4ea401a7,0xdcfc00c2,0x69c00085}},	//   tuhe, _уриа, _pupă, _ålek, 
   {{0x2ba80f61,0x0a6802dc,0xb05400e2,0x6b8c018f}},	//   _चौरा, ураи_, _دپکت, sqag, 
   {{0x69c41d1e,0x6d5c004e,0xf3880048,0x65901d1f}},	//   ruhe, _uksa, _rợn_, _nāha, 
   {{0x6b8c0132,0x69c41d20,0x66e40078,0x00000000}},	//   qqag, suhe, _lékņ, --, 
   {{0x69c40274,0x25a40336,0xa59412a3,0x2cb801eb}},	//   puhe, _pwll_, орищ, _hdsd_, 
   {{0x69c40222,0x659001d3,0xd90c01b8,0x00000000}},	//   quhe, _bāha, ریے_, --, 
   {{0xe3b80e4d,0x1cdc043b,0x27ec1d21,0xa91c00e0}},	//   аби_, _རིབ_, _tsen_, _dižc, 
   {{0x27ec1d22,0x659001d3,0x00000000,0x00000000}},	//   _usen_, _dāha, --, --, 
   {{0xdb1406ea,0xf3880048,0x25a40323,0xe2c8132f}},	//   styö, _tợn_, _twll_, جودو_, 
   {{0xd24c00d5,0xe5081d23,0x00000000,0x00000000}},	//   ہنی_, वादि_, --, --, 
   {{0xd24c0046,0x6f040048,0x659000a8,0x28d003e4}},	//   ځنی_, _anhc, _gāha, _हाफि, 
   {{0x28d0044b,0xd24c1d24,0x20540027,0xe7f00098}},	//   _हानि, فنی_, ютор, _आईफा_, 
   {{0xe2981d25,0xe7f003ef,0x256002e8,0x612400f2}},	//   _так_, _आईना_, gólv_, _góln, 
   {{0x1cdc0560,0x8e8003bd,0x5fb40098,0x21680450}},	//   _རིད_, дгре, _अटकल, _кики_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd00c0075,0x8c38002a,0x5f740075,0x1c441d26}},	// [1840] _للي_, _meßw, _واخر, цнам, 
   {{0x2cb800fb,0x5de40320,0xa0c400ea,0x00000000}},	//   _edsd_, _джоа, _ايکو, --, 
   {{0xa3a80d3f,0x7f5c1d27,0x00000000,0x00000000}},	//   गीत_, morq, --, --, 
   {{0x6d400c5b,0x20040177,0x7f5c1d28,0x5974001e}},	//   élat, _àois_, lorq, цызу, 
   {{0x65901d29,0x61240223,0x37f800fc,0x00000000}},	//   _rāha, _lólo, селэ_, --, 
   {{0xd5b81d2a,0x6e380b66,0x3d0800b3,0x98a81d2b}},	//   аси_, _ñabü, हावे_, ımın_, 
   {{0x65900341,0x7f5c03b2,0xe18801eb,0x960800e5}},	//   _pāha, iorq, _sẳn_, рэла_, 
   {{0xe9700200,0x89d41be1,0x1de00098,0x00000000}},	//   _كۇلد, _گوہر_, _पहनत, --, 
   {{0x25a8091d,0x7f5c03c0,0x969409a5,0xe7d0081a}},	//   ćala_, korq, _дреш, _समयप, 
   {{0x65900b60,0x7f5c014a,0x63bc0191,0x25b40012}},	//   _wāha, jorq, ásna, _کۆٹھ_, 
   {{0x659004c4,0x7f5c1d2c,0x61241d2d,0x28d00098}},	//   _tāha, dorq, _cólo, _हामि, 
   {{0xd1381d2e,0xf388000d,0x940400e2,0xd0a80123}},	//   рхо_, _hợm_, _وواه, штод_, 
   {{0x61fc00d4,0xa91c01d5,0x659001d3,0x40340027}},	//   āsla, _jiža, _jāhn, деяс, 
   {{0x7f5c0034,0x00000000,0x00000000,0x00000000}},	//   gorq, --, --, --, 
   {{0x61241d2f,0x645c00af,0x3d94041c,0x00000000}},	//   _kóll, üsiv, диср, --, 
   {{0x69c0007e,0x25440059,0xaadc0a9e,0xdce400b0}},	//   _ålei, tēli_, न्नक, _mikė, 
   {{0x7f5c034c,0xa91c01f6,0xe1e801b5,0x6fb41d30}},	// [1850] borq, _niža, _نى۪و_, _عمدا, 
   {{0x6f041d31,0xf3e40252,0x95080126,0x7f5c0034}},	//   _unhc, কটপৰ_, _ཀོའི_, corq, 
   {{0x3f6800b7,0x00000000,0x00000000,0x00000000}},	//   _фиќо_, --, --, --, 
   {{0xa91c01df,0x67d400e1,0xec141d32,0x3bd4012b}},	//   _biža, зоду, _فوجد, bäq_, 
   {{0x3d081d33,0x38640086,0xf38801eb,0x6590004f}},	//   हारे_, _cymr_, _bợm_, _cāhn, 
   {{0xa91c00e0,0x00000000,0x00000000,0x00000000}},	//   _diža, --, --, --, 
   {{0x98a400ef,0xf4a8001d,0x368803ba,0x00000000}},	//   choď_, _መቀመጥ_, әсән_, --, 
   {{0x67d40f5d,0x612403b2,0x00000000,0x00000000}},	//   _нобу, _cóll, --, --, 
   {{0x61240029,0x7f5c0964,0xd1c40182,0xa4440108}},	//   _dóll, yorq, үлье_, янид, 
   {{0x612400b7,0xdedc0020,0x00000000,0x00000000}},	//   _pólo, ዕትን_, --, --, 
   {{0x644c0822,0x6264009e,0x238401b5,0xaadc1d34}},	//   _žaid, явоа, _کٔتِ, न्यक, 
   {{0x659000a2,0x612400d5,0x00000000,0x00000000}},	//   _hāho, _góll, --, --, 
   {{0x65900b60,0x7f5c1d35,0xd91800cf,0xc2f000dc}},	//   _kāho, torq, צושל, জাবি_, 
   {{0x612402c6,0x606c010f,0x53980107,0x4ac402bc}},	//   _tólo, _በንግድ_, _היסו, _लागव, 
   {{0xc25403d9,0x65900341,0x61241d36,0x7f5c034c}},	//   _بخشت, _māho, _hólm, rorq, 
   {{0x7f5c1d37,0x91b800ca,0x00000000,0x00000000}},	//   sorq, _המקי, --, --, 
   {{0x3b181d38,0x7f5c04db,0xc1d81d39,0x612400f2}},	// [1860] _porq_, porq, _बहुग, _jólm, 
   {{0x1cdc1ada,0x7f5c0d2e,0xa91c01f6,0x00000000}},	//   _རིམ_, qorq, _riža, --, 
   {{0x659000a8,0x00000000,0x00000000,0x00000000}},	//   _sāhn, --, --, --, 
   {{0xa91c1cb4,0x00000000,0x00000000,0x00000000}},	//   _piža, --, --, --, 
   {{0x61240c0f,0x4c801166,0xe79400ea,0x00000000}},	//   _róll, _плюв, واوک, --, 
   {{0xd394039c,0x612400cc,0x28d0021f,0x7bc40128}},	//   җәдә_, _sóll, _हाथि, mriu, 
   {{0x09e01d3a,0x98a41d3b,0x61240407,0x18a41d3c}},	//   _порн, _ниве, _póll, _навм, 
   {{0x779402ac,0x39b801e8,0x7bc400af,0x00000000}},	//   _قیصا, mčs_, oriu, --, 
   {{0x39b81d3d,0x7bc4006f,0x28d0025c,0x337402dc}},	//   lčs_, nriu, _हाति, мгир, 
   {{0x9664009e,0xdce40007,0xa91c00aa,0x7bc40023}},	//   _екзе, _tikė, _jižn, iriu, 
   {{0x6124038a,0x7bc4034c,0x0ed00d49,0x39b81d3e}},	//   _tóll, hriu, _ताबड, nčs_, 
   {{0x7bc41d3f,0x53b40476,0xf48401d9,0x00000000}},	//   kriu, _еғир_, _قاشی, --, 
   {{0xb4e803b6,0x612403aa,0x63ac011a,0xd324058b}},	//   मजी_, _gólm, _ħang, _ньки, 
   {{0x7bc41d40,0xa91c02cc,0x8c38002a,0x00000000}},	//   driu, _nižn, _meßt, --, 
   {{0x7bc41d41,0x39b80078,0x00000000,0x00000000}},	//   eriu, jčs_, --, --, 
   {{0x7bc40496,0x29d41d42,0x39b800f1,0x00000000}},	//   friu, våa_, dčs_, --, 
   {{0x70541d43,0xc158033c,0x799c02b0,0x7bc41d44}},	// [1870] _زندا, _משהו_, _atrw, griu, 
   {{0x29d4036d,0x659001d3,0xbbb8021d,0x00000000}},	//   tåa_, _bāhl, ягує_, --, 
   {{0x79a4070b,0x65901d45,0x799c06e2,0x7bc41d46}},	//   ерче, _rāho, _ctrw, ariu, 
   {{0x7bc41d47,0xba741d48,0x29d40aa0,0x50bc00cb}},	//   briu, رالت, råa_, ्लिष, 
   {{0x7bc41d49,0x799c07e1,0x6d4c1d4a,0x65900341}},	//   criu, _etrw, mnaa, _pāho, 
   {{0x6d4c1d4b,0x0f18006c,0x6b9c002a,0xe3e80012}},	//   lnaa, _नकोस_, _itsg, ۪کان_, 
   {{0x6d4c1d4c,0x25a80473,0x612406b4,0x00000000}},	//   onaa, ćalo_, _sólm, --, 
   {{0x6d4c1d4d,0x63bc0113,0x56900121,0x2fd801eb}},	//   nnaa, ásno, наәт, ktsg_, 
   {{0x6d4c1d4e,0x65900296,0xe3e802ac,0x69c41d4f}},	//   inaa, _tāho, تکان_, lrhe, 
   {{0x6d4c1d50,0x20f80048,0x6aa41d51,0x63ac011a}},	//   hnaa, _ỏi_, nbhf, _ħand, 
   {{0x69c40336,0xa300002c,0x6d4c1d52,0x6aa41d51}},	//   nrhe, еүҙе, knaa, ibhf, 
   {{0xe7d01d53,0x7bc40007,0x61ec0091,0x69c411ae}},	//   _समाप, yriu, _ćald, irhe, 
   {{0x6b9c1d54,0x69c406ef,0x6d4c1d55,0x612402b2}},	//   _ntsg, hrhe, dnaa, _hólk, 
   {{0x65681d56,0xf1a81d57,0x7bc40322,0x6d4c1d58}},	//   lleh, _کاوه_, vriu, enaa, 
   {{0x6d4c1d59,0xa3a81d5a,0xa91c0b34,0xae0401c4}},	//   fnaa, गीर_, _nižo, норҙ, 
   {{0x65681d5b,0x6d4c1d5c,0x69c400ef,0x39b801b1}},	//   nleh, gnaa, drhe, včs_, 
   {{0x8c401d5d,0x799c0336,0x69c41d5e,0x5fd0002f}},	// [1880] вете, _strw, erhe, _तमिल, 
   {{0x6d4c1d5f,0x65681d60,0x7bc41d61,0xa3b400a1}},	//   anaa, hleh, rriu, _जबन_, 
   {{0x69c41d62,0x6d4c1d63,0xa91c01c3,0x0ed000b3}},	//   grhe, bnaa, _vižn, _तातड, 
   {{0x7bc41d64,0x6d4c0012,0x2ba800b3,0xa91c00ce}},	//   priu, cnaa, _चौका, _dižo, 
   {{0x69c41d65,0x66001d66,0xaab81d67,0x65681d68}},	//   arhe, _arlk, زدەر_, dleh, 
   {{0x61240545,0x7c241d69,0x65681d6a,0xa91c07b5}},	//   _bólk, myir, eleh, _fižo, 
   {{0x6568007f,0x69c40323,0x799c0098,0x00000000}},	//   fleh, crhe, _utrw, --, 
   {{0x6ba4046a,0xdb040252,0x65681d6b,0xf3880048}},	//   _åtgä, _avkø, gleh, _hợi_, 
   {{0x7c241d6c,0xa3a80698,0x66000104,0xb9cc19ef}},	//   nyir, गील_, _erlk, _ሲሶ_, 
   {{0x61241d6d,0x6568060f,0xc7a00087,0x00000000}},	//   _fólk, aleh, _рифк, --, 
   {{0x6d4c1d6e,0x7c241d6f,0x65681d70,0xdce40095}},	//   ynaa, hyir, bleh, _cikī, 
   {{0xf3880765,0x6d4c1d71,0x7c240271,0x14241d72}},	//   _lợi_, xnaa, kyir, _одем, 
   {{0x28d00f7c,0x7c24017b,0x03140122,0x61ec01df}},	//   _हासि, jyir, ستیت_, _ćale, 
   {{0x7c240068,0x6d4c1d73,0x69c40086,0x00000000}},	//   dyir, wnaa, yrhe, --, 
   {{0x6d4c1d74,0x9f500078,0xae441d75,0x00000000}},	//   tnaa, _msyè_, رپرو, --, 
   {{0x6d4c1d76,0xa91c1d77,0x70580182,0x9f40012b}},	//   unaa, _rižo, _найр_, ewkä_, 
   {{0x6d4c1d78,0x4ea41d79,0xc0d80020,0x86480020}},	// [1890] rnaa, _орна, ርኦም_, _ዝዕንድ, 
   {{0x6d4c1d7a,0xdb14029f,0x69c41d7b,0xa91c0091}},	//   snaa, nsyè, trhe, _pižo, 
   {{0x6d4c1d7c,0x65680080,0x7c24074e,0x705402ac}},	//   pnaa, yleh, ayir, _زنگا, 
   {{0x69c41d7d,0x7c241d7e,0x6b9c02d4,0x6d4c1d7f}},	//   rrhe, byir, _ttsg, qnaa, 
   {{0x0664046d,0x7c2404f8,0x7c841d80,0xdb14029f}},	//   ﺴﯩﻨﯩ, cyir, _ауре, ksyè, 
   {{0x65680c12,0x96d8025c,0xc6a4018f,0x00000000}},	//   wleh, प्लॉ, фрди, --, 
   {{0x65681d81,0xf3880710,0xd5ac04bb,0x00000000}},	//   tleh, _gợi_, مہٕ_, --, 
   {{0xa5641d82,0x96640020,0x00000000,0x00000000}},	//   رگان, _ምንጽጻ, --, --, 
   {{0x13e41d83,0x65681d84,0xa3c00d54,0xc764006e}},	//   емый_, rleh, ौंध_, _قائى, 
   {{0x65681d85,0x69c00b2f,0xe3b001e0,0x00000000}},	//   sleh, _åles, پرک_, --, 
   {{0x21681d86,0x00000000,0x00000000,0x00000000}},	//   зини_, --, --, --, 
   {{0x7c2403af,0x61241d87,0xdce401d3,0x00000000}},	//   yyir, _kóli, _vikī, --, 
   {{0x44241d88,0x61240984,0x64bc00b3,0xf3f41d89}},	//   _تراف, _jóli, ोलीश, _аңы_, 
   {{0x7c2413e8,0x44e80252,0xd1b8001d,0x00000000}},	//   vyir, কাওক_, ዳለች_, --, 
   {{0xdd901d8a,0x3d28066c,0x82341d8b,0x00000000}},	//   اور_, وتری_, _ترشا, --, 
   {{0x7c240403,0xaadc00bd,0x46dc064c,0x00000000}},	//   tyir, न्सक, प्तह, --, 
   {{0xf3880014,0x9b880a23,0x9b041d8c,0x7c240266}},	// [18a0] _sợi_, سنال_, нзад, uyir, 
   {{0x38e8011a,0x7c2400b8,0x61241caf,0x00000000}},	//   _ལིངྒ, ryir, _sólh, --, 
   {{0x7c241d8d,0xdddc002f,0x28d003ef,0xda641d8e}},	//   syir, _wypł, _हाशि, راطي, 
   {{0x61241d8f,0x59d006fa,0xd7f81d90,0x7c240593}},	//   _bóli, दंबर, зук_, pyir, 
   {{0x61241ab0,0xa7fc0191,0xd824006b,0x28d018eb}},	//   _cóli, _szűr, эдди, _हारि, 
   {{0x07a00294,0x2ba803bf,0x00000000,0x00000000}},	//   ћајн, _चौटा, --, --, 
   {{0x60d40034,0x1cdc011a,0x00000000,0x00000000}},	//   _ocym, _ལྡོ_, --, --, 
   {{0x612419b5,0x93a401cf,0x00000000,0x00000000}},	//   _fóli, ншод, --, --, 
   {{0xe970006e,0x84941d91,0x53441d92,0x612400f2}},	//   _ئۇند, رئيس_, ехна, _góli, 
   {{0xa91c14ba,0x60d402b0,0x8d60001d,0x2d8402ba}},	//   _nižj, _acym, _ሰጥተው_, ílez_, 
   {{0x53c01d93,0xa2a000bd,0x00000000,0x00000000}},	//   _शिवश, _गभर्, --, --, 
   {{0xa5c00573,0xb7f40774,0x50641d94,0x62940593}},	//   _төше, _इनाम_, етга, ñzor, 
   {{0x1cdc0037,0xdb140078,0x06641d95,0x03a001c7}},	//   _ལྡེ_, psyè, ﺴﯩﻠﯩ, _бичо, 
   {{0x8460010f,0x4ea41d96,0x00000000,0x00000000}},	//   _ስትሆን_, эрма, --, --, 
   {{0x28d01cd5,0x7dc4018f,0x00000000,0x00000000}},	//   _हालि, лётд, --, --, 
   {{0xa91c0b0a,0xe7f0006c,0x0ed0040e,0x00000000}},	//   _pižm, _आईला_, _तावड, --, 
   {{0x50641d97,0xd24c00e2,0x8f0800fb,0x00000000}},	// [18b0] _ятка, _خنډ_, _ехна_, --, 
   {{0xa91c01f6,0x61240579,0x00000000,0x00000000}},	//   _vižm, _róli, --, --, 
   {{0xa7fc00cd,0x2a840123,0x00000000,0x00000000}},	//   _gyűj, тъаҳ, --, --, 
   {{0x61240270,0x61e40278,0xac941d98,0x00000000}},	//   _póli, _ähle, _шамш, --, 
   {{0x2ca81d99,0x00000000,0x00000000,0x00000000}},	//   mbad_, --, --, --, 
   {{0x2ca81d9a,0x38340551,0x20d80031,0xb8c803bf}},	//   lbad_, ынчр, _išiō_, _ख्_, 
   {{0xf664039c,0x65900296,0x36940200,0x569000db}},	//   лешү, _kāhi, ушіс, шајт, 
   {{0x2ca81d9b,0x61240f34,0x00000000,0x00000000}},	//   nbad_, _tóli, --, --, 
   {{0x65901d9c,0x290c026b,0x44281d9d,0xa6f4005b}},	//   _māhi, _inea_, ác_, _изаш, 
   {{0x2ca80104,0x612400f2,0x24540061,0x066400bf}},	//   hbad_, _jólv, _یناس, _كااپ, 
   {{0xa0a41d9e,0x290c0aa0,0xfdcc02fa,0xe7ec0030}},	//   канд, _knea_, _লন্ড, चौरा_, 
   {{0x65901d29,0xdb140249,0x00000000,0x00000000}},	//   _nāhi, rsyé, --, --, 
   {{0x290c0243,0x2ca81d9f,0xc4440063,0xe35402de}},	//   _mnea_, dbad_, _سیدن_, _иткэ, 
   {{0x54500476,0x0bc800c3,0x2ca80104,0x8fa009ab}},	//   _әвәт, _ﺗﻪﻫﺮ, ebad_, раре, 
   {{0x290c0243,0xbcf001c6,0x2ca80104,0xdcfc004f}},	//   _onea_, koɩt, fbad_, _utpī, 
   {{0xf2880282,0x2ca81da0,0xa91c015b,0x6590004f}},	//   _אָפֿ, gbad_, _dižk, _cāhi, 
   {{0x06640853,0xeb54071e,0xdee001d2,0x00000000}},	// [18c0] ﺴﯩﻤﯩ, گىلگ, _кунi_, --, 
   {{0x290c13e3,0x2ca81da1,0x00000000,0x00000000}},	//   _anea_, abad_, --, --, 
   {{0x3eb81da2,0x2ca81da3,0xabc400ec,0x5974001e}},	//   mart_, bbad_, _ҙарҙ, ҭыҵу, 
   {{0x3eb81da4,0x2ca80177,0xf388000d,0x00000000}},	//   lart_, cbad_, _hợt_, --, 
   {{0x6c7405bc,0x0d200128,0x56900049,0xdb64001d}},	//   _бурх, _түтү, қақт, ዳለውም_, 
   {{0x3eb81da5,0x290c1da6,0x612405c0,0x3e7c012c}},	//   nart_, _enea_, _gólv, cáté_, 
   {{0x7afc1da7,0x612406b4,0x588400b8,0x00000000}},	//   _iart, _hólu, хыҧа, --, 
   {{0x7afc1da8,0x3eb8081d,0xdb140105,0xf3f81bc1}},	//   _hart, hart_, muyñ, ениш_, 
   {{0x3eb81da9,0x17841daa,0x2c0400cb,0x6124020f}},	//   kart_, _агам, रियं_, _jólu, 
   {{0x7afc05bc,0x00000000,0x00000000,0x00000000}},	//   _jart, --, --, --, 
   {{0x2ca80060,0x6d400249,0x00000000,0x00000000}},	//   ybad_, èlak, --, --, 
   {{0x7afc1dab,0xd3c400fc,0x3944015b,0x25a000c0}},	//   _lart, _айдй, _jmms_, íhle_, 
   {{0x65901dac,0x4fc40348,0x7afc1dad,0x628401d5}},	//   _rāhi, ъсна, _oart, _úhon, 
   {{0x3eb81dae,0x63ac1daf,0x0cc803ef,0xdb140105}},	//   gart_, _çana, िल्म, kuyñ, 
   {{0x3944034a,0x65901db0,0x2ca80aa0,0xf388000d}},	//   _omms_, _pāhi, tbad_, _dợt_, 
   {{0xad241db1,0x6124020f,0x2ca80030,0x00000000}},	//   دىرى, _sólv, ubad_, --, 
   {{0x7afc1db2,0x3eb81db3,0x2ca81db4,0x25a8091d}},	// [18d0] _bart, bart_, rbad_, ćali_, 
   {{0x3eb81db5,0x6590004d,0x2ca8017d,0x00000000}},	//   cart_, _wāhi, sbad_, --, 
   {{0x61241db6,0x65900296,0x7afc1db7,0x2ca803f4}},	//   _vólv, _tāhi, _dart, pbad_, 
   {{0xe5a40121,0x612402b2,0x2ca8043b,0xe8581db8}},	//   ңили, _fólu, qbad_, наеш_, 
   {{0x1cdc043b,0xa7e4020d,0x7afc027e,0x6124014e}},	//   _ལྡི_, اكتى, _fart, _tólv, 
   {{0xd1d402b4,0xd7ec13f6,0x00000000,0x00000000}},	//   ካእታ_, سكى_, --, --, 
   {{0x3a8402b3,0x39440207,0xa91c01d4,0x3d08006c}},	//   _вытв, _fmms_, _liži, हाचे_, 
   {{0x3eb81847,0x7afc1db9,0x290c0182,0x612402e8}},	//   zart_, _zart, _unea_, _jólt, 
   {{0xa8541377,0x7afc1dba,0xa91c0ada,0xe3b00272}},	//   _скач, _yart, _niži, حرب_, 
   {{0x316801e8,0x78800192,0x7afc1dbb,0xd7e800cc}},	//   _akaz_, _dívč, _xart, _سومۇ_, 
   {{0x3eb81dbc,0x6ab41dbd,0xe4d40a23,0xa52001ec}},	//   vart_, _mezf, _مقاد, _гүйҗ, 
   {{0xf1a8049d,0x6ab40151,0x672001df,0x46dc00cb}},	//   کایه_, _lezf, _holj, प्रह, 
   {{0xa2e41dbe,0x67201dbf,0xd24c01a0,0x00000000}},	//   _болд, _kolj, قنی_, --, 
   {{0x6ff40560,0x61240191,0xa91c04c6,0x6204004b}},	//   _བརྫུ_, _rólu, _diži, _موتٕ, 
   {{0x67201dc0,0x61241dc1,0x7afc1dc2,0xe4f81dc3}},	//   _molj, _bólt, _rart, ्यपि_, 
   {{0x7afc1dc4,0x5c141dc5,0xdce4004f,0x612400d5}},	//   _sart, льзу, _vikį, _pólu, 
   {{0x3eb81dc6,0x6ab401d4,0x00000000,0x00000000}},	// [18e0] part_, _bezf, --, --, 
   {{0x7afc1dc7,0x3eb8012f,0x4c800833,0xdce400b0}},	//   _qart, qart_, слув, _tikį, 
   {{0x7afc1dc8,0x9d441dc9,0x65901dca,0x18a41dcb}},	//   _vart, _бенд, _kāhu, гаем, 
   {{0x7afc1dcc,0x61241dcd,0x00000000,0x00000000}},	//   _wart, _tólu, --, --, 
   {{0x65901dce,0x1cdc0560,0x23640473,0x6124030f}},	//   _māhu, _ལྡག_, kolj_, _hóls, 
   {{0x65901607,0x7afc0c2f,0x6720018c,0x9f4c01e8}},	//   _lāhu, _uart, _colj, ènèl_, 
   {{0x67201dcf,0xd5641dd0,0x95c8070b,0x3944012b}},	//   _dolj, лтип, хула_, _tmms_, 
   {{0x18680bfb,0x3944014e,0x659000a8,0x00000000}},	//   _заби_, _umms_, _nāhu, --, 
   {{0x67201dd1,0x6d4005cf,0x74541dd2,0x195800bf}},	//   _folj, ūlag, جھائ, _жаңы_, 
   {{0xa3b41dd3,0x67200a67,0x2c0400cb,0xa91c1dd4}},	//   _जबर_, _golj, रितं_, _riži, 
   {{0x6124020c,0x4d7c0041,0x659001d3,0x00000000}},	//   _nóls, _ﺣﺎﯞﯨ, _bāhu, --, 
   {{0x672000e9,0x659001d3,0xa1140411,0xa91c015b}},	//   _zolj, _cāhu, لوپت, _piži, 
   {{0x5edc02fa,0x236407b5,0xc0581dd5,0x0440044a}},	//   য়নে, bolj_, гір_, _лецн, 
   {{0x7f940213,0xa91c01df,0x612403c2,0x6720011a}},	//   сарх, _viži, _bóls, _xolj, 
   {{0x1cdc0002,0x313400fc,0xdddc01d5,0x612402b2}},	//   _ལྡང_, _вейр, _kypř, _pólt, 
   {{0xa12401b5,0x31681dd6,0x0c840152,0x61e4012b}},	//   _نوى۪, _ukaz_, гызм, _ähla, 
   {{0x8aa41dd7,0x70580121,0xfbd001b5,0x00000000}},	// [18f0] гред, _шаир_, ۪تہ_, --, 
   {{0x6124030f,0x00000000,0x00000000,0x00000000}},	//   _fóls, --, --, --, 
   {{0x67201dd8,0x296400ea,0x612400e3,0x00000000}},	//   _rolj, لیسۍ_, _góls, --, 
   {{0x67201dd9,0x2738000b,0xcc840122,0xf7840012}},	//   _solj, _kèng_, _مۆزه_, ۅلنَ, 
   {{0x67200406,0x00f80100,0xc7c4001e,0x9cd400ca}},	//   _polj, טזאם_, усеи, _דורה_, 
   {{0x2738000b,0x637c0249,0x28d00802,0x00000000}},	//   _mèng_, mèng, _हाकि, --, 
   {{0x67201dda,0x23640f68,0xf044001d,0x00000000}},	//   _volj, volj_, _የኦሊም, --, 
   {{0xa5241ddb,0xdddc01d5,0x64a40c8e,0xf60802cf}},	//   рмид, _cypř, јапа, اتوه_, 
   {{0xc0ec0422,0x65900ad8,0x68e81ddc,0x67201ddd}},	//   _ቅዳሴ_, _rāhu, _ibed, _tolj, 
   {{0x24a40012,0x48ec00bd,0x00000000,0x00000000}},	//   دٕکِ, ीएको_, --, --, 
   {{0xf7701dde,0x65900296,0x26c401c6,0x27ec01ab}},	//   _راك_, _pāhu, _idlo_, _hpen_, 
   {{0x3e7c00d3,0x05840cde,0x00000000,0x00000000}},	//   _látí_, _сузм, --, --, 
   {{0x68e81ddf,0x61241de0,0x23640106,0xa0740200}},	//   _mbed, _sóls, polj_, рынш, 
   {{0x2738000b,0x61240cb6,0xdb140139,0x765802a0}},	//   _dèng_, _póls, luyö, _çayç, 
   {{0xa0a41de1,0x63a81de2,0x6590004d,0x91e00b61}},	//   _кайд, lpen, _tāhu, _доще, 
   {{0xf38801c0,0x63a81de3,0x27ec1de4,0x216800bf}},	//   _hợp_, open, _open_, _шийи_, 
   {{0x5bc403c4,0x4d600302,0xa3a8006c,0x00000000}},	// [1900] شقال, ікув, गीच_, --, 
   {{0x63a81de5,0xed5802dc,0x61e002bb,0x4aa4044a}},	//   ipen, воӣ_, otll, икун_, 
   {{0x27ec1de6,0x61e01de7,0xeb740007,0x63a81de8}},	//   _apen_, ntll, сытэ, hpen, 
   {{0x57a41de9,0x76000191,0x26c41dea,0x637c04c3}},	//   ашка, házá, _adlo_, lènd, 
   {{0x25a402ba,0x760000aa,0x2738001c,0x63a8084f}},	//   _atll_, kázá, _xèng_, jpen, 
   {{0x68e80a9a,0x73d801d9,0x00000000,0x00000000}},	//   _ebed, ҳдир_, --, --, 
   {{0x291c0197,0x27ec018c,0xec340061,0xceb0023c}},	//   bjwa_, _epen_, _نوێگ, חיו_, 
   {{0x68e80223,0x73d801d9,0x75d401ac,0x25a002cc}},	//   _gbed, гдир_, ليڪا, íhla_, 
   {{0x07a01deb,0x63a81dec,0x27e81ded,0xc7a01dee}},	//   _матн, gpen, çant_, _митк, 
   {{0x27380249,0xa91c01df,0x68e81def,0x00000000}},	//   _rèng_, _dižu, _zbed, --, 
   {{0x63a8000b,0x00000000,0x00000000,0x00000000}},	//   apen, --, --, --, 
   {{0x94841df0,0x73341df1,0x6124020f,0xed000143}},	//   _кылд, _گىتا, _sólr, _এক্স_, 
   {{0x6124000f,0xb4c41df2,0x93240cca,0x00000000}},	//   _cólq, ौली_, _پرشن, --, 
   {{0x7334006e,0x637c005e,0x00000000,0x00000000}},	//   _دىتا, gènd, --, --, 
   {{0x637c0249,0x00000000,0x00000000,0x00000000}},	//   wèng, --, --, --, 
   {{0x637c0249,0xdedc0020,0x61340023,0x00000000}},	//   tèng, ንትኻ_, kšly, --, 
   {{0xe4f81113,0x7bc00034,0x6fbc025c,0x00000000}},	// [1910] ्यति_, _æmul, _्टिं, --, 
   {{0x8aa41df3,0xf00402dc,0x637c0324,0x612402b2}},	//   ррад, _кӯҳи, rèng, _hólp, 
   {{0x63a805bc,0x27ec0d13,0x291c1df4,0xc9841df5}},	//   zpen, _spen_, tjwa_, ауди, 
   {{0x63a81df6,0x637c1df7,0xe6181df8,0x27381df9}},	//   ypen, mène, ғди_, _mène_, 
   {{0x63a81dfa,0x6d4c1dfb,0x291c04cd,0x637c014a}},	//   xpen, miaa, rjwa_, lène, 
   {{0x6d4c1dfc,0x220002b1,0x6aa8059c,0x00000000}},	//   liaa, nçhá_, _şeff, --, 
   {{0x291c00ec,0x6d4c018c,0xda6c00dd,0xf38801eb}},	//   pjwa_, oiaa, _ٻڏل_, _rợp_, 
   {{0x68e81dfd,0x6d4c0e92,0x63a81dfe,0x34f00121}},	//   _ubed, niaa, tpen, җҗәт, 
   {{0xe2981dff,0x63a81e00,0x6d4c03e6,0x637c0045}},	//   лап_, upen, iiaa, hène, 
   {{0x6d4c00b6,0x63a81e01,0x05140143,0x2cb81e02}},	//   hiaa, rpen, ়সের_, _lesd_, 
   {{0x63a81e03,0x22480acc,0xd00401c4,0x6d4c1e04}},	//   spen, упни_, ҙере_, kiaa, 
   {{0x6d4c1e05,0x00000000,0x00000000,0x00000000}},	//   jiaa, --, --, --, 
   {{0x6d4c1e06,0x6568008b,0xd49400ca,0xb7bc00c3}},	//   diaa, moeh, _הכנת_, ﻧﻴﺎﻏ, 
   {{0x2cb80151,0x65681e07,0xe2c817ae,0x00000000}},	//   _aesd_, loeh, _صوبو_, --, 
   {{0x443c1e08,0xfe780340,0x6d4c1e09,0x637c1e0a}},	//   lzu_, рүн_, fiaa, gène, 
   {{0xe0d806d4,0x443c01aa,0xe6d80f34,0x612400f2}},	//   _сви_, ozu_, _áræð, _gólp, 
   {{0x443c1e0b,0x28d00cf8,0x2cb804ac,0xdd100560}},	// [1920] nzu_, _हाजि, _desd_, _iżżu, 
   {{0x65681e0c,0x443c01aa,0x5a9402dc,0x6c54021d}},	//   hoeh, izu_, сраф, іттє, 
   {{0x65680321,0x2f5401f5,0x637c014a,0x6d4002b1}},	//   koeh, _єтьс, cène, ëlac, 
   {{0x6d4c1526,0xdef800b8,0x00000000,0x00000000}},	//   ciaa, _рыҩ_, --, --, 
   {{0x7d041e0d,0x443c1e0e,0xdb0801ca,0x00000000}},	//   mdis, jzu_, ánói, --, 
   {{0x7d041e0f,0x443c1e10,0x057001d0,0xdcfc015b}},	//   ldis, dzu_, ۋايد, _tupē, 
   {{0x98a41dcb,0xd5e803a2,0x7d041e11,0x443c1e12}},	//   _гибе, اعتن_, odis, ezu_, 
   {{0x7d041e13,0x741409c1,0xa91c00e0,0x65681e14}},	//   ndis, قوبا, _dižs, goeh, 
   {{0x7d041e15,0x1cdc043b,0x27380078,0xdc38021d}},	//   idis, _ལྡབ_, _sène_, кцiї_, 
   {{0x7d0406ea,0x612403e2,0xdb10012b,0x00000000}},	//   hdis, _sólp, _ügär, --, 
   {{0x443c02ba,0x65680249,0xaadc0477,0x00000000}},	//   azu_, boeh, न्टक, --, 
   {{0x637c029f,0x7d041e16,0x25b40012,0x6d4c018c}},	//   vène, jdis, _بۆٹھ_, xiaa, 
   {{0x7d041e17,0x8500049d,0x50641e18,0x6d4c1e19}},	//   ddis, _روون, стна, viaa, 
   {{0x2738052b,0x7d0403af,0x32380020,0x637c01e8}},	//   _tène_, edis, _ብጉልባ, tène, 
   {{0x8d741e1a,0x6d4c02eb,0x798006e2,0xabcc01d2}},	//   مارا, tiaa, _ohmw, _ﯗﻗﻘﺎ, 
   {{0x7d041e1b,0x637c0670,0x717401ac,0x00000000}},	//   gdis, rène, _ڏهڪا, --, 
   {{0x6d4c1e1c,0xfd440023,0x2cb800e3,0x00000000}},	// [1930] riaa, чэрн, _vesd_, --, 
   {{0x6d4c1e1d,0x7d041e1e,0x798002b0,0x637c00cc}},	//   siaa, adis, _ahmw, mènc, 
   {{0x443c1e1f,0x637c0340,0xac941e20,0x7d041e21}},	//   zzu_, lènc, _манш, bdis, 
   {{0x7d0401c6,0x6d4c012e,0x2cb8011a,0x443c1e22}},	//   cdis, qiaa, _uesd_, yzu_, 
   {{0xe4f80828,0x637c0128,0xf9901e23,0x00000000}},	//   ्यसि_, nènc, ربم_, --, 
   {{0x443c1e24,0x65681e25,0xd5ac0012,0x16a4021d}},	//   vzu_, woeh, چہٕ_, овши_, 
   {{0xf77017ab,0xd5ac0d07,0x65681e26,0x253800b7}},	//   راه_, نہٕ_, toeh, ичиќ_, 
   {{0x443c05bc,0x63ac0333,0x67d400cc,0x00000000}},	//   tzu_, _çank, _мобу, --, 
   {{0xa444006e,0x6568061a,0x51a0024b,0x00000000}},	//   юнид, roeh, _ﺍﻟﺨﻁ_, --, 
   {{0x1cdc074c,0x637c0340,0x7d040475,0x00000000}},	//   _ལྡན_, dènc, zdis, --, 
   {{0x7d041e27,0x443c002f,0xb5940116,0xa7fc01b8}},	//   ydis, szu_, _еихш, _gyűr, 
   {{0x21681e28,0x20881e29,0x798002b0,0xdd0c012b}},	//   рими_, ийни_, _xhmw, dışb, 
   {{0x637c00e7,0x7d041e2a,0x8ee00143,0x83a80027}},	//   gènc, vdis, য়নগ, _стеб_, 
   {{0x6d5c0209,0x7d041e2b,0xfe78157e,0x179800ca}},	//   _ajsa, wdis, йүп_, יישב, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2fcc1e2c,0x7d041e2d,0x637c0249,0x3ba4001e}},	//   šega_, udis, bènc, злаҳ, 
   {{0x637c0340,0x6e20020c,0x6d4003f4,0x4dc01d95}},	// [1940] cènc, ølbr, ëlaa, ﺭﮔﯩﻨ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7d040308,0x09e0021c,0x00000000,0x00000000}},	//   pdis, дохн, --, --, 
   {{0x7d040d07,0x1d081e2e,0x00000000,0x00000000}},	//   qdis, _теми_, --, --, 
   {{0x38601e2f,0xd6d802dc,0x6aa802a0,0x09e40143}},	//   çir_, атй_, _şefe, ফিগা, 
   {{0xcb240046,0xd7780020,0x7bc4028d,0x38600037}},	//   _وړلو_, _ፖሊቲካ_, msiu, ħir_, 
   {{0x98a400df,0x00000000,0x00000000,0x00000000}},	//   _миве, --, --, --, 
   {{0x38c8009d,0x7bc41e30,0x1c0c1e31,0x738800fc}},	//   _داسی_, osiu, सिपल_, әриң_, 
   {{0x7bc41e32,0x799c1e33,0x74140272,0x39b80034}},	//   nsiu, _hurw, سودا, lōs_, 
   {{0x799c1e34,0xa3280105,0x637c00e7,0x12880668}},	//   _kurw, _p葵ac, vènc, ищни_, 
   {{0x799c1e35,0xd25800fc,0x4b780100,0x00000000}},	//   _jurw, рцп_, שטיג, --, 
   {{0x09cc0301,0x799c1e36,0x637c00e7,0x7bc41e37}},	//   _রহমা, _murw, tènc, ksiu, 
   {{0x7bc40008,0x6e941e38,0x00000000,0x00000000}},	//   jsiu, зигу, --, --, 
   {{0x799c147c,0x637c03c4,0x00000000,0x00000000}},	//   _ourw, rènc, --, --, 
   {{0x637c0340,0x799c1e39,0x7bc41e3a,0x63ac0126}},	//   sènc, _nurw, esiu, _ħani, 
   {{0x463800cf,0x00000000,0x00000000,0x00000000}},	//   בעלע, --, --, --, 
   {{0x7bc41e3b,0x799c02b0,0x637c0249,0x00000000}},	// [1950] gsiu, _aurw, lèna, --, 
   {{0x799c1e3c,0x7ff414c7,0x9f4001d4,0x00000000}},	//   _burw, _آسيا, ytké_, --, 
   {{0x7bc41e3d,0x799c0086,0x637c0249,0xb17c0237}},	//   asiu, _curw, nèna, ntĥo, 
   {{0x799c1e3e,0xc9841e3f,0x6d5c00f2,0x00000000}},	//   _durw, цузи, _ujsa, --, 
   {{0x2d88165f,0xd90c0191,0x799c1e40,0x6f04015e}},	//   mmae_, ھیے_, _eurw, _kahc, 
   {{0x27380078,0x799c01ab,0x2d881e41,0x6f0400b0}},	//   _bèna_, _furw, lmae_, _jahc, 
   {{0x6b9c1e42,0x799c1e43,0x6f040380,0x7f3c007c}},	//   _husg, _gurw, _mahc, שעוו, 
   {{0x69c41e44,0x6aa41e45,0x6b9c1e46,0xe3b81e47}},	//   mshe, lchf, _kusg, бби_, 
   {{0x69c40437,0x67d41e48,0x1c0c1e49,0x6b941b63}},	//   lshe, _хозу, सियल_, _kizg, 
   {{0x6f040085,0x69c41e4a,0x46681e4b,0x2d880337}},	//   _nahc, oshe, _крем_, hmae_, 
   {{0x69c41e4c,0x637c1e4d,0x6b941e4e,0x6aa41e4f}},	//   nshe, gèna, _mizg, ichf, 
   {{0x7bc41e50,0x293400cf,0x00000000,0x00000000}},	//   ysiu, פאָן_, --, --, 
   {{0x2ee00197,0x6f041e51,0x6b9c01ec,0x69c41e52}},	//   _bchf_, _bahc, _nusg, hshe, 
   {{0xdd900046,0x53980107,0x00000000,0x00000000}},	//   ځوس_, _פיצו, --, --, 
   {{0x6b9c1e53,0x69c41e54,0x6f04028b,0xdddc00ce}},	//   _ausg, jshe, _dahc, _izpū, 
   {{0xf1a802a5,0x6b9c1e55,0x7bc41e56,0x6b940059}},	//   _باوه_, _busg, tsiu, _aizg, 
   {{0xd00c1e57,0x69c41e58,0x6b9402ac,0x6b9c1e59}},	// [1960] _ملي_, eshe, _bizg, _cusg, 
   {{0x7bc41e5a,0x799c1e5b,0x6b941e5c,0x69c41e5d}},	//   rsiu, _purw, _cizg, fshe, 
   {{0x7bc41e5e,0x69c41e5f,0xdca41e60,0x6bd41cb3}},	//   ssiu, gshe, _нани, كتەر, 
   {{0x7bc41e61,0x68f80c12,0x6aa41e62,0x59d003ea}},	//   psiu, gewd, achf, दूगर, 
   {{0x69c41e63,0x6b9c1e64,0x6b940181,0x799c152c}},	//   ashe, _gusg, _fizg, _wurw, 
   {{0x799c1e65,0x69c41e66,0x47300302,0xd5b81e67}},	//   _turw, bshe, нніс, бси_, 
   {{0x799c1e68,0x69c41e69,0x20bc022d,0x00000000}},	//   _uurw, cshe, ्णाध, --, 
   {{0x660001d4,0x18a4070b,0x6b94018f,0x637c01e8}},	//   _dslk, _хаам, _zizg, vèna, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x637c065e,0x88380240,0xe728009d,0xdcfc00b0}},	//   tèna, _התמו, _وسلو_, _tupė, 
   {{0xb9e4078c,0x25700340,0x2d880034,0x22a002b2}},	//   _ከኣ_, رۇۇس, ymae_, _sækó_, 
   {{0x27380078,0x8678007c,0xd1381e6a,0x6f040380}},	//   _jènn_, _פראו, схо_, _sahc, 
   {{0xcfa41198,0x6f040140,0x637c0249,0x6aa40335}},	//   яшни, _pahc, sèna, ychf, 
   {{0x69c41e6b,0x6b9c1e6c,0x637c1e6d,0x2d880086}},	//   yshe, _rusg, pèna, wmae_, 
   {{0x6f040008,0x6b9c1e6e,0x69c40060,0x6b940222}},	//   _vahc, _susg, xshe, _rizg, 
   {{0x6b9404e7,0x6b9c00d4,0x70581b48,0x69c40056}},	//   _sizg, _pusg, _майр_, vshe, 
   {{0xfe70063a,0x69c41e6f,0x2d881e70,0x81380256}},	// [1970] ندہ_, wshe, rmae_, _ءسىز_, 
   {{0x69c41e71,0x6b9401a0,0x2d880034,0x00000000}},	//   tshe, _qizg, smae_, --, 
   {{0x6aa41e72,0xac980200,0xdb241e73,0x637c000b}},	//   rchf, _وندا_, بولی, kènn, 
   {{0x69c41e74,0x6aa41e75,0x66000308,0x6b9c1e76}},	//   rshe, schf, _rslk, _tusg, 
   {{0x68f81e77,0x69c41e78,0xfc641166,0x6b941e79}},	//   rewd, sshe, _зърн, _tizg, 
   {{0x69c41e7a,0x76c400c3,0x00000000,0x00000000}},	//   pshe, ىغىل, --, --, 
   {{0x76c402ac,0xb4e80030,0x69c40002,0x2c040095}},	//   رغول, यभू_, qshe, रिकं_, 
   {{0x61e401ec,0xbe3c0107,0xa4f8006c,0x38c80094}},	//   _ähli, מעות, ्येच_, _нуун_, 
   {{0xd85400bf,0x00000000,0x00000000,0x00000000}},	//   _жетө, --, --, --, 
   {{0x45a0086b,0x644c0007,0xd34403b5,0x00ac00c3}},	//   _كەتك, _žais, وینه_, _ﺳﯩﺴﺘ, 
   {{0xa51c0007,0x77640128,0x63ac0002,0x8ee00143}},	//   _вялi, éixe, _ħanu, য়াগ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2e40d82,0x00000000,0x00000000,0x00000000}},	//   _жолд, --, --, --, 
   {{0xb37c02b4,0xdddc00ce,0x33940027,0x00000000}},	//   _ብብዙሕ_, _uzpū, _зачё, --, 
   {{0x1b0400ac,0x2fc8042e,0x1d08023f,0xd24c00dd}},	//   রামে_, _evag_, оеви_, _پني_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9b041e7b,0xc0ec010f,0x273800f1,0x1f6401d9}},	// [1980] мзад, _ቅዳሜ_, _rènn_, _оким, 
   {{0x27380078,0x4c80023f,0x98a00386,0x4cb80143}},	//   _sènn_, тлув, _ıkı_, ইলগু, 
   {{0x9d441e7c,0x63500192,0x00000000,0x00000000}},	//   _женд, měně, --, --, 
   {{0x312000cb,0x00000000,0x00000000,0x00000000}},	//   यायः_, --, --, --, 
   {{0xc7a01e7d,0x07a01e7e,0x20100139,0x00000000}},	//   вичк, вачн, _jryi_, --, 
   {{0x3ce01e7f,0x764400b8,0xf1c002d9,0x00000000}},	//   lgiv_, нҭза, úšky_, --, 
   {{0x8a001e80,0x312000cb,0xda70004b,0xdedc010f}},	//   _изре, यामः_, _شُر_, ንስና_, 
   {{0x3ce01e81,0x18681e82,0x00000000,0x00000000}},	//   ngiv_, _даби_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2e44038a,0x00000000,0x00000000,0x00000000}},	//   _jëfé_, --, --, --, 
   {{0x2fc81e83,0x333c0306,0xcad400ca,0x612400d5}},	//   _svag_, _vlvx_, ווית_, _hóly, 
   {{0x92bc0301,0x91481e84,0xae0c00a1,0xd084012b}},	//   ইলে_, ічна_, हिसन_, дыги, 
   {{0xb3e8043b,0xf6ec0126,0x54341e85,0x534400fb}},	//   _འདྲུ, _ལྡོང, _ترار, _охка, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x20100080,0x7f941e86,0x00000000,0x00000000}},	//   _eryi_, тарх, --, --, 
   {{0x2fc801d3,0x00000000,0x00000000,0x00000000}},	//   _tvag_, --, --, --, 
   {{0x63ac1e87,0xc0dc0090,0x628401d4,0xcfa80061}},	// [1990] _çant, ንንም_, _úhor, _بابم_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd364024c,0xbdf80e14,0x00000000,0x00000000}},	//   _ڕه_, _کریا_, --, --, 
   {{0x2ca81e88,0xd6cc1e89,0x2d98000b,0x9cd4023c}},	//   mcad_, ڭقى_, _iise_, _אורה_, 
   {{0x6d90018b,0x2ca80012,0xd7041e8a,0x80380100}},	//   _sťah, lcad_, енше_, ונדע_, 
   {{0x2d981e8b,0x249c02b4,0xdac40121,0x2ca804ac}},	//   _kise_, _ቀዳሞት_, _سېنى_, ocad_, 
   {{0x2d9802bb,0x92bc0143,0x1b040143,0xe2980123}},	//   _jise_, ইলো_, রাণে_, ӯаи_, 
   {{0x2d981e8c,0xe4581e8d,0x92bc007e,0x64a40116}},	//   _mise_, яжи_, ইলৈ_, _ҟала, 
   {{0x2d981e8e,0x2ca8028b,0xd7640124,0x00000000}},	//   _lise_, hcad_, _كەنى_, --, 
   {{0x78a41e8f,0x2d981e90,0xf7480046,0xb38c0020}},	//   žive, _oise_, _تللي_, _መኣዝን_, 
   {{0x2d981e91,0xa0680294,0xdedc1e92,0x6d9000c0}},	//   _nise_, зама_, ንድን_, _uťah, 
   {{0xa0341e93,0x4fa01320,0x1b0402fa,0x2ca81e94}},	//   رىست, лияв, রাতে_, dcad_, 
   {{0x03640012,0xf36401c4,0x00000000,0x00000000}},	//   _تٔتی_, _үтән, --, --, 
   {{0x2d981e95,0xa4fc0126,0x637c0249,0x2ca8028b}},	//   _bise_, _དྲོག_, nènm, fcad_, 
   {{0x71580256,0x2d981e96,0x2ca8028b,0x00000000}},	//   _орыс_, _cise_, gcad_, --, 
   {{0x2d981e97,0x26000098,0x3ce01e7f,0x00000000}},	// [19a0] _dise_, _वैसी_, rgiv_, --, 
   {{0x2d981e98,0x2ca80060,0x612402b2,0x00000000}},	//   _eise_, acad_, _róly, --, 
   {{0x533400b9,0x795403b5,0x2d981e99,0x2ca8028b}},	//   ענען_, نێسا, _fise_, bcad_, 
   {{0x60c41e9a,0x97c41e9b,0x2d98175c,0x58841e9c}},	//   nakm, ейде, _gise_, ныла, 
   {{0xa4fc043b,0xd4981abc,0xc8c41e9d,0x2c000108}},	//   _དྲེག_, үри_, روون_, _күтм, 
   {{0x2d981e9e,0xd5b81829,0x60c41e9f,0xd4980123}},	//   _zise_, пси_, hakm, ӯри_, 
   {{0xceb0033c,0x2d981ea0,0x60c40243,0x6ff40126}},	//   ניה_, _yise_, kakm, _བརྐུ_, 
   {{0x59741ea1,0x38c81ea2,0x2d980087,0x60c41ea3}},	//   _чыгу, _زاری_, _xise_, jakm, 
   {{0x75d41ea4,0x60c41ea5,0x7c2403b2,0x12e401b2}},	//   ريکا, dakm, nxir, нінг, 
   {{0x637c1ea6,0x63800116,0x00000000,0x00000000}},	//   lènj, аҳча, --, --, 
   {{0x60c401c6,0xd2581ea7,0x362400d5,0xd34401d9}},	//   fakm, яци_, _جواہ, ویچه_, 
   {{0x60c41ea8,0x00000000,0x00000000,0x00000000}},	//   gakm, --, --, --, 
   {{0x2d981ea9,0xb4040155,0x5eb00143,0xb4bc1eaa}},	//   _rise_, _рӯйд, _জয়ে, अरी_, 
   {{0x2d980528,0xf0b000d5,0xae0c0608,0x00000000}},	//   _sise_, دیکھ, हिलन_, --, 
   {{0x2d981eab,0xf8d000b3,0x60c401e8,0x87780100}},	//   _pise_, हणाय, bakm, פאלי, 
   {{0x51840b2e,0x0320078e,0xad24006e,0x30140329}},	//   _яула, _адән, خىرى, _адир, 
   {{0x2d981eac,0x2ca801b5,0x863c1ead,0x00000000}},	// [19b0] _vise_, rcad_, ባልነት, --, 
   {{0x2d981eae,0x659000a8,0x2ca8006a,0x3eb400c0}},	//   _wise_, _dāhy, scad_, čatí_, 
   {{0x2d980078,0x412404e7,0x70541eaf,0x7c240d8c}},	//   _tise_, _شفیق, _سنگا, axir, 
   {{0x637c0cc9,0x2d9805d9,0x6c54150f,0xe8580deb}},	//   vènm, _uise_, _акму, маеш_, 
   {{0x66e41eb0,0x27e81402,0x7c8405c8,0x00000000}},	//   вола, îan_, _буре, --, 
   {{0x63ac0237,0x9ba000c3,0x637c01e8,0x00000000}},	//   _ɩand, _ئەلى, tènm, --, 
   {{0xa4fc1c98,0xa5c40087,0x7764000f,0xff1800ca}},	//   _དྲུག_, төзе, éixa, תקות_, 
   {{0x200003ef,0xd90c01ac,0xf9880200,0x799400b7}},	//   ywki_, _وڌن_, _كەلۋ_, _бисф, 
   {{0x78a402db,0x60c4018c,0xc76400c3,0x80b00388}},	//   živc, vakm, _كائى, ंडसे, 
   {{0x7bc00475,0xdedc001d,0x00000000,0x00000000}},	//   _çmue, ንድና_, --, --, 
   {{0x21681eb1,0x60c41eb2,0x61441eb3,0xf6ec0126}},	//   дини_, takm, вена, _ལྡིང, 
   {{0x35f81eb4,0x6aa810ad,0x25a000c0,0x00000000}},	//   _سرمد_, _şefl, íhlu_, --, 
   {{0x60c41eb5,0x7c240dbc,0x00000000,0x00000000}},	//   rakm, xxir, --, --, 
   {{0x22141eb6,0xf1a80122,0x6448002a,0xd24c1719}},	//   _афир, بایه_, mzei, _ژنو_, 
   {{0x644803c8,0x60c41eb7,0x659001d3,0x00000000}},	//   lzei, pakm, _sāhy, --, 
   {{0x7c240182,0x6590004f,0x8d600320,0xdcf400e5}},	//   txir, _pāhy, авсе, plyč, 
   {{0x64480602,0x9f8407f9,0x5f741eb8,0xdb0400e3}},	// [19c0] nzei, _игид, _لادر, _atká, 
   {{0x64480602,0x7c241eb9,0x0b400087,0x5f741eba}},	//   izei, rxir, анун, _جابر, 
   {{0x644806ef,0xdd881ebb,0x5a9418d9,0x00000000}},	//   hzei, _обод_, траф, --, 
   {{0xd7f803c4,0x7c24004e,0xdca40ab4,0x5ca4039c}},	//   дук_, pxir, _шами, _шимб, 
   {{0x87e00ad2,0x48e01ebc,0x00000000,0x00000000}},	//   ающе, рочв, --, --, 
   {{0x64480104,0x00000000,0x00000000,0x00000000}},	//   dzei, --, --, --, 
   {{0xd5640121,0x6448002a,0x74541ebd,0x00000000}},	//   ктип, ezei, گھائ, --, 
   {{0x644806ef,0x00000000,0x00000000,0x00000000}},	//   fzei, --, --, --, 
   {{0x06801ebe,0x644803c8,0x312000cb,0x33741ebf}},	//   лгән, gzei, यासः_, лгир, 
   {{0x60c00237,0x81a802fa,0x87b40107,0x8c40012b}},	//   _ĵoma, গঠন_, _סלבס_, _öşeg, 
   {{0x55041ec0,0x46a002dc,0xd7640128,0xd7d000bd}},	//   _ачла, _тахв, _كەچى_, _सिँच, 
   {{0x51841ec1,0x64480e48,0x50640182,0x00000000}},	//   ђуна, bzei, втга, --, 
   {{0x93441ec2,0xe8140227,0x00000000,0x00000000}},	//   _инде, ढिया_, --, --, 
   {{0xc0ec010f,0x8d7400cc,0x91e001c4,0x704400bf}},	//   _ህዳር_, چارا, _кәмһ, _ەردە, 
   {{0x8d741ec3,0x00000000,0x00000000,0x00000000}},	//   نارا, --, --, --, 
   {{0xd7d00203,0x4ee002fa,0x00000000,0x00000000}},	//   _सिंच, য়েল, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [19d0] --, --, --, --, 
   {{0x16001ec4,0x31200095,0xaa94018f,0x00000000}},	//   लबार_, यावः_, гизч, --, 
   {{0x64480c73,0x00000000,0x00000000,0x00000000}},	//   zzei, --, --, --, 
   {{0x61e401c5,0x00000000,0x00000000,0x00000000}},	//   _åhle, --, --, --, 
   {{0x07e40049,0x00000000,0x00000000,0x00000000}},	//   тцем, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x78a40b53,0xd7640256,0xa3e400b3,0x3a980254}},	//   živa, دەلى_, बून_, _акрэ_, 
   {{0x2408163b,0x64480a79,0x637c1ec5,0xf8e402be}},	//   ении_, tzei, mèni, _ەسەپ, 
   {{0x290c1ec6,0x68e81ec7,0xdb1400df,0xdbd00e48}},	//   _iaea_, _iced, hsyý, _müßt, 
   {{0x64481ec8,0x290c1ec9,0x386001ca,0x00000000}},	//   rzei, _haea_, úire_, --, 
   {{0x64481eca,0x290c1ecb,0x26c401c6,0x637c0249}},	//   szei, _kaea_, _ielo_, nèni, 
   {{0x26c41ecc,0x71241df1,0x68e8011a,0xf644070b}},	//   _helo_, لىپم, _jced, _тхун, 
   {{0x26c41ecd,0x25a41ece,0x290c08ff,0x68e801e7}},	//   _kelo_, _hull_, _maea_, _mced, 
   {{0x25a41ecf,0x26c41ed0,0x290c1ed1,0x8fa01ed2}},	//   _kull_, _jelo_, _laea_, саре, 
   {{0x26c41ed3,0x290c00ec,0x68e8071c,0x63a81ed4}},	//   _melo_, _oaea_, _oced, lqen, 
   {{0x68e8009d,0x26c411e2,0x61e01ed5,0x25a41ed6}},	//   _nced, _lelo_, mull, _mull_, 
   {{0x63a8019b,0x25a401c5,0xdc6801a7,0x00000000}},	// [19e0] nqen, _lull_, хаад_, --, 
   {{0x290c008b,0x68e81ed7,0x26c41ed8,0x25a4034a}},	//   _aaea_, _aced, _nelo_, _oull_, 
   {{0x61e01ed9,0x290c1eda,0x25a41edb,0x637c1edc}},	//   null, _baea_, _null_, gèni, 
   {{0x68e81edd,0x61e0012a,0x290c0086,0xe0e00143}},	//   _cced, iull, _caea_, _বসুন, 
   {{0x26c41ede,0x00000000,0x00000000,0x00000000}},	//   _belo_, --, --, --, 
   {{0x61e01edf,0x26c41ee0,0x290c03f2,0x68e8071c}},	//   kull, _celo_, _eaea_, _eced, 
   {{0x26c41ee1,0x290c14a5,0x25a414cc,0x61e01ee2}},	//   _delo_, _faea_, _cull_, jull, 
   {{0x26c41ee3,0x290c1ee4,0x25a4027e,0xc8e401ac}},	//   _eelo_, _gaea_, _dull_, _مڙهه_, 
   {{0x26c41ee5,0x63a8019b,0x15701310,0x00000000}},	//   _felo_, gqen, _ққиё, --, 
   {{0x25a41ee6,0x26c41ee7,0xd6281ee8,0x7af801e3}},	//   _full_, _gelo_, _позе_, еvti, 
   {{0x61e01ee9,0xdb040573,0xa3e403ef,0x25a41eea}},	//   gull, _itkä, बूब_, _gull_, 
   {{0x94841eeb,0x26c40f29,0x23a800d5,0x00000000}},	//   _йылд, _zelo_, _fúj_, --, 
   {{0x54341eec,0x61e00cfa,0xdce400e0,0xca681033}},	//   _حرار, aull, _dikļ, зiлi, 
   {{0x61e01eed,0x26c403b2,0x733400c3,0x00000000}},	//   bull, _xelo_, _خىتا, --, 
   {{0x25dc00b6,0x00000000,0x00000000,0x00000000}},	//   _गमछी_, --, --, --, 
   {{0x637c1eee,0x704401d2,0x00000000,0x00000000}},	//   vèni, _ەرگە, --, --, 
   {{0xd1f80422,0x6fd81eef,0xde40010f,0x9f400152}},	// [19f0] ዋእቲ_, _भटिं, ከላከል, ftkä_, 
   {{0x39441ef0,0x290c025e,0x68e80614,0xead402c2}},	//   _alms_, _saea_, _sced, рожь, 
   {{0x26c41ef1,0x290c1ef2,0xcbc400e2,0x0a6802dc}},	//   _relo_, _paea_, _څېرو_, храи_, 
   {{0x78a41ef3,0x25a41ef4,0x36e8024b,0x63a804db}},	//   živn, _rull_, ۇرىپ_, yqen, 
   {{0x26c41ef5,0x25a40683,0x290c1ef6,0x61e01ef7}},	//   _pelo_, _sull_, _vaea_, zull, 
   {{0x290c004d,0x61e00ca1,0x68e80083,0x7bc00020}},	//   _waea_, yull, _wced, _çmua, 
   {{0x290c1ef8,0xd5ac0c30,0x25a402bb,0x61e0028b}},	//   _taea_, وفو_, _qull_, xull, 
   {{0x61e01ef9,0x25a40340,0x26c41efa,0x68e81efb}},	//   vull, _vull_, _welo_, _uced, 
   {{0xa8541efc,0x26c41efd,0xa3e41efe,0x80c01eff}},	//   _ткач, _telo_, बंध_, ্লম্, 
   {{0x26c403f2,0x63a802b4,0x23340182,0x5028001d}},	//   _uelo_, rqen, рхир, _ትላላች, 
   {{0xe1241f00,0x61e0012e,0x63a81f01,0x00000000}},	//   амни, uull, sqen, --, 
   {{0x61e01f02,0xa3e40021,0x657802dc,0x63a80140}},	//   rull, बंद_, _ukwh, pqen, 
   {{0x61e01f03,0x31681f04,0x2258002f,0x00000000}},	//   sull, _djaz_, ńsk_, --, 
   {{0x61e01f05,0xd0040294,0xdee40931,0xc58400e2}},	//   pull, јере_, јови, _شپږم_, 
   {{0x61e01f06,0x3f840025,0x00000000,0x00000000}},	//   qull, ēmu_, --, --, 
   {{0xdb140029,0x637c00f1,0x6e200207,0xa2dc03ec}},	//   ppyë, tènw, ålba, पलक्, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1a00] --, --, --, --, 
   {{0xb17c01c6,0x4b2001f1,0x8b201c80,0x00000000}},	//   muĥa, омув, одуе, --, 
   {{0x60d40d92,0xa3e41efe,0x7f5c0105,0x5f440012}},	//   _kdym, बूत_, mirq, _منکل, 
   {{0xd94406d4,0xdb040020,0x7f5c0105,0x11f400cf}},	//   једи, _kukë, lirq, יזעל_, 
   {{0x7d041f07,0x4cb80107,0x9854023f,0x88b001d9}},	//   meis, _בזכו, јтеш, تیقچ, 
   {{0xed58018b,0xdb0402bb,0x73d80375,0x9f400475}},	//   ďže_, _mukë, қдор_, dukë_, 
   {{0x645c0849,0x1c0c0203,0x60d402b0,0x3944015b}},	//   úsin, सिकल_, _odym, _tlms_, 
   {{0x7d041f08,0x44a01001,0x66040d2e,0x7f5c0387}},	//   neis, يمىق, çhka, hirq, 
   {{0x6aa81f09,0x19580200,0x7f5c04db,0x00000000}},	//   _şefi, _заңы_, kirq, --, 
   {{0x7d041f0a,0x1674005b,0x60d41f0b,0xdb041f0c}},	//   heis, _кћер, _adym, _utkä, 
   {{0x7d041f0d,0x321800ef,0x154403a7,0xb15c1f0e}},	//   keis, íry_, _кежм, еннi, 
   {{0x7d04021c,0xdb040222,0xd1381f0f,0x93241f10}},	//   jeis, _bukë, тхо_, ارکن, 
   {{0x7d041f11,0x60d41f12,0x67200010,0xe7e8080a}},	//   deis, _ddym, _ynlj, ﺎﻧﺎﻟ, 
   {{0x932401fa,0xc0580302,0x7f5c02b1,0xdb040475}},	//   _څرګن, рію_, girq, _dukë, 
   {{0x7d041f13,0x637c02ba,0x00000000,0x00000000}},	//   feis, gènu, --, --, 
   {{0x7d041f14,0x6efc02b2,0x00000000,0x00000000}},	//   geis, _bæbæ, --, --, 
   {{0x6e941f15,0x7f5c0d2e,0x6144155a,0x644c0023}},	// [1a10] _گلدا, birq, _دىيە, _žaiz, 
   {{0x78a416e5,0x7c2002db,0x7f5c02b1,0x60d401d5}},	//   živl, _šmrc, cirq, _zdym, 
   {{0x6e941f16,0x637c0249,0xdb0401ab,0x00000000}},	//   _دلدا, mènt, _zukë, --, 
   {{0xd244004b,0x31781f17,0x637c005e,0x7d0401c6}},	//   _ہن_, nosz_, lènt, ceis, 
   {{0xff501f18,0x00000000,0x00000000,0x00000000}},	//   _رخی_, --, --, --, 
   {{0xa3e400d1,0x00000000,0x00000000,0x00000000}},	//   बंस_, --, --, --, 
   {{0xbb5802dc,0xf9d4012b,0x00000000,0x00000000}},	//   _тарх_, _морэ, --, --, 
   {{0xa5241f19,0x637c0249,0x00000000,0x00000000}},	//   смид, hènt, --, --, 
   {{0x142002b3,0x52e00227,0x7f5c0d2e,0xc0ec001d}},	//   здым, पलूस, yirq, _ህዳሴ_, 
   {{0x7d041f1a,0xdddc01d5,0x7f5c0560,0x00000000}},	//   zeis, _expř, xirq, --, 
   {{0x7d041f1b,0xdb041f1c,0xc4cc0191,0x00000000}},	//   yeis, _utkå, _ہےں_, --, 
   {{0x7f5c1f1d,0xdb040475,0x05841f1e,0x7d040139}},	//   wirq, _pukë, _тузм, xeis, 
   {{0x7d041f1f,0xdb040078,0x9f40005e,0x7f5c04db}},	//   veis, _fukè, luké_, tirq, 
   {{0x7d041f20,0x21640087,0x602400b8,0x00000000}},	//   weis, ртүг, _ҳдиа, --, 
   {{0x7d041f21,0xe0600122,0x7f5c0919,0x533001f1}},	//   teis, تێکی, rirq, _хејт, 
   {{0x21f003af,0xed5800f8,0x20c401a0,0xa0580efd}},	//   máh_, ҳоӣ_, _уйим, _مؤخر_, 
   {{0x21f003fa,0x7f5c04db,0xdee401c3,0x00000000}},	// [1a20] láh_, pirq, _лопи, --, 
   {{0x7d041f22,0x9f040046,0x637c1f23,0x7f5c0105}},	//   seis, _اودو, cènt, qirq, 
   {{0x7d041f24,0x99381e84,0x38c81f25,0xd358007c}},	//   peis, ляду_, لاشی_, נדעל, 
   {{0x5824024b,0x29dc02e8,0xf8b8001e,0x00000000}},	//   ймеб, _sáað_, рҩа_, --, 
   {{0x98a400b8,0x9b881f26,0x69c014e4,0x645c1f27}},	//   аиҵе, _منحل_, _çlen, úsil, 
   {{0x21f003af,0x00000000,0x00000000,0x00000000}},	//   káh_, --, --, --, 
   {{0x21f00110,0xceb0129b,0x8f981f28,0x09e01f29}},	//   jáh_, ליג_, ניצי, _норн, 
   {{0x73d81f2a,0x21f003fa,0x948400fc,0xd90c1f2b}},	//   адир_, dáh_, йыпд, _سیت_, 
   {{0x637c01e8,0x51a001d2,0x00000000,0x00000000}},	//   yènt, _ﺍﻟﺘﻁ_, --, --, 
   {{0x870800d5,0x1b040143,0x9f400223,0x00000000}},	//   _معمہ_, রাকে_, buké_, --, 
   {{0x21f003fa,0x637c19ab,0x9f40005e,0x4b78007c}},	//   gáh_, vènt, cuké_, רטיג, 
   {{0x2bd80979,0xd14802ac,0x4a980100,0x00000000}},	//   _ढिला, اشدن_, טייג, --, 
   {{0x7afc1f2c,0x2738052b,0x637c0128,0x00000000}},	//   _obrt, _gèns_, tènt, --, 
   {{0x21f003af,0x11f400e2,0xdce4012b,0x447800cf}},	//   báh_, _هوتک_, _pkkğ, _ענגע, 
   {{0x21f00110,0x637c1f2d,0x7e28075c,0x313400b7}},	//   cáh_, rènt, біта_, _мекр, 
   {{0x78a41f2e,0xa1b40061,0x00000000,0x00000000}},	//   živj, _بجوڵ, --, --, 
   {{0x637c0247,0x00000000,0x00000000,0x00000000}},	// [1a30] pènt, --, --, --, 
   {{0x321c01d4,0x8aa41f2f,0x00000000,0x00000000}},	//   _krvy_, срад, --, --, 
   {{0xc9841f30,0xd7c4006c,0x00000000,0x00000000}},	//   буди, रीसच, --, --, 
   {{0x321c01d5,0x28f80027,0x2c700537,0x00000000}},	//   _mrvy_, редь_, _ẹdun_, --, 
   {{0x6aa80254,0x6d4c0aea,0xa6c81f31,0x63580078}},	//   _şefu, mhaa, алла_, wňnm, 
   {{0x6d4c1f32,0x70b406a7,0x21f00110,0x9f400249}},	//   lhaa, ंडुल, yáh_, tuké_, 
   {{0x21f003fa,0x7f3c0100,0x6d4c0139,0x00000000}},	//   xáh_, רעוו, ohaa, --, 
   {{0xa4440108,0x21f001d4,0x00000000,0x00000000}},	//   жнид, váh_, --, --, 
   {{0x86e81f33,0x38341f34,0x21f003af,0xdb040029}},	//   _معاف_, _ентр, wáh_, _suké, 
   {{0xe1f81f35,0x21f00110,0x9f4001d4,0x00000000}},	//   аго_, táh_, stkú_, --, 
   {{0x6d4c1f36,0x466810b5,0x973000e2,0x00000000}},	//   khaa, _срам_, _تکنا, --, 
   {{0xd24c1f37,0x6b280560,0x21f003fa,0x637c00f1}},	//   خچه_, _ལོའོ_, ráh_, tèns, 
   {{0x6d4c1f38,0x23281f39,0x21f00110,0x656800c0}},	//   dhaa, _воли_, sáh_, mneh, 
   {{0x65681f3a,0xdb040039,0x443c1f3b,0x637c005e}},	//   lneh, _tuké, myu_, rèns, 
   {{0xa3e40267,0xfe7800e7,0x21f003af,0x443c1f3c}},	//   बूर_, сүн_, qáh_, lyu_, 
   {{0x443c01e7,0x6d4c1f3d,0xdb14021c,0x00000000}},	//   oyu_, ghaa, nsyö, --, 
   {{0x443c1f3e,0x66000054,0x5ac81f3f,0x65681f40}},	// [1a40] nyu_, _lplk, илам_, ineh, 
   {{0x443c0130,0x61e0012a,0x6d4c0080,0x5900011a}},	//   iyu_, orll, ahaa, _ཛིངས_, 
   {{0x443c0651,0x5ca41f41,0x9a680272,0x0b140272}},	//   hyu_, _минб, جمال_, تقلة_, 
   {{0x6d4c1f42,0x443c1f43,0x98a41f44,0xd8381f45}},	//   chaa, kyu_, циде, иэл_, 
   {{0xd7081f46,0x18681f47,0x656802d9,0x443c0d2e}},	//   инде_, шади_, dneh, jyu_, 
   {{0x501810bc,0x443c1f48,0x47300c57,0x656806e2}},	//   יונו, dyu_, мніс, eneh, 
   {{0x656803c8,0x00000000,0x00000000,0x00000000}},	//   fneh, --, --, --, 
   {{0x65681f49,0x443c007b,0x05800049,0x00000000}},	//   gneh, fyu_, муым, --, 
   {{0x63ac059b,0x87e40041,0x443c00f2,0xa3e41f4a}},	//   _éanl, _وتكە, gyu_, बूल_, 
   {{0x72d00121,0x32540129,0x321c02d9,0xdb140139}},	//   رەبچ, звор, _prvy_, asyö, 
   {{0x6d4c0fdc,0x443c065b,0x65681f4b,0xc0d80020}},	//   yhaa, ayu_, bneh, _ክኢላ_, 
   {{0x443c025e,0x65681f4c,0xc68c0012,0x3ce403ef}},	//   byu_, cneh, _شِن_, गलों_, 
   {{0x443c0172,0x61e01f4d,0x7c2001d5,0x00000000}},	//   cyu_, arll, _šmrn, --, 
   {{0x6d4c1f4e,0xd14801d9,0x300400b8,0x00000000}},	//   whaa, اشگن_, озҭг, --, 
   {{0xd1c80396,0x6d4c1f4f,0x201c0296,0xca680049}},	//   _тулд_, thaa, ātia_, зiнi, 
   {{0x2afc0979,0x00000000,0x00000000,0x00000000}},	//   र्नु_, --, --, --, 
   {{0xc0d802b4,0xd1480012,0x6b840140,0xc0f40020}},	// [1a50] _ክኢሉ_, _مشکن_, tlhg, ልኦም_, 
   {{0x6d4c1f38,0xe86405bc,0xa0340049,0x656802d9}},	//   shaa, үхдү, _رىپت, zneh, 
   {{0x2fc81f50,0x6d4c158f,0x65680080,0xa8880108}},	//   _hwag_, phaa, yneh, әйла_, 
   {{0x443c1f51,0xa3ac025c,0xf9901f52,0x00000000}},	//   yyu_, कदम_, نبن_, --, 
   {{0x88041f53,0x6d5c1f54,0x6568018b,0x7af0019f}},	//   تظام, _imsa, vneh, äitö, 
   {{0x49b80122,0x39a803b4,0xdc3800ca,0x2c0800d5}},	//   _نارد_, _ağsu_, _העשר, _پٹڑی_, 
   {{0x65681f55,0x443c03c0,0x63b803c7,0x9f400353}},	//   tneh, wyu_, _stwn, rtkø_, 
   {{0x443c0b8e,0x38c81f56,0xd88401b5,0x00000000}},	//   tyu_, _муун_, _کھٔن_, --, 
   {{0x65681f57,0x3f980336,0x443c0088,0x00000000}},	//   rneh, ymru_, uyu_, --, 
   {{0x443c1f58,0x65681f59,0x69c0011a,0xdb14021c}},	//   ryu_, sneh, _ħlej, ssyö, 
   {{0x443c1f5a,0x6d5c0a0e,0x776400cc,0x656801d4}},	//   syu_, _omsa, èixe, pneh, 
   {{0x443c0b92,0x21681e28,0xe3b00075,0x61e002bb}},	//   pyu_, сими_, _كرت_, rrll, 
   {{0x4ac81f5b,0x00000000,0x00000000,0x00000000}},	//   िराव, --, --, --, 
   {{0x6d5c1f5c,0xca681f5d,0x00000000,0x00000000}},	//   _amsa, зiмi, --, --, 
   {{0x61441f5e,0xf9f8011a,0xdddc0192,0x3f98011a}},	//   _нека, _པཱེན_, _vypů, rmru_, 
   {{0x78a40406,0xdd880155,0x91d80100,0x2d9407c1}},	//   živi, ёбад_, _פֿופ, друс, 
   {{0x2fc80336,0xdddc012c,0x00000000,0x00000000}},	// [1a60] _gwag_, _typů, --, --, 
   {{0x6d5c1f5f,0xa3cc1f60,0xdc68022e,0x00000000}},	//   _emsa, षीय_, _ҳамд_, --, 
   {{0x1d081f61,0x00000000,0x00000000,0x00000000}},	//   _лени_, --, --, --, 
   {{0xed040128,0x00000000,0x00000000,0x00000000}},	//   _قوپپ, --, --, --, 
   {{0x0c2002b3,0x680001b8,0xbb740eb8,0xd7c4006c}},	//   _змян, _rájö, _قۇرع, रींच, 
   {{0xa3e40c48,0x8c400c8e,0x00000000,0x00000000}},	//   बंई_, _џере, --, --, 
   {{0x6d5c020c,0x24a002df,0x8b201166,0x68f00139}},	//   _ymsa, ərmə_, _ядре, ähdö, 
   {{0xf9040324,0x6aa0030f,0x00000000,0x00000000}},	//   _تأسی, _úlfa, --, --, 
   {{0xd3781c3c,0x97c40061,0x00000000,0x00000000}},	//   йчо_, _رقاو, --, --, 
   {{0x15b004fa,0xcc540107,0xd8cc00c3,0x00000000}},	//   _كەتس, פסיק_, _ﻗﯩﻼﻟ, --, 
   {{0x2fc81f62,0x2010017b,0x00000000,0x00000000}},	//   _swag_, _asyi_, --, --, 
   {{0xf8cc1f63,0x92bc0143,0x2fd80075,0x00000000}},	//   ारिय, েলে_, يوجد_, --, 
   {{0xb4e80cd4,0xc9500d47,0x00000000,0x00000000}},	//   बली_, תמר_, --, --, 
   {{0xd1480324,0x4ea41f64,0x984c03b4,0x00000000}},	//   _گشتن_, ярма, nğıc_, --, 
   {{0xf8cc1f65,0xfe700272,0x6fd800b3,0x6d5c02a0}},	//   ाराय, هدف_, _भटकं, _pmsa, 
   {{0x2fc805b8,0xdb04012f,0x00000000,0x00000000}},	//   _twag_, _nukâ, --, --, 
   {{0x2fc80098,0xf41400cf,0x00000000,0x00000000}},	// [1a70] _uwag_, ופּ_, --, --, 
   {{0x7b141f66,0x41a80030,0xc864012b,0x00000000}},	//   ндух, _घूँस, үтди, --, 
   {{0x7f3c0240,0x4428001c,0xc0f40020,0x00000000}},	//   _לעזו, ̣c_, ልጦም_, --, 
   {{0x6d5c1f67,0x2bb40021,0xb32c011a,0x00000000}},	//   _umsa, _अंपा, _ཧོའང_, --, 
   {{0xe7381f68,0x00000000,0x00000000,0x00000000}},	//   жел_, --, --, --, 
   {{0x2d881f69,0x66e41f6a,0xbdf81f6b,0x0ebc081a}},	//   llae_, фока, _بریا_, ्रिड, 
   {{0x2d88034c,0x00000000,0x00000000,0x00000000}},	//   olae_, --, --, --, 
   {{0xe3b81f6c,0x92bc02fa,0x19c0012b,0x00000000}},	//   оби_, েলো_, _рәфг, --, 
   {{0x2d8802bf,0x33f400e5,0x00000000,0x00000000}},	//   ilae_, нчэс, --, --, 
   {{0xf8681f6d,0x9f400243,0xaadc1d39,0xba08001d}},	//   _عملي_, tukí_, मणिक, _ወባ_, 
   {{0x77901f6e,0x00000000,0x00000000,0x00000000}},	//   _حیوا, --, --, --, 
   {{0x61440741,0x00000000,0x00000000,0x00000000}},	//   фема, --, --, --, 
   {{0x34940f0e,0xd36c00ea,0x942400c3,0x00000000}},	//   _зацр, اهۍ_, _يومۇ, --, 
   {{0x51940090,0x62640b5d,0x2d881945,0xdb040d2e}},	//   መለከተ_, _овла, elae_, _pukí, 
   {{0x8fa01f6f,0x4fa001c7,0x00000000,0x00000000}},	//   таре, тирв, --, --, 
   {{0xd00c1f70,0x25e403bf,0x00000000,0x00000000}},	//   _چلي_, _टिनी_, --, --, 
   {{0xdc680182,0xd00c024b,0x25a001d4,0x00000000}},	// [1a80] цаад_, _ەلۋ_, íhly_, --, 
   {{0x2d881f71,0x5f040007,0x39a81f72,0xa3e40030}},	//   alae_, _ўзна, _aşsa_, _फिन_, 
   {{0xa3cc1f73,0x5de41f74,0xd3780100,0x9f0403dd}},	//   षीत_, _южна, קרעט, _فوکو, 
   {{0x9cb41f75,0x2d880034,0xa3ac1f76,0x58841f77}},	//   _زمست, clae_, कदा_, мыла, 
   {{0x6c7405bc,0xbe640020,0x00000000,0x00000000}},	//   _зурх, _ፍልጠታ, --, --, 
   {{0xd5b81f78,0x9f4001d4,0x00000000,0x00000000}},	//   оси_, ytký_, --, --, 
   {{0xfbb002fa,0x00000000,0x00000000,0x00000000}},	//   _ছবিত, --, --, --, 
   {{0x82100cce,0xb4e808af,0x5edc0095,0x6e200207}},	//   িমাপ_, बले_, कृत्_, ålbi, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x92bc0252,0x46e400fc,0x883800ca,0x00000000}},	//   েল্_, _одун_, _ותמו, --, 
   {{0x85741f79,0x3b181f7a,0xdb040029,0x2d881f7b}},	//   ясәт_, _marq_, _mukà, ylae_, 
   {{0x3b180d2e,0x78a400ef,0x00000000,0x00000000}},	//   _larq_, živu, --, --, 
   {{0x59cc0698,0x10480302,0x4fc41f7c,0x00000000}},	//   हीतर, іями_, ьсна, --, 
   {{0x2bb41f7d,0x40340106,0x7334080a,0x63bc00c0}},	//   _अंबा, њерс, _سىبا, ísne, 
   {{0x2d881f7e,0x26d80271,0x00000000,0x00000000}},	//   tlae_, _ɛso_, --, --, 
   {{0x66040d2e,0xa3e40030,0x00000000,0x00000000}},	//   çhki, बूक_, --, --, 
   {{0x3b18018f,0x2d880618,0x25e400bd,0x00000000}},	// [1a90] _barq_, rlae_, _टिभी_, --, 
   {{0x2d881f7f,0x00000000,0x00000000,0x00000000}},	//   slae_, --, --, --, 
   {{0x2d881f80,0x00000000,0x00000000,0x00000000}},	//   plae_, --, --, --, 
   {{0x6ef802b2,0x00000000,0x00000000,0x00000000}},	//   búbó, --, --, --, 
   {{0x3b1802ac,0xf210021f,0x00000000,0x00000000}},	//   _farq_, ़बड़_, --, --, 
   {{0x64a40116,0x00000000,0x00000000,0x00000000}},	//   ҭака, --, --, --, 
   {{0x8d90010f,0x2bb4161f,0x69c00560,0x855400d5}},	//   _ሁኔታው_, _अंडा, _ħlew, ویئر_, 
   {{0xad44010f,0x09c817d6,0x00000000,0x00000000}},	//   _የወጣቶ, ाठीय, --, --, 
   {{0xa7740007,0x7d000479,0x3b1801e3,0xe3b00075}},	//   _злач, _ömse, _yarq_, درب_, 
   {{0x7c201f81,0x46801901,0x4e0c0d49,0xdb0400e3}},	//   _šmrk, _иқла, ाबाई_, _kuká, 
   {{0x36d40155,0xdb04001e,0xe5e41f82,0x00000000}},	//   _рохр, _juká, _سزای, --, 
   {{0x261001f8,0x14c8005e,0x00000000,0x00000000}},	//   _išo_, _فهمی_, --, --, 
   {{0xdb0419ba,0xd24c1f83,0x80a80143,0x00000000}},	//   _luká, لنی_, কুন্, --, 
   {{0x3eac0c8f,0xdb0400b8,0x38600306,0x00000000}},	//   ødt_, _ouká, úiri_, --, 
   {{0x236404bc,0xa3e400bd,0x00000000,0x00000000}},	//   milj_, _फिड_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdd94024b,0xa06800df,0x1be8041c,0x00000000}},	// [1aa0] даңы, _хапа_, ядаи_, --, 
   {{0x26101f84,0x4c800108,0xdb0400d5,0x23640479}},	//   _ošo_, улув, _buká, nilj_, 
   {{0x9d441f85,0xd94403a7,0x6aa006b4,0x00000000}},	//   _зенд, нежи, _úlfl, --, 
   {{0xdb041f86,0x225000c0,0x6a940b1e,0x00000000}},	//   _duká, úzky_, трує, --, 
   {{0xdb04001e,0xb71801c3,0x00000000,0x00000000}},	//   _euká, долф_, --, --, 
   {{0x7bc41f87,0xc7a01f88,0x00000000,0x00000000}},	//   mpiu, гичк, --, --, 
   {{0x06cc02fa,0x7bc41f89,0x95c81f8a,0x00000000}},	//   _রাশি, lpiu, чула_, --, 
   {{0x26001f8b,0x00000000,0x00000000,0x00000000}},	//   _शहरी_, --, --, --, 
   {{0xd7c81d8e,0xf8cc0a63,0x00000000,0x00000000}},	//   _رواه_, ारीप, --, --, 
   {{0xf48404e7,0x7bc4028d,0x8500005e,0x00000000}},	//   _یاشی, ipiu, پوین, --, 
   {{0x82d41f8c,0x00000000,0x00000000,0x00000000}},	//   эдэс_, --, --, --, 
   {{0xeb0c17c6,0x00000000,0x00000000,0x00000000}},	//   _हस्त_, --, --, --, 
   {{0x45080002,0xba08010f,0x2bb4122a,0x236400e9}},	//   _ཁྲིར_, _ወጣ_, _अंधा, bilj_, 
   {{0x4ea41f8d,0xbfa81f8e,0x91e000ec,0xa3e40030}},	//   ерба, етсе_, _йәмһ, बूओ_, 
   {{0x831800ca,0x00000000,0x00000000,0x00000000}},	//   _מוגז, --, --, --, 
   {{0x2bb409b1,0xdb040212,0x6ab80979,0x00000000}},	//   _अंदा, _ruká, इड्र, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1ab0] --, --, --, --, 
   {{0xbc3817c4,0x62240340,0x8c3402dc,0x00000000}},	//   رسقا_, _سوۋە, _ҷомӣ_, --, 
   {{0x4ea405bc,0xf8cc0ad3,0xdeb400ca,0x6e94001e}},	//   _яриа, ारूप, _בפתח_, _шиоу, 
   {{0x23641909,0x3a74001e,0x00000000,0x00000000}},	//   zilj_, ылхр, --, --, 
   {{0x2d980207,0xf77000e7,0x00000000,0x00000000}},	//   _ihse_, ڭان_, --, --, 
   {{0x994c00ef,0xaa5c03d6,0x7e740031,0xdaa00128}},	//   rýš_, _дегi, _çepç, _چەكپ, 
   {{0xf7701f8f,0xc4441f90,0x23640091,0x00000000}},	//   حان_, کیشن_, vilj_, --, 
   {{0xa5241f91,0x69c41f92,0x00000000,0x00000000}},	//   тмид, mphe, --, --, 
   {{0x236400e9,0x00000000,0x00000000,0x00000000}},	//   tilj_, --, --, --, 
   {{0x69c41f93,0x59cc006c,0x00000000,0x00000000}},	//   ophe, हीवर, --, --, 
   {{0x69c41f94,0xe514009e,0x261000e9,0x236401df}},	//   nphe, _афлэ, _ušo_, rilj_, 
   {{0x291c1f95,0xa0681f96,0x69c408c2,0x6f040075}},	//   ndwa_, дама_, iphe, _abhc, 
   {{0x62240121,0xa074024b,0x69c40177,0x27fc0086}},	//   رىڭل, тынш, hphe, ntwn_, 
   {{0x2d981f97,0x69c40636,0xe2841f98,0x5f040668}},	//   _ahse_, kphe, _илли, ъзга, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x60240116,0x7bc41f99,0x69c41f9a,0xc5e00143}},	//   _адиа, tpiu, dphe, _মহাপ, 
   {{0x291c0c2e,0x8c40021c,0x7bc401d6,0x5ba81f9b}},	// [1ac0] ddwa_, аете, upiu, дкам_, 
   {{0x7bc41f9c,0x00000000,0x00000000,0x00000000}},	//   rpiu, --, --, --, 
   {{0x7bc41f9d,0x986400d5,0x00000000,0x00000000}},	//   spiu, ھیئے_, --, --, 
   {{0x7bc40880,0xd7e40103,0x61e401c5,0x9d4403ba}},	//   ppiu, віко, _åhlu, _ремд, 
   {{0x69c4060f,0xeb300340,0x00000000,0x00000000}},	//   aphe, _گۉلد, --, --, 
   {{0x69c401ba,0x34bc00cb,0x73c401c4,0x00000000}},	//   bphe, ैर्द, ңәле, --, 
   {{0x69c40e3d,0xceb00240,0x00000000,0x00000000}},	//   cphe, סיה_, --, --, 
   {{0x38c8109d,0xdb040152,0x34941a6b,0xe6c40200}},	//   _ساری_, _bukç, лайр, _ەتني, 
   {{0x491400b3,0x00000000,0x00000000,0x00000000}},	//   _नसतो_, --, --, --, 
   {{0x2bb41f9e,0x15e8025c,0x00000000,0x00000000}},	//   _अंसा, _टिपर_, --, --, 
   {{0x0f3c001d,0x00000000,0x00000000,0x00000000}},	//   _ዓለማየ, --, --, --, 
   {{0x27e81547,0x995c01d5,0x00000000,0x00000000}},	//   šane_, _lůž_, --, --, 
   {{0x69c40151,0xc1740393,0x5434115c,0x00000000}},	//   zphe, рлящ, _جرار, --, 
   {{0x995c00bd,0x1304024b,0x00000000,0x00000000}},	//   _nůž_, _شىعۋ_, --, --, 
   {{0x814400cc,0x00000000,0x00000000,0x00000000}},	//   _چنىن, --, --, --, 
   {{0xf8cc1d34,0x6e2400e9,0x637c0078,0x00000000}},	//   ारोप, _vrhb, dèny, --, 
   {{0x09c8072d,0xcf9800b7,0x00000000,0x00000000}},	// [1ad0] ाठ्य, _ојо_, --, --, 
   {{0x69c41f9f,0x3b541fa0,0x95100126,0x6f040306}},	//   tphe, акур, _ཉིའི_, _ubhc, 
   {{0x66e402ac,0x69c40083,0x18a000ec,0x00000000}},	//   ҳола, uphe, ҙашм, --, 
   {{0x2d9801d5,0xfce400b7,0x00000000,0x00000000}},	//   _uhse_, _коџо, --, --, 
   {{0xdb040638,0x6d4c1fa1,0xd8b404c3,0x310400cb}},	//   _bukä, mkaa, اگفا_, ष्यः_, 
   {{0x6d4c1fa2,0x77841fa3,0x69c41fa4,0xe6880041}},	//   lkaa, аліз, pphe, ىنشى_, 
   {{0x7f3c007c,0xdb040031,0x27fc0335,0x00000000}},	//   ועגו, _dukä, stwn_, --, 
   {{0x6d4c1fa5,0x6b8402ac,0x25881df1,0x00000000}},	//   nkaa, lohg, رچاپ_, --, 
   {{0x38600272,0x4aa400cb,0xe3a8022e,0x6d4c1fa6}},	//   úirt_, _कृतव, нкид_, ikaa, 
   {{0x6d4c1fa7,0x96c80021,0x344400c3,0x543400d5}},	//   hkaa, _स्पॉ, рүши_, ارٹر, 
   {{0xe6580272,0x15e803ef,0x21681fa8,0x21a41fa9}},	//   _ثلاث_, _टियर_, еини_, лиом, 
   {{0x6b840140,0x00000000,0x00000000,0x00000000}},	//   hohg, --, --, --, 
   {{0x6d4c1faa,0x656806ea,0x69c0034a,0xf2f803b5}},	//   dkaa, mieh, _élef, روێژ_, 
   {{0x65681fab,0x349402dc,0x6d4c1fac,0x00000000}},	//   lieh, _тачр, ekaa, --, 
   {{0xfe781fad,0x6d4c1fae,0x1d081faf,0x9b041fb0}},	//   түн_, fkaa, неви_, һзад, 
   {{0x6d4c1fb1,0x2bb4072d,0x71c40123,0x5f7400ea}},	//   gkaa, _अंशा, _таъҷ, _څادر, 
   {{0x5f740dfc,0x220401b5,0x64481fb2,0x9f400299}},	// [1ae0] _مادر, _شِکٲ, nyei, tukä_, 
   {{0x6448007f,0x6d4c1fb3,0x9b881fb4,0x65680e48}},	//   iyei, akaa, رنال_, hieh, 
   {{0x60d4021d,0x6d4c01b5,0x65681fb5,0x4ef80a0b}},	//   _keym, bkaa, kieh, _אליג, 
   {{0x39401fb6,0x60d41fb7,0xdbdc00d3,0x8a84004b}},	//   ðis_, _jeym, _tíàg, چھہِ_, 
   {{0x7d041fb8,0x60d41fb9,0x65681fba,0x48e00a21}},	//   mfis, _meym, dieh, сочв, 
   {{0x7d041fbb,0x7c241fbc,0xf7701fbd,0x60d404db}},	//   lfis, mvir, ڭاچ_, _leym, 
   {{0x7d041fbe,0xbacc0e85,0x6568002a,0x4ed80100}},	//   ofis, _ﺗﯘﺗﺎ, fieh, ײַונ, 
   {{0x74141fbf,0x98a40f7d,0x1ae402dc,0x65680379}},	//   لوبا, _бибе, _шоҳм, gieh, 
   {{0x7c241fc0,0x13681fc1,0xb6c40121,0x7d041fc2}},	//   nvir, ешни_, _көйд, ifis, 
   {{0xa3e41fc3,0xdb040139,0x7c240472,0x932401d9}},	//   _फिर_, _etkö, ivir, چرگن, 
   {{0x60d41fc4,0x6568018b,0x7d0401c5,0x6d4c1fc5}},	//   _beym, bieh, kfis, ykaa, 
   {{0x51840c9f,0x6568018b,0x60d41fc6,0x6d4c028b}},	//   ѓуна, cieh, _ceym, xkaa, 
   {{0x7d041fc7,0x60d41fc8,0x50640023,0x8f080108}},	//   dfis, _deym, утна, нхва_, 
   {{0x7d041fc9,0x7c241fca,0x60d400a0,0xdc68010f}},	//   efis, dvir, _eeym, _በመላክ_, 
   {{0x7d041fcb,0x6d4c1fcc,0xadd4005b,0x8d741fcd}},	//   ffis, tkaa, робљ, هارا, 
   {{0x7d041fce,0x60d41fcf,0x9f400552,0x7c240038}},	//   gfis, _geym, trkã_, fvir, 
   {{0x6d4c1fd0,0xdbb40087,0x417400e2,0x31040095}},	// [1af0] rkaa, иатө, _داوس, ष्णः_, 
   {{0x65680602,0x6d4c1fd1,0x7d041fd2,0x0ca8006b}},	//   zieh, skaa, afis, _үтми_, 
   {{0x6d4c0ca1,0x6a140200,0x7d040104,0x7c240027}},	//   pkaa, рмеу, bfis, avir, 
   {{0x7c240582,0xa3e403b6,0x7d04042e,0x60d402a0}},	//   bvir, _फिल_, cfis, _xeym, 
   {{0x65680139,0x7c2400c2,0x64480379,0x89d41741}},	//   vieh, cvir, xyei, ئوچر_, 
   {{0xb8ec076f,0x65681fd3,0x24b401d2,0x00000000}},	//   _श्_, wieh, _ﹼﻘﺘﻬ, --, 
   {{0x65681fd4,0xe6340094,0x00000000,0x00000000}},	//   tieh, рхлэ, --, --, 
   {{0x79a40c9f,0x63bc00ef,0x64480027,0x6fb4040e}},	//   _груе, ísno, tyei, ंदां, 
   {{0x65681fd5,0x00000000,0x00000000,0x00000000}},	//   rieh, --, --, --, 
   {{0x65681fd6,0x60d41fd7,0x06cc0143,0x00000000}},	//   sieh, _seym, _রাকি, --, 
   {{0x60d41fd8,0x7d041fd9,0x7c240a84,0x06980075}},	//   _peym, yfis, zvir, _أخذت_, 
   {{0xa0a41fda,0x7c2405c0,0x21681fdb,0x60d40380}},	//   ианд, yvir, тими_, _qeym, 
   {{0x7d041fdc,0x974c0223,0x00000000,0x00000000}},	//   vfis, _ọ̀rọ_, --, --, 
   {{0x60d41fdd,0x7d041fde,0x7c241fdf,0xddc4018f}},	//   _weym, wfis, vvir, ибги, 
   {{0x60d41fe0,0xfcdc001d,0x399c01ca,0x9d4408e4}},	//   _teym, _ሕንጻ_, líse_, аевд, 
   {{0x7c240822,0x127800cf,0x00000000,0x00000000}},	//   tvir, _שאקע, --, --, 
   {{0xdee41fe1,0x7d041fe2,0x7c240047,0xb33c011a}},	// [1b00] _копи, rfis, uvir, lmħa, 
   {{0x9e64057a,0xd00c1fe3,0x7d041fe4,0xe190010f}},	//   _ввод, _کلی_, sfis, _ማህበሩ_, 
   {{0x399c03e0,0x7d040b1e,0x200000b6,0x7d0001c5}},	//   híse_, pfis, ltki_, _ömso, 
   {{0x06cc02fa,0x7c241fe5,0x92981fe6,0x00000000}},	//   _রাগি, pvir, דיעת, --, 
   {{0x20001fe7,0x77941fe8,0x2b9002ac,0x00000000}},	//   ntki_, میرا, _کیلس, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb0c02b4,0xcb64009e,0x09e01fe9,0x06cc0143}},	//   _libë, _таре_, _морн, _রাখি, 
   {{0x27e811a4,0x399c0272,0x00000000,0x00000000}},	//   šana_, físe_, --, --, 
   {{0x362401b8,0x8cd400b6,0x93440075,0x00000000}},	//   _گواہ, बरतो, لخدم, --, 
   {{0x73380155,0x39441fea,0xb3541ee8,0x53441feb}},	//   узор_, _homs_, скош, рхиа, 
   {{0x3944062d,0xe6b401d9,0x8ab40100,0x00000000}},	//   _koms_, _المگ, יליג_, --, 
   {{0x3f540299,0x39440023,0xdb0c0222,0x00000000}},	//   _räua_, _joms_, _bibë, --, 
   {{0x7afc0070,0x39441fec,0xca681fed,0x399c01ca}},	//   _ocrt, _moms_, дiлi, císe_, 
   {{0x39441fee,0x27f81fef,0xdb0c0222,0x52640012}},	//   _loms_, _åsne_, _dibë, _پاتٲ, 
   {{0x39440aea,0xaa0402ef,0x200003bf,0x00000000}},	//   _ooms_, _रहेछ_, atki_, --, 
   {{0xac181ff0,0x065400ca,0x00000000,0x00000000}},	//   лобу_, בילך_, --, --, 
   {{0x31681ff1,0xdb0c0078,0x299800c3,0x00000000}},	// [1b10] _imaz_, _kibè, ﯘﺭﭼﻪ_, --, 
   {{0x7afc0128,0x2ef41ff2,0x0ac400fc,0x00000000}},	//   _ccrt, _узор, рщам, --, 
   {{0x39440638,0x6f140a24,0x49a40f0e,0x00000000}},	//   _boms_, mezc, ајда, --, 
   {{0xdb0c065e,0x39441ff3,0x6f141ff4,0xe8580074}},	//   _libè, _coms_, lezc, лаеш_, 
   {{0x39441ff5,0xec340100,0xdbd40101,0x00000000}},	//   _doms_, _האָר_, _käýe, --, 
   {{0xd7ec1ff6,0x6f141ff7,0x2d881ff8,0xc77000ec}},	//   ركى_, nezc, loae_, өтһө, 
   {{0x31681ff9,0x39440638,0xaa580663,0x00000000}},	//   _omaz_, _foms_, _сиву_, --, 
   {{0x39441ffa,0x200003ef,0x2d880034,0x26c801c6}},	//   _goms_, ytki_, noae_, ŝao_, 
   {{0xa8241ffb,0xe2b40182,0xa8540139,0x25a801d4}},	//   _دکان, йснэ, _укач, ňalo_, 
   {{0xda0c1ffc,0xb9e002b4,0x46680553,0x826000c3}},	//   _सहमत_, _እብ_, _ирем_, يۇشن, 
   {{0xe69403ae,0x6f140143,0xdb0c0249,0xdb0400b8}},	//   _الاد, dezc, _dibè, _pukú, 
   {{0x67201ffd,0xa5340254,0x225803ef,0x26000029}},	//   _halj, _ынеч, ąsk_, móo_, 
   {{0x67201ffe,0x2600175d,0x24f8001e,0xa8780100}},	//   _kalj, lóo_, _анҵы_, ראָר, 
   {{0x6720004e,0x20001fff,0x9e640121,0xb3842000}},	//   _jalj, rtki_, مازن, _وجوه, 
   {{0x67202001,0x3eac2002,0x20002003,0xaea80272}},	//   _malj, ädt_, stki_, لطفل_, 
   {{0x5f742004,0x00000000,0x00000000,0x00000000}},	//   _گابر, --, --, --, 
   {{0x39442005,0x67200556,0x00000000,0x00000000}},	// [1b20] _roms_, _oalj, --, --, 
   {{0x67202006,0x39442007,0x5f741009,0x2600175c}},	//   _nalj, _soms_, _دابر, kóo_, 
   {{0x39440496,0x316803f4,0x26002008,0x4f200152}},	//   _poms_, _ymaz_, jóo_, _эдэб, 
   {{0xdb0c07d4,0x98d82009,0xe190001d,0xdcfc0152}},	//   _mibé, اباز_, _ማኅበሩ_, _tupı, 
   {{0x67200331,0xdb0c200a,0x3944200b,0x06cc0143}},	//   _balj, _libé, _voms_, _রাজি, 
   {{0x7afc0070,0x781800b6,0x50181fe6,0x00000000}},	//   _ucrt, _धनीक_, טונו, --, 
   {{0x672003e8,0x3944200c,0xdb0c0249,0x2600038a}},	//   _dalj, _toms_, _ribè, góo_, 
   {{0xdb0c02ba,0xd3a403ba,0x00000000,0x00000000}},	//   _sibè, әрип, --, --, 
   {{0x672002b4,0x38600e3d,0xded4001d,0x00000000}},	//   _falj, ùird_, ራሩን_, --, 
   {{0x69c0200d,0x6720200e,0x8c180240,0xdb040247}},	//   _élec, _galj, נויי, _pukù, 
   {{0x01c401b8,0xc1b40182,0x00000000,0x00000000}},	//   یویٹ_, йлэх_, --, --, 
   {{0x67200406,0xdb0c200f,0xd1382010,0x00000000}},	//   _zalj, _dibé, ухо_, --, 
   {{0xc0582011,0x61e0012a,0x6f1404ac,0xdb0c01e8}},	//   бір_, asll, tezc, _tibè, 
   {{0x80dc04d8,0xc0581210,0x316803f4,0x00000000}},	//   _ভাণ্, сію_, _wmaz_, --, 
   {{0x65b40f3d,0x6f1402fa,0xdb0c2012,0x316800b0}},	//   _tšhe, rezc, _gibé, _tmaz_, 
   {{0x63b8004e,0x1aa801b9,0x5dac01ee,0xc9200143}},	//   _yuwn, খুৱা, _ﺳﺎﻧﺴ, _ভক্ত_, 
   {{0xc1740107,0xdb0c0249,0x88d402fa,0x68fc0031}},	// [1b30] _מחק_, _zibé, _হালক, _ösdi, 
   {{0x2d540085,0x8aa4023f,0x6db400b0,0x00000000}},	//   _gåen_, бред, _sąau, --, 
   {{0xdb242013,0x9ed8002c,0x67202014,0x4f641742}},	//   تولی, _өмөт_, _ralj, _ناگف, 
   {{0x67202015,0x01f80100,0xe6d02016,0xcc840061}},	//   _salj, רפאל, हर्ज, _هۆزه_, 
   {{0x67202017,0x26002018,0x18b4001e,0x00000000}},	//   _palj, wóo_, әгәы_, --, 
   {{0x27e82019,0x2fc80840,0x78a40247,0x00000000}},	//   šano_, _mtag_, ýiva, --, 
   {{0x6720201a,0x39a8012b,0x63b80201,0x00000000}},	//   _valj, _aşsu_, _suwn, --, 
   {{0x672008df,0xdb0c201b,0x2fc80101,0xd7ec00e7}},	//   _walj, _ribé, _otag_, ركۉ_, 
   {{0x67200002,0xdb0c201c,0x2fc80069,0x25e4021f}},	//   _talj, _sibé, _ntag_, _टिकी_, 
   {{0x9700006e,0x399c00c4,0x51f400dd,0x442001c6}},	//   _يېنى, mísa_, ڊسٽر, ĉj_, 
   {{0xe298201d,0x4424201e,0xa3e4023b,0x00000000}},	//   ран_, _گراف, _फिक_, --, 
   {{0x80a80143,0x00000000,0x00000000,0x00000000}},	//   _ক্ষ্, --, --, --, 
   {{0xa2e4201f,0x2bb42020,0xdef8016d,0x399c00c4}},	//   _долд, _अंगा, һың_, nísa_, 
   {{0x20e80048,0xdb0c2021,0x3d0c00aa,0x61e002bb}},	//   ời_, _tibé, ड्ने_, psll, 
   {{0x61442022,0xdef82023,0x2fc80043,0x290c2024}},	//   _мека, лың_, _etag_, _obea_, 
   {{0x2fc8044a,0x68e82025,0x00000000,0x00000000}},	//   _ftag_, _nded, --, --, 
   {{0x5bc42026,0x2d540085,0x80a80143,0x00000000}},	// [1b40] زقال, _tåen_, _ক্র্, --, 
   {{0x290c0513,0x3f54000b,0x4c640254,0x00000000}},	//   _abea_, _käum_, циун_, --, 
   {{0x9d442027,0x1d082028,0x19f80254,0xdb142029}},	//   _денд, _кени_, рэзь_, mpyü, 
   {{0x290c006f,0x9848002c,0x1988001e,0x00000000}},	//   _cbea_, ияла_, шбеи_, --, 
   {{0x68e8202a,0x3ce001f9,0x57a4202b,0xbd8803a2}},	//   _dded, maiv_, ошка, _ننڍن_, 
   {{0x68e8202c,0xc9500329,0x3ce001ca,0x00000000}},	//   _eded, зтәы, laiv_, --, 
   {{0xda0c0872,0xe87400e7,0x8a000106,0x31780098}},	//   _सहित_, ينۅگ, _озре, ynsz_, 
   {{0x73d801a0,0x3ce00078,0xceb0023c,0xc5a401ac}},	//   бдир_, naiv_, ויו_, يُون_, 
   {{0x8d58007c,0xd378202d,0x00000000,0x00000000}},	//   יכקי, ичо_, --, --, 
   {{0x3ce001ba,0x27f801c5,0x68e802cc,0x00000000}},	//   haiv_, _åsna_, _zded, --, 
   {{0x2fc8202e,0x201000f1,0x68e80085,0x00000000}},	//   _stag_, _apyi_, _yded, --, 
   {{0xdbd0202f,0x00000000,0x00000000,0x00000000}},	//   _küät, --, --, --, 
   {{0x06cc0252,0xad240682,0xb37c001d,0x00000000}},	//   _ৰাতি, ۋىسى, ኖረውን_, --, 
   {{0xdb0c0239,0xd8b8011a,0x8de80587,0xdc78001d}},	//   _sibî, _བུའི, ифба_, _ተመራጭ_, 
   {{0x20100078,0x7f940123,0x4ea401d9,0x25fc1b41}},	//   _epyi_, фарх, юрма, रूपी_, 
   {{0x2fc82030,0x8d7400cd,0x3da42031,0xe8d80030}},	//   _ttag_, زازا, друб, _ढ़ेच, 
   {{0x2fc80039,0x0ca82032,0x705401e0,0x00000000}},	// [1b50] _utag_, ртви_, _رندا, --, 
   {{0x399c020f,0x88d402fa,0x68e80335,0x96c80388}},	//   vísa_, _হাইক, _sded, _स्लॉ, 
   {{0xdb0c01b8,0x00000000,0x00000000,0x00000000}},	//   óján, --, --, --, 
   {{0x26c40d13,0x7ec000d3,0x00000000,0x00000000}},	//   _sflo_, _tàpó, --, --, 
   {{0xdd380107,0x25fc0203,0x5d3800ca,0x00000000}},	//   _הערכ, रूनी_, _התרא, --, 
   {{0x478803d6,0x399c02e8,0x00000000,0x00000000}},	//   шсем_, rísa_, --, --, 
   {{0x80dc00ac,0xe61800f8,0x3b6401b5,0x00000000}},	//   _ভাস্, ёди_, _تێلہ, --, 
   {{0xded42033,0x68e82034,0x3f54000b,0xd90c01b5}},	//   _ኪዳን_, _uded, _räum_, _میٔ_, 
   {{0xdb040101,0xb50800e7,0x00000000,0x00000000}},	//   _luký, تۉنۅ_, --, --, 
   {{0x26c4041c,0xe6940329,0x00000000,0x00000000}},	//   _uflo_, _еизы, --, --, 
   {{0x23280288,0xff840031,0x00000000,0x00000000}},	//   _ҳоли_, _üçiň_, --, --, 
   {{0xe2982035,0x9f4000aa,0xdb140078,0x765c0055}},	//   _қай_, mské_, npyò, _ürya, 
   {{0x9f4002f6,0x23282036,0x3ce00496,0x7d000207}},	//   lské_, _голи_, vaiv_, _ömsi, 
   {{0x442c2037,0x80cc03ef,0x443c0002,0x00000000}},	//   _irg_, _थ्रे, mxu_, --, 
   {{0x9f401301,0xd24c2038,0x2bb405d5,0x00000000}},	//   nské_, _منو_, _अंजा, --, 
   {{0xe0d80668,0xad242039,0xa6c00143,0x9f04203a}},	//   _уви_, ورقو, উরিট, _کودو, 
   {{0x442c203b,0x27e814ba,0x443c0636,0x52dc02fa}},	// [1b60] _jrg_, šanj_, nxu_, _মাতৃ, 
   {{0x8b20203c,0x797c00f1,0x3ce00306,0x00000000}},	//   ндуе, tčwo, saiv_, --, 
   {{0x9f400212,0x442c203d,0x00000000,0x00000000}},	//   jské_, _lrg_, --, --, 
   {{0x442c203e,0x9f4002d6,0x18a41064,0xa2f8025c}},	//   _org_, dské_, паем, ्भुज_, 
   {{0x98a4203f,0xdbd0006b,0x2bb40030,0x00000000}},	//   чиде, _qüät, _अंचा, --, 
   {{0x9fec0143,0xdb0c00d5,0x4c9800ca,0x2b14044a}},	//   _ওহাব_, _kibí, _לבכו, _оьср, 
   {{0x442c2040,0xded42041,0x443c175c,0x9f4001d5}},	//   _arg_, _ኪዳነ_, exu_, gské_, 
   {{0xceb010bc,0xd7640191,0x00000000,0x00000000}},	//   עיה_, _کارٹ, --, --, 
   {{0x442c2042,0x443c2043,0xdb0c01d5,0xd1d0001d}},	//   _crg_, gxu_, _libí, ያዙት_, 
   {{0x442c2044,0x32542045,0x9f400113,0x9988012c}},	//   _drg_, двор, bské_, _krbů_, 
   {{0x442c2046,0x443c038a,0x00000000,0x00000000}},	//   _erg_, axu_, --, --, 
   {{0x65b406f9,0x442c2047,0x46380282,0x443c044a}},	//   _tšha, _frg_, _לעבע, bxu_, 
   {{0x94200121,0xdb0c059b,0x442c00b0,0xc0581e8a}},	//   _سوغۇ, _aibí, _grg_, пір_, 
   {{0xdb0c00b7,0x00000000,0x00000000,0x00000000}},	//   _libâ, --, --, --, 
   {{0x80dc00ac,0x2cb82048,0x051c0252,0x00000000}},	//   _ভার্, _pgsd_, ভাৰৰ_, --, 
   {{0xebd81166,0x00000000,0x00000000,0x00000000}},	//   ждаш_, --, --, --, 
   {{0x7bc02049,0xdb0400d3,0xdb0c00d3,0x00000000}},	// [1b70] _émul, _nukó, _tibì, --, 
   {{0x8aa40fca,0xdcec0828,0x7ac409c7,0xfb840094}},	//   пред, ākār, есце, ныхн, 
   {{0x7054204a,0xd8c801e5,0xaa181b6f,0x25a800c0}},	//   _رنگا, _ịpịr, تياط_, ňali_, 
   {{0x9f400214,0xdb04204b,0xf99000dd,0x443c015e}},	//   vské_, _zukü, هبن_, yxu_, 
   {{0x443c204c,0x00000000,0x00000000,0x00000000}},	//   xxu_, --, --, --, 
   {{0x9f4005a4,0x49b8204d,0xaae00203,0x00000000}},	//   tské_, _هارد_, _फ़िक, --, 
   {{0x442c0c2a,0xe61801f5,0x60c401c5,0x00000000}},	//   _srg_, іди_, yckm, --, 
   {{0x9f401301,0x443c05bc,0x361801f5,0xe458018f}},	//   rské_, txu_, яцію_, жжи_, 
   {{0xdb100247,0x80dc0143,0x00000000,0x00000000}},	//   _ágãr, _ভাল্, --, --, 
   {{0x04fc00ac,0xa1c4204e,0x9f4000aa,0x443c204f}},	//   ্যের_, мбод, pské_, rxu_, 
   {{0x6d5c2050,0xf99001b8,0xd76401d9,0x00000000}},	//   _olsa, _شبہ_, _تنلی, --, 
   {{0x442c2051,0xdb0403b2,0xdb0c01ca,0x00000000}},	//   _trg_, _yukó, _ribí, --, 
   {{0x442c2052,0x443c08cf,0xdb0c00c0,0x00000000}},	//   _urg_, qxu_, _sibí, --, 
   {{0x6d5c2053,0xd24c049d,0x671c0098,0x00000000}},	//   _alsa, انێ_, फ़िक_, --, 
   {{0xf1a81aa4,0x00000000,0x00000000,0x00000000}},	//   تایه_, --, --, --, 
   {{0xb3800020,0x2d941857,0x00000000,0x00000000}},	//   _ዕብዳን_, ерус, --, --, 
   {{0x9f500a70,0x1b4800f8,0x71242054,0xd020012b}},	// [1b80] ðbót_, озаи_, _سريل, _амый, 
   {{0xda640272,0x00000000,0x00000000,0x00000000}},	//   واضي, --, --, --, 
   {{0x69c00191,0xd9442055,0x09e0018f,0x00000000}},	//   _élel, межи, вохн, --, 
   {{0xed040049,0x00000000,0x00000000,0x00000000}},	//   _كوپپ, --, --, --, 
   {{0x1b20001e,0xca680049,0x48e02056,0x00000000}},	//   _иҟаҳ, дiгi, точв, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x98a40340,0x77a4052b,0x73d801ec,0x04140143}},	//   _жибе, dòxe, пдир_, তিনী_, 
   {{0x74142057,0x00000000,0x00000000,0x00000000}},	//   رودا, --, --, --, 
   {{0xc87c2058,0x00000000,0x00000000,0x00000000}},	//   üşen_, --, --, --, 
   {{0x25fc03bf,0x00000000,0x00000000,0x00000000}},	//   रूदी_, --, --, --, 
   {{0xdb0c0693,0x00000000,0x00000000,0x00000000}},	//   _libà, --, --, --, 
   {{0x93442059,0x85000b30,0x00000000,0x00000000}},	//   _онде, _شوون, --, --, 
   {{0xb8e00145,0x45080560,0xb8d00560,0xcdd80294}},	//   _གཔ_, _གཡོར_, _ནཻ_, жња_, 
   {{0x42f800ca,0x00000000,0x00000000,0x00000000}},	//   _והוס, --, --, --, 
   {{0x27e803e8,0xd24c0012,0x00000000,0x00000000}},	//   šani_, _منڈ_, --, --, 
   {{0xada400c3,0x3d940139,0x00000000,0x00000000}},	// [1b90] даңл, титр, --, --, 
   {{0x6a740579,0x7bf8012b,0x00000000,0x00000000}},	//   _nýfø, ьнур_, --, --, 
   {{0x6f04004f,0x38600097,0x00000000,0x00000000}},	//   _ichc, ùirn_, --, --, 
   {{0x6e24205a,0xfaa4205b,0x4508043b,0x6d5c205c}},	//   _ishb, тшун, _གཡེར_, _ulsa, 
   {{0xe738205d,0x7cd800fc,0x2ee0205e,0xf9900075}},	//   зел_, _юмяр_, _kehf_, جبل_, 
   {{0x6134039c,0xd820205f,0x84780020,0x660417da}},	//   _külä, удши, _ይስማዕ_, епка, 
   {{0xe6101d43,0x09040551,0x556000c3,0x00000000}},	//   اشت_, _очам, گۇنك, --, 
   {{0x69c40996,0x23d41857,0x39a409b7,0xe8940027}},	//   mqhe, нцор, _ашув, _забь, 
   {{0x291c2060,0x96c803c3,0xdb0c00cd,0x67d400df}},	//   mewa_, _स्कॉ, _hibá, _чозу, 
   {{0x291c2061,0x65b42062,0xb71402eb,0xdb0c00f2}},	//   lewa_, _tšho, _идущ, _kibá, 
   {{0x69c42063,0xb1d80027,0x00000000,0x00000000}},	//   nqhe, мьях_, --, --, 
   {{0x291c2064,0x6f0401a0,0x00000000,0x00000000}},	//   newa_, _achc, --, --, 
   {{0x25ac2065,0x6e242066,0xdb0c00e3,0x00000000}},	//   mmel_, _ashb, _libá, --, 
   {{0x291c2067,0x61340573,0x232800f8,0x25ac00b6}},	//   hewa_, _bülä, _хоки_, lmel_, 
   {{0x291c2068,0x6134012b,0x8fa00254,0x00000000}},	//   kewa_, _cülä, уаре, --, 
   {{0xa0a42069,0x291c206a,0x6f0402b0,0x25ac0086}},	//   _пайд, jewa_, _echc, nmel_, 
   {{0x291c206b,0xd00c1443,0xf1a8049d,0x6e24018f}},	// [1ba0] dewa_, _هلي_, _تاوه_, _eshb, 
   {{0xe6240765,0x31c4012b,0x00000000,0x00000000}},	//   _đông_, _ясәв, --, --, 
   {{0x291c206c,0x9f4002d9,0x6134206d,0x2d840151}},	//   fewa_, nskí_, _gülä, élec_, 
   {{0x291c206e,0xdb0c00c0,0x00000000,0x00000000}},	//   gewa_, _dibá, --, --, 
   {{0x7bc4206f,0x31040828,0x77942070,0xb908006c}},	//   qqiu, ष्टः_, نیرا, _मज_, 
   {{0x45080560,0xdb140027,0x25ac2071,0x6134012b}},	//   _གཡུར_, epyö, emel_, _yülä, 
   {{0x291c2072,0x9f4000c0,0x88800049,0xd7040152}},	//   bewa_, jskí_, _ұлтж, _үзби, 
   {{0x07a007d8,0x291c2073,0x05802074,0x9f4000c0}},	//   _ҡатн, cewa_, луым, dskí_, 
   {{0x1784001e,0x00000000,0x00000000,0x00000000}},	//   _згам, --, --, --, 
   {{0x25ac2075,0xd628023f,0x62f0001e,0x00e0000d}},	//   amel_, _нозе_, аҧшт, _đườg_, 
   {{0x941c009f,0xd5f8011a,0x74140324,0xcb1000ca}},	//   _ərəb_, _དཀྲབ_, روگا, אלת_, 
   {{0x25d817ab,0x02a02076,0x6f042077,0x25ac01e8}},	//   _آهنگ_, ырым, _schc, cmel_, 
   {{0x6e24001e,0x408400fc,0x61342078,0x00000000}},	//   _sshb, гурб, _sülä, --, 
   {{0x291c2079,0x399c06b4,0x00000000,0x00000000}},	//   zewa_, físk_, --, --, 
   {{0xbe88207a,0x291c207b,0xdb0c0353,0x6e9401f5}},	//   есте_, yewa_, _kibæ, тиву, 
   {{0xb034022e,0x4298023c,0x3d94207c,0x00000000}},	//   _аниш, _מסוב, гиср, --, 
   {{0x291c0047,0x81c80143,0x320c02e6,0x00000000}},	// [1bb0] vewa_, _লিএ_, ltdy_, --, 
   {{0x6134039c,0x6e240197,0xed5003a2,0x291c207d}},	//   _tülä, _tshb, اھھ_, wewa_, 
   {{0x291c207e,0x6e24207f,0x7af805c0,0x25ac2080}},	//   tewa_, _ushb, óvta, ymel_, 
   {{0x0408011a,0x00000000,0x00000000,0x00000000}},	//   _ཁྱྀམ_, --, --, --, 
   {{0x291c2081,0xe72805bc,0x00000000,0x00000000}},	//   rewa_, долд_, --, --, 
   {{0x36e809e5,0x291c2082,0x9ba0006e,0x00000000}},	//   ىرىپ_, sewa_, _نەقى, --, 
   {{0x291c2083,0x25ac00b6,0x96602084,0x048c00d3}},	//   pewa_, tmel_, икше, _àjẹs, 
   {{0x847400d3,0x3f5401ab,0xd5ac05a1,0x25ac018c}},	//   _aáwẹ, _häut_, يفو_, umel_, 
   {{0x9f400c09,0xc1b40551,0xac9401da,0xe61001ac}},	//   nskã_, қәкы, _ሙስሊም_, اشڪ_, 
   {{0xdb1402eb,0x9f4000c0,0x00000000,0x00000000}},	//   spyö, tskí_, --, --, 
   {{0x36d412ba,0x96c81f7d,0x27ec0353,0x320c0031}},	//   _сохр, _स्टॉ, _hven_, gtdy_, 
   {{0x27e811b0,0x27ec01b9,0x9f4002cc,0x61fc01e3}},	//   šanu_, _kven_, rskí_, хsla, 
   {{0x9f400e84,0x84740229,0x25fc03ef,0x00000000}},	//   jskã_, _fáwẹ, रूरी_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc10401c4,0xc1e001d2,0xed80001d,0x00000000}},	//   _йүнл, _حۋجي, _የጥቁር_, --, 
   {{0x16002085,0x27ec0bb8,0x1cb4011a,0x00000000}},	//   रंतर_, _oven_, _ཝུད_, --, 
   {{0xdb0400e3,0xa06801c7,0x00000000,0x00000000}},	// [1bc0] _mukö, _цапа_, --, --, 
   {{0xddc4001e,0xfe780182,0x79540122,0xc1b400b8}},	//   _ибои, _зүг_, گێرا, _шәҿы, 
   {{0x27ec2086,0x6bd414c8,0x59080027,0x312402ba}},	//   _aven_, نتەر, деем_, _рдөг, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1e1c1e92,0x4c801166,0x81ac0143,0x00000000}},	//   _ስልጠና, _вляв, কআপ_, --, 
   {{0x7d042087,0x7c242088,0xb6c800d5,0xc7a00074}},	//   lgis, mwir, راتے_, аичк, 
   {{0x27ec2089,0x1600002f,0x7c24208a,0x3f5401ab}},	//   _even_, रंधर_, lwir, _häus_, 
   {{0x69940b1e,0xdb4c0061,0x00000000,0x00000000}},	//   _брух, _دێڕ_, --, --, 
   {{0x7c24208b,0x7d04208c,0x81c800dc,0x00000000}},	//   nwir, igis, _লিগ_, --, 
   {{0x1cb4043b,0xe8f800f8,0x80dc02fa,0x7c240088}},	//   _ཝུན_, _олӣ_, _ভাগ্, iwir, 
   {{0x7c24208d,0x7d0400ec,0x27ec01d1,0x87780100}},	//   hwir, kgis, _zven_, _קאבי, 
   {{0x7c24208e,0x09d40143,0x00000000,0x00000000}},	//   kwir, _হিমা, --, --, 
   {{0x752001dc,0x320c208f,0x7c242090,0xdb0c0152}},	//   memz, stdy_, jwir, _kibä, 
   {{0x7c242091,0x9f400c09,0xc32c004b,0xdb0c012b}},	//   dwir, vskã_, _وٕن_, _jibä, 
   {{0x31342092,0x7dc401a0,0x7c24002a,0x00000000}},	//   _бейр, иётд, ewir, --, 
   {{0x2d540c8f,0x7c24002a,0x6db402ba,0x00000000}},	//   _nået_, fwir, уйбу, --, 
   {{0x7c2417b3,0x7c940075,0xaf60001d,0x00000000}},	// [1bd0] gwir, لشكا, _ማገልገ, --, 
   {{0x9f400e84,0x7d042093,0x7658021c,0x31782094}},	//   rskã_, agis, kyvy, lisz_, 
   {{0x7c2408a2,0xe8f8006b,0x6f0001d6,0x00000000}},	//   awir, енеч_, òlcu, --, 
   {{0x7c2404fe,0x27ec018c,0x9f402095,0x31781f17}},	//   bwir, _pven_, mská_, nisz_, 
   {{0x9f40048a,0x75200031,0xcbb4024b,0x78240aab}},	//   lská_, demz, _ағаш_, لعول, 
   {{0xdb0c039c,0xdb040638,0xbdf82096,0x36e800e7}},	//   _cibä, _sukö, _ثریا_, ۉرۉپ_, 
   {{0x9f4005a4,0x2d540499,0xdb0c019f,0x3cf8006c}},	//   nská_, _fået_, _dibä, एलचे_, 
   {{0x2d540184,0x5dac0ce5,0xa5240409,0x00000000}},	//   _gået_, _ﺳﺎﻟﺴ, умид, --, 
   {{0xe7042097,0x95b40329,0xe3b80128,0x9f4001d5}},	//   _مسای, ыршә, нби_, hská_, 
   {{0x61182098,0x399c0984,0x7d04059c,0x6ae003ef}},	//   _mālō, vísi_, zgis, _फ़ोर, 
   {{0x9f4002ec,0x75200636,0x7c240088,0x2d982099}},	//   jská_, bemz, zwir, _okse_, 
   {{0x9f400212,0xf5300272,0x7c240335,0x2d9800f2}},	//   dská_, _وإن_, ywir, _nkse_, 
   {{0x7d04209a,0xa0740049,0x00000000,0x00000000}},	//   vgis, уынш, --, --, 
   {{0x2d98209b,0x57d00e85,0x7c240b75,0x3f5401ab}},	//   _akse_, ﻟﺪﯨﺮ, vwir, _räus_, 
   {{0x2d54021d,0x3178002f,0x7d04209c,0x00000000}},	//   _nåes_, bisz_, tgis, --, 
   {{0x7c24209d,0x317803ef,0x12780100,0x6ae00098}},	//   twir, cisz_, _ראקע, _फ़ॉर, 
   {{0x5ba8209e,0x8c40209f,0x00000000,0x00000000}},	// [1be0] екам_, бете, --, --, 
   {{0x7c2420a0,0x200020a1,0x2120010b,0x2d540085}},	//   rwir, muki_, lekh_, _sået_, 
   {{0x7c2420a2,0x200020a3,0x2d980243,0x752001dc}},	//   swir, luki_, _fkse_, yemz, 
   {{0x588420a4,0xd7e820a5,0x7c241562,0x20000197}},	//   лыла, емде_, pwir, ouki_, 
   {{0x200020a6,0x1d98010f,0x8d94010f,0x7c2402b1}},	//   nuki_, _መብቶች_, _መጥቷል_, qwir, 
   {{0x2d5420a7,0xa8540abc,0xdbd00030,0x317820a8}},	//   _fåes_, решә, _müüt, zisz_, 
   {{0x200020a9,0x06cc01b9,0x795403b5,0x44f00572}},	//   huki_, _ৰাখি, _پێشا, ڭسىز, 
   {{0x200020aa,0xd90c20ab,0x550420ac,0x00000000}},	//   kuki_, _ریت_, учка, --, 
   {{0xe97020ad,0x12e420ae,0x200020af,0x9f400113}},	//   _بۇند, лінг, juki_, zská_, 
   {{0x752001fa,0x317803ef,0xd2440254,0x92681046}},	//   semz, wisz_, гэми, ерма_, 
   {{0x362400cd,0x0690024b,0x5fbc023b,0x00000000}},	//   _خواہ, _ﭘﺎﻳﯩ, _एंजल, --, 
   {{0x9f4005a4,0x2000206a,0x6ae0002f,0x32400020}},	//   vská_, fuki_, _फ़्र, _ንዘለኣ, 
   {{0x69c020b0,0xb4e0140e,0x9f4000ef,0xc1740027}},	//   _élev, थरी_, wská_, слящ, 
   {{0x9f400214,0x317806f7,0x00000000,0x00000000}},	//   tská_, sisz_, --, --, 
   {{0x317806f7,0x21200083,0x43800075,0xd06002a0}},	//   pisz_, bekh_, _دلوق, _ərən, 
   {{0x200020b1,0x9f400214,0xac180294,0x00000000}},	//   buki_, rská_, кобу_, --, 
   {{0x200020b2,0x6b7420b3,0xab7420b4,0x00000000}},	// [1bf0] cuki_, алау, агаш, --, 
   {{0x9f4000aa,0x00000000,0x00000000,0x00000000}},	//   pská_, --, --, --, 
   {{0xb36802b4,0x8aa420b5,0x4290010f,0xdd9001b5}},	//   _ሽወደን_, урад, _ማንነት_, _ژوپ_, 
   {{0x65b40f3d,0x2d9800b6,0x00000000,0x00000000}},	//   _tšhi, _ukse_, --, --, 
   {{0x6d4c042e,0x66e4018f,0x00000000,0x00000000}},	//   mjaa, аола, --, --, 
   {{0x6d4c20b6,0x28d40cd4,0x77840023,0x5c7800cf}},	//   ljaa, _ड्रि, бліз, _יארה, 
   {{0x200020b7,0xff580100,0x6d4c150d,0x34c000d3}},	//   zuki_, רבוך_, ojaa, _ẹdọ_, 
   {{0x6d4c20b8,0x69d420b9,0x00000000,0x00000000}},	//   njaa, _itze, --, --, 
   {{0x870420ba,0x13e401c8,0x20000048,0x7bc0008f}},	//   _مبال, амый_, xuki_, _émut, 
   {{0xdbd000a1,0x200020bb,0x466820bc,0xc98402ac}},	//   _rüüt, vuki_, _прем_, _руҳи, 
   {{0x216820bd,0x21c40341,0xdbd000a1,0x69d4000b}},	//   вини_, _kēhi_, _süüt, _jtze, 
   {{0x200020be,0x6d4c20bf,0x80dc02fa,0xdbd000b6}},	//   tuki_, jjaa, _ভাঙ্, _püüt, 
   {{0x2120007b,0x324002b4,0x65680177,0xb1740020}},	//   rekh_, _ንዘልኣ, mheh, _ብከምዚ_, 
   {{0x200020c0,0x263404c4,0x21200990,0xd1dc010f}},	//   ruki_, _kāo_, sekh_, ናለች_, 
   {{0x13d820c1,0x200020c2,0x644800cc,0xdea001d9}},	//   _দিয়, suki_, lxei, تیدی, 
   {{0x6d4c20c3,0x21c40341,0xdbd000b6,0x797c0341}},	//   gjaa, _nēhi_, _tüüt, kōwa, 
  
   {{0x69d40396,0x644816a5,0x2000019b,0x00000000}},	// [1c00] _atze, nxei, quki_, --, 
   {{0x0b4020c4,0x6d4c0132,0x644803b2,0x27fc0323}},	//   онун, ajaa, ixei, drwn_, 
   {{0x656820c5,0x4ef800ca,0xdb0c00e3,0x00000000}},	//   kheh, _בליג, _kibú, --, 
   {{0xd7f820c6,0x3f9820c7,0x394004db,0xd2380100}},	//   вук_, loru_, ñis_, כגעל, 
   {{0x386020c8,0x656820c9,0x69d420ca,0x00000000}},	//   áir_, dheh, _etze, --, 
   {{0x35b40121,0x00000000,0x00000000,0x00000000}},	//   әбир, --, --, --, 
   {{0x25fc06a7,0x964401a7,0x00000000,0x00000000}},	//   रंगी_, рэлд, --, --, 
   {{0x3f9802ef,0xa6e80014,0x741420cb,0x00000000}},	//   horu_, _ngươ, موبا, --, 
   {{0x3f9820cc,0x068020cd,0x534420ce,0x337402dc}},	//   koru_, йгән, ахна, йгир, 
   {{0x449420cf,0x9694009e,0x69d40028,0x847c0020}},	//   рвью_, _креш, _ytze, _ዕድመን_, 
   {{0x69c0063a,0x3f980770,0x656808c2,0xe7b420d0}},	//   _élet, doru_, bheh, _اللھ, 
   {{0x506420d1,0x65681ca5,0xd498012b,0x00000000}},	//   атга, cheh, _ирл_, --, 
   {{0x93880683,0xd0700020,0x6b84000d,0x00000000}},	//   _иска_, _ኣድላዩ_, ynhg, --, 
   {{0x3f9820d2,0x09d400ac,0x6d4c10a8,0xc0ec001d}},	//   goru_, _হিসা, wjaa, _ኅዳር_, 
   {{0xadd40106,0xfeb8042e,0x720400ea,0x00000000}},	//   собљ, لافت_, _اوعم, --, 
   {{0x7d6802ac,0x658000a2,0x417420d3,0x00000000}},	//   ашув_, tēhi, _وايس, --, 
   {{0x21c40299,0x4ae80027,0x00000000,0x00000000}},	// [1c10] _rēhi_, вьем_, --, --, 
   {{0x6d4c20d4,0x3f9820d5,0x8cb800cb,0x65800296}},	//   sjaa, coru_, _शृणो, rēhi, 
   {{0x21c40341,0x7a300306,0x00000000,0x00000000}},	//   _pēhi_, vótá, --, --, 
   {{0x65800299,0x797c00a2,0xb4e002a4,0x00000000}},	//   pēhi, tōwa, थरो_, --, 
   {{0x6c8420d6,0x7c84038e,0x2fc820d7,0x399c05c0}},	//   _طلسم, _дуре, _juag_, víst_, 
   {{0x2fc80179,0xa7a820d8,0x27fc0086,0xbd9c001d}},	//   _muag_, ыкла_, rrwn_, _ሀብታም_, 
   {{0x656804f7,0x2fc80179,0xb6c4002c,0xd6cc1b55}},	//   theh, _luag_, әсәй, رقي_, 
   {{0x799420d9,0x3afc0537,0xd6b80143,0x78a40560}},	//   _дисф, _tápà_, ুরূপ, żiva, 
   {{0x290c02ba,0x6448000f,0x79580049,0x65680027}},	//   _icea_, uxei, _титр_, rheh, 
   {{0x656820da,0x68e820db,0x63a0012a,0x3f9820dc}},	//   sheh, _heed, ulln, xoru_, 
   {{0x63a00043,0x68e820dd,0x26c420de,0x69c001b8}},	//   rlln, _keed, _iglo_, _éles, 
   {{0x68e804bb,0x65680197,0x3f9820df,0x63a0015e}},	//   _jeed, qheh, woru_, slln, 
   {{0x3f9820e0,0x343820e1,0x68e820e2,0x2fc8042a}},	//   toru_, _پسند_, _meed, _cuag_, 
   {{0x68e820e3,0x358c0422,0xdcf40078,0xfe440094}},	//   _leed, _ሕቶታት_, riyč, омгү, 
   {{0x25fc0774,0xdee402ac,0xdef800fc,0x00000000}},	//   रंटी_, _қони, кың_, --, 
   {{0x3f9820e4,0x68e80be0,0x290c20e5,0x00000000}},	//   soru_, _need, _ncea_, --, 
   {{0x3f980551,0x8c4020e6,0x2fc8006f,0x00000000}},	// [1c20] poru_, пете, _guag_, --, 
   {{0x290c038e,0x00000000,0x00000000,0x00000000}},	//   _acea_, --, --, --, 
   {{0xcf5420e7,0x68e820e8,0x2fc801f3,0x0f54007c}},	//   _הבית_, _beed, _zuag_, _היים_, 
   {{0x2fc801f3,0x26c40100,0x290c20e9,0x68e81d50}},	//   _yuag_, _aglo_, _ccea_, _ceed, 
   {{0x290c015e,0x68e820ea,0xf77800b8,0x00000000}},	//   _dcea_, _deed, аҧа_, --, 
   {{0x07b40075,0x34e00803,0x99e8005e,0x00000000}},	//   مهنة_, नर्द, _معرق_, --, 
   {{0x68e820eb,0xdb24009d,0x75880020,0x00000000}},	//   _feed, _پوځی, _ዝህልዎ_, --, 
   {{0x68e820ec,0xf3f804e7,0xf8b820ed,0x00540020}},	//   _geed, аниш_, _көл_, _ዝጸንሓ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2fc820ee,0x68e820ef,0x72181c3c,0xe80c20f0}},	//   _ruag_, _zeed, ажор_, _समता_, 
   {{0x68e820f1,0x21300039,0xcb98047b,0x2d8401b8}},	//   _yeed, _bayh_, רסיט, élek_, 
   {{0x2fc8042a,0x68e80080,0x15b8012b,0x00000000}},	//   _puag_, _xeed, _сызы_, --, 
   {{0x2fc801f9,0x91c813d3,0xf2c420f2,0x543420f3}},	//   _quag_, _संवै, _мөни, _درار, 
   {{0x2fc80069,0x5694044a,0x00000000,0x00000000}},	//   _vuag_, _таçт, --, --, 
   {{0xad24006e,0x43d000ea,0x00000000,0x00000000}},	//   يىسى, _وڅیړ, --, --, 
   {{0x2fc820f4,0x213014c5,0x09d40143,0x6ed8006c}},	//   _tuag_, _gayh_, _হিলা, _ब्रँ, 
   {{0x68e820f5,0x316802bb,0x636c0306,0x00000000}},	// [1c30] _reed, _ilaz_, _dúnf, --, 
   {{0x316802e3,0x68e820f6,0x7c840edd,0x25f80030}},	//   _hlaz_, _seed, чусе, _ईटली_, 
   {{0x636c0223,0x3944015e,0x68e820f7,0xdb0c0475}},	//   _fúnf, _bnms_, _peed, _zhbë, 
   {{0x9f5000f1,0x68e803fa,0xe91801f5,0xad4000e7}},	//   _avyè_, _qeed, роді_, _تۉرۉ, 
   {{0xbae800ac,0x2d8802bf,0x68e820f8,0x31680ddc}},	//   _পারছ, mnae_, _veed, _mlaz_, 
   {{0xe73820f9,0xadec02e0,0x68e8027e,0x7c70001d}},	//   рек_, _जबान_, _weed, ቸግራል_, 
   {{0x636c20fa,0x68e820fb,0xfb8420fc,0x2d8820fd}},	//   _húng, _teed, _хыян, onae_, 
   {{0x2d8820fe,0xa9080012,0x636c0229,0x00000000}},	//   nnae_, _خٲرٕ_, _kúng, --, 
   {{0x25fc20ff,0x2d882100,0x3860077d,0x00000000}},	//   रूजी_, inae_, ùirt_, --, 
   {{0x31682101,0x8220011a,0xe3580074,0x50cc004f}},	//   _alaz_, _འགྱི_, ршиш_, _ānāṃ_, 
   {{0xe1242102,0x31682103,0x7af802e8,0x00000000}},	//   омни, _blaz_, óvti, --, 
   {{0x24182104,0xd1c40007,0x00000000,0x00000000}},	//   _воды_, ўляе_, --, --, 
   {{0x2d882105,0x9fc80320,0x1fa801d9,0x9f4001d4}},	//   dnae_, ргга_, икми_, mskú_, 
   {{0x2d8820fe,0x442c02b2,0x65800299,0x3168006b}},	//   enae_, _isg_, rēhu, _elaz_, 
   {{0x316811c6,0x442c2106,0x9d4400dd,0x3eac0056}},	//   _flaz_, _hsg_, يئرن, ådt_, 
   {{0x2d88165f,0x316808be,0x9f4002d9,0x636c02b2}},	//   gnae_, _glaz_, nskú_, _búng, 
   {{0x636c0075,0x442c002a,0x00000000,0x00000000}},	// [1c40] _cúng, _jsg_, --, --, 
   {{0x2d881658,0x1dd02107,0x9f040061,0x636c0306}},	//   anae_, _दंपत, _بودو, _dúng, 
   {{0x442c2108,0xb604012b,0x636c176c,0x0bb800ec}},	//   _lsg_, _kráş, _túnf, рттө_, 
   {{0x9f4000c0,0x28d404c7,0x00000000,0x00000000}},	//   jskú_, डुलि, --, --, 
   {{0x636c2109,0x9f4002cc,0x80a000aa,0x36d41310}},	//   _gúng, dskú_, _गुमे, полр, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5f1000cb,0x636c00b8,0x645c210a,0x442c0201}},	//   _तान्_, _múnd, øsin, _asg_, 
   {{0x2c1c0252,0x2000018f,0x29d4018f,0x00000000}},	//   নিৰে_, krki_, _хўрс, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x636c0028,0x8c1800ca,0x00000000,0x00000000}},	//   _núnd, סויי, --, --, 
   {{0x3168210b,0x8b0000aa,0x442c210c,0x9f4001d4}},	//   _plaz_, _úřed, _esg_, bskú_, 
   {{0x442c0496,0x77a400cc,0xdc380386,0x00000000}},	//   _fsg_, dòxi, hçıv, --, 
   {{0x31680151,0xe73001b8,0x00000000,0x00000000}},	//   _vlaz_, _غصے_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x442c006f,0x0dc8210d,0x636c210e,0xdce40055}},	//   _zsg_, руги_, _dúnd, _akkı, 
   {{0x3168091d,0xc0d0010f,0x00000000,0x00000000}},	//   _ulaz_, ጥቷል_, --, --, 
   {{0xfbd0210f,0x2d882110,0x636c2111,0xa1140046}},	// [1c50] نتل_, rnae_, _fúnd, _رسيږ, 
   {{0x8aa42112,0x636c2113,0xdcf40828,0x2d8811ae}},	//   оред, _vúng, riyā, snae_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdeb40107,0xd5a42114,0xd36400e2,0x636c06b4}},	//   _מפתח_, _سف_, _ړه_, _túng, 
   {{0x5f100828,0xef3402b4,0x9f4002d9,0x9cd402c3}},	//   _ताम्_, _ብምድል, vskú_, _מורה_, 
   {{0x442c062d,0xd2440272,0x00000000,0x00000000}},	//   _rsg_, _كن_, --, --, 
   {{0xfaa403d6,0x37a800fc,0xa954021d,0x9f4002cc}},	//   тшăн, цтцн_, _екві, tskú_, 
   {{0x442c2115,0x20001de0,0x09bc0560,0x636c0034}},	//   _psg_, yrki_, _གངྒ_, _múne, 
   {{0x02c401a0,0x9f4002cc,0xe694077f,0xf48400b7}},	//   оқли_, rskú_, _کلاد, дуќн, 
   {{0x468002ac,0x00000000,0x00000000,0x00000000}},	//   _оқла, --, --, --, 
   {{0xe2982116,0xd24c049d,0x636c0272,0x26cc05e1}},	//   сан_, ۆنی_, _rúnd, āloā_, 
   {{0x442c2117,0xd24c00e2,0xe2980116,0x00000000}},	//   _tsg_, چنی_, иаҿ_, --, 
   {{0x55502118,0x645c2119,0xd24c211a,0x442c211b}},	//   _سپور, äsid, ننی_, _usg_, 
   {{0xdc38038c,0x80a00095,0x00000000,0x00000000}},	//   xçıv, _गुणे, --, --, 
   {{0x75f8012b,0x81a800ea,0xa49000ea,0x00000000}},	//   _gäzā, _وضعې_, _تیښت, --, 
   {{0x636c211c,0xbae802fa,0xadec0098,0x00000000}},	//   _dúne, _পাইছ, _जबरन_, --, 
   {{0x5bc4211d,0x636c0229,0x00000000,0x00000000}},	// [1c60] سقال, _túnd, --, --, 
   {{0x636c211e,0x9cc800df,0x10380107,0x2f1401b8}},	//   _fúne, рыңа_, _פגיע, rúgó_, 
   {{0x069000c3,0x6704211f,0xeb5400bf,0x00000000}},	//   _ﭘﺎﻛﯩ, _राजक_, بىلگ, --, 
   {{0x25700270,0x9f040063,0xad240411,0x00000000}},	//   _hálf_, _بوگو, _قىپى, --, 
   {{0xe7f42120,0x1cb800ea,0x00000000,0x00000000}},	//   ुंगा_, _دادب_, --, --, 
   {{0x50180240,0x37d80143,0x00000000,0x00000000}},	//   מונו, _সিআর, --, --, 
   {{0xc71400ea,0xf8b80197,0x00000000,0x00000000}},	//   ستوئ_, сөң_, --, --, 
   {{0x1dbc00cb,0xd9180046,0x7afc015e,0x73d82121}},	//   ्दित, _ديرش_, _hdrt, одир_, 
   {{0x186800b8,0x00000000,0x00000000,0x00000000}},	//   _уааи_, --, --, --, 
   {{0xb4ac02d2,0xca7402b4,0xb4bc0698,0x00000000}},	//   _गरी_, በርኩም_, _आणी_, --, 
   {{0x1dbc0add,0x00000000,0x00000000,0x00000000}},	//   ्दात, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x24482122,0x00000000,0x00000000,0x00000000}},	//   _وجهي_, --, --, --, 
   {{0x645c0139,0x00000000,0x00000000,0x00000000}},	//   äsie, --, --, --, 
   {{0x7f942123,0xd2440182,0x313400cc,0x00000000}},	//   харх, _хэли, _жейр, --, 
   {{0x646400df,0xad242124,0x8d740801,0x8230059b}},	//   _ätiý, بىرى, سازا, _أروا, 
   {{0x0dc80362,0x01342125,0x0ca8044a,0x00000000}},	// [1c70] руҳи_, _سعيد, стви_, --, 
   {{0x836801e2,0x65a400cd,0x3f84008f,0x61f4006b}},	//   _ስለዚህ_, róhi, émut_, _äglä, 
   {{0x6e94038e,0xadb4021c,0x00000000,0x00000000}},	//   _цину, _обош, --, --, 
   {{0x636c00c4,0xb4bc040e,0xdd902126,0x00000000}},	//   _kúnc, _आणू_, _لوپ_, --, 
   {{0xf7702127,0x19c02128,0xa6c82129,0xf9900657}},	//   گان_, тәрг, олла_, دبل_, 
   {{0x80a00098,0x803800ca,0xfcac00cf,0x00000000}},	//   _ऐडसे, פנוע_, _ליכּ, --, 
   {{0x797c0296,0x95d40087,0x00000000,0x00000000}},	//   kōwh, үдәт_, --, --, 
   {{0xa9680122,0x00000000,0x00000000,0x00000000}},	//   _بمرم_, --, --, --, 
   {{0x291c0083,0x636c0223,0x00000000,0x00000000}},	//   mfwa_, _rúnb, --, --, 
   {{0xe1f8212a,0x65a41cca,0x066400d5,0xa90c0030}},	//   ого_, jóhv, _ٹائپ, _हाँफ_, 
   {{0xdb0c0078,0x85440254,0x00000000,0x00000000}},	//   _kibò, _нэде, --, --, 
   {{0x291c212b,0xdb0c012b,0x00000000,0x00000000}},	//   nfwa_, _sibü, --, --, 
   {{0x41cc1953,0xdeb80cb2,0x00000000,0x00000000}},	//   _संवस, ቲውን_, --, --, 
   {{0xd42400dd,0xe8040c5f,0x00000000,0x00000000}},	//   _آڻين_, _रिना_, --, --, 
   {{0x291c212c,0x636c0417,0x02a40182,0x7094001d}},	//   kfwa_, _túnb, _эрдм, _ያድርጉ_, 
   {{0x61e0212d,0x27e8212e,0x00000000,0x00000000}},	//   mpll, šany_, --, --, 
   {{0x1fb4212f,0x67202130,0xdbd4039c,0x3f84034c}},	// [1c80] _осор, _oblj, _mäçe, émus_, 
   {{0xbb5403b5,0xdb0c01d5,0x00000000,0x00000000}},	//   رۆزب, _ribó, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d8401b8,0xdbd400fc,0x00000000,0x00000000}},	//   élet_, _näçe, --, --, 
   {{0xb4ac0357,0x60240271,0x87d42131,0x257002e8}},	//   _गरे_, _wɔmf, وبوس_, _máld_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8b0002ef,0xb0a42132,0x745400d5,0x00000000}},	//   _úřad, _गुनग, کھائ, --, 
   {{0xd8242133,0x743412a3,0x86b001d2,0xf48400e3}},	//   _одби, ениф, тәуі, ٹابی, 
   {{0xe8040d04,0x00000000,0x00000000,0x00000000}},	//   _रिया_, --, --, --, 
   {{0x79800379,0xd7f8001e,0x32542134,0xd62803a7}},	//   _hmmw, _гуҧ_, евор, _мозе_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe7f4002f,0x672001df,0x80a0064c,0x00000000}},	//   ुंचा_, _zblj, _गुहे, --, 
   {{0xc0c8038e,0x00000000,0x00000000,0x00000000}},	//   дуре_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7980007b,0x490c0303,0x43902135,0x867800cf}},	//   _ommw, _डालो_, _шашс, ַרמו, 
   {{0x9f4002dd,0xebd8041c,0x320c0101,0x00000000}},	//   mský_, здаш_, mudy_, --, 
   {{0x9f4002d6,0x636c0009,0x21240329,0xf41c0143}},	// [1c90] lský_, _húna, _ñoha_, তিকর_, 
   {{0x636c0a03,0x79801985,0x257002e8,0x00000000}},	//   _kúna, _ammw, _tálg_, --, 
   {{0xdeb00256,0x291c2136,0x9f401301,0x25700247}},	//   _бұры, tfwa_, nský_, _hále_, 
   {{0x2d8c0d8c,0xd7ec0b0f,0x00000000,0x00000000}},	//   _ñee_, ڭكو_, --, --, 
   {{0x291c2137,0xba742138,0x636c03e0,0x9d180282}},	//   rfwa_, _یافت, _lúna, _צושט, 
   {{0x6d5c2139,0x79800266,0x00000000,0x00000000}},	//   _hosa, _emmw, --, --, 
   {{0x6d5c213a,0x9f400212,0x25700223,0xe2c80152}},	//   _kosa, jský_, _lále_, үлид_, 
   {{0x6d5c213b,0x9f400212,0x6b8401e3,0x62a402a0}},	//   _josa, dský_, lihg, _əroğ, 
   {{0x6d5c213c,0x4ad000b3,0xe36400bf,0x00000000}},	//   _mosa, _तलाव, екпи, --, 
   {{0x6d5c213d,0x636c0984,0x27ec0249,0x34440108}},	//   _losa, _búna, _iwen_, түши_, 
   {{0x636c0272,0xf770006e,0x69c80249,0x27ec08be}},	//   _cúna, _ئاق_, _kiee, _hwen_, 
   {{0x6d5c213e,0x27ec213f,0x636c0075,0xa3d42140}},	//   _nosa, _kwen_, _dúna, _зодч, 
   {{0x27ec065e,0x65682141,0x00000000,0x00000000}},	//   _jwen_, mkeh, --, --, 
   {{0x27ec137f,0x443c2142,0x257002ef,0x9f402143}},	//   _mwen_, mvu_, _dále_, bský_, 
   {{0x6d5c2144,0x27ec2145,0x443c2146,0x21682147}},	//   _bosa, _lwen_, lvu_, _ники_, 
   {{0x6d5c2148,0x69c82149,0x6568214a,0x443c00e9}},	//   _cosa, _niee, nkeh, ovu_, 
   {{0x6d5c214b,0x443c214c,0x6568001e,0x10a0044a}},	// [1ca0] _dosa, nvu_, ikeh, _йиън, 
   {{0x6d5c02b0,0x443c214d,0xed5802dc,0x90980107}},	//   _eosa, ivu_, поӣ_, _מספק, 
   {{0x6d5c214e,0x69c8214f,0x27ec2150,0x443c2151}},	//   _fosa, _biee, _awen_, hvu_, 
   {{0x443c2152,0x6d5c2153,0x27ec0278,0x63a02154}},	//   kvu_, _gosa, _bwen_, holn, 
   {{0x69c82155,0x63a02156,0x9f4000aa,0x443c0091}},	//   _diee, koln, zský_, jvu_, 
   {{0x443c00c4,0x27ec0008,0x6d5c051f,0x69c8006f}},	//   dvu_, _dwen_, _zosa, _eiee, 
   {{0x69c80243,0x443c2157,0x6d5c2158,0x27ec2159}},	//   _fiee, evu_, _yosa, _ewen_, 
   {{0x9f4005a4,0x09d401b9,0x27ec008e,0x636c215a}},	//   vský_, _হিচা, _fwen_, _rúna, 
   {{0x443c020c,0x636c02e8,0x80a004c7,0x00000000}},	//   gvu_, _súna, _गुले, --, 
   {{0x320c215b,0x9f400214,0x63a0215c,0xe8042120}},	//   tudy_, tský_, goln, _रिता_, 
   {{0x27ec07e1,0x69c8005e,0x443c215d,0x25700113}},	//   _zwen_, _yiee, avu_, _sále_, 
   {{0x9f40215e,0x443c215f,0xb484002c,0x27ec0086}},	//   rský_, bvu_, _икеһ, _ywen_, 
   {{0x63a02160,0x443c000d,0x15fc03bf,0x00000000}},	//   boln, cvu_, ईओवर_, --, 
   {{0x6d5c2161,0x9f402095,0x636c014e,0x63a02162}},	//   _sosa, pský_, _túna, coln, 
   {{0x636c2163,0x25700229,0x00000000,0x00000000}},	//   _kúnn, _wále_, --, --, 
   {{0xd13805bc,0x6d5c2164,0x257001d4,0xdeb80020}},	//   _ххк_, _qosa, _tále_, ሲልካ_, 
   {{0x6d5c2165,0xc0f40020,0x00000000,0x00000000}},	// [1cb0] _vosa, ፍኦም_, --, --, 
   {{0x6d5c2166,0x656800c0,0x00000000,0x00000000}},	//   _wosa, zkeh, --, --, 
   {{0x6d5c2167,0x27ec2168,0x69c82169,0x443c216a}},	//   _tosa, _swen_, _piee, zvu_, 
   {{0x27ec216b,0x6d5c216c,0xfaa4216d,0xd70c216e}},	//   _pwen_, _uosa, ушун, _साउथ_, 
   {{0xfe70049d,0x63a0216f,0xdce401d3,0x00000000}},	//   _ندێ_, yoln, _ulkā, --, 
   {{0x443c074e,0x69c82170,0x00000000,0x00000000}},	//   vvu_, _wiee, --, --, 
   {{0x63a02171,0x656800c0,0x00000000,0x00000000}},	//   voln, tkeh, --, --, 
   {{0x443c03e8,0x63a0002f,0x27ec0078,0x636c01ca}},	//   tvu_, woln, _twen_, _cúnn, 
   {{0x65680602,0x67d42172,0x636c0223,0x63a02173}},	//   rkeh, _розу, _dúnn, toln, 
   {{0x443c2174,0x65682175,0xd5a404e7,0x93402176}},	//   rvu_, skeh, _یللی, анье, 
   {{0x443c2177,0xf7d00853,0x636c0537,0x466800fc}},	//   svu_, ﮕﯩﻠﻪ, _fúnn, _эрам_, 
   {{0x98a403f2,0x636c0229,0x63a02178,0x7ec800e3}},	//   leoā_, _gúnn, soln, _lépü, 
   {{0x63a00f29,0xb0a40e8f,0x662000d1,0x42c00143}},	//   poln, _गुदग, _महुए_, োরেশ, 
   {{0x25ac2179,0xffa405bc,0xf1b40121,0x2d84000b}},	//   llel_, улгү, _ﭼﯩﻘﻘ, èlen_, 
   {{0x25ac0197,0x539802c3,0x8e80217a,0xdb0c00f2}},	//   olel_, _קיצו, агре, _kibö, 
   {{0xd00c00a3,0xe044217b,0x00000000,0x00000000}},	//   _ڀلي_, _ании, --, --, 
   {{0x636c00c0,0x91b80107,0x1dd00095,0x00000000}},	// [1cc0] _júno, _קמפי, _दूरत, --, 
   {{0x25ac217c,0x9f400579,0x00000000,0x00000000}},	//   hlel_, rskó_, --, --, 
   {{0xefe0010f,0x25ac012b,0x00000000,0x00000000}},	//   ናየው_, klel_, --, --, 
   {{0x5884217d,0xa3d0011c,0x00000000,0x00000000}},	//   кыла, वदा_, --, --, 
   {{0x7d0800d3,0x636c00d3,0x25ac217e,0xd85002ba}},	//   _eèrà, _rúnn, dlel_, релө, 
   {{0x636c0e0b,0x25ac00af,0x7ec800e3,0xa9c400bf}},	//   _súnn, elel_, _gépü, _ۅزقو, 
   {{0xd5b8217f,0x645c2180,0x25ac11c6,0x75d40a12}},	//   мси_, äsin, flel_, ديبا, 
   {{0x25ac2181,0x3dc000f1,0x69b40030,0x00000000}},	//   glel_, nmiw_, ेषणी, --, 
   {{0xd0e00d68,0x41cc00a1,0x18a400b8,0xf8b01b64}},	//   _क्षण_, _संउस, _раам, _اکا_, 
   {{0x31bc00cb,0x636c0306,0x45d0001e,0x00000000}},	//   ोद्ध, _dúno, ыцәт, --, 
   {{0xcb100240,0xdb0c0638,0x25ac08be,0x23780222}},	//   בלת_, _fibö, blel_, ësja_, 
   {{0x3a380426,0x82a0001e,0x00000000,0x00000000}},	//   _msrp_, ршье, --, --, 
   {{0x3a3801d6,0x636c0229,0x8fe000ec,0x00000000}},	//   _lsrp_, _kúnl, шәйҙ, --, 
   {{0x823001ac,0x82600061,0x403401c3,0x00000000}},	//   _چريا, اهێن, јерс, --, 
   {{0x636c0272,0xc33002c3,0xe518025c,0x25702182}},	//   _múnl, _כוס_, _धामि_, _hála_, 
   {{0x51842183,0x25702184,0x46380100,0xb1140106}},	//   _шула, _kála_, ועלע, _смиш, 
   {{0x3cd42185,0x636c00d3,0xd1f80020,0x00000000}},	// [1cd0] ржус, _oúnl, ጋእቲ_, --, 
   {{0x25702186,0x3a380083,0xbb74005b,0xf3f4007e}},	//   _mála_, _bsrp_, агуј, _আমাৰ_, 
   {{0xe80414d1,0x257000c4,0x3a3800b0,0x3dc00428}},	//   _रिहा_, _lála_, _csrp_, bmiw_, 
   {{0x3a380693,0x67d42187,0x00000000,0x00000000}},	//   _dsrp_, году, --, --, 
   {{0x60240130,0x2d88165f,0x31b800ef,0x4b500012}},	//   _kɔma, miae_, céze_, _پێار, 
   {{0x2d88044f,0x6f14008e,0x636c0306,0x00000000}},	//   liae_, ngzc, _cúnl, --, 
   {{0x25ac2188,0x6ab402b0,0x00000000,0x00000000}},	//   tlel_, _uzzf, --, --, 
   {{0x22480b53,0x2d88044f,0x69c42189,0x2570218a}},	//   _čak_, niae_, _сөзб, _bála_, 
   {{0x257000c4,0x69d4218b,0x636c00d3,0xe7dc0143}},	//   _cála_, _huze, _fúnl, _ঠিকঠ, 
   {{0x68f8218c,0x69d4218d,0x25ac0212,0x2d881658}},	//   lawd, _kuze, slel_, hiae_, 
   {{0x69d4218e,0xa1882112,0xa1c42028,0x2d88006a}},	//   _juze, ебна_, лбод, kiae_, 
   {{0x69d4218f,0x9f5c00bd,0x68f82190,0x257001ca}},	//   _muze, čtí_, nawd, _fála_, 
   {{0x69d42191,0x2d882192,0x70180049,0x27fc0086}},	//   _luze, diae_, кірт_, nswn_, 
   {{0x02c0039c,0x69d408be,0xe2982193,0x9ea82194}},	//   _килү, _ouze, _пал_, евга_, 
   {{0x2d882195,0xe80c05d5,0xab680098,0x3eac0c8f}},	//   fiae_, _समझा_, zyżó, ædt_, 
   {{0x2d88165f,0x3a380308,0xdd100101,0xdca41454}},	//   giae_, _rsrp_, _düşu, габи, 
   {{0x69d42196,0x1c442197,0x68f82198,0xf1a80061}},	// [1ce0] _auze, ынам, dawd, _جاوه_, 
   {{0x69d42199,0x3a3801dc,0xe80c006c,0x4ad800b6}},	//   _buze, _psrp_, _समजा_, मँगव, 
   {{0xd944219a,0x2d881658,0x69d4219b,0x636c0223}},	//   лежи, biae_, _cuze, _rúnl, 
   {{0x2d88165f,0x69d4219c,0x68f8219d,0x00000000}},	//   ciae_, _duze, gawd, --, 
   {{0xb6c80191,0x645c0027,0x00000000,0x00000000}},	//   ھاتے_, äsil, --, --, 
   {{0x69d4219e,0x07a0219f,0xc7a021a0,0xb6c800d5}},	//   _fuze, бачн, бичк, پاتے_, 
   {{0x2a34009e,0x69d421a1,0xea640012,0x257021a2}},	//   _кэтр, _guze, _پھلی, _sála_, 
   {{0x636c0075,0x68f80060,0xa3d41ab7,0x257021a3}},	//   _dúnm, cawd, _ांश_, _pála_, 
   {{0x69d402fb,0x349402b3,0x938821a4,0x0680006e}},	//   _zuze, рапр, есна_, игән, 
   {{0x69d40d7f,0x28b8038e,0x355400e2,0x2d880034}},	//   _yuze, _русэ_, انکز, ziae_, 
   {{0x3938010f,0x636c0223,0x60c802df,0x2d880034}},	//   _በምዕራ, _gúnm, əlmə, yiae_, 
   {{0x257002c6,0x7648015e,0xd13821a5,0x2d8802bf}},	//   _tála_, _irdy, ххо_, xiae_, 
   {{0x2d881658,0x645c21a6,0x00000000,0x00000000}},	//   viae_, øsit, --, --, 
   {{0x4478007c,0x00e400c3,0x00000000,0x00000000}},	//   _אנדע, _ﺋﯩﺸﻘ, --, --, 
   {{0x2d88044f,0x1b1802fa,0x636c0528,0x00000000}},	//   tiae_, ড়াই_, _oúnj, --, 
   {{0x69d421a7,0x2d88034c,0x8c34041c,0x00000000}},	//   _ruze, uiae_, лобӣ_, --, 
   {{0x2d880d8e,0x69d421a8,0x3178015e,0x00000000}},	// [1cf0] riae_, _suze, mhsz_, --, 
   {{0x2d88044f,0x69d421a9,0x68f8007b,0xadd80116}},	//   siae_, _puze, wawd, _имоу_, 
   {{0x2d881658,0x68f821aa,0x69d403b4,0x00000000}},	//   piae_, tawd, _quze, --, 
   {{0x69d421ab,0x888001d9,0x636c0537,0xb33c043b}},	//   _vuze, میزن, _rúnm, koħo, 
   {{0x68f80066,0x636c0229,0x0ca821ac,0xfb2400c3}},	//   rawd, _dúnj, _سطحي_, شرەپ, 
   {{0x68f8009c,0x69d421ad,0x186421ae,0xa7a81166}},	//   sawd, _tuze, раши_, ъкла_, 
   {{0x7f3c0282,0x9ba021af,0x636c0537,0x6f0401e8}},	//   געוו, _بەلى, _fúnj, _mdhc, 
   {{0x49b804c3,0xd3440122,0x68f80140,0xe40400b7}},	//   _سازد_, یینه_, qawd, азип, 
   {{0x27fc0337,0x00000000,0x00000000,0x00000000}},	//   qswn_, --, --, --, 
   {{0x2d9807b5,0xe3b00075,0x636c21b0,0x00000000}},	//   _ljse_, غرة_, _túnm, --, 
   {{0xe29821b1,0xc5f401d9,0x2b400306,0x6724013c}},	//   тан_, _ёғи_, idhc_, õhju, 
   {{0xa068005b,0xe0440678,0xd24c02ac,0xf6f00223}},	//   вама_, анми, بچه_, _iṣẹt, 
   {{0x10a00128,0x320c21b2,0xdfa421b3,0x00000000}},	//   жиян, ardy_, لحسي, --, 
   {{0x25700223,0x60d0015b,0x30740027,0x5eb80143}},	//   _kálo_, _ņemā, суюс, _আলবে, 
   {{0x0fc010aa,0x9cf421b4,0x929000b7,0x00000000}},	//   ійсн, ичаш, _маљц, --, 
   {{0x2570048a,0xdcb021b5,0xaaa80227,0x00000000}},	//   _málo_, قىز_, _कड़क, --, 
   {{0x25700223,0x5ba80027,0xa2c80095,0x8c4000b8}},	// [1d00] _lálo_, вкам_, _हृत्, оете, 
   {{0xdcf421b6,0x2ee002bb,0x00000000,0x00000000}},	//   ıcın, _gfhf_, --, --, 
   {{0x067c024b,0x19f8009e,0x629c002a,0x00000000}},	//   ﺭﺍﻧﯩ, тэзь_, ßsoh, --, 
   {{0xdca4006b,0x5ca40e44,0x4e2402ba,0x00000000}},	//   _вами, _вимб, _тоюн_, --, 
   {{0x97c421b7,0x31b803aa,0x4810021d,0x88800094}},	//   айде, néza_, жміс, олцж, 
   {{0x320c01ec,0xc6d00411,0x68ec03c2,0xaf340222}},	//   yrdy_, يتىت, ðadr, _ብዝሓለ, 
   {{0x31b80186,0xf8b800ec,0xf62800bf,0x00000000}},	//   héza_, төң_, اتتۇ_, --, 
   {{0x636c21b8,0x00000000,0x00000000,0x00000000}},	//   _fúnk, --, --, --, 
   {{0x68ec0b07,0xa9980074,0x00000000,0x00000000}},	//   ñade, _сърф_, --, --, 
   {{0x33740027,0x68f401d4,0x00000000,0x00000000}},	//   сгор, ľadň, --, --, 
   {{0x0bb40240,0x200c05e1,0x6f04015e,0xa2c821b9}},	//   שלים_, _āfia_, _rdhc, _हृद्, 
   {{0xc68c01b5,0x672c0070,0x00000000,0x00000000}},	//   _تِم_, đaje, --, --, 
   {{0x490400b3,0x00000000,0x00000000,0x00000000}},	//   हणतो_, --, --, --, 
   {{0x35a002b4,0xcfa401c3,0x00000000,0x00000000}},	//   _ውህበት_, ршми, --, --, 
   {{0x59a421ba,0x9f400139,0x00000000,0x00000000}},	//   गकार, yskö_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x31b801d4,0x7cd80613,0x3d180030,0x8f08044a}},	// [1d10] céza_, рмур_, _फारे_, _ихна_, 
   {{0x8ae410aa,0x9ec800cb,0x6fb400e2,0xac9411aa}},	//   ріал, ṇāya_, _دمخا, _ҳамш, 
   {{0x2d9801f1,0x636c00d3,0x833400cf,0x1fe00143}},	//   _tjse_, _súnk, שאבס_, _বিএস, 
   {{0x645c0638,0xac9401a7,0x2bd821bb,0x00000000}},	//   äsik, _гамш, _ماسک_, --, 
   {{0x66e421bc,0x41d009c5,0x3f84038a,0x257000d3}},	//   бола, _संघस, ëmug_, _sálo_, 
   {{0xdc3800b9,0x8038007c,0x7784021d,0x00000000}},	//   _געשר, ינדע_, оліз, --, 
   {{0x8234010f,0xb9e401f5,0x00000000,0x00000000}},	//   _ይካሄዳ, _міти, --, --, 
   {{0xe29821bd,0x636c0010,0xfd7c0200,0x257000f2}},	//   ғам_, _túnk, ﻠﻌﺎﻥ_, _gáll_, 
   {{0x636c019f,0x2168021b,0x39400237,0xa2c818eb}},	//   _húni, ҳини_, ɾis_, हेन्, 
   {{0xc6a421be,0x36d401f1,0x490c00bd,0xdcf4012b}},	//   _креи, _дофр, डलको_, kiyğ, 
   {{0x216821bf,0x636c21c0,0x6144182a,0xe29821c1}},	//   гини_, _júni, бена, ѓам_, 
   {{0x636c21c2,0x249c042a,0x31b803aa,0x00000000}},	//   _múni, _txwm_, téza_, --, 
   {{0x232821c3,0x636c02ba,0x64c401d9,0x00000000}},	//   _боли_, _lúni, _ايشل, --, 
   {{0x442c0a65,0x257002b2,0x00000000,0x00000000}},	//   _ipg_, _málm_, --, --, 
   {{0xf4241c98,0x1d0821c4,0x442c0055,0x2bbc21c5}},	//   _འདོད_, леви_, _hpg_, ्गना, 
   {{0x442c025e,0x00000000,0x00000000,0x00000000}},	//   _kpg_, --, --, --, 
   {{0xd114023c,0x645c02eb,0x00000000,0x00000000}},	// [1d20] _הקפה_, äsih, --, --, 
   {{0x442c21c6,0x200021c7,0x636c0270,0x3ce000c2}},	//   _mpg_, mski_, _búni, sciv_, 
   {{0x200021c8,0x257021c9,0x00000000,0x00000000}},	//   lski_, _páll_, --, --, 
   {{0x442c0085,0x200021ca,0x6e2002ba,0x5f440122}},	//   _opg_, oski_, àlbe, _ئنگل, 
   {{0x200021cb,0xf4240037,0x644c00e9,0x442c0f37}},	//   nski_, _འདེད_, _šain, _npg_, 
   {{0x394002b3,0x7c2421cc,0xc7a012a3,0x07a00947}},	//   žis_, mtir, пичк, пачн, 
   {{0x7c2421cd,0xd94421ce,0xe31808be,0x8af810bc}},	//   ltir, _леви, ྱུནཔ_, _תהלי, 
   {{0xd5b8173a,0x200000b6,0x442c21cf,0xdb1c059b}},	//   ысл_, kski_, _bpg_, impí, 
   {{0x7c2421d0,0x200021d1,0xd3440063,0x94a818b4}},	//   ntir, jski_, ییچه_, ытка_, 
   {{0x20000406,0x7c2421d2,0x60d421d3,0x00000000}},	//   dski_, itir, _agym, --, 
   {{0x7c240063,0x60240130,0x200007e7,0x636c0a03}},	//   htir, _dɔmm, eski_, _lúnw, 
   {{0x200021d4,0x00000000,0x00000000,0x00000000}},	//   fski_, --, --, --, 
   {{0x442c21d5,0x7c2400e9,0x2bbc0095,0x00000000}},	//   _gpg_, jtir, ्गमा, --, 
   {{0x7c2421d6,0x60d400cd,0x40340f0e,0x19bc0200}},	//   dtir, _egym, џерс, ﺭﯨﻤﺠ, 
   {{0x7c2421d7,0x442c00b0,0x00000000,0x00000000}},	//   etir, _zpg_, --, --, 
   {{0x7c2421d8,0x200021d9,0xfb3401a7,0x95f802fa}},	//   ftir, bski_, үнтэ, _ইমাম_, 
   {{0x7c2421da,0xdb681e92,0xfe700191,0x442c00b7}},	// [1d30] gtir, _ቱሪዝም_, ودہ_, _xpg_, 
   {{0x636c197c,0x645c0027,0x00000000,0x00000000}},	//   _púni, äsii, --, --, 
   {{0x7c2421db,0x25701cca,0x60d40101,0x2bbc21dc}},	//   atir, _sálm_, _ygym, ्गबा, 
   {{0xac1821dd,0x7c2421de,0x636c00d3,0x00000000}},	//   _кому_, btir, _fúnw, --, 
   {{0x7c2421df,0x636c00d3,0xc8880075,0x87d000e3}},	//   ctir, _gúnw, دخال_, سےات, 
   {{0x636c03e2,0x00000000,0x00000000,0x00000000}},	//   _túni, --, --, --, 
   {{0xf424043b,0x65c40129,0xe8040098,0x200001d4}},	//   _འདུད_, обка, _रिका_, zski_, 
   {{0x240821e0,0x200021e1,0x442c0335,0xa2c800cb}},	//   ании_, yski_, _ppg_, _हृष्, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa20421e2,0x00000000,0x00000000,0x00000000}},	//   опод, --, --, --, 
   {{0x200021e3,0x7c2401a7,0xe6940272,0xa1b821e4}},	//   wski_, ztir, _بلاد, иумф_, 
   {{0x200021e5,0x7c2421e6,0x602421e7,0x245421e8}},	//   tski_, ytir, _wɔmm, _وناس, 
   {{0x442c21e9,0x307400f8,0x844407bc,0xdee400ec}},	//   _upg_, пурс, _دخال, жоги, 
   {{0x200021ea,0xc0cc01e2,0x00000000,0x00000000}},	//   rski_, _በኩል_, --, --, 
   {{0x644821eb,0x45240002,0x636c00d3,0x06a800dc}},	//   lvei, _རྡོར_, _súnw, গেরি, 
   {{0x200021ec,0x5bd000cb,0x60d400f2,0xdd1401e0}},	//   pski_, तद्व, _ugym, تورخ, 
   {{0x644821ed,0x00000000,0x00000000,0x00000000}},	// [1d40] nvei, --, --, --, 
   {{0x644821ee,0x9b04024b,0x3f6800ea,0xda640075}},	//   ivei, ізед, _چټکۍ_, ياضي, 
   {{0x7c2421ef,0x628021f0,0x2f54001e,0x64480027}},	//   stir, nzlo, _хтыс, hvei, 
   {{0xb4d821f1,0x257006b4,0x00000000,0x00000000}},	//   _ाले_, _dálk_, --, --, 
   {{0x7c2421f2,0x68ec0573,0x183421f3,0x64480870}},	//   qtir, ñada, تراح, jvei, 
   {{0x636c2184,0xdbcc039c,0x65780151,0x7dd801c6}},	//   _kúnu, _tıñl, _alwh, _eŭse, 
   {{0xd95806d4,0x7afc21f4,0x644821f5,0x628021f6}},	//   _краљ_, _iert, evei, jzlo, 
   {{0x7afc21f7,0x18680063,0x8ebc02fa,0x95c821f8}},	//   _hert, _каби_, _আলমগ, шула_, 
   {{0x7afc21f9,0x335400bf,0x644821fa,0x00000000}},	//   _kert, зүлө_, gvei, --, 
   {{0x7afc21fb,0x394421fc,0x872800e2,0x7c200152}},	//   _jert, _hams_, _نغمې_, _ämru, 
   {{0x394421fd,0x64480cbf,0x953c070b,0x2bbc0095}},	//   _kams_, avei, _аслă_, ्गता, 
   {{0x394421fe,0x7afc21ff,0x00000000,0x00000000}},	//   _jams_, _lert, --, --, 
   {{0x7afc0ac1,0x3944018c,0x61ec01df,0x6448015b}},	//   _oert, _mams_, _čale, cvei, 
   {{0x25a82200,0x39442201,0x7afc2202,0x636c0579}},	//   čale_, _lams_, _nert, _búnu, 
   {{0xccf806d4,0x645c021c,0x00000000,0x00000000}},	//   ића_, äsiv, --, --, 
   {{0x7afc2203,0x39440059,0x7e680207,0xfcdc0020}},	//   _aert, _nams_, ädpa, _ንሕጂ_, 
   {{0x7afc2204,0x6b740553,0x67f000d3,0x7d240675}},	// [1d50] _bert, плау, _mójò, ьфре, 
   {{0x394401c7,0x316808be,0x00000000,0x00000000}},	//   _aams_, _hoaz_, --, --, 
   {{0x7afc2205,0x3944010b,0x316802e3,0x64482206}},	//   _dert, _bams_, _koaz_, zvei, 
   {{0x7afc2207,0x316801aa,0x39442208,0xf9a40012}},	//   _eert, _joaz_, _cams_, وٕلُ, 
   {{0x66e42209,0x636c00c4,0x7afc220a,0xa7b802ba}},	//   пола, _kúnt, _fert, блду_, 
   {{0x7afc0396,0xe738220b,0x31680151,0xaa58220c}},	//   _gert, сек_, _loaz_, _лигу_, 
   {{0x3944008b,0xa8a4049d,0x64480008,0x257002e8}},	//   _fams_, _کڵاو, wvei, _háli_, 
   {{0x7afc220d,0x3944013b,0x7e9c007c,0x6448220e}},	//   _zert, _gams_, יסוו, tvei, 
   {{0x291c00ba,0x7afc01d9,0xe804025c,0xc4440324}},	//   mgwa_, _yert, _रिटा_, تیشن_, 
   {{0x6448220f,0x25702210,0xd04c009f,0x7afc2211}},	//   rvei, _máli_, _ödəm, _xert, 
   {{0xa91c02b3,0x316808be,0x61442212,0x00000000}},	//   _amži, _boaz_, пена, --, 
   {{0x291c2213,0x24182214,0xdcf40828,0xa0a42215}},	//   ngwa_, _годы_, khyā, замд, 
   {{0x31680182,0x25ac2216,0x62802217,0x00000000}},	//   _doaz_, moel_, szlo, --, 
   {{0xdcf4076f,0x636c0075,0x77680080,0xcf180012}},	//   dhyā, _cúnt, _xodx, ٝرِچ_, 
   {{0x291c0987,0x636c0272,0x8fa02218,0xdee401d9}},	//   kgwa_, _dúnt, харе, жоҳи, 
   {{0x7afc2219,0x25ac221a,0x31680182,0x00000000}},	//   _sert, noel_, _goaz_, --, 
   {{0x636c00d3,0x1fb40254,0x9b0802e2,0x00000000}},	// [1d60] _fúnt, _нсор, йнаб_, --, 
   {{0x3944221b,0x636c221c,0x31680094,0x257001d5}},	//   _sams_, _gúnt, _zoaz_, _dáli_, 
   {{0x7afc221d,0x19b8221e,0xaee40828,0x394402ba}},	//   _vert, будь_, saṃy, _pams_, 
   {{0x7afc221f,0xdcf4076f,0x25ac0047,0x291c1ccf}},	//   _wert, bhyā, joel_, ggwa_, 
   {{0x25ac2220,0x672c0070,0xecb8025c,0xdb1c0306}},	//   doel_, đajn, _आरएफ, ampá, 
   {{0x7afc2221,0x4cb80240,0x636c03b2,0x291c2222}},	//   _uert, _לזכו, _xúnt, agwa_, 
   {{0x25ac2223,0x9a100a1d,0x67200d2e,0x96f801d2}},	//   foel_, _سڃاڻ, _dclj, _ۇعار_, 
   {{0x25ac0323,0x2a6401d6,0xfcdc0020,0x00000000}},	//   goel_, _àlba_, _ንሕጊ_, --, 
   {{0xb4c80203,0xb89800d5,0x00000000,0x00000000}},	//   ोखे_, _بھائ_, --, --, 
   {{0x316802e3,0x00000000,0x00000000,0x00000000}},	//   _soaz_, --, --, --, 
   {{0x25ac2224,0x636c0038,0x00000000,0x00000000}},	//   boel_, _rúnt, --, --, 
   {{0x25ac2225,0x92c02226,0x636c21b0,0x95c800e1}},	//   coel_, _ışın, _súnt, _улеб_, 
   {{0x645c2227,0x25a803a2,0x636c0329,0x31680593}},	//   äsit, _بدلي_, _púnt, _voaz_, 
   {{0x3358038e,0x636c02b2,0x08740100,0x249800c0}},	//   _факэ_, _dúns, לעכט_, úsme_, 
   {{0xae1c05d5,0xfe540007,0x31680593,0x257003c2}},	//   बंधन_, нкрэ, _toaz_, _sáli_, 
   {{0xdcf40828,0x25702228,0x645c01c5,0x00000000}},	//   thyā, _páli_, åsig, --, 
   {{0x636c21b0,0x00000000,0x00000000,0x00000000}},	// [1d70] _gúns, --, --, --, 
   {{0x636c0223,0x257002e8,0x00000000,0x00000000}},	//   _húnr, _váli_, --, --, 
   {{0x68ec2229,0xe9f80200,0x2d840045,0x636c0528}},	//   ñado, інді_, èles_, _kúnr, 
   {{0xd244222a,0x2570222b,0xad400340,0xfbd80ccc}},	//   _ین_, _táli_, _جۉرۉ, _भूकम, 
   {{0x25ac0dd4,0x291c0249,0xd24400dd,0xb4c800d1}},	//   voel_, rgwa_, _ڌن_, ोखो_, 
   {{0x25ac0618,0x00000000,0x00000000,0x00000000}},	//   woel_, --, --, --, 
   {{0x25ac222c,0xe5a4222d,0x0bd00108,0x00000000}},	//   toel_, мики, _ﭘﯘﻗﺮ, --, 
   {{0xc1740181,0x5ea80252,0x2bbc222e,0x00000000}},	//   _kiɗe_, ছেকে, ्गवा, --, 
   {{0x290c222f,0x68e800d3,0x3cec02df,0x25ac02e3}},	//   _idea_, _ifed, _ədv_, roel_, 
   {{0x27ec2230,0xe298005b,0xb2f4021c,0x636c0e07}},	//   _iten_, жао_, няющ, _rúns, 
   {{0x25ac05ab,0xda780282,0xd5ac2231,0xa6342232}},	//   poel_, ַנשר, طفی_, _інді, 
   {{0x36342233,0x27e80513,0x645c021c,0x00000000}},	//   _سرمس, ţanu_, äsis, --, 
   {{0x5f940108,0x05740061,0xd24c1613,0x00000000}},	//   җиңт, _واڵد, هنی_, --, 
   {{0xdfd02234,0x443c01c4,0x27ec01c6,0x03c4002c}},	//   ئيس_, mwu_, _mten_, _эсем, 
   {{0x27ec0e84,0x1d080c9f,0xdef804d9,0xdd90196a}},	//   _lten_, жеби_, йың_, نوس_, 
   {{0x290c212b,0x27ec0b66,0x636c2235,0x443c08cf}},	//   _ndea_, _oten_, _túns, owu_, 
   {{0x443c2236,0xed340396,0x27ec11d5,0x00000000}},	// [1d80] nwu_, ээрэ, _nten_, --, 
   {{0x290c2237,0x68e82238,0x443c2239,0x00000000}},	//   _adea_, _afed, iwu_, --, 
   {{0x27ec223a,0xddc4021c,0x9cc8024b,0x00000000}},	//   _aten_, _обои, сыңа_, --, 
   {{0x443c05a3,0xaac401a0,0x3d1808ed,0x7e680085}},	//   kwu_, رتلن, _फाटे_, ødpu, 
   {{0x7d04223b,0x4f8401b5,0x2bbc0523,0x00000000}},	//   mais, _رایہ, ्गशा, --, 
   {{0x7d04223c,0x68e80145,0x290c20d5,0x443c043b}},	//   lais, _efed, _edea_, dwu_, 
   {{0x27ec223d,0x68e80323,0xa3c0223e,0x443c223f}},	//   _eten_, _ffed, ंतन_, ewu_, 
   {{0x7d042240,0xd49802dc,0x4d780100,0x6eb003bf}},	//   nais, жро_, ַריע, _आँसु, 
   {{0x443c05a3,0xddcc01d5,0x00000000,0x00000000}},	//   gwu_, hybů, --, --, 
   {{0x7d042241,0x636c02ba,0x00000000,0x00000000}},	//   hais, _búnq, --, --, 
   {{0x7d042242,0x443c2243,0x7e680207,0x00000000}},	//   kais, awu_, ädpl, --, 
   {{0x7d042244,0x443c00ba,0xc5f002c3,0x00000000}},	//   jais, bwu_, _ידע_, --, 
   {{0x7d042245,0xb2a80012,0x147400cc,0x00000000}},	//   dais, تُھم_, _تااج, --, 
   {{0xc0582246,0x636c0229,0x00000000,0x00000000}},	//   фію_, _wúnr, --, --, 
   {{0x7d042247,0x42400329,0x8d742248,0x313400fc}},	//   fais, _ахыб, وارا, _зейр, 
   {{0x7d042249,0x7520042e,0xc0cc001d,0x00000000}},	//   gais, ngmz, በርም_, --, 
   {{0x2bbc186f,0x9a6c001d,0x00000000,0x00000000}},	// [1d90] ्गला, _በላከው_, --, --, 
   {{0x257003c2,0x27ec004f,0x00000000,0x00000000}},	//   _hált_, _rten_, --, --, 
   {{0x27ec224a,0x290c224b,0x7e0400f1,0xb9e4021d}},	//   _sten_, _pdea_, _pčsň, вічи, 
   {{0x7d04224c,0x317802dc,0xdb1c0027,0x443c0098}},	//   cais, nksz_, empä, ywu_, 
   {{0x2570014e,0x16700121,0x5d780100,0x00000000}},	//   _mált_, ңқур, _זארק, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x443c224d,0x00000000,0x00000000,0x00000000}},	//   wwu_, --, --, --, 
   {{0x290c224e,0x68e8042e,0x443c03ef,0xa444224f}},	//   _udea_, _ufed, twu_, енид, 
   {{0x27ec10aa,0x09c800cb,0x00000000,0x00000000}},	//   _uten_, िषीय, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x443c00ba,0x7d042250,0x81e40143,0x25702251}},	//   swu_, yais, মীন_, _bált_, 
   {{0x257002b2,0x00000000,0x00000000,0x00000000}},	//   _pálu_, --, --, --, 
   {{0x7d042252,0xdeb801da,0x00000000,0x00000000}},	//   vais, ሲውን_, --, --, 
   {{0x7d042253,0x2d842254,0x257001d5,0x00000000}},	//   wais, ëlen_, _válu_, --, 
   {{0xb80400cb,0x00000000,0x00000000,0x00000000}},	//   _bhṛś, --, --, --, 
   {{0x80b400c3,0x00000000,0x00000000,0x00000000}},	//   _ۋەھش, --, --, --, 
   {{0x7d042255,0xdee42256,0xdb1c021c,0x25701cbc}},	// [1da0] rais, _попи, ympä, _háls_, 
   {{0x7d042257,0xd9b80b29,0x28c000c3,0x4b2000b7}},	//   sais, ेष्ट, ﺭﻩﺗﻠ, лмув, 
   {{0x7d042258,0xb0682259,0x4ef80107,0xb5200280}},	//   pais, _فصیل_, _מהיו, _यालय_, 
   {{0x25700038,0x18a4225a,0x4aac006c,0x7d04225b}},	//   _máls_, наем, _जुळव, qais, 
   {{0xb8e820ff,0xeaf800c3,0x00000000,0x00000000}},	//   _उर_, سرەت_, --, --, 
   {{0xaee40828,0xdb240229,0x00000000,0x00000000}},	//   raṇy, _àpàp, --, --, 
   {{0x8ba0044a,0x00000000,0x00000000,0x00000000}},	//   _сирж, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x81e400ac,0x3200038a,0x44f00108,0x00000000}},	//   মীম_, _ňiy_, دسىز, --, 
   {{0xecc40774,0x3f84038a,0x33740094,0x32540375}},	//   लेटफ, ëmul_, тгор, ввор, 
   {{0x067c0e85,0x310800bf,0x5ef42107,0x257000e3}},	//   ﺭﺍﻟﯩ, үнүп_, ्रन्_, _pált_, 
   {{0x4a980282,0x54680683,0x3a38010b,0x00000000}},	//   לייג, _наем_, _mprp_, --, 
   {{0xc95010bc,0x636c0028,0x25700191,0x00000000}},	//   אמר_, _túnp, _vált_, --, 
   {{0x136400a3,0x339400e5,0x00000000,0x00000000}},	//   _ڊاڪٽ, _шалё, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2ef40ba3,0x2a6c0098,0x00000000,0x00000000}},	// [1db0] _изпр, _łeb_, --, --, 
   {{0x8aa4225c,0xa91c01d5,0x7980225d,0x06a80143}},	//   нред, _mlže, _almw, গেটি, 
   {{0x02f80100,0x00000000,0x00000000,0x00000000}},	//   פלאמ, --, --, --, 
   {{0x3a38010b,0xc1740181,0xc0bc0020,0x39780103}},	//   _dprp_, _kiɗa_, _ተጋሩ_, нсію_, 
   {{0x684404e7,0x6d5c225e,0x6d4c028b,0x00000000}},	//   тнла, _insa, mdaa, --, 
   {{0x6d4c225f,0xdc540012,0x8d8401a0,0x98e400ec}},	//   ldaa, _شرُک, _آشگن, нсәһ, 
   {{0x6d4c0012,0x61ec2260,0xdb2400d3,0xe5680094}},	//   odaa, _čalo, _àpáp, дийд_, 
   {{0x6d4c2261,0x5800006e,0xe4580d01,0x6d5c011a}},	//   ndaa, _چۈنك, джи_, _jnsa, 
   {{0x5ef40828,0x6d5c05b8,0x69c82262,0x6d4c2263}},	//   ्रम्_, _mnsa, _ihee, idaa, 
   {{0xb9e02264,0x6d5c2075,0x69c80243,0x6d4c2265}},	//   _ብቻ_, _lnsa, _hhee, hdaa, 
   {{0x69c80179,0xdce41926,0x6d5c2266,0x6d4c1f50}},	//   _khee, _lokā, _onsa, kdaa, 
   {{0x798002b0,0x2508005e,0x257000f2,0x00000000}},	//   _xlmw, _آرای_, _váls_, --, 
   {{0x65682267,0x69c80177,0xdce400d4,0x232801aa}},	//   mjeh, _mhee, _nokā, _жоли_, 
   {{0x6d5c2268,0x6d4c2269,0x69c80cfa,0x6568226a}},	//   _ansa, edaa, _lhee, ljeh, 
   {{0xee140007,0x6d4c018c,0x80d00030,0x00000000}},	//   льтэ, fdaa, ठइहे, --, 
   {{0x6568226b,0xc1740181,0x6d5c02ea,0x69c80616}},	//   njeh, _fiɗa_, _cnsa, _nhee, 
   {{0x1ae4226c,0xcd240668,0x00000000,0x00000000}},	// [1dc0] возм, ъжте_, --, --, 
   {{0xa3c01f9e,0x6d4c226d,0x69c8226e,0x3b84010f}},	//   ंति_, adaa, _ahee, ካሪዎች_, 
   {{0x69c80762,0x3f98226f,0x6d4c0fdc,0x65680252}},	//   _bhee, miru_, bdaa, kjeh, 
   {{0x3f982270,0x6d4c004b,0x69c82271,0xa91c0113}},	//   liru_, cdaa, _chee, _alžb, 
   {{0x69c8146e,0xa3c01efe,0xdcf400f1,0xdce4004f}},	//   _dhee, ंता_, nkyč, _gokā, 
   {{0x69c82272,0x3f982273,0xa924018b,0x06a80143}},	//   _ehee, niru_, _rožň, গেছি, 
   {{0x6d5c2274,0x7bdc0083,0xb5940300,0x8f980a0b}},	//   _ynsa, _iiru, ликш, ויסי, 
   {{0x7bdc2275,0x3f982276,0x46e4016d,0x69c82277}},	//   _hiru, hiru_, ндән_, _ghee, 
   {{0x3f982278,0x73d82279,0x99980299,0x8d74001d}},	//   kiru_, ндир_, nupō_, _የገባው_, 
   {{0x3f98227a,0x9700006e,0x96940503,0x7bdc227b}},	//   jiru_, _ئېغى, _иреш, _jiru, 
   {{0x6d4c004b,0x3f98227c,0x69c80083,0x999800a2}},	//   ydaa, diru_, _yhee, hupō_, 
   {{0x7bdc227d,0x6d4c227e,0x99980296,0x7648227f}},	//   _liru, xdaa, kupō_, _isdy, 
   {{0x68ec04ac,0x7bdc0177,0x93882280,0x1b180143}},	//   ñadi, _oiru, _оска_, ন্যে_, 
   {{0x7bdc2281,0xafc42282,0x3f982283,0xdce40059}},	//   _niru, ايسى, giru_, _rokā, 
   {{0xcdd81ec1,0x6d4c2284,0x00000000,0x00000000}},	//   дња_, tdaa, --, --, 
   {{0x7bdc2285,0x672c091d,0x31b800ef,0x2bc40030}},	//   _airu, đaji, tézu_, वतभा, 
   {{0x7bdc2286,0x6d4c2287,0x69c82288,0xcfa401e3}},	// [1dd0] _biru, rdaa, _rhee, _ашни, 
   {{0x09c81113,0x6d4c2289,0x69c8228a,0x3f980091}},	//   िष्य, sdaa, _shee, ciru_, 
   {{0x69c8042a,0x7bdc228b,0x00000000,0x00000000}},	//   _phee, _diru, --, --, 
   {{0x6d5c228c,0x60240130,0x6d4c004b,0xdce40d71}},	//   _unsa, _kɔmp, qdaa, _tokā, 
   {{0x7bdc228d,0xec340282,0x69c80088,0x76480101}},	//   _firu, _גאָר_, _vhee, _asdy, 
   {{0x7bdc228e,0x69c8133c,0x23f402dc,0xb74801d2}},	//   _giru, _whee, қчиё, кпіз_, 
   {{0x69c8228f,0x656800ec,0x6f040428,0xe91801f5}},	//   _thee, tjeh, _mehc, _пові_, 
   {{0x6f0400bd,0x69c8028b,0x2b40000b,0x00000000}},	//   _lehc, _uhee, lehc_, --, 
   {{0x7b08039c,0x7bdc2290,0xf7700eeb,0x65682291}},	//   _östä, _yiru, _ڈال_, rjeh, 
   {{0xf7702292,0x67d42293,0x6f040380,0x7bdc2294}},	//   _وال_, _созу, _nehc, _xiru, 
   {{0x3f982295,0x65682296,0xdde002db,0xe6c001ac}},	//   viru_, pjeh, _žuži, _ھڪڙي, 
   {{0x3f982297,0x21682298,0x20881cea,0xe6c000dd}},	//   wiru_, хими_, ейми_, _پڪڙي, 
   {{0x3f982299,0x4404012b,0x00000000,0x00000000}},	//   tiru_, _рчеб, --, --, 
   {{0xdca4229a,0x00000000,0x00000000,0x00000000}},	//   қази, --, --, --, 
   {{0xe1f0229b,0x3f98229c,0x7bdc229d,0x1b1802fa}},	//   _است_, riru_, _riru, ন্ডে_, 
   {{0x3f98229e,0x7f94009f,0xd00c0046,0x999800a2}},	//   siru_, _müqə, _ځلي_, tupō_, 
   {{0x7bdc1b59,0x3f98229f,0xcde01d95,0xe0d822a0}},	// [1de0] _piru, piru_, _қояй, _яви_, 
   {{0x3f9808df,0x7bdc03c0,0x7b840121,0x99980296}},	//   qiru_, _qiru, جارە, rupō_, 
   {{0xf3f40ff0,0x7bdc22a1,0x1d080393,0xb8f40095}},	//   _ইয়াৰ_, _viru, _пени_, _niṣī, 
   {{0x7bdc22a2,0x9f94078e,0xdc6801a7,0x00000000}},	//   _wiru, _шықә, _замд_, --, 
   {{0xb8f4004f,0xbb48012b,0x00000000,0x00000000}},	//   _aiṣī, _иҗад_, --, --, 
   {{0x7bdc1658,0x473001f5,0x5fb411d0,0x3dc003c7}},	//   _uiru, йніс, ृतिल, lliw_, 
   {{0x645c021d,0xaa640197,0x00000000,0x00000000}},	//   åsin, _керһ, --, --, 
   {{0x295403d6,0x00000000,0x00000000,0x00000000}},	//   _къур, --, --, --, 
   {{0x7dd80282,0x660002b0,0x18a42028,0xc5340027}},	//   _aŭsk, _ewlk, _саам, упых_, 
   {{0x88380240,0xa264000d,0x00000000,0x00000000}},	//   _אתמו, _trộ, --, --, 
   {{0x4ebc00ac,0x87780100,0xe78400b7,0x00000000}},	//   _আল্ল, _ראבי, _туѓо, --, 
   {{0x6f040140,0x00000000,0x00000000,0x00000000}},	//   _sehc, --, --, --, 
   {{0x7dd80100,0x3dc00083,0x344802dc,0x00000000}},	//   _eŭsk, dliw_, _рӯйи_, --, 
   {{0x8474010f,0x1b1802fa,0x6f040140,0x823018d1}},	//   ራክሽን_, ন্তে_, _qehc, جریا, 
   {{0xa3c00584,0x60240130,0x6f0422a3,0x3dc00086}},	//   ंतर_, _wɔmp, _vehc, fliw_, 
   {{0x7de4024b,0x00000000,0x00000000,0x00000000}},	//   сірд, --, --, --, 
   {{0xcb18023f,0x6f040380,0xf4140100,0x00000000}},	// [1df0] еќе_, _tehc, יפּ_, --, 
   {{0x3dc01f50,0x7ff4082f,0x00000000,0x00000000}},	//   aliw_, _اسيا, --, --, 
   {{0xe8dc00cb,0xe9b40116,0x00000000,0x00000000}},	//   यश्च, абжь, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x660002a6,0x2d880b1e,0x1b1802fa,0xc77002ba}},	//   _swlk, mhae_, ন্ধে_, йткө, 
   {{0x6b8001d7,0x7ac403d6,0x5c340a0b,0x00000000}},	//   ịgbo, _ӳсте, _דרשן_, --, 
   {{0x2d880062,0xdb10001e,0xe5700075,0x00000000}},	//   ohae_, _ägár, قطة_, --, 
   {{0x2d880b1e,0x1b1802fa,0x87e4018f,0xb8f400a8}},	//   nhae_, ন্দে_, _бюже, _viṣī, 
   {{0x872422a4,0x64a422a5,0x68ec0a24,0xa3c008ed}},	//   _معام, рапа, ñadu, ंतल_, 
   {{0x65141a3c,0x00000000,0x00000000,0x00000000}},	//   _چوائ, --, --, --, 
   {{0x651422a6,0x6eb000a1,0xc6780020,0x00000000}},	//   _نوائ, _आँगु, ክራሲያ_, --, 
   {{0x672c0473,0x00000000,0x00000000,0x00000000}},	//   đaju, --, --, --, 
   {{0xb63c001d,0xa4d4021d,0x9d4400d5,0x00000000}},	//   _ሰርተፊ, _тоді, یئرن, --, 
   {{0x248c01ba,0x2d8800a2,0x00000000,0x00000000}},	//   mzem_, ehae_, --, --, 
   {{0x8fa022a7,0x1d9422a8,0xb80401d3,0x81e00143}},	//   царе, араё, _kiṃś, _পৌর_, 
   {{0x645803ef,0x00000000,0x00000000,0x00000000}},	//   _krwi, --, --, --, 
   {{0x9b0422a9,0x248c22aa,0x64580306,0x71240128}},	// [1e00] изад, nzem_, _jrwi, _ارىل, 
   {{0x2d8801c4,0x248c22ab,0xee380123,0x00000000}},	//   ahae_, izem_, ънӣ_, --, 
   {{0x81e402fa,0x59081166,0xee3800e3,0x0f3400cf}},	//   মীর_, веем_, _یقیں_, _דריט_, 
   {{0x2d8802bf,0x645822ac,0x00000000,0x00000000}},	//   chae_, _orwi, --, --, 
   {{0x98a422ad,0xfaf801b8,0x01e001d2,0x00000000}},	//   шиде, _مہذب_, _ﺍﻟﻔﺨ, --, 
   {{0xab0822ae,0xc7a022af,0x7c2422b0,0xdce40098}},	//   _متفق_, оичк, muir, _doką, 
   {{0x7c2422b1,0x645822b2,0xdab822b3,0x644c028d}},	//   luir, _arwi, _شهرت_, _šaip, 
   {{0x733400e7,0x645822b4,0x00000000,0x00000000}},	//   ڭىدا, _brwi, --, --, 
   {{0xdef80020,0xd3a402dc,0x94a80668,0x94840152}},	//   ዋሩን_, ироп, ътка_, рыйд, 
   {{0x7e7c0c12,0x64582149,0x1c1c025c,0x00000000}},	//   kyrp, _drwi, यूएल_, --, 
   {{0x0cc0147e,0x672c1f81,0x7c2422b5,0xcb100107}},	//   _शर्म, đajt, huir, חלת_, 
   {{0x7e7c1311,0x7c2422b6,0x645800fb,0x9fa4002c}},	//   dyrp, kuir, _frwi, ҡырҙ, 
   {{0x636c00c4,0x248c002f,0x53a40123,0x345400d5}},	//   _lúny, czem_, _кадб, _دراڑ, 
   {{0x7c2422b7,0xd25800b7,0xf4840061,0x00000000}},	//   duir, _аци_, _پاڵی, --, 
   {{0x2d88034c,0xcd042212,0x00000000,0x00000000}},	//   thae_, ичаи, --, --, 
   {{0x7c2422b8,0x518403e9,0xadd822b9,0x463800cf}},	//   fuir, _њука, умбу_, כעלע, 
   {{0x427c0090,0xc4d0007c,0x61ec22ba,0x70581aab}},	// [1e10] _ጦርነት_, ַגע_, _čali, _сапр_, 
   {{0x25a822bb,0x636c02e8,0xc25001b8,0x1b180143}},	//   čali_, _búny, _اکیڈ, ন্সে_, 
   {{0x2d88034c,0xa91c02cc,0x7f3c0d47,0x9be801c4}},	//   phae_, _dlžn, _יעזו, _ҡырҡ_, 
   {{0x7c2422bc,0x79a422bd,0xac1800c8,0xd5a422be}},	//   buir, орче, _йому_, _رف_, 
   {{0x7c2422bf,0x2d98012c,0x1c1c0030,0x00000000}},	//   cuir, _imse_, _पियल_, --, 
   {{0x98f4006e,0x636c00d3,0x6b7402ac,0x248c0c91}},	//   لغۇچ, _fúny, _улгу, vzem_, 
   {{0x636c22c0,0x7f3c0100,0xff1800ca,0x00000000}},	//   _gúny, דעוו, בקות_, --, 
   {{0x248c0128,0xa9a4004b,0xefe402b4,0x645803f4}},	//   tzem_, _امرى, ማማዕ_, _prwi, 
   {{0x2d980636,0xe3b822c1,0xb80400cb,0xd76402ac}},	//   _mmse_, лби_, _viṃś, _گنلی, 
   {{0x64a422c2,0x248c22c3,0xa06802ac,0x442c000d}},	//   _қала, rzem_, қага_, _vqg_, 
   {{0xe29822c4,0x248c1b1c,0x7c2402ea,0xe04400ec}},	//   уан_, szem_, zuir, әнги, 
   {{0xa06822c5,0x69ac006c,0xbb2401d2,0x00000000}},	//   гама_, जवटी, _ﹼﺴﻡ_, --, 
   {{0x555022c6,0x645804f8,0x645c22c7,0x10a022c8}},	//   _رپور, _urwi, æsid, зиян, 
   {{0x64480336,0xdd1402e6,0x2d98028b,0x638401ec}},	//   mwei, _bäşd, _amse_, _ыгла, 
   {{0x644822c9,0x5ba8021b,0xfe4401c4,0xe2080247}},	//   lwei, ҳкам_, әнғо, ñóĩ_, 
   {{0x7c2422ca,0x64480278,0xb324011a,0xdcb0155a}},	//   tuir, owei, _འཐོང_, كىز_, 
   {{0x644822cb,0x9d4401c4,0xe7b8081a,0x00000000}},	// [1e20] nwei, _һенд, ेताप, --, 
   {{0x7c2422cc,0xdca40800,0x2eec0130,0x2d980207}},	//   ruir, _ҳами, ɛefo_, _emse_, 
   {{0x644822cd,0x9d4422ce,0x7c240070,0xeb540bf3}},	//   hwei, _ленд, suir, تىلگ, 
   {{0x2d981737,0x588422cf,0x64480be3,0x64540059}},	//   _gmse_, йыла, kwei, āzij, 
   {{0x7c2422d0,0x636c03b2,0x2d9801c4,0x4f840012}},	//   quir, _fúnx, _төрө_, _ضایہ, 
   {{0x644822d1,0xb3240126,0xacb000c3,0x3e58012c}},	//   dwei, _འཐེང_, _غەلب, _kčt_, 
   {{0x2d9822d2,0x941002df,0x2b9001d9,0x6448002a}},	//   _ymse_, ədək_, _تیلس, ewei, 
   {{0x644803c8,0x3e58029f,0xa380013c,0x00000000}},	//   fwei, _mčt_, õõnd, --, 
   {{0x12e40041,0x644822d3,0x58d40252,0x3e5801b1}},	//   йінг, gwei, _ড্ৰী, _lčt_, 
   {{0x6ac40010,0x758800e2,0x675400d5,0xdb10006b}},	//   _útfû, دۍچې_, _وینس_, _ägär, 
   {{0x3e5801b1,0xd4e41166,0x58840049,0x00000000}},	//   _nčt_, _люли, _тыңа, --, 
   {{0x644803c8,0x7a1c0513,0x43d001b5,0x16840061}},	//   bwei, mătă, _ہٲنز, _پاڕێ, 
   {{0x657c0479,0x00000000,0x00000000,0x00000000}},	//   öshe, --, --, --, 
   {{0x3e5801b1,0x2d98013c,0x2ee40353,0x00000000}},	//   _bčt_, _smse_, ølf_, --, 
   {{0x7a1c038e,0x720412de,0x31340128,0x87781714}},	//   nătă, _بوعم, _дейр, נאלי, 
   {{0xad2422d4,0x3e5800f1,0xacf80091,0x00000000}},	//   تىرى, _dčt_, рнау_, --, 
   {{0x6fb422d5,0x48f400aa,0xab7401f1,0x7e680207}},	// [1e30] _ومبا, उँसो_, огаш, ädpr, 
   {{0x3e58065e,0xdce400b0,0x4ba400bf,0xdd14006b}},	//   _fčt_, _mokę, сөмү_, _täşd, 
   {{0x64481a2c,0x7ff422d6,0x00000000,0x00000000}},	//   zwei, _وسیا, --, --, 
   {{0xf1c822d7,0x644822d8,0x2d980083,0x00000000}},	//   रतिन, ywei, _umse_, --, 
   {{0xd7e80340,0x2bd822d9,0x19c00abc,0x6448002a}},	//   لونۇ_, _ناسک_, фәрг, xwei, 
   {{0x27e0002a,0x26c00560,0x00000000,0x00000000}},	//   öhn_, żhom_, --, --, 
   {{0xf1c80991,0x39a401b5,0x6e340085,0xff1800ca}},	//   रतान, _کینہ, ntzb, זקות_, 
   {{0x644822da,0xe57822db,0x6e3400af,0xdaa0102b}},	//   twei, рзи_, itzb, _تەمپ, 
   {{0xa8a402a5,0x644822dc,0xa3e8023f,0xf9d4009e}},	//   _بڵاو, uwei, јдоа_, _хотэ, 
   {{0x644822dd,0xe3b001d9,0x00000000,0x00000000}},	//   rwei, برب_, --, --, 
   {{0x64481bbd,0x7a1c02ea,0x216801e3,0xe8500061}},	//   swei, cătă, аини_, _رۆژد, 
   {{0xc17401e7,0x64a400c3,0x6448000b,0x00000000}},	//   _kiɗi_, _қаһа, pwei, --, 
   {{0x3e5801e8,0x61ec01d4,0x9fc803a7,0x27fc011a}},	//   _sčt_, _čalu, игма_, npwn_, 
   {{0xf1b80560,0x00000000,0x00000000,0x00000000}},	//   rrġa_, --, --, --, 
   {{0xaf9822de,0x00000000,0x00000000,0x00000000}},	//   стях_, --, --, --, 
   {{0xa3c022df,0x3e580078,0x00000000,0x00000000}},	//   ंतक_, _včt_, --, --, 
   {{0xf1a8049d,0xdc680182,0x00000000,0x00000000}},	// [1e40] _داوه_, шаад_, --, --, 
   {{0x7dd80282,0x3e58029f,0x0b4002e2,0x00000000}},	//   _aŭst, _tčt_, мнун, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5f441c0f,0x61e40a03,0x7a1c0513,0xd2380100}},	//   _انگل, _éhlu, vătă, יגעל, 
   {{0xa3b822e0,0x913800cf,0x00000000,0x00000000}},	//   चवा_, שענק, --, --, 
   {{0x9af40075,0x0f3400cf,0x00000000,0x00000000}},	//   _ذكرت, ַרפט_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7a1c00c2,0xdb1c01ca,0x05b401dc,0xd90c01e1}},	//   rătă, ilpí, يديت_, _شیت_, 
   {{0x136822e1,0x38c800d5,0x00000000,0x00000000}},	//   ашни_, _طاری_, --, --, 
   {{0x7a1c00c2,0xe7b000bf,0x00000000,0x00000000}},	//   pătă, _كۅند, --, --, 
   {{0x6584059b,0x00000000,0x00000000,0x00000000}},	//   áthó, --, --, --, 
   {{0x52b8025c,0x25a001ab,0x5064018f,0x02a000b8}},	//   _उडीस, éhlt_, отга, ьрым, 
   {{0x490822e2,0xdb0c02b2,0xb6240200,0x3c3401c5}},	//   ारतो_, _dkbú, _ﺫﻩ_, jäv_, 
   {{0xb3240d7f,0x00000000,0x00000000,0x00000000}},	//   _འཐིང_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6e3401f5,0xb5fc011a,0x3f740152,0x301422e3}},	//   rtzb, _erġg, _aşuı_, _едир, 
   {{0x392c010f,0x261003ef,0xe570007c,0xd7c8072d}},	// [1e50] ተዳደራ, _धौनी_, ײַן_, िताच, 
   {{0xc17401e7,0xba740324,0x00000000,0x00000000}},	//   _riɗi_, ژانت, --, --, 
   {{0x9ff400e2,0x8aa401f5,0xbfb40075,0x00000000}},	//   _وزیږ, црад, _تحيت, --, 
   {{0xb9e80041,0x4c8002ac,0x00000000,0x00000000}},	//   іміз_, _قیزق, --, --, 
   {{0x2fc002b2,0x4ab4040e,0x00000000,0x00000000}},	//   _kkhg_, _अडकव, --, --, 
   {{0x36e80134,0x00000000,0x00000000,0x00000000}},	//   يرىپ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe79422e4,0x2bd80095,0x7ac820d0,0x00000000}},	//   _کارک, भगवा, _ذوقِ_, --, 
   {{0x69d822e5,0x68e80126,0x00000000,0x00000000}},	//   mmwe, _iged, --, --, 
   {{0x69d822e6,0xe3b022e7,0x23280edd,0x00000000}},	//   lmwe, عرة_, љони_, --, 
   {{0x27ec22e8,0xd5a422e9,0x69d80aea,0x00000000}},	//   _huen_, _کلنی, omwe, --, 
   {{0x27ec0249,0x69d801e8,0xdee4001d,0xf624021d}},	//   _kuen_, nmwe, ማዋን_, _ідіо, 
   {{0xc0bc0090,0x27e422ea,0x290c00ec,0x69d80088}},	//   _ተቋም_, _kiln_, _meea_, imwe, 
   {{0x22141166,0x201c22eb,0x3c3401c5,0x330800cc}},	//   _ефир, čti_, väv_, _ۇيۇپ_, 
   {{0x63a022ec,0xe8e40a1d,0x657804c4,0x68e822ed}},	//   miln, _ڄڻ_, _kowh, _oged, 
   {{0x68e822ee,0x657801b5,0x63a022ef,0x27ec0670}},	//   _nged, _jowh, liln, _ouen_, 
   {{0x27ec05bc,0x65780296,0x63ac000f,0x8c4022f0}},	// [1e60] _nuen_, _mowh, _íans, нете, 
   {{0x63a022f1,0x68e822f2,0x847402b4,0xb60801d4}},	//   niln, _aged, ራርሓን_, lišť, 
   {{0x290c01d1,0x5ed802fa,0x628022f3,0x8f780107}},	//   _beea_, _ব্রে, nylo, _הניק, 
   {{0x27ec22f4,0x290c0241,0x63a022f5,0x657822f6}},	//   _buen_, _ceea_, hiln, _nowh, 
   {{0x7d0422f7,0x63a022f8,0x290c22f9,0x27e422fa}},	//   mbis, kiln, _deea_, _biln_, 
   {{0x27ec0396,0x26c40357,0x62800638,0x69d822fb}},	//   _duen_, _bylo_, kylo, amwe, 
   {{0x63a022fc,0x68ec00aa,0x290c006f,0x27ec0054}},	//   diln, žada, _feea_, _euen_, 
   {{0x65780abe,0x7d0422fd,0xb60802ef,0x290c00c2}},	//   _cowh, nbis, jišť, _geea_, 
   {{0x27ec038a,0x7d0422fe,0xe3b80028,0x20dc0c5f}},	//   _guen_, ibis, rrűn_, नेमध, 
   {{0x63a022ff,0x7d042300,0xb5fc0002,0x6d900085}},	//   giln, hbis, _arġe, _gåaf, 
   {{0x27ec02fb,0x7c2402ac,0x7d04012b,0x154402ba}},	//   _zuen_, hrir, kbis, _нежм, 
   {{0x27ec2301,0x7c242302,0x9594010f,0x63a001d6}},	//   _yuen_, krir, ዎቻችን_, ailn, 
   {{0x7d042303,0x63a02304,0x62800029,0x26c40475}},	//   dbis, biln, aylo, _zylo_, 
   {{0x63a02305,0x7d042306,0x00000000,0x00000000}},	//   ciln, ebis, --, --, 
   {{0x43380240,0x69c0020c,0xbb60010f,0x26c400ef}},	//   _העוב, _íleg, _ለማቋቋ, _xylo_, 
   {{0x7c242307,0x7d042308,0x3eac00ef,0x00000000}},	//   frir, gbis, _šitý_, --, 
   {{0xc0bc001d,0x3d940246,0xa3c0006c,0x644c015b}},	// [1e70] _ተቋሙ_, хитр, ंतच_, _šaiz, 
   {{0x290c2309,0x7d040080,0xefe40020,0x00000000}},	//   _seea_, abis, ዛማዲ_, --, 
   {{0x7d04227b,0x7c240074,0x27ec09d7,0x316801d4}},	//   bbis, arir, _suen_, _knaz_, 
   {{0x290c00ec,0x776802b0,0xfaa40df8,0x27ec0139}},	//   _qeea_, _andx, хшун, _puen_, 
   {{0x27ec230a,0x172408be,0x6280230b,0xa7b800e7}},	//   _quen_, _རྐངམ_, zylo, олду_, 
   {{0x27ec01ab,0xf7940007,0xa91c01d5,0x65780101}},	//   _vuen_, начэ, _mlži, _sowh, 
   {{0x63a00ebd,0x65780341,0x6280006a,0x69d80083}},	//   viln, _powh, xylo, pmwe, 
   {{0x68e8230c,0x63a0002f,0x27ec1b03,0x38b8012c}},	//   _uged, wiln, _tuen_, _sýrů_, 
   {{0x63a0230d,0x26c40335,0xa854012b,0x00000000}},	//   tiln, _wylo_, _юкач, --, 
   {{0xb370010f,0x7d04230e,0xc1bc01ee,0x628005d0}},	//   _ብቻውን_, zbis, ﻧﺎﺩﺍ, tylo, 
   {{0x63a014ba,0xa91c1547,0x7d040060,0xe3b001b8}},	//   riln, _alži, ybis, ٹرک_, 
   {{0x7c24230f,0xfe782310,0xa0a42311,0x00000000}},	//   yrir, җүм_, дамд, --, 
   {{0x63a02312,0x31b803aa,0xb16400ec,0x25ac2313}},	//   piln, nézy_, хняһ, mnel_, 
   {{0x98a404c4,0x7c242314,0x7dd80237,0x31680055}},	//   ngoā_, vrir, _aŭsp, _enaz_, 
   {{0x25ac2315,0x7c2404db,0xb60800ef,0xe2982316}},	//   onel_, wrir, pišť, _фай_, 
   {{0x25ac2317,0x7c242318,0x3168000b,0xb5fc043b}},	//   nnel_, trir, _gnaz_, _urġe, 
   {{0x7d042319,0x7c24231a,0x6f180306,0x00000000}},	// [1e80] rbis, urir, éacó, --, 
   {{0x7c24231b,0x9f04231c,0x25ac002a,0x20000098}},	//   rrir, _تودو, hnel_, mpki_, 
   {{0xdb1c02bb,0x7c24013c,0x68ec02d9,0x00000000}},	//   lopë, srir, ľadn, --, 
   {{0x7c24231d,0x18a40798,0xd00c005e,0x00000000}},	//   prir, маем, _حلی_, --, 
   {{0x7f90039c,0x3860014e,0xad580094,0x00000000}},	//   _täqd, íir_, _эрэх_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb33c0126,0x76b400b8,0x00000000,0x00000000}},	//   jiħa, хәац, --, --, 
   {{0x25ac231e,0xdb1c0475,0xa2c00477,0x00000000}},	//   gnel_, kopë, रअन्, --, 
   {{0x9324066c,0x73c400fc,0x31b802cc,0xe97000bf}},	//   وردن, нәке, cézy_, _حۇند, 
   {{0x25ac03af,0xd788005e,0x00000000,0x00000000}},	//   anel_, _بخرم_, --, --, 
   {{0x32180214,0xa2c0231f,0xd25800b7,0x00000000}},	//   éry_, _रुद्, ццп_, --, 
   {{0x54680007,0x85f400ca,0x00000000,0x00000000}},	//   _маем_, _חמאס_, --, --, 
   {{0xc0582320,0x53b402ac,0xa9d400c3,0x00000000}},	//   мір_, _оғир_, ﯘﺭﯨﻴ, --, 
   {{0x0ef80aff,0x00000000,0x00000000,0x00000000}},	//   ्रेस_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb1c197c,0x00000000,0x00000000,0x00000000}},	//   lopè, --, --, --, 
   {{0xcee801b5,0xfa50010f,0x7de4024b,0x0b840012}},	// [1e90] _وردن_, _ዘላለማ, тірд, وٝری_, 
   {{0xc084001d,0xf4000143,0xdfd000dd,0xc9040098}},	//   ሮግራሙ_, _এটার_, _ٽيپ_, शर्म_, 
   {{0x25ac2321,0x00000000,0x00000000,0x00000000}},	//   ynel_, --, --, --, 
   {{0x31b803aa,0x6f142322,0x68ec02d9,0x00000000}},	//   tézy_, lazc, ľado, --, 
   {{0x68ec0214,0x6d4c2323,0xd9142324,0x00000000}},	//   žado, meaa, ريوش_, --, 
   {{0x6d4c2325,0x7b642326,0x4df02327,0x00000000}},	//   leaa, _итсе, _अढाई_, --, 
   {{0x7ac41ec1,0x80c802fa,0x657c0139,0x00000000}},	//   _асте, রেপ্, ösho, --, 
   {{0x25ac0d7f,0xc8641166,0x6d4c2328,0x00000000}},	//   unel_, _отзи, neaa, --, 
   {{0x38342329,0x00000000,0x00000000,0x00000000}},	//   _интр, --, --, --, 
   {{0xbab001b9,0xe298005b,0x18281141,0xdb1c00cc}},	//   _কৰিছ, зао_, _رقمی_, gopè, 
   {{0x25ac232a,0xb634232b,0xd5ac01b8,0x6d4c021c}},	//   pnel_, _لعنت, شفی_, keaa, 
   {{0x68f80a03,0x6024144b,0x30740020,0x00000000}},	//   ncwd, ндма, _ኪመጽእ_, --, 
   {{0x80c800ac,0x1fb4023f,0x1b1802fa,0x5574232c}},	//   রেন্, есвр, ন্টে_, _רענן_, 
   {{0xdb1c0422,0x6d4c025e,0xdfd0232d,0xa91c00e0}},	//   ropë, eeaa, ايس_, _ilžu, 
   {{0x4dc40121,0x1ea81598,0xdd90232e,0x00000000}},	//   ﯩﻜﯩﻨ, ساسي_, هوس_, --, 
   {{0x6d4c018c,0xdce40055,0x00000000,0x00000000}},	//   geaa, _cokğ, --, --, 
   {{0xdb1c01d4,0x00000000,0x00000000,0x00000000}},	// [1ea0] lopé, --, --, --, 
   {{0x5bc4232f,0x6f1402c6,0xa3c0147e,0x6d4c015e}},	//   رقال, cazc, ूति_, aeaa, 
   {{0x6d4c2330,0x00000000,0x00000000,0x00000000}},	//   beaa, --, --, --, 
   {{0xabd40256,0x38040123,0x00000000,0x00000000}},	//   ىزەت, водҳ, --, --, 
   {{0x4c640682,0x645c0270,0x1ba801b8,0xa3c02331}},	//   _зиян_, æsil, _فاسٹ_, ूता_, 
   {{0x50180107,0xdb1c2332,0xd4980123,0x00000000}},	//   לונו, kopé, ҷро_, --, 
   {{0x5bbc2333,0xb81c0d49,0x00000000,0x00000000}},	//   ्तीव, _निकम_, --, --, 
   {{0xd49800f8,0xe3b80010,0x00000000,0x00000000}},	//   зро_, brűk_, --, --, 
   {{0x73d82334,0x39440207,0x4dd401ee,0x46e401c4}},	//   мдир_, _ibms_, ﯞﺭﯨﻨ, мдән_, 
   {{0x969410f3,0xb5fc011a,0x00000000,0x00000000}},	//   _преш, _erġa, --, --, 
   {{0xdb1c2335,0x6d4c007b,0x932401d9,0xf1942336}},	//   ropè, yeaa, ورگن, винь, 
   {{0xdce401e8,0xdb0c1b63,0x0ef8025c,0x81b40143}},	//   _ankč, _akbü, ्र्स_, _জীব_, 
   {{0x6d4c2337,0x5fd000b6,0x00000000,0x00000000}},	//   veaa, _दीहल, --, --, 
   {{0x73c401c4,0x6d4c005e,0x3da402dc,0x73340e75}},	//   _шәйе, weaa, ҳруб, _شىبا, 
   {{0x6f142338,0xdb1c00b7,0xfe242339,0x2ee40207}},	//   razc, copé, льтн, älf_, 
   {{0x8d74233a,0x7afc028b,0x2fdc00e5,0x3da401c7}},	//   رازا, _afrt, _žygį_, груб, 
   {{0xb81c233b,0x6fb801a0,0x00000000,0x00000000}},	// [1eb0] _निगम_, _огир_, --, --, 
   {{0x76480085,0x6d4c087e,0x7f94070b,0x00000000}},	//   _opdy, seaa, _баьх, --, 
   {{0x6db4233c,0x6d4c0607,0x7dfc01e8,0x39b801e8}},	//   _айну, peaa, _pčse, zčse_, 
   {{0xa91c14ba,0xdeb0024b,0x999800f1,0x37740197}},	//   _možg, _тұсы, nspň_, ғышс, 
   {{0x39440426,0x00000000,0x00000000,0x00000000}},	//   _dbms_, --, --, --, 
   {{0x394405b8,0x1864233d,0x39b800f1,0x00000000}},	//   _ebms_, таши_, včse_, --, 
   {{0x9730233e,0x00000000,0x00000000,0x00000000}},	//   شکلا, --, --, --, 
   {{0xa2c00a34,0x9c84015b,0x7f90006b,0xd3440061}},	//   _रुष्, _fočē, _mäqa, ێینه_, 
   {{0x64740152,0x00000000,0x00000000,0x00000000}},	//   тыйф, --, --, --, 
   {{0xe1f800e7,0xdb1c233f,0xe7182340,0xaac400aa}},	//   мго_, topé, _آيات_, _वडाक, 
   {{0x05440396,0xe2982341,0xa5340027,0x00000000}},	//   _зүйл_, фан_, _анеч, --, 
   {{0xdb1c2342,0x709c0828,0xe4d80075,0x21a400c3}},	//   ropé, _śikṣ, _قوات_, тимм, 
   {{0x8edc0301,0xdb1c0b1e,0x00000000,0x00000000}},	//   _ব্লগ, llpå, --, --, 
   {{0xb804004f,0x76480031,0x00000000,0x00000000}},	//   _akṛś, _ypdy, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcb02343,0xa2c0006c,0x3bd4012b,0x32d400e5}},	//   لىز_, रॅण्, däqa_, _сціс, 
   {{0xa91c0b53,0x672001f8,0x1be800f8,0x5f041166}},	// [1ec0] _možd, _odlj, ддаи_, _изпа, 
   {{0x8c402344,0x1f640329,0x1e8401ef,0x7b8400e7}},	//   рефе, _рком, _алом, دارە, 
   {{0xdee40ce1,0x00000000,0x00000000,0x00000000}},	//   _јони, --, --, --, 
   {{0x98480b1e,0xdca4018f,0x57b8040e,0x00000000}},	//   дяка_, _аами, इव्ह, --, 
   {{0x17a00155,0x46a40030,0x00000000,0x00000000}},	//   ақаҳ, _केबह, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x98b00333,0xcba001d2,0x41b403e7,0x00000000}},	//   ıyı_, _тарй, ीवास, --, 
   {{0x325402dc,0xceb00d47,0x743401c7,0x00000000}},	//   ҳвор, ייו_, гниф, --, 
   {{0x857001d2,0x645c0207,0x00000000,0x00000000}},	//   рлых, åsip, --, --, 
   {{0x79800140,0xb9ec02b4,0x27f8005e,0x32542345}},	//   _homw, _ኔረ_, _ésna_, гвор, 
   {{0x798008bb,0x60d42346,0x00000000,0x00000000}},	//   _komw, _azym, --, --, 
   {{0x28d8004b,0x316c2347,0x82302348,0x00000000}},	//   बेकि, ñez_, گریا, --, 
   {{0x798008bb,0x60d403ef,0x24940012,0x94740075}},	//   _momw, _czym, _مۅٹھ_, _جداا, 
   {{0x798008bb,0x9f5001e8,0x82301826,0xef540116}},	//   _lomw, _juyè_, دریا, ыкгь, 
   {{0xdb0400bd,0xca68024b,0x527400fc,0xa3c00388}},	//   ámýc, гiнi, _шуду, ूतर_, 
   {{0xa91c0212,0x79802349,0x31341cad,0x7f90012b}},	//   _kože, _nomw, _сеир, _väqa, 
   {{0xa91c234a,0xebd80e42,0x7f90012b,0x60d40201}},	// [1ed0] _jože, едаш_, _wäqa, _gzym, 
   {{0xa91c234b,0x4174234c,0xad4000cc,0x00000000}},	//   _može, _ماۋس, _گۉرۉ, --, 
   {{0x7980234d,0xefe40090,0x7ac40007,0x00000000}},	//   _bomw, ዛኛው_, асце, --, 
   {{0x60d400fc,0xaa9000b8,0x660000f2,0x00000000}},	//   _yzym, аҳҳә, _rtlk, --, 
   {{0x68440017,0xa91c234e,0x6d5c234f,0x79802350}},	//   унла, _nože, _iasa, _domw, 
   {{0x6d5c2351,0x79800278,0x00000000,0x00000000}},	//   _hasa, _eomw, --, --, 
   {{0x6d5c2352,0xe5a42353,0xa7fc0028,0xa91c01df}},	//   _kasa, лики, _grűn, _požd, 
   {{0xe4580cac,0xa91c0b0a,0x79800278,0x555006e5}},	//   ежи_, _bože, _gomw, مپىر, 
   {{0x69c82354,0xa91c0106,0xd5440027,0xdbe800e3}},	//   _ikee, _vožd, упые_, _hőál, 
   {{0x6d5c2355,0x798017b3,0x2bd82356,0xc6a4078e}},	//   _lasa, _zomw, _बीमा, _иреи, 
   {{0x798017b3,0x69c82357,0x6d5c2358,0x60d42359}},	//   _yomw, _kkee, _oasa, _szym, 
   {{0x6388000d,0x00000000,0x00000000,0x00000000}},	//   _bênê, --, --, --, 
   {{0x643800cf,0x00000000,0x00000000,0x00000000}},	//   _נײַג, --, --, --, 
   {{0x443c235a,0x6d5c235b,0x6458235c,0x69c80139}},	//   mtu_, _aasa, _iswi, _lkee, 
   {{0x69c8235d,0xa91c00c0,0x327400ea,0xaf98021d}},	//   _okee, _zože, _ننوځ, ттях_, 
   {{0x5bbc1113,0x69c80069,0xa91c0091,0x5de40e1a}},	//   ्त्व, _nkee, _ložb, ужба, 
   {{0x79800088,0x3ba400f8,0x70540320,0x00000000}},	// [1ee0] _romw, алаҳ, _кĕте, --, 
   {{0x443c235e,0x69c8235f,0x6d5c2360,0xed5800f8}},	//   itu_, _akee, _easa, ноӣ_, 
   {{0x6d5c2361,0x443c2362,0x798017b3,0x00000000}},	//   _fasa, htu_, _pomw, --, 
   {{0x6d5c2363,0x79800428,0x4e780100,0x64580098}},	//   _gasa, _qomw, _נאכצ, _oswi, 
   {{0x443c2364,0x8eb004c3,0x1c1c025c,0x00000000}},	//   jtu_, _نمیش, _पिटल_, --, 
   {{0x6d5c2365,0x69c82366,0x443c2367,0xfbb82368}},	//   _zasa, _ekee, dtu_, _आदिम, 
   {{0x6d5c2369,0x6458236a,0x7980236b,0x443c236c}},	//   _yasa, _aswi, _tomw, etu_, 
   {{0x6d5c04bb,0xa91c236d,0x69c80054,0x3f98011a}},	//   _xasa, _pože, _gkee, hhru_, 
   {{0x38c802a5,0x7bdc236e,0xf8b0049d,0x9734236f}},	//   _شاری_, _khru, _بکا_, _معاص, 
   {{0xa91c000e,0xb4c4025c,0xdb1c0113,0x00000000}},	//   _vože, _एडी_, kopí, --, 
   {{0x443c2370,0x64582371,0x3f980002,0x00000000}},	//   atu_, _eswi, dhru_, --, 
   {{0xa91c14ba,0x645801c8,0x3f98011a,0xa69400e1}},	//   _tože, äbiä, ehru_, _труј, 
   {{0x443c2372,0x80c800dc,0x00000000,0x00000000}},	//   ctu_, রেস্, --, --, 
   {{0x6d5c2373,0xa91c01d1,0xa3c00095,0x00000000}},	//   _sasa, _kožc, ूतः_, --, 
   {{0xcdd82374,0x27e819ab,0x0edc0203,0x02f8023c}},	//   ења_, ìani_, फेंड, _אלומ, 
   {{0x6d5c2375,0x64580336,0x46a400a1,0x3104024b}},	//   _qasa, _yswi, _कइसह, _тікұ, 
   {{0x6d5c2376,0x7bdc2377,0xc98400c3,0xed5800ec}},	// [1ef0] _vasa, _bhru, һуди, ноң_, 
   {{0x6d5c2378,0x7bdc2379,0x69c80437,0x6d90036d}},	//   _wasa, _chru, _skee, _gåan, 
   {{0x443c0396,0xaa54237a,0x7bdc237b,0xdeb00041}},	//   ztu_, рвеш, _dhru, _дұры, 
   {{0x443c237c,0x6d5c1472,0x7bdc237d,0xfc3001b8}},	//   ytu_, _uasa, _ehru, تحہ_, 
   {{0x443c237e,0x0c84237f,0x7bdc01ca,0x00000000}},	//   xtu_, _сынм, _fhru, --, 
   {{0x8ae41bc8,0x7bdc2380,0x66042381,0x64580496}},	//   _бібл, _ghru, апка, _rswi, 
   {{0xc6a40e0a,0x443c0126,0xf60801ac,0xaab803bf}},	//   ырди, wtu_, هتيه_, _आशिक, 
   {{0x443c2382,0x7bdc02d6,0x64580039,0xd6cc0272}},	//   ttu_, _zhru, _pswi, بقى_, 
   {{0x443c2383,0xa91c14ba,0xe3b802ba,0x00000000}},	//   utu_, _tožb, кби_, --, 
   {{0x443c2384,0x1c1c021f,0x93402385,0x67d41cd6}},	//   rtu_, _पिघल_, онье, _тозу, 
   {{0x65942386,0xe1081c6d,0x765c0247,0xe2b40023}},	//   _кажу, кенд_, _áryp, рспэ, 
   {{0x64582387,0x2934007c,0xc0e000ff,0x926000c3}},	//   _tswi, סאָן_, _ዑመር_, زگىم, 
   {{0x64582388,0x3f982389,0x443c238a,0x20b8238b}},	//   _uswi, thru_, qtu_, тынь_, 
   {{0xa2e4238c,0x232800c8,0xd0040d15,0xaf3401b5}},	//   _колд, _роки_, рере_, ٝرِت, 
   {{0xe298021b,0x29d40207,0x00000000,0x00000000}},	//   _шак_, våan_, --, --, 
   {{0x7bdc238d,0xdb1c238e,0x80c802fa,0xd24c238f}},	//   _shru, ropí, রেষ্, _آني_, 
   {{0x7bdc01d6,0xd00c0dae,0x00000000,0x00000000}},	// [1f00] _phru, _قلي_, --, --, 
   {{0x3f8c0030,0xdb1c00ef,0x00000000,0x00000000}},	//   ödud_, popí, --, --, 
   {{0x9d442390,0x7bc000d3,0x00000000,0x00000000}},	//   _кенд, _ímum, --, --, 
   {{0xdc340121,0xa91c01f6,0x00000000,0x00000000}},	//   _پىسخ, _rožc, --, --, 
   {{0x7bdc2391,0x985400fb,0x00000000,0x00000000}},	//   _thru, ртеш, --, --, 
   {{0x5fc42392,0x00000000,0x00000000,0x00000000}},	//   लकिल, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4140116,0x00000000,0x00000000,0x00000000}},	//   қьҩы, --, --, --, 
   {{0x57e82393,0x3e5801b1,0x18a42394,0x99980078}},	//   _адам_, _lōt_, _таам, nspō_, 
   {{0x07a02395,0x88380107,0x00000000,0x00000000}},	//   _даун, _בתמו, --, --, 
   {{0x3e5800f1,0x00000000,0x00000000,0x00000000}},	//   _nōt_, --, --, --, 
   {{0xa91c00e9,0x00000000,0x00000000,0x00000000}},	//   _koža, --, --, --, 
   {{0x344802dc,0x73c403ba,0x00000000,0x00000000}},	//   _сӯйи_, _гәне, --, --, 
   {{0xa91c2396,0x926800b8,0xa2c0011c,0x823001ac}},	//   _moža, _ариа_, _रुक्, _ڀريا, 
   {{0xbe882397,0x63bc01b8,0xa31002d9,0x00000000}},	//   асте_, ésne, äčšo, --, 
   {{0x40c801e5,0x072c00c3,0xb1142398,0x7058138a}},	//   ọrị_, ﯨﻤﯘ_, _умиш, _баир_, 
   {{0xdce402b3,0x660c02db,0x8c3400f8,0x7bf8009e}},	// [1f10] _mokė, ćaki, розӣ_, интр_, 
   {{0xbb7401c3,0x46a40030,0x00000000,0x00000000}},	//   огуј, _कइलह, --, --, 
   {{0xd1ec01e2,0xf9902399,0x00000000,0x00000000}},	//   _ሁለት_, ژبه_, --, --, 
   {{0xa91c239a,0x00000000,0x00000000,0x00000000}},	//   _boža, --, --, --, 
   {{0x67d4239b,0x3e580078,0x3b180387,0xe728239c}},	//   боду, _zōt_, _ferq_, голд_, 
   {{0xa91c03aa,0x00000000,0x00000000,0x00000000}},	//   _doža, --, --, --, 
   {{0xa6c8239d,0x361802b3,0xeae401b9,0xaa940272}},	//   ылка_, ацыю_, _প্ৰম, _الأث, 
   {{0xa2c00698,0x00000000,0x00000000,0x00000000}},	//   _रुग्, --, --, --, 
   {{0x291c239e,0x18b0239f,0x9f5000d3,0x64a423a0}},	//   mawa_, _нәшр, _buyì_, сапа, 
   {{0x291c23a1,0x86b0024b,0x984c000d,0x4ad823a2}},	//   lawa_, _мәйі, _gđđh_, _भराव, 
   {{0x65141e85,0xdb1c000f,0x6e3400e9,0x0d1400b3}},	//   _هوائ, nopá, juzb, तराष_, 
   {{0x291c23a3,0x68ec0214,0x070823a4,0xf65000bf}},	//   nawa_, žadu, _स्तव_, _تئك_, 
   {{0x25ac23a5,0xe1f00eb6,0x291c0299,0x7dfc01b1}},	//   miel_, _کست_, iawa_, _pčso, 
   {{0x291c2264,0x25ac23a6,0x3e580078,0xdb1c23a7}},	//   hawa_, liel_, _pōt_, kopá, 
   {{0x8fa023a8,0xa7fc0ac1,0xdc340152,0x216800cc}},	//   чаре, _brűk, _bäğe, _бийи_, 
   {{0x291c23a9,0xdca401a0,0xdb1c0113,0x3b18043b}},	//   jawa_, баби, dopá, _serq_, 
   {{0x291c23aa,0xf1a8049d,0x3b1802ba,0xa06823ab}},	// [1f20] dawa_, _خاوه_, _perq_, _сапа_, 
   {{0x25ac23ac,0x3b18043b,0xa3dc03e1,0x29080d8c}},	//   hiel_, _qerq_, _थीम_, ñaan_, 
   {{0x25ac23ad,0x291c23ae,0xa91c01f6,0x248c0475}},	//   kiel_, fawa_, _soža, hyem_, 
   {{0x291c23af,0xa91c0192,0x25ac0145,0xdca40151}},	//   gawa_, _poža, jiel_, x̣ʷł, 
   {{0x25ac23b0,0xb5fc0002,0xd76401a0,0x00000000}},	//   diel_, _irġi, ینچی, --, 
   {{0x9b9423b1,0x0a9800cc,0x00000000,0x00000000}},	//   _الست, _өссө_, --, --, 
   {{0x25ac2046,0x291c23b2,0xd1ec0090,0x6384012c}},	//   fiel_, bawa_, _ሁለቱ_, _méně, 
   {{0x291c0382,0x25ac23b3,0xa91c01d1,0x00000000}},	//   cawa_, giel_, _toža, --, 
   {{0xf8dc0076,0xca680200,0x09e001a7,0x0460038e}},	//   _बरिय, гiзi, _хотн, птэм, 
   {{0x6e3401a0,0x9f940034,0xa784031e,0xfdc40030}},	//   yuzb, lææ_, _وشلو, वकुफ, 
   {{0xa91c23b4,0x25ac0a81,0xcb1011e7,0xc20401b8}},	//   _možn, biel_, הלת_, یقین_, 
   {{0x25ac23b5,0xf48423b6,0xa91c00aa,0x9f500537}},	//   ciel_, _واشی, _ložn, _wuyì_, 
   {{0xf0e80200,0x13a804e7,0x00000000,0x00000000}},	//   شىسى_, _ینچی_, --, --, 
   {{0x291c23b7,0xa91c23b8,0x6e3423b9,0xf1640223}},	//   zawa_, _nožn, tuzb, _imọ̀_, 
   {{0x291c23ba,0xfdc40774,0x04b40191,0x00000000}},	//   yawa_, वकूफ, _نھیں_, --, 
   {{0x291c0636,0xa1f400d5,0x00000000,0x00000000}},	//   xawa_, _گڑیا_, --, --, 
   {{0x06680121,0x291c007b,0x00000000,0x00000000}},	// [1f30] _ﺳﯧﻠﯩ, vawa_, --, --, 
   {{0x291c23bb,0xdb1c23bc,0x00000000,0x00000000}},	//   wawa_, topá, --, --, 
   {{0x291c23bd,0x248c23be,0xcae00774,0x2d840670}},	//   tawa_, zyem_, केंड_, êles_, 
   {{0x291c03a2,0x6ab81c44,0x25ac14c5,0x248c0110}},	//   uawa_, _आशीर, xiel_, yyem_, 
   {{0xf77023bf,0x291c23c0,0x2d9823c1,0x25ac23c2}},	//   کان_, rawa_, _ilse_, viel_, 
   {{0x291c23c3,0x248c14c5,0x25ac23c4,0xdb1c001e}},	//   sawa_, vyem_, wiel_, popá, 
   {{0x291c08df,0x9ba023c5,0x25ac23c6,0xe9e80075}},	//   pawa_, _تەلى, tiel_, _نفسى_, 
   {{0x248c05e5,0x291c044d,0xf7700b0f,0xdb1c0353}},	//   tyem_, qawa_, _ۋال_, gopæ, 
   {{0x25ac23c7,0x92e402fa,0x00000000,0x00000000}},	//   riel_, যুৎ_, --, --, 
   {{0x25ac23c8,0xa91c23c9,0x248c059c,0x7e7c015e}},	//   siel_, _kožo, ryem_, yxrp, 
   {{0x25ac23ca,0x248c0078,0x80dc00aa,0xecac0143}},	//   piel_, syem_, _नरहे, _কুমড, 
   {{0x61e4036d,0x248c0078,0xa06800cc,0xe04423cb}},	//   umkl, pyem_, аама_, онми, 
   {{0x10a023cc,0xb5c80324,0x00000000,0x00000000}},	//   диян, _اونم_, --, --, 
   {{0x2d9802ba,0xaab823cd,0x92a801b8,0x00000000}},	//   _alse_, _आशंक, ائیہ_, --, 
   {{0xa91c23ce,0xe81823cf,0x00000000,0x00000000}},	//   _rožn, नीता_, --, --, 
   {{0x2908038a,0x00000000,0x00000000,0x00000000}},	//   ñaal_, --, --, --, 
   {{0x8c4023d0,0xa91c00e9,0x5ba80deb,0x00000000}},	// [1f40] мете, _požn, акам_, --, 
   {{0xa91c23d1,0x2d9823d2,0x7dfc01d5,0x00000000}},	//   _božo, _else_, _jčsk, --, 
   {{0xa91c21cb,0xdee401cf,0x9cc818b9,0x00000000}},	//   _vožn, _фони, уыңа_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7d0423d3,0x97c423d4,0xa91c0c91,0x4810021d}},	//   mcis, ойде, _tožn, дміс, 
   {{0x7c2423d5,0x7d0423d6,0x1a240012,0x00000000}},	//   msir, lcis, _ورزُ, --, 
   {{0x07a00385,0x7d0400b7,0xdb1c0353,0x998400fb}},	//   ќајн, ocis, topæ, _мăкш, 
   {{0x7d0423d7,0x0d94007c,0x7c240c32,0x00000000}},	//   ncis, ַכים_, osir, --, 
   {{0x7c2423d8,0x7d0423d9,0xdb1c0184,0xdcf40055}},	//   nsir, icis, ropæ, niyı, 
   {{0x926823da,0x7c2423db,0x938800b8,0x7f90006b}},	//   арма_, isir, рсиа_, _fäqi, 
   {{0x7dfc00f1,0x8af8067a,0x7d0423dc,0x7c2423dd}},	//   _dčsk, יליז, kcis, hsir, 
   {{0x7c2423de,0x63800329,0x7d0401df,0xdb1c02eb}},	//   ksir, дҳәа, jcis, lopä, 
   {{0x7c240070,0x00000000,0x00000000,0x00000000}},	//   jsir, --, --, --, 
   {{0x09b423df,0xc05800c8,0x7d0423e0,0x7c24036d}},	//   _अद्य, цію_, ecis, dsir, 
   {{0x8d7423e1,0x7f90012b,0x645c0560,0x11d4129f}},	//   يارا, _xäqi, ħsie, _وتعد, 
   {{0x7c2423e2,0x7d04009d,0x752023e3,0xa91c01d4}},	//   fsir, gcis, namz, _rožo, 
   {{0x7c2423e4,0xb5fc011a,0x29080029,0xdb1c02eb}},	// [1f50] gsir, _irġu, ñaam_, kopä, 
   {{0x09b023e5,0xf3fc007e,0x7d0423e6,0x35cc0457}},	//   ंच्य, _এবাৰ_, acis, ावड़, 
   {{0x752023e7,0xdfd003a2,0x7c240266,0x6b5006b4}},	//   kamz, _سيٽ_, asir, _aðgæ, 
   {{0xc8b023e8,0x7d0423e9,0x7c2423ea,0xbdf80061}},	//   ولاک, ccis, bsir, _گریا_, 
   {{0x6c78007c,0xf804006b,0xdb1c0030,0x752023eb}},	//   _האָפ, үчән, fopä, damz, 
   {{0xbdf823ec,0x80c802fa,0xdb1c0104,0xa91c01d4}},	//   _دریا_, রেক্, gopä, _zožl, 
   {{0xf1bc0095,0x00000000,0x00000000,0x00000000}},	//   ैवान, --, --, --, 
   {{0x752023ed,0x7f90006b,0x3ebc00ca,0xa5240123}},	//   gamz, _väqi, יצוב, чмид, 
   {{0xf7700a1d,0x00000000,0x00000000,0x00000000}},	//   _ڄام_, --, --, --, 
   {{0xf77023ee,0xa91c23ef,0x63781baf,0x7f90012b}},	//   _لام_, _možm, ссир_, _täqi, 
   {{0x216823f0,0xa91c015b,0x7c2400c0,0x00000000}},	//   бини_, _ložm, zsir, --, 
   {{0xdce40028,0x7d0403af,0x6454007b,0x7c2423f1}},	//   _enkę, xcis, ăzib, ysir, 
   {{0xa91c23f2,0x00000000,0x00000000,0x00000000}},	//   _rožl, --, --, --, 
   {{0x7c24070b,0x224402d4,0x00000000,0x00000000}},	//   vsir, ptlk_, --, --, 
   {{0x7c240d2e,0x7d040055,0x00000000,0x00000000}},	//   wsir, tcis, --, --, 
   {{0x7c2423f3,0x91e00348,0xf1a8082f,0x7d040670}},	//   tsir, _поще, _وايه_, ucis, 
   {{0x7d0423f4,0xe3180048,0x2120014a,0x00000000}},	// [1f60] rcis, _điể, makh_, --, 
   {{0x2120000f,0x7d0423f5,0x61f423f6,0x752008be}},	//   lakh_, scis, _hiyl, zamz, 
   {{0x4ef8033c,0x7c2423f7,0x39b80078,0x14e0006c}},	//   _להיו, ssir, lčsi_, _परभण, 
   {{0x82f80560,0xd00c23f8,0x00000000,0x00000000}},	//   _ནུའུ_, _جلی_, --, --, 
   {{0x636400a2,0xdb1c23f9,0x7c2423fa,0x61f400f2}},	//   _kōnē, topä, qsir, _miyl, 
   {{0xc7a023fb,0x07a023fc,0xb8f40076,0x60d40274}},	//   ничк, начн, _सँ_, _myym, 
   {{0xdb1c23fd,0xa3c004c7,0x21200083,0x7520042e}},	//   ropä, ्कन_, kakh_, tamz, 
   {{0x61f40636,0x7f90006b,0x00000000,0x00000000}},	//   _niyl, _täqw, --, --, 
   {{0x752023fe,0x73c40c87,0xdb1c0139,0xb784018f}},	//   ramz, мәке, popä, _оғди, 
   {{0xb9cc010f,0x75201c58,0xd378044a,0x00000000}},	//   _ቶሎ_, samz, счи_, --, 
   {{0xca2c0ce5,0xa91c00b0,0x313423ff,0xd5740b1e}},	//   ﺩﻗﺎ_, _alžy, менр, _нудь, 
   {{0x21200083,0xc1080254,0x86780107,0xa8a403d6}},	//   gakh_, зэре_, _לרבו, _ирĕк, 
   {{0xa91c2400,0x6ab80fa3,0x9f500101,0x61f42401}},	//   _božj, _आश्र, _atyñ_, _diyl, 
   {{0xa91c2402,0x00000000,0x00000000,0x00000000}},	//   _rožm, --, --, --, 
   {{0x21202403,0x61f4018f,0xc7d400ca,0x00000000}},	//   bakh_, _fiyl, פולי_, --, 
   {{0x61f4012b,0x00000000,0x00000000,0x00000000}},	//   _giyl, --, --, --, 
   {{0xdb0c13e8,0x6ecc2016,0x9f4800b7,0x3d0c00a1}},	// [1f70] _imbê, _दुरु, imbê_, ़ड़े_, 
   {{0xaa94018f,0x00000000,0x00000000,0x00000000}},	//   мизч, --, --, --, 
   {{0xbb8403e0,0xecf82404,0x00000000,0x00000000}},	//   علمي, _менш_, --, --, 
   {{0xac9401a0,0x61f401d9,0x00000000,0x00000000}},	//   _жамш, _xiyl, --, --, 
   {{0xa3c000b3,0x00000000,0x00000000,0x00000000}},	//   ्कम_, --, --, --, 
   {{0x21202405,0x6d4c2406,0xa69801c3,0x00000000}},	//   zakh_, lfaa, жњих_, --, 
   {{0xb8f42407,0xa91c2408,0x6d4c0080,0x00000000}},	//   _सु_, _jožk, ofaa, --, 
   {{0x24080332,0x6d4c2409,0xa2ac240a,0xa91c01d1}},	//   онии_, nfaa, ुपस्, _možk, 
   {{0x6d4c03f2,0x69d800e2,0x00000000,0x00000000}},	//   ifaa, mlwe, --, --, 
   {{0xdb0c0064,0x69d8240b,0x6d4c01b5,0x01940020}},	//   _ambê, llwe, hfaa, _ዝረኸበ_, 
   {{0x7f9001c8,0x69d8240c,0x21200d8c,0xa91c012c}},	//   _mäqt, olwe, takh_, _nožk, 
   {{0x60d40139,0x61f401e3,0x24540075,0x00000000}},	//   _pyym, _qiyl, _يناس, --, 
   {{0x69d8240d,0x7dfc240e,0x6d4c0010,0x2120240f}},	//   ilwe, _mōse, dfaa, rakh_, 
   {{0x69d80bb1,0x98b006f7,0x64482410,0xd9a82411}},	//   hlwe, żyć_, mtei, _कष्ट, 
   {{0x6d4c2412,0x69d80123,0x63a00083,0xfe780128}},	//   ffaa, klwe, mhln, чүн_, 
   {{0x65682413,0x6d4c007b,0xe8e400dd,0x6448100a}},	//   ndeh, gfaa, _مڻ_, otei, 
   {{0x69d81203,0x71640256,0x6aa402e3,0x1c440023}},	// [1f80] dlwe, _سايك, ezhf, ьнам, 
   {{0x64482414,0x63a0041c,0x6d4c2415,0x69d82416}},	//   itei, nhln, afaa, elwe, 
   {{0x64482417,0x6d4c01f9,0x7f5c0380,0x8f7800ca}},	//   htei, bfaa, merq, _וניק, 
   {{0xaae42418,0x656801ed,0xa3c008ed,0x6d4c0060}},	//   رسلو, jdeh, ्कड_, cfaa, 
   {{0x80dc0092,0xa3bc0828,0xdb0c0084,0x65682419}},	//   ণশক্, _इदं_, þjón, ddeh, 
   {{0x6568241a,0x6448241b,0x7f5c012e,0x69d8062d}},	//   edeh, dtei, nerq, alwe, 
   {{0x2a34038e,0x6448241c,0x5fd40041,0x4664241d}},	//   _пэтр, etei, ﯞﺍﭘﺘ, дрым_, 
   {{0x6448241e,0xe8180c51,0x7f5c0105,0x3e480104}},	//   ftei, _नौका_, herq, ißt_, 
   {{0x3944023f,0x7f5c071c,0x27e40177,0x3f98241f}},	//   _icms_, kerq, _fhln_, kkru_, 
   {{0x6578147c,0x27e40177,0x96942420,0x99980296}},	//   _enwh, _ghln_, _ореш, kupū_, 
   {{0x64482421,0x7f5c0083,0xdb0c02bb,0x38640086}},	//   atei, derq, _ambë, _hsmr_, 
   {{0xdb0c012f,0x64482422,0x9578010f,0xa91c2423}},	//   _ejbø, btei, ጮቻችን_, _rožk, 
   {{0x14e008e7,0x644809c1,0x3e4803c8,0x7afc236d}},	//   _परिण, ctei, eßt_, _ogrt, 
   {{0x61ec0c75,0x7f5c02b1,0x69d80008,0x9f480078}},	//   _ďale, gerq, zlwe, nmbè_, 
   {{0xdb0c2424,0x51840931,0x77680060,0xdb1c00b8}},	//   _imbè, _жупа, _madx, bopú, 
   {{0xa2ac0357,0x6d4c2425,0x69d80008,0xdedc0020}},	//   ुपर्, ufaa, xlwe, ዒልካ_, 
   {{0xab7404e7,0x6d4c2426,0x6b742427,0x2ae00030}},	// [1f90] нгаш, rfaa, нлау, _करहु_, 
   {{0x6d4c2428,0x4fc40103,0xcf240046,0x7f5c2429}},	//   sfaa, _іспа, _کرکي, cerq, 
   {{0x69d8240d,0x6448242a,0x316801ab,0x6d4c01ab}},	//   tlwe, ztei, _kaaz_, pfaa, 
   {{0xa91c1909,0x6448242b,0x6d4c028b,0x9f6000d3}},	//   _koži, ytei, qfaa, _òpòs_, 
   {{0xdb0c005e,0xa91c01f6,0x3168242c,0x6448242d}},	//   _ombè, _joži, _maaz_, xtei, 
   {{0xa3dc06f7,0x66e4242e,0x23dc021f,0xa91c01f6}},	//   _थीं_, нола, _नींद, _moži, 
   {{0x92c000ac,0xa91c03aa,0x3ddc0239,0xe91800c8}},	//   ্ধু_, _loži, _âzwâ_, _нові_, 
   {{0x6448242f,0xdb0c0249,0x7f5c06e2,0x00000000}},	//   ttei, _ambè, zerq, --, 
   {{0xa91c2430,0x75680191,0xe584002c,0x7768028b}},	//   _noži, بینہ_, _үтеү, _fadx, 
   {{0x65682431,0xf77400b8,0x13e4006b,0x2b40000d}},	//   sdeh, _аҧш_, нмый_, nghc_, 
   {{0x21682432,0x3168028b,0x00000000,0x00000000}},	//   пини_, _baaz_, --, --, 
   {{0xa91c0518,0x67202433,0x64482434,0x628002ac}},	//   _boži, _helj, ptei, rxlo, 
   {{0x66002435,0x7f5c2436,0x67202437,0x601401d7}},	//   _hulk, terq, _kelj, _ẹmbr, 
   {{0xa91c16e5,0x66002438,0xb4640302,0xdd902439}},	//   _doži, _kulk, _шкіл, گور_, 
   {{0x66000466,0xe298243a,0x9f4802ba,0x7f5c04db}},	//   _julk, _хай_, nmbé_, rerq, 
   {{0xdd90243b,0x6600243c,0x3f982075,0xdb0c243d}},	//   دور_, _mulk, skru_, _imbé, 
   {{0x7f5c243e,0xa91c00b0,0x67200379,0x6600243f}},	// [1fa0] perq, _goži, _oelj, _lulk, 
   {{0xa3c013aa,0x67200fde,0x66000693,0x99980296}},	//   ्कि_, _nelj, _oulk, pupū_, 
   {{0xa91c01f6,0xcee00049,0x192c001d,0x00000000}},	//   _zoži, _бұрқ, _አምልኮ, --, 
   {{0xd82414e4,0x99d40f5f,0xd7f819ce,0x57b8006c}},	//   едди, رتاا, пук_, ेव्ह, 
   {{0xa3c00cbd,0x66002440,0x00000000,0x00000000}},	//   ्का_, _aulk, --, --, 
   {{0x67200f68,0xacb000c3,0x87e00246,0x00000000}},	//   _celj, _ئەكب, люще, --, 
   {{0x660000f1,0x67202441,0xdd10004f,0x41e002a4}},	//   _culk, _delj, _aüũu, नतास, 
   {{0x66002442,0x6720013c,0x394400b0,0x00000000}},	//   _dulk, _eelj, _ucms_, --, 
   {{0xdb0c00c6,0x67200191,0x5ed00698,0x380400f8}},	//   _ambé, _felj, _दुसऱ, _розҳ, 
   {{0xc450045d,0x67200937,0xa91c2443,0x3168000b}},	//   اضيع, _gelj, _roži, _saaz_, 
   {{0x6680009d,0xa91c01f6,0x4b340100,0xc87c0386}},	//   _نیول, _soži, ערטל_, _öğrt_, 
   {{0x672014b4,0xa91c2444,0xa7fc0028,0xf4842445}},	//   _zelj, _poži, _krűp, _لاتی, 
   {{0x66002446,0xdb0c0039,0x4fc41166,0x92c002fa}},	//   _zulk, _embé, есва, ্ধে_, 
   {{0xa91c01d5,0x00000000,0x00000000,0x00000000}},	//   _voži, --, --, --, 
   {{0x660001b5,0x00000000,0x00000000,0x00000000}},	//   _xulk, --, --, --, 
   {{0xa91c14ba,0xdce42447,0x2bd82448,0x29d40207}},	//   _toži, _alkı, _बीजा, håar_, 
   {{0x41c40930,0x7de40200,0x6d8401b5,0x00000000}},	// [1fb0] _حقيق, уірд, _یۅسہ_, --, 
   {{0x6e94001e,0x4ae80027,0x00000000,0x00000000}},	//   _аиоу, пьем_, --, --, 
   {{0x67202449,0x70e000d1,0x7f90006b,0x00000000}},	//   _relj, _नरुल, _täqr, --, 
   {{0xba7409a8,0xdd1402d9,0x9e64244a,0x15c8004f}},	//   داكت, _päťd, _شاپن, _gṛṇī, 
   {{0x6600244b,0x6720244c,0x9ba00121,0x00000000}},	//   _sulk, _pelj, _ھەمى, --, 
   {{0x6600244d,0x5cc005bc,0x00000000,0x00000000}},	//   _pulk, _төсв, --, --, 
   {{0x6720244e,0x2ca80145,0xe5a40409,0x6600028b}},	//   _velj, lzad_, кики, _qulk, 
   {{0x672002e3,0x2d88244f,0x00000000,0x00000000}},	//   _welj, njae_, --, --, 
   {{0x67202450,0x290c2451,0x7dfc0369,0x14202452}},	//   _telj, _ifea_, _mōsa, адым, 
   {{0xc6a42453,0x66002454,0xe2982455,0x2ca802e3}},	//   _преи, _tulk, дао_, izad_, 
   {{0x2ca8036d,0xb2f40ad2,0x3dc00209,0x66000012}},	//   hzad_, ляющ, yniw_, _uulk, 
   {{0xe1942456,0x00000000,0x00000000,0x00000000}},	//   троэ, --, --, --, 
   {{0x2ca80ffc,0xe3641028,0xd00c0b16,0x00000000}},	//   jzad_, _акли, يلَ_, --, 
   {{0x443c2457,0x645802b0,0x00000000,0x00000000}},	//   muu_, _ipwi, --, --, 
   {{0x443c2458,0x290c03f2,0x1d0802ba,0x7d0800f2}},	//   luu_, _ofea_, деби_, _néró, 
   {{0xa91c2459,0xca64018f,0x00000000,0x00000000}},	//   _kožu, _rejа, --, --, 
   {{0x443c245a,0xd1e80422,0x4938010f,0x6d900207}},	// [1fc0] nuu_, _ዘረባ_, _አምራቾ, _påar, 
   {{0x290c2098,0x9f0401b5,0xed5800f8,0x443c03f2}},	//   _afea_, _جودو, моӣ_, iuu_, 
   {{0x443c245b,0xc2f00143,0x6cb80152,0x00000000}},	//   huu_, চুরি_, _җыяр_, --, 
   {{0x443c245c,0x6458245d,0x6d4800b8,0x00000000}},	//   kuu_, _opwi, _ñeap, --, 
   {{0x443c245e,0x2ca80201,0x00000000,0x00000000}},	//   juu_, czad_, --, --, 
   {{0x443c245f,0x68ec01ec,0x889002dc,0x00000000}},	//   duu_, ýada, ришх, --, 
   {{0x64580278,0xdce40078,0xabc401c4,0x00000000}},	//   _apwi, _makč, _сарҙ, --, 
   {{0xd4980a3a,0x443c2460,0xa91c0070,0x59a400a1}},	//   дро_, fuu_, _božu, _खतिर, 
   {{0x443c2461,0xa91c01d1,0x9f5802bb,0x574801d2}},	//   guu_, _požv, _cipë_, _озам_, 
   {{0xa91c02db,0xdce4028d,0x96b40106,0x73341184}},	//   _dožu, _nakč, _исељ, دىدا, 
   {{0x64582462,0x443c2463,0xc7d40107,0x00000000}},	//   _epwi, auu_, _יומי_, --, 
   {{0x443c2464,0xe8182465,0x6ecc03ea,0x00000000}},	//   buu_, नीका_, _दुगु, --, 
   {{0x04402466,0x443c2467,0x82f400d5,0x291002a0}},	//   _вечн, cuu_, ٹریز_, _əza_, 
   {{0x2fc4013c,0x9998012c,0x00000000,0x00000000}},	//   õlg_, kupů_, --, --, 
   {{0xa3c0057d,0x0264006b,0x00000000,0x00000000}},	//   ्कर_, _ашый_, --, --, 
   {{0xc0f00090,0x0dc800b7,0x518401c3,0x00000000}},	//   ቀርም_, фуги_, _јука, --, 
   {{0xa91c01d4,0x7d0802b2,0x4fc42468,0x00000000}},	// [1fd0] _možt, _séró, _асна, --, 
   {{0x6f080223,0x2ca82469,0x00000000,0x00000000}},	//   _dèbó, rzad_, --, --, 
   {{0x443c05c4,0x6e94246a,0xc984246b,0x00000000}},	//   zuu_, _сину, куди, --, 
   {{0x443c227b,0xdd90246c,0xf9900a1d,0xac180254}},	//   yuu_, _هوپ_, يبن_, _пому_, 
   {{0x443c0d07,0x7c84246d,0x9f580078,0xb86400e2}},	//   xuu_, _куре, _bipè_, لاوو, 
   {{0xfe70246e,0x443c246f,0xa91c2470,0x00000000}},	//   _ادی_, vuu_, _rožu, --, 
   {{0x443c2471,0xa91c01d4,0xc6a41166,0x98f400c3}},	//   wuu_, _božt, ърди, نغۇچ, 
   {{0x443c2458,0xa91c091d,0x7d80010f,0x291806b4}},	//   tuu_, _požu, _የሙዚቃ_, _ýsa_, 
   {{0xa3c00fd4,0xb33c0126,0x07440e00,0x00000000}},	//   ्कल_, ghħo, _ахем, --, 
   {{0x443c2457,0xdb1c00b8,0x53c400cc,0x00000000}},	//   ruu_, kopý, лгым_, --, 
   {{0xe2982472,0x443c2457,0xf7702473,0xdb1c00b8}},	//   хан_, suu_, _باق_, jopý, 
   {{0xa1340075,0x00000000,0x00000000,0x00000000}},	//   دردش, --, --, --, 
   {{0x443c158f,0xdce401e8,0x00000000,0x00000000}},	//   quu_, _pakč, --, --, 
   {{0xa2e41092,0x442c014a,0xd24c00ea,0x00000000}},	//   _йолд, _ivg_, _ځنو_, --, 
   {{0x442c0191,0x00000000,0x00000000,0x00000000}},	//   _hvg_, --, --, --, 
   {{0xdcb02474,0x1fb42475,0xf2c42476,0x00000000}},	//   مىز_, _әсир, _әсән, --, 
   {{0xa2ac0523,0x9f5801d5,0x00000000,0x00000000}},	// [1fe0] ुपक्, _lipé_, --, --, 
   {{0x442c2477,0xc0e40108,0x1f640129,0x00000000}},	//   _mvg_, _йоқк, _ском, --, 
   {{0x442c0091,0x9d4400cc,0x539800cf,0x00000000}},	//   _lvg_, _йенд, עיעו, --, 
   {{0x9f58065e,0x18a42478,0x442c002a,0xdca42479}},	//   _sipè_, лаем, _ovg_, _бами, 
   {{0x442c03f4,0x00000000,0x00000000,0x00000000}},	//   _nvg_, --, --, --, 
   {{0xa91c0113,0x00000000,0x00000000,0x00000000}},	//   _božs, --, --, --, 
   {{0x9f580078,0x442c247a,0xc0cc001d,0x00000000}},	//   _vipè_, _avg_, _አኩሪ_, --, 
   {{0x442c247b,0x743402dc,0x00000000,0x00000000}},	//   _bvg_, аниф, --, --, 
   {{0xd324247c,0x48e00a15,0xa91c00e5,0xa3c00add}},	//   льни, _готв, _vožt, ्कं_, 
   {{0x3254247d,0xbef400b3,0x0454247e,0x00000000}},	//   авор, _आणून_, اجيت_, --, 
   {{0x442c002a,0x00000000,0x00000000,0x00000000}},	//   _evg_, --, --, --, 
   {{0x442c0074,0x7334247f,0x14c802eb,0x00000000}},	//   _fvg_, دىگا, _пыли_, --, 
   {{0x442c0043,0xdb1c0c9b,0xc5f002c3,0xdb0c1d87}},	//   _gvg_, nopó, _הדף_, _ambí, 
   {{0xa91c2480,0xa3c00095,0x00000000,0x00000000}},	//   _inže, ्कः_, --, --, 
   {{0x442c002a,0x00000000,0x00000000,0x00000000}},	//   _zvg_, --, --, --, 
   {{0x82302481,0xc27804b0,0x8d740cc1,0x00000000}},	//   _اروا, _טרוי, داسا, --, 
   {{0xc3240664,0xe6e00884,0x0fe000df,0xdb1c001e}},	// [1ff0] _মাতি_, _फर्ज, _гөвү, jopó, 
   {{0x79802482,0xdce4015b,0xbcf40027,0x00000000}},	//   _anmw, _ankē, спущ, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa91c0091,0x28b80254,0x9f5800d3,0x3f8c013c}},	//   _onže, кулэ_, _ripé_, öduv_, 
   {{0x9f5800d3,0x00000000,0x00000000,0x00000000}},	//   _sipé_, --, --, --, 
   {{0x442c2483,0xdc38023c,0x265801f1,0x00000000}},	//   _rvg_, _בעשר, вриќ_, --, 
   {{0x16a40989,0xa91c2484,0x442c2208,0xa6c80668}},	//   ивши_, _anže, _svg_, ълка_, 
   {{0x442c018c,0xd8840012,0xe4480b0f,0xdce400a8}},	//   _pvg_, _چھون_, پلدى_, _hakā, 
   {{0x291c2485,0x18b012d5,0xdce409c4,0x39400306}},	//   mbwa_, _мәшр, _kakā, óise_, 
   {{0xe7a82486,0x68e82487,0x291c0078,0xdce419c5}},	//   _कतिप, _ized, lbwa_, _jakā, 
   {{0x26d02488,0xa2e42489,0x442c018c,0xc79400b8}},	//   _âzo_, ронд, _wvg_, _ирҧы, 
   {{0x442c03b2,0xdb1c248a,0x69c80472,0x291c01e8}},	//   _tvg_, nopò, _jjee, nbwa_, 
   {{0x291c248b,0x69c800d3,0xe3b00b26,0xd83c02cc}},	//   ibwa_, _mjee, _ورت_, _účte_, 
   {{0xdd0c02a0,0xdce400a8,0x00000000,0x00000000}},	//   _bışo, _nakā, --, --, 
   {{0x69c8248c,0x291c01b1,0x00000000,0x00000000}},	//   _ojee, kbwa_, --, --, 
   {{0x3d2006f7,0xe1f0248d,0x69c8248e,0x2d940139}},	//   बरें_, _بست_, _njee, брус, 
  
   {{0x291c0078,0xdce400a8,0x00000000,0x00000000}},	// [2000] dbwa_, _bakā, --, --, 
   {{0x69c820bf,0x109802c3,0xdce400cb,0x291c030b}},	//   _ajee, _סביב, _cakā, ebwa_, 
   {{0x68e8248f,0x75ec0028,0xdce409c4,0xcb640027}},	//   _azed, lûze, _dakā, рахе_, 
   {{0xf3fc0252,0x291c007b,0x1d08118d,0x00000000}},	//   _এবছৰ_, gbwa_, _шеми_, --, 
   {{0x8eb02490,0xa91c2491,0x6b6c00d4,0xd54000d3}},	//   _همیش, _požr, _bēgļ, _lẹ́f, 
   {{0xdb1c2492,0x68e80582,0x69c80472,0xc790071e}},	//   ropó, _dzed, _ejee, قشىب, 
   {{0x68e802dc,0xda7001b5,0x7980007b,0x75ec0028}},	//   _ezed, _بُز_, _tnmw, hûze, 
   {{0x59dc0021,0xdb1c03b2,0x69c8015b,0x00000000}},	//   _फीचर, popó, _gjee, --, 
   {{0x73d82493,0x46e42128,0x06e40c87,0x9c58021d}},	//   лдир_, лдән_, лмәк_, ерiг, 
   {{0xd3782494,0x00000000,0x00000000,0x00000000}},	//   тчи_, --, --, --, 
   {{0xaf0002fa,0xab780100,0x870800d5,0x00000000}},	//   ্রমণ_, אָרז, _شعلہ_, --, 
   {{0x3d200098,0x00000000,0x00000000,0x00000000}},	//   बरों_, --, --, --, 
   {{0x7bdc2495,0xdb0c034a,0x93e401d9,0x00000000}},	//   _okru, _ombà, _кўкл, --, 
   {{0x7bdc012d,0x2cac00df,0x00000000,0x00000000}},	//   _nkru, _ýedi_, --, --, 
   {{0x03a000e1,0xdce41bf4,0x00000000,0x00000000}},	//   _фијо, _rakā, --, --, 
   {{0xdce4005a,0xd24c01b8,0xe7ec0030,0x00000000}},	//   _sakā, _فنڈ_, _चीना_, --, 
   {{0xdce40ef7,0x6be40272,0xf4140100,0x23a800f2}},	// [2010] _pakā, مكرم, מפּ_, _fújd_, 
   {{0x95040002,0x69c8018c,0xfbd00046,0x7bdc0192}},	//   _ངུའི_, _sjee, وتل_, _ckru, 
   {{0x7ff4031b,0x68e80191,0xaa5400db,0xdce400a8}},	//   _بسيا, _szed, свеш, _vakā, 
   {{0x7bdc2496,0xe61802ac,0xa91c01d5,0x332c011a}},	//   _ekru, қди_, _cožp, hadx_, 
   {{0xe7382497,0xdb1c1eee,0x0c840b74,0xdce42498}},	//   гел_, ropò, _тынм, _takā, 
   {{0x8a140dfc,0xe5780336,0x23a80223,0x291c0472}},	//   _نظرا, glŷn_, _kúje_, sbwa_, 
   {{0xf7702499,0x69c8249a,0x39400306,0x00000000}},	//   بان_, _tjee, óisc_, --, 
   {{0x69c8004b,0x6b94075d,0xdb0c001e,0x9f940270}},	//   _ujee, _hozg, _imbá, hæð_, 
   {{0xbee41cac,0x69d8249b,0x6f040380,0x6b941240}},	//   _गर्न_, mowe, _oghc, _kozg, 
   {{0x69d8249c,0x7bdc011a,0xf770249d,0x00000000}},	//   lowe, _xkru, _يال_, --, 
   {{0x6b94249e,0x237c0422,0x00000000,0x00000000}},	//   _mozg, _ንገዛእ_, --, --, 
   {{0xa2e4249f,0x69d824a0,0x75ec0556,0x6b9424a1}},	//   _қойд, nowe, tûze, _lozg, 
   {{0xd24c0901,0x248824a2,0x69d800b7,0xd54000d3}},	//   ونی_, _çam_, iowe, _wẹ́f, 
   {{0x443c24a3,0x69d824a4,0xe7ec025c,0x232824a5}},	//   mru_, howe, _चीमा_, _соки_, 
   {{0xdee424a6,0x69d824a7,0xe3b003a2,0x236424a8}},	//   сови, kowe, _ورڪ_, melj_, 
   {{0x443c24a9,0x6f040156,0x69d8002f,0xd24c0272}},	//   oru_, _eghc, jowe, _أني_, 
   {{0x443c24aa,0x69d806f7,0x3f8c00b6,0x6b9424ab}},	// [2020] nru_, dowe, ödus_, _bozg, 
   {{0x6b940337,0x443c24ac,0x69d8007f,0x00000000}},	//   _cozg, iru_, eowe, --, 
   {{0x443c24ad,0x69d824ae,0x6b940201,0x00000000}},	//   hru_, fowe, _dozg, --, 
   {{0x5d84045d,0xd94424af,0x69d824b0,0x23640291}},	//   _الحل, седи, gowe, helj_, 
   {{0x6b940337,0xdb0c000f,0x236401f6,0x985401f1}},	//   _fozg, _embá, kelj_, стеш, 
   {{0x7bdc24b1,0x6b9400df,0xb8f400a8,0x22440078}},	//   _ukru, _gozg, _akṣī, kulk_, 
   {{0x9f5004ac,0x236406c1,0x69d824b2,0x15c801d3}},	//   _huyó_, delj_, bowe, _mṛṇā, 
   {{0x98a40241,0xe970071e,0x86040272,0x69d803ef}},	//   _либе, _يۇلد, حقيق_, cowe, 
   {{0x443c24b3,0x6b9424b4,0x9f580074,0x236424b5}},	//   gru_, _yozg, _pipì_, felj_, 
   {{0x236424b6,0x13680123,0x15c80095,0x00000000}},	//   gelj_, ушии_, _nṛṇā, --, 
   {{0x443c24b7,0x674400bd,0xf2880182,0x224400b0}},	//   aru_, ňují, рөлд_, gulk_, 
   {{0x6844001e,0x67ec001e,0x00000000,0x00000000}},	//   _ынӡа, rúje, --, --, 
   {{0x443c24b8,0x236401d1,0x9f940038,0xa48403a2}},	//   cru_, belj_, tæð_, _وجهن, 
   {{0x4fc424b9,0x69d824ba,0x23641cf2,0x63a024bb}},	//   ссма, zowe, celj_, ckln, 
   {{0x69d824bc,0x6b9424bd,0x823024be,0x00000000}},	//   yowe, _rozg, _فريا, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b940094,0x8c3402dc,0xa3dc006c,0x00000000}},	// [2030] _pozg, созӣ_, ढतच_, --, 
   {{0x69d824bf,0x6844010f,0x09b0072d,0x15c8004f}},	//   wowe, _የልማት, ूच्य, _gṛṇā, 
   {{0x69d824c0,0xdb0c0085,0x8af40387,0x2d580129}},	//   towe, _ombæ, _şəbn, _кинь_, 
   {{0x443c24c1,0x236424b5,0x00000000,0x00000000}},	//   yru_, zelj_, --, --, 
   {{0x69d824c2,0x6d5c227b,0x3c4424c3,0x684400c5}},	//   rowe, _ibsa, _нэрв, інка, 
   {{0x69d824c4,0xdb0c02e8,0x7a30001e,0x00000000}},	//   sowe, _ambæ, _ẽtee, --, 
   {{0x66c40551,0x80c00203,0x070400e2,0x443c24c5}},	//   цәаж, _लेने, ليږي_, wru_, 
   {{0x443c24c6,0xdd04004f,0x00000000,0x00000000}},	//   tru_, _āpīp, --, --, 
   {{0x236416e5,0x443c24c7,0x7eb000f2,0x00000000}},	//   telj_, uru_, _kópé, --, 
   {{0xdb0c0984,0xe3b824c8,0x651401ac,0x00000000}},	//   _embæ, рбо_, _ڀوائ, --, 
   {{0x6d5c1252,0xa18812d9,0x443c24c9,0x00000000}},	//   _obsa, абна_, sru_, --, 
   {{0x443c24ca,0x236424cb,0x224401c5,0xe7ec0098}},	//   pru_, selj_, rulk_, _चीता_, 
   {{0x236413bd,0x443c04db,0x00000000,0x00000000}},	//   pelj_, qru_, --, --, 
   {{0xdce403ef,0x25ac0237,0xdb1c0139,0x22440b76}},	//   _jaką, lhel_, lopö, pulk_, 
   {{0x9f500229,0x1d0824cc,0x1d9401d9,0x00000000}},	//   _buyò_, иеви_, ораё, --, 
   {{0x6d5c006f,0x9c2401cf,0x00000000,0x00000000}},	//   _cbsa, ждад, --, --, 
   {{0x6d5c02a6,0xa068138a,0x15c80095,0xdd941cd6}},	// [2040] _dbsa, _тапа_, _tṛṇā, баңы, 
   {{0x61e424cd,0x0fc00041,0x5f4413c5,0x6d5c02b0}},	//   llkl, _ойын, _بندل, _ebsa, 
   {{0x61e424ce,0x00000000,0x00000000,0x00000000}},	//   olkl, --, --, --, 
   {{0xc98024cf,0x248c018f,0x00000000,0x00000000}},	//   души, kxem_, --, --, 
   {{0x25ac24d0,0x00000000,0x00000000,0x00000000}},	//   dhel_, --, --, --, 
   {{0xc7a02112,0xfbc800dd,0x61e4002a,0x907800ca}},	//   мичк, _اڀري_, hlkl, יטני, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdeec01da,0x61e40056,0x00000000,0x00000000}},	//   _ጀግና_, jlkl, --, --, 
   {{0x938824d1,0x00000000,0x00000000,0x00000000}},	//   асна_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcb100240,0x25ac0083,0x27e80181,0x383c001d}},	//   ולת_, bhel_, ɓan_, _አልቀበ, 
   {{0x61e4036d,0x23a8001d,0xdec80020,0xdce40098}},	//   glkl, _ህገወጥ_, _በልካ_, _zaką, 
   {{0x25d804c3,0x3dc0038a,0xcf9800e1,0x2eb40095}},	//   _اهنگ_, diiw_, ајв_, ृप्त, 
   {{0x61e4018c,0x4ea424d2,0x2f8802de,0x00000000}},	//   alkl, орба, сәин_, --, 
   {{0x09b00252,0x6d5c0177,0x625c011a,0xd1380023}},	//   য়কতা, _pbsa, għoġ, _кхп_, 
   {{0x51840678,0x46380100,0x42340676,0x00000000}},	//   _фука, יעלע, _ונהל_, --, 
   {{0xdb240064,0xc19c0107,0x649c01c6,0x00000000}},	// [2050] _âpûp, _כשהי, rɨig, --, 
   {{0x09d0076f,0x25ac0d7f,0xdec802b4,0x0af001a7}},	//   तव्य, zhel_, _በልኩ_, дүгэ, 
   {{0xaf0002fa,0x37d00143,0x00000000,0x00000000}},	//   ্রহণ_, িতার, --, --, 
   {{0x6d5c0c2f,0x25ac0083,0x00000000,0x00000000}},	//   _ubsa, xhel_, --, --, 
   {{0x2d9824d3,0xdb1c24d4,0x248c03af,0x6d4c24d5}},	//   _iose_, kipè, xxem_, mgaa, 
   {{0x2d9824d6,0x7b6424d7,0x00000000,0x00000000}},	//   _hose_, _отсе, --, --, 
   {{0x25ac24d8,0x2d9824d9,0x7dfc0243,0x67ec0191}},	//   thel_, _kose_, _sōsi, gúja, 
   {{0x6d4c064b,0x2d9824da,0x2b4800c2,0x00000000}},	//   ngaa, _jose_, şică_, --, 
   {{0x2d9824db,0x7950049d,0xdb1c019f,0x6d4c24dc}},	//   _mose_, _شێوا, ropö, igaa, 
   {{0x2d9824dd,0x248c24de,0x6d4c000b,0x00000000}},	//   _lose_, rxem_, hgaa, --, 
   {{0x25ac08c2,0x6d4c000b,0xa068001e,0x00000000}},	//   phel_, kgaa, әага_, --, 
   {{0x6d4c24df,0x2d980bb8,0xa0681838,0xa3a80012}},	//   jgaa, _nose_, бама_, _گُتل_, 
   {{0x6d4c24e0,0x26100048,0x6568006f,0x307424e1}},	//   dgaa, _háo_, meeh, мурс, 
   {{0x2d980249,0xdb1c24e2,0x6d4c24e3,0x656824e4}},	//   _aose_, cipè, egaa, leeh, 
   {{0x2d9824e5,0x6d4c24e6,0x644824e7,0xdb1c0020}},	//   _bose_, fgaa, luei, sipë, 
   {{0x2d9824e8,0x6d4c24e9,0x9ea80409,0x2610000d}},	//   _cose_, ggaa, авҳа_, _máo_, 
   {{0xdb1c24ea,0x7a0c039c,0x1c4424eb,0x644824ec}},	// [2060] qipë, _iğti, янам, nuei, 
   {{0x6d4c24ed,0x9f5800d3,0x644801d6,0x00000000}},	//   agaa, _fipá_, iuei, --, 
   {{0xdcf824ee,0x2d9824ef,0x6448068c,0xdee424f0}},	//   _گردش_, _fose_, huei, _хони, 
   {{0x5f4424f1,0x2d9824f2,0x9b9424f3,0x644824f4}},	//   _بنگل, _gose_, _کلست, kuei, 
   {{0xa3bc0584,0x644824f5,0x656800af,0x48100049}},	//   ीचा_, juei, deeh, еміс, 
   {{0x261001c0,0x2d9804fe,0x64480340,0xdb1c24f6}},	//   _báo_, _zose_, duei, kipé, 
   {{0x2d9824f7,0x261001c0,0xd5b824f8,0x65680028}},	//   _yose_, _cáo_, йси_, feeh, 
   {{0xdedc0020,0x2d9824f9,0x2610000d,0x74140061}},	//   ዒልና_, _xose_, _dáo_, ووبا, 
   {{0x644824fa,0x27f0028d,0x00000000,0x00000000}},	//   guei, _šonų_, --, --, 
   {{0x93880329,0x7dfc0078,0xdee80b22,0x00000000}},	//   ссиа_, _včsy, ሙርን_, --, 
   {{0xf28c0043,0x6d4c24fb,0x6568042e,0x0ed824fc}},	//   criﬁ, ygaa, beeh, _मुंड, 
   {{0xfbc400ac,0x644824fd,0x31080128,0x705424fe}},	//   ্তিত, buei, өнүп_, ونجا, 
   {{0x644824ff,0x2d980d97,0xdb1c0139,0x6d4c2500}},	//   cuei, _rose_, onpä, vgaa, 
   {{0x225806f7,0x30e000cb,0xa91c01d1,0x6d4c0060}},	//   ńska_, _गुणः_, _anžl, wgaa, 
   {{0x6d4c2501,0xdb1c2502,0x64940126,0x2d9805a0}},	//   tgaa, cipé, _eżiġ, _pose_, 
   {{0x6d4c0132,0x2d9802bb,0x3d9400fb,0x00000000}},	//   ugaa, _qose_, ниср, --, 
   {{0x6d4c2503,0x2d980a84,0x6b7420f2,0x41742504}},	// [2070] rgaa, _vose_, млау, _سايس, 
   {{0x6d4c2505,0x2d982506,0x656808c2,0x9f5800d3}},	//   sgaa, _wose_, zeeh, _tipá_, 
   {{0x2d982507,0x6d4c2508,0x6448002a,0x00000000}},	//   _tose_, pgaa, zuei, --, 
   {{0xdb1c0274,0x2610001c,0x2d9800b0,0xd5a42509}},	//   enpä, _ráo_, _uose_, _شف_, 
   {{0x2610001c,0x656801ed,0x00000000,0x00000000}},	//   _sáo_, veeh, --, --, 
   {{0x66e4250a,0x6568007b,0x2610000d,0x00000000}},	//   мола, weeh, _páo_, --, 
   {{0x9ba0250b,0xe91801f5,0x7f3c00cf,0x00000000}},	//   _جەلى, _мові_, זעוו, --, 
   {{0x6448250c,0xe7ec00d1,0x2998001d,0xdb1c02eb}},	//   tuei, _चीरा_, ሊምፒክ_, anpä, 
   {{0x7a0c0031,0x656801d6,0xa3b8250d,0x00000000}},	//   _eştd, reeh, قادر_, --, 
   {{0xf770049d,0x65680239,0x26100014,0x6448250e}},	//   _مام_, seeh, _táo_, ruei, 
   {{0x64480cbf,0xe298250f,0x630401d9,0x00000000}},	//   suei, цан_, بودل, --, 
   {{0x644805e1,0x985c010f,0xdb1c2510,0xa97800cf}},	//   puei, _ሳይሆኑ_, ripé, קאָכ, 
   {{0x64482511,0x7a0c024f,0x2908038a,0x00000000}},	//   quei, _işte, ñaay_, --, 
   {{0x63040063,0x6ad800bd,0xa7fc01b8,0x00000000}},	//   _قوشل, _बु्र, _zsűr, --, 
   {{0x5de402b3,0xdb0c014a,0x00000000,0x00000000}},	//   джва, _embû, --, --, 
   {{0xdd902512,0x00000000,0x00000000,0x00000000}},	//   خور_, --, --, --, 
   {{0xdd942513,0xdb1c0139,0x00000000,0x00000000}},	// [2080] паңы, ynpä, --, --, 
   {{0x03c8000d,0x00000000,0x00000000,0x00000000}},	//   _điện, --, --, --, 
   {{0x1d082514,0x61f40c12,0x9a682515,0x7a0c00c2}},	//   _мени_, _khyl, تمال_, _oşte, 
   {{0xdca40063,0x5ca400fb,0x00000000,0x00000000}},	//   _жами, _жимб, --, --, 
   {{0x61f40086,0xf8a40182,0xda6400ea,0xd7f800b7}},	//   _mhyl, эгдү, _ښاري, оук_, 
   {{0x7a0c038e,0xdcfc028d,0xe6c80095,0x00000000}},	//   _aşte, _švėg, िपूज, --, 
   {{0x6b8002b2,0x00000000,0x00000000,0x00000000}},	//   _ólga, --, --, --, 
   {{0xdce4028d,0xf8b81cd6,0x00000000,0x00000000}},	//   _sakę, _нөл_, --, --, 
   {{0x4c980100,0x13682516,0x934400e2,0xdce4028d}},	//   ַשטע, ошни_, وخدم, _pakę, 
   {{0x88980107,0x69c00537,0x00000000,0x00000000}},	//   _ובמי, _ìler, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x61f42517,0xc690023c,0x46a0022e,0x393c0020}},	//   _chyl, _שאף_, _шахв, ረታዉያ, 
   {{0xe6ac0229,0x00000000,0x00000000,0x00000000}},	//   _ìbòò, --, --, --, 
   {{0xdb0c02ba,0xf778011a,0x00000000,0x00000000}},	//   _embú, _jaħ_, --, --, 
   {{0xa3bc002f,0x00000000,0x00000000,0x00000000}},	//   ीचर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3c580254,0x00000000,0x00000000,0x00000000}},	// [2090] митэ_, --, --, --, 
   {{0x21f0018b,0x21d41d29,0xac9402dc,0x61f40475}},	//   máha_, rāhe_, _ҷамш, _zhyl, 
   {{0xfd1000cd,0x21f00a03,0xa82401b8,0x60d4015e}},	//   اجہ_, láha_, ڑکان, _zxym, 
   {{0x69c8007c,0x9f580274,0x9c8007b5,0x02f800cf}},	//   _ĉees, _eipä_, ščad, קלאמ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xba280012,0x23b40223,0x21f00247,0x48f800bd}},	//   _ٲسِم_, _lùjù_, háha_, _ऋणको_, 
   {{0x393c02b4,0x21f0001e,0xe2980108,0x00000000}},	//   ረታውያ, káha_, җам_, --, 
   {{0x290c0074,0x61f40335,0xa7b8012b,0x00000000}},	//   _igea_, _rhyl, _елау_, --, 
   {{0xdb0c0064,0x61f4036b,0xa91c00b0,0xe2b40094}},	//   _albê, _shyl, _rožy, есмэ, 
   {{0x61f42518,0x7a0c0055,0x00000000,0x00000000}},	//   _phyl, _iştc, --, --, 
   {{0x68e80472,0x2258002f,0xa0682519,0xa91c0023}},	//   _kyed, ńsko_, пама_, _požy, 
   {{0x3208251a,0x6abc251b,0x00000000,0x00000000}},	//   _diay_, ्पुर, --, --, 
   {{0x65780341,0x61f4045f,0x245800f1,0xf390000d}},	//   _hawh, _whyl, mèm_, _hảnh_, 
   {{0x61f40c12,0x2458251c,0x65780341,0x68e80472}},	//   _thyl, lèm_, _kawh, _lyed, 
   {{0x32080014,0x290c251d,0x68e800f8,0x6578251e}},	//   _giay_, _ngea_, _oyed, _jawh, 
   {{0x657804c4,0x8c40251f,0x68e82520,0xf3900014}},	// [20a0] _mawh, лете, _nyed, _mảnh_, 
   {{0x6abc2521,0x32080693,0xf39001eb,0x3ba8001d}},	//   ्पूर, _ziay_, _lảnh_, ፋሪዎች_, 
   {{0x68e82522,0xf778011a,0x657802b0,0x66280151}},	//   _ayed, _raħ_, _oawh, łskʷ, 
   {{0x20102523,0x68e8007b,0x65780299,0x644400a2}},	//   _kuyi_, _byed, _nawh, _āhin, 
   {{0x2010028a,0xd7e402b3,0xdb1c2524,0x00000000}},	//   _juyi_, ніко, lipí, --, 
   {{0x7c242525,0x657800a2,0x2010028a,0x290c2526}},	//   mpir, _aawh, _muyi_, _egea_, 
   {{0x68e82527,0x7c242528,0xd0440271,0xd9440c6a}},	//   _eyed, lpir, _ɑmɑm, _певи, 
   {{0xf3900765,0x245800f1,0x00000000,0x00000000}},	//   _cảnh_, fèm_, --, --, 
   {{0x7c242529,0x2010193b,0x657801d6,0xdce40059}},	//   npir, _nuyi_, _dawh, _nokļ, 
   {{0x3208008f,0x21f003aa,0x7c24252a,0xd24400fc}},	//   _siay_, váha_, ipir, нэми, 
   {{0x65780337,0xdb0c252b,0x0bb40107,0x7c240475}},	//   _fawh, _albë, גלים_, hpir, 
   {{0x7c240ca1,0x2458052b,0x2010252c,0x68e802b0}},	//   kpir, bèm_, _buyi_, _yyed, 
   {{0x645808c2,0xe874010f,0x53a40023,0xca681af0}},	//   _gqwi, _በፍጹም_, _падб, бiлi, 
   {{0x7c2414ba,0x44f00023,0x32940075,0xaad800b6}},	//   dpir, _спіс, _للتأ, _बुझक, 
   {{0xfe7000cd,0x0ed8252d,0x7c240475,0xbed40edd}},	//   یدہ_, _मुखड, epir, горј, 
   {{0x201000c4,0x46c000a1,0x00000000,0x00000000}},	//   _fuyi_, _वइसह, --, --, 
   {{0x3cfc0584,0x7c241a96,0xa0200386,0x00000000}},	// [20b0] लेले_, gpir, _şöva, --, 
   {{0xa91c252e,0x21d40828,0x3b54038e,0x00000000}},	//   _inži, māha_, лкур, --, 
   {{0xc3300240,0xdb1c01fc,0xa9342212,0x245800f1}},	//   רוע_, cipí, вееш, zèm_, 
   {{0x2458029f,0x7c24018c,0xcd4802dc,0x68e802a0}},	//   yèm_, bpir, _эчод_, _pyed, 
   {{0x65780341,0xf390001c,0x7c8400df,0x3da40023}},	//   _rawh, _rảnh_, _йуре, _срэб, 
   {{0x18a0252f,0x65782530,0x98a02531,0xf390001c}},	//   рашм, _sawh, рише, _sảnh_, 
   {{0x290c0c2a,0x65780296,0xc6a400df,0xf1e021b9}},	//   _tgea_, _pawh, эрди, नवान, 
   {{0xd6cc03e0,0xdb0c2532,0x65780380,0xa5080254}},	//   تقى_, _albè, _qawh, мейа_, 
   {{0x68e82533,0x784405bc,0x7a0c13d8,0x6fe0006c}},	//   _uyed, _бэхж, _işta, पकां, 
   {{0x2010007b,0x24582534,0x21300055,0x00000000}},	//   _ruyi_, rèm_, _seyh_, --, 
   {{0x65780b60,0x20100ae3,0xdb1c0111,0xa91c01d1}},	//   _tawh, _suyi_, lipã, _anži, 
   {{0x201002b1,0x7c2402b1,0xa0a400c3,0x00000000}},	//   _puyi_, ypir, вамд, --, 
   {{0x201001a0,0xd0040254,0x7cf80223,0x20d42535}},	//   _quyi_, ӂере_, _múrí, тінс, 
   {{0x6448009c,0x201004ca,0xe8400020,0xdb0c0579}},	//   mrei, _vuyi_, _ኣይተቐ, _umbø, 
   {{0xd0042536,0xdee42537,0x64482538,0xe2980182}},	//   тере_, тови, lrei, _цай_, 
   {{0xd00c063a,0x7c242539,0x62800ac8,0x00000000}},	//   صلہ_, tpir, mvlo, --, 
   {{0xa3c40828,0x62800830,0x4d60023f,0xd5bc00a8}},	// [20c0] _एषा_, lvlo, јкув, _śāka_, 
   {{0x7c24253a,0x6448253b,0xd00c253c,0x442c0323}},	//   rpir, irei, _گلی_, _mwg_, 
   {{0x6448253d,0x442c008e,0x6280253e,0x8c400254}},	//   hrei, _lwg_, nvlo, леӂе, 
   {{0x6448253f,0xd00c2540,0xd9442541,0x18a41a67}},	//   krei, _دلی_, теди, каем, 
   {{0x442c01f3,0x487000e7,0x64481c38,0x985400bf}},	//   _nwg_, لدوس, jrei, ттеш, 
   {{0xda7008c9,0x62800726,0x00000000,0x00000000}},	//   _پُر_, kvlo, --, --, 
   {{0x442c2542,0x07a0030d,0x9974001e,0x4b780100}},	//   _awg_, рајн, _иуаш, _קאלו, 
   {{0x64482543,0x442c2544,0x21d400cb,0x29400480}},	//   frei, _bwg_, yāha_, _ﻛﻪﭖ_, 
   {{0x644809cd,0x442c01d5,0x97542545,0xdb0c2546}},	//   grei, _cwg_, _атељ, _albé, 
   {{0x442c01ea,0x75c800bd,0x38040123,0x00000000}},	//   _dwg_, tězs, _созҳ, --, 
   {{0x261001d1,0x442c1621,0x628003f4,0xcb340100}},	//   _cšod_, _ewg_, gvlo, כניק_, 
   {{0x64482547,0x442c0323,0x244800dd,0xd4e401d9}},	//   brei, _fwg_, _ڳجهي_, _июли, 
   {{0x64482548,0xc0580041,0x7d000a03,0x90280788}},	//   crei, кір_, _úmsh, ьцна_, 
   {{0xdce40386,0x628002bb,0x4fc400b8,0x00000000}},	//   _nokı, bvlo, тсма, --, 
   {{0x2fcc091d,0x2fd00770,0x442c01c6,0x43640294}},	//   đeg_, rnzg_, _zwg_, _рајн_, 
   {{0x442c042a,0x21d40296,0x00000000,0x00000000}},	//   _ywg_, pāha_, --, --, 
   {{0x6abc2549,0x03b4007e,0x656c0329,0x629400c0}},	// [20d0] ्प्र, ীকৰণ, _ñahe, äzov, 
   {{0x8aa4254a,0x60c00031,0xcf8800b7,0x00000000}},	//   кред, _ýoma, _цсид_, --, 
   {{0x65b40a1a,0x00000000,0x00000000,0x00000000}},	//   _háhe, --, --, --, 
   {{0x69340dd0,0x2f140012,0xe91801f5,0x6448254b}},	//   унду, _جِگر, ході_, yrei, 
   {{0x3944254c,0xdb1c021d,0x96640020,0x00000000}},	//   рніг, ynpø, _መርገጻ, --, 
   {{0x442c01ba,0xdb1c02ba,0xe7ec00b6,0x270c00aa}},	//   _rwg_, cipà, _चीखा_, िखेर_, 
   {{0x6448254d,0x442c0177,0x98e4002c,0x9a640012}},	//   wrei, _swg_, ксәһ, _مۅلل_, 
   {{0x442c01ba,0x649803a7,0x00000000,0x00000000}},	//   _pwg_, етор_, --, --, 
   {{0x240802dc,0x64480335,0xdce4006b,0x00000000}},	//   ннии_, urei, _yokı, --, 
   {{0x6448254e,0x6280254f,0xe3580123,0x375400cc}},	//   rrei, tvlo, хшиш_, _ەپەس, 
   {{0x64482550,0xe4e400df,0x62800151,0x36d40074}},	//   srei, _өсдү, uvlo, _кофр, 
   {{0x442c0179,0x62800e97,0xdb1c059e,0x60242551}},	//   _twg_, rvlo, zipà, лдма, 
   {{0x3fc817ab,0x62800952,0x442c0104,0x00000000}},	//   ندسی_, svlo, _uwg_, --, 
   {{0xdb0c00df,0x00000000,0x00000000,0x00000000}},	//   ýjün, --, --, --, 
   {{0x1ea809a9,0xb1a000ec,0x00000000,0x00000000}},	//   راسي_, сһөҙ, --, --, 
   {{0x25ac2552,0x65b402b2,0x00000000,0x00000000}},	//   nkel_, _fáhe, --, --, 
   {{0xed340afa,0x291c0083,0x00000000,0x00000000}},	// [20e0] рэсэ, dcwa_, --, --, 
   {{0x9f5c2553,0x61e42554,0x25ac00a1,0xdb1c03b2}},	//   ötä_, lokl, hkel_, fipá, 
   {{0x25ac2555,0x53340282,0xdb0c059e,0xdb1c034a}},	//   kkel_, רנען_, _imbü, ripà, 
   {{0x61e42556,0x9f5819ab,0x291c0123,0x2ca8018c}},	//   nokl, _ripù_, gcwa_, byad_, 
   {{0x17c82557,0xdce4006b,0xd7c40027,0x2d9400e5}},	//   нгди_, _tokı, лёко, _трэс, 
   {{0x61e42558,0x25ac2559,0x50d80100,0xc9500116}},	//   hokl, ekel_, עקסא, атәы, 
   {{0xa91c0106,0xabc401c4,0xdb1c00b8,0x61e4255a}},	//   _anžu, _тарҙ, cipá, kokl, 
   {{0xd498255b,0x25ac255c,0x61e4255d,0x5b240116}},	//   еро_, gkel_, jokl, _шьҭа, 
   {{0x56900256,0x61e40025,0x73d806b9,0x39440151}},	//   рақт, dokl, кдир_, _idms_, 
   {{0x25ac255e,0x95842074,0x948401c4,0x27e80151}},	//   akel_, _әлде, _ҡылд, îant_, 
   {{0xdb0c00c4,0xe5780086,0x00000000,0x00000000}},	//   _imbó, rlŷr_, --, --, 
   {{0x25ac255f,0x61e42560,0xd9f4025c,0x2ca82561}},	//   ckel_, gokl, ेषित_, yyad_, 
   {{0xc2e00063,0x73c42562,0xdb0c0496,0xf434150f}},	//   _қўши, _پيغم, _ambü, _телэ, 
   {{0x439000fc,0xaad4072d,0x00000000,0x00000000}},	//   _гашс, _दशलक, --, --, 
   {{0x2ca80086,0x61e42563,0xd244012b,0x00000000}},	//   wyad_, bokl, _сэли, --, 
   {{0x61e405d7,0xa2d000bd,0x00000000,0x00000000}},	//   cokl, डपर्, --, --, 
   {{0x644400a2,0x4c140324,0x00000000,0x00000000}},	// [20f0] _āhik, ابرس, --, --, 
   {{0x25ac01c6,0xdb1c23f1,0x00000000,0x00000000}},	//   zkel_, tipá, --, --, 
   {{0x2ca81ea5,0x25ac2564,0xfbd02565,0x3f840271}},	//   syad_, ykel_, ستك_, ɛmu_, 
   {{0xdb0c2566,0x6e240177,0x25ac0560,0x00000000}},	//   _ambó, _ithb, xkel_, --, 
   {{0xf7700046,0x7a0c02a0,0x00000000,0x00000000}},	//   ګان_, _eşto, --, --, 
   {{0x225806f7,0x61e4041c,0x39442567,0x248804c6}},	//   ński_, zokl, _edms_, _šamo_, 
   {{0x25ac0076,0x39440353,0x61e42568,0xa2840020}},	//   tkel_, _fdms_, yokl, ዝኾነን_, 
   {{0xa4442569,0xdb0c01d4,0x25ac256a,0x3cfc0030}},	//   анид, _embó, ukel_, लेके_, 
   {{0x25ac256b,0x61e4256c,0x00000000,0x00000000}},	//   rkel_, vokl, --, --, 
   {{0x3168256d,0x6e240c2f,0x626401f1,0x00000000}},	//   _abaz_, _othb, авоа, --, 
   {{0x22481166,0x2a60000d,0x00000000,0x00000000}},	//   ъпни_, nthb_, --, --, 
   {{0x316814c5,0x61e40023,0x56880100,0x00000000}},	//   _cbaz_, uokl, _שטײַ, --, 
   {{0x6e2403e0,0x80c000aa,0x00000000,0x00000000}},	//   _athb, _लेखे, --, --, 
   {{0x443c256e,0x21d40341,0x61e404ec,0xdfd0256f}},	//   msu_, pāho_, sokl, زيز_, 
   {{0xa91c1252,0xdc2c02a0,0x5f040668,0x00000000}},	//   _každ, _bığl, рзва, --, 
   {{0x443c0880,0x1d242570,0xa0a400b7,0x00000000}},	//   osu_, рмам, _ваид, --, 
   {{0x443c2571,0xa91c2572,0x6e2406e2,0xdca4118d}},	// [2100] nsu_, _mažd, _ethb, јази, 
   {{0x443c2573,0x2fcc000b,0x00000000,0x00000000}},	//   isu_, éegt_, --, --, 
   {{0xfe5802a5,0x5a940155,0x8f98067a,0x00000000}},	//   _حیزب_, шраф, _סיטי, --, 
   {{0x443c2574,0xeaf8006e,0xa91c01df,0xdb1c059c}},	//   ksu_, ھرەت_, _nažd, kipç, 
   {{0x443c2575,0x8d742576,0xac740020,0xa3e40192}},	//   jsu_, _ئاپا, ጠልጢሉ_, भका_, 
   {{0x443c01f6,0xdb0c01d4,0x6e2402b0,0xd0f800cf}},	//   dsu_, _hlbí, _ythb, כּור, 
   {{0x443c2577,0xa91c00e9,0xdec8001d,0x19940edd}},	//   esu_, _bažd, _በውኃ_, _кјар, 
   {{0x443c2578,0x98a42579,0x18a4257a,0x00000000}},	//   fsu_, _кибе, _кабм, --, 
   {{0x23a800c4,0x79800b66,0xb0c4002f,0xa91c257b}},	//   _lúju_, _iamw, _लेंग, _dažd, 
   {{0x7980257c,0xa3c40828,0x93a4257d,0xb8640122}},	//   _hamw, _एषः_, ршид, _ناڕو, 
   {{0x443c257e,0x75ec0186,0xe6840116,0x67ec01b8}},	//   asu_, wûzu, _гәык_, gúju, 
   {{0x443c257f,0x7980011a,0xdb1c2580,0xa4f00087}},	//   bsu_, _jamw, lipä, _çişü_, 
   {{0x79802581,0x84600348,0x8d742582,0x656c001e}},	//   _mamw, _дъще, یارا, _ñaha, 
   {{0x7980054f,0xdb1c2583,0xd1000a7b,0xdb0c02b2}},	//   _lamw, nipä, रेषण_, _albí, 
   {{0xc3f80240,0x76a80130,0xf23801d9,0x00000000}},	//   _שלוש, bɛye, _ёпиш_, --, 
   {{0xa91c2400,0x79802584,0xdb1c2585,0xd0182586}},	//   _kaže, _namw, hipä, _ифо_, 
   {{0xdb1c2587,0x4b240075,0x00000000,0x00000000}},	// [2110] kipä, لعاف, --, --, 
   {{0xa91c02b3,0x80c003e4,0x7f9403d6,0xdb0c01b8}},	//   _maže, _लेटे, _даьх, _elbí, 
   {{0x79802588,0xa91c2200,0xdb0c00b7,0xdb1c1513}},	//   _bamw, _laže, _albâ, dipä, 
   {{0x798003c7,0xd24400e7,0xfe702589,0x2bb80388}},	//   _camw, _ۉن_, _کدی_, _इतवा, 
   {{0x79800336,0x19c00087,0x49b801d9,0x6d5c0379}},	//   _damw, чәрг, _یارد_, _icsa, 
   {{0x7980007f,0xdb1c00b6,0xd2440ce5,0x7c3401c7}},	//   _eamw, gipä, _ىن_, _ферх, 
   {{0x79800086,0xba740075,0xe6880128,0x00000000}},	//   _famw, _وافت, انبى_, --, 
   {{0x7980258a,0x00000000,0x00000000,0x00000000}},	//   _gamw, --, --, --, 
   {{0x69c8258b,0xdb1c00af,0x00000000,0x00000000}},	//   _imee, bipä, --, --, 
   {{0x443c258c,0x79800196,0xa0a4002c,0x63940673}},	//   rsu_, _zamw, ҡанд, сшиф, 
   {{0x443c258d,0x7980258e,0xf770258f,0xa2e42590}},	//   ssu_, _yamw, _زال_, сонд, 
   {{0x443c2591,0xf6502592,0xe8e4011a,0x00000000}},	//   psu_, _آئل_, _སྙོག, --, 
   {{0x69c82593,0x644400a2,0xa91c0ddc,0x23a800e3}},	//   _mmee, _āhiw, _gaže, _bújt_, 
   {{0x6d5c2594,0x84c00087,0x00000000,0x00000000}},	//   _acsa, _гәүд, --, --, 
   {{0xa91c1108,0x65b40212,0x69c82595,0x5dd800fc}},	//   _zaže, _záha, _omee, гфар_, 
   {{0x3d282596,0xe3f803a2,0x91e01166,0x46dc0030}},	//   شتری_, _جوڙڻ_, _ноще, _पुछह, 
   {{0x79802597,0x3ba40123,0x23a800e3,0x00000000}},	// [2120] _ramw, олаҳ, _fújt_, --, 
   {{0x69c82598,0xe8e4043b,0x6ee001e5,0x225803ef}},	//   _amee, _སྙེག, _ịbel, ńsku_, 
   {{0x3cfc0cd6,0x79802599,0x2bb8259a,0x9f0400e2}},	//   लेजे_, _pamw, _इतरा, _دودو, 
   {{0x7980259b,0xdec800ff,0xbd8801ac,0x00000000}},	//   _qamw, _በልና_, _ڍنڍن_, --, 
   {{0x79801c60,0x515800ca,0xdb1c11d1,0xbf80004f}},	//   _vamw, רכנו, tipä, _śoṇa_, 
   {{0x7980259c,0xd498259d,0x69c8259e,0xa91c01d5}},	//   _wamw, ғри_, _emee, _raže, 
   {{0xa91c259f,0x798025a0,0x7bdc0140,0x65b40a24}},	//   _dažb, _tamw, _ijru, _sáha, 
   {{0xa91c02b3,0xdb1c25a1,0x69c8000b,0x65b4014e}},	//   _paže, sipä, _gmee, _páha, 
   {{0xf8b025a2,0xd7f00075,0x73c400ec,0xdb1c150d}},	//   _تکا_, _فكر_, жәйе, pipä, 
   {{0xd37825a3,0xa91c0b34,0x65b40113,0x00000000}},	//   учи_, _važe, _váha, --, 
   {{0xc7b00107,0x70d0161f,0x58d400ec,0x050c004f}},	//   _צבע_, सप्ल, _тоҡт, _śītī_, 
   {{0xa91c0192,0xc2b4021d,0x23a800f2,0x00000000}},	//   _taže, слює_, _sújt_, --, 
   {{0xd4f425a4,0x00000000,0x00000000,0x00000000}},	//   _اثاث, --, --, --, 
   {{0x823025a5,0x00000000,0x00000000,0x00000000}},	//   _کروا, --, --, --, 
   {{0x09cc02fa,0x00000000,0x00000000,0x00000000}},	//   িকতা, --, --, --, 
   {{0x7bdc25a6,0x46380100,0x00000000,0x00000000}},	//   _ajru, טעלע, --, --, 
   {{0xdb0c00cc,0x9f5801f1,0x69c8006f,0xeb3825a7}},	// [2130] _albà, _cipó_, _rmee, изаш_, 
   {{0x69c825a8,0x7afc00fb,0x00000000,0x00000000}},	//   _smee, _bzrt, --, --, 
   {{0xa91c00ef,0x954003b4,0x00000000,0x00000000}},	//   _ražb, _əşrə, --, --, 
   {{0xe8e40126,0x6d5c02b0,0x00000000,0x00000000}},	//   _སྙུག, _ucsa, --, --, 
   {{0xbd940041,0xe738182a,0xa91c012c,0xc8640091}},	//   _эқтө, аел_, _pažb, стеи, 
   {{0x8d740121,0x00000000,0x00000000,0x00000000}},	//   _ئاھا, --, --, --, 
   {{0x56900931,0x660425a9,0x36940049,0x00000000}},	//   дајт, опка, зшыс, --, 
   {{0x69c825aa,0x38600097,0x00000000,0x00000000}},	//   _umee, àirc_, --, --, 
   {{0x3e700064,0xe3b825ab,0x69d8041c,0x3914241d}},	//   _kötö_, иби_, mnwe, _хмур, 
   {{0x1cb00126,0x26000029,0x87d425ac,0x00000000}},	//   ྐྱི_, kóog_, _اغرا, --, 
   {{0x6b8002b2,0x00000000,0x00000000,0x00000000}},	//   _ólgu, --, --, --, 
   {{0x69d825ad,0x33b000c3,0x65b401d4,0x208801d9}},	//   nnwe, _ۋەير, _záhn, айми_, 
   {{0x09a40cd6,0x64a425ae,0xdbc400b6,0x7a300078}},	//   _खवैय, _фала, mööb, _kòtò, 
   {{0x440425af,0x232825b0,0x69d80104,0x656825b1}},	//   _учеб, _токи_, hnwe, lfeh, 
   {{0xdd9025b2,0x51f40191,0x00000000,0x00000000}},	//   ووس_, _ڈسٹر, --, --, 
   {{0x656825b3,0x69d8084f,0xdddc00b0,0x7a4001b8}},	//   nfeh, jnwe, _ispū, _látá, 
   {{0xfaf811b0,0x9f5800d3,0xdbc805bc,0xfb1801b8}},	// [2140] _šī_, _dipò_, агад_, مراں_, 
   {{0x7a0c0c60,0x69d825b4,0xe81c0774,0xdb0c01db}},	//   _işti, enwe, _पढ़ा_, _albá, 
   {{0x65b4215e,0x9f580223,0x9f0425b5,0x6568002a}},	//   _náho, _fipò_, _گوگو, kfeh, 
   {{0x69d80083,0x65b40192,0x00000000,0x00000000}},	//   gnwe, _sáhn, --, --, 
   {{0x7a400223,0x00000000,0x00000000,0x00000000}},	//   _bátá, --, --, --, 
   {{0x69d803f4,0x65b401d4,0x9f580078,0x47300b0f}},	//   anwe, _báho, _zipò_, ورىز, 
   {{0xd5b825b6,0x6568036d,0xdb0c06b4,0x00000000}},	//   иси_, ffeh, _ambö, --, 
   {{0x7a0c00c2,0x2da4001d,0x00000000,0x00000000}},	//   _oşti, _ወገኖቼ_, --, --, 
   {{0x65b40192,0xdb1c00d3,0x00000000,0x00000000}},	//   _táhn, dipú, --, --, 
   {{0xe8e40002,0x3e7c01c6,0xccf000ca,0x65b400f2}},	//   _སྙིག, _oŭt_, וכח_, _fáho, 
   {{0x741425b7,0x4bf8007c,0xf28801a7,0x65680104}},	//   _کوتا, שליס, сөлд_, bfeh, 
   {{0xd46825b8,0x76580186,0x65b401d5,0xd1381f0f}},	//   _виде_, muvy, _jáhl, шхо_, 
   {{0x3e7c01c6,0x65b425b9,0xd24c03b5,0x9f4c0212}},	//   _aŭt_, _záho, رۆک_, šným_, 
   {{0xb4c81f7d,0x9f58029f,0xa91c02b3,0x00000000}},	//   ोपी_, _sipò_, _maža, --, 
   {{0x0ef002fa,0xa91c00e9,0xbe8825ba,0x69d80335}},	//   ছেনঃ_, _laža, осте_, ynwe, 
   {{0x65b402d6,0xf8bc0095,0x22a402dc,0x225002cc}},	//   _náhl, ्छाय, _хушҳ, ázke_, 
   {{0xa91c25bb,0x70240126,0xec1400ea,0xfc640074}},	// [2150] _naža, _འཕྲུ_, سواد, дъхн, 
   {{0x76580bf8,0xfc300272,0x68300229,0x7e7c0086}},	//   kuvy, ضحك_, _lódò, bwrp, 
   {{0x7a40045d,0x21d4004d,0x41c40012,0x37d00143}},	//   _rátá, wāhi_, _رٲیِ, াকার, 
   {{0x1cb0043b,0x3eac03c8,0xa91c25bc,0x69d80080}},	//   ྐྱང_, ädte_, _baža, unwe, 
   {{0x69d825bd,0x7a400537,0xe7280182,0x65b401d5}},	//   rnwe, _pátá, болд_, _sáho, 
   {{0xa91c1426,0x005800ca,0x65b400e3,0x00000000}},	//   _daža, קשות_, _páho, --, 
   {{0xc97425be,0x6568002a,0xa93400fb,0x00000000}},	//   _وارث, tfeh, _невш, --, 
   {{0x317806f7,0x65b402ec,0x65680369,0x795800b2}},	//   jesz_, _váho, ufeh, _миср_, 
   {{0x31780191,0x65140191,0x656825bf,0x7e7c0151}},	//   desz_, _ہوائ, rfeh, zwrp, 
   {{0x656825c0,0x765800b0,0x65b40c8b,0xe50c00b6}},	//   sfeh, buvy, _záhl, ाइबि_, 
   {{0x65680602,0x45a0006e,0xdb0c0085,0x651425c1}},	//   pfeh, _يەتك, _elbæ, _فوائ, 
   {{0x2168221e,0x00000000,0x00000000,0x00000000}},	//   щими_, --, --, --, 
   {{0xdb040638,0xe35400df,0x00000000,0x00000000}},	//   _ämög, _етйэ, --, --, 
   {{0x660825c2,0x21f00113,0x00000000,0x00000000}},	//   lmek, váhu_, --, --, 
   {{0x020400f8,0x7a0c012b,0x137800e2,0x823000d5}},	//   _оҷон, _iştv, _دجنګ_, _کرڈا, 
   {{0x9c2425c3,0x317806f7,0x660825c4,0xd24c0272}},	//   здад, cesz_, nmek, _إني_, 
   {{0x66080046,0x00000000,0x00000000,0x00000000}},	// [2160] imek, --, --, --, 
   {{0xa91c25c5,0x660825c6,0x65b401d5,0x765825c7}},	//   _raža, hmek, _sáhl, yuvy, 
   {{0x660825c8,0xa91c0473,0x200825c9,0x00000000}},	//   kmek, _saža, mmbi_, --, 
   {{0x9f480212,0xa91c0007,0xceb00107,0x00000000}},	//   dobé_, _paža, _ניר_, --, 
   {{0xdb0c0186,0x660800b6,0x44f80593,0x5cf40094}},	//   _ambô, dmek, _n̪_, _хяну, 
   {{0xa91c091d,0x66080046,0x6c3001b5,0x21d40299}},	//   _važa, emek, _شہما, māhu_, 
   {{0x5ac4043b,0x2008074e,0xdce400e5,0x65b40192}},	//   _གཟིམ, imbi_, _pakė, _táhl, 
   {{0x44f80593,0x4540020d,0x765825ca,0x00000000}},	//   _b̪_, ىنىق, ruvy, --, 
   {{0xa91c091d,0x317801b8,0xb4c80095,0x629406e9}},	//   _kažn, vesz_, ोपे_, åzon, 
   {{0x44f80593,0x12e4024b,0x88b800ca,0x19dc01d2}},	//   _d̪_, зімг, _הזמי, _ﺃﻓﻀﻠ, 
   {{0x3dc008c2,0x317801b8,0x00000000,0x00000000}},	//   khiw_, tesz_, --, --, 
   {{0xa91c12dc,0x21d40299,0x2bb80095,0x00000000}},	//   _lažn, kāhu_, _इत्थ, --, 
   {{0x260802a4,0xf0e81812,0x826001d9,0x73c401d2}},	//   ागरी_, زىسى_, وهین, _және, 
   {{0x03a025cb,0x753803ef,0x00000000,0x00000000}},	//   _пичо, ńczą, --, --, 
   {{0x438025cc,0x2fd001d1,0x7ee425cd,0x00000000}},	//   _سليق, rizg_, ецте, --, 
   {{0x70580121,0xe81c0030,0x51841310,0x00000000}},	//   _даир_, _पढला_, _хука, --, 
   {{0xa91c0007,0x62840038,0x6c1425ce,0x3d38009e}},	// [2170] _bažn, _áhor, ддаф, яптэ_, 
   {{0xf6b808be,0x660825cf,0x2fd0018f,0x65b400f2}},	//   ྐྱོང, zmek, qizg_, _ráhm, 
   {{0xa91c0822,0xfe2425d0,0x3860077d,0xdb1400a8}},	//   _dažn, _пьян, àirn_, _įcãk, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x81b0028a,0x2d9825d1,0x76480222,0x6608059c}},	//   _jiɓa, _inse_, _avdy, vmek, 
   {{0xdc54049d,0xa6940931,0x2d8825d2,0x00000000}},	//   _کرێک, дриј, ldae_, --, 
   {{0x660825d3,0x80d40ff0,0xe6280046,0xe5a400c3}},	//   tmek, _সৰঞ্, زګان_, дийи, 
   {{0x2d8825d4,0x9f4825d5,0x7648006f,0x44f80593}},	//   ndae_, robé_, _dvdy, _p̪_, 
   {{0x660825d6,0x2d8801b4,0x77900061,0x00000000}},	//   rmek, idae_, _ڕیوا, --, 
   {{0xe79425d7,0xd764006e,0x660825d8,0xe3b00272}},	//   _تارک, _يەنى_, smek, ئرة_, 
   {{0x2d9825d9,0x2d8803f4,0xd7e8020d,0xf65025da}},	//   _onse_, kdae_, _بولۇ_, _مئن_, 
   {{0xa91c25db,0x44f80593,0xdb1c0475,0x00000000}},	//   _mažo, _t̪_, thpë, --, 
   {{0xa91c0c0a,0x2d8805ab,0x10a025dc,0x00000000}},	//   _lažo, ddae_, виян, --, 
   {{0x2d9825dd,0xf4c401ec,0x2d8825de,0x3fcc02fa}},	//   _anse_, şýän_, edae_, লক্ষ, 
   {{0x248c25df,0xa91c01f8,0x3dc00990,0xdb1c0020}},	//   lvem_, _ražn, thiw_, shpë, 
   {{0x217407ce,0x5bb409cf,0x21d400a2,0x70500122}},	//   _цукр, ःस्व, tāhu_, خۆیا, 
   {{0xa91c16c6,0xa3b025e0,0x8c400111,0x5ba80deb}},	// [2180] _pažn, _टका_, кете, окам_, 
   {{0x2d9825e1,0x2d88034c,0x00000000,0x00000000}},	//   _ense_, adae_, --, --, 
   {{0xa91c0b53,0xdce400a2,0x248c00af,0x4f9800ca}},	//   _važn, _kakī, hvem_, _וביצ, 
   {{0xa91c25e2,0xdcf400f1,0x248c05eb,0x00000000}},	//   _dažo, leyč, kvem_, --, 
   {{0x6c740332,0xa91c014d,0x00000000,0x00000000}},	//   _пурх, _tažn, --, --, 
   {{0x8c400931,0xa91c02db,0x60c000fc,0x00000000}},	//   _јере, _fažo, _ýomu, --, 
   {{0x7c24004e,0x00000000,0x00000000,0x00000000}},	//   lqir, --, --, --, 
   {{0x77b40340,0x1ddc25e3,0xc720002c,0x3c2400d5}},	//   _màxi, नचित, ндәй, _köv_, 
   {{0x7c2425e4,0x18680c8e,0xe8500122,0x3c2400f2}},	//   nqir, _фази_, _مۆند, _jöv_, 
   {{0x926825e5,0xf8b00a1d,0x81b001e7,0xa91c0c0a}},	//   орма_, _لکڻ_, _riɓa, _lažl, 
   {{0xc7d402c3,0x7c2425e6,0x3c2425e7,0x2d8825e8}},	//   _קובי_, hqir, _löv_, ydae_, 
   {{0x225002f6,0x82301cb9,0x626419be,0xcb100107}},	//   ázka_, کریا, راپق, כלת_, 
   {{0x3c2402df,0x225825e9,0x46100324,0x00000000}},	//   _növ_, ąska_, _شوهر, --, 
   {{0x1cb00d7f,0x00000000,0x00000000,0x00000000}},	//   ྐྱབ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa91c11b0,0x00000000,0x00000000,0x00000000}},	//   _ražo, --, --, --, 
   {{0x7c24009d,0x2d8825ea,0x4cdc0143,0x00000000}},	// [2190] gqir, rdae_, _মরহু, --, 
   {{0x2d880520,0x09d400b3,0x3c2425e7,0xa91c25eb}},	//   sdae_, ढच्य, _döv_, _pažo, 
   {{0x160c25ec,0x248c00aa,0xbf14004b,0xe9b400b8}},	//   ागार_, zvem_, _لوٝب, нбжь, 
   {{0x7c2401a0,0x2d9825ed,0xac181774,0x00000000}},	//   bqir, _unse_, _ному_, --, 
   {{0x67d40b1e,0x766800ea,0x00000000,0x00000000}},	//   ноду, ېیمې_, --, --, 
   {{0xa91c00ef,0x00000000,0x00000000,0x00000000}},	//   _zažl, --, --, --, 
   {{0x26d80130,0x65b406b4,0x00000000,0x00000000}},	//   _ɛsow_, _háhi, --, --, 
   {{0xff180107,0x65b403aa,0xa91c015b,0xdcf40078}},	//   וקות_, _káhi, _kažm, zeyč, 
   {{0xb8f40143,0x248c0078,0xf8f400e5,0xe85400e3}},	//   _সু_, uvem_, _аптэ, _سناد, 
   {{0xf77025ee,0x248c25ef,0xa91c0023,0x24880151}},	//   _نام_, rvem_, _mažm, _šams_, 
   {{0x659400f8,0x7a0c0387,0x8588044a,0x00000000}},	//   _пажу, _iştr, _мёда_, --, 
   {{0x363425f0,0x56b4007c,0x21a402dc,0x7c2413e6}},	//   _شرمس, _אפען_, химм, yqir, 
   {{0x60b401d9,0x65b402b2,0x4f480020,0x00000000}},	//   رمسئ, _náhi, _ንምዝር, --, 
   {{0x644825f1,0x7c2401a0,0x3c2401c5,0xa2e425f2}},	//   msei, vqir, _röv_, _полд, 
   {{0x644825f3,0xa91c091d,0x442c25f4,0x00000000}},	//   lsei, _pažl, _htg_, --, 
   {{0x644825f5,0x00000000,0x00000000,0x00000000}},	//   osei, --, --, --, 
   {{0x644825f6,0x442c01e7,0x9f4800bf,0xdcf400f1}},	// [21a0] nsei, _jtg_, lobí_, peyč, 
   {{0x644825f7,0x7c2425f8,0xdca40123,0x00000000}},	//   isei, rqir, _ҷами, --, 
   {{0x64480337,0x9d4425f9,0xe7f425fa,0x9f4801d4}},	//   hsei, _пенд, ेतना_, nobí_, 
   {{0xdca425fb,0x2018004d,0x394003e0,0x442c0c2a}},	//   _зами, _hipi_, úis_, _otg_, 
   {{0x201811f4,0x7c24012a,0x64480085,0x00000000}},	//   _kipi_, qqir, jsei, --, 
   {{0x644825f7,0xc7a01b62,0x07a025fc,0xd1c40020}},	//   dsei, личк, лачн, _ጽዑቕ_, 
   {{0x64480cbf,0x201825fd,0xa91c0070,0x00000000}},	//   esei, _mipi_, _zažm, --, 
   {{0x9f4802f6,0x442c11ae,0xa91c14ba,0x644825fe}},	//   dobí_, _btg_, _lažj, fsei, 
   {{0x644825ff,0x48e02600,0x00000000,0x00000000}},	//   gsei, _ботв, --, --, 
   {{0x20182601,0x61f401ec,0x442c0308,0xd24c0012}},	//   _nipi_, _akyl, _dtg_, مۆت_, 
   {{0x96942602,0x442c0496,0xdb0c0038,0xa2802603}},	//   _яраш, _etg_, _albú, لیوو, 
   {{0x64482604,0x442c2605,0x26881443,0x324401c4}},	//   bsei, _ftg_, _زخمي_, неүг, 
   {{0x442c2606,0x20181607,0xc5ec03d9,0x00000000}},	//   _gtg_, _bipi_, _آن_, --, 
   {{0x61f402b0,0xbfa815d1,0x7dc401a0,0xdb1c00af}},	//   _ekyl, нтсе_, қёсд, gipü, 
   {{0x20180762,0xdb1c2607,0xdb0c2608,0xca4c01d2}},	//   _dipi_, hipó, _elbú, _ﺍﻋﺎ_, 
   {{0x65b40247,0x2018015b,0x13a400d5,0x00000000}},	//   _páhi, _eipi_, _آچکی_, --, 
   {{0x3208043e,0xa2980b22,0xfc302609,0x6ad8260a}},	// [21b0] _ihay_, _ፈተናን_, محل_, भप्र, 
   {{0x20181737,0x32080636,0x00000000,0x00000000}},	//   _gipi_, _hhay_, --, --, 
   {{0x3208001c,0x64480361,0x00000000,0x00000000}},	//   _khay_, zsei, --, --, 
   {{0xdb0c0064,0x2018260b,0x3208034a,0x7a542418}},	//   _kobê, _zipi_, _jhay_, اضلا, 
   {{0x201802ba,0x50b01a4b,0xd84000b0,0xec140075}},	//   _yipi_, ुनिष, _nyčė_, _لوحد, 
   {{0xa91c02b3,0x66180105,0x644800b6,0x201802ba}},	//   _kažk, _siwk, vsei, _xipi_, 
   {{0x320806e2,0x66180098,0x00000000,0x00000000}},	//   _ohay_, _piwk, --, --, 
   {{0x6448260c,0xe5780155,0xc984002c,0x3208260d}},	//   tsei, фзи_, _яуги, _nhay_, 
   {{0xa814260e,0x6448017a,0xd5ac1049,0xe3b00075}},	//   _адаш, usei, تفي_, لرد_, 
   {{0x3208260f,0x68e80c2f,0x442c0496,0x00000000}},	//   _ahay_, _ixed, _vtg_, --, 
   {{0x64482610,0xa2e42611,0x3208025e,0x20182612}},	//   ssei, тонд, _bhay_, _ripi_, 
   {{0x32082613,0x20182614,0x442c2615,0x68180078}},	//   _chay_, _sipi_, _ttg_, _kňdo, 
   {{0x442c2616,0x9f480214,0x638401ec,0x64480361}},	//   _utg_, sobí_, _агла, qsei, 
   {{0x3208147c,0xb370001d,0xdee42617,0x00000000}},	//   _ehay_, ባቢውን_, воги, --, 
   {{0x20182618,0x8fa02619,0xdb1c013c,0xe8e401ac}},	//   _vipi_, шаре, ripü, _ڇڻ_, 
   {{0x32080380,0x20180444,0xa91c00d4,0xe8e400dd}},	//   _ghay_, _wipi_, _dažk, _هڻ_, 
   {{0x2018261a,0xa3d40227,0x79580223,0x00000000}},	// [21c0] _tipi_, _सगा_, _lúwà, --, 
   {{0x2018261b,0xa2c41671,0xf38c00cf,0x200c00d3}},	//   _uipi_, ानप्, ּראָ, _òfi_, 
   {{0xcf54033c,0x0f5400b9,0x68e806e2,0x320802b0}},	//   _בבית_, _ביים_, _axed, _yhay_, 
   {{0x3eb800a0,0x29d403aa,0xdb1c00ef,0xe9c4001e}},	//   myrt_, sťan_, tipó, лахҿ, 
   {{0x89340049,0x61e4030f,0x00000000,0x00000000}},	//   тпіс_, _íhlu, --, --, 
   {{0xc7900200,0x3eb80616,0xdb1c0247,0x8cc803bf}},	//   لشىب, oyrt_, ripó, _सेटो, 
   {{0x68e8261c,0x9a14001e,0xcb64261d,0x00000000}},	//   _exed, _афаш, _шаре_, --, 
   {{0xa2c4261e,0xceb00107,0xd5b0006c,0xa91c01d5}},	//   ानन्, שיה_, _जवळज, _nažh, 
   {{0x3944261f,0x7afc2620,0x3eb80207,0x335400cc}},	//   _iems_, _hyrt, hyrt_, гүлө_, 
   {{0x7afc061e,0x39440d6b,0x8d800090,0x32082621}},	//   _kyrt, _hems_, ርበታል_, _shay_, 
   {{0x32082622,0x59b42331,0xd394002c,0x0bb40107}},	//   _phay_, _अकार, еҙҙә_, דלים_, 
   {{0x39440fd8,0x3eb806e9,0x30342623,0xf5e801ac}},	//   _jems_, dyrt_, лемё, _ڪڙڪي_, 
   {{0x62840064,0x3eb8006f,0x00000000,0x00000000}},	//   _âhon, eyrt_, --, --, 
   {{0xd1600329,0x40342624,0x39442470,0x00000000}},	//   ынҭқ, рерс, _lems_, --, 
   {{0x32082625,0x39442626,0xdb0c02b4,0xe888010f}},	//   _thay_, _oems_, _dobë, _በውስጡ_, 
   {{0x32081ddc,0x39442627,0x00000000,0x00000000}},	//   _uhay_, _nems_, --, --, 
   {{0x7afc01f1,0x3eb80cfa,0xfd880300,0x6b740a6d}},	// [21d0] _ayrt, ayrt_, ъёри_, ллау, 
   {{0x7afc2628,0x3eb80331,0xa91c00c0,0xed50013f}},	//   _byrt, byrt_, _tažk, جھھ_, 
   {{0x65b403aa,0x7afc0086,0x6d7c0020,0x00000000}},	//   _záhu, _cyrt, _ብጎይታ_, --, 
   {{0xa91c2629,0x7afc262a,0xe9440eb9,0xf7700012}},	//   _kaži, _dyrt, ارای, ۪ان_, 
   {{0x3da40822,0x9f4807d4,0x88c41088,0xf77003a2}},	//   _трэб, lobá_, ختال, ڪان_, 
   {{0xa91c02b3,0x7afc262b,0x66e4262c,0xdb1c00f1}},	//   _maži, _fyrt, лола, sipò, 
   {{0xf770262d,0x3944262e,0xa91c1882,0x9ba00bf3}},	//   تان_, _fems_, _laži, _دەلى, 
   {{0x3944262f,0x6e242630,0x75d80116,0x00000000}},	//   _gems_, _muhb, кьыс_, --, 
   {{0x7afc0422,0x69d82631,0x00000000,0x00000000}},	//   _zyrt, miwe, --, --, 
   {{0x69d82632,0x13e4039c,0xa91c2633,0xa0a4022e}},	//   liwe, лмый_, _naži, ҳамд, 
   {{0x21682634,0xdb0c2635,0x61442636,0x39440083}},	//   нини_, _cobè, лена, _yems_, 
   {{0x69d82637,0xdb0c052b,0x9f480113,0x525400b8}},	//   niwe, _dobè, dobá_, ыхьӡ, 
   {{0xa91c03aa,0xd24c2638,0x59b400b6,0x00000000}},	//   _baži, ينی_, _अकसर, --, 
   {{0x3eb82639,0x38600097,0x05740122,0xd8d800ca}},	//   tyrt_, àiri_, _ساڵد, תקשר, 
   {{0x69d8263a,0xd36c166c,0xe298263b,0x2eb41198}},	//   kiwe, _رهي_, _чай_, астс, 
   {{0x3f8c03aa,0x69d803a2,0x6e24263c,0xdee4263d}},	//   ždu_, jiwe, _duhb, воҳи, 
   {{0x7afc263e,0x3944263f,0x69d82640,0xd00c2641}},	// [21e0] _syrt, _rems_, diwe, زلہ_, 
   {{0x39442642,0x0b402643,0x7afc061e,0x9b442644}},	//   _sems_, йнун, _pyrt, اناو, 
   {{0xdb0c02c6,0x6e240008,0xad2401b8,0x26c801c6}},	//   _kobé, _guhb, ارہو, ŝaoj_, 
   {{0xa91c2645,0x69d82646,0x5cf40007,0x7afc0475}},	//   _zaži, giwe, _бягу, _vyrt, 
   {{0xd7f82647,0x4870144e,0x394401c5,0xa8440122}},	//   нук_, مدوس, _vems_, لکلۆ, 
   {{0x69d803f4,0x7afc0034,0x26000029,0x6e3400d3}},	//   aiwe, _tyrt, sóol_, _ègbè, 
   {{0xf1c00214,0x69d82648,0x39440496,0xdce42649}},	//   ášky_, biwe, _tems_, _inkı, 
   {{0x69d8264a,0xd1f4010f,0xdb0c0039,0x4e34007c}},	//   ciwe, _ለፊት_, _nobé, אָזן_, 
   {{0x41a8004b,0xa2d8264b,0x13681166,0x73c401c4}},	//   गानस, _फेब्, ншни_, ҫәһе, 
   {{0xb27403d6,0xc7a0001e,0x07a0264c,0x260402ba}},	//   алош, _лиук, _лаун, лчөг, 
   {{0xdb0c02c6,0xa91c264d,0x63b401b8,0x00000000}},	//   _bobé, _raži, özna, --, 
   {{0x506405bc,0xf4840063,0xa91c163e,0x0ecc00a1}},	//   лтга, _ناتی, _saži, _हेगड, 
   {{0xa91c02b3,0x6e2404e7,0xdb0c000b,0x50640007}},	//   _paži, _suhb, _dobé, ытна, 
   {{0x69d8264e,0x9f4801f1,0x4fc4264f,0x00000000}},	//   ziwe, tobá_, усма, --, 
   {{0xa91c2650,0x69d82651,0x8a940200,0x1d3000d3}},	//   _važi, yiwe, _ءﻭﻧﺪ, _ọjọm, 
   {{0x69d80da6,0xdb0c2652,0xd1b80340,0x9f4800b7}},	//   xiwe, _gobé, _ساعا_, robá_, 
   {{0x69d82653,0x41c42654,0xca4c01d2,0x00000000}},	// [21f0] viwe, _دقيق, _ﺍﻋﺘ_, --, 
   {{0x0ae82655,0x69d80454,0x6e24012b,0x4ae80027}},	//   ىراي_, wiwe, _tuhb, ньем_, 
   {{0x69d80da6,0xd1cc0020,0x786400c3,0x00000000}},	//   tiwe, _ባሮት_, ەدىك, --, 
   {{0x893403e0,0xa91c00e5,0xa2c40095,0x00000000}},	//   اعضا, _mažv, ानत्, --, 
   {{0x69d80bb1,0x9ce80012,0xfc780020,0x00000000}},	//   riwe, _لوَے_, _ኣጋጢሙ_, --, 
   {{0xd2442656,0x69d82657,0x65b405a4,0x26001420}},	//   _ون_, siwe, _náhr, róom_, 
   {{0x69d82658,0x2ca8028b,0x00000000,0x00000000}},	//   piwe, lxad_, --, --, 
   {{0x69d80046,0x60c00560,0x7de0012c,0x64982659}},	//   qiwe, _żomm, _tísň, втор_, 
   {{0xdb0c012b,0x00000000,0x00000000,0x00000000}},	//   _robé, --, --, --, 
   {{0xe2981ec1,0x6720091d,0x96900012,0xb6c400ec}},	//   вао_, _uglj, _ڈیٖش, рсәй, 
   {{0xd5ac1743,0xdb0c265a,0x21a400b8,0x00000000}},	//   سفی_, _pobé, аинм, --, 
   {{0xd1d000ff,0xa91c00e0,0x00000000,0x00000000}},	//   _ከፊቱ_, _dažv, --, --, 
   {{0x81b00181,0x645c265b,0xa0740049,0x00000000}},	//   _jiɓi, ásid, шынш, --, 
   {{0xdb1c019f,0x25ac00b6,0xfd640182,0x26000029}},	//   mipö, ljel_, өнгү, kóok_, 
   {{0xdb1c0027,0x00000000,0x00000000,0x00000000}},	//   lipö, --, --, --, 
   {{0x65b40c75,0x25ac265c,0x91e022a0,0x00000000}},	//   _záhr, njel_, _моще, --, 
   {{0x5b340aab,0xa91c01df,0x65b401d4,0x25ac0207}},	// [2200] لعار, _kažu, _yáhr, ijel_, 
   {{0xed580155,0xdb0c0513,0xde2801a0,0x00000000}},	//   коӣ_, _dobî, _ижод_, --, 
   {{0xa91c265d,0x25ac16bb,0xa3cc0cd4,0x61e401c6}},	//   _mažu, kjel_, _रतन_, onkl, 
   {{0x25ac265e,0xdb1c0638,0x13cc0143,0x61e4265f}},	//   jjel_, kipö, িচয়, nnkl, 
   {{0x25ac2660,0xfcc401c4,0x57a4044a,0x61e42661}},	//   djel_, _уҙам, ишка, inkl, 
   {{0x8c402662,0xda6417ae,0xa91c2663,0x61e4002a}},	//   _фере, _پاسي, _nažu, hnkl, 
   {{0x9f581402,0x4b782664,0xabc400ec,0x27e8059b}},	//   _akpë_, _שאלו, _уарҙ, éana_, 
   {{0xd4982665,0xf1c00019,0x25ac0020,0x61e401ed}},	//   вро_, _উদ্ভ, gjel_, jnkl, 
   {{0x81b0028a,0x56900200,0xa91c00e9,0xdb1c00af}},	//   _giɓi, сақт, _sažv, gipö, 
   {{0xd1f40422,0xa91c0023,0x00000000,0x00000000}},	//   ለዎት_, _pažv, --, --, 
   {{0x25ac01c3,0x91a00b1c,0xa91c2666,0xf1942667}},	//   bjel_, गालै, _dažu, бинь, 
   {{0x05b00075,0xdb0c0335,0x61e42668,0x6aa006b4}},	//   _وملح, _lobï, gnkl, _álfe, 
   {{0xdb0c0397,0x00000000,0x00000000,0x00000000}},	//   _albü, --, --, --, 
   {{0xd1cc001d,0xdb1c00af,0x00000000,0x00000000}},	//   _ባዮች_, lipõ, --, --, 
   {{0xc32c071e,0x82f401a0,0x00000000,0x00000000}},	//   _تەپ_, _پروز_, --, --, 
   {{0x82302669,0xa91c1909,0x3da4266a,0xdb1c013c}},	//   _بروا, _zažu, оруб, nipõ, 
   {{0xe238001d,0x925401d2,0x00000000,0x00000000}},	// [2210] _የተሳና, _сақт_, --, --, 
   {{0x2ca801b5,0x6fb400d5,0x00000000,0x00000000}},	//   rxad_, _چمکا, --, --, 
   {{0x6e94045d,0x00000000,0x00000000,0x00000000}},	//   _الجا, --, --, --, 
   {{0xdb0c0247,0xba08138a,0xf9d40b1e,0x00000000}},	//   _albó, ахче_, оцію, --, 
   {{0x225803ef,0xdb1c013c,0x00000000,0x00000000}},	//   ąski_, dipõ, --, --, 
   {{0x29000828,0xdb1c019f,0x681800f1,0x9f4802ba}},	//   āha_, vipö, _kňdi, llbò_, 
   {{0x89a40012,0xa91c00ce,0xa68401d9,0x499000d5}},	//   _پھاہ_, _ražu, ёлид, _ویئر, 
   {{0x3940266b,0xa2c40828,0x6b84266c,0xdb0c00d3}},	//   ðist_, ानस्, lehg, _mobì, 
   {{0x38600011,0x26c00c75,0x25ac165b,0xdb0c0229}},	//   àirt_, šho_, rjel_, _lobì, 
   {{0x25ac03f4,0x645c02ba,0xdb1c0027,0x00000000}},	//   sjel_, àsiq, ripö, --, 
   {{0xf770266d,0x57f80100,0xdb1c00af,0x46680139}},	//   _تاق_, _עלעו, bipõ, _шрам_, 
   {{0xe29801c4,0x00000000,0x00000000,0x00000000}},	//   _ҡал_, --, --, --, 
   {{0x61e4266e,0x6568002a,0x00000000,0x00000000}},	//   rnkl, mgeh, --, --, 
   {{0x6568266f,0xa0a400b8,0x00000000,0x00000000}},	//   lgeh, _ҳаид, --, --, 
   {{0xfe7800e7,0x00000000,0x00000000,0x00000000}},	//   шүн_, --, --, --, 
   {{0xdb100670,0xa0a4001e,0x1d240294,0x00000000}},	//   _égér, _гаид, смам, --, 
   {{0xdc282670,0x68180031,0x4e24024b,0x65680104}},	// [2220] اسره_, _eňdi, _қоян_, igeh, 
   {{0x3dc00209,0x656813ac,0x6b842671,0x21f00113}},	//   skiw_, hgeh, gehg, váhy_, 
   {{0xdb0c01e8,0x65680031,0x00000000,0x00000000}},	//   _albò, kgeh, --, --, 
   {{0x27e80272,0x6568084f,0x2ee4000f,0x47302672}},	//   éann_, jgeh, úlfe_, ۋرىز, 
   {{0x6b840636,0x65681490,0xa2d82673,0x8d7400cc}},	//   behg, dgeh, _फेस्, _ااپا, 
   {{0x18a4024b,0x65682254,0x00000000,0x00000000}},	//   _қазм, egeh, --, --, 
   {{0x65682674,0x8f980107,0x2a342675,0x47c800e2}},	//   fgeh, טיסי, _мэтр, دانۍ_, 
   {{0x65682676,0x7434038e,0x75d42677,0x741401ac}},	//   ggeh, ониф, تيبا, ڊوبا, 
   {{0xdb0c01f1,0x932404e7,0xdddc015b,0xb79400dd}},	//   _mobí, یرگن, _appū, _وائڙ, 
   {{0x32540f0e,0x73d80362,0xa91c00b0,0xdb1c00af}},	//   овор, рдор_, _važt, sipõ, 
   {{0xc3180664,0x785401b8,0x6568002a,0x4b780a0b}},	//   _দ্বি_, _ایڈز_, bgeh, נאטו, 
   {{0x645c2678,0x490c00bd,0x00000000,0x00000000}},	//   ásic, तेको_, --, --, 
   {{0x1bf8025c,0xc05801d2,0x00000000,0x00000000}},	//   ्ताल_, йір_, --, --, 
   {{0x74142679,0xb33c011a,0xa2d80c5f,0xa2c403ec}},	//   _بوتا, gjħt, _फेव्, ानश्, 
   {{0xdb0c267a,0xada401c4,0xab880012,0x437400cf}},	//   _lobâ, ҙаҡл, یٖرن_, _לײגן_, 
   {{0xc0cc001d,0xa2c40095,0x00000000,0x00000000}},	//   ጠርም_, ानर्, --, --, 
   {{0xebd8267b,0xdb0c2095,0xe2a402e8,0x00000000}},	// [2230] адаш_, _dobí, óðve_, --, 
   {{0x8aa400fc,0xdb0c0223,0x00000000,0x00000000}},	//   йред, _tobì, --, --, 
   {{0xa91c01d1,0xc3300107,0xcb080094,0x65680cd5}},	//   _nažr, פוף_, ухад_, ygeh, 
   {{0xdb0c267c,0x6b840104,0xed5012e6,0x00000000}},	//   _gobí, sehg, _زھر_, --, 
   {{0x27e8267d,0xbd8801b5,0x2f1401b5,0x00000000}},	//   éano_, _انُن_, _دِگر, --, 
   {{0xdb0c0254,0x265801f1,0x00000000,0x00000000}},	//   _dobâ, ариќ_, --, --, 
   {{0x6568267e,0x3ffc007c,0x38600177,0x00000000}},	//   tgeh, אפגע, àirr_, --, 
   {{0xe458267f,0xa91c00d4,0x00000000,0x00000000}},	//   ажи_, _dažr, --, --, 
   {{0x77a80012,0x69c82680,0xe744002c,0x00000000}},	//   _گُلِ_, _ilee, _һүҙе_, --, 
   {{0x65682681,0x3860119c,0x00000000,0x00000000}},	//   sgeh, áire_, --, --, 
   {{0xf7702682,0x69c82683,0x65682684,0x00000000}},	//   _سال_, _klee, pgeh, --, 
   {{0x21682685,0x38600070,0x6e2801c6,0x00000000}},	//   шими_, šire_, ĉebl, --, 
   {{0xdb0c2686,0x69c80331,0xa91c01d1,0x2c0800cb}},	//   _robí, _mlee, _zažr, वतां_, 
   {{0xd9b40872,0x69c8018c,0xdb0c01d5,0x00000000}},	//   _अक्ट, _llee, _sobí, --, 
   {{0x69c82687,0xdb0c0192,0x5dd8041c,0x9e6400ea}},	//   _olee, _pobí, афар_, غاسن, 
   {{0x22500214,0xe1f0031b,0xdb0c01f1,0x1c440023}},	//   ázku_, _تست_, _lobã, жнам, 
   {{0x1b480155,0xdb0c0034,0x22580098,0xdc682688}},	// [2240] изаи_, _vobí, ąsku_, разд_, 
   {{0x69c82689,0x00000000,0x00000000,0x00000000}},	//   _alee, --, --, --, 
   {{0x8eb00eeb,0xdb0c000f,0x69c8268a,0x192c0020}},	//   _ہمیش, _tobí, _blee, _ብሓልዮ, 
   {{0x69c819b3,0xdca4268b,0x5ca40366,0xdc6802ba}},	//   _clee, _дами, _димб, _камд_, 
   {{0x69c808be,0x9f4800c0,0x718c00cf,0x00000000}},	//   _dlee, dobú_, טװאַ, --, 
   {{0x69c8268c,0x290c0047,0x3a3805e1,0x5fcc00b3}},	//   _elee, _dzea_, _ttrp_, होचल, 
   {{0xeb9000b9,0x69c80bb8,0x7bdc02a0,0xa2d8268d}},	//   _אָן_, _flee, _imru, _फेल्, 
   {{0x69c8268e,0x6aa00038,0xd7a801ac,0x00000000}},	//   _glee, _álfa, _ھٿان_, --, 
   {{0x3a240083,0x73d80816,0x46e40087,0x6b98059b}},	//   _iimp_, йдир_, йдән_, _éagó, 
   {{0x3a24268f,0x69c80151,0x249c0323,0x00000000}},	//   _himp_, _zlee, _drwm_, --, 
   {{0x69c806ea,0xc7b00107,0x3a24013c,0x15b000c3}},	//   _ylee, _קבע_, _kimp_, _يەتس, 
   {{0x453000cc,0xc2b4021d,0x00000000,0x00000000}},	//   _قىمر, іляє_, --, --, 
   {{0xc95010bc,0x3a2404ac,0x249c0086,0xf43400fc}},	//   ומר_, _mimp_, _grwm_, _эелэ, 
   {{0x3a240bc1,0xcf2403e0,0x28bc0a34,0x2cac0126}},	//   _limp_, ترحي, ्नति, _ħed_, 
   {{0xcdd82690,0xebb800cb,0x92f00094,0x601002b2}},	//   ања_, nuḥ_, _цүнх, dæmd, 
   {{0x7bdc2691,0x86580100,0x00000000,0x00000000}},	//   _amru, ידלי, --, --, 
   {{0x32180264,0x69c8075d,0xebb800cb,0xfc302692}},	// [2250] mmsy_, _rlee, huḥ_, نحل_, 
   {{0x95280002,0x290c0552,0x69c82693,0x4ea400b7}},	//   _ཤུའི_, _rzea_, _slee, _дрма, 
   {{0x69c82694,0x8ae410aa,0xaa9403e0,0x6dc00128}},	//   _plee, ціал, ثلاث, _كۅسۅ, 
   {{0x3a242695,0xebb800cb,0x7bdc2696,0x00000000}},	//   _cimp_, duḥ_, _emru, --, 
   {{0x69c82697,0xe7382698,0x3a2408be,0x2d88034c}},	//   _vlee, бел_, _dimp_, meae_, 
   {{0x2d8802bf,0x00000000,0x00000000,0x00000000}},	//   leae_, --, --, --, 
   {{0x3a240207,0x69c808be,0x00000000,0x00000000}},	//   _fimp_, _tlee, --, --, 
   {{0x2d882699,0xd90c00cd,0x69c8269a,0x290c0182}},	//   neae_, ئیے_, _ulee, _tzea_, 
   {{0x47880bbf,0x6b940152,0x4428000d,0x00000000}},	//   _всем_, _kazg, êc_, --, 
   {{0x6b94269b,0x00000000,0x00000000,0x00000000}},	//   _jazg, --, --, --, 
   {{0x6b94269c,0x9f4c00aa,0xe1f8269d,0x3a240151}},	//   _mazg, áním_, йго_, _yimp_, 
   {{0x6b94163f,0x249c0323,0x92601812,0x00000000}},	//   _lazg, _trwm_, رگىم, --, 
   {{0x64a4269e,0x9f4c00bd,0x2bc0006c,0x00000000}},	//   _хала, šním_, _एवढा, --, 
   {{0xdd901466,0x443c269f,0x00000000,0x00000000}},	//   کور_, mpu_, --, --, 
   {{0x443c26a0,0x60100084,0x998400ef,0x248c000b}},	//   lpu_, væmd, bloň_, lwem_, 
   {{0x443c00b0,0x00000000,0x00000000,0x00000000}},	//   opu_, --, --, --, 
   {{0x6b940008,0x443c07eb,0x3a2402e3,0x48d80098}},	// [2260] _bazg, npu_, _rimp_, _खेलो_, 
   {{0x3a2426a1,0x443c26a2,0x7b84006e,0x58840551}},	//   _simp_, ipu_, بارە, ҧыла, 
   {{0x443c07eb,0xdb0c00ef,0x2d880034,0x8c4000fc}},	//   hpu_, _bobá, beae_, _җесе, 
   {{0x443c01d7,0x248c01d7,0xdb2401a0,0x00000000}},	//   kpu_, kwem_, زوچی, --, 
   {{0x443c090c,0x3a240145,0xdce40237,0x97a0006b}},	//   jpu_, _vimp_, _bakĥ, нһаҗ, 
   {{0x3f9826a3,0xebb80828,0x3a24036d,0x6b9426a4}},	//   ndru_, tuḥ_, _wimp_, _gazg, 
   {{0x3a240241,0x2bc00698,0x443c00b0,0x41cc072d}},	//   _timp_, _शकता, epu_, ासास, 
   {{0xebb800cb,0xdb0c01ca,0x98680386,0x00000000}},	//   ruḥ_, _gobá, _göğe_, --, 
   {{0x6b94039c,0x798006e2,0x443c26a5,0x00000000}},	//   _yazg, _ibmw, gpu_, --, 
   {{0x63ac01e7,0xdb0c03aa,0x88380107,0xaf700020}},	//   _ɗang, _zobá, _לתמו, ብታትና_, 
   {{0x443c26a6,0x41a8072d,0x42700182,0x00000000}},	//   apu_, गांस, нгэс, --, 
   {{0x3f9800d4,0x443c0156,0x00000000,0x00000000}},	//   edru_, bpu_, --, --, 
   {{0x53a426a7,0x85980107,0x25640012,0x79800379}},	//   _надб, _לשאו, _زانُ, _mbmw, 
   {{0x798002b0,0x823002cb,0x00000000,0x00000000}},	//   _lbmw, بریا, --, --, 
   {{0x6b9416e5,0x263400a2,0x2d88034c,0x00000000}},	//   _razg, _kāoa_, teae_, --, 
   {{0x3f9819ab,0x2600038a,0x6b94012b,0x92f00513}},	//   adru_, lóor_, _sazg, ăşăm, 
   {{0x2d881658,0x26340299,0x6b940222,0x953c010f}},	// [2270] reae_, _māoa_, _pazg, _በኢንተ, 
   {{0xbca40272,0x2d88034c,0xdb0c02cc,0x26000029}},	//   عملي, seae_, _sobá, nóor_, 
   {{0xa3cc0774,0x6b9426a8,0x2d880034,0x00000000}},	//   रसत_, _vazg, peae_, --, 
   {{0x443c0156,0x3eac26a9,0x6b94012b,0x00000000}},	//   ypu_, ådte_, _wazg, --, 
   {{0xa91c00ef,0x6d5c0379,0x6b9407b5,0xe7281ff1}},	//   _obže, _idsa, _tazg, оолд_, 
   {{0x443c090c,0xa90803a2,0x98a026aa,0x798002b0}},	//   vpu_, ٽيڪل_, тише, _ebmw, 
   {{0xc6a407f9,0x248c08da,0xdb0c01ca,0x443c26ab}},	//   ярди, wwem_, _tobá, wpu_, 
   {{0x248c03ef,0x38600070,0x798006e2,0x443c090c}},	//   twem_, šira_, _gbmw, tpu_, 
   {{0x6adc26ac,0x443c26ad,0x6f0800aa,0xdce801d3}},	//   _मधुर, upu_, řech, _ānīt, 
   {{0x443c26ae,0x00000000,0x00000000,0x00000000}},	//   rpu_, --, --, --, 
   {{0x443c090c,0xa18826af,0x6d5c26b0,0x248c0618}},	//   spu_, обна_, _odsa, swem_, 
   {{0x443c26b1,0x6d5c036d,0x6b2c011a,0x6514051a}},	//   ppu_, _ndsa, _ཧུའོ_, _قوائ, 
   {{0xc4f80e39,0x660826b2,0x26000d8c,0x443c090c}},	//   _اعضا_, mlek, bóor_, qpu_, 
   {{0x6d5c26b3,0x9ea826b4,0x442c0034,0xa2e400cc}},	//   _adsa, овга_, _iug_, _оолд, 
   {{0x442c26b5,0x442409e8,0xd00426b6,0x3f9826b7}},	//   _hug_, _iin_, фере_, rdru_, 
   {{0x442426b8,0x6608039c,0x2d94006b,0x3f980513}},	//   _hin_, nlek, нрус, sdru_, 
   {{0x442c26b9,0x9c2426ba,0x660826bb,0x442426bc}},	// [2280] _jug_, ддад, ilek, _kin_, 
   {{0x442426bd,0x6d5c26be,0x442c26bf,0x5f4400e2}},	//   _jin_, _edsa, _mug_, _تندل, 
   {{0x442c26c0,0x6eb40a63,0x660826c1,0x0e60006b}},	//   _lug_, _उपयु, klek, _икэн, 
   {{0x442426c2,0x442c0254,0xd94400fc,0x58840007}},	//   _lin_, _oug_, феди, дыка, 
   {{0x442c042a,0x660826c3,0x442426c4,0xa3cc23df}},	//   _nug_, dlek, _oin_, रसा_, 
   {{0x442426c5,0x6ee401a0,0x6eb40813,0xc7a012d9}},	//   _nin_, _آسیل, _उपमु, кичк, 
   {{0x34b80b37,0x442c05cb,0x26340296,0x07a00931}},	//   ेन्द, _aug_, _pāoa_, тајн, 
   {{0x442426c6,0x660826c7,0x629c05e1,0x442c26c8}},	//   _ain_, glek, āsol, _bug_, 
   {{0x442426c9,0x442c26ca,0xa30001c8,0x89a401a0}},	//   _bin_, _cug_, ңүче, _ўкув_, 
   {{0x660826cb,0x2e4400f1,0x442426cc,0x442c027e}},	//   alek, _jèfò_, _cin_, _dug_, 
   {{0x442426cd,0x442c077d,0x44f00063,0xa2c403eb}},	//   _din_, _eug_, فسیز, ानग्, 
   {{0x442426ce,0x442c26cf,0x54c400b7,0x00000000}},	//   _ein_, _fug_, _обеб, --, 
   {{0xf0e800c3,0x00000000,0x00000000,0x00000000}},	//   سىسى_, --, --, --, 
   {{0x442426d0,0xdb0c0638,0x2ee4000f,0x78a40027}},	//   _gin_, _kobä, úlfo_, äivy, 
   {{0x442c26d1,0x765800b0,0x00000000,0x00000000}},	//   _zug_, nsvy, --, --, 
   {{0x442426d2,0x442c042a,0x7fb80152,0x60d800cf}},	//   _zin_, _yug_, _aşqı, ŝtma, 
   {{0x442426d3,0x4218059b,0x00000000,0x00000000}},	// [2290] _yin_, _تزوج_, --, --, 
   {{0x442426d4,0x660826d5,0xa9c000e7,0x09c40095}},	//   _xin_, zlek, گۅرۉ, लस्य, 
   {{0xdb0c01ab,0x00000000,0x00000000,0x00000000}},	//   _nobä, --, --, --, 
   {{0x6d5c0184,0x28bc03ef,0xa9c000e7,0x66080479}},	//   _udsa, ्नलि, دۅرۉ, xlek, 
   {{0xdd38033c,0x52c826d6,0x66080da7,0xe73826d7}},	//   _מערכ, ानुस, vlek, пел_, 
   {{0xe73826d8,0x2d9826d9,0xa69426da,0xe61004c3}},	//   чек_, _hase_, ериј, گشت_, 
   {{0x442426db,0x2d9826dc,0x442c26dd,0x660826de}},	//   _rin_, _kase_, _sug_, tlek, 
   {{0x442426df,0xdb0c09d7,0x9f480113,0xe61026e0}},	//   _sin_, _dobä, dobý_, دشت_, 
   {{0x660826e1,0x74f805bc,0x442c1bef,0x998800bd}},	//   rlek, дээс_, _qug_, _zubů_, 
   {{0xe3b00699,0xe8bc03c3,0x442426e2,0x66082649}},	//   ارة_, ्नीच, _qin_, slek, 
   {{0x442426e3,0x660826e4,0x2d9826e5,0xdb0c0087}},	//   _vin_, plek, _oase_, _gobä, 
   {{0x442c26e6,0x442426e7,0x2b500151,0x601006b4}},	//   _tug_, _win_, _lezc_, dæma, 
   {{0x442426e8,0x307426e9,0x00000000,0x00000000}},	//   _tin_, курс, --, --, 
   {{0x25bc26ea,0x442426eb,0x2d980331,0x356800ec}},	//   _howl_, _uin_, _aase_, _ерән_, 
   {{0x2d9826ec,0x00000000,0x00000000,0x00000000}},	//   _base_, --, --, --, 
   {{0x2d9826ed,0x25bc006f,0xa3cc26ee,0x2174012b}},	//   _case_, _jowl_, रसव_, _чукр, 
   {{0x2d9826ef,0x00000000,0x00000000,0x00000000}},	// [22a0] _dase_, --, --, --, 
   {{0x61e426f0,0x2d980dc9,0x5c840020,0xbe84012b}},	//   likl, _ease_, _ነካይዶ_, _иңгл, 
   {{0xdee400f8,0x60c426f1,0x5eb80143,0x00000000}},	//   _чони, lykm, _উইকে, --, 
   {{0x2d9826f2,0x61e426f3,0x523800cf,0x00000000}},	//   _gase_, nikl, לײענ, --, 
   {{0x79a4002c,0x68180078,0x6d4000c2,0xe9700134}},	//   ерҙе, _pňdp, _şlag, شۇلد, 
   {{0x2d9826f4,0x61e426f5,0x38600091,0xa3e0025c}},	//   _zase_, hikl, širo_, नोम_, 
   {{0x7e7c01c4,0x2d9826f6,0x61e426f7,0x25bc0d08}},	//   ntrp, _yase_, kikl, _bowl_, 
   {{0xceb0033c,0x25bc1c2f,0xdb0c019f,0x61e40ac0}},	//   ריה_, _cowl_, _vobä, jikl, 
   {{0x61e40be2,0x986826f8,0x53e426f9,0x47c800e2}},	//   dikl, _хизб_, ецна, _ډالۍ_, 
   {{0xf8b000dd,0x60c40031,0xb5d801d2,0x638000b8}},	//   _مکڻ_, dykm, _ﺀﺑﯩﺰ, ҳҳәа, 
   {{0x25bc26fa,0x6b8001c8,0x61e426fb,0xaa2801b5}},	//   _fowl_, _ölge, fikl, _رسہٕ_, 
   {{0x25bc0002,0xa2c00d56,0x60100038,0x61e400e5}},	//   _gowl_, рәшк, væma, gikl, 
   {{0x403426fc,0x00000000,0x00000000,0x00000000}},	//   леяс, --, --, --, 
   {{0x2d9826fd,0x439026fe,0xb4cc0cd4,0xd25800b7}},	//   _sase_, _башс, रनी_, _еци_, 
   {{0x2d9826ff,0x25bc11ae,0xef1000e7,0xbe88038e}},	//   _pase_, _yowl_, рүнө, нсте_, 
   {{0x2d980382,0xed5001ac,0x3d940123,0x00000000}},	//   _qase_, گھھ_, лиср, --, 
   {{0x6b7401c8,0xa91c1ef3,0x8240010f,0x0320006b}},	// [22b0] клау, _obža, _የተሳሳ, _идән, 
   {{0x2d982700,0xa2c4006c,0x6aa002b2,0x00000000}},	//   _wase_, ानच्, _álfk, --, 
   {{0x2d982701,0xbf140587,0xdeb001d2,0x00000000}},	//   _tase_, _бүрә, _кұры, --, 
   {{0x2d980034,0x00000000,0x00000000,0x00000000}},	//   _uase_, --, --, --, 
   {{0xcf242702,0x25bc2703,0xdb0c0085,0xa30c03ea}},	//   _ترکي, _rowl_, _robå, _हर्ज_, 
   {{0x61e42704,0x25bc11ae,0x00000000,0x00000000}},	//   zikl, _sowl_, --, --, 
   {{0x98f40476,0x9ba0006e,0x79a42705,0x60c42706}},	//   ىغۇچ, _خەلى, _өрте, zykm, 
   {{0x25bc0080,0x361800e5,0x00000000,0x00000000}},	//   _qowl_, нцыю_, --, --, 
   {{0x61e42707,0x00000000,0x00000000,0x00000000}},	//   vikl, --, --, --, 
   {{0xf7702708,0x13e40087,0x00000000,0x00000000}},	//   _هام_, кмый_, --, --, 
   {{0x21682709,0xc6481845,0x25bc0cfa,0x614400f5}},	//   мини_, _رجال_, _towl_, кена, 
   {{0x60c400df,0xd3e401d9,0x8c140143,0x00000000}},	//   tykm, _یقنی, ়দিন_, --, 
   {{0x16080098,0x00000000,0x00000000,0x00000000}},	//   _हीटर_, --, --, --, 
   {{0x5040150f,0x60c4270a,0xe5a400fb,0x00000000}},	//   рерб, rykm, _пиçи, --, 
   {{0xe3b001fa,0x52b00075,0x61e4270b,0xf644070b}},	//   _مرګ_, _نموذ, pikl, _ыхăн, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e7c18f1,0x00000000,0x00000000,0x00000000}},	// [22c0] strp, --, --, --, 
   {{0x9f480504,0x2018270c,0x00000000,0x00000000}},	//   robó_, _تتبع_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2b4c01c3,0x1868270d,0xa3cc00a1,0x00000000}},	//   _đece_, дади_, रसँ_, --, 
   {{0xd7f8270e,0x0c98001d,0xda6401ac,0x28100108}},	//   мук_, _ቅርሶች_, _ڄاري, ڭۈلس, 
   {{0xda64270f,0xbdc801b8,0x00000000,0x00000000}},	//   _لاري, _آدھے_, --, --, 
   {{0x81d80252,0xa91c0007,0x00000000,0x00000000}},	//   _াদন_, _mažy, --, --, 
   {{0xd8742710,0x310400cb,0xa91c0023,0x00000000}},	//   _لائب, रथमः_, _lažy, --, 
   {{0xb4cc2711,0x52c82712,0xed880020,0xa3cc052c}},	//   रने_, ान्स, _ምጽባይ_, रसं_, 
   {{0x27e80045,0x0e7402b4,0x674400bd,0x47d001ac}},	//   éant_, _ይግብኦ_, čují, _پيمر, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x550401d9,0x00000000,0x00000000,0x00000000}},	//   _ичла, --, --, --, 
   {{0x63c404d9,0x50640074,0x00000000,0x00000000}},	//   ýunç, ътна, --, --, 
   {{0x5eb80664,0xa3e02713,0xcf40095e,0xa3cc0095}},	//   _উইজে, नोद_, شىرۋ, रसः_, 
   {{0x3d3801e5,0xa91c0023,0x2ef40106,0x00000000}},	//   _ọwa_, _dažy, узвр, --, 
   {{0x61f40475,0x7e440123,0x00000000,0x00000000}},	//   _gjyl, рхре, --, --, 
   {{0x32082714,0xa9a42715,0x00000000,0x00000000}},	// [22d0] _ikay_, ғилд, --, --, 
   {{0xc8b0066c,0x0a6802ba,0x00000000,0x00000000}},	//   یلاک, дрди_, --, --, 
   {{0x32080d2e,0xdb0c01d4,0x61f40031,0x00000000}},	//   _kkay_, _zobú, _yjyl, --, 
   {{0x700001e5,0x684c0020,0x00000000,0x00000000}},	//   _ịcho, _ዝተረድ, --, --, 
   {{0x3208000b,0xa8840411,0x3d94012b,0x00000000}},	//   _mkay_, التى, _тияр, --, 
   {{0xaa5c15d6,0x00000000,0x00000000,0x00000000}},	//   _негi, --, --, --, 
   {{0xf3f801b9,0x06e02716,0x32082717,0x00000000}},	//   ঁতাৰ_, _केशव_, _okay_, --, 
   {{0x320800ba,0x28140122,0x00000000,0x00000000}},	//   _nkay_, _ڵواس, --, --, 
   {{0x27e82718,0xe3b0110b,0xe35401a7,0x00000000}},	//   éans_, مرد_, лтнэ, --, 
   {{0x32082719,0x36880b74,0xdb0c0306,0x00000000}},	//   _akay_, хсән_, _robú, --, 
   {{0xb2f4205f,0x04840012,0xf77001ac,0x00000000}},	//   ияющ, رٕگی_, _ذال_, --, 
   {{0xa068271a,0x9f4c05a4,0x20180222,0xe53402eb}},	//   нама_, čník_, _shpi_, _седь, 
   {{0xa91c02b3,0xc3d80200,0xe3b00252,0x23840012}},	//   _pažy, _жөнi, য়োগব, _مٔشِ, 
   {{0xdee4271b,0x320802b0,0x70180023,0xfe440094}},	//   гоги, _ekay_, віст_, имгү, 
   {{0x4c640108,0xd00c0075,0x00000000,0x00000000}},	//   һитн_, سلف_, --, --, 
   {{0xc2c000d5,0x00000000,0x00000000,0x00000000}},	//   _ميڈي, --, --, --, 
   {{0x6578271c,0x63ac01e7,0x5ba8271d,0xeb4801ac}},	// [22e0] _mcwh, _ɗann, нкам_, چشمو_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7794031b,0xeb540572,0xdb0c0085,0x4c900409}},	//   ییرا, شىنگ, _jobø, _қиёс, 
   {{0xdb0c0028,0x9d4400fc,0x29000055,0x05a00030}},	//   _ynbê, _щемд, ğhan_, _खोलब, 
   {{0xd7e415a7,0x60100056,0x06800012,0x0d80271e}},	//   ліко, hæmm, ۅلوُ, _улян, 
   {{0xacb01bfa,0x00000000,0x00000000,0x00000000}},	//   _بەكب, --, --, --, 
   {{0xb4cc00cb,0x36d400f8,0x466416c1,0x76d802dc}},	//   रन्_, ройр, грым_, ъудӣ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x98741be0,0xdb1c00b6,0x320801dc,0x55041a6c}},	//   _љубљ, skpä, _rkay_, ычка, 
   {{0x32080105,0xd378271f,0x7dd80306,0xe8f40587}},	//   _skay_, хчи_, _físg, _әһә_, 
   {{0x0bb402c3,0x939401ac,0x00000000,0x00000000}},	//   אלים_, نجھا, --, --, 
   {{0xc2b4021d,0xa564005e,0x00000000,0x00000000}},	//   улює_, _ندهن, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x40342720,0xed580031,0x00000000,0x00000000}},	//   серс, _žž_, --, --, 
   {{0x8bc40f5d,0x02a000e5,0xbed400b7,0x00000000}},	//   қсад, _грым, борј, --, 
   {{0x32082721,0x9f482722,0xfd7401a7,0xb0342723}},	//   _ukay_, nibê_, йлсэ, _книш, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [22f0] --, --, --, --, 
   {{0xbc6803a2,0x92b40252,0x3b5400bf,0x00000000}},	//   املن_, ছনী_, йкур, --, 
   {{0x8aa42724,0x15f41715,0x00000000,0x00000000}},	//   ырад, ुकार_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d4c2725,0x99540049,0x00000000,0x00000000}},	//   mbaa, сiби_, --, --, 
   {{0x6d4c2726,0x00000000,0x00000000,0x00000000}},	//   lbaa, --, --, --, 
   {{0x6d4c0060,0x00000000,0x00000000,0x00000000}},	//   obaa, --, --, --, 
   {{0x6d4c2727,0x00000000,0x00000000,0x00000000}},	//   nbaa, --, --, --, 
   {{0x6d4c2728,0x851c136a,0x69d80130,0x00000000}},	//   ibaa, मेंट_, mhwe, --, 
   {{0xe2840329,0x6d4c0060,0x23282729,0x23340320}},	//   алои, hbaa, копи_, шхир, 
   {{0x6d4c272a,0x7dd801ca,0xdce4015b,0x00000000}},	//   kbaa, _híse, _sakļ, --, 
   {{0x69d80125,0xe124272b,0xdce40059,0x6d4c10a8}},	//   nhwe, имни, _pakļ, jbaa, 
   {{0x6d4c272c,0xbb1c080a,0xc6840061,0x00000000}},	//   dbaa, _ﺷﺎﻡ_, _شێکن_, --, 
   {{0x6448272d,0x6d4c272e,0xd4640027,0x0eb0040e}},	//   mpei, ebaa, _тише_, ीहंड, 
   {{0x69d81582,0x7dd800c4,0xdd90272f,0x6d4c2730}},	//   khwe, _líse, يوس_, fbaa, 
   {{0x38600815,0x6d4c2731,0xdee4021b,0xa3e0025c}},	//   širi_, gbaa, гоҳи, नोर_, 
   {{0xd00c063a,0x62802732,0x644801aa,0x69d80080}},	// [2300] سلہ_, ltlo, npei, dhwe, 
   {{0x6d4c2733,0xa2a81962,0x64482734,0x6280015e}},	//   abaa, टिप्, ipei, otlo, 
   {{0x7f5c2735,0x628001fa,0x6d4c2736,0x00000000}},	//   marq, ntlo, bbaa, --, 
   {{0xed340396,0xf95811cf,0x22502737,0x7f5c0d2e}},	//   _гэрэ, اساں_, ázky_, larq, 
   {{0x386003e0,0x91380282,0x62800e48,0x7dd80b7c}},	//   éir_, דענק, htlo, _vísd, 
   {{0x7f5c2738,0x7dd82739,0x6280273a,0x6f080333}},	//   narq, _díse, ktlo, şece, 
   {{0x69d80123,0x7f5c012a,0x6448018c,0x00000000}},	//   bhwe, iarq, epei, --, 
   {{0x7dd803e0,0xa2a81d14,0xef3c010f,0x7f5c273b}},	//   _físe, टिन्, ካሄደው, harq, 
   {{0x0308273c,0x7f5c03c0,0x628003ef,0xdce40055}},	//   _सुबह_, karq, etlo, _kakı, 
   {{0x44f0273d,0x3a3800e0,0x00000000,0x00000000}},	//   تسىز, _kurp_, --, --, 
   {{0x6d4c273e,0x6aa00038,0x64480139,0x62800085}},	//   ybaa, _álft, apei, gtlo, 
   {{0x37b801b9,0x6d4c0060,0xf4840122,0x9f4801b1}},	//   _অতিৰ, xbaa, _هاتی, libè_, 
   {{0x92b400ac,0x681802e6,0x7f5c273f,0x4fc42740}},	//   ছনে_, _aňdy, farq, асва, 
   {{0x7f5c2741,0x92140d54,0x6d4c2742,0xdce4024f}},	//   garq, _धीरज_, wbaa, _nakı, 
   {{0x6d4c2743,0x62802744,0x69d808c2,0x00000000}},	//   tbaa, ctlo, yhwe, --, 
   {{0x69d8019b,0x6d4c2745,0x00000000,0x00000000}},	//   xhwe, ubaa, --, --, 
   {{0xdce42746,0x6d4c2747,0x7f5c2748,0x00000000}},	// [2310] _bakı, rbaa, barq, --, 
   {{0x6d4c2749,0x8aa4274a,0x3a380f37,0x00000000}},	//   sbaa, иред, _burp_, --, 
   {{0x69d8120a,0x6d4c0e97,0x7dd8274b,0x3a38274c}},	//   thwe, pbaa, _síse, _curp_, 
   {{0x80a4274d,0x7dd802ef,0x6fd819ab,0x6d4c274e}},	//   _امین, _píse, _dìce, qbaa, 
   {{0x69d8274f,0x3a38011a,0xdce40055,0x00000000}},	//   rhwe, _eurp_, _fakı, --, 
   {{0x69d82750,0xdce4012b,0x68180031,0x49900061}},	//   shwe, _gakı, _yňdy, _ژیار, 
   {{0x6448036b,0x69d81562,0xded0010f,0x3a380101}},	//   wpei, phwe, _የዜና_, _gurp_, 
   {{0x69d82751,0x07040046,0x7dd801d5,0x0438001d}},	//   qhwe, هيږي_, _tíse, _በባለሙ, 
   {{0xdce42752,0x7f5c0919,0x240802eb,0xdb0c0229}},	//   _yakı, yarq, лнии_, _àjòj, 
   {{0xa3e01471,0xe29806d4,0x62802753,0x64482754}},	//   नों_, гао_, ttlo, rpei, 
   {{0x64482755,0x66f400df,0xe74401c4,0x0574115c}},	//   spei, _упжу, _күҙе_, _ناشد, 
   {{0x62802756,0x64482757,0x7f5c03c0,0xe7380116}},	//   rtlo, ppei, warq, _реҧ_, 
   {{0x7f5c2758,0x66082759,0x9f480249,0xa3b801ac}},	//   tarq, moek, libé_, _ماثر_, 
   {{0x216403c4,0xc34802e5,0xd9181f28,0x00000000}},	//   штүг, _ряде_, טורל, --, 
   {{0x7f5c275a,0x601003ed,0xdce4059c,0xa3e00095}},	//   rarq, næmi, _rakı, नोः_, 
   {{0xdce40333,0x7f5c04db,0x9f340049,0x6608275b}},	//   _sakı, sarq, реңі, noek, 
   {{0x7f5c275c,0xdb0c0113,0x5b34275d,0x3a380151}},	// [2320] parq, _dobý, معار, _surp_, 
   {{0x6608275e,0x26000110,0x7f5c03c0,0x2d8c0d8c}},	//   hoek, róoy_, qarq, _ñeen_, 
   {{0xdce40573,0x2008275f,0x66082760,0x9f480249}},	//   _vakı, mobi_, koek, jibé_, 
   {{0x200811e2,0x9f48018c,0x7dd801ca,0x657c01d6}},	//   lobi_, dibé_, _dísc, òshl, 
   {{0x1cb82761,0xdce40a4e,0x66080416,0x64440341}},	//   _صاحب_, _takı, doek, _ōhin, 
   {{0x20082762,0x3a382763,0x8c400937,0x9ad40007}},	//   nobi_, _turp_, _хере, _любі, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x20081f7e,0x660801aa,0xd4982764,0x00000000}},	//   hobi_, goek, гро_, --, 
   {{0x73d82765,0xdb0c0638,0x3944042e,0xd978001e}},	//   идир_, _lobü, _ifms_, _арҕә_, 
   {{0x249c0078,0x20082766,0x9f48014a,0x28c402a4}},	//   _dswm_, jobi_, bibé_, वहरि, 
   {{0x66082767,0x20082768,0x00000000,0x00000000}},	//   boek, dobi_, --, --, 
   {{0x3860173f,0x44f00340,0xe5780335,0x96180075}},	//   širu_, تسۉز, ghŷd_, _صغار_, 
   {{0x20082769,0x2ed009cf,0x73c40049,0x2bb8040e}},	//   fobi_, सन्त, _дәне, _उचला, 
   {{0x63ac01e7,0x03a00254,0x2008007b,0x2cac00ef}},	//   _ɗank, _ничо, gobi_, _šedo_, 
   {{0xdb0c0192,0x00000000,0x00000000,0x00000000}},	//   _pobý, --, --, --, 
   {{0x21f0000a,0x00000000,0x00000000,0x00000000}},	//   tšhe_, --, --, --, 
   {{0x2008276a,0x316801aa,0x7dd80306,0x80d800bd}},	// [2330] bobi_, _idaz_, _sísc, नैदे, 
   {{0x660808cd,0x2008276b,0x00000000,0x00000000}},	//   zoek, cobi_, --, --, 
   {{0x6fb4276c,0xfbd00272,0xd1dc02b4,0xcb1800b7}},	//   _همکا, رتك_, _ዓሌት_, уќа_, 
   {{0x7dd80b07,0xdd901ae5,0x660801aa,0x311c0095}},	//   _vísc, _قوپ_, xoek, _नराः_, 
   {{0x764800fc,0x9994276d,0x765801d3,0x00000000}},	//   _atdy, زپور_, _āraṇ, --, 
   {{0xa6c8276e,0xa7a8276f,0x6608086a,0x2ca8090c}},	//   илла_, ркка_, woek, mvad_, 
   {{0x2ca82770,0x66082771,0xe57802dc,0xdb0c2772}},	//   lvad_, toek, азй_, _dobó, 
   {{0xe6180c9f,0xa4442773,0xc0e0010f,0xa3e0021f}},	//   јди_, онид, _ነዋሪ_, नोई_, 
   {{0x38600272,0xa91c03aa,0x9f48005e,0x2008061a}},	//   áirt_, _obži, sibé_, yobi_, 
   {{0x66082774,0x7dd8006b,0xdc2c012b,0x668000d5}},	//   soek, _mísa, _yııl, _ہیڈل, 
   {{0x2ca82775,0x7dd800c4,0x66080039,0x200801d9}},	//   hvad_, _lísa, poek, vobi_, 
   {{0x249c01f3,0x2ca80aa0,0x950801e5,0x26d80151}},	//   _tswm_, kvad_, ịzịg, _ęsoh_, 
   {{0xd24c2776,0x20082777,0x34942778,0x2ca8090c}},	//   _ینو_, tobi_, _нацр, jvad_, 
   {{0x23282779,0x2ca8277a,0x25e4277b,0x443c090c}},	//   _коли_, dvad_, जोरी_, mqu_, 
   {{0x443c277c,0xa2e40063,0x53980107,0x2ca800af}},	//   lqu_, _фойд, _כיסו, evad_, 
   {{0x2008277d,0x2d8c1420,0x835000d5,0x00000000}},	//   sobi_, _ñeel_, _بھکا, --, 
   {{0xe20413d7,0x443c277e,0x1be800f8,0x7dd800bd}},	// [2340] रवीण_, nqu_, адаи_, _císa, 
   {{0x3ce00091,0x20081123,0x443c0670,0x7dd8030f}},	//   rziv_, qobi_, iqu_, _dísa, 
   {{0x3f98277f,0x443c07eb,0x2ca800a1,0x7094010f}},	//   meru_, hqu_, avad_, ያደርጉ_, 
   {{0x2ca80140,0x198800cc,0xdb0c03bf,0x00000000}},	//   bvad_, рбди_, _sobó, --, 
   {{0x443c090c,0xdb0c03bf,0x00000000,0x00000000}},	//   jqu_, _pobó, --, --, 
   {{0x3f982780,0x48d8007e,0x1ae41ade,0x443c090c}},	//   neru_, বপূৰ, _догм, dqu_, 
   {{0xd94400c3,0x3f9800c2,0x443c0002,0x00000000}},	//   _меви, ieru_, equ_, --, 
   {{0x3f982781,0x394400b7,0x443c043b,0x00000000}},	//   heru_, _ufms_, fqu_, --, 
   {{0x22482782,0x443c0380,0x7dd80152,0x00000000}},	//   _čaka_, gqu_, _xísa, --, 
   {{0x3f982783,0xc5100121,0x00000000,0x00000000}},	//   jeru_, ببىت, --, --, 
   {{0x443c2784,0x2ca802e3,0x76480031,0x6d4002a0}},	//   aqu_, zvad_, _utdy, _şlam, 
   {{0x443c0156,0x2ca80156,0x00000000,0x00000000}},	//   bqu_, yvad_, --, --, 
   {{0x3f982785,0x63ac059b,0x798002b0,0x9f480335}},	//   feru_, íonó, _mcmw, ribî_, 
   {{0x3f982786,0xdde001df,0x603001d5,0x2ca80156}},	//   geru_, _ćušk, _němě, vvad_, 
   {{0xfeb82787,0xadf800aa,0x6374001e,0x2ca80428}},	//   يافت_, ्कलन_, _ỹngu, wvad_, 
   {{0x7dd8018b,0x31680054,0xc32c1be5,0x2ca80156}},	//   _písa, _udaz_, _جەپ_, tvad_, 
   {{0x9f84007f,0xb0542788,0xa3e00030,0x2ca8013c}},	// [2350] _eôñ_, ọọrọ_, नोक_, uvad_, 
   {{0x3f982789,0x7dd80984,0xdb0c00cc,0x7980043e}},	//   ceru_, _vísa, _robò, _acmw, 
   {{0x2ca80156,0x443c01e3,0x00000000,0x00000000}},	//   svad_, zqu_, --, --, 
   {{0x2ca80380,0xdb240324,0x443c278a,0x00000000}},	//   pvad_, سونی, yqu_, --, 
   {{0x6d5c0025,0x2ca80156,0x00000000,0x00000000}},	//   _iesa, qvad_, --, --, 
   {{0x798002b0,0x05a003ea,0xdc380107,0x443c090c}},	//   _ecmw, _खोजब, _לעשר, vqu_, 
   {{0x6d5c278b,0xba74278c,0xc6a401a0,0x443c0380}},	//   _kesa, _يافت, юрди, wqu_, 
   {{0x6d5c278d,0xfb340822,0x443c0156,0xa2a8011c}},	//   _jesa, _інтэ, tqu_, टिस्, 
   {{0x6d5c278e,0x2918020f,0x649801a0,0x78a0278f}},	//   _mesa, _ása_, ётир_, _gsmv, 
   {{0x443c2790,0x33d4021d,0x00000000,0x00000000}},	//   rqu_, діют, --, --, 
   {{0x443c2791,0x3f982792,0xe7182793,0x69c80369}},	//   squ_, veru_, _ايات_, _koee, 
   {{0x3f982794,0x443c090c,0x00000000,0x00000000}},	//   weru_, pqu_, --, --, 
   {{0x69c82795,0xe4482796,0x443c2797,0x7dd802b2}},	//   _moee, _التى_, qqu_, _bísn, 
   {{0x6d5c08be,0x64580380,0xe2980b1e,0x00000000}},	//   _aesa, _iwwi, _гак_, --, 
   {{0x6d5c2798,0x3f982799,0x00000000,0x00000000}},	//   _besa, reru_, --, --, 
   {{0x3f98279a,0x645808c2,0x1c44279b,0x69c8015b}},	//   seru_, _kwwi, знам, _noee, 
   {{0x6d5c279c,0x3f98279d,0x3ba400f8,0xa2a8072d}},	// [2360] _desa, peru_, млаҳ, टिव्, 
   {{0x6d5c279e,0x6eb40303,0x798002b0,0x00000000}},	//   _eesa, _उपचु, _scmw, --, 
   {{0x69c8279f,0x6d5c27a0,0xcf540107,0x3d0800b0}},	//   _boee, _fesa, _מבית_, _žuvę_, 
   {{0x6d5c27a1,0xc8340020,0xd8381857,0xbf58004f}},	//   _gesa, _ክሰምዕ, бэк_, _ārṣe_, 
   {{0x8eb0005e,0x00000000,0x00000000,0x00000000}},	//   _قمیش, --, --, --, 
   {{0x6d5c27a2,0xdb501741,0x00000000,0x00000000}},	//   _zesa, _سَر_, --, --, 
   {{0x6d5c27a3,0x6458043b,0x0308021f,0x798002b0}},	//   _yesa, _awwi, _सुलह_, _tcmw, 
   {{0x64580039,0x9f480110,0x8af800ca,0x00000000}},	//   _bwwi, nibâ_, _ההלי, --, 
   {{0x7dd80a03,0xd498263d,0xdb1c013c,0x00000000}},	//   _líso, ёри_, hkpü, --, 
   {{0xdb1c00af,0xb9dc001d,0x00000000,0x00000000}},	//   kkpü, _በሱ_, --, --, 
   {{0x9f480770,0x73341812,0x7dd800d3,0xa2800cca}},	//   ribì_, بىدا, _níso, نیوو, 
   {{0xd4980f0e,0x56280106,0x00000000,0x00000000}},	//   _грк_, _ужем_, --, --, 
   {{0x7dd800aa,0x94240200,0x6d5c27a4,0x3a24012c}},	//   _písn, _емде, _resa, _mhmp_, 
   {{0x6e940152,0x00000000,0x00000000,0x00000000}},	//   мигу, --, --, --, 
   {{0x6d5c27a5,0x9f4800dc,0xd2440128,0x2d8c0d8c}},	//   _pesa, cibí_, _ээли, _ñeek_, 
   {{0x6d5c27a6,0x42f80240,0x7bdc0a0e,0x3da402dc}},	//   _qesa, _להוס, _alru, нруб, 
   {{0x6d5c27a7,0xfd7405bc,0x7bdc007b,0x7dd827a8}},	// [2370] _vesa, элтэ, _blru, _tísn, 
   {{0x6e9827a9,0x4ba40128,0x4ea427aa,0x0fe00572}},	//   _двор_, чөмү_, _ерма, _чөмү, 
   {{0x69c827ab,0x60100085,0xa3e00098,0x00000000}},	//   _poee, ræmt, नोट_, --, 
   {{0x7bdc0140,0xc3300107,0x6d5c27ac,0xa5bc028d}},	//   _elru, גוע_, _uesa, amųj, 
   {{0xe738023f,0x62840247,0x00000000,0x00000000}},	//   оел_, _ãhov, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x56901458,0x7c20000b,0xaa5427ad,0x7aa40427}},	//   вајт, _ëmra, _іваш, _пиёз, 
   {{0xd90c03d9,0x44a000fc,0x00000000,0x00000000}},	//   ایے_, егиң, --, --, 
   {{0x66d400a3,0x00000000,0x00000000,0x00000000}},	//   _ڪيائ, --, --, --, 
   {{0x7dd804ac,0xa3e801f5,0xa2a82448,0x3a2401d5}},	//   _aísl, ідна_, टिल्, _zhmp_, 
   {{0xa2e427ae,0x94c800ea,0x00000000,0x00000000}},	//   фонд, مایې_, --, --, 
   {{0x672007e7,0x7dd800ef,0x00000000,0x00000000}},	//   _izlj, _císl, --, --, 
   {{0x6458193b,0x7dd827af,0x01e400cc,0x00000000}},	//   _uwwi, _dísl, _үйлү, --, 
   {{0x7dd8018b,0xe2c8005e,0x2be0006c,0xd6e00201}},	//   _píso, _ووشو_, फसफा, bułą_, 
   {{0xe7e40076,0xd34427b0,0x00000000,0x00000000}},	//   _कतना_, _تیپه_, --, --, 
   {{0x7dd80984,0xe1f004c3,0x00000000,0x00000000}},	//   _gísl, _جست_, --, --, 
   {{0xa0080075,0x3a2401d5,0x24e40200,0x3f8c00af}},	// [2380] _وقبل_, _rhmp_, ﺍﺭﻻﻣ, õdus_, 
   {{0x67201f81,0x60100085,0x00000000,0x00000000}},	//   _ozlj, ræms, --, --, 
   {{0xf0001436,0xa5bc0023,0x00000000,0x00000000}},	//   _сүри, rmųj, --, --, 
   {{0x7e7c27b1,0x9f4827b2,0x2124012c,0x00000000}},	//   murp, libà_, _úohs_, --, 
   {{0x5fd01471,0x7e7c27b3,0x00000000,0x00000000}},	//   _हवाल, lurp, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x37c4016d,0x63ac01e7,0xa3b003ef,0xdab80075}},	//   _үҙеб, _ɗant, _ऑफ़_, _ظهرت_, 
   {{0x2cac27b4,0xc2140125,0x99840593,0x00000000}},	//   _šedi_, _nkɔ_, mmoů_, --, 
   {{0xd4980302,0x38c827b5,0xd4040634,0xb4c80030}},	//   іри_, _عاری_, дяни, ईहे_, 
   {{0xc2140125,0x32540254,0x7e7c27b6,0xe2a800dd}},	//   _akɔ_, нвор, kurp, ڳاپن_, 
   {{0xc7b010bc,0x7dd806b4,0x580000c3,0xf4840123}},	//   _שבע_, _písl, _كۈچك, фуқн, 
   {{0x7e7c03c0,0x00000000,0x00000000,0x00000000}},	//   durp, --, --, --, 
   {{0xd3c4192c,0x660400c6,0xe7e40095,0x3cf803bf}},	//   _ойдй, éhke, _कतमा_, ंपों_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x403427b7,0xb8d00037,0x7e7c27b8,0xca6801d2}},	//   терс, _ཐན_, gurp, нiнi, 
   {{0x9f480552,0x8d7427b9,0x020401c8,0x2b4c01d5}},	//   tibã_, باسا, _үзән, _řec_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2390] --, --, --, --, 
   {{0x7e7c01a7,0x00000000,0x00000000,0x00000000}},	//   burp, --, --, --, 
   {{0x2f1801a7,0x00000000,0x00000000,0x00000000}},	//   _хонь_, --, --, --, 
   {{0x88f0024b,0x00000000,0x00000000,0x00000000}},	//   кілә, --, --, --, 
   {{0x6e2c27ba,0x00000000,0x00000000,0x00000000}},	//   mmab, --, --, --, 
   {{0x63ac0181,0x7b7427bb,0xe4f400bd,0x64a4001e}},	//   _ɗans, _لطفا, ुअघि_, ҵаиа, 
   {{0x6e2c27bc,0x499027bd,0xdec0001d,0x00000000}},	//   omab, _لیار, _ትተን_, --, 
   {{0x672001f6,0xa2bc0474,0xeb340411,0x8c340123}},	//   _vzlj, षमस्, _يىڭد, _хоҳӣ_, 
   {{0x25e40cd6,0x60100184,0x6e2c27be,0xe3b00061}},	//   जोगी_, kæmp, imab, ۆرگ_, 
   {{0xdb0c0638,0x69d827bf,0x64a4006e,0x6e2c0095}},	//   _vobö, lkwe, _җака, hmab, 
   {{0xd24c27c0,0x69d827c1,0x9f4800b7,0x2d8c0029}},	//   ینی_, okwe, jibá_, _ñeew_, 
   {{0x69d827c2,0x7dd80214,0x36d401ec,0xbbdc00cb}},	//   nkwe, _písm, _шохр, _यत्क, 
   {{0xa3d427c3,0xb5c80324,0x00000000,0x00000000}},	//   _подч, _تونم_, --, --, 
   {{0x53a002ca,0x64440299,0x7dd8014e,0x6e2c0379}},	//   _башб, _ōhiw, _vísm, emab, 
   {{0x44240602,0xdee40989,0x236400e9,0x9f4800bf}},	//   _ihn_, хови, malj_, ribà_, 
   {{0xd24c03e0,0x6e2c27c4,0x44240177,0x7e7c27c5}},	//   _اني_, gmab, _hhn_, rurp, 
   {{0x92140282,0x9c241eb3,0x716400e7,0xdd940049}},	// [23a0] _אַזױ_, едад, _شايك, маңы, 
   {{0x7e7c036b,0x26e400ac,0x44240618,0x69d827c6}},	//   purp, _কখনো_, _jhn_, ekwe, 
   {{0x442427c7,0x7e7c02b1,0x00000000,0x00000000}},	//   _mhn_, qurp, --, --, 
   {{0xceb00a1b,0x69d827c8,0x09e002ac,0x44240177}},	//   _עיר_, gkwe, лохн, _lhn_, 
   {{0x236427c9,0x7dd80192,0x00000000,0x00000000}},	//   kalj_, _lísk, --, --, 
   {{0x442425e8,0x69d827ca,0x00000000,0x00000000}},	//   _nhn_, akwe, --, --, 
   {{0x236427cb,0x69d8018c,0x7dd806b4,0x00000000}},	//   dalj_, bkwe, _nísk, --, 
   {{0x69d827cc,0x86200061,0x35b401c3,0x00000000}},	//   ckwe, ۆکۆل, тбир, --, 
   {{0x09e027cd,0xbb3811e5,0x19580049,0x04600094}},	//   _сотн, _ﻗﺎﻥ_, _маңы_, лтэм, 
   {{0xb4580090,0x442427ce,0x236427cf,0x00000000}},	//   _ያደረጉ, _chn_, galj_, --, 
   {{0xa3b003c3,0x7a7c02b4,0x44240177,0x6e2c27d0}},	//   _ऑफर_, _ብቐጥታ_, _dhn_, ymab, 
   {{0x44240125,0xdb0c0479,0x562802ba,0x8af80676}},	//   _ehn_, _inbä, _эжем_, להיי, 
   {{0x23640070,0x442427d1,0x506400e5,0x609801ac}},	//   balj_, _fhn_, этна, ونٽس_, 
   {{0x442427d2,0x7dd802e8,0x44ac001e,0x9f4801f1}},	//   _ghn_, _físk, _ñasẽ_, tibá_, 
   {{0x6e2c00cb,0x82b027d3,0x644c0475,0x6d480012}},	//   tmab, _محيط, _çair, ِلرِ_, 
   {{0x6e2c27d4,0x51840d38,0x9f4800b7,0x00000000}},	//   umab, _чука, ribá_, --, 
   {{0x6e2c27d5,0x7dd827d6,0x998800e5,0x00000000}},	// [23b0] rmab, _získ, _lubų_, --, 
   {{0x7dd800c4,0xaa580106,0xdb0c0031,0xdec8001d}},	//   _lísh, дижу_, _onbä, _አልኩ_, 
   {{0xa0340240,0x69d800c4,0xbb840272,0x00000000}},	//   _שאתה_, tkwe, المي, --, 
   {{0xdb0c01f1,0xfaa40152,0x00000000,0x00000000}},	//   _robô, ышун, --, --, 
   {{0x69d80952,0x19c00d56,0xdb0c01d4,0x7bcc01d5}},	//   rkwe, шәрг, _sobô, _žluť, 
   {{0x69d827d7,0xd7e800e7,0xa6940edd,0x00000000}},	//   skwe, وونۇ_, вриј, --, 
   {{0xd7ec27d8,0xe5a4006e,0x23640070,0x69d8018c}},	//   تكو_, вийи, valj_, pkwe, 
   {{0xfa780661,0x442427d9,0x92dc00c2,0xc06c00a8}},	//   _ካልኣይ_, _shn_, datπ_, _eṣyā, 
   {{0x236427da,0x442427db,0xdb0c0207,0x7dd801ca}},	//   talj_, _phn_, _enbä, _dísh, 
   {{0x7dd827dc,0xdb0c01d4,0xc7640108,0x00000000}},	//   _písk, _tobô, _سائى, --, 
   {{0x236402db,0xb458001d,0xf65001ac,0xf67427dd}},	//   ralj_, _ያደርጉ, _هئن_, _مانخ, 
   {{0xa06827de,0x236401df,0x7dd827df,0x00000000}},	//   мама_, salj_, _vísk, --, 
   {{0x93c827e0,0x442427e1,0x236401df,0x25ac0207}},	//   سایہ_, _thn_, palj_, mdel_, 
   {{0x7dd821c9,0x4424010b,0x1ea818c2,0x25ac03af}},	//   _tísk, _uhn_, وازي_, ldel_, 
   {{0x248c27e2,0x6fd801d6,0x7dd801ca,0x6ed4013c}},	//   ltem_, _mìch, _hísi, _sхbr, 
   {{0x248c27e3,0x33b00121,0x6b94012b,0x7dd806b4}},	//   otem_, _نەۋر, _abzg, _kísi, 
   {{0x248c27e4,0xa2a827e5,0x60080294,0x8c4027e6}},	// [23c0] ntem_, टिक्, _оним_, иете, 
   {{0x248c27e7,0x7dd82607,0xbe6401ac,0x00000000}},	//   item_, _mísi, _مڇري, --, 
   {{0x248c27e8,0x7dd800c4,0x6f78007c,0xdee427e9}},	//   htem_, _lísi, _אָרג, _рони, 
   {{0x248c27ea,0x00000000,0x00000000,0x00000000}},	//   ktem_, --, --, --, 
   {{0x9f48034c,0x7dd827eb,0x00000000,0x00000000}},	//   ribæ_, _nísi, --, --, 
   {{0x25ac27ec,0x248c27ed,0x48100023,0x00000000}},	//   edel_, dtem_, аміс, --, 
   {{0x248c1658,0x8c1400e2,0x98b00386,0x00000000}},	//   etem_, _شيفر_, ıcık_, --, 
   {{0x7c3c27ee,0x2d8c0029,0x25ac1fe4,0x248c27ef}},	//   _hirr, _ñeet_, gdel_, ftem_, 
   {{0x248c03fa,0xf8b027f0,0x7c3c27f1,0x73d827f2}},	//   gtem_, _دکا_, _kirr, едпр_, 
   {{0x7c3c27f3,0x25ac038b,0x660c27f4,0x1958016d}},	//   _jirr, adel_, čaka, _хаҡы_, 
   {{0x248c27f5,0x27e80e66,0x7c3c27f6,0x25ac0002}},	//   atem_, ɗan_, _mirr, bdel_, 
   {{0xcb1010bc,0x248c0110,0x63800116,0x00000000}},	//   ילת_, btem_, аҳәа, --, 
   {{0x248c27f7,0x7c3c27f8,0x00000000,0x00000000}},	//   ctem_, _oirr, --, --, 
   {{0x7c3c27f9,0x92f4059b,0x00000000,0x00000000}},	//   _nirr, _لأعض, --, --, 
   {{0xc2c027fa,0xb5fc0126,0xef100128,0xbb380200}},	//   _نيوي, _ewġe, сүнө, _ﻗﺎﻻ_, 
   {{0x7c3c27fb,0xfd7401a7,0x61e427fc,0x225002cc}},	//   _airr, илсэ, chkl, ízke_, 
   {{0x7c3c2457,0x224801d1,0xcfa8059b,0x00000000}},	// [23d0] _birr, _čaki_, _قادم_, --, 
   {{0x7c3c27fd,0x7c841577,0x3b5427fe,0xe7bc00ac}},	//   _cirr, јуте, икур, _অত্য, 
   {{0x7c3c27ff,0x248c00cd,0xaed4024b,0xf40400dc}},	//   _dirr, ztem_, _сонш, _উঠার_, 
   {{0xe7e41f7d,0x248c03af,0x25ac02ba,0x7c3c02b2}},	//   कसभा_, ytem_, xdel_, _eirr, 
   {{0x7c3c2800,0x6e3c0556,0x6d4c0012,0x67d42801}},	//   _firr, _iisb, mcaa, лоду, 
   {{0x6e3c2802,0x7c3c0cfa,0x6d4c2803,0x7dd802e8}},	//   _hisb, _girr, lcaa, _rísi, 
   {{0x6e3c265e,0x6d4c03af,0xdb4c0012,0x6b840428}},	//   _kisb, ocaa, _ژێے_, mghg, 
   {{0x248c2804,0x6d4c2805,0x26c816c6,0x25ac2806}},	//   ttem_, ncaa, ćao_, udel_, 
   {{0x6e3c0351,0xf9d400fc,0x7c3c028b,0x248c000b}},	//   _misb, _тотэ, _yirr, utem_, 
   {{0x248c2807,0x7dd81d6d,0x25ac0cd5,0x6b84008e}},	//   rtem_, _vísi, sdel_, nghg, 
   {{0x44f80151,0x6e3c02b0,0x25ac0078,0x66d4238f}},	//   _wɪ_, _oisb, pdel_, _حيائ, 
   {{0x6e3c2808,0x64b41f33,0x248c2809,0xdee400b2}},	//   _nisb, _محتر, ptem_, қоби, 
   {{0x248c03fa,0x6d4c0080,0x0464001e,0x24f8069d}},	//   qtem_, dcaa, _ртем, _янды_, 
   {{0x6d4c280a,0x6e3c280b,0x6568280c,0x61e4280d}},	//   ecaa, _aisb, laeh, shkl, 
   {{0x6e3c280e,0xf3f003e0,0xd40403a2,0x6d4c280f}},	//   _bisb, _بأن_, _حڪيم_, fcaa, 
   {{0x7c3c2810,0xdca42494,0x6e3c0012,0x6d4c0060}},	//   _sirr, лаби, _cisb, gcaa, 
   {{0x6e3c2811,0x62802812,0x7c3c2813,0x214404c4}},	// [23e0] _disb, lulo, _pirr, āwhā_, 
   {{0x65682814,0x6e3c0a79,0x7c3c01a0,0x3d040457}},	//   haeh, _eisb, _qirr, _रखीं_, 
   {{0x62802815,0x65682816,0xa2a8025c,0x6d4c0060}},	//   nulo, kaeh, टिट्, bcaa, 
   {{0x6d4c0788,0x5f442817,0x63a02818,0x8e78007c}},	//   ccaa, _جنگل, heln, _אנטה, 
   {{0x7c3c0c89,0x62802819,0x2448281a,0x7dd800c4}},	//   _tirr, hulo, _núm_, _sísw, 
   {{0xda64281b,0x63a0281c,0x7c3c281d,0x00000000}},	//   _ماري, jeln, _uirr, --, 
   {{0x6280281e,0x63a0281f,0x1ae400bb,0x61f40c8b}},	//   julo, deln, _совм, _omyl, 
   {{0x6e3c04bb,0xc0f002b4,0x244802b2,0x63a000af}},	//   _xisb, ጀርስ_, _búm_, eeln, 
   {{0x6448070b,0x24480014,0x80a403ef,0x1cb80126}},	//   gqei, _cúm_, _चैले, མའི_, 
   {{0x62802820,0x93a42821,0x73d8021b,0xe7b00012}},	//   fulo, ушид, тдор_, _وۅند, 
   {{0x62802822,0x21e000b8,0x6d4c028b,0x00000000}},	//   gulo, _sóha_, ycaa, --, 
   {{0x15442823,0x244801ca,0x6d4c028b,0x324400ec}},	//   _седм, _fúm_, xcaa, леүг, 
   {{0x6e3c2824,0xc1080254,0x24482825,0x663401e3}},	//   _risb, гэре_, _gúm_, _тэфф, 
   {{0x61f40083,0x63a02826,0x6e3c0380,0x41c40049}},	//   _emyl, celn, _sisb, _ۇقىق, 
   {{0x62802827,0x6d4c0788,0x6e3c018c,0xb36c001d}},	//   culo, tcaa, _pisb, _በሱዳን_, 
   {{0xefbc0020,0x2c1c0095,0x6d4c23ea,0x00000000}},	//   ቶንዮ_, _बीजं_, ucaa, --, 
   {{0x6d4c2828,0x6e3c2829,0x216400bf,0x244801eb}},	// [23f0] rcaa, _visb, _өтөг, _xúm_, 
   {{0x0a68282a,0x6e3c005e,0x2018010b,0x6d4c282b}},	//   ерди_, _wisb, _gkpi_, scaa, 
   {{0xdb0c0034,0x6e3c282c,0x61f40323,0x682c001e}},	//   _habê, _tisb, _ymyl, lúdg, 
   {{0x63a0282d,0x6e3c03f4,0xc3300d47,0x00000000}},	//   zeln, _uisb, צוף_, --, 
   {{0x6280282e,0x2d98158f,0x47700200,0x32080085}},	//   zulo, _ibse_, йқау, _mjay_, 
   {{0x6568282f,0x24482830,0x644801a0,0xb68c02b4}},	//   waeh, _rúm_, vqei, _ዘይኮኑ_, 
   {{0x656800a2,0x65c41551,0x49b0001e,0x32080379}},	//   taeh, ибка, _гәлу, _ojay_, 
   {{0x62802831,0x660c14ba,0x32082832,0x63a00560}},	//   vulo, čako, _njay_, weln, 
   {{0x65682833,0x63a02834,0xa3b82835,0x2bc817b1}},	//   raeh, teln, نادر_, रापा, 
   {{0x62802836,0x66180df9,0x61f40207,0x23d42837}},	//   tulo, _wkwk, _smyl, рцир, 
   {{0x63a02838,0x2d9801d4,0x65682839,0xa20402eb}},	//   reln, _obse_, paeh, ипод, 
   {{0x6280283a,0x63a0283b,0x32080085,0xa3b40290}},	//   rulo, seln, _cjay_, _चोर_, 
   {{0x6280283c,0x7dd80357,0x63a0283d,0x3d0406f7}},	//   sulo, _míst, peln, _रखें_, 
   {{0x7dd80214,0x2d9800f1,0x63a00380,0x307402eb}},	//   _líst, _abse_, qeln, щуюс, 
   {{0x2bc8022d,0x6280283e,0x2174283f,0xb7f803ef}},	//   राना, qulo, _купр, ्चतम_, 
   {{0x2d982840,0x7dd806b4,0xb60801d5,0x00000000}},	//   _cbse_, _níst, pešť, --, 
  
   {{0xa0a400df,0x4d4401c7,0xd12c00cc,0x00000000}},	// [2400] _тапд, рпун_, _ۉمۉ_, --, 
   {{0x7dd802e8,0x00000000,0x00000000,0x00000000}},	//   _rísu, --, --, --, 
   {{0x0f780100,0x7dd80229,0x596401d9,0x00000000}},	//   _בריל, _sísu, аъла, --, 
   {{0x7dd801ca,0xdb0c02bb,0x00000000,0x00000000}},	//   _císt, _habë, --, --, 
   {{0xdb0c02bb,0x88c400a8,0x00000000,0x00000000}},	//   _kabë, _niśī, --, --, 
   {{0x7dd81de0,0x7c0403a2,0x00000000,0x00000000}},	//   _vísu, _اڀرن, --, --, 
   {{0x7dd80306,0x682c02b2,0x00000000,0x00000000}},	//   _físt, dúdd, --, --, 
   {{0xdb0c0475,0x4e7800cf,0x765800b0,0x00000000}},	//   _labë, דאקצ, rpvy, --, 
   {{0x335400bf,0x00000000,0x00000000,0x00000000}},	//   бүлө_, --, --, --, 
   {{0xd3941436,0x2bc82841,0x454000e7,0xdb0c0229}},	//   рәдә_, राया, مچۇق, _àkóy, 
   {{0x0bb40240,0x00000000,0x00000000,0x00000000}},	//   בלים_, --, --, --, 
   {{0x05802842,0x7dd82843,0xd4981820,0x22500b0a}},	//   _душм, _míss, _арк_, ízka_, 
   {{0x76482844,0x2bc82845,0xdb0c0222,0x629c0513}},	//   _hudy, रामा, _babë, ăsoa, 
   {{0xb7f82846,0x76482847,0x00000000,0x00000000}},	//   ्चिम_, _kudy, --, --, 
   {{0xdb0c0239,0x5f18252d,0x3208006f,0x60c00560}},	//   _wabê, _मुद्_, _tjay_, _ġome, 
   {{0x60c02848,0x76482849,0x3208284a,0x00d803b5}},	//   _šome, _mudy, _ujay_, ابێت_, 
   {{0x6b74284b,0xab740340,0xcb440116,0x321807f1}},	// [2410] йлау, йгаш, ахеи, mosy_, 
   {{0xdb0c17ab,0x32180693,0xe2040038,0x764802b0}},	//   _kabè, losy_, _þóra_, _oudy, 
   {{0x2bc80b0c,0xdb0c00f1,0xcc840122,0x4ea403e9}},	//   राबा, _jabè, انڕه_, _трпа, 
   {{0x3218284c,0xfe24284d,0x3944015b,0xdf5400e2}},	//   nosy_, _мьян, _cgms_, _پریښ, 
   {{0x7dd8020c,0xdb0c0078,0x31680151,0x764803ef}},	//   _víst, _labè, _meaz_, _audy, 
   {{0x764806f7,0x2ca80762,0x3218069c,0xa3b4021f}},	//   _budy, mwad_, hosy_, _चों_, 
   {{0x321812ca,0x2ca8284e,0x76480335,0x7dd803c2}},	//   kosy_, lwad_, _cudy, _tíst, 
   {{0x2d88284f,0xe2980f72,0x5f08025c,0x00000000}},	//   ngae_, қам_, _सशस्_, --, 
   {{0x2ca80336,0x3218039d,0xc7a00012,0x21680121}},	//   nwad_, dosy_, _ؤری, һини_, 
   {{0xdb0c0078,0xe284138a,0x13e4006b,0xe7942850}},	//   _babè, блои, ймый_, _دارک, 
   {{0x21680e19,0x3218034a,0x316801aa,0xe7840108}},	//   лини_, fosy_, _beaz_, _вуҗо, 
   {{0x32182851,0x2ca800f1,0xa0a402ba,0x00000000}},	//   gosy_, kwad_, бамд, --, 
   {{0x316802e3,0xdb0c02bb,0x67202852,0x7648028d}},	//   _deaz_, _pabë, _hylj, _zudy, 
   {{0xd9180240,0x46100063,0x2ca80323,0x76482853}},	//   רושל, _اوچر, dwad_, _yudy, 
   {{0xdb0c052b,0xe2982854,0x32180693,0x3dbc011a}},	//   _gabè, _сай_, bosy_, _པོདན, 
   {{0x22902855,0x672002b2,0x32180055,0x527800cf}},	//   mák_, _mylj, cosy_, _ענפא, 
   {{0x22902856,0x2ca80840,0xdb0c0078,0x00000000}},	// [2420] lák_, gwad_, _zabè, --, 
   {{0x9f842857,0xdb0c2858,0x672008a2,0xef180155}},	//   _угод, _habé, _oylj, умӣ_, 
   {{0xdb0c2859,0x3f9800de,0x7768006f,0x2290285a}},	//   _kabé, mfru_, _redx, nák_, 
   {{0x3f9801c6,0x00000000,0x00000000,0x00000000}},	//   lfru_, --, --, --, 
   {{0xd7f803c4,0xdb0c02c6,0x7648285b,0x2ca80012}},	//   лук_, _mabé, _sudy, cwad_, 
   {{0x2bc8285c,0x67200028,0x2290285d,0xdb0c0039}},	//   राणा, _bylj, kák_, _labé, 
   {{0x2290285e,0x3eb807b5,0xc6740075,0x764802a0}},	//   ják_, nvrt_, محيط_, _qudy, 
   {{0x2290285f,0x764804ca,0x67242860,0x672003c2}},	//   dák_, _vudy, ühja, _dylj, 
   {{0xdb0c197c,0x05700e85,0x4d780100,0x53440182}},	//   _sabè, سايد, ארפע, йхна, 
   {{0xb2742861,0x67202862,0x22902863,0x99980105}},	//   олош, _fylj, fák_, śyńy_, 
   {{0xdb0c2864,0x764805b8,0x22902865,0x2bc81403}},	//   _babé, _uudy, gák_, राता, 
   {{0xd46809ac,0xdb0c0039,0xf77003a2,0x924c010f}},	//   _биде_, _cabé, _راڄ_, _አደረጃ, 
   {{0x32182866,0x682c02d9,0xdb0c01d5,0x3f982867}},	//   rosy_, súde, _dabé, ffru_, 
   {{0x321812c6,0x22902868,0x9590010f,0x2ca80078}},	//   sosy_, bák_, ጃዎችን_, vwad_, 
   {{0x82342869,0x3218069c,0x5184286a,0x22901a54}},	//   تریا, posy_, _лупа, cák_, 
   {{0x2ca80086,0x00000000,0x00000000,0x00000000}},	//   twad_, --, --, --, 
   {{0x2d8802bf,0x00000000,0x00000000,0x00000000}},	// [2430] rgae_, --, --, --, 
   {{0x2bc8286b,0x4ae80ad0,0x6b74024b,0x2d880034}},	//   राधा, льем_, ілеу, sgae_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd3641596,0x6dc00340,0x00000000,0x00000000}},	//   _ښه_, _تۅرۅ, --, --, 
   {{0x7c84286c,0x6720286d,0x22901a31,0x2bc8286e}},	//   _нуре, _sylj, zák_, रादा, 
   {{0x2290286f,0xb6b80560,0x8bc80254,0xd2440ece}},	//   yák_, _ཚནྡྷ, _сымб_, _ين_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22902870,0xdb0c034a,0xdb2401d9,0x799402dc}},	//   vák_, _kabî, _ذوقی, _нисф, 
   {{0xa5082871,0x229003af,0x00000000,0x00000000}},	//   репа_, wák_, --, --, 
   {{0xdb0c0964,0x22900724,0x22500212,0xe2900272}},	//   _sabé, ták_, ízko_, وذج_, 
   {{0x23280332,0xd5ac17ab,0xdb0c2872,0x65942873}},	//   рони_, رفی_, _pabé, _мажу, 
   {{0x22902868,0x63ac028a,0x36340272,0x1b140143}},	//   rák_, _ɗany, _فرنس, থেকে_, 
   {{0x22901a31,0x66082874,0x94c800e2,0x20d40023}},	//   sák_, mnek, _ناوې_, цінс, 
   {{0xa2e42875,0x64582876,0x3eb80473,0x00000000}},	//   _молд, _itwi, tvrt_, --, 
   {{0x66082877,0xdb0c008f,0x229003af,0xc0d4001d}},	//   onek, _tabé, qák_, _ያውም_, 
   {{0x628000e9,0x3f980126,0x9db802ba,0x00000000}},	//   mrlo, sfru_, шыгу_, --, 
   {{0x66082878,0x25e000a1,0x9f34024b,0x7dd801ca}},	// [2440] inek, _ओकनी_, сеңі, _dísp, 
   {{0xc17401e7,0x62802879,0xd9e00d5b,0x6608287a}},	//   _doɗe_, orlo, पस्ट, hnek, 
   {{0x6608287b,0x644c00a8,0x00000000,0x00000000}},	//   knek, _ũail, --, --, 
   {{0x6608287c,0x18a40302,0xac080329,0x6458287d}},	//   jnek, жадм, анӡа_, _otwi, 
   {{0x6458287e,0xdce401d1,0x7dd801f1,0x62800e48}},	//   _ntwi, _kekč, _uísq, hrlo, 
   {{0x660801a7,0x6280018f,0x96100c14,0xe51c0030}},	//   enek, krlo, डक्ट_, _पड़ि_, 
   {{0x6458287f,0x660808c2,0x8b200fca,0x070400dd}},	//   _atwi, fnek, _ждре, يڊمي_, 
   {{0xd4982880,0xdef402b4,0xfa24011a,0x66082881}},	//   аро_, _ዎያነ_, _འཚིན_, gnek, 
   {{0x6280002a,0xb548001e,0x00000000,0x00000000}},	//   erlo, аҧҵа_, --, --, 
   {{0x6608018c,0x4f880020,0x28100108,0x00000000}},	//   anek, ንቀቕታ_, _كۈنس, --, 
   {{0x9f58059e,0x645801d5,0x66080865,0xb6c40182}},	//   _impè_, _etwi, bnek, _хөлд, 
   {{0x60c02882,0xd5a40324,0x00000000,0x00000000}},	//   _šoma, _گلچی, --, --, 
   {{0x62802883,0x4dd01eff,0x682c0272,0xc0e40007}},	//   arlo, সসমূ, lúda, доўк, 
   {{0x09c42884,0x95c001ac,0x00000000,0x00000000}},	//   _रच्य, _ريڙه, --, --, 
   {{0x2bc80474,0x2ee40270,0x00000000,0x00000000}},	//   रासा, álf_, --, --, 
   {{0x2bdc03bf,0x00000000,0x00000000,0x00000000}},	//   _यवहा, --, --, --, 
   {{0x7dd82885,0x20180038,0x9f4801d5,0x00000000}},	// [2450] _vísp, ófið_, libý_, --, 
   {{0x80a42886,0x66082887,0x660c01f6,0xbc680075}},	//   _کمین, znek, čaki, تمكن_, 
   {{0x66082888,0x00000000,0x00000000,0x00000000}},	//   ynek, --, --, --, 
   {{0xdd9013a1,0x2bc81aed,0x423800cf,0xa9342889}},	//   _كوپ_, राहा, ַנגל_, пееш, 
   {{0x6608288a,0x48a8006b,0x7ff40e14,0x00000000}},	//   vnek, ртем_, _رسیا, --, 
   {{0xa7a8012b,0x66080126,0xdd38023c,0x00000000}},	//   скка_, wnek, _לערכ, --, 
   {{0x6458002f,0xdb0c034a,0x6608288b,0xd90c00e2}},	//   _stwi, _jabì, tnek, نیې_, 
   {{0x2bc80325,0x9f58059e,0x97300324,0x628001d4}},	//   रावा, _empè_, رکلا, vrlo, 
   {{0x64c400ea,0x634c00f2,0x00000000,0x00000000}},	//   سيدل, _nőné, --, --, 
   {{0x6608288c,0xe284288d,0x682c02d9,0x46601afb}},	//   snek, плои, búda, _قۇتق, 
   {{0xdce40078,0x62800cec,0x394001f6,0xa5f80129}},	//   _rekč, urlo, žist_, _лежу_, 
   {{0x66080d2e,0x6280288e,0xdce402aa,0x61441194}},	//   qnek, rrlo, _sekč, яема, 
   {{0x6458288f,0xe3642890,0x00000000,0x00000000}},	//   _utwi, _екли, --, --, 
   {{0xdfd02891,0xe3b02892,0x00000000,0x00000000}},	//   ريز_, _سرت_, --, --, 
   {{0x46a80021,0xb804004f,0x929003a7,0x00000000}},	//   चबिह, _anṛś, _зајц, --, 
   {{0x634c00e3,0x127800cf,0x00000000,0x00000000}},	//   _főné, _האקע, --, --, 
   {{0x0d800094,0x00000000,0x00000000,0x00000000}},	// [2460] элтн, --, --, --, 
   {{0x61e4018c,0x682c02b1,0x00000000,0x00000000}},	//   lkkl, yúda, --, --, 
   {{0x34a819f1,0xdb0c002a,0x9f0410a4,0x00000000}},	//   _कन्द, _unbü, _روحو, --, 
   {{0x61e40aea,0x00000000,0x00000000,0x00000000}},	//   nkkl, --, --, --, 
   {{0x39402893,0x2bc80674,0x61e403f4,0x48e00741}},	//   äis_, राशा, ikkl, ноцв, 
   {{0xdb0c0839,0x682c03b2,0xd7300182,0x88900123}},	//   _habí, túda, ндлө, хишх, 
   {{0xdb0c02cc,0x690402df,0x2bc821b9,0x00000000}},	//   _kabí, _ərdə, रारा, --, 
   {{0xceb00107,0x682c0075,0xd5b802dc,0x00000000}},	//   תיה_, rúda, ёсй_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x61e40618,0x325402dc,0x00000000,0x00000000}},	//   ekkl, мвор, --, --, 
   {{0x27e00104,0xe6c40075,0xc7b000ca,0x00000000}},	//   öhne_, _يتمي, _רבע_, --, 
   {{0xdb0c02d2,0x290c00e9,0x741400dd,0xa2c00197}},	//   _nabí, škaš_, _ڪوتا, тәшк, 
   {{0x4fc41166,0x932400d5,0x7bc800d3,0x00000000}},	//   псва, _کرشن, _òduw, --, 
   {{0x7414232b,0xdfd000e2,0x853800ca,0x00000000}},	//   _توتا, نيټ_, _הגדי, --, 
   {{0xef1000e7,0xa3b40a53,0xdb0c00c0,0xca682894}},	//   түнө, _चोट_, _babí, мiнi, 
   {{0xdb0c2895,0x61e42896,0x645c059b,0x00000000}},	//   _cabí, ckkl, ísig, --, 
   {{0x4fc40329,0x2bc82897,0xb0140294,0xebd8041c}},	// [2470] _есна, राला, _омиљ, одаш_, 
   {{0x645c00cf,0xed5800ec,0x00000000,0x00000000}},	//   ŭsig, соҡ_, --, --, 
   {{0xdb0c01f1,0xba742898,0x9f500207,0x00000000}},	//   _fabí, فانت, äbåt_, --, 
   {{0xfcf8001d,0x6c5402ba,0x00000000,0x00000000}},	//   ጋግጡ_, _окму, --, --, 
   {{0x2038010f,0xf9902899,0xa888021d,0x8cc4044a}},	//   _በህብረ, ابم_, ійка_, _хĕлĕ_, 
   {{0x8d74289a,0xdb0c2095,0x00000000,0x00000000}},	//   _باھا, _zabí, --, --, 
   {{0xdce40025,0xb8d40076,0x61e4036d,0xb6580023}},	//   _iekā, _छै_, ykkl, пшых_, 
   {{0xe458289b,0x3e5800ef,0x00000000,0x00000000}},	//   ожи_, _učte_, --, --, 
   {{0x69c8289c,0xdce40062,0xc744289d,0xef180098}},	//   _inee, _kekā, _فضاي, ęży_, 
   {{0x69c801ba,0x60c0289e,0xf794289f,0xa2e41bb5}},	//   _hnee, _šomo, _пауэ, доод, 
   {{0x9f580186,0x69c8027e,0x682c02d9,0xd260012b}},	//   _umpé_, _knee, lúdo, ккэй, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2508229b,0xc0c80046,0x61e428a0,0xdb0c012b}},	//   _برای_, سېده_, rkkl, _rabí, 
   {{0xdb0c28a1,0xdce40025,0x94240340,0x660c14ba}},	//   _sabí, _nekā, _قونۇ, čaku, 
   {{0x69c828a2,0x4da80108,0x5dd80074,0x00000000}},	//   _onee, ﺷﻠﯩﻨ, офар_, --, 
   {{0x7f7c0256,0x69c828a3,0xfcf8001d,0x00000000}},	//   ﺌﻴل_, _nnee, ጋግጥ_, --, 
   {{0x205404e7,0x3d280324,0x5f08025c,0x1c4428a4}},	// [2480] _ўтир, ستری_, _सशक्_, днам, 
   {{0x69c828a5,0x9f4828a6,0x5f7428a7,0x00000000}},	//   _anee, ribó_, _کاکر, --, 
   {{0x684c02b4,0xdce400ce,0xdb0c0087,0x00000000}},	//   _ንሰለስ, _dekā, _tabí, --, 
   {{0x9f480770,0x09e0018f,0x00000000,0x00000000}},	//   cibò_, кохн, --, --, 
   {{0x28a803ea,0xdce400e0,0xd9ac03ef,0x00000000}},	//   चौलि, _fekā, _घसीट, --, 
   {{0x69c828a8,0xc9500329,0x682c01d4,0x00000000}},	//   _enee, нтәы, súdn, --, 
   {{0xdb0c0239,0x7bdc0075,0x3c340207,0x00000000}},	//   _wabâ, _ioru, rävd_, --, 
   {{0x7bdc28a9,0xc8800397,0xdb2004db,0x69c8006f}},	//   _horu, üğü_, _ñuñu, _gnee, 
   {{0x7bdc28aa,0xdb0c00b7,0xb8f40095,0x00000000}},	//   _koru, _fabã, _koṭī, --, 
   {{0x7bdc28ab,0x3a24000d,0xbbdc0098,0x00000000}},	//   _joru, _hkmp_, _मकोक, --, 
   {{0x7bdc28ac,0xbbdc00bd,0x00000000,0x00000000}},	//   _moru, _मकैक, --, --, 
   {{0x7bdc28ad,0x15b0006e,0x2d8c038a,0x550428ae}},	//   _loru, _شەخس, _ñeex_, _очла, 
   {{0xdb0c0078,0xf1f401a7,0xc0580049,0x7bdc0528}},	//   _labà, _үзлэ, діс_, _ooru, 
   {{0x7bdc28af,0x00000000,0x00000000,0x00000000}},	//   _noru, --, --, --, 
   {{0x682c0010,0xff040027,0x00000000,0x00000000}},	//   dúdl, вятн, --, --, 
   {{0xb814007e,0x7094021b,0xf07801a0,0xdce400ce}},	//   িতিত_, _заиф, _ейиш_, _sekā, 
   {{0x7bdc28b0,0x682c00c4,0xdd140128,0x25a80029}},	// [2490] _boru, fúdl, ептө, _ñale_, 
   {{0x7bdc28b1,0x5f1828b2,0x0ae828b3,0x00000000}},	//   _coru, _मुक्_, يراي_, --, 
   {{0xdb0c28b4,0xe56801d4,0x3f1400e5,0x00000000}},	//   _cabà, _líšč, _адэс, --, 
   {{0x7bdc0d8e,0xdb0c0111,0xc330047b,0xa874024b}},	//   _eoru, _sabã, דוע_, елді, 
   {{0xfcf80020,0x3b540320,0x00000000,0x00000000}},	//   ጋግጾ_, икăр, --, --, 
   {{0xfe700324,0x682c01d4,0x7b440108,0x00000000}},	//   _حدی_, rúdo, رئەل, --, 
   {{0x26c002d2,0x683401ec,0x48fc28b5,0x9aa00012}},	//   ího_, _aýdý, _शेरो_, _مۅلو, 
   {{0x7bdc0397,0x69c828b6,0xfcf80422,0x79a402eb}},	//   _zoru, _unee, ጋግጽ_, _ируе, 
   {{0x7bdc28b7,0x543400cd,0xa96801c8,0x2d0c006c}},	//   _yoru, کرٹر, _миңа_, _सखोल_, 
   {{0x62640254,0xd4040012,0x3834012b,0xdb0c00d5}},	//   нвоа, ى۪نم_, _анур, _habá, 
   {{0xdb0c19ba,0xa2e428b8,0xe50800ea,0x00000000}},	//   _kabá, хонд, تيکو_, --, 
   {{0xbbdc0774,0xe1f028b9,0x00000000,0x00000000}},	//   _मक्क, اسد_, --, --, 
   {{0x64a428ba,0x25ac28bb,0x17b00252,0xc4f828bc}},	//   _чала, meel_, চাৰি, _بعضا_, 
   {{0xd24c00a3,0x25ac28bd,0xdb0c0479,0x00000000}},	//   _ڏنو_, leel_, _inbö, --, 
   {{0x5f1803c3,0x248c28be,0x7bdc28bf,0x00000000}},	//   _मुख्_, luem_, _roru, --, 
   {{0x7bdc28c0,0x25ac28c1,0xdb0c0b0a,0x9f5801ca}},	//   _soru, neel_, _nabá, _impí_, 
   {{0x7bdc28c2,0x248c28c3,0x10a000fc,0x6ab401b8}},	// [24a0] _poru, nuem_, _биын, _aszf, 
   {{0x25ac28c4,0x7bdc0c60,0x1f6415a7,0xce440182}},	//   heel_, _qoru, _яком, _үзье_, 
   {{0xdb0c28c5,0x7bdc28c6,0x25ac28c7,0x682c28c8}},	//   _babá, _voru, keel_, rúdl, 
   {{0x7bdc28c9,0x25ac28ca,0xd7080937,0xdb0c01ca}},	//   _woru, jeel_, үнде_, _cabá, 
   {{0x25ac28cb,0x05d000bd,0x00000000,0x00000000}},	//   deel_, थानब, --, --, 
   {{0xeff00422,0xdb0c02ba,0xd6d8172f,0x7bdc0379}},	//   _ፍቓድ_, _tabà, зти_, _uoru, 
   {{0x25ac175c,0xdb0c000f,0x21e002e8,0xd6ac0143}},	//   feel_, _fabá, _jóhs_, কম্প, 
   {{0xdb0c03af,0x25ac175c,0x0f340100,0x00000000}},	//   _gabá, geel_, ערקט_, --, 
   {{0x248c28cc,0xd40428cd,0x25e000a1,0x998402e3}},	//   guem_, еяни, _ओकरी_, lloů_, 
   {{0x0900038e,0xd37828ce,0xdb0c28cf,0x00000000}},	//   _спун, ччи_, _zabá, --, 
   {{0x25ac28d0,0x7dd80191,0x454000c3,0xf4840210}},	//   beel_, _dísz, نچۇق, راکی, 
   {{0x7a380a03,0x248c0111,0x25ac0012,0xfcf80020}},	//   sítf, buem_, ceel_, ጋግጹ_, 
   {{0x0fe00128,0x644c004f,0x00000000,0x00000000}},	//   гөнү, _ũaiv, --, --, 
   {{0xc32c28d1,0x00000000,0x00000000,0x00000000}},	//   _گەپ_, --, --, --, 
   {{0xdb0c00d3,0x00000000,0x00000000,0x00000000}},	//   _àkèy, --, --, --, 
   {{0xc32c1a05,0x5678010f,0x42700668,0x00000000}},	//   _دەپ_, _አይነቱ_, _сгъс, --, 
   {{0xb03400fc,0xcb840106,0x00000000,0x00000000}},	// [24b0] _иниш, ећеп, --, --, 
   {{0xdb0c054b,0x59c428d2,0x4f6800cc,0x00000000}},	//   _sabá, _रोबर, _эшим_, --, 
   {{0x25ac28d3,0xfc300075,0x248c02bb,0x00000000}},	//   yeel_, صحك_, zuem_, --, 
   {{0x25ac175c,0x00000000,0x00000000,0x00000000}},	//   xeel_, --, --, --, 
   {{0x25ac0afe,0x79800d13,0x6d5c0110,0x67d40302}},	//   veel_, _ddmw, _ifsa, коду, 
   {{0x25ac28d4,0x6d5c0083,0x7d000270,0x248c0337}},	//   weel_, _hfsa, _ýmsa, vuem_, 
   {{0x25ac28d5,0xdb0c28d6,0x6e2c28d7,0xd6cc0128}},	//   teel_, _tabá, olab, ققو_, 
   {{0x6e2c28d8,0x2bc828d9,0x248c28da,0xc6a40182}},	//   nlab, राका, tuem_, _үржи, 
   {{0x25ac1420,0x6e2c28db,0x00000000,0x00000000}},	//   reel_, ilab, --, --, 
   {{0x6e2c26f6,0xeff00020,0x25ac0029,0x248c28dc}},	//   hlab, _ፍቓዱ_, seel_, ruem_, 
   {{0x6d5c28dd,0x25ac05ab,0x233402dc,0x248c28de}},	//   _ofsa, peel_, ъхир, suem_, 
   {{0x69d828df,0x25ac08cf,0x64c40075,0xd09802a0}},	//   njwe, qeel_, _ليصل, lçəy, 
   {{0xdd9028e0,0x656828e1,0x248c28e2,0x6e2c28e3}},	//   یوس_, mbeh, quem_, dlab, 
   {{0x656828e4,0x6e2c28e5,0x6d5c28e6,0x7a3828e7}},	//   lbeh, elab, _afsa, míte, 
   {{0x6e2c28e8,0x7a3828e9,0x00000000,0x00000000}},	//   flab, líte, --, --, 
   {{0xa6e80710,0x656828ea,0xdca40121,0x205428eb}},	//   _trươ, nbeh, каби, _итор, 
   {{0x7a3828ec,0x442428ed,0x3ba400f8,0xa3e400b3}},	// [24c0] níte, _kkn_, ллаҳ, _नवा_, 
   {{0x26c40074,0x6e2c28ee,0x6d5c0333,0x2bc80523}},	//   _orlo_, alab, _efsa, रागा, 
   {{0x7a380306,0x00000000,0x00000000,0x00000000}},	//   híte, --, --, --, 
   {{0x6e2c28ef,0x442428f0,0x588428f1,0x656828f2}},	//   clab, _lkn_, выка, jbeh, 
   {{0x26c401a7,0x656828f3,0xadc4006e,0x38600335}},	//   _arlo_, dbeh, _саяһ, ëir_, 
   {{0x6568018b,0x79800379,0xfc04012b,0x00000000}},	//   ebeh, _wdmw, _согү, --, 
   {{0xa3d4147e,0x65680618,0x787800d5,0x33740108}},	//   हान_, fbeh, _búvá, ңгир, 
   {{0x44240062,0x23680091,0x656828f4,0x09e028f5}},	//   _akn_, _đaja_, gbeh, _косн, 
   {{0x7a3800cd,0x442428f6,0x26c401aa,0x09e010fb}},	//   gíte, _bkn_, _erlo_, _тотн, 
   {{0x6e2c28f7,0xdcf40055,0xb458001d,0x00000000}},	//   zlab, neyı, _ካደረጉ, --, 
   {{0x6e2c28f8,0x26c42200,0x442428f9,0x65681dc2}},	//   ylab, _grlo_, _dkn_, bbeh, 
   {{0x8500018f,0x4424013c,0x20ac006c,0x00000000}},	//   اوین, _ekn_, टबंध, --, 
   {{0xf0e81ba6,0xdb0c019f,0x442428fa,0x661003b5}},	//   رىسى_, _habä, _fkn_, _دژوا, 
   {{0x6e2c01ca,0x741401d2,0x00000000,0x00000000}},	//   wlab, _حوتا, --, --, 
   {{0x6e2c28fb,0x00000000,0x00000000,0x00000000}},	//   tlab, --, --, --, 
   {{0x518428fc,0x6e2c01d6,0x00000000,0x00000000}},	//   _рука, ulab, --, --, 
   {{0x6e2c28fd,0x4424227b,0x3178172a,0x201c0296}},	// [24d0] rlab, _ykn_, masz_, ōtia_, 
   {{0x317800e8,0x6e2c28fe,0xa3d428ff,0x65682900}},	//   lasz_, slab, हाय_, zbeh, 
   {{0xdb0c0239,0x1620057d,0x69d81efb,0x6e2c00e3}},	//   _nabä, मवार_, tjwe, plab, 
   {{0x60c00f3d,0x31781720,0xbd04012c,0x6b5800f2}},	//   _šomi, nasz_, _sféř, _búgó, 
   {{0xa7a82901,0x682c00b7,0xbb2c0121,0xa3d406de}},	//   екла_, lúdi, ﻧﻨﻰ_, हाम_, 
   {{0xe7382902,0x7640006f,0xdbd000fc,0xa69401c3}},	//   нел_, emmy, _küýs, гриј, 
   {{0x65682903,0x31782904,0x2d9801dc,0xe5a40121}},	//   tbeh, kasz_, _kcse_, гийи, 
   {{0x26c40b53,0x44242905,0xdb0c0932,0x656801ed}},	//   _vrlo_, _skn_, _dabä, ubeh, 
   {{0x65682906,0x3178002f,0x7dcc012b,0x74f80182}},	//   rbeh, dasz_, _mösе, вээс_, 
   {{0x7a382907,0x2cb80a65,0x76400616,0x26c401d1}},	//   ríte, _mssd_, ammy, _trlo_, 
   {{0x26c40668,0x7a380a56,0x2d980074,0xa91c091d}},	//   _urlo_, síte, _ocse_, _udžb, 
   {{0x7a382908,0x4424195c,0x65680428,0x7e7c01c6}},	//   píte, _wkn_, qbeh, vsrp, 
   {{0x44242909,0xbb6c0121,0x10a00b0e,0xb5c8005e}},	//   _tkn_, _ﺷﯘﯕﺎ_, биян, _جونم_, 
   {{0x25bc290a,0x6608290b,0x44240105,0xdbd00101}},	//   _hawl_, liek, _ukn_, _büýs, 
   {{0x6440290c,0x53980107,0x9f9400b6,0xdb0c006b}},	//   mmli, _ניקו, müük_, _xabä, 
   {{0x660811b0,0xe1f017ab,0x2d980078,0x31780098}},	//   niek, _دست_, _ccse_, casz_, 
   {{0xd00c0046,0x2cb801d5,0x25bc03c7,0x9f340049}},	// [24e0] _ډلي_, _cssd_, _mawl_, теңі, 
   {{0x6440290d,0x2d980177,0x6608290e,0x9a9c0049}},	//   nmli, _ecse_, hiek, зудi, 
   {{0xdee4290f,0x66082910,0x20082911,0x682c00bf}},	//   _сони, kiek, mibi_, cúdi, 
   {{0x20082912,0xceb0007c,0x64402913,0x660803f4}},	//   libi_, _פיר_, hmli, jiek, 
   {{0x7a1c00aa,0x2cb802e3,0xdbd000b6,0xdb0c012b}},	//   jčte, _gssd_, _küüs, _sabä, 
   {{0xc8c42914,0x31780098,0x00000000,0x00000000}},	//   اوون_, zasz_, --, --, 
   {{0x645c2830,0x66082915,0x25bc2916,0xdbd00030}},	//   ísin, fiek, _bawl_, _müüs, 
   {{0x20082917,0xd9442918,0x64400c12,0x66082919}},	//   hibi_, _беби, emli, giek, 
   {{0x2008291a,0x7794049d,0x25bc0037,0x317801b8}},	//   kibi_, _نیشا, _dawl_, vasz_, 
   {{0x20081aa0,0x64400243,0x31780098,0x3374291b}},	//   jibi_, gmli, wasz_, шгор, 
   {{0x1664005b,0x6608291c,0x25bc145f,0x44f022e9}},	//   _свем, biek, _fawl_, لسیز, 
   {{0x6440291d,0x6608002f,0x25bc0335,0xe6840108}},	//   amli, ciek, _gawl_, _тәшк_, 
   {{0x3dc0009c,0x657c0b7c,0x69d403eb,0x31780bfd}},	//   ddiw_, ðshe, णाती, rasz_, 
   {{0x682c291e,0x200803af,0x386401d5,0x5338044a}},	//   túdi, gibi_, _mtmr_, _пуйă, 
   {{0x2b5001f6,0x25bc0177,0xdbd0013c,0x2bc821dc}},	//   _rgzc_, _yawl_, _düüs, राघा, 
   {{0xa3d402a4,0x7054291f,0x682c01d4,0x00000000}},	//   हाथ_, _پندا, rúdi, --, 
   {{0x20082920,0x1ae000ac,0xdbd000a1,0xa91c0473}},	// [24f0] bibi_, _গেলে_, _füüs, _odža, 
   {{0x66082921,0x20082922,0x682c01f1,0xdbd002e6}},	//   ziek, cibi_, púdi, _tüýs, 
   {{0xa3d42923,0x7ff400e2,0xdb0c0223,0xaed42924}},	//   हात_, _دسيا, _àkìy, _тонш, 
   {{0xa91c01d1,0x69d40ccc,0x8c5400e7,0x6608000b}},	//   _adža, णाधी, _مئسا, xiek, 
   {{0x9f480278,0x25bc018c,0x69241be0,0x64400616}},	//   _ùjòn_, _rawl_, јмла, ymli, 
   {{0x25bc009c,0x660806f7,0x5ea001b5,0xa264000d}},	//   _sawl_, wiek, _دۅہل, _buộ, 
   {{0x66082925,0x25bc2926,0xa2640048,0x00000000}},	//   tiek, _pawl_, _cuộ, --, 
   {{0x20082927,0x7eac02eb,0x25bc2928,0x766800e2}},	//   zibi_, _höpö, _qawl_, اینې_, 
   {{0xfa342929,0x200804ba,0xe8580668,0x67d40106}},	//   _طرفد, yibi_, _разш_, _коау, 
   {{0x6608292a,0x200814c5,0x7a38292b,0x13e42478}},	//   siek, xibi_, míta, имый_, 
   {{0x2168292c,0x6608292d,0x7a380191,0x6fb80560}},	//   кини_, piek, líta, _བལྟའ, 
   {{0x7eac0139,0xdbd0013c,0x6144292e,0x00000000}},	//   _löpö, _süüs, иена, --, 
   {{0x2008292f,0x0464009e,0x9f9400af,0xa3d426ee}},	//   tibi_, _стем, püük_, हाद_, 
   {{0xdb0c00c4,0x248c2930,0x7eac0139,0xdd9000dd}},	//   _cabû, mrem_, _nöpö, ڪور_, 
   {{0x20082931,0x248c0085,0x5de42932,0x925401f1}},	//   ribi_, lrem_, ажва, _кајт_, 
   {{0x06ac2933,0x248c044f,0x20082934,0x99841c1d}},	//   কিপি, orem_, sibi_, kloš_, 
   {{0x248c060f,0xb164002c,0xdd94024b,0x61f402b0}},	// [2500] nrem_, _уныһ, лаңы, _ilyl, 
   {{0x907800b9,0xdfb804c3,0x248c28b4,0x200809a2}},	//   _שטיי, _شاخص_, irem_, qibi_, 
   {{0x248c2935,0x2c001df1,0xdcf40078,0x00000000}},	//   hrem_, чүрм, mayč, --, 
   {{0x248c2936,0xdd200513,0x18682937,0xdb0c2938}},	//   krem_, _cîţi, вади_, _kabú, 
   {{0xd7f82939,0xdb0c00c4,0x6c300191,0x7c3c0475}},	//   кук_, _jabú, _کہلا, _thrr, 
   {{0xda64293a,0x248c27a8,0xdcf40078,0xcb64044a}},	//   _ناري, drem_, nayč, _варе_, 
   {{0x248c293b,0x69c00030,0x00000000,0x00000000}},	//   erem_, _रोकी, --, --, 
   {{0x248c293c,0xd87414d0,0x7a38293d,0x00000000}},	//   frem_, _نائب, bíta, --, 
   {{0x248c0fd8,0x7a3801c8,0x91800048,0xdb0c00c0}},	//   grem_, cíta, _nếu_, _nabú, 
   {{0x38a0197c,0x53e4293e,0x61f40101,0x00000000}},	//   mòr_, рциа, _alyl, --, 
   {{0x248c293f,0x4b780282,0x61f4036d,0xd5b82940}},	//   arem_, כטיג, _blyl, _асл_, 
   {{0x248c2941,0x20180105,0x506402ac,0x94a82942}},	//   brem_, _ajpi_, итга, _атка_, 
   {{0xfeb82943,0xdb0c00cc,0x248c02bf,0x38a0007f}},	//   یافت_, _cabú, crem_, nòr_, 
   {{0xf778011a,0xddc403bf,0x00000000,0x00000000}},	//   _jeħ_, _nikł, --, --, 
   {{0x61f42944,0xf778011a,0x38a001d6,0x7eac2321}},	//   _flyl, _meħ_, hòr_, _röpö, 
   {{0x4f940551,0xb3980090,0xd24c03a2,0xf778011a}},	//   ырҭу, _ጉዳዩን_, _کنڊ_, _leħ_, 
   {{0x7eac2722,0xd7c400b3,0x32082945,0x8b640f5f}},	// [2510] _pöpö, लयाच, _imay_, لاام, 
   {{0x6fb408c9,0x7a382946,0x38a0007f,0x0a68030d}},	//   _امدا, víta, dòr_, врди_, 
   {{0x05340422,0xdb0c02cc,0x248c01d4,0x00000000}},	//   _ብድሕሪ, _zabú, zrem_, --, 
   {{0xc9842947,0x9f580027,0x248c2948,0xc33000ca}},	//   ружи, _empä_, yrem_, קוף_, 
   {{0x38a0052b,0x320803fa,0x7eac0139,0x7eb00078}},	//   gòr_, _mmay_, _töpö, pòpò, 
   {{0x645c2949,0x320801a0,0x248c294a,0x7a38294b}},	//   ísim, _lmay_, vrem_, ríta, 
   {{0x7a38294c,0xa3d4058a,0x2cb4294d,0x320806e2}},	//   síta, हास_, şadı_, _omay_, 
   {{0x248c294e,0xff1810bc,0x3208025e,0x76c40121}},	//   trem_, יקות_, _nmay_, زغىل, 
   {{0xe28412fe,0x248c24de,0xd1e80b22,0xd90c00dd}},	//   әлми, urem_, ቆናት_, _ٻڌن_, 
   {{0x3208294f,0x248c2950,0x00000000,0x00000000}},	//   _amay_, rrem_, --, --, 
   {{0x85b80012,0xefe4001d,0x00000000,0x00000000}},	//   _لاشس_, _ማሟያ_, --, --, 
   {{0x248c2951,0xa0682952,0x682c0075,0x547001ac}},	//   prem_, лама_, rúdu, _کٿور, 
   {{0x201800b7,0x10a02953,0x00000000,0x00000000}},	//   _pjpi_, пиян, --, --, 
   {{0x3208147c,0xe2982954,0x657800a2,0x64580249}},	//   _emay_, _бак_, _hewh, _iuwi, 
   {{0x64582955,0x229403e0,0x65780299,0x27e40479}},	//   _huwi, _العس, _kewh, _moln_, 
   {{0x64582956,0xdb0c02ba,0x2fc00031,0x61f40101}},	//   _kuwi, _tabú, _eahg_, _ulyl, 
   {{0x64582957,0x62802958,0x14602959,0x5ba8295a}},	// [2520] _juwi, lslo, _kọọp, лкам_, 
   {{0x6280295b,0x181400cb,0x6458295c,0x588401c4}},	//   oslo, _तदेव_, _muwi, ҡыла, 
   {{0x6280295d,0x6458295e,0x3208147c,0xcf540240}},	//   nslo, _luwi, _ymay_, _לבית_, 
   {{0x6578295f,0x5ca40241,0xdca4288d,0x38a0052b}},	//   _newh, _лимб, _лами, tòr_, 
   {{0x64582960,0x00000000,0x00000000,0x00000000}},	//   _nuwi, --, --, --, 
   {{0x5bf4004b,0xacb000c3,0xa29819ef,0x00000000}},	//   _آسا, _تەكب, _ጉባኤን_, --, 
   {{0x466408f6,0xdb0c0537,0x6fd8006c,0x00000000}},	//   брым_, _àkày, मातू, --, 
   {{0x64582961,0x62802962,0x38a0052b,0x8e780100}},	//   _buwi, dslo, pòr_, אנקה, 
   {{0xf3f80476,0x7a380191,0x62802963,0x657c0009}},	//   иниш_, líto, eslo, ðsha, 
   {{0x64582964,0x27e40181,0x6d400237,0x320802b0}},	//   _duwi, _goln_, _ŝlak, _smay_, 
   {{0x02a02965,0x73342966,0x7a3801b8,0x56f00182}},	//   прям, تىدا, níto, _хүйс, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x645802b1,0xfbc80095,0x682c01d4,0x20e002bb}},	//   _guwi, रयाम, múdr, vçiç_, 
   {{0xb4e42967,0xb4d400b3,0x136802ac,0x7a380191}},	//   नही_, हमी_, _ёшли_, kíto, 
   {{0xa3d402d7,0x320801a0,0x64580104,0x6280015e}},	//   हार_, _tmay_, _zuwi, cslo, 
   {{0x32082968,0x6458008f,0x6aa001c8,0x7a382969}},	//   _umay_, _yuwi, _älfi, díto, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2530] --, --, --, --, 
   {{0xf1a4231f,0x9f480151,0x2d9c011a,0x30141123}},	//   ग्रन, ñjãb_, żwe_, _фдор, 
   {{0xd1d800a7,0x4ea40128,0xb4e400b6,0xf1dc0095}},	//   _ፖስት_, _урпа, नहु_, यापन, 
   {{0x2bf4006c,0x645c02e8,0x80a40061,0x00000000}},	//   _इतकं_, ísik, _بمین, --, 
   {{0x65780341,0x27e40c91,0x57b400c3,0xc98401a0}},	//   _rewh, _poln_, ﺸﻠﯩﺮ, _қуви, 
   {{0x6280296a,0x60c0007f,0x8b6400e2,0xd8840012}},	//   yslo, _âome, _داحم, تھِن_, 
   {{0x6458296b,0xe738296c,0x7aa4172d,0x65780341}},	//   _suwi, шек_, _ниёз, _pewh, 
   {{0x6458296d,0xdb0c0353,0x00000000,0x00000000}},	//   _puwi, _rabø, --, --, 
   {{0x6aa42626,0xa3d4277b,0x645803c0,0xf1dc00cb}},	//   lthf, हाल_, _quwi, यानन, 
   {{0x6280296e,0xdcf400cb,0xe28423ff,0x00000000}},	//   tslo, nayā, олои, --, 
   {{0x6578296f,0x6aa42970,0x00000000,0x00000000}},	//   _tewh, nthf, --, --, 
   {{0x64582971,0x6aa42972,0xdcf400cb,0xe50800dd}},	//   _tuwi, ithf, hayā, _پيتو_, 
   {{0x24182973,0x62802974,0x6458025e,0x316c21c2}},	//   _коды_, sslo, _uuwi, ñeza_, 
   {{0x62802975,0x7d000038,0xdcf400cb,0x00000000}},	//   pslo, _ýmsi, jayā, --, 
   {{0xe2982976,0xdcf400cb,0x21a40937,0x4f380012}},	//   _тай_, dayā, _дийм, لتِھ_, 
   {{0xdee402dc,0x5d6820b4,0x00000000,0x00000000}},	//   боҳи, риам_, --, --, 
   {{0x10a00041,0x9c6401d9,0x8ff800dd,0x00000000}},	// [2540] _жиын, زهاو, _چرپر_, --, 
   {{0x602400c8,0xb0682977,0x682c03aa,0xefcc0020}},	//   _єдна, _اصيل_, zúdr, _ኣሎዶ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3d42978,0xf1dc00cb,0x7a3801b8,0x75fc00d5}},	//   हाँ_, यायन, ríto, _kéze, 
   {{0x7a3800cd,0x41ac0474,0xb8f400a8,0x38c80061}},	//   síto, ट्यस, _maṇī, ڤاڵی_, 
   {{0x7a382979,0x75fc00d5,0x5de0024b,0xac940061}},	//   píto, _méze, _ﺇﻗﻠﻴ, _رۆما_, 
   {{0x75fc01b8,0xf1dc0add,0xe1c80098,0x00000000}},	//   _léze, यामन, ियाघ, --, 
   {{0x95c8297a,0xc9c40046,0xf8b800fc,0x00000000}},	//   рука_, _وژنه_, _гөк_, --, 
   {{0xa3d40224,0x75fc00cd,0xb1140143,0x00000000}},	//   हां_, _néze, _সর্ব_, --, 
   {{0xaf7002b4,0x00000000,0x00000000,0x00000000}},	//   እታትና_, --, --, --, 
   {{0x3218069c,0xc80400e2,0x5fdc297b,0x0bb400ca}},	//   tnsy_, _بښنه_, मानल, חלים_, 
   {{0xf4840061,0xb9e4001d,0x00000000,0x00000000}},	//   _فاتی, _የአ_, --, --, 
   {{0x4fc42147,0x201c01e3,0xf4842114,0x00000000}},	//   осва, еti_, _راشی, --, 
   {{0x75fc01ab,0x6aa40086,0xa3d40803,0x2d840201}},	//   _déze, ythf, हाः_, _śle_, 
   {{0x15ec00a1,0x403402d1,0x7a3802e8,0xfb0000ce}},	//   _जवार_, ферс, títl, _šūnu_, 
   {{0xc3301098,0x02f811e7,0xc4800b4c,0x8d7413be}},	//   _קוק_, _כלומ, _эләк, تاسا, 
   {{0x3014297c,0xdcf400cb,0x75fc00e3,0xd1d8001d}},	// [2550] _ндир, tayā, _kézb, _ፖስታ_, 
   {{0x0f800012,0x91a408e5,0xebc40152,0x5f04040e}},	//   _زیرُ, ट्रै, чәмн, _हेक्_, 
   {{0xca3008e6,0xdcf400cb,0xdd900046,0x6aa40116}},	//   _ﺯﻭﺭ_, rayā, _ګوټ_, uthf, 
   {{0x6aa4297d,0x7a380191,0x67fc00d3,0x6fd8006c}},	//   rthf, lítj, _mèje, मावू, 
   {{0x6e2c297e,0xdcf400cb,0xb86400ea,0x00000000}},	//   moab, payā, واوو, --, 
   {{0x97c0297f,0x00000000,0x00000000,0x00000000}},	//   ейше, --, --, --, 
   {{0x98f40121,0x00000000,0x00000000,0x00000000}},	//   يغۇچ, --, --, --, 
   {{0x3e3c001d,0x00000000,0x00000000,0x00000000}},	//   _በእነር, --, --, --, 
   {{0xa5080254,0x00000000,0x00000000,0x00000000}},	//   сепа_, --, --, --, 
   {{0x6e2c01eb,0xe2982980,0x240801d9,0x99840098}},	//   hoab, бао_, ённи_, cioł_, 
   {{0x6e2c0239,0x23282981,0x82400020,0xb8f400a8}},	//   koab, сони_, _ባህልታ, _paṇī, 
   {{0xd24c02a5,0x75fc014a,0xdb0c0192,0x00000000}},	//   ێنی_, _péze, _nabý, --, 
   {{0x6e2c0513,0x00000000,0x00000000,0x00000000}},	//   doab, --, --, --, 
   {{0x50a00121,0x8f640049,0x00000000,0x00000000}},	//   رەپل, зарб_, --, --, 
   {{0xdee40302,0xdb0c02b2,0xd0042982,0xf8b802a4}},	//   чови, _babý, чере_, _इन्प, 
   {{0x1d080340,0x6e2c03f4,0x127800cf,0x00000000}},	//   беби_, goab, _פאפע, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2560] --, --, --, --, 
   {{0x7a38000f,0xa1342983,0x04a4015b,0x75fc00f2}},	//   rítm, _ورکش, _čīlē_, _kézc, 
   {{0x7a380191,0x9cc82984,0x6e2c2985,0xab680075}},	//   sítm, шыңа_, boab, تحقق_, 
   {{0x98a40551,0xc8c403c3,0x7a3803aa,0x6e2c0306}},	//   зиде, लिंट, mítk, coab, 
   {{0x0d8000fc,0xd94403f7,0x00000000,0x00000000}},	//   _ялян, чеди, --, --, 
   {{0x26080774,0x7d042986,0xdb0c2987,0x00000000}},	//   ़ोसी_, mzis, _zabý, --, 
   {{0x8c40199e,0xb4d40828,0x7d0401c7,0xa3d42988}},	//   _чере, हम्_, lzis, हाई_, 
   {{0xd4980e44,0xceb00240,0xcb34007c,0xc6900200}},	//   бро_, גיה_, _זאלי_, رشىع, 
   {{0x7d042989,0x38c8298a,0xdb0c298b,0x09e00ce1}},	//   nzis, _بازی_, _labü, _џоун, 
   {{0x6e2c106c,0xd324298c,0x7d000270,0x07a0298d}},	//   zoab, зьми, _ýmsu, _паун, 
   {{0x316c2607,0x00000000,0x00000000,0x00000000}},	//   ñezo_, --, --, --, 
   {{0x7d04298e,0x7a380212,0xbbc80fa3,0x609801ac}},	//   kzis, dítk, रयुक, ڊنٽس_, 
   {{0x6e2c0693,0x112802dc,0x5064298f,0xca6814fa}},	//   voab, сюни_, ятна, лiлi, 
   {{0x7d042990,0x1ae00301,0xdb0c2991,0xd36c00cc}},	//   dzis, _গেছে_, _jabó, _حۇد_, 
   {{0xc43800ca,0x92682992,0xf1dc0095,0x00000000}},	//   _התגי, _урла_, यादन, --, 
   {{0xdb0c2993,0x7d04041c,0x7a380191,0xacf800cc}},	//   _dabü, fzis, sítj, онбу_, 
   {{0x7d042994,0x6e2c006a,0x00000000,0x00000000}},	// [2570] gzis, roab, --, --, 
   {{0xf04413ee,0x7a381984,0x6e2c01c4,0xdb0c0098}},	//   _تعبی, líth, soab, _nabó, 
   {{0x2d580396,0x53ac2995,0x7d04117f,0x7a380192}},	//   _минь_, ज्यश, azis, cítk, 
   {{0xcbc40046,0x7d040513,0x6dc000e7,0x42380100}},	//   _ډېرو_, bzis, _جۅرۅ, ִנגל_, 
   {{0x31680083,0xdb0c00e3,0x00000000,0x00000000}},	//   _mfaz_, _babó, --, --, 
   {{0xfe702996,0x3e5800a2,0x2ca801c9,0xd7e800e7}},	//   _جدی_, _hōta_, mtad_, يونۇ_, 
   {{0x2ca82997,0xf40401b9,0xe5780123,0x00000000}},	//   ltad_, ৰকাৰ_, озй_, --, 
   {{0xd8b401ac,0xba74005e,0x75fc00f2,0x00000000}},	//   _ڊگها_, _سافت, _rézc, --, 
   {{0x2ca82998,0xf770049d,0xdb0c014a,0xdb4c0012}},	//   ntad_, _ڕان_, _abbè, _مێے_, 
   {{0xdb0c0b07,0x2ca82999,0x00000000,0x00000000}},	//   _gabó, itad_, --, --, 
   {{0x7d04299a,0x39640207,0x2ca8299b,0xefcc0020}},	//   zzis, _åsså_, htad_, _ኣሎዋ_, 
   {{0x2ca8299c,0xdb0c299d,0xe5e4299e,0xa91c0070}},	//   ktad_, _kabò, _تزئی, _adži, 
   {{0xdb0c0078,0x3ce0034c,0xb33c0002,0x00000000}},	//   _jabò, xxiv_, egħd, --, 
   {{0xdb0c299f,0xffa401a7,0x7a3800ef,0x25ac01c5}},	//   _xabó, элгү, títk, lfel_, 
   {{0x2ca814cc,0x7d040083,0x75fc00e3,0x2bd003bf}},	//   etad_, wzis, _héza, _सफ़ा, 
   {{0x3ce001ba,0x75fc014a,0xa91c015b,0x2ca80479}},	//   txiv_, _kéza, _edži, ftad_, 
   {{0x2ca829a0,0x1be80155,0xbb380ef1,0x25ac29a1}},	// [2580] gtad_, одаи_, _ﺗﺎﻝ_, ifel_, 
   {{0x7d0429a2,0xabc4002c,0x25ac0078,0xb5fc011a}},	//   rzis, науҙ, hfel_, _tuġg, 
   {{0xdb0c02ba,0x75fc0670,0x2ca80593,0x7d0401b8}},	//   _rabó, _léza, atad_, szis, 
   {{0x25ac29a3,0x2ca80181,0xdb0c29a4,0x61e40c91}},	//   jfel_, btad_, _sabó, njkl, 
   {{0xdb0c29a5,0x25ac29a6,0xb33c0560,0x225002cc}},	//   _cabò, dfel_, mgħe, ízky_, 
   {{0xdb0c01e8,0x25ac0e48,0xb33c0560,0x00000000}},	//   _dabò, efel_, lgħe, --, 
   {{0x25ac29a7,0x00000000,0x00000000,0x00000000}},	//   ffel_, --, --, --, 
   {{0xd90c29a8,0x68ec0222,0xa91c00e5,0xd94400df}},	//   _پیت_, ëndë, _bežd, _жеби, 
   {{0x3168018f,0xf1dc03ec,0x236802e6,0x00000000}},	//   _rfaz_, यासन, _şaja_, --, 
   {{0x798029a9,0xa3d40774,0xefcc02b4,0xdb0c014a}},	//   _hemw, हाग_, _ኣሎዎ_, _abbé, 
   {{0x79800088,0xa284002c,0x41d000a1,0x2ca829aa}},	//   _kemw, нъяһ, _तोहस, ztad_, 
   {{0xdef801e2,0x7a38000f,0xdbd40607,0x00000000}},	//   _ዋርካ_, fíti, _hääb, --, 
   {{0xc5f00240,0x798029ab,0xdbd40030,0x2ca8015e}},	//   _בדף_, _memw, _kääb, xtad_, 
   {{0x79800762,0xbbc829ac,0x7a380191,0xdbd40030}},	//   _lemw, रयोक, síth, _jääb, 
   {{0x7f5829ad,0x798029ae,0xeff00020,0x7a3801b8}},	//   дарс_, _oemw, _ግናይ_, píth, 
   {{0x2ca829af,0x79800a84,0x7a38059b,0xc32c00c3}},	//   ttad_, _nemw, bíti, _خەپ_, 
   {{0x7a3829b0,0x2ca80151,0x7dc401d9,0x823401ac}},	// [2590] cíti, utad_, ъёрд, _جروا, 
   {{0x2ca829b1,0xbf640012,0x41740049,0x00000000}},	//   rtad_, _لگٲو, _كاۋس, --, 
   {{0x2ca829b2,0xdb0c197c,0x25ac29b3,0x8f440087}},	//   stad_, _sabò, yfel_, _юхид, 
   {{0xdb2417ab,0xa91c29b4,0x00000000,0x00000000}},	//   رونی, _leže, --, --, 
   {{0x6d5c29b5,0x798001e8,0x25ac01c5,0x00000000}},	//   _igsa, _demw, vfel_, --, 
   {{0x75fc000f,0x00000000,0x00000000,0x00000000}},	//   _réza, --, --, --, 
   {{0x25ac0241,0x49b817ab,0x7980007b,0x3b54001e}},	//   tfel_, _وارد_, _femw, _акрр, 
   {{0x649829b6,0xba4405bc,0x798003c7,0x25ac0104}},	//   птор_, _ахуй, _gemw, ufel_, 
   {{0x7a3801ae,0x25ac29b7,0x6d5c0308,0xa91c29b8}},	//   xíti, rfel_, _mgsa, _beže, 
   {{0x142020fc,0x79800088,0xc74429b9,0x69c801aa}},	//   лдым, _zemw, _قضاي, _haee, 
   {{0x798029ba,0xa91c29bb,0x25ac03c8,0x69c8008f}},	//   _yemw, _deže, pfel_, _kaee, 
   {{0x6d5c29bc,0x26c429bd,0x69c80085,0x600029be}},	//   _ngsa, _islo_, _jaee, _môme, 
   {{0x69c829bf,0x75fc00e3,0x00000000,0x00000000}},	//   _maee, _kézn, --, --, 
   {{0x6b84010b,0xdfd029c0,0x6d5c02e6,0x94242343}},	//   jahg, ديس_, _agsa, _كونۇ, 
   {{0x6e280212,0x9f58059e,0x247c0078,0x53980100}},	//   čebn, _impü_, lňm_, _זיצו, 
   {{0x69c829c1,0xa3c400b3,0xdb100191,0x2d9401c7}},	//   _naee, _उघड_, _ígér, крус, 
   {{0x1c4429c2,0x798029c3,0x247c00f1,0x03c4004f}},	// [25a0] енам, _remw, nňm_, _śaṇa, 
   {{0x26c429c4,0x69c802ba,0x79800068,0x41ac29c5}},	//   _oslo_, _aaee, _semw, ट्रस, 
   {{0x79800068,0x8f98007c,0xdbd4013c,0x3eb000c2}},	//   _pemw, _ציטי, _rääb, întă_, 
   {{0x5fdc1a4b,0x79800444,0x69c80335,0x12780100}},	//   मावल, _qemw, _caee, פאנע, 
   {{0x0d2029c6,0x26c401a0,0x79800403,0x69c80cfa}},	//   _бүтү, _aslo_, _vemw, _daee, 
   {{0x798029c7,0xf7780126,0x00000000,0x00000000}},	//   _wemw, _roħs_, --, --, 
   {{0x69c8008b,0x7bdc29c8,0x8f980282,0xa91c1909}},	//   _faee, _inru, ליסי, _reže, 
   {{0xd49800f8,0x69c829c9,0x247c01e8,0xa91c29ca}},	//   про_, _gaee, fňm_, _seže, 
   {{0x57b0024b,0x26c401d5,0x85700108,0x00000000}},	//   _бұлт, _eslo_, ددىئ, --, 
   {{0xba0802b4,0xb4c000b3,0x93a400f8,0x656802cc}},	//   _ፋሕ_, _ंनी_, хшид, aceh, 
   {{0x645c29cb,0xa3d40774,0xa91c14b7,0x69d4040e}},	//   ísir, हाज_, _veže, णाची, 
   {{0x6b840636,0xa91c00d4,0x00000000,0x00000000}},	//   zahg, _edžu, --, --, 
   {{0x7bdc29cc,0xa91c13c0,0x6b840249,0x25a829cd}},	//   _onru, _teže, yahg, _آدمي_, 
   {{0xa91c00e0,0x00000000,0x00000000,0x00000000}},	//   _idžt, --, --, --, 
   {{0xb92800cb,0x6f0800cf,0xdb1c013c,0x00000000}},	//   rtuṃ_, ĝeco, ndpä, --, 
   {{0x7bdc29ce,0x213029cf,0xa91c01d5,0x6f0801c6}},	//   _anru, ọrọl, _ježc, ŝeco, 
   {{0xa3d400b3,0xa91c00ce,0x6b840380,0xa11400d5}},	// [25b0] हाच_, _mežc, tahg, _لوٹت, 
   {{0xfe7000d5,0x2ef429d0,0x00000000,0x00000000}},	//   شدہ_, _азор, --, --, 
   {{0x69c808be,0xdec000b8,0x247c00f1,0x22580078}},	//   _paee, _кәто, zňm_, ňske_, 
   {{0x6d5c29d1,0x7ac40329,0x3d0c03e4,0x00000000}},	//   _ugsa, ысуе, _ठेके_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xea94009d,0xe73829d2,0x69c80039,0x6b840308}},	//   _لارښ, мел_, _waee, qahg, 
   {{0x69c805e1,0xa91c00c0,0x247c0078,0x79a40587}},	//   _taee, _bežc, wňm_, _әрсе, 
   {{0xa91c1635,0x660c018b,0x75fc0670,0xdb0c00d3}},	//   _vežb, ďako, _dézo, _ìjám, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7a1c0078,0x00000000,0x00000000,0x00000000}},	//   včti, --, --, --, 
   {{0xf1dc29d3,0xf7700075,0x74e80182,0x00000000}},	//   यांन, _طال_, ддөг_, --, 
   {{0xddc40237,0x7a3829d4,0x00000000,0x00000000}},	//   _bikŝ, sítv, --, --, 
   {{0x64a429d5,0x7a3829d6,0x66e8028d,0x00000000}},	//   _рала, pítv, _dūkš, --, 
   {{0xca300ce5,0x630000cc,0x00000000,0x00000000}},	//   ﺯﺩﺍ_, _ەۋگە, --, --, 
   {{0x8e800254,0xfbe011d6,0x765c0670,0x00000000}},	//   игре, नासम, _éryt, --, 
   {{0xe1f00122,0xdb1c0207,0xdd900075,0xf1d80098}},	//   _خست_, ndpå, شوط_, _बोपन, 
   {{0xd24c020e,0x4d6029d7,0xb334028d,0xb33c0002}},	// [25c0] _بني_, ркув, _įžiū, mgħa, 
   {{0xd00c2891,0xb33c0037,0x4d440106,0x38c800d5}},	//   _ولي_, lgħa, тпун_, ہاتی_, 
   {{0xdb0c29d8,0x682c02cc,0x394400f2,0x00000000}},	//   _labö, búdz, _szms_, --, 
   {{0xb33c0c89,0x38c804e7,0x60d429d9,0x7a1c00a2}},	//   ngħa, فاتی_, _krym, kōte, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bdc29da,0x88b004e7,0x3dc0000b,0xd6d8012b}},	//   _unru, شیمچ, leiw_, дти_, 
   {{0xcac429db,0x86c029dc,0x47c800e2,0x6b8000af}},	//   _игре_, ليون, بانۍ_, _õlga, 
   {{0xfbe029dd,0x60d403c7,0x39580020,0x00000000}},	//   नावम, _orym, ገሳውያ, --, 
   {{0xb33c0126,0x16940012,0xd40429de,0x00000000}},	//   dgħa, رٕکھ_, вяни, --, 
   {{0x9f5800cc,0x645400df,0xc770010f,0xd3940087}},	//   _alpí_, ňzin, ከናወኑ_, тәдә_, 
   {{0xdddc0341,0x60d429df,0xb33c011a,0xdb1c02bb}},	//   _aupō, _arym, fgħa, depë, 
   {{0x60d429e0,0x657c018f,0x75fc01b8,0xd49800b7}},	//   _brym, аshu, _kézm, _жрк_, 
   {{0xb5fc011a,0x60d403c7,0x99840151,0x7a3801b8}},	//   _guġa, _crym, lloų_, líts, 
   {{0x2cb80693,0x60d40335,0xc9500107,0x00000000}},	//   _rpsd_, _drym, ימר_, --, 
   {{0xb8e4043b,0x60d4034c,0x0d640348,0x682c0028}},	//   _ཏར_, _erym, възм, túdz, 
   {{0x60d40422,0x50640f72,0x1ee801b8,0x50a000c3}},	//   _frym, _итоа, روقی_, _پەسل, 
   {{0xebd829e1,0x32180364,0x60d429e2,0xdb1c0249}},	// [25d0] ндаш_, misy_, _grym, lepè, 
   {{0x321829e3,0xa91c29e4,0xdce400b0,0xdb1c02bb}},	//   lisy_, _neža, _lekė, cepë, 
   {{0x7b6429e5,0x67fc01e8,0x0ac40074,0x00000000}},	//   ртуе, _sèjo, ъщам, --, 
   {{0x3218039d,0xb4f40224,0xdce400b0,0x5ef80107}},	//   nisy_, ेनाय_, _nekė, _נפרד, 
   {{0xa91c29e6,0xf8a80122,0x2cb80426,0x00000000}},	//   _beža, ندوه_, _upsd_, --, 
   {{0x684429e7,0x00000000,0x00000000,0x00000000}},	//   ынла, --, --, --, 
   {{0x7a3829e8,0x2d88008b,0xc984038e,0xddc4012b}},	//   gíts, oaae_, _аузи, _jikş, 
   {{0xb0b8011a,0x85542850,0x36180023,0x280800e5}},	//   _བརཕེ, نیار_, кцыю_, _šunį_, 
   {{0xe45829e9,0x893429ea,0x321801d4,0x75fc00e3}},	//   нжи_, _شعرا, disy_, _kézj, 
   {{0x60d40020,0x7a3802b2,0x00000000,0x00000000}},	//   _rrym, bíts, --, --, 
   {{0x2d88004d,0x7a3803b2,0x321829eb,0x657c01a0}},	//   kaae_, mítr, fisy_, аsht, 
   {{0xb5fc011a,0x60d40098,0x7524015b,0x00000000}},	//   _tuġa, _prym, _žize, --, 
   {{0xf3c802ac,0xb33c043b,0xd65400ca,0x657c03e2}},	//   ربیه_, rgħa, _עינת_, ðshu, 
   {{0xf1dc02ef,0x60d4062d,0xca680049,0xb33c0126}},	//   याउन, _vrym, лiмi, sgħa, 
   {{0x44240a65,0x53980107,0x00000000,0x00000000}},	//   _ijn_, _טיסו, --, --, 
   {{0xdb0c2722,0x6000007f,0x60d429ec,0x998400c0}},	//   _mabô, _dôma, _trym, choň_, 
   {{0x248c29ed,0x9c2429ee,0x1da800cb,0x3dc0000b}},	// [25e0] nsem_, гдад, ङ्गत, reiw_, 
   {{0x248c11c6,0xef1800f8,0xdb1c29ef,0x90c00027}},	//   isem_, хмӣ_, lepé, _убье, 
   {{0x9ea801a7,0xa91c0b34,0x4424000d,0xd7e0006c}},	//   _явна_, _reža, _mjn_, पासच, 
   {{0x53340282,0x248c29f0,0x442401ed,0xbc740ce5}},	//   אנען_, ksem_, _ljn_, _نۇرب, 
   {{0x248c00aa,0x44240100,0xca6829f1,0xdce400b0}},	//   jsem_, _ojn_, лiгi, _rekė, 
   {{0xdce400e5,0x442401d5,0x00000000,0x00000000}},	//   _sekė, _njn_, --, --, 
   {{0x248c29f2,0xa91c0023,0xcf900100,0x6c3000d5}},	//   esem_, _veža, זטו_, _بہلا, 
   {{0x44240282,0x34940551,0xd9540012,0x35f402dc}},	//   _ajn_, ааир, _منزخ, рпир, 
   {{0xa91c0ebd,0x248c0191,0x321829f3,0xdb1c0039}},	//   _teža, gsem_, visy_, depé, 
   {{0x75fc00f2,0x07a0044a,0x00000000,0x00000000}},	//   _kézk, _гафн, --, --, 
   {{0x321829f4,0x2d880130,0x8c3402c3,0xdce400e5}},	//   tisy_, yaae_, רטיס_, _tekė, 
   {{0xf0e80476,0x60000693,0x248c29f5,0xd7e003eb}},	//   پىسى_, _rôma, bsem_, पावच, 
   {{0x3218039d,0x25d803a2,0x44f429f6,0xdb1c005e}},	//   risy_, _جهنگ_, _مروج_, sepè, 
   {{0x3218039d,0x44240848,0xcbbc02fa,0x13a401d9}},	//   sisy_, _gjn_, _উচ্ছ, _صنعی_, 
   {{0x321816b1,0xa91c29f7,0x68f803ef,0xb33c0126}},	//   pisy_, _nežn, zywd, mgħo, 
   {{0xad240572,0xb33c043b,0x442429f8,0x00000000}},	//   لىزى, lgħo, _zjn_, --, 
   {{0xfbe0006c,0xada400c3,0x64b801c6,0x00000000}},	// [25f0] नांम, лаңл, sʈiv, --, 
   {{0xddc40573,0xa91c018b,0xb33c011a,0x4424000d}},	//   _tikş, _bežn, ngħo, _xjn_, 
   {{0x8fd0016d,0xbc380ef1,0x940802df,0xe9740318}},	//   _кәңә, اسقا_, çmək_, لهاد, 
   {{0x248c29f9,0xd364049d,0xa91c07b5,0xc9840128}},	//   ysem_, _ژه_, _dežn, اشاي, 
   {{0x417c00ca,0x248c011a,0x00000000,0x00000000}},	//   תנדב, xsem_, --, --, 
   {{0xa69415b0,0x248c14ba,0xdb1c0191,0xec3400cf}},	//   ариј, vsem_, zepé, _כאָר_, 
   {{0x44240091,0x7a380579,0x75fc00d5,0x6fac0c2b}},	//   _rjn_, rítr, _kézh, _जानू, 
   {{0x44240a65,0xf98829fa,0x7a3802e8,0x00000000}},	//   _sjn_, _منفي_, sítr, --, 
   {{0xdb0c0064,0x44240a65,0x74f805bc,0xa91c00e0}},	//   _wabô, _pjn_, гээс_, _iežo, 
   {{0x248c29fb,0x00000000,0x00000000,0x00000000}},	//   rsem_, --, --, --, 
   {{0x248c29fc,0x232829fd,0x7a1c008b,0xe29829fe}},	//   ssem_, тони_, lōta, ъан_, 
   {{0xa06829ff,0x248c2a00,0xa91c00ef,0x75fc01b8}},	//   кама_, psem_, _ježo, _nézh, 
   {{0xdb1c01b8,0xb33c0126,0xa91c00d4,0x4424000d}},	//   repé, bgħo, _mežo, _tjn_, 
   {{0x2bd41f73,0x66080037,0x53a00182,0x00000000}},	//   _डोला, lhek, _дашб, --, 
   {{0x53980107,0x7a1c0299,0x644002bb,0x427c001d}},	//   _סיקו, hōta, mlli, _የተኩስ_, 
   {{0x3e58004d,0xdcb002fe,0xa91c2a01,0x7a1c0299}},	//   _kōti_, يىز_, _režn, kōta, 
   {{0x64402a02,0x1b7400cc,0x5ca4059f,0x5ba800cc}},	// [2600] olli, لداج, ризб, ккам_, 
   {{0x64402a03,0xdb0c2a04,0x4c800108,0x1fa402ba}},	//   nlli, _abbá, юлув, _өрүг, 
   {{0x66082a05,0xa91c01d4,0x4f9800ca,0x00000000}},	//   khek, _bežo, _בביצ, --, 
   {{0x6000034a,0x64402a06,0x2008015e,0x64b801c6}},	//   _kômo, hlli, lhbi_, nʈis, 
   {{0x3e580299,0x66082a07,0x64402a08,0x8d600302}},	//   _nōti_, dhek, klli, _євре, 
   {{0xa91c0518,0x48100302,0x64402a09,0x66080027}},	//   _težn, оміс, jlli, ehek, 
   {{0x07a00106,0x00000000,0x00000000,0x00000000}},	//   цајн, --, --, --, 
   {{0x644006ea,0x75fc0191,0x00000000,0x00000000}},	//   elli, _kézi, --, --, 
   {{0x75fc0078,0x18680302,0x644003f4,0x46100012}},	//   _jézi, _рази_, flli, زوٝر, 
   {{0x64400840,0x75fc0670,0xa91c00fc,0x00000000}},	//   glli, _mézi, _mežl, --, 
   {{0x66082a0a,0xa3c403ef,0x75fc2a0b,0x95c82a0c}},	//   bhek, उज़_, _lézi, _аула_, 
   {{0x66082a0d,0x64402a0e,0x2c7c0229,0xb33c011a}},	//   chek, alli, _jádò_, sgħo, 
   {{0x644014c5,0x600001f1,0x73c40c87,0xa91c0192}},	//   blli, _cômo, _ләне, _nežl, 
   {{0x3274010f,0xb33c0002,0x03141719,0x00000000}},	//   ለሥልጣ, qgħo, اتیت_, --, 
   {{0x60d8076f,0xcfa803f0,0xadbc0023,0x00000000}},	//   ātma, _یادم_, навi, --, 
   {{0x75fc0670,0x291002df,0xd1b801d2,0x8d742a0f}},	//   _bézi, _əzab_, _شاعا_, شارا, 
   {{0xfd8801d9,0x00000000,0x00000000,0x00000000}},	// [2610] рёси_, --, --, --, 
   {{0x9e7400dd,0x75fc014a,0x66082a10,0x62242a11}},	//   _گهٽت, _dézi, zhek, _پوۋە, 
   {{0x2c7c0229,0xa91c0091,0x66080139,0x00000000}},	//   _bádò_, _pežo, yhek, --, 
   {{0x66080008,0x7a1c0296,0x6e040012,0x629801d4}},	//   xhek, tōta, _چِھن, _úbož, 
   {{0x64402a12,0x66081a4d,0x48a80d56,0x01fc0100}},	//   ylli, vhek, ттем_, כפאל, 
   {{0xa7a800e7,0x7a1c00a2,0x66080341,0xac1800bf}},	//   укка_, rōta, whek, _согу_, 
   {{0x3e5801e8,0xa91c01df,0xb76400ec,0x00000000}},	//   _sōti_, _težo, әтәй, --, 
   {{0x3e5804c4,0x67fc0247,0x64402a13,0x7a1c2a14}},	//   _pōti_, _mèji, wlli, pōta, 
   {{0x66082a15,0xa91c2a16,0x64402a17,0x79582a18}},	//   rhek, _kežm, tlli, _витр_, 
   {{0xf7702a19,0x64402a1a,0xe51c0076,0x00000000}},	//   _قام_, ulli, _बइठि_, --, 
   {{0x66082a1b,0x64402a1c,0x6e3c0353,0xf1d8025c}},	//   phek, rlli, _oksb, _बोहन, 
   {{0x6608016d,0x3e5800a2,0x64402a1d,0x00000000}},	//   qhek, _tōti_, slli, --, 
   {{0x6aa40104,0x2bfc006c,0x644002bb,0x363410a4}},	//   huhf, _एवढं_, plli, _برلس, 
   {{0x75fc0039,0x6fac00b3,0x644003c0,0xa91c028d}},	//   _rézi, _जाणू, qlli, _nežm, 
   {{0xd24c0122,0xf1d80030,0x00000000,0x00000000}},	//   بنێ_, _बोवन, --, --, 
   {{0x2008036b,0x5f042a1e,0x00000000,0x00000000}},	//   shbi_, азҳа, --, --, 
   {{0xe0d801f1,0x00000000,0x00000000,0x00000000}},	// [2620] _свп_, --, --, --, 
   {{0x61f42a1f,0x6e3c01c6,0x00000000,0x00000000}},	//   _hoyl, _eksb, --, --, 
   {{0x20182a20,0x34c40887,0xa91c2a21,0xdca402dc}},	//   _impi_, _वन्द, _dežm, раҷи, 
   {{0x9b942a22,0x61f40063,0x99480272,0x186801a0}},	//   _گلست, _joyl, هلال_, гади_, 
   {{0x61f40cfa,0x00000000,0x00000000,0x00000000}},	//   _moyl, --, --, --, 
   {{0xdb1c2a23,0xda6403a2,0x61f40444,0x06c00143}},	//   lepí, _هاري, _loyl, ্মনি, 
   {{0x661800ef,0x61f400a0,0xdb0c021c,0x8c1802c3}},	//   _bmwk, _ooyl, äjän, _עולי, 
   {{0xe97016dd,0x00000000,0x00000000,0x00000000}},	//   _قۇمد, --, --, --, 
   {{0x20182a24,0xf98800ea,0x04900020,0x00000000}},	//   _ompi_, _منځي_, _መቐይሮ_, --, 
   {{0x75fc01b8,0xdbd4012b,0x00000000,0x00000000}},	//   _nézv, _näüb, --, --, 
   {{0x61f42a25,0x969402ba,0x00000000,0x00000000}},	//   _boyl, _ыраш, --, --, 
   {{0x201808df,0xd4a400df,0x00000000,0x00000000}},	//   _ampi_, _гидй, --, --, 
   {{0x61f42a26,0x33940007,0x6fac0c14,0x324401c4}},	//   _doyl, _далё, _जादू, йеүг, 
   {{0x61f400a0,0x33580254,0x7a1c0299,0x23c0011a}},	//   _eoyl, _калэ_, kōto, _མིགཕ, 
   {{0xa3d40357,0x61f42a27,0xa3c4011e,0x00000000}},	//   ाएर_, _foyl, उजर_, --, 
   {{0x2018007b,0xa91c07b5,0x2b180095,0x00000000}},	//   _empi_, _dežj, _येषु_, --, 
   {{0x3208081c,0x8d840375,0x00000000,0x00000000}},	// [2630] _ilay_, _қунд, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x32080618,0x2b18025c,0xc2780100,0x00000000}},	//   _klay_, _येशु_, ָרדי, --, 
   {{0xf1c80cd6,0x80cc00ac,0x00000000,0x00000000}},	//   िजिन, ামর্, --, --, 
   {{0x32082a28,0xdb0c012b,0x5fdc211f,0x75fc0191}},	//   _mlay_, _abbä, माचल, _jézu, 
   {{0x320806f6,0x00000000,0x00000000,0x00000000}},	//   _llay_, --, --, --, 
   {{0x32082a29,0xf1c80095,0x00000000,0x00000000}},	//   _olay_, िजान, --, --, 
   {{0xf1d80267,0xa91c2a2a,0x7c3801f6,0xd6cc148b}},	//   _बोलन, _ježk, čvre, ئقي_, 
   {{0xdb1c038e,0x24082a2b,0xc7a812ce,0xa3d4058f}},	//   cepâ, инии_, _مدال_, ाएल_, 
   {{0x61f42a2c,0x32082a2d,0x06c002fa,0x2d98013c}},	//   _soyl, _alay_, ্মবি, _ldse_, 
   {{0x0e100828,0x320800cc,0x61f40338,0xca2800c3}},	//   ṣṭav, _blay_, _poyl, ﺧﺸﺎ_, 
   {{0x201802ba,0x61f40380,0xa91c01d1,0x32082a2e}},	//   _smpi_, _qoyl, _nežk, _clay_, 
   {{0xa0682a2f,0xb5c804c3,0x61f40331,0x00000000}},	//   рага_, _دونم_, _voyl, --, 
   {{0xdee405bc,0x32082a30,0x61f42a31,0xdef800fc}},	//   ооги, _elay_, _woyl, ңың_, 
   {{0x32081de8,0x8d70010f,0xa91c00c0,0x61f40387}},	//   _flay_, _ቤታቸው_, _bežk, _toyl, 
   {{0x7e7c012a,0x3208015e,0xdbd0012b,0x5fdc00bd}},	//   rprp, _glay_, _küçs, माङल, 
   {{0x769000d3,0xb33c0126,0xdbd40152,0x5c1403d6}},	// [2640] _kóyá, egħh, _täüb, оьжу, 
   {{0x2d9801c6,0x20180039,0xa91c0c91,0xf38c0100}},	//   _edse_, _umpi_, _težj, ָראָ, 
   {{0x2ca40010,0x769000d3,0x32082a32,0x5ac82a33}},	//   _ālde_, _móyá, _ylay_, рлем_, 
   {{0xa3d40066,0xa2b00095,0xf2ac00cf,0x00000000}},	//   ाएँ_, _अमन्, רשאָ, --, 
   {{0x7a1c008b,0x2bd42a34,0x20c800bd,0x00000000}},	//   sōto, _डोका, िबिध, --, 
   {{0x5c0403b5,0xdb1c00b7,0xb7d800dd,0x53ac0095}},	//   _بکرێ_, repâ, صوبا_, ज्ञश, 
   {{0x5fb00303,0x6fac03ef,0x46642a35,0x2b9000e3}},	//   _जानल, _जासू, орым_, _سینس, 
   {{0x273003c4,0x3e58008b,0xb5fc0126,0x75fc0191}},	//   رۉنس, _tōtu_, _kuġi, _nézt, 
   {{0xa3d40066,0x69dc2a36,0x5fc82a37,0x39c00078}},	//   ाएं_, _ósea, ाजाल, _včsč_, 
   {{0x96b80139,0x00000000,0x00000000,0x00000000}},	//   _вуду_, --, --, --, 
   {{0x32082a38,0x39440616,0x167001d9,0x00000000}},	//   _play_, _hyms_, _ўқир, --, 
   {{0x80ac0267,0x00000000,0x00000000,0x00000000}},	//   _जमशे, --, --, --, 
   {{0xf3e801b9,0x769000d3,0xdbd0059c,0xf8bc025c}},	//   য়োগৰ_, _fóyá, _güçs, ोबिय, 
   {{0x3208025e,0x00000000,0x00000000,0x00000000}},	//   _wlay_, --, --, --, 
   {{0x28d0140e,0x65780c5b,0x3208069c,0x43700121}},	//   _दैनि, _éché, _tlay_, _تۇپر, 
   {{0x2134014a,0x6aa00207,0x320802b0,0x6fac006c}},	//   éché_, _ålfi, _ulay_, _जावू, 
   {{0x316800cd,0xa91c00b0,0xb33c011a,0xa9a400df}},	// [2650] _igaz_, _vežk, dgħi, җилд, 
   {{0x24880222,0xdfd003a2,0x5fb0006c,0x6f8000bf}},	//   _çame_, _ٻيٽ_, _जायल, _سۇرۅ, 
   {{0xa91c0f68,0x39440cfa,0x00000000,0x00000000}},	//   _težk, _ayms_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x88c4160e,0xd5e0000d,0xa0240152,0x00000000}},	//   تتال, _giỏ, _unöç, --, 
   {{0xa91c2a39,0xc7b82a3a,0x00000000,0x00000000}},	//   _ježi, рёд_, --, --, 
   {{0xf42002fa,0xd7ec2a3b,0xb33c043b,0xa91c2a3c}},	//   নকার_, اكى_, bgħi, _meži, 
   {{0xe29804f7,0xa91c0e6e,0x31680762,0xe81c011c}},	//   ҙам_, _leži, _ngaz_, _भगवा_, 
   {{0x39442a3d,0xe524021d,0xdb1c01d4,0x75340094}},	//   _gyms_, ядип, mepá, дээх, 
   {{0xa91c2a3e,0xe7b40203,0x240802dc,0x00000000}},	//   _neži, _आउटप, снои_, --, 
   {{0x2168205b,0xf7702a3f,0xe2980294,0xa2e4022e}},	//   йини_, _شال_, љам_, чонд, 
   {{0x06c000ac,0x75fc00e3,0xdb1c01d4,0x291002a0}},	//   ্মদি, _dézs, nepá, _əzan_, 
   {{0xa91c24b5,0xdb0c000b,0x2ab42a40,0x30742a41}},	//   _beži, _pcbë, håb_, дусс, 
   {{0x2ca805d7,0x60000693,0x31680054,0x25ac2a42}},	//   duad_, _kômi, _egaz_, lgel_, 
   {{0x25ac0336,0xdb1c0c0f,0x00000000,0x00000000}},	//   ogel_, kepá, --, --, 
   {{0x75fc0249,0xc1040108,0x2ab40056,0x0e602a43}},	//   _hézr, _жүмл, dåb_, ексн, 
   {{0x60240254,0x25ac0496,0x75fc00d5,0x00000000}},	// [2660] _ндиа, igel_, _kézr, --, 
   {{0x39440479,0x25ac0104,0xabc400ec,0x00000000}},	//   _ryms_, hgel_, мауҙ, --, 
   {{0x39442a44,0x25ac0031,0x00000000,0x00000000}},	//   _syms_, kgel_, --, --, 
   {{0x38c82a45,0x25ac0091,0xdb1c00cc,0x2ca80207}},	//   قاتی_, jgel_, repà, buad_, 
   {{0x25ac2a46,0x00000000,0x00000000,0x00000000}},	//   dgel_, --, --, --, 
   {{0x25ac2a47,0xe8e800e2,0xb33c0126,0x69dc06b4}},	//   egel_, ترمو_, sgħi, _ósen, 
   {{0x600001f1,0x00000000,0x00000000,0x00000000}},	//   _cômi, --, --, --, 
   {{0x25ac2a48,0xf9c403d5,0x95c82a49,0x75fc00f2}},	//   ggel_, _تحسی, сука_, _rézs, 
   {{0x057006e8,0x55040074,0x00000000,0x00000000}},	//   رايد, ячка, --, --, 
   {{0xc1b80396,0xd77403e0,0x75fc00f2,0x00000000}},	//   үлэх_, _رائع, _pézs, --, 
   {{0xa91c2a4a,0x2d9c03ef,0x998408be,0x8778023c}},	//   _reži, ówek_, nnoů_, _האבי, 
   {{0xb9e40422,0xa91c01f6,0x00000000,0x00000000}},	//   _ከአ_, _seži, --, --, 
   {{0x4638007c,0xa91c00b0,0x482000cc,0x00000000}},	//   _פעדע, _peži, _تىەق, --, 
   {{0x86280090,0xa5bc00b0,0x00000000,0x00000000}},	//   _ድህነት, riųe, --, --, 
   {{0xa91c0007,0x31680496,0xdb1c0fa7,0xb27401d9}},	//   _veži, _tgaz_, lepæ, _ўлиш, 
   {{0xc2780107,0xdddc0192,0x00000000,0x00000000}},	//   _פרחי, _kupř, --, --, 
   {{0x42382664,0xa91c239a,0x417400e2,0xb0340300}},	// [2670] _מנהל_, _teži, _ښایس, _ониш, 
   {{0xaf5000b8,0xfd740094,0x00000000,0x00000000}},	//   _аҽгә, _үлээ, --, --, 
   {{0x3fd80182,0xdb1c2a4b,0x25ac0d6b,0x5fb0084b}},	//   _эмээ_, tepá, ygel_, _जातल, 
   {{0x0dc80aab,0x2ca80151,0xa91c00e0,0x2ab40353}},	//   _ابدى_, puad_, _mežv, råb_, 
   {{0x8934045d,0x6e2c2a4c,0xb33c0560,0xdb1c0247}},	//   أعضا, mnab, mgħu, repá, 
   {{0xd3642a4d,0xb5fc011a,0xfeb82899,0xb33c0126}},	//   _له_, _muġu, _بایت_, lgħu, 
   {{0x25ac0c2a,0xc174028a,0x69dc2a36,0xd6cc2a4e}},	//   tgel_, _haɗe_, _óseo, لقو_, 
   {{0x6e2c2a4f,0xc174028a,0x600001f1,0x25ac0943}},	//   nnab, _kaɗe_, _vômi, ugel_, 
   {{0x69d80271,0x6e2c2a50,0x00000000,0x00000000}},	//   mdwe, inab, --, --, 
   {{0x6e2c0104,0x93c002ea,0xe4580023,0x00000000}},	//   hnab, _ţăra, ўжо_, --, 
   {{0x6e2c2a51,0xe51c00a1,0x69d80335,0x25ac0055}},	//   knab, _बेरि_, odwe, pgel_, 
   {{0x85b01fb0,0x78a42a01,0x6e2c00c0,0x00000000}},	//   _чәкч, šive, jnab, --, 
   {{0x6e2c009c,0xc17401e7,0xdd900012,0x00000000}},	//   dnab, _naɗe_, ێوس_, --, 
   {{0x62840616,0xb33c0126,0x201c0078,0x00000000}},	//   _çhoo, egħu, òti_, --, 
   {{0xa91c00ce,0xb33c0126,0x75fc00f2,0x6e2c030f}},	//   _iežu, fgħu, _kézp, fnab, 
   {{0xb8e02a52,0x6e2c2a53,0xb8d0011a,0xa3d42a54}},	//   _ཀྱ_, gnab, _ཟྀ_, ाएक_, 
   {{0x69d82a55,0x20542a56,0x62800028,0x00000000}},	// [2680] ddwe, _отор, lplo, --, 
   {{0xc1740ae3,0x6e2c2a57,0x26c401ab,0x6280018c}},	//   _daɗe_, anab, _oplo_, oplo, 
   {{0x62802a58,0x69d8018c,0xb33c0002,0xa91c00e0}},	//   nplo, fdwe, bgħu, _mežu, 
   {{0x98a42a59,0x69d801ed,0x6e2c1e69,0x9f580475}},	//   диде, gdwe, cnab, _lopë_, 
   {{0xed340396,0x2fc00d92,0x8d742a5a,0x00000000}},	//   _зэрэ, _ybhg_, _تاپا, --, 
   {{0x69d80618,0x7d04041c,0xa91c2a5b,0x8cd82448}},	//   adwe, myis, _nežu, निरो, 
   {{0xe7942a5c,0x7d042a5d,0x628000e9,0xddc400a8}},	//   راوک, lyis, jplo, _nikū, 
   {{0xd4982a5e,0x35b40c00,0xceb00240,0x7d042a5f}},	//   оро_, хбир, דיה_, oyis, 
   {{0x7d042a60,0x26c40030,0xeb140229,0x00000000}},	//   nyis, _eplo_, _òòré_, --, 
   {{0x6e2c2a61,0x9f580020,0xdb1c0353,0x00000000}},	//   znab, _copë_, repæ, --, 
   {{0xa91c2a62,0xb6c40c7e,0x6e2c2a63,0x62802a64}},	//   _dežu, _чөлд, ynab, gplo, 
   {{0xd4680573,0x20c803c3,0x7d0406ea,0x75d40041}},	//   _диде_, िबंध, kyis, _سيتا, 
   {{0x8264049d,0xdb1c2583,0x62800618,0x92bc02fa}},	//   کهێن, lepä, aplo, ঁটে_, 
   {{0x76402a65,0xdb1c023f,0xc1740181,0x7d042a66}},	//   lomy, cepç, _raɗe_, dyis, 
   {{0x15f00c51,0xb8e0043b,0x69d80323,0x7d040266}},	//   _आचार_, _ཀཱ_, ydwe, eyis, 
   {{0x76402a67,0x6e2c2075,0x7d0413fb,0xc3300240}},	//   nomy, unab, fyis, _שוק_, 
   {{0xdb1c00af,0xb33c011a,0x00000000,0x00000000}},	// [2690] hepä, rgħu, --, --, 
   {{0x6e2c2a68,0x76400428,0x6b840177,0xdb1c02eb}},	//   snab, homy, ubhg, kepä, 
   {{0x76402a69,0x7d042a6a,0x00000000,0x00000000}},	//   komy, ayis, --, --, 
   {{0x7d042a6b,0x764006f7,0xdb1c2a6c,0x9ba000e7}},	//   byis, jomy, depä, _ەەلى, 
   {{0x99942a6d,0xf1c00828,0x5d78007c,0x7d04017b}},	//   رپور_, ष्यन, _מארק, cyis, 
   {{0xca74006e,0x9f5800f1,0x9be4011a,0x00000000}},	//   _يازغ, _bopè_, སྐྱོ, --, 
   {{0x764008c2,0xdb1c2a6e,0x00000000,0x00000000}},	//   fomy, gepä, --, --, 
   {{0x76402a6f,0xa91c01d4,0xf1c000cb,0x62800207}},	//   gomy, _bežt, ष्मन, vplo, 
   {{0x64c400e2,0x6280006f,0x48742a70,0x00000000}},	//   ريدل, wplo, _آدرس, --, 
   {{0x628025a8,0xdb1c0030,0x78a401d1,0x00000000}},	//   tplo, bepä, šivc, --, 
   {{0x04ec0143,0x00000000,0x00000000,0x00000000}},	//   টনের_, --, --, --, 
   {{0xa0a42a71,0x62802a72,0x31780308,0x7d04193b}},	//   намд, rplo, gcsz_, yyis, 
   {{0x60640108,0x2cb801eb,0x00000000,0x00000000}},	//   нҗиң_, _nqsd_, --, --, 
   {{0x66082a73,0x62802a74,0x7a1c00a2,0xb33c011a}},	//   lkek, pplo, rōti, tgħt, 
   {{0x64402a75,0x6d5800df,0xcee4224f,0x66080379}},	//   moli, ýwan, ндре_, okek, 
   {{0x64402a76,0x7d042a77,0x600001f1,0x7a1c0341}},	//   loli, tyis, _rômu, pōti, 
   {{0x64400cbf,0x9f580229,0x66082a78,0xa91c00d4}},	// [26a0] ooli, _mopé_, ikek, _mežs, 
   {{0xf1c000cb,0x60d400b8,0x7d042a79,0x9f842a7a}},	//   ष्ठन, _isym, ryis, _ягод, 
   {{0xcfb400ca,0x20e00560,0x7d04021c,0x62840031}},	//   _אליי_, sħiħ_, syis, _ŧhoj, 
   {{0x7d0404f8,0xddc400b8,0x9f58038a,0xdb1c00b6}},	//   pyis, _oikũ, _nopé_, vepä, 
   {{0x6440176a,0x6c740329,0x7640017b,0x49700007}},	//   koli, _аусх, vomy, уліс, 
   {{0x64402a7b,0x66082a7c,0x7640186d,0xdb1c1031}},	//   joli, ekek, womy, tepä, 
   {{0x64402a7d,0xddc40247,0x76402a7e,0x22402a7f}},	//   doli, _aikũ, tomy, kokk_, 
   {{0xdb1c00a1,0x2240036d,0xcb640007,0x9f58014a}},	//   repä, jokk_, _часе_, _copé_, 
   {{0xdddc11b0,0xdb1c2a80,0xf8d40457,0x9f58014a}},	//   _atpū, sepä, _धनिय, _dopé_, 
   {{0x64402a81,0x76402a82,0xa91c00e5,0xdb1c0030}},	//   goli, somy, _vežt, pepä, 
   {{0x03c00041,0x2240036d,0xc794244a,0xb33c0126}},	//   усым, fokk_, _سپنا_, egħr, 
   {{0xf26c010f,0x660826bb,0x64400177,0x6844001e}},	//   _አደገኛ_, ckek, aoli, _знӡа, 
   {{0x62940113,0x00000000,0x00000000,0x00000000}},	//   ázor, --, --, --, 
   {{0x31780320,0x20d4091d,0xefb001b8,0xdec80020}},	//   scsz_, džić_, جیدگ, ሽጥን_, 
   {{0x80c42a83,0x22400126,0x00000000,0x00000000}},	//   শিষ্, bokk_, --, --, 
   {{0xb114009d,0x931001b8,0xa91c00e0,0x00000000}},	//   _لوبغ, _لوڈش, _mežr, --, 
   {{0x301402b3,0xebd800fc,0xf1c01403,0x313400c3}},	// [26b0] _адпр, мдаш_, ष्णन, _шеир, 
   {{0x66080054,0x2008000d,0x09b80095,0x00000000}},	//   zkek, ckbi_, ोज्य, --, 
   {{0xc1740e66,0xe9d8002f,0x69dc09b4,0xcf240a12}},	//   _haɗa_, _paź_, _ósek, _سردي, 
   {{0x64402a84,0xe8081ffc,0xc1740ae3,0x7a1c0299}},	//   zoli, वस्थ_, _kaɗa_, kōtu, 
   {{0x2d882a85,0x64402a86,0x798402b1,0xca440061}},	//   mbae_, yoli, ñiwa, ولڕه_, 
   {{0x2ca80762,0x64401320,0x8d740121,0x2d88034c}},	//   mrad_, xoli, _تاھا, lbae_, 
   {{0x66082a87,0x2ca80104,0x7c342a88,0x00000000}},	//   tkek, lrad_, _серх, --, 
   {{0x2ca81472,0x64402a89,0x82800051,0x78a4091d}},	//   orad_, woli, ққид, šiva, 
   {{0x64402a8a,0xc1740ae3,0xe4580393,0x2240013c}},	//   toli, _naɗa_, мжи_, vokk_, 
   {{0x2ca80104,0x64400335,0xa2e401aa,0x00000000}},	//   irad_, uoli, воод, --, 
   {{0x2ca80212,0x2240043b,0x00000000,0x00000000}},	//   hrad_, tokk_, --, --, 
   {{0x2ca82a8b,0xe5e404c3,0x64402a8c,0x60d40085}},	//   krad_, _جزئی, soli, _psym, 
   {{0x65c00200,0xc0c800e2,0x22402a8d,0x00000000}},	//   _бұқа, رېده_, rokk_, --, 
   {{0xc174028a,0x2ca82a8e,0x64402a8f,0x2d880034}},	//   _daɗa_, drad_, qoli, ebae_, 
   {{0x53980107,0x2ca82a90,0x00000000,0x00000000}},	//   _חיצו, erad_, --, --, 
   {{0xc1740e66,0x60d40693,0xfb540121,0x00000000}},	//   _faɗa_, _tsym, ۇراھ, --, 
   {{0x2ca82a91,0xdc680396,0xdc282038,0x60d40085}},	// [26c0] grad_, даад_, وسطه_, _usym, 
   {{0x3ce02a92,0x38bc0247,0x2c6c01d5,0x99bc00dc}},	//   rviv_, hárã_, _sždc_, _ইফেক, 
   {{0x3f982a93,0x2ca82a94,0xdcb00121,0x00000000}},	//   maru_, arad_, _ھىس_, --, 
   {{0x3f982a95,0x3c942a96,0x2ca82a97,0xc1740ae3}},	//   laru_, _میرز, brad_, _yaɗa_, 
   {{0xd7f802ea,0x2ca800f1,0xa91c012c,0xd8380152}},	//   дуй_, crad_, _sežr, мэк_, 
   {{0x3f982a98,0x1cc0043b,0x00000000,0x00000000}},	//   naru_, _གྱར_, --, --, 
   {{0x6964006e,0x7bdc2a99,0xc95000b8,0x99840075}},	//   ندۇق, _iaru, лтәы, _للأو, 
   {{0x3f982a9a,0x7bdc2a9b,0x75b801a0,0xb5d400e1}},	//   haru_, _haru, хлиё_, ужиј, 
   {{0x3f982a9c,0x7bdc23de,0x04b400d5,0xb8f400a8}},	//   karu_, _karu, نھوں_, _kaṭī, 
   {{0x3f982a9d,0x3a24025e,0xc17401e7,0x2d880337}},	//   jaru_, _hmmp_, _raɗa_, zbae_, 
   {{0x3f982a9e,0x81dc0301,0x1cc02a9f,0x04400111}},	//   daru_, ঠান_, _གྱལ_, реќн, 
   {{0x7a1c00a2,0x91e000ec,0x00000000,0x00000000}},	//   pōtu, рәкһ, --, --, 
   {{0x9f440048,0x10681812,0x00000000,0x00000000}},	//   _đoá_, _ﺳﻮﺭﯨ, --, --, 
   {{0x3f982aa0,0x2ca80593,0xc95000ca,0xc0580c57}},	//   garu_, vrad_, שמש_, віс_, 
   {{0xdd3800c2,0x386c015e,0x92f02aa1,0xcdd80106}},	//   _păşc, _midr_, _түнх, мња_, 
   {{0x7bdc2aa2,0x2ca82aa3,0xc0d00020,0x00000000}},	//   _aaru, trad_, ብሶም_, --, 
   {{0x3f982aa4,0xcfa42aa5,0x2d881658,0x2ca82aa6}},	// [26d0] baru_, _ишни, rbae_, urad_, 
   {{0x7bdc2aa7,0x3f980fb6,0x2ca82aa8,0x8b6400cc}},	//   _caru, caru_, rrad_, ناام, 
   {{0xba742aa9,0x3a740329,0x00000000,0x00000000}},	//   لانت, алхр, --, --, 
   {{0xc330033c,0x7bdc165f,0x2ca8018b,0xa6842709}},	//   בוע_, _earu, prad_, қлид, 
   {{0x7bdc2aaa,0x6000034a,0x2458014a,0x00000000}},	//   _faru, _kômp, lème_, --, 
   {{0x7bdc2aab,0xfe70009d,0xdddc0152,0x00000000}},	//   _garu, _ددی_, _kupş, --, 
   {{0x8cd80aff,0x60000693,0x56900e44,0xa44400c3}},	//   निको, _mômp, бајт, һнид, 
   {{0x7bdc01d9,0x3f982aac,0x24580045,0xbb580027}},	//   _zaru, zaru_, ième_, _расх_, 
   {{0x291801c9,0x24580670,0xdddc00c2,0x6b94018f}},	//   _åsa_, hème_, _lupş, _kezg, 
   {{0x7bdc04bb,0x87d4175a,0x6b94091d,0x23d42aad}},	//   _xaru, _جغرا, _jezg, уцир, 
   {{0x3f982aae,0x6b942aaf,0xa2280acc,0x33f42ab0}},	//   varu_, _mezg, ежна_, рчыс, 
   {{0x3f982ab1,0x6b942ab2,0x24580670,0xa2e400ec}},	//   waru_, _lezg, dème_, _ҡолд, 
   {{0x3f982ab3,0x00000000,0x00000000,0x00000000}},	//   taru_, --, --, --, 
   {{0x6b942ab4,0x2a6c1a2c,0x600000b7,0xe2980074}},	//   _nezg, _lieb_, _cômp, _зак_, 
   {{0x3f982ab5,0x7bdc2ab6,0x31c802fa,0x9e74005e}},	//   raru_, _raru, ষয়শ, اهرت, 
   {{0x3f982ab7,0x55000229,0xa1140061,0x00000000}},	//   saru_, _ìṣèl, _موعت, --, 
   {{0x3f982ab8,0x6b942ab9,0x1be80155,0xb8f4004f}},	// [26e0] paru_, _bezg, ндаи_, _maṣī, 
   {{0x3f982aba,0xd0f40107,0x4d602abb,0x6cc401c4}},	//   qaru_, _עמית_, скув, рифҡ, 
   {{0x7bdc2abc,0x2a6c0002,0xdb1c021d,0x91d40252}},	//   _varu, _bieb_, nepø, ধাৰ্, 
   {{0x386c0181,0x6b9402b0,0x00000000,0x00000000}},	//   _sidr_, _eezg, --, --, 
   {{0x2a6c2abd,0x98482abe,0x00000000,0x00000000}},	//   _dieb_, няка_, --, --, 
   {{0xd6d82abf,0x6b942ac0,0x7bdc2ac1,0x78a40070}},	//   ети_, _gezg, _uaru, šivo, 
   {{0xfd50001c,0x2a6c00b7,0x5fb00608,0x86c02ac2}},	//   _nghẹ, _fieb_, _जाईल, ميون, 
   {{0x1cc00560,0xa5bc0007,0x00000000,0x00000000}},	//   _གྱོ_, liųj, --, --, 
   {{0x99140007,0x75fc01b8,0x1cd0011a,0xe8480128}},	//   _сьві, _kézz, _ེགས_, رجۇن_, 
   {{0x63ac0e66,0x7a1c0197,0xb4e400aa,0xa5bc00e5}},	//   _ɓang, pōts, _पछी_, niųj, 
   {{0x2a6c0337,0xdb1c021d,0x69e40091,0x24580670}},	//   _yieb_, gepø, štež, xème_, 
   {{0xa2d4021f,0x00000000,0x00000000,0x00000000}},	//   _बनर्, --, --, --, 
   {{0x93e402ac,0x934401d2,0x73c42ac3,0x50f00123}},	//   _бўйл, _өнде, _кәне, ёҷот, 
   {{0xc17401e7,0x75fc0191,0x1cc00126,0x94700012}},	//   _faɗo_, _nézz, _གྱེ_, _پۯگا, 
   {{0xdbd00104,0xdddc0152,0xaed4021d,0x6b942ac4}},	//   _süßs, _qupş, шовш, _rezg, 
   {{0xfc2400ac,0x6b942ac5,0x24580045,0xdfd80123}},	//   বকোষ_, _sezg, rème_, нъӣ_, 
   {{0x82342ac6,0x2a6c2ac7,0x00000000,0x00000000}},	// [26f0] _دروا, _rieb_, --, --, 
   {{0x79800379,0xbd682ac8,0x2a6c0104,0xa5bc028d}},	//   _afmw, урсе_, _sieb_, giųj, 
   {{0x7c842ac9,0x4f68006b,0xf1a803e4,0x18780020}},	//   _ҳусе, _яшим_, _कयान, _ብሃገር_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c842aca,0x6b942acb,0xa9340c3f,0xa5bc00b0}},	//   _гусе, _tezg, шедш, biųj, 
   {{0xec240121,0x2c6c00b0,0x6b9402b0,0x00000000}},	//   _ئىسپ, _iždo_, _uezg, --, 
   {{0x81dc007e,0xe57003e0,0xc98404e7,0xbb581d17}},	//   ঠাত_, يطة_, _бузи, _барх_, 
   {{0x1b1c02fa,0x0ba80128,0xb3a400ec,0xaa582acc}},	//   _বুকে_, _تاڭى_, ҡлыһ, _рибу_, 
   {{0x69c80528,0x88800ac9,0x00000000,0x00000000}},	//   _ibee, _ایتن, --, --, 
   {{0x68e82acd,0x291c01ac,0x135402b4,0x00000000}},	//   _ired, mzwa_, _ግሉጽነ, --, 
   {{0x68e808be,0x291c042e,0x391409a8,0xa5d40111}},	//   _hred, lzwa_, _پوەز, _вжеш, 
   {{0x37041901,0x9730005e,0xd1c400e5,0x229000e5}},	//   _учув, _بکها, алюе_, ršk_, 
   {{0x291c2ace,0x69c82acf,0xa5080106,0x00000000}},	//   nzwa_, _mbee, _јела_, --, 
   {{0x68e80249,0xa348018f,0x00000000,0x00000000}},	//   _mred, _изла_, --, --, 
   {{0x9e640051,0x92f41fe3,0x69c82ad0,0x44242ad1}},	//   لارن, _نفوذ_, _obee, _imn_, 
   {{0x44242ad2,0x68e82ad3,0x1cc00560,0x291c042e}},	//   _hmn_, _ored, _གྱུ_, kzwa_, 
   {{0x75fc0496,0x9c242ad4,0x68e800d3,0xe1f000ea}},	// [2700] _pézz, адад, _nred, _هسک_, 
   {{0x69c82ad5,0x291c2ad6,0x9f580552,0x51580107}},	//   _abee, dzwa_, _copã_, _בכפו, 
   {{0xf7780037,0x69c8074e,0x68e82ad7,0x3dd00252}},	//   _naħa_, _bbee, _ared, ৱাবল, 
   {{0x69c82ad8,0x44242ad9,0xa5bc0023,0xdd9000dd}},	//   _cbee, _lmn_, siųj, _ڏوھ_, 
   {{0x69c8000b,0x7e6400af,0x3e7c2ada,0x44242adb}},	//   _dbee, mmip, _hít_, _omn_, 
   {{0x68e80382,0x442410ed,0x99840212,0x69c8030b}},	//   _dred, _nmn_, dnoť_, _ebee, 
   {{0x68e82adc,0x69c8018c,0x8f98007c,0x3e7c00aa}},	//   _ered, _fbee, דיצי, _jít_, 
   {{0x68e82add,0x35f42ade,0x3e7c02ef,0x44242adf}},	//   _fred, спир, _mít_, _amn_, 
   {{0x68e82ae0,0x3e7c2ae1,0x99840593,0x44240386}},	//   _gred, _lít_, lioů_, _bmn_, 
   {{0x5fb01dd3,0x44242ae2,0xb80401d3,0xca680049}},	//   _जागल, _cmn_, _daṃś, кiзi, 
   {{0x68e82ae3,0x3e7c2ae4,0x998402e3,0x00000000}},	//   _zred, _nít_, nioů_, --, 
   {{0x741403b5,0x69c80085,0x00000000,0x00000000}},	//   _گوتا, _xbee, --, --, 
   {{0x442404f3,0x99840151,0x7e6401d5,0x00000000}},	//   _fmn_, hioů_, dmip, --, 
   {{0x44242ae5,0x3e7c0014,0x33840012,0x741410d9}},	//   _gmn_, _bít_, _الغٲ, _دوتا, 
   {{0x02a02ae6,0xb4b4002c,0x24880560,0x34940152}},	//   _дрым, _тиҙә, _ħami_, _таһр, 
   {{0x51842ae7,0xef18002f,0x99840151,0x3e7c012c}},	//   _тука, ąż_, dioů_, _dít_, 
   {{0x82640324,0x00000000,0x00000000,0x00000000}},	// [2710] _بهين, --, --, --, 
   {{0x46a40457,0x68e802bb,0x7e640030,0x00000000}},	//   _गिलह, _rred, amip, --, 
   {{0x68e821ec,0x2458197c,0x7e64005e,0xdeb00049}},	//   _sred, nèma_, bmip, _нұры, 
   {{0x68e82ae8,0x7e64005e,0xcc840122,0x684400c3}},	//   _pred, cmip, _نۆره_, әнка, 
   {{0xb9c403e0,0x2d982ae9,0x291c01ac,0x6e2c00e3}},	//   تقني, _iese_, uzwa_, miab, 
   {{0x1cc02aea,0x6e2c2aeb,0x68e82aec,0x2d982aed}},	//   _གྱི_, liab, _vred, _hese_, 
   {{0x44242aee,0x68e82aef,0x2d982af0,0xb8040828}},	//   _rmn_, _wred, _kese_, _saṃś, 
   {{0x68e82af1,0x6e2c2af2,0xdb140272,0x69c80123}},	//   _tred, niab, _ócái, _ubee, 
   {{0x68e821cb,0x2d982af3,0x46d40357,0xc82801d2}},	//   _ured, _mese_, _भैरह, рiңi, 
   {{0x2d982af4,0x6e2c2af5,0xddc406a4,0xdb1c001e}},	//   _lese_, hiab, _mikš, hepý, 
   {{0x7e6402b1,0xddc400e0,0x00000000,0x00000000}},	//   ymip, _likš, --, --, 
   {{0x2d982af6,0x3e7c0048,0x00000000,0x00000000}},	//   _nese_, _rít_, --, --, 
   {{0x44242af7,0xddc40473,0xd6540107,0x99840593}},	//   _tmn_, _nikš, _פינת_, zioů_, 
   {{0x2d982af8,0x3e7c2af9,0x3ec82afa,0x00000000}},	//   _aese_, _pít_, ақом_, --, 
   {{0x2d982afb,0xddc40007,0xb55400cb,0xd24c00ea}},	//   _bese_, _aikš, āṅga, _ګني_, 
   {{0x2d980a24,0x6e2c2afc,0x1b1c02fa,0x3e7c2afd}},	//   _cese_, giab, _বুঝে_, _vít_, 
   {{0x2d982afe,0x7e642aff,0xdbc801a7,0x5ca400bf}},	// [2720] _dese_, rmip, лгад_, сизб, 
   {{0x2d982b00,0x78a40113,0x3e7c2ada,0x9a9c0049}},	//   _eese_, šivk, _tít_, еудi, 
   {{0x6e2c2b01,0xd24c2b02,0x2d982b03,0xddc400b0}},	//   biab, _زنی_, _fese_, _eikš, 
   {{0x2d980520,0x4f8403d9,0x6e80001e,0x998408be}},	//   _gese_, _پایہ, _ẽngú, rioů_, 
   {{0xdb1c00cd,0x91b80107,0x2ba40881,0x1cc0011a}},	//   lepü, רמני, गृहा, _གཱི_, 
   {{0xaab800cc,0x00000000,0x00000000,0x00000000}},	//   ادەر_, --, --, --, 
   {{0x07a026da,0x2d982b04,0x8b2000b7,0x00000000}},	//   чајн, _yese_, _едре, --, 
   {{0xd5b82b05,0xc6d01fbd,0xda78002c,0x6120013c}},	//   уск_, ستىت, _аяҡ_, _vдlj, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6e2c2b06,0x07a00116,0x287400fc,0x69dc0579}},	//   ziab, _наун, _фытр, _óser, 
   {{0x95c82b07,0x75a4001e,0x33580254,0xdb0c00f2}},	//   _була_, _дылҧ, ранэ_, _ebbö, 
   {{0xdb1c2b08,0x6e2c03b2,0x00000000,0x00000000}},	//   lepó, xiab, --, --, 
   {{0x2d982b09,0xc0f4010f,0x78a40247,0xc5f000ca}},	//   _rese_, _ሌተር_, áivh, _מדף_, 
   {{0x2d982b0a,0xddc42b0b,0x741401ac,0x00000000}},	//   _sese_, _rikš, _گوڪا, --, 
   {{0x2d982b0c,0xdb1c0116,0x00000000,0x00000000}},	//   _pese_, tepý, --, --, 
   {{0x1cc02b0d,0x31340200,0x2d980222,0x741400dd}},	//   _གྱང_, _мейр, _qese_, _دوڪا, 
   {{0x2d982b0e,0x6e2c2b0f,0x6ad008e5,0xff880094}},	// [2730] _vese_, riab, सब्र, шөөл_, 
   {{0x2d982b10,0x6e2c2b11,0xfbd004c3,0xaed401a7}},	//   _wese_, siab, فتم_, _доош, 
   {{0x2d982b12,0x6d4003ef,0x28bc00cb,0xbca800c3}},	//   _tese_, _ślad, ोऽभि, لدەك_, 
   {{0x75200320,0x2d9803f2,0xddc40059,0x00000000}},	//   kzmz, _uese_, _tikš, --, 
   {{0x6e3c2b13,0xebc41381,0x00000000,0x00000000}},	//   _ijsb, _мәжн, --, --, 
   {{0x6d5c0059,0xac1801e3,0x765c004f,0x00000000}},	//   _izsa, _тогу_, _īrya, --, 
   {{0x39c005e1,0xdc540061,0x7b54059b,0x00000000}},	//   _sōsō_, _گرێک, _فضفض, --, 
   {{0xa91c00e0,0x00000000,0x00000000,0x00000000}},	//   _mežz, --, --, --, 
   {{0xe3b02b14,0xab2800fc,0x00000000,0x00000000}},	//   ورد_, _соңа_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc1740181,0xe29826da,0x04280020,0xf7702b15}},	//   _haɗi_, јам_, _ብወገን, _كام_, 
   {{0x21682b16,0x00000000,0x00000000,0x00000000}},	//   иини_, --, --, --, 
   {{0xd24c0046,0x6d5c00a2,0x79840105,0x00000000}},	//   ځنۍ_, _nzsa, ñiwi, --, 
   {{0x248c2b17,0x6e3c02bb,0x04642b18,0x00000000}},	//   mpem_, _ajsb, _утем, --, 
   {{0x248c2b19,0x6d5c2b1a,0x00000000,0x00000000}},	//   lpem_, _azsa, --, --, 
   {{0x78a400e9,0x2fcc00e9,0x248c0034,0xdd880123}},	//   šivi, đega_, opem_, рбад_, 
   {{0x61f4043e,0xdb1c013c,0xce4400e5,0x00000000}},	// [2740] _inyl, sepü, ізуе_, --, 
   {{0x61e42b1b,0xc1740181,0x6d5c2b1c,0x5c5400e5}},	//   ldkl, _naɗi_, _dzsa, ітаф, 
   {{0x6d5c02b0,0x6b500020,0x00000000,0x00000000}},	//   _ezsa, _ንጢሞቴ, --, --, 
   {{0xd9d00e40,0x988002b4,0x27e8028a,0x3eb82b1d}},	//   بەرگ, _ክሰርሑ_, ɓani_, murt_, 
   {{0xc1740181,0x97e00551,0x3eb80085,0xd7f8001e}},	//   _baɗi_, мҩаҧ, lurt_, иук_, 
   {{0xacd800b9,0x7c380b34,0x3940043b,0x00000000}},	//   _פֿרי, čvrs, ħis_, --, 
   {{0xc1740ae3,0x795403b5,0xdb1c00b7,0x00000000}},	//   _daɗi_, _کێشا, repó, --, 
   {{0x61e4018c,0x043c0020,0x00000000,0x00000000}},	//   jdkl, _ይብጻሕ, --, --, 
   {{0xc1740ae3,0x3eb800a0,0x236801c6,0x61e40207}},	//   _faɗi_, hurt_, _ĝaja_, ddkl, 
   {{0x3eb82b1e,0x13682b1f,0xd3781901,0xa91c00e5}},	//   kurt_, ишни_, шчи_, _nežy, 
   {{0x248c0130,0x4b78007c,0x61e4084f,0xe7f4012b}},	//   apem_, יטיג, fdkl, _эчтэ, 
   {{0x20182b20,0x3eb81977,0x7af80353,0x00000000}},	//   _alpi_, durt_, øvty, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3eb82b21,0x61e40010,0x10482b22,0x61f406e2}},	//   furt_, adkl, рями_, _enyl, 
   {{0x3eb82b23,0x63b400c0,0x00000000,0x00000000}},	//   gurt_, ózne, --, --, 
   {{0x20182b24,0x92642b25,0x00000000,0x00000000}},	//   _elpi_, _بدتم, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2750] --, --, --, --, 
   {{0x3eb803c8,0x32082b26,0x62240012,0x6fb82b27}},	//   burt_, _hoay_, _وى۪ل, _угор_, 
   {{0x0a6825ae,0x3eb814cc,0x8ca40030,0x8aa401a0}},	//   арди_, curt_, _चिको, юрад, 
   {{0x9984186c,0xadd801d9,0x00000000,0x00000000}},	//   rhoş_, _умму_, --, --, 
   {{0x6d5c1d04,0xa2a00add,0xbdc400c3,0x00000000}},	//   _uzsa, _कौन्, _تەقۋ, --, 
   {{0xa6942b28,0x66e42b29,0x32080048,0x397c0020}},	//   приј, зока, _loay_, _ብዓልቲ_, 
   {{0x9ba02b2a,0x4e0c0021,0x3208028b,0xe5a40121}},	//   _سەنى, _सवाई_, _ooay_, пийи, 
   {{0xd6cc2b2b,0x6b840336,0x600001d4,0x7f3c0100}},	//   اقي_, lchg, _dômy, יעוו, 
   {{0x69d82b2c,0xc1740181,0x00000000,0x00000000}},	//   mewe, _taɗi_, --, --, 
   {{0x483001fa,0x69d82b2d,0x6b842b2e,0x248c02bf}},	//   _غواړ, lewe, nchg, rpem_, 
   {{0x32082b2f,0x6b842b30,0xe3b00221,0x98680121}},	//   _boay_, ichg, ورگ_, _اللە_, 
   {{0x61440385,0x69d82567,0x00000000,0x00000000}},	//   зема, newe, --, --, 
   {{0x10a02b31,0x61e42b32,0x69d803f4,0xa2cc025c}},	//   ниян, rdkl, iewe, _तहव्, 
   {{0x69d82b33,0x3eb82b34,0xa0682b35,0x00000000}},	//   hewe, turt_, сага_, --, 
   {{0x63a02b36,0xe8e400dd,0x539800ca,0x00000000}},	//   maln, _ڌڻ_, _היצו, --, 
   {{0x2fc0000b,0x6b840028,0x27e42b37,0x63a02b38}},	//   _echg_, echg, _laln_, laln, 
   {{0x69d82b39,0x2fd007d4,0x3eb82b3a,0x5ba81a6c}},	// [2760] dewe, ́ngɔ_, surt_, йкам_, 
   {{0x63a02b3b,0xdce40025,0x2ee00222,0xcf8c01b5}},	//   naln, _iekļ, _fshf_, _مژِ_, 
   {{0x69d82b3c,0x22802b3d,0x0f7800ca,0x5ac82b3e}},	//   fewe, _jók_, _לאיב, слем_, 
   {{0x69d8098b,0x63a02b3f,0x32080014,0x00000000}},	//   gewe, haln, _xoay_, --, 
   {{0x63a015f0,0xc5c000c7,0x26c40444,0xf1c011d4}},	//   kaln, ্যাপ, _aqlo_, ष्टन, 
   {{0x63a0136b,0x9f580e84,0x36d42b40,0x00000000}},	//   jaln, _topä_, докр, --, 
   {{0x63a02b41,0x69d82b42,0x8c180240,0x65780308}},	//   daln, bewe, _פולי, _bgwh, 
   {{0xc174028a,0x09e003a7,0x63a0015e,0xd5e001eb}},	//   _haɗu_, _посн, ealn, _khỏ, 
   {{0x63a02b43,0xc17401e7,0x1dcc00cb,0x32080c0d}},	//   faln, _kaɗu_, ह्यत, _roay_, 
   {{0x228021c9,0x320801d6,0x00000000,0x00000000}},	//   _bók_, _soay_, --, --, 
   {{0x95c82b44,0xd6280836,0x00000000,0x00000000}},	//   _глеб_, _ложе_, --, --, 
   {{0x63a000a1,0x867800ca,0x63800116,0x00000000}},	//   aaln, _הראו, нҳәа, --, 
   {{0x32080693,0xd7600061,0x50641611,0x92bc00dc}},	//   _voay_, _تۆژی, зтва, ুটে_, 
   {{0x69d82b45,0x74142b46,0x228002b2,0xb4e803e4}},	//   zewe, _زوبا, _fók_, मटी_, 
   {{0x69d82b47,0x998400ef,0x93580a22,0x82640122}},	//   yewe, dnož_, _урду_, بهێن, 
   {{0xc3300107,0x43380107,0x00000000,0x00000000}},	//   _רוק_, _לעוב, --, --, 
   {{0x69d82b48,0xd24c004b,0x1cc00560,0xbec4004f}},	// [2770] vewe, _لۆگ_, _གྱད_, _śīty, 
   {{0x69d82b49,0xf778043b,0x705404c3,0x6b842b4a}},	//   wewe, _daħk_, _زنجا, uchg, 
   {{0x6b842b4b,0x00000000,0x00000000,0x00000000}},	//   rchg, --, --, --, 
   {{0x27e40e84,0x63a02b4c,0x6b8422cd,0x291c01ee}},	//   _saln_, zaln, schg, ﺴﺎﭖ_, 
   {{0xba742b4d,0xed501eb4,0x69d8027e,0x7ac40152}},	//   رامت, _شھر_, rewe, _үссе, 
   {{0x69d808bb,0x635800cb,0x63a00080,0xf5340222}},	//   sewe, ṃnid, xaln, _ክትኮነ, 
   {{0x63a00f29,0x69d82b4e,0x96f400b7,0xe64401d2}},	//   valn, pewe, дејт_, мекп, 
   {{0x63a0002f,0x4660039b,0x22800579,0x00000000}},	//   waln, رۇشق, _rók_, --, 
   {{0xc17401e7,0xc8b00046,0x228000f2,0x00000000}},	//   _yaɗu_, _سلاک, _sók_, --, 
   {{0x228000e3,0x00000000,0x00000000,0x00000000}},	//   _pók_, --, --, --, 
   {{0x63a02b4f,0x1cc00560,0x62800337,0x04ec0143}},	//   raln, _གྱན_, uqlo, য়নের_, 
   {{0x63a02b50,0xa0a42b51,0x00000000,0x00000000}},	//   saln, мамд, --, --, 
   {{0xa5bc02b3,0x63a02b52,0x72d800cb,0xa50801f1}},	//   siųs, paln, āreṇ, _фела_, 
   {{0x2280266b,0x63a003a9,0xe2982b53,0x04640320}},	//   _tók_, qaln, _дак_, _этем, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb7d40223,0xd5e0000d,0x00000000,0x00000000}},	//   _iṣeg, _phỏ, --, --, 
   {{0xdb1c0139,0x00000000,0x00000000,0x00000000}},	// [2780] nepö, --, --, --, 
   {{0x8d600734,0x3e7c00cf,0x4d600302,0x1fb40007}},	//   твуе, _aŭte_, ткув, _ўспр, 
   {{0x786402ba,0x9e642b54,0x1a282b55,0x00000000}},	//   nòve, _овод, ожжи_, --, 
   {{0xdb1c0027,0xd5e0000d,0x00000000,0x00000000}},	//   kepö, _thỏ, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f4802b2,0xe4f00030,0x00000000,0x00000000}},	//   _þjón_, _अछ़ि_, --, --, 
   {{0x86c02b56,0xd5b82b57,0xdddc2b58,0x47c800ea}},	//   نيون, осп_, _nupū, تانۍ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x05702b59,0xb4e81ac8,0x4c9800cf,0x00000000}},	//   پايد, मटे_, ֿשטע, --, 
   {{0xd3940152,0x00000000,0x00000000,0x00000000}},	//   фәдә_, --, --, --, 
   {{0x0bb4033c,0x287404f7,0xefe00422,0x87780107}},	//   ולים_, _яҡшы_, ነታዊ_, _ואבי, 
   {{0xa818024b,0x00000000,0x00000000,0x00000000}},	//   _وتەر_, --, --, --, 
   {{0xdb1c00af,0x00000000,0x00000000,0x00000000}},	//   mepõ, --, --, --, 
   {{0xdb1c013c,0x00000000,0x00000000,0x00000000}},	//   lepõ, --, --, --, 
   {{0xf31805bc,0xadd4005b,0x60c001c6,0x998402e3}},	//   _хойш_, новљ, _ĥome, nnoų_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf4bc00ac,0x2f24038a,0x8bc40294,0xefe0010f}},	// [2790] _অনুব, _bëgé_, дсед, ነሳው_, 
   {{0x50640b5c,0xdb242b5a,0xdce40055,0xdb1c0030}},	//   _تطبق, کومی, _cekı, hepõ, 
   {{0xdb1c019f,0x00000000,0x00000000,0x00000000}},	//   zepö, --, --, --, 
   {{0x3218062d,0x0ddc001d,0xc9800020,0x00000000}},	//   nksy_, _ዓቀፉ_, _ክበጽሖ_, --, 
   {{0xd3641596,0xc03c0090,0x7c840551,0xddd402e6}},	//   _څه_, _ባለሥል, _аусе, lmyş, 
   {{0xd3641a9f,0x2ca800b6,0x2d880034,0x00000000}},	//   _مه_, msad_, lcae_, --, 
   {{0x7ac42b5b,0x2ca82b5c,0x00000000,0x00000000}},	//   _исте, lsad_, --, --, 
   {{0x2d882b5d,0xe58400e7,0xdddc028d,0x2ca82b5e}},	//   ncae_, رۅتۉ_, _rupū, osad_, 
   {{0x2ca81c27,0x79c82b5f,0x79502b60,0x2d88034c}},	//   nsad_, _توقف_, _پێوا, icae_, 
   {{0xdddc0299,0x2ca800af,0xd8b40c78,0xddd40031}},	//   _pupū, isad_, _سگها_, kmyş, 
   {{0x34842b61,0x00000000,0x00000000,0x00000000}},	//   нгөг, --, --, --, 
   {{0x81b80664,0x2ca82b62,0x339802b4,0x00000000}},	//   ঘ্ন_, ksad_, መስረተ_, --, 
   {{0xa1142b63,0xdb1c0010,0x2ca80140,0x00000000}},	//   روست, lepô, jsad_, --, 
   {{0x201c2b64,0xdee40396,0x4430019f,0x2ca82b65}},	//   óti_, ноги, _öx_, dsad_, 
   {{0x931003b5,0x6d580002,0x00000000,0x00000000}},	//   _مووش, żwal, --, --, 
   {{0x0ddc010f,0x321800c2,0x2ca82b66,0xdce40386}},	//   _ዓቀፍ_, cksy_, fsad_, _sekı, 
   {{0x15f00774,0xa5140560,0xc21001b5,0x2ca82b67}},	// [27a0] _अफसर_, ིརིག_, _مٔژ_, gsad_, 
   {{0x2d88034c,0x00000000,0x00000000,0x00000000}},	//   acae_, --, --, --, 
   {{0x3f982b68,0x2ca8017d,0x3ce001b1,0x2c0000fc}},	//   mbru_, asad_, swiv_, шүрм, 
   {{0x2d882b69,0x0f34007c,0xe9e40302,0xdb1c0c0d}},	//   ccae_, _טריט_, кціо, ngpé, 
   {{0xe9800121,0x24bc00c3,0x7b8401d2,0x00000000}},	//   рқун, _ﻣﻪﯞﺟ, _لازە, --, 
   {{0xcdcc0046,0x3eb8006f,0x00000000,0x00000000}},	//   _پښې_, orrt_, --, --, 
   {{0x8c402b6a,0x2480010f,0xabc401c4,0x5fd011d0}},	//   _сере, _የሁለት_, _шарҙ, द्यल, 
   {{0x96442b6b,0x35f40111,0xceb000ca,0xda640995}},	//   ээлд, тпир, איה_, _سازي, 
   {{0x7d042b6c,0x3218010b,0x3f98043b,0xdb1c0030}},	//   nxis, vksy_, kbru_, repõ, 
   {{0x3d0805d5,0xdb1c0030,0x00000000,0x00000000}},	//   _सपने_, sepõ, --, --, 
   {{0x26100043,0xb6c40049,0xf1941c80,0x00000000}},	//   _cáos_, _рөлд, кинь, --, 
   {{0xca30006e,0x3eb800fb,0xb33c011a,0x2ca82b6d}},	//   ﺭﻏﺎ_, drrt_, baħn, ysad_, 
   {{0x7d040209,0xf48401a0,0x2ca8028b,0xd46800b7}},	//   jxis, _شاشی, xsad_, _еиде_, 
   {{0x906021b5,0x3f982b6e,0xb4ac00b3,0x00000000}},	//   انسۇ, gbru_, गळी_, --, 
   {{0x7f8417db,0x00000000,0x00000000,0x00000000}},	//   الفن, --, --, --, 
   {{0x76400b1e,0x2ca82b6f,0x2d880034,0x7f5801cf}},	//   nnmy, tsad_, ucae_, хасс_, 
   {{0x7d042b70,0x2ca8025e,0x2d8802bf,0x3f982b71}},	// [27b0] gxis, usad_, rcae_, bbru_, 
   {{0x2ca82b72,0x2d882b73,0x2bd82b74,0x00000000}},	//   rsad_, scae_, بارک_, --, 
   {{0x2ca82b75,0xd5a410a0,0x00000000,0x00000000}},	//   ssad_, _پف_, --, --, 
   {{0x6fcc03ec,0x2ca82b5c,0x00000000,0x00000000}},	//   द्रू, psad_, --, --, 
   {{0x2ca802ac,0x9f5800f1,0xf99001ac,0x00000000}},	//   qsad_, _anpè_, صبن_, --, 
   {{0xec3400b9,0x76402b76,0x49140098,0x00000000}},	//   _יאָר_, enmy, बैगो_, --, 
   {{0xbdd001c6,0x9538001d,0x764002b2,0x00000000}},	//   liɨa, _እስከተ, fnmy, --, 
   {{0xba7402be,0x6934038a,0xeb1c006c,0xdb2400d5}},	//   _ماقت, 茜eya, पनीत_, _شوقی, 
   {{0xd1e00090,0x63b40b0a,0x00000000,0x00000000}},	//   ምንት_, ózno, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x23282b77,0xe2982b78,0x00000000,0x00000000}},	//   фони_, ьан_, --, --, 
   {{0x65942b79,0x22142b7a,0x00000000,0x00000000}},	//   _раду, тфор, --, --, 
   {{0x66081a92,0x78640693,0x1ea801ac,0x7d040126}},	//   mjek, lòva, ڀاري_, xxis, 
   {{0x660801ec,0x3e7c00cf,0x73c4005e,0x3c2400f2}},	//   ljek, _aŭta_, _ميهم, _köve_, 
   {{0x8fa02b7b,0x64402b7c,0x6608193b,0x3f982b7d}},	//   расе, mnli, ojek, rbru_, 
   {{0xd24c2b7e,0x66082b7f,0x3c24000b,0x7d0416c8}},	//   _ونو_, njek, _möve_, txis, 
   {{0x64402b80,0x60240822,0xdca40663,0x69dc06b4}},	// [27c0] onli, _адпа, тази, _ósey, 
   {{0x64402b81,0xabc4002c,0x66081652,0x00000000}},	//   nnli, лауҙ, hjek, --, 
   {{0x64402b82,0x78640770,0x66082b83,0x00000000}},	//   inli, jòva, kjek, --, 
   {{0x7d04004e,0x644006ef,0x66080472,0x3a20059b}},	//   pxis, hnli, jjek, óip_, 
   {{0xc03c0090,0x66082b84,0x8f502b85,0x00000000}},	//   _ባለስል, djek, _منیش, --, 
   {{0x8d742b86,0x644008cd,0xfaa40eba,0x00000000}},	//   _جاپا, jnli, _مجری, --, 
   {{0xc5e800ac,0x66080028,0x46a02b87,0x00000000}},	//   কানা_, fjek, ашыб, --, 
   {{0x64402b88,0x6608044e,0xcb642b89,0x3c240055}},	//   enli, gjek, _расе_, _döve_, 
   {{0xb4ac00b3,0xf48414e7,0xdddc01d5,0x48e00074}},	//   गळे_, دابی, _lupů, _котв, 
   {{0xe7c81c54,0x644003c2,0xbb400200,0x66080247}},	//   _रायप, gnli, ﻜﻮﻡ_, ajek, 
   {{0x62840039,0x44002b8a,0x1de0006c,0xb274044a}},	//   _éhol, рчыб, _पसंत, ллош, 
   {{0x64400a18,0x05802b8b,0x00000000,0x00000000}},	//   anli, _кушм, --, --, 
   {{0xe7c82b8c,0x73c4002c,0x798002b0,0xd57402eb}},	//   _रामप, _йәне, _mgmw, _ружь, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5fd02b8d,0x00000000,0x00000000,0x00000000}},	//   द्धल, --, --, --, 
   {{0xdfd80123,0x00000000,0x00000000,0x00000000}},	//   мъӣ_, --, --, --, 
   {{0x0ba40319,0xdeb0024b,0x00000000,0x00000000}},	// [27d0] вшем, _құты, --, --, 
   {{0x798002b0,0x5fd0072d,0x7cd80427,0x4ea401e3}},	//   _agmw, द्दल, ъмур_, _ирма, 
   {{0x9e640020,0x00000000,0x00000000,0x00000000}},	//   _ጸገምና_, --, --, --, 
   {{0xc3300240,0xa3d82b8e,0x7d78080a,0x00000000}},	//   סוף_, _डॉन_, رمەر_, --, 
   {{0x66080cb1,0x64400a0e,0x48a802dc,0x6934038e}},	//   vjek, ynli, фтем_, ынду, 
   {{0xa6c82b8f,0x00000000,0x00000000,0x00000000}},	//   елка_, --, --, --, 
   {{0x64402b90,0x66082b91,0x6d5c02bb,0xdedc0020}},	//   vnli, tjek, _hysa, _ዕደና_, 
   {{0x64402b92,0x24e80efb,0x6d5c03aa,0x16840061}},	//   wnli, емии_, _kysa, داوێ, 
   {{0x66082b93,0x69c8018c,0xc7c4001e,0x64400579}},	//   rjek, _icee, _асеи, tnli, 
   {{0x66082b94,0x6d5c2b95,0xe3b00272,0xe298005b}},	//   sjek, _mysa, حرة_, нао_, 
   {{0x6d5c2b96,0x21a42b97,0x64402b98,0xa6c81325}},	//   _lysa, линм, rnli, _سوشل_, 
   {{0x1e841088,0xb464105a,0x6d5c2b99,0x00000000}},	//   ғлам, лкөл, _oysa, --, 
   {{0xf484023f,0xf6500128,0x00000000,0x00000000}},	//   _кујн, _بئل_, --, --, 
   {{0xf7780c89,0xf4340340,0x00000000,0x00000000}},	//   _taħt_, _кечэ, --, --, 
   {{0x6d5c2b9a,0x69c8071c,0x1c440568,0x62580b61}},	//   _aysa, _ocee, ҳнам, _прир_, 
   {{0x69c80069,0x6d5c2b9b,0x68e82b9c,0xd5e0001c}},	//   _ncee, _bysa, _osed, _khó, 
   {{0x6d5c0086,0x3ba40123,0x00000000,0x00000000}},	// [27e0] _cysa, илаҳ, --, --, 
   {{0x69c82b9d,0x6d5c01b4,0xbd4400ea,0x00000000}},	//   _acee, _dysa, هنځي, --, 
   {{0x68e82b9e,0xd13402b4,0x0c940e2e,0x6d5c0080}},	//   _ased, _ኣስተው, ندەگ, _eysa, 
   {{0x1d0810b5,0x6d5c0086,0x1ea800dd,0x18800020}},	//   _земи_, _fysa, _ٺاھي_, _ክሰግር_, 
   {{0x6d5c2b9f,0xd5e001eb,0x86c00481,0x00000000}},	//   _gysa, _nhó, ەيىن, --, 
   {{0x68e80091,0x4ed40252,0x2c0400cb,0x3db00143}},	//   _dsed, হিৰল, राणं_, ঙ্খল, 
   {{0x68e82ba0,0xd5e00048,0xcb641391,0x182801d9}},	//   _esed, _phò, _баре_, وقچی_, 
   {{0xd4980332,0x34b41deb,0xa28006f7,0xb4b401d9}},	//   нро_, абиё, łość_, айиш, 
   {{0xe8e800e2,0xd5e001eb,0xc68c0012,0x2ee000aa}},	//   _لرلو_, _chó, _ہِل_, _पन्त, 
   {{0x53e40116,0x74340027,0x52b000c3,0x6d400095}},	//   уциа, рноф, مەتئ, _ślak, 
   {{0xcc54007c,0xc5ec00b7,0x00000000,0x00000000}},	//   רביי_, _лѓ_, --, --, 
   {{0xf8c822e2,0x044000c3,0x91e000ec,0x00000000}},	//   _रमाय, _һечн, сәкһ, --, 
   {{0x27480064,0x3e7c007c,0x386c02e6,0x00000000}},	//   _tînï_, _aŭto_, _khdr_, --, 
   {{0x74140ff7,0x2d8c043b,0xc0580049,0x00000000}},	//   _خوتا, _żee_, гіс_, --, 
   {{0x386c0177,0xff040027,0x00000000,0x00000000}},	//   _mhdr_, бятн, --, --, 
   {{0x6d5c01d4,0x95e000d1,0x3da402ba,0x00000000}},	//   _pysa, _खसोट_, йруб, --, 
   {{0xbf14016d,0xc3c01b48,0xe8140030,0xd24c00d5}},	// [27f0] _һүрә, _төөл, _तकला_, _ونڈ_, 
   {{0x6d5c048a,0x00000000,0x00000000,0x00000000}},	//   _vysa, --, --, --, 
   {{0x78bc0025,0xc5e802fa,0xddc400a8,0xdeb00049}},	//   _ārva, কাতা_, _cikų, _мұры, 
   {{0xba74055d,0x68e80078,0xa9c00340,0x00000000}},	//   مانت, _psed, تۅرۉ, --, 
   {{0x7a380237,0x6d5c2ba1,0xd88402ac,0xe9442ba2}},	//   aŭto, _uysa, لهنی, جرای, 
   {{0x25a814ba,0xa6c4071e,0x68e80da7,0x00000000}},	//   _žal_, لقتى, _vsed, --, 
   {{0x8d74006e,0x672c01c6,0xe6100075,0x660401c7}},	//   _جاھا, ĝajo, قشة_, ипка, 
   {{0x68e82ba3,0x57b02ba4,0x69c80043,0x22480237}},	//   _tsed, ббәт, _ucee, _ĉako_, 
   {{0x68e8147c,0xf7780126,0x3d080095,0x291806b4}},	//   _used, _daħq_, समये_, _æsa_, 
   {{0x39142ba5,0xc6a40106,0x00000000,0x00000000}},	//   _умур, _брди, --, --, 
   {{0x2a6c2ba6,0x31680191,0x9f580223,0xdd10015b}},	//   _kheb_, _azaz_, _lopò_, _pļūt, 
   {{0xe3b02a45,0xa4d40302,0x25a802b2,0x00000000}},	//   حرک_, _воді, _þal_, --, 
   {{0xdddc00c2,0x386c015e,0x00000000,0x00000000}},	//   _lupţ, _yhdr_, --, --, 
   {{0xa0682ba7,0x8fa02ba8,0xfaf80059,0xe3b80b61}},	//   тага_, жаре, _šīm_, _рбк_, 
   {{0xdee42ba9,0xd36c03a2,0x31682baa,0x2a6c01d5}},	//   шови, _ٺهي_, _ezaz_, _oheb_, 
   {{0xbdd001c6,0x00000000,0x00000000,0x00000000}},	//   riɨo, --, --, --, 
  
   {{0xa2a02bab,0xd24c2bac,0x9f5800f2,0xeb1400d3}},	// [2800] कीर्, _تني_, _popó_, _òòjé_, 
   {{0x2a6c08a2,0xd00c0272,0x00000000,0x00000000}},	//   _aheb_, _يلي_, --, --, 
   {{0xaec00200,0x5ac800ec,0x00000000,0x00000000}},	//   _нұрл, тлем_, --, --, 
   {{0x2a6c2bad,0x5fd02bae,0x3c2401c5,0x8cc00095}},	//   _cheb_, द्रल, _döva_, िंशो, 
   {{0x386c2baf,0xd944038e,0x6bd40838,0xa3c40777}},	//   _phdr_, шеди, شتەر, एला_, 
   {{0x9854009e,0xd6d80123,0xc7a000b7,0x00000000}},	//   штеш, вти_, оиљк, --, 
   {{0x63ac01e7,0xda780108,0x2b900061,0x00000000}},	//   _ɓant, _җяң_, _رینس, --, 
   {{0x6d40004f,0x00000000,0x00000000,0x00000000}},	//   _ślai, --, --, --, 
   {{0x386c0b0a,0x57e80111,0xd40400f9,0x81ac0143}},	//   _thdr_, _идам_, аяни, খলা_, 
   {{0x07a01298,0x00000000,0x00000000,0x00000000}},	//   _маун, --, --, --, 
   {{0xdb0c012c,0x8c1800ca,0xb23c01d2,0xd7340320}},	//   _odbí, דויי, емнi, _тхаь, 
   {{0x25dc13d7,0xc1ac00c3,0xb9e419ef,0xd7f80320}},	//   _कॉपी_, _ﻳﯩﺮﺍ, _ቫን_, _пуç_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9fa00029,0x04d8067a,0x9f580229,0x00000000}},	//   _bëñu_, _סקול, _ropò_, --, 
   {{0xbe882bb0,0x6e940197,0x00000000,0x00000000}},	//   исте_, сибу, --, --, 
   {{0xdddc00c2,0x3c240207,0x82342bb1,0xca6801d2}},	//   _rupţ, _röva_, _وريا, йiнi, 
   {{0x25dc03c3,0xacf8024b,0xebd82bb2,0xaa580121}},	// [2810] _कॉफी_, ынау_, лдаш_, қиду_, 
   {{0xada401c4,0xa2ac006c,0x3cf80030,0x00000000}},	//   раҡл, ूंच्, _उछरे_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2a6c01f3,0xcb8c02b4,0x00000000,0x00000000}},	//   _qheb_, _ዝጀመረ_, --, --, 
   {{0x201c0207,0x00000000,0x00000000,0x00000000}},	//   ötig_, --, --, --, 
   {{0x1d140107,0x6e0000e2,0x00000000,0x00000000}},	//   _הקשר_, _بېړن, --, --, 
   {{0xd90c00e2,0x00000000,0x00000000,0x00000000}},	//   ویې_, --, --, --, 
   {{0xdddc01d1,0xa3d800aa,0x986800cc,0x66042bb3}},	//   _kupš, ड्न_, _ەلكە_, спиа, 
   {{0xe4580a3d,0x852003b5,0xa81400bf,0xe57800b8}},	//   лжи_, ڵوگۆ, _лдаш, ызи_, 
   {{0x291c2bb4,0x00000000,0x00000000,0x00000000}},	//   mywa_, --, --, --, 
   {{0xe7182bb5,0x182801d9,0x61e00031,0x00000000}},	//   _حيات_, _حقلی_, _ıolb, --, 
   {{0xf5e4021d,0x00000000,0x00000000,0x00000000}},	//   _мічм, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2e400fc,0x84c0012b,0x00000000,0x00000000}},	//   _гокд, _ләүд, --, --, 
   {{0xc2140130,0x442401f5,0x64a40108,0x9e640108}},	//   _toɔ_, _iln_, _таһа, مارن, 
   {{0x25ac2bb6,0x44242bb7,0x2d840031,0x00000000}},	//   nael_, _hln_, _şler_, --, 
   {{0x61e42bb8,0x6fb00608,0x00000000,0x00000000}},	// [2820] mekl, _जयचं, --, --, 
   {{0x61e42bb9,0x60c42bba,0x442426eb,0xdddc00e0}},	//   lekl, mukm, _jln_, _dupš, 
   {{0xdddc2848,0x60c42bbb,0x6fa80182,0xd7f802e2}},	//   _eupš, lukm, _өвөг_, ғул_, 
   {{0x61e42bbc,0x38c80063,0x4e2400fc,0x1d800061}},	//   nekl, لاتی_, _гоюн_, _رگرێ, 
   {{0x25ac009c,0x7e642bbd,0xd83800fc,0x5cf40152}},	//   dael_, mlip, лэк_, _уяну, 
   {{0x7e642bbe,0x61e42bbf,0x44242bc0,0x00000000}},	//   llip, hekl, _nln_, --, 
   {{0x61e42bc1,0x7e642bc2,0x60c42bc3,0x248c0110}},	//   kekl, olip, hukm, eqem_, 
   {{0x61e42bc4,0x7e6410ed,0x248c0110,0x7afc2bc5}},	//   jekl, nlip, fqem_, _irrt, 
   {{0x61e42bc6,0x99840151,0x7e642bc7,0x00000000}},	//   dekl, lhoů_, ilip, --, 
   {{0x60c40a65,0x7e64273a,0x7afc0475,0x00000000}},	//   dukm, hlip, _krrt, --, 
   {{0x25ac14a5,0x7bdc2bc8,0x61e4059c,0x00000000}},	//   bael_, _mbru, fekl, --, 
   {{0x7e6401f8,0xcb100107,0x61e42bc9,0x25ac0207}},	//   jlip, ללת_, gekl, cael_, 
   {{0x7bdc2bca,0x661c0274,0x44240386,0x00000000}},	//   _obru, öske, _fln_, --, 
   {{0x7afc02b0,0xdddc028d,0x70a80098,0x156401ac}},	//   _orrt, _rupš, _कबील, _پٽڙي_, 
   {{0x61e40dda,0xfbcc02ef,0x40340634,0x291c03ef}},	//   bekl, ालनम, черс, zywa_, 
   {{0x7e6410ed,0xa294049d,0x61e42bcb,0xd24c03a2}},	//   glip, _بدوڵ, cekl, _ڪنڊ_, 
   {{0x7bdc0177,0x42380107,0x8d38001d,0x60c40055}},	// [2830] _bbru, _לנהל_, _በዘላቂ, cukm, 
   {{0x7e642bcc,0x25ac01f1,0x5fa800aa,0xcfb00143}},	//   alip, zael_, करणल, ঞ্জন, 
   {{0x7e6426bf,0x70a8006c,0x00000000,0x00000000}},	//   blip, _कबुल, --, --, 
   {{0x291c2bcd,0x7e642bce,0x7bdc071c,0xae1c2bcf}},	//   tywa_, clip, _ebru, _नविन_, 
   {{0x7afc2bd0,0xa7a80edd,0x278800b8,0x6e2c0386}},	//   _errt, акла_, аӡеи_, mhab, 
   {{0x6e2c1f7e,0xa69415b0,0x61e42bd1,0x291c03ef}},	//   lhab, ориј, zekl, rywa_, 
   {{0x248c0110,0x998402e3,0x25ac0105,0x94dc02a0}},	//   wqem_, choů_, tael_, _içər_, 
   {{0x6e2c2bd2,0x0ba8160e,0xbb4803e0,0x7bdc012c}},	//   nhab, _جاڭى_, _الفن_, _zbru, 
   {{0x44240440,0x36d400b8,0x61e42bd3,0x49000094}},	//   _pln_, _ҭоур, vekl, _хүлг, 
   {{0xe7041447,0xfbcc09c5,0x6e2c2bd4,0x69d80aea}},	//   _وسای, ालयम, hhab, lfwe, 
   {{0x6e2c2bd5,0xf9900012,0x25b82787,0x44242bd6}},	//   khab, _آبہ_, _نهاد_, _vln_, 
   {{0x60c41ea5,0x61e403f4,0x6e2c2bd7,0x9f5800d3}},	//   tukm, uekl, jhab, _nnpá_, 
   {{0x61e42bd8,0x6e2c2bd9,0xcfb00cce,0x44242bda}},	//   rekl, dhab, ঞ্ছন, _tln_, 
   {{0x6e2c0034,0xa8780100,0xf49400fb,0x00000000}},	//   ehab, יאָר, _хăрн, --, 
   {{0x61e42bdb,0x7e64006f,0x60c417cd,0xbdd001c6}},	//   pekl, tlip, sukm, liɨi, 
   {{0x22b40025,0x7e642bdc,0x7bdc20d5,0x61e40636}},	//   māk_, ulip, _sbru, qekl, 
   {{0x22b40025,0x7e642bdd,0x99840151,0x71580049}},	// [2840] lāk_, rlip, zioų_, _грэс_, 
   {{0x7e642bde,0x69d82bdf,0x6e2c0472,0x00000000}},	//   slip, efwe, ahab, --, 
   {{0x6e2c2be0,0x7e640b5f,0x22b40025,0xd24c2be1}},	//   bhab, plip, nāk_, _سنی_, 
   {{0x6e2c2be2,0xceb000ca,0x00000000,0x00000000}},	//   chab, _קיר_, --, --, 
   {{0xd7e82be3,0x24880306,0x00000000,0x00000000}},	//   имде_, _éamh_, --, --, 
   {{0x22b40059,0x69d80952,0xe9702343,0x4c800074}},	//   kāk_, afwe, رۇلد, _оляв, 
   {{0xdcf42be4,0x73c40087,0xea6400d5,0x22b400ce}},	//   mayı, җәле, _کھلی, jāk_, 
   {{0xdcf42be5,0x22b400d4,0x597400b8,0x99840151}},	//   layı, dāk_, _дызу, rioų_, 
   {{0x5fa82be6,0x00000000,0x00000000,0x00000000}},	//   कराल, --, --, --, 
   {{0x18680ba3,0x68ec2be7,0x6e2c2be8,0x47c02be9}},	//   _тази_, çade, zhab, _обув, 
   {{0x92682bea,0x6e2c025e,0xd62802c9,0x22b40059}},	//   ирма_, yhab, _коже_, gāk_, 
   {{0xdcf40055,0x6e2c2beb,0x6ef4012c,0x00000000}},	//   hayı, xhab, hýbá, --, 
   {{0xdcf40680,0x76400139,0x3d040098,0x00000000}},	//   kayı, mimy, रमों_, --, 
   {{0x76402bec,0x22b40025,0x6e2c00dd,0x249802ba}},	//   limy, bāk_, whab, ísme_, 
   {{0x6e2c2bed,0xdcf42bee,0x786402ba,0x75200379}},	//   thab, dayı, gòvi, lymz, 
   {{0x2bdc011c,0xac940551,0x9de4011a,0x200c0528}},	//   न्ना, зааш, _སྒྱེ, _òfin_, 
   {{0x6e2c2bef,0x82e40560,0x8d742bf0,0x00000000}},	// [2850] rhab, _འགོའ, زارا, --, 
   {{0xd24c1cbe,0x6e2c2bf1,0x76402bf2,0x22582bf3}},	//   _سنڌ_, shab, himy, čske_, 
   {{0x69d82bf4,0x76402bf5,0x6e2c2bf6,0xbca800c3}},	//   tfwe, kimy, phab, مدەك_, 
   {{0x7c3c0d92,0x7640017b,0x6e2c08c2,0x69d80104}},	//   _emrr, jimy, qhab, ufwe, 
   {{0x9de40002,0x22b40025,0x76400105,0x06881812}},	//   _སྒྲེ, zāk_, dimy, ﮔﯩﻨﯩ, 
   {{0xac5400dd,0xdcf40387,0x00000000,0x00000000}},	//   _ڀرڳڙ, cayı, --, --, 
   {{0x764001b1,0xdce400d4,0x69d80104,0xac941baf}},	//   fimy, _izkā, pfwe, _фаҳш, 
   {{0x76402bf7,0x69d80337,0x22b42bf8,0x00000000}},	//   gimy, qfwe, vāk_, --, 
   {{0xf7702bf9,0xa9a40121,0xbc680012,0x00000000}},	//   _یام_, _миңд, _طمہن_, --, 
   {{0x87042bfa,0x22b40059,0xf77001ac,0x00000000}},	//   _وبال, tāk_, _ڌام_, --, 
   {{0x2bdc2bfb,0x7640017b,0xfbcc00aa,0x00000000}},	//   न्या, bimy, ालतम, --, 
   {{0x22b411a4,0x2c6c2737,0x26f82bfc,0xd5a401b8}},	//   rāk_, _vždy_, ्मीर_, _فلمی, 
   {{0x22b400d4,0xdcf413d8,0x00000000,0x00000000}},	//   sāk_, yayı, --, --, 
   {{0x2bdc0ad3,0x6618011a,0x00000000,0x00000000}},	//   न्मा, _howk, --, --, 
   {{0x64402bfd,0x91a82bfe,0x5fd000cb,0x53980cdd}},	//   mili, _কাৰ্, द्गल, _פיקו, 
   {{0xd33400ca,0x00000000,0x00000000,0x00000000}},	//   _מרצה_, --, --, --, 
   {{0x22402bff,0x61440cac,0xdcf42c00,0x64402c01}},	// [2860] mikk_, _хепа, tayı, oili, 
   {{0x61f42c02,0x22400c81,0x76400185,0x661811ae}},	//   _hayl, likk_, zimy, _lowk, 
   {{0x61f42c03,0xdcf42c04,0x7640017b,0x64402c05}},	//   _kayl, rayı, yimy, iili, 
   {{0x64402c06,0x61f42c07,0x22400c81,0x20182c08}},	//   hili, _jayl, nikk_, _hopi_, 
   {{0x64402c09,0x61f42c0a,0xc98000c3,0xdcf4059c}},	//   kili, _mayl, нуши, payı, 
   {{0x64402c0b,0x20182c0c,0x764000ba,0x02d800cb}},	//   jili, _jopi_, wimy, _बहून, 
   {{0x64402c0d,0x76402c0e,0x66182c0f,0x201801c4}},	//   dili, timy, _bowk, _mopi_, 
   {{0xa3d82c10,0x20182c11,0x64402c12,0xf4a8001d}},	//   ड्स_, _lopi_, eili, _መቁረጥ_, 
   {{0x76402c13,0xf4340254,0xd87408ea,0x661c01c5}},	//   rimy, депэ, _فائب, öska, 
   {{0x1cd80560,0x20180d8c,0x20d40034,0x76402c14}},	//   ྡ྄ར_, _nopi_, dæi_, simy, 
   {{0x61f42c15,0x46a02c16,0x22402c17,0x66182c18}},	//   _bayl, _захв, fikk_, _fowk, 
   {{0x61f42c19,0x22402c1a,0xbba8161f,0x66180031}},	//   _cayl, gikk_, गरुक, _gowk, 
   {{0x61f42c1b,0x44440012,0x20182c1c,0xfbcc09c5}},	//   _dayl, _کرنہ, _bopi_, ालाम, 
   {{0x20182c1d,0x6e3c2c1e,0x94200340,0x3d0000aa}},	//   _copi_, _smsb, _سوعۇ, रिने_, 
   {{0x61f42c1f,0x64b4059c,0x00000000,0x00000000}},	//   _fayl, _eşiğ, --, --, 
   {{0x61f42c20,0x00000000,0x00000000,0x00000000}},	//   _gayl, --, --, --, 
   {{0x32080d07,0xc1bc0240,0x201803f2,0x28d01953}},	// [2870] _inay_, _המחש, _fopi_, _समधि, 
   {{0x20182c21,0x61f42c22,0xa3c40203,0x0b8802dc}},	//   _gopi_, _zayl, एलए_, ссаи_, 
   {{0x61f42c23,0x64b40031,0xa7e400c3,0x15d80049}},	//   _yayl, _işiş, ېكتى, _ﺃﺤﺎﺩ, 
   {{0x61f40fdc,0x64402c24,0x6e3c02b0,0x19c0001e}},	//   _xayl, zili, _umsb, кәуг, 
   {{0x20182c25,0x9f58021c,0xfcc800c3,0x1f500020}},	//   _yopi_, _enpä_, _нурй_, _ዘስደም, 
   {{0x64402c26,0x66180080,0xdce400ce,0xa95000e3}},	//   xili, _sowk, _uzkā, _یہاں, 
   {{0x32082c27,0xba0800c3,0x91bc01f0,0x00000000}},	//   _onay_, تتەك_, ्लाई, --, 
   {{0x64400f32,0x76c400c3,0xe5e00023,0x00000000}},	//   wili, رغىل, тыкi_, --, 
   {{0x61f42c28,0x3d002c29,0x9f5801c5,0x00000000}},	//   _rayl, रिये_, _inpå_, --, 
   {{0x61f42c2a,0x32082c2b,0xe7b42c2c,0x64402c2d}},	//   _sayl, _anay_, _آماد, uili, 
   {{0x61f42c2e,0x22402c2f,0x20182c30,0x66180031}},	//   _payl, tikk_, _ropi_, _towk, 
   {{0x2bdc2c31,0x61f42c32,0x216826ba,0xdb0c0385}},	//   न्ता, _qayl, жими_, _bebê, 
   {{0x22400ff0,0x61f42c33,0x9f4801f1,0x00000000}},	//   rikk_, _vayl, cebê_, --, 
   {{0x2240036a,0x61f40919,0xdee42c34,0x64402c35}},	//   sikk_, _wayl, моги, qili, 
   {{0x224000af,0xfbcc1667,0x00000000,0x00000000}},	//   pikk_, ालसम, --, --, 
   {{0x61f402df,0x74a411d0,0x00000000,0x00000000}},	//   _uayl, चीकृ, --, --, 
   {{0x20182c36,0xdb0c05ab,0x0f4802b4,0x00000000}},	// [2880] _topi_, _gebê, _ዘድልየ, --, 
   {{0x3208034a,0x25dc2c37,0xcb48024b,0xcf8c01b5}},	//   _znay_, क्ती_, дiрi, _نژِ_, 
   {{0x2bdc2c38,0x3e480254,0xa2a000b3,0x5f4404c3}},	//   न्धा, eşte_, कीच्, _آنجل, 
   {{0xfaf80025,0x1d082843,0x00000000,0x00000000}},	//   _šīs_, _деми_, --, --, 
   {{0x249c01f9,0x08942c39,0xd8380007,0x127800cf}},	//   _ntwm_, وضوع_, жэй_, קאנע, 
   {{0x2bdc2c3a,0x399400c4,0x68ec2c3b,0x3f9819ab}},	//   न्दा, _bûsó_, çada, ncru_, 
   {{0xdb0c038a,0x3e4800c2,0xcb642c3c,0x67b400ea}},	//   _mebë, aşte_, _жаре_, رجوړ, 
   {{0x3e4800c2,0x99f40023,0x8a000668,0x675400e3}},	//   bşte_, _ўяві, _изсе, رینس_, 
   {{0x05bc0325,0x25bc0335,0x62940237,0x00000000}},	//   _एयरब, _ddwl_, ŭzol, --, 
   {{0xdecc00ff,0xd5e80012,0x00000000,0x00000000}},	//   ብለን_, _ژٹان_, --, --, 
   {{0x97242c3d,0xdb0c00c4,0x00000000,0x00000000}},	//   _تفاو, _sebê, --, --, 
   {{0xd50800dd,0xd6241fbf,0x00000000,0x00000000}},	//   _وٺان_, _تعطي, --, --, 
   {{0x225000ef,0x71240108,0x00000000,0x00000000}},	//   ézka_, رىسم, --, --, 
   {{0x225801d4,0x00000000,0x00000000,0x00000000}},	//   čska_, --, --, --, 
   {{0x60c40b1e,0xb9000560,0xdb0c02bb,0x81e40143}},	//   arkm, _ཧད_, _debë, নয়_, 
   {{0x3f9819ab,0x32082c3e,0x00000000,0x00000000}},	//   acru_, _unay_, --, --, 
   {{0x32d82c3f,0x00000000,0x00000000,0x00000000}},	// [2890] léy_, --, --, --, 
   {{0xdb0c2c40,0x4fc40023,0x70542c41,0x417401d2}},	//   _kebè, _ўспа, _سنجا, _جاىس, 
   {{0xfbd000e2,0xba7400d5,0x671c006c,0x00000000}},	//   شتل_, چانت, _बॅंक_, --, 
   {{0xc27c00cf,0x00000000,0x00000000,0x00000000}},	//   ַרגי, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c04002f,0xec34007c,0x3168000d,0xae0c00b6}},	//   राओं_, _טאָר_, _myaz_, हावन_, 
   {{0x9984002c,0xa3d80203,0x974c0020,0xf4140143}},	//   мтәһ, _डॉग_, _ዕንወት, িসার_, 
   {{0xd5e80002,0x00000000,0x00000000,0x00000000}},	//   _རྒྱག, --, --, --, 
   {{0x316814c5,0xe50800e2,0xe758005e,0x75340094}},	//   _nyaz_, سيدو_, _کلاغ_, вээх, 
   {{0xdb0c1f23,0x387c015e,0xe2c8138a,0x7b080152}},	//   _bebè, cmvr_, плод_, _üstä, 
   {{0x33f40340,0x31682c42,0xe5e00007,0x32d80d8c}},	//   тчыс, _ayaz_, _былi_, géy_, 
   {{0xdb0c0078,0x00000000,0x00000000,0x00000000}},	//   _debè, --, --, --, 
   {{0xe4d800e2,0x00000000,0x00000000,0x00000000}},	//   _روغت_, --, --, --, 
   {{0x316800f1,0x3f8c014e,0x00000000,0x00000000}},	//   _dyaz_, ødu_, --, --, 
   {{0x9e740294,0x00000000,0x00000000,0x00000000}},	//   ећај, --, --, --, 
   {{0x2bdc2c43,0xdee40123,0xe3b001ac,0x00000000}},	//   न्सा, моҳи, _شرڪ_, --, 
   {{0xda5806c3,0xf778011a,0x00000000,0x00000000}},	// [28a0] үреш_, _waħx_, --, --, 
   {{0x4d602c44,0xc5e80143,0x6a700207,0x5b5400b7}},	//   укув, কাটা_, våfa, нтеѕ, 
   {{0x4fd419fc,0xe7c82c45,0x9f480249,0x00000000}},	//   _אויב_, _राजप, kebé_, --, 
   {{0xdca42c46,0x661c0207,0x00000000,0x00000000}},	//   _пами, öskl, --, --, 
   {{0x2bdc2c47,0x18682c48,0x1cc80560,0xae0c0030}},	//   न्हा, пади_, _ཊའི_, हारन_, 
   {{0x25dc2c49,0xb90811ce,0x986401b5,0xdb0c00f2}},	//   क्सी_, _बह_, ریاے_, _lebé, 
   {{0x32d80110,0xbbcc00aa,0xfce00020,0x629400cf}},	//   xéy_, ालीक, _ሓዲጉ_, ŭzoj, 
   {{0xdb0c2c4a,0xca340200,0xa5bc00b0,0x1c0c03e4}},	//   _rebè, _ﯗﻟﺖ_, lkųj, सावल_, 
   {{0x2bdc00cb,0x788400b8,0x98a402dc,0xa49001d9}},	//   न्वा, _акаҷ, _чизе, لینت, 
   {{0xccf00240,0x88b80107,0x72d000c3,0x291800d3}},	//   רכז_, _מזמי, لەتچ, _àsaa_, 
   {{0x07a007df,0xdb0c2c4b,0x9f4804ac,0xf4842c4c}},	//   _сахн, _bebé, bebé_, _یاتی, 
   {{0x32d82c4d,0xd1640123,0x00000000,0x00000000}},	//   réy_, еъги, --, --, 
   {{0xdb0c0a24,0x32d80039,0x201c01d9,0x00000000}},	//   _debé, séy_, аti_, --, 
   {{0xd7540422,0x27e80091,0xdb0c0078,0x148400dd}},	//   _ውሕስነ, đang_, _tebè, _ڪپڙي_, 
   {{0xa3d80c07,0x6e9400b7,0x00000000,0x00000000}},	//   _डॉट_, тибу, --, --, 
   {{0xdb0c2c4e,0x28d02c4f,0x9e6c001d,0x00000000}},	//   _gebé, _समलि, _በጥሞና_, --, 
   {{0x8bc42c50,0x00000000,0x00000000,0x00000000}},	// [28b0] есед, --, --, --, 
   {{0x7bf80abc,0x1ea800dd,0x00000000,0x00000000}},	//   ннур_, _ڪاٿي_, --, --, 
   {{0x0a6800cc,0x41741826,0x00000000,0x00000000}},	//   прди_, _لایس, --, --, 
   {{0xf99002a5,0x68ec2c51,0x00000000,0x00000000}},	//   مبه_, çado, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd3642c52,0xab94005b,0x97c00c3f,0xc174067a}},	//   _نه_, _јављ, айше, נחס_, 
   {{0x9ba0006e,0x1cdc0126,0xda0000b6,0xe6180123}},	//   _ئەمى, _རཱོ_, _रोवत_, ддй_, 
   {{0x24982c53,0x649810f1,0x00000000,0x00000000}},	//   ísmo_, мтор_, --, --, 
   {{0xe89402b3,0x9f4800e7,0xdb0c2c54,0x3e480055}},	//   _разь, rebé_, _rebé, nşta_, 
   {{0x68e80379,0xe2982c55,0xdb0c2c56,0xe3b00075}},	//   _iped, мао_, _sebé, جرة_, 
   {{0xe8d02c57,0x3f8c00e9,0x21a42c58,0x00000000}},	//   _समुच, žduk_, кинм, --, 
   {{0xa1142c59,0xb46400cc,0x1fa800bd,0x00000000}},	//   پوست, ккөл, कर्ड, --, 
   {{0x6f040306,0x9f9c0055,0x3914044a,0x00000000}},	//   _arhc, nççi_, _умăр, --, 
   {{0x25dc11e9,0x68e8007b,0x70180103,0xe36401cf}},	//   क्री_, _mped, ніст_, _икли, 
   {{0x9e641088,0xdb0c0039,0xe8e401ac,0x00000000}},	//   نارن, _tebé, _ڏڻ_, --, 
   {{0xe8d00774,0x9f580222,0x68e82c5a,0x05100143}},	//   _समूच, _hapë_, _oped, িনীর_, 
   {{0x6f0404cd,0x9f580475,0x12780100,0xd7d0006c}},	// [28c0] _erhc, _kapë_, _קאפע, _सालच, 
   {{0x9f5802b4,0xbbcc02ef,0xb7bc00e0,0xd9b800bd}},	//   _japë_, ालेक, _koģe, उण्ट, 
   {{0x68e82c5b,0x00000000,0x00000000,0x00000000}},	//   _aped, --, --, --, 
   {{0x98a42c5c,0x01b002fa,0xdb0800d3,0x00000000}},	//   виде, _কাঁদ, _ènít, --, 
   {{0x68e814c5,0xec1000c3,0x00000000,0x00000000}},	//   _cped, _گۈلد, --, --, 
   {{0xe9800121,0x8ba00c41,0x69dc02e6,0x91380676}},	//   сқун, _вирж, _ösen, וענק, 
   {{0x68e80b66,0x24a4010f,0x2b902c5d,0xcf900107}},	//   _eped, _ለሁለት_, _ایمس, סטה_, 
   {{0x24800090,0xd4980155,0x35f42c5e,0x7e642c5f}},	//   _ከሁለት_, мро_, упир, noip, 
   {{0x44b000cc,0xaa640027,0x00000000,0x00000000}},	//   абыс, _стёк, --, --, 
   {{0x7e642c60,0xddd400df,0x9874118d,0x00000000}},	//   hoip, ylyş, _рубљ, --, 
   {{0x1db006a7,0x0bb4047b,0xd774059b,0x00000000}},	//   जरात, כלים_, _شائع, --, 
   {{0x27e8091d,0x7e640247,0x68e806e2,0xd7d02a54}},	//   đane_, joip, _yped, _साँच, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xbbcc0095,0x930401f1,0x00000000,0x00000000}},	//   ालोक, _аџил, --, --, 
   {{0x1cdc0560,0x92e804e7,0xd2580ce1,0x70440049}},	//   _རཱུ_, _آرتق_, _оци_, _ەرجە, 
   {{0xfda4005b,0x7e6405e1,0xa34c00ef,0x00000000}},	//   ијум, goip, ščák, --, 
   {{0x9f58029f,0xd7d00d54,0x25a002a0,0xdd000055}},	// [28d0] _lapè_, _सांच, _əhl_, ğuğu, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68e82c61,0xbf142c62,0x7e642188,0xe9440324}},	//   _sped, _күрә, boip, گرای, 
   {{0xa9340027,0x15e00cb0,0x00000000,0x00000000}},	//   лееш, _कॉलर_, --, --, 
   {{0x6e2c2c63,0xe9440e5a,0xf9902c64,0x26c0011a}},	//   mkab, درای, زبن_, ġhom_, 
   {{0x6e2c2c65,0xf99001d0,0x920001d3,0x00000000}},	//   lkab, مبۇ_, _śālm, --, 
   {{0x2ba80b13,0x48ec002f,0x6e2c042e,0xba742c66}},	//   _च्या, _इनको_, okab, _چاقت, 
   {{0xcd440090,0xba742c67,0x7d0c012b,0x88a0044a}},	//   _በመንፈ, _ناقت, _ülsä, _влаç, 
   {{0x68e82c68,0x6e2c2c69,0x9f5802bb,0x00000000}},	//   _uped, ikab, _papë_, --, 
   {{0x7e642c6a,0x6e2c2c6b,0x00000000,0x00000000}},	//   zoip, hkab, --, --, 
   {{0x6e2c2c6c,0x23280155,0x7e6401ac,0x051002fa}},	//   kkab, хони_, yoip, িনের_, 
   {{0x65942c6d,0x36342c6e,0xe3b00012,0x25a80101}},	//   _саду, _پرمس, جرک_, _ýal_, 
   {{0x6e2c2c6f,0xdce400e5,0x7e640139,0x00000000}},	//   dkab, _pykč, voip, --, 
   {{0x9f58008f,0x63042c70,0x6e2c0023,0x00000000}},	//   _hapé_, _موتل, ekab, --, 
   {{0xd0040254,0x6e2c028b,0xa2e40027,0x00000000}},	//   ыере_, fkab, _сойд, --, 
   {{0x6e2c2c71,0x3e7c01c6,0xbbcc025c,0x645c0c0d}},	//   gkab, _oƭte_, ाल्क, ésif, 
   {{0xdca42c72,0x80e80608,0x7e6400b8,0x6d4002a0}},	// [28e0] уази, _ओहिओ_, roip, _əlag, 
   {{0x6e2c2c73,0x1c0c0303,0xae0c0192,0x00000000}},	//   akab, साइल_, हाउन_, --, 
   {{0x7e642c74,0x6e44020c,0x6e2c2c75,0x70442c76}},	//   poip, útbú, bkab, _түрм_, 
   {{0x6e2c2c77,0x9f5800f1,0xd1d4001d,0xb4f803bf}},	//   ckab, _rapè_, _ርዳታ_, ्टमय_, 
   {{0x9f580fb6,0x3c24009f,0x1cdc011a,0x3940077d}},	//   _sapè_, _dövr_, _རཱི_, àis_, 
   {{0x7d0404fe,0xb8dc0076,0xdb0c01d5,0x99840151}},	//   mvis, _आब_, _hebí, skoů_, 
   {{0x3ce0212b,0xdb0c01d4,0x00000000,0x00000000}},	//   ltiv_, _kebí, --, --, 
   {{0xceb00240,0x9f582c78,0x7d042c79,0xb3680020}},	//   זיה_, _capé_, ovis, _ሳንዱቕ_, 
   {{0x7d0418c7,0x3ce02c7a,0x25b80849,0x97c417db}},	//   nvis, ntiv_, ðsla_, _متضم, 
   {{0x7d042c7b,0x28c803e4,0x888000b7,0x00000000}},	//   ivis, _रिति, _глуж, --, 
   {{0x7d0406ea,0x32542c7c,0x3ce000b6,0x97540294}},	//   hvis, ивор, htiv_, _стаљ, 
   {{0x3ce02c7d,0x7d042c7e,0xdb0c00ef,0x6e2c2c7f}},	//   ktiv_, kvis, _nebí, xkab, 
   {{0x7d042c80,0xc5f00240,0x3ce00091,0x6e2c007b}},	//   jvis, _לדף_, jtiv_, vkab, 
   {{0x6d400387,0x00000000,0x00000000,0x00000000}},	//   _əlad, --, --, --, 
   {{0xdb0c0b07,0x7d0411b4,0x765c0247,0x1c0c00b6}},	//   _bebí, evis, _êrys, साईल_, 
   {{0x2134014a,0x7d042c81,0x8d8400bf,0x712400cc}},	//   êché_, fvis, гузд, _نىعم, 
   {{0xdb0c0ab9,0x661c021c,0x7d042c82,0x6c8401d9}},	// [28f0] _debí, öski, gvis, للرم, 
   {{0x6e2c2c83,0x00000000,0x00000000,0x00000000}},	//   skab, --, --, --, 
   {{0xbca8006e,0x7d042c84,0xba740411,0x6e2c0085}},	//   ندەك_, avis, ڭالت, pkab, 
   {{0x7d040a84,0x2d4c01c6,0xe4e40030,0x00000000}},	//   bvis, _tɾe_, _कहलि_, --, 
   {{0x3ce02c85,0xab9401f5,0x48a80123,0x8cc400fb}},	//   ctiv_, _вигі, хтем_, _сĕлĕ_, 
   {{0x2ca82c86,0x6d5c2c87,0x9f5800b7,0xfbcc02fa}},	//   mpad_, _ixsa, _sapé_, র্বত, 
   {{0x2ca82c88,0x9c600411,0x00000000,0x00000000}},	//   lpad_, _بۇلو, --, --, 
   {{0xc2140130,0xd5ac1906,0x00000000,0x00000000}},	//   _ahɔn_, وفى_, --, --, 
   {{0xdee42c89,0xe57804e7,0x7d0021c2,0xbc680012}},	//   ዝብና_, ъзи_, _ámst, _شمہن_, 
   {{0xa4442c8a,0xe2e4021d,0x00000000,0x00000000}},	//   рнод, ажоп, --, --, 
   {{0x9f582c8b,0x7d040582,0x63780362,0xa2e400f8}},	//   _tapé_, zvis, ъсир_, шонд, 
   {{0x7d042c8c,0x2ca8006a,0x6d5c2c8d,0xf7480075}},	//   yvis, kpad_, _oxsa, _حلمي_, 
   {{0x25ac2c8e,0x23dc07aa,0x2ca80207,0x21740123}},	//   mbel_, _मापद, jpad_, рунр, 
   {{0x7d042c8f,0x645c2c90,0x25ac2c91,0x2ca805b8}},	//   vvis, ésid, lbel_, dpad_, 
   {{0xc4442c92,0x6d5c2c93,0x81c002fa,0x7d042c94}},	//   _لیکن_, _axsa, ুভব_, wvis, 
   {{0x6304166c,0x3ce00c89,0x25ac2b19,0x7d042c95}},	//   _موڪل, ttiv_, nbel_, tvis, 
   {{0x1c442c96,0x7d042c97,0x2ca80039,0x61e4018c}},	// [2900] анам, uvis, gpad_, mfkl, 
   {{0x3ce02c98,0x61e42c99,0xdb0c012c,0x00000000}},	//   rtiv_, lfkl, _webí, --, 
   {{0x3ce02c9a,0x6d5c2c9b,0x5e440012,0x25ac0055}},	//   stiv_, _exsa, _نندٕ, kbel_, 
   {{0x7d042c9c,0xd9d02b2a,0x25ac10a8,0x3ce02c9d}},	//   pvis, تەرگ, jbel_, ptiv_, 
   {{0x7d042c9e,0xa04002b4,0x6aa801f6,0xd8f400fc}},	//   qvis, _ኣብነታ, _čefe, рчеь, 
   {{0x25ac2c9f,0x00000000,0x00000000,0x00000000}},	//   ebel_, --, --, --, 
   {{0xb908009d,0x19b80254,0x00000000,0x00000000}},	//   _څښتن_, _аузь_, --, --, 
   {{0x27e816c6,0x34b41072,0x25ac03f4,0xd7d00b02}},	//   đana_, ббиё, gbel_, _साकच, 
   {{0x15e0058a,0x73c401c4,0x8e340100,0xfbcc00dc}},	//   क्षर_, бәйе, ינקא_, র্ণত, 
   {{0x3a2408be,0x25ac11c6,0x2874001e,0x71400020}},	//   _homp_, abel_, _лыхр, _ኣስማቶ, 
   {{0x25ac2ca0,0xf2e82c4c,0x14c000b3,0x61e4002a}},	//   bbel_, اکته_, _शिकण, ffkl, 
   {{0x2ca82ca1,0x3a240151,0xabdc01d2,0x00000000}},	//   ypad_, _jomp_, _ﺇﻫﻤﺎ, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x50642ca2,0x10482ca3,0x3a240952,0x61e40085}},	//   ртма, тями_, _lomp_, afkl, 
   {{0xc05810aa,0x25dc0267,0x645c2ca4,0xd148001d}},	//   рія_, क्की_, ésie, መራቸው, 
   {{0x2ca82ca5,0x3a242ca6,0x82641f6b,0x00000000}},	//   tpad_, _nomp_, _وهون, --, 
   {{0x8d8401d9,0xdb0c0201,0x00000000,0x00000000}},	// [2910] рувд, _odbó, --, --, 
   {{0x2ca8060f,0x0ba42ca7,0x83b80108,0x00000000}},	//   rpad_, ршам, ﻠﻤﺎﺳ, --, 
   {{0xd1bc0090,0x25ac03f4,0x6e9401ac,0x28c800b6}},	//   _ሶስት_, ybel_, _دلجا, _रिहि, 
   {{0x2ca801c9,0x7bdc043e,0x3a242ca8,0xfbd000e7}},	//   ppad_, _ecru, _comp_, كتۅ_, 
   {{0x3a2402e3,0x2908000f,0x22480029,0x00000000}},	//   _domp_, íaa_, _ňakk_, --, 
   {{0x7bdc0075,0x3a2408be,0x067c0682,0xb804004f}},	//   _gcru, _eomp_, ﺯﯨﻨﯩ, _idṛś, 
   {{0x26c02ca9,0x25ac2075,0x3a240151,0x4b500012}},	//   ého_, tbel_, _fomp_, _بێار, 
   {{0x26c8091d,0xa3a82caa,0x3a240151,0x25ac018c}},	//   čao_, गुन_, _gomp_, ubel_, 
   {{0x69d80990,0xa4442cab,0x7bdc007b,0x69340197}},	//   mgwe, йнид, _ycru, _унау, 
   {{0xc6e408a1,0x3a240151,0x69d802e3,0x00000000}},	//   _відп, _zomp_, lgwe, --, 
   {{0x9f580880,0xe3642cac,0x69d803f4,0x25ac03f4}},	//   _capì_, скни, ogwe, pbel_, 
   {{0x69d82cad,0x61e40104,0xe1f00075,0x39400097}},	//   ngwe, ufkl, أسد_, ùisg_, 
   {{0x64a42cae,0x661c0038,0x6d400387,0xb16400ec}},	//   _уала, ösku, _əlac, жняһ, 
   {{0x8fa02caf,0xa878007c,0x00000000,0x00000000}},	//   заре, טאָר, --, --, 
   {{0x69d82cb0,0x7bdc0034,0xb8040095,0x28d00098}},	//   kgwe, _rcru, _adṛś, _समझि, 
   {{0x7bdc2cb1,0xfb1801b5,0xdb0c03aa,0x629401c6}},	//   _scru, یراں_, _nebá, ŭzos, 
   {{0x3a240ac8,0x6284002a,0x00000000,0x00000000}},	// [2920] _romp_, mmko, --, --, 
   {{0xdec02cb2,0xd37c0473,0x69d8018c,0x3a240029}},	//   ትሪክ_, šćem_, egwe, _somp_, 
   {{0x5f042cb3,0x3a242cb4,0x9f041026,0x9f5800f1}},	//   _узна, _pomp_, _اوجو, _enpò_, 
   {{0xd6d80155,0x69d82cb5,0x00000000,0x00000000}},	//   ҳти_, ggwe, --, --, 
   {{0xdb0c000f,0x62842cb6,0x98482cb7,0x1cb800d6}},	//   _debá, imko, ляка_, _حاجب_, 
   {{0xd6d82cb8,0x69d80472,0x00000000,0x00000000}},	//   гти_, agwe, --, --, 
   {{0xfe1c2cb9,0x3d002cba,0x69d80047,0x00000000}},	//   _पचास_, रिके_, bgwe, --, 
   {{0xc2140130,0x9f580770,0x628401c6,0x09e01725}},	//   _nnɔ_, _rapì_, jmko, _носн, 
   {{0xd4042cbb,0x00000000,0x00000000,0x00000000}},	//   бяни, --, --, --, 
   {{0x96b81b88,0x93242cbc,0x6284018c,0x00000000}},	//   _буду_, مرجن, emko, --, 
   {{0x2bdc2cbd,0x36182cbe,0x00000000,0x00000000}},	//   न्टा, _پراگ_, --, --, 
   {{0xc1ac080a,0x00000000,0x00000000,0x00000000}},	//   _ﺳﯩﺮﺍ, --, --, --, 
   {{0x645c2c53,0x91480b35,0x0678007c,0xcfa4021d}},	//   ésic, учна_, _ענדל, йшви, 
   {{0x6e94023f,0x067c11a7,0x00000000,0x00000000}},	//   живу, ﺯﯨﻠﯩ, --, --, 
   {{0xadbc0007,0x62940237,0x00000000,0x00000000}},	//   кавi, ŭzor, --, --, 
   {{0x28c8084b,0x00000000,0x00000000,0x00000000}},	//   _रिलि, --, --, --, 
   {{0xb33c011a,0x2618023b,0x816802ba,0x00000000}},	// [2930] rbħu, भाती_, _грэб_, --, 
   {{0x09b000cb,0xada401c4,0xdb0c293d,0x69d80086}},	//   ुण्य, саҡл, _sebá, wgwe, 
   {{0x9f580247,0xaab401f5,0x00000000,0x00000000}},	//   _yapí_, ійді, --, --, 
   {{0x69d80151,0x2bdc070d,0x00000000,0x00000000}},	//   ugwe, न्जा, --, --, 
   {{0xa968005b,0x69d82cbf,0x7c2c0085,0x00000000}},	//   јила_, rgwe, ålrø, --, 
   {{0x27e80091,0x69d82cc0,0xdb0c00f2,0x00000000}},	//   đano_, sgwe, _webá, --, 
   {{0xe7382cc1,0x00000000,0x00000000,0x00000000}},	//   рей_, --, --, --, 
   {{0xe7f406f7,0x99840070,0x00000000,0x00000000}},	//   _इसका_, skoš_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x38602cc2,0x29001d1a,0x68ec011a,0x00000000}},	//   éire_, āhau_, ħadu, --, 
   {{0x290c2cc3,0x7b2000e9,0xaad000a1,0x26c003aa}},	//   _krea_, _ušuš, _हिनक, áhou_, 
   {{0x291c2cc4,0xa5bc028d,0x00000000,0x00000000}},	//   nxwa_, skųs, --, --, 
   {{0xdfd002c7,0x628401c6,0xb46401d2,0x00000000}},	//   بيس_, smko, _екіл, --, 
   {{0xa3a82cc5,0x69c809e8,0x44242cc6,0x00000000}},	//   गुण_, _odee, _ion_, --, 
   {{0x69c82cc7,0x6d042cc8,0x290c01d5,0x00000000}},	//   _ndee, रिंग_, _orea_, --, 
   {{0x6254000a,0x44242cc9,0x9c241eb3,0xdb98005b}},	// [2940] tšof, _kon_, одад, атељ_, 
   {{0x69c82cca,0x44242ccb,0xee3800f8,0x067c11e5}},	//   _adee, _jon_, анӣ_, ﺯﯨﻤﯩ, 
   {{0x44242ccc,0x290c2ccd,0x8af40387,0xf8b000d5}},	//   _mon_, _area_, _üəll, ڑکا_, 
   {{0x290c0010,0x38c8175a,0x00000000,0x00000000}},	//   _brea_, ماتی_, --, --, 
   {{0x44242cce,0x9aa80121,0x69c80308,0x37c82ccf}},	//   _oon_, انچە_, _ddee, йғам_, 
   {{0x44242cd0,0x69c82cd1,0xe9a800e7,0x00000000}},	//   _non_, _edee, لدۇن_, --, 
   {{0x290c2cd2,0x3e4802ea,0x00000000,0x00000000}},	//   _erea_, eşti_, --, --, 
   {{0x44242cd3,0x3dc00278,0x290c2cd4,0xcf900107}},	//   _aon_, naiw_, _frea_, וטו_, 
   {{0x290c0254,0x94842cd5,0xa8a4181e,0x76900116}},	//   _grea_, жынд, _فصلو, _ẽysa, 
   {{0xdb0c012f,0x938819cd,0x00000000,0x00000000}},	//   _vebæ, исна_, --, --, 
   {{0x44242cd6,0x645c014a,0x69c80353,0x8c38002a}},	//   _don_, ésia, _ydee, _fußf, 
   {{0x44242cd7,0x4ad8025c,0x00000000,0x00000000}},	//   _eon_, मंतव, --, --, 
   {{0x44242cd8,0xdf480090,0xc21800c8,0x2688009d}},	//   _fon_, _አስፈፃ, ією_, _اخلي_, 
   {{0xdb1c023f,0x00000000,0x00000000,0x00000000}},	//   rapê, --, --, --, 
   {{0x22a404c4,0x7f942cd9,0x00000000,0x00000000}},	//   _pēke_, дарх, --, --, 
   {{0xd1b80122,0x00000000,0x00000000,0x00000000}},	//   _ئاغا_, --, --, --, 
   {{0x44242cda,0xd36c0572,0xc0d8010f,0x00000000}},	// [2950] _yon_, _سۇڭ_, ርቧል_, --, 
   {{0x44242cdb,0xaa5000d3,0x00000000,0x00000000}},	//   _xon_, _ṣàá_, --, --, 
   {{0x94f80002,0x7ac402e5,0xf9900122,0x637002b2}},	//   _དགའི_, дсче, ۆبه_, _iðnþ, 
   {{0x290c2cdc,0x7b640683,0xf9900061,0x88f001d2}},	//   _prea_, фтуе, چبه_, дікә, 
   {{0xf9902cdd,0x8d842cde,0xdde801a0,0xdb1c0247}},	//   نبه_, _фунд, _ارپه_, hapè, 
   {{0x290c009e,0x684416b2,0xa52402dc,0x00000000}},	//   _vrea_, янла, ҷмид, --, 
   {{0xbb58044a,0xc9f4129f,0x00000000,0x00000000}},	//   _дарх_, _وسرع, --, --, 
   {{0x44242cdf,0x290c2ce0,0x56901458,0xe6180f72}},	//   _son_, _trea_, најт, сди_, 
   {{0xaa4400fc,0x290c0426,0xa2bc1d39,0x693402ba}},	//   _деңл, _urea_, वीन्, _энау, 
   {{0x44242ce1,0x9f5800d3,0x00000000,0x00000000}},	//   _qon_, _lapá_, --, --, 
   {{0x44242ce2,0xdb0c2ce3,0x683c014a,0x00000000}},	//   _von_, _gebä, _cède, --, 
   {{0x44242ce4,0x8c380e48,0x63e400ea,0xf6740108}},	//   _won_, _fußg, _کېدې_, _قانخ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f581166,0x442414cc,0x25bc03c7,0x26182ce5}},	//   _papà_, _uon_, _hewl_, भावी_, 
   {{0xe7ec23e5,0x25bc2ce6,0xe2c8009d,0xdb1c0222}},	//   च्या_, _kewl_, _اوبو_, rapë, 
   {{0x925400e1,0xdca40116,0x5ca400b8,0xdb1c02bb}},	//   _најт_, зааи, зиаб, sapë, 
   {{0x6294025e,0x3dc0000b,0x8d602ce7,0xd83c02cc}},	// [2960] _iiyo, raiw_, евте, účka_, 
   {{0x62942ce8,0xe9e40552,0x8c38002a,0x1fb4012b}},	//   _hiyo, åºno_, _nußd, _эсир, 
   {{0x62942ce9,0x60c40252,0x4f980107,0x00000000}},	//   _kiyo, lskm, _לביצ, --, 
   {{0x62942cea,0xdb1c2ceb,0x25bc0126,0x00000000}},	//   _jiyo, napé, _newl_, --, 
   {{0xdb0c0937,0x62942cec,0xdd902ced,0x60c42cee}},	//   _sebä, _miyo, _سوس_, nskm, 
   {{0x62942cef,0xe980006e,0xdb1c0116,0x00000000}},	//   _liyo, тқун, hapé, --, 
   {{0x62940b66,0x8f9804b0,0x00000000,0x00000000}},	//   _oiyo, זיצי, --, --, 
   {{0x62942cf0,0xaad00a9e,0x26182cf1,0xdb1c0247}},	//   _niyo, _हितक, भाषी_, japé, 
   {{0xdb1c00b7,0xcfe00143,0x00000000,0x00000000}},	//   dapé, য়তন, --, --, 
   {{0xdb0c0031,0x00000000,0x00000000,0x00000000}},	//   _tebä, --, --, --, 
   {{0x8c1800cf,0x00000000,0x00000000,0x00000000}},	//   צוטי, --, --, --, 
   {{0x62942cf2,0xdb1c2cf3,0x46a00007,0xe6b401a0}},	//   _ciyo, gapé, _чацв, _آلنگ, 
   {{0x62942cf4,0xd4682cf5,0x261817d6,0x00000000}},	//   _diyo, _лиде_, भारी_, --, 
   {{0xc950033c,0x4ea405bc,0xdb1c02ba,0x9f580223}},	//   תמש_, зраа, papè, _sapá_, 
   {{0x9f582cf6,0x0874007c,0xa91c01d1,0x62942cf7}},	//   _papá_, פעלט_, _izže, _fiyo, 
   {{0xdb1c2cf8,0x62942cf9,0x7c3c04ac,0x6fb400dd}},	//   capé, _giyo, _alrr, _ڪمدا, 
   {{0xd24c009d,0x8d742cfa,0xd86000a5,0xac940123}},	// [2970] _لنډ_, سارا, zọọt, дааш, 
   {{0x6294021b,0x63ac00e9,0xd24c01ac,0x00000000}},	//   _ziyo, _đank, _جنڊ_, --, 
   {{0x62942cfb,0x6db400fc,0x9f5800d3,0x00000000}},	//   _yiyo, _ойну, _tapá_, --, 
   {{0x629401a0,0xefe800d5,0x2bd800bd,0x69cc022d}},	//   _xiyo, _اٹھو_, _ढाका, दृढी, 
   {{0x8c380602,0x23dc2cfc,0x6e3c0207,0x202802e8}},	//   _auße, _मालद, _ilsb, _útið_, 
   {{0x27e0000b,0x6d400387,0x00000000,0x00000000}},	//   ühn_, _əlal, --, --, 
   {{0x2618021f,0xca742cfd,0x00000000,0x00000000}},	//   भाली_, _فارغ, --, --, 
   {{0x45a00134,0xff1800ca,0x00000000,0x00000000}},	//   رەتك, לקות_, --, --, 
   {{0xc9840396,0x3a8402b3,0x62942cfe,0x645c00b7}},	//   _хуви, _чырв, _riyo, ésio, 
   {{0x62942cff,0x7e9c0299,0xd860063e,0xb48401c4}},	//   _siyo, _hōpe, pọọt, нкыһ, 
   {{0xcfe000ac,0x7e9c0341,0x62942d00,0xdb1c0a03}},	//   য়ান, _kōpe, _piyo, tapé, 
   {{0x1c080584,0x629404e7,0x76400323,0xd5a402ac}},	//   _होईल_, _qiyo, chmy, _قلمی, 
   {{0xdb1c2d01,0x66082d02,0x62942d03,0x22a4015b}},	//   rapé, mdek, _viyo, _dēka_, 
   {{0x66082d04,0x60c42d05,0x62942d06,0xdfd00075}},	//   ldek, rskm, _wiyo, ضير_, 
   {{0x64402d07,0x62942d08,0x2cb80560,0xfe7800e7}},	//   mhli, _tiyo, _བསུབ, зүн_, 
   {{0x7c3c025e,0x7e9c00a2,0xa3a82d09,0x64400140}},	//   _slrr, _nōpe, गुर_, lhli, 
   {{0x614401c3,0xd06401d2,0x00000000,0x00000000}},	// [2980] _цепа, _ﺍﻳﯩﭗ_, --, --, 
   {{0x64400155,0x66080274,0x5f7400c3,0x00000000}},	//   nhli, hdek, _يادر, --, 
   {{0x20182d0a,0x66082d0b,0x1e842d0c,0x50180a0b}},	//   _inpi_, kdek, _олом, _וויו, 
   {{0xa2d41b12,0xceb010bc,0x6e3c0444,0x6608018c}},	//   _भिन्, _שיר_, _glsb, jdek, 
   {{0x66081ccf,0x2018010b,0x81d402fa,0x64400060}},	//   ddek, _knpi_, স্থ_, khli, 
   {{0x645c0c5b,0x66080ac8,0xf63c00c3,0xdf2401d2}},	//   ésil, edek, ﻟﻼﮬ_, _ءﯨﻨﯩ, 
   {{0x6440053e,0x8c380602,0xda642d0d,0x6d40009f}},	//   dhli, _fußb, _قاري, _əlam, 
   {{0x81d42d0e,0x66082d0f,0x6440002a,0x0690024b}},	//   স্ত_, gdek, ehli, _ﺟﺎﻧﯩ, 
   {{0xdb0c2d10,0xb7bc0059,0x6ba40207,0x34942d11}},	//   _nebú, _loģi, _åtgå, наир, 
   {{0x64402d12,0x201802cc,0xa3a82d13,0x66081b8c}},	//   ghli, _nnpi_, गुल_, adek, 
   {{0x78a0017b,0x95c80116,0x660801c6,0x8bd4067a}},	//   _humv, _дула_, bdek, וויו_, 
   {{0x78a02d14,0x518405bc,0x20182d15,0xdb0c00e3}},	//   _kumv, дуга, _anpi_, _bebú, 
   {{0x64402d16,0x63ac0101,0x00000000,0x00000000}},	//   bhli, _şane, --, --, 
   {{0x64402d17,0xdb0c2d18,0x78a02d19,0x8410001e}},	//   chli, _debú, _mumv, _амшх, 
   {{0x78a00428,0x2c44001e,0x00000000,0x00000000}},	//   _lumv, ҕьаҳ, --, --, 
   {{0x2018029f,0x27e816c6,0x15e02d1a,0x63ac01df}},	//   _enpi_, đani_, क्चर_, _đani, 
   {{0x78a00148,0x3134009e,0x7e9c0299,0xc1bc00ca}},	// [2990] _numv, _чепр, _rōpe, _ומחש, 
   {{0x4ea406e8,0x66080333,0x32082d1b,0x4bd80324}},	//   _орма, zdek, _haay_, تبرد_, 
   {{0x0a682d1c,0x32082d1d,0x66082d1e,0xbb8400c3}},	//   орди_, _kaay_, ydek, _ﺩﺍﻧﻪ_, 
   {{0x78a01334,0x6f0402ac,0x3208065b,0x644000c0}},	//   _bumv, _ishc, _jaay_, zhli, 
   {{0x78a02d1f,0x32082d20,0x66082d21,0xf8a80ff7}},	//   _cumv, _maay_, vdek, ودوه_, 
   {{0x78a000cf,0x32082d22,0x01380107,0x5c70006b}},	//   _dumv, _laay_, ורדת_, _бһут, 
   {{0x645c2d23,0x66082d24,0xe5a4006e,0xd1c402b4}},	//   ésim, tdek, нийи, ጽንታ_, 
   {{0x32082d25,0xd90c00cd,0x66082d26,0x5964001d}},	//   _naay_, جیے_, udek, ታላችሁ_, 
   {{0x9f580239,0x64402d27,0x27e80ae3,0x00000000}},	//   _zapä_, thli, ƙan_, --, 
   {{0x68e80123,0xe3b003e0,0x64400008,0x6f0402b0}},	//   _iqed, درة_, uhli, _oshc, 
   {{0x32082d28,0x78a02d29,0x660815ce,0xfbcc0143}},	//   _baay_, _zumv, pdek, র্কত, 
   {{0x78a00161,0x21682d2a,0x64402d2b,0x32080080}},	//   _yumv, зими_, shli, _caay_, 
   {{0x6f040c2f,0xdb0c007f,0x10a02d2c,0x78a001f9}},	//   _ashc, _debù, лиян, _xumv, 
   {{0xc44401d9,0xe2c82d2d,0xe3b00075,0xd24c00ea}},	//   _آیدن_, _فوتو_, _صرت_, لنۍ_, 
   {{0x5e9403e0,0x32082d2e,0x00000000,0x00000000}},	//   فلسط, _faay_, --, --, 
   {{0x68e8041c,0x32080d8c,0xd35400ca,0x00000000}},	//   _oqed, _gaay_, _ריקי_, --, 
   {{0x6f0401e3,0x68e8011a,0x0e60006b,0xa2d400bd}},	// [29a0] _eshc, _nqed, уктн, _भिड्, 
   {{0x78a00085,0xa6c40143,0x1c080030,0x00000000}},	//   _rumv, _এমনট, _होखल_, --, 
   {{0x68e80123,0x78a00c2a,0x9f48036d,0x32082d1d}},	//   _aqed, _sumv, jebø_, _yaay_, 
   {{0xfbd00a1d,0x3208175d,0x78a00380,0x0f541714}},	//   _چڪا_, _xaay_, _pumv, _טיים_, 
   {{0x78a00380,0xb3740020,0xd8380023,0xfbd000dd}},	//   _qumv, _ራዕድን_, зэй_, _نڪا_, 
   {{0x78a00088,0xdb1c2d2f,0x683c0078,0x36d42d30}},	//   _vumv, lapí, _pèda, вокр, 
   {{0x8c1800b9,0x78a00148,0x68e802dc,0xcb642d31}},	//   _צולי, _wumv, _eqed, _заре_, 
   {{0x65780086,0xdb1c03aa,0x4b780100,0x00000000}},	//   _bywh, napí, _זאלו, --, 
   {{0xa2bc0523,0x2ab40229,0xd0c80143,0x00000000}},	//   वीस्, _túbò_, _লঙ্ঘ, --, 
   {{0x32082d32,0x335400cc,0x4d6800c3,0x00000000}},	//   _saay_, күлө_, ﺳﯩﯟﯨ, --, 
   {{0x3208018c,0xa91c01f6,0x1424024b,0xdb1c00b8}},	//   _paay_, _izža, _үдем, kapí, 
   {{0xb0a40774,0x65780086,0xdb1c00b8,0x154400b7}},	//   _गंदग, _fywh, japí, _пеем, 
   {{0x506401be,0x2c2c0020,0x6380001e,0xd6b00143}},	//   етва, _ተዛሪቡ, лҳәа, _ঘটিয, 
   {{0x32082d33,0xaad0025c,0x00000000,0x00000000}},	//   _waay_, _हिलक, --, --, 
   {{0x3208038a,0x27f00386,0x00000000,0x00000000}},	//   _taay_, _özne_, --, --, 
   {{0xa2d42d34,0xdb1c0b07,0xc0d00020,0x00000000}},	//   _भित्, gapí, እሶም_, --, 
   {{0x6c740106,0x00000000,0x00000000,0x00000000}},	// [29b0] влађ, --, --, --, 
   {{0xac18021d,0x6d4003b4,0x00000000,0x00000000}},	//   ьозу_, _əlah, --, --, 
   {{0xbf140121,0x6f0402b0,0x00000000,0x00000000}},	//   _йүрә, _ushc, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x27e402ba,0x645c008f,0x5ea40143,0x00000000}},	//   _pcln_, ésik, গীদে, --, 
   {{0x7e9c04c4,0x25a803ef,0x8c38002a,0x18a000c3}},	//   _hōpa, _żal_, _fußa, шашм, 
   {{0x1c082d35,0x7e9c04c4,0xd1b80090,0xaa582d36}},	//   _होटल_, _kōpa, ዳሉት_, _живу_, 
   {{0x9f481a0c,0x68e8011a,0x00000000,0x00000000}},	//   rebø_, _tqed, --, --, 
   {{0x68e802dc,0x75340182,0x94e40e90,0x00000000}},	//   _uqed, гээх, نکوف_, --, 
   {{0xa2d400cb,0xdb1c00ef,0x22500201,0x00000000}},	//   _भिद्, zapí, _smyk_, --, 
   {{0x33f4039c,0xb9cc010f,0xe3642d37,0x00000000}},	//   учыс, _ዳቦ_, ткни, --, 
   {{0xdb1c00b7,0xa0a42d38,0x55501127,0x00000000}},	//   lapã, камд, اپیر, --, 
   {{0xa5082d39,0x00000000,0x00000000,0x00000000}},	//   _цела_, --, --, --, 
   {{0xa0682d3a,0x91000e44,0x2a7c03c7,0x00000000}},	//   фага_, јпре, hlwb_, --, 
   {{0xdee400f8,0xd4642d3b,0x44e818d6,0x00000000}},	//   ъови, _шише_, lø_, --, 
   {{0x52540116,0x645c0249,0xd12c00e2,0x9f480223}},	//   _ахьӡ, èsif, _ژمي_, _àjín_, 
   {{0xa2bc01a4,0x44e80085,0xc0d00020,0x00000000}},	// [29c0] वीर्, nø_, እቶም_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2b38038e,0xe7240061,0xa1342d3c,0x00000000}},	//   няцэ_, _اڵ_, _سرکش, --, 
   {{0x44e80085,0x81d40143,0xef100100,0x48700ac9}},	//   kø_, স্র_, _פּי_, یدوس, 
   {{0x17080145,0x61f40422,0xd9442d3d,0x52280100}},	//   _གནངམ_, _mbyl, ъеди, ווײַ, 
   {{0x2b4c0192,0x00000000,0x00000000,0x00000000}},	//   _řece_, --, --, --, 
   {{0xca74093f,0x5a9412df,0x7d042d3e,0xd6c018d1}},	//   رمۇش_, _араф, lwis, جمعی, 
   {{0x26182d3f,0xd0b002a0,0x00000000,0x00000000}},	//   भागी_, _eşəl, --, --, 
   {{0x18a42a35,0x7d042d40,0x57e82d41,0x44e80085}},	//   _разм, nwis, _одам_, gø_, 
   {{0x61f42d42,0xa4900e5a,0x72d000c3,0xa97401c3}},	//   _abyl, مینت, مەتچ, _сусј, 
   {{0x07a02d43,0x625400b0,0x00000000,0x00000000}},	//   _тахн, ršon, --, --, 
   {{0x7d042d44,0x9fa4016d,0x06900041,0x44e82d45}},	//   kwis, ғырҙ, _ﺟﺎﻳﯩ, bø_, 
   {{0x65b004f7,0x855401b8,0x7d0400f1,0x27f00306}},	//   _уҡыт, _لیٹر_, jwis, _énní_, 
   {{0x7e9c0299,0x00000000,0x00000000,0x00000000}},	//   _rōpa, --, --, --, 
   {{0xb0340476,0xadd40294,0x92580075,0x0dc8018f}},	//   نىڭغ, ловљ, _يشعر_, дузи_, 
   {{0x12842d46,0x6aa003b2,0x7d042d47,0x625401d1}},	//   _جمعی_, _élfi, fwis, nšol, 
   {{0x5064039c,0xe9a404e7,0x7d042d48,0x8bc4021c}},	// [29d0] _атна, қалп, gwis, всед, 
   {{0xada4002c,0x61f400bd,0x6fb42d49,0x00000000}},	//   таҡл, _zbyl, _حمدا, --, 
   {{0xbed80182,0x8c380104,0x61f801b8,0xc17403dd}},	//   _идэх_, _fußn, őtle, _مدیت, 
   {{0x7d042d4a,0x7e9c0296,0xca540320,0x00000000}},	//   bwis, _tōpa, тĕмп, --, 
   {{0x625407b5,0xc0d8001d,0x00000000,0x00000000}},	//   dšol, _ይባስ_, --, --, 
   {{0xd3642d4b,0x00000000,0x00000000,0x00000000}},	//   _هه_, --, --, --, 
   {{0x2ca8028b,0xdb1c001e,0x7c38013c,0x00000000}},	//   lqad_, rapã, övre, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x61480045,0xe5782d4c,0x00000000,0x00000000}},	//   _mêlé, эзи_, --, --, 
   {{0x057401d9,0x44e813f7,0x00000000,0x00000000}},	//   _یاشد, rø_, --, --, 
   {{0x7d042d4d,0x637801c8,0x44e80353,0x00000000}},	//   zwis, эсир_, sø_, --, 
   {{0x9f580369,0x7d04002f,0x15e80c14,0xdb0c2095}},	//   _tapú_, ywis, _टायर_, _nebý, 
   {{0x25ac2d4e,0xb8f400a8,0x00000000,0x00000000}},	//   mcel_, _veṇī, --, --, 
   {{0xc5e00774,0x25ac2d4f,0xcd28010f,0xdb1c001e}},	//   _गाँठ_, lcel_, ሰግናለ, hapá, 
   {{0x7d04193b,0x9e640324,0x25ac0513,0xdb1c2d50}},	//   wwis, هارن, ocel_, kapá, 
   {{0x25ac2d51,0x7d042d52,0x6d400c60,0x205400c3}},	//   ncel_, twis, _əlav, _әтир, 
   {{0x7d042d53,0x21240101,0x5d68001e,0x661c2d54}},	// [29e0] uwis, _çoh_, хиам_, ösky, 
   {{0x7d042d55,0x683c0249,0x5f742d56,0x5bc42d57}},	//   rwis, _bèdm, _ماجر, اقال, 
   {{0x7d042d58,0x5f0401a0,0x41b82d59,0x3ce001e8}},	//   swis, _ёзма, _आभास, suiv_, 
   {{0x7d042d5a,0x61e42d5b,0x98a42d5c,0x4e2401ec}},	//   pwis, ngkl, гиде, _боюн_, 
   {{0x6e280b66,0x7e642d5d,0x91b80107,0x00000000}},	//   _òeba, mnip, גמני, --, 
   {{0x7e9c0299,0xd37c02db,0x8ba000df,0x7b840200}},	//   _kōpo, šćim_, _гирж, _نازە, 
   {{0xd5e001e5,0xf70401c8,0x7e642bc7,0x6e340528}},	//   _nhọ, рҗем, onip, _àgbé, 
   {{0x7e642d5e,0xdb1c04ac,0x00000000,0x00000000}},	//   nnip, capá, --, --, 
   {{0xdb0c013b,0x7e641513,0x2618006c,0x625401d1}},	//   _lebü, inip, भाजी_, ršol, 
   {{0x26180698,0x56900200,0x7e642d5f,0x00000000}},	//   _मोठी_, шақт, hnip, --, 
   {{0x7e642d60,0xa3e42d61,0x7e9c00a2,0xd5e00048}},	//   knip, _फार_, _nōpo, _chọ, 
   {{0x3eb801f6,0x61e401c5,0x00000000,0x00000000}},	//   dprt_, ggkl, --, --, 
   {{0x53442d62,0xc690129b,0x2714000d,0xb7bc00e0}},	//   _әхла, _האף_, _ánh_, _enģe, 
   {{0xdb0c019f,0x7afc1909,0x33940007,0x7e642d63}},	//   _bebü, _oprt, _калё, enip, 
   {{0x645c02ba,0x4e880668,0xdb1c014e,0x40340074}},	//   èsie, ещам_, lapæ, щерс, 
   {{0xdb0c2d64,0xadb42d65,0x645c014a,0x00000000}},	//   _debü, рбаш, ésiv, --, 
   {{0x26c000cd,0x6cd40340,0x8c38002a,0x00000000}},	// [29f0] ához_, شقاا, _fußl, --, 
   {{0x2ca801b5,0x6244038a,0x7e642bda,0x00000000}},	//   rqad_, _góob, anip, --, 
   {{0xdb0c06ef,0x2ca8028b,0x7c8401f1,0x7e6401d5}},	//   _gebü, sqad_, суте, bnip, 
   {{0x25ac2d66,0x06900200,0x7e6401d5,0x8c080143}},	//   xcel_, _ﺟﺎﻋﯩ, cnip, রাধন_, 
   {{0x6e2c2d67,0x6aa801f6,0x2ca8043b,0x88802d68}},	//   mjab, _čefu, qqad_, میرن, 
   {{0xf9902d69,0x6e2c036d,0x6d4c018c,0xdb1c2d6a}},	//   سبن_, ljab, mzaa, sapá, 
   {{0x6d4c2d6b,0xaa9400c8,0x6f1400fb,0xdb4c0012}},	//   lzaa, _вивч, nvzc, _ہێے_, 
   {{0x6e2c2d6c,0xe6182d6d,0x49b80122,0x6d4c2d6e}},	//   njab, тди_, _سارد_, ozaa, 
   {{0xa4440017,0x6d4c2d6f,0xd82c01ac,0xf62800cc}},	//   инид, nzaa, _ڪڍن_, اسىى_, 
   {{0x22a40341,0x6d4c2d70,0x25ac2d71,0x7d7c00cf}},	//   _hēki_, izaa, scel_, ענזו, 
   {{0x22480108,0x8c380104,0x638401f1,0x7e642d72}},	//   впни_, _rußl, ргна, ynip, 
   {{0x341000cb,0x6e2c09e8,0x6244175c,0x6d4c01ed}},	//   āyaḥ_, jjab, _sóob, kzaa, 
   {{0xa0a42d73,0x644c036b,0x27140028,0x6e2c2d74}},	//   рагд, _ïaio, _hān_, djab, 
   {{0x6d4c2d75,0x7e9c2d76,0x26182d77,0xae0401c4}},	//   dzaa, _pōpo, _मोती_, ҙоуҙ, 
   {{0x6d4c0472,0x645c2d78,0x612c006b,0xa2e41875}},	//   ezaa, ésiu, _bеlä, _тойд, 
   {{0xdcb02d79,0x7e64044d,0xa0a42d7a,0xdee42d7b}},	//   قىر_, unip, _каид, лоҳи, 
   {{0x7e642d7c,0x27140010,0x6d4c01ed,0x1278007c}},	// [2a00] rnip, _lān_, gzaa, _באקע, 
   {{0x7e642d7d,0x6e2c2d7e,0x0c202d7f,0x8c380104}},	//   snip, ajab, омун, _fußm, 
   {{0x6d4c2d80,0x2714004f,0xd00c00ea,0x7e6401d5}},	//   azaa, _nān_, _کلۍ_, pnip, 
   {{0x63ac2d81,0x7e6402b1,0x6d4c015e,0xddd400b0}},	//   _şanl, qnip, bzaa, blyš, 
   {{0x39402d82,0xa3b400af,0x2c10006c,0x00000000}},	//   áis_, जडा_, _डोकं_, --, 
   {{0xdb0c01e8,0xfaa401a0,0x81cc0143,0x2b9000e3}},	//   _debò, _هجری, _লাফ_, _کیمس, 
   {{0x37c4016d,0x39400007,0x7afc2d83,0xdb0c01ab}},	//   _һәйб, šis_, _uprt, _ofbé, 
   {{0x26181efe,0xd6240272,0xceb00d47,0xcb6400b7}},	//   _मोदी_, شعبي, חיה_, _тасе_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x07a02d84,0x6e2c158a,0x00000000,0x00000000}},	//   _дафн, zjab, --, --, 
   {{0x2248004e,0x6d4c2d85,0xb2740128,0x74142d86}},	//   _ŋaka_, zzaa, йлош, لوکا, 
   {{0xdb1c2d87,0xdec802b4,0xb464069d,0x00000000}},	//   mapä, ጽእን_, ркүл, --, 
   {{0xdb1c2d88,0x51842d89,0xcfa40152,0x34b41941}},	//   lapä, руна, ишви, _امتز, 
   {{0x645c0045,0xdb1c0128,0x853802c3,0x161c00d1}},	//   ésit, capç, _בגדי, भाकर_, 
   {{0x24982d8a,0xdb1c2d8b,0x6e2c2d8c,0xc3240075}},	//   ïsme_, napä, tjab, _نكون_, 
   {{0x11e808c4,0x6d4c2d8d,0x23700028,0x42c400c3}},	//   _شعبي_, tzaa, ûzje_, _өгән_, 
   {{0xdb1c0076,0x6e2c2d8e,0x79800028,0xbca80121}},	// [2a10] hapä, rjab, _nymw, ۇدەك_, 
   {{0x29e40a72,0x6d4c1526,0x6e2c2d8f,0xdb1c2d90}},	//   _ḓa_, rzaa, sjab, kapä, 
   {{0x6d4c2d91,0xdb1c0027,0x612c012b,0x7f940320}},	//   szaa, japä, _tеlä, _маьх, 
   {{0x6d4c018c,0x80a4130f,0xdb1c0030,0xddd400b0}},	//   pzaa, _دمین, dapä, plyš, 
   {{0x79800336,0x1dc006c3,0x090400bf,0x00000000}},	//   _cymw, _хөсн, рчем, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x39500130,0xa90803a2,0xd7640eb8,0x00000000}},	//   _ɑnsɑ_, ئيڪل_, مەكى_, --, 
   {{0x683c00e7,0x81cc00ac,0x62540023,0x271400a8}},	//   _mèdi, _লাভ_, ršok, _vān_, 
   {{0x7980009c,0xdb1c2d92,0x67d400df,0x6498038e}},	//   _gymw, tapç, _гозу, лтор_, 
   {{0xe4482d79,0x27140828,0x290c2d93,0xa91c01d5}},	//   الدى_, _tān_, _isea_, _vyžd, 
   {{0x21a418ce,0x2448014e,0xa91c02e6,0x00000000}},	//   йинм, _rúmd_, _wyžd, --, 
   {{0xb3842d94,0x7640006f,0xa91c01d4,0xb46402ba}},	//   өлөл, ckmy, _tyžd, йкөл, 
   {{0xf6742d95,0xdb1c2d96,0xf6500340,0x645c2d78}},	//   _بالخ, mapå, _تئل_, ésis, 
   {{0x73c400e7,0x4aa4006c,0x00000000,0x00000000}},	//   _ۇيۇم, गदाव, --, --, 
   {{0x6440002a,0x00000000,0x00000000,0x00000000}},	//   mkli, --, --, --, 
   {{0x290c2d97,0xfe78039b,0x1d082d98,0x8c38002a}},	//   _osea_, рүм_, леби_, _fußk, 
   {{0xdc6805bc,0x9f580299,0x64402d99,0x1c4400f8}},	// [2a20] гаад_, _hapü_, okli, бнам, 
   {{0xefd401e2,0x64402d9a,0xdb1c02b1,0x60082d9b}},	//   ራቸው_, nkli, yapä, _сном_, 
   {{0x64402d9c,0x290c0ac4,0x7980015e,0xdb1c0207}},	//   ikli, _asea_, _symw, kapå, 
   {{0x290c0043,0xbb300dd7,0x64402d9d,0xdb1c2583}},	//   _bsea_, ﻪﺳﻰ_, hkli, vapä, 
   {{0x64402d9e,0xd7f801a7,0x2cd4018f,0x00000000}},	//   kkli, гуй_, _мюрр, --, 
   {{0xaad020ff,0xfc4400cd,0xdb1c021c,0x64402d9f}},	//   _हिचक, _بھرپ, tapä, jkli, 
   {{0x290c0cbf,0x01e00252,0x64402da0,0x8c4000fc}},	//   _esea_, য্যদ, dkli, _эере, 
   {{0xd1dc2cb2,0x64402da1,0x9f58001e,0x6b800085}},	//   ንቦት_, ekli, _hapó_, _ølga, 
   {{0xd49800f8,0x26c40335,0x644001c6,0x98c400e2}},	//   лро_, _ewlo_, fkli, _دغزن, 
   {{0x9f580128,0x15e80aff,0xdb1c07e9,0xb3c80143}},	//   _japó_, _टावर_, papä, _শাহজ, 
   {{0x6d400c60,0x3a2401ed,0x9f58001e,0xa91c00ef}},	//   _əlaq, _knmp_, _papý_, _vyže, 
   {{0x64402da2,0x9f58059e,0x683c02ba,0x3ce02da3}},	//   akli, _dapü_, _rèdi, kriv_, 
   {{0x64402da4,0x683c00f1,0xc0d8010f,0x8678067a}},	//   bkli, _sèdi, _ይባል_, _גראו, 
   {{0x64402da5,0x683c00f1,0x53940020,0x50642da6}},	//   ckli, _pèdi, _መሓዙት_, стма, 
   {{0xc0582da7,0xce682da8,0x3ce000af,0x00000000}},	//   сія_, град_, eriv_, --, 
   {{0x683c00f1,0x60d80078,0x00000000,0x00000000}},	//   _vèdi, ņtma, --, --, 
   {{0x2d9c01c8,0x3d940091,0x00000000,0x00000000}},	// [2a30] äwe_, зитр, --, --, 
   {{0x9f582da9,0x7f54010f,0x99b802fa,0x00000000}},	//   _capó_, ሙያዎች, ুলোক, --, 
   {{0xa91c13bd,0x29d42daa,0xfbd00075,0x00000000}},	//   _izži, قياس, عتك_, --, 
   {{0x3a2401f1,0xa2bc2dab,0x00000000,0x00000000}},	//   _cnmp_, वीट्, --, --, 
   {{0x4c800061,0x00000000,0x00000000,0x00000000}},	//   _فیرق, --, --, --, 
   {{0x8aa402b8,0xe7382dac,0x68442dad,0x00000000}},	//   _град, иел_, юнла, --, 
   {{0x81d40ce4,0x64402dae,0x625401d4,0xdb1c0207}},	//   স্ট_, vkli, mšov, tapå, 
   {{0x62540113,0x569001f1,0x00000000,0x00000000}},	//   lšov, мајт, --, --, 
   {{0x893408c9,0x64402daf,0xe9d8002f,0x290c0139}},	//   _اعزا, tkli, _idź_, _usea_, 
   {{0xf9902db0,0x26182db1,0x62542645,0x442002e3}},	//   _سبق_, _मोरी_, nšov, ñj_, 
   {{0x64402db2,0xa22809c7,0x074401a7,0x645c014a}},	//   rkli, ажна_, _ухам, ésiq, 
   {{0x64402db3,0x62582db4,0x36d40182,0x9200015b}},	//   skli, ррор_, _хоцр, _šāro, 
   {{0xa2d40b29,0xfaf8015b,0x625401d5,0x208809b7}},	//   _भिक्, _ģīm_, kšov, ийми_, 
   {{0xe7ec2db5,0x625400ef,0x00000000,0x00000000}},	//   च्चा_, jšov, --, --, 
   {{0x8fa02db6,0x7e9c00a2,0x9e580362,0x4fa01166}},	//   даре, _hōpi, араф_, дирв, 
   {{0x7e9c0341,0xb8fc043b,0x3f840059,0xd12c00dd}},	//   _kōpi, _རྗ_, āmu_, _ڄمي_, 
   {{0x9f58197c,0x2cb803f4,0xdbc82db7,0x00000000}},	// [2a40] _papó_, _ctsd_, игад_, --, 
   {{0x62842db8,0x81b001e7,0x2a6c0039,0xaa64016d}},	//   llko, _daɓe, _ajeb_, үефһ, 
   {{0xe7ec2db9,0x3f8c00b6,0xa2bc00b3,0x628405ab}},	//   च्छा_, üdud_, वीच्, olko, 
   {{0x94080125,0x3ce02dba,0x59840074,0x00000000}},	//   _ɔmɑn_, priv_, олеб, --, 
   {{0xa3e80584,0xc2140130,0x9f5800d3,0xabd40108}},	//   यला_, _nkɔm_, _tapó_, ززەت, 
   {{0x62840104,0xa3e400d1,0x00000000,0x00000000}},	//   hlko, _फाग_, --, --, 
   {{0x81b01aa0,0x38c82dbb,0xcb640320,0x00000000}},	//   _zaɓe, _گازی_, _даре_, --, 
   {{0x6244038a,0x62840a0e,0x8f98023c,0xdb1c0247}},	//   _sóon, jlko, סיקי, kapú, 
   {{0xd4042dbc,0xf98402dc,0x97d802cb,0xf8c40061}},	//   ояни, _эҳдо, _نظار_, _رماێ, 
   {{0x62842dbd,0xb35400c8,0x645c0039,0x00000000}},	//   elko, зкош, ésip, --, 
   {{0x683c00cc,0x00000000,0x00000000,0x00000000}},	//   _cèdu, --, --, --, 
   {{0xb9e40117,0x8c380104,0x06b40122,0xd2580320}},	//   _ያን_, _fußw, _بچوک_, рцо_, 
   {{0xdb0c013b,0x62540212,0x0fe000cc,0xd468012b}},	//   _gebö, yšov, мөнү, _киде_, 
   {{0x9f58065e,0x62842dbe,0x74142dbf,0x00000000}},	//   _rapò_, alko, _روبا, --, 
   {{0x62440d8c,0x38b0077d,0x6284212e,0x00000000}},	//   _kóol, _làr_, blko, --, 
   {{0x2cb82dc0,0xa91c00bd,0xf4840122,0x9f580537}},	//   _ptsd_, _lyža, _باڵی, _papò_, 
   {{0xad4003c4,0x6244065b,0xebd801d9,0x00000000}},	// [2a50] رۉسۉ, _móol, йдаш_, --, 
   {{0x64dc0698,0x70542dc1,0x00000000,0x00000000}},	//   _मिसळ, _رنجا, --, --, 
   {{0x625403aa,0x00000000,0x00000000,0x00000000}},	//   ršov, --, --, --, 
   {{0xc3300282,0x38b00177,0x2fd00770,0x00000000}},	//   ווע_, _bàr_, lazg_, --, 
   {{0x40540063,0x38b0077d,0x62540212,0x00000000}},	//   _رئیس, _càr_, pšov, --, 
   {{0x38b00177,0x2fd00770,0x7e9c0296,0x244800b8}},	//   _dàr_, nazg_, _rōpi, _oúma_, 
   {{0xe7382dc2,0x3ffc00b9,0x62440029,0x37a8006e}},	//   сей_, יפגע, _bóol, әтән_, 
   {{0x62440d8c,0xc95802ac,0x38b00177,0x00000000}},	//   _cóol, _кўз_, _fàr_, --, 
   {{0x29182dc3,0x38b00177,0x00000000,0x00000000}},	//   _ésa_, _gàr_, --, --, 
   {{0x67d40094,0x62840126,0x00000000,0x00000000}},	//   _хожу, wlko, --, --, 
   {{0x8c38002a,0x4de800aa,0xe7180075,0x00000000}},	//   _fußv, टलाई_, _ديات_, --, 
   {{0x64c400a3,0x7e9c0341,0xdb1000cd,0x00000000}},	//   _فيصل, _tōpi, égév, --, 
   {{0x66082dc4,0xe2980108,0xb9e400ff,0xd24c0b16}},	//   meek, _һак_, _ያዕ_, انُ_, 
   {{0xa8780100,0x62840151,0x60c002e6,0x94b800ca}},	//   מאָר, slko, _çomm, _המסת, 
   {{0xe2982dc5,0x44242dc6,0xa91c015b,0x00000000}},	//   _лак_, _inn_, _izžu, --, 
   {{0x66082dc7,0x62440029,0x44242dc8,0xdd900272}},	//   neek, _kóom, _hnn_, فوز_, 
   {{0xdb1c02e8,0x00000000,0x00000000,0x00000000}},	// [2a60] lapø, --, --, --, 
   {{0x4c800385,0x44242dc9,0x66082dca,0x00000000}},	//   елув, _jnn_, heek, --, 
   {{0x10380107,0x6b80036d,0x4424011a,0x38b00e3d}},	//   _הגיע, _ølgl, _mnn_, _sàr_, 
   {{0x20082dcb,0xdca42dcc,0x66082dcd,0x44240177}},	//   lebi_, _нами, jeek, _lnn_, 
   {{0xbc742dce,0x4424161b,0x66082dcf,0xa91c0113}},	//   _قۇرب, _onn_, deek, _pyža, 
   {{0x20082dd0,0x8c080143,0xd7f80094,0x624400f2}},	//   nebi_, রাউন_, ёул_, _sóol, 
   {{0xa91c0214,0x1c0003c3,0x86c00ad5,0x66080110}},	//   _vyža, _रॉयल_, ىيون, feek, 
   {{0x44242dd1,0x15b02dd2,0x6244038a,0xd4982dd3}},	//   _ann_, رەتس, _bóom, әри_, 
   {{0x48e02112,0x94842dd4,0x20082dd5,0x44242dd6}},	//   _потв, зынд, kebi_, _bnn_, 
   {{0x200801f8,0x6244175c,0x44242dd7,0x244801ca}},	//   jebi_, _wóol, _cnn_, _púma_, 
   {{0x7e9c004d,0x44242dd8,0x66082dd9,0xd394006b}},	//   _hōpu, _dnn_, beek, чәдә_, 
   {{0x44242dda,0x7e9c0341,0x00000000,0x00000000}},	//   _enn_, _kōpu, --, --, 
   {{0x20080197,0x95842ddb,0x62440029,0x81cc0143}},	//   febi_, _элде, _góom, _লাশ_, 
   {{0xc05802b3,0x44240520,0x7bdc2ddc,0xdb1c0247}},	//   піс_, _gnn_, _ndru, sapù, 
   {{0xff04221e,0x8c3803c8,0xa3e80203,0x00000000}},	//   нятн, _mußt, यलर_, --, 
   {{0x826801f1,0x1ee8005e,0x00000000,0x00000000}},	//   _најв_, توفی_, --, --, 
   {{0x62540007,0x20082ddd,0x44240335,0x00000000}},	// [2a70] ršot, bebi_, _ynn_, --, 
   {{0x66082dde,0x20082ddf,0x627003f2,0x7c1401f5}},	//   zeek, cebi_, māoa, ндує, 
   {{0x81b00ae3,0x7bdc0323,0x66082de0,0x7ac407ad}},	//   _haɓa, _ddru, yeek, есче, 
   {{0x81b001e7,0x7bdc0222,0x7b640023,0x66082de1}},	//   _kaɓa, _edru, хтуе, xeek, 
   {{0x8d842de2,0xcc8403b5,0x66082de3,0x97300122}},	//   _хунд, _فۆره_, veek, ێکما, 
   {{0x66082de4,0x81b00181,0xef34024b,0x00000000}},	//   week, _maɓa, _ءﯨﺸﯩ, --, 
   {{0x66080c2e,0xba281015,0x645c1ec5,0x161c2120}},	//   teek, تسەم_, èsim, _मोहर_, 
   {{0x7bdc2de5,0xe5a40476,0x44240060,0xdb242de6}},	//   _zdru, мийи, _snn_, _توفی, 
   {{0x66082de7,0x81cc00ac,0x200811e2,0x4424000d}},	//   reek, _লাল_, yebi_, _pnn_, 
   {{0x66082de8,0x291c2de9,0x6f0401d1,0xe3b00075}},	//   seek, mvwa_, _ophc, خرة_, 
   {{0x6e280b66,0x4424001c,0xfbcc0252,0xa5f80b1e}},	//   _òebw, _vnn_, ৰ্কত, _межу_, 
   {{0x1fc40021,0x20082dea,0x44241d50,0xf7482deb}},	//   वर्ड, webi_, _wnn_, _علني_, 
   {{0x241814a2,0x2008137a,0x291c00f1,0x367000cc}},	//   _моды_, tebi_, nvwa_, _حۇيز, 
   {{0x44242dec,0x6720173f,0xa91c0212,0x10a002ba}},	//   _unn_, _krlj, _lyžo, киян, 
   {{0x20082ded,0x10a02dee,0x7bdc011a,0x00000000}},	//   rebi_, тирн, _rdru, --, 
   {{0x20082def,0xbf2800d3,0x7bdc2df0,0x67200473}},	//   sebi_, _aṣòr, _sdru, _mrlj, 
   {{0x81b0028a,0x6b800aa0,0x200800a5,0x629401e3}},	// [2a80] _gaɓa, _ølgj, pebi_, _ihyo, 
   {{0x1da82df1,0x291c2df2,0xbd440046,0x672000e9}},	//   _कलकत, dvwa_, ونځي, _orlj, 
   {{0x81b00ae3,0xddc4010c,0x712401d9,0x00000000}},	//   _zaɓa, _обни, _قریل, --, 
   {{0x7e9c03e6,0x5334007c,0x9f9400b8,0x00000000}},	//   _pōpu, ונען_, _ныҟә, --, 
   {{0x7e642df3,0x00000000,0x00000000,0x00000000}},	//   miip, --, --, --, 
   {{0x7bdc0b53,0x9f480064,0x7e642df4,0x67200ddc}},	//   _udru, ngbï_, liip, _brlj, 
   {{0x67200070,0x7c3c12a6,0x169401b5,0x00000000}},	//   _crlj, _iorr, وٕتھ_, --, 
   {{0x7e642df5,0x7c3c0383,0x7e9c0341,0x8c380e48}},	//   niip, _horr, _tōpu, _wußt, 
   {{0x7c3c2df6,0x62440029,0x041402fa,0x81b40143}},	//   _korr, _tóoj, তানী_, টরা_, 
   {{0x7c3c2df7,0x7e6408cf,0x62942df8,0x672001df}},	//   _jorr, hiip, _ahyo, _frlj, 
   {{0x7c3c2df9,0x78a808c2,0x81b00ae3,0xe7d40691}},	//   _morr, _iidv, _saɓa, _سمنگ, 
   {{0x7c3c2dfa,0x63ac2dfb,0x62942dfc,0x68ec0007}},	//   _lorr, _şant, _chyo, žodž, 
   {{0x7c3c062d,0x00000000,0x00000000,0x00000000}},	//   _oorr, --, --, --, 
   {{0x7c3c2dfd,0x00000000,0x00000000,0x00000000}},	//   _norr, --, --, --, 
   {{0x78a80c91,0x627003f2,0x291c0088,0x4ea40094}},	//   _midv, māon, zvwa_, драа, 
   {{0x78a80a03,0x7e64206f,0x81b00ae3,0x0268006b}},	//   _lidv, giip, _taɓa, _ошый_, 
   {{0x7c3c0f37,0x4fc42dfe,0xa91c135d,0x78a806e2}},	// [2a90] _borr, _осна, _ryžo, _oidv, 
   {{0x6f040710,0x09d40698,0x22902dff,0x00000000}},	//   _tphc, डण्य, máka_, --, 
   {{0x7c3c2e00,0x7e642e01,0x229004e3,0x00000000}},	//   _dorr, biip, láka_, --, 
   {{0x7c3c006f,0x6d342e02,0x70540324,0x291c01e8}},	//   _eorr, _земф, _آنگا, tvwa_, 
   {{0x6e3c2e03,0x78a82e04,0xdd9003a2,0x67200070}},	//   _iosb, _bidv, _موٽ_, _srlj, 
   {{0x7c3c2e05,0x672025bb,0x6e3c2e06,0x78a8004f}},	//   _gorr, _prlj, _hosb, _cidv, 
   {{0x6e3c0520,0x5b000046,0x78a800e5,0x229000ef}},	//   _kosb, _مېلم, _didv, háka_, 
   {{0x7c3c2e07,0x6e3c2e08,0xf7702708,0xfbd001b5}},	//   _zorr, _josb, جاه_, _متہ_, 
   {{0x6e3c2e09,0x6294006f,0x22900192,0xf8f4012b}},	//   _mosb, _rhyo, jáka_, _иптэ, 
   {{0x6e3c0b66,0x6720236d,0x7c3c01b5,0x62940172}},	//   _losb, _trlj, _xorr, _shyo, 
   {{0x63ac2e0a,0x6aa82e0b,0x62641388,0xdb1c001e}},	//   _şans, _kief, евна, kapý, 
   {{0x6e3c2e0c,0xf0880107,0x7e64034a,0x244800d3}},	//   _nosb, _הנ_, xiip, _túmo_, 
   {{0xc5680cc8,0x7e642e0d,0x00000000,0x00000000}},	//   _بحال_, viip, --, --, 
   {{0x6aa82e0e,0x66182e0f,0xdfd00075,0x64a403a7}},	//   _lief, _hawk, طير_, _џака, 
   {{0x66182e10,0xfe7803c4,0x1e942e11,0x6294051f}},	//   _kawk, дүн_, ерар, _thyo, 
   {{0x7c3c2e12,0x6aa82e13,0x6e3c2e14,0x229003aa}},	//   _sorr, _nief, _cosb, báka_, 
   {{0x9c242e15,0x66182e16,0x6e3c009c,0x644c036b}},	// [2aa0] ндад, _mawk, _dosb, _ïais, 
   {{0x6e3c0083,0x66182e17,0x7c3c2e18,0xcc840241}},	//   _eosb, _lawk, _qorr, ебуе_, 
   {{0xd1d40648,0x7c3c2e19,0x6e3c0307,0x2018010b}},	//   _ክሳብ_, _vorr, _fosb, _iapi_, 
   {{0x78a82e1a,0x81b001e7,0x20182e1b,0x7c3c2e1c}},	//   _sidv, _maɓo, _hapi_, _worr, 
   {{0x20182e1d,0xdb1c2e1e,0xc9800476,0x6aa80cec}},	//   _kapi_, lapü, луши, _dief, 
   {{0x20182e1f,0x78a80444,0x244802b2,0x98540254}},	//   _japi_, _qidv, _búmm_, этеш, 
   {{0x6aa8088f,0x20182e20,0x78a82e21,0xdb1c200b}},	//   _fief, _mapi_, _vidv, napü, 
   {{0x66182e22,0x20182e23,0x6aa82e24,0xceb00107}},	//   _cawk, _lapi_, _gief, ניח_, 
   {{0x1cac2e25,0x9f480064,0xa4f42e26,0x78a82e27}},	//   _ནངས_, ngbâ_, نکور_, _tidv, 
   {{0x61f42e28,0x201800cd,0x22900113,0xdb1c2e29}},	//   _acyl, _napi_, váka_, kapü, 
   {{0x6254000a,0x4610009d,0x661811ae,0xdb1c013b}},	//   tšop, _څومر, _fawk, japü, 
   {{0x20181f50,0xdb1c2e2a,0x66180f37,0x22902e2b}},	//   _aapi_, dapü, _gawk, táka_, 
   {{0x26180774,0xeb0c2db5,0x00000000,0x00000000}},	//   _मोटी_, _सन्त_, --, --, 
   {{0x20182e2c,0xdb1c013b,0x1c00216e,0x6e3c2e2d}},	//   _capi_, fapü, र्मल_, _sosb, 
   {{0x201805d1,0x6e3c2e2e,0x81b00181,0x229003aa}},	//   _dapi_, _posb, _gaɓo, sáka_, 
   {{0x20180264,0x6e3c0428,0x9f5800f1,0x6b800085}},	//   _eapi_, _qosb, _rapô_, _ølgi, 
   {{0x31342e2f,0x6aa82e30,0x6aa002ba,0x7db40075}},	// [2ab0] _репр, _rief, _èlfi, اصفا, 
   {{0x20182e31,0xdfd00a1d,0x6aa82e32,0xdb1c0551}},	//   _gapi_, _پيٽ_, _sief, japó, 
   {{0xa91c01d4,0x6e3c2e33,0x6aa800e0,0xdb1c00b8}},	//   _vyžm, _tosb, _pief, papý, 
   {{0x20180094,0x8a400122,0x1ee80061,0x244802b2}},	//   _zapi_, دێرن, _کوێی_, _rúmm_, 
   {{0x20182e34,0x6618006a,0x8c380e48,0x00000000}},	//   _yapi_, _rawk, _fußp, --, 
   {{0xd9402e35,0x66182e36,0x20180054,0x9ba001d0}},	//   реши, _sawk, _xapi_, _چەكى, 
   {{0x6aa806ef,0x66182e37,0xe3b027bb,0x9ba000e7}},	//   _tief, _pawk, یرد_, _نەكى, 
   {{0x66182aba,0x59b001d2,0x00000000,0x00000000}},	//   _qawk, _көшс, --, --, 
   {{0xdb0c1402,0x74f805bc,0x81b00181,0xe5780b61}},	//   _ngbê, нээс_, _saɓo, ьзи_, 
   {{0x61f42e38,0x6aa800b0,0x5eac00c3,0x00000000}},	//   _scyl, _čefy, _ﻳﺎﯞﺭ, --, 
   {{0x661804db,0x7c2802b2,0x00000000,0x00000000}},	//   _tawk, _ódre, --, --, 
   {{0x20182e39,0x21682e3a,0x661802b0,0xe1f00075}},	//   _sapi_, дими_, _uawk, جسد_, 
   {{0x20182e3b,0x29340100,0xe5340668,0x217401cf}},	//   _papi_, דאָן_, _шедь, тунр, 
   {{0x61f40264,0xd24c0046,0xdb1c0638,0xe2c800cc}},	//   _wcyl, منۍ_, tapü, _قوتو_, 
   {{0x62780f5d,0x20182e3c,0x8c38002a,0x09d40143}},	//   _осиё_, _vapi_, _rußp, _হানা, 
   {{0x20182e3d,0x2ee40270,0x3940288a,0x61f402b0}},	//   _wapi_, álfa_, øisk_, _ucyl, 
   {{0x20182e3e,0x6b9402b0,0xdb1c001e,0xe7d00030}},	// [2ac0] _tapi_, _azzg, japò, हराप, 
   {{0xefd40090,0xd00c00cc,0x00000000,0x00000000}},	//   ያቸው_, _ۇلۋ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x752401c3,0x27e80181,0x0c942e3f,0x59642326}},	//   _šizm, ɗani_, ىدەگ, къла, 
   {{0x49902e40,0xd8600329,0x3ea02e41,0xd8380094}},	//   һшәт, аҵаҩ, mmit_, дэй_, 
   {{0x3ea02e42,0xb7d80272,0x51580107,0x60c00031}},	//   lmit_, روبا_, וכנו, _çomu, 
   {{0xdb1c265b,0x00000000,0x00000000,0x00000000}},	//   rapó, --, --, --, 
   {{0x3ea00ca7,0x46640087,0x5ee800aa,0x22500031}},	//   nmit_, крым_, _छिन्_, _nlyk_, 
   {{0x3ea02e43,0x00000000,0x00000000,0x00000000}},	//   imit_, --, --, --, 
   {{0x3ea02e44,0x73382e45,0x2874044a,0x00000000}},	//   hmit_, езор_, _йыхр, --, 
   {{0x22500520,0x3ea00110,0xd708024b,0x25bc0335}},	//   _blyk_, kmit_, _інде_, _ffwl_, 
   {{0x3ea00156,0x55041df0,0x00000000,0x00000000}},	//   jmit_, _ачка, --, --, 
   {{0x81cc00ac,0x88c401d3,0x09d40143,0xd324001e}},	//   _লাখ_, _gośī, _হামা, хьҿи, 
   {{0x7afc012a,0x3ea003fa,0x00000000,0x00000000}},	//   _oqrt, emit_, --, --, 
   {{0x072c0041,0x42540012,0x645c0618,0x40340e0a}},	//   _ﻩﺗﯟ_, _چۆپر, ësie, шерс, 
   {{0x02a42e46,0x3ea02e47,0xdb0c0223,0x645c00d4}},	//   _крым, gmit_, _igbè, īsie, 
   {{0x8d8401d9,0xbdb40106,0x00000000,0x00000000}},	// [2ad0] тувд, рбуј, --, --, 
   {{0x3ea02e48,0x00000000,0x00000000,0x00000000}},	//   amit_, --, --, --, 
   {{0x3ea00f5b,0x22500101,0x00000000,0x00000000}},	//   bmit_, _ylyk_, --, --, 
   {{0xcd0400fc,0x3ea00254,0xa6c400c3,0xa9080075}},	//   _ичги, cmit_, ۇقتى, فيصل_, 
   {{0x656c00c0,0x7f842e49,0xed5400cf,0x00000000}},	//   _ľaho, _ملین, _עבֿר_, --, 
   {{0xdb1c0078,0x00000000,0x00000000,0x00000000}},	//   rapò, --, --, --, 
   {{0x27e82e4a,0x8aa42e4b,0x8a40049d,0x96f401f1}},	//   ğan_, _арад, _پێشن, гејт_, 
   {{0x27e82e4c,0xa91c018b,0x6578015e,0x00000000}},	//   şan_, _lyži, _pxwh, --, 
   {{0x69d82e4d,0xdb0c0528,0xe5080046,0xa5642e4e}},	//   mawe, _agbè, ريدو_, دگان, 
   {{0x3ea00422,0x69d82e4f,0x22502e50,0x00000000}},	//   zmit_, lawe, _slyk_, --, 
   {{0x3ea02e51,0x00000000,0x00000000,0x00000000}},	//   ymit_, --, --, --, 
   {{0x69d800a3,0xddd40214,0x6b800085,0x244800d3}},	//   nawe, chyň, _ølgu, _múmi_, 
   {{0xdb0c0223,0xd5ac2e52,0xa5082e53,0x00000000}},	//   _egbè, _عفو_, _чела_, --, 
   {{0x69d82e54,0x81cc007e,0xa0682e55,0x24480247}},	//   hawe, _লাও_, хага_, _oúmi_, 
   {{0x37d800ac,0x2eb42e56,0x3ea02e57,0x53300381}},	//   _সামর, истс, tmit_, _гејт, 
   {{0x69d82e58,0x3ea02e59,0xe6d000bd,0xdee4018f}},	//   jawe, umit_, _सबैज, коҳи, 
   {{0x69d82e5a,0x3ea02e5b,0x62440029,0xcee00200}},	// [2ae0] dawe, rmit_, _dóot, _құтқ, 
   {{0x62842e5c,0xa3e80021,0x3ea02e5d,0x656c01d4}},	//   loko, यलट_, smit_, _ľahl, 
   {{0x3ea02e5e,0x69d8028b,0x5f440075,0x00000000}},	//   pmit_, fawe, _إنجل, --, 
   {{0x24842e5f,0x62842e60,0x69d82e61,0x6ab40337}},	//   holm_, noko, gawe, _duzf, 
   {{0x18682e62,0x09e02e63,0x6284042e,0x161c00b6}},	//   нади_, сочн, ioko, _मोगर_, 
   {{0x62842e64,0xf7081123,0x00000000,0x00000000}},	//   hoko, вфиқ_, --, --, 
   {{0x69d82e65,0xdb0c00d3,0x00000000,0x00000000}},	//   bawe, _ogbé, --, --, 
   {{0x62842e66,0x6244175c,0x86200122,0x00000000}},	//   joko, _xóot, یکۆل, --, 
   {{0x62842e67,0x00000000,0x00000000,0x00000000}},	//   doko, --, --, --, 
   {{0xdb0c0229,0x98a401c8,0x12c400cc,0x00000000}},	//   _agbé, _сизе, лёмг, --, 
   {{0x62842e68,0x26000698,0xd7bc0029,0xcfc801ee}},	//   foko, व्ही_, _l胃kk_, _ﺑﯘﻟﺒ, 
   {{0x62842e69,0x66800324,0xc0580049,0x00000000}},	//   goko, _ویول, ңір_, --, 
   {{0x85540191,0xc108006b,0x00000000,0x00000000}},	//   _میٹر_, лэре_, --, --, 
   {{0x69d82df2,0x24842e6a,0x645c0249,0xef540116}},	//   zawe, colm_, èsit, акгь, 
   {{0x62842e6b,0x69d82e6c,0xa91c02ec,0xc0e40cb2}},	//   boko, yawe, _vyži, _ሞዴል_, 
   {{0x62842e6d,0x24482e6e,0x23700010,0x1c002e6f}},	//   coko, _rúmi_, úzje_, र्सल_, 
   {{0xe6d005d5,0x69d80068,0x32082e70,0x00000000}},	// [2af0] _सब्ज, vawe, _ibay_, --, 
   {{0x69d82e71,0x7bf82e72,0xaed400bf,0x00000000}},	//   wawe, лнур_, _коош, --, 
   {{0x69d82e73,0x6e940b61,0x9ce80012,0x44780100}},	//   tawe, _вину, _یوَے_, ענבע, 
   {{0x8d842e74,0xeb040608,0x00000000,0x00000000}},	//   _бугд, _रहीत_, --, --, 
   {{0x69d82e75,0x80a42e76,0x3208065b,0xa3e40030}},	//   rawe, _خمین, _mbay_, _बएल_, 
   {{0x62442e77,0x627000a2,0xb8000203,0x00000000}},	//   _jóor, tāok, ल्लम_, --, 
   {{0xe7382e78,0x69d82e79,0x62842e7a,0x32082e7b}},	//   тей_, pawe, yoko, _obay_, 
   {{0x62840da6,0x2bdc2e7c,0x62440229,0x00000000}},	//   xoko, मणका, _lóor, --, 
   {{0x27b00121,0x2484013c,0x00000000,0x00000000}},	//   _һәқс, tolm_, --, --, 
   {{0x62842e7d,0x32082e7e,0x290c01f1,0x00000000}},	//   woko, _abay_, _ipea_, --, 
   {{0xe29806d4,0xf77000d5,0x6eb00030,0x00000000}},	//   као_, _ٹال_, _आंगु, --, 
   {{0xe1242e7f,0xf7700075,0x67240207,0xdfd001ac}},	//   амми, _عال_, åhju, ڪيس_, 
   {{0x624400d3,0x161c216e,0x84c40294,0x00000000}},	//   _bóor, _मोटर_, _сљед, --, 
   {{0x32082e80,0x70180103,0xd78c0020,0x00000000}},	//   _ebay_, ліст_, _ምንባራ_, --, 
   {{0x62842e81,0x6244038a,0x00000000,0x00000000}},	//   poko, _dóor, --, --, 
   {{0x290c0243,0xddc40329,0x201c0023,0x62842e82}},	//   _opea_, рбаи, žti_, qoko, 
   {{0x9d440106,0x00000000,0x00000000,0x00000000}},	// [2b00] језд, --, --, --, 
   {{0x26c40197,0x62440d8c,0x00000000,0x00000000}},	//   _otlo_, _góor, --, --, 
   {{0x32082e83,0x290c2e84,0x26c42e85,0x00000000}},	//   _ybay_, _apea_, _ntlo_, --, 
   {{0xdb1c2e86,0xa91c00ef,0x38c80122,0x539802c3}},	//   kapö, _lyžu, هاتی_, דיעו, 
   {{0x891401d9,0xdb1c0139,0x98a4001e,0x00000000}},	//   لغوز_, japö, аиде, --, 
   {{0x986400cd,0x1c00083e,0xda6401ac,0x00000000}},	//   جیئے_, र्शल_, _ڦاسي, --, 
   {{0x290c05bc,0xd5e0063e,0x46e4002c,0xe9a800e7}},	//   _epea_, _nkọ, ңдән_, ندۇن_, 
   {{0xd01c00ac,0x96080007,0x42200095,0xd94400cc}},	//   দায়_, тэка_, ययोः_, _кеби, 
   {{0xd90c2e87,0x26c40197,0xd4982e88,0xdb0c0353}},	//   _آیت_, _etlo_, кро_, _afbø, 
   {{0x320805b8,0x76d80123,0x00000000,0x00000000}},	//   _sbay_, _будӣ_, --, --, 
   {{0x0bb4033c,0x6f0806f7,0x78840012,0x843001f5}},	//   ילים_, łecz, _پێژِ_, інює, 
   {{0x81b00181,0xeeb8222d,0x62440029,0x82f401b8}},	//   _zaɓi, ғлаш_, _sóor, گریز_, 
   {{0xc6900240,0x660c2e89,0x00000000,0x00000000}},	//   _ואף_, _ñaka, --, --, 
   {{0xdb1c00af,0x920000d4,0x00000000,0x00000000}},	//   lapõ, _šādo, --, --, 
   {{0x4500080d,0x09d400ac,0xb7f802fa,0x28dc0098}},	//   _མདོར_, _হাসা, _আঘাত_, _नौनि, 
   {{0x8778007c,0x6b74002c,0x00d803b5,0x62440d8c}},	//   דאלי, ҡлау, دبێت_, _wóor, 
   {{0x656c018b,0x8bb40272,0x62440029,0x00000000}},	// [2b10] _ľahk, لإضا, _tóor, --, 
   {{0x8bc42d7b,0x13d802fa,0xdb1c00af,0x00000000}},	//   рсад, _দাড়, hapõ, --, 
   {{0x290c042e,0xc5fc02fa,0x8aa40182,0x2bc800aa}},	//   _spea_, ্যতা_, ардд, ाँबा, 
   {{0x09d402fa,0xdb1c00af,0x66e400ec,0x00000000}},	//   _হাহা, japõ, ҡола, --, 
   {{0x692402ac,0xb9e8024b,0xdb1c013c,0x00000000}},	//   смла, рміз_, dapõ, --, 
   {{0x60c0000f,0x6d4c2e8a,0xdb1c0139,0x00000000}},	//   _éome, myaa, vapö, --, 
   {{0x6d4c2e8b,0xb92001e5,0x612c034a,0x4910084b}},	//   lyaa, _karị_, _kôlô, _धनको_, 
   {{0x80b82933,0xe6182e8c,0xb92001e5,0x6d4c028b}},	//   _অবস্, уди_, _jarị_, oyaa, 
   {{0x6d4c2e8d,0x81b00181,0xe1f8006e,0x2cb8000b}},	//   nyaa, _taɓi, ңго_, _jusd_, 
   {{0x6d4c0012,0xdb1c2e8e,0x00000000,0x00000000}},	//   iyaa, rapö, --, --, 
   {{0x6d4c2e8f,0xf5080182,0xa91c00b0,0xdb1c00af}},	//   hyaa, гнөл_, _vyžu, bapõ, 
   {{0xb92005b6,0x6d4c030b,0xeb0400a1,0x244806b4}},	//   _narị_, kyaa, _रहैत_, _rúmu_, 
   {{0x64c42e90,0x60642e91,0xa97800cf,0x00000000}},	//   _ايتل, йҗиң_, ראָכ, --, 
   {{0xa0742e92,0x6d4c2e93,0x46100324,0xa0a40182}},	//   сымш, dyaa, _دوچر, сагд, 
   {{0x6d4c01b5,0x8c380104,0x00000000,0x00000000}},	//   eyaa, _fußz, --, --, 
   {{0xdcb0075f,0x6d4c2e94,0x3ce000af,0x00000000}},	//   كىر_, fyaa, tsiv_, --, 
   {{0xc2c000a3,0x6d4c2e95,0xdc7400b8,0x00000000}},	// [2b20] _ايڊي, gyaa, быжь, --, 
   {{0x3ce02e96,0xb0b403ef,0x2cb8015e,0x649c000b}},	//   rsiv_, ंदरग, _dusd_, bèie, 
   {{0x15880853,0x6d4c2e97,0x2cb8015e,0x00000000}},	//   ﺗﯩﺴﯩ, ayaa, _eusd_, --, 
   {{0x6d4c2e98,0xaa64021d,0x79c8018f,0xfe78012b}},	//   byaa, отік, рқаб_, _түб_, 
   {{0xdd902e99,0xdb0c00d3,0x6d4c0060,0xdcb00200}},	//   _روس_, _igbí, cyaa, _ءىس_, 
   {{0x7d042e9a,0xb900021f,0x9f480029,0xa91c00e5}},	//   mtis, _दब_, _ójóo_, _ryžt, 
   {{0x7d042e9b,0x09d400ac,0xca700061,0x00000000}},	//   ltis, _হারা, _کۆنک, --, 
   {{0xceb00240,0x645c0422,0x60d40201,0x69d82e9c}},	//   היה_, ësin, _owym, मरणी, 
   {{0x7d042e9d,0xdb1c2e9e,0x59cc0095,0x00000000}},	//   ntis, rapõ, _ह्यर, --, 
   {{0x7d042e9f,0x73d800f8,0x33742ea0,0x00000000}},	//   itis, шдор_, жгор, --, 
   {{0x7d042ea1,0x81b00181,0x244806b4,0x00000000}},	//   htis, _maɓu, _rúmt_, --, 
   {{0x7d041154,0x6d4c2ea2,0xd060009f,0x4b780100}},	//   ktis, yyaa, ərəc, ראטו, 
   {{0x6d4c004b,0x518400e7,0x60d40323,0xd38800df}},	//   xyaa, суна, _cwym, _өйде_, 
   {{0x80b800ac,0x612c034a,0x60d40335,0x249401b5}},	//   _অবশ্, _sôlô, _dwym, _وۅٹھ_, 
   {{0x612c034a,0x63ac0100,0x6d4c028b,0x00000000}},	//   _pôlô, _ĝang, wyaa, --, 
   {{0x7d042ea3,0x3d140310,0x8d840128,0x63ac0237}},	//   ftis, _नईखे_, бузд, _ŝang, 
   {{0xdb0c1402,0x6d4c0ca7,0x7d042ea4,0x60d403c7}},	// [2b30] _ngbâ, uyaa, gtis, _gwym, 
   {{0x6d4c2ea5,0x459800cf,0x00000000,0x00000000}},	//   ryaa, רסמע, --, --, 
   {{0xdb0c0239,0x7d042ea6,0x6d4c2ea7,0x63ac059c}},	//   _agbâ, atis, syaa, _şanz, 
   {{0x02f80100,0xc864069d,0xfba8021d,0x1ea814de}},	//   רלאמ, әтди, стуй_, _پاپي_, 
   {{0x6d4c0ca1,0x627000a2,0xf3f00143,0x2cb0012b}},	//   qyaa, māot, জ্যর_, _tizd_, 
   {{0xd5e00223,0xdb1c034a,0xa6c826d7,0xe9d803ef}},	//   _amò, tapô, алка_, _weź_, 
   {{0x70b4002f,0xdc9800ca,0x265800b7,0x00000000}},	//   ंदुल, _כישל, ириќ_, --, 
   {{0x81b0028a,0xb6580007,0x24e82ea8,0x00000000}},	//   _zaɓu, йшых_, амии_, --, 
   {{0x1fa42ea9,0xd5ac009d,0xe4582eaa,0x29180078}},	//   _खण्ड, نځه_, ижи_, _èsa_, 
   {{0x38a0197c,0x48740eb6,0x60d403c7,0x24480bbc}},	//   gòrd_, _ادرس, _rwym, _rúms_, 
   {{0x4f78010f,0x1604006c,0xdb0c02b2,0x60d42eab}},	//   _አቤቱታ_, व्हर_, _ofbý, _swym, 
   {{0x7d042eac,0xa3b40cd4,0x00000000,0x00000000}},	//   ytis, _झलक_, --, --, 
   {{0x7d040034,0x66080085,0x00000000,0x00000000}},	//   xtis, mfek, --, --, 
   {{0x66082ead,0x6594001e,0x1ea801ac,0x1ec80bf5}},	//   lfek, _лаҵу, ڄاري_, илги_, 
   {{0xe29815fd,0x1fa82eae,0xc0e8010f,0x64400337}},	//   _как_, ркви_, ማየሁ_, mjli, 
   {{0x7d041b56,0xdbe01225,0x60d403c7,0x64400207}},	//   ttis, खण्ड_, _twym, ljli, 
   {{0x7d042eaf,0x38a0052b,0xe0d00272,0x66082eb0}},	// [2b40] utis, lòre_, _غزة_, ifek, 
   {{0x7d042eb1,0x64400008,0x63ac00df,0xdce400e0}},	//   rtis, njli, _şany, _izkļ, 
   {{0x9f042eb2,0xda640302,0x00000000,0x00000000}},	//   _بوجو, овжи, --, --, 
   {{0x6080010f,0x7640015e,0x19f40012,0x0b1800dc}},	//   _የቅጣት_, xjmy, زِتھ_, ণমূল_, 
   {{0xdca42eb3,0x81b00181,0x00000000,0x00000000}},	//   _мами, _taɓu, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bdc2eb4,0x66082ce0,0x229003aa,0x00000000}},	//   _ieru, ffek, láku_, --, 
   {{0x7bdc2eb5,0xdb0c0223,0xa91c00ef,0x00000000}},	//   _heru, _igbà, _vyžr, --, 
   {{0x7bdc2eb6,0x00000000,0x00000000,0x00000000}},	//   _keru, --, --, --, 
   {{0x3a242eb7,0x248801c6,0x2dcc0a82,0x64400475}},	//   _hamp_, _ƭama_, _ﺑﯩﻠﻤ, gjli, 
   {{0x7bdc2eb8,0xd5e80012,0xd1cc0020,0x00ac080a}},	//   _meru, _نٹان_, ባራቱ_, ﺳﻪﺗﺘ, 
   {{0x7bdc2eb9,0x3a242eba,0x00000000,0x00000000}},	//   _leru, _jamp_, --, --, 
   {{0x70b40098,0x229002aa,0x00000000,0x00000000}},	//   ंदेल, jáku_, --, --, 
   {{0x7bdc2ebb,0x63ac01c6,0x3a242ebc,0x2290014d}},	//   _neru, _ŝane, _lamp_, dáku_, 
   {{0xb8fc080d,0xcdd82b28,0xff042ebd,0xce682ebe}},	//   _ཡས_, иња_, мятн, арад_, 
   {{0x7bdc2ebf,0xb3bc02fa,0xfbd001b5,0x00000000}},	//   _aeru, _আজিজ, ۆتم_, --, 
   {{0x7bdc2ec0,0xdb0c0223,0x32182ec1,0x386c0353}},	// [2b50] _beru, _agbà, mesy_, _omdr_, 
   {{0x7bdc2ec2,0x32182ec3,0xfbd02ec4,0xb8f4004f}},	//   _ceru, lesy_, نتم_, _ceṭī, 
   {{0x627004c4,0x3a240207,0xfe7001b8,0x00000000}},	//   māor, _bamp_, ردہ_, --, 
   {{0x32182ec5,0x7bdc2ec6,0x3a242ec7,0x2290012c}},	//   nesy_, _eeru, _camp_, báku_, 
   {{0xcfa82ec8,0x7bdc2ec9,0x69342028,0x2290012c}},	//   _حاکم_, _feru, янду, cáku_, 
   {{0x386c05e1,0xd8201198,0x32180247,0xfeb8066c}},	//   _cmdr_, едши, hesy_, _دایت_, 
   {{0x645c0020,0x00000000,0x00000000,0x00000000}},	//   ësim, --, --, --, 
   {{0x386c02d4,0x7bdc2eca,0x3218034a,0x3a242ecb}},	//   _emdr_, _zeru, jesy_, _gamp_, 
   {{0x7bdc2ecc,0x321800fa,0x07182cbd,0x848402b4}},	//   _yeru, desy_, _भैरव_, _ምእማን_, 
   {{0xfdb80021,0x7bdc2607,0x3a2401df,0x391400fc}},	//   _अल्फ, _xeru, _zamp_, _юмур, 
   {{0x3a240337,0xdbdc00d3,0x32180693,0x66080582}},	//   _yamp_, _díèd, fesy_, pfek, 
   {{0x672000e9,0x23c0030f,0x00000000,0x00000000}},	//   _islj, _bæjó_, --, --, 
   {{0x55b80107,0x8fa00329,0xd24c00e2,0xa18801d9}},	//   _המנו, ҵаре, چنۍ_, ёбга_, 
   {{0x39400274,0x291c0dbc,0xe3b801f1,0x55500c18}},	//   äisi_, iwwa_, _убк_, _سپىر, 
   {{0x7bdc2ecd,0x28dc0aff,0x68f801ed,0x8fa00111}},	//   _reru, _नौसि, huwd, еаре, 
   {{0x32182ece,0x229003aa,0x68f802e6,0x00000000}},	//   cesy_, táku_, kuwd, --, 
   {{0x7bdc2ecf,0x3a242ed0,0x68f80031,0xd12c020e}},	// [2b60] _peru, _ramp_, juwd, _ممي_, 
   {{0x3a24175c,0xdb0c0528,0x7bdc132a,0x68f8018c}},	//   _samp_, _agbá, _qeru, duwd, 
   {{0x7bdc2ed1,0x3a24025e,0x68f810a8,0x50180107}},	//   _veru, _pamp_, euwd, _פוטו, 
   {{0x7bdc2ed2,0xfe5801d9,0x645c02bb,0x00000000}},	//   _weru, _بیرب_, ësij, --, 
   {{0x7bdc2ed3,0x3a2401c6,0x6bd4184e,0xf9180324}},	//   _teru, _vamp_, ستەر, تراژ_, 
   {{0x3a241b59,0x7bdc1658,0xd6d8263d,0x1ae4006b}},	//   _wamp_, _ueru, бти_, _ногм, 
   {{0x6b9400df,0x88b001d9,0x00000000,0x00000000}},	//   _gyzg, ریمچ, --, --, 
   {{0x4b780107,0xd56422a0,0x00000000,0x00000000}},	//   _האלו, зтоп, --, --, 
   {{0x5fbc186f,0x244801d4,0x321802cc,0x00000000}},	//   ्डाल, _púmp_, vesy_, --, 
   {{0xdecc0020,0xa17c001d,0xddc80049,0x00000000}},	//   እለን_, _የንፁህ_, _ﺑﯩﺰﺑ, --, 
   {{0x32182ed4,0x00000000,0x00000000,0x00000000}},	//   tesy_, --, --, --, 
   {{0x63ac007c,0xb9e40b22,0x145800b8,0xd4c400b7}},	//   _ŝanc, _ካን_, ршҩы_, _ескп, 
   {{0x32182ed5,0x62700299,0xdb08014e,0x00000000}},	//   resy_, tāor, _ónær, --, 
   {{0x32180364,0xf4200252,0x04400027,0xddd42ed6}},	//   sesy_, বাহৰ_, _печн, lkyň, 
   {{0x842000cc,0x00000000,0x00000000,0x00000000}},	//   _سىين, --, --, --, 
   {{0xf1c000bd,0xddd402cc,0x55f80143,0x00000000}},	//   _एलिन, nkyň, _আসুক_, --, 
   {{0x72740422,0x62700299,0x48d40143,0x200c00e5}},	// [2b70] _ብረታዊ_, pāor, _সম্র, _ūkių_, 
   {{0x649c000b,0x7c9400c3,0x00000000,0x00000000}},	//   hèin, ىشلا, --, --, 
   {{0xead80256,0x69cc0b66,0xe7a40059,0x00000000}},	//   імді_, ñaeo, ādīš, --, 
   {{0x2ee40038,0x7ac40106,0xddd401d4,0x00000000}},	//   álfu_, хсфе, jkyň, --, 
   {{0xddd402cc,0x645c02bb,0x65e40049,0x00000000}},	//   dkyň, ësik, _ﺍﺩﯨﻠ, --, 
   {{0xf7702ed7,0xe73801ec,0x291c017b,0xddd403bf}},	//   گاه_, жек_, rwwa_, chył, 
   {{0xab9400c8,0x6ac401d9,0x660c0d8c,0x00000000}},	//   _циві, _آقرم, _ñakk, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69c82ed8,0xa3f400e5,0x00000000,0x00000000}},	//   _ifee, мянш, --, --, 
   {{0x68e82ed9,0x7d000207,0x69c82eda,0x00000000}},	//   _ived, _åmse, हुरी, --, 
   {{0x59080560,0xc6a42edb,0x67200070,0x68e819e2}},	//   _གདོས_, _ерди, _uslj, _hved, 
   {{0x38a0197c,0xe5e401d9,0x442803ef,0x68e82edc}},	//   mòra_, _آزای, śc_, _kved, 
   {{0x160403c3,0xc1780108,0x00000000,0x00000000}},	//   _वॉटर_, яҗи_, --, --, 
   {{0xa0682edd,0x94b800ca,0x00000000,0x00000000}},	//   цага_, _ומסת, --, --, 
   {{0x4424251d,0x28dc2ede,0x69c82edf,0x626401d9}},	//   _ian_, नीति, _ofee, _овка, 
   {{0x44242ee0,0x68e82ee1,0x69c8074e,0x45080126}},	//   _han_, _oved, _nfee, _ཁྱོར_, 
   {{0x41b40012,0x9c242ee2,0x00000000,0x00000000}},	// [2b80] _سۅسر, мдад, --, --, 
   {{0xee380a3a,0x44240240,0x69c82ee3,0xc0cc001d}},	//   онӣ_, _jan_, _afee, ባኛል_, 
   {{0x4424225e,0x68e81ed7,0x2ee40038,0x5f040023}},	//   _man_, _aved, álft_, _ўзма, 
   {{0x44242ee4,0x5cf40123,0x00000000,0x00000000}},	//   _lan_, _оягу, --, --, 
   {{0x442418ed,0x09e02ee5,0xc9802ee6,0x58841a67}},	//   _oan_, точн, куши, мыка, 
   {{0x44242ee7,0x45080885,0x69c800f5,0xdca405bc}},	//   _nan_, _ཁྱེར_, _efee, _цаги, 
   {{0x69c8030b,0x68e82ee8,0xddd401d4,0x00000000}},	//   _ffee, _eved, tkyň, --, 
   {{0x44242ee9,0xdecc0020,0x00000000,0x00000000}},	//   _aan_, እለና_, --, --, 
   {{0x44242eea,0xc6a01166,0x73c401c4,0xddd42eeb}},	//   _ban_, ърши, нәйе, rkyň, 
   {{0x44242eec,0xddd42eed,0x00000000,0x00000000}},	//   _can_, skyň, --, --, 
   {{0x44242eee,0x68e82eef,0xa2c0012c,0xddd400c0}},	//   _dan_, _zved, _रूद्, pkyň, 
   {{0x44242ef0,0x926801f5,0x69c801d4,0x00000000}},	//   _ean_, ірна_, _xfee, --, 
   {{0x44242ef1,0xe8042a00,0xc0c8038e,0x00000000}},	//   _fan_, _रामा_, дусе_, --, 
   {{0x44242ef2,0x00000000,0x00000000,0x00000000}},	//   _gan_, --, --, --, 
   {{0x00ac01ee,0x50280020,0xfbe400dc,0x7f941baf}},	//   _ﺳﻮﺗﺘ, _ብዝከኣ, মলাত, варх, 
   {{0x6db42ef3,0x00000000,0x00000000,0x00000000}},	//   ейбу, --, --, --, 
   {{0x44242ef4,0x6244065b,0x00000000,0x00000000}},	// [2b90] _yan_, _nóoy, --, --, 
   {{0x44242ef5,0x69c8241a,0xdfd001ac,0x00000000}},	//   _xan_, _sfee, _ٽيٽ_, --, 
   {{0xdb0c0064,0x59080126,0xe9442ef6,0x00000000}},	//   _ngbä, _གདུས_, کرای, --, 
   {{0xdb0c01b8,0x37d80143,0x2bdc0098,0x00000000}},	//   áján, _সাগর, यरहा, --, 
   {{0xe6ec0c75,0xbd940041,0xcce403e0,0xd7ec2ef7}},	//   _väčš, _ақтө, _تسجي, ڭكى_, 
   {{0x3b3c001d,0x00000000,0x00000000,0x00000000}},	//   _በጋምቤ, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68e80302,0x2d982ef8,0x45080560,0xfaa400c3}},	//   _tved, _kyse_, _ཁྱུར_, _ашун, 
   {{0xe57812ba,0x68e82ef9,0x44242efa,0x74f801a7}},	//   язи_, _uved, _pan_, мээс_, 
   {{0x44242efb,0x2d982efc,0xf6740061,0x00000000}},	//   _qan_, _myse_, _یانخ, --, 
   {{0x44242efd,0xe2982efe,0x2d98103a,0x870413e9}},	//   _van_, зан_, _lyse_, _زبال, 
   {{0x44242eff,0x6244038a,0x80d402fa,0xdce401d4}},	//   _wan_, _jóox, _তিব্, _vykĺ, 
   {{0x44242f00,0x2d980f37,0x5fbc022d,0x00000000}},	//   _tan_, _nyse_, ्डलल, --, 
   {{0x44242f01,0x645c012a,0x64a40094,0x00000000}},	//   _uan_, êsid, _яала, --, 
   {{0x3d100130,0x3228021c,0x2d982f02,0x00000000}},	//   _yεwכ_, ötyä_, _ayse_, --, 
   {{0x2d982f03,0xc2b42f04,0x00000000,0x00000000}},	//   _byse_, _шөпш, --, --, 
   {{0x61e42f05,0x6294041c,0x12780100,0x00000000}},	// [2ba0] makl, _ikyo, _מאקע, --, 
   {{0x61e42f06,0x2d980353,0x00000000,0x00000000}},	//   lakl, _dyse_, --, --, 
   {{0x09d40301,0x20c40014,0x6294007b,0x545400cf}},	//   _হাজা, _hôi_, _kkyo, עסען_, 
   {{0x2d980086,0x00000000,0x00000000,0x00000000}},	//   _fyse_, --, --, --, 
   {{0x2d980085,0xa2c00098,0xd5b82f07,0x00000000}},	//   _gyse_, _रूस्, үси_, --, 
   {{0xd6d82f08,0x20c40710,0xe8042f09,0x61e42f0a}},	//   пти_, _môi_, _राणा_, hakl, 
   {{0x4c902f0b,0x61e42f0c,0x8ba02f0d,0x7e64036b}},	//   _сиёс, kakl, _бирж, ohip, 
   {{0xc2140130,0x7e642f0e,0x6294074e,0x61e42f0f}},	//   _nbɔ_, nhip, _nkyo, jakl, 
   {{0x61e42f10,0xd4042f11,0x20c4001c,0x00000000}},	//   dakl, няни, _nôi_, --, 
   {{0xc2140271,0x62942f12,0x1a6403b5,0x00000000}},	//   _abɔ_, _akyo, _تیڤی_, --, 
   {{0x7e642f13,0x61e42f14,0xd3782f15,0xd70401f5}},	//   khip, fakl, ячи_, _їзди, 
   {{0xe684002c,0x20c42f16,0x61e42f17,0x28dc081a}},	//   _үҙәк_, _bôi_, gakl, नीवि, 
   {{0x99900937,0x7e640828,0xc68c139d,0x0fe000e7}},	//   ýyň_, dhip, _اِن_, лөнү, 
   {{0x62942f18,0x45080126,0x1cdc0126,0x657c0028}},	//   _ekyo, _ཁྱིར_, _ལྦེ_, úshe, 
   {{0x61e42f19,0x83302f1a,0x2d9803f4,0xb8ec0126}},	//   bakl, _مريض, _syse_, _ྱང_, 
   {{0x61e40397,0x645c0020,0x43980107,0x7e642f1b}},	//   cakl, ësiv, _מבוג, ghip, 
   {{0x61440572,0x20c4000d,0x8d742f1c,0x00000000}},	// [2bb0] _لىيە, _gôi_, رارا, --, 
   {{0xe80417d6,0x7e640299,0x2d9803aa,0x00000000}},	//   _राधा_, ahip, _vyse_, --, 
   {{0x2d980520,0x7c9417cc,0x7e642f1d,0x00000000}},	//   _wyse_, اشقا, bhip, --, 
   {{0x7e642f1e,0x7c3c2f1f,0xdd9000dd,0x00000000}},	//   chip, _enrr, _چوٽ_, --, 
   {{0x6e2c2f20,0x6e3c06ef,0xdd9003a2,0x20c4001c}},	//   mdab, _insb, _نوٽ_, _xôi_, 
   {{0x6e2c030f,0x99840151,0x7ed42f21,0x7b6401d2}},	//   ldab, adoů_, _جزیا, _өтсе, 
   {{0x6e2c0060,0x00000000,0x00000000,0x00000000}},	//   odab, --, --, --, 
   {{0x6e2c2f22,0x7f3c007c,0xfbd0004b,0xea1801ac}},	//   ndab, לעוו, _نتہ_, _ترسڻ_, 
   {{0x69d82f23,0x6e2c00b8,0x5908043b,0x28dc021f}},	//   mbwe, idab, _གདགས_, नीशि, 
   {{0xdb0c0239,0x69d80a79,0x629400a0,0x6e2c0080}},	//   _ngbû, lbwe, _skyo, hdab, 
   {{0x61e42f24,0x6aa82bd5,0x20c40014,0xd5d00846}},	//   takl, _khef, _sôi_, _ध्वज, 
   {{0x6e2c01f9,0x05b803ea,0x7e6402bb,0x00000000}},	//   jdab, _उलटब, xhip, --, 
   {{0x6e2c2f25,0x69d82f26,0x925400e5,0x00000000}},	//   ddab, ibwe, таўт_, --, 
   {{0x23342f27,0x6e3c2f28,0xa0a405bc,0x61e42f29}},	//   _ахир, _ansb, тагд, sakl, 
   {{0x7e642f2a,0x61e42f2b,0xe28401ec,0x656801ab}},	//   thip, pakl, _илки, lzeh, 
   {{0x20c401c0,0x1cdc043b,0xeb64001d,0x00000000}},	//   _tôi_, _ལྦུ_, _መሸጋገ, --, 
   {{0x65682f2c,0x6e3c23f1,0x61441f34,0x660c001e}},	// [2bc0] nzeh, _dnsb, _репа, _ñaku, 
   {{0x69d82f2d,0x6e3c0353,0x6e2c2f2e,0x6568002e}},	//   ebwe, _ensb, adab, izeh, 
   {{0x7e642f2f,0x59080002,0x46b00095,0x65680104}},	//   phip, _གདངས_, ुदाह, hzeh, 
   {{0x7e6408df,0xd12c2f30,0x6568000b,0x6e2c0060}},	//   qhip, _امی_, kzeh, cdab, 
   {{0x18680f5d,0x0d200468,0x6aa80789,0x5f7422a6}},	//   мади_, _күтү, _dhef, _ساگر, 
   {{0xda6403a2,0x69d8007b,0x6aa82f31,0x39400059}},	//   _ڌاري, abwe, _ehef, ģis_, 
   {{0x6aa80a72,0x07040046,0x73c400b8,0x00000000}},	//   _fhef, نيوي_, қәле, --, 
   {{0xb7bc0059,0x656801ab,0xda6400dd,0x00000000}},	//   _maģi, fzeh, _شازي, --, 
   {{0x34940116,0x6568000b,0x661c013c,0x85002f32}},	//   лаир, gzeh, õska, لوين, 
   {{0x850010a0,0x00000000,0x00000000,0x00000000}},	//   گوین, --, --, --, 
   {{0x6e2c03af,0x2c3400cf,0x4bf800ca,0x00000000}},	//   ydab, אָרם_, וליס, --, 
   {{0x35c400f8,0x6aa80475,0x6568002a,0x6e2c0080}},	//   _садҳ, _xhef, bzeh, xdab, 
   {{0x51842f33,0x00000000,0x00000000,0x00000000}},	//   туна, --, --, --, 
   {{0x645c02b4,0x6e2c028b,0x00000000,0x00000000}},	//   ësit, wdab, --, --, 
   {{0x3ce80227,0x69d8028b,0x00000000,0x00000000}},	//   _चौबे_, ybwe, --, --, 
   {{0x68ec005b,0xe1c000df,0x6e2c2f34,0x4ea4018f}},	//   šadi, _гөрй, udab, трга, 
   {{0x6aa82f35,0x320806e2,0x31342f36,0x00000000}},	// [2bd0] _rhef, _icay_, _сепр, --, 
   {{0x6aa82f37,0x3f840333,0x09c82a37,0xddd401d4}},	//   _shef, ğmur_, ाड्य, rnyš, 
   {{0x6aa82f38,0xddc406f7,0xfbd001ee,0xbae40075}},	//   _phef, _dokł, تتق_, لكلي, 
   {{0xbca8006e,0x66e404e7,0x6e2c0080,0xe8040d49}},	//   ىدەك_, ҳока, qdab, _राहा_, 
   {{0x69d8002a,0x069000e3,0xdd300387,0x00000000}},	//   rbwe, یابھ, məşq, --, 
   {{0xe5a40476,0x00000000,0x00000000,0x00000000}},	//   һийи, --, --, --, 
   {{0x3208071c,0xd7ec0075,0x00000000,0x00000000}},	//   _ocay_, سكي_, --, --, 
   {{0xe5a4006e,0xf7a800c3,0x656801ab,0x00000000}},	//   лийи, ﺷﯘﻧﺪ, tzeh, --, 
   {{0x67d42f39,0xa5d82f3a,0x00000000,0x00000000}},	//   _бозу, وبکر_, --, --, 
   {{0x3208043e,0x65682f3b,0xa6340049,0xa4440b1e}},	//   _acay_, rzeh, _әнді, унод, 
   {{0x65682f3c,0x00000000,0x00000000,0x00000000}},	//   szeh, --, --, --, 
   {{0x27e40278,0xf420007e,0x26c40034,0x656801ab}},	//   _heln_, বাগৰ_, _iulo_, pzeh, 
   {{0x645c0661,0x27e40091,0xb7bc015b,0x2918012b}},	//   ësis, _keln_, _raģi, _äsad_, 
   {{0x26c42f3d,0xa0340a44,0xf1b4002c,0x320802b0}},	//   _kulo_, دىست, шҡы_, _ecay_, 
   {{0x26c40537,0xa3cc00cb,0xb7bc00e0,0x00000000}},	//   _julo_, षुः_, _paģi, --, 
   {{0x26c42f3e,0xe8e40a1d,0xa2042f3f,0x6df81166}},	//   _mulo_, _وڻ_, _спид, кхус_, 
   {{0x2074172d,0x26c40156,0xddc403ef,0x116401b8}},	// [2be0] _бунё, _lulo_, _pokł, _ملٹی_, 
   {{0xefd4010f,0x216400bf,0x00000000,0x00000000}},	//   ካቸው_, _атүг, --, --, 
   {{0x32080379,0x00000000,0x00000000,0x00000000}},	//   _ycay_, --, --, --, 
   {{0x3ce80440,0x198802dc,0xdef0001d,0x00000000}},	//   _चौथे_, нбеи_, _ውሃና_, --, 
   {{0x26c40034,0x27e4012b,0x127800cf,0x00000000}},	//   _aulo_, _beln_, עאנע, --, 
   {{0x3ea02f40,0x26c42f41,0xc8c403b5,0x986401b8}},	//   llit_, _bulo_, دوون_, دیئے_, 
   {{0x26c42f42,0x3ea00027,0xdb5000d5,0xcc7400ca}},	//   _culo_, olit_, _اَز_, _עגלת_, 
   {{0x26c410ed,0x3ea00984,0x00000000,0x00000000}},	//   _dulo_, nlit_, --, --, 
   {{0x3ea02f43,0x27e401d1,0x18a40128,0x00000000}},	//   ilit_, _feln_, _баам, --, 
   {{0x3ea02f44,0x26c40110,0xf8b00a1d,0x24500134}},	//   hlit_, _fulo_, _ڏکڻ_, قچىس, 
   {{0x26c42f45,0x3ea02f46,0x6eb80a9e,0x91580223}},	//   _gulo_, klit_, ्दमु, _ọ̀n_, 
   {{0x645c0222,0x2fc00031,0x3ea02f47,0x0bb400ca}},	//   ësir, _sghg_, jlit_, טלים_, 
   {{0x4638007c,0x26c40182,0x3ea02f48,0xa81801d2}},	//   _רעדע, _zulo_, dlit_, _ستەر_, 
   {{0x26c40083,0x50642f49,0x3ea02f4a,0x00000000}},	//   _yulo_, утма, elit_, --, 
   {{0x26c42f4b,0x3ea010c6,0x00000000,0x00000000}},	//   _xulo_, flit_, --, --, 
   {{0x3ea02f4c,0x2bdc0828,0x17740020,0x3208043e}},	//   glit_, यर्थ, _ክንድኡ_, _ucay_, 
   {{0x9f480239,0xe8040440,0x00000000,0x00000000}},	// [2bf0] nabê_, _राला_, --, --, 
   {{0x3ea02f4d,0x00000000,0x00000000,0x00000000}},	//   alit_, --, --, --, 
   {{0xfbd0009d,0x0ba42f4e,0xbb840075,0x5ae400c3}},	//   ستل_, ушам, ملكي, لقلە, 
   {{0x7f8402ac,0x26c42f4f,0x3ea02f50,0x00000000}},	//   _چلین, _rulo_, clit_, --, 
   {{0xc77000e7,0x00000000,0x00000000,0x00000000}},	//   өткө, --, --, --, 
   {{0x26c42f51,0x5d780100,0xfc640074,0x00000000}},	//   _pulo_, _יארק, _лъсн, --, 
   {{0xd6cc0046,0x8aa41b62,0x18641166,0x0a540020}},	//   وقو_, _брад, ращи_, ፋማርያ, 
   {{0xbb84045d,0x661c01c6,0x00000000,0x00000000}},	//   _الفي, ĵsko, --, --, 
   {{0xeb98006e,0x22500579,0x26c40537,0x00000000}},	//   _чиң_, _royk_, _wulo_, --, 
   {{0x26c42f52,0x2da00049,0x00000000,0x00000000}},	//   _tulo_, _ﺃﻭﻟﻰ_, --, --, 
   {{0xf8682562,0x3834038e,0x3ea02f53,0xe2842a43}},	//   _حملي_, _ынфр, ylit_, илои, 
   {{0x3ea001a0,0xe6a402ba,0x00000000,0x00000000}},	//   xlit_, _тузү, --, --, 
   {{0xa50800b7,0x00000000,0x00000000,0x00000000}},	//   _рела_, --, --, --, 
   {{0x3ea00616,0x3074044a,0x00000000,0x00000000}},	//   wlit_, бусс, --, --, 
   {{0x3ea02f54,0x9e740294,0x630400c3,0x00000000}},	//   tlit_, аћај, _ئوبل, --, 
   {{0x3f8c0037,0x3ea02f55,0xe2982f56,0x6dc401e3}},	//   ħdu_, ulit_, _шай_, 奏ari, 
  
   {{0x3ea0056d,0x63ac00cf,0xd2b400ca,0x9c8800c3}},	// [2c00] rlit_, _ŝanh, _דלקת_, پپاق_, 
   {{0x3ea02f57,0x99840b0a,0x00000000,0x00000000}},	//   slit_, jdoš_, --, --, 
   {{0xf1a8024c,0x3ea02f58,0x00000000,0x00000000}},	//   _لایه_, plit_, --, --, 
   {{0x62842f59,0x38a02f5a,0x00000000,0x00000000}},	//   nnko, mòri_, --, --, 
   {{0x62842f5b,0xd824172d,0x397800dd,0x4e24044a}},	//   inko, идди, دشاھ_, _тоян_, 
   {{0x7d042f5c,0x62840104,0x00000000,0x00000000}},	//   muis, hnko, --, --, 
   {{0x7d042f5d,0xf74800dd,0x61f402b0,0x8c4001f1}},	//   luis, العي_, _odyl, _ќесе, 
   {{0x62842bb7,0x59742f5e,0x60d40207,0x7d04034c}},	//   jnko, _кызу, _otym, ouis, 
   {{0x7d042f5f,0x00000000,0x00000000,0x00000000}},	//   nuis, --, --, --, 
   {{0x62842f60,0x61f42f61,0x229003aa,0x98a422b9}},	//   enko, _adyl, máky_, _тизе, 
   {{0x7d042f62,0x60d402e6,0x628406b4,0x2290014d}},	//   huis, _atym, fnko, láky_, 
   {{0x7d042f63,0x628401f5,0x00000000,0x00000000}},	//   kuis, gnko, --, --, 
   {{0x61f4009c,0x7d042f64,0x4fc40348,0x9f480078}},	//   _ddyl, juis, исва, labè_, 
   {{0xdedc0422,0x7d042f65,0x03742f66,0x62842f67}},	//   ሕሪኡ_, duis, احیت_, anko, 
   {{0x60d42f68,0x2290018b,0xfc5802b4,0x12e4024b}},	//   _etym, háky_, _የረጋግ, _тілг, 
   {{0x7d0420fe,0xdce40333,0x2c1800cb,0x5f30001d}},	//   fuis, _aykı, न्नं_, _ችግራቸ, 
   {{0x60d40031,0xa3cc0030,0x22900c8b,0x00000000}},	// [2c10] _gtym, षुक_, jáky_, --, 
   {{0x22900c8b,0x00000000,0x00000000,0x00000000}},	//   dáky_, --, --, --, 
   {{0xeb080075,0x6e942acc,0x705400e3,0x00000000}},	//   اقصى_, _гину, _ننکا, --, 
   {{0xe8f403e0,0xed500012,0x60d40139,0x3a98021d}},	//   مستخ, _ٹھر_, _ytym, атію_, 
   {{0x7d042f69,0xd3640046,0x42380a0b,0x00000000}},	//   cuis, _ځه_, ינאל_, --, 
   {{0xd364024c,0x26d80113,0x9f4800f1,0x00000000}},	//   _فه_, _čsob_, fabè_, --, 
   {{0x99842f6a,0x628403ef,0xe7380668,0x00000000}},	//   rdoš_, ynko, уей_, --, 
   {{0x229003aa,0x2820001d,0xa2c0006c,0xba0800bf}},	//   báky_, _ተፎካካ, _रूग्, _ەتەك_, 
   {{0x846400fc,0x22900c8b,0x00000000,0x00000000}},	//   изиң_, cáky_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c1800cb,0xc66800df,0x60d40098,0x36d40308}},	//   न्यं_, _ишде_, _stym, _дохр, 
   {{0x628401a7,0x20180a65,0x363401d2,0x00000000}},	//   unko, _sbpi_, _ورنس, --, 
   {{0x62842f6b,0x200c019f,0x38a0007f,0x660803f4}},	//   rnko, _öfik_, wòri_, mgek, 
   {{0x660800a1,0x38a024d4,0x7d042f6c,0xd5a40ac9}},	//   lgek, tòri_, vuis, _الهی, 
   {{0x7fb401a0,0xc21001b5,0x628401d4,0xe298012b}},	//   زلرچ, _ۂژ_, pnko, _йак_, 
   {{0x66082f6d,0x9f482f6e,0xf1d00098,0x1f64001e}},	//   ngek, nabé_, थुआन, _ҳком, 
   {{0x60d40083,0x6608002a,0x00000000,0x00000000}},	// [2c20] _utym, igek, --, --, 
   {{0x7d042f6f,0x660806f0,0x22900113,0x00000000}},	//   ruis, hgek, váky_, --, 
   {{0x7d042f70,0x59c40200,0xec3402ac,0x5884001e}},	//   suis, مياك, تولگ, ҩыла, 
   {{0x7d042f71,0xd1d00090,0x35a40090,0x22900212}},	//   puis, _ጨዋታ_, ገንባት_, táky_, 
   {{0x66082f72,0x7d042f73,0x98a401de,0x657c059b}},	//   dgek, quis, биде, úshl, 
   {{0x20082488,0x22900212,0xd9440108,0x91b8023c}},	//   ngbi_, ráky_, _қези, אמני, 
   {{0x59080037,0x66082f74,0x229000ef,0x95c80091}},	//   _གདམས_, fgek, sáky_, лупа_, 
   {{0x66082f75,0x229000ef,0x466400cc,0x00000000}},	//   ggek, páky_, йрым_, --, 
   {{0xaee400cb,0xddc400e5,0xa5080121,0x4d7800cf}},	//   puṇy, _alkū, لىيە_, ָריע, 
   {{0x84840020,0x00000000,0x00000000,0x00000000}},	//   _ዝብልን_, --, --, --, 
   {{0x9f480324,0xdb0c00d3,0xd794059b,0x00000000}},	//   babé_, _igbó, _الضخ, --, 
   {{0x96b82f76,0x00000000,0x00000000,0x00000000}},	//   _сузу_, --, --, --, 
   {{0x73c40ed1,0x00000000,0x00000000,0x00000000}},	//   _мәне, --, --, --, 
   {{0x2e3401e5,0x0f7001d9,0x00000000,0x00000000}},	//   _ụf_, зғор, --, --, 
   {{0x44780240,0x00000000,0x00000000,0x00000000}},	//   _תנוע, --, --, --, 
   {{0xae0421b5,0xadd82f77,0x00000000,0x00000000}},	//   تورى, рмау_, --, --, 
   {{0x46380282,0xcbc42a3b,0xdb0c00d3,0xe184012b}},	// [2c30] נעמע, مزاي, _ogbó, _дөре_, 
   {{0x66081562,0x8bc42f78,0xddc4012c,0x00000000}},	//   zgek, ссад, _mokř, --, 
   {{0x66080618,0x6ed403bf,0xdfd0005e,0x00000000}},	//   ygek, _bąbe, _تيپ_, --, 
   {{0xdb0c0537,0xdd9802dc,0x2be80143,0xabb40116}},	//   _agbó, ушӣ_, খলেই_, баҕә, 
   {{0x6f140197,0xfbe802fa,0x16f40126,0x693400bf}},	//   ltzc, _পারত, ྗེའམ_, юнду, 
   {{0xf99001dc,0x9f480249,0x97c400ec,0x00000000}},	//   ربن_, wabé_, ҙрәһ, --, 
   {{0xb8d01efe,0x66080a81,0x6d4c2f79,0xaa44002c}},	//   _टी_, tgek, lxaa, _һеңл, 
   {{0xc98400b7,0x00000000,0x00000000,0x00000000}},	//   _лузи, --, --, --, 
   {{0x66082f7a,0x6d4c03fa,0x9f4802ba,0x630400e2}},	//   rgek, nxaa, rabé_, ښودل, 
   {{0x66082f7b,0x9f4803f4,0x6ed403bf,0x00000000}},	//   sgek, sabé_, _ząbe, --, 
   {{0x22482f7c,0x66080502,0x6d4c028b,0x17081b89}},	//   апни_, pgek, hxaa, _نفلی_, 
   {{0x2c180828,0x00000000,0x00000000,0x00000000}},	//   न्तं_, --, --, --, 
   {{0x672002b0,0xe5a400b7,0x00000000,0x00000000}},	//   _hplj, _ќили, --, --, 
   {{0x6d4c0080,0x00000000,0x00000000,0x00000000}},	//   dxaa, --, --, --, 
   {{0xd36c183f,0x6d4c0060,0x10a02f7d,0x00000000}},	//   _لهو_, exaa, фирн, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1d082f7e,0x1be80155,0x6d4c0060,0x9db80deb}},	// [2c40] рези_, идаи_, gxaa, рыву_, 
   {{0x67200473,0x656c0101,0x00000000,0x00000000}},	//   _oplj, _ýahu, --, --, 
   {{0xdb0c0223,0x6d4c2f7f,0x2c1800cb,0x5b240075}},	//   _agbò, axaa, न्धं_, تفال, 
   {{0x6d4c2f80,0x09e00c9f,0xdd940329,0x9d4401de}},	//   bxaa, доцн, _ҳаҭы, _демд, 
   {{0x49c4150f,0x98480878,0xa3d80030,0x00000000}},	//   әлән_, ияка_, ़डा_, --, 
   {{0x7e642f81,0x2c1800cb,0x8d78001d,0xe8f40152}},	//   lkip, न्दं_, ሪያቸው_, яһу_, 
   {{0x3d1401c8,0xdb0c0223,0x7e641117,0x00000000}},	//   läw_, _egbò, okip, --, 
   {{0x7e642f82,0xddc40192,0x00000000,0x00000000}},	//   nkip, _pokř, --, --, 
   {{0xceb010bc,0x38a0197c,0x5ba800b6,0x35c8001e}},	//   ויה_, fòrt_, _करुव, аҳҵо_, 
   {{0xb9e00090,0x33742f83,0x7e640027,0x88b001b5}},	//   _ጦር_, згор, hkip, _ہیۆچ, 
   {{0x3d140209,0x7e642f84,0xdeb80b22,0x93882f85}},	//   häw_, kkip, ታምን_, рспа_, 
   {{0x63b40212,0x00000000,0x00000000,0x00000000}},	//   ýzna, --, --, --, 
   {{0x6d4c0fdc,0x00000000,0x00000000,0x00000000}},	//   xxaa, --, --, --, 
   {{0xad2414c8,0x4540005e,0x3d140152,0x00000000}},	//   ۋىزى, _آنوق, däw_, --, 
   {{0x649c052b,0x08740100,0x00000000,0x00000000}},	//   pèir, קעלט_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d4c028b,0x656c0101,0xd0180074,0x00000000}},	// [2c50] uxaa, _ýaht, _кфн_, --, 
   {{0x6d4c0012,0x7e64012f,0xdb1c03aa,0x00000000}},	//   rxaa, akip, _šváb, --, 
   {{0x6d4c028b,0x00000000,0x00000000,0x00000000}},	//   sxaa, --, --, --, 
   {{0x7e642f86,0xba742399,0x672c0098,0xd1c0001d}},	//   ckip, وانت, łajk, _ሹመት_, 
   {{0x672000e9,0xf9a401b5,0xf0340020,0x00000000}},	//   _splj, وٕمُ, _ብምስም, --, 
   {{0xd5e000d3,0x00000000,0x00000000,0x00000000}},	//   _alò, --, --, --, 
   {{0x25a82f87,0xefcc01da,0x00000000,0x00000000}},	//   _šal_, _ኤንድ_, --, --, 
   {{0x53780422,0x24080121,0xe648044a,0x00000000}},	//   _ኣሕዋት_, әнни_, спид_, --, 
   {{0x69c82f88,0xf8f40254,0x64982f89,0x00000000}},	//   _igee, _оптэ, йтор_, --, 
   {{0x68e82f8a,0x7e640054,0x33d401f5,0xb9240075}},	//   _iwed, zkip, міют, _تفكي, 
   {{0x7e641b59,0x68e80403,0x00000000,0x00000000}},	//   ykip, _hwed, --, --, 
   {{0x68e82f8b,0x23280427,0x00000000,0x00000000}},	//   _kwed, _ҳоки_, --, --, 
   {{0x38a0197c,0x613401b8,0x00000000,0x00000000}},	//   còrs_, dülá, --, --, 
   {{0x68e80582,0x201c2f8c,0x00000000,0x00000000}},	//   _mwed, ýti_, --, --, 
   {{0x1ea82f8d,0x69c809e8,0x68e8193d,0x1fa82f8e}},	//   ماري_, _ogee, _lwed, скви_, 
   {{0x69c82f8f,0x437024f8,0x7e64012a,0x68e82f90}},	//   _ngee, _нуқт, ukip, _owed, 
   {{0x68e82f91,0x7e642f92,0x00000000,0x00000000}},	// [2c60] _nwed, rkip, --, --, 
   {{0xeff801e2,0x7e642f93,0x69c82f94,0x9f482f95}},	//   ላቸው_, skip, _agee, labí_, 
   {{0x68e82f96,0xe8042f97,0xd24c2f98,0x7e64018c}},	//   _awed, _राजा_, _شنی_, pkip, 
   {{0x9f4804ac,0x19f40012,0x00000000,0x00000000}},	//   nabí_, سِتھ_, --, --, 
   {{0x69c80247,0xf8b000e2,0xd7f82f99,0x98a42f9a}},	//   _dgee, نکئ_, буй_, пиде, 
   {{0xdcb02f9b,0xb8f42f9c,0x7d042f9d,0x69c8036d}},	//   _سىز_, _सं_, mris, _egee, 
   {{0x1b480155,0x25c0038c,0xd5e00223,0x68e82f9e}},	//   _узви_, ərlə_, _aló, _ewed, 
   {{0x69c80472,0x656c011a,0xf4d802d8,0x00000000}},	//   _ggee, _żaha, омиш_, --, 
   {{0x68e82f9f,0xd4982fa0,0x7d042fa1,0x00000000}},	//   _gwed, йро_, nris, --, 
   {{0x7d042fa2,0x73c4002c,0x00000000,0x00000000}},	//   iris, мәйе, --, --, 
   {{0x7d042fa3,0x68e8084f,0xe87401d9,0x95c823ff}},	//   hris, _zwed, _تنلگ, _лула_, 
   {{0x9a94001d,0x00000000,0x00000000,0x00000000}},	//   _ሆኖአል_, --, --, --, 
   {{0x386c0192,0x7d040085,0xc0e40023,0x00000000}},	//   _kldr_, jris, ноўк, --, 
   {{0x7d042fa4,0x9410012d,0xf1e00121,0x00000000}},	//   dris, _ɔyɛ_, _ﺋﯩﻨﺘ, --, 
   {{0x7d042fa5,0x00000000,0x00000000,0x00000000}},	//   eris, --, --, --, 
   {{0x7d042fa6,0x63640020,0x00000000,0x00000000}},	//   fris, _ዝመጣጠ, --, --, 
   {{0x7d042fa7,0x82342fa8,0x21300055,0xaffc2fa9}},	// [2c70] gris, _سريا, _gsyh_, _копi, 
   {{0x68e80068,0xbec8015b,0x00000000,0x00000000}},	//   _rwed, _skūš, --, --, 
   {{0x7d042faa,0x68e80144,0x00000000,0x00000000}},	//   aris, _swed, --, --, 
   {{0x68e82fab,0x7d18045d,0x7d041d77,0x386c2fac}},	//   _pwed, éasá, bris, _aldr_, 
   {{0x7d042fad,0xe9442fae,0x6d840012,0x386c0055}},	//   cris, برای, _غۅطہ_, _bldr_, 
   {{0x01380107,0xd9400128,0x8cd00095,0x00000000}},	//   פרות_, теши, _भूयो, --, 
   {{0xb8f413bb,0x1dd80a9e,0x00000000,0x00000000}},	//   _सू_, युवत, --, --, 
   {{0x69c809d7,0x68e82faf,0x56900381,0x386c015b}},	//   _ugee, _twed, кајт, _eldr_, 
   {{0x68e82fb0,0x8520049d,0xe5782fb1,0xc7c4138a}},	//   _uwed, رودۆ, юзи_, _есеи, 
   {{0x2a6c2fb2,0xdde404c4,0x00000000,0x00000000}},	//   _hleb_, _āpōp, --, --, 
   {{0xa2282fb3,0xe3b00012,0x04fc02fa,0x2a6c0078}},	//   ожна_, کرک_, ্বের_, _kleb_, 
   {{0x7d042fb4,0x00000000,0x00000000,0x00000000}},	//   yris, --, --, --, 
   {{0x7d0401e3,0x5ba8064c,0x6ed40201,0x00000000}},	//   xris, _कर्व, _rąba, --, 
   {{0x63842fb5,0x7d042fb6,0x9f480552,0x248014cb}},	//   _огла, vris, jabã_, _öhm_, 
   {{0x8fa02890,0x9e642fb7,0x7d042fb8,0x00000000}},	//   варе, وارن, wris, --, 
   {{0xdde8018f,0xd12c00dd,0xf7a80108,0x00000000}},	//   ترسه_, _چمي_, ﺷﯘﻟﺪ, --, 
   {{0xd12c031b,0x00000000,0x00000000,0x00000000}},	// [2c80] _نمي_, --, --, --, 
   {{0xed3405bc,0x3ac8009f,0x5f2802ba,0x00000000}},	//   ээсэ, _aşpa_, _доом_, --, 
   {{0x2a6c0616,0x00000000,0x00000000,0x00000000}},	//   _bleb_, --, --, --, 
   {{0x3a2004d9,0x7d042fb9,0x2a6c0039,0x99840061}},	//   ýip_, pris, _cleb_, ولاو, 
   {{0x611002c6,0x3ea0036b,0xaac42fba,0x660c0247}},	//   _bɛlɛ, moit_, رتمن, _ñaky, 
   {{0xd6d82fbb,0x3ea02fbc,0x2a6c0039,0x176800fc}},	//   оти_, loit_, _eleb_, жрип_, 
   {{0x7a240078,0x3ea003f4,0xf1a400d1,0x39400100}},	//   _pčtč, ooit_, _गुनन, ŭis_, 
   {{0x2a6c2fbd,0xd5640634,0x00000000,0x00000000}},	//   _gleb_, дтоп, --, --, 
   {{0xd4040027,0x8d5800cf,0x18a402ba,0x00000000}},	//   мяни, ַכטי, _жаам, --, 
   {{0x3ea02fbe,0x9854018f,0x00000000,0x00000000}},	//   hoit_, _ўташ, --, --, 
   {{0xd3782fbf,0x3ea00c12,0x41c40560,0x73880108}},	//   ючи_, koit_, _གུཔྟ, яриң_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0fe00340,0x3ea00513,0x00000000,0x00000000}},	//   көнү, doit_, --, --, 
   {{0x320401ec,0x10480302,0x33940007,0x00000000}},	//   şly_, цями_, _палё, --, 
   {{0xb8d0080d,0xc0581ab3,0x00000000,0x00000000}},	//   _ནེ_, фія_, --, --, 
   {{0x02a40329,0xf4840061,0x3ea02fc0,0x00000000}},	//   _ирым, _تاڵی, goit_, --, 
   {{0x86580107,0x00000000,0x00000000,0x00000000}},	// [2c90] קדמי, --, --, --, 
   {{0x6ab80095,0x291800ce,0x00000000,0x00000000}},	//   ेद्र, _īsa_, --, --, 
   {{0x2a6c2fc1,0x00000000,0x00000000,0x00000000}},	//   _pleb_, --, --, --, 
   {{0x0ea4021f,0x3ea02fc2,0x2ab40085,0x00000000}},	//   _कीचड, coit_, kåbe_, --, 
   {{0x6e2c2fc3,0x2a6c006f,0xf1a40098,0x00000000}},	//   meab, _vleb_, _गुमन, --, 
   {{0xe7382fc4,0x6e2c2fc5,0x6e28038a,0x00000000}},	//   зек_, leab, _ñebb, --, 
   {{0xa6c41a05,0xddc4012b,0x2a6c013c,0x3f9c014e}},	//   ىقتى, _kokş, _tleb_, _øvut_, 
   {{0xbb481011,0x6e2c2fc6,0x00000000,0x00000000}},	//   _تلفن_, neab, --, --, 
   {{0xddc40152,0x00000000,0x00000000,0x00000000}},	//   _mokş, --, --, --, 
   {{0xe45003e0,0x3ea023de,0x88800191,0x67d400fc}},	//   اضة_, zoit_, _جیتن, _чожу, 
   {{0xe2842fc7,0x4e0c2465,0x6e2c0426,0x00000000}},	//   елни, िलाई_, keab, --, 
   {{0x69d80335,0x00000000,0x00000000,0x00000000}},	//   ncwe, --, --, --, 
   {{0x6e2c2a36,0x3ea02fc8,0xe4b80200,0x952001a0}},	//   deab, voit_, _елді_, _یکیم, 
   {{0xa0682fc9,0x273001f6,0xd24c0200,0xa87800cf}},	//   чага_, _kšn_, _ۇنى_, לאָר, 
   {{0xa0a412d5,0x53300f0e,0x6e2c059b,0x629c01f6}},	//   _җанд, _бејт, feab, čsob, 
   {{0x6e2c2fca,0xdb0c0039,0x2484013c,0x00000000}},	//   geab, _uzbé, lilm_, --, 
   {{0x62842fcb,0x3ea02fcc,0x1c442fcd,0xeb40001d}},	// [2ca0] miko, roit_, ннам, _የሚገለ, 
   {{0x62842fce,0x4c8001f1,0x00000000,0x00000000}},	//   liko, глув, --, --, 
   {{0x6e2c2fcf,0x79ac00c3,0x3ea00139,0x4fd400ca}},	//   beab, ﺴﺘﯩﻤ, poit_, _רוטב_, 
   {{0x6e2c2fd0,0x62842fd1,0x69d82fd2,0xf1a4025c}},	//   ceab, niko, gcwe, _गुडन, 
   {{0x62840088,0x0d2000c3,0x998402e3,0xb9340111}},	//   iiko, _йүтү, reoů_, телј, 
   {{0xdca40152,0x00000000,0x00000000,0x00000000}},	//   _чаги, --, --, --, 
   {{0x62842fd3,0xbb3001ee,0x2484013c,0x00000000}},	//   kiko, ﻫﻠﻪ_, dilm_, --, 
   {{0x62842fd4,0x34c80095,0x00000000,0x00000000}},	//   jiko, रद्द, --, --, 
   {{0x62842fd5,0x19b80396,0x590801c8,0x35b42fd6}},	//   diko, _хувь_, _хезм_, ъбир, 
   {{0x6e2c2fd7,0x4dc40ce5,0x62840618,0x1cac0126}},	//   zeab, ﯨﺮﯨﻨ, eiko, _ཕེས_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62842fd8,0x93442fd9,0x3944013c,0x2484013c}},	//   giko, _үнде, _krms_, ailm_, 
   {{0x6e2c0ff0,0x7bdc0020,0x93a80191,0x7f942fda}},	//   veab, _ofru, _کاشف_, ҳарх, 
   {{0xc0582fdb,0x74142fdc,0x62842fdd,0x7afc012b}},	//   ніс_, _شوبا, aiko, _ovrt, 
   {{0x62842fde,0x6e2c2fdf,0x7f9403d6,0x00000000}},	//   biko, teab, гарх, --, 
   {{0x7bdc2fe0,0x62842fe1,0x728400d5,0x00000000}},	//   _afru, ciko, _جاتے, --, 
   {{0x6e2c2fe2,0x9f482fe3,0x7afc00a8,0x7e440116}},	// [2cb0] reab, rabá_, _avrt, ыхре, 
   {{0x6e2c2fe4,0xf8b8001c,0x705400e7,0xbca800c3}},	//   seab, _nhĩ_, _شنجا, ۈدەك_, 
   {{0x6e2c02c6,0xab6c010f,0x7afc13bd,0x39442fe5}},	//   peab, _በዚያው_, _cvrt, _arms_, 
   {{0x09c80523,0x8d84012b,0x00000000,0x00000000}},	//   िशेय, _зугд, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62842fe6,0xc71001d3,0xf8b801eb,0x00000000}},	//   ziko, _amūḍ, _chĩ_, --, 
   {{0x62842fe7,0xa694076a,0x57b00121,0x00000000}},	//   yiko, криј, һбәт, --, 
   {{0x62842fe8,0xf1640229,0x3944015e,0xdd8c00d5}},	//   xiko, _ayọ̀_, _frms_, _اڈہ_, 
   {{0x7afc0da7,0x799400b7,0x490001d2,0x00000000}},	//   _zvrt, _битф, _сүлг, --, 
   {{0x62842fe9,0x7bdc0182,0x291c042e,0x00000000}},	//   wiko, _xfru, mtwa_, --, 
   {{0xe2982fea,0xe3b802b3,0x9f5c0055,0x00000000}},	//   дан_, ьбо_, ütü_, --, 
   {{0xe5a400b8,0x24840030,0x00000000,0x00000000}},	//   _ҧиҧи, silm_, --, --, 
   {{0xf65000e4,0x291c2feb,0x2484025e,0x95b400b8}},	//   _دئل_, ntwa_, pilm_, _иршә, 
   {{0x628427a3,0x291c2fec,0xf1b400ec,0xb38401d2}},	//   siko, itwa_, ыҡы_, _өліл, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bdc2fed,0x291c065e,0xddc4015b,0x6284175c}},	//   _sfru, ktwa_, _alkš, qiko, 
   {{0x291c00c4,0x21742fee,0x8d602fef,0x9e340152}},	// [2cc0] jtwa_, _шукр, авте, неңч, 
   {{0x1f642ff0,0x28d40121,0x00000000,0x00000000}},	//   _аком, ﻟﻪﺗﻠ, --, --, 
   {{0xdbdc00d3,0xdee401e3,0x00000000,0x00000000}},	//   _bíòd, _шони, --, --, 
   {{0x19880329,0xddc4015b,0xfde800e2,0x99282ff1}},	//   мбеи_, _elkš, _سکرو_, дюка_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7afc2ff2,0x3a2402d4,0x481001f5,0x497000e5}},	//   _tvrt, _wbmp_, иміс, шліс, 
   {{0x7c3c2cd3,0x291c042e,0x394400b7,0xcc3800cf}},	//   _iarr, atwa_, _wrms_, _קעלט, 
   {{0x7c3c2ff3,0xcf9000ca,0x00000000,0x00000000}},	//   _harr, יטו_, --, --, 
   {{0x7c3c2ff4,0x75842ff5,0x291c06f7,0x81d802fa}},	//   _karr, ыңда, ctwa_, িরা_, 
   {{0x7c3c2ff6,0xdb0c00c2,0x76d802dc,0x00000000}},	//   _jarr, _izbâ, _зудӣ_, --, 
   {{0x7c3c2ff7,0x00000000,0x00000000,0x00000000}},	//   _marr, --, --, --, 
   {{0x7c3c2ff8,0x55e40106,0x00000000,0x00000000}},	//   _larr, _родб, --, --, 
   {{0x7c3c2ff9,0x316c2ffa,0x63800116,0x29c00031}},	//   _oarr, áez_, иҳәа, _ỳaz_, 
   {{0x53440182,0x316c011a,0x00000000,0x00000000}},	//   _ахиа, ġez_, --, --, 
   {{0x4ea40094,0x00000000,0x00000000,0x00000000}},	//   враа, --, --, --, 
   {{0x7c3c2ffb,0x8d742ffc,0x6b7420f2,0x291c08c2}},	//   _aarr, پارا, ңлау, ytwa_, 
   {{0x7c3c2ffd,0x201c00bf,0x79ac00c3,0x00000000}},	// [2cd0] _barr, òtic_, ﺴﺘﯧﻤ, --, 
   {{0xb0342ffe,0x5ee00143,0xcfa8005e,0x00000000}},	//   _снош, _ফিরে, _يادم_, --, 
   {{0x7c3c2fff,0x09c800cb,0x1f2401b5,0x8bc43000}},	//   _darr, िश्य, _یِیہ, тсад, 
   {{0x7c3c3001,0x63b400ef,0x3a2001c6,0x291c3002}},	//   _earr, ýzni, ϲipe_, ttwa_, 
   {{0x69243003,0x6e3c06e2,0xc27c02c3,0xd6cc00e7}},	//   умла, _iasb, וראי, ۋقو_, 
   {{0x7c3c3004,0x6e3c3005,0xfc640683,0x6c780100}},	//   _garr, _hasb, _късн, _טאָפ, 
   {{0x6e3c3006,0x64a43007,0x291c3008,0x09d802fa}},	//   _kasb, ғана, stwa_, দরবা, 
   {{0x7c3c3009,0xe618300a,0x9f5c0045,0x00000000}},	//   _zarr, хди_, ûté_, --, 
   {{0x7c3c300b,0x6e3c300c,0x64a4001e,0x00000000}},	//   _yarr, _masb, лаиа, --, 
   {{0x649c0340,0x7c3c300d,0x6e3c300e,0x49b000c3}},	//   nèix, _xarr, _lasb, _йәһу, 
   {{0xf770300f,0xf8683010,0x684401c4,0x6ed403bf}},	//   _وام_, _جملي_, _инҡа, _dąbk, 
   {{0x6e3c3011,0x00000000,0x00000000,0x00000000}},	//   _nasb, --, --, --, 
   {{0xc1040108,0xa6a800cc,0x00000000,0x00000000}},	//   шүпл, _قاچق_, --, --, 
   {{0x65680172,0x787402ba,0xdfd000ad,0x6ed40098}},	//   myeh, _tàve, صير_, _gąbk, 
   {{0x7c3c3012,0x6aa8011a,0x656801d4,0x00000000}},	//   _rarr, _okef, lyeh, --, 
   {{0x7c3c3013,0x6e3c03af,0xd1b8010f,0x6ed403ef}},	//   _sarr, _casb, ተሞች_, _ząbk, 
   {{0x7c3c3014,0xdcb01412,0x65683015,0x61443016}},	// [2ce0] _parr, مىر_, nyeh, _сепа, 
   {{0x7c3c3017,0x61f43018,0x6e3c0e3d,0x6aa806e2}},	//   _qarr, _heyl, _easb, _akef, 
   {{0x7c3c3019,0x61f4301a,0x6e3c2075,0x60d4301b}},	//   _varr, _keyl, _fasb, _huym, 
   {{0xe3c400ac,0x7c3c301c,0x61f40380,0x99d002fa}},	//   _এভাব, _warr, _jeyl, ার্ক, 
   {{0x58840573,0x61f4301d,0x6568017b,0x0d801d25}},	//   лыка, _meyl, jyeh, _глян, 
   {{0x4424079f,0x60d405b8,0x61f4301e,0x7c3c301f}},	//   _nbn_, _muym, _leyl, _uarr, 
   {{0x6aa8008b,0x57243020,0x6e3c00ba,0xfbb80224}},	//   _fkef, ارتق, _yasb, _अरिम, 
   {{0x61f43021,0x6e3c028b,0x00000000,0x00000000}},	//   _neyl, _xasb, --, --, 
   {{0x44243022,0x85000046,0xe9a4004b,0x661c0078}},	//   _bbn_, موين, _پۯون_, òska, 
   {{0x74142977,0x2018015e,0x44240f37,0x12e4024b}},	//   جودا, _ncpi_, _cbn_, лімг, 
   {{0x61f43023,0x44240618,0x47d003a2,0xc68c0012}},	//   _beyl, _dbn_, _ايمر, _کِن_, 
   {{0x20180126,0x18b01092,0x442418b3,0x61f4059c}},	//   _acpi_, _тәҗр, _ebn_, _ceyl, 
   {{0x6e3c3024,0x44240177,0x61f43025,0x60d4012b}},	//   _rasb, _fbn_, _deyl, _cuym, 
   {{0x8500009d,0x60d43026,0x6e3c3027,0x76400207}},	//   _اوون, _duym, _sasb, ldmy, 
   {{0xb4c03028,0xceb8005b,0x8c643029,0x6e3c302a}},	//   ंगी_, еља_, қтад, _pasb, 
   {{0x6e3c302b,0x4ea4302c,0x7640302d,0x61f4302e}},	//   _qasb, урга, ndmy, _geyl, 
   {{0xb8042923,0x6e3c302f,0x2018014a,0x31340320}},	// [2cf0] रणाम_, _vasb, _fcpi_, _тепр, 
   {{0x6aa83030,0x61f43031,0x6e3c3032,0x00000000}},	//   _skef, _zeyl, _wasb, --, 
   {{0x649c00e7,0x61f4028b,0xa03400c3,0x3d94018f}},	//   rèix, _yeyl, _ئىپت, _ғирр, 
   {{0x61f4009f,0x60d40110,0x6e3c0039,0xb4c00bc2}},	//   _xeyl, _yuym, _uasb, ंगु_, 
   {{0xc27c007c,0x00000000,0x00000000,0x00000000}},	//   ערדי, --, --, --, 
   {{0x1cac0126,0x68440106,0x00000000,0x00000000}},	//   _ཕེག_, рнка, --, --, 
   {{0x5780004f,0x6f000306,0x00000000,0x00000000}},	//   _kāṇā_, álch, --, --, 
   {{0x6aa802b0,0xd75400e2,0x00000000,0x00000000}},	//   _ukef, ؤليت_, --, --, 
   {{0x44240308,0x74f801a7,0xb4c0122a,0x61f43033}},	//   _pbn_, лээс_, ंगू_, _reyl, 
   {{0x61f43034,0x00000000,0x00000000,0x00000000}},	//   _seyl, --, --, --, 
   {{0x44240353,0x60d4018f,0x00000000,0x00000000}},	//   _vbn_, _suym, --, --, 
   {{0x61f4090c,0x61443035,0x216800c8,0x20180670}},	//   _qeyl, аема, вими_, _scpi_, 
   {{0x4424001c,0x60d43036,0x00000000,0x00000000}},	//   _tbn_, _quym, --, --, 
   {{0xd4641ec1,0x1ea803a2,0x4424038a,0x61f4028b}},	//   _више_, چاري_, _ubn_, _weyl, 
   {{0x61f43037,0x64403038,0x1ea83039,0x578000a8}},	//   _teyl, mdli, ناري_, _bāṇā_, 
   {{0x53980107,0x2ba8021f,0x1cac0560,0x3afc0229}},	//   _ביצו, _कड़ा, _ཕེང_, _lápá_, 
   {{0xc0500661,0x1cb80075,0xb9e400c3,0x2d9800cc}},	// [2d00] _ኣገልግ, نائب_, ەتتۇ, гөрө_, 
   {{0xd1b801e2,0xd12c303a,0xeff8010f,0x2c640012}},	//   ተኞች_, _کمی_, ዋቸው_, ٝدمُ, 
   {{0x64400177,0x9ac40191,0x00000000,0x00000000}},	//   idli, لگرہ_, --, --, 
   {{0x50d00012,0x64400308,0xf38c00cf,0x00000000}},	//   _دٲیر, hdli, עראָ, --, 
   {{0xc9a41838,0xc9800027,0x6ed40201,0xd83801aa}},	//   авце_, жущи, _rąbi, вэй_, 
   {{0x644001ed,0x36d400b7,0xf1b8303b,0x00000000}},	//   jdli, бокр, ýši_, --, 
   {{0x6440303c,0x00000000,0x00000000,0x00000000}},	//   ddli, --, --, --, 
   {{0x64400602,0xda700012,0x95c803e3,0x6e60001d}},	//   edli, _بُر_, купа_, _ወገኖች, 
   {{0x64402b13,0xd9440106,0x5fc4040e,0x00000000}},	//   fdli, _њези, ळेतल, --, 
   {{0xb4c00066,0x5344303d,0x2450303e,0x225001ec}},	//   ंगे_, ахма, كچىس, _anyk_, 
   {{0xf98800e2,0x4bf800ca,0x00000000,0x00000000}},	//   _شخړه_, כליס, --, --, 
   {{0xe6380a1d,0x6440303f,0x25640012,0x926801c3}},	//   _ميمڻ_, adli, _گامُ, троа_, 
   {{0x50643040,0x93e401a0,0x64d00095,0x00000000}},	//   атва, _кўйл, सदृश, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c1800b3,0x2b4c01d5,0xa5c400f2,0x00000000}},	//   _पाहू_, _čec_, _utóí, --, 
   {{0xeff00090,0x66d40007,0x30140152,0x313400b7}},	// [2d10] ቃላይ_, _iške, _лдпр, _ѓеор, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa7e4273d,0x29d43041,0x6e48010f,0x00000000}},	//   ەكتى, مياس, ነምግባ, --, 
   {{0x999001ec,0x3afc00d3,0xe97800cc,0x6f140055}},	//   ýyş_, _sápá_, лбеш_, muzc, 
   {{0xf9903042,0x0dc80c9f,0x9de40012,0x3afc0537}},	//   وبه_, _јуни_, _چہہٕ_, _pápá_, 
   {{0xb4c03043,0xf8a80007,0xd1b8010f,0x229007b5}},	//   ंगो_, авік_, ተኞቹ_, mške_, 
   {{0xa7a83044,0x27e8007c,0x94100130,0xbb580108}},	//   ыкка_, ĝan_, _ɔyɔ_, _карх_, 
   {{0x23280288,0xc9843045,0x6440006f,0x27e80100}},	//   қоми_, _кузи, wdli, ŝan_, 
   {{0x88043046,0xa3c81d23,0x22903047,0xcfc0095e}},	//   _نظام, लेन_, nške_, ﯩﺮﺍﺗ, 
   {{0x47883048,0x66d401f6,0x7af800d3,0x6440013c}},	//   _исем_, _aške, _àatà, udli, 
   {{0x64403049,0xe7b407bc,0x98b000c2,0xe2c801cf}},	//   rdli, _اماد, şcăm_, ллод_, 
   {{0x2720304a,0x6f14304b,0xdd1401c8,0x76640012}},	//   món_, duzc, _näşe, _وُلم, 
   {{0x2720304c,0xa508304d,0x5a98067a,0xe5b40152}},	//   lón_, _села_, רשרא, _уйды, 
   {{0x408800ec,0x81d800dc,0x00000000,0x00000000}},	//   рҙом_, িরই_, --, --, 
   {{0x272008b1,0xdee41951,0x630400e2,0xd43400ea}},	//   nón_, соби, _اوبل, _دبنګ, 
   {{0x22500010,0x9290118d,0xe2c801ac,0x00000000}},	//   _unyk_, _најц, _ڌوڪو_, --, 
   {{0x2720304e,0xdd14012b,0x9b88304f,0xd00c00d5}},	// [2d20] hón_, _däşe, گنال_, ظلہ_, 
   {{0x27203050,0x00000000,0x00000000,0x00000000}},	//   kón_, --, --, --, 
   {{0x27203051,0xf1a81683,0x5f440ee5,0x6f140105}},	//   jón_, _مایه_, _انجل, cuzc, 
   {{0x27201b16,0xa0340121,0xa3c800b3,0x91000122}},	//   dón_, _ئىھت, लेय_, _بژێو, 
   {{0x186804e2,0x00000000,0x00000000,0x00000000}},	//   лади_, --, --, --, 
   {{0x27203052,0xda6401ac,0x00000000,0x00000000}},	//   fón_, _ڏاري, --, --, 
   {{0x27203053,0xa3c83054,0xdd1401c8,0x9f48014e}},	//   gón_, लेम_, _yäşe, gabø_, 
   {{0xb6c801b8,0xb4c03055,0x00000000,0x00000000}},	//   جاتے_, ंग्_, --, --, 
   {{0xf8b81afb,0x9990002f,0xb47800c3,0xbbb800bd}},	//   _көк_, żył_, ийиф_, _अरुक, 
   {{0x27203056,0xf484107f,0x201c00cc,0x88c43057}},	//   bón_, تابی, òtil_, _paśū, 
   {{0xd5b004c3,0x87080012,0x00000000,0x00000000}},	//   _کفش_, _معنہ_, --, --, 
   {{0x41e402b3,0x95480210,0xe5780086,0x6f142630}},	//   зіра, _مشتق_, rbŷr_, vuzc, 
   {{0xa3c80030,0xf48403f5,0xefe40020,0x00000000}},	//   लेब_, _واتی, ማሚዑ_, --, 
   {{0x9f5800b7,0x387c015e,0x229001f6,0xbbb8081a}},	//   _iepê_, nhvr_, vške_, _अरूक, 
   {{0xfc5802b4,0x00000000,0x00000000,0x00000000}},	//   _ከረጋግ, --, --, --, 
   {{0xad240b0f,0xa3bc0030,0x00000000,0x00000000}},	//   يىزى, _आरत_, --, --, 
   {{0x27200839,0x92540f5d,0x32083058,0x8cd003ef}},	// [2d30] zón_, _вақт_, _iday_, _भूखो, 
   {{0x27200105,0x6f143059,0xc4d000ca,0x8bc40320}},	//   yón_, puzc, פגע_, бсед, 
   {{0x272001ae,0x00000000,0x00000000,0x00000000}},	//   xón_, --, --, --, 
   {{0x2720305a,0xf1bc0098,0x00000000,0x00000000}},	//   vón_, _ईरान, --, --, 
   {{0xd5a40cc8,0x7c040108,0x00000000,0x00000000}},	//   _آف_, زبەك, --, --, 
   {{0x2720305b,0xd364024c,0x9f48020c,0x387c006f}},	//   tón_, _قه_, tabø_, ghvr_, 
   {{0x3208305c,0x7b64305d,0xf99000e7,0x00000000}},	//   _oday_, _етте, وبۇ_, --, 
   {{0x2720305e,0x2bf00252,0x3208175c,0x9f4802e8}},	//   rón_, _চায়ে_, _nday_, rabø_, 
   {{0x2720305f,0x0420043b,0x644402b2,0x00000000}},	//   són_, _འཁྱམ_, _óhik, --, 
   {{0x27203060,0x32083061,0x1cac0126,0x68e8043e}},	//   pón_, _aday_, _ཕེབ_, _ited, 
   {{0x320805b8,0x68e801c3,0x232800f8,0xe3b00272}},	//   _bday_, _hted, шони_, برة_, 
   {{0x68e80055,0xc6a409a5,0xe124044a,0x00000000}},	//   _kted, _урзи, омми, --, 
   {{0x32083062,0x3e7c01d5,0xf494005e,0x52a00061}},	//   _dday_, _jíte_, _کشند, بڵوق, 
   {{0x201c3063,0x68e8051f,0x3208071c,0x28e00030}},	//   üti_, _mted, _eday_, _पढनि, 
   {{0x931000cc,0xbbb80030,0x00000000,0x00000000}},	//   _قووش, _अरेक, --, --, 
   {{0x68e8071c,0x43702fd6,0xe0d80668,0x201c0560}},	//   _oted, _муқт, _кви_, żti_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2d40] --, --, --, --, 
   {{0xa3bc3064,0x9f5802bb,0x00000000,0x00000000}},	//   _आरा_, _jepë_, --, --, 
   {{0x68e8147c,0x6d5800a2,0x320806e2,0x547800cf}},	//   _ated, äwar, _yday_, סטעו, 
   {{0xddc400e5,0x3208015e,0x539800ca,0x26d8012c}},	//   _jokū, _xday_, ביעו, _čsop_, 
   {{0x81ac0301,0xa3c800b3,0xef1803ef,0x98a40450}},	//   কের_, लेत_, ąże_, оиде, 
   {{0x7d043065,0x36d41725,0x00000000,0x00000000}},	//   msis, покр, --, --, 
   {{0x8b203066,0x7d043067,0x2a7c01ba,0x68e802b0}},	//   _одре, lsis, bhwb_, _eted, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4980332,0x34943068,0xa50800c3,0x00000000}},	//   иро_, запр, مىيە_, --, 
   {{0x7d043069,0x88b0306a,0x00000000,0x00000000}},	//   isis, _قینچ, --, --, 
   {{0x7d04306b,0x1cac043b,0xdb0c012b,0x00000000}},	//   hsis, _ཕེན_, _uzbä, --, 
   {{0x7d04306c,0x95c8306d,0x3208018f,0xc73800ca}},	//   ksis, _кула_, _qday_, _כתבת, 
   {{0xf5240d7f,0x66d4306e,0x7d04306f,0x00000000}},	//   _འདྲཝ_, _iška, jsis, --, 
   {{0x7d043070,0x04400106,0x00000000,0x00000000}},	//   dsis, _жељн, --, --, 
   {{0x7d043071,0x81ac02fa,0x4e881166,0x320802b0}},	//   esis, কেল_, ащам_, _tday_, 
   {{0x7d043072,0x2a7c01f9,0x320802b0,0x59c8260a}},	//   fsis, xhwb_, _uday_, िधार, 
   {{0x7d043073,0x9f580078,0x0dc8018f,0x00000000}},	// [2d50] gsis, _lepè_, руви_, --, 
   {{0x6ed403ef,0x229007b5,0x0cd800bd,0x00000000}},	//   _dąbr, mška_, _बढीम, --, 
   {{0x68e83074,0x7d043075,0x66d401d4,0x229001d1}},	//   _sted, asis, _oška, lška_, 
   {{0x21300247,0x00000000,0x00000000,0x00000000}},	//   _ypyh_, --, --, --, 
   {{0x7d043076,0x229022f1,0x9e580107,0x00000000}},	//   csis, nška_, _הכרט, --, 
   {{0x68e8018b,0x3e7c00aa,0x48a83077,0x9ac0011a}},	//   _vted, _víte_, штем_, _ċċed, 
   {{0x68e806f7,0x6aa800cf,0xca7401c4,0x4a7400ec}},	//   _wted, _ĉeff, _һуҡы, _һыҡт, 
   {{0x9f5800f1,0xba7416dd,0xbacc01ee,0x7990000b}},	//   _depè_, _قاقت, _ﺑﺎﺳﺎ, ühwä, 
   {{0xf8ac0116,0x229003aa,0xa8143078,0xe48801a0}},	//   _аҩ_, jška_, _ндаш, ййид_, 
   {{0x9f580475,0xe12400c3,0x48740249,0x00000000}},	//   _qepë_, үмни, _بدرس, --, 
   {{0xf1a83079,0x22900822,0x00000000,0x00000000}},	//   _עס_, eška_, --, --, 
   {{0xe298307a,0x7d04307b,0x2eb400b6,0x00000000}},	//   сам_, ysis, ंतोत, --, 
   {{0xbbb80357,0x7d0403af,0xe3b00e70,0x00000000}},	//   _अर्क, xsis, برک_, --, 
   {{0x1540307c,0xf1e00121,0x6384307d,0xd1c400e5}},	//   _чешм, _ﺋﯩﻘﺘ, _нгла, яляе_, 
   {{0xa0680256,0x7d04307e,0x10a00094,0x00000000}},	//   _ғана_, wsis, хирн, --, 
   {{0x7d04307f,0x229001d1,0x00000000,0x00000000}},	//   tsis, bška_, --, --, 
   {{0x7d043080,0xe1240027,0x00000000,0x00000000}},	// [2d60] usis, _эмпи, --, --, 
   {{0x7d043081,0x14d400ca,0x00000000,0x00000000}},	//   rsis, פועל_, --, --, 
   {{0x7d043082,0x0d2000bf,0x3ce00444,0xaca80012}},	//   ssis, _үүсү, sqiv_, تھَے_, 
   {{0x61e43083,0x1c1c00a1,0x81ac0143,0x6ed403bf}},	//   nckl, _पावल_, কেঃ_, _wąbr, 
   {{0x7d043084,0x00000000,0x00000000,0x00000000}},	//   qsis, --, --, --, 
   {{0x91b80107,0x7e6401d1,0xac18021d,0x00000000}},	//   זמני, ljip, _місц_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e643085,0x6aa80237,0x8b9800ca,0x38c80061}},	//   njip, _ĉefg, _הבלת, حاڵی_, 
   {{0x9f58008f,0x1dbc251b,0xa3c8182b,0x74c40046}},	//   _depé_, ्धित, लेस_, وښتن, 
   {{0x33743086,0x05703087,0x61e4002a,0x229007b5}},	//   дгор, عايد, eckl, vška_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1dbc052c,0x7e64011a,0x6b800386,0x00000000}},	//   ्धात, jjip, _ülge, --, 
   {{0x7e640010,0x00000000,0x00000000,0x00000000}},	//   djip, --, --, --, 
   {{0x22901cf2,0x61e40331,0x82f43088,0x4ee4021d}},	//   rška_, ackl, _کروز_, зіаз, 
   {{0xb4b81cf7,0x044000e1,0x00000000,0x00000000}},	//   चती_, _чејн, --, --, 
   {{0x81ac0301,0x02a40822,0x8778007c,0xd2440937}},	//   কেই_, _прым, זאלי, _хэки, 
   {{0xfeb804c3,0xad2400ea,0xf8cc0095,0x00000000}},	// [2d70] سافت_, ګرځو, ाषाय, --, 
   {{0xddc40078,0x629403aa,0xcc840061,0x00000000}},	//   _makň, ézov, سۆزه_, --, 
   {{0xddc401e8,0xb5dc024b,0x00000000,0x00000000}},	//   _lakň, _өнiм, --, --, 
   {{0xdfd03089,0x00000000,0x00000000,0x00000000}},	//   _جيپ_, --, --, --, 
   {{0x7c58006e,0x6aa800cf,0x78b8015e,0xbdd40027}},	//   تلەر_, _ĉefd, flvv, _поющ, 
   {{0x9f4803af,0x9f580223,0x6d4c00af,0x00000000}},	//   cabó_, _sepé_, mvaa, --, 
   {{0x6d4c308a,0xa6c81388,0x37d00252,0x61e401c9}},	//   lvaa, олка_, _স্বৰ, yckl, 
   {{0x24e8308b,0x8d70001d,0xdbcc0055,0x6d4c0139}},	//   омии_, _የመስኖ_, _sıçm, ovaa, 
   {{0x6d4c308c,0x12e4024b,0xa2ac0095,0x00000000}},	//   nvaa, _ﺍﻟﻨﻭ, ीतस्, --, 
   {{0xefdc0090,0xa2e4308d,0x6d4c0027,0x00000000}},	//   ሔራዊ_, моод, ivaa, --, 
   {{0x3e7c0635,0x06d400ac,0x6d4c308e,0x78a4000b}},	//   _líta_, _সবকি, hvaa, éive, 
   {{0x7a24308f,0x66d40023,0x6d4c3090,0x6e2c01c6}},	//   _tōtō, _iško, kvaa, jfab, 
   {{0x61e401e7,0x1dd00a9e,0x6d4c084f,0x6f1403ef}},	//   rckl, _दृढत, jvaa, erzc, 
   {{0x2fc002e3,0x6e2c018c,0x6d4c03f4,0x9f4800f1}},	//   _bzhg_, efab, dvaa, dabò_, 
   {{0xa3c81f8b,0x6e2c3091,0x7e643092,0x6d4c0331}},	//   लेश_, ffab, tjip, evaa, 
   {{0xdcb013fa,0x3e7c3093,0x6e2c0085,0x229007b5}},	//   چىر_, _bíta_, gfab, mško_, 
   {{0x9f580239,0x1c443094,0xdb0c00aa,0xef18002f}},	// [2d80] _gepî_, мнам, _vybí, ąża_, 
   {{0x66d43095,0x28e00098,0x00000000,0x00000000}},	//   _oško, _पढ़ि, --, --, 
   {{0x6d4c3096,0x229001f6,0x00000000,0x00000000}},	//   avaa, nško_, --, --, 
   {{0x9f4800f1,0x7cf401e3,0x229000b0,0x1958001e}},	//   babò_, bоrо, iško_, ҩаҧы_, 
   {{0xed34038e,0x0d8000df,0x5f740122,0x48e00023}},	//   _пэрэ, _алян, _راگر, вочв, 
   {{0xd6e83097,0x3fb00853,0x6aa80100,0xb4bc0030}},	//   офил_, ﺳﺘﺎﻧ, _ĉefe, _आठे_, 
   {{0xc0440422,0x7bdc3098,0x46e401c8,0x73d800fc}},	//   _ብዝተፈ, _igru, үдән_, үдир_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x66d40023,0x2290028d,0x35b400cc,0xceb0232c}},	//   _iškl, eško_, эбир, כיה_, 
   {{0x39440636,0xb4b81b12,0x08c03099,0x68ec309a}},	//   _isms_, चते_, _абун, íade, 
   {{0xd6280d72,0x6d4c0403,0xa3c8309b,0x00000000}},	//   _може_, zvaa, लेल_, --, 
   {{0xae1c124e,0x987c02df,0x6d4c0139,0x00000000}},	//   _फाइन_, mçıq_, yvaa, --, 
   {{0x44f00007,0x1048309c,0x7bdc309d,0x987c2b1a}},	//   _апіс, ояви_, _ogru, lçıq_, 
   {{0x7bdc031b,0x6d4c309e,0xc058309f,0x386c02ba}},	//   _ngru, vvaa, міс_, _jodr_, 
   {{0xf54805b6,0x37d00252,0xce6800f8,0x66d40192}},	//   _hụ_, _স্তৰ, орад_, _oškl, 
   {{0x7bdc30a0,0x6d4c30a1,0xf54801eb,0x00000000}},	//   _agru, tvaa, _kụ_, --, 
   {{0xf54801e5,0xe1c0016d,0x6d4c30a2,0x7afc0060}},	// [2d90] _jụ_, _бөрй, uvaa, _awrt, 
   {{0xf54830a3,0x6d4c30a4,0x3e7c03aa,0x80b4001e}},	//   _mụ_, rvaa, _víta_, _ибых, 
   {{0x3a240043,0x6d4c30a5,0x6e2c30a6,0x6aa80237}},	//   _bcmp_, svaa, pfab, _ĉefb, 
   {{0x3a241c1e,0x6d4c084f,0x1dbc0c5a,0x3e7c0223}},	//   _ccmp_, pvaa, ्धशत, _títa_, 
   {{0x801830a7,0xf54830a8,0x3a240308,0x00000000}},	//   _عزیز_, _nụ_, _dcmp_, --, 
   {{0x7bdc011a,0xb4b8072d,0x00000000,0x00000000}},	//   _ggru, चतो_, --, --, 
   {{0x7afc009c,0x7c3001b8,0x00000000,0x00000000}},	//   _gwrt, ékrő, --, --, 
   {{0xf54830a9,0x7bdc30aa,0x66c42492,0x229001f6}},	//   _bụ_, _zgru, kóke, vško_, 
   {{0xf5480765,0x39442188,0x987c02a0,0x00000000}},	//   _cụ_, _gsms_, açıq_, --, 
   {{0x291c30ab,0xf5480710,0x7b08019f,0x958030ac}},	//   muwa_, _dụ_, _ästä, улье, 
   {{0xa3c8098f,0x291c30ad,0xf6740828,0x66d430ae}},	//   लें_, luwa_, ṛtaṃ_, _uško, 
   {{0xbbdc13aa,0x229024b5,0xf548000d,0x613402b2}},	//   _बल्क, rško_, _fụ_, _nýlö, 
   {{0x291c30af,0xf54801e5,0x2a6c0337,0x787400cc}},	//   nuwa_, _gụ_, _moeb_, _sàvi, 
   {{0x2a6c0607,0xe4c40108,0x1c1c00b6,0xe6c001ac}},	//   _loeb_, _яйли, _पाइल_, _جڪڙي, 
   {{0x291c30b0,0x02c80155,0xf548000d,0x2bd00c5f}},	//   huwa_, _оқои_, _zụ_, थेमा, 
   {{0x291c1cbe,0x94000130,0x7bdc30b1,0x72940116}},	//   kuwa_, ɑkɑ_, _sgru, _ашьх, 
   {{0x291c30b2,0x7afc0335,0x3a240426,0x26cc01ca}},	// [2da0] juwa_, _swrt, _rcmp_, imeo_, 
   {{0x291c30b3,0x1ab800cb,0xcfb80143,0x00000000}},	//   duwa_, ेष्ठ, ঃখজন, --, 
   {{0xc1e40256,0xabc40ef1,0xefd4001d,0x501800cf}},	//   _ﺍﯞﺩﺍ, _ﺩﺍﻧﺎ, ጫቸው_, _צוטו, 
   {{0x291c30b4,0x394430b5,0x6aa80237,0x26cc01c6}},	//   fuwa_, _psms_, _ĉefc, jmeo_, 
   {{0x291c30b6,0x3ea030b7,0x386c04ac,0x1c1c00b3}},	//   guwa_, mnit_, _podr_, _पाऊल_, 
   {{0x7bdc01ec,0x3ea030b8,0xf54801d7,0x9f5800ef}},	//   _ugru, lnit_, _rụ_, _lepí_, 
   {{0x3ea030b9,0x291c0307,0x501800ca,0xf548000d}},	//   onit_, auwa_, לוסו, _sụ_, 
   {{0x291c30ba,0x3ea030bb,0xb4b800cb,0x26cc000f}},	//   buwa_, nnit_, चत्_, gmeo_, 
   {{0x3ea030bc,0x291c2a5f,0xd6200103,0x4914025c}},	//   init_, cuwa_, _фiна, _नियो_, 
   {{0xf54801c0,0xaee40828,0x3ea030bd,0x2450155a}},	//   _vụ_, nuṣy, hnit_, لچىس, 
   {{0x3ea030be,0x3e7c00d3,0x00000000,0x00000000}},	//   knit_, _níto_, --, --, 
   {{0xf5480014,0x958430bf,0x03c00200,0xd6280c3f}},	//   _tụ_, _плее, ысым, _ходе_, 
   {{0x3ea000bd,0x2ee00207,0x00000000,0x00000000}},	//   dnit_, _suhf_, --, --, 
   {{0x3ea030c0,0xb6240ce5,0xbacc024b,0x00000000}},	//   enit_, _ﯨﻦ_, _ﺑﺎﺑﺎ, --, 
   {{0xbfa830c1,0x291c30c2,0x787419ab,0x3ea000c2}},	//   етте_, zuwa_, _fàvv, fnit_, 
   {{0x3ea030c3,0x291c30ba,0x8d8400cc,0x03b800ca}},	//   gnit_, yuwa_, нузд, _מצול, 
   {{0xdb0c0214,0x2a6c0337,0x291c03fa,0x2dd40182}},	// [2db0] _rybá, _roeb_, xuwa_, тжар, 
   {{0x3ea030c4,0x00000000,0x00000000,0x00000000}},	//   anit_, --, --, --, 
   {{0x291c30c5,0x3ea00039,0x2a6c00af,0xefc40020}},	//   wuwa_, bnit_, _poeb_, _ጸግዒ_, 
   {{0x291c30c6,0x81ac0301,0x29d428d1,0x3ea030c7}},	//   tuwa_, কেও_, نياس, cnit_, 
   {{0xddc40387,0xdde80061,0x00000000,0x00000000}},	//   _inkş, _ترپه_, --, --, 
   {{0x291c30c8,0xe73830c9,0x1d140107,0x79a4001e}},	//   ruwa_, дек_, _בקשר_, ырхе, 
   {{0x291c30ca,0x8aa401f5,0x18640393,0xa6c800ea}},	//   suwa_, _зрад, тащи_, ووتل_, 
   {{0xd6cc30cb,0x291c30cc,0xf4c400c3,0x77a80012}},	//   يقو_, puwa_, ﺮﯨﺸﻜ, رێنہ_, 
   {{0x26cc30cd,0xe5700272,0x166002eb,0x99580031}},	//   rmeo_, شطة_, рвым, jäňe_, 
   {{0x290c03f2,0xf99030ce,0x3ea030cf,0x00000000}},	//   _ivea_, _طبق_, znit_, --, 
   {{0x3ea030d0,0x00000000,0x00000000,0x00000000}},	//   ynit_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ea000bd,0x3e7c01d5,0xa44400cc,0x00000000}},	//   vnit_, _síto_, _анлд, --, 
   {{0x3ea0006f,0x00000000,0x00000000,0x00000000}},	//   wnit_, --, --, --, 
   {{0xdee430d1,0x442400fb,0x3ea030d2,0x544000c3}},	//   тоби, _icn_, tnit_, _ئۆپك, 
   {{0x3ea030d3,0x4424006a,0x290c02eb,0xdef801c4}},	//   unit_, _hcn_, _ovea_, зыҡ_, 
   {{0xa0680340,0x4424001c,0x81ac0143,0x9c240bf5}},	// [2dc0] _жапа_, _kcn_, কেজ_, кдад, 
   {{0x3ea030d4,0x6aa80282,0x91740107,0x4c801cc7}},	//   snit_, _ĉefa, _סעיף_, алув, 
   {{0x290c30d5,0x7c4001df,0x1a280741,0x3ea030d6}},	//   _avea_, _čvrč, джеи_, pnit_, 
   {{0x442430d7,0x1c1c00b6,0x00000000,0x00000000}},	//   _lcn_, _पाकल_, --, --, 
   {{0x442430d8,0x58840937,0x98a401d1,0x00000000}},	//   _ocn_, кыка, stoč_, --, 
   {{0x68ec30d9,0xdca4001e,0xd85012fe,0x44240308}},	//   íada, _раги, рекө, _ncn_, 
   {{0xabc4016d,0x290c013c,0x00000000,0x00000000}},	//   _барҙ, _evea_, --, --, 
   {{0x442430da,0xddc40078,0x752401c6,0x00000000}},	//   _acn_, _lakō, _ĥizb, --, 
   {{0x442430db,0x948430dc,0x62840060,0xd4c430dd}},	//   _bcn_, вынд, dhko, ксоп, 
   {{0x73c4016d,0xddd400ef,0x12e4024b,0x741430de}},	//   ләйе, chyť, кімг, دودا, 
   {{0x8c1800b9,0x442430df,0x046030e0,0xd7040116}},	//   וויי, _dcn_, ртым, _рзеи, 
   {{0x439014a2,0x6284043b,0x00000000,0x00000000}},	//   раюс, ghko, --, --, 
   {{0x764004ba,0x442430e1,0xf43430e2,0xdb0c30e3}},	//   memy, _fcn_, _белэ, _hybä, 
   {{0x74140cc8,0x787419ab,0x1c1c1100,0x4424000d}},	//   _صوبا, _tàvu, _पागल_, _gcn_, 
   {{0x7f9401a7,0x66c401b8,0x00000000,0x00000000}},	//   аарх, lóka, --, --, 
   {{0x628430e4,0xc2541166,0x764030e5,0x00000000}},	//   chko, _вкъщ, nemy, --, 
   {{0x51841bc8,0xfd74038e,0x752030e6,0x705830e7}},	// [2dd0] _шука, алтэ, numz, _запр_, 
   {{0x764030e8,0x5dc40411,0xa3c83055,0x00000000}},	//   hemy, امكە, लेक_, --, 
   {{0x7640021c,0x75200123,0x290c01c5,0x00000000}},	//   kemy, humz, _svea_, --, 
   {{0x752008c2,0x228030e9,0xc33000ca,0xc0cc0020}},	//   kumz, _kóka_, יוע_, ኣዛር_, 
   {{0x764030ea,0xc984006e,0x8d841be0,0x12e40200}},	//   demy, خشاي, _рунд, _ﺍﻟﻴﻭ, 
   {{0xb4ac0357,0x6da40551,0x66d40007,0xa52402dc}},	//   कको_, _аиҭа, _iški, ҳмид, 
   {{0x442400dc,0xdd1002e6,0xe7380a2e,0xb4ac00bd}},	//   _rcn_, _küşt, хей_, ककै_, 
   {{0x442430eb,0x37740119,0x764030ec,0x00000000}},	//   _scn_, рышс, gemy, --, 
   {{0xdd1030ed,0x7520019b,0x290c0369,0x39b8009e}},	//   _müşt, gumz, _uvea_, _алтэ_, 
   {{0xddc400b0,0x54400411,0x22900c91,0x77902348}},	//   _jokš, مچىك, mški_, _ژیوا, 
   {{0x229000e9,0x764000b0,0xa3bc03bf,0x00000000}},	//   lški_, bemy, _आरओ_, --, 
   {{0xe2840155,0x66c40849,0x22800009,0xddc4163c}},	//   улми, bóka, _bóka_, _lokš, 
   {{0xddc400a2,0x229013c0,0x442430ee,0x660830ef}},	//   _pakō, nški_, _tcn_, maek, 
   {{0x628430f0,0x660830f1,0x0364004b,0x228000f2}},	//   shko, laek, _لٔتی_, _dóka_, 
   {{0xe29830f2,0xa3c82c10,0x6aa801c6,0x26dc30f3}},	//   _пак_, लेख_, _ĉefn, _kiwo_, 
   {{0x644030f4,0x660830f5,0x26dc30f6,0xdd9030f7}},	//   leli, naek, _jiwo_, موز_, 
   {{0x62940211,0xdd100333,0xddc429e4,0xa3b800b3}},	// [2de0] _imyo, _düşt, _bokš, _अँड_, 
   {{0x764030f8,0x212001c6,0x2c0000cc,0x00000000}},	//   zemy, mukh_, жүрм, --, 
   {{0x660830f9,0x6440038e,0x200830fa,0x9d44006b}},	//   kaek, ieli, mabi_, _өенд, 
   {{0x644030fb,0x200830fc,0x60dc0140,0x59840116}},	//   heli, labi_, _hipm, ллеб, 
   {{0x66080039,0x60dc30fd,0x00000000,0x00000000}},	//   daek, _kipm, --, --, 
   {{0x644030fe,0x200830ff,0x22400037,0x26dc006f}},	//   jeli, nabi_, hekk_, _aiwo_, 
   {{0x64400957,0xd6d83100,0x76403101,0x26dc065e}},	//   deli, нти_, temy, _biwo_, 
   {{0x20083102,0x26dc0e66,0xdca400b2,0x21200b10}},	//   habi_, _ciwo_, _раҳи, kukh_, 
   {{0xa50803dc,0x76400190,0x26dc3103,0xd49807dd}},	//   نىيە_, remy, _diwo_, ерн_, 
   {{0x64403104,0x75203105,0xc2140130,0x20083106}},	//   geli, rumz, _adɔ_, jabi_, 
   {{0x20083107,0x7520002a,0x2874044a,0x00000000}},	//   dabi_, sumz, _тытр, --, 
   {{0x8cc80774,0x752003a2,0x741410a0,0x55e41e7c}},	//   _तीनो, pumz, دوگا, _содб, 
   {{0x20080266,0xdd100314,0xc6b40100,0x00000000}},	//   fabi_, _rüşt, _גלאז_, --, 
   {{0x64403108,0x6294030b,0x95c000dd,0x2ef43109}},	//   celi, _emyo, _پيڙه, изгр, 
   {{0x447800b9,0x9f58008b,0x60dc0140,0x2240310a}},	//   _אנגע, _pepá_, _dipm, bekk_, 
   {{0x6aa80100,0x2280310b,0xadf4310c,0x00000000}},	//   _ĉefo, _tóka_, рпаш, --, 
   {{0xddc40023,0x6144039b,0xadd8150f,0x60d801e8}},	// [2df0] _pokš, _نىيە, тмау_, ňtma, 
   {{0x66f00296,0x2008028b,0x229007b5,0x00000000}},	//   _hāke, cabi_, vški_, --, 
   {{0x8bc40099,0x66d40023,0x66f000a8,0xad240108}},	//   усад, _iškv, _kāke, _ھىسى, 
   {{0xa3c81ffc,0xad241c0a,0x60dc0139,0x28f8310d}},	//   लेट_, _پىسى, _zipm, ведь_, 
   {{0x6440310e,0x66f0310f,0x66d401d1,0x66080116}},	//   yeli, _māke, _uški, vaek, 
   {{0x64403110,0x26dc029f,0x22901547,0x00000000}},	//   xeli, _siwo_, rški_, --, 
   {{0x26dc3111,0x66083112,0xdb640020,0x00000000}},	//   _piwo_, taek, _ሰሚዖም_, --, 
   {{0x64403113,0x7f3c0282,0x20083114,0x00000000}},	//   weli, געהו, zabi_, --, 
   {{0xe5a40476,0x66083115,0x26dc074a,0xc9843116}},	//   рипи, raek, _viwo_, _суви, 
   {{0x26dc3117,0x291c01e7,0x66083118,0x88800122}},	//   _wiwo_, mrwa_, saek, _دیتن, 
   {{0x6264057c,0x6aa80aa0,0x20083119,0x21200083}},	//   авна, _kjef, vabi_, wukh_, 
   {{0x2008311a,0x60dc311b,0xa5f8005b,0x291c0047}},	//   wabi_, _sipm, _реду_, orwa_, 
   {{0x273001c0,0x2008311c,0xa3c81cb5,0x2240311d}},	//   _hơn_, tabi_, लेज_, rekk_, 
   {{0x69c8042e,0x60dc0140,0x22402358,0x291c311e}},	//   _mzee, _qipm, sekk_, irwa_, 
   {{0x2008311f,0xfe78118a,0x1e943120,0x6aa80247}},	//   rabi_, гүн_, арар, _ojef, 
   {{0x20083121,0x291c07e1,0x629408c2,0x69c8007b}},	//   sabi_, krwa_, _umyo, _ozee, 
   {{0x69c802c6,0x61443122,0x60dc00ef,0x1d083123}},	// [2e00] _nzee, _тепа, _tipm, тези_, 
   {{0x291c14c5,0x6aa80088,0xc5d402fa,0x200803fa}},	//   drwa_, _ajef, _সভাপ, qabi_, 
   {{0x6aa82d05,0x9ea83124,0x291c3125,0xa3c800b3}},	//   _bjef, _авна_, erwa_, लेच_, 
   {{0x533400b9,0x228000d3,0xbe3400cc,0xcb6401c3}},	//   ינען_, _móko_, _دۉرب, јаце_, 
   {{0x18683126,0x3e7c014e,0x22800537,0x66c401b8}},	//   кади_, _níti_, _lóko_, tókn, 
   {{0x69c803bb,0x3e7c0306,0x00000000,0x00000000}},	//   _dzee, _síth_, --, --, 
   {{0x27300710,0xcb640241,0x3cec0021,0x69c83127}},	//   _cơn_, _каре_, _अंडे_, _ezee, 
   {{0x66c42210,0x99840299,0x3e7c02e8,0x273001eb}},	//   sókn, ngoū_, _bíti_, _dơn_, 
   {{0xf8b801b7,0x66f00296,0x661c0b7c,0x3e7c02cc}},	//   _йөк_, _rāke, óska, _cíti_, 
   {{0x7ae03128,0x22900023,0x66f0004f,0x00000000}},	//   _himt, išku_, _sāke, --, 
   {{0x66f00b60,0x7ae03129,0xa82409a8,0xdd2000a8}},	//   _pāke, _kimt, _اۋىل_, _dįũy, 
   {{0x22800229,0x7ae00560,0x69dc01d5,0xddc40201}},	//   _dóko_, _jimt, _úsec, _makł, 
   {{0x9484312a,0x7ae00039,0x229002aa,0x00000000}},	//   _выйд, _mimt, jšku_, --, 
   {{0x6aa8007c,0x7ae0312b,0x66f00299,0x78b801e3}},	//   _ĉefm, _limt, _wāke, novv, 
   {{0xceb806d4,0x66f00296,0xddc4002f,0x03a000b7}},	//   вља_, _tāke, _nakł, _миљо, 
   {{0x9e94312c,0x7ae0042e,0x00000000,0x00000000}},	//   ماقچ, _nimt, --, --, 
   {{0x291c017b,0x78b80085,0x00000000,0x00000000}},	// [2e10] xrwa_, kovv, --, --, 
   {{0x6aa81a0c,0xc1bc0107,0x3208006f,0x7bf800c3}},	//   _sjef, _במחש, _heay_, инур_, 
   {{0x39f401d7,0x7ae000b7,0x32080616,0x69c80932}},	//   _ịzọ_, _bimt, _keay_, _szee, 
   {{0x291c1ff9,0xba74312d,0x7ae008cf,0x9f580101}},	//   trwa_, يانت, _cimt, _depä_, 
   {{0x27300765,0x7ae0312e,0x291c0403,0x3208006f}},	//   _sơn_, _dimt, urwa_, _meay_, 
   {{0x6c8403e0,0x291c14f4,0x66e4312f,0x00000000}},	//   _السم, rrwa_, бока, --, 
   {{0x7ae03130,0x3e7c00bd,0xd7ec3131,0x80380100}},	//   _fimt, _síti_, ركي_, ינגע_, 
   {{0x7ae002b3,0x291c14c5,0x6aa80123,0x69c801ab}},	//   _gimt, prwa_, _ujef, _tzee, 
   {{0xddc406f7,0x69c801ac,0x78b8001e,0x22800229}},	//   _zakł, _uzee, bovv, _sóko_, 
   {{0xe5a43132,0x7ae03133,0x216800b2,0x6ab83134}},	//   _қили, _zimt, ҳими_, lowf, 
   {{0x7ae001f9,0x68e80513,0xe3b00272,0x58b8007c}},	//   _yimt, _hued, ثرة_, _עמעצ, 
   {{0x68e03135,0x68e83136,0x291801c5,0x09d80143}},	//   _hild, _kued, _åsas_, _ড্যা, 
   {{0x68e03137,0x6f040379,0x3cec0098,0xe5a401c3}},	//   _kild, _awhc, _अंधे_, _ћили, 
   {{0x68e03138,0x68e83139,0x44f802bf,0x2328313a}},	//   _jild, _mued, _iª_, _боки_, 
   {{0x68e809d7,0x1ea83010,0x3208006f,0x25a80031}},	//   _lued, هاري_, _feay_, _ĸaly_, 
   {{0x320800a0,0x00000000,0x00000000,0x00000000}},	//   _geay_, --, --, --, 
   {{0x6ab80177,0x68e8010b,0x7ae00007,0x9f580027}},	// [2e20] dowf, _nued, _rimt, _sepä_, 
   {{0x7ae0313b,0x22900091,0x44f8313c,0x225003c0}},	//   _simt, ršku_, _mª_, _hayk_, 
   {{0x22500105,0x7ae002a0,0xfbd80095,0xe7240061}},	//   _kayk_, _pimt, _भृशम, _تڵ_, 
   {{0x68e809d7,0x225004db,0x68e00336,0x7ae0313d}},	//   _bued, _jayk_, _aild, _qimt, 
   {{0x7ae001f9,0x2250313e,0x9f580207,0x00000000}},	//   _vimt, _mayk_, _depå_, --, 
   {{0x68e8313f,0x68e03140,0x00000000,0x00000000}},	//   _dued, _cild, --, --, 
   {{0x78b80668,0x44f801c6,0xb6f80108,0x00000000}},	//   rovv, _aª_, جىبا_, --, 
   {{0x68e80932,0x68e00c9c,0x225001e3,0x66c43141}},	//   _fued, _eild, _nayk_, bókm, 
   {{0x68e83142,0x09f40075,0xd5b81a6c,0x00000000}},	//   _gued, _طفلة_, ыск_, --, 
   {{0x68e0266b,0x44f804ac,0x73c401c4,0xb9e4001d}},	//   _gild, _dª_, ҙәһе, _ይሉ_, 
   {{0x29181d42,0x7c3c0475,0x22500387,0x06800012}},	//   _åsar_, _mbrr, _bayk_, زلیُ, 
   {{0x850001fa,0x68e03143,0x25a80070,0x6aa80100}},	//   _کوون, _zild, _žale_, _ĉefk, 
   {{0x68e00063,0x3208006f,0x938800c3,0x7f9400fc}},	//   _yild, _veay_, _әсла_, җатх, 
   {{0x68e0004b,0x66f004c4,0x00000000,0x00000000}},	//   _xild, _hāka, --, --, 
   {{0x66f03144,0xfd7405bc,0x66d40023,0x009400cc}},	//   _kāka, үлсэ, _iškr, чирэ, 
   {{0x82a40f0e,0x66f000e0,0x00000000,0x00000000}},	//   _најж, _jāka, --, --, 
   {{0x66f03145,0xdc34012b,0x44f802a0,0x00000000}},	// [2e30] _māka, _qäğb, _xª_, --, 
   {{0x68e83146,0x66f00062,0x6ad02d59,0x00000000}},	//   _rued, _lāka, तग्र, --, 
   {{0x68e83147,0x68e001a0,0xdb2401a0,0xa0340107}},	//   _sued, _rild, قولی, _ואתה_, 
   {{0x68e80ce4,0x66f011b0,0xdc34012b,0xfbd0129a}},	//   _pued, _nāka, _täğb, رتل_, 
   {{0x68e83148,0x68e03149,0xa968314a,0xe944314b}},	//   _qued, _pild, рила_, ترای, 
   {{0x68e00063,0x6d5c314c,0xf77001e0,0x00000000}},	//   _qild, _irsa, کاه_, --, 
   {{0x68e0314d,0x66f000e0,0x00000000,0x00000000}},	//   _vild, _bāka, --, --, 
   {{0xf4240b06,0x9ba0086b,0x68e0314e,0x68e8314f}},	//   _འཐུད_, _تەمى, _wild, _tued, 
   {{0x6aa801c6,0x00000000,0x00000000,0x00000000}},	//   _ĉefh, --, --, --, 
   {{0x68e00c2f,0x225002b1,0x6d5c27cf,0x67d43150}},	//   _uild, _sayk_, _mrsa, _дозу, 
   {{0xf868009d,0x4a24011a,0x00000000,0x00000000}},	//   _دملي_, _ལྐོལ_, --, --, 
   {{0x6d5c3151,0x66f0015b,0x00000000,0x00000000}},	//   _orsa, _gāka, --, --, 
   {{0xa5083152,0x3e7c020c,0x20543153,0x7a40030f}},	//   _тела_, _mítt_, отвр, _hátæ, 
   {{0x39403154,0x6e3c3155,0x225004db,0xb5c83156}},	//   çisi_, _absb, _wayk_, _اوهم_, 
   {{0x6d5c3157,0x78a401ca,0x00000000,0x00000000}},	//   _arsa, éivi, --, --, 
   {{0x6e3c015e,0x3e7c014e,0x00000000,0x00000000}},	//   _cbsb, _nítt_, --, --, 
   {{0x20743158,0x61f42f6b,0x6d5c0177,0x648c0272}},	// [2e40] _дунё, _ifyl, _crsa, _cúig, 
   {{0x6d5c07b5,0x3e7c01d4,0x648c01ca,0x00000000}},	//   _drsa, _rítu_, _dúig, --, 
   {{0x6d5c3159,0x9b44315a,0xf1a8049d,0x3e7c014e}},	//   _ersa, تناو, _نایه_, _bítt_, 
   {{0x6d5c0387,0x19c400b7,0x00000000,0x00000000}},	//   _frsa, обем, --, --, 
   {{0x3ea0315b,0x66f00b60,0x8c1c0664,0x9b68002c}},	//   miit_, _rāka, ন্ধন_, ышҡа_, 
   {{0x3ea0315c,0xc01c01b9,0x66f0315d,0x00000000}},	//   liit_, দ্ৰণ_, _sāka, --, 
   {{0x66f0315e,0x00000000,0x00000000,0x00000000}},	//   _pāka, --, --, --, 
   {{0xad2c01e2,0x3ea0315f,0x8c1c0019,0x648c059b}},	//   _ድርጅቶ, niit_, ন্দন_, _lúid, 
   {{0x94a80385,0x18a43160,0x66f03161,0x00000000}},	//   итоа_, _даам, _vāka, --, 
   {{0x3ea03162,0xe8b03163,0x7a400984,0x66f00296}},	//   hiit_, _كەنج, _fátæ, _wāka, 
   {{0x66f0004d,0x3ea03164,0xfd5400cb,0x00000000}},	//   _tāka, kiit_, rmeṣ, --, 
   {{0x3ea00139,0x00000000,0x00000000,0x00000000}},	//   jiit_, --, --, --, 
   {{0x3ea03165,0x41e40049,0x3b500020,0x64880094}},	//   diit_, діра, _ዘጋጠመ, рсөг_, 
   {{0x66d400ef,0x00000000,0x00000000,0x00000000}},	//   _uškr, --, --, --, 
   {{0xc05810aa,0x3ea00e92,0x2120010b,0xf3140937}},	//   ція_, fiit_, arkh_, _эдйэ, 
   {{0x3ea00a94,0x82f43166,0x6d5c01d5,0x3e6800cc}},	//   giit_, _بروز_, _prsa, ошун_, 
   {{0x620000df,0x98c8002f,0x00000000,0x00000000}},	// [2e50] şylý, िताए, --, --, 
   {{0x3e7c0545,0xcee83167,0x6d5c01df,0x8bc43168}},	//   _sítt_, _پردن_, _vrsa, осед, 
   {{0xa8000b07,0x3ea002bf,0x4a24011a,0x66c406b4}},	//   _íñig, biit_, _ལྐུལ_, bókh, 
   {{0x6d5c3169,0x3ea0316a,0xddd40031,0x00000000}},	//   _trsa, ciit_, kdyň, --, 
   {{0x6e2c316b,0x6d5c316c,0x6f14316d,0x3e7c03ed}},	//   mgab, _ursa, lszc, _vítt_, 
   {{0x6d4c0266,0x66e4087a,0xd3640324,0x6f140098}},	//   mwaa, пока, _كه_, oszc, 
   {{0x3e7c020c,0x6e2c007b,0x491400bd,0x00000000}},	//   _títt_, ogab, _निको_, --, 
   {{0x6e2c316e,0x6d4c316f,0x98f40121,0x657c0b1e}},	//   ngab, owaa, زغۇچ, øsho, 
   {{0x64a43170,0x6d4c3171,0x6e2c3172,0x7754010f}},	//   запа, nwaa, igab, መሰረተ, 
   {{0x6d4c3173,0x6e2c3174,0x3ea03175,0xe3b01049}},	//   iwaa, hgab, ziit_, فرج_, 
   {{0x6d4c3176,0x6e2c3177,0x3ea03178,0x77903179}},	//   hwaa, kgab, yiit_, _لیوا, 
   {{0x66f00341,0x3ea0175c,0x20180306,0x22800bbc}},	//   _hāko, xiit_, _sdpi_, _kóki_, 
   {{0x3ea00a94,0x66f01847,0x6f14002f,0x941c0125}},	//   viit_, _kāko, eszc, totɔ_, 
   {{0x6e2c317a,0x3ea0317b,0xd57402c3,0x66f000ce}},	//   egab, wiit_, _מתנה_, _jāko, 
   {{0x66f0317c,0x6e2c317d,0x3ea0317e,0x6d4c317f}},	//   _māko, fgab, tiit_, ewaa, 
   {{0x66f011f4,0x6d4c3180,0x6e2c3181,0x3ea0012a}},	//   _lāko, fwaa, ggab, uiit_, 
   {{0x3ea03182,0x6d4c3183,0x752401c6,0xed3401a7}},	// [2e60] riit_, gwaa, _ĥizk, дэхэ, 
   {{0x3ea03184,0x66f00025,0x6e2c3185,0x62843186}},	//   siit_, _nāko, agab, lkko, 
   {{0x6d4c2733,0x3ea03187,0x6e2c3188,0x907800ca}},	//   awaa, piit_, bgab, _הטיי, 
   {{0x62843189,0x66c40849,0x3ea0012a,0x6d4c030b}},	//   nkko, bóki, qiit_, bwaa, 
   {{0x0d200476,0x6284021c,0x69dc02e8,0x20300020}},	//   _пүтү, ikko, _úsel, _ይምስክ, 
   {{0x648c059b,0x6284013c,0x7b8401d2,0x00000000}},	//   _lúib, hkko, _قازە, --, 
   {{0x6aa800cf,0x50180100,0x63ac004f,0x00000000}},	//   _ĉefv, צוקו, _śann, --, 
   {{0x25a800e5,0x00000000,0x00000000,0x00000000}},	//   _žala_, --, --, --, 
   {{0x12e40200,0x349400e5,0x00000000,0x00000000}},	//   _ﺍﻟﻘﻭ, дапр, --, --, 
   {{0x6f14002f,0x6284318a,0x6e2c0054,0x0d9400ca}},	//   yszc, ekko, zgab, פכים_, 
   {{0x6d4c10a8,0x66f000e0,0x6e2c318b,0x00000000}},	//   zwaa, _jākl, ygab, --, 
   {{0x6d4c318c,0x66f000ce,0x2ca00055,0x00000000}},	//   ywaa, _mākl, zihd_, --, 
   {{0x6d4c028b,0x00000000,0x00000000,0x00000000}},	//   xwaa, --, --, --, 
   {{0x6284318d,0xe52029dd,0x39440475,0x6e2c028b}},	//   akko, _मिति_, _mpms_, wgab, 
   {{0x6e2c318e,0x6d4c0711,0x2eec01c6,0x2fc40085}},	//   tgab, wwaa, ĉefo_, ælg_, 
   {{0x6284318f,0x6d4c3190,0x6f1403ef,0x00000000}},	//   ckko, twaa, rszc, --, 
   {{0x6e2c3191,0x6d4c025e,0x50640023,0x00000000}},	// [2e70] rgab, uwaa, _етна, --, 
   {{0x6e2c3192,0x6d4c3193,0x3df405bc,0x228002e8}},	//   sgab, rwaa, _үзэс, _róki_, 
   {{0x6d4c29cc,0x7afc015e,0x648c01ca,0x3e7c00bd}},	//   swaa, _ctrt, _húic, _vítr_, 
   {{0x66f00025,0xfbd003e0,0x6d4c01ed,0x228003ef}},	//   _sāko, اتك_, pwaa, _póki_, 
   {{0x6d4c3194,0x66f00296,0x2d4c0070,0x28740087}},	//   qwaa, _pāko, _uže_, дыйр, 
   {{0x6aa8007c,0xc5f401a4,0x186401e3,0xe730129f}},	//   _ĉefu, ीर्य_, даши_, نصب_, 
   {{0xe7383195,0x648c01ca,0x66f0015b,0x00000000}},	//   цей_, _lúic, _vāko, --, 
   {{0x3694021c,0x228003e2,0x57f00108,0xba7400bf}},	//   ешьс, _tóki_, нпәт, _كاقت, 
   {{0x39440d92,0x09d802fa,0x648c0075,0x66f00341}},	//   _gpms_, _ড্রা, _núic, _tāko, 
   {{0x544000c3,0x00000000,0x00000000,0x00000000}},	//   نچىك, --, --, --, 
   {{0x478800fb,0x00000000,0x00000000,0x00000000}},	//   _усам_, --, --, --, 
   {{0x21a400c3,0x62843196,0x00000000,0x00000000}},	//   димм, ukko, --, --, 
   {{0x62840466,0xb0d8025c,0x00000000,0x00000000}},	//   rkko, णगंग, --, --, 
   {{0x62840310,0x648c0075,0x630402ac,0xc4d80294}},	//   skko, _dúic, _قوتل, _уђе_, 
   {{0x23d03197,0xdfd03198,0xd36c00e2,0x00000000}},	//   _हरिद, ئيز_, _نهو_, --, 
   {{0xddc4012c,0x1ea8238f,0x00000000,0x00000000}},	//   _zakř, زازي_, --, --, 
   {{0x7afc3199,0xb0f801a7,0xdc7400b8,0x00000000}},	// [2e80] _strt, _нээх_, мыжь, --, 
   {{0x0c2001ec,0x00000000,0x00000000,0x00000000}},	//   кмун, --, --, --, 
   {{0x9f18059b,0x00000000,0x00000000,0x00000000}},	//   _بآخر_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xda7004bb,0x6aa80100,0x66c4001e,0x7d2400d5}},	//   _یُس_, _ĉeft, nóku, _سہان, 
   {{0xd0540387,0xd05c0387,0x00000000,0x00000000}},	//   _bixə, _buqə, --, --, 
   {{0x8cb00098,0x00000000,0x00000000,0x00000000}},	//   _आदतो, --, --, --, 
   {{0xdb0c002f,0x46a000bf,0x66c40116,0x8b9800ca}},	//   _wybó, кшыб, kóku, _ובלת, 
   {{0xfbb002fa,0xd44800f8,0x66c4001e,0x4d780100}},	//   _করিত, оянд_, jóku, ַרטע, 
   {{0x3374319a,0x00000000,0x00000000,0x00000000}},	//   егор, --, --, --, 
   {{0xf4700422,0x00000000,0x00000000,0x00000000}},	//   _ብኻልእ_, --, --, --, 
   {{0xfbb00143,0x00000000,0x00000000,0x00000000}},	//   _করাত, --, --, --, 
   {{0xddc40192,0x00000000,0x00000000,0x00000000}},	//   _takř, --, --, --, 
   {{0xa0280126,0xef540116,0x00000000,0x00000000}},	//   _སྐྱང_, нкгь, --, --, 
   {{0x45080560,0xf778011a,0x04b400d5,0x04400ce1}},	//   _གསོར_, _tgħu_, _تھيں_, _рејн, 
   {{0x66c40cb6,0x648c0247,0x22b40296,0x8d84319b}},	//   bóku, _túic, tāke_, музд, 
   {{0xc0f4001d,0x8bc4041c,0x00000000,0x00000000}},	// [2e90] ግቧል_, ӄсад, --, --, 
   {{0x61f800bd,0x00000000,0x00000000,0x00000000}},	//   ětle, --, --, --, 
   {{0x248801e7,0x661c0007,0xa0280126,0x270c0227}},	//   _ɓam_, ųski, _སྐྲང_, _सबेर_, 
   {{0x69dc0212,0x2a680b66,0x6aa80100,0xd05c02a0}},	//   _úsek, ñab_, _ĉefs, _ruqə, 
   {{0x45081af2,0x6844319c,0x00000000,0x00000000}},	//   _གསེར_, енла, --, --, 
   {{0x225c0025,0xa7540668,0xa8180061,0x00000000}},	//   ētki_, етищ, ستتر_, --, 
   {{0x7c34319d,0x00000000,0x00000000,0x00000000}},	//   _шерх, --, --, --, 
   {{0xe618319e,0x9ba000e7,0xe5781310,0x00000000}},	//   чди_, _حەمى, ззи_, --, 
   {{0x7ae801b1,0x00000000,0x00000000,0x00000000}},	//   _èdta, --, --, --, 
   {{0xe1f81cd5,0x69c80080,0x66c4001e,0x00000000}},	//   ूर्ण_, _iyee, vóku, --, 
   {{0x69c80249,0xf1a800ca,0x00000000,0x00000000}},	//   _hyee, _פס_, --, --, 
   {{0x290c319f,0x69c831a0,0xddc4004f,0xe80c00b6}},	//   _kwea_, _kyee, _cakś, हरवा_, 
   