/* $Id: sinfo_wavecal_config.c,v 1.6 2012-03-03 10:35:14 amodigli Exp $
 *
 * This file is part of the CPL (Common Pipeline Library)
 * Copyright (C) 2002 European Southern Observatory
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * $Author: amodigli $
 * $Date: 2012-03-03 10:35:14 $
 * $Revision: 1.6 $
 * $Name: not supported by cvs2svn $
 */

/****************************************************************
 *   Wavecal Frames Data Reduction Parameter Initialization        *
 ****************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "sinfo_wavecal_config.h"
/**@{*/  
/**
 * @addtogroup sinfo_rec_wavecal wavecal recipe parameters definition \
      and initialization
 *
 * TBD
 */


void
sinfo_wavecal_config_add(cpl_parameterlist *list)
{

    cpl_parameter *p;

    if (!list) {
        return;
    }

    p = cpl_parameter_new_value("sinfoni.wavecal.slitpos_boostrap",
                    CPL_TYPE_BOOL,
                    "Switch to get a new slitpos without a reference: ",
                    "sinfoni.wavecal",
                    FALSE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-slitpos_bootstrap");
    cpl_parameterlist_append(list, p);

    /*
  p = cpl_parameter_new_value("sinfoni.wavecal.mflat_frm_switch",
                  CPL_TYPE_BOOL,
                              "Switch for master lampflat input: ",
                              "sinfoni.wavecal",
                              TRUE);


  cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-mflat_frm_switch");
  cpl_parameterlist_append(list, p);
     */


    /* Find Lines */
    /* indicates if the dispersion relation is already determined or not */
    p = cpl_parameter_new_value("sinfoni.wavecal.calib_indicator",
                    CPL_TYPE_BOOL,
                    "Calib Indicator: "
                    "FALSE: if the dispersion relation is already "
                    "known, the routine can jump to the sinfo_waveMap "
                    "section "
                    "TRUE: if the dispersion relation "
                    "must first be determined",
                    "sinfoni.wavecal",
                    TRUE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-calib_indicator");
    cpl_parameterlist_append(list, p);


    /* minimal difference of mean and sinfo_median column intensity */
    p = cpl_parameter_new_value("sinfoni.wavecal.min_diff",
                    CPL_TYPE_DOUBLE,
                    "Minimum Of Difference: "
                    "minimum difference of mean and sinfo_median column "
                    "intensity to carry out the cross sinfo_correlation",
                    "sinfoni.wavecal",
                    1.);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-min_diff");
    cpl_parameterlist_append(list, p);

    /* half width of a box within which the line must sit */
    p = cpl_parameter_new_value("sinfoni.wavecal.half_width",
                    CPL_TYPE_INT,
                    "Half Width: "
                    "half width of a box within which the line "
                    "must be placed",
                    "sinfoni.wavecal",
                    7);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-hw");
    cpl_parameterlist_append(list, p);

    /* sigma of Gaussian of artificial model spectra */
    p = cpl_parameter_new_value("sinfoni.wavecal.sigma",
                    CPL_TYPE_DOUBLE,
                    "Sigma: sigma of Gaussian which is convolved "
                    "with the artificial spectrum generated using "
                    "the line list",
                    "sinfoni.wavecal",
                    2.);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-sigma");
    cpl_parameterlist_append(list, p);

    /* Wavelength Calibration */
    /* guess value for fwhm of emission lines */
    p = cpl_parameter_new_value("sinfoni.wavecal.fwhm",
                    CPL_TYPE_DOUBLE,
                    "FWHM: initial guess value for the fwhm of "
                    "the Gaussian used for the line fit",
                    "sinfoni.wavecal",
                    2.83);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-fwhm");
    cpl_parameterlist_append(list, p);

    /* minimum amplitude of a line to be fitted */
    p = cpl_parameter_new_value("sinfoni.wavecal.min_amplitude",
                    CPL_TYPE_DOUBLE,
                    "Minimum Of Amplitude: "
                    "of the Gaussian to do the fit",
                    "sinfoni.wavecal",
                    5.);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-min_amplitude");
    cpl_parameterlist_append(list, p);

    /* maximal residual value for a valid fit */
    p = cpl_parameter_new_value("sinfoni.wavecal.max_residual",
                    CPL_TYPE_DOUBLE,
                    "Maximum Residuals value: "
                    "beyond this value the fit is rejected",
                    "sinfoni.wavecal",
                    0.5);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-max_residual");
    cpl_parameterlist_append(list, p);

    /* # of polynomial coefficients used for the dispersion relation */
    p = cpl_parameter_new_value("sinfoni.wavecal.n_a_coefficients",
                    CPL_TYPE_INT,
                    "Number of A coefficients: number of "
                    "polynomial coefficients for the "
                    "dispersion relation",
                    "sinfoni.wavecal",
                    4);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-n_a_coeffs");
    cpl_parameterlist_append(list, p);

    /* # of polynomial coefficients used for the fit of
    the dispersion coefficients */
    p = cpl_parameter_new_value("sinfoni.wavecal.n_b_coefficients",
                    CPL_TYPE_INT,
                    "Number of B coefficients: "
                    "number of polynomial coefficients for the "
                    "polynomial fit of the dispersion coefficients",
                    "sinfoni.wavecal",
                    2);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-n_b_coeffs");
    cpl_parameterlist_append(list, p);

    /* minimal factor of the standard deviation of the fit coefficients */
    p = cpl_parameter_new_value("sinfoni.wavecal.sigma_factor",
                    CPL_TYPE_DOUBLE,
                    "Sigma Factor: "
                    "Factor of the standard deviation of the "
                    "polynomial coefficients of the dispersion "
                    "relation beyond which the coefficients are "
                    "not used for the fit",
                    "sinfoni.wavecal",
                    1.5);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-sigma_factor");
    cpl_parameterlist_append(list, p);

    /* indicates if the parameterized dispersion relation coefficients
       should be written into an ASCII file */
    p = cpl_parameter_new_value("sinfoni.wavecal.write_coeffs_ind",
                    CPL_TYPE_BOOL,
                    "Write Coefficients Index: "
                    "indicates if the coefficients should "
                    "be written into a file or not",
                    "sinfoni.wavecal",
                    TRUE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-wcoeff_ind");
    cpl_parameterlist_append(list, p);

    /* indicates if the fit parameters should be written into an ASCII file */
    p = cpl_parameter_new_value("sinfoni.wavecal.write_par_ind",
                    CPL_TYPE_BOOL,
                    "Write Parameter Index: "
                    "indicates if the fit parameters should "
                    "be written into a file or not ",
                    "sinfoni.wavecal",
                    TRUE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-par_ind");
    cpl_parameterlist_append(list, p);









    /* dispersion relation */



    /* minimal distance of the slitlets in spectral direction */
    p = cpl_parameter_new_value("sinfoni.wavecal.pixel_dist",
                    CPL_TYPE_INT,
                    "Minimal Slitlets's Distance in spectral direction",
                    "sinfoni.wavecal",
                    15);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-pixel_dist");
    cpl_parameterlist_append(list, p);



    /* allowed pixel position tolerance between estimated and fitted line
     position
     */

    p = cpl_parameter_new_value("sinfoni.wavecal.pixel_tol",
                    CPL_TYPE_DOUBLE,
                    "Pixel Tolerance: allowed pixel position "
                    "tolerance between estimated and fitted "
                    "line position",
                    "sinfoni.wavecal",
                    5.0);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-pixel_tol");
    cpl_parameterlist_append(list, p);

    /* Wavelength Map */
    /* indicator if wavelength map should be generated or not */
    p = cpl_parameter_new_value("sinfoni.wavecal.wave_map_ind",
                    CPL_TYPE_BOOL,
                    "Wavelength Map Indicator: "
                    "indicates if the wavelength calibration map "
                    "should be generated (TRUE) or not (FALSE)",
                    "sinfoni.wavecal",
                    FALSE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-wave_map_ind");
    cpl_parameterlist_append(list, p);

    /* magnifying factor for FFT */
    p = cpl_parameter_new_value("sinfoni.wavecal.mag_factor",
                    CPL_TYPE_INT,
                    "Magnificator Factor: "
                    "magnifying factor for the number of pixels "
                    "in the columns needed for FFT",
                    "sinfoni.wavecal",
                    8);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-mag_factor");
    cpl_parameterlist_append(list, p);

    /* Fits Slits */
    /* indicator if the fit of the slit edge positions is carried through or not */
    p = cpl_parameter_new_value("sinfoni.wavecal.slit_pos_indicator",
                    CPL_TYPE_BOOL,
                    "Slit Position Indicator: "
                    "indicates if the fits of the slitlet "
                    "edge positions should be carried "
                    "through or not",
                    "sinfoni.wavecal",
                    TRUE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-slit_pos_ind");
    cpl_parameterlist_append(list, p);

    /* indicator if the fit model function is a Boltzmann function or not */
    p = cpl_parameter_new_value("sinfoni.wavecal.fit_boltz_indicator",
                    CPL_TYPE_BOOL ,
                    "Fit Boltzmann Indicator: "
                    "indicates if the fits of the slitlet edge "
                    "positions is carried trough by using a "
                    "Boltzmann function as model function",
                    "sinfoni.wavecal",
                    TRUE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-fit_boltz_ind");
    cpl_parameterlist_append(list, p);

    /* indicator if the fit model function
   is a simple edge function or not */
    p = cpl_parameter_new_value("sinfoni.wavecal.fit_edge_indicator",
                    CPL_TYPE_BOOL,
                    "Fit Edge Indicator: "
                    "indicates if the fits of the slitlet edge "
                    "positions is carried through by using a "
                    "simple edge function as model function",
                    "sinfoni.wavecal",
                    FALSE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-fit_edge_ind");
    cpl_parameterlist_append(list, p);

    /* indicator if the fit guess position are
    user given or calculated automatically */

    p = cpl_parameter_new_value("sinfoni.wavecal.estimate_indicator",
                    CPL_TYPE_BOOL,
                    "Estimate Indicator: "
                    "indicates if the fits of the slitlet edge "
                    "positions is carried through by using a list "
                    "of estimated guess positions in a file (TRUE)"
                    "or if the initial positions are calculated "
                    "automatically (FALSE). The estimation case "
                    "is more stable",
                    "sinfoni.wavecal",
                    FALSE);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-estimate_ind");
    cpl_parameterlist_append(list, p);

    /* pixel length of the row box within which the fit of the
   slitlet positions is carried out*/

    p = cpl_parameter_new_value("sinfoni.wavecal.box_length",
                    CPL_TYPE_INT,
                    "Box Length: "
                    "pixel length of the row box within "
                    "which the fit is carried out",
                    "sinfoni.wavecal",
                    32);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-box_len");
    cpl_parameterlist_append(list, p);

    /* float box half width in spectral direction */
    p = cpl_parameter_new_value("sinfoni.wavecal.y_box",
                    CPL_TYPE_DOUBLE,
                    "Y Box: half width of a small box in "
                    "spectral direction within which the "
                    "maximal intensity pixel is searched",
                    "sinfoni.wavecal",
                    5.);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-y_box");
    cpl_parameterlist_append(list, p);


    /* maximal tolerable difference to the expected slitlet positions */
    p = cpl_parameter_new_value("sinfoni.wavecal.diff_tol",
                    CPL_TYPE_DOUBLE,
                    "Difference Tolearance: "
                    "maximal tolerable difference of the "
                    "resulting fit positions of the slitlet "
                    "edges with respect to the expected positions",
                    "sinfoni.wavecal",
                    2.);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-diff_toll");
    cpl_parameterlist_append(list, p);



    p = cpl_parameter_new_value("sinfoni.wavecal.qc_thresh_min",
                    CPL_TYPE_INT,
                    "qc_thresh_min",
                    "sinfoni.wavecal",
                    0);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-qc_thresh_min");
    cpl_parameterlist_append(list, p);


    p = cpl_parameter_new_value("sinfoni.wavecal.qc_thresh_max",
                    CPL_TYPE_INT,
                    "qc_thresh_max",
                    "sinfoni.wavecal",
                    49000);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-qc_thresh_max");
    cpl_parameterlist_append(list, p);


    /*Resampling */
    /* number of coefficients for the polynomial interpolation */
    p = cpl_parameter_new_value("sinfoni.wavecal.n_coeffs",
                    CPL_TYPE_INT,
                    "number of coefficients for the polynomial "
                    "interpolation ",
                    "sinfoni.wavecal",
                    3);

    cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI,"wcal-no_coeffs");
    cpl_parameterlist_append(list, p);



}
/**@}*/
