/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#include <QMenu>
#include <QSettings>
#include <QWebHistory>
#include <QContextMenuEvent>
#include <QWebHitTestResult>

#include "dview.h"
#include "dwebpage.h"

dview::dview(QWidget *parent):QWebView(parent),
			      clear_history_after_next_load_(false)
{
  dwebpage *page(new dwebpage(this));
  QWebView::setPage(page);
  pageLoaded = false;
  percentLoaded = 0;
  selectedUrl = "";
  selectedImageUrl = "";
  QWebView::page()->setLinkDelegationPolicy(QWebPage::DelegateAllLinks);
  connect(this, SIGNAL(loadFinished(bool)), this,
	  SLOT(slotLoadFinished(bool)));
  connect(this, SIGNAL(loadStarted(void)), this,
	  SLOT(slotLoadStarted(void)));
  connect(this, SIGNAL(loadProgress(int)), this,
	  SLOT(slotLoadProgress(int)));
}

dview::~dview()
{
}

void dview::slotLoadFinished(bool ok)
{
  Q_UNUSED(ok);
  pageLoaded = true;
  unsetCursor();

  if(clear_history_after_next_load_)
    history()->clear();
}

void dview::slotLoadStarted(void)
{
  pageLoaded = false;
  setCursor(Qt::BusyCursor);
}

void dview::slotLoadProgress(int progress)
{
  percentLoaded = progress;
}

int dview::progress(void)
{
  return percentLoaded;
}

bool dview::isLoaded(void)
{
  return pageLoaded;
}

void dview::contextMenuEvent(QContextMenuEvent *event)
{
  QMenu menu(this);
  QWebHitTestResult result = page()->currentFrame()->
    hitTestContent(event->pos());

  if(!result.linkUrl().isEmpty())
    {
      selectedUrl = result.linkUrl();
      menu.addAction(tr("Copy &Link Location"),
		     this, SLOT(slotCopyLinkLocation(void)));
      menu.addAction(tr("Copy &Selected Text"),
		     this, SLOT(slotCopySelectedText(void)));
      menu.addSeparator();
      menu.addAction(tr("Open Link in New &Tab"),
		     this, SLOT(slotOpenLinkInNewTab(void)));
      menu.addAction(tr("Open Link in &New Window"),
		     this, SLOT(slotOpenLinkInNewWindow(void)));
      menu.addSeparator();
      menu.addAction(tr("&Save Link"),
		     this, SLOT(slotSaveLink(void)));
    }

  if(!result.imageUrl().isEmpty())
    {
      selectedImageUrl = result.imageUrl();

      if(!result.linkUrl().isEmpty())
	menu.addSeparator();

      menu.addAction(tr("Copy &Image Location"),
		     this, SLOT(slotCopyImageLocation(void)));
      menu.addSeparator();
      menu.addAction(tr("Sa&ve Image"),
		     this, SLOT(slotSaveImage(void)));
      menu.addSeparator();
      menu.addAction(tr("View I&mage"),
		     this, SLOT(slotViewImage(void)));
      menu.addAction(tr("View Im&age in New Tab"),
		     this, SLOT(slotOpenImageInNewTab(void)));
      menu.addAction(tr("View Ima&ge in New Window"),
		     this, SLOT(slotOpenImageInNewWindow(void)));
    }

  if(!menu.isEmpty())
    {
      menu.exec(mapToGlobal(event->pos()));
      return;
    }

  QWebView::contextMenuEvent(event);
}

void dview::slotViewImage(void)
{
  emit viewImageSignal(selectedImageUrl);
}

void dview::slotOpenLinkInNewTab(void)
{
  emit openLinkInNewTabSignal(selectedUrl);
}

void dview::slotOpenLinkInNewWindow(void)
{
  emit openLinkInNewWindowSignal(selectedUrl);
}

void dview::slotOpenImageInNewTab(void)
{
  emit openLinkInNewTabSignal(selectedImageUrl);
}

void dview::slotOpenImageInNewWindow(void)
{
  emit openLinkInNewWindowSignal(selectedImageUrl);
}

void dview::slotCopyLinkLocation(void)
{
  emit copyLinkSignal(selectedUrl);
}

void dview::slotCopyImageLocation(void)
{
  emit copyLinkSignal(selectedImageUrl);
}

void dview::slotSaveLink(void)
{
  emit saveUrlSignal(selectedUrl);
}

void dview::slotSaveImage(void)
{
  emit saveUrlSignal(selectedImageUrl);
}

void dview::clearHistoryAfterNextLoad()
{
  clear_history_after_next_load_ = true;
}

void dview::slotClearHistory(void)
{
  history()->clear();
}

QIcon dview::icon(void)
{
  if(QWebView::icon().isNull())
    {
      QSettings settings;
      QSettings cfgSettings
	(settings.value("iconSet").toString(), QSettings::IniFormat);

      return QIcon(cfgSettings.value("mainWindow/emptyIcon").toString());
    }
  else
    return QWebView::icon();
}

void dview::slotCopySelectedText(void)
{
  triggerPageAction(QWebPage::Copy);
}
