﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Threading.Tasks;
using Microsoft.CodeAnalysis.CSharp.Structure;
using Microsoft.CodeAnalysis.CSharp.Syntax;
using Microsoft.CodeAnalysis.Structure;
using Microsoft.CodeAnalysis.Test.Utilities;
using Xunit;

namespace Microsoft.CodeAnalysis.Editor.CSharp.UnitTests.Structure;

public sealed class DelegateDeclarationStructureTests : AbstractCSharpSyntaxNodeStructureTests<DelegateDeclarationSyntax>
{
    internal override AbstractSyntaxStructureProvider CreateProvider() => new DelegateDeclarationStructureProvider();

    [Fact, Trait(Traits.Feature, Traits.Features.Outlining)]
    public Task TestDelegateWithComments()
        => VerifyBlockSpansAsync("""
                {|span:// Goo
                // Bar|}
                $$public delegate void C();
                """,
            Region("span", "// Goo ...", autoCollapse: true));
}
