#!/bin/sh -e

GIT_DIR=emscripten

git clone git://github.com/kripken/emscripten.git $GIT_DIR
cd $GIT_DIR
MAJOR=$(grep "^EMSCRIPTEN_VERSION" tools/shared.py|cut -d\' -f2)
VERSION="$MAJOR~$(date +"%Y%m%d")~$(git log --abbrev-commit --no-color --pretty=oneline -1|awk '{print $1}')"
rm -fr third_party/closure-compiler/compiler.jar patches

# ship sources from web-socket-js
cd third_party/websockify/include/web-socket-js/
git clone https://github.com/gimite/web-socket-js.git src
rm -rf src/.git/
cd -

cd ../

tar --exclude-vcs -c -j -f ../emscripten_$VERSION.orig.tar.bz2 $GIT_DIR
rm -rf $GIT_DIR

