(**************************************************************************)
(*                                                                        *)
(*  This file is part of WP plug-in of Frama-C.                           *)
(*                                                                        *)
(*  Copyright (C) 2007-2022                                               *)
(*    CEA (Commissariat a l'energie atomique et aux energies              *)
(*         alternatives)                                                  *)
(*                                                                        *)
(*  you can redistribute it and/or modify it under the terms of the GNU   *)
(*  Lesser General Public License as published by the Free Software       *)
(*  Foundation, version 2.1.                                              *)
(*                                                                        *)
(*  It is distributed in the hope that it will be useful,                 *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU Lesser General Public License for more details.                   *)
(*                                                                        *)
(*  See the GNU Lesser General Public License version 2.1                 *)
(*  for more details (enclosed in the file licenses/LGPLv2.1).            *)
(*                                                                        *)
(**************************************************************************)

open Lang.F

(** Passive Forms *)

type t

val empty : t
val is_empty : t -> bool
val union : t -> t -> t
val bind : fresh:var -> bound:var -> t -> t
val join : var -> var -> t -> t
val conditions : t -> (var -> bool) -> pred list
val apply : t -> pred -> pred

type binding =
  | Bind of var * var (* fresh , bound *)
  | Join of var * var (* left, right *)

val iter : (binding -> unit) -> t -> unit
val pretty : Format.formatter -> t -> unit
