import QtQuick 2.0
import Ubuntu.Components 0.1

// Shows sender and time of a status update
// Should only be used by StatusUpdateContent
Item {
    anchors {
        left: parent.left
        right: parent.right
        rightMargin: units.gu(1)
    }

    height: units.gu(1)

    Label {
        id: senderLabel
        text: sender
        fontSize: "medium"
        font.bold: true

        anchors {
            left: parent.left
            verticalCenter: parent.verticalCenter
        }
        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
    }

    Label {
        id: nicknameLabel
        text: visible ? "@" + senderNick : ""
        fontSize: "small"
        font.bold: false

        anchors {
            left: senderLabel.right
            right: time.left
            verticalCenter: parent.verticalCenter
            leftMargin: units.gu(1)
            rightMargin: units.gu(2)
        }

        visible: metaInfo.isMicroblogging && parent.width

        wrapMode: Text.NoWrap
        elide: Text.ElideRight
    }

    Label {
        id: time
        anchors {
            right: parent.right
            verticalCenter: parent.verticalCenter
        }

        text: timeString
        fontSize: "small"
        color: Theme.palette.normal.baseText
    }
}
