// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package servicecatalog_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/servicecatalog"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleServiceCatalog_DescribeProduct() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.DescribeProductInput{
		Id:             aws.String("Id"), // Required
		AcceptLanguage: aws.String("AcceptLanguage"),
	}
	resp, err := svc.DescribeProduct(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_DescribeProductView() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.DescribeProductViewInput{
		Id:             aws.String("Id"), // Required
		AcceptLanguage: aws.String("AcceptLanguage"),
	}
	resp, err := svc.DescribeProductView(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_DescribeProvisioningParameters() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.DescribeProvisioningParametersInput{
		ProductId:              aws.String("Id"), // Required
		ProvisioningArtifactId: aws.String("Id"), // Required
		AcceptLanguage:         aws.String("AcceptLanguage"),
		PathId:                 aws.String("Id"),
	}
	resp, err := svc.DescribeProvisioningParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_DescribeRecord() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.DescribeRecordInput{
		Id:             aws.String("Id"), // Required
		AcceptLanguage: aws.String("AcceptLanguage"),
		PageSize:       aws.Int64(1),
		PageToken:      aws.String("PageToken"),
	}
	resp, err := svc.DescribeRecord(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_ListLaunchPaths() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.ListLaunchPathsInput{
		ProductId:      aws.String("Id"), // Required
		AcceptLanguage: aws.String("AcceptLanguage"),
		PageSize:       aws.Int64(1),
		PageToken:      aws.String("PageToken"),
	}
	resp, err := svc.ListLaunchPaths(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_ListRecordHistory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.ListRecordHistoryInput{
		AcceptLanguage: aws.String("AcceptLanguage"),
		AccessLevelFilter: &servicecatalog.AccessLevelFilter{
			Key:   aws.String("AccessLevelFilterKey"),
			Value: aws.String("AccessLevelFilterValue"),
		},
		PageSize:  aws.Int64(1),
		PageToken: aws.String("PageToken"),
		SearchFilter: &servicecatalog.ListRecordHistorySearchFilter{
			Key:   aws.String("SearchFilterKey"),
			Value: aws.String("SearchFilterValue"),
		},
	}
	resp, err := svc.ListRecordHistory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_ProvisionProduct() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.ProvisionProductInput{
		ProductId:              aws.String("Id"),                     // Required
		ProvisionToken:         aws.String("IdempotencyToken"),       // Required
		ProvisionedProductName: aws.String("ProvisionedProductName"), // Required
		ProvisioningArtifactId: aws.String("Id"),                     // Required
		AcceptLanguage:         aws.String("AcceptLanguage"),
		NotificationArns: []*string{
			aws.String("NotificationArn"), // Required
			// More values...
		},
		PathId: aws.String("Id"),
		ProvisioningParameters: []*servicecatalog.ProvisioningParameter{
			{ // Required
				Key:   aws.String("ParameterKey"),
				Value: aws.String("ParameterValue"),
			},
			// More values...
		},
		Tags: []*servicecatalog.Tag{
			{ // Required
				Key:   aws.String("TagKey"),
				Value: aws.String("TagValue"),
			},
			// More values...
		},
	}
	resp, err := svc.ProvisionProduct(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_ScanProvisionedProducts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.ScanProvisionedProductsInput{
		AcceptLanguage: aws.String("AcceptLanguage"),
		AccessLevelFilter: &servicecatalog.AccessLevelFilter{
			Key:   aws.String("AccessLevelFilterKey"),
			Value: aws.String("AccessLevelFilterValue"),
		},
		PageSize:  aws.Int64(1),
		PageToken: aws.String("PageToken"),
	}
	resp, err := svc.ScanProvisionedProducts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_SearchProducts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.SearchProductsInput{
		AcceptLanguage: aws.String("AcceptLanguage"),
		Filters: map[string][]*string{
			"Key": { // Required
				aws.String("ProductViewFilterValue"), // Required
				// More values...
			},
			// More values...
		},
		PageSize:  aws.Int64(1),
		PageToken: aws.String("PageToken"),
		SortBy:    aws.String("ProductViewSortBy"),
		SortOrder: aws.String("SortOrder"),
	}
	resp, err := svc.SearchProducts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_TerminateProvisionedProduct() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.TerminateProvisionedProductInput{
		TerminateToken:         aws.String("IdempotencyToken"), // Required
		AcceptLanguage:         aws.String("AcceptLanguage"),
		IgnoreErrors:           aws.Bool(true),
		ProvisionedProductId:   aws.String("Id"),
		ProvisionedProductName: aws.String("ProvisionedProductNameOrArn"),
	}
	resp, err := svc.TerminateProvisionedProduct(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleServiceCatalog_UpdateProvisionedProduct() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := servicecatalog.New(sess)

	params := &servicecatalog.UpdateProvisionedProductInput{
		UpdateToken:            aws.String("IdempotencyToken"), // Required
		AcceptLanguage:         aws.String("AcceptLanguage"),
		PathId:                 aws.String("Id"),
		ProductId:              aws.String("Id"),
		ProvisionedProductId:   aws.String("Id"),
		ProvisionedProductName: aws.String("ProvisionedProductNameOrArn"),
		ProvisioningArtifactId: aws.String("Id"),
		ProvisioningParameters: []*servicecatalog.UpdateProvisioningParameter{
			{ // Required
				Key:              aws.String("ParameterKey"),
				UsePreviousValue: aws.Bool(true),
				Value:            aws.String("ParameterValue"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateProvisionedProduct(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
