// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package arczonalshift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelZonalShift = "CancelZonalShift"

// CancelZonalShiftRequest generates a "aws/request.Request" representing the
// client's request for the CancelZonalShift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelZonalShift for more information on using the CancelZonalShift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelZonalShiftRequest method.
//	req, resp := client.CancelZonalShiftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelZonalShift
func (c *ARCZonalShift) CancelZonalShiftRequest(input *CancelZonalShiftInput) (req *request.Request, output *CancelZonalShiftOutput) {
	op := &request.Operation{
		Name:       opCancelZonalShift,
		HTTPMethod: "DELETE",
		HTTPPath:   "/zonalshifts/{zonalShiftId}",
	}

	if input == nil {
		input = &CancelZonalShiftInput{}
	}

	output = &CancelZonalShiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelZonalShift API operation for AWS ARC - Zonal Shift.
//
// Cancel a zonal shift in Amazon Route 53 Application Recovery Controller.
// To cancel the zonal shift, specify the zonal shift ID.
//
// A zonal shift can be one that you've started for a resource in your Amazon
// Web Services account in an Amazon Web Services Region, or it can be a zonal
// shift started by a practice run with zonal autoshift.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation CancelZonalShift for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CancelZonalShift
func (c *ARCZonalShift) CancelZonalShift(input *CancelZonalShiftInput) (*CancelZonalShiftOutput, error) {
	req, out := c.CancelZonalShiftRequest(input)
	return out, req.Send()
}

// CancelZonalShiftWithContext is the same as CancelZonalShift with the addition of
// the ability to pass a context and additional request options.
//
// See CancelZonalShift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) CancelZonalShiftWithContext(ctx aws.Context, input *CancelZonalShiftInput, opts ...request.Option) (*CancelZonalShiftOutput, error) {
	req, out := c.CancelZonalShiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePracticeRunConfiguration = "CreatePracticeRunConfiguration"

// CreatePracticeRunConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreatePracticeRunConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePracticeRunConfiguration for more information on using the CreatePracticeRunConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePracticeRunConfigurationRequest method.
//	req, resp := client.CreatePracticeRunConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CreatePracticeRunConfiguration
func (c *ARCZonalShift) CreatePracticeRunConfigurationRequest(input *CreatePracticeRunConfigurationInput) (req *request.Request, output *CreatePracticeRunConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreatePracticeRunConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/configuration",
	}

	if input == nil {
		input = &CreatePracticeRunConfigurationInput{}
	}

	output = &CreatePracticeRunConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePracticeRunConfiguration API operation for AWS ARC - Zonal Shift.
//
// A practice run configuration for zonal autoshift is required when you enable
// zonal autoshift. A practice run configuration includes specifications for
// blocked dates and blocked time windows, and for Amazon CloudWatch alarms
// that you create to use with practice runs. The alarms that you specify are
// an outcome alarm, to monitor application health during practice runs and,
// optionally, a blocking alarm, to block practice runs from starting.
//
// For more information, see Considerations when you configure zonal autoshift
// (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation CreatePracticeRunConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/CreatePracticeRunConfiguration
func (c *ARCZonalShift) CreatePracticeRunConfiguration(input *CreatePracticeRunConfigurationInput) (*CreatePracticeRunConfigurationOutput, error) {
	req, out := c.CreatePracticeRunConfigurationRequest(input)
	return out, req.Send()
}

// CreatePracticeRunConfigurationWithContext is the same as CreatePracticeRunConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePracticeRunConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) CreatePracticeRunConfigurationWithContext(ctx aws.Context, input *CreatePracticeRunConfigurationInput, opts ...request.Option) (*CreatePracticeRunConfigurationOutput, error) {
	req, out := c.CreatePracticeRunConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePracticeRunConfiguration = "DeletePracticeRunConfiguration"

// DeletePracticeRunConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeletePracticeRunConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePracticeRunConfiguration for more information on using the DeletePracticeRunConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePracticeRunConfigurationRequest method.
//	req, resp := client.DeletePracticeRunConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/DeletePracticeRunConfiguration
func (c *ARCZonalShift) DeletePracticeRunConfigurationRequest(input *DeletePracticeRunConfigurationInput) (req *request.Request, output *DeletePracticeRunConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeletePracticeRunConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/configuration/{resourceIdentifier}",
	}

	if input == nil {
		input = &DeletePracticeRunConfigurationInput{}
	}

	output = &DeletePracticeRunConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePracticeRunConfiguration API operation for AWS ARC - Zonal Shift.
//
// Deletes the practice run configuration for a resource. Before you can delete
// a practice run configuration for a resource., you must disable zonal autoshift
// for the resource. Practice runs must be configured for zonal autoshift to
// be enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation DeletePracticeRunConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/DeletePracticeRunConfiguration
func (c *ARCZonalShift) DeletePracticeRunConfiguration(input *DeletePracticeRunConfigurationInput) (*DeletePracticeRunConfigurationOutput, error) {
	req, out := c.DeletePracticeRunConfigurationRequest(input)
	return out, req.Send()
}

// DeletePracticeRunConfigurationWithContext is the same as DeletePracticeRunConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePracticeRunConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) DeletePracticeRunConfigurationWithContext(ctx aws.Context, input *DeletePracticeRunConfigurationInput, opts ...request.Option) (*DeletePracticeRunConfigurationOutput, error) {
	req, out := c.DeletePracticeRunConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetManagedResource = "GetManagedResource"

// GetManagedResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetManagedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetManagedResource for more information on using the GetManagedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetManagedResourceRequest method.
//	req, resp := client.GetManagedResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetManagedResource
func (c *ARCZonalShift) GetManagedResourceRequest(input *GetManagedResourceInput) (req *request.Request, output *GetManagedResourceOutput) {
	op := &request.Operation{
		Name:       opGetManagedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/managedresources/{resourceIdentifier}",
	}

	if input == nil {
		input = &GetManagedResourceInput{}
	}

	output = &GetManagedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetManagedResource API operation for AWS ARC - Zonal Shift.
//
// Get information about a resource that's been registered for zonal shifts
// with Amazon Route 53 Application Recovery Controller in this Amazon Web Services
// Region. Resources that are registered for zonal shifts are managed resources
// in Route 53 ARC. You can start zonal shifts and configure zonal autoshift
// for managed resources.
//
// At this time, you can only start a zonal shift or configure zonal autoshift
// for Network Load Balancers and Application Load Balancers with cross-zone
// load balancing turned off.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation GetManagedResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/GetManagedResource
func (c *ARCZonalShift) GetManagedResource(input *GetManagedResourceInput) (*GetManagedResourceOutput, error) {
	req, out := c.GetManagedResourceRequest(input)
	return out, req.Send()
}

// GetManagedResourceWithContext is the same as GetManagedResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetManagedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) GetManagedResourceWithContext(ctx aws.Context, input *GetManagedResourceInput, opts ...request.Option) (*GetManagedResourceOutput, error) {
	req, out := c.GetManagedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAutoshifts = "ListAutoshifts"

// ListAutoshiftsRequest generates a "aws/request.Request" representing the
// client's request for the ListAutoshifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAutoshifts for more information on using the ListAutoshifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAutoshiftsRequest method.
//	req, resp := client.ListAutoshiftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListAutoshifts
func (c *ARCZonalShift) ListAutoshiftsRequest(input *ListAutoshiftsInput) (req *request.Request, output *ListAutoshiftsOutput) {
	op := &request.Operation{
		Name:       opListAutoshifts,
		HTTPMethod: "GET",
		HTTPPath:   "/autoshifts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAutoshiftsInput{}
	}

	output = &ListAutoshiftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAutoshifts API operation for AWS ARC - Zonal Shift.
//
// Returns the active autoshifts for a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation ListAutoshifts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListAutoshifts
func (c *ARCZonalShift) ListAutoshifts(input *ListAutoshiftsInput) (*ListAutoshiftsOutput, error) {
	req, out := c.ListAutoshiftsRequest(input)
	return out, req.Send()
}

// ListAutoshiftsWithContext is the same as ListAutoshifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAutoshifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListAutoshiftsWithContext(ctx aws.Context, input *ListAutoshiftsInput, opts ...request.Option) (*ListAutoshiftsOutput, error) {
	req, out := c.ListAutoshiftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAutoshiftsPages iterates over the pages of a ListAutoshifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAutoshifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAutoshifts operation.
//	pageNum := 0
//	err := client.ListAutoshiftsPages(params,
//	    func(page *arczonalshift.ListAutoshiftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ARCZonalShift) ListAutoshiftsPages(input *ListAutoshiftsInput, fn func(*ListAutoshiftsOutput, bool) bool) error {
	return c.ListAutoshiftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAutoshiftsPagesWithContext same as ListAutoshiftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListAutoshiftsPagesWithContext(ctx aws.Context, input *ListAutoshiftsInput, fn func(*ListAutoshiftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAutoshiftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAutoshiftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAutoshiftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListManagedResources = "ListManagedResources"

// ListManagedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedResources for more information on using the ListManagedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListManagedResourcesRequest method.
//	req, resp := client.ListManagedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources
func (c *ARCZonalShift) ListManagedResourcesRequest(input *ListManagedResourcesInput) (req *request.Request, output *ListManagedResourcesOutput) {
	op := &request.Operation{
		Name:       opListManagedResources,
		HTTPMethod: "GET",
		HTTPPath:   "/managedresources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedResourcesInput{}
	}

	output = &ListManagedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedResources API operation for AWS ARC - Zonal Shift.
//
// Lists all the resources in your Amazon Web Services account in this Amazon
// Web Services Region that are managed for zonal shifts in Amazon Route 53
// Application Recovery Controller, and information about them. The information
// includes the zonal autoshift status for the resource, as well as the Amazon
// Resource Name (ARN), the Availability Zones that each resource is deployed
// in, and the resource name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation ListManagedResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListManagedResources
func (c *ARCZonalShift) ListManagedResources(input *ListManagedResourcesInput) (*ListManagedResourcesOutput, error) {
	req, out := c.ListManagedResourcesRequest(input)
	return out, req.Send()
}

// ListManagedResourcesWithContext is the same as ListManagedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListManagedResourcesWithContext(ctx aws.Context, input *ListManagedResourcesInput, opts ...request.Option) (*ListManagedResourcesOutput, error) {
	req, out := c.ListManagedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListManagedResourcesPages iterates over the pages of a ListManagedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListManagedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListManagedResources operation.
//	pageNum := 0
//	err := client.ListManagedResourcesPages(params,
//	    func(page *arczonalshift.ListManagedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ARCZonalShift) ListManagedResourcesPages(input *ListManagedResourcesInput, fn func(*ListManagedResourcesOutput, bool) bool) error {
	return c.ListManagedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListManagedResourcesPagesWithContext same as ListManagedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListManagedResourcesPagesWithContext(ctx aws.Context, input *ListManagedResourcesInput, fn func(*ListManagedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListManagedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListManagedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListManagedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListZonalShifts = "ListZonalShifts"

// ListZonalShiftsRequest generates a "aws/request.Request" representing the
// client's request for the ListZonalShifts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListZonalShifts for more information on using the ListZonalShifts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListZonalShiftsRequest method.
//	req, resp := client.ListZonalShiftsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts
func (c *ARCZonalShift) ListZonalShiftsRequest(input *ListZonalShiftsInput) (req *request.Request, output *ListZonalShiftsOutput) {
	op := &request.Operation{
		Name:       opListZonalShifts,
		HTTPMethod: "GET",
		HTTPPath:   "/zonalshifts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListZonalShiftsInput{}
	}

	output = &ListZonalShiftsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListZonalShifts API operation for AWS ARC - Zonal Shift.
//
// Lists all active and completed zonal shifts in Amazon Route 53 Application
// Recovery Controller in your Amazon Web Services account in this Amazon Web
// Services Region. ListZonalShifts returns customer-started zonal shifts, as
// well as practice run zonal shifts that Route 53 ARC started on your behalf
// for zonal autoshift.
//
// The ListZonalShifts operation does not list autoshifts. For more information
// about listing autoshifts, see ">ListAutoshifts (https://docs.aws.amazon.com/arc-zonal-shift/latest/api/API_ListAutoshifts.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation ListZonalShifts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/ListZonalShifts
func (c *ARCZonalShift) ListZonalShifts(input *ListZonalShiftsInput) (*ListZonalShiftsOutput, error) {
	req, out := c.ListZonalShiftsRequest(input)
	return out, req.Send()
}

// ListZonalShiftsWithContext is the same as ListZonalShifts with the addition of
// the ability to pass a context and additional request options.
//
// See ListZonalShifts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListZonalShiftsWithContext(ctx aws.Context, input *ListZonalShiftsInput, opts ...request.Option) (*ListZonalShiftsOutput, error) {
	req, out := c.ListZonalShiftsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListZonalShiftsPages iterates over the pages of a ListZonalShifts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListZonalShifts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListZonalShifts operation.
//	pageNum := 0
//	err := client.ListZonalShiftsPages(params,
//	    func(page *arczonalshift.ListZonalShiftsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ARCZonalShift) ListZonalShiftsPages(input *ListZonalShiftsInput, fn func(*ListZonalShiftsOutput, bool) bool) error {
	return c.ListZonalShiftsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListZonalShiftsPagesWithContext same as ListZonalShiftsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) ListZonalShiftsPagesWithContext(ctx aws.Context, input *ListZonalShiftsInput, fn func(*ListZonalShiftsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListZonalShiftsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListZonalShiftsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListZonalShiftsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartZonalShift = "StartZonalShift"

// StartZonalShiftRequest generates a "aws/request.Request" representing the
// client's request for the StartZonalShift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartZonalShift for more information on using the StartZonalShift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartZonalShiftRequest method.
//	req, resp := client.StartZonalShiftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartZonalShift
func (c *ARCZonalShift) StartZonalShiftRequest(input *StartZonalShiftInput) (req *request.Request, output *StartZonalShiftOutput) {
	op := &request.Operation{
		Name:       opStartZonalShift,
		HTTPMethod: "POST",
		HTTPPath:   "/zonalshifts",
	}

	if input == nil {
		input = &StartZonalShiftInput{}
	}

	output = &StartZonalShiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartZonalShift API operation for AWS ARC - Zonal Shift.
//
// You start a zonal shift to temporarily move load balancer traffic away from
// an Availability Zone in an Amazon Web Services Region, to help your application
// recover immediately, for example, from a developer's bad code deployment
// or from an Amazon Web Services infrastructure failure in a single Availability
// Zone. You can start a zonal shift in Route 53 ARC only for managed resources
// in your Amazon Web Services account in an Amazon Web Services Region. Resources
// are automatically registered with Route 53 ARC by Amazon Web Services services.
//
// At this time, you can only start a zonal shift for Network Load Balancers
// and Application Load Balancers with cross-zone load balancing turned off.
//
// When you start a zonal shift, traffic for the resource is no longer routed
// to the Availability Zone. The zonal shift is created immediately in Route
// 53 ARC. However, it can take a short time, typically up to a few minutes,
// for existing, in-progress connections in the Availability Zone to complete.
//
// For more information, see Zonal shift (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation StartZonalShift for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/StartZonalShift
func (c *ARCZonalShift) StartZonalShift(input *StartZonalShiftInput) (*StartZonalShiftOutput, error) {
	req, out := c.StartZonalShiftRequest(input)
	return out, req.Send()
}

// StartZonalShiftWithContext is the same as StartZonalShift with the addition of
// the ability to pass a context and additional request options.
//
// See StartZonalShift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) StartZonalShiftWithContext(ctx aws.Context, input *StartZonalShiftInput, opts ...request.Option) (*StartZonalShiftOutput, error) {
	req, out := c.StartZonalShiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePracticeRunConfiguration = "UpdatePracticeRunConfiguration"

// UpdatePracticeRunConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePracticeRunConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePracticeRunConfiguration for more information on using the UpdatePracticeRunConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePracticeRunConfigurationRequest method.
//	req, resp := client.UpdatePracticeRunConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdatePracticeRunConfiguration
func (c *ARCZonalShift) UpdatePracticeRunConfigurationRequest(input *UpdatePracticeRunConfigurationInput) (req *request.Request, output *UpdatePracticeRunConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdatePracticeRunConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/configuration/{resourceIdentifier}",
	}

	if input == nil {
		input = &UpdatePracticeRunConfigurationInput{}
	}

	output = &UpdatePracticeRunConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePracticeRunConfiguration API operation for AWS ARC - Zonal Shift.
//
// Update a practice run configuration to change one or more of the following:
// add, change, or remove the blocking alarm; change the outcome alarm; or add,
// change, or remove blocking dates or time windows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation UpdatePracticeRunConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdatePracticeRunConfiguration
func (c *ARCZonalShift) UpdatePracticeRunConfiguration(input *UpdatePracticeRunConfigurationInput) (*UpdatePracticeRunConfigurationOutput, error) {
	req, out := c.UpdatePracticeRunConfigurationRequest(input)
	return out, req.Send()
}

// UpdatePracticeRunConfigurationWithContext is the same as UpdatePracticeRunConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePracticeRunConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) UpdatePracticeRunConfigurationWithContext(ctx aws.Context, input *UpdatePracticeRunConfigurationInput, opts ...request.Option) (*UpdatePracticeRunConfigurationOutput, error) {
	req, out := c.UpdatePracticeRunConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateZonalAutoshiftConfiguration = "UpdateZonalAutoshiftConfiguration"

// UpdateZonalAutoshiftConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateZonalAutoshiftConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateZonalAutoshiftConfiguration for more information on using the UpdateZonalAutoshiftConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateZonalAutoshiftConfigurationRequest method.
//	req, resp := client.UpdateZonalAutoshiftConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalAutoshiftConfiguration
func (c *ARCZonalShift) UpdateZonalAutoshiftConfigurationRequest(input *UpdateZonalAutoshiftConfigurationInput) (req *request.Request, output *UpdateZonalAutoshiftConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateZonalAutoshiftConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/managedresources/{resourceIdentifier}",
	}

	if input == nil {
		input = &UpdateZonalAutoshiftConfigurationInput{}
	}

	output = &UpdateZonalAutoshiftConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateZonalAutoshiftConfiguration API operation for AWS ARC - Zonal Shift.
//
// You can update the zonal autoshift status for a resource, to enable or disable
// zonal autoshift. When zonal autoshift is ENABLED, Amazon Web Services shifts
// away resource traffic from an Availability Zone, on your behalf, when Amazon
// Web Services determines that there's an issue in the Availability Zone that
// could potentially affect customers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation UpdateZonalAutoshiftConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalAutoshiftConfiguration
func (c *ARCZonalShift) UpdateZonalAutoshiftConfiguration(input *UpdateZonalAutoshiftConfigurationInput) (*UpdateZonalAutoshiftConfigurationOutput, error) {
	req, out := c.UpdateZonalAutoshiftConfigurationRequest(input)
	return out, req.Send()
}

// UpdateZonalAutoshiftConfigurationWithContext is the same as UpdateZonalAutoshiftConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateZonalAutoshiftConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) UpdateZonalAutoshiftConfigurationWithContext(ctx aws.Context, input *UpdateZonalAutoshiftConfigurationInput, opts ...request.Option) (*UpdateZonalAutoshiftConfigurationOutput, error) {
	req, out := c.UpdateZonalAutoshiftConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateZonalShift = "UpdateZonalShift"

// UpdateZonalShiftRequest generates a "aws/request.Request" representing the
// client's request for the UpdateZonalShift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateZonalShift for more information on using the UpdateZonalShift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateZonalShiftRequest method.
//	req, resp := client.UpdateZonalShiftRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalShift
func (c *ARCZonalShift) UpdateZonalShiftRequest(input *UpdateZonalShiftInput) (req *request.Request, output *UpdateZonalShiftOutput) {
	op := &request.Operation{
		Name:       opUpdateZonalShift,
		HTTPMethod: "PATCH",
		HTTPPath:   "/zonalshifts/{zonalShiftId}",
	}

	if input == nil {
		input = &UpdateZonalShiftInput{}
	}

	output = &UpdateZonalShiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateZonalShift API operation for AWS ARC - Zonal Shift.
//
// Update an active zonal shift in Amazon Route 53 Application Recovery Controller
// in your Amazon Web Services account. You can update a zonal shift to set
// a new expiration, or edit or replace the comment for the zonal shift.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS ARC - Zonal Shift's
// API operation UpdateZonalShift for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceNotFoundException
//     The input requested a resource that was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/arc-zonal-shift-2022-10-30/UpdateZonalShift
func (c *ARCZonalShift) UpdateZonalShift(input *UpdateZonalShiftInput) (*UpdateZonalShiftOutput, error) {
	req, out := c.UpdateZonalShiftRequest(input)
	return out, req.Send()
}

// UpdateZonalShiftWithContext is the same as UpdateZonalShift with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateZonalShift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARCZonalShift) UpdateZonalShiftWithContext(ctx aws.Context, input *UpdateZonalShiftInput, opts ...request.Option) (*UpdateZonalShiftOutput, error) {
	req, out := c.UpdateZonalShiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex structure that lists an autoshift that is currently active for
// a managed resource and information about the autoshift.
//
// For more information, see How zonal autoshift and practice runs work (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
type AutoshiftInResource struct {
	_ struct{} `type:"structure"`

	// The appliedStatus field specifies which application traffic shift is in effect
	// for a resource when there is more than one traffic shift active. There can
	// be more than one application traffic shift in progress at the same time -
	// that is, practice run zonal shifts, customer-started zonal shifts, or an
	// autoshift. The appliedStatus field for an autoshift for a resource can have
	// one of two values: APPLIED or NOT_APPLIED. The zonal shift or autoshift that
	// is currently in effect for the resource has an applied status set to APPLIED.
	//
	// The overall principle for precedence is that zonal shifts that you start
	// as a customer take precedence autoshifts, which take precedence over practice
	// runs. That is, customer-started zonal shifts > autoshifts > practice run
	// zonal shifts.
	//
	// For more information, see How zonal autoshift and practice runs work (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html)
	// in the Amazon Route 53 Application Recovery Controller Developer Guide.
	//
	// AppliedStatus is a required field
	AppliedStatus *string `locationName:"appliedStatus" type:"string" required:"true" enum:"AutoshiftAppliedStatus"`

	// The Availability Zone that traffic is shifted away from for a resource, when
	// Amazon Web Services starts an autoshift. Until the autoshift ends, traffic
	// for the resource is instead directed to other Availability Zones in the Amazon
	// Web Services Region. An autoshift can end for a resource, for example, when
	// Amazon Web Services ends the autoshift for the Availability Zone or when
	// you disable zonal autoshift for the resource.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// The time (UTC) when the autoshift started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoshiftInResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoshiftInResource) GoString() string {
	return s.String()
}

// SetAppliedStatus sets the AppliedStatus field's value.
func (s *AutoshiftInResource) SetAppliedStatus(v string) *AutoshiftInResource {
	s.AppliedStatus = &v
	return s
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *AutoshiftInResource) SetAwayFrom(v string) *AutoshiftInResource {
	s.AwayFrom = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AutoshiftInResource) SetStartTime(v time.Time) *AutoshiftInResource {
	s.StartTime = &v
	return s
}

// Information about an autoshift. Amazon Web Services starts an autoshift to
// temporarily move traffic for a resource away from an Availability Zone in
// an Amazon Web Services Region when Amazon Web Services determines that there's
// an issue in the Availability Zone that could potentially affect customers.
// You can configure zonal autoshift in Route 53 ARC for managed resources in
// your Amazon Web Services account in a Region. Supported Amazon Web Services
// resources are automatically registered with Route 53 ARC.
//
// Autoshifts are temporary. When the Availability Zone recovers, Amazon Web
// Services ends the autoshift, and traffic for the resource is no longer directed
// to the other Availability Zones in the Region.
//
// You can stop an autoshift for a resource by disabling zonal autoshift.
type AutoshiftSummary struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is shifted away from for a resource when
	// Amazon Web Services starts an autoshift. Until the autoshift ends, traffic
	// for the resource is instead directed to other Availability Zones in the Amazon
	// Web Services Region. An autoshift can end for a resource, for example, when
	// Amazon Web Services ends the autoshift for the Availability Zone or when
	// you disable zonal autoshift for the resource.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// The time (in UTC) when the autoshift ended.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The time (in UTC) when the autoshift started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The status for an autoshift.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AutoshiftExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoshiftSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoshiftSummary) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *AutoshiftSummary) SetAwayFrom(v string) *AutoshiftSummary {
	s.AwayFrom = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AutoshiftSummary) SetEndTime(v time.Time) *AutoshiftSummary {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AutoshiftSummary) SetStartTime(v time.Time) *AutoshiftSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoshiftSummary) SetStatus(v string) *AutoshiftSummary {
	s.Status = &v
	return s
}

type CancelZonalShiftInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The internally-generated identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `location:"uri" locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelZonalShiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelZonalShiftInput"}
	if s.ZonalShiftId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZonalShiftId"))
	}
	if s.ZonalShiftId != nil && len(*s.ZonalShiftId) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ZonalShiftId", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *CancelZonalShiftInput) SetZonalShiftId(v string) *CancelZonalShiftInput {
	s.ZonalShiftId = &v
	return s
}

type CancelZonalShiftOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the Amazon Web Services Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for a customer-started zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift.
	// You can initially set a zonal shift to expire in a maximum of three days
	// (72 hours). However, you can update a zonal shift to set a new expiration
	// at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift when you're ready to restore traffic to the Availability
	// Zone, or just wait for it to expire. Or you can update the zonal shift to
	// specify another length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to shift away traffic for. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift has been started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelZonalShiftOutput) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *CancelZonalShiftOutput) SetAwayFrom(v string) *CancelZonalShiftOutput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *CancelZonalShiftOutput) SetComment(v string) *CancelZonalShiftOutput {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *CancelZonalShiftOutput) SetExpiryTime(v time.Time) *CancelZonalShiftOutput {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CancelZonalShiftOutput) SetResourceIdentifier(v string) *CancelZonalShiftOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CancelZonalShiftOutput) SetStartTime(v time.Time) *CancelZonalShiftOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelZonalShiftOutput) SetStatus(v string) *CancelZonalShiftOutput {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *CancelZonalShiftOutput) SetZonalShiftId(v string) *CancelZonalShiftOutput {
	s.ZonalShiftId = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the conflict exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ConflictExceptionReason"`

	// The zonal shift ID associated with the conflict exception.
	ZonalShiftId *string `locationName:"zonalShiftId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A control condition is an alarm that you specify for a practice run. When
// you configure practice runs with zonal autoshift for a resource, you specify
// Amazon CloudWatch alarms, which you create in CloudWatch to use with the
// practice run. The alarms that you specify are an outcome alarm, to monitor
// application health during practice runs and, optionally, a blocking alarm,
// to block practice runs from starting.
//
// Control condition alarms do not apply for autoshifts.
//
// For more information, see Considerations when you configure zonal autoshift
// (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
type ControlCondition struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Amazon CloudWatch alarm that you specify
	// as a control condition for a practice run.
	//
	// AlarmIdentifier is a required field
	AlarmIdentifier *string `locationName:"alarmIdentifier" min:"8" type:"string" required:"true"`

	// The type of alarm specified for a practice run. The only valid value is CLOUDWATCH.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ControlConditionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ControlCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ControlCondition"}
	if s.AlarmIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmIdentifier"))
	}
	if s.AlarmIdentifier != nil && len(*s.AlarmIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmIdentifier", 8))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmIdentifier sets the AlarmIdentifier field's value.
func (s *ControlCondition) SetAlarmIdentifier(v string) *ControlCondition {
	s.AlarmIdentifier = &v
	return s
}

// SetType sets the Type field's value.
func (s *ControlCondition) SetType(v string) *ControlCondition {
	s.Type = &v
	return s
}

type CreatePracticeRunConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Optionally, you can block Route 53 ARC from starting practice runs for a
	// resource on specific calendar dates.
	//
	// The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify
	// dates, that dates and times for practice runs are in UTC. Separate multiple
	// blocked dates with spaces.
	//
	// For example, if you have an application update scheduled to launch on May
	// 1, 2024, and you don't want practice runs to shift traffic away at that time,
	// you could set a blocked date for 2024-05-01.
	BlockedDates []*string `locationName:"blockedDates" type:"list"`

	// Optionally, you can block Route 53 ARC from starting practice runs for specific
	// windows of days and times.
	//
	// The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when
	// you specify dates, that dates and times for practice runs are in UTC. Also,
	// be aware of potential time adjustments that might be required for daylight
	// saving time differences. Separate multiple blocked windows with spaces.
	//
	// For example, say you run business report summaries three days a week. For
	// this scenario, you might set the following recurring days and times as blocked
	// windows, for example: MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30.
	BlockedWindows []*string `locationName:"blockedWindows" type:"list"`

	// An Amazon CloudWatch alarm that you can specify for zonal autoshift practice
	// runs. This alarm blocks Route 53 ARC from starting practice run zonal shifts,
	// and ends a practice run that's in progress, when the alarm is in an ALARM
	// state.
	BlockingAlarms []*ControlCondition `locationName:"blockingAlarms" min:"1" type:"list"`

	// The outcome alarm for practice runs is a required Amazon CloudWatch alarm
	// that you specify that ends a practice run when the alarm is in an ALARM state.
	//
	// Configure the alarm to monitor the health of your application when traffic
	// is shifted away from an Availability Zone during each weekly practice run.
	// You should configure the alarm to go into an ALARM state if your application
	// is impacted by the zonal shift, and you want to stop the zonal shift, to
	// let traffic for the resource return to the Availability Zone.
	//
	// OutcomeAlarms is a required field
	OutcomeAlarms []*ControlCondition `locationName:"outcomeAlarms" min:"1" type:"list" required:"true"`

	// The identifier of the resource to shift away traffic for when a practice
	// run starts a zonal shift. The identifier is the Amazon Resource Name (ARN)
	// for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePracticeRunConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePracticeRunConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePracticeRunConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePracticeRunConfigurationInput"}
	if s.BlockingAlarms != nil && len(s.BlockingAlarms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockingAlarms", 1))
	}
	if s.OutcomeAlarms == nil {
		invalidParams.Add(request.NewErrParamRequired("OutcomeAlarms"))
	}
	if s.OutcomeAlarms != nil && len(s.OutcomeAlarms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutcomeAlarms", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}
	if s.BlockingAlarms != nil {
		for i, v := range s.BlockingAlarms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockingAlarms", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutcomeAlarms != nil {
		for i, v := range s.OutcomeAlarms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutcomeAlarms", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockedDates sets the BlockedDates field's value.
func (s *CreatePracticeRunConfigurationInput) SetBlockedDates(v []*string) *CreatePracticeRunConfigurationInput {
	s.BlockedDates = v
	return s
}

// SetBlockedWindows sets the BlockedWindows field's value.
func (s *CreatePracticeRunConfigurationInput) SetBlockedWindows(v []*string) *CreatePracticeRunConfigurationInput {
	s.BlockedWindows = v
	return s
}

// SetBlockingAlarms sets the BlockingAlarms field's value.
func (s *CreatePracticeRunConfigurationInput) SetBlockingAlarms(v []*ControlCondition) *CreatePracticeRunConfigurationInput {
	s.BlockingAlarms = v
	return s
}

// SetOutcomeAlarms sets the OutcomeAlarms field's value.
func (s *CreatePracticeRunConfigurationInput) SetOutcomeAlarms(v []*ControlCondition) *CreatePracticeRunConfigurationInput {
	s.OutcomeAlarms = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreatePracticeRunConfigurationInput) SetResourceIdentifier(v string) *CreatePracticeRunConfigurationInput {
	s.ResourceIdentifier = &v
	return s
}

type CreatePracticeRunConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you configured the practice
	// run for.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"8" type:"string" required:"true"`

	// The name of the resource that you configured the practice run for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A practice run configuration for a resource. Configurations include the outcome
	// alarm that you specify for practice runs, and, optionally, a blocking alarm
	// and blocking dates and windows.
	//
	// PracticeRunConfiguration is a required field
	PracticeRunConfiguration *PracticeRunConfiguration `locationName:"practiceRunConfiguration" type:"structure" required:"true"`

	// The status for zonal autoshift for a resource. When you specify the autoshift
	// status as ENABLED, Amazon Web Services shifts traffic away from shifts away
	// application resource traffic from an Availability Zone, on your behalf, when
	// Amazon Web Services determines that there's an issue in the Availability
	// Zone that could potentially affect customers.
	//
	// When you enable zonal autoshift, you must also configure practice runs for
	// the resource.
	//
	// ZonalAutoshiftStatus is a required field
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" required:"true" enum:"ZonalAutoshiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePracticeRunConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePracticeRunConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePracticeRunConfigurationOutput) SetArn(v string) *CreatePracticeRunConfigurationOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePracticeRunConfigurationOutput) SetName(v string) *CreatePracticeRunConfigurationOutput {
	s.Name = &v
	return s
}

// SetPracticeRunConfiguration sets the PracticeRunConfiguration field's value.
func (s *CreatePracticeRunConfigurationOutput) SetPracticeRunConfiguration(v *PracticeRunConfiguration) *CreatePracticeRunConfigurationOutput {
	s.PracticeRunConfiguration = v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *CreatePracticeRunConfigurationOutput) SetZonalAutoshiftStatus(v string) *CreatePracticeRunConfigurationOutput {
	s.ZonalAutoshiftStatus = &v
	return s
}

type DeletePracticeRunConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the resource that you want to delete the practice run
	// configuration for. The identifier is the Amazon Resource Name (ARN) for the
	// resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePracticeRunConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePracticeRunConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePracticeRunConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePracticeRunConfigurationInput"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *DeletePracticeRunConfigurationInput) SetResourceIdentifier(v string) *DeletePracticeRunConfigurationInput {
	s.ResourceIdentifier = &v
	return s
}

type DeletePracticeRunConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you deleted the practice
	// run for.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"8" type:"string" required:"true"`

	// The name of the resource that you deleted the practice run for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of zonal autoshift for the resource.
	//
	// ZonalAutoshiftStatus is a required field
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" required:"true" enum:"ZonalAutoshiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePracticeRunConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePracticeRunConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeletePracticeRunConfigurationOutput) SetArn(v string) *DeletePracticeRunConfigurationOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeletePracticeRunConfigurationOutput) SetName(v string) *DeletePracticeRunConfigurationOutput {
	s.Name = &v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *DeletePracticeRunConfigurationOutput) SetZonalAutoshiftStatus(v string) *DeletePracticeRunConfigurationOutput {
	s.ZonalAutoshiftStatus = &v
	return s
}

type GetManagedResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the resource to shift away traffic for. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetManagedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetManagedResourceInput"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *GetManagedResourceInput) SetResourceIdentifier(v string) *GetManagedResourceInput {
	s.ResourceIdentifier = &v
	return s
}

type GetManagedResourceOutput struct {
	_ struct{} `type:"structure"`

	// A collection of key-value pairs that indicate whether resources are active
	// in Availability Zones or not. The key name is the Availability Zone where
	// the resource is deployed. The value is 1 or 0.
	//
	// AppliedWeights is a required field
	AppliedWeights map[string]*float64 `locationName:"appliedWeights" type:"map" required:"true"`

	// The Amazon Resource Name (ARN) for the resource.
	Arn *string `locationName:"arn" min:"8" type:"string"`

	// An array of the autoshifts that are active for the resource.
	Autoshifts []*AutoshiftInResource `locationName:"autoshifts" type:"list"`

	// The name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The practice run configuration for zonal autoshift that's associated with
	// the resource.
	PracticeRunConfiguration *PracticeRunConfiguration `locationName:"practiceRunConfiguration" type:"structure"`

	// The status for zonal autoshift for a resource. When the autoshift status
	// is ENABLED, Amazon Web Services shifts traffic for a resource away from an
	// Availability Zone, on your behalf, when Amazon Web Services determines that
	// there's an issue in the Availability Zone that could potentially affect customers.
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" enum:"ZonalAutoshiftStatus"`

	// The zonal shifts that are currently active for a resource.
	//
	// ZonalShifts is a required field
	ZonalShifts []*ZonalShiftInResource `locationName:"zonalShifts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetManagedResourceOutput) GoString() string {
	return s.String()
}

// SetAppliedWeights sets the AppliedWeights field's value.
func (s *GetManagedResourceOutput) SetAppliedWeights(v map[string]*float64) *GetManagedResourceOutput {
	s.AppliedWeights = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetManagedResourceOutput) SetArn(v string) *GetManagedResourceOutput {
	s.Arn = &v
	return s
}

// SetAutoshifts sets the Autoshifts field's value.
func (s *GetManagedResourceOutput) SetAutoshifts(v []*AutoshiftInResource) *GetManagedResourceOutput {
	s.Autoshifts = v
	return s
}

// SetName sets the Name field's value.
func (s *GetManagedResourceOutput) SetName(v string) *GetManagedResourceOutput {
	s.Name = &v
	return s
}

// SetPracticeRunConfiguration sets the PracticeRunConfiguration field's value.
func (s *GetManagedResourceOutput) SetPracticeRunConfiguration(v *PracticeRunConfiguration) *GetManagedResourceOutput {
	s.PracticeRunConfiguration = v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *GetManagedResourceOutput) SetZonalAutoshiftStatus(v string) *GetManagedResourceOutput {
	s.ZonalAutoshiftStatus = &v
	return s
}

// SetZonalShifts sets the ZonalShifts field's value.
func (s *GetManagedResourceOutput) SetZonalShifts(v []*ZonalShiftInResource) *GetManagedResourceOutput {
	s.ZonalShifts = v
	return s
}

// There was an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAutoshiftsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The status of the autoshift.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"AutoshiftExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoshiftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoshiftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAutoshiftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAutoshiftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAutoshiftsInput) SetMaxResults(v int64) *ListAutoshiftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAutoshiftsInput) SetNextToken(v string) *ListAutoshiftsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListAutoshiftsInput) SetStatus(v string) *ListAutoshiftsInput {
	s.Status = &v
	return s
}

type ListAutoshiftsOutput struct {
	_ struct{} `type:"structure"`

	// The items in the response list.
	Items []*AutoshiftSummary `locationName:"items" type:"list"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoshiftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAutoshiftsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListAutoshiftsOutput) SetItems(v []*AutoshiftSummary) *ListAutoshiftsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAutoshiftsOutput) SetNextToken(v string) *ListAutoshiftsOutput {
	s.NextToken = &v
	return s
}

type ListManagedResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListManagedResourcesInput) SetMaxResults(v int64) *ListManagedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedResourcesInput) SetNextToken(v string) *ListManagedResourcesInput {
	s.NextToken = &v
	return s
}

type ListManagedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The items in the response list.
	//
	// Items is a required field
	Items []*ManagedResourceSummary `locationName:"items" type:"list" required:"true"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedResourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListManagedResourcesOutput) SetItems(v []*ManagedResourceSummary) *ListManagedResourcesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedResourcesOutput) SetNextToken(v string) *ListManagedResourcesOutput {
	s.NextToken = &v
	return s
}

type ListZonalShiftsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of objects that you want to return with this call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The identifier for the resource that you want to list zonal shifts for. The
	// identifier is the Amazon Resource Name (ARN) for the resource.
	ResourceIdentifier *string `location:"querystring" locationName:"resourceIdentifier" min:"8" type:"string"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift has been started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ZonalShiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListZonalShiftsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListZonalShiftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListZonalShiftsInput) SetMaxResults(v int64) *ListZonalShiftsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListZonalShiftsInput) SetNextToken(v string) *ListZonalShiftsInput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ListZonalShiftsInput) SetResourceIdentifier(v string) *ListZonalShiftsInput {
	s.ResourceIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListZonalShiftsInput) SetStatus(v string) *ListZonalShiftsInput {
	s.Status = &v
	return s
}

type ListZonalShiftsOutput struct {
	_ struct{} `type:"structure"`

	// The items in the response list.
	Items []*ZonalShiftSummary `locationName:"items" type:"list"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListZonalShiftsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListZonalShiftsOutput) SetItems(v []*ZonalShiftSummary) *ListZonalShiftsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListZonalShiftsOutput) SetNextToken(v string) *ListZonalShiftsOutput {
	s.NextToken = &v
	return s
}

// A complex structure for a managed resource in an Amazon Web Services account
// with information about zonal shifts and autoshifts.
//
// A managed resource is a load balancer that has been registered with Route
// 53 ARC by Elastic Load Balancing. You can start a zonal shift in Route 53
// ARC for a managed resource to temporarily move traffic for the resource away
// from an Availability Zone in an Amazon Web Services Region. You can also
// configure zonal autoshift for a managed resource.
//
// At this time, managed resources are Network Load Balancers and Application
// Load Balancers with cross-zone load balancing turned off.
type ManagedResourceSummary struct {
	_ struct{} `type:"structure"`

	// A collection of key-value pairs that indicate whether resources are active
	// in Availability Zones or not. The key name is the Availability Zone where
	// the resource is deployed. The value is 1 or 0.
	AppliedWeights map[string]*float64 `locationName:"appliedWeights" type:"map"`

	// The Amazon Resource Name (ARN) for the managed resource.
	Arn *string `locationName:"arn" min:"8" type:"string"`

	// An array of the autoshifts that have been completed for a resource.
	Autoshifts []*AutoshiftInResource `locationName:"autoshifts" type:"list"`

	// The Availability Zones that a resource is deployed in.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list" required:"true"`

	// The name of the managed resource.
	Name *string `locationName:"name" min:"1" type:"string"`

	// This status tracks whether a practice run configuration exists for a resource.
	// When you configure a practice run for a resource so that a practice run configuration
	// exists, Route 53 ARC sets this value to ENABLED. If a you have not configured
	// a practice run for the resource, or delete a practice run configuration,
	// Route 53 ARC sets the value to DISABLED.
	//
	// Route 53 ARC updates this status; you can't set a practice run status to
	// ENABLED or DISABLED.
	PracticeRunStatus *string `locationName:"practiceRunStatus" type:"string" enum:"ZonalAutoshiftStatus"`

	// The status of autoshift for a resource. When you configure zonal autoshift
	// for a resource, you can set the value of the status to ENABLED or DISABLED.
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" enum:"ZonalAutoshiftStatus"`

	// An array of the zonal shifts for a resource.
	ZonalShifts []*ZonalShiftInResource `locationName:"zonalShifts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedResourceSummary) GoString() string {
	return s.String()
}

// SetAppliedWeights sets the AppliedWeights field's value.
func (s *ManagedResourceSummary) SetAppliedWeights(v map[string]*float64) *ManagedResourceSummary {
	s.AppliedWeights = v
	return s
}

// SetArn sets the Arn field's value.
func (s *ManagedResourceSummary) SetArn(v string) *ManagedResourceSummary {
	s.Arn = &v
	return s
}

// SetAutoshifts sets the Autoshifts field's value.
func (s *ManagedResourceSummary) SetAutoshifts(v []*AutoshiftInResource) *ManagedResourceSummary {
	s.Autoshifts = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *ManagedResourceSummary) SetAvailabilityZones(v []*string) *ManagedResourceSummary {
	s.AvailabilityZones = v
	return s
}

// SetName sets the Name field's value.
func (s *ManagedResourceSummary) SetName(v string) *ManagedResourceSummary {
	s.Name = &v
	return s
}

// SetPracticeRunStatus sets the PracticeRunStatus field's value.
func (s *ManagedResourceSummary) SetPracticeRunStatus(v string) *ManagedResourceSummary {
	s.PracticeRunStatus = &v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *ManagedResourceSummary) SetZonalAutoshiftStatus(v string) *ManagedResourceSummary {
	s.ZonalAutoshiftStatus = &v
	return s
}

// SetZonalShifts sets the ZonalShifts field's value.
func (s *ManagedResourceSummary) SetZonalShifts(v []*ZonalShiftInResource) *ManagedResourceSummary {
	s.ZonalShifts = v
	return s
}

// A practice run configuration for a resource includes the Amazon CloudWatch
// alarms that you've specified for a practice run, as well as any blocked dates
// or blocked windows for the practice run.
//
// You can update or delete a practice run configuration. Before you delete
// a practice run configuration, you must disable zonal autoshift for the resource.
// A practice run configuration is required when zonal autoshift is enabled.
type PracticeRunConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of one or more dates that you can specify when Amazon Web Services
	// does not start practice runs for a resource.
	//
	// Specify blocked dates, in UTC, in the format YYYY-MM-DD, separated by spaces.
	BlockedDates []*string `locationName:"blockedDates" type:"list"`

	// An array of one or more windows of days and times that you can block Route
	// 53 ARC from starting practice runs for a resource.
	//
	// Specify the blocked windows in UTC, using the format DAY:HH:MM-DAY:HH:MM,
	// separated by spaces. For example, MON:18:30-MON:19:30 TUE:18:30-TUE:19:30.
	BlockedWindows []*string `locationName:"blockedWindows" type:"list"`

	// The blocking alarm for practice runs is an optional alarm that you can specify
	// that blocks practice runs when the alarm is in an ALARM state.
	BlockingAlarms []*ControlCondition `locationName:"blockingAlarms" min:"1" type:"list"`

	// The outcome alarm for practice runs is an alarm that you specify that ends
	// a practice run when the alarm is in an ALARM state.
	//
	// OutcomeAlarms is a required field
	OutcomeAlarms []*ControlCondition `locationName:"outcomeAlarms" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PracticeRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PracticeRunConfiguration) GoString() string {
	return s.String()
}

// SetBlockedDates sets the BlockedDates field's value.
func (s *PracticeRunConfiguration) SetBlockedDates(v []*string) *PracticeRunConfiguration {
	s.BlockedDates = v
	return s
}

// SetBlockedWindows sets the BlockedWindows field's value.
func (s *PracticeRunConfiguration) SetBlockedWindows(v []*string) *PracticeRunConfiguration {
	s.BlockedWindows = v
	return s
}

// SetBlockingAlarms sets the BlockingAlarms field's value.
func (s *PracticeRunConfiguration) SetBlockingAlarms(v []*ControlCondition) *PracticeRunConfiguration {
	s.BlockingAlarms = v
	return s
}

// SetOutcomeAlarms sets the OutcomeAlarms field's value.
func (s *PracticeRunConfiguration) SetOutcomeAlarms(v []*ControlCondition) *PracticeRunConfiguration {
	s.OutcomeAlarms = v
	return s
}

// The input requested a resource that was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartZonalShiftInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the Amazon Web Services Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The length of time that you want a zonal shift to be active, which Route
	// 53 ARC converts to an expiry time (expiration time). Zonal shifts are temporary.
	// You can set a zonal shift to be active initially for up to three days (72
	// hours).
	//
	// If you want to still keep traffic away from an Availability Zone, you can
	// update the zonal shift and set a new expiration. You can also cancel a zonal
	// shift, before it expires, for example, if you're ready to restore traffic
	// to the Availability Zone.
	//
	// To set a length of time for a zonal shift to be active, specify a whole number,
	// and then one of the following, with no space:
	//
	//    * A lowercase letter m: To specify that the value is in minutes.
	//
	//    * A lowercase letter h: To specify that the value is in hours.
	//
	// For example: 20h means the zonal shift expires in 20 hours. 120m means the
	// zonal shift expires in 120 minutes (2 hours).
	//
	// ExpiresIn is a required field
	ExpiresIn *string `locationName:"expiresIn" min:"2" type:"string" required:"true"`

	// The identifier for the resource to shift away traffic for. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartZonalShiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartZonalShiftInput"}
	if s.AwayFrom == nil {
		invalidParams.Add(request.NewErrParamRequired("AwayFrom"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.ExpiresIn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpiresIn"))
	}
	if s.ExpiresIn != nil && len(*s.ExpiresIn) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExpiresIn", 2))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *StartZonalShiftInput) SetAwayFrom(v string) *StartZonalShiftInput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *StartZonalShiftInput) SetComment(v string) *StartZonalShiftInput {
	s.Comment = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *StartZonalShiftInput) SetExpiresIn(v string) *StartZonalShiftInput {
	s.ExpiresIn = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *StartZonalShiftInput) SetResourceIdentifier(v string) *StartZonalShiftInput {
	s.ResourceIdentifier = &v
	return s
}

type StartZonalShiftOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the Amazon Web Services Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for a customer-started zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift.
	// You can initially set a zonal shift to expire in a maximum of three days
	// (72 hours). However, you can update a zonal shift to set a new expiration
	// at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift when you're ready to restore traffic to the Availability
	// Zone, or just wait for it to expire. Or you can update the zonal shift to
	// specify another length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to shift away traffic for. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift has been started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartZonalShiftOutput) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *StartZonalShiftOutput) SetAwayFrom(v string) *StartZonalShiftOutput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *StartZonalShiftOutput) SetComment(v string) *StartZonalShiftOutput {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *StartZonalShiftOutput) SetExpiryTime(v time.Time) *StartZonalShiftOutput {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *StartZonalShiftOutput) SetResourceIdentifier(v string) *StartZonalShiftOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartZonalShiftOutput) SetStartTime(v time.Time) *StartZonalShiftOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartZonalShiftOutput) SetStatus(v string) *StartZonalShiftOutput {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *StartZonalShiftOutput) SetZonalShiftId(v string) *StartZonalShiftOutput {
	s.ZonalShiftId = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdatePracticeRunConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Add, change, or remove blocked dates for a practice run in zonal autoshift.
	//
	// Optionally, you can block practice runs for specific calendar dates. The
	// format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates,
	// that dates and times for practice runs are in UTC. Separate multiple blocked
	// dates with spaces.
	//
	// For example, if you have an application update scheduled to launch on May
	// 1, 2024, and you don't want practice runs to shift traffic away at that time,
	// you could set a blocked date for 2024-05-01.
	BlockedDates []*string `locationName:"blockedDates" type:"list"`

	// Add, change, or remove windows of days and times for when you can, optionally,
	// block Route 53 ARC from starting a practice run for a resource.
	//
	// The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when
	// you specify dates, that dates and times for practice runs are in UTC. Also,
	// be aware of potential time adjustments that might be required for daylight
	// saving time differences. Separate multiple blocked windows with spaces.
	//
	// For example, say you run business report summaries three days a week. For
	// this scenario, you might set the following recurring days and times as blocked
	// windows, for example: MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30.
	BlockedWindows []*string `locationName:"blockedWindows" type:"list"`

	// Add, change, or remove the Amazon CloudWatch alarm that you optionally specify
	// as the blocking alarm for practice runs.
	BlockingAlarms []*ControlCondition `locationName:"blockingAlarms" min:"1" type:"list"`

	// Specify a new the Amazon CloudWatch alarm as the outcome alarm for practice
	// runs.
	OutcomeAlarms []*ControlCondition `locationName:"outcomeAlarms" min:"1" type:"list"`

	// The identifier for the resource that you want to update the practice run
	// configuration for. The identifier is the Amazon Resource Name (ARN) for the
	// resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePracticeRunConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePracticeRunConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePracticeRunConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePracticeRunConfigurationInput"}
	if s.BlockingAlarms != nil && len(s.BlockingAlarms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockingAlarms", 1))
	}
	if s.OutcomeAlarms != nil && len(s.OutcomeAlarms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutcomeAlarms", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}
	if s.BlockingAlarms != nil {
		for i, v := range s.BlockingAlarms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockingAlarms", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutcomeAlarms != nil {
		for i, v := range s.OutcomeAlarms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutcomeAlarms", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockedDates sets the BlockedDates field's value.
func (s *UpdatePracticeRunConfigurationInput) SetBlockedDates(v []*string) *UpdatePracticeRunConfigurationInput {
	s.BlockedDates = v
	return s
}

// SetBlockedWindows sets the BlockedWindows field's value.
func (s *UpdatePracticeRunConfigurationInput) SetBlockedWindows(v []*string) *UpdatePracticeRunConfigurationInput {
	s.BlockedWindows = v
	return s
}

// SetBlockingAlarms sets the BlockingAlarms field's value.
func (s *UpdatePracticeRunConfigurationInput) SetBlockingAlarms(v []*ControlCondition) *UpdatePracticeRunConfigurationInput {
	s.BlockingAlarms = v
	return s
}

// SetOutcomeAlarms sets the OutcomeAlarms field's value.
func (s *UpdatePracticeRunConfigurationInput) SetOutcomeAlarms(v []*ControlCondition) *UpdatePracticeRunConfigurationInput {
	s.OutcomeAlarms = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *UpdatePracticeRunConfigurationInput) SetResourceIdentifier(v string) *UpdatePracticeRunConfigurationInput {
	s.ResourceIdentifier = &v
	return s
}

type UpdatePracticeRunConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you updated the practice
	// run for.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"8" type:"string" required:"true"`

	// The name of the resource that you updated the practice run for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The practice run configuration that was updated.
	//
	// PracticeRunConfiguration is a required field
	PracticeRunConfiguration *PracticeRunConfiguration `locationName:"practiceRunConfiguration" type:"structure" required:"true"`

	// The zonal autoshift status for the resource that you updated the practice
	// run for.
	//
	// ZonalAutoshiftStatus is a required field
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" required:"true" enum:"ZonalAutoshiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePracticeRunConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePracticeRunConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePracticeRunConfigurationOutput) SetArn(v string) *UpdatePracticeRunConfigurationOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePracticeRunConfigurationOutput) SetName(v string) *UpdatePracticeRunConfigurationOutput {
	s.Name = &v
	return s
}

// SetPracticeRunConfiguration sets the PracticeRunConfiguration field's value.
func (s *UpdatePracticeRunConfigurationOutput) SetPracticeRunConfiguration(v *PracticeRunConfiguration) *UpdatePracticeRunConfigurationOutput {
	s.PracticeRunConfiguration = v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *UpdatePracticeRunConfigurationOutput) SetZonalAutoshiftStatus(v string) *UpdatePracticeRunConfigurationOutput {
	s.ZonalAutoshiftStatus = &v
	return s
}

type UpdateZonalAutoshiftConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource that you want to update the zonal autoshift
	// configuration for. The identifier is the Amazon Resource Name (ARN) for the
	// resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `location:"uri" locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The zonal autoshift status for the resource that you want to update the zonal
	// autoshift configuration for.
	//
	// ZonalAutoshiftStatus is a required field
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" required:"true" enum:"ZonalAutoshiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalAutoshiftConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalAutoshiftConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateZonalAutoshiftConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateZonalAutoshiftConfigurationInput"}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 8))
	}
	if s.ZonalAutoshiftStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("ZonalAutoshiftStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *UpdateZonalAutoshiftConfigurationInput) SetResourceIdentifier(v string) *UpdateZonalAutoshiftConfigurationInput {
	s.ResourceIdentifier = &v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *UpdateZonalAutoshiftConfigurationInput) SetZonalAutoshiftStatus(v string) *UpdateZonalAutoshiftConfigurationInput {
	s.ZonalAutoshiftStatus = &v
	return s
}

type UpdateZonalAutoshiftConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource that you updated the zonal autoshift configuration
	// for. The identifier is the Amazon Resource Name (ARN) for the resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The zonal autoshift status for the resource that you updated the zonal autoshift
	// configuration for.
	//
	// ZonalAutoshiftStatus is a required field
	ZonalAutoshiftStatus *string `locationName:"zonalAutoshiftStatus" type:"string" required:"true" enum:"ZonalAutoshiftStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalAutoshiftConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalAutoshiftConfigurationOutput) GoString() string {
	return s.String()
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *UpdateZonalAutoshiftConfigurationOutput) SetResourceIdentifier(v string) *UpdateZonalAutoshiftConfigurationOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetZonalAutoshiftStatus sets the ZonalAutoshiftStatus field's value.
func (s *UpdateZonalAutoshiftConfigurationOutput) SetZonalAutoshiftStatus(v string) *UpdateZonalAutoshiftConfigurationOutput {
	s.ZonalAutoshiftStatus = &v
	return s
}

type UpdateZonalShiftInput struct {
	_ struct{} `type:"structure"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	Comment *string `locationName:"comment" type:"string"`

	// The length of time that you want a zonal shift to be active, which Route
	// 53 ARC converts to an expiry time (expiration time). Zonal shifts are temporary.
	// You can set a zonal shift to be active initially for up to three days (72
	// hours).
	//
	// If you want to still keep traffic away from an Availability Zone, you can
	// update the zonal shift and set a new expiration. You can also cancel a zonal
	// shift, before it expires, for example, if you're ready to restore traffic
	// to the Availability Zone.
	//
	// To set a length of time for a zonal shift to be active, specify a whole number,
	// and then one of the following, with no space:
	//
	//    * A lowercase letter m: To specify that the value is in minutes.
	//
	//    * A lowercase letter h: To specify that the value is in hours.
	//
	// For example: 20h means the zonal shift expires in 20 hours. 120m means the
	// zonal shift expires in 120 minutes (2 hours).
	ExpiresIn *string `locationName:"expiresIn" min:"2" type:"string"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `location:"uri" locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateZonalShiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateZonalShiftInput"}
	if s.ExpiresIn != nil && len(*s.ExpiresIn) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExpiresIn", 2))
	}
	if s.ZonalShiftId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZonalShiftId"))
	}
	if s.ZonalShiftId != nil && len(*s.ZonalShiftId) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ZonalShiftId", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *UpdateZonalShiftInput) SetComment(v string) *UpdateZonalShiftInput {
	s.Comment = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *UpdateZonalShiftInput) SetExpiresIn(v string) *UpdateZonalShiftInput {
	s.ExpiresIn = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *UpdateZonalShiftInput) SetZonalShiftId(v string) *UpdateZonalShiftInput {
	s.ZonalShiftId = &v
	return s
}

type UpdateZonalShiftOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the Amazon Web Services Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. A new comment overwrites any
	// existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for a customer-started zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift.
	// You can initially set a zonal shift to expire in a maximum of three days
	// (72 hours). However, you can update a zonal shift to set a new expiration
	// at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift when you're ready to restore traffic to the Availability
	// Zone, or just wait for it to expire. Or you can update the zonal shift to
	// specify another length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The identifier for the resource to shift away traffic for. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift has been started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateZonalShiftOutput) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *UpdateZonalShiftOutput) SetAwayFrom(v string) *UpdateZonalShiftOutput {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *UpdateZonalShiftOutput) SetComment(v string) *UpdateZonalShiftOutput {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *UpdateZonalShiftOutput) SetExpiryTime(v time.Time) *UpdateZonalShiftOutput {
	s.ExpiryTime = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *UpdateZonalShiftOutput) SetResourceIdentifier(v string) *UpdateZonalShiftOutput {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *UpdateZonalShiftOutput) SetStartTime(v time.Time) *UpdateZonalShiftOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateZonalShiftOutput) SetStatus(v string) *UpdateZonalShiftOutput {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *UpdateZonalShiftOutput) SetZonalShiftId(v string) *UpdateZonalShiftOutput {
	s.ZonalShiftId = &v
	return s
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex structure that lists the zonal shifts for a managed resource and
// their statuses for the resource.
type ZonalShiftInResource struct {
	_ struct{} `type:"structure"`

	// The appliedStatus field specifies which application traffic shift is in effect
	// for a resource when there is more than one traffic shift active. There can
	// be more than one application traffic shift in progress at the same time -
	// that is, practice run zonal shifts, customer-started zonal shifts, or an
	// autoshift. The appliedStatus field for an autoshift for a resource can have
	// one of two values: APPLIED or NOT_APPLIED. The zonal shift or autoshift that
	// is currently in effect for the resource has an applied status set to APPLIED.
	//
	// The overall principle for precedence is that zonal shifts that you start
	// as a customer take precedence autoshifts, which take precedence over practice
	// runs. That is, customer-started zonal shifts > autoshifts > practice run
	// zonal shifts.
	//
	// For more information, see How zonal autoshift and practice runs work (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html)
	// in the Amazon Route 53 Application Recovery Controller Developer Guide.
	//
	// AppliedStatus is a required field
	AppliedStatus *string `locationName:"appliedStatus" type:"string" required:"true" enum:"AppliedStatus"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the Amazon Web Services Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. That is, a new comment overwrites
	// any existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for a customer-started zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift.
	// You can initially set a zonal shift to expire in a maximum of three days
	// (72 hours). However, you can update a zonal shift to set a new expiration
	// at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift when you're ready to restore traffic to the Availability
	// Zone, or just wait for it to expire. Or you can update the zonal shift to
	// specify another length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The outcome, or end state, returned for a practice run. The following values
	// can be returned:
	//
	//    * PENDING: Outcome value when a practice run is in progress.
	//
	//    * SUCCEEDED: Outcome value when the outcome alarm specified for the practice
	//    run configuration does not go into an ALARM state during the practice
	//    run, and the practice run was not interrupted before it completed the
	//    expected 30 minute zonal shift.
	//
	//    * INTERRUPTED: Outcome value when the practice run was stopped before
	//    the expected 30 minute zonal shift duration, or there was another problem
	//    with the practice run that created an inconclusive outcome.
	//
	//    * FAILED: Outcome value when the outcome alarm specified for the practice
	//    run configuration goes into an ALARM state during the practice run, and
	//    the practice run was not interrupted before it completed.
	//
	// For more information about practice run outcomes, see Considerations when
	// you configure zonal autoshift (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html)
	// in the Amazon Route 53 Application Recovery Controller Developer Guide.
	PracticeRunOutcome *string `locationName:"practiceRunOutcome" type:"string" enum:"PracticeRunOutcome"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftInResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftInResource) GoString() string {
	return s.String()
}

// SetAppliedStatus sets the AppliedStatus field's value.
func (s *ZonalShiftInResource) SetAppliedStatus(v string) *ZonalShiftInResource {
	s.AppliedStatus = &v
	return s
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *ZonalShiftInResource) SetAwayFrom(v string) *ZonalShiftInResource {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *ZonalShiftInResource) SetComment(v string) *ZonalShiftInResource {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *ZonalShiftInResource) SetExpiryTime(v time.Time) *ZonalShiftInResource {
	s.ExpiryTime = &v
	return s
}

// SetPracticeRunOutcome sets the PracticeRunOutcome field's value.
func (s *ZonalShiftInResource) SetPracticeRunOutcome(v string) *ZonalShiftInResource {
	s.PracticeRunOutcome = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ZonalShiftInResource) SetResourceIdentifier(v string) *ZonalShiftInResource {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ZonalShiftInResource) SetStartTime(v time.Time) *ZonalShiftInResource {
	s.StartTime = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *ZonalShiftInResource) SetZonalShiftId(v string) *ZonalShiftInResource {
	s.ZonalShiftId = &v
	return s
}

// Lists information about zonal shifts in Amazon Route 53 Application Recovery
// Controller, including zonal shifts that you start yourself and zonal shifts
// that Route 53 ARC starts on your behalf for practice runs with zonal autoshift.
//
// Zonal shifts are temporary, including customer-started zonal shifts and the
// zonal autoshift practice run zonal shifts that Route 53 ARC starts weekly,
// on your behalf. A zonal shift that a customer starts can be active for up
// to three days (72 hours). A practice run zonal shift has a 30 minute duration.
type ZonalShiftSummary struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that traffic is moved away from for a resource when
	// you start a zonal shift. Until the zonal shift expires or you cancel it,
	// traffic for the resource is instead moved to other Availability Zones in
	// the Amazon Web Services Region.
	//
	// AwayFrom is a required field
	AwayFrom *string `locationName:"awayFrom" type:"string" required:"true"`

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. That is, a new comment overwrites
	// any existing comment string.
	//
	// Comment is a required field
	Comment *string `locationName:"comment" type:"string" required:"true"`

	// The expiry time (expiration time) for a customer-started zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift.
	// You can initially set a zonal shift to expire in a maximum of three days
	// (72 hours). However, you can update a zonal shift to set a new expiration
	// at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which Route 53 ARC converts to an expiry time (expiration time). You can
	// cancel a zonal shift when you're ready to restore traffic to the Availability
	// Zone, or just wait for it to expire. Or you can update the zonal shift to
	// specify another length of time to expire in.
	//
	// ExpiryTime is a required field
	ExpiryTime *time.Time `locationName:"expiryTime" type:"timestamp" required:"true"`

	// The outcome, or end state, of a practice run. The following values can be
	// returned:
	//
	//    * PENDING: Outcome value when the practice run is in progress.
	//
	//    * SUCCEEDED: Outcome value when the outcome alarm specified for the practice
	//    run configuration does not go into an ALARM state during the practice
	//    run, and the practice run was not interrupted before it completed.
	//
	//    * INTERRUPTED: Outcome value when the practice run did not run for the
	//    expected 30 minutes or there was another problem with the practice run
	//    that created an inconclusive outcome.
	//
	//    * FAILED: Outcome value when the outcome alarm specified for the practice
	//    run configuration goes into an ALARM state during the practice run, and
	//    the practice run was not interrupted before it completed.
	//
	// For more information about practice run outcomes, see Considerations when
	// you configure zonal autoshift (https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html)
	// in the Amazon Route 53 Application Recovery Controller Developer Guide.
	PracticeRunOutcome *string `locationName:"practiceRunOutcome" type:"string" enum:"PracticeRunOutcome"`

	// The identifier for the resource to include in a zonal shift. The identifier
	// is the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, you can only start a zonal shift for Network Load Balancers
	// and Application Load Balancers with cross-zone load balancing turned off.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `locationName:"resourceIdentifier" min:"8" type:"string" required:"true"`

	// The time (UTC) when the zonal shift starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//    * ACTIVE: The zonal shift has been started and active.
	//
	//    * EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//    * CANCELED: The zonal shift was canceled.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ZonalShiftStatus"`

	// The identifier of a zonal shift.
	//
	// ZonalShiftId is a required field
	ZonalShiftId *string `locationName:"zonalShiftId" min:"6" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalShiftSummary) GoString() string {
	return s.String()
}

// SetAwayFrom sets the AwayFrom field's value.
func (s *ZonalShiftSummary) SetAwayFrom(v string) *ZonalShiftSummary {
	s.AwayFrom = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *ZonalShiftSummary) SetComment(v string) *ZonalShiftSummary {
	s.Comment = &v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *ZonalShiftSummary) SetExpiryTime(v time.Time) *ZonalShiftSummary {
	s.ExpiryTime = &v
	return s
}

// SetPracticeRunOutcome sets the PracticeRunOutcome field's value.
func (s *ZonalShiftSummary) SetPracticeRunOutcome(v string) *ZonalShiftSummary {
	s.PracticeRunOutcome = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ZonalShiftSummary) SetResourceIdentifier(v string) *ZonalShiftSummary {
	s.ResourceIdentifier = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ZonalShiftSummary) SetStartTime(v time.Time) *ZonalShiftSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ZonalShiftSummary) SetStatus(v string) *ZonalShiftSummary {
	s.Status = &v
	return s
}

// SetZonalShiftId sets the ZonalShiftId field's value.
func (s *ZonalShiftSummary) SetZonalShiftId(v string) *ZonalShiftSummary {
	s.ZonalShiftId = &v
	return s
}

const (
	// AppliedStatusApplied is a AppliedStatus enum value
	AppliedStatusApplied = "APPLIED"

	// AppliedStatusNotApplied is a AppliedStatus enum value
	AppliedStatusNotApplied = "NOT_APPLIED"
)

// AppliedStatus_Values returns all elements of the AppliedStatus enum
func AppliedStatus_Values() []string {
	return []string{
		AppliedStatusApplied,
		AppliedStatusNotApplied,
	}
}

const (
	// AutoshiftAppliedStatusApplied is a AutoshiftAppliedStatus enum value
	AutoshiftAppliedStatusApplied = "APPLIED"

	// AutoshiftAppliedStatusNotApplied is a AutoshiftAppliedStatus enum value
	AutoshiftAppliedStatusNotApplied = "NOT_APPLIED"
)

// AutoshiftAppliedStatus_Values returns all elements of the AutoshiftAppliedStatus enum
func AutoshiftAppliedStatus_Values() []string {
	return []string{
		AutoshiftAppliedStatusApplied,
		AutoshiftAppliedStatusNotApplied,
	}
}

const (
	// AutoshiftExecutionStatusActive is a AutoshiftExecutionStatus enum value
	AutoshiftExecutionStatusActive = "ACTIVE"

	// AutoshiftExecutionStatusCompleted is a AutoshiftExecutionStatus enum value
	AutoshiftExecutionStatusCompleted = "COMPLETED"
)

// AutoshiftExecutionStatus_Values returns all elements of the AutoshiftExecutionStatus enum
func AutoshiftExecutionStatus_Values() []string {
	return []string{
		AutoshiftExecutionStatusActive,
		AutoshiftExecutionStatusCompleted,
	}
}

const (
	// ConflictExceptionReasonZonalShiftAlreadyExists is a ConflictExceptionReason enum value
	ConflictExceptionReasonZonalShiftAlreadyExists = "ZonalShiftAlreadyExists"

	// ConflictExceptionReasonZonalShiftStatusNotActive is a ConflictExceptionReason enum value
	ConflictExceptionReasonZonalShiftStatusNotActive = "ZonalShiftStatusNotActive"

	// ConflictExceptionReasonSimultaneousZonalShiftsConflict is a ConflictExceptionReason enum value
	ConflictExceptionReasonSimultaneousZonalShiftsConflict = "SimultaneousZonalShiftsConflict"

	// ConflictExceptionReasonPracticeConfigurationAlreadyExists is a ConflictExceptionReason enum value
	ConflictExceptionReasonPracticeConfigurationAlreadyExists = "PracticeConfigurationAlreadyExists"

	// ConflictExceptionReasonAutoShiftEnabled is a ConflictExceptionReason enum value
	ConflictExceptionReasonAutoShiftEnabled = "AutoShiftEnabled"

	// ConflictExceptionReasonPracticeConfigurationDoesNotExist is a ConflictExceptionReason enum value
	ConflictExceptionReasonPracticeConfigurationDoesNotExist = "PracticeConfigurationDoesNotExist"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonZonalShiftAlreadyExists,
		ConflictExceptionReasonZonalShiftStatusNotActive,
		ConflictExceptionReasonSimultaneousZonalShiftsConflict,
		ConflictExceptionReasonPracticeConfigurationAlreadyExists,
		ConflictExceptionReasonAutoShiftEnabled,
		ConflictExceptionReasonPracticeConfigurationDoesNotExist,
	}
}

const (
	// ControlConditionTypeCloudwatch is a ControlConditionType enum value
	ControlConditionTypeCloudwatch = "CLOUDWATCH"
)

// ControlConditionType_Values returns all elements of the ControlConditionType enum
func ControlConditionType_Values() []string {
	return []string{
		ControlConditionTypeCloudwatch,
	}
}

const (
	// PracticeRunOutcomeFailed is a PracticeRunOutcome enum value
	PracticeRunOutcomeFailed = "FAILED"

	// PracticeRunOutcomeInterrupted is a PracticeRunOutcome enum value
	PracticeRunOutcomeInterrupted = "INTERRUPTED"

	// PracticeRunOutcomePending is a PracticeRunOutcome enum value
	PracticeRunOutcomePending = "PENDING"

	// PracticeRunOutcomeSucceeded is a PracticeRunOutcome enum value
	PracticeRunOutcomeSucceeded = "SUCCEEDED"
)

// PracticeRunOutcome_Values returns all elements of the PracticeRunOutcome enum
func PracticeRunOutcome_Values() []string {
	return []string{
		PracticeRunOutcomeFailed,
		PracticeRunOutcomeInterrupted,
		PracticeRunOutcomePending,
		PracticeRunOutcomeSucceeded,
	}
}

const (
	// ValidationExceptionReasonInvalidExpiresIn is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidExpiresIn = "InvalidExpiresIn"

	// ValidationExceptionReasonInvalidStatus is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidStatus = "InvalidStatus"

	// ValidationExceptionReasonMissingValue is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingValue = "MissingValue"

	// ValidationExceptionReasonInvalidToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidToken = "InvalidToken"

	// ValidationExceptionReasonInvalidResourceIdentifier is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidResourceIdentifier = "InvalidResourceIdentifier"

	// ValidationExceptionReasonInvalidAz is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidAz = "InvalidAz"

	// ValidationExceptionReasonUnsupportedAz is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnsupportedAz = "UnsupportedAz"

	// ValidationExceptionReasonInvalidAlarmCondition is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidAlarmCondition = "InvalidAlarmCondition"

	// ValidationExceptionReasonInvalidConditionType is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidConditionType = "InvalidConditionType"

	// ValidationExceptionReasonInvalidPracticeBlocker is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidPracticeBlocker = "InvalidPracticeBlocker"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonInvalidExpiresIn,
		ValidationExceptionReasonInvalidStatus,
		ValidationExceptionReasonMissingValue,
		ValidationExceptionReasonInvalidToken,
		ValidationExceptionReasonInvalidResourceIdentifier,
		ValidationExceptionReasonInvalidAz,
		ValidationExceptionReasonUnsupportedAz,
		ValidationExceptionReasonInvalidAlarmCondition,
		ValidationExceptionReasonInvalidConditionType,
		ValidationExceptionReasonInvalidPracticeBlocker,
	}
}

const (
	// ZonalAutoshiftStatusEnabled is a ZonalAutoshiftStatus enum value
	ZonalAutoshiftStatusEnabled = "ENABLED"

	// ZonalAutoshiftStatusDisabled is a ZonalAutoshiftStatus enum value
	ZonalAutoshiftStatusDisabled = "DISABLED"
)

// ZonalAutoshiftStatus_Values returns all elements of the ZonalAutoshiftStatus enum
func ZonalAutoshiftStatus_Values() []string {
	return []string{
		ZonalAutoshiftStatusEnabled,
		ZonalAutoshiftStatusDisabled,
	}
}

const (
	// ZonalShiftStatusActive is a ZonalShiftStatus enum value
	ZonalShiftStatusActive = "ACTIVE"

	// ZonalShiftStatusExpired is a ZonalShiftStatus enum value
	ZonalShiftStatusExpired = "EXPIRED"

	// ZonalShiftStatusCanceled is a ZonalShiftStatus enum value
	ZonalShiftStatusCanceled = "CANCELED"
)

// ZonalShiftStatus_Values returns all elements of the ZonalShiftStatus enum
func ZonalShiftStatus_Values() []string {
	return []string{
		ZonalShiftStatusActive,
		ZonalShiftStatusExpired,
		ZonalShiftStatusCanceled,
	}
}
