/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://discord.gg/8naAwJfWN6
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"
	"context"
	"encoding/json"
	"encoding/xml"
	"errors"
	"fmt"
	"io"
	"log"
	"net/http"
	"net/http/httputil"
	"net/url"
	"os"
	"reflect"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"
)

var (
	jsonCheck = regexp.MustCompile(`(?i:(?:application|text)/(?:vnd\.[^;]+\+)?json)`)
	xmlCheck  = regexp.MustCompile(`(?i:(?:application|text)/xml)`)
)

// ErrorResponse defines the error that will be asserted by FGA API.
// This will only be used for error that is not defined
type ErrorResponse struct {
	Code    string `json:"code"`
	Message string `json:"message"`
}

// APIClient manages communication with the OpenFGA API v0.1
// In most cases there should be only one, shared, APIClient.
type APIClient struct {
	cfg    *Configuration
	common service // Reuse a single struct instead of allocating one for each service on the heap.

	// API Services

	OpenFgaApi OpenFgaApi
}

type service struct {
	client      *APIClient
	RetryParams *RetryParams
}

// NewAPIClient creates a new API client. Requires a userAgent string describing your application.
// optionally a custom http.Client to allow for advanced features such as caching.
func NewAPIClient(cfg *Configuration) *APIClient {
	if cfg.HTTPClient == nil {
		if cfg.Credentials == nil {
			cfg.HTTPClient = http.DefaultClient
		} else {
			var httpClient, headers = cfg.Credentials.GetHttpClientAndHeaderOverrides()
			if len(headers) > 0 {
				for idx := range headers {
					cfg.AddDefaultHeader(headers[idx].Key, headers[idx].Value)
				}
			}
			if httpClient != nil {
				cfg.HTTPClient = httpClient
			}
		}
	}

	c := &APIClient{}
	c.cfg = cfg
	c.common.client = c
	c.common.RetryParams = cfg.RetryParams

	// API Services
	c.OpenFgaApi = (*OpenFgaApiService)(&c.common)

	return c
}

func (a APIClient) GetStoreId() string {
	return a.cfg.StoreId
}

func (a APIClient) SetStoreId(storeId string) {
	a.cfg.StoreId = storeId
}

// selectHeaderContentType select a content type from the available list.
func selectHeaderContentType(contentTypes []string) string {
	if len(contentTypes) == 0 {
		return ""
	}
	if contains(contentTypes, "application/json") {
		return "application/json"
	}
	return contentTypes[0] // use the first content type specified in 'consumes'
}

// selectHeaderAccept join all accept types and return
func selectHeaderAccept(accepts []string) string {
	if len(accepts) == 0 {
		return ""
	}

	if contains(accepts, "application/json") {
		return "application/json"
	}

	return strings.Join(accepts, ",")
}

// contains is a case insensitive match, finding needle in a haystack
func contains(haystack []string, needle string) bool {
	loweredNeedle := strings.ToLower(needle)
	for _, a := range haystack {
		if strings.ToLower(a) == loweredNeedle {
			return true
		}
	}
	return false
}

// Verify optional parameters are of the correct type.
func typeCheckParameter(obj interface{}, expected string, name string) error {
	// Make sure there is an object.
	if obj == nil {
		return nil
	}

	// Check the type is as expected.
	if reflect.TypeOf(obj).String() != expected {
		return fmt.Errorf("Expected %s to be of type %s but received %s.", name, expected, reflect.TypeOf(obj).String())
	}
	return nil
}

// parameterToString convert interface{} parameters to string, using a delimiter if format is provided.
func parameterToString(obj interface{}, collectionFormat string) string {
	var delimiter string

	switch collectionFormat {
	case "pipes":
		delimiter = "|"
	case "ssv":
		delimiter = " "
	case "tsv":
		delimiter = "\t"
	case "csv":
		delimiter = ","
	}

	if reflect.TypeOf(obj).Kind() == reflect.Slice {
		return strings.Trim(strings.Replace(fmt.Sprint(obj), " ", delimiter, -1), "[]")
	} else if t, ok := obj.(time.Time); ok {
		return t.Format(time.RFC3339)
	}

	return fmt.Sprintf("%v", obj)
}

// helper for converting interface{} parameters to json strings
func parameterToJson(obj interface{}) (string, error) {
	jsonBuf, err := json.Marshal(obj)
	if err != nil {
		return "", err
	}
	return string(jsonBuf), err
}

// callAPI do the request.
func (c *APIClient) callAPI(request *http.Request) (*http.Response, error) {
	if c.cfg.Debug {
		dump, err := httputil.DumpRequestOut(request, true)
		if err != nil {
			return nil, err
		}
		log.Printf("\n%s\n", string(dump))
	}

	resp, err := c.cfg.HTTPClient.Do(request)
	if err != nil {
		return resp, err
	}

	if c.cfg.Debug {
		dump, err := httputil.DumpResponse(resp, true)
		if err != nil {
			return resp, err
		}
		log.Printf("\n%s\n", string(dump))
	}
	return resp, err
}

// Allow modification of underlying config for alternate implementations and testing
// Caution: modifying the configuration while live can cause data races and potentially unwanted behavior
func (c *APIClient) GetConfig() *Configuration {
	return c.cfg
}

// prepareRequest build the request
func (c *APIClient) prepareRequest(
	ctx context.Context,
	path string, method string,
	postBody interface{},
	headerParams map[string]string,
	queryParams url.Values) (localVarRequest *http.Request, err error) {

	var body *bytes.Buffer

	// Detect postBody type and post.
	if postBody != nil {
		contentType := headerParams["Content-Type"]
		if contentType == "" {
			contentType = detectContentType(postBody)
			headerParams["Content-Type"] = contentType
		}

		body, err = setBody(postBody, contentType)
		if err != nil {
			return nil, err
		}
	}

	// Setup path and query parameters
	uri, err := url.Parse(c.cfg.ApiUrl + path)
	if err != nil {
		return nil, err
	}

	// Adding Query Param
	query := uri.Query()
	for k, v := range queryParams {
		for _, iv := range v {
			query.Add(k, iv)
		}
	}

	// Encode the parameters.
	uri.RawQuery = query.Encode()

	// Generate a new request
	if body != nil {
		localVarRequest, err = http.NewRequest(method, uri.String(), body)
	} else {
		localVarRequest, err = http.NewRequest(method, uri.String(), nil)
	}
	if err != nil {
		return nil, err
	}

	// add header parameters, if any
	if len(headerParams) > 0 {
		headers := http.Header{}
		for h, v := range headerParams {
			headers.Set(h, v)
		}
		localVarRequest.Header = headers
	}

	// Add the user agent to the request.
	localVarRequest.Header.Set("User-Agent", c.cfg.UserAgent)

	for header, value := range c.cfg.DefaultHeaders {
		localVarRequest.Header.Set(header, value)
	}

	if ctx != nil {
		// add context to the request
		localVarRequest = localVarRequest.WithContext(ctx)
	}

	return localVarRequest, nil
}

func (c *APIClient) decode(v interface{}, b []byte, contentType string) (err error) {
	if len(b) == 0 {
		return nil
	}
	if s, ok := v.(*string); ok {
		*s = string(b)
		return nil
	}
	if xmlCheck.MatchString(contentType) {
		if err = xml.Unmarshal(b, v); err != nil {
			return err
		}
		return nil
	}
	if jsonCheck.MatchString(contentType) {
		if actualObj, ok := v.(interface{ GetActualInstance() interface{} }); ok { // oneOf, anyOf schemas
			if unmarshalObj, ok := actualObj.(interface{ UnmarshalJSON([]byte) error }); ok { // make sure it has UnmarshalJSON defined
				if err = unmarshalObj.UnmarshalJSON(b); err != nil {
					return err
				}
			} else {
				return errors.New("Unknown type with GetActualInstance but no unmarshalObj.UnmarshalJSON defined")
			}
		} else if err = json.Unmarshal(b, v); err != nil { // simple model
			return err
		}
		return nil
	}
	return errors.New("undefined response type")
}

// Prevent trying to import "fmt"
func reportError(format string, a ...interface{}) error {
	return fmt.Errorf(format, a...)
}

// Set request body from an interface{}
func setBody(body interface{}, contentType string) (bodyBuf *bytes.Buffer, err error) {
	if bodyBuf == nil {
		bodyBuf = &bytes.Buffer{}
	}

	if reader, ok := body.(io.Reader); ok {
		_, err = bodyBuf.ReadFrom(reader)
	} else if fp, ok := body.(**os.File); ok {
		_, err = bodyBuf.ReadFrom(*fp)
	} else if b, ok := body.([]byte); ok {
		_, err = bodyBuf.Write(b)
	} else if s, ok := body.(string); ok {
		_, err = bodyBuf.WriteString(s)
	} else if s, ok := body.(*string); ok {
		_, err = bodyBuf.WriteString(*s)
	} else if jsonCheck.MatchString(contentType) {
		err = json.NewEncoder(bodyBuf).Encode(body)
	} else if xmlCheck.MatchString(contentType) {
		err = xml.NewEncoder(bodyBuf).Encode(body)
	}

	if err != nil {
		return nil, err
	}

	if bodyBuf.Len() == 0 {
		err = fmt.Errorf("Invalid body type %s\n", contentType)
		return nil, err
	}
	return bodyBuf, nil
}

// detectContentType method is used to figure out `Request.Body` content type for request header
func detectContentType(body interface{}) string {
	contentType := "text/plain; charset=utf-8"
	kind := reflect.TypeOf(body).Kind()

	switch kind {
	case reflect.Struct, reflect.Map, reflect.Ptr:
		contentType = "application/json; charset=utf-8"
	case reflect.String:
		contentType = "text/plain; charset=utf-8"
	default:
		if b, ok := body.([]byte); ok {
			contentType = http.DetectContentType(b)
		} else if kind == reflect.Slice {
			contentType = "application/json; charset=utf-8"
		}
	}

	return contentType
}

// Ripped from https://github.com/gregjones/httpcache/blob/master/httpcache.go
type cacheControl map[string]string

func parseCacheControl(headers http.Header) cacheControl {
	cc := cacheControl{}
	ccHeader := headers.Get("Cache-Control")
	for _, part := range strings.Split(ccHeader, ",") {
		part = strings.Trim(part, " ")
		if part == "" {
			continue
		}
		if strings.ContainsRune(part, '=') {
			keyval := strings.Split(part, "=")
			cc[strings.Trim(keyval[0], " ")] = strings.Trim(keyval[1], ",")
		} else {
			cc[part] = ""
		}
	}
	return cc
}

// CacheExpires helper function to determine remaining time before repeating a request.
func CacheExpires(r *http.Response) time.Time {
	// Figure out when the cache expires.
	var expires time.Time
	now, err := time.Parse(time.RFC1123, r.Header.Get("date"))
	if err != nil {
		return time.Now()
	}
	respCacheControl := parseCacheControl(r.Header)

	if maxAge, ok := respCacheControl["max-age"]; ok {
		lifetime, err := time.ParseDuration(maxAge + "s")
		if err != nil {
			expires = now
		} else {
			expires = now.Add(lifetime)
		}
	} else {
		expiresHeader := r.Header.Get("Expires")
		if expiresHeader != "" {
			expires, err = time.Parse(time.RFC1123, expiresHeader)
			if err != nil {
				expires = now
			}
		}
	}
	return expires
}

func strlen(s string) int {
	return utf8.RuneCountInString(s)
}

// GenericOpenAPIError Provides access to the body, error and model on returned errors.
type GenericOpenAPIError struct {
	body  []byte
	error string
	model interface{}
}

// Error returns non-empty string if there was an error.
func (e GenericOpenAPIError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e GenericOpenAPIError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e GenericOpenAPIError) Model() interface{} {
	return e.model
}

// FgaApiAuthenticationError is raised when API has errors due to invalid authentication
type FgaApiAuthenticationError struct {
	body  []byte
	error string
	model interface{}

	storeId            string
	endpointCategory   string
	modelDecodeError   error
	responseStatusCode int
	responseHeader     http.Header
	requestId          string
	responseCode       string
}

// Error returns non-empty string if there was an error.
func (e FgaApiAuthenticationError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e FgaApiAuthenticationError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e FgaApiAuthenticationError) Model() interface{} {
	return e.model
}

// StoreId returns the store ID for the API that causes the error
func (e FgaApiAuthenticationError) StoreId() string {
	return e.storeId
}

// EndpointCategory returns the original API category
func (e FgaApiAuthenticationError) EndpointCategory() string {
	return e.endpointCategory
}

// ModelDecodeError returns any error when decoding the unpacked model of the error
func (e FgaApiAuthenticationError) ModelDecodeError() error {
	return e.modelDecodeError
}

// ResponseStatusCode returns the original API response status HTTP code
func (e FgaApiAuthenticationError) ResponseStatusCode() int {
	return e.responseStatusCode
}

// ResponseHeader returns the original API response header
func (e FgaApiAuthenticationError) ResponseHeader() http.Header {
	return e.responseHeader
}

// RequestId returns the FGA request ID associated with the response
func (e FgaApiAuthenticationError) RequestId() string {
	return e.requestId
}

// ResponseCode returns response code
func (e FgaApiAuthenticationError) ResponseCode() string {
	return e.responseCode
}

// FgaApiError will be returned if there are errors in the API

type FgaApiError struct {
	body  []byte
	error string
	model interface{}

	storeId            string
	endpointCategory   string
	requestBody        interface{}
	requestMethod      string
	modelDecodeError   error
	responseStatusCode int
	responseHeader     http.Header
	requestId          string
	responseCode       string
}

// Error returns non-empty string if there was an error.
func (e FgaApiError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e FgaApiError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e FgaApiError) Model() interface{} {
	return e.model
}

// StoreId returns the store ID for the API that causes the error
func (e FgaApiError) StoreId() string {
	return e.storeId
}

// RequestBody returns the original request body
func (e FgaApiError) RequestBody() interface{} {
	return e.requestBody
}

// RequestMethod returns the method calling the API
func (e FgaApiError) RequestMethod() string {
	return e.requestMethod
}

// EndpointCategory returns the original API category
func (e FgaApiError) EndpointCategory() string {
	return e.endpointCategory
}

// ModelDecodeError returns any error when decoding the unpacked model of the error
func (e FgaApiError) ModelDecodeError() error {
	return e.modelDecodeError
}

// ResponseStatusCode returns the original API response HTTP status code
func (e FgaApiError) ResponseStatusCode() int {
	return e.responseStatusCode
}

// ResponseHeader returns the original API response header
func (e FgaApiError) ResponseHeader() http.Header {
	return e.responseHeader
}

// RequestId returns the FGA request ID associated with the response
func (e FgaApiError) RequestId() string {
	return e.requestId
}

// ResponseCode returns response code
func (e FgaApiError) ResponseCode() string {
	return e.responseCode
}

// FgaApiValidationError will be returned if there are errors in the API's parameters

type FgaApiValidationError struct {
	body  []byte
	error string
	model interface{}

	storeId            string
	endpointCategory   string
	requestBody        interface{}
	requestMethod      string
	modelDecodeError   error
	responseStatusCode int
	responseHeader     http.Header
	requestId          string
	responseCode       ErrorCode
}

// Error returns non-empty string if there was an error.
func (e FgaApiValidationError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e FgaApiValidationError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e FgaApiValidationError) Model() interface{} {
	return e.model
}

// StoreId returns the store ID for the API that causes the error
func (e FgaApiValidationError) StoreId() string {
	return e.storeId
}

// RequestBody returns the original request body
func (e FgaApiValidationError) RequestBody() interface{} {
	return e.requestBody
}

// RequestMethod returns the method calling the API
func (e FgaApiValidationError) RequestMethod() string {
	return e.requestMethod
}

// EndpointCategory returns the original API category
func (e FgaApiValidationError) EndpointCategory() string {
	return e.endpointCategory
}

// ModelDecodeError returns any error when decoding the unpacked model of the error
func (e FgaApiValidationError) ModelDecodeError() error {
	return e.modelDecodeError
}

// ResponseStatusCode returns the original API response HTTP status code
func (e FgaApiValidationError) ResponseStatusCode() int {
	return e.responseStatusCode
}

// ResponseHeader returns the original API response header
func (e FgaApiValidationError) ResponseHeader() http.Header {
	return e.responseHeader
}

// RequestId returns the FGA request ID associated with the response
func (e FgaApiValidationError) RequestId() string {
	return e.requestId
}

// ResponseCode returns response code
func (e FgaApiValidationError) ResponseCode() ErrorCode {
	return e.responseCode
}

// FgaApiNotFoundError will be returned if the endpoint cannot be found

type FgaApiNotFoundError struct {
	body  []byte
	error string
	model interface{}

	storeId            string
	endpointCategory   string
	requestBody        interface{}
	requestMethod      string
	modelDecodeError   error
	responseStatusCode int
	responseHeader     http.Header
	requestId          string
	responseCode       NotFoundErrorCode
}

// Error returns non-empty string if there was an error.
func (e FgaApiNotFoundError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e FgaApiNotFoundError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e FgaApiNotFoundError) Model() interface{} {
	return e.model
}

// StoreId returns the store ID for the API that causes the error
func (e FgaApiNotFoundError) StoreId() string {
	return e.storeId
}

// RequestBody returns the original request body
func (e FgaApiNotFoundError) RequestBody() interface{} {
	return e.requestBody
}

// RequestMethod returns the method calling the API
func (e FgaApiNotFoundError) RequestMethod() string {
	return e.requestMethod
}

// EndpointCategory returns the original API category
func (e FgaApiNotFoundError) EndpointCategory() string {
	return e.endpointCategory
}

// ModelDecodeError returns any error when decoding the unpacked model of the error
func (e FgaApiNotFoundError) ModelDecodeError() error {
	return e.modelDecodeError
}

// ResponseStatusCode returns the original API response HTTP status code
func (e FgaApiNotFoundError) ResponseStatusCode() int {
	return e.responseStatusCode
}

// ResponseHeader returns the original API response header
func (e FgaApiNotFoundError) ResponseHeader() http.Header {
	return e.responseHeader
}

// RequestId returns the FGA request ID associated with the response
func (e FgaApiNotFoundError) RequestId() string {
	return e.requestId
}

// ResponseCode returns response code
func (e FgaApiNotFoundError) ResponseCode() NotFoundErrorCode {
	return e.responseCode
}

// FgaApiInternalError will be returned if there are internal errors in OpenFGA

type FgaApiInternalError struct {
	body  []byte
	error string
	model interface{}

	storeId            string
	endpointCategory   string
	requestBody        interface{}
	requestMethod      string
	modelDecodeError   error
	responseStatusCode int
	responseHeader     http.Header
	requestId          string
	responseCode       InternalErrorCode
}

// Error returns non-empty string if there was an error.
func (e FgaApiInternalError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e FgaApiInternalError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e FgaApiInternalError) Model() interface{} {
	return e.model
}

// StoreId returns the store ID for the API that causes the error
func (e FgaApiInternalError) StoreId() string {
	return e.storeId
}

// RequestBody returns the original request body
func (e FgaApiInternalError) RequestBody() interface{} {
	return e.requestBody
}

// RequestMethod returns the method calling the API
func (e FgaApiInternalError) RequestMethod() string {
	return e.requestMethod
}

// EndpointCategory returns the original API category
func (e FgaApiInternalError) EndpointCategory() string {
	return e.endpointCategory
}

// ModelDecodeError returns any error when decoding the unpacked model of the error
func (e FgaApiInternalError) ModelDecodeError() error {
	return e.modelDecodeError
}

// ResponseStatusCode returns the original API response HTTP status code
func (e FgaApiInternalError) ResponseStatusCode() int {
	return e.responseStatusCode
}

// ResponseHeader returns the original API response header
func (e FgaApiInternalError) ResponseHeader() http.Header {
	return e.responseHeader
}

// RequestId returns the FGA request ID associated with the response
func (e FgaApiInternalError) RequestId() string {
	return e.requestId
}

// ResponseCode returns response code
func (e FgaApiInternalError) ResponseCode() InternalErrorCode {
	return e.responseCode
}

// FgaApiRateLimitExceededError will be returned if error happens because the API's rate limit has been exceeded (429 HTTP response)

type FgaApiRateLimitExceededError struct {
	body  []byte
	error string
	model interface{}

	storeId            string
	endpointCategory   string
	requestBody        interface{}
	requestMethod      string
	modelDecodeError   error
	responseStatusCode int
	responseHeader     http.Header
	requestId          string
	responseCode       string

	rateLimit           int
	rateUnit            string
	rateLimitResetEpoch string
}

// Error returns non-empty string if there was an error.
func (e FgaApiRateLimitExceededError) Error() string {
	return e.error
}

// Body returns the raw bytes of the response
func (e FgaApiRateLimitExceededError) Body() []byte {
	return e.body
}

// Model returns the unpacked model of the error
func (e FgaApiRateLimitExceededError) Model() interface{} {
	return e.model
}

// StoreId returns the store ID for the API that causes the error
func (e FgaApiRateLimitExceededError) StoreId() string {
	return e.storeId
}

// RequestBody returns the original request body
func (e FgaApiRateLimitExceededError) RequestBody() interface{} {
	return e.requestBody
}

// RequestMethod returns the method calling the API
func (e FgaApiRateLimitExceededError) RequestMethod() string {
	return e.requestMethod
}

// RateLimit returns the limit for the API
func (e FgaApiRateLimitExceededError) RateLimit() int {
	return e.rateLimit
}

// RateUnit returns the unit used for rate limit
func (e FgaApiRateLimitExceededError) RateUnit() string {
	return e.rateUnit
}

// RateLimitResetEpoch returns the unit used for rate limit
func (e FgaApiRateLimitExceededError) RateLimitResetEpoch() string {
	return e.rateLimitResetEpoch
}

// EndpointCategory returns the original API category
func (e FgaApiRateLimitExceededError) EndpointCategory() string {
	return e.endpointCategory
}

// ModelDecodeError returns any error when decoding the unpacked model of the error
func (e FgaApiRateLimitExceededError) ModelDecodeError() error {
	return e.modelDecodeError
}

// ResponseStatusCode returns the original API response HTTP status code
func (e FgaApiRateLimitExceededError) ResponseStatusCode() int {
	return e.responseStatusCode
}

// ResponseHeader returns the original API response header
func (e FgaApiRateLimitExceededError) ResponseHeader() http.Header {
	return e.responseHeader
}

// RequestId returns the FGA request ID associated with the response
func (e FgaApiRateLimitExceededError) RequestId() string {
	return e.requestId
}

// ResponseCode returns response code
func (e FgaApiRateLimitExceededError) ResponseCode() string {
	return e.responseCode
}
