/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.performance.fixture

import spock.lang.Specification

class UnitsTest extends Specification {
    def "can compare units of same quantity"() {
        def base = Units.base(Void.class, "base")
        def units1 = base.times(12, "units1")
        def units2 = base.times(33, "units2")

        expect:
        base < units1
        base < units2
        units1 > base
        units1 < units2
        units2 > base
        units2 > units1
    }
}
