/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.jvm.test;

import org.gradle.api.Incubating;
import org.gradle.jvm.JvmComponentSpec;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.testing.base.TestSuiteSpec;

/**
 * Base type for all JVM test suites.
 *
 * @since 2.11
 */
@Incubating
public interface JvmTestSuiteSpec extends TestSuiteSpec, JvmComponentSpec {
    /**
     * The set of dependencies applicable to the entire test suite.
     */
    DependencySpecContainer getDependencies();

    @Override
    JvmComponentSpec getTestedComponent();
}
