/*
 * jaZip for Linux  (c) 1996  Jarrod A. Smith
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#ifndef FD_jazip_h_
#define FD_jazip_h_

/* define some constants for the dtype variable */
#define ZIP				1
#define JAZ				2

#define IOMEGA_FSTAB	"/etc/jazip.conf"
#define LOCK_FILE		"/etc/mtab~"
#define DOCDIR			"/usr/doc/jaZip-0.34"  /* this should match the makefile */

/* define a few things to help with deciphering menu selections */
#define FILE_EXIT		1

#define TOOLS_INFO	1
#define TOOLS_MOUNT	2
#define TOOLS_UMOUNT	3
#define TOOLS_EJECT	4
#define TOOLS_RO		5
#define TOOLS_RW		6

#define HELP_ABOUT	1
#define HELP_HELP		2

/* I need a few globals to help with interacting between forms and callbacks */
char	dev[32], mesg[256];
char	mnt_dir[512], mnt_type[64], mnt_fsname[64];
int	dtype, conf;

/* The rest of this header file generated with fdesign. */

/**** Callback routines ****/

extern void file(FL_OBJECT *, long);
extern void tools(FL_OBJECT *, long);
extern void help(FL_OBJECT *, long);
extern void iomega_info(FL_OBJECT *, long);
extern void mount_it(FL_OBJECT *, long);
extern void umount_it(FL_OBJECT *, long);
extern void eject_it(FL_OBJECT *, long);
extern void ro_it(FL_OBJECT *, long);
extern void rw_it(FL_OBJECT *, long);
extern void quit_it(FL_OBJECT *, long);


/**** Forms and Objects ****/

typedef struct {
	FL_FORM *jazip;
	FL_OBJECT *msg_browser;
	FL_OBJECT *info;
	FL_OBJECT *mount_z;
	FL_OBJECT *umount_z;
	FL_OBJECT *eject_z;
	FL_OBJECT *quit;
	FL_OBJECT *ro_z;
	FL_OBJECT *rw_z;
	FL_OBJECT *jazip_xpm;
	FL_OBJECT *little_i_xpm;
	FL_OBJECT *help_menu;
	FL_OBJECT *file_menu;
	FL_OBJECT *tools_menu;
	void *vdata;
	long ldata;
} FD_jazip;

extern FD_jazip * create_form_jazip(void);

#endif /* FD_jazip_h_ */
