
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSaveFile.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSaveFile>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSaveFile

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSaveFile::staticMetaObject);
}


// void QSaveFile::cancelWriting()


static void _init_f_cancelWriting_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cancelWriting_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile *)cls)->cancelWriting ();
}


// bool QSaveFile::commit()


static void _init_f_commit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_commit_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSaveFile *)cls)->commit ());
}


// bool QSaveFile::directWriteFallback()


static void _init_f_directWriteFallback_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_directWriteFallback_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSaveFile *)cls)->directWriteFallback ());
}


// QString QSaveFile::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSaveFile *)cls)->fileName ());
}


// bool QSaveFile::open(QFlags<QIODevice::OpenModeFlag> flags)


static void _init_f_open_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_open_3242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap);
  ret.write<bool > ((bool)((QSaveFile *)cls)->open (arg1));
}


// void QSaveFile::setDirectWriteFallback(bool enabled)


static void _init_f_setDirectWriteFallback_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectWriteFallback_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile *)cls)->setDirectWriteFallback (arg1);
}


// void QSaveFile::setFileName(const QString &name)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile *)cls)->setFileName (arg1);
}


// static QString QSaveFile::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSaveFile::tr (arg1, arg2, arg3));
}


// static QString QSaveFile::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSaveFile::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSaveFile () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("cancelWriting", "@brief Method void QSaveFile::cancelWriting()\n", false, &_init_f_cancelWriting_0, &_call_f_cancelWriting_0);
  methods += new qt_gsi::GenericMethod ("commit", "@brief Method bool QSaveFile::commit()\n", false, &_init_f_commit_0, &_call_f_commit_0);
  methods += new qt_gsi::GenericMethod (":directWriteFallback", "@brief Method bool QSaveFile::directWriteFallback()\n", true, &_init_f_directWriteFallback_c0, &_call_f_directWriteFallback_c0);
  methods += new qt_gsi::GenericMethod (":fileName", "@brief Method QString QSaveFile::fileName()\nThis is a reimplementation of QFileDevice::fileName", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method bool QSaveFile::open(QFlags<QIODevice::OpenModeFlag> flags)\nThis is a reimplementation of QIODevice::open", false, &_init_f_open_3242, &_call_f_open_3242);
  methods += new qt_gsi::GenericMethod ("setDirectWriteFallback|directWriteFallback=", "@brief Method void QSaveFile::setDirectWriteFallback(bool enabled)\n", false, &_init_f_setDirectWriteFallback_864, &_call_f_setDirectWriteFallback_864);
  methods += new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QSaveFile::setFileName(const QString &name)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
  methods += gsi::qt_signal ("aboutToClose()", "aboutToClose", "@brief Signal declaration for QSaveFile::aboutToClose()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("bytesWritten(qint64)", "bytesWritten", gsi::arg("bytes"), "@brief Signal declaration for QSaveFile::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSaveFile::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readChannelFinished()", "readChannelFinished", "@brief Signal declaration for QSaveFile::readChannelFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QSaveFile::readyRead()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSaveFile::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSaveFile::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QFileDevice> &qtdecl_QFileDevice ();

qt_gsi::QtNativeClass<QSaveFile> decl_QSaveFile (qtdecl_QFileDevice (), "QtCore", "QSaveFile_Native",
  methods_QSaveFile (),
  "@hide\n@alias QSaveFile");

GSI_QTCORE_PUBLIC gsi::Class<QSaveFile> &qtdecl_QSaveFile () { return decl_QSaveFile; }

}


class QSaveFile_Adaptor : public QSaveFile, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSaveFile_Adaptor();

  //  [adaptor ctor] QSaveFile::QSaveFile(const QString &name)
  QSaveFile_Adaptor(const QString &name) : QSaveFile(name)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSaveFile::QSaveFile(QObject *parent)
  QSaveFile_Adaptor() : QSaveFile()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSaveFile::QSaveFile(QObject *parent)
  QSaveFile_Adaptor(QObject *parent) : QSaveFile(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSaveFile::QSaveFile(const QString &name, QObject *parent)
  QSaveFile_Adaptor(const QString &name, QObject *parent) : QSaveFile(name, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QSaveFile::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSaveFile_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSaveFile::isSignalConnected(signal);
  }

  //  [expose] int QSaveFile::receivers(const char *signal)
  int fp_QSaveFile_receivers_c1731 (const char *signal) const {
    return QSaveFile::receivers(signal);
  }

  //  [expose] QObject *QSaveFile::sender()
  QObject * fp_QSaveFile_sender_c0 () const {
    return QSaveFile::sender();
  }

  //  [expose] int QSaveFile::senderSignalIndex()
  int fp_QSaveFile_senderSignalIndex_c0 () const {
    return QSaveFile::senderSignalIndex();
  }

  //  [expose] void QSaveFile::setErrorString(const QString &errorString)
  void fp_QSaveFile_setErrorString_2025 (const QString &errorString) {
    QSaveFile::setErrorString(errorString);
  }

  //  [expose] void QSaveFile::setOpenMode(QFlags<QIODevice::OpenModeFlag> openMode)
  void fp_QSaveFile_setOpenMode_3242 (QFlags<QIODevice::OpenModeFlag> openMode) {
    QSaveFile::setOpenMode(openMode);
  }

  //  [emitter impl] void QSaveFile::aboutToClose()
  void emitter_QSaveFile_aboutToClose_0()
  {
    emit QSaveFile::aboutToClose();
  }

  //  [adaptor impl] bool QSaveFile::atEnd()
  bool cbs_atEnd_c0_0() const
  {
    return QSaveFile::atEnd();
  }

  virtual bool atEnd() const
  {
    if (cb_atEnd_c0_0.can_issue()) {
      return cb_atEnd_c0_0.issue<QSaveFile_Adaptor, bool>(&QSaveFile_Adaptor::cbs_atEnd_c0_0);
    } else {
      return QSaveFile::atEnd();
    }
  }

  //  [adaptor impl] qint64 QSaveFile::bytesAvailable()
  qint64 cbs_bytesAvailable_c0_0() const
  {
    return QSaveFile::bytesAvailable();
  }

  virtual qint64 bytesAvailable() const
  {
    if (cb_bytesAvailable_c0_0.can_issue()) {
      return cb_bytesAvailable_c0_0.issue<QSaveFile_Adaptor, qint64>(&QSaveFile_Adaptor::cbs_bytesAvailable_c0_0);
    } else {
      return QSaveFile::bytesAvailable();
    }
  }

  //  [adaptor impl] qint64 QSaveFile::bytesToWrite()
  qint64 cbs_bytesToWrite_c0_0() const
  {
    return QSaveFile::bytesToWrite();
  }

  virtual qint64 bytesToWrite() const
  {
    if (cb_bytesToWrite_c0_0.can_issue()) {
      return cb_bytesToWrite_c0_0.issue<QSaveFile_Adaptor, qint64>(&QSaveFile_Adaptor::cbs_bytesToWrite_c0_0);
    } else {
      return QSaveFile::bytesToWrite();
    }
  }

  //  [emitter impl] void QSaveFile::bytesWritten(qint64 bytes)
  void emitter_QSaveFile_bytesWritten_986(qint64 bytes)
  {
    emit QSaveFile::bytesWritten(bytes);
  }

  //  [adaptor impl] bool QSaveFile::canReadLine()
  bool cbs_canReadLine_c0_0() const
  {
    return QSaveFile::canReadLine();
  }

  virtual bool canReadLine() const
  {
    if (cb_canReadLine_c0_0.can_issue()) {
      return cb_canReadLine_c0_0.issue<QSaveFile_Adaptor, bool>(&QSaveFile_Adaptor::cbs_canReadLine_c0_0);
    } else {
      return QSaveFile::canReadLine();
    }
  }

  //  [emitter impl] void QSaveFile::destroyed(QObject *)
  void emitter_QSaveFile_destroyed_1302(QObject *arg1)
  {
    emit QSaveFile::destroyed(arg1);
  }

  //  [adaptor impl] bool QSaveFile::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSaveFile::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSaveFile_Adaptor, bool, QEvent *>(&QSaveFile_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSaveFile::event(arg1);
    }
  }

  //  [adaptor impl] bool QSaveFile::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSaveFile::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSaveFile_Adaptor, bool, QObject *, QEvent *>(&QSaveFile_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSaveFile::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QString QSaveFile::fileName()
  QString cbs_fileName_c0_0() const
  {
    return QSaveFile::fileName();
  }

  virtual QString fileName() const
  {
    if (cb_fileName_c0_0.can_issue()) {
      return cb_fileName_c0_0.issue<QSaveFile_Adaptor, QString>(&QSaveFile_Adaptor::cbs_fileName_c0_0);
    } else {
      return QSaveFile::fileName();
    }
  }

  //  [adaptor impl] bool QSaveFile::isSequential()
  bool cbs_isSequential_c0_0() const
  {
    return QSaveFile::isSequential();
  }

  virtual bool isSequential() const
  {
    if (cb_isSequential_c0_0.can_issue()) {
      return cb_isSequential_c0_0.issue<QSaveFile_Adaptor, bool>(&QSaveFile_Adaptor::cbs_isSequential_c0_0);
    } else {
      return QSaveFile::isSequential();
    }
  }

  //  [adaptor impl] bool QSaveFile::open(QFlags<QIODevice::OpenModeFlag> flags)
  bool cbs_open_3242_0(QFlags<QIODevice::OpenModeFlag> flags)
  {
    return QSaveFile::open(flags);
  }

  virtual bool open(QFlags<QIODevice::OpenModeFlag> flags)
  {
    if (cb_open_3242_0.can_issue()) {
      return cb_open_3242_0.issue<QSaveFile_Adaptor, bool, QFlags<QIODevice::OpenModeFlag> >(&QSaveFile_Adaptor::cbs_open_3242_0, flags);
    } else {
      return QSaveFile::open(flags);
    }
  }

  //  [adaptor impl] QFlags<QFileDevice::Permission> QSaveFile::permissions()
  QFlags<QFileDevice::Permission> cbs_permissions_c0_0() const
  {
    return QSaveFile::permissions();
  }

  virtual QFlags<QFileDevice::Permission> permissions() const
  {
    if (cb_permissions_c0_0.can_issue()) {
      return cb_permissions_c0_0.issue<QSaveFile_Adaptor, QFlags<QFileDevice::Permission> >(&QSaveFile_Adaptor::cbs_permissions_c0_0);
    } else {
      return QSaveFile::permissions();
    }
  }

  //  [adaptor impl] qint64 QSaveFile::pos()
  qint64 cbs_pos_c0_0() const
  {
    return QSaveFile::pos();
  }

  virtual qint64 pos() const
  {
    if (cb_pos_c0_0.can_issue()) {
      return cb_pos_c0_0.issue<QSaveFile_Adaptor, qint64>(&QSaveFile_Adaptor::cbs_pos_c0_0);
    } else {
      return QSaveFile::pos();
    }
  }

  //  [emitter impl] void QSaveFile::readChannelFinished()
  void emitter_QSaveFile_readChannelFinished_0()
  {
    emit QSaveFile::readChannelFinished();
  }

  //  [emitter impl] void QSaveFile::readyRead()
  void emitter_QSaveFile_readyRead_0()
  {
    emit QSaveFile::readyRead();
  }

  //  [adaptor impl] bool QSaveFile::reset()
  bool cbs_reset_0_0()
  {
    return QSaveFile::reset();
  }

  virtual bool reset()
  {
    if (cb_reset_0_0.can_issue()) {
      return cb_reset_0_0.issue<QSaveFile_Adaptor, bool>(&QSaveFile_Adaptor::cbs_reset_0_0);
    } else {
      return QSaveFile::reset();
    }
  }

  //  [adaptor impl] bool QSaveFile::resize(qint64 sz)
  bool cbs_resize_986_0(qint64 sz)
  {
    return QSaveFile::resize(sz);
  }

  virtual bool resize(qint64 sz)
  {
    if (cb_resize_986_0.can_issue()) {
      return cb_resize_986_0.issue<QSaveFile_Adaptor, bool, qint64>(&QSaveFile_Adaptor::cbs_resize_986_0, sz);
    } else {
      return QSaveFile::resize(sz);
    }
  }

  //  [adaptor impl] bool QSaveFile::seek(qint64 offset)
  bool cbs_seek_986_0(qint64 offset)
  {
    return QSaveFile::seek(offset);
  }

  virtual bool seek(qint64 offset)
  {
    if (cb_seek_986_0.can_issue()) {
      return cb_seek_986_0.issue<QSaveFile_Adaptor, bool, qint64>(&QSaveFile_Adaptor::cbs_seek_986_0, offset);
    } else {
      return QSaveFile::seek(offset);
    }
  }

  //  [adaptor impl] bool QSaveFile::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)
  bool cbs_setPermissions_3370_0(QFlags<QFileDevice::Permission> permissionSpec)
  {
    return QSaveFile::setPermissions(permissionSpec);
  }

  virtual bool setPermissions(QFlags<QFileDevice::Permission> permissionSpec)
  {
    if (cb_setPermissions_3370_0.can_issue()) {
      return cb_setPermissions_3370_0.issue<QSaveFile_Adaptor, bool, QFlags<QFileDevice::Permission> >(&QSaveFile_Adaptor::cbs_setPermissions_3370_0, permissionSpec);
    } else {
      return QSaveFile::setPermissions(permissionSpec);
    }
  }

  //  [adaptor impl] qint64 QSaveFile::size()
  qint64 cbs_size_c0_0() const
  {
    return QSaveFile::size();
  }

  virtual qint64 size() const
  {
    if (cb_size_c0_0.can_issue()) {
      return cb_size_c0_0.issue<QSaveFile_Adaptor, qint64>(&QSaveFile_Adaptor::cbs_size_c0_0);
    } else {
      return QSaveFile::size();
    }
  }

  //  [adaptor impl] bool QSaveFile::waitForBytesWritten(int msecs)
  bool cbs_waitForBytesWritten_767_0(int msecs)
  {
    return QSaveFile::waitForBytesWritten(msecs);
  }

  virtual bool waitForBytesWritten(int msecs)
  {
    if (cb_waitForBytesWritten_767_0.can_issue()) {
      return cb_waitForBytesWritten_767_0.issue<QSaveFile_Adaptor, bool, int>(&QSaveFile_Adaptor::cbs_waitForBytesWritten_767_0, msecs);
    } else {
      return QSaveFile::waitForBytesWritten(msecs);
    }
  }

  //  [adaptor impl] bool QSaveFile::waitForReadyRead(int msecs)
  bool cbs_waitForReadyRead_767_0(int msecs)
  {
    return QSaveFile::waitForReadyRead(msecs);
  }

  virtual bool waitForReadyRead(int msecs)
  {
    if (cb_waitForReadyRead_767_0.can_issue()) {
      return cb_waitForReadyRead_767_0.issue<QSaveFile_Adaptor, bool, int>(&QSaveFile_Adaptor::cbs_waitForReadyRead_767_0, msecs);
    } else {
      return QSaveFile::waitForReadyRead(msecs);
    }
  }

  //  [adaptor impl] void QSaveFile::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSaveFile::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSaveFile_Adaptor, QChildEvent *>(&QSaveFile_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSaveFile::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSaveFile::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSaveFile::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSaveFile_Adaptor, QEvent *>(&QSaveFile_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSaveFile::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSaveFile::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSaveFile::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSaveFile_Adaptor, const QMetaMethod &>(&QSaveFile_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSaveFile::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSaveFile::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSaveFile::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSaveFile_Adaptor, QTimerEvent *>(&QSaveFile_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSaveFile::timerEvent(arg1);
    }
  }

  //  [adaptor impl] qint64 QSaveFile::writeData(const char *data, qint64 len)
  qint64 cbs_writeData_2609_0(const char *data, qint64 len)
  {
    return QSaveFile::writeData(data, len);
  }

  virtual qint64 writeData(const char *data, qint64 len)
  {
    if (cb_writeData_2609_0.can_issue()) {
      return cb_writeData_2609_0.issue<QSaveFile_Adaptor, qint64, const char *, qint64>(&QSaveFile_Adaptor::cbs_writeData_2609_0, data, len);
    } else {
      return QSaveFile::writeData(data, len);
    }
  }

  gsi::Callback cb_atEnd_c0_0;
  gsi::Callback cb_bytesAvailable_c0_0;
  gsi::Callback cb_bytesToWrite_c0_0;
  gsi::Callback cb_canReadLine_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fileName_c0_0;
  gsi::Callback cb_isSequential_c0_0;
  gsi::Callback cb_open_3242_0;
  gsi::Callback cb_permissions_c0_0;
  gsi::Callback cb_pos_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_resize_986_0;
  gsi::Callback cb_seek_986_0;
  gsi::Callback cb_setPermissions_3370_0;
  gsi::Callback cb_size_c0_0;
  gsi::Callback cb_waitForBytesWritten_767_0;
  gsi::Callback cb_waitForReadyRead_767_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_writeData_2609_0;
};

QSaveFile_Adaptor::~QSaveFile_Adaptor() { }

//  Constructor QSaveFile::QSaveFile(const QString &name) (adaptor class)

static void _init_ctor_QSaveFile_Adaptor_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QSaveFile_Adaptor> ();
}

static void _call_ctor_QSaveFile_Adaptor_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QSaveFile_Adaptor *> (new QSaveFile_Adaptor (arg1));
}


//  Constructor QSaveFile::QSaveFile(QObject *parent) (adaptor class)

static void _init_ctor_QSaveFile_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSaveFile_Adaptor> ();
}

static void _call_ctor_QSaveFile_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSaveFile_Adaptor *> (new QSaveFile_Adaptor (arg1));
}


//  Constructor QSaveFile::QSaveFile(const QString &name, QObject *parent) (adaptor class)

static void _init_ctor_QSaveFile_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QSaveFile_Adaptor> ();
}

static void _call_ctor_QSaveFile_Adaptor_3219 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QObject *arg2 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QSaveFile_Adaptor *> (new QSaveFile_Adaptor (arg1, arg2));
}


// emitter void QSaveFile::aboutToClose()

static void _init_emitter_aboutToClose_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToClose_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSaveFile_Adaptor *)cls)->emitter_QSaveFile_aboutToClose_0 ();
}


// bool QSaveFile::atEnd()

static void _init_cbs_atEnd_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_atEnd_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_atEnd_c0_0 ());
}

static void _set_callback_cbs_atEnd_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_atEnd_c0_0 = cb;
}


// qint64 QSaveFile::bytesAvailable()

static void _init_cbs_bytesAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_bytesAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSaveFile_Adaptor *)cls)->cbs_bytesAvailable_c0_0 ());
}

static void _set_callback_cbs_bytesAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_bytesAvailable_c0_0 = cb;
}


// qint64 QSaveFile::bytesToWrite()

static void _init_cbs_bytesToWrite_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_bytesToWrite_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSaveFile_Adaptor *)cls)->cbs_bytesToWrite_c0_0 ());
}

static void _set_callback_cbs_bytesToWrite_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_bytesToWrite_c0_0 = cb;
}


// emitter void QSaveFile::bytesWritten(qint64 bytes)

static void _init_emitter_bytesWritten_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("bytes");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bytesWritten_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QSaveFile_Adaptor *)cls)->emitter_QSaveFile_bytesWritten_986 (arg1);
}


// bool QSaveFile::canReadLine()

static void _init_cbs_canReadLine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_canReadLine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_canReadLine_c0_0 ());
}

static void _set_callback_cbs_canReadLine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_canReadLine_c0_0 = cb;
}


// void QSaveFile::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSaveFile::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QSaveFile::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QSaveFile_Adaptor *)cls)->emitter_QSaveFile_destroyed_1302 (arg1);
}


// void QSaveFile::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QSaveFile::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSaveFile::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QString QSaveFile::fileName()

static void _init_cbs_fileName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_fileName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSaveFile_Adaptor *)cls)->cbs_fileName_c0_0 ());
}

static void _set_callback_cbs_fileName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_fileName_c0_0 = cb;
}


// bool QSaveFile::isSequential()

static void _init_cbs_isSequential_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isSequential_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_isSequential_c0_0 ());
}

static void _set_callback_cbs_isSequential_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_isSequential_c0_0 = cb;
}


// exposed bool QSaveFile::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->fp_QSaveFile_isSignalConnected_c2394 (arg1));
}


// bool QSaveFile::open(QFlags<QIODevice::OpenModeFlag> flags)

static void _init_cbs_open_3242_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_open_3242_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = args.read<QFlags<QIODevice::OpenModeFlag> > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_open_3242_0 (arg1));
}

static void _set_callback_cbs_open_3242_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_open_3242_0 = cb;
}


// QFlags<QFileDevice::Permission> QSaveFile::permissions()

static void _init_cbs_permissions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QFileDevice::Permission> > ();
}

static void _call_cbs_permissions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QFileDevice::Permission> > ((QFlags<QFileDevice::Permission>)((QSaveFile_Adaptor *)cls)->cbs_permissions_c0_0 ());
}

static void _set_callback_cbs_permissions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_permissions_c0_0 = cb;
}


// qint64 QSaveFile::pos()

static void _init_cbs_pos_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_pos_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSaveFile_Adaptor *)cls)->cbs_pos_c0_0 ());
}

static void _set_callback_cbs_pos_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_pos_c0_0 = cb;
}


// emitter void QSaveFile::readChannelFinished()

static void _init_emitter_readChannelFinished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_readChannelFinished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSaveFile_Adaptor *)cls)->emitter_QSaveFile_readChannelFinished_0 ();
}


// emitter void QSaveFile::readyRead()

static void _init_emitter_readyRead_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_readyRead_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSaveFile_Adaptor *)cls)->emitter_QSaveFile_readyRead_0 ();
}


// exposed int QSaveFile::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSaveFile_Adaptor *)cls)->fp_QSaveFile_receivers_c1731 (arg1));
}


// bool QSaveFile::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_reset_0_0 ());
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// bool QSaveFile::resize(qint64 sz)

static void _init_cbs_resize_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sz");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_resize_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_resize_986_0 (arg1));
}

static void _set_callback_cbs_resize_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_resize_986_0 = cb;
}


// bool QSaveFile::seek(qint64 offset)

static void _init_cbs_seek_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_seek_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_seek_986_0 (arg1));
}

static void _set_callback_cbs_seek_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_seek_986_0 = cb;
}


// exposed QObject *QSaveFile::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSaveFile_Adaptor *)cls)->fp_QSaveFile_sender_c0 ());
}


// exposed int QSaveFile::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSaveFile_Adaptor *)cls)->fp_QSaveFile_senderSignalIndex_c0 ());
}


// exposed void QSaveFile::setErrorString(const QString &errorString)

static void _init_fp_setErrorString_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("errorString");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setErrorString_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile_Adaptor *)cls)->fp_QSaveFile_setErrorString_2025 (arg1);
}


// exposed void QSaveFile::setOpenMode(QFlags<QIODevice::OpenModeFlag> openMode)

static void _init_fp_setOpenMode_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("openMode");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOpenMode_3242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile_Adaptor *)cls)->fp_QSaveFile_setOpenMode_3242 (arg1);
}


// bool QSaveFile::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)

static void _init_cbs_setPermissions_3370_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("permissionSpec");
  decl->add_arg<QFlags<QFileDevice::Permission> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setPermissions_3370_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QFileDevice::Permission> arg1 = args.read<QFlags<QFileDevice::Permission> > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_setPermissions_3370_0 (arg1));
}

static void _set_callback_cbs_setPermissions_3370_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_setPermissions_3370_0 = cb;
}


// qint64 QSaveFile::size()

static void _init_cbs_size_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_size_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSaveFile_Adaptor *)cls)->cbs_size_c0_0 ());
}

static void _set_callback_cbs_size_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_size_c0_0 = cb;
}


// void QSaveFile::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSaveFile_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// bool QSaveFile::waitForBytesWritten(int msecs)

static void _init_cbs_waitForBytesWritten_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_waitForBytesWritten_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_waitForBytesWritten_767_0 (arg1));
}

static void _set_callback_cbs_waitForBytesWritten_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_waitForBytesWritten_767_0 = cb;
}


// bool QSaveFile::waitForReadyRead(int msecs)

static void _init_cbs_waitForReadyRead_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_waitForReadyRead_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSaveFile_Adaptor *)cls)->cbs_waitForReadyRead_767_0 (arg1));
}

static void _set_callback_cbs_waitForReadyRead_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_waitForReadyRead_767_0 = cb;
}


// qint64 QSaveFile::writeData(const char *data, qint64 len)

static void _init_cbs_writeData_2609_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_cbs_writeData_2609_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  qint64 arg2 = args.read<qint64 > (heap);
  ret.write<qint64 > ((qint64)((QSaveFile_Adaptor *)cls)->cbs_writeData_2609_0 (arg1, arg2));
}

static void _set_callback_cbs_writeData_2609_0 (void *cls, const gsi::Callback &cb)
{
  ((QSaveFile_Adaptor *)cls)->cb_writeData_2609_0 = cb;
}


namespace gsi
{

gsi::Class<QSaveFile> &qtdecl_QSaveFile ();

static gsi::Methods methods_QSaveFile_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSaveFile::QSaveFile(const QString &name)\nThis method creates an object of class QSaveFile.", &_init_ctor_QSaveFile_Adaptor_2025, &_call_ctor_QSaveFile_Adaptor_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSaveFile::QSaveFile(QObject *parent)\nThis method creates an object of class QSaveFile.", &_init_ctor_QSaveFile_Adaptor_1302, &_call_ctor_QSaveFile_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSaveFile::QSaveFile(const QString &name, QObject *parent)\nThis method creates an object of class QSaveFile.", &_init_ctor_QSaveFile_Adaptor_3219, &_call_ctor_QSaveFile_Adaptor_3219);
  methods += new qt_gsi::GenericMethod ("emit_aboutToClose", "@brief Emitter for signal void QSaveFile::aboutToClose()\nCall this method to emit this signal.", false, &_init_emitter_aboutToClose_0, &_call_emitter_aboutToClose_0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@hide", true, &_init_cbs_atEnd_c0_0, &_call_cbs_atEnd_c0_0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Virtual method bool QSaveFile::atEnd()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_atEnd_c0_0, &_call_cbs_atEnd_c0_0, &_set_callback_cbs_atEnd_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@hide", true, &_init_cbs_bytesAvailable_c0_0, &_call_cbs_bytesAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Virtual method qint64 QSaveFile::bytesAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bytesAvailable_c0_0, &_call_cbs_bytesAvailable_c0_0, &_set_callback_cbs_bytesAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@hide", true, &_init_cbs_bytesToWrite_c0_0, &_call_cbs_bytesToWrite_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@brief Virtual method qint64 QSaveFile::bytesToWrite()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bytesToWrite_c0_0, &_call_cbs_bytesToWrite_c0_0, &_set_callback_cbs_bytesToWrite_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_bytesWritten", "@brief Emitter for signal void QSaveFile::bytesWritten(qint64 bytes)\nCall this method to emit this signal.", false, &_init_emitter_bytesWritten_986, &_call_emitter_bytesWritten_986);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@hide", true, &_init_cbs_canReadLine_c0_0, &_call_cbs_canReadLine_c0_0);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@brief Virtual method bool QSaveFile::canReadLine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canReadLine_c0_0, &_call_cbs_canReadLine_c0_0, &_set_callback_cbs_canReadLine_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSaveFile::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSaveFile::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSaveFile::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSaveFile::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSaveFile::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSaveFile::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fileName", "@hide", true, &_init_cbs_fileName_c0_0, &_call_cbs_fileName_c0_0);
  methods += new qt_gsi::GenericMethod ("fileName", "@brief Virtual method QString QSaveFile::fileName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_fileName_c0_0, &_call_cbs_fileName_c0_0, &_set_callback_cbs_fileName_c0_0);
  methods += new qt_gsi::GenericMethod ("isSequential", "@hide", true, &_init_cbs_isSequential_c0_0, &_call_cbs_isSequential_c0_0);
  methods += new qt_gsi::GenericMethod ("isSequential", "@brief Virtual method bool QSaveFile::isSequential()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isSequential_c0_0, &_call_cbs_isSequential_c0_0, &_set_callback_cbs_isSequential_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSaveFile::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("open", "@hide", false, &_init_cbs_open_3242_0, &_call_cbs_open_3242_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Virtual method bool QSaveFile::open(QFlags<QIODevice::OpenModeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_open_3242_0, &_call_cbs_open_3242_0, &_set_callback_cbs_open_3242_0);
  methods += new qt_gsi::GenericMethod ("permissions", "@hide", true, &_init_cbs_permissions_c0_0, &_call_cbs_permissions_c0_0);
  methods += new qt_gsi::GenericMethod ("permissions", "@brief Virtual method QFlags<QFileDevice::Permission> QSaveFile::permissions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_permissions_c0_0, &_call_cbs_permissions_c0_0, &_set_callback_cbs_permissions_c0_0);
  methods += new qt_gsi::GenericMethod ("pos", "@hide", true, &_init_cbs_pos_c0_0, &_call_cbs_pos_c0_0);
  methods += new qt_gsi::GenericMethod ("pos", "@brief Virtual method qint64 QSaveFile::pos()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pos_c0_0, &_call_cbs_pos_c0_0, &_set_callback_cbs_pos_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_readChannelFinished", "@brief Emitter for signal void QSaveFile::readChannelFinished()\nCall this method to emit this signal.", false, &_init_emitter_readChannelFinished_0, &_call_emitter_readChannelFinished_0);
  methods += new qt_gsi::GenericMethod ("emit_readyRead", "@brief Emitter for signal void QSaveFile::readyRead()\nCall this method to emit this signal.", false, &_init_emitter_readyRead_0, &_call_emitter_readyRead_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSaveFile::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method bool QSaveFile::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("resize", "@hide", false, &_init_cbs_resize_986_0, &_call_cbs_resize_986_0);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Virtual method bool QSaveFile::resize(qint64 sz)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resize_986_0, &_call_cbs_resize_986_0, &_set_callback_cbs_resize_986_0);
  methods += new qt_gsi::GenericMethod ("seek", "@hide", false, &_init_cbs_seek_986_0, &_call_cbs_seek_986_0);
  methods += new qt_gsi::GenericMethod ("seek", "@brief Virtual method bool QSaveFile::seek(qint64 offset)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_seek_986_0, &_call_cbs_seek_986_0, &_set_callback_cbs_seek_986_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSaveFile::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSaveFile::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setErrorString", "@brief Method void QSaveFile::setErrorString(const QString &errorString)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setErrorString_2025, &_call_fp_setErrorString_2025);
  methods += new qt_gsi::GenericMethod ("*setOpenMode", "@brief Method void QSaveFile::setOpenMode(QFlags<QIODevice::OpenModeFlag> openMode)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOpenMode_3242, &_call_fp_setOpenMode_3242);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@hide", false, &_init_cbs_setPermissions_3370_0, &_call_cbs_setPermissions_3370_0);
  methods += new qt_gsi::GenericMethod ("setPermissions", "@brief Virtual method bool QSaveFile::setPermissions(QFlags<QFileDevice::Permission> permissionSpec)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPermissions_3370_0, &_call_cbs_setPermissions_3370_0, &_set_callback_cbs_setPermissions_3370_0);
  methods += new qt_gsi::GenericMethod ("size", "@hide", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Virtual method qint64 QSaveFile::size()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0, &_set_callback_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSaveFile::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@hide", false, &_init_cbs_waitForBytesWritten_767_0, &_call_cbs_waitForBytesWritten_767_0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Virtual method bool QSaveFile::waitForBytesWritten(int msecs)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_waitForBytesWritten_767_0, &_call_cbs_waitForBytesWritten_767_0, &_set_callback_cbs_waitForBytesWritten_767_0);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@hide", false, &_init_cbs_waitForReadyRead_767_0, &_call_cbs_waitForReadyRead_767_0);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Virtual method bool QSaveFile::waitForReadyRead(int msecs)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_waitForReadyRead_767_0, &_call_cbs_waitForReadyRead_767_0, &_set_callback_cbs_waitForReadyRead_767_0);
  methods += new qt_gsi::GenericMethod ("*writeData", "@hide", false, &_init_cbs_writeData_2609_0, &_call_cbs_writeData_2609_0);
  methods += new qt_gsi::GenericMethod ("*writeData", "@brief Virtual method qint64 QSaveFile::writeData(const char *data, qint64 len)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_writeData_2609_0, &_call_cbs_writeData_2609_0, &_set_callback_cbs_writeData_2609_0);
  return methods;
}

gsi::Class<QSaveFile_Adaptor> decl_QSaveFile_Adaptor (qtdecl_QSaveFile (), "QtCore", "QSaveFile",
  methods_QSaveFile_Adaptor (),
  "@qt\n@brief Binding of QSaveFile");

}

