
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRadioDataControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRadioDataControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRadioDataControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRadioDataControl::staticMetaObject);
}


// QRadioData::Error QRadioDataControl::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::Error>::target_type > ((qt_gsi::Converter<QRadioData::Error>::target_type)qt_gsi::CppToQtAdaptor<QRadioData::Error>(((QRadioDataControl *)cls)->error ()));
}


// QString QRadioDataControl::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->errorString ());
}


// bool QRadioDataControl::isAlternativeFrequenciesEnabled()


static void _init_f_isAlternativeFrequenciesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAlternativeFrequenciesEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioDataControl *)cls)->isAlternativeFrequenciesEnabled ());
}


// QRadioData::ProgramType QRadioDataControl::programType()


static void _init_f_programType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ();
}

static void _call_f_programType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ((qt_gsi::Converter<QRadioData::ProgramType>::target_type)qt_gsi::CppToQtAdaptor<QRadioData::ProgramType>(((QRadioDataControl *)cls)->programType ()));
}


// QString QRadioDataControl::programTypeName()


static void _init_f_programTypeName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_programTypeName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->programTypeName ());
}


// QString QRadioDataControl::radioText()


static void _init_f_radioText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_radioText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->radioText ());
}


// void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)


static void _init_f_setAlternativeFrequenciesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlternativeFrequenciesEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl *)cls)->setAlternativeFrequenciesEnabled (arg1);
}


// QString QRadioDataControl::stationId()


static void _init_f_stationId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_stationId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->stationId ());
}


// QString QRadioDataControl::stationName()


static void _init_f_stationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_stationName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl *)cls)->stationName ());
}


// static QString QRadioDataControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioDataControl::tr (arg1, arg2, arg3));
}


// static QString QRadioDataControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioDataControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QRadioDataControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QRadioData::Error QRadioDataControl::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRadioDataControl::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled?|:alternativeFrequenciesEnabled", "@brief Method bool QRadioDataControl::isAlternativeFrequenciesEnabled()\n", true, &_init_f_isAlternativeFrequenciesEnabled_c0, &_call_f_isAlternativeFrequenciesEnabled_c0);
  methods += new qt_gsi::GenericMethod ("programType", "@brief Method QRadioData::ProgramType QRadioDataControl::programType()\n", true, &_init_f_programType_c0, &_call_f_programType_c0);
  methods += new qt_gsi::GenericMethod ("programTypeName", "@brief Method QString QRadioDataControl::programTypeName()\n", true, &_init_f_programTypeName_c0, &_call_f_programTypeName_c0);
  methods += new qt_gsi::GenericMethod ("radioText", "@brief Method QString QRadioDataControl::radioText()\n", true, &_init_f_radioText_c0, &_call_f_radioText_c0);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled|alternativeFrequenciesEnabled=", "@brief Method void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)\n", false, &_init_f_setAlternativeFrequenciesEnabled_864, &_call_f_setAlternativeFrequenciesEnabled_864);
  methods += new qt_gsi::GenericMethod ("stationId", "@brief Method QString QRadioDataControl::stationId()\n", true, &_init_f_stationId_c0, &_call_f_stationId_c0);
  methods += new qt_gsi::GenericMethod ("stationName", "@brief Method QString QRadioDataControl::stationName()\n", true, &_init_f_stationName_c0, &_call_f_stationName_c0);
  methods += gsi::qt_signal<bool > ("alternativeFrequenciesEnabledChanged(bool)", "alternativeFrequenciesEnabledChanged", gsi::arg("enabled"), "@brief Signal declaration for QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QRadioDataControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QRadioData::Error>::target_type & > ("error(QRadioData::Error)", "error_sig", gsi::arg("err"), "@brief Signal declaration for QRadioDataControl::error(QRadioData::Error err)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QRadioDataControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & > ("programTypeChanged(QRadioData::ProgramType)", "programTypeChanged", gsi::arg("programType"), "@brief Signal declaration for QRadioDataControl::programTypeChanged(QRadioData::ProgramType programType)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QString > ("programTypeNameChanged(QString)", "programTypeNameChanged", gsi::arg("programTypeName"), "@brief Signal declaration for QRadioDataControl::programTypeNameChanged(QString programTypeName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QString > ("radioTextChanged(QString)", "radioTextChanged", gsi::arg("radioText"), "@brief Signal declaration for QRadioDataControl::radioTextChanged(QString radioText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QString > ("stationIdChanged(QString)", "stationIdChanged", gsi::arg("stationId"), "@brief Signal declaration for QRadioDataControl::stationIdChanged(QString stationId)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QString > ("stationNameChanged(QString)", "stationNameChanged", gsi::arg("stationName"), "@brief Signal declaration for QRadioDataControl::stationNameChanged(QString stationName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRadioDataControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRadioDataControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QRadioDataControl> decl_QRadioDataControl (qtdecl_QMediaControl (), "QtMultimedia", "QRadioDataControl_Native",
  methods_QRadioDataControl (),
  "@hide\n@alias QRadioDataControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QRadioDataControl> &qtdecl_QRadioDataControl () { return decl_QRadioDataControl; }

}


class QRadioDataControl_Adaptor : public QRadioDataControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRadioDataControl_Adaptor();

  //  [expose] bool QRadioDataControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRadioDataControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRadioDataControl::isSignalConnected(signal);
  }

  //  [expose] int QRadioDataControl::receivers(const char *signal)
  int fp_QRadioDataControl_receivers_c1731 (const char *signal) const {
    return QRadioDataControl::receivers(signal);
  }

  //  [expose] QObject *QRadioDataControl::sender()
  QObject * fp_QRadioDataControl_sender_c0 () const {
    return QRadioDataControl::sender();
  }

  //  [expose] int QRadioDataControl::senderSignalIndex()
  int fp_QRadioDataControl_senderSignalIndex_c0 () const {
    return QRadioDataControl::senderSignalIndex();
  }

  //  [emitter impl] void QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled)
  void emitter_QRadioDataControl_alternativeFrequenciesEnabledChanged_864(bool enabled)
  {
    emit QRadioDataControl::alternativeFrequenciesEnabledChanged(enabled);
  }

  //  [emitter impl] void QRadioDataControl::destroyed(QObject *)
  void emitter_QRadioDataControl_destroyed_1302(QObject *arg1)
  {
    emit QRadioDataControl::destroyed(arg1);
  }

  //  [adaptor impl] QRadioData::Error QRadioDataControl::error()
  qt_gsi::Converter<QRadioData::Error>::target_type cbs_error_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("error");
  }

  virtual QRadioData::Error error() const
  {
    if (cb_error_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioData::Error>(cb_error_c0_0.issue<QRadioDataControl_Adaptor, qt_gsi::Converter<QRadioData::Error>::target_type>(&QRadioDataControl_Adaptor::cbs_error_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("error");
    }
  }

  //  [emitter impl] void QRadioDataControl::error(QRadioData::Error err)
  void emitter_QRadioDataControl_error_2028(QRadioData::Error err)
  {
    emit QRadioDataControl::error(err);
  }

  //  [adaptor impl] QString QRadioDataControl::errorString()
  QString cbs_errorString_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("errorString");
  }

  virtual QString errorString() const
  {
    if (cb_errorString_c0_0.can_issue()) {
      return cb_errorString_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_errorString_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("errorString");
    }
  }

  //  [adaptor impl] bool QRadioDataControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QRadioDataControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRadioDataControl_Adaptor, bool, QEvent *>(&QRadioDataControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QRadioDataControl::event(_event);
    }
  }

  //  [adaptor impl] bool QRadioDataControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QRadioDataControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRadioDataControl_Adaptor, bool, QObject *, QEvent *>(&QRadioDataControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QRadioDataControl::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QRadioDataControl::isAlternativeFrequenciesEnabled()
  bool cbs_isAlternativeFrequenciesEnabled_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isAlternativeFrequenciesEnabled");
  }

  virtual bool isAlternativeFrequenciesEnabled() const
  {
    if (cb_isAlternativeFrequenciesEnabled_c0_0.can_issue()) {
      return cb_isAlternativeFrequenciesEnabled_c0_0.issue<QRadioDataControl_Adaptor, bool>(&QRadioDataControl_Adaptor::cbs_isAlternativeFrequenciesEnabled_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isAlternativeFrequenciesEnabled");
    }
  }

  //  [emitter impl] void QRadioDataControl::objectNameChanged(const QString &objectName)
  void emitter_QRadioDataControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QRadioDataControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QRadioData::ProgramType QRadioDataControl::programType()
  qt_gsi::Converter<QRadioData::ProgramType>::target_type cbs_programType_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("programType");
  }

  virtual QRadioData::ProgramType programType() const
  {
    if (cb_programType_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QRadioData::ProgramType>(cb_programType_c0_0.issue<QRadioDataControl_Adaptor, qt_gsi::Converter<QRadioData::ProgramType>::target_type>(&QRadioDataControl_Adaptor::cbs_programType_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("programType");
    }
  }

  //  [emitter impl] void QRadioDataControl::programTypeChanged(QRadioData::ProgramType programType)
  void emitter_QRadioDataControl_programTypeChanged_2652(QRadioData::ProgramType programType)
  {
    emit QRadioDataControl::programTypeChanged(programType);
  }

  //  [adaptor impl] QString QRadioDataControl::programTypeName()
  QString cbs_programTypeName_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("programTypeName");
  }

  virtual QString programTypeName() const
  {
    if (cb_programTypeName_c0_0.can_issue()) {
      return cb_programTypeName_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_programTypeName_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("programTypeName");
    }
  }

  //  [emitter impl] void QRadioDataControl::programTypeNameChanged(QString programTypeName)
  void emitter_QRadioDataControl_programTypeNameChanged_1148(QString programTypeName)
  {
    emit QRadioDataControl::programTypeNameChanged(programTypeName);
  }

  //  [adaptor impl] QString QRadioDataControl::radioText()
  QString cbs_radioText_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("radioText");
  }

  virtual QString radioText() const
  {
    if (cb_radioText_c0_0.can_issue()) {
      return cb_radioText_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_radioText_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("radioText");
    }
  }

  //  [emitter impl] void QRadioDataControl::radioTextChanged(QString radioText)
  void emitter_QRadioDataControl_radioTextChanged_1148(QString radioText)
  {
    emit QRadioDataControl::radioTextChanged(radioText);
  }

  //  [adaptor impl] void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)
  void cbs_setAlternativeFrequenciesEnabled_864_0(bool enabled)
  {
    __SUPPRESS_UNUSED_WARNING (enabled);
    throw qt_gsi::AbstractMethodCalledException("setAlternativeFrequenciesEnabled");
  }

  virtual void setAlternativeFrequenciesEnabled(bool enabled)
  {
    if (cb_setAlternativeFrequenciesEnabled_864_0.can_issue()) {
      cb_setAlternativeFrequenciesEnabled_864_0.issue<QRadioDataControl_Adaptor, bool>(&QRadioDataControl_Adaptor::cbs_setAlternativeFrequenciesEnabled_864_0, enabled);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setAlternativeFrequenciesEnabled");
    }
  }

  //  [adaptor impl] QString QRadioDataControl::stationId()
  QString cbs_stationId_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("stationId");
  }

  virtual QString stationId() const
  {
    if (cb_stationId_c0_0.can_issue()) {
      return cb_stationId_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_stationId_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stationId");
    }
  }

  //  [emitter impl] void QRadioDataControl::stationIdChanged(QString stationId)
  void emitter_QRadioDataControl_stationIdChanged_1148(QString stationId)
  {
    emit QRadioDataControl::stationIdChanged(stationId);
  }

  //  [adaptor impl] QString QRadioDataControl::stationName()
  QString cbs_stationName_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("stationName");
  }

  virtual QString stationName() const
  {
    if (cb_stationName_c0_0.can_issue()) {
      return cb_stationName_c0_0.issue<QRadioDataControl_Adaptor, QString>(&QRadioDataControl_Adaptor::cbs_stationName_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stationName");
    }
  }

  //  [emitter impl] void QRadioDataControl::stationNameChanged(QString stationName)
  void emitter_QRadioDataControl_stationNameChanged_1148(QString stationName)
  {
    emit QRadioDataControl::stationNameChanged(stationName);
  }

  //  [adaptor impl] void QRadioDataControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QRadioDataControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRadioDataControl_Adaptor, QChildEvent *>(&QRadioDataControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QRadioDataControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QRadioDataControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QRadioDataControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRadioDataControl_Adaptor, QEvent *>(&QRadioDataControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QRadioDataControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QRadioDataControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRadioDataControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRadioDataControl_Adaptor, const QMetaMethod &>(&QRadioDataControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRadioDataControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QRadioDataControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QRadioDataControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRadioDataControl_Adaptor, QTimerEvent *>(&QRadioDataControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QRadioDataControl::timerEvent(event);
    }
  }

  gsi::Callback cb_error_c0_0;
  gsi::Callback cb_errorString_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAlternativeFrequenciesEnabled_c0_0;
  gsi::Callback cb_programType_c0_0;
  gsi::Callback cb_programTypeName_c0_0;
  gsi::Callback cb_radioText_c0_0;
  gsi::Callback cb_setAlternativeFrequenciesEnabled_864_0;
  gsi::Callback cb_stationId_c0_0;
  gsi::Callback cb_stationName_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QRadioDataControl_Adaptor::~QRadioDataControl_Adaptor() { }

// emitter void QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled)

static void _init_emitter_alternativeFrequenciesEnabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_alternativeFrequenciesEnabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_alternativeFrequenciesEnabledChanged_864 (arg1);
}


// void QRadioDataControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QRadioDataControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QRadioDataControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_destroyed_1302 (arg1);
}


// void QRadioDataControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// QRadioData::Error QRadioDataControl::error()

static void _init_cbs_error_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::Error>::target_type > ();
}

static void _call_cbs_error_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::Error>::target_type > ((qt_gsi::Converter<QRadioData::Error>::target_type)((QRadioDataControl_Adaptor *)cls)->cbs_error_c0_0 ());
}

static void _set_callback_cbs_error_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_error_c0_0 = cb;
}


// emitter void QRadioDataControl::error(QRadioData::Error err)

static void _init_emitter_error_2028 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("err");
  decl->add_arg<const qt_gsi::Converter<QRadioData::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_error_2028 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioData::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioData::Error>::target_type & >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_error_2028 (arg1);
}


// QString QRadioDataControl::errorString()

static void _init_cbs_errorString_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_errorString_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_errorString_c0_0 ());
}

static void _set_callback_cbs_errorString_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_errorString_c0_0 = cb;
}


// bool QRadioDataControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRadioDataControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QRadioDataControl::isAlternativeFrequenciesEnabled()

static void _init_cbs_isAlternativeFrequenciesEnabled_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAlternativeFrequenciesEnabled_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->cbs_isAlternativeFrequenciesEnabled_c0_0 ());
}

static void _set_callback_cbs_isAlternativeFrequenciesEnabled_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_isAlternativeFrequenciesEnabled_c0_0 = cb;
}


// exposed bool QRadioDataControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_isSignalConnected_c2394 (arg1));
}


// emitter void QRadioDataControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_objectNameChanged_4567 (arg1);
}


// QRadioData::ProgramType QRadioDataControl::programType()

static void _init_cbs_programType_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ();
}

static void _call_cbs_programType_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ((qt_gsi::Converter<QRadioData::ProgramType>::target_type)((QRadioDataControl_Adaptor *)cls)->cbs_programType_c0_0 ());
}

static void _set_callback_cbs_programType_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_programType_c0_0 = cb;
}


// emitter void QRadioDataControl::programTypeChanged(QRadioData::ProgramType programType)

static void _init_emitter_programTypeChanged_2652 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("programType");
  decl->add_arg<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_programTypeChanged_2652 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioData::ProgramType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_programTypeChanged_2652 (arg1);
}


// QString QRadioDataControl::programTypeName()

static void _init_cbs_programTypeName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_programTypeName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_programTypeName_c0_0 ());
}

static void _set_callback_cbs_programTypeName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_programTypeName_c0_0 = cb;
}


// emitter void QRadioDataControl::programTypeNameChanged(QString programTypeName)

static void _init_emitter_programTypeNameChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("programTypeName");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_programTypeNameChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_programTypeNameChanged_1148 (arg1);
}


// QString QRadioDataControl::radioText()

static void _init_cbs_radioText_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_radioText_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_radioText_c0_0 ());
}

static void _set_callback_cbs_radioText_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_radioText_c0_0 = cb;
}


// emitter void QRadioDataControl::radioTextChanged(QString radioText)

static void _init_emitter_radioTextChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("radioText");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_radioTextChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_radioTextChanged_1148 (arg1);
}


// exposed int QRadioDataControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_receivers_c1731 (arg1));
}


// exposed QObject *QRadioDataControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_sender_c0 ());
}


// exposed int QRadioDataControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioDataControl_Adaptor *)cls)->fp_QRadioDataControl_senderSignalIndex_c0 ());
}


// void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)

static void _init_cbs_setAlternativeFrequenciesEnabled_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setAlternativeFrequenciesEnabled_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_setAlternativeFrequenciesEnabled_864_0 (arg1);
}

static void _set_callback_cbs_setAlternativeFrequenciesEnabled_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_setAlternativeFrequenciesEnabled_864_0 = cb;
}


// QString QRadioDataControl::stationId()

static void _init_cbs_stationId_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_stationId_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_stationId_c0_0 ());
}

static void _set_callback_cbs_stationId_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_stationId_c0_0 = cb;
}


// emitter void QRadioDataControl::stationIdChanged(QString stationId)

static void _init_emitter_stationIdChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stationId");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stationIdChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_stationIdChanged_1148 (arg1);
}


// QString QRadioDataControl::stationName()

static void _init_cbs_stationName_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_stationName_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioDataControl_Adaptor *)cls)->cbs_stationName_c0_0 ());
}

static void _set_callback_cbs_stationName_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_stationName_c0_0 = cb;
}


// emitter void QRadioDataControl::stationNameChanged(QString stationName)

static void _init_emitter_stationNameChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stationName");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stationNameChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  ((QRadioDataControl_Adaptor *)cls)->emitter_QRadioDataControl_stationNameChanged_1148 (arg1);
}


// void QRadioDataControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioDataControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioDataControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QRadioDataControl> &qtdecl_QRadioDataControl ();

static gsi::Methods methods_QRadioDataControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_alternativeFrequenciesEnabledChanged", "@brief Emitter for signal void QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled)\nCall this method to emit this signal.", false, &_init_emitter_alternativeFrequenciesEnabledChanged_864, &_call_emitter_alternativeFrequenciesEnabledChanged_864);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRadioDataControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRadioDataControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QRadioDataControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRadioDataControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Virtual method QRadioData::Error QRadioDataControl::error()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@hide", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0, &_set_callback_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_error_sig", "@brief Emitter for signal void QRadioDataControl::error(QRadioData::Error err)\nCall this method to emit this signal.", false, &_init_emitter_error_2028, &_call_emitter_error_2028);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Virtual method QString QRadioDataControl::errorString()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_errorString_c0_0, &_call_cbs_errorString_c0_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@hide", true, &_init_cbs_errorString_c0_0, &_call_cbs_errorString_c0_0, &_set_callback_cbs_errorString_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QRadioDataControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRadioDataControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled", "@brief Virtual method bool QRadioDataControl::isAlternativeFrequenciesEnabled()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAlternativeFrequenciesEnabled_c0_0, &_call_cbs_isAlternativeFrequenciesEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled", "@hide", true, &_init_cbs_isAlternativeFrequenciesEnabled_c0_0, &_call_cbs_isAlternativeFrequenciesEnabled_c0_0, &_set_callback_cbs_isAlternativeFrequenciesEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRadioDataControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QRadioDataControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("programType", "@brief Virtual method QRadioData::ProgramType QRadioDataControl::programType()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_programType_c0_0, &_call_cbs_programType_c0_0);
  methods += new qt_gsi::GenericMethod ("programType", "@hide", true, &_init_cbs_programType_c0_0, &_call_cbs_programType_c0_0, &_set_callback_cbs_programType_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_programTypeChanged", "@brief Emitter for signal void QRadioDataControl::programTypeChanged(QRadioData::ProgramType programType)\nCall this method to emit this signal.", false, &_init_emitter_programTypeChanged_2652, &_call_emitter_programTypeChanged_2652);
  methods += new qt_gsi::GenericMethod ("programTypeName", "@brief Virtual method QString QRadioDataControl::programTypeName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_programTypeName_c0_0, &_call_cbs_programTypeName_c0_0);
  methods += new qt_gsi::GenericMethod ("programTypeName", "@hide", true, &_init_cbs_programTypeName_c0_0, &_call_cbs_programTypeName_c0_0, &_set_callback_cbs_programTypeName_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_programTypeNameChanged", "@brief Emitter for signal void QRadioDataControl::programTypeNameChanged(QString programTypeName)\nCall this method to emit this signal.", false, &_init_emitter_programTypeNameChanged_1148, &_call_emitter_programTypeNameChanged_1148);
  methods += new qt_gsi::GenericMethod ("radioText", "@brief Virtual method QString QRadioDataControl::radioText()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_radioText_c0_0, &_call_cbs_radioText_c0_0);
  methods += new qt_gsi::GenericMethod ("radioText", "@hide", true, &_init_cbs_radioText_c0_0, &_call_cbs_radioText_c0_0, &_set_callback_cbs_radioText_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_radioTextChanged", "@brief Emitter for signal void QRadioDataControl::radioTextChanged(QString radioText)\nCall this method to emit this signal.", false, &_init_emitter_radioTextChanged_1148, &_call_emitter_radioTextChanged_1148);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRadioDataControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRadioDataControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRadioDataControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled", "@brief Virtual method void QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setAlternativeFrequenciesEnabled_864_0, &_call_cbs_setAlternativeFrequenciesEnabled_864_0);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled", "@hide", false, &_init_cbs_setAlternativeFrequenciesEnabled_864_0, &_call_cbs_setAlternativeFrequenciesEnabled_864_0, &_set_callback_cbs_setAlternativeFrequenciesEnabled_864_0);
  methods += new qt_gsi::GenericMethod ("stationId", "@brief Virtual method QString QRadioDataControl::stationId()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stationId_c0_0, &_call_cbs_stationId_c0_0);
  methods += new qt_gsi::GenericMethod ("stationId", "@hide", true, &_init_cbs_stationId_c0_0, &_call_cbs_stationId_c0_0, &_set_callback_cbs_stationId_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_stationIdChanged", "@brief Emitter for signal void QRadioDataControl::stationIdChanged(QString stationId)\nCall this method to emit this signal.", false, &_init_emitter_stationIdChanged_1148, &_call_emitter_stationIdChanged_1148);
  methods += new qt_gsi::GenericMethod ("stationName", "@brief Virtual method QString QRadioDataControl::stationName()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stationName_c0_0, &_call_cbs_stationName_c0_0);
  methods += new qt_gsi::GenericMethod ("stationName", "@hide", true, &_init_cbs_stationName_c0_0, &_call_cbs_stationName_c0_0, &_set_callback_cbs_stationName_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_stationNameChanged", "@brief Emitter for signal void QRadioDataControl::stationNameChanged(QString stationName)\nCall this method to emit this signal.", false, &_init_emitter_stationNameChanged_1148, &_call_emitter_stationNameChanged_1148);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRadioDataControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QRadioDataControl_Adaptor> decl_QRadioDataControl_Adaptor (qtdecl_QRadioDataControl (), "QtMultimedia", "QRadioDataControl",
  methods_QRadioDataControl_Adaptor (),
  "@qt\n@brief Binding of QRadioDataControl");

}

