/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#include "database.h"

Database::Database()
{
#ifdef WIN32
    QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "\\" + KP_DIRECTORY);
    db_path = QDir::toNativeSeparators(QDir::homePath()) + "\\" + KP_DIRECTORY + "\\" + "kontrolpack.db";
#else
    QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "/" + KP_DIRECTORY);
    db_path = QDir::toNativeSeparators(QDir::homePath()) + "/" + KP_DIRECTORY + "/" + "kontrolpack.db";
#endif
    if (!kpDir.exists()) {
        QDir dir = QDir::home();
        dir.mkdir(KP_DIRECTORY);
        dir.cd(KP_DIRECTORY);
    }
    zErrMsg = 0;
    rc = sqlite3_open(db_path.toUtf8().data(), &db);
    if( rc ) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
    }
    // Server related table.
    rc = sqlite3_exec(db, "select * from client_parameter;", NULL, 0, &zErrMsg);
    if( rc != SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        if (rc == 1) {
            rc = sqlite3_exec(db, "create table client_parameter(id int, ip varchar(16), os varchar(10), hostname varchar(200), port int, port_file int);", NULL, 0, &zErrMsg);
            if( rc!=SQLITE_OK ) {
                fprintf(stderr, "SQL error: %s\n", zErrMsg);
                sqlite3_free(zErrMsg);
            }
        }
    }

    // Commands historic for a specific server identified by id_server.
    rc = sqlite3_exec(db, "select * from commands_historic;", NULL, 0, &zErrMsg);
    if( rc != SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        if (rc == 1) {
            rc = sqlite3_exec(db, "create table commands_historic(id_server int, id_command int, command varchar(800), date varchar(20));", NULL, 0, &zErrMsg);
            if( rc!=SQLITE_OK ) {
                fprintf(stderr, "SQL error: %s\n", zErrMsg);
                sqlite3_free(zErrMsg);
            }
        }
    }
}

void Database::saveRemoteClients(RemoteComputerInfo* data)
{
    QString query = QString("insert into client_parameter values(\"" + QString::number(data->id) + "\", \"" + data->ip + "\", \"" + data->system + "\", \"" + data->hostname + "\", " + QString::number(data->port) + ", " + QString::number(data->port_file) + ");");
    rc = sqlite3_exec(db, query.toUtf8().data(), NULL, 0, &zErrMsg);
    if( rc!=SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
}

QList<RemoteComputerInfo*> Database::getRemoteClients()
{
    QList<RemoteComputerInfo*> data = QList<RemoteComputerInfo*>();
    sqlite3_stmt* pStatement;

    char* acQuery = sqlite3_mprintf("select * from client_parameter;");
    int nError = sqlite3_prepare_v2(db,acQuery,-1,&pStatement,NULL);
    while (nError == SQLITE_OK && sqlite3_step(pStatement) == SQLITE_ROW) {
        RemoteComputerInfo *remoteInfo = new RemoteComputerInfo(this);
        remoteInfo->id = QString((char*)sqlite3_column_text(pStatement, DB_ID_SERVER)).toInt();
        remoteInfo->ip = QString((char*)sqlite3_column_text(pStatement, DB_IP));
        remoteInfo->system = QString((char*)sqlite3_column_text(pStatement, DB_OS));
        remoteInfo->hostname = QString((char*)sqlite3_column_text(pStatement, DB_HOSTNAME));
        remoteInfo->port = QString((char*)sqlite3_column_text(pStatement, DB_PORT)).toInt();
        remoteInfo->port_file = QString((char*)sqlite3_column_text(pStatement, DB_PORT_FILE)).toInt();
        data.append(remoteInfo);
    }
    sqlite3_finalize(pStatement);
    sqlite3_free(acQuery);
    return data;
}

void Database::dropRemoteClients()
{
    rc = sqlite3_exec(db, "drop table client_parameter;", NULL, 0, &zErrMsg);
    if( rc!=SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
    rc = sqlite3_exec(db, "create table client_parameter(id int, ip varchar(16), os varchar(10), hostname varchar(200), port int, port_file int);", NULL, 0, &zErrMsg);
    if( rc!=SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
}

void Database::saveCommand(Command* data)
{
    QString query = QString("insert into commands_historic values(\"" + QString::number(data->id_server) + "\", \"" + QString::number(data->id_command) + "\", \"" + data->command + "\", \"" + data->date + "\");");
    rc = sqlite3_exec(db, query.toUtf8().data(), NULL, 0, &zErrMsg);
    if( rc!=SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
}

void Database::dropCommands()
{
    rc = sqlite3_exec(db, "drop table commands_historic;", NULL, 0, &zErrMsg);
    if( rc!=SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
    rc = sqlite3_exec(db, "create table commands_historic(id_server int, id_command int, command varchar(800), date varchar(20));", NULL, 0, &zErrMsg);
    if( rc!=SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
}

QList<Command*>* Database::getCommandsByIdServer(int id_server)
{
    QList<Command*> *data = new QList<Command*>;
    sqlite3_stmt* statement;
    char* acQuery = sqlite3_mprintf("select * from commands_historic where id_server=?;");
    int nError = sqlite3_prepare_v2(db,acQuery,-1,&statement,NULL);

    nError = sqlite3_bind_int(statement, 1, id_server);

    if( SQLITE_OK == nError ) {
        while (nError == SQLITE_OK && sqlite3_step(statement) == SQLITE_ROW) {
            Command *command = new Command(this);
            command->id_server = QString((char*)sqlite3_column_text(statement, DB_ID_SERVER)).toInt();
            command->id_command = QString((char*)sqlite3_column_text(statement, DB_ID_COMMAND)).toInt();
            command->command = QString((char*)sqlite3_column_text(statement, DB_COMMAND));
            command->date = QString((char*)sqlite3_column_text(statement, DB_DATE));
            data->append(command);
        }
    }
    sqlite3_finalize(statement);
    sqlite3_free(acQuery);
    return data;
}

void Database::delete_command(int id_server, int id_command, QString command)
{
    sqlite3_stmt* statement;
    char* acQuery = sqlite3_mprintf("delete from commands_historic where id_server=? and id_command=? and command=?;");
    int nError = sqlite3_prepare_v2(db,acQuery,-1,&statement,NULL);

    nError = sqlite3_bind_int(statement, 1, id_server);

    if( SQLITE_OK == nError ) {
        nError = sqlite3_bind_int(statement, 2, id_command);
        nError = sqlite3_bind_text(statement, 3, command.toUtf8().data(), strlen(command.toUtf8().data()), NULL);
    }
    sqlite3_step(statement);
    sqlite3_finalize(statement);
    sqlite3_free(acQuery);
}

void Database::freeDatabase()
{
    sqlite3_close(db);
}


