/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.debugger;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class PositionManagerTestGenerated extends AbstractPositionManagerTest {
    @TestMetadata("idea/testData/debugger/positionManager")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SingleFile extends AbstractPositionManagerTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSingleFile() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/positionManager"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, false);
        }

        @TestMetadata("anonymousFunction.kt")
        public void testAnonymousFunction() throws Exception {
            runTest("idea/testData/debugger/positionManager/anonymousFunction.kt");
        }

        @TestMetadata("anonymousNamedFunction.kt")
        public void testAnonymousNamedFunction() throws Exception {
            runTest("idea/testData/debugger/positionManager/anonymousNamedFunction.kt");
        }

        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            runTest("idea/testData/debugger/positionManager/class.kt");
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("idea/testData/debugger/positionManager/classObject.kt");
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("idea/testData/debugger/positionManager/enum.kt");
        }

        @TestMetadata("extensionFunction.kt")
        public void testExtensionFunction() throws Exception {
            runTest("idea/testData/debugger/positionManager/extensionFunction.kt");
        }

        @TestMetadata("functionLiteral.kt")
        public void testFunctionLiteral() throws Exception {
            runTest("idea/testData/debugger/positionManager/functionLiteral.kt");
        }

        @TestMetadata("functionLiteralInVal.kt")
        public void testFunctionLiteralInVal() throws Exception {
            runTest("idea/testData/debugger/positionManager/functionLiteralInVal.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("idea/testData/debugger/positionManager/innerClass.kt");
        }

        @TestMetadata("JvmNameAnnotation.kt")
        public void testJvmNameAnnotation() throws Exception {
            runTest("idea/testData/debugger/positionManager/JvmNameAnnotation.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("idea/testData/debugger/positionManager/localFunction.kt");
        }

        @TestMetadata("objectDeclaration.kt")
        public void testObjectDeclaration() throws Exception {
            runTest("idea/testData/debugger/positionManager/objectDeclaration.kt");
        }

        @TestMetadata("objectExpression.kt")
        public void testObjectExpression() throws Exception {
            runTest("idea/testData/debugger/positionManager/objectExpression.kt");
        }

        @TestMetadata("package.kt")
        public void testPackage() throws Exception {
            runTest("idea/testData/debugger/positionManager/package.kt");
        }

        @TestMetadata("propertyAccessor.kt")
        public void testPropertyAccessor() throws Exception {
            runTest("idea/testData/debugger/positionManager/propertyAccessor.kt");
        }

        @TestMetadata("propertyInitializer.kt")
        public void testPropertyInitializer() throws Exception {
            runTest("idea/testData/debugger/positionManager/propertyInitializer.kt");
        }

        @TestMetadata("topLevelPropertyInitializer.kt")
        public void testTopLevelPropertyInitializer() throws Exception {
            runTest("idea/testData/debugger/positionManager/topLevelPropertyInitializer.kt");
        }

        @TestMetadata("trait.kt")
        public void testTrait() throws Exception {
            runTest("idea/testData/debugger/positionManager/trait.kt");
        }

        @TestMetadata("twoClasses.kt")
        public void testTwoClasses() throws Exception {
            runTest("idea/testData/debugger/positionManager/twoClasses.kt");
        }

        @TestMetadata("_DefaultPackage.kt")
        public void test_DefaultPackage() throws Exception {
            runTest("idea/testData/debugger/positionManager/_DefaultPackage.kt");
        }
    }

    @TestMetadata("idea/testData/debugger/positionManager")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiFile extends AbstractPositionManagerTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMultiFile() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/positionManager"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
        }

        @TestMetadata("multiFilePackage")
        public void testMultiFilePackage() throws Exception {
            runTest("idea/testData/debugger/positionManager/multiFilePackage/");
        }

        @TestMetadata("multiFileSameName")
        public void testMultiFileSameName() throws Exception {
            runTest("idea/testData/debugger/positionManager/multiFileSameName/");
        }
    }
}
