dnl Check for M$-Compiler      (C) 2000-2008 Fritz Elfert <felfert@to.com>
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a configuration
dnl script generated by Autoconf, you may include it under the same
dnl distribution terms that you use for the rest of that program.

AC_DEFUN([NP_FIND_DOSENV],[
    save_IFS="$IFS"
    $3=no
    IFS=","
    ENVVAR=`echo $$2 | tr ';' ','`
    for i in $ENVVAR ; do
        f=`cygpath -u "$i"`
        if test -r "$f/$1" ; then
            $3="$f"
            break
        fi
    done
    IFS="$save_IFS"
])

AC_DEFUN([NP_PROG_MSC],[
    AC_ARG_WITH(wininc,
        [  --with-wininc=DIR       define windows include directory],
        [win32inc="$withval"],[win32inc=no]
    )
    AC_ARG_WITH(winlib,
        [  --with-winlib=DIR       define windows lib directory],
        [win32lib="$withval"],[win32lib=no]
    )
    AC_CACHE_CHECK(for MSC environment, np_cv_prog_msc, [
        np_cv_prog_msc=no
        cat > conftest.c <<EOF
#ifndef _MSC_VER
#error NOMSC
#endif
int main() {}
EOF
        RET=`cl -nologo -c conftest.c 2>&1`
        case "$RET" in
            conftest.c?)
                np_cv_prog_msc=yes
                ;;
            *)
                ;;
        esac
    ])
    if test "x$np_cv_prog_msc" = "xyes" ; then
        if test "$win32inc" = "no" ; then
            AC_MSG_CHECKING(for Win32 include dir)
            NP_FIND_DOSENV(ras.h,INCLUDE,win32inc)
            AC_MSG_RESULT("$win32inc")
        fi
        if test "$win32inc" = "no" ; then
            AC_MSG_ERROR([Unable to get Win32 include dir from environment.])
            AC_MSG_ERROR([use --with-wininc=DIR to set it manually])
        fi
        if test "$win32lib" = "no" ; then
            AC_MSG_CHECKING(for Win32 lib dir)
            NP_FIND_DOSENV(wsock32.lib,LIB,win32lib)
            AC_MSG_RESULT("$win32lib")
        fi
        if test "$win32lib" = "no" ; then
            AC_MSG_ERROR([Unable to get Win32 lib dir from environment.])
            AC_MSG_ERROR([use --with-winlib=DIR to set it manually])
        fi
        CC="cl -nologo -GX -D__WIN32__ -D_MT -D_WIN32_WINNT=0x0400 -I$win32inc"
        CXX="cl -nologo -GX -D__WIN32__ -D_MT -D_WIN32_WINNT=0x0400 -I$win32inc"
        LD="link /libpath:$win32lib"
        AS=masm
    fi
    AM_CONDITIONAL(MSWIN32, test $np_cv_prog_msc = yes)
])

