/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.io.InputStream;
import java.io.InputStreamReader;

import junit.framework.TestCase;

public class XmlRpcReaderTest extends TestCase {
	
	public void testReader() throws Exception {
		InputStream is = getClass().getResourceAsStream("/test.xml");
		InputStreamReader reader = new InputStreamReader(is);
		XmlRpcReaderImpl ri = new XmlRpcReaderImpl(reader);
		assertEquals("generic_handler.unpack_pack", ri.readMethodName());
		ParamIterator i = ri.readMethodRequest();
		iterate(i);
		i.close();
	}
	
	private void iterate(ParamIterator i) throws Exception {
		while (i.hasNext()) {
			Object object = i.next();
			if (object instanceof ParamIterator)
				iterate((ParamIterator)object);
			System.out.println(object);
		}
	}

}

