with Ada.Text_Io;

with Ada.Containers.Doubly_Linked_Lists;

procedure Prefixed_Notation_Browsing is

   use Ada;
   use Text_Io;

   package Integers_Lists is new Containers.Doubly_Linked_Lists (Integer);
   use Integers_Lists;
   My_List : Integers_Lists.List;

begin

   -- Unable to browse the prefixed notation Is_Empty function
   Put_Line ("Is My_List empty? ==> " & Boolean'Image (My_List.Is_Empty));

   -- Observation: if a none prefixed notation exists, as shown below,
   -- GPS can browse normally. Of course, it needs to be uncommented to see
   -- the effect mentioned.
--     Put_Line ("Is My_List empty? ==> " & Boolean'Image (Is_Empty (My_List)));

end Prefixed_Notation_Browsing;

