/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.ByteBufferImpl;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

class HeapByteBuffer
extends ByteBufferImpl {
    HeapByteBuffer(int n, byte[] byArray, int n2) {
        super(n, byArray, n2);
    }

    public ByteBuffer slice() {
        return new HeapByteBuffer(this.limit - this.position, this.array, this.arrayOffset + this.position);
    }

    void copyToArray(byte[] byArray, int n, int n2) {
        System.arraycopy(this.array, this.arrayOffset + this.position, byArray, n, n2);
    }

    public boolean isDirect() {
        return false;
    }

    public FloatBuffer asFloatBuffer() {
        return new ByteBufferAsFloatBuffer(this, this.remaining() >> 2, this.position);
    }

    public IntBuffer asIntBuffer() {
        return new ByteBufferAsIntBuffer(this, this.remaining() >> 2, this.position);
    }

    public ShortBuffer asShortBuffer() {
        return new ByteBufferAsShortBuffer(this, this.remaining() >> 1, this.position);
    }
}

