#!/usr/bin/perl

# libtextwrap - Text-Wrapping Library with I18N
# Copyright (C) 2003 by Tomohiro KUBOTA <kubota@debian.org>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of any author may not be used to endorse or promote
#    products derived from this software without their specific prior
#    written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.


# The sample texts are citations from Debian website (http://www.debian.org/).
#
# Copyright (c) 1997-2003 Software in the Public Interest, Inc.
# P.O. Box 502761
# Indianapolis, IN 46250-2761
# United States
#
# This material may be distributed only subject to the terms and conditions
# set forth in the Open Publication License, Draft v1.0 or later (the latest
# version is presently available at http://www.opencontent.org/openpub/). 
#
# "Debian" and the Debian Logo are trademarks of Software in the Public
# Interest, Inc.


$locale = `locale charmap`;
chomp($locale);

print "locale = $locale\n";

if ($locale eq "UTF-8") {
    $str = <<"EOF";
English - Debian is a free operating system (OS) for your computer. An operating system is the set of basic programs and utilities that make your computer run.
Greek - \xce\xa4\xce\xbf Debian \xce\xb5\xce\xaf\xce\xbd\xce\xb1\xce\xb9 \xce\xad\xce\xbd\xce\xb1 \xce\xb5\xce\xbb\xce\xb5\xcf\x8d\xce\xb8\xce\xb5\xcf\x81\xce\xbf \xce\xbb\xce\xb5\xce\xb9\xcf\x84\xce\xbf\xcf\x85\xcf\x81\xce\xb3\xce\xb9\xce\xba\xcf\x8c \xcf\x83\xcf\x8d\xcf\x83\xcf\x84\xce\xb7\xce\xbc\xce\xb1 (\xce\x9b\xce\xa3) \xce\xb3\xce\xb9\xce\xb1 \xcf\x84\xce\xbf\xce\xbd \xcf\x85\xcf\x80\xce\xbf\xce\xbb\xce\xbf\xce\xb3\xce\xb9\xcf\x83\xcf\x84\xce\xae \xcf\x83\xce\xb1\xcf\x82. \xce\xa4\xce\xbf \xce\xbb\xce\xb5\xce\xb9\xcf\x84\xce\xbf\xcf\x85\xcf\x81\xce\xb3\xce\xb9\xce\xba\xcf\x8c \xcf\x83\xcf\x8d\xcf\x83\xcf\x84\xce\xb7\xce\xbc\xce\xb1 \xce\xb5\xce\xaf\xce\xbd\xce\xb1\xce\xb9 \xce\xbc\xce\xb9\xce\xb1 \xcf\x83\xcf\x85\xce\xbb\xce\xbb\xce\xbf\xce\xb3\xce\xae \xce\xb1\xcf\x80\xce\xbf \xcf\x84\xce\xb1 \xce\xb1\xcf\x80\xce\xb1\xcf\x81\xce\xb1\xce\xaf\xcf\x84\xce\xb7\xcf\x84\xce\xb1 \xcf\x80\xcf\x81\xce\xbf\xce\xb3\xcf\x81\xce\xac\xce\xbc\xce\xbc\xce\xb1\xcf\x84\xce\xb1 \xce\xba\xce\xb1\xce\xb9 \xce\xb2\xce\xbf\xce\xb7\xce\xb8\xce\xae\xce\xbc\xce\xb1\xcf\x84\xce\xb1 \xcf\x80\xce\xbf\xcf\x85 \xce\xb1\xcf\x80\xce\xb1\xce\xb9\xcf\x84\xce\xb5\xce\xaf \xce\xbf \xcf\x85\xcf\x80\xce\xbf\xce\xbb\xce\xbf\xce\xb3\xce\xb9\xcf\x83\xcf\x84\xce\xae\xcf\x82 \xcf\x83\xce\xb1\xcf\x82 \xce\xb3\xce\xb9\xce\xb1 \xce\xbd\xce\xb1 \xce\xbb\xce\xb5\xce\xb9\xcf\x84\xce\xbf\xcf\x85\xcf\x81\xce\xb3\xce\xae\xcf\x83\xce\xb5\xce\xb9.
Japanese - Debian \xe3\x81\xaf\xe3\x81\x82\xe3\x81\xaa\xe3\x81\x9f\xe3\x81\xae\xe3\x82\xb3\xe3\x83\xb3\xe3\x83\x94\xe3\x83\xa5\xe3\x83\xbc\xe3\x82\xbf\xe3\x81\xae\xe3\x81\x9f\xe3\x82\x81\xe3\x81\xae\xe3\x83\x95\xe3\x83\xaa\xe3\x83\xbc\xe3\x81\xaa\xe3\x82\xaa\xe3\x83\x9a\xe3\x83\xac\xe3\x83\xbc\xe3\x83\x86\xe3\x82\xa3\xe3\x83\xb3\xe3\x82\xb0\xe3\x82\xb7\xe3\x82\xb9\xe3\x83\x86\xe3\x83\xa0 (OS) \xe3\x81\xa7\xe3\x81\x99\xe3\x80\x82\xe3\x82\xaa\xe3\x83\x9a\xe3\x83\xac\xe3\x83\xbc\xe3\x83\x86\xe3\x82\xa3\xe3\x83\xb3\xe3\x82\xb0\xe3\x82\xb7\xe3\x82\xb9\xe3\x83\x86\xe3\x83\xa0\xe3\x81\xaf\xe3\x80\x81\xe3\x82\xb3\xe3\x83\xb3\xe3\x83\x94\xe3\x83\xa5\xe3\x83\xbc\xe3\x82\xbf\xe3\x82\x92\xe5\x8b\x95\xe4\xbd\x9c\xe3\x81\x95\xe3\x81\x9b\xe3\x82\x8b\xe3\x81\x9f\xe3\x82\x81\xe3\x81\xab\xe5\xbf\x85\xe8\xa6\x81\xe3\x81\xaa\xe5\x9f\xba\xe6\x9c\xac\xe3\x83\x97\xe3\x83\xad\xe3\x82\xb0\xe3\x83\xa9\xe3\x83\xa0\xe3\x81\xa8\xe3\x83\xa6\xe3\x83\xbc\xe3\x83\x86\xe3\x82\xa3\xe3\x83\xaa\xe3\x83\x86\xe3\x82\xa3\xe3\x81\xae\xe9\x9b\x86\xe5\x90\x88\xe4\xbd\x93\xe3\x81\xa7\xe3\x81\x99\xe3\x80\x82
Korean - \xeb\x8d\xb0\xeb\xb9\x84\xec\x95\x88\xec\x9d\x80 \xec\x97\xac\xeb\x9f\xac\xeb\xb6\x84\xec\x9d\x98 \xec\xbb\xb4\xed\x93\xa8\xed\x84\xb0\xeb\xa5\xbc \xec\x9c\x84\xed\x95\x9c \xec\x9e\x90\xec\x9c\xa0 \xec\x9a\xb4\xec\x98\x81\xec\xb2\xb4\xec\xa0\x9c\xec\x9e\x85\xeb\x8b\x88\xeb\x8b\xa4. \xec\x9a\xb4\xec\x98\x81\xec\xb2\xb4\xec\xa0\x9c\xeb\x9e\x80 \xec\xbb\xb4\xed\x93\xa8\xed\x84\xb0\xeb\xa5\xbc \xeb\x8f\x99\xec\x9e\x91\xec\x8b\x9c\xed\x82\xa4\xeb\x8a\x94 \xea\xb8\xb0\xeb\xb3\xb8\xec\xa0\x81\xec\x9d\xb8 \xed\x94\x84\xeb\xa1\x9c\xea\xb7\xb8\xeb\x9e\xa8\xea\xb3\xbc \xec\x9c\xa0\xed\x8b\xb8\xeb\xa6\xac\xed\x8b\xb0\xeb\xa5\xbc \xed\x95\x98\xeb\x82\x98\xeb\xa1\x9c \xeb\xac\xb6\xec\x9d\x80 \xea\xb2\x83\xec\x9e\x85\xeb\x8b\x88\xeb\x8b\xa4.
Russian - Debian -- \xd1\x8d\xd1\x82\xd0\xbe \xd1\x81\xd0\xb2\xd0\xbe\xd0\xb1\xd0\xbe\xd0\xb4\xd0\xbd\xd0\xb0\xd1\x8f \xd0\xbe\xd0\xbf\xd0\xb5\xd1\x80\xd0\xb0\xd1\x86\xd0\xb8\xd0\xbe\xd0\xbd\xd0\xbd\xd0\xb0\xd1\x8f \xd1\x81\xd0\xb8\xd1\x81\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb0 (\xd0\x9e\xd0\xa1) \xd0\xb8 \xd0\xbd\xd0\xb0\xd0\xb1\xd0\xbe\xd1\x80 \xd0\xbf\xd1\x80\xd0\xb8\xd0\xba\xd0\xbb\xd0\xb0\xd0\xb4\xd0\xbd\xd1\x8b\xd1\x85 \xd0\xbf\xd1\x80\xd0\xbe\xd0\xb3\xd1\x80\xd0\xb0\xd0\xbc\xd0\xbc \xd0\xb4\xd0\xbb\xd1\x8f \xd0\xb2\xd0\xb0\xd1\x88\xd0\xb5\xd0\xb3\xd0\xbe \xd0\xba\xd0\xbe\xd0\xbc\xd0\xbf\xd1\x8c\xd1\x8e\xd1\x82\xd0\xb5\xd1\x80\xd0\xb0.
simplified Chinese - Debian \xe6\x98\xaf\xe4\xb8\x80\xe5\xa5\x97\xe4\xb8\xba\xe4\xba\x86\xe6\x82\xa8\xe7\x9a\x84\xe8\xae\xa1\xe7\xae\x97\xe6\x9c\xba\xe6\x89\x80\xe8\xae\xbe\xe8\xae\xa1\xe7\x9a\x84\xe8\x87\xaa\xe7\x94\xb1\xe6\x93\x8d\xe4\xbd\x9c\xe7\xb3\xbb\xe7\xbb\x9f (OS)\xe3\x80\x82\xe6\x93\x8d\xe4\xbd\x9c\xe7\xb3\xbb\xe7\xbb\x9f\xe6\x98\xaf\xe4\xbd\xbf\xe8\xae\xa1\xe7\xae\x97\xe6\x9c\xba\xe8\xbf\x90\xe8\xa1\x8c\xe7\x9a\x84\xe5\x9f\xba\xe6\x9c\xac\xe7\xa8\x8b\xe5\xba\x8f\xe5\x92\x8c\xe5\xb7\xa5\xe5\x85\xb7\xe7\x9a\x84\xe9\x9b\x86\xe5\x90\x88\xe3\x80\x82
EOF
} elsif ($locale eq "EUC-JP") {
    $str = <<"EOF";
Japanese - Debian \xa4\xcf\xa4\xa2\xa4\xca\xa4\xbf\xa4\xce\xa5\xb3\xa5\xf3\xa5\xd4\xa5\xe5\xa1\xbc\xa5\xbf\xa4\xce\xa4\xbf\xa4\xe1\xa4\xce\xa5\xd5\xa5\xea\xa1\xbc\xa4\xca\xa5\xaa\xa5\xda\xa5\xec\xa1\xbc\xa5\xc6\xa5\xa3\xa5\xf3\xa5\xb0\xa5\xb7\xa5\xb9\xa5\xc6\xa5\xe0 (OS) \xa4\xc7\xa4\xb9\xa1\xa3\xa5\xaa\xa5\xda\xa5\xec\xa1\xbc\xa5\xc6\xa5\xa3\xa5\xf3\xa5\xb0\xa5\xb7\xa5\xb9\xa5\xc6\xa5\xe0\xa4\xcf\xa1\xa2\xa5\xb3\xa5\xf3\xa5\xd4\xa5\xe5\xa1\xbc\xa5\xbf\xa4\xf2\xc6\xb0\xba\xee\xa4\xb5\xa4\xbb\xa4\xeb\xa4\xbf\xa4\xe1\xa4\xcb\xc9\xac\xcd\xd7\xa4\xca\xb4\xf0\xcb\xdc\xa5\xd7\xa5\xed\xa5\xb0\xa5\xe9\xa5\xe0\xa4\xc8\xa5\xe6\xa1\xbc\xa5\xc6\xa5\xa3\xa5\xea\xa5\xc6\xa5\xa3\xa4\xce\xbd\xb8\xb9\xe7\xc2\xce\xa4\xc7\xa4\xb9\xa1\xa3
EOF
} elsif ($locale eq "KOI8-R") {
    $str = <<"EOF";
Russian - Debian -- \xdc\xd4\xcf \xd3\xd7\xcf\xc2\xcf\xc4\xce\xc1\xd1 \xcf\xd0\xc5\xd2\xc1\xc3\xc9\xcf\xce\xce\xc1\xd1 \xd3\xc9\xd3\xd4\xc5\xcd\xc1 (\xef\xf3) \xc9 \xce\xc1\xc2\xcf\xd2 \xd0\xd2\xc9\xcb\xcc\xc1\xc4\xce\xd9\xc8 \xd0\xd2\xcf\xc7\xd2\xc1\xcd\xcd \xc4\xcc\xd1 \xd7\xc1\xdb\xc5\xc7\xcf \xcb\xcf\xcd\xd0\xd8\xc0\xd4\xc5\xd2\xc1.
EOF
} else {
    $str = <<"EOF";
English - Debian is a free operating system (OS) for your computer. An operating system is the set of basic programs and utilities that make your computer run.
EOF
}

chomp($str);

for($i=40; $i<80; $i++) {
	print "\x1b[2J\x1b[Hencoding=$locale,width=$i\n", "-" x $i , "\n";
	system("echo \"$str\" | dotextwrap $i");
	print "[ Hit Enter key. ]";
	<>;
}

for($i=40; $i<80; $i++) {
	print "\x1b[2J\x1b[Hencoding=$locale,width=$i\n", "-" x $i , "\n";
	system("echo \"$str\" | dotextwrap $i 8 \"/* \" \" * \"");
	print "[ Hit Enter key. ]";
	<>;
}

