
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileSymbolIndividualModeAttributes.h
    \brief Definition of SymbolIndividualMode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef SymbolIndividualModeAttributes_H
#define SymbolIndividualModeAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class SymbolIndividualModeAttributes 
{
public:
//  --  constructor
    SymbolIndividualModeAttributes();
    
//  --  destructor
    virtual ~SymbolIndividualModeAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SymbolIndividualModeAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string legend_text_;
	double height_;
	string marker_mode_;
	int marker_;
	string symbol_;
	string image_path_;
	string image_format_;
	double image_width_;
	double image_height_;
	bool image_by_reference_;
	stringarray text_;
	string text_position_;
	string text_font_name_;
	double text_font_size_;
	string text_font_style_;
	double legend_height_;
	unique_ptr<Colour> colour_;
	unique_ptr<Colour> text_font_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const SymbolIndividualModeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

