# Flatpak packaging

## Building Flatpak

To build the Flatpak package, you will need `flatpak`, `flatpak-builder`, and
KDE 5.14 runtime with SDK. `flatpak-builder` is usually available from
the same repository as `flatpak`.  
See the [Flatpak setup instructions](https://flatpak.org/setup/) 
for your system.

To install the runtimes (remove the `--user` flag and run as root if you 
prefer system-wide installation):

```sh
    flatpak install --user flathub org.kde.Platform//5.14 org.kde.Sdk//5.14
```

If the download fails for some reason, run `flatpak repair` before retrying.

To build, create a bundle and install it, run from the root of the project:

```sh
    make clean
    flatpak-builder --repo=build/flatpak/repo --force-clean build/flatpak/build packaging/flatpak/mirage.flatpak.yaml
    flatpak build-bundle build/flatpak/repo build/mirage.flatpak io.github.mirukana.mirage
    flatpak install --user build/mirage.flatpak
```

To run the installed bundle,
either use your desktop environment or command line:

```sh
    flatpak run io.github.mirukana.mirage
```

## Manifest

The manifest can be created using the included scripts, as described
below. Please note it is intended to be done by the maintainers
only. In particular, there could be some unexpected issues exposed by
updates in Python modules that have to be resolved.

The manifest has to be updated by maintainers when the dependencies of
Mirage change, or some updates in used Python modules are desired.

The Flatpak packaging manifest is generated by running
[generate-flatpak-script.sh](generate-flatpak-script.sh), which 
uses [mirage.flatpak.base.yaml](mirage.flatpak.base.yaml) and replaces the
marked placeholder with Python dependencies.

This script requires `libolm` to be installed on the development PC, as it
will create Python virtual environment and install all the requirements in it.

Note that the Python dependencies are taken from
[requirements.flatpak.txt](requirements.flatpak.txt) and the
project root's [requirements.txt](../../requirements.txt).

In addition, the list of ignored packages is in
[generate-flatpak-script.sh](generate-flatpak-script.sh).
