*DECK DBIE
      DOUBLE PRECISION FUNCTION DBIE (X)
C***BEGIN PROLOGUE  DBIE
C***PURPOSE  Calculate the Bairy function for a negative argument and an
C            exponentially scaled Bairy function for a non-negative
C            argument.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10D
C***TYPE      DOUBLE PRECISION (BIE-S, DBIE-D)
C***KEYWORDS  BAIRY FUNCTION, EXPONENTIALLY SCALED, FNLIB,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C DBIE(X) calculates the double precision Airy function of the
C second kind or the double precision exponentially scaled Airy
C function of the second kind, depending on the value of the
C double precision argument X.
C
C Evaluate BI(X) for X .LE. 0.0  and  BI(X)*EXP(-ZETA)  where
C ZETA = 2/3 * X**(3/2)  for X .GE. 0.0
C
C
C Series for BIF        on the interval -1.00000E+00 to  1.00000E+00
C                                        with weighted error   1.45E-32
C                                         log weighted error  31.84
C                               significant figures required  30.85
C                                    decimal places required  32.40
C
C
C Series for BIG        on the interval -1.00000E+00 to  1.00000E+00
C                                        with weighted error   1.29E-33
C                                         log weighted error  32.89
C                               significant figures required  31.48
C                                    decimal places required  33.45
C
C
C Series for BIF2       on the interval  1.00000E+00 to  8.00000E+00
C                                        with weighted error   6.08E-32
C                                         log weighted error  31.22
C                        approx significant figures required  30.8
C                                    decimal places required  31.80
C
C
C Series for BIG2       on the interval  1.00000E+00 to  8.00000E+00
C                                        with weighted error   4.91E-33
C                                         log weighted error  32.31
C                        approx significant figures required  31.6
C                                    decimal places required  32.90
C
C
C Series for BIP1       on the interval  1.25000E-01 to  3.53553E-01
C                                        with weighted error   1.06E-32
C                                         log weighted error  31.98
C                               significant figures required  30.61
C                                    decimal places required  32.81
C
C
C Series for BIP2       on the interval  0.          to  1.25000E-01
C                                        with weighted error   4.04E-33
C                                         log weighted error  32.39
C                               significant figures required  31.15
C                                    decimal places required  33.37
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, D9AIMP, DCSEVL, INITDS
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C***END PROLOGUE  DBIE
      DOUBLE PRECISION X, BIFCS(13), BIGCS(13), BIF2CS(15), BIG2CS(15),
     1  BIP1CS(47), BIP2CS(88), ATR, BTR, SQRTX, THETA, XBIG, XM, X3SML,
     2  X32SML, Z, D1MACH, DCSEVL
      LOGICAL FIRST
      SAVE BIFCS, BIGCS, BIF2CS, BIG2CS, BIP1CS, BIP2CS, ATR, BTR,
     1 NBIF, NBIG, NBIF2, NBIG2, NBIP1, NBIP2, X3SML, X32SML, XBIG,
     2 FIRST
      DATA BIFCS(  1) / -.1673021647 1986649483 5374239281 76 D-1     /
      DATA BIFCS(  2) / +.1025233583 4249445611 4263627777 57 D+0     /
      DATA BIFCS(  3) / +.1708309250 7381516539 4296502420 13 D-2     /
      DATA BIFCS(  4) / +.1186254546 7744681179 2164592100 40 D-4     /
      DATA BIFCS(  5) / +.4493290701 7792133694 5318879272 42 D-7     /
      DATA BIFCS(  6) / +.1069820714 3387889067 5677676636 28 D-9     /
      DATA BIFCS(  7) / +.1748064339 9771824706 0105176285 73 D-12    /
      DATA BIFCS(  8) / +.2081023107 1761711025 8818918343 99 D-15    /
      DATA BIFCS(  9) / +.1884981469 5665416509 9279717333 33 D-18    /
      DATA BIFCS( 10) / +.1342577917 3097804625 8826666666 66 D-21    /
      DATA BIFCS( 11) / +.7715959342 9658887893 3333333333 33 D-25    /
      DATA BIFCS( 12) / +.3653387961 7478566399 9999999999 99 D-28    /
      DATA BIFCS( 13) / +.1449756592 7953066666 6666666666 66 D-31    /
      DATA BIGCS(  1) / +.2246622324 8574522283 4682201390 24 D-1     /
      DATA BIGCS(  2) / +.3736477545 3019545441 7275616667 52 D-1     /
      DATA BIGCS(  3) / +.4447621895 7212285696 2152943266 39 D-3     /
      DATA BIGCS(  4) / +.2470807563 6329384245 4945919488 82 D-5     /
      DATA BIGCS(  5) / +.7919135339 5149635134 8624262855 96 D-8     /
      DATA BIGCS(  6) / +.1649807985 1827779880 8878724027 06 D-10    /
      DATA BIGCS(  7) / +.2411990666 4835455909 2475011228 41 D-13    /
      DATA BIGCS(  8) / +.2610373623 6091436985 1847812693 33 D-16    /
      DATA BIGCS(  9) / +.2175308297 7160323853 1237920000 00 D-19    /
      DATA BIGCS( 10) / +.1438694640 0390433219 4837333333 33 D-22    /
      DATA BIGCS( 11) / +.7734912561 2083468629 3333333333 33 D-26    /
      DATA BIGCS( 12) / +.3446929203 3849002666 6666666666 66 D-29    /
      DATA BIGCS( 13) / +.1293891927 3216000000 0000000000 00 D-32    /
      DATA BIF2CS(  1) / +.0998457269 3816041044 6828425799 3 D+0      /
      DATA BIF2CS(  2) / +.4786249778 6300553772 2114673182 31 D+0     /
      DATA BIF2CS(  3) / +.2515521196 0433011771 3244154366 75 D-1     /
      DATA BIF2CS(  4) / +.5820693885 2326456396 5156978722 16 D-3     /
      DATA BIF2CS(  5) / +.7499765964 4377865943 8614573782 17 D-5     /
      DATA BIF2CS(  6) / +.6134602870 3493836681 4030103564 74 D-7     /
      DATA BIF2CS(  7) / +.3462753885 1480632900 4342687333 59 D-9     /
      DATA BIF2CS(  8) / +.1428891008 0270254287 7708467489 31 D-11    /
      DATA BIF2CS(  9) / +.4496270429 8334641895 0564721792 00 D-14    /
      DATA BIF2CS( 10) / +.1114232306 5833011708 4283001066 66 D-16    /
      DATA BIF2CS( 11) / +.2230479106 6175002081 5178666666 66 D-19    /
      DATA BIF2CS( 12) / +.3681577873 6393142842 9226666666 66 D-22    /
      DATA BIF2CS( 13) / +.5096086844 9338261333 3333333333 33 D-25    /
      DATA BIF2CS( 14) / +.6000338692 6288554666 6666666666 66 D-28    /
      DATA BIF2CS( 15) / +.6082749744 6570666666 6666666666 66 D-31    /
      DATA BIG2CS(  1) / +.0333056621 4551434046 5176188111 647 D+0    /
      DATA BIG2CS(  2) / +.1613092151 2319706761 3287532084 943 D+0    /
      DATA BIG2CS(  3) / +.6319007309 6134286912 1615634921 173 D-2    /
      DATA BIG2CS(  4) / +.1187904568 1625173638 9780192304 567 D-3    /
      DATA BIG2CS(  5) / +.1304534588 6200265614 7116485012 843 D-5    /
      DATA BIG2CS(  6) / +.9374125995 5352172954 6809615508 936 D-8    /
      DATA BIG2CS(  7) / +.4745801886 7472515378 8510169834 595 D-10   /
      DATA BIG2CS(  8) / +.1783107265 0948139980 0065667560 946 D-12   /
      DATA BIG2CS(  9) / +.5167591927 8495818037 4276356640 000 D-15   /
      DATA BIG2CS( 10) / +.1190045083 8682712512 9496251733 333 D-17   /
      DATA BIG2CS( 11) / +.2229828806 6640351727 7063466666 666 D-20   /
      DATA BIG2CS( 12) / +.3465519230 2768941972 2666666666 666 D-23   /
      DATA BIG2CS( 13) / +.4539263363 2050451413 3333333333 333 D-26   /
      DATA BIG2CS( 14) / +.5078849965 1352234666 6666666666 666 D-29   /
      DATA BIG2CS( 15) / +.4910206746 9653333333 3333333333 333 D-32   /
      DATA BIP1CS(  1) / -.8322047477 9434474687 4718647079 73 D-1     /
      DATA BIP1CS(  2) / +.1146118927 3711742889 9202261280 31 D-1     /
      DATA BIP1CS(  3) / +.4289644071 8911509494 1344725666 35 D-3     /
      DATA BIP1CS(  4) / -.1490663937 9950514017 8476777329 54 D-3     /
      DATA BIP1CS(  5) / -.1307659726 7876290663 1363409988 81 D-4     /
      DATA BIP1CS(  6) / +.6327598396 1030344754 5357160324 94 D-5     /
      DATA BIP1CS(  7) / -.4222669698 2681924884 7785158894 33 D-6     /
      DATA BIP1CS(  8) / -.1914718629 8654689632 8354941812 77 D-6     /
      DATA BIP1CS(  9) / +.6453106284 5583173611 0381578809 34 D-7     /
      DATA BIP1CS( 10) / -.7844854677 1397719289 7483104486 28 D-8     /
      DATA BIP1CS( 11) / -.9607721662 3785085879 1985335654 32 D-9     /
      DATA BIP1CS( 12) / +.7000471331 6443966339 0060744020 68 D-9     /
      DATA BIP1CS( 13) / -.1773178913 2814932022 0831280566 98 D-9     /
      DATA BIP1CS( 14) / +.2272089478 3465236347 2821263893 11 D-10    /
      DATA BIP1CS( 15) / +.1654045631 3972049847 0328606818 91 D-11    /
      DATA BIP1CS( 16) / -.1851712555 9292316390 7553698966 93 D-11    /
      DATA BIP1CS( 17) / +.5957631247 7117290165 6807155342 77 D-12    /
      DATA BIP1CS( 18) / -.1219434814 7346564781 0557694989 86 D-12    /
      DATA BIP1CS( 19) / +.1334786925 3513048815 3863478135 97 D-13    /
      DATA BIP1CS( 20) / +.1727831152 4339746664 3847928897 31 D-14    /
      DATA BIP1CS( 21) / -.1459073201 3016720735 2688717131 66 D-14    /
      DATA BIP1CS( 22) / +.4901031992 7115819978 9949895201 04 D-15    /
      DATA BIP1CS( 23) / -.1155654551 9261548129 2629727625 21 D-15    /
      DATA BIP1CS( 24) / +.1909880736 7072411430 6717324415 24 D-16    /
      DATA BIP1CS( 25) / -.1176896685 4492179886 9139959578 62 D-17    /
      DATA BIP1CS( 26) / -.6327192514 9530064474 5374596770 47 D-18    /
      DATA BIP1CS( 27) / +.3386183888 0715361614 1301913223 16 D-18    /
      DATA BIP1CS( 28) / -.1072582532 1758625254 9921622196 22 D-18    /
      DATA BIP1CS( 29) / +.2599570960 5617169284 7869331155 62 D-19    /
      DATA BIP1CS( 30) / -.4847758357 1081193660 9623094941 01 D-20    /
      DATA BIP1CS( 31) / +.5529891398 2121625361 5055131989 33 D-21    /
      DATA BIP1CS( 32) / +.4942166082 6069471371 7481974442 66 D-22    /
      DATA BIP1CS( 33) / -.5516212192 4145707458 0697208149 33 D-22    /
      DATA BIP1CS( 34) / +.2143756041 7632550086 6318844996 26 D-22    /
      DATA BIP1CS( 35) / -.6191031338 7655605798 7850611370 66 D-23    /
      DATA BIP1CS( 36) / +.1462936270 7391245659 8309673369 59 D-23    /
      DATA BIP1CS( 37) / -.2791848447 1059005576 1778660693 33 D-24    /
      DATA BIP1CS( 38) / +.3645570316 8570246150 9067953493 33 D-25    /
      DATA BIP1CS( 39) / +.5851182190 6188711839 3824597333 33 D-27    /
      DATA BIP1CS( 40) / -.2494695048 7566510969 7450475519 99 D-26    /
      DATA BIP1CS( 41) / +.1097932398 0338380977 9195794773 33 D-26    /
      DATA BIP1CS( 42) / -.3474338834 5961115015 0340881066 66 D-27    /
      DATA BIP1CS( 43) / +.9137340263 5349697363 1710822400 00 D-28    /
      DATA BIP1CS( 44) / -.2051035272 8210629186 2477209599 99 D-28    /
      DATA BIP1CS( 45) / +.3797698569 8546461748 6516223999 99 D-29    /
      DATA BIP1CS( 46) / -.4847945849 7755565887 8484480000 00 D-30    /
      DATA BIP1CS( 47) / -.1055830694 1230714314 2058666666 66 D-31    /
      DATA BIP2CS(  1) / -.1135967375 8598867913 7973108955 27 D+0     /
      DATA BIP2CS(  2) / +.4138147394 7881595760 0520811714 44 D-2     /
      DATA BIP2CS(  3) / +.1353470622 1193329857 6969217275 08 D-3     /
      DATA BIP2CS(  4) / +.1042731665 3015353405 8871834567 80 D-4     /
      DATA BIP2CS(  5) / +.1347495476 7849907889 5899119589 25 D-5     /
      DATA BIP2CS(  6) / +.1696537405 4383983356 0625111637 56 D-6     /
      DATA BIP2CS(  7) / -.1009650086 5641624301 3662283963 73 D-7     /
      DATA BIP2CS(  8) / -.1672911949 3778475127 8369730959 43 D-7     /
      DATA BIP2CS(  9) / -.4581536448 5068383217 1527956133 91 D-8     /
      DATA BIP2CS( 10) / +.3736681366 5655477274 0647493842 84 D-9     /
      DATA BIP2CS( 11) / +.5766930320 1452448119 5846435021 11 D-9     /
      DATA BIP2CS( 12) / +.6218126508 7850324095 3934087923 71 D-10    /
      DATA BIP2CS( 13) / -.6329412028 2743068241 5891772813 54 D-10    /
      DATA BIP2CS( 14) / -.1491504790 8598767633 9990919894 87 D-10    /
      DATA BIP2CS( 15) / +.7889621394 2486771938 1723942948 91 D-11    /
      DATA BIP2CS( 16) / +.2496051372 1857797984 8880640001 27 D-11    /
      DATA BIP2CS( 17) / -.1213007528 7291659477 7466647348 14 D-11    /
      DATA BIP2CS( 18) / -.3740493910 8727277887 3434604027 16 D-12    /
      DATA BIP2CS( 19) / +.2237727814 0321476798 7834469310 91 D-12    /
      DATA BIP2CS( 20) / +.4749029631 2192466341 9860774725 14 D-13    /
      DATA BIP2CS( 21) / -.4526160799 1821224810 6056558312 94 D-13    /
      DATA BIP2CS( 22) / -.3017227184 1986072645 1122458760 20 D-14    /
      DATA BIP2CS( 23) / +.9105860355 8754058327 5926834789 08 D-14    /
      DATA BIP2CS( 24) / -.9814923803 3807062926 6438642077 09 D-15    /
      DATA BIP2CS( 25) / -.1642940064 7889465253 6012452515 89 D-14    /
      DATA BIP2CS( 26) / +.5533483421 4274215451 1821146351 64 D-15    /
      DATA BIP2CS( 27) / +.2175047986 4482655984 3743819981 56 D-15    /
      DATA BIP2CS( 28) / -.1737923620 0220656971 2870295580 87 D-15    /
      DATA BIP2CS( 29) / -.1047002347 1443714959 2839093136 04 D-17    /
      DATA BIP2CS( 30) / +.3921914598 6056386925 4414033114 62 D-16    /
      DATA BIP2CS( 31) / -.1162129368 6345196925 8240056659 10 D-16    /
      DATA BIP2CS( 32) / -.5402747449 1754245533 7354113077 73 D-17    /
      DATA BIP2CS( 33) / +.4544158212 3884610882 6754285533 04 D-17    /
      DATA BIP2CS( 34) / -.2877559962 5221075729 4275854800 86 D-18    /
      DATA BIP2CS( 35) / -.1001734092 7225341243 5961629604 40 D-17    /
      DATA BIP2CS( 36) / +.4482393121 5068369856 3325619063 13 D-18    /
      DATA BIP2CS( 37) / +.7613596865 4908942328 9489823667 75 D-19    /
      DATA BIP2CS( 38) / -.1444832409 4881347238 9560601454 22 D-18    /
      DATA BIP2CS( 39) / +.4046085944 9205362251 6248473921 12 D-19    /
      DATA BIP2CS( 40) / +.2032108570 0338446891 3251907072 77 D-19    /
      DATA BIP2CS( 41) / -.1960279547 1446798718 2727580419 62 D-19    /
      DATA BIP2CS( 42) / +.3427303844 3944824263 5189582117 38 D-20    /
      DATA BIP2CS( 43) / +.3702370585 3905135480 0246515931 54 D-20    /
      DATA BIP2CS( 44) / -.2687959517 2041591131 4003329667 12 D-20    /
      DATA BIP2CS( 45) / +.2812167846 3531712209 7144546833 64 D-21    /
      DATA BIP2CS( 46) / +.6093396363 6177797173 2711196803 29 D-21    /
      DATA BIP2CS( 47) / -.3866662189 7150844994 1729778934 13 D-21    /
      DATA BIP2CS( 48) / +.2598933125 3566943450 8956519272 28 D-22    /
      DATA BIP2CS( 49) / +.9719439362 2938503767 2811752160 84 D-22    /
      DATA BIP2CS( 50) / -.5939281783 4375098415 6304782045 91 D-22    /
      DATA BIP2CS( 51) / +.3886494997 7113015409 5919604394 44 D-23    /
      DATA BIP2CS( 52) / +.1533430739 3617272869 7215128687 69 D-22    /
      DATA BIP2CS( 53) / -.9751355520 9762624036 3365214097 24 D-23    /
      DATA BIP2CS( 54) / +.9634064444 0489471424 7413393837 26 D-24    /
      DATA BIP2CS( 55) / +.2384199940 0208880109 9467487924 54 D-23    /
      DATA BIP2CS( 56) / -.1689698631 5019706184 8480442052 07 D-23    /
      DATA BIP2CS( 57) / +.2735271588 8928361222 5784448014 78 D-24    /
      DATA BIP2CS( 58) / +.3566001618 5409578960 1116850257 30 D-24    /
      DATA BIP2CS( 59) / -.3023402660 8258827249 5342806669 54 D-24    /
      DATA BIP2CS( 60) / +.7500204160 5973930653 1442048232 32 D-25    /
      DATA BIP2CS( 61) / +.4840328757 5851388827 4553198387 48 D-25    /
      DATA BIP2CS( 62) / -.5436413765 4447888432 6980102977 66 D-25    /
      DATA BIP2CS( 63) / +.1928121447 0820962653 3459788097 56 D-25    /
      DATA BIP2CS( 64) / +.5011635502 0532656659 6118141721 72 D-26    /
      DATA BIP2CS( 65) / -.9504074458 2693253786 0346208699 72 D-26    /
      DATA BIP2CS( 66) / +.4637264615 7101975948 6963322456 11 D-26    /
      DATA BIP2CS( 67) / +.2117717070 4466954163 7681705770 46 D-28    /
      DATA BIP2CS( 68) / -.1540485026 8168594303 6922045487 26 D-26    /
      DATA BIP2CS( 69) / +.1038794429 3201213662 0478891944 41 D-26    /
      DATA BIP2CS( 70) / -.1989007815 6915416751 3167282351 53 D-27    /
      DATA BIP2CS( 71) / -.2102217387 8658495471 1770445225 32 D-27    /
      DATA BIP2CS( 72) / +.2135309972 4525793150 6333566704 91 D-27    /
      DATA BIP2CS( 73) / -.7904081074 7961342319 0235376326 27 D-28    /
      DATA BIP2CS( 74) / -.1657535996 0435585049 9737417635 92 D-28    /
      DATA BIP2CS( 75) / +.3886834285 0124112587 6255864965 37 D-28    /
      DATA BIP2CS( 76) / -.2230923733 0896866182 6215624247 17 D-28    /
      DATA BIP2CS( 77) / +.2777724442 0176260265 6259774043 82 D-29    /
      DATA BIP2CS( 78) / +.5707854347 2657725368 7124337827 72 D-29    /
      DATA BIP2CS( 79) / -.5174308444 5303852800 1733715552 80 D-29    /
      DATA BIP2CS( 80) / +.1841328075 1095837198 4509270715 69 D-29    /
      DATA BIP2CS( 81) / +.4442256239 0957094598 5440710686 47 D-30    /
      DATA BIP2CS( 82) / -.9850414263 9629801547 4649582269 43 D-30    /
      DATA BIP2CS( 83) / +.5885720135 3585104884 7541988819 95 D-30    /
      DATA BIP2CS( 84) / -.9763607544 0429787961 4023126285 95 D-31    /
      DATA BIP2CS( 85) / -.1358101199 6074695047 0635978841 22 D-30    /
      DATA BIP2CS( 86) / +.1399974351 8492413270 5680483803 45 D-30    /
      DATA BIP2CS( 87) / -.5975490454 5248477620 8845629811 18 D-31    /
      DATA BIP2CS( 88) / -.4039165387 5428313641 0453275298 56 D-32    /
      DATA ATR / 8.750690570 8484345088 0771988210 148 D0 /
      DATA BTR / -2.093836321 3560543136 0096498526 268 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  DBIE
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NBIF = INITDS (BIFCS, 13, ETA)
         NBIG = INITDS (BIGCS, 13, ETA)
         NBIF2 = INITDS (BIF2CS, 15, ETA)
         NBIG2 = INITDS (BIG2CS, 15, ETA)
         NBIP1 = INITDS (BIP1CS, 47, ETA)
         NBIP2 = INITDS (BIP2CS, 88, ETA)
C
         X3SML = ETA**0.3333
         X32SML = 1.3104D0*X3SML**2
         XBIG = D1MACH(2)**0.6666D0
      ENDIF
      FIRST = .FALSE.
C
      IF (X.GE.(-1.0D0)) GO TO 20
      CALL D9AIMP (X, XM, THETA)
      DBIE = XM * SIN(THETA)
      RETURN
C
 20   IF (X.GT.1.0D0) GO TO 30
      Z = 0.D0
      IF (ABS(X).GT.X3SML) Z = X**3
      DBIE = 0.625D0 + DCSEVL (Z, BIFCS, NBIF) + X*(0.4375D0 +
     1  DCSEVL (Z, BIGCS, NBIG) )
      IF (X.GT.X32SML) DBIE = DBIE * EXP(-2.0D0*X*SQRT(X)/3.0D0)
      RETURN
C
 30   IF (X.GT.2.0D0) GO TO 40
      Z = (2.0D0*X**3 - 9.0D0)/7.0D0
      DBIE = EXP(-2.0D0*X*SQRT(X)/3.0D0) * (1.125D0 +
     1  DCSEVL (Z, BIF2CS, NBIF2) + X*(0.625D0 + DCSEVL (Z, BIG2CS,
     2  NBIG2)) )
      RETURN
C
 40   IF (X.GT.4.0D0) GO TO 50
      SQRTX = SQRT(X)
      Z = ATR/(X*SQRTX) + BTR
      DBIE = (0.625D0 + DCSEVL (Z, BIP1CS, NBIP1))/SQRT(SQRTX)
      RETURN
C
 50   SQRTX = SQRT(X)
      Z = -1.0D0
      IF (X.LT.XBIG) Z = 16.D0/(X*SQRTX) - 1.0D0
      DBIE = (0.625D0 + DCSEVL (Z, BIP2CS, NBIP2))/SQRT(SQRTX)
      RETURN
C
      END
