# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class VRModel(Object):
    r"""
    VRModel - VR device model
    
    Superclass: Object
    
    Abstract class used to load models such as for the trackers and
    controllers and to render them in the scene
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRModel, obj, update, **traits)
    
    name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetName,
                        self.name)

    def _get_visibility(self):
        return self._vtk_obj.GetVisibility()
    def _set_visibility(self, arg):
        old_val = self._get_visibility()
        self._wrap_call(self._vtk_obj.SetVisibility,
                        arg)
        self.trait_property_changed('visibility', old_val, arg)
    visibility = traits.Property(_get_visibility, _set_visibility, desc=\
        r"""
        
        """
    )

    def _get_ray(self):
        return wrap_vtk(self._vtk_obj.GetRay())
    ray = traits.Property(_get_ray, desc=\
        r"""
        
        """
    )

    def build(self, *args):
        """
        build(self, win:OpenGLRenderWindow) -> bool
        C++: bool build(OpenGLRenderWindow *win)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Build, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, win:Window) -> None
        C++: void release_graphics_resources(Window *win)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def render(self, *args):
        """
        render(self, win:OpenGLRenderWindow,
            poseInTrackingCoordinates:Matrix4x4) -> None
        C++: void render(OpenGLRenderWindow *win,
            Matrix4x4 *poseInTrackingCoordinates)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    def set_ray_color(self, *args):
        """
        set_ray_color(self, r:float, g:float, b:float) -> None
        C++: void set_ray_color(double r, double g, double b)"""
        ret = self._wrap_call(self._vtk_obj.SetRayColor, *args)
        return ret

    def set_ray_length(self, *args):
        """
        set_ray_length(self, length:float) -> None
        C++: void set_ray_length(double length)"""
        ret = self._wrap_call(self._vtk_obj.SetRayLength, *args)
        return ret

    def set_show_ray(self, *args):
        """
        set_show_ray(self, v:bool) -> None
        C++: void set_show_ray(bool v)"""
        ret = self._wrap_call(self._vtk_obj.SetShowRay, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('name', 'GetName'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'name', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRModel, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRModel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['name', 'object_name']),
            title='Edit VRModel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRModel properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

