/* Settings.c generated by valac 0.38.4, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
enum  {
	SETTINGS_0_PROPERTY,
	SETTINGS_DEVICE_PROPERTY,
	SETTINGS_BAUD_RATE_PROPERTY,
	SETTINGS_DATA_BITS_PROPERTY,
	SETTINGS_STOP_BITS_PROPERTY,
	SETTINGS_PARITY_PROPERTY,
	SETTINGS_HANDSHAKE_PROPERTY,
	SETTINGS_ACCESS_MODE_PROPERTY,
	SETTINGS_LOCAL_ECHO_PROPERTY,
	SETTINGS_NUM_PROPERTIES
};
static GParamSpec* settings_properties[SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

struct _SettingsPrivate {
	gchar* _device;
	gint _baudRate;
	gint _dataBits;
	gint _stopBits;
	SettingsParity _parity;
	SettingsHandshake _handshake;
	SettingsAccessMode _accessMode;
	gboolean _localEcho;
};

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer settings_parent_class = NULL;
extern gchar* settings_DEFAULT_DEVICEFILE;
gchar* settings_DEFAULT_DEVICEFILE = NULL;
extern gint settings_DEFAULT_BAUDRATE;
gint settings_DEFAULT_BAUDRATE = 1200;
extern gint settings_DEFAULT_DATABITS;
gint settings_DEFAULT_DATABITS = 8;
extern gint settings_DEFAULT_STOPBITS;
gint settings_DEFAULT_STOPBITS = 1;
extern SettingsParity settings_DEFAULT_PARITY;
SettingsParity settings_DEFAULT_PARITY = SETTINGS_PARITY_NONE;
extern SettingsHandshake settings_DEFAULT_HANDSHAKE;
SettingsHandshake settings_DEFAULT_HANDSHAKE = SETTINGS_HANDSHAKE_HARDWARE;
extern SettingsAccessMode settings_DEFAULT_ACCESSMODE;
SettingsAccessMode settings_DEFAULT_ACCESSMODE = SETTINGS_ACCESS_MODE_READWRITE;
extern gboolean settings_DEFAULT_LOCAL_ECHO;
gboolean settings_DEFAULT_LOCAL_ECHO = FALSE;

GType settings_get_type (void) G_GNUC_CONST;
GType settings_parity_get_type (void) G_GNUC_CONST;
GType settings_handshake_get_type (void) G_GNUC_CONST;
GType settings_access_mode_get_type (void) G_GNUC_CONST;
#define SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS, SettingsPrivate))
Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
gchar* settings_parityToChar (Settings* self);
SettingsParity settings_get_parity (Settings* self);
gchar* settings_getStatusbarString (Settings* self, gboolean open);
const gchar* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType profile_get_type (void) G_GNUC_CONST;
void settings_saveToProfile (Settings* self, Profile* profile);
SettingsHandshake settings_get_handshake (Settings* self);
SettingsAccessMode settings_get_accessMode (Settings* self);
gboolean settings_get_localEcho (Settings* self);
Settings* settings_loadFromProfile (Profile* profile);
gchar* mo_utils_getKeyString (Profile* profile, const gchar* group, const gchar* key);
gint mo_utils_getKeyInteger (Profile* profile, const gchar* group, const gchar* key, gint default_val);
gboolean mo_utils_getKeyBoolean (Profile* profile, const gchar* group, const gchar* key, gboolean default_val);
static void settings_set_device (Settings* self, const gchar* value);
static void settings_set_baudRate (Settings* self, gint value);
static void settings_set_dataBits (Settings* self, gint value);
static void settings_set_stopBits (Settings* self, gint value);
static void settings_set_parity (Settings* self, SettingsParity value);
static void settings_set_handshake (Settings* self, SettingsHandshake value);
static void settings_set_accessMode (Settings* self, SettingsAccessMode value);
static void settings_set_localEcho (Settings* self, gboolean value);
static GObject * settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void settings_finalize (GObject * obj);
static void _vala_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

const gchar* SETTINGS_ParityModeStrings[5] = {N_ ("None"), N_ ("Odd"), N_ ("Even"), N_ ("Mark"), N_ ("Space")};
const gchar* SETTINGS_AccessModeStrings[3] = {N_ ("Read and Write"), N_ ("Read Only"), N_ ("Write Only")};
const gchar* SETTINGS_DataBitItems[4] = {"5", "6", "7", "8"};
const gchar* SETTINGS_StopBitItems[2] = {"1", "2"};
const gchar* SETTINGS_BaudRateItems[16] = {"300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200", "230400", "460800", "576000", "921600", "1000000", "2000000"};

GType settings_parity_get_type (void) {
	static volatile gsize settings_parity_type_id__volatile = 0;
	if (g_once_init_enter (&settings_parity_type_id__volatile)) {
		static const GEnumValue values[] = {{SETTINGS_PARITY_NONE, "SETTINGS_PARITY_NONE", "none"}, {SETTINGS_PARITY_ODD, "SETTINGS_PARITY_ODD", "odd"}, {SETTINGS_PARITY_EVEN, "SETTINGS_PARITY_EVEN", "even"}, {SETTINGS_PARITY_MARK, "SETTINGS_PARITY_MARK", "mark"}, {SETTINGS_PARITY_SPACE, "SETTINGS_PARITY_SPACE", "space"}, {0, NULL, NULL}};
		GType settings_parity_type_id;
		settings_parity_type_id = g_enum_register_static ("SettingsParity", values);
		g_once_init_leave (&settings_parity_type_id__volatile, settings_parity_type_id);
	}
	return settings_parity_type_id__volatile;
}


GType settings_handshake_get_type (void) {
	static volatile gsize settings_handshake_type_id__volatile = 0;
	if (g_once_init_enter (&settings_handshake_type_id__volatile)) {
		static const GEnumValue values[] = {{SETTINGS_HANDSHAKE_NONE, "SETTINGS_HANDSHAKE_NONE", "none"}, {SETTINGS_HANDSHAKE_HARDWARE, "SETTINGS_HANDSHAKE_HARDWARE", "hardware"}, {SETTINGS_HANDSHAKE_SOFTWARE, "SETTINGS_HANDSHAKE_SOFTWARE", "software"}, {SETTINGS_HANDSHAKE_BOTH, "SETTINGS_HANDSHAKE_BOTH", "both"}, {0, NULL, NULL}};
		GType settings_handshake_type_id;
		settings_handshake_type_id = g_enum_register_static ("SettingsHandshake", values);
		g_once_init_leave (&settings_handshake_type_id__volatile, settings_handshake_type_id);
	}
	return settings_handshake_type_id__volatile;
}


GType settings_access_mode_get_type (void) {
	static volatile gsize settings_access_mode_type_id__volatile = 0;
	if (g_once_init_enter (&settings_access_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SETTINGS_ACCESS_MODE_READWRITE, "SETTINGS_ACCESS_MODE_READWRITE", "readwrite"}, {SETTINGS_ACCESS_MODE_READONLY, "SETTINGS_ACCESS_MODE_READONLY", "readonly"}, {SETTINGS_ACCESS_MODE_WRITEONLY, "SETTINGS_ACCESS_MODE_WRITEONLY", "writeonly"}, {0, NULL, NULL}};
		GType settings_access_mode_type_id;
		settings_access_mode_type_id = g_enum_register_static ("SettingsAccessMode", values);
		g_once_init_leave (&settings_access_mode_type_id__volatile, settings_access_mode_type_id);
	}
	return settings_access_mode_type_id__volatile;
}


Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho) {
	Settings * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SettingsParity _tmp4_;
	SettingsHandshake _tmp5_;
	SettingsAccessMode _tmp6_;
	gboolean _tmp7_;
	_tmp0_ = device;
	_tmp1_ = baudRate;
	_tmp2_ = dataBits;
	_tmp3_ = stopBits;
	_tmp4_ = parity;
	_tmp5_ = handshake;
	_tmp6_ = accessMode;
	_tmp7_ = localEcho;
	self = (Settings*) g_object_new (object_type, "device", _tmp0_, "baudRate", _tmp1_, "dataBits", _tmp2_, "stopBits", _tmp3_, "parity", _tmp4_, "handshake", _tmp5_, "accessMode", _tmp6_, "localEcho", _tmp7_, NULL);
	return self;
}


Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho) {
	return settings_construct (TYPE_SETTINGS, device, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho);
}


gchar* settings_parityToChar (Settings* self) {
	gchar* result = NULL;
	SettingsParity _tmp0_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parity;
	switch (_tmp0_) {
		case SETTINGS_PARITY_NONE:
		{
			{
				gchar* _tmp1_;
				_tmp1_ = g_strdup (_ ("N"));
				result = _tmp1_;
				return result;
			}
		}
		case SETTINGS_PARITY_ODD:
		{
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup (_ ("O"));
				result = _tmp2_;
				return result;
			}
		}
		case SETTINGS_PARITY_EVEN:
		{
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (_ ("E"));
				result = _tmp3_;
				return result;
			}
		}
		case SETTINGS_PARITY_MARK:
		{
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("M"));
				result = _tmp4_;
				return result;
			}
		}
		case SETTINGS_PARITY_SPACE:
		{
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (_ ("S"));
				result = _tmp5_;
				return result;
			}
		}
		default:
		break;
	}
	_tmp6_ = g_strdup ("?");
	result = _tmp6_;
	return result;
}


gchar* settings_getStatusbarString (Settings* self, gboolean open) {
	gchar* result = NULL;
	gchar* r = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = g_strdup_printf ("%s", _tmp0_);
	_g_free0 (r);
	r = _tmp1_;
	_tmp2_ = open;
	if (_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = r;
		_tmp4_ = g_strconcat (_tmp3_, " ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, _ ("OPEN"), NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, " ", NULL);
		_g_free0 (r);
		r = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = r;
		_tmp10_ = g_strconcat (_tmp9_, " ", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, _ ("CLOSED"), NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, " ", NULL);
		_g_free0 (r);
		r = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
	}
	_tmp15_ = r;
	_tmp16_ = self->priv->_baudRate;
	_tmp17_ = self->priv->_dataBits;
	_tmp18_ = settings_parityToChar (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->_stopBits;
	_tmp21_ = g_strdup_printf ("%i,%i%s%i", _tmp16_, _tmp17_, _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp15_, _tmp22_, NULL);
	_g_free0 (r);
	r = _tmp23_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	result = r;
	return result;
}


void settings_saveToProfile (Settings* self, Profile* profile) {
	Profile* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	Profile* _tmp3_;
	GKeyFile* _tmp4_;
	gint _tmp5_;
	Profile* _tmp6_;
	GKeyFile* _tmp7_;
	gint _tmp8_;
	Profile* _tmp9_;
	GKeyFile* _tmp10_;
	gint _tmp11_;
	Profile* _tmp12_;
	GKeyFile* _tmp13_;
	SettingsParity _tmp14_;
	Profile* _tmp15_;
	GKeyFile* _tmp16_;
	SettingsHandshake _tmp17_;
	Profile* _tmp18_;
	GKeyFile* _tmp19_;
	SettingsAccessMode _tmp20_;
	Profile* _tmp21_;
	GKeyFile* _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	_tmp0_ = profile;
	_tmp1_ = _tmp0_->keyFile;
	_tmp2_ = self->priv->_device;
	g_key_file_set_string (_tmp1_, "port_settings", "device", _tmp2_);
	_tmp3_ = profile;
	_tmp4_ = _tmp3_->keyFile;
	_tmp5_ = self->priv->_baudRate;
	g_key_file_set_integer (_tmp4_, "port_settings", "baud_rate", _tmp5_);
	_tmp6_ = profile;
	_tmp7_ = _tmp6_->keyFile;
	_tmp8_ = self->priv->_dataBits;
	g_key_file_set_integer (_tmp7_, "port_settings", "data_bits", _tmp8_);
	_tmp9_ = profile;
	_tmp10_ = _tmp9_->keyFile;
	_tmp11_ = self->priv->_stopBits;
	g_key_file_set_integer (_tmp10_, "port_settings", "stop_bits", _tmp11_);
	_tmp12_ = profile;
	_tmp13_ = _tmp12_->keyFile;
	_tmp14_ = self->priv->_parity;
	g_key_file_set_integer (_tmp13_, "port_settings", "parity", (gint) _tmp14_);
	_tmp15_ = profile;
	_tmp16_ = _tmp15_->keyFile;
	_tmp17_ = self->priv->_handshake;
	g_key_file_set_integer (_tmp16_, "port_settings", "handshake", (gint) _tmp17_);
	_tmp18_ = profile;
	_tmp19_ = _tmp18_->keyFile;
	_tmp20_ = self->priv->_accessMode;
	g_key_file_set_integer (_tmp19_, "port_settings", "access_mode", (gint) _tmp20_);
	_tmp21_ = profile;
	_tmp22_ = _tmp21_->keyFile;
	_tmp23_ = self->priv->_localEcho;
	g_key_file_set_boolean (_tmp22_, "port_settings", "local_echo", _tmp23_);
}


Settings* settings_loadFromProfile (Profile* profile) {
	Settings* result = NULL;
	gchar* device = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean localEcho = FALSE;
	Profile* _tmp2_;
	gchar* _tmp3_;
	Profile* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Profile* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Profile* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	Profile* _tmp13_;
	SettingsParity _tmp14_;
	gint _tmp15_;
	Profile* _tmp16_;
	SettingsHandshake _tmp17_;
	gint _tmp18_;
	Profile* _tmp19_;
	SettingsAccessMode _tmp20_;
	gint _tmp21_;
	Profile* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	Settings* _tmp26_;
	g_return_val_if_fail (profile != NULL, NULL);
	_tmp0_ = settings_DEFAULT_DEVICEFILE;
	_tmp1_ = g_strdup (_tmp0_);
	device = _tmp1_;
	_tmp2_ = profile;
	_tmp3_ = mo_utils_getKeyString (_tmp2_, "port_settings", "device");
	_g_free0 (device);
	device = _tmp3_;
	_tmp4_ = profile;
	_tmp5_ = settings_DEFAULT_BAUDRATE;
	_tmp6_ = mo_utils_getKeyInteger (_tmp4_, "port_settings", "baud_rate", _tmp5_);
	baudRate = _tmp6_;
	_tmp7_ = profile;
	_tmp8_ = settings_DEFAULT_DATABITS;
	_tmp9_ = mo_utils_getKeyInteger (_tmp7_, "port_settings", "data_bits", _tmp8_);
	dataBits = _tmp9_;
	_tmp10_ = profile;
	_tmp11_ = settings_DEFAULT_STOPBITS;
	_tmp12_ = mo_utils_getKeyInteger (_tmp10_, "port_settings", "stop_bits", _tmp11_);
	stopBits = _tmp12_;
	_tmp13_ = profile;
	_tmp14_ = settings_DEFAULT_PARITY;
	_tmp15_ = mo_utils_getKeyInteger (_tmp13_, "port_settings", "parity", (gint) _tmp14_);
	parity = (SettingsParity) _tmp15_;
	_tmp16_ = profile;
	_tmp17_ = settings_DEFAULT_HANDSHAKE;
	_tmp18_ = mo_utils_getKeyInteger (_tmp16_, "port_settings", "handshake", (gint) _tmp17_);
	handshake = (SettingsHandshake) _tmp18_;
	_tmp19_ = profile;
	_tmp20_ = settings_DEFAULT_ACCESSMODE;
	_tmp21_ = mo_utils_getKeyInteger (_tmp19_, "port_settings", "access_mode", (gint) _tmp20_);
	accessMode = (SettingsAccessMode) _tmp21_;
	_tmp22_ = profile;
	_tmp23_ = settings_DEFAULT_LOCAL_ECHO;
	_tmp24_ = mo_utils_getKeyBoolean (_tmp22_, "port_settings", "local_echo", _tmp23_);
	localEcho = _tmp24_;
	_tmp25_ = device;
	_tmp26_ = settings_new (_tmp25_, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho);
	result = _tmp26_;
	_g_free0 (device);
	return result;
}


const gchar* settings_get_device (Settings* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void settings_set_device (Settings* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, settings_get_device (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_device);
		self->priv->_device = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_DEVICE_PROPERTY]);
	}
}


gint settings_get_baudRate (Settings* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_baudRate;
	result = _tmp0_;
	return result;
}


static void settings_set_baudRate (Settings* self, gint value) {
	g_return_if_fail (self != NULL);
	if (settings_get_baudRate (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_baudRate = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_BAUD_RATE_PROPERTY]);
	}
}


gint settings_get_dataBits (Settings* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dataBits;
	result = _tmp0_;
	return result;
}


static void settings_set_dataBits (Settings* self, gint value) {
	g_return_if_fail (self != NULL);
	if (settings_get_dataBits (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_dataBits = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_DATA_BITS_PROPERTY]);
	}
}


gint settings_get_stopBits (Settings* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_stopBits;
	result = _tmp0_;
	return result;
}


static void settings_set_stopBits (Settings* self, gint value) {
	g_return_if_fail (self != NULL);
	if (settings_get_stopBits (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_stopBits = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_STOP_BITS_PROPERTY]);
	}
}


SettingsParity settings_get_parity (Settings* self) {
	SettingsParity result;
	SettingsParity _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_parity;
	result = _tmp0_;
	return result;
}


static void settings_set_parity (Settings* self, SettingsParity value) {
	g_return_if_fail (self != NULL);
	if (settings_get_parity (self) != value) {
		SettingsParity _tmp0_;
		_tmp0_ = value;
		self->priv->_parity = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_PARITY_PROPERTY]);
	}
}


SettingsHandshake settings_get_handshake (Settings* self) {
	SettingsHandshake result;
	SettingsHandshake _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_handshake;
	result = _tmp0_;
	return result;
}


static void settings_set_handshake (Settings* self, SettingsHandshake value) {
	g_return_if_fail (self != NULL);
	if (settings_get_handshake (self) != value) {
		SettingsHandshake _tmp0_;
		_tmp0_ = value;
		self->priv->_handshake = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_HANDSHAKE_PROPERTY]);
	}
}


SettingsAccessMode settings_get_accessMode (Settings* self) {
	SettingsAccessMode result;
	SettingsAccessMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_accessMode;
	result = _tmp0_;
	return result;
}


static void settings_set_accessMode (Settings* self, SettingsAccessMode value) {
	g_return_if_fail (self != NULL);
	if (settings_get_accessMode (self) != value) {
		SettingsAccessMode _tmp0_;
		_tmp0_ = value;
		self->priv->_accessMode = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_ACCESS_MODE_PROPERTY]);
	}
}


gboolean settings_get_localEcho (Settings* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_localEcho;
	result = _tmp0_;
	return result;
}


static void settings_set_localEcho (Settings* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (settings_get_localEcho (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_localEcho = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_LOCAL_ECHO_PROPERTY]);
	}
}


static GObject * settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Settings * self;
	const gchar* _tmp0_;
	gint _tmp2_;
	gint _tmp4_;
	gint _tmp6_;
	parent_class = G_OBJECT_CLASS (settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	_tmp0_ = self->priv->_device;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = settings_DEFAULT_DEVICEFILE;
		settings_set_device (self, _tmp1_);
	}
	_tmp2_ = self->priv->_baudRate;
	if (_tmp2_ == 0) {
		gint _tmp3_;
		_tmp3_ = settings_DEFAULT_BAUDRATE;
		settings_set_baudRate (self, _tmp3_);
	}
	_tmp4_ = self->priv->_dataBits;
	if (_tmp4_ == 0) {
		gint _tmp5_;
		_tmp5_ = settings_DEFAULT_DATABITS;
		settings_set_dataBits (self, _tmp5_);
	}
	_tmp6_ = self->priv->_stopBits;
	if (_tmp6_ == 0) {
		gint _tmp7_;
		_tmp7_ = settings_DEFAULT_STOPBITS;
		settings_set_stopBits (self, _tmp7_);
	}
	return obj;
}


static void settings_class_init (SettingsClass * klass) {
	gchar* _tmp0_;
	settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SettingsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DEVICE_PROPERTY, settings_properties[SETTINGS_DEVICE_PROPERTY] = g_param_spec_string ("device", "device", "device", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_BAUD_RATE_PROPERTY, settings_properties[SETTINGS_BAUD_RATE_PROPERTY] = g_param_spec_int ("baudRate", "baudRate", "baudRate", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DATA_BITS_PROPERTY, settings_properties[SETTINGS_DATA_BITS_PROPERTY] = g_param_spec_int ("dataBits", "dataBits", "dataBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_STOP_BITS_PROPERTY, settings_properties[SETTINGS_STOP_BITS_PROPERTY] = g_param_spec_int ("stopBits", "stopBits", "stopBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_PARITY_PROPERTY, settings_properties[SETTINGS_PARITY_PROPERTY] = g_param_spec_enum ("parity", "parity", "parity", SETTINGS_TYPE_PARITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_HANDSHAKE_PROPERTY, settings_properties[SETTINGS_HANDSHAKE_PROPERTY] = g_param_spec_enum ("handshake", "handshake", "handshake", SETTINGS_TYPE_HANDSHAKE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_ACCESS_MODE_PROPERTY, settings_properties[SETTINGS_ACCESS_MODE_PROPERTY] = g_param_spec_enum ("accessMode", "accessMode", "accessMode", SETTINGS_TYPE_ACCESS_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_LOCAL_ECHO_PROPERTY, settings_properties[SETTINGS_LOCAL_ECHO_PROPERTY] = g_param_spec_boolean ("localEcho", "localEcho", "localEcho", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("/dev/ttyS0");
	settings_DEFAULT_DEVICEFILE = _tmp0_;
}


static void settings_instance_init (Settings * self) {
	self->priv = SETTINGS_GET_PRIVATE (self);
}


static void settings_finalize (GObject * obj) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	_g_free0 (self->priv->_device);
	G_OBJECT_CLASS (settings_parent_class)->finalize (obj);
}


GType settings_get_type (void) {
	static volatile gsize settings_type_id__volatile = 0;
	if (g_once_init_enter (&settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Settings), 0, (GInstanceInitFunc) settings_instance_init, NULL };
		GType settings_type_id;
		settings_type_id = g_type_register_static (G_TYPE_OBJECT, "Settings", &g_define_type_info, 0);
		g_once_init_leave (&settings_type_id__volatile, settings_type_id);
	}
	return settings_type_id__volatile;
}


static void _vala_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS, Settings);
	switch (property_id) {
		case SETTINGS_DEVICE_PROPERTY:
		g_value_set_string (value, settings_get_device (self));
		break;
		case SETTINGS_BAUD_RATE_PROPERTY:
		g_value_set_int (value, settings_get_baudRate (self));
		break;
		case SETTINGS_DATA_BITS_PROPERTY:
		g_value_set_int (value, settings_get_dataBits (self));
		break;
		case SETTINGS_STOP_BITS_PROPERTY:
		g_value_set_int (value, settings_get_stopBits (self));
		break;
		case SETTINGS_PARITY_PROPERTY:
		g_value_set_enum (value, settings_get_parity (self));
		break;
		case SETTINGS_HANDSHAKE_PROPERTY:
		g_value_set_enum (value, settings_get_handshake (self));
		break;
		case SETTINGS_ACCESS_MODE_PROPERTY:
		g_value_set_enum (value, settings_get_accessMode (self));
		break;
		case SETTINGS_LOCAL_ECHO_PROPERTY:
		g_value_set_boolean (value, settings_get_localEcho (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS, Settings);
	switch (property_id) {
		case SETTINGS_DEVICE_PROPERTY:
		settings_set_device (self, g_value_get_string (value));
		break;
		case SETTINGS_BAUD_RATE_PROPERTY:
		settings_set_baudRate (self, g_value_get_int (value));
		break;
		case SETTINGS_DATA_BITS_PROPERTY:
		settings_set_dataBits (self, g_value_get_int (value));
		break;
		case SETTINGS_STOP_BITS_PROPERTY:
		settings_set_stopBits (self, g_value_get_int (value));
		break;
		case SETTINGS_PARITY_PROPERTY:
		settings_set_parity (self, g_value_get_enum (value));
		break;
		case SETTINGS_HANDSHAKE_PROPERTY:
		settings_set_handshake (self, g_value_get_enum (value));
		break;
		case SETTINGS_ACCESS_MODE_PROPERTY:
		settings_set_accessMode (self, g_value_get_enum (value));
		break;
		case SETTINGS_LOCAL_ECHO_PROPERTY:
		settings_set_localEcho (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



