/* +---------------------------------------------------------------------------+
   |                 The Mobile Robot Programming Toolkit (MRPT)               |
   |                                                                           |
   |                          http://www.mrpt.org/                             |
   |                                                                           |
   | Copyright (c) 2005-2013, Individual contributors, see AUTHORS file        |
   | Copyright (c) 2005-2013, MAPIR group, University of Malaga                |
   | Copyright (c) 2012-2013, University of Almeria                            |
   | All rights reserved.                                                      |
   |                                                                           |
   | Redistribution and use in source and binary forms, with or without        |
   | modification, are permitted provided that the following conditions are    |
   | met:                                                                      |
   |    * Redistributions of source code must retain the above copyright       |
   |      notice, this list of conditions and the following disclaimer.        |
   |    * Redistributions in binary form must reproduce the above copyright    |
   |      notice, this list of conditions and the following disclaimer in the  |
   |      documentation and/or other materials provided with the distribution. |
   |    * Neither the name of the copyright holders nor the                    |
   |      names of its contributors may be used to endorse or promote products |
   |      derived from this software without specific prior written permission.|
   |                                                                           |
   | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       |
   | 'AS IS' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED |
   | TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR|
   | PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE |
   | FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL|
   | DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR|
   |  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)       |
   | HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,       |
   | STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN  |
   | ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           |
   | POSSIBILITY OF SUCH DAMAGE.                                               |
   +---------------------------------------------------------------------------+ */

#ifndef _mrpt_math_H
#define _mrpt_math_H

#include <mrpt/math/distributions.h>
#include <mrpt/math/transform_gaussian.h>
#include <mrpt/math/fourier.h>
#include <mrpt/math/utils.h>
#include <mrpt/math/ops_vectors.h>
#include <mrpt/math/ops_matrices.h>
#include <mrpt/math/ops_containers.h>

#include <mrpt/math/CLevenbergMarquardt.h>
#include <mrpt/math/CQuaternion.h>
#include <mrpt/math/CQuaternion.h>
#include <mrpt/math/ransac.h>
#include <mrpt/math/ransac_applications.h>

#include <mrpt/math/CHistogram.h>
#include <mrpt/math/CMatrix.h>
#include <mrpt/math/CMatrixD.h>
#include <mrpt/math/CMatrixB.h>
#include <mrpt/math/CMatrixTemplateObjects.h>
#include <mrpt/math/CMatrixFixedNumeric.h>
#include <mrpt/math/CArray.h>

#include <mrpt/math/CPolygon.h>
#include <mrpt/math/geometry.h>

#include <mrpt/math/CSplineInterpolator1D.h>

#include <mrpt/math/lightweight_geom_data.h>
#include <mrpt/math/CSparseMatrixTemplate.h>
#include <mrpt/math/CSparseMatrix.h>
#include <mrpt/math/MatrixBlockSparseCols.h>

#include <mrpt/math/CBinaryRelation.h>
#include <mrpt/math/CMonteCarlo.h>
#include <mrpt/math/jacobians.h>

#include <mrpt/math/KDTreeCapable.h>
#include <mrpt/math/kmeans.h>
#include <mrpt/math/slerp.h>
#include <mrpt/math/model_search.h>

#endif
