/* $Id: TMgr_ClientInfo.cpp 498903 2016-04-20 15:50:10Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'trackmgr.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/trackmgr/TMgr_ClientInfo.hpp>

#include <vector>

#include <vector>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CTMgr_ClientInfo::~CTMgr_ClientInfo(void)
{
}

void CTMgr_ClientInfo::SetContext(const CTMgr_ClientInfo::TContext& value)
{
    // parse the context, if necessary
    typedef vector<string> TTokens;

    static const string major_delim("::");
    static const string minor_delim(":");

    TContext context = value;

    TTokens major_tokens;
    NStr::Split(value, major_delim, major_tokens, NStr::fSplit_ByPattern);
    bool is_context = true;

    ITERATE (TTokens, it, major_tokens) {
        if (is_context) {
            context = *it;
            CTMgr_ClientInfo_Base::SetContext(context);
            is_context = false;
        }
        else {
            string key, val;
            if (NStr::SplitInTwo(*it, minor_delim, key, val)) {
                CRef<CTMgr_AttrSpec> attr(new CTMgr_AttrSpec());
                attr->SetKey(key);
                attr->SetValue(val);
                SetContext_attrs().push_back(attr);
            }
        }
    }
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1744, CRC32: 67e32918 */
