/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public final class SingletonAtomizer
extends UnaryExpression {
    private boolean allowEmpty;
    private RoleLocator role;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public SingletonAtomizer(Expression sequence, RoleLocator role, boolean allowEmpty) {
        super(sequence);
        this.allowEmpty = allowEmpty;
        this.role = role;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal && ((Literal)this.operand).getValue() instanceof AtomicValue) {
            return this.operand;
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        visitor.resetStaticProperties();
        if (Literal.isEmptySequence(this.operand)) {
            if (!this.allowEmpty) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
            }
            return this.operand;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.operand.getItemType(th).isAtomicType()) {
            return this.operand;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (this.operand.getItemType(th).isAtomicType()) {
                return this.operand;
            }
            return this;
        }
        return exp;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new SingletonAtomizer(this.getBaseExpression().copy(), this.role, this.allowEmpty);
    }

    public RoleLocator getRole() {
        return this.role;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = this.operand.addToPathMap(pathMap, pathMapNodeSet);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item;
        int found = 0;
        Item result = null;
        SequenceIterator iter = this.operand.iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof AtomicValue) {
                if (found++ > 0) {
                    this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
                }
                result = item;
                continue;
            }
            if (item instanceof FunctionItem) {
                this.typeError("A function item cannot appear as the " + this.role.getMessage(), "FOTY0013", context);
                continue;
            }
            Value value = ((NodeInfo)item).atomize();
            if ((found += value.getLength()) > 1) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            }
            result = value.itemAt(0);
        }
        if (found == 0 && !this.allowEmpty) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
        }
        return result;
    }

    public ItemType getItemType(TypeHierarchy th) {
        boolean isSchemaAware;
        block10: {
            isSchemaAware = true;
            try {
                isSchemaAware = this.getExecutable().isSchemaAware();
            }
            catch (NullPointerException err) {
                if (th.getConfiguration().isLicensedFeature(1)) break block10;
                isSchemaAware = false;
            }
        }
        ItemType in = this.operand.getItemType(th);
        if (in.isAtomicType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            if (in instanceof EmptySequenceTest) {
                return in;
            }
            int kinds = ((NodeTest)in).getNodeKindMask();
            if (!isSchemaAware) {
                if ((kinds | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((kinds | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((kinds | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        if (this.allowEmpty) {
            return 24576;
        }
        return 16384;
    }

    protected String displayExpressionName() {
        return "atomizeSingleton";
    }
}

