### Before creating an issue, please try the following

- Are you on the latest version of ytdl-core?
  - To check, run `npm ls ytdl-core`
  - If you're using a bot or application that depends on ytdl-core, look at the bottom of the readme on how to update the library
  - Otherwise, if you're directly importing ytdl-core, to install the latest version, run `npm install ytdl-core@latest`
- Search the list of issues for a possible duplicate.
  - If there is a duplicate issue thread, but it's closed, only post in it if it's been active in the past month. Otherwise, creating a new issue thread is fine.
- If your question is about using the library for a specific use case, check out the [examples folder](https://github.com/fent/node-ytdl-core/tree/master/example).

### Otherwise, feel free to open an issue

Include the following if your issue is a bug

- If you're getting a specific error message, include the full stack trace
- If you're getting unexpected behavior without an error message
  - What should happen?
  - What happens instead?
- Include any relevant code around ytdl-core. You don't have to upload your entire program, small snippets are fine.
- If this error happens only on some videos, include a link or links to videos.
