/*
 * nsfDecls.h --
 *
 *	Declarations of functions in the platform independent public Nsf API.
 *
 *  This file is part of the Next Scripting Framework.
 *
 *  Copyright (C) 1999-2014 Gustaf Neumann (a, b)
 *  Copyright (C) 1999-2007 Uwe Zdun (a, b)
 * 
 * (a) University of Essen
 *     Specification of Software Systems
 *     Altendorferstrasse 97-101
 *     D-45143 Essen, Germany
 *
 * (b) Vienna University of Economics and Business
 *     Institute of Information Systems and New Media
 *     A-1020, Welthandelsplatz 1
 *     Vienna, Austria
 *
 * This work is licensed under the MIT License https://www.opensource.org/licenses/MIT
 *
 * Copyright:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef _NSFDECLS
#define _NSFDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the nsf.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Exported function declarations:
 */

#ifndef Nsf_Init_TCL_DECLARED
#define Nsf_Init_TCL_DECLARED
/* 0 */
EXTERN int		Nsf_Init(Tcl_Interp *interp);
#endif
/* Slot 1 is reserved */
#ifndef NsfIsClass_TCL_DECLARED
#define NsfIsClass_TCL_DECLARED
/* 2 */
EXTERN struct Nsf_Class * NsfIsClass(Tcl_Interp *interp, ClientData cd);
#endif
#ifndef NsfGetObject_TCL_DECLARED
#define NsfGetObject_TCL_DECLARED
/* 3 */
EXTERN struct Nsf_Object * NsfGetObject(Tcl_Interp *interp, CONST char *name);
#endif
#ifndef NsfGetClass_TCL_DECLARED
#define NsfGetClass_TCL_DECLARED
/* 4 */
EXTERN struct Nsf_Class * NsfGetClass(Tcl_Interp *interp, CONST char *name);
#endif
#ifndef NsfDeleteObject_TCL_DECLARED
#define NsfDeleteObject_TCL_DECLARED
/* 5 */
EXTERN int		NsfDeleteObject(Tcl_Interp *interp,
				struct Nsf_Object *object);
#endif
#ifndef NsfRemoveObjectMethod_TCL_DECLARED
#define NsfRemoveObjectMethod_TCL_DECLARED
/* 6 */
EXTERN int		NsfRemoveObjectMethod(Tcl_Interp *interp,
				struct Nsf_Object *object,
				CONST char *methodName);
#endif
#ifndef NsfRemoveClassMethod_TCL_DECLARED
#define NsfRemoveClassMethod_TCL_DECLARED
/* 7 */
EXTERN int		NsfRemoveClassMethod(Tcl_Interp *interp,
				struct Nsf_Class *class,
				CONST char *methodName);
#endif
#ifndef Nsf_ObjSetVar2_TCL_DECLARED
#define Nsf_ObjSetVar2_TCL_DECLARED
/* 8 */
EXTERN Tcl_Obj *	Nsf_ObjSetVar2(struct Nsf_Object *object,
				Tcl_Interp *interp, Tcl_Obj *name1,
				Tcl_Obj *name2, Tcl_Obj *valueObj,
				unsigned int flags);
#endif
#ifndef Nsf_ObjGetVar2_TCL_DECLARED
#define Nsf_ObjGetVar2_TCL_DECLARED
/* 9 */
EXTERN Tcl_Obj *	Nsf_ObjGetVar2(struct Nsf_Object *object,
				Tcl_Interp *interp, Tcl_Obj *name1,
				Tcl_Obj *name2, unsigned int flags);
#endif
#ifndef Nsf_UnsetVar2_TCL_DECLARED
#define Nsf_UnsetVar2_TCL_DECLARED
/* 10 */
EXTERN int		Nsf_UnsetVar2(struct Nsf_Object *object,
				Tcl_Interp *interp, CONST char *name1,
				CONST char *name2, unsigned int flags);
#endif
#ifndef NsfDStringVPrintf_TCL_DECLARED
#define NsfDStringVPrintf_TCL_DECLARED
/* 11 */
EXTERN void		NsfDStringVPrintf(Tcl_DString *dsPtr,
				CONST char *fmt, va_list argPtr);
#endif
#ifndef NsfPrintError_TCL_DECLARED
#define NsfPrintError_TCL_DECLARED
/* 12 */
EXTERN int		NsfPrintError(Tcl_Interp *interp, CONST char *fmt, ...);
#endif
#ifndef NsfErrInProc_TCL_DECLARED
#define NsfErrInProc_TCL_DECLARED
/* 13 */
EXTERN int		NsfErrInProc(Tcl_Interp *interp, Tcl_Obj *objName,
				Tcl_Obj *clName, CONST char *procName);
#endif
#ifndef NsfObjErrType_TCL_DECLARED
#define NsfObjErrType_TCL_DECLARED
/* 14 */
EXTERN int		NsfObjErrType(Tcl_Interp *interp,
				CONST char *context, Tcl_Obj *value,
				CONST char *type,
				Nsf_Param CONST *NsfObjErrType);
#endif
#ifndef NsfStackDump_TCL_DECLARED
#define NsfStackDump_TCL_DECLARED
/* 15 */
EXTERN void		NsfStackDump(Tcl_Interp *interp);
#endif
#ifndef NsfSetObjClientData_TCL_DECLARED
#define NsfSetObjClientData_TCL_DECLARED
/* 16 */
EXTERN void		NsfSetObjClientData(Tcl_Interp *interp,
				Nsf_Object *object, ClientData data);
#endif
#ifndef NsfGetObjClientData_TCL_DECLARED
#define NsfGetObjClientData_TCL_DECLARED
/* 17 */
EXTERN ClientData	NsfGetObjClientData(Tcl_Interp *interp,
				Nsf_Object *object);
#endif
#ifndef NsfSetClassClientData_TCL_DECLARED
#define NsfSetClassClientData_TCL_DECLARED
/* 18 */
EXTERN void		NsfSetClassClientData(Tcl_Interp *interp,
				Nsf_Class *cl, ClientData data);
#endif
#ifndef NsfGetClassClientData_TCL_DECLARED
#define NsfGetClassClientData_TCL_DECLARED
/* 19 */
EXTERN ClientData	NsfGetClassClientData(Tcl_Interp *interp,
				Nsf_Class *cl);
#endif
#ifndef NsfRequireObjNamespace_TCL_DECLARED
#define NsfRequireObjNamespace_TCL_DECLARED
/* 20 */
EXTERN void		NsfRequireObjNamespace(Tcl_Interp *interp,
				Nsf_Object *object);
#endif
#ifndef NsfCallMethodWithArgs_TCL_DECLARED
#define NsfCallMethodWithArgs_TCL_DECLARED
/* 21 */
EXTERN int		NsfCallMethodWithArgs(Tcl_Interp *interp,
				Nsf_Object *object, Tcl_Obj *methodObj,
				Tcl_Obj *arg1, int givenObjc,
				Tcl_Obj *CONST objv[], unsigned int flags);
#endif
#ifndef NsfAddObjectMethod_TCL_DECLARED
#define NsfAddObjectMethod_TCL_DECLARED
/* 22 */
EXTERN int		NsfAddObjectMethod(Tcl_Interp *interp,
				struct Nsf_Object *object,
				CONST char *methodName, Tcl_ObjCmdProc *proc,
				ClientData clientData, Tcl_CmdDeleteProc *dp,
				unsigned int flags);
#endif
#ifndef NsfAddClassMethod_TCL_DECLARED
#define NsfAddClassMethod_TCL_DECLARED
/* 23 */
EXTERN int		NsfAddClassMethod(Tcl_Interp *interp,
				struct Nsf_Class *class,
				CONST char *methodName, Tcl_ObjCmdProc *proc,
				ClientData clientData, Tcl_CmdDeleteProc *dp,
				unsigned int flags);
#endif
#ifndef NsfCreate_TCL_DECLARED
#define NsfCreate_TCL_DECLARED
/* 24 */
EXTERN int		NsfCreate(Tcl_Interp *interp, Nsf_Class *class,
				Tcl_Obj *nameObj, int objc,
				Tcl_Obj *CONST objv[]);
#endif
#ifndef Nsf_ArgumentParse_TCL_DECLARED
#define Nsf_ArgumentParse_TCL_DECLARED
/* 25 */
EXTERN int		Nsf_ArgumentParse(Tcl_Interp *interp, int objc,
				Tcl_Obj *CONST objv[], Nsf_Object *object,
				Tcl_Obj *procNameObj,
				Nsf_Param CONST *paramPtr, int nrParams,
				int serial, unsigned int processFlags,
				Nsf_ParseContext *pcPtr);
#endif
#ifndef NsfLog_TCL_DECLARED
#define NsfLog_TCL_DECLARED
/* 26 */
EXTERN void		NsfLog(Tcl_Interp *interp, int requiredLevel,
				CONST char *fmt, ...);
#endif
#ifndef Nsf_PointerAdd_TCL_DECLARED
#define Nsf_PointerAdd_TCL_DECLARED
/* 27 */
EXTERN int		Nsf_PointerAdd(Tcl_Interp *interp, char *buffer,
				size_t size, CONST char *typeName,
				VOID *valuePtr);
#endif
#ifndef Nsf_PointerDelete_TCL_DECLARED
#define Nsf_PointerDelete_TCL_DECLARED
/* 28 */
EXTERN int		Nsf_PointerDelete(CONST char *key, VOID *valuePtr,
				int free);
#endif
#ifndef Nsf_PointerTypeRegister_TCL_DECLARED
#define Nsf_PointerTypeRegister_TCL_DECLARED
/* 29 */
EXTERN int		Nsf_PointerTypeRegister(Tcl_Interp *interp,
				CONST char*typeName, int *counterPtr);
#endif
#ifndef Nsf_ConvertToBoolean_TCL_DECLARED
#define Nsf_ConvertToBoolean_TCL_DECLARED
/* 30 */
EXTERN int		Nsf_ConvertToBoolean(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToClass_TCL_DECLARED
#define Nsf_ConvertToClass_TCL_DECLARED
/* 31 */
EXTERN int		Nsf_ConvertToClass(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToInt32_TCL_DECLARED
#define Nsf_ConvertToInt32_TCL_DECLARED
/* 32 */
EXTERN int		Nsf_ConvertToInt32(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToInteger_TCL_DECLARED
#define Nsf_ConvertToInteger_TCL_DECLARED
/* 33 */
EXTERN int		Nsf_ConvertToInteger(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToObject_TCL_DECLARED
#define Nsf_ConvertToObject_TCL_DECLARED
/* 34 */
EXTERN int		Nsf_ConvertToObject(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToPointer_TCL_DECLARED
#define Nsf_ConvertToPointer_TCL_DECLARED
/* 35 */
EXTERN int		Nsf_ConvertToPointer(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToString_TCL_DECLARED
#define Nsf_ConvertToString_TCL_DECLARED
/* 36 */
EXTERN int		Nsf_ConvertToString(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_ConvertToTclobj_TCL_DECLARED
#define Nsf_ConvertToTclobj_TCL_DECLARED
/* 37 */
EXTERN int		Nsf_ConvertToTclobj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param CONST *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
#endif
#ifndef Nsf_EnumerationTypeRegister_TCL_DECLARED
#define Nsf_EnumerationTypeRegister_TCL_DECLARED
/* 38 */
EXTERN int		Nsf_EnumerationTypeRegister(Tcl_Interp *interp,
				Nsf_EnumeratorConverterEntry *typeRecords);
#endif
#ifndef Nsf_CmdDefinitionRegister_TCL_DECLARED
#define Nsf_CmdDefinitionRegister_TCL_DECLARED
/* 39 */
EXTERN int		Nsf_CmdDefinitionRegister(Tcl_Interp *interp,
				Nsf_methodDefinition *definitionRecords);
#endif
#ifndef NsfArgumentError_TCL_DECLARED
#define NsfArgumentError_TCL_DECLARED
/* 40 */
EXTERN int		NsfArgumentError(Tcl_Interp *interp,
				CONST char *errorMsg,
				Nsf_Param CONST *paramPtr,
				Tcl_Obj *cmdNameObj, Tcl_Obj *methodPathObj);
#endif
#ifndef Nsf_DStringPrintf_TCL_DECLARED
#define Nsf_DStringPrintf_TCL_DECLARED
/* 41 */
EXTERN void		Nsf_DStringPrintf(Tcl_DString *dsPtr,
				CONST char *fmt, ...);
#endif

typedef struct NsfStubHooks {
    struct NsfIntStubs *nsfIntStubs;
} NsfStubHooks;

typedef struct NsfStubs {
    int magic;
    struct NsfStubHooks *hooks;

    int (*nsf_Init) (Tcl_Interp *interp); /* 0 */
    VOID *reserved1;
    struct Nsf_Class * (*nsfIsClass) (Tcl_Interp *interp, ClientData cd); /* 2 */
    struct Nsf_Object * (*nsfGetObject) (Tcl_Interp *interp, CONST char *name); /* 3 */
    struct Nsf_Class * (*nsfGetClass) (Tcl_Interp *interp, CONST char *name); /* 4 */
    int (*nsfDeleteObject) (Tcl_Interp *interp, struct Nsf_Object *object); /* 5 */
    int (*nsfRemoveObjectMethod) (Tcl_Interp *interp, struct Nsf_Object *object, CONST char *methodName); /* 6 */
    int (*nsfRemoveClassMethod) (Tcl_Interp *interp, struct Nsf_Class *class, CONST char *methodName); /* 7 */
    Tcl_Obj * (*nsf_ObjSetVar2) (struct Nsf_Object *object, Tcl_Interp *interp, Tcl_Obj *name1, Tcl_Obj *name2, Tcl_Obj *valueObj, unsigned int flags); /* 8 */
    Tcl_Obj * (*nsf_ObjGetVar2) (struct Nsf_Object *object, Tcl_Interp *interp, Tcl_Obj *name1, Tcl_Obj *name2, unsigned int flags); /* 9 */
    int (*nsf_UnsetVar2) (struct Nsf_Object *object, Tcl_Interp *interp, CONST char *name1, CONST char *name2, unsigned int flags); /* 10 */
    void (*nsfDStringVPrintf) (Tcl_DString *dsPtr, CONST char *fmt, va_list argPtr); /* 11 */
    int (*nsfPrintError) (Tcl_Interp *interp, CONST char *fmt, ...); /* 12 */
    int (*nsfErrInProc) (Tcl_Interp *interp, Tcl_Obj *objName, Tcl_Obj *clName, CONST char *procName); /* 13 */
    int (*nsfObjErrType) (Tcl_Interp *interp, CONST char *context, Tcl_Obj *value, CONST char *type, Nsf_Param CONST *NsfObjErrType); /* 14 */
    void (*nsfStackDump) (Tcl_Interp *interp); /* 15 */
    void (*nsfSetObjClientData) (Tcl_Interp *interp, Nsf_Object *object, ClientData data); /* 16 */
    ClientData (*nsfGetObjClientData) (Tcl_Interp *interp, Nsf_Object *object); /* 17 */
    void (*nsfSetClassClientData) (Tcl_Interp *interp, Nsf_Class *cl, ClientData data); /* 18 */
    ClientData (*nsfGetClassClientData) (Tcl_Interp *interp, Nsf_Class *cl); /* 19 */
    void (*nsfRequireObjNamespace) (Tcl_Interp *interp, Nsf_Object *object); /* 20 */
    int (*nsfCallMethodWithArgs) (Tcl_Interp *interp, Nsf_Object *object, Tcl_Obj *methodObj, Tcl_Obj *arg1, int givenObjc, Tcl_Obj *CONST objv[], unsigned int flags); /* 21 */
    int (*nsfAddObjectMethod) (Tcl_Interp *interp, struct Nsf_Object *object, CONST char *methodName, Tcl_ObjCmdProc *proc, ClientData clientData, Tcl_CmdDeleteProc *dp, unsigned int flags); /* 22 */
    int (*nsfAddClassMethod) (Tcl_Interp *interp, struct Nsf_Class *class, CONST char *methodName, Tcl_ObjCmdProc *proc, ClientData clientData, Tcl_CmdDeleteProc *dp, unsigned int flags); /* 23 */
    int (*nsfCreate) (Tcl_Interp *interp, Nsf_Class *class, Tcl_Obj *nameObj, int objc, Tcl_Obj *CONST objv[]); /* 24 */
    int (*nsf_ArgumentParse) (Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], Nsf_Object *object, Tcl_Obj *procNameObj, Nsf_Param CONST *paramPtr, int nrParams, int serial, unsigned int processFlags, Nsf_ParseContext *pcPtr); /* 25 */
    void (*nsfLog) (Tcl_Interp *interp, int requiredLevel, CONST char *fmt, ...); /* 26 */
    int (*nsf_PointerAdd) (Tcl_Interp *interp, char *buffer, size_t size, CONST char *typeName, VOID *valuePtr); /* 27 */
    int (*nsf_PointerDelete) (CONST char *key, VOID *valuePtr, int free); /* 28 */
    int (*nsf_PointerTypeRegister) (Tcl_Interp *interp, CONST char*typeName, int *counterPtr); /* 29 */
    int (*nsf_ConvertToBoolean) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 30 */
    int (*nsf_ConvertToClass) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 31 */
    int (*nsf_ConvertToInt32) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 32 */
    int (*nsf_ConvertToInteger) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 33 */
    int (*nsf_ConvertToObject) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 34 */
    int (*nsf_ConvertToPointer) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 35 */
    int (*nsf_ConvertToString) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 36 */
    int (*nsf_ConvertToTclobj) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param CONST *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 37 */
    int (*nsf_EnumerationTypeRegister) (Tcl_Interp *interp, Nsf_EnumeratorConverterEntry *typeRecords); /* 38 */
    int (*nsf_CmdDefinitionRegister) (Tcl_Interp *interp, Nsf_methodDefinition *definitionRecords); /* 39 */
    int (*nsfArgumentError) (Tcl_Interp *interp, CONST char *errorMsg, Nsf_Param CONST *paramPtr, Tcl_Obj *cmdNameObj, Tcl_Obj *methodPathObj); /* 40 */
    void (*nsf_DStringPrintf) (Tcl_DString *dsPtr, CONST char *fmt, ...); /* 41 */
} NsfStubs;

extern NsfStubs *nsfStubsPtr;

#ifdef __cplusplus
}
#endif

#if defined(USE_NSF_STUBS) && !defined(USE_NSF_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef Nsf_Init
#define Nsf_Init \
	(nsfStubsPtr->nsf_Init) /* 0 */
#endif
/* Slot 1 is reserved */
#ifndef NsfIsClass
#define NsfIsClass \
	(nsfStubsPtr->nsfIsClass) /* 2 */
#endif
#ifndef NsfGetObject
#define NsfGetObject \
	(nsfStubsPtr->nsfGetObject) /* 3 */
#endif
#ifndef NsfGetClass
#define NsfGetClass \
	(nsfStubsPtr->nsfGetClass) /* 4 */
#endif
#ifndef NsfDeleteObject
#define NsfDeleteObject \
	(nsfStubsPtr->nsfDeleteObject) /* 5 */
#endif
#ifndef NsfRemoveObjectMethod
#define NsfRemoveObjectMethod \
	(nsfStubsPtr->nsfRemoveObjectMethod) /* 6 */
#endif
#ifndef NsfRemoveClassMethod
#define NsfRemoveClassMethod \
	(nsfStubsPtr->nsfRemoveClassMethod) /* 7 */
#endif
#ifndef Nsf_ObjSetVar2
#define Nsf_ObjSetVar2 \
	(nsfStubsPtr->nsf_ObjSetVar2) /* 8 */
#endif
#ifndef Nsf_ObjGetVar2
#define Nsf_ObjGetVar2 \
	(nsfStubsPtr->nsf_ObjGetVar2) /* 9 */
#endif
#ifndef Nsf_UnsetVar2
#define Nsf_UnsetVar2 \
	(nsfStubsPtr->nsf_UnsetVar2) /* 10 */
#endif
#ifndef NsfDStringVPrintf
#define NsfDStringVPrintf \
	(nsfStubsPtr->nsfDStringVPrintf) /* 11 */
#endif
#ifndef NsfPrintError
#define NsfPrintError \
	(nsfStubsPtr->nsfPrintError) /* 12 */
#endif
#ifndef NsfErrInProc
#define NsfErrInProc \
	(nsfStubsPtr->nsfErrInProc) /* 13 */
#endif
#ifndef NsfObjErrType
#define NsfObjErrType \
	(nsfStubsPtr->nsfObjErrType) /* 14 */
#endif
#ifndef NsfStackDump
#define NsfStackDump \
	(nsfStubsPtr->nsfStackDump) /* 15 */
#endif
#ifndef NsfSetObjClientData
#define NsfSetObjClientData \
	(nsfStubsPtr->nsfSetObjClientData) /* 16 */
#endif
#ifndef NsfGetObjClientData
#define NsfGetObjClientData \
	(nsfStubsPtr->nsfGetObjClientData) /* 17 */
#endif
#ifndef NsfSetClassClientData
#define NsfSetClassClientData \
	(nsfStubsPtr->nsfSetClassClientData) /* 18 */
#endif
#ifndef NsfGetClassClientData
#define NsfGetClassClientData \
	(nsfStubsPtr->nsfGetClassClientData) /* 19 */
#endif
#ifndef NsfRequireObjNamespace
#define NsfRequireObjNamespace \
	(nsfStubsPtr->nsfRequireObjNamespace) /* 20 */
#endif
#ifndef NsfCallMethodWithArgs
#define NsfCallMethodWithArgs \
	(nsfStubsPtr->nsfCallMethodWithArgs) /* 21 */
#endif
#ifndef NsfAddObjectMethod
#define NsfAddObjectMethod \
	(nsfStubsPtr->nsfAddObjectMethod) /* 22 */
#endif
#ifndef NsfAddClassMethod
#define NsfAddClassMethod \
	(nsfStubsPtr->nsfAddClassMethod) /* 23 */
#endif
#ifndef NsfCreate
#define NsfCreate \
	(nsfStubsPtr->nsfCreate) /* 24 */
#endif
#ifndef Nsf_ArgumentParse
#define Nsf_ArgumentParse \
	(nsfStubsPtr->nsf_ArgumentParse) /* 25 */
#endif
#ifndef NsfLog
#define NsfLog \
	(nsfStubsPtr->nsfLog) /* 26 */
#endif
#ifndef Nsf_PointerAdd
#define Nsf_PointerAdd \
	(nsfStubsPtr->nsf_PointerAdd) /* 27 */
#endif
#ifndef Nsf_PointerDelete
#define Nsf_PointerDelete \
	(nsfStubsPtr->nsf_PointerDelete) /* 28 */
#endif
#ifndef Nsf_PointerTypeRegister
#define Nsf_PointerTypeRegister \
	(nsfStubsPtr->nsf_PointerTypeRegister) /* 29 */
#endif
#ifndef Nsf_ConvertToBoolean
#define Nsf_ConvertToBoolean \
	(nsfStubsPtr->nsf_ConvertToBoolean) /* 30 */
#endif
#ifndef Nsf_ConvertToClass
#define Nsf_ConvertToClass \
	(nsfStubsPtr->nsf_ConvertToClass) /* 31 */
#endif
#ifndef Nsf_ConvertToInt32
#define Nsf_ConvertToInt32 \
	(nsfStubsPtr->nsf_ConvertToInt32) /* 32 */
#endif
#ifndef Nsf_ConvertToInteger
#define Nsf_ConvertToInteger \
	(nsfStubsPtr->nsf_ConvertToInteger) /* 33 */
#endif
#ifndef Nsf_ConvertToObject
#define Nsf_ConvertToObject \
	(nsfStubsPtr->nsf_ConvertToObject) /* 34 */
#endif
#ifndef Nsf_ConvertToPointer
#define Nsf_ConvertToPointer \
	(nsfStubsPtr->nsf_ConvertToPointer) /* 35 */
#endif
#ifndef Nsf_ConvertToString
#define Nsf_ConvertToString \
	(nsfStubsPtr->nsf_ConvertToString) /* 36 */
#endif
#ifndef Nsf_ConvertToTclobj
#define Nsf_ConvertToTclobj \
	(nsfStubsPtr->nsf_ConvertToTclobj) /* 37 */
#endif
#ifndef Nsf_EnumerationTypeRegister
#define Nsf_EnumerationTypeRegister \
	(nsfStubsPtr->nsf_EnumerationTypeRegister) /* 38 */
#endif
#ifndef Nsf_CmdDefinitionRegister
#define Nsf_CmdDefinitionRegister \
	(nsfStubsPtr->nsf_CmdDefinitionRegister) /* 39 */
#endif
#ifndef NsfArgumentError
#define NsfArgumentError \
	(nsfStubsPtr->nsfArgumentError) /* 40 */
#endif
#ifndef Nsf_DStringPrintf
#define Nsf_DStringPrintf \
	(nsfStubsPtr->nsf_DStringPrintf) /* 41 */
#endif

#endif /* defined(USE_NSF_STUBS) && !defined(USE_NSF_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _NSFDECLS */

