// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepFeat_SplitShape_HeaderFile
#define _BRepFeat_SplitShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _LocOpe_Spliter_HeaderFile
#include <LocOpe_Spliter.hxx>
#endif
#ifndef _Handle_LocOpe_WiresOnShape_HeaderFile
#include <Handle_LocOpe_WiresOnShape.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class LocOpe_WiresOnShape;
class StdFail_NotDone;
class Standard_ConstructionError;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopoDS_Wire;
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Compound;
class TopTools_ListOfShape;


//! One of the most significant aspects of BRepFeat functionality is the use of local <br>
//! operations as opposed to global ones. In a global operation, you would first construct a <br>
//! form of the type you wanted in your final feature, and then remove matter so that it could <br>
//! fit into your initial basis object. In a local operation, however, you specify the domain of <br>
//! the feature construction with aspects of the shape on which the feature is being created. <br>
//! These semantics are expressed in terms of a member shape of the basis shape from which - <br>
//! or up to which - matter will be added or removed. As a result, local operations make <br>
//! calculations simpler and faster than global operations. <br>
//! In BRepFeat, the semantics of local operations define features constructed from a contour or a <br>
//! part of the basis shape referred to as the tool. In a SplitShape object, wires or edges of a <br>
//! face in the basis shape to be used as a part of the feature are cut out and projected to a plane <br>
//! outside or inside the basis shape. By rebuilding the initial shape incorporating the edges and <br>
//! the faces of the tool, protrusion or depression features can be constructed. <br>
class BRepFeat_SplitShape  : public BRepBuilderAPI_MakeShape {
public:

  DEFINE_STANDARD_ALLOC

  //! Empty constructor <br>
      BRepFeat_SplitShape();
  //! Creates the process  with the shape <S>. <br>
      BRepFeat_SplitShape(const TopoDS_Shape& S);
  //! Initializes the process on the shape <S>. <br>
        void Init(const TopoDS_Shape& S) ;
  //! Set the flag of check internal intersections <br>
//!          default value is True (to check) <br>
        void SetCheckInterior(const Standard_Boolean ToCheckInterior) ;
  //! Adds the wire <W> on the face <F>. <br>
//! Raises NoSuchObject  if <F> does not belong to the original shape. <br>
        void Add(const TopoDS_Wire& W,const TopoDS_Face& F) ;
  //! Adds the edge <E> on the face <F>. <br>
        void Add(const TopoDS_Edge& E,const TopoDS_Face& F) ;
  //! Adds the compound <Comp> on the face <F>. The <br>
//!          compound <Comp> must consist of edges lying on the <br>
//!          face <F>. If edges are geometrically connected, <br>
//!          they must be connected topologically, i.e. they <br>
//!          must share common vertices. <br>
//! <br>
//! Raises NoSuchObject  if <F> does not belong to the original shape. <br>
        void Add(const TopoDS_Compound& Comp,const TopoDS_Face& F) ;
  //! Adds the edge <E> on the existing edge <EOn>. <br>
        void Add(const TopoDS_Edge& E,const TopoDS_Edge& EOn) ;
  //! Returns  the faces   which  are the  left of   the <br>
//!          projected wires. <br>
  Standard_EXPORT    const TopTools_ListOfShape& DirectLeft() const;
  //! Returns the faces of the "left" part on the shape. <br>
//!          (It  is build   from  DirectLeft,  with  the faces <br>
//!          connected to this set, and so on...). <br>
//! Raises NotDone if IsDone returns <Standard_False>. <br>
  Standard_EXPORT    const TopTools_ListOfShape& Left() const;
  //! Builds the cut and the resulting faces and edges as well. <br>
  Standard_EXPORT     void Build() ;
  //! Returns true if the shape has been deleted. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsDeleted(const TopoDS_Shape& S) ;
  //! Returns the list of generated Faces. <br>
  Standard_EXPORT    const TopTools_ListOfShape& Modified(const TopoDS_Shape& F) ;





protected:





private:



LocOpe_Spliter mySShape;
Handle_LocOpe_WiresOnShape myWOnShape;


};


#include <BRepFeat_SplitShape.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
