// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GccAna_Lin2d2Tan_HeaderFile
#define _GccAna_Lin2d2Tan_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColgp_Array1OfLin2d_HeaderFile
#include <TColgp_Array1OfLin2d.hxx>
#endif
#ifndef _GccEnt_Array1OfPosition_HeaderFile
#include <GccEnt_Array1OfPosition.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
class Standard_OutOfRange;
class GccEnt_BadQualifier;
class StdFail_NotDone;
class gp_Pnt2d;
class GccEnt_QualifiedCirc;
class gp_Lin2d;


//! This class implements the algorithms used to <br>
//!          create 2d lines tangent to 2 other elements which <br>
//!          can be circles or points. <br>
//!          Describes functions for building a 2D line: <br>
//!          -   tangential to 2 circles, or <br>
//!          -   tangential to a circle and passing through a point, or <br>
//!          -   passing through 2 points. <br>
//!          A Lin2d2Tan object provides a framework for: <br>
//!          -   defining the construction of 2D line(s), <br>
//!          -   implementing the construction algorithm, and <br>
//!          consulting the result(s). <br>
//!          Some constructors may check the type of the qualified argument <br>
//!          and raise BadQualifier Error in case of incorrect couple (qualifier, <br>
//!          curv). <br>
//!          For example: "EnclosedCirc". <br>
class GccAna_Lin2d2Tan  {
public:

  DEFINE_STANDARD_ALLOC

  //! This methods implements the algorithms used to <br>
//!          create 2d lines passing thrue 2 points. <br>
//!          Tolerance is used because we can't create a line <br>
//!          when the distance between the two points is too small. <br>
  Standard_EXPORT   GccAna_Lin2d2Tan(const gp_Pnt2d& ThePoint1,const gp_Pnt2d& ThePoint2,const Standard_Real Tolerance);
  //! This methods implements the algorithms used to <br>
//!          create 2d lines tangent to one circle and passing <br>
//!          thrue a point. <br>
//!          Exception BadQualifier is raised in the case of <br>
//!          EnclosedCirc <br>
//!          Tolerance is used because there is no solution <br>
//!          when the point is inside the solution according to <br>
//!          the tolerance. <br>
  Standard_EXPORT   GccAna_Lin2d2Tan(const GccEnt_QualifiedCirc& Qualified1,const gp_Pnt2d& ThePoint,const Standard_Real Tolerance);
  //! This methods implements the algorithms used to <br>
//!          create 2d lines tangent to 2 circles. <br>
//!          Exception BadQualifier is raised in the case of <br>
//!          EnclosedCirc <br>
  Standard_EXPORT   GccAna_Lin2d2Tan(const GccEnt_QualifiedCirc& Qualified1,const GccEnt_QualifiedCirc& Qualified2,const Standard_Real Tolerance);
  //! This method returns true when there is a solution <br>
//!          and false in the other cases. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! This method returns the number of solutions. <br>
//!          Raises NotDone if the construction algorithm didn't succeed. <br>
  Standard_EXPORT     Standard_Integer NbSolutions() const;
  //! Returns the solution number Index and raises OutOfRange <br>
//!           exception if Index is greater than the number of solutions. <br>
//!           Be carefull: the Index is only a way to get all the <br>
//!           solutions, but is not associated to theses outside the <br>
//!           context of the algorithm-object. Raises OutOfRange is raised if Index is greater than <br>
//!           the number of solutions. <br>
//!           It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     gp_Lin2d ThisSolution(const Standard_Integer Index) const;
  //! Returns the qualifiers Qualif1 and Qualif2 of the <br>
//! tangency arguments for the solution of index Index <br>
//! computed by this algorithm. <br>
//! The returned qualifiers are: <br>
//! -   those specified at the start of construction when the <br>
//!   solutions are defined as enclosing or outside with <br>
//!   respect to the arguments, or <br>
//! -   those computed during construction (i.e. enclosing or <br>
//!   outside) when the solutions are defined as unqualified <br>
//!   with respect to the arguments, or <br>
//! -   GccEnt_noqualifier if the tangency argument is a point. <br>
//!  Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     void WhichQualifier(const Standard_Integer Index,GccEnt_Position& Qualif1,GccEnt_Position& Qualif2) const;
  //! Returns informations about the tangency point between the <br>
//!           result number Index and the first argument. <br>
//!           ParSol is the intrinsic parameter of the point PntSol on <br>
//!           the solution curv. <br>
//!           ParArg is the intrinsic parameter of the point PntSol on <br>
//!           the argument curv. Raises OutOfRange is raised if Index is greater than <br>
//!           the number of solutions. <br>
//!           It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     void Tangency1(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns informations about the tangency point between the <br>
//!           result number Index and the second argument. <br>
//!           ParSol is the intrinsic parameter of the point ParSol on <br>
//!           the solution curv. <br>
//!           ParArg is the intrinsic parameter of the point PntSol on <br>
//!           the argument curv. Raises OutOfRange is raised if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the algorithm failed. <br>
  Standard_EXPORT     void Tangency2(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;





protected:





private:



Standard_Boolean WellDone;
Standard_Integer NbrSol;
TColgp_Array1OfLin2d linsol;
GccEnt_Array1OfPosition qualifier1;
GccEnt_Array1OfPosition qualifier2;
TColgp_Array1OfPnt2d pnttg1sol;
TColgp_Array1OfPnt2d pnttg2sol;
TColStd_Array1OfReal par1sol;
TColStd_Array1OfReal par2sol;
TColStd_Array1OfReal pararg1;
TColStd_Array1OfReal pararg2;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
