MACRO(PARSE_ARGUMENTS LIST_VARS BOOLEAN_VARS DEFAULT_VAR)
    SET(CURRENT_VAR ${DEFAULT_VAR})
    FOREACH (arg ${ARGN})
        SET(skip_this_arg FALSE)
        FOREACH(var ${LIST_VARS})
            IF (${arg} STREQUAL ${var})
                SET(CURRENT_VAR ${var})
                SET(skip_this_arg TRUE)
                BREAK()
            ENDIF()
        ENDFOREACH ()
        IF (NOT skip_this_arg)
            SET(skip_this_arg FALSE)
            FOREACH(var ${BOOLEAN_VARS})
                IF (${arg} STREQUAL ${var})
                    SET(${var} TRUE)
                    SET(skip_this_arg TRUE)
                    BREAK()
                ENDIF()
            ENDFOREACH()
            IF (NOT skip_this_arg)
                SET(${CURRENT_VAR} ${${CURRENT_VAR}} ${arg})
            ENDIF()
        ENDIF()
    ENDFOREACH ()
ENDMACRO()

FUNCTION(NEW_EXECUTABLE EXECUTABLE)
    PARSE_ARGUMENTS("SOURCES;LIBRARIES" "EXCLUDE_FROM_ALL" "DEFAULT" ${ARGN})
    SET(SOURCES ${DEFAULT} ${SOURCES})
    IF (EXCLUDE_FROM_ALL)
        SET(EXCLUDE_FROM_ALL EXCLUDE_FROM_ALL)
    ENDIF()
    ADD_EXECUTABLE(${EXECUTABLE} ${EXCLUDE_FROM_ALL} ${SOURCES})
    TARGET_LINK_LIBRARIES(${EXECUTABLE} ${LIBRARIES})
ENDFUNCTION()
