///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMS2TACHYON_H
#define __ATOMS2TACHYON_H

#include <core/Core.h>
#include <tachyon/renderer/TachyonExportInterface.h>

#include <atomviz/atoms/AtomsObject.h>

namespace AtomViz {

/******************************************************************************
* Exports an AtomsObject to Tachyon scene description format.
******************************************************************************/
class ATOMVIZ_DLLEXPORT Atoms2TachyonExportInterface : public TachyonExportInterface
{
public:
	/// The default constructor.
	Atoms2TachyonExportInterface() : TachyonExportInterface() {}

	/// Exports the given scene object in the Tachyon format and returns true.
	/// Return false if the scene object type is not supported by this interface class.
	/// Throws an exception if an error occurred.
	virtual bool exportSceneObject(SceneObject* sceneObj, TachyonWriter& writer, ObjectNode* contextNode, const AffineTransformation& objToWorldTM);

private:
	Q_OBJECT
	DECLARE_PLUGIN_CLASS(Atoms2TachyonExportInterface)
};

};	// End of namespace AtomViz

#endif // __ATOMS2TACHYON_H
