///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/viewport/Viewport.h>
#include <core/scene/ObjectNode.h>
#include "TargetObject.h"

namespace StdObjects {

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(TargetObject, SceneObject)

/******************************************************************************
* Makes the object render itself into the viewport. 
******************************************************************************/
void TargetObject::renderObject(TimeTicks time, ObjectNode* contextNode, Viewport* vp)
{
	if(contextNode->isSelected()) 
		vp->setRenderingColor(Viewport::getVPColor(Viewport::COLOR_SELECTION));
	else		
		vp->setRenderingColor(contextNode->displayColor());
	
	vp->renderMarker(Window3D::MARKER_BOX, ORIGIN);
}

};

