// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                         avtOpenFOAMOptions.C                              //
// ************************************************************************* //

#include <avtOpenFOAMOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>


// ****************************************************************************
//  Function: GetOpenFOAMReadOptions
//
//  Purpose:
//      Creates the options for OpenFOAM readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue May 21 11:07:32 PDT 2013
//
// ****************************************************************************

DBOptionsAttributes *
GetOpenFOAMReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetEnum("Case Type", 1);
    std::vector<std::string> caseType;
    caseType.push_back("Decomposed");
    caseType.push_back("Reconstructed");
    rv->SetEnumStrings("Case Type", caseType);
    rv->SetBool("Convert Cell Data To Point Data", false);
    rv->SetBool("Read Zones", false);
#if 0
    rv->SetBool("Positions in 1.3 Format", false);
#endif
    return rv;
}


// ****************************************************************************
//  Function: GetOpenFOAMWriteOptions
//
//  Purpose:
//      Creates the options for OpenFOAM writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue May 21 11:07:32 PDT 2013
//
// ****************************************************************************

DBOptionsAttributes *
GetOpenFOAMWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
