/*	Procedures_Table

PIRL CVS ID: Procedures_Table.java,v 1.6 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package PIRL.Conductor;

import	org.jdesktop.swingx.JXTable;

import	javax.swing.JTable;
import	javax.swing.ListSelectionModel;
import	javax.swing.table.TableCellRenderer;
import	javax.swing.JLabel;
import	javax.swing.BorderFactory;
import	java.awt.Component;
import	java.awt.Color;
import	java.awt.Font;
import	java.util.Vector;


/**	A <i>Procedures_Table</i> is a table view of a Procedures_Table_Model.
<p>
	@author	Bradford Castalia, UA/HiROC
	@version 1.6
*/
public class Procedures_Table
	extends JXTable
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor.Procedures_Table (1.6 2012/04/16 06:04:10)";


private Font
	Emphasis_Font;


//  DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTOR	= 1 << 0,
	DEBUG_ACCESSORS		= 1 << 1,
	DEBUG_RENDERER		= 1 << 2,
	DEBUG_ALL			= -1,

	DEBUG				= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
public Procedures_Table
	(
	Procedures_Table_Model	table_model
	)
{
super (table_model);

setColumnSelectionAllowed (true);
setRowSelectionAllowed (false);
getColumnModel ().getSelectionModel ()
	.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
addMouseListener (new Table_Mouse_Listener ());
setBackground (Colors.TABLE);
getTableHeader ().setBackground (Colors.TABLE_HEADER);
Emphasis_Font = getFont ().deriveFont (Font.BOLD);
/*
	WARNING: These are JXTable specific methods.
*/
setColumnControlVisible (true);
setSortable (false);

setDefaultRenderer (String.class, new Procedures_Table_Cell_Renderer ());
}

/*==============================================================================
	Accessors
*/

/*	If not provided by the base class.
public int convertRowIndexToModel
	(
	int		view_row
	)
{return view_row;}
*/

/*==============================================================================
	Procedures_Table_Cell_Renderer
*/
private class Procedures_Table_Cell_Renderer
	extends JLabel
	implements TableCellRenderer
{
public Procedures_Table_Cell_Renderer ()
{
setOpaque (true);
setBorder (BorderFactory.createEmptyBorder (0, 5, 0, 0));
}


public Component getTableCellRendererComponent
	(
	JTable	table,
	Object	value,
	boolean	selected,
	boolean	focused,
	int		row,
	int		column
	)
{
if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		(">>> Procedures_Table_Cell_Renderer: "
			+ row + '/' + ((JXTable)table).convertRowIndexToModel (row) + ','
			+ column + '/' + table.convertColumnIndexToModel (column) + ' '
			+ value);
row = ((JXTable)table).convertRowIndexToModel (row);
Procedures_Table_Model
	model = (Procedures_Table_Model)table.getModel ();
Vector
	record = (Vector)model.Record (row);
Color
	color = table.getBackground ();

if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		("    Current_Row: " + model.Current_Row);
if (row <= model.Current_Row)
	{
	//	Processed record.
	setFont (Emphasis_Font);
	if (row == model.Current_Row)
		color = Colors.CURRENT_RECORD;
	else
		color = Colors.PROCESSED_RECORD;
	}
else
	setFont (table.getFont ());

if (selected)
	{
	if (color.getRed () > 200 &&
		color.getGreen () > 200 &&
		color.getBlue () > 200)
		color = color.darker ();
	else
		color = color.brighter ();
	}
setBackground (color);
setValue (value);
if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		("<<< Procedures_Table_Cell_Renderer");
return this;
}


public void setValue
	(
	Object	value
	)
{setText ((value == null) ? "" : value.toString ());}

}	//	Procedures_Table_Cell_Renderer


}
