# -*- coding: utf-8 -*-
"""This file contains the Windows NT Language identifiers."""

LANGUAGE_IDENTIFIERS = {
    u'af': [0x0036, u'Afrikaans'],
    u'af-ZA': [0x0436, u'Afrikaans, South Africa'],
    u'am': [0x005e, u'Amharic'],
    u'am-ET': [0x045e, u'Amharic, Ethiopia'],
    u'ar': [0x0001, u'Arabic'],
    u'ar-AE': [0x3801, u'Arabic, United Arab Emirates'],
    u'ar-BH': [0x3c01, u'Arabic, Bahrain'],
    u'ar-DZ': [0x1401, u'Arabic, Algeria'],
    u'ar-EG': [0x0c01, u'Arabic, Egypt'],
    u'ar-IQ': [0x0801, u'Arabic, Iraq'],
    u'ar-JO': [0x2c01, u'Arabic, Jordan'],
    u'ar-KW': [0x3401, u'Arabic, Kuwait'],
    u'ar-LB': [0x3001, u'Arabic, Lebanon'],
    u'ar-LY': [0x1001, u'Arabic, Libyan Arab Jamahiriya'],
    u'ar-MA': [0x1801, u'Arabic, Morocco'],
    u'arn': [0x007a, u'Mapudungun'],
    u'arn-CL': [0x047a, u'Mapudungun, Chile'],
    u'ar-OM': [0x2001, u'Arabic, Oman'],
    u'ar-QA': [0x4001, u'Arabic, Qatar'],
    u'ar-SA': [0x0401, u'Arabic, Saudi Arabia'],
    u'ar-SY': [0x2801, u'Arabic, Syrian Arab Republic'],
    u'ar-TN': [0x1c01, u'Arabic, Tunisia'],
    u'ar-YE': [0x2401, u'Arabic, Yemen'],
    u'as': [0x004d, u'Assamese'],
    u'as-IN': [0x044d, u'Assamese, India'],
    u'az': [0x002c, u'Azerbaijani'],
    u'az-Cyrl': [0x742c, u'Azerbaijani, Cyrillic'],
    u'az-Cyrl-AZ': [0x082c, u'Azerbaijani, Cyrillic, Azerbaijan'],
    u'az-Latn': [0x782c, u'Azerbaijani, Latin'],
    u'az-Latn-AZ': [0x042c, u'Azerbaijani, Latin, Azerbaijan'],
    u'ba': [0x006d, u'Bashkir'],
    u'ba-RU': [0x046d, u'Bashkir, Russian Federation'],
    u'be': [0x0023, u'Belarusian'],
    u'be-BY': [0x0423, u'Belarusian, Belarus'],
    u'bg': [0x0002, u'Bulgarian'],
    u'bg-BG': [0x0402, u'Bulgarian, Bulgaria'],
    u'bin-NG': [0x0466, u'Bini, Nigeria'],
    u'bn': [0x0045, u'Bengali'],
    u'bn-BD': [0x0845, u'Bengali, Bangladesh'],
    u'bn-IN': [0x0445, u'Bengali, India'],
    u'bo': [0x0051, u'Tibetan'],
    u'bo-BT': [0x0851, u'Tibetan, Bhutan'],
    u'bo-CN': [0x0451, u'Tibetan, China'],
    u'br': [0x007e, u'Breton'],
    u'br-FR': [0x047e, u'Breton, France'],
    u'bs': [0x781a, u'Bosnian'],
    u'bs-Cyrl': [0x641a, u'Bosnian, Cyrillic'],
    u'bs-Cyrl-BA': [0x201a, u'Bosnian, Cyrillic, Bosnia and Herzegovina'],
    u'bs-Latn': [0x681a, u'Bosnian, Latin'],
    u'bs-Latn-BA': [0x141a, u'Bosnian, Latin, Bosnia and Herzegovina'],
    u'ca': [0x0003, u'Catalan'],
    u'ca-ES': [0x0403, u'Catalan, Spain'],
    u'chr-US': [0x045c, u'Cherokee, United States'],
    u'co': [0x0083, u'Corsican'],
    u'co-FR': [0x0483, u'Corsican, France'],
    u'cs': [0x0005, u'Czech'],
    u'cs-CZ': [0x0405, u'Czech, Czech Republic'],
    u'cy': [0x0052, u'Welsh'],
    u'cy-GB': [0x0452, u'Welsh, United Kingdom'],
    u'da': [0x0006, u'Danish'],
    u'da-DK': [0x0406, u'Danish, Denmark'],
    u'de': [0x0007, u'German'],
    u'de-AT': [0x0c07, u'German, Austria'],
    u'de-CH': [0x0807, u'German, Switzerland'],
    u'de-DE': [0x0407, u'German, Germany'],
    u'de-LI': [0x1407, u'German, Liechtenstein'],
    u'de-LU': [0x1007, u'German, Luxembourg'],
    u'dsb': [0x7c2e, u'Lower Sorbian'],
    u'dsb-DE': [0x082e, u'Lower Sorbian, Germany'],
    u'dv': [0x0065, u'Dhivehi'],
    u'dv-MV': [0x0465, u'Dhivehi, Maldives'],
    u'el': [0x0008, u'Modern Greek (1453 and later)'],
    u'el-GR': [0x0408, u'Modern Greek (1453-), Greece'],
    u'en': [0x0009, u'English'],
    u'en-AU': [0x0c09, u'English, Australia'],
    u'en-BZ': [0x2809, u'English, Belize'],
    u'en-CA': [0x1009, u'English, Canada'],
    u'en-CB': [0x2409, u'English'],
    u'en-GB': [0x0809, u'English, United Kingdom'],
    u'en-HK': [0x3c09, u'English, Hong Kong'],
    u'en-ID': [0x3809, u'English, Indonesia'],
    u'en-IE': [0x1809, u'English, Ireland'],
    u'en-IN': [0x4009, u'English, India'],
    u'en-JM': [0x2009, u'English, Jamaica'],
    u'en-MY': [0x4409, u'English, Malaysia'],
    u'en-NZ': [0x1409, u'English, New Zealand'],
    u'en-PH': [0x3409, u'English, Philippines'],
    u'en-SG': [0x4809, u'English, Singapore'],
    u'en-TT': [0x2c09, u'English, Trinidad and Tobago'],
    u'en-US': [0x0409, u'English, United States'],
    u'en-ZA': [0x1c09, u'English, South Africa'],
    u'en-ZW': [0x3009, u'English, Zimbabwe'],
    u'es': [0x000a, u'Spanish'],
    u'es-AR': [0x2c0a, u'Spanish, Argentina'],
    u'es-BO': [0x400a, u'Spanish, Bolivia'],
    u'es-CL': [0x340a, u'Spanish, Chile'],
    u'es-CO': [0x240a, u'Spanish, Colombia'],
    u'es-CR': [0x140a, u'Spanish, Costa Rica'],
    u'es-DO': [0x1c0a, u'Spanish, Dominican Republic'],
    u'es-EC': [0x300a, u'Spanish, Ecuador'],
    u'es-ES': [0x0c0a, u'Spanish, Spain'],
    u'es-ES_tradnl': [0x040a, u'Spanish'],
    u'es-GT': [0x100a, u'Spanish, Guatemala'],
    u'es-HN': [0x480a, u'Spanish, Honduras'],
    u'es-MX': [0x080a, u'Spanish, Mexico'],
    u'es-NI': [0x4c0a, u'Spanish, Nicaragua'],
    u'es-PA': [0x180a, u'Spanish, Panama'],
    u'es-PE': [0x280a, u'Spanish, Peru'],
    u'es-PR': [0x500a, u'Spanish, Puerto Rico'],
    u'es-PY': [0x3c0a, u'Spanish, Paraguay'],
    u'es-SV': [0x440a, u'Spanish, El Salvador'],
    u'es-US': [0x540a, u'Spanish, United States'],
    u'es-UY': [0x380a, u'Spanish, Uruguay'],
    u'es-VE': [0x200a, u'Spanish, Venezuela'],
    u'et': [0x0025, u'Estonian'],
    u'et-EE': [0x0425, u'Estonian, Estonia'],
    u'eu': [0x002d, u'Basque'],
    u'eu-ES': [0x042d, u'Basque, Spain'],
    u'fa': [0x0029, u'Persian'],
    u'fa-IR': [0x0429, u'Persian, Islamic Republic of Iran'],
    u'fi': [0x000b, u'Finnish'],
    u'fi-FI': [0x040b, u'Finnish, Finland'],
    u'fil': [0x0064, u'Filipino'],
    u'fil-PH': [0x0464, u'Filipino, Philippines'],
    u'fo': [0x0038, u'Faroese'],
    u'fo-FO': [0x0438, u'Faroese, Faroe Islands'],
    u'fr': [0x000c, u'French'],
    u'fr-BE': [0x080c, u'French, Belgium'],
    u'fr-CA': [0x0c0c, u'French, Canada'],
    u'fr-CG': [0x240c, u'French, Congo'],
    u'fr-CH': [0x100c, u'French, Switzerland'],
    u'fr-CI': [0x300c, u'French, Côte d\'Ivoire'],
    u'fr-CM': [0x2c0c, u'French, Cameroon'],
    u'fr-FR': [0x040c, u'French, France'],
    u'fr-HT': [0x3c0c, u'French, Haiti'],
    u'fr-LU': [0x140c, u'French, Luxembourg'],
    u'fr-MA': [0x380c, u'French, Morocco'],
    u'fr-MC': [0x180c, u'French, Monaco'],
    u'fr-ML': [0x340c, u'French, Mali'],
    u'fr-RE': [0x200c, u'French, Réunion'],
    u'fr-SN': [0x280c, u'French, Senegal'],
    u'fr-West': [0x1c0c, u'French'],
    u'fuv-NG': [0x0467, u'Nigerian Fulfulde, Nigeria'],
    u'fy': [0x0062, u'Western Frisian'],
    u'fy-NL': [0x0462, u'Western Frisian, Netherlands'],
    u'ga': [0x003c, u'Irish'],
    u'ga-IE': [0x083c, u'Irish, Ireland'],
    u'gaz-ET': [0x0472, u'West Central Oromo, Ethiopia'],
    u'gd': [0x0091, u'Scottish Gaelic'],
    u'gd-GB': [0x0491, u'Scottish Gaelic, United Kingdom'],
    u'gl': [0x0056, u'Galician'],
    u'gl-ES': [0x0456, u'Galician, Spain'],
    u'gn-PY': [0x0474, u'Guarani, Paraguay'],
    u'gsw': [0x0084, u'Swiss German'],
    u'gsw-FR': [0x0484, u'Swiss German, France'],
    u'gu': [0x0047, u'Gujarati'],
    u'gu-IN': [0x0447, u'Gujarati, India'],
    u'ha': [0x0068, u'Hausa'],
    u'ha-Latn': [0x7c68, u'Hausa, Latin'],
    u'ha-Latn-NG': [0x0468, u'Hausa, Latin, Nigeria'],
    u'haw-US': [0x0475, u'Hawaiian, United States'],
    u'he': [0x000d, u'Hebrew'],
    u'he-IL': [0x040d, u'Hebrew, Israel'],
    u'hi': [0x0039, u'Hindi'],
    u'hi-IN': [0x0439, u'Hindi, India'],
    u'hr': [0x001a, u'Croatian'],
    u'hr-BA': [0x101a, u'Croatian, Bosnia and Herzegovina'],
    u'hr-HR': [0x041a, u'Croatian, Croatia'],
    u'hsb': [0x002e, u'Upper Sorbian'],
    u'hu': [0x000e, u'Hungarian'],
    u'hu-HU': [0x040e, u'Hungarian, Hungary'],
    u'hy': [0x002b, u'Armenian'],
    u'hy-AM': [0x042b, u'Armenian, Armenia'],
    u'ibb-NG': [0x0469, u'Ibibio, Nigeria'],
    u'id': [0x0021, u'Indonesian'],
    u'id-ID': [0x0421, u'Indonesian, Indonesia'],
    u'ig': [0x0070, u'Igbo'],
    u'ig-NG': [0x0470, u'Igbo, Nigeria'],
    u'ii': [0x0078, u'Sichuan Yi'],
    u'ii-CN': [0x0478, u'Sichuan Yi, China'],
    u'is': [0x000f, u'Icelandic'],
    u'is-IS': [0x040f, u'Icelandic, Iceland'],
    u'it': [0x0010, u'Italian'],
    u'it-CH': [0x0810, u'Italian, Switzerland'],
    u'it-IT': [0x0410, u'Italian, Italy'],
    u'iu': [0x005d, u'Inuktitut'],
    u'iu-Cans': [0x785d, u'Inuktitut, Unified Canadian Aboriginal Syllabics'],
    u'iu-Cans-CA': [
        0x045d, 'Inuktitut, Unified Canadian Aboriginal Syllabics, Canada'],
    u'iu-Latn': [0x7c5d, u'Inuktitut, Latin'],
    u'iu-Latn-CA': [0x085d, u'Inuktitut, Latin, Canada'],
    u'ja': [0x0011, u'Japanese'],
    u'ja-JP': [0x0411, u'Japanese, Japan'],
    u'ka': [0x0037, u'Georgian'],
    u'ka-GE': [0x0437, u'Georgian, Georgia'],
    u'kk': [0x003f, u'Kazakh'],
    u'kk-KZ': [0x043f, u'Kazakh, Kazakhstan'],
    u'kl': [0x006f, u'Kalaallisut'],
    u'kl-GL': [0x046f, u'Kalaallisut, Greenland'],
    u'km': [0x0053, u'Central Khmer'],
    u'km-KH': [0x0453, u'Central Khmer, Cambodia'],
    u'kn': [0x004b, u'Kannada'],
    u'kn-IN': [0x044b, u'Kannada, India'],
    u'ko': [0x0012, u'Korean'],
    u'kok': [0x0057, u'Konkani (macrolanguage)'],
    u'kok-IN': [0x0457, u'Konkani (macrolanguage), India'],
    u'ko-KR': [0x0412, u'Korean, Republic of Korea'],
    u'kr-NG': [0x0471, u'Kanuri, Nigeria'],
    u'ky': [0x0040, u'Kirghiz'],
    u'ky-KG': [0x0440, u'Kirghiz, Kyrgyzstan'],
    u'lb': [0x006e, u'Luxembourgish'],
    u'lb-LU': [0x046e, u'Luxembourgish, Luxembourg'],
    u'lo': [0x0054, u'Lao'],
    u'lo-LA': [0x0454, u'Lao, Lao People\'s Democratic Republic'],
    u'lt': [0x0027, u'Lithuanian'],
    u'lt-LT': [0x0427, u'Lithuanian, Lithuania'],
    u'lv': [0x0026, u'Latvian'],
    u'lv-LV': [0x0426, u'Latvian, Latvia'],
    u'mi': [0x0081, u'Maori'],
    u'mi-NZ': [0x0481, u'Maori, New Zealand'],
    u'mk': [0x002f, u'Macedonian'],
    u'mk-MK': [
        0x042f, u'Macedonian, The Former Yugoslav Republic of Macedonia'],
    u'ml': [0x004c, u'Malayalam'],
    u'ml-IN': [0x044c, u'Malayalam, India'],
    u'mn': [0x0050, u'Mongolian'],
    u'mn-Cyrl': [0x7850, u'Mongolian, Cyrillic'],
    u'mni': [0x0458, u'Manipuri'],
    u'mn-MN': [0x0450, u'Mongolian, Mongolia'],
    u'mn-Mong': [0x7c50, u'Mongolian, Mongolian'],
    u'mn-Mong-CN': [0x0850, u'Mongolian, Mongolian, China'],
    u'moh': [0x007c, u'Mohawk'],
    u'moh-CA': [0x047c, u'Mohawk, Canada'],
    u'mr': [0x004e, u'Marathi'],
    u'mr-IN': [0x044e, u'Marathi, India'],
    u'ms': [0x003e, u'Malay (macrolanguage)'],
    u'ms-BN': [0x083e, u'Malay (macrolanguage), Brunei Darussalam'],
    u'ms-MY': [0x043e, u'Malay (macrolanguage), Malaysia'],
    u'mt': [0x003a, u'Maltese'],
    u'mt-MT': [0x043a, u'Maltese, Malta'],
    u'my-MM': [0x0455, u'Burmese, Myanmar'],
    u'nb': [0x7c14, u'Norwegian Bokmål'],
    u'nb-NO': [0x0414, u'Norwegian Bokmål, Norway'],
    u'ne': [0x0061, u'Nepali'],
    u'ne-IN': [0x0861, u'Nepali, India'],
    u'ne-NP': [0x0461, u'Nepali, Nepal'],
    u'nl': [0x0013, u'Dutch'],
    u'nl-BE': [0x0813, u'Dutch, Belgium'],
    u'nl-NL': [0x0413, u'Dutch, Netherlands'],
    u'nn': [0x7814, u'Norwegian Nynorsk'],
    u'nn-NO': [0x0814, u'Norwegian Nynorsk, Norway'],
    u'no': [0x0014, u'Norwegian'],
    u'nso': [0x006c, u'Pedi'],
    u'nso-ZA': [0x046c, u'Pedi, South Africa'],
    u'oc': [0x0082, u'Occitan (post 1500)'],
    u'oc-FR': [0x0482, u'Occitan (post 1500), France'],
    u'or': [0x0048, u'Oriya'],
    u'or-IN': [0x0448, u'Oriya, India'],
    u'pa': [0x0046, u'Panjabi'],
    u'pa-IN': [0x0446, u'Panjabi, India'],
    u'pap-AN': [0x0479, u'Papiamento, Netherlands Antilles'],
    u'pa-PK': [0x0846, u'Panjabi, Pakistan'],
    u'pl': [0x0015, u'Polish'],
    u'pl-PL': [0x0415, u'Polish, Poland'],
    u'plt-MG': [0x048d, u'Plateau Malagasy, Madagascar'],
    u'prs': [0x008c, u'Dari'],
    u'prs-AF': [0x048c, u'Dari, Afghanistan'],
    u'ps': [0x0063, u'Pushto'],
    u'ps-AF': [0x0463, u'Pushto, Afghanistan'],
    u'pt': [0x0016, u'Portuguese'],
    u'pt-BR': [0x0416, u'Portuguese, Brazil'],
    u'pt-PT': [0x0816, u'Portuguese, Portugal'],
    u'qut': [0x0086, u'Guatemala'],
    u'qut-GT': [0x0486, u'Guatemala'],
    u'quz': [0x006b, u'Cusco Quechua'],
    u'quz-BO': [0x046b, u'Cusco Quechua, Bolivia'],
    u'quz-EC': [0x086b, u'Cusco Quechua, Ecuador'],
    u'quz-PE': [0x0c6b, u'Cusco Quechua, Peru'],
    u'rm': [0x0017, u'Romansh'],
    u'rm-CH': [0x0417, u'Romansh, Switzerland'],
    u'ro': [0x0018, u'Romanian'],
    u'ro-MO': [0x0818, u'Romanian, Macao'],
    u'ro-RO': [0x0418, u'Romanian, Romania'],
    u'ru': [0x0019, u'Russian'],
    u'ru-MO': [0x0819, u'Russian, Macao'],
    u'ru-RU': [0x0419, u'Russian, Russian Federation'],
    u'rw': [0x0087, u'Kinyarwanda'],
    u'rw-RW': [0x0487, u'Kinyarwanda, Rwanda'],
    u'sa': [0x004f, u'Sanskrit'],
    u'sah': [0x0085, u'Yakut'],
    u'sah-RU': [0x0485, u'Yakut, Russian Federation'],
    u'sa-IN': [0x044f, u'Sanskrit, India'],
    u'sd-IN': [0x0459, u'Sindhi, India'],
    u'sd-PK': [0x0859, u'Sindhi, Pakistan'],
    u'se': [0x003b, u'Northern Sami'],
    u'se-FI': [0x0c3b, u'Northern Sami, Finland'],
    u'se-NO': [0x043b, u'Northern Sami, Norway'],
    u'se-SE': [0x083b, u'Northern Sami, Sweden'],
    u'si': [0x005b, u'Sinhala'],
    u'si-LK': [0x045b, u'Sinhala, Sri Lanka'],
    u'sk': [0x001b, u'Slovak'],
    u'sk-SK': [0x041b, u'Slovak, Slovakia'],
    u'sl': [0x0024, u'Slovenian'],
    u'sl-SI': [0x0424, u'Slovenian, Slovenia'],
    u'sma': [0x783b, u'Southern Sami'],
    u'sma-NO': [0x183b, u'Southern Sami, Norway'],
    u'sma-SE': [0x1c3b, u'Southern Sami, Sweden'],
    u'smj': [0x7c3b, u'Lule Sami'],
    u'smj-NO': [0x103b, u'Lule Sami, Norway'],
    u'smj-SE': [0x143b, u'Lule Sami, Sweden'],
    u'smn': [0x703b, u'Inari Sami'],
    u'smn-FI': [0x243b, u'Inari Sami, Finland'],
    u'sms': [0x743b, u'Skolt Sami'],
    u'sms-FI': [0x203b, u'Skolt Sami, Finland'],
    u'so-SO': [0x0477, u'Somali, Somalia'],
    u'sq': [0x001c, u'Albanian'],
    u'sq-AL': [0x041c, u'Albanian, Albania'],
    u'sr': [0x7c1a, u'Serbian'],
    u'sr-Cyrl': [0x6c1a, u'Serbian, Cyrillic'],
    u'sr-Cyrl-BA': [0x1c1a, u'Serbian, Cyrillic, Bosnia and Herzegovina'],
    u'sr-Cyrl-CS': [0x0c1a, u'Serbian, Cyrillic, Serbia and Montenegro'],
    u'sr-Cyrl-ME': [0x301a, u'Serbian, Cyrillic, Montenegro'],
    u'sr-Cyrl-RS': [0x281a, u'Serbian, Cyrillic, Serbia'],
    u'sr-Latn': [0x701a, u'Serbian, Latin'],
    u'sr-Latn-BA': [0x181a, u'Serbian, Latin, Bosnia and Herzegovina'],
    u'sr-Latn-CS': [0x081a, u'Serbian, Latin, Serbia and Montenegro'],
    u'sr-Latn-ME': [0x2c1a, u'Serbian, Latin, Montenegro'],
    u'sr-Latn-RS': [0x241a, u'Serbian, Latin, Serbia'],
    u'st-ZA': [0x0430, u'Southern Sotho, South Africa'],
    u'sv': [0x001d, u'Swedish'],
    u'sv-FI': [0x081d, u'Swedish, Finland'],
    u'sv-SE': [0x041d, u'Swedish, Sweden'],
    u'sw': [0x0041, u'Swahili (macrolanguage)'],
    u'sw-KE': [0x0441, u'Swahili (macrolanguage), Kenya'],
    u'syr': [0x005a, u'Syriac'],
    u'syr-SY': [0x045a, u'Syriac, Syrian Arab Republic'],
    u'ta': [0x0049, u'Tamil'],
    u'ta-IN': [0x0449, u'Tamil, India'],
    u'te': [0x004a, u'Telugu'],
    u'te-IN': [0x044a, u'Telugu, India'],
    u'tg': [0x0028, u'Tajik'],
    u'tg-Cyrl': [0x7c28, u'Tajik, Cyrillic'],
    u'tg-Cyrl-TJ': [0x0428, u'Tajik, Cyrillic, Tajikistan'],
    u'th': [0x001e, u'Thai'],
    u'th-TH': [0x041e, u'Thai, Thailand'],
    u'ti-ER': [0x0473, u'Tigrinya, Eritrea'],
    u'ti-ET': [0x0873, u'Tigrinya, Ethiopia'],
    u'tk': [0x0042, u'Turkmen'],
    u'tk-TM': [0x0442, u'Turkmen, Turkmenistan'],
    u'tmz': [0x045f, u'Tamanaku'],
    u'tmz-MA': [0x0c5f, u'Tamanaku, Morocco'],
    u'tn': [0x0032, u'Tswana'],
    u'tn-ZA': [0x0432, u'Tswana, South Africa'],
    u'tr': [0x001f, u'Turkish'],
    u'tr-TR': [0x041f, u'Turkish, Turkey'],
    u'ts-ZA': [0x0431, u'Tsonga, South Africa'],
    u'tt': [0x0044, u'Tatar'],
    u'tt-RU': [0x0444, u'Tatar, Russian Federation'],
    u'tzm': [0x005f, u'Central Atlas Tamazight'],
    u'tzm-Latn': [0x7c5f, u'Central Atlas Tamazight, Latin'],
    u'tzm-Latn-DZ': [0x085f, u'Central Atlas Tamazight, Latin, Algeria'],
    u'ug': [0x0080, u'Uighur'],
    u'ug-CN': [0x0480, u'Uighur, China'],
    u'uk': [0x0022, u'Ukrainian'],
    u'uk-UA': [0x0422, u'Ukrainian, Ukraine'],
    u'ur': [0x0020, u'Urdu'],
    u'ur-IN': [0x0820, u'Urdu, India'],
    u'ur-PK': [0x0420, u'Urdu, Pakistan'],
    u'uz': [0x0043, u'Uzbek'],
    u'uz-Cyrl': [0x7843, u'Uzbek, Cyrillic'],
    u'uz-Cyrl-UZ': [0x0843, u'Uzbek, Cyrillic, Uzbekistan'],
    u'uz-Latn': [0x7c43, u'Uzbek, Latin'],
    u'uz-Latn-UZ': [0x0443, u'Uzbek, Latin, Uzbekistan'],
    u'ven-ZA': [0x0433, u'South Africa'],
    u'vi': [0x002a, u'Vietnamese'],
    u'vi-VN': [0x042a, u'Vietnamese, Viet Nam'],
    u'wen-DE': [0x042e, u'Sorbian languages, Germany'],
    u'wo': [0x0088, u'Wolof'],
    u'wo-SN': [0x0488, u'Wolof, Senegal'],
    u'xh': [0x0034, u'Xhosa'],
    u'xh-ZA': [0x0434, u'Xhosa, South Africa'],
    u'yo': [0x006a, u'Yoruba'],
    u'yo-NG': [0x046a, u'Yoruba, Nigeria'],
    u'zh': [0x7804, u'Chinese'],
    u'zh-CN': [0x0804, u'Chinese, China'],
    u'zh-Hans': [0x0004, u'Chinese, Han (Simplified variant)'],
    u'zh-Hant': [0x7c04, u'Chinese, Han (Traditional variant)'],
    u'zh-HK': [0x0c04, u'Chinese, Hong Kong'],
    u'zh-MO': [0x1404, u'Chinese, Macao'],
    u'zh-SG': [0x1004, u'Chinese, Singapore'],
    u'zh-TW': [0x0404, u'Chinese, Taiwan, Province of China'],
    u'zu': [0x0035, u'Zulu'],
    u'zu-ZA': [0x0435, u'Zulu, South Africa'],
}

# Make sure the language identifiers are lower case.
LANGUAGE_IDENTIFIERS = dict(
    (key.lower(), value) for key, value in LANGUAGE_IDENTIFIERS.items())
