#!/usr/bin/python3
# -*- coding: utf-8 -*-

#  Copyright © 2012-2013  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os
import unicodedata


symbols = [
    #('ATOM SYMBOL',         'DejaVu-Sans-Oblique',  300, '+0+3'),
    ('ATOM SYMBOL',         'FreeSerif-Mittel',     256, '+0-6'),
    #('BEAMED EIGHTH NOTES', 'DejaVu-Sans-Oblique',  256, '+0-6'),
    ('BEAMED EIGHTH NOTES', 'FreeSerif-Mittel',     256, '+0+16'),
    ('BLACK SMILING FACE',  'DejaVu-Sans-Oblique',  256, '-1+5'),
    ('PEACE SYMBOL',        'DejaVu-Sans-Oblique',  300, '-2+5'),
    ('SHAMROCK',            'DejaVu-Sans-Oblique',  300, '-1+5'),
    ('SKULL AND CROSSBONES','DejaVu-Sans-Oblique',  300, '-1+5'),
    #('SKULL AND CROSSBONES','FreeSerif-Mittel',     300, '+0+0'),
    #('SNOWFLAKE',           'DejaVu-Sans-Oblique',  300, '-1+5'),
    ('SNOWFLAKE',           'FreeSerif-Mittel',     320, '+0+14'),
    ('WHITE SMILING FACE',  'DejaVu-Sans-Oblique',  256, '-1+5'),
    #('WHITE SUN WITH RAYS', 'DejaVu-Sans-Oblique',  300, '+0+4'),
    ('WHITE SUN WITH RAYS', 'FreeMono-Standard',    390, '+0+0'),
    ('YIN YANG',            'DejaVu-Sans-Oblique',  300, '-2+5'),
    #'FOUR LEAF CLOVER',
    #'ANTICLOCKWISE GAPPED CIRCLE ARROW',
    #'CLOCKWISE GAPPED CIRCLE ARROW',
]


path = 'data/ui/images'

def main():
    for name, font, size, pos in symbols:
        c = unicodedata.lookup(name)
        os.system('convert -size 256x256 null: -alpha transparent -font {} -pointsize {} -gravity center'
                  ' -annotate 0x0{} {} "{}/{}.png"'
                  .format(font, size, pos, c, path, name)
                  .encode('utf-8'))
    
    
if __name__ == '__main__':
    main()
    

